# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.178.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.default_bid_status import DefaultBidStatus

class DefaultBid(BaseModel):
    """
    DefaultBid
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    auction_product_type: AuctionProductType = Field(..., alias="auctionProductType")
    delivery_period_start: datetime = Field(..., alias="deliveryPeriodStart", description="The first moment (inclusive) of an MTU period  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute MTU start point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format - only with `XX:00:00`, `XX:15:00`, `XX:30:00` and `XX:45:00` time parts are valid values (depending on MTU size) ")
    delivery_period_end: Optional[datetime] = Field(None, alias="deliveryPeriodEnd", description="The last moment (exclusive) of an MTU period  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute MTU start point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format - only with `XX:00:00`, `XX:15:00`, `XX:30:00` and `XX:45:00` time parts are valid values (depending on MTU size) ")
    validity_period_start: datetime = Field(..., alias="validityPeriodStart", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    validity_period_end: Optional[datetime] = Field(None, alias="validityPeriodEnd", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    border_direction: BorderDirection = Field(..., alias="borderDirection")
    status: DefaultBidStatus = Field(...)
    __properties = ["id", "auctionProductType", "deliveryPeriodStart", "deliveryPeriodEnd", "validityPeriodStart", "validityPeriodEnd", "borderDirection", "status"]

    # @validator('delivery_period_start')
    def delivery_period_start_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$", value):
            raise ValueError(r"must validate the regular expression /^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$/")
        return value

    # @validator('delivery_period_end')
    def delivery_period_end_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$", value):
            raise ValueError(r"must validate the regular expression /^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DefaultBid:
        """Create an instance of DefaultBid from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DefaultBid:
        """Create an instance of DefaultBid from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DefaultBid.parse_obj(obj)

        _obj = DefaultBid.parse_obj({
            "id": obj.get("id"),
            "auction_product_type": obj.get("auctionProductType"),
            "delivery_period_start": obj.get("deliveryPeriodStart"),
            "delivery_period_end": obj.get("deliveryPeriodEnd"),
            "validity_period_start": obj.get("validityPeriodStart"),
            "validity_period_end": obj.get("validityPeriodEnd"),
            "border_direction": obj.get("borderDirection"),
            "status": obj.get("status")
        })
        return _obj

