# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.178.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt

class DayAheadOrIntraDayAuctionMtu(BaseModel):
    """
    MTU values for DA / ID auctions  * `atc` - ATC (Available Transfer Capacity) for the given MTU in kilowatts * `preliminaryOc` - The OC that was initially reserved at the auction creation - not including any un nominated capacity in the LT nomination window from participants in kilowatts * `unNominatedCapacity` - The un nominated capacity for this auction from the LT nomination window. This can be put up either as UIoSI or UIoLI and returned in kilowatts * `finalOc` - The final OC of the auction taking into account the preliminary OC and the un-nominated capacity in kilowatts 
    """
    mtu: datetime = Field(..., description="The first moment (inclusive) of an MTU period  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute MTU start point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format - only with `XX:00:00`, `XX:15:00`, `XX:30:00` and `XX:45:00` time parts are valid values (depending on MTU size) ")
    atc: Optional[StrictInt] = Field(None, description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    preliminary_oc: Optional[StrictInt] = Field(None, alias="preliminaryOc", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    un_nominated_capacity: Optional[StrictInt] = Field(None, alias="unNominatedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    final_oc: Optional[StrictInt] = Field(None, alias="finalOc", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    __properties = ["mtu", "atc", "preliminaryOc", "unNominatedCapacity", "finalOc"]

    # @validator('mtu')
    def mtu_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$", value):
            raise ValueError(r"must validate the regular expression /^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DayAheadOrIntraDayAuctionMtu:
        """Create an instance of DayAheadOrIntraDayAuctionMtu from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DayAheadOrIntraDayAuctionMtu:
        """Create an instance of DayAheadOrIntraDayAuctionMtu from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DayAheadOrIntraDayAuctionMtu.parse_obj(obj)

        _obj = DayAheadOrIntraDayAuctionMtu.parse_obj({
            "mtu": obj.get("mtu"),
            "atc": obj.get("atc"),
            "preliminary_oc": obj.get("preliminaryOc"),
            "un_nominated_capacity": obj.get("unNominatedCapacity"),
            "final_oc": obj.get("finalOc")
        })
        return _obj

