# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.178.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictInt, StrictStr, confloat, conint, constr, validator

class CreateSecondaryMarketLongTermNoticeboardResponse(BaseModel):
    """
    CreateSecondaryMarketLongTermNoticeboardResponse
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    response_capacity: StrictInt = Field(..., alias="responseCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    response_price: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="responsePrice", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    contact_name: StrictStr = Field(..., alias="contactName")
    phone_number: constr(strict=True) = Field(..., alias="phoneNumber")
    email: constr(strict=True) = Field(...)
    comment: Optional[StrictStr] = None
    __properties = ["id", "responseCapacity", "responsePrice", "contactName", "phoneNumber", "email", "comment"]

    # @validator('phone_number')
    def phone_number_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\+\d{10,13}$", value):
            raise ValueError(r"must validate the regular expression /^\+\d{10,13}$/")
        return value

    # @validator('email')
    def email_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[\w-\.]+@([\w-]+\.)+[\w-]{2,6}$", value):
            raise ValueError(r"must validate the regular expression /^[\w-\.]+@([\w-]+\.)+[\w-]{2,6}$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateSecondaryMarketLongTermNoticeboardResponse:
        """Create an instance of CreateSecondaryMarketLongTermNoticeboardResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateSecondaryMarketLongTermNoticeboardResponse:
        """Create an instance of CreateSecondaryMarketLongTermNoticeboardResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateSecondaryMarketLongTermNoticeboardResponse.parse_obj(obj)

        _obj = CreateSecondaryMarketLongTermNoticeboardResponse.parse_obj({
            "id": obj.get("id"),
            "response_capacity": obj.get("responseCapacity"),
            "response_price": obj.get("responsePrice"),
            "contact_name": obj.get("contactName"),
            "phone_number": obj.get("phoneNumber"),
            "email": obj.get("email"),
            "comment": obj.get("comment")
        })
        return _obj

