# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.178.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field
from empire_platform_api_public_client.models.bidding_configuration_per_direction import BiddingConfigurationPerDirection
from empire_platform_api_public_client.models.border_direction import BorderDirection

class BiddingConfigurationValuesInner(BaseModel):
    """
    BiddingConfigurationValuesInner
    """
    direction: BorderDirection = Field(...)
    configuration: BiddingConfigurationPerDirection = Field(...)
    __properties = ["direction", "configuration"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BiddingConfigurationValuesInner:
        """Create an instance of BiddingConfigurationValuesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of configuration
        if self.configuration:
            _dict['configuration'] = self.configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BiddingConfigurationValuesInner:
        """Create an instance of BiddingConfigurationValuesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BiddingConfigurationValuesInner.parse_obj(obj)

        _obj = BiddingConfigurationValuesInner.parse_obj({
            "direction": obj.get("direction"),
            "configuration": BiddingConfigurationPerDirection.from_dict(obj.get("configuration")) if obj.get("configuration") is not None else None
        })
        return _obj

