# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.178.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, conlist

from typing import List

from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.participant_dashboard_default_bids_and_nominations_data import ParticipantDashboardDefaultBidsAndNominationsData
from empire_platform_api_public_client.models.participant_dashboard_finance_overview_data import ParticipantDashboardFinanceOverviewData
from empire_platform_api_public_client.models.participant_dashboard_interconnector_capacity_data import ParticipantDashboardInterconnectorCapacityData
from empire_platform_api_public_client.models.participant_dashboard_interconnector_capacity_graph_data import ParticipantDashboardInterconnectorCapacityGraphData
from empire_platform_api_public_client.models.participant_dashboard_messages import ParticipantDashboardMessages
from empire_platform_api_public_client.models.participant_dashboard_netted_nominations_data import ParticipantDashboardNettedNominationsData
from empire_platform_api_public_client.models.participant_dashboard_next_auction import ParticipantDashboardNextAuction
from empire_platform_api_public_client.models.participant_dashboard_next_auctions_and_nomination_gates import ParticipantDashboardNextAuctionsAndNominationGates
from empire_platform_api_public_client.models.participant_dashboard_transmission_rights_and_nominations_data import ParticipantDashboardTransmissionRightsAndNominationsData
from empire_platform_api_public_client.models.participant_dashboard_transmission_rights_and_nominations_graph_data import ParticipantDashboardTransmissionRightsAndNominationsGraphData

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ParticipantDashboardApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_participant_dashboard_default_bids_and_nominations(self, **kwargs) -> ParticipantDashboardDefaultBidsAndNominationsData:  # noqa: E501
        """get_participant_dashboard_default_bids_and_nominations  # noqa: E501

        Fetches information if Default Bids & Nominations exists for the Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_default_bids_and_nominations(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ParticipantDashboardDefaultBidsAndNominationsData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_dashboard_default_bids_and_nominations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_dashboard_default_bids_and_nominations_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_dashboard_default_bids_and_nominations_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_dashboard_default_bids_and_nominations  # noqa: E501

        Fetches information if Default Bids & Nominations exists for the Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_default_bids_and_nominations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ParticipantDashboardDefaultBidsAndNominationsData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_dashboard_default_bids_and_nominations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "ParticipantDashboardDefaultBidsAndNominationsData",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/participant-dashboard/default-bids-and-nominations', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_participant_dashboard_finance_overview(self, **kwargs) -> ParticipantDashboardFinanceOverviewData:  # noqa: E501
        """get_participant_dashboard_finance_overview  # noqa: E501

        Fetch Finance Overview of the current Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_finance_overview(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ParticipantDashboardFinanceOverviewData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_dashboard_finance_overview_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_dashboard_finance_overview_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_dashboard_finance_overview_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_dashboard_finance_overview  # noqa: E501

        Fetch Finance Overview of the current Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_finance_overview_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ParticipantDashboardFinanceOverviewData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_dashboard_finance_overview" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "ParticipantDashboardFinanceOverviewData",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/participant-dashboard/finance-overview', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_participant_dashboard_interconnector_capacity(self, delivery_day : date, **kwargs) -> ParticipantDashboardInterconnectorCapacityData:  # noqa: E501
        """get_participant_dashboard_interconnector_capacity  # noqa: E501

        Fetch Interconnector Capacity information  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_interconnector_capacity(delivery_day, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ParticipantDashboardInterconnectorCapacityData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_dashboard_interconnector_capacity_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_dashboard_interconnector_capacity_with_http_info(delivery_day, **kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_dashboard_interconnector_capacity_with_http_info(self, delivery_day : date, **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_dashboard_interconnector_capacity  # noqa: E501

        Fetch Interconnector Capacity information  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_interconnector_capacity_with_http_info(delivery_day, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ParticipantDashboardInterconnectorCapacityData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_dashboard_interconnector_capacity" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "ParticipantDashboardInterconnectorCapacityData",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/participant-dashboard/interconnector-capacity', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_participant_dashboard_interconnector_capacity_graph(self, delivery_day_from : date, delivery_day_to : date, **kwargs) -> ParticipantDashboardInterconnectorCapacityGraphData:  # noqa: E501
        """get_participant_dashboard_interconnector_capacity_graph  # noqa: E501

        Fetch data for tne Interconnector Capacity Graph  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_interconnector_capacity_graph(delivery_day_from, delivery_day_to, async_req=True)
        >>> result = thread.get()

        :param delivery_day_from: (required)
        :type delivery_day_from: date
        :param delivery_day_to: (required)
        :type delivery_day_to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ParticipantDashboardInterconnectorCapacityGraphData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_dashboard_interconnector_capacity_graph_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_dashboard_interconnector_capacity_graph_with_http_info(delivery_day_from, delivery_day_to, **kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_dashboard_interconnector_capacity_graph_with_http_info(self, delivery_day_from : date, delivery_day_to : date, **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_dashboard_interconnector_capacity_graph  # noqa: E501

        Fetch data for tne Interconnector Capacity Graph  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_interconnector_capacity_graph_with_http_info(delivery_day_from, delivery_day_to, async_req=True)
        >>> result = thread.get()

        :param delivery_day_from: (required)
        :type delivery_day_from: date
        :param delivery_day_to: (required)
        :type delivery_day_to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ParticipantDashboardInterconnectorCapacityGraphData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day_from',
            'delivery_day_to'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_dashboard_interconnector_capacity_graph" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day_from') is not None:  # noqa: E501
            if isinstance(_params['delivery_day_from'], datetime):
                _query_params.append(('deliveryDayFrom', _params['delivery_day_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDayFrom', _params['delivery_day_from']))

        if _params.get('delivery_day_to') is not None:  # noqa: E501
            if isinstance(_params['delivery_day_to'], datetime):
                _query_params.append(('deliveryDayTo', _params['delivery_day_to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDayTo', _params['delivery_day_to']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "ParticipantDashboardInterconnectorCapacityGraphData",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/participant-dashboard/interconnector-capacity-graph', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_participant_dashboard_messages(self, **kwargs) -> ParticipantDashboardMessages:  # noqa: E501
        """get_participant_dashboard_messages  # noqa: E501

        Fetch the latest 3 messages from the General System Messages and the Participant Inbox  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_messages(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ParticipantDashboardMessages
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_dashboard_messages_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_dashboard_messages_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_dashboard_messages_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_dashboard_messages  # noqa: E501

        Fetch the latest 3 messages from the General System Messages and the Participant Inbox  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_messages_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ParticipantDashboardMessages, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_dashboard_messages" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "ParticipantDashboardMessages",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/participant-dashboard/messages', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_participant_dashboard_netted_nominations(self, delivery_day : date, timescales : Annotated[conlist(AuctionTimescale), Field(..., description="List of Auction Timescales")], **kwargs) -> ParticipantDashboardNettedNominationsData:  # noqa: E501
        """get_participant_dashboard_netted_nominations  # noqa: E501

        Fetch Netted Nominations for a given delivery day, aggregating arbitrary Timescales  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_netted_nominations(delivery_day, timescales, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ParticipantDashboardNettedNominationsData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_dashboard_netted_nominations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_dashboard_netted_nominations_with_http_info(delivery_day, timescales, **kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_dashboard_netted_nominations_with_http_info(self, delivery_day : date, timescales : Annotated[conlist(AuctionTimescale), Field(..., description="List of Auction Timescales")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_dashboard_netted_nominations  # noqa: E501

        Fetch Netted Nominations for a given delivery day, aggregating arbitrary Timescales  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_netted_nominations_with_http_info(delivery_day, timescales, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ParticipantDashboardNettedNominationsData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'timescales'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_dashboard_netted_nominations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('timescales') is not None:  # noqa: E501
            _query_params.append(('timescales', _params['timescales']))
            _collection_formats['timescales'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "ParticipantDashboardNettedNominationsData",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/participant-dashboard/netted-nominations', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_participant_dashboard_next_auctions_and_nomination_gates(self, **kwargs) -> ParticipantDashboardNextAuctionsAndNominationGates:  # noqa: E501
        """get_participant_dashboard_next_auctions_and_nomination_gates  # noqa: E501

        Fetches next Auctions and Nomination Gates for the Participants  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_next_auctions_and_nomination_gates(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ParticipantDashboardNextAuctionsAndNominationGates
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_dashboard_next_auctions_and_nomination_gates_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_dashboard_next_auctions_and_nomination_gates_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_dashboard_next_auctions_and_nomination_gates_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_dashboard_next_auctions_and_nomination_gates  # noqa: E501

        Fetches next Auctions and Nomination Gates for the Participants  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_next_auctions_and_nomination_gates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ParticipantDashboardNextAuctionsAndNominationGates, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_dashboard_next_auctions_and_nomination_gates" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "ParticipantDashboardNextAuctionsAndNominationGates",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/participant-dashboard/next-auctions-and-nomination-gates', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_participant_dashboard_transmission_rights_and_nominations(self, delivery_day : date, timescales : Annotated[conlist(AuctionTimescale), Field(..., description="List of Auction Timescales")], **kwargs) -> ParticipantDashboardTransmissionRightsAndNominationsData:  # noqa: E501
        """get_participant_dashboard_transmission_rights_and_nominations  # noqa: E501

        Fetch data about Transmission Right & Nominations  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_transmission_rights_and_nominations(delivery_day, timescales, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ParticipantDashboardTransmissionRightsAndNominationsData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_dashboard_transmission_rights_and_nominations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_dashboard_transmission_rights_and_nominations_with_http_info(delivery_day, timescales, **kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_dashboard_transmission_rights_and_nominations_with_http_info(self, delivery_day : date, timescales : Annotated[conlist(AuctionTimescale), Field(..., description="List of Auction Timescales")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_dashboard_transmission_rights_and_nominations  # noqa: E501

        Fetch data about Transmission Right & Nominations  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_transmission_rights_and_nominations_with_http_info(delivery_day, timescales, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ParticipantDashboardTransmissionRightsAndNominationsData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'timescales'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_dashboard_transmission_rights_and_nominations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('timescales') is not None:  # noqa: E501
            _query_params.append(('timescales', _params['timescales']))
            _collection_formats['timescales'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "ParticipantDashboardTransmissionRightsAndNominationsData",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/participant-dashboard/transmission-rights-and-nominations', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_participant_dashboard_transmission_rights_and_nominations_graph(self, delivery_day_from : date, delivery_day_to : date, timescales : Annotated[conlist(AuctionTimescale), Field(..., description="List of Auction Timescales")], **kwargs) -> ParticipantDashboardTransmissionRightsAndNominationsGraphData:  # noqa: E501
        """get_participant_dashboard_transmission_rights_and_nominations_graph  # noqa: E501

        Fetch data about Transmission Right & Nominations Graph  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_transmission_rights_and_nominations_graph(delivery_day_from, delivery_day_to, timescales, async_req=True)
        >>> result = thread.get()

        :param delivery_day_from: (required)
        :type delivery_day_from: date
        :param delivery_day_to: (required)
        :type delivery_day_to: date
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ParticipantDashboardTransmissionRightsAndNominationsGraphData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_dashboard_transmission_rights_and_nominations_graph_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_dashboard_transmission_rights_and_nominations_graph_with_http_info(delivery_day_from, delivery_day_to, timescales, **kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_dashboard_transmission_rights_and_nominations_graph_with_http_info(self, delivery_day_from : date, delivery_day_to : date, timescales : Annotated[conlist(AuctionTimescale), Field(..., description="List of Auction Timescales")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_dashboard_transmission_rights_and_nominations_graph  # noqa: E501

        Fetch data about Transmission Right & Nominations Graph  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_transmission_rights_and_nominations_graph_with_http_info(delivery_day_from, delivery_day_to, timescales, async_req=True)
        >>> result = thread.get()

        :param delivery_day_from: (required)
        :type delivery_day_from: date
        :param delivery_day_to: (required)
        :type delivery_day_to: date
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ParticipantDashboardTransmissionRightsAndNominationsGraphData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day_from',
            'delivery_day_to',
            'timescales'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_dashboard_transmission_rights_and_nominations_graph" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day_from') is not None:  # noqa: E501
            if isinstance(_params['delivery_day_from'], datetime):
                _query_params.append(('deliveryDayFrom', _params['delivery_day_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDayFrom', _params['delivery_day_from']))

        if _params.get('delivery_day_to') is not None:  # noqa: E501
            if isinstance(_params['delivery_day_to'], datetime):
                _query_params.append(('deliveryDayTo', _params['delivery_day_to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDayTo', _params['delivery_day_to']))

        if _params.get('timescales') is not None:  # noqa: E501
            _query_params.append(('timescales', _params['timescales']))
            _collection_formats['timescales'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "ParticipantDashboardTransmissionRightsAndNominationsGraphData",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/participant-dashboard/transmission-rights-and-nominations-graph', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_participant_dashboard_upcoming_long_term_auctions(self, **kwargs) -> List[ParticipantDashboardNextAuction]:  # noqa: E501
        """get_participant_dashboard_upcoming_long_term_auctions  # noqa: E501

        Fetch a list of upcoming Long Term Auctions  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_upcoming_long_term_auctions(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[ParticipantDashboardNextAuction]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_participant_dashboard_upcoming_long_term_auctions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_participant_dashboard_upcoming_long_term_auctions_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_participant_dashboard_upcoming_long_term_auctions_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_participant_dashboard_upcoming_long_term_auctions  # noqa: E501

        Fetch a list of upcoming Long Term Auctions  ---  __Requires Permission:__ (at least one)   * `VIEW_PARTICIPANT_DASHBOARD`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_participant_dashboard_upcoming_long_term_auctions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[ParticipantDashboardNextAuction], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_participant_dashboard_upcoming_long_term_auctions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "List[ParticipantDashboardNextAuction]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/participant-dashboard/upcoming-long-term-auctions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
