"""
The MIT License (MIT)

Copyright (c) 2015-2021 Rapptz
Copyright (c) 2021-present Pycord Development

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
"""

from __future__ import annotations

from typing import Literal, TypedDict, Union

from .snowflake import Snowflake
from .user import User

StickerFormatType = Literal[1, 2, 3]


class StickerItem(TypedDict):
    id: Snowflake
    name: str
    format_type: StickerFormatType


class BaseSticker(TypedDict):
    id: Snowflake
    name: str
    description: str
    tags: str
    format_type: StickerFormatType


class StandardSticker(BaseSticker):
    type: Literal[1]
    sort_value: int
    pack_id: Snowflake


class _GuildStickerOptional(TypedDict, total=False):
    user: User


class GuildSticker(BaseSticker, _GuildStickerOptional):
    type: Literal[2]
    available: bool
    guild_id: Snowflake


Sticker = Union[BaseSticker, StandardSticker, GuildSticker]


class StickerPack(TypedDict):
    id: Snowflake
    stickers: list[StandardSticker]
    name: str
    sku_id: Snowflake
    cover_sticker_id: Snowflake
    description: str
    banner_asset_id: Snowflake


class _CreateGuildStickerOptional(TypedDict, total=False):
    description: str


class CreateGuildSticker(_CreateGuildStickerOptional):
    name: str
    tags: str


class EditGuildSticker(TypedDict, total=False):
    name: str
    tags: str
    description: str


class ListPremiumStickerPacks(TypedDict):
    sticker_packs: list[StickerPack]
