import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SchemaConfig extends cdktf.TerraformMetaArguments {
    /**
     * The database name to alter schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#database Schema#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * When true, will also drop all the objects that are contained in the schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#drop_cascade Schema#drop_cascade}
     *
     * @stability stable
     */
    readonly dropCascade?: boolean | cdktf.IResolvable;
    /**
     * When true, use the existing schema if it exists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#if_not_exists Schema#if_not_exists}
     *
     * @stability stable
     */
    readonly ifNotExists?: boolean | cdktf.IResolvable;
    /**
     * The name of the schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#name Schema#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ROLE name who owns the schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#owner Schema#owner}
     *
     * @stability stable
     */
    readonly owner?: string;
    /**
     * policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#policy Schema#policy}
     *
     * @stability stable
     */
    readonly policy?: SchemaPolicy[];
}
/**
 * @stability stable
 */
export interface SchemaPolicy {
    /**
     * If true, allow the specified ROLEs to CREATE new objects within the schema(s).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#create Schema#create}
     *
     * @stability stable
     */
    readonly create?: boolean | cdktf.IResolvable;
    /**
     * If true, allow the specified ROLEs to CREATE new objects within the schema(s) and GRANT the same CREATE privilege to different ROLEs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#create_with_grant Schema#create_with_grant}
     *
     * @stability stable
     */
    readonly createWithGrant?: boolean | cdktf.IResolvable;
    /**
     * ROLE who will receive this policy (default: PUBLIC).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#role Schema#role}
     *
     * @stability stable
     */
    readonly role?: string;
    /**
     * If true, allow the specified ROLEs to use objects within the schema(s).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#usage Schema#usage}
     *
     * @stability stable
     */
    readonly usage?: boolean | cdktf.IResolvable;
    /**
     * If true, allow the specified ROLEs to use objects within the schema(s) and GRANT the same USAGE privilege to different ROLEs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#usage_with_grant Schema#usage_with_grant}
     *
     * @stability stable
     */
    readonly usageWithGrant?: boolean | cdktf.IResolvable;
}
export declare function schemaPolicyToTerraform(struct?: SchemaPolicy): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/schema postgresql_schema}.
 *
 * @stability stable
 */
export declare class Schema extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/schema postgresql_schema} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SchemaConfig);
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    resetDatabase(): void;
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _dropCascade?;
    /**
     * @stability stable
     */
    get dropCascade(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dropCascade(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDropCascade(): void;
    /**
     * @stability stable
     */
    get dropCascadeInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ifNotExists?;
    /**
     * @stability stable
     */
    get ifNotExists(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ifNotExists(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIfNotExists(): void;
    /**
     * @stability stable
     */
    get ifNotExistsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _owner?;
    /**
     * @stability stable
     */
    get owner(): string;
    /**
     * @stability stable
     */
    set owner(value: string);
    /**
     * @stability stable
     */
    resetOwner(): void;
    /**
     * @stability stable
     */
    get ownerInput(): string | undefined;
    private _policy?;
    /**
     * @stability stable
     */
    get policy(): SchemaPolicy[];
    /**
     * @stability stable
     */
    set policy(value: SchemaPolicy[]);
    /**
     * @stability stable
     */
    resetPolicy(): void;
    /**
     * @stability stable
     */
    get policyInput(): SchemaPolicy[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
