# coding: utf-8

"""
    printnanny-api-client

    Official API client library for printnanny.ai  # noqa: E501

    The version of the OpenAPI document: 0.131.4
    Contact: leigh@printnanny.ai
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from printnanny_api_client.configuration import Configuration


class DjStripeCharge(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'djstripe_id': 'int',
        'failure_code': 'StripeApiErrorCode',
        'djstripe_created': 'datetime',
        'djstripe_updated': 'datetime',
        'id': 'str',
        'livemode': 'bool',
        'created': 'datetime',
        'metadata': 'dict(str, object)',
        'description': 'str',
        'amount': 'str',
        'amount_captured': 'str',
        'amount_refunded': 'str',
        'application': 'str',
        'application_fee_amount': 'str',
        'billing_details': 'dict(str, object)',
        'calculated_statement_descriptor': 'str',
        'captured': 'bool',
        'currency': 'str',
        'disputed': 'bool',
        'failure_message': 'str',
        'fraud_details': 'dict(str, object)',
        'outcome': 'dict(str, object)',
        'paid': 'bool',
        'payment_method_details': 'dict(str, object)',
        'receipt_email': 'str',
        'receipt_number': 'str',
        'receipt_url': 'str',
        'refunded': 'bool',
        'shipping': 'dict(str, object)',
        'statement_descriptor': 'str',
        'statement_descriptor_suffix': 'str',
        'status': 'StripeSourceCodeVerificationStatus',
        'transfer_data': 'dict(str, object)',
        'transfer_group': 'str',
        'djstripe_owner_account': 'str',
        'application_fee': 'str',
        'balance_transaction': 'str',
        'customer': 'str',
        'dispute': 'str',
        'invoice': 'str',
        'on_behalf_of': 'str',
        'payment_intent': 'str',
        'payment_method': 'str',
        'source': 'str',
        'source_transfer': 'str',
        'transfer': 'str'
    }

    attribute_map = {
        'djstripe_id': 'djstripe_id',
        'failure_code': 'failure_code',
        'djstripe_created': 'djstripe_created',
        'djstripe_updated': 'djstripe_updated',
        'id': 'id',
        'livemode': 'livemode',
        'created': 'created',
        'metadata': 'metadata',
        'description': 'description',
        'amount': 'amount',
        'amount_captured': 'amount_captured',
        'amount_refunded': 'amount_refunded',
        'application': 'application',
        'application_fee_amount': 'application_fee_amount',
        'billing_details': 'billing_details',
        'calculated_statement_descriptor': 'calculated_statement_descriptor',
        'captured': 'captured',
        'currency': 'currency',
        'disputed': 'disputed',
        'failure_message': 'failure_message',
        'fraud_details': 'fraud_details',
        'outcome': 'outcome',
        'paid': 'paid',
        'payment_method_details': 'payment_method_details',
        'receipt_email': 'receipt_email',
        'receipt_number': 'receipt_number',
        'receipt_url': 'receipt_url',
        'refunded': 'refunded',
        'shipping': 'shipping',
        'statement_descriptor': 'statement_descriptor',
        'statement_descriptor_suffix': 'statement_descriptor_suffix',
        'status': 'status',
        'transfer_data': 'transfer_data',
        'transfer_group': 'transfer_group',
        'djstripe_owner_account': 'djstripe_owner_account',
        'application_fee': 'application_fee',
        'balance_transaction': 'balance_transaction',
        'customer': 'customer',
        'dispute': 'dispute',
        'invoice': 'invoice',
        'on_behalf_of': 'on_behalf_of',
        'payment_intent': 'payment_intent',
        'payment_method': 'payment_method',
        'source': 'source',
        'source_transfer': 'source_transfer',
        'transfer': 'transfer'
    }

    def __init__(self, djstripe_id=None, failure_code=None, djstripe_created=None, djstripe_updated=None, id=None, livemode=None, created=None, metadata=None, description=None, amount=None, amount_captured=None, amount_refunded=None, application=None, application_fee_amount=None, billing_details=None, calculated_statement_descriptor=None, captured=None, currency=None, disputed=None, failure_message=None, fraud_details=None, outcome=None, paid=None, payment_method_details=None, receipt_email=None, receipt_number=None, receipt_url=None, refunded=None, shipping=None, statement_descriptor=None, statement_descriptor_suffix=None, status=None, transfer_data=None, transfer_group=None, djstripe_owner_account=None, application_fee=None, balance_transaction=None, customer=None, dispute=None, invoice=None, on_behalf_of=None, payment_intent=None, payment_method=None, source=None, source_transfer=None, transfer=None, local_vars_configuration=None):  # noqa: E501
        """DjStripeCharge - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._djstripe_id = None
        self._failure_code = None
        self._djstripe_created = None
        self._djstripe_updated = None
        self._id = None
        self._livemode = None
        self._created = None
        self._metadata = None
        self._description = None
        self._amount = None
        self._amount_captured = None
        self._amount_refunded = None
        self._application = None
        self._application_fee_amount = None
        self._billing_details = None
        self._calculated_statement_descriptor = None
        self._captured = None
        self._currency = None
        self._disputed = None
        self._failure_message = None
        self._fraud_details = None
        self._outcome = None
        self._paid = None
        self._payment_method_details = None
        self._receipt_email = None
        self._receipt_number = None
        self._receipt_url = None
        self._refunded = None
        self._shipping = None
        self._statement_descriptor = None
        self._statement_descriptor_suffix = None
        self._status = None
        self._transfer_data = None
        self._transfer_group = None
        self._djstripe_owner_account = None
        self._application_fee = None
        self._balance_transaction = None
        self._customer = None
        self._dispute = None
        self._invoice = None
        self._on_behalf_of = None
        self._payment_intent = None
        self._payment_method = None
        self._source = None
        self._source_transfer = None
        self._transfer = None
        self.discriminator = None

        self.djstripe_id = djstripe_id
        self.failure_code = failure_code
        self.djstripe_created = djstripe_created
        self.djstripe_updated = djstripe_updated
        self.id = id
        self.livemode = livemode
        self.created = created
        self.metadata = metadata
        self.description = description
        self.amount = amount
        self.amount_captured = amount_captured
        self.amount_refunded = amount_refunded
        if application is not None:
            self.application = application
        self.application_fee_amount = application_fee_amount
        self.billing_details = billing_details
        if calculated_statement_descriptor is not None:
            self.calculated_statement_descriptor = calculated_statement_descriptor
        if captured is not None:
            self.captured = captured
        self.currency = currency
        if disputed is not None:
            self.disputed = disputed
        if failure_message is not None:
            self.failure_message = failure_message
        self.fraud_details = fraud_details
        self.outcome = outcome
        if paid is not None:
            self.paid = paid
        self.payment_method_details = payment_method_details
        if receipt_email is not None:
            self.receipt_email = receipt_email
        if receipt_number is not None:
            self.receipt_number = receipt_number
        if receipt_url is not None:
            self.receipt_url = receipt_url
        if refunded is not None:
            self.refunded = refunded
        self.shipping = shipping
        self.statement_descriptor = statement_descriptor
        self.statement_descriptor_suffix = statement_descriptor_suffix
        self.status = status
        self.transfer_data = transfer_data
        self.transfer_group = transfer_group
        self.djstripe_owner_account = djstripe_owner_account
        self.application_fee = application_fee
        self.balance_transaction = balance_transaction
        self.customer = customer
        self.dispute = dispute
        self.invoice = invoice
        self.on_behalf_of = on_behalf_of
        self.payment_intent = payment_intent
        self.payment_method = payment_method
        self.source = source
        self.source_transfer = source_transfer
        self.transfer = transfer

    @property
    def djstripe_id(self):
        """Gets the djstripe_id of this DjStripeCharge.  # noqa: E501


        :return: The djstripe_id of this DjStripeCharge.  # noqa: E501
        :rtype: int
        """
        return self._djstripe_id

    @djstripe_id.setter
    def djstripe_id(self, djstripe_id):
        """Sets the djstripe_id of this DjStripeCharge.


        :param djstripe_id: The djstripe_id of this DjStripeCharge.  # noqa: E501
        :type djstripe_id: int
        """
        if self.local_vars_configuration.client_side_validation and djstripe_id is None:  # noqa: E501
            raise ValueError("Invalid value for `djstripe_id`, must not be `None`")  # noqa: E501

        self._djstripe_id = djstripe_id

    @property
    def failure_code(self):
        """Gets the failure_code of this DjStripeCharge.  # noqa: E501


        :return: The failure_code of this DjStripeCharge.  # noqa: E501
        :rtype: StripeApiErrorCode
        """
        return self._failure_code

    @failure_code.setter
    def failure_code(self, failure_code):
        """Sets the failure_code of this DjStripeCharge.


        :param failure_code: The failure_code of this DjStripeCharge.  # noqa: E501
        :type failure_code: StripeApiErrorCode
        """
        if self.local_vars_configuration.client_side_validation and failure_code is None:  # noqa: E501
            raise ValueError("Invalid value for `failure_code`, must not be `None`")  # noqa: E501

        self._failure_code = failure_code

    @property
    def djstripe_created(self):
        """Gets the djstripe_created of this DjStripeCharge.  # noqa: E501


        :return: The djstripe_created of this DjStripeCharge.  # noqa: E501
        :rtype: datetime
        """
        return self._djstripe_created

    @djstripe_created.setter
    def djstripe_created(self, djstripe_created):
        """Sets the djstripe_created of this DjStripeCharge.


        :param djstripe_created: The djstripe_created of this DjStripeCharge.  # noqa: E501
        :type djstripe_created: datetime
        """
        if self.local_vars_configuration.client_side_validation and djstripe_created is None:  # noqa: E501
            raise ValueError("Invalid value for `djstripe_created`, must not be `None`")  # noqa: E501

        self._djstripe_created = djstripe_created

    @property
    def djstripe_updated(self):
        """Gets the djstripe_updated of this DjStripeCharge.  # noqa: E501


        :return: The djstripe_updated of this DjStripeCharge.  # noqa: E501
        :rtype: datetime
        """
        return self._djstripe_updated

    @djstripe_updated.setter
    def djstripe_updated(self, djstripe_updated):
        """Sets the djstripe_updated of this DjStripeCharge.


        :param djstripe_updated: The djstripe_updated of this DjStripeCharge.  # noqa: E501
        :type djstripe_updated: datetime
        """
        if self.local_vars_configuration.client_side_validation and djstripe_updated is None:  # noqa: E501
            raise ValueError("Invalid value for `djstripe_updated`, must not be `None`")  # noqa: E501

        self._djstripe_updated = djstripe_updated

    @property
    def id(self):
        """Gets the id of this DjStripeCharge.  # noqa: E501


        :return: The id of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DjStripeCharge.


        :param id: The id of this DjStripeCharge.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 255):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `255`")  # noqa: E501

        self._id = id

    @property
    def livemode(self):
        """Gets the livemode of this DjStripeCharge.  # noqa: E501

        Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.  # noqa: E501

        :return: The livemode of this DjStripeCharge.  # noqa: E501
        :rtype: bool
        """
        return self._livemode

    @livemode.setter
    def livemode(self, livemode):
        """Sets the livemode of this DjStripeCharge.

        Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.  # noqa: E501

        :param livemode: The livemode of this DjStripeCharge.  # noqa: E501
        :type livemode: bool
        """

        self._livemode = livemode

    @property
    def created(self):
        """Gets the created of this DjStripeCharge.  # noqa: E501

        The datetime this object was created in stripe.  # noqa: E501

        :return: The created of this DjStripeCharge.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this DjStripeCharge.

        The datetime this object was created in stripe.  # noqa: E501

        :param created: The created of this DjStripeCharge.  # noqa: E501
        :type created: datetime
        """

        self._created = created

    @property
    def metadata(self):
        """Gets the metadata of this DjStripeCharge.  # noqa: E501

        A set of key/value pairs that you can attach to an object. It can be useful for storing additional information about an object in a structured format.  # noqa: E501

        :return: The metadata of this DjStripeCharge.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this DjStripeCharge.

        A set of key/value pairs that you can attach to an object. It can be useful for storing additional information about an object in a structured format.  # noqa: E501

        :param metadata: The metadata of this DjStripeCharge.  # noqa: E501
        :type metadata: dict(str, object)
        """

        self._metadata = metadata

    @property
    def description(self):
        """Gets the description of this DjStripeCharge.  # noqa: E501

        A description of this object.  # noqa: E501

        :return: The description of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DjStripeCharge.

        A description of this object.  # noqa: E501

        :param description: The description of this DjStripeCharge.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def amount(self):
        """Gets the amount of this DjStripeCharge.  # noqa: E501

        Amount charged (as decimal).  # noqa: E501

        :return: The amount of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this DjStripeCharge.

        Amount charged (as decimal).  # noqa: E501

        :param amount: The amount of this DjStripeCharge.  # noqa: E501
        :type amount: str
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                amount is not None and not re.search(r'^-?\d{0,9}(?:\.\d{0,2})?$', amount)):  # noqa: E501
            raise ValueError(r"Invalid value for `amount`, must be a follow pattern or equal to `/^-?\d{0,9}(?:\.\d{0,2})?$/`")  # noqa: E501

        self._amount = amount

    @property
    def amount_captured(self):
        """Gets the amount_captured of this DjStripeCharge.  # noqa: E501

        Amount (as decimal) captured (can be less than the amount attribute on the charge if a partial capture was issued).  # noqa: E501

        :return: The amount_captured of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._amount_captured

    @amount_captured.setter
    def amount_captured(self, amount_captured):
        """Sets the amount_captured of this DjStripeCharge.

        Amount (as decimal) captured (can be less than the amount attribute on the charge if a partial capture was issued).  # noqa: E501

        :param amount_captured: The amount_captured of this DjStripeCharge.  # noqa: E501
        :type amount_captured: str
        """
        if (self.local_vars_configuration.client_side_validation and
                amount_captured is not None and not re.search(r'^-?\d{0,9}(?:\.\d{0,2})?$', amount_captured)):  # noqa: E501
            raise ValueError(r"Invalid value for `amount_captured`, must be a follow pattern or equal to `/^-?\d{0,9}(?:\.\d{0,2})?$/`")  # noqa: E501

        self._amount_captured = amount_captured

    @property
    def amount_refunded(self):
        """Gets the amount_refunded of this DjStripeCharge.  # noqa: E501

        Amount (as decimal) refunded (can be less than the amount attribute on the charge if a partial refund was issued).  # noqa: E501

        :return: The amount_refunded of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._amount_refunded

    @amount_refunded.setter
    def amount_refunded(self, amount_refunded):
        """Sets the amount_refunded of this DjStripeCharge.

        Amount (as decimal) refunded (can be less than the amount attribute on the charge if a partial refund was issued).  # noqa: E501

        :param amount_refunded: The amount_refunded of this DjStripeCharge.  # noqa: E501
        :type amount_refunded: str
        """
        if self.local_vars_configuration.client_side_validation and amount_refunded is None:  # noqa: E501
            raise ValueError("Invalid value for `amount_refunded`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                amount_refunded is not None and not re.search(r'^-?\d{0,9}(?:\.\d{0,2})?$', amount_refunded)):  # noqa: E501
            raise ValueError(r"Invalid value for `amount_refunded`, must be a follow pattern or equal to `/^-?\d{0,9}(?:\.\d{0,2})?$/`")  # noqa: E501

        self._amount_refunded = amount_refunded

    @property
    def application(self):
        """Gets the application of this DjStripeCharge.  # noqa: E501

        ID of the Connect application that created the charge.  # noqa: E501

        :return: The application of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._application

    @application.setter
    def application(self, application):
        """Sets the application of this DjStripeCharge.

        ID of the Connect application that created the charge.  # noqa: E501

        :param application: The application of this DjStripeCharge.  # noqa: E501
        :type application: str
        """
        if (self.local_vars_configuration.client_side_validation and
                application is not None and len(application) > 255):
            raise ValueError("Invalid value for `application`, length must be less than or equal to `255`")  # noqa: E501

        self._application = application

    @property
    def application_fee_amount(self):
        """Gets the application_fee_amount of this DjStripeCharge.  # noqa: E501

        The amount (as decimal) of the application fee (if any) requested for the charge.  # noqa: E501

        :return: The application_fee_amount of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._application_fee_amount

    @application_fee_amount.setter
    def application_fee_amount(self, application_fee_amount):
        """Sets the application_fee_amount of this DjStripeCharge.

        The amount (as decimal) of the application fee (if any) requested for the charge.  # noqa: E501

        :param application_fee_amount: The application_fee_amount of this DjStripeCharge.  # noqa: E501
        :type application_fee_amount: str
        """
        if (self.local_vars_configuration.client_side_validation and
                application_fee_amount is not None and not re.search(r'^-?\d{0,9}(?:\.\d{0,2})?$', application_fee_amount)):  # noqa: E501
            raise ValueError(r"Invalid value for `application_fee_amount`, must be a follow pattern or equal to `/^-?\d{0,9}(?:\.\d{0,2})?$/`")  # noqa: E501

        self._application_fee_amount = application_fee_amount

    @property
    def billing_details(self):
        """Gets the billing_details of this DjStripeCharge.  # noqa: E501

        Billing information associated with the PaymentMethod at the time of the transaction.  # noqa: E501

        :return: The billing_details of this DjStripeCharge.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._billing_details

    @billing_details.setter
    def billing_details(self, billing_details):
        """Sets the billing_details of this DjStripeCharge.

        Billing information associated with the PaymentMethod at the time of the transaction.  # noqa: E501

        :param billing_details: The billing_details of this DjStripeCharge.  # noqa: E501
        :type billing_details: dict(str, object)
        """

        self._billing_details = billing_details

    @property
    def calculated_statement_descriptor(self):
        """Gets the calculated_statement_descriptor of this DjStripeCharge.  # noqa: E501

        The full statement descriptor that is passed to card networks, and that is displayed on your customers' credit card and bank statements. Allows you to see what the statement descriptor looks like after the static and dynamic portions are combined.  # noqa: E501

        :return: The calculated_statement_descriptor of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._calculated_statement_descriptor

    @calculated_statement_descriptor.setter
    def calculated_statement_descriptor(self, calculated_statement_descriptor):
        """Sets the calculated_statement_descriptor of this DjStripeCharge.

        The full statement descriptor that is passed to card networks, and that is displayed on your customers' credit card and bank statements. Allows you to see what the statement descriptor looks like after the static and dynamic portions are combined.  # noqa: E501

        :param calculated_statement_descriptor: The calculated_statement_descriptor of this DjStripeCharge.  # noqa: E501
        :type calculated_statement_descriptor: str
        """
        if (self.local_vars_configuration.client_side_validation and
                calculated_statement_descriptor is not None and len(calculated_statement_descriptor) > 22):
            raise ValueError("Invalid value for `calculated_statement_descriptor`, length must be less than or equal to `22`")  # noqa: E501

        self._calculated_statement_descriptor = calculated_statement_descriptor

    @property
    def captured(self):
        """Gets the captured of this DjStripeCharge.  # noqa: E501

        If the charge was created without capturing, this boolean represents whether or not it is still uncaptured or has since been captured.  # noqa: E501

        :return: The captured of this DjStripeCharge.  # noqa: E501
        :rtype: bool
        """
        return self._captured

    @captured.setter
    def captured(self, captured):
        """Sets the captured of this DjStripeCharge.

        If the charge was created without capturing, this boolean represents whether or not it is still uncaptured or has since been captured.  # noqa: E501

        :param captured: The captured of this DjStripeCharge.  # noqa: E501
        :type captured: bool
        """

        self._captured = captured

    @property
    def currency(self):
        """Gets the currency of this DjStripeCharge.  # noqa: E501

        The currency in which the charge was made.  # noqa: E501

        :return: The currency of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this DjStripeCharge.

        The currency in which the charge was made.  # noqa: E501

        :param currency: The currency of this DjStripeCharge.  # noqa: E501
        :type currency: str
        """
        if self.local_vars_configuration.client_side_validation and currency is None:  # noqa: E501
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                currency is not None and len(currency) > 3):
            raise ValueError("Invalid value for `currency`, length must be less than or equal to `3`")  # noqa: E501

        self._currency = currency

    @property
    def disputed(self):
        """Gets the disputed of this DjStripeCharge.  # noqa: E501

        Whether the charge has been disputed.  # noqa: E501

        :return: The disputed of this DjStripeCharge.  # noqa: E501
        :rtype: bool
        """
        return self._disputed

    @disputed.setter
    def disputed(self, disputed):
        """Sets the disputed of this DjStripeCharge.

        Whether the charge has been disputed.  # noqa: E501

        :param disputed: The disputed of this DjStripeCharge.  # noqa: E501
        :type disputed: bool
        """

        self._disputed = disputed

    @property
    def failure_message(self):
        """Gets the failure_message of this DjStripeCharge.  # noqa: E501

        Message to user further explaining reason for charge failure if available.  # noqa: E501

        :return: The failure_message of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._failure_message

    @failure_message.setter
    def failure_message(self, failure_message):
        """Sets the failure_message of this DjStripeCharge.

        Message to user further explaining reason for charge failure if available.  # noqa: E501

        :param failure_message: The failure_message of this DjStripeCharge.  # noqa: E501
        :type failure_message: str
        """
        if (self.local_vars_configuration.client_side_validation and
                failure_message is not None and len(failure_message) > 5000):
            raise ValueError("Invalid value for `failure_message`, length must be less than or equal to `5000`")  # noqa: E501

        self._failure_message = failure_message

    @property
    def fraud_details(self):
        """Gets the fraud_details of this DjStripeCharge.  # noqa: E501

        Hash with information on fraud assessments for the charge.  # noqa: E501

        :return: The fraud_details of this DjStripeCharge.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._fraud_details

    @fraud_details.setter
    def fraud_details(self, fraud_details):
        """Sets the fraud_details of this DjStripeCharge.

        Hash with information on fraud assessments for the charge.  # noqa: E501

        :param fraud_details: The fraud_details of this DjStripeCharge.  # noqa: E501
        :type fraud_details: dict(str, object)
        """

        self._fraud_details = fraud_details

    @property
    def outcome(self):
        """Gets the outcome of this DjStripeCharge.  # noqa: E501

        Details about whether or not the payment was accepted, and why.  # noqa: E501

        :return: The outcome of this DjStripeCharge.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._outcome

    @outcome.setter
    def outcome(self, outcome):
        """Sets the outcome of this DjStripeCharge.

        Details about whether or not the payment was accepted, and why.  # noqa: E501

        :param outcome: The outcome of this DjStripeCharge.  # noqa: E501
        :type outcome: dict(str, object)
        """

        self._outcome = outcome

    @property
    def paid(self):
        """Gets the paid of this DjStripeCharge.  # noqa: E501

        True if the charge succeeded, or was successfully authorized for later capture, False otherwise.  # noqa: E501

        :return: The paid of this DjStripeCharge.  # noqa: E501
        :rtype: bool
        """
        return self._paid

    @paid.setter
    def paid(self, paid):
        """Sets the paid of this DjStripeCharge.

        True if the charge succeeded, or was successfully authorized for later capture, False otherwise.  # noqa: E501

        :param paid: The paid of this DjStripeCharge.  # noqa: E501
        :type paid: bool
        """

        self._paid = paid

    @property
    def payment_method_details(self):
        """Gets the payment_method_details of this DjStripeCharge.  # noqa: E501

        Details about the payment method at the time of the transaction.  # noqa: E501

        :return: The payment_method_details of this DjStripeCharge.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._payment_method_details

    @payment_method_details.setter
    def payment_method_details(self, payment_method_details):
        """Sets the payment_method_details of this DjStripeCharge.

        Details about the payment method at the time of the transaction.  # noqa: E501

        :param payment_method_details: The payment_method_details of this DjStripeCharge.  # noqa: E501
        :type payment_method_details: dict(str, object)
        """

        self._payment_method_details = payment_method_details

    @property
    def receipt_email(self):
        """Gets the receipt_email of this DjStripeCharge.  # noqa: E501

        The email address that the receipt for this charge was sent to.  # noqa: E501

        :return: The receipt_email of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._receipt_email

    @receipt_email.setter
    def receipt_email(self, receipt_email):
        """Sets the receipt_email of this DjStripeCharge.

        The email address that the receipt for this charge was sent to.  # noqa: E501

        :param receipt_email: The receipt_email of this DjStripeCharge.  # noqa: E501
        :type receipt_email: str
        """
        if (self.local_vars_configuration.client_side_validation and
                receipt_email is not None and len(receipt_email) > 800):
            raise ValueError("Invalid value for `receipt_email`, length must be less than or equal to `800`")  # noqa: E501

        self._receipt_email = receipt_email

    @property
    def receipt_number(self):
        """Gets the receipt_number of this DjStripeCharge.  # noqa: E501

        The transaction number that appears on email receipts sent for this charge.  # noqa: E501

        :return: The receipt_number of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._receipt_number

    @receipt_number.setter
    def receipt_number(self, receipt_number):
        """Sets the receipt_number of this DjStripeCharge.

        The transaction number that appears on email receipts sent for this charge.  # noqa: E501

        :param receipt_number: The receipt_number of this DjStripeCharge.  # noqa: E501
        :type receipt_number: str
        """
        if (self.local_vars_configuration.client_side_validation and
                receipt_number is not None and len(receipt_number) > 14):
            raise ValueError("Invalid value for `receipt_number`, length must be less than or equal to `14`")  # noqa: E501

        self._receipt_number = receipt_number

    @property
    def receipt_url(self):
        """Gets the receipt_url of this DjStripeCharge.  # noqa: E501

        This is the URL to view the receipt for this charge. The receipt is kept up-to-date to the latest state of the charge, including any refunds. If the charge is for an Invoice, the receipt will be stylized as an Invoice receipt.  # noqa: E501

        :return: The receipt_url of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._receipt_url

    @receipt_url.setter
    def receipt_url(self, receipt_url):
        """Sets the receipt_url of this DjStripeCharge.

        This is the URL to view the receipt for this charge. The receipt is kept up-to-date to the latest state of the charge, including any refunds. If the charge is for an Invoice, the receipt will be stylized as an Invoice receipt.  # noqa: E501

        :param receipt_url: The receipt_url of this DjStripeCharge.  # noqa: E501
        :type receipt_url: str
        """
        if (self.local_vars_configuration.client_side_validation and
                receipt_url is not None and len(receipt_url) > 5000):
            raise ValueError("Invalid value for `receipt_url`, length must be less than or equal to `5000`")  # noqa: E501

        self._receipt_url = receipt_url

    @property
    def refunded(self):
        """Gets the refunded of this DjStripeCharge.  # noqa: E501

        Whether or not the charge has been fully refunded. If the charge is only partially refunded, this attribute will still be false.  # noqa: E501

        :return: The refunded of this DjStripeCharge.  # noqa: E501
        :rtype: bool
        """
        return self._refunded

    @refunded.setter
    def refunded(self, refunded):
        """Sets the refunded of this DjStripeCharge.

        Whether or not the charge has been fully refunded. If the charge is only partially refunded, this attribute will still be false.  # noqa: E501

        :param refunded: The refunded of this DjStripeCharge.  # noqa: E501
        :type refunded: bool
        """

        self._refunded = refunded

    @property
    def shipping(self):
        """Gets the shipping of this DjStripeCharge.  # noqa: E501

        Shipping information for the charge  # noqa: E501

        :return: The shipping of this DjStripeCharge.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._shipping

    @shipping.setter
    def shipping(self, shipping):
        """Sets the shipping of this DjStripeCharge.

        Shipping information for the charge  # noqa: E501

        :param shipping: The shipping of this DjStripeCharge.  # noqa: E501
        :type shipping: dict(str, object)
        """

        self._shipping = shipping

    @property
    def statement_descriptor(self):
        """Gets the statement_descriptor of this DjStripeCharge.  # noqa: E501

        For card charges, use statement_descriptor_suffix instead. Otherwise, you can use this value as the complete description of a charge on your customers' statements. Must contain at least one letter, maximum 22 characters.  # noqa: E501

        :return: The statement_descriptor of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._statement_descriptor

    @statement_descriptor.setter
    def statement_descriptor(self, statement_descriptor):
        """Sets the statement_descriptor of this DjStripeCharge.

        For card charges, use statement_descriptor_suffix instead. Otherwise, you can use this value as the complete description of a charge on your customers' statements. Must contain at least one letter, maximum 22 characters.  # noqa: E501

        :param statement_descriptor: The statement_descriptor of this DjStripeCharge.  # noqa: E501
        :type statement_descriptor: str
        """
        if (self.local_vars_configuration.client_side_validation and
                statement_descriptor is not None and len(statement_descriptor) > 22):
            raise ValueError("Invalid value for `statement_descriptor`, length must be less than or equal to `22`")  # noqa: E501

        self._statement_descriptor = statement_descriptor

    @property
    def statement_descriptor_suffix(self):
        """Gets the statement_descriptor_suffix of this DjStripeCharge.  # noqa: E501

        Provides information about the charge that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that's set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.  # noqa: E501

        :return: The statement_descriptor_suffix of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._statement_descriptor_suffix

    @statement_descriptor_suffix.setter
    def statement_descriptor_suffix(self, statement_descriptor_suffix):
        """Sets the statement_descriptor_suffix of this DjStripeCharge.

        Provides information about the charge that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that's set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.  # noqa: E501

        :param statement_descriptor_suffix: The statement_descriptor_suffix of this DjStripeCharge.  # noqa: E501
        :type statement_descriptor_suffix: str
        """
        if (self.local_vars_configuration.client_side_validation and
                statement_descriptor_suffix is not None and len(statement_descriptor_suffix) > 22):
            raise ValueError("Invalid value for `statement_descriptor_suffix`, length must be less than or equal to `22`")  # noqa: E501

        self._statement_descriptor_suffix = statement_descriptor_suffix

    @property
    def status(self):
        """Gets the status of this DjStripeCharge.  # noqa: E501

        The status of the payment.  * `failed` - Failed * `pending` - Pending * `succeeded` - Succeeded  # noqa: E501

        :return: The status of this DjStripeCharge.  # noqa: E501
        :rtype: StripeSourceCodeVerificationStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this DjStripeCharge.

        The status of the payment.  * `failed` - Failed * `pending` - Pending * `succeeded` - Succeeded  # noqa: E501

        :param status: The status of this DjStripeCharge.  # noqa: E501
        :type status: StripeSourceCodeVerificationStatus
        """

        self._status = status

    @property
    def transfer_data(self):
        """Gets the transfer_data of this DjStripeCharge.  # noqa: E501

        An optional dictionary including the account to automatically transfer to as part of a destination charge.  # noqa: E501

        :return: The transfer_data of this DjStripeCharge.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._transfer_data

    @transfer_data.setter
    def transfer_data(self, transfer_data):
        """Sets the transfer_data of this DjStripeCharge.

        An optional dictionary including the account to automatically transfer to as part of a destination charge.  # noqa: E501

        :param transfer_data: The transfer_data of this DjStripeCharge.  # noqa: E501
        :type transfer_data: dict(str, object)
        """

        self._transfer_data = transfer_data

    @property
    def transfer_group(self):
        """Gets the transfer_group of this DjStripeCharge.  # noqa: E501

        A string that identifies this transaction as part of a group.  # noqa: E501

        :return: The transfer_group of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._transfer_group

    @transfer_group.setter
    def transfer_group(self, transfer_group):
        """Sets the transfer_group of this DjStripeCharge.

        A string that identifies this transaction as part of a group.  # noqa: E501

        :param transfer_group: The transfer_group of this DjStripeCharge.  # noqa: E501
        :type transfer_group: str
        """
        if (self.local_vars_configuration.client_side_validation and
                transfer_group is not None and len(transfer_group) > 255):
            raise ValueError("Invalid value for `transfer_group`, length must be less than or equal to `255`")  # noqa: E501

        self._transfer_group = transfer_group

    @property
    def djstripe_owner_account(self):
        """Gets the djstripe_owner_account of this DjStripeCharge.  # noqa: E501

        The Stripe Account this object belongs to.  # noqa: E501

        :return: The djstripe_owner_account of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._djstripe_owner_account

    @djstripe_owner_account.setter
    def djstripe_owner_account(self, djstripe_owner_account):
        """Sets the djstripe_owner_account of this DjStripeCharge.

        The Stripe Account this object belongs to.  # noqa: E501

        :param djstripe_owner_account: The djstripe_owner_account of this DjStripeCharge.  # noqa: E501
        :type djstripe_owner_account: str
        """

        self._djstripe_owner_account = djstripe_owner_account

    @property
    def application_fee(self):
        """Gets the application_fee of this DjStripeCharge.  # noqa: E501

        The application fee (if any) for the charge.  # noqa: E501

        :return: The application_fee of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._application_fee

    @application_fee.setter
    def application_fee(self, application_fee):
        """Sets the application_fee of this DjStripeCharge.

        The application fee (if any) for the charge.  # noqa: E501

        :param application_fee: The application_fee of this DjStripeCharge.  # noqa: E501
        :type application_fee: str
        """

        self._application_fee = application_fee

    @property
    def balance_transaction(self):
        """Gets the balance_transaction of this DjStripeCharge.  # noqa: E501

        The balance transaction that describes the impact of this charge on your account balance (not including refunds or disputes).  # noqa: E501

        :return: The balance_transaction of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._balance_transaction

    @balance_transaction.setter
    def balance_transaction(self, balance_transaction):
        """Sets the balance_transaction of this DjStripeCharge.

        The balance transaction that describes the impact of this charge on your account balance (not including refunds or disputes).  # noqa: E501

        :param balance_transaction: The balance_transaction of this DjStripeCharge.  # noqa: E501
        :type balance_transaction: str
        """

        self._balance_transaction = balance_transaction

    @property
    def customer(self):
        """Gets the customer of this DjStripeCharge.  # noqa: E501

        The customer associated with this charge.  # noqa: E501

        :return: The customer of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """Sets the customer of this DjStripeCharge.

        The customer associated with this charge.  # noqa: E501

        :param customer: The customer of this DjStripeCharge.  # noqa: E501
        :type customer: str
        """

        self._customer = customer

    @property
    def dispute(self):
        """Gets the dispute of this DjStripeCharge.  # noqa: E501

        Details about the dispute if the charge has been disputed.  # noqa: E501

        :return: The dispute of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._dispute

    @dispute.setter
    def dispute(self, dispute):
        """Sets the dispute of this DjStripeCharge.

        Details about the dispute if the charge has been disputed.  # noqa: E501

        :param dispute: The dispute of this DjStripeCharge.  # noqa: E501
        :type dispute: str
        """

        self._dispute = dispute

    @property
    def invoice(self):
        """Gets the invoice of this DjStripeCharge.  # noqa: E501

        The invoice this charge is for if one exists.  # noqa: E501

        :return: The invoice of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._invoice

    @invoice.setter
    def invoice(self, invoice):
        """Sets the invoice of this DjStripeCharge.

        The invoice this charge is for if one exists.  # noqa: E501

        :param invoice: The invoice of this DjStripeCharge.  # noqa: E501
        :type invoice: str
        """

        self._invoice = invoice

    @property
    def on_behalf_of(self):
        """Gets the on_behalf_of of this DjStripeCharge.  # noqa: E501

        The account (if any) the charge was made on behalf of without triggering an automatic transfer.  # noqa: E501

        :return: The on_behalf_of of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._on_behalf_of

    @on_behalf_of.setter
    def on_behalf_of(self, on_behalf_of):
        """Sets the on_behalf_of of this DjStripeCharge.

        The account (if any) the charge was made on behalf of without triggering an automatic transfer.  # noqa: E501

        :param on_behalf_of: The on_behalf_of of this DjStripeCharge.  # noqa: E501
        :type on_behalf_of: str
        """

        self._on_behalf_of = on_behalf_of

    @property
    def payment_intent(self):
        """Gets the payment_intent of this DjStripeCharge.  # noqa: E501

        PaymentIntent associated with this charge, if one exists.  # noqa: E501

        :return: The payment_intent of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._payment_intent

    @payment_intent.setter
    def payment_intent(self, payment_intent):
        """Sets the payment_intent of this DjStripeCharge.

        PaymentIntent associated with this charge, if one exists.  # noqa: E501

        :param payment_intent: The payment_intent of this DjStripeCharge.  # noqa: E501
        :type payment_intent: str
        """

        self._payment_intent = payment_intent

    @property
    def payment_method(self):
        """Gets the payment_method of this DjStripeCharge.  # noqa: E501

        PaymentMethod used in this charge.  # noqa: E501

        :return: The payment_method of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._payment_method

    @payment_method.setter
    def payment_method(self, payment_method):
        """Sets the payment_method of this DjStripeCharge.

        PaymentMethod used in this charge.  # noqa: E501

        :param payment_method: The payment_method of this DjStripeCharge.  # noqa: E501
        :type payment_method: str
        """

        self._payment_method = payment_method

    @property
    def source(self):
        """Gets the source of this DjStripeCharge.  # noqa: E501

        The source used for this charge.  # noqa: E501

        :return: The source of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this DjStripeCharge.

        The source used for this charge.  # noqa: E501

        :param source: The source of this DjStripeCharge.  # noqa: E501
        :type source: str
        """

        self._source = source

    @property
    def source_transfer(self):
        """Gets the source_transfer of this DjStripeCharge.  # noqa: E501

        The transfer which created this charge. Only present if the charge came from another Stripe account.  # noqa: E501

        :return: The source_transfer of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._source_transfer

    @source_transfer.setter
    def source_transfer(self, source_transfer):
        """Sets the source_transfer of this DjStripeCharge.

        The transfer which created this charge. Only present if the charge came from another Stripe account.  # noqa: E501

        :param source_transfer: The source_transfer of this DjStripeCharge.  # noqa: E501
        :type source_transfer: str
        """

        self._source_transfer = source_transfer

    @property
    def transfer(self):
        """Gets the transfer of this DjStripeCharge.  # noqa: E501

        The transfer to the `destination` account (only applicable if the charge was created using the `destination` parameter).  # noqa: E501

        :return: The transfer of this DjStripeCharge.  # noqa: E501
        :rtype: str
        """
        return self._transfer

    @transfer.setter
    def transfer(self, transfer):
        """Sets the transfer of this DjStripeCharge.

        The transfer to the `destination` account (only applicable if the charge was created using the `destination` parameter).  # noqa: E501

        :param transfer: The transfer of this DjStripeCharge.  # noqa: E501
        :type transfer: str
        """

        self._transfer = transfer

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DjStripeCharge):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DjStripeCharge):
            return True

        return self.to_dict() != other.to_dict()
