# printnanny-api-client
Official API client library for printnanny.ai

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.131.4
- Package version: 0.131.4
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen
For more information, please visit [https://printnanny.ai](https://printnanny.ai)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import printnanny_api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import printnanny_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import printnanny_api_client
from printnanny_api_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = printnanny_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'

# Configure Bearer authorization: tokenAuth
configuration = printnanny_api_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with printnanny_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = printnanny_api_client.AccountsApi(api_client)
    email_auth_request = printnanny_api_client.EmailAuthRequest() # EmailAuthRequest | 

    try:
        api_response = api_instance.accounts2fa_auth_email_create(email_auth_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccountsApi->accounts2fa_auth_email_create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountsApi* | [**accounts2fa_auth_email_create**](docs/AccountsApi.md#accounts2fa_auth_email_create) | **POST** /accounts/2fa-auth/email/ | 
*AccountsApi* | [**accounts2fa_auth_session_create**](docs/AccountsApi.md#accounts2fa_auth_session_create) | **POST** /accounts/2fa-auth/session/ | 
*AccountsApi* | [**accounts2fa_auth_token_create**](docs/AccountsApi.md#accounts2fa_auth_token_create) | **POST** /accounts/2fa-auth/token/ | 
*AccountsApi* | [**accounts_email_waitlist_create**](docs/AccountsApi.md#accounts_email_waitlist_create) | **POST** /api/accounts/email-waitlist/ | 
*AccountsApi* | [**accounts_login_create**](docs/AccountsApi.md#accounts_login_create) | **POST** /api/accounts/login/ | 
*AccountsApi* | [**accounts_logout_create**](docs/AccountsApi.md#accounts_logout_create) | **POST** /api/accounts/logout/ | 
*AccountsApi* | [**accounts_password_change_create**](docs/AccountsApi.md#accounts_password_change_create) | **POST** /api/accounts/password/change/ | 
*AccountsApi* | [**accounts_password_reset_confirm_create**](docs/AccountsApi.md#accounts_password_reset_confirm_create) | **POST** /api/accounts/password/reset/confirm/ | 
*AccountsApi* | [**accounts_password_reset_create**](docs/AccountsApi.md#accounts_password_reset_create) | **POST** /api/accounts/password/reset/ | 
*AccountsApi* | [**accounts_registration_create**](docs/AccountsApi.md#accounts_registration_create) | **POST** /api/accounts/registration/ | 
*AccountsApi* | [**accounts_registration_resend_email_create**](docs/AccountsApi.md#accounts_registration_resend_email_create) | **POST** /api/accounts/registration/resend-email/ | 
*AccountsApi* | [**accounts_registration_verify_email_create**](docs/AccountsApi.md#accounts_registration_verify_email_create) | **POST** /api/accounts/registration/verify-email/ | 
*AccountsApi* | [**accounts_user_nkey_retrieve**](docs/AccountsApi.md#accounts_user_nkey_retrieve) | **GET** /api/accounts/user/nkey | 
*AccountsApi* | [**accounts_user_partial_update**](docs/AccountsApi.md#accounts_user_partial_update) | **PATCH** /api/accounts/user/ | 
*AccountsApi* | [**accounts_user_retrieve**](docs/AccountsApi.md#accounts_user_retrieve) | **GET** /api/accounts/user/ | 
*AccountsApi* | [**accounts_user_update**](docs/AccountsApi.md#accounts_user_update) | **PUT** /api/accounts/user/ | 
*AchievementsApi* | [**achievements_list**](docs/AchievementsApi.md#achievements_list) | **GET** /api/achievements/ | 
*AlertsApi* | [**alert_settings_email_create**](docs/AlertsApi.md#alert_settings_email_create) | **POST** /api/alert-settings/email/ | 
*AlertsApi* | [**alert_settings_email_list**](docs/AlertsApi.md#alert_settings_email_list) | **GET** /api/alert-settings/email/ | 
*AlertsApi* | [**alert_settings_email_partial_update**](docs/AlertsApi.md#alert_settings_email_partial_update) | **PATCH** /api/alert-settings/email/{id}/ | 
*AlertsApi* | [**alert_settings_email_retrieve**](docs/AlertsApi.md#alert_settings_email_retrieve) | **GET** /api/alert-settings/email/{id}/ | 
*AlertsApi* | [**alert_settings_email_update**](docs/AlertsApi.md#alert_settings_email_update) | **PUT** /api/alert-settings/email/{id}/ | 
*AlertsApi* | [**alerts_print_job_create**](docs/AlertsApi.md#alerts_print_job_create) | **POST** /api/alerts/print-job/ | 
*AlertsApi* | [**alerts_print_job_list**](docs/AlertsApi.md#alerts_print_job_list) | **GET** /api/alerts/print-job/ | 
*AlertsApi* | [**alerts_print_job_partial_update**](docs/AlertsApi.md#alerts_print_job_partial_update) | **PATCH** /api/alerts/print-job/{id}/ | 
*AlertsApi* | [**alerts_print_job_retrieve**](docs/AlertsApi.md#alerts_print_job_retrieve) | **GET** /api/alerts/print-job/{id}/ | 
*AlertsApi* | [**alerts_print_job_update**](docs/AlertsApi.md#alerts_print_job_update) | **PUT** /api/alerts/print-job/{id}/ | 
*CrashReportsApi* | [**crash_reports_create**](docs/CrashReportsApi.md#crash_reports_create) | **POST** /api/crash-reports/ | 
*CrashReportsApi* | [**crash_reports_list**](docs/CrashReportsApi.md#crash_reports_list) | **GET** /api/crash-reports/ | 
*CrashReportsApi* | [**crash_reports_partial_update**](docs/CrashReportsApi.md#crash_reports_partial_update) | **PATCH** /api/crash-reports/{id}/ | 
*CrashReportsApi* | [**crash_reports_retrieve**](docs/CrashReportsApi.md#crash_reports_retrieve) | **GET** /api/crash-reports/{id}/ | 
*CrashReportsApi* | [**crash_reports_update**](docs/CrashReportsApi.md#crash_reports_update) | **PUT** /api/crash-reports/{id}/ | 
*DevicesApi* | [**network_settings_create**](docs/DevicesApi.md#network_settings_create) | **POST** /api/network-settings/ | 
*DevicesApi* | [**network_settings_partial_update**](docs/DevicesApi.md#network_settings_partial_update) | **PATCH** /api/network-settings/{id} | 
*DevicesApi* | [**network_settings_retrieve**](docs/DevicesApi.md#network_settings_retrieve) | **GET** /api/network-settings/ | 
*DevicesApi* | [**network_settings_update**](docs/DevicesApi.md#network_settings_update) | **PUT** /api/network-settings/{id} | 
*DevicesApi* | [**pi_update_or_create**](docs/DevicesApi.md#pi_update_or_create) | **POST** /api/pis/update-or-create/ | 
*DevicesApi* | [**pis_create**](docs/DevicesApi.md#pis_create) | **POST** /api/pis/ | 
*DevicesApi* | [**pis_destroy**](docs/DevicesApi.md#pis_destroy) | **DELETE** /api/pis/{id}/ | 
*DevicesApi* | [**pis_license_zip_retrieve**](docs/DevicesApi.md#pis_license_zip_retrieve) | **GET** /api/pis/{pi_id}/license/zip/ | 
*DevicesApi* | [**pis_list**](docs/DevicesApi.md#pis_list) | **GET** /api/pis/ | 
*DevicesApi* | [**pis_partial_update**](docs/DevicesApi.md#pis_partial_update) | **PATCH** /api/pis/{id}/ | 
*DevicesApi* | [**pis_retrieve**](docs/DevicesApi.md#pis_retrieve) | **GET** /api/pis/{id}/ | 
*DevicesApi* | [**pis_system_info_create**](docs/DevicesApi.md#pis_system_info_create) | **POST** /api/pis/{pi_id}/system-info/ | 
*DevicesApi* | [**pis_system_info_list**](docs/DevicesApi.md#pis_system_info_list) | **GET** /api/pis/{pi_id}/system-info/ | 
*DevicesApi* | [**pis_system_info_partial_update**](docs/DevicesApi.md#pis_system_info_partial_update) | **PATCH** /api/pis/{pi_id}/system-info/{id}/ | 
*DevicesApi* | [**pis_system_info_retrieve**](docs/DevicesApi.md#pis_system_info_retrieve) | **GET** /api/pis/{pi_id}/system-info/{id}/ | 
*DevicesApi* | [**pis_system_info_update**](docs/DevicesApi.md#pis_system_info_update) | **PUT** /api/pis/{pi_id}/system-info/{id}/ | 
*DevicesApi* | [**pis_update**](docs/DevicesApi.md#pis_update) | **PUT** /api/pis/{id}/ | 
*DevicesApi* | [**pis_webrtc_streams_create**](docs/DevicesApi.md#pis_webrtc_streams_create) | **POST** /api/pis/{pi_id}/webrtc-streams/ | 
*DevicesApi* | [**pis_webrtc_streams_list**](docs/DevicesApi.md#pis_webrtc_streams_list) | **GET** /api/pis/{pi_id}/webrtc-streams/ | 
*DevicesApi* | [**pis_webrtc_streams_partial_update**](docs/DevicesApi.md#pis_webrtc_streams_partial_update) | **PATCH** /api/pis/{pi_id}/webrtc-streams/{id}/ | 
*DevicesApi* | [**pis_webrtc_streams_retrieve**](docs/DevicesApi.md#pis_webrtc_streams_retrieve) | **GET** /api/pis/{pi_id}/webrtc-streams/{id}/ | 
*DevicesApi* | [**pis_webrtc_streams_update**](docs/DevicesApi.md#pis_webrtc_streams_update) | **PUT** /api/pis/{pi_id}/webrtc-streams/{id}/ | 
*DevicesApi* | [**system_info_update_or_create**](docs/DevicesApi.md#system_info_update_or_create) | **POST** /api/pis/{pi_id}/system-info/update-or-create/ | 
*DevicesApi* | [**webrtc_stream_update_or_create**](docs/DevicesApi.md#webrtc_stream_update_or_create) | **POST** /api/pis/{pi_id}/webrtc-streams/update-or-create/ | 
*JanusApi* | [**pis_webrtc_streams_create**](docs/JanusApi.md#pis_webrtc_streams_create) | **POST** /api/pis/{pi_id}/webrtc-streams/ | 
*JanusApi* | [**pis_webrtc_streams_list**](docs/JanusApi.md#pis_webrtc_streams_list) | **GET** /api/pis/{pi_id}/webrtc-streams/ | 
*JanusApi* | [**pis_webrtc_streams_partial_update**](docs/JanusApi.md#pis_webrtc_streams_partial_update) | **PATCH** /api/pis/{pi_id}/webrtc-streams/{id}/ | 
*JanusApi* | [**pis_webrtc_streams_retrieve**](docs/JanusApi.md#pis_webrtc_streams_retrieve) | **GET** /api/pis/{pi_id}/webrtc-streams/{id}/ | 
*JanusApi* | [**pis_webrtc_streams_update**](docs/JanusApi.md#pis_webrtc_streams_update) | **PUT** /api/pis/{pi_id}/webrtc-streams/{id}/ | 
*MoonrakerApi* | [**moonraker_create**](docs/MoonrakerApi.md#moonraker_create) | **POST** /api/moonraker/ | 
*MoonrakerApi* | [**moonraker_list**](docs/MoonrakerApi.md#moonraker_list) | **GET** /api/moonraker/ | 
*MoonrakerApi* | [**moonraker_partial_update**](docs/MoonrakerApi.md#moonraker_partial_update) | **PATCH** /api/moonraker/{id}/ | 
*MoonrakerApi* | [**moonraker_retrieve**](docs/MoonrakerApi.md#moonraker_retrieve) | **GET** /api/moonraker/{id}/ | 
*MoonrakerApi* | [**moonraker_server_update_or_create**](docs/MoonrakerApi.md#moonraker_server_update_or_create) | **POST** /api/moonraker/update-or-create/ | 
*MoonrakerApi* | [**moonraker_update**](docs/MoonrakerApi.md#moonraker_update) | **PUT** /api/moonraker/{id}/ | 
*MoonrakerApi* | [**pis_moonraker_server_list**](docs/MoonrakerApi.md#pis_moonraker_server_list) | **GET** /api/pis/{pi_id}/moonraker-server/ | 
*OctoprintApi* | [**octoprint_backups_create**](docs/OctoprintApi.md#octoprint_backups_create) | **POST** /api/octoprint/backups/ | 
*OctoprintApi* | [**octoprint_backups_list**](docs/OctoprintApi.md#octoprint_backups_list) | **GET** /api/octoprint/backups/ | 
*OctoprintApi* | [**octoprint_backups_retrieve**](docs/OctoprintApi.md#octoprint_backups_retrieve) | **GET** /api/octoprint/backups/{id}/ | 
*OctoprintApi* | [**octoprint_create**](docs/OctoprintApi.md#octoprint_create) | **POST** /api/octoprint/ | 
*OctoprintApi* | [**octoprint_gcode_files_create**](docs/OctoprintApi.md#octoprint_gcode_files_create) | **POST** /api/octoprint/gcode-files/ | 
*OctoprintApi* | [**octoprint_gcode_files_list**](docs/OctoprintApi.md#octoprint_gcode_files_list) | **GET** /api/octoprint/gcode-files/ | 
*OctoprintApi* | [**octoprint_gcode_files_retrieve**](docs/OctoprintApi.md#octoprint_gcode_files_retrieve) | **GET** /api/octoprint/gcode-files/{id}/ | 
*OctoprintApi* | [**octoprint_list**](docs/OctoprintApi.md#octoprint_list) | **GET** /api/octoprint/ | 
*OctoprintApi* | [**octoprint_partial_update**](docs/OctoprintApi.md#octoprint_partial_update) | **PATCH** /api/octoprint/{id}/ | 
*OctoprintApi* | [**octoprint_printer_profiles_create**](docs/OctoprintApi.md#octoprint_printer_profiles_create) | **POST** /api/octoprint/printer-profiles/ | 
*OctoprintApi* | [**octoprint_printer_profiles_list**](docs/OctoprintApi.md#octoprint_printer_profiles_list) | **GET** /api/octoprint/printer-profiles/ | 
*OctoprintApi* | [**octoprint_printer_profiles_partial_update**](docs/OctoprintApi.md#octoprint_printer_profiles_partial_update) | **PATCH** /api/octoprint/printer-profiles/{id}/ | 
*OctoprintApi* | [**octoprint_printer_profiles_update**](docs/OctoprintApi.md#octoprint_printer_profiles_update) | **PUT** /api/octoprint/printer-profiles/{id}/ | 
*OctoprintApi* | [**octoprint_profile_update_or_create**](docs/OctoprintApi.md#octoprint_profile_update_or_create) | **POST** /api/octoprint/printer-profiles/update-or-create/ | 
*OctoprintApi* | [**octoprint_server_update_or_create**](docs/OctoprintApi.md#octoprint_server_update_or_create) | **POST** /api/octoprint/update-or-create/ | 
*OctoprintApi* | [**octoprint_settings_create**](docs/OctoprintApi.md#octoprint_settings_create) | **POST** /api/octoprint/settings/ | 
*OctoprintApi* | [**octoprint_settings_list**](docs/OctoprintApi.md#octoprint_settings_list) | **GET** /api/octoprint/settings/ | 
*OctoprintApi* | [**octoprint_settings_partial_update**](docs/OctoprintApi.md#octoprint_settings_partial_update) | **PATCH** /api/octoprint/settings/{id}/ | 
*OctoprintApi* | [**octoprint_settings_update**](docs/OctoprintApi.md#octoprint_settings_update) | **PUT** /api/octoprint/settings/{id}/ | 
*OctoprintApi* | [**octoprint_settings_update_or_create**](docs/OctoprintApi.md#octoprint_settings_update_or_create) | **POST** /api/octoprint/settings/update-or-create/ | 
*OctoprintApi* | [**octoprint_update**](docs/OctoprintApi.md#octoprint_update) | **PUT** /api/octoprint/{id}/ | 
*OctoprintApi* | [**pis_octoprint_server_list**](docs/OctoprintApi.md#pis_octoprint_server_list) | **GET** /api/pis/{pi_id}/octoprint-server/ | 
*SchemaApi* | [**schema_retrieve**](docs/SchemaApi.md#schema_retrieve) | **GET** /api/schema/ | 
*SettingsApi* | [**alert_settings_email_create**](docs/SettingsApi.md#alert_settings_email_create) | **POST** /api/alert-settings/email/ | 
*SettingsApi* | [**alert_settings_email_list**](docs/SettingsApi.md#alert_settings_email_list) | **GET** /api/alert-settings/email/ | 
*SettingsApi* | [**alert_settings_email_partial_update**](docs/SettingsApi.md#alert_settings_email_partial_update) | **PATCH** /api/alert-settings/email/{id}/ | 
*SettingsApi* | [**alert_settings_email_retrieve**](docs/SettingsApi.md#alert_settings_email_retrieve) | **GET** /api/alert-settings/email/{id}/ | 
*SettingsApi* | [**alert_settings_email_update**](docs/SettingsApi.md#alert_settings_email_update) | **PUT** /api/alert-settings/email/{id}/ | 
*ShopApi* | [**cloud_plans_retrieve**](docs/ShopApi.md#cloud_plans_retrieve) | **GET** /api/shop/products/cloud-plans/ | 
*ShopApi* | [**shop_checkout_success_retrieve**](docs/ShopApi.md#shop_checkout_success_retrieve) | **GET** /api/shop/checkout/success/{stripe_checkout_session_id} | 
*ShopApi* | [**shop_orders_create**](docs/ShopApi.md#shop_orders_create) | **POST** /api/shop/orders | 
*ShopApi* | [**shop_products_list**](docs/ShopApi.md#shop_products_list) | **GET** /api/shop/products/ | 
*VideosApi* | [**video_parts_create**](docs/VideosApi.md#video_parts_create) | **POST** /api/video-parts/ | 
*VideosApi* | [**video_parts_list**](docs/VideosApi.md#video_parts_list) | **GET** /api/video-parts/ | 
*VideosApi* | [**video_parts_retrieve**](docs/VideosApi.md#video_parts_retrieve) | **GET** /api/video-parts/{id}/ | 
*VideosApi* | [**video_recordings_finalize**](docs/VideosApi.md#video_recordings_finalize) | **POST** /api/videos/{id}/finalize/ | 
*VideosApi* | [**video_recordings_update_or_create**](docs/VideosApi.md#video_recordings_update_or_create) | **POST** /api/videos/{id}/update-or-create/ | 
*VideosApi* | [**videos_create**](docs/VideosApi.md#videos_create) | **POST** /api/videos/ | 
*VideosApi* | [**videos_list**](docs/VideosApi.md#videos_list) | **GET** /api/videos/ | 
*VideosApi* | [**videos_partial_update**](docs/VideosApi.md#videos_partial_update) | **PATCH** /api/videos/{id}/ | 
*VideosApi* | [**videos_retrieve**](docs/VideosApi.md#videos_retrieve) | **GET** /api/videos/{id}/ | 
*VideosApi* | [**videos_update**](docs/VideosApi.md#videos_update) | **PUT** /api/videos/{id}/ | 


## Documentation For Models

 - [Achievement](docs/Achievement.md)
 - [AchievementTypeEnum](docs/AchievementTypeEnum.md)
 - [CallbackTokenAuth](docs/CallbackTokenAuth.md)
 - [CallbackTokenAuthRequest](docs/CallbackTokenAuthRequest.md)
 - [CrashReport](docs/CrashReport.md)
 - [CrashReportStatusEnum](docs/CrashReportStatusEnum.md)
 - [DjStripeCharge](docs/DjStripeCharge.md)
 - [DjStripeCheckoutSession](docs/DjStripeCheckoutSession.md)
 - [DjStripeCustomer](docs/DjStripeCustomer.md)
 - [DjStripePaymentIntent](docs/DjStripePaymentIntent.md)
 - [DjStripePrice](docs/DjStripePrice.md)
 - [DjStripeProduct](docs/DjStripeProduct.md)
 - [EmailAlertSettings](docs/EmailAlertSettings.md)
 - [EmailAlertSettingsRequest](docs/EmailAlertSettingsRequest.md)
 - [EmailAuth](docs/EmailAuth.md)
 - [EmailAuthRequest](docs/EmailAuthRequest.md)
 - [EmailWaitlist](docs/EmailWaitlist.md)
 - [EmailWaitlistRequest](docs/EmailWaitlistRequest.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [EventSourceEnum](docs/EventSourceEnum.md)
 - [EventTypeEnum](docs/EventTypeEnum.md)
 - [EventTypesEnum](docs/EventTypesEnum.md)
 - [GcodeFile](docs/GcodeFile.md)
 - [JanusConfigType](docs/JanusConfigType.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [MoonrakerServer](docs/MoonrakerServer.md)
 - [MoonrakerServerRequest](docs/MoonrakerServerRequest.md)
 - [NatsOrganization](docs/NatsOrganization.md)
 - [NatsOrganizationRequest](docs/NatsOrganizationRequest.md)
 - [NatsOrganizationUser](docs/NatsOrganizationUser.md)
 - [NetworkSettings](docs/NetworkSettings.md)
 - [NetworkSettingsRequest](docs/NetworkSettingsRequest.md)
 - [OctoPrintBackup](docs/OctoPrintBackup.md)
 - [OctoPrintServer](docs/OctoPrintServer.md)
 - [OctoPrintServerRequest](docs/OctoPrintServerRequest.md)
 - [OctoPrintSettings](docs/OctoPrintSettings.md)
 - [OctoPrintSettingsRequest](docs/OctoPrintSettingsRequest.md)
 - [OctoPrinterProfile](docs/OctoPrinterProfile.md)
 - [OctoPrinterProfileRequest](docs/OctoPrinterProfileRequest.md)
 - [Order](docs/Order.md)
 - [OrderCheckout](docs/OrderCheckout.md)
 - [OrderCheckoutRequest](docs/OrderCheckoutRequest.md)
 - [OrderItem](docs/OrderItem.md)
 - [OrderItemRequest](docs/OrderItemRequest.md)
 - [OrderStatus](docs/OrderStatus.md)
 - [OrderStatusType](docs/OrderStatusType.md)
 - [PaginatedAchievementList](docs/PaginatedAchievementList.md)
 - [PaginatedCrashReportList](docs/PaginatedCrashReportList.md)
 - [PaginatedEmailAlertSettingsList](docs/PaginatedEmailAlertSettingsList.md)
 - [PaginatedGcodeFileList](docs/PaginatedGcodeFileList.md)
 - [PaginatedMoonrakerServerList](docs/PaginatedMoonrakerServerList.md)
 - [PaginatedOctoPrintBackupList](docs/PaginatedOctoPrintBackupList.md)
 - [PaginatedOctoPrintServerList](docs/PaginatedOctoPrintServerList.md)
 - [PaginatedOctoPrintSettingsList](docs/PaginatedOctoPrintSettingsList.md)
 - [PaginatedOctoPrinterProfileList](docs/PaginatedOctoPrinterProfileList.md)
 - [PaginatedPiList](docs/PaginatedPiList.md)
 - [PaginatedPrintJobAlertList](docs/PaginatedPrintJobAlertList.md)
 - [PaginatedProductList](docs/PaginatedProductList.md)
 - [PaginatedSystemInfoList](docs/PaginatedSystemInfoList.md)
 - [PaginatedVideoRecordingList](docs/PaginatedVideoRecordingList.md)
 - [PaginatedVideoRecordingPartList](docs/PaginatedVideoRecordingPartList.md)
 - [PaginatedWebrtcStreamList](docs/PaginatedWebrtcStreamList.md)
 - [PasswordChangeRequest](docs/PasswordChangeRequest.md)
 - [PasswordResetConfirmRequest](docs/PasswordResetConfirmRequest.md)
 - [PasswordResetRequest](docs/PasswordResetRequest.md)
 - [PatchedEmailAlertSettingsRequest](docs/PatchedEmailAlertSettingsRequest.md)
 - [PatchedMoonrakerServerRequest](docs/PatchedMoonrakerServerRequest.md)
 - [PatchedNetworkSettingsRequest](docs/PatchedNetworkSettingsRequest.md)
 - [PatchedOctoPrintServerRequest](docs/PatchedOctoPrintServerRequest.md)
 - [PatchedOctoPrintSettingsRequest](docs/PatchedOctoPrintSettingsRequest.md)
 - [PatchedOctoPrinterProfileRequest](docs/PatchedOctoPrinterProfileRequest.md)
 - [PatchedPiRequest](docs/PatchedPiRequest.md)
 - [PatchedSystemInfoRequest](docs/PatchedSystemInfoRequest.md)
 - [PatchedUserRequest](docs/PatchedUserRequest.md)
 - [PatchedVideoRecordingRequest](docs/PatchedVideoRecordingRequest.md)
 - [PatchedWebrtcStreamRequest](docs/PatchedWebrtcStreamRequest.md)
 - [Pi](docs/Pi.md)
 - [PiNatsApp](docs/PiNatsApp.md)
 - [PiNatsAppRequest](docs/PiNatsAppRequest.md)
 - [PiRequest](docs/PiRequest.md)
 - [PiUrls](docs/PiUrls.md)
 - [PreferredDnsType](docs/PreferredDnsType.md)
 - [PrintJobAlert](docs/PrintJobAlert.md)
 - [Product](docs/Product.md)
 - [RegisterRequest](docs/RegisterRequest.md)
 - [ResendEmailVerificationRequest](docs/ResendEmailVerificationRequest.md)
 - [RestAuthDetail](docs/RestAuthDetail.md)
 - [SbcEnum](docs/SbcEnum.md)
 - [StripeApiErrorCode](docs/StripeApiErrorCode.md)
 - [StripeBillingScheme](docs/StripeBillingScheme.md)
 - [StripeConfirmationMethod](docs/StripeConfirmationMethod.md)
 - [StripeCustomerTaxExempt](docs/StripeCustomerTaxExempt.md)
 - [StripeIntentUsage](docs/StripeIntentUsage.md)
 - [StripePaymentIntentCancellationReason](docs/StripePaymentIntentCancellationReason.md)
 - [StripePaymentIntentStatus](docs/StripePaymentIntentStatus.md)
 - [StripePriceTiersMode](docs/StripePriceTiersMode.md)
 - [StripePriceType](docs/StripePriceType.md)
 - [StripeProductType](docs/StripeProductType.md)
 - [StripeSessionBillingAddressCollection](docs/StripeSessionBillingAddressCollection.md)
 - [StripeSessionMode](docs/StripeSessionMode.md)
 - [StripeSourceCodeVerificationStatus](docs/StripeSourceCodeVerificationStatus.md)
 - [StripeSubmitTypeStatus](docs/StripeSubmitTypeStatus.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [SystemInfoRequest](docs/SystemInfoRequest.md)
 - [Token](docs/Token.md)
 - [User](docs/User.md)
 - [UserRequest](docs/UserRequest.md)
 - [VerifyEmailRequest](docs/VerifyEmailRequest.md)
 - [VideoRecording](docs/VideoRecording.md)
 - [VideoRecordingPart](docs/VideoRecordingPart.md)
 - [VideoRecordingRequest](docs/VideoRecordingRequest.md)
 - [WebrtcStream](docs/WebrtcStream.md)
 - [WebrtcStreamRequest](docs/WebrtcStreamRequest.md)


## Documentation For Authorization


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## tokenAuth

- **Type**: Bearer authentication


## Author

leigh@printnanny.ai


