# swx_sdk
The endpoints for the authentication API.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: DRAFT
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swx_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swx_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import swx_sdk
from pprint import pprint
from swx_sdk.api import clusters_api
from swx_sdk.model.create_cluster import CreateCluster
from swx_sdk.model.create_cluster_response import CreateClusterResponse
from swx_sdk.model.delete_cluster_response import DeleteClusterResponse
from swx_sdk.model.error_response import ErrorResponse
from swx_sdk.model.list_clusters_response import ListClustersResponse
from swx_sdk.model.secret import Secret
from swx_sdk.model.show_cluster_response import ShowClusterResponse
from swx_sdk.model.update_cluster import UpdateCluster
from swx_sdk.model.update_cluster_response import UpdateClusterResponse
# Defining the host is optional and defaults to http://localhost:8080
# See configuration.py for a list of all supported configuration parameters.
configuration = swx_sdk.Configuration(
    host = "http://localhost:8080"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearerAuth
configuration = swx_sdk.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with swx_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = clusters_api.ClustersApi(api_client)
    space = "altair" # str | 
create_cluster = CreateCluster(
        description="My cluster one",
        title="cluster1",
    ) # CreateCluster | Create a new cluster in the platform

    try:
        # Add a cluster
        api_response = api_instance.create_spaces_cluster(space, create_cluster)
        pprint(api_response)
    except swx_sdk.ApiException as e:
        print("Exception when calling ClustersApi->create_spaces_cluster: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ClustersApi* | [**create_spaces_cluster**](docs/ClustersApi.md#create_spaces_cluster) | **POST** /spaces/{space}/clusters | Add a cluster
*ClustersApi* | [**delete_spaces_cluster**](docs/ClustersApi.md#delete_spaces_cluster) | **DELETE** /spaces/{space}/clusters/{cluster-id} | Delete cluster
*ClustersApi* | [**list_spaces_clusters**](docs/ClustersApi.md#list_spaces_clusters) | **GET** /spaces/{space}/clusters | List clusters
*ClustersApi* | [**reinstall_spaces_clusters_cluster**](docs/ClustersApi.md#reinstall_spaces_clusters_cluster) | **PUT** /spaces/{space}/clusters/{cluster-id}/reinstall | Regenerate configuration files
*ClustersApi* | [**reset_spaces_clusters_client_secret**](docs/ClustersApi.md#reset_spaces_clusters_client_secret) | **POST** /spaces/{space}/clusters/{cluster-id}/reset-secret | Reset Client Secret
*ClustersApi* | [**show_spaces_cluster**](docs/ClustersApi.md#show_spaces_cluster) | **GET** /spaces/{space}/clusters/{cluster-id} | Show cluster
*ClustersApi* | [**update_spaces_cluster**](docs/ClustersApi.md#update_spaces_cluster) | **PUT** /spaces/{space}/clusters/{cluster-id} | Update cluster
*DataApi* | [**create_spaces_data**](docs/DataApi.md#create_spaces_data) | **POST** /spaces/{space}/data | Create data
*DataApi* | [**delete_spaces_data**](docs/DataApi.md#delete_spaces_data) | **DELETE** /spaces/{space}/data/{data-id} | Delete Data
*DataApi* | [**delete_spaces_data_from_source**](docs/DataApi.md#delete_spaces_data_from_source) | **DELETE** /spaces/{space}/data | Delete Data
*DataApi* | [**list_spaces_data**](docs/DataApi.md#list_spaces_data) | **GET** /spaces/{space}/data | List Data
*DataApi* | [**show_spaces_data**](docs/DataApi.md#show_spaces_data) | **GET** /spaces/{space}/data/{data-id} | Show Data
*LabelApi* | [**create_spaces_label**](docs/LabelApi.md#create_spaces_label) | **POST** /spaces/{space}/labels | Create label
*LabelApi* | [**create_spaces_labels_label_relation**](docs/LabelApi.md#create_spaces_labels_label_relation) | **POST** /spaces/{space}/labels/{label-id}/relations | Create label relation
*LabelApi* | [**delete_spaces_label**](docs/LabelApi.md#delete_spaces_label) | **DELETE** /spaces/{space}/labels/{label-id} | Delete Label
*LabelApi* | [**delete_spaces_labels**](docs/LabelApi.md#delete_spaces_labels) | **DELETE** /spaces/{space}/labels/{label-id}/relations | Delete Label relation
*LabelApi* | [**list_spaces_label**](docs/LabelApi.md#list_spaces_label) | **GET** /spaces/{space}/labels | List Labels
*LabelApi* | [**show_spaces_label**](docs/LabelApi.md#show_spaces_label) | **GET** /spaces/{space}/labels/{label-id} | Show Label
*LabelApi* | [**show_spaces_labels_label_items**](docs/LabelApi.md#show_spaces_labels_label_items) | **GET** /spaces/{space}/labels/{label-id}/relations | Show Label Items
*LabelApi* | [**update_spaces_label**](docs/LabelApi.md#update_spaces_label) | **PUT** /spaces/{space}/labels/{label-id} | Update label
*LabeledEntitiesApi* | [**spaces_space_labeled_entities_get**](docs/LabeledEntitiesApi.md#spaces_space_labeled_entities_get) | **GET** /spaces/{space}/labeled-entities | 
*MQTTApi* | [**create_spaces_mqtt_mqtt_label_credentials**](docs/MQTTApi.md#create_spaces_mqtt_mqtt_label_credentials) | **POST** /spaces/{space}/mqtt/labels | Create MQTT credentials for a label
*MQTTApi* | [**delete_spaces_mqtt_mqtt_label**](docs/MQTTApi.md#delete_spaces_mqtt_mqtt_label) | **DELETE** /spaces/{space}/mqtt/labels/{label-id} | Delete MQTT label
*MQTTApi* | [**list_spaces_mqtt_mqt_tcredentials**](docs/MQTTApi.md#list_spaces_mqtt_mqt_tcredentials) | **GET** /spaces/{space}/mqtt/credentials | List space MQTT credentials
*MQTTApi* | [**list_spaces_mqtt_thing_mqt_tcredentials**](docs/MQTTApi.md#list_spaces_mqtt_thing_mqt_tcredentials) | **GET** /spaces/{space}/mqtt/things/{thing-id} | List Thing MQTT credentials
*MQTTApi* | [**show_spaces_mqtt_mqt_tcredentials**](docs/MQTTApi.md#show_spaces_mqtt_mqt_tcredentials) | **GET** /spaces/{space}/mqtt/credentials/{credentials-id} | Show MQTT credentials
*MQTTApi* | [**show_spaces_mqtt_mqtt_label_info**](docs/MQTTApi.md#show_spaces_mqtt_mqtt_label_info) | **GET** /spaces/{space}/mqtt/labels/{label-id} | Show MQTT label details
*MQTTApi* | [**update_spaces_mqtt_mqt_tcredentials**](docs/MQTTApi.md#update_spaces_mqtt_mqt_tcredentials) | **PUT** /spaces/{space}/mqtt/credentials/{credentials-id} | Update MQTT credentials
*MQTTApi* | [**update_spaces_mqtt_mqt_tpassword**](docs/MQTTApi.md#update_spaces_mqtt_mqt_tpassword) | **PATCH** /spaces/{space}/mqtt/credentials-username/{mqtt-username} | Update MQTT password
*MQTTApi* | [**update_spaces_mqtt_mqtt_label**](docs/MQTTApi.md#update_spaces_mqtt_mqtt_label) | **PUT** /spaces/{space}/mqtt/labels/{label-id} | Update MQTT Label
*ActionsApi* | [**add_accounts_things_action**](docs/ActionsApi.md#add_accounts_things_action) | **POST** /accounts/{account-id}/things/{thing-id}/actions/{action} | Request action
*ActionsApi* | [**add_spaces_collections_things_action**](docs/ActionsApi.md#add_spaces_collections_things_action) | **POST** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action} | Request action
*ActionsApi* | [**delete_accounts_things_action**](docs/ActionsApi.md#delete_accounts_things_action) | **DELETE** /accounts/{account-id}/things/{thing-id}/actions/{action}/{action-id} | Delete Action
*ActionsApi* | [**delete_spaces_collections_things_action**](docs/ActionsApi.md#delete_spaces_collections_things_action) | **DELETE** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id} | Delete Action
*ActionsApi* | [**list_accounts_things_actions**](docs/ActionsApi.md#list_accounts_things_actions) | **GET** /accounts/{account-id}/things/{thing-id}/actions | Lists all the action queues for a thing
*ActionsApi* | [**list_accounts_things_actions_by_name**](docs/ActionsApi.md#list_accounts_things_actions_by_name) | **GET** /accounts/{account-id}/things/{thing-id}/actions/{action} | List the queue of actions from a thing
*ActionsApi* | [**list_spaces_collections_things_actions**](docs/ActionsApi.md#list_spaces_collections_things_actions) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions | Lists all the action queues for a thing
*ActionsApi* | [**list_spaces_collections_things_actions_by_name**](docs/ActionsApi.md#list_spaces_collections_things_actions_by_name) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action} | List the queue of actions from a thing
*ActionsApi* | [**show_accounts_things_action**](docs/ActionsApi.md#show_accounts_things_action) | **GET** /accounts/{account-id}/things/{thing-id}/actions/{action}/{action-id} | Show action requested
*ActionsApi* | [**show_spaces_collections_things_action**](docs/ActionsApi.md#show_spaces_collections_things_action) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id} | Show action requested
*ActionsApi* | [**update_accounts_things_action**](docs/ActionsApi.md#update_accounts_things_action) | **PUT** /accounts/{account-id}/things/{thing-id}/actions/{action}/{action-id} | Update action inside a queue
*ActionsApi* | [**update_spaces_collections_things_action**](docs/ActionsApi.md#update_spaces_collections_things_action) | **PUT** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id} | Update action inside a queue
*AuthenticationApi* | [**login**](docs/AuthenticationApi.md#login) | **POST** /login | Log in
*AuthenticationApi* | [**refresh**](docs/AuthenticationApi.md#refresh) | **GET** /refresh | Refresh token
*ClientsApi* | [**add_cloud_connect_client**](docs/ClientsApi.md#add_cloud_connect_client) | **POST** /cloud/connect/clients | Add Client
*ClientsApi* | [**add_exports_mqtt_client**](docs/ClientsApi.md#add_exports_mqtt_client) | **POST** /exports/mqtt/clients | Add Client
*ClientsApi* | [**delete_cloud_connect_client**](docs/ClientsApi.md#delete_cloud_connect_client) | **DELETE** /cloud/connect/clients/{client_id} | Delete Client
*ClientsApi* | [**delete_exports_mqtt_client**](docs/ClientsApi.md#delete_exports_mqtt_client) | **DELETE** /exports/mqtt/clients/{client_id} | Delete Client
*ClientsApi* | [**list_cloud_connect_clients**](docs/ClientsApi.md#list_cloud_connect_clients) | **GET** /cloud/connect/clients | List Clients
*ClientsApi* | [**list_exports_mqtt_clients**](docs/ClientsApi.md#list_exports_mqtt_clients) | **GET** /exports/mqtt/clients | List Clients
*ClientsApi* | [**show_cloud_connect_client**](docs/ClientsApi.md#show_cloud_connect_client) | **GET** /cloud/connect/clients/{client_id} | Show a Client
*ClientsApi* | [**show_exports_mqtt_client**](docs/ClientsApi.md#show_exports_mqtt_client) | **GET** /exports/mqtt/clients/{client_id} | Show a Client
*ClientsApi* | [**update_cloud_connect_client**](docs/ClientsApi.md#update_cloud_connect_client) | **PUT** /cloud/connect/clients/{client_id} | Update Client
*ClientsApi* | [**update_exports_mqtt_client**](docs/ClientsApi.md#update_exports_mqtt_client) | **PUT** /exports/mqtt/clients/{client_id} | Update Client
*CollectionsApi* | [**add_spaces_collection**](docs/CollectionsApi.md#add_spaces_collection) | **POST** /spaces/{space}/collections | Create collection
*CollectionsApi* | [**delete_spaces_collection**](docs/CollectionsApi.md#delete_spaces_collection) | **DELETE** /spaces/{space}/collections/{collection-name} | Delete collection
*CollectionsApi* | [**list_spaces_collections**](docs/CollectionsApi.md#list_spaces_collections) | **GET** /spaces/{space}/collections | List collections
*CollectionsApi* | [**show_spaces_collection**](docs/CollectionsApi.md#show_spaces_collection) | **GET** /spaces/{space}/collections/{collection-name} | Show collection
*CollectionsApi* | [**update_spaces_collection**](docs/CollectionsApi.md#update_spaces_collection) | **PUT** /spaces/{space}/collections/{collection-name} | Update collection
*DiscoveryApi* | [**delete_reports_discovery**](docs/DiscoveryApi.md#delete_reports_discovery) | **DELETE** /reports/discovery/{discovery_type}/{report_id} | Delete Discovery Report
*DiscoveryApi* | [**list_reports_discoveries**](docs/DiscoveryApi.md#list_reports_discoveries) | **GET** /reports/discovery | List history of request for all Discovery Reports
*DiscoveryApi* | [**list_reports_discoveries_by_type**](docs/DiscoveryApi.md#list_reports_discoveries_by_type) | **GET** /reports/discovery/{discovery_type} | List history of requests for a Discovery Report
*DiscoveryApi* | [**list_reports_discovery_discovery_uploads**](docs/DiscoveryApi.md#list_reports_discovery_discovery_uploads) | **GET** /reports/discovery/{discovery_type}/{report_id}/uploads | List Discovery Report Uploads
*DiscoveryApi* | [**request_reports_discovery**](docs/DiscoveryApi.md#request_reports_discovery) | **POST** /reports/discovery/{discovery_type} | Request a Discovery Report
*DiscoveryApi* | [**retrieve_reports_discovery_discovery_upload**](docs/DiscoveryApi.md#retrieve_reports_discovery_discovery_upload) | **GET** /reports/discovery/{discovery_type}/{report_id}/uploads/{upload_id} | Retrieve Discovery Report Upload Content
*DiscoveryApi* | [**show_reports_discovery**](docs/DiscoveryApi.md#show_reports_discovery) | **GET** /reports/discovery/{discovery_type}/{report_id} | Show Discovery Report
*DiscoveryApi* | [**update_reports_action**](docs/DiscoveryApi.md#update_reports_action) | **PUT** /reports/discovery/{discovery_type}/{report_id} | Update a request for a Discovery Report
*EventsApi* | [**add_accounts_things_event**](docs/EventsApi.md#add_accounts_things_event) | **POST** /accounts/{account-id}/things/{thing-id}/events/{event} | Add event
*EventsApi* | [**add_spaces_collections_things_event**](docs/EventsApi.md#add_spaces_collections_things_event) | **POST** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events/{event} | Add event
*EventsApi* | [**list_accounts_things_events**](docs/EventsApi.md#list_accounts_things_events) | **GET** /accounts/{account-id}/things/{thing-id}/events | List history of all events
*EventsApi* | [**list_accounts_things_events_by_name**](docs/EventsApi.md#list_accounts_things_events_by_name) | **GET** /accounts/{account-id}/things/{thing-id}/events/{event} | List history of one type of event
*EventsApi* | [**list_spaces_collections_things_events**](docs/EventsApi.md#list_spaces_collections_things_events) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events | List history of all events
*EventsApi* | [**list_spaces_collections_things_events_by_name**](docs/EventsApi.md#list_spaces_collections_things_events_by_name) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events/{event} | List history of one type of event
*EventsApi* | [**show_accounts_things_event**](docs/EventsApi.md#show_accounts_things_event) | **GET** /accounts/{account-id}/things/{thing-id}/events/{event}/{event-id} | Show event
*EventsApi* | [**show_spaces_collections_things_event**](docs/EventsApi.md#show_spaces_collections_things_event) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events/{event}/{event-id} | Show event
*HealthApi* | [**list_health_health**](docs/HealthApi.md#list_health_health) | **GET** /health/services | List health status of services
*HealthApi* | [**show_health_health**](docs/HealthApi.md#show_health_health) | **GET** /health/services/{service_key} | Show health status of a service
*LabelsApi* | [**add_support_label**](docs/LabelsApi.md#add_support_label) | **POST** /support/labels | Add Label
*LabelsApi* | [**delete_support_label**](docs/LabelsApi.md#delete_support_label) | **DELETE** /support/labels/{label_id} | Delete Label
*LabelsApi* | [**list_support_labels**](docs/LabelsApi.md#list_support_labels) | **GET** /support/labels | List Labels
*LabelsApi* | [**show_support_label**](docs/LabelsApi.md#show_support_label) | **GET** /support/labels/{label_id} | Show a Label
*LabelsApi* | [**update_support_label**](docs/LabelsApi.md#update_support_label) | **PUT** /support/labels/{label_id} | Update Label
*LoggingApi* | [**update_logging_logging**](docs/LoggingApi.md#update_logging_logging) | **PUT** /logging/services/{service_key} | Update the minimum log level
*MappingsApi* | [**add_support_labels_label_thing_property_mapping**](docs/MappingsApi.md#add_support_labels_label_thing_property_mapping) | **POST** /support/labels/{label_id}/mappings | Add Label to Thing property mappings
*MappingsApi* | [**delete_support_labels_label_thing_property_mapping**](docs/MappingsApi.md#delete_support_labels_label_thing_property_mapping) | **DELETE** /support/labels/{label_id}/mappings/{property_label_id} | Delete Label to Thing property mapping
*MappingsApi* | [**list_support_labels_label_thing_property_mappings**](docs/MappingsApi.md#list_support_labels_label_thing_property_mappings) | **GET** /support/labels/{label_id}/mappings | List Label to Thing property mappings
*MappingsApi* | [**show_support_labels_label_thing_property_mapping**](docs/MappingsApi.md#show_support_labels_label_thing_property_mapping) | **GET** /support/labels/{label_id}/mappings/{property_label_id} | Show Label to Thing property mapping
*MessageTemplatesApi* | [**add_exports_mqtt_message_template**](docs/MessageTemplatesApi.md#add_exports_mqtt_message_template) | **POST** /exports/mqtt/messageTemplates | Add MessageTemplate
*MessageTemplatesApi* | [**delete_exports_mqtt_message_template**](docs/MessageTemplatesApi.md#delete_exports_mqtt_message_template) | **DELETE** /exports/mqtt/messageTemplates/{template_id} | Delete MessageTemplate
*MessageTemplatesApi* | [**list_exports_mqtt_message_templates**](docs/MessageTemplatesApi.md#list_exports_mqtt_message_templates) | **GET** /exports/mqtt/messageTemplates | List MessageTemplates
*MessageTemplatesApi* | [**show_exports_mqtt_message_template**](docs/MessageTemplatesApi.md#show_exports_mqtt_message_template) | **GET** /exports/mqtt/messageTemplates/{template_id} | Show a MessageTemplate
*MessageTemplatesApi* | [**update_exports_mqtt_message_template**](docs/MessageTemplatesApi.md#update_exports_mqtt_message_template) | **PUT** /exports/mqtt/messageTemplates/{template_id} | Update MessageTemplate
*ModelVersionsApi* | [**add_spaces_collections_models_version**](docs/ModelVersionsApi.md#add_spaces_collections_models_version) | **POST** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions | Create version
*ModelVersionsApi* | [**delete_spaces_collections_models_version**](docs/ModelVersionsApi.md#delete_spaces_collections_models_version) | **DELETE** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name} | Delete version
*ModelVersionsApi* | [**list_spaces_collections_models_version**](docs/ModelVersionsApi.md#list_spaces_collections_models_version) | **GET** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions | List version
*ModelVersionsApi* | [**show_spaces_collections_models_version**](docs/ModelVersionsApi.md#show_spaces_collections_models_version) | **GET** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name} | Show version
*ModelVersionsApi* | [**update_spaces_collections_models_version**](docs/ModelVersionsApi.md#update_spaces_collections_models_version) | **PUT** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name} | Update version
*ModelsApi* | [**add_spaces_collections_model**](docs/ModelsApi.md#add_spaces_collections_model) | **POST** /spaces/{space}/collections/{collection-name}/models | Create model
*ModelsApi* | [**delete_spaces_collections_model**](docs/ModelsApi.md#delete_spaces_collections_model) | **DELETE** /spaces/{space}/collections/{collection-name}/models/{model-name} | Delete model
*ModelsApi* | [**list_spaces_collections_models**](docs/ModelsApi.md#list_spaces_collections_models) | **GET** /spaces/{space}/collections/{collection-name}/models | List models
*ModelsApi* | [**show_spaces_collections_model**](docs/ModelsApi.md#show_spaces_collections_model) | **GET** /spaces/{space}/collections/{collection-name}/models/{model-name} | Show model
*ModelsApi* | [**update_spaces_collections_model**](docs/ModelsApi.md#update_spaces_collections_model) | **PUT** /spaces/{space}/collections/{collection-name}/models/{model-name} | Update model
*PropertiesApi* | [**list_accounts_things_properties**](docs/PropertiesApi.md#list_accounts_things_properties) | **GET** /accounts/{account-id}/things/{thing-id}/properties | List properties
*PropertiesApi* | [**list_spaces_collections_things_properties**](docs/PropertiesApi.md#list_spaces_collections_things_properties) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/properties | List properties
*PropertiesApi* | [**show_accounts_things_property**](docs/PropertiesApi.md#show_accounts_things_property) | **GET** /accounts/{account-id}/things/{thing-id}/properties/{property} | Show property
*PropertiesApi* | [**show_spaces_collections_things_property**](docs/PropertiesApi.md#show_spaces_collections_things_property) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/properties/{property} | Show property
*PropertiesApi* | [**update_accounts_things_property**](docs/PropertiesApi.md#update_accounts_things_property) | **PUT** /accounts/{account-id}/things/{thing-id}/properties/{property} | Update property
*PropertiesApi* | [**update_spaces_collections_things_property**](docs/PropertiesApi.md#update_spaces_collections_things_property) | **PUT** /spaces/{space}/collections/{collection-name}/things/{thing-id}/properties/{property} | Update property
*PublishersApi* | [**add_exports_mqtt_publisher**](docs/PublishersApi.md#add_exports_mqtt_publisher) | **POST** /exports/mqtt/publishers | Add Publisher
*PublishersApi* | [**delete_exports_mqtt_publisher**](docs/PublishersApi.md#delete_exports_mqtt_publisher) | **DELETE** /exports/mqtt/publishers/{publisher_id} | Delete Publisher
*PublishersApi* | [**list_exports_mqtt_publishers**](docs/PublishersApi.md#list_exports_mqtt_publishers) | **GET** /exports/mqtt/publishers | List Publishers
*PublishersApi* | [**show_exports_mqtt_publisher**](docs/PublishersApi.md#show_exports_mqtt_publisher) | **GET** /exports/mqtt/publishers/{publisher_id} | Show a Publisher
*PublishersApi* | [**update_exports_mqtt_publisher**](docs/PublishersApi.md#update_exports_mqtt_publisher) | **PUT** /exports/mqtt/publishers/{publisher_id} | Update Publisher
*SmartworksApi* | [**delete_support_smartworks_thing_connections**](docs/SmartworksApi.md#delete_support_smartworks_thing_connections) | **DELETE** /support/smartworks/thingConnections/{thing_id} | Delete MQTT subscribers and publishers for SmartWorks Sync
*SmartworksApi* | [**setup_support_smartworks_thing_connections**](docs/SmartworksApi.md#setup_support_smartworks_thing_connections) | **PUT** /support/smartworks/thingConnections/{thing_id} | Set up (create or update) MQTT subscribers and publishers for SmartWorks Sync
*SubscribersApi* | [**add_cloud_connect_subscriber**](docs/SubscribersApi.md#add_cloud_connect_subscriber) | **POST** /cloud/connect/subscribers | Add Subscriber
*SubscribersApi* | [**delete_cloud_connect_subscriber**](docs/SubscribersApi.md#delete_cloud_connect_subscriber) | **DELETE** /cloud/connect/subscribers/{subscriber_id} | Delete Subscriber
*SubscribersApi* | [**list_cloud_connect_subscribers**](docs/SubscribersApi.md#list_cloud_connect_subscribers) | **GET** /cloud/connect/subscribers | List Subscribers
*SubscribersApi* | [**show_cloud_connect_subscriber**](docs/SubscribersApi.md#show_cloud_connect_subscriber) | **GET** /cloud/connect/subscribers/{subscriber_id} | Show a Subscriber
*SubscribersApi* | [**update_cloud_connect_subscriber**](docs/SubscribersApi.md#update_cloud_connect_subscriber) | **PUT** /cloud/connect/subscribers/{subscriber_id} | Update Subscriber
*ThingsApi* | [**add_accounts_thing**](docs/ThingsApi.md#add_accounts_thing) | **POST** /accounts/{account-id}/things | Add a thing description
*ThingsApi* | [**add_exports_mqtt_publishers_publisher_thing_mapping**](docs/ThingsApi.md#add_exports_mqtt_publishers_publisher_thing_mapping) | **POST** /exports/mqtt/publishers/{publisher_id}/things | Add Publisher to Thing mappings
*ThingsApi* | [**add_spaces_collections_thing**](docs/ThingsApi.md#add_spaces_collections_thing) | **POST** /spaces/{space}/collections/{collection-name}/things | Add a thing description
*ThingsApi* | [**delete_accounts_thing**](docs/ThingsApi.md#delete_accounts_thing) | **DELETE** /accounts/{account-id}/things/{thing-id} | Delete thing
*ThingsApi* | [**delete_exports_mqtt_publishers_publisher_thing_mapping**](docs/ThingsApi.md#delete_exports_mqtt_publishers_publisher_thing_mapping) | **DELETE** /exports/mqtt/publishers/{publisher_id}/things/{thing_id} | Delete Publisher to Thing mapping
*ThingsApi* | [**delete_spaces_collections_thing**](docs/ThingsApi.md#delete_spaces_collections_thing) | **DELETE** /spaces/{space}/collections/{collection-name}/things/{thing-id} | Delete thing
*ThingsApi* | [**list_accounts_things**](docs/ThingsApi.md#list_accounts_things) | **GET** /accounts/{account-id}/things | List thing descriptions
*ThingsApi* | [**list_exports_mqtt_publishers_publisher_thing_mappings**](docs/ThingsApi.md#list_exports_mqtt_publishers_publisher_thing_mappings) | **GET** /exports/mqtt/publishers/{publisher_id}/things | List Publisher to Thing mappings
*ThingsApi* | [**list_spaces_collections_things**](docs/ThingsApi.md#list_spaces_collections_things) | **GET** /spaces/{space}/collections/{collection-name}/things | List thing descriptions
*ThingsApi* | [**reset_accounts_things_client_secret**](docs/ThingsApi.md#reset_accounts_things_client_secret) | **POST** /accounts/{account-id}/things/{thing-id}/reset-secret | Reset Client Secret
*ThingsApi* | [**reset_spaces_collections_things_client_secret**](docs/ThingsApi.md#reset_spaces_collections_things_client_secret) | **POST** /spaces/{space}/collections/{collection-name}/things/{thing-id}/reset-secret | Reset Client Secret
*ThingsApi* | [**show_accounts_thing**](docs/ThingsApi.md#show_accounts_thing) | **GET** /accounts/{account-id}/things/{thing-id} | Show thing
*ThingsApi* | [**show_exports_mqtt_publishers_publisher_thing_mapping**](docs/ThingsApi.md#show_exports_mqtt_publishers_publisher_thing_mapping) | **GET** /exports/mqtt/publishers/{publisher_id}/things/{thing_id} | Show Publisher to Thing mapping
*ThingsApi* | [**show_spaces_collections_thing**](docs/ThingsApi.md#show_spaces_collections_thing) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id} | Show thing
*ThingsApi* | [**update_accounts_thing**](docs/ThingsApi.md#update_accounts_thing) | **PUT** /accounts/{account-id}/things/{thing-id} | Update thing description
*ThingsApi* | [**update_spaces_collections_thing**](docs/ThingsApi.md#update_spaces_collections_thing) | **PUT** /spaces/{space}/collections/{collection-name}/things/{thing-id} | Update thing description
*ThingsStatusApi* | [**list_spaces_collections_items**](docs/ThingsStatusApi.md#list_spaces_collections_items) | **GET** /spaces/{space}/collections/{collection-name}/things-status | List items
*ThingsStatusApi* | [**show_spaces_collections_item**](docs/ThingsStatusApi.md#show_spaces_collections_item) | **GET** /spaces/{space}/collections/{collection-name}/things-status/{thing-id} | Show item


## Documentation For Models

 - [ActionDelay](docs/ActionDelay.md)
 - [ActionDelayInput](docs/ActionDelayInput.md)
 - [ActionDelayInputProperties](docs/ActionDelayInputProperties.md)
 - [ActionDelayInputPropertiesInput](docs/ActionDelayInputPropertiesInput.md)
 - [ActionDelayListResponse](docs/ActionDelayListResponse.md)
 - [ActionDelayListResponsePaging](docs/ActionDelayListResponsePaging.md)
 - [ActionDelayResponse](docs/ActionDelayResponse.md)
 - [ActionDelayResponseLinks](docs/ActionDelayResponseLinks.md)
 - [ActionDeleteResponse](docs/ActionDeleteResponse.md)
 - [ActionDeleteResponseErrorClusterBackend](docs/ActionDeleteResponseErrorClusterBackend.md)
 - [ActionListResponse](docs/ActionListResponse.md)
 - [ActionReboot](docs/ActionReboot.md)
 - [ActionRebootResponse](docs/ActionRebootResponse.md)
 - [ActionRequest](docs/ActionRequest.md)
 - [ActionRequestDelay](docs/ActionRequestDelay.md)
 - [ActionRequestDelayInput](docs/ActionRequestDelayInput.md)
 - [ActionResponseElement1](docs/ActionResponseElement1.md)
 - [ActionResponseElement1Delay](docs/ActionResponseElement1Delay.md)
 - [ActionResponseElement2](docs/ActionResponseElement2.md)
 - [ActionResponseElement2Delay](docs/ActionResponseElement2Delay.md)
 - [ActionResponseElement2DelayInput](docs/ActionResponseElement2DelayInput.md)
 - [ActionResponseElement3](docs/ActionResponseElement3.md)
 - [ActionResponseElement3Reboot](docs/ActionResponseElement3Reboot.md)
 - [ActionRunStats](docs/ActionRunStats.md)
 - [ActionRunStatsInput](docs/ActionRunStatsInput.md)
 - [ActionRunStatsInputProperties](docs/ActionRunStatsInputProperties.md)
 - [ActionRunStatsInputPropertiesInterval](docs/ActionRunStatsInputPropertiesInterval.md)
 - [ActionSendKubectl](docs/ActionSendKubectl.md)
 - [ActionSendKubectlInput](docs/ActionSendKubectlInput.md)
 - [ActionSendKubectlInputProperties](docs/ActionSendKubectlInputProperties.md)
 - [ActionSendKubectlInputPropertiesArguments](docs/ActionSendKubectlInputPropertiesArguments.md)
 - [ActionSendKubectlInputPropertiesCommand](docs/ActionSendKubectlInputPropertiesCommand.md)
 - [ActionStopStats](docs/ActionStopStats.md)
 - [ActionUpdateRequest](docs/ActionUpdateRequest.md)
 - [ActionUpdateRequestDelay](docs/ActionUpdateRequestDelay.md)
 - [ActionUpdateResponse](docs/ActionUpdateResponse.md)
 - [ActionUpdateResponseDelay](docs/ActionUpdateResponseDelay.md)
 - [ClientBase](docs/ClientBase.md)
 - [ClientRequest](docs/ClientRequest.md)
 - [ClientRequestAllOf](docs/ClientRequestAllOf.md)
 - [ClientResponse](docs/ClientResponse.md)
 - [ClientResponseAllOf](docs/ClientResponseAllOf.md)
 - [CollectionListResponse](docs/CollectionListResponse.md)
 - [CollectionRequest](docs/CollectionRequest.md)
 - [CollectionResponse](docs/CollectionResponse.md)
 - [CollectionUpdateRequest](docs/CollectionUpdateRequest.md)
 - [CollectionUpdateResponse](docs/CollectionUpdateResponse.md)
 - [CreateCluster](docs/CreateCluster.md)
 - [CreateClusterResponse](docs/CreateClusterResponse.md)
 - [CreateData](docs/CreateData.md)
 - [CreateDataResponse](docs/CreateDataResponse.md)
 - [CreateLabel](docs/CreateLabel.md)
 - [CreateLabelRelation](docs/CreateLabelRelation.md)
 - [CreateLabelResponse](docs/CreateLabelResponse.md)
 - [CredentialsResponseList](docs/CredentialsResponseList.md)
 - [CredentialsResponsePUT](docs/CredentialsResponsePUT.md)
 - [CredentialsResponseThing](docs/CredentialsResponseThing.md)
 - [CredentialsStudio](docs/CredentialsStudio.md)
 - [CredentialsThing](docs/CredentialsThing.md)
 - [DataDeleteResponse](docs/DataDeleteResponse.md)
 - [DataListElement1](docs/DataListElement1.md)
 - [DataListElement2](docs/DataListElement2.md)
 - [DataListElement3](docs/DataListElement3.md)
 - [DataListResponse](docs/DataListResponse.md)
 - [DeleteClusterResponse](docs/DeleteClusterResponse.md)
 - [DiscoveriesResponse](docs/DiscoveriesResponse.md)
 - [DiscoveriesResponseExampleDiscoveryType](docs/DiscoveriesResponseExampleDiscoveryType.md)
 - [DiscoveriesResponseExampleDiscoveryTypeInput](docs/DiscoveriesResponseExampleDiscoveryTypeInput.md)
 - [DiscoveryRequest](docs/DiscoveryRequest.md)
 - [DiscoveryRequestExampleDiscoveryType](docs/DiscoveryRequestExampleDiscoveryType.md)
 - [DiscoveryRequestExampleDiscoveryTypeInput](docs/DiscoveryRequestExampleDiscoveryTypeInput.md)
 - [DiscoveryResponse](docs/DiscoveryResponse.md)
 - [DiscoveryResponseExampleDiscoveryType](docs/DiscoveryResponseExampleDiscoveryType.md)
 - [DiscoveryUpdateRequest](docs/DiscoveryUpdateRequest.md)
 - [DiscoveryUpdateResponse](docs/DiscoveryUpdateResponse.md)
 - [DiscoveryUploadsResponse](docs/DiscoveryUploadsResponse.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [ErrorResponseError](docs/ErrorResponseError.md)
 - [EventDeploymentStats](docs/EventDeploymentStats.md)
 - [EventHighCPU](docs/EventHighCPU.md)
 - [EventHighCPUData](docs/EventHighCPUData.md)
 - [EventHighCPUListResponse](docs/EventHighCPUListResponse.md)
 - [EventHighCPUResponse](docs/EventHighCPUResponse.md)
 - [EventKubectlLogs](docs/EventKubectlLogs.md)
 - [EventKubectlLogsData](docs/EventKubectlLogsData.md)
 - [EventNodesStats](docs/EventNodesStats.md)
 - [EventRequest](docs/EventRequest.md)
 - [EventRequestHighCPU](docs/EventRequestHighCPU.md)
 - [EventResponse](docs/EventResponse.md)
 - [EventResponse2](docs/EventResponse2.md)
 - [EventResponse2HighCPU](docs/EventResponse2HighCPU.md)
 - [EventResponseHighCPU](docs/EventResponseHighCPU.md)
 - [HealthResponse](docs/HealthResponse.md)
 - [LabelBase](docs/LabelBase.md)
 - [LabelDeleteResponse](docs/LabelDeleteResponse.md)
 - [LabelListElement1](docs/LabelListElement1.md)
 - [LabelListElementRelations](docs/LabelListElementRelations.md)
 - [LabelListResponse](docs/LabelListResponse.md)
 - [LabelRelationElement1](docs/LabelRelationElement1.md)
 - [LabelRequest](docs/LabelRequest.md)
 - [LabelRequestAllOf](docs/LabelRequestAllOf.md)
 - [LabelResponse](docs/LabelResponse.md)
 - [LabelResponseAllOf](docs/LabelResponseAllOf.md)
 - [LabelThingPropertyMappingBase](docs/LabelThingPropertyMappingBase.md)
 - [LabelThingPropertyMappingRequest](docs/LabelThingPropertyMappingRequest.md)
 - [LabelThingPropertyMappingRequestAllOf](docs/LabelThingPropertyMappingRequestAllOf.md)
 - [LabelThingPropertyMappingResponse](docs/LabelThingPropertyMappingResponse.md)
 - [LabelThingPropertyMappingResponseAllOf](docs/LabelThingPropertyMappingResponseAllOf.md)
 - [LabeledListItem1](docs/LabeledListItem1.md)
 - [LabeledListResponse](docs/LabeledListResponse.md)
 - [ListClustersResponse](docs/ListClustersResponse.md)
 - [ListClustersResponseElement1](docs/ListClustersResponseElement1.md)
 - [ListClustersResponseElement1Properties](docs/ListClustersResponseElement1Properties.md)
 - [ListClustersResponseElement2](docs/ListClustersResponseElement2.md)
 - [LoggingRequest](docs/LoggingRequest.md)
 - [LoggingResponse](docs/LoggingResponse.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [MQTTAccountActions](docs/MQTTAccountActions.md)
 - [MQTTAccountData](docs/MQTTAccountData.md)
 - [MQTTAccountEvents](docs/MQTTAccountEvents.md)
 - [MQTTAccountPattern1](docs/MQTTAccountPattern1.md)
 - [MQTTAccountPattern2](docs/MQTTAccountPattern2.md)
 - [MQTTAccountPattern3](docs/MQTTAccountPattern3.md)
 - [MQTTAccountProperties](docs/MQTTAccountProperties.md)
 - [MQTTLabel](docs/MQTTLabel.md)
 - [MQTTLabelCredentials](docs/MQTTLabelCredentials.md)
 - [MQTTLabelDeleteResponse](docs/MQTTLabelDeleteResponse.md)
 - [MQTTLabelShowResponse](docs/MQTTLabelShowResponse.md)
 - [MQTTPOSTBody](docs/MQTTPOSTBody.md)
 - [MQTTPOSTResponse](docs/MQTTPOSTResponse.md)
 - [MQTTPUTBody](docs/MQTTPUTBody.md)
 - [MQTTPassword](docs/MQTTPassword.md)
 - [MessageTemplateBase](docs/MessageTemplateBase.md)
 - [MessageTemplateRequest](docs/MessageTemplateRequest.md)
 - [MessageTemplateRequestAllOf](docs/MessageTemplateRequestAllOf.md)
 - [MessageTemplateResponse](docs/MessageTemplateResponse.md)
 - [MessageTemplateResponseAllOf](docs/MessageTemplateResponseAllOf.md)
 - [ModelListResponse](docs/ModelListResponse.md)
 - [ModelProperty](docs/ModelProperty.md)
 - [ModelRequest](docs/ModelRequest.md)
 - [ModelResponse](docs/ModelResponse.md)
 - [ModelUpdateRequest](docs/ModelUpdateRequest.md)
 - [ModelUpdateResponse](docs/ModelUpdateResponse.md)
 - [ModelVersionListResponse](docs/ModelVersionListResponse.md)
 - [ModelVersionRequest](docs/ModelVersionRequest.md)
 - [ModelVersionRequestProperties](docs/ModelVersionRequestProperties.md)
 - [ModelVersionResponse](docs/ModelVersionResponse.md)
 - [Properties](docs/Properties.md)
 - [PropertyBuildConfiguration](docs/PropertyBuildConfiguration.md)
 - [PropertyCPU](docs/PropertyCPU.md)
 - [PropertyCPUResponse](docs/PropertyCPUResponse.md)
 - [PropertyDisk](docs/PropertyDisk.md)
 - [PropertyDiskResponse](docs/PropertyDiskResponse.md)
 - [PropertyMasterNode](docs/PropertyMasterNode.md)
 - [PropertyMemory](docs/PropertyMemory.md)
 - [PropertyMemoryResponse](docs/PropertyMemoryResponse.md)
 - [PropertyStatus](docs/PropertyStatus.md)
 - [PublisherBase](docs/PublisherBase.md)
 - [PublisherRequest](docs/PublisherRequest.md)
 - [PublisherRequestAllOf](docs/PublisherRequestAllOf.md)
 - [PublisherResponse](docs/PublisherResponse.md)
 - [PublisherResponseAllOf](docs/PublisherResponseAllOf.md)
 - [PublisherThingMappingObject](docs/PublisherThingMappingObject.md)
 - [Secret](docs/Secret.md)
 - [ShowClusterResponse](docs/ShowClusterResponse.md)
 - [SubscriberBase](docs/SubscriberBase.md)
 - [SubscriberRequest](docs/SubscriberRequest.md)
 - [SubscriberRequestAllOf](docs/SubscriberRequestAllOf.md)
 - [SubscriberResponse](docs/SubscriberResponse.md)
 - [SubscriberResponseAllOf](docs/SubscriberResponseAllOf.md)
 - [ThingConnectionsRequest](docs/ThingConnectionsRequest.md)
 - [ThingConnectionsResponse](docs/ThingConnectionsResponse.md)
 - [ThingCreateResponse](docs/ThingCreateResponse.md)
 - [ThingCreateResponseActions](docs/ThingCreateResponseActions.md)
 - [ThingCreateResponseCredentials](docs/ThingCreateResponseCredentials.md)
 - [ThingCreateResponseCredentialsHttp](docs/ThingCreateResponseCredentialsHttp.md)
 - [ThingCreateResponseCredentialsMqtt](docs/ThingCreateResponseCredentialsMqtt.md)
 - [ThingCreateResponseCredentialsMqttData](docs/ThingCreateResponseCredentialsMqttData.md)
 - [ThingCreateResponseCredentialsMqttThing](docs/ThingCreateResponseCredentialsMqttThing.md)
 - [ThingCreateResponseEvents](docs/ThingCreateResponseEvents.md)
 - [ThingCreateResponseLinks](docs/ThingCreateResponseLinks.md)
 - [ThingCreateResponseModel](docs/ThingCreateResponseModel.md)
 - [ThingCreateResponseProperties](docs/ThingCreateResponseProperties.md)
 - [ThingDeleteResponse](docs/ThingDeleteResponse.md)
 - [ThingListResponse](docs/ThingListResponse.md)
 - [ThingObjectDeleteResponse](docs/ThingObjectDeleteResponse.md)
 - [ThingRequest](docs/ThingRequest.md)
 - [ThingRequestActions](docs/ThingRequestActions.md)
 - [ThingRequestEvents](docs/ThingRequestEvents.md)
 - [ThingResponse](docs/ThingResponse.md)
 - [ThingStatusListResponse](docs/ThingStatusListResponse.md)
 - [ThingStatusResponse](docs/ThingStatusResponse.md)
 - [ThingUpdateRequest](docs/ThingUpdateRequest.md)
 - [ThingUpdateResponse](docs/ThingUpdateResponse.md)
 - [UpdateCluster](docs/UpdateCluster.md)
 - [UpdateClusterResponse](docs/UpdateClusterResponse.md)
 - [UpdateClusterResponseActions](docs/UpdateClusterResponseActions.md)
 - [UpdateClusterResponseEvents](docs/UpdateClusterResponseEvents.md)
 - [UpdateClusterResponseProperties](docs/UpdateClusterResponseProperties.md)


## Documentation For Authorization


## bearerAuth

- **Type**: Bearer authentication (JWT)


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in swx_sdk.apis and swx_sdk.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from swx_sdk.api.default_api import DefaultApi`
- `from swx_sdk.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import swx_sdk
from swx_sdk.apis import *
from swx_sdk.models import *
```

LICENSE
This project is licensed under the MIT License - see the license file for details.
