# Generated by "invoke backend.generate", do not edit directly

from __future__ import annotations

from pydantic import Field

from infrahub.core.constants import (
    AllowOverrideType,
    BranchSupportType,
    HashableModelState,
    RelationshipCardinality,
    RelationshipDeleteBehavior,
    RelationshipDirection,
    RelationshipKind,
)  # noqa: TC001
from infrahub.core.models import HashableModel


class GeneratedRelationshipSchema(HashableModel):
    id: str | None = Field(
        default=None, description="The ID of the relationship schema", json_schema_extra={"update": "not_applicable"}
    )
    name: str = Field(
        ...,
        description="Relationship name, must be unique within a model and must be all lowercase.",
        pattern=r"^[a-z0-9\_]+$",
        min_length=3,
        max_length=32,
        json_schema_extra={"update": "allowed"},
    )
    peer: str = Field(
        ...,
        description="Type (kind) of objects supported on the other end of the relationship.",
        pattern="^[A-Z][a-zA-Z0-9]+$",
        json_schema_extra={"update": "validate_constraint"},
    )
    kind: RelationshipKind = Field(
        default=RelationshipKind.GENERIC,
        description="Defines the type of the relationship.",
        json_schema_extra={"update": "allowed"},
    )
    label: str | None = Field(
        default=None,
        description="Human friendly representation of the name. Will be autogenerated if not provided",
        max_length=32,
        json_schema_extra={"update": "allowed"},
    )
    description: str | None = Field(
        default=None,
        description="Short description of the relationship.",
        max_length=128,
        json_schema_extra={"update": "allowed"},
    )
    identifier: str | None = Field(
        default=None,
        description="Unique identifier of the relationship within a model, identifiers must match to traverse a relationship on both direction.",
        pattern=r"^[a-z0-9\_]+$",
        max_length=128,
        json_schema_extra={"update": "allowed"},
    )
    cardinality: RelationshipCardinality = Field(
        default=RelationshipCardinality.MANY,
        description="Defines how many objects are expected on the other side of the relationship.",
        json_schema_extra={"update": "validate_constraint"},
    )
    min_count: int = Field(
        default=0,
        description="Defines the minimum objects allowed on the other side of the relationship.",
        json_schema_extra={"update": "validate_constraint"},
    )
    max_count: int = Field(
        default=0,
        description="Defines the maximum objects allowed on the other side of the relationship.",
        json_schema_extra={"update": "validate_constraint"},
    )
    order_weight: int | None = Field(
        default=None,
        description="Number used to order the relationship in the frontend (table and view). Lowest value will be ordered first.",
        json_schema_extra={"update": "allowed"},
    )
    optional: bool = Field(
        default=True,
        description="Indicate if this relationship is mandatory or optional.",
        json_schema_extra={"update": "validate_constraint"},
    )
    branch: BranchSupportType | None = Field(
        default=None,
        description="Type of branch support for the relatioinship, if not defined it will be determine based both peers.",
        json_schema_extra={"update": "not_supported"},
    )
    inherited: bool = Field(
        default=False,
        description="Internal value to indicate if the relationship was inherited from a Generic node.",
        json_schema_extra={"update": "not_applicable"},
    )
    direction: RelationshipDirection = Field(
        default=RelationshipDirection.BIDIR,
        description="Defines the direction of the relationship,  Unidirectional relationship are required when the same model is on both side.",
        json_schema_extra={"update": "not_supported"},
    )
    hierarchical: str | None = Field(
        default=None,
        description="Internal attribute to track the type of hierarchy this relationship is part of, must match a valid Generic Kind",
        json_schema_extra={"update": "not_supported"},
    )
    state: HashableModelState = Field(
        default=HashableModelState.PRESENT,
        description="Expected state of the relationship after loading the schema",
        json_schema_extra={"update": "not_applicable"},
    )
    on_delete: RelationshipDeleteBehavior | None = Field(
        default=None,
        description="Default is no-action. If cascade, related node(s) are deleted when this node is deleted.",
        json_schema_extra={"update": "allowed"},
    )
    allow_override: AllowOverrideType = Field(
        default=AllowOverrideType.ANY,
        description="Type of allowed override for the relationship.",
        json_schema_extra={"update": "allowed"},
    )
    read_only: bool = Field(
        default=False,
        description="Set the relationship as read-only, users won't be able to change its value.",
        json_schema_extra={"update": "allowed"},
    )
    deprecation: str | None = Field(
        default=None,
        description="Mark relationship as deprecated and provide a user-friendly message to display",
        max_length=128,
        json_schema_extra={"update": "allowed"},
    )
