# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['previewer', 'previewer.commands']

package_data = \
{'': ['*']}

install_requires = \
['Wand>=0.6.10,<0.7.0', 'colorama>=0.4.5,<0.5.0', 'python-magic>=0.4.27,<0.5.0']

entry_points = \
{'console_scripts': ['previewer = previewer.cli:run']}

setup_kwargs = {
    'name': 'previewer',
    'version': '0.2.1',
    'description': 'Video or Folder preview generator',
    'long_description': '![Github](https://img.shields.io/github/tag/essembeh/previewer.svg)\n![PyPi](https://img.shields.io/pypi/v/previewer.svg)\n![Python](https://img.shields.io/pypi/pyversions/previewer.svg)\n![CI](https://github.com/essembeh/previewer/actions/workflows/poetry.yml/badge.svg)\n\n# Previewer\n\nCommand line tools to generate previews from video clips or folders containing images.\n\n_previewer_ is a collection of tools:\n\n- `previewer montage`: to generate a single image with thumbnails from a _folder_ containing images or a video clip\n- `previewer gif`: to generate a Gif with thumbnails from a _folder_ containing images or a video clip\n- `previewer video-thumbnailer`: to extract a given number of thumbnails from a video clip\n- `previewer folder-thumbnailer`: to generate thumbnails (resized and cropped images) from a folder containing larger images\n\n# Install\n\nInstall dependencies\n\n```sh\n$ sudo apt update\n$ sudo apt install imagemagick ffmpeg\n```\n\nInstall the latest release of _previewer_ from [PyPI](https://pypi.org/project/previewer/)\n\n```sh\n$ pip3 install previewer\n$ previewer-montage --help\n```\n\nOr install _previewer_ from the sources\n\n```sh\n$ pip3 install poetry\n$ pip3 install git+https://github.com/essembeh/previewer\n$ previewer --help\n```\n\n# Usage: `previewer montage`\n\n```sh\n$ previewer montage --help\nusage: previewer montage [-h] [-r] [-o OUTPUT] [-P PREFIX] [-S SUFFIX] [--polaroid | --no-polaroid] [--shadow | --no-shadow] [--auto_orient | --no-auto_orient] [--title | --no-title]\n                         [--filenames | --no-filenames] [-B BACKGROUND] [-C COLUMNS] [-R ROWS] [--size SIZE] [--crop | --no-crop] [--fill | --no-fill] [--offset OFFSET]\n                         input_files [input_files ...]\n\npositional arguments:\n  input_files           folders containing images or video files\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -r, --recursive       list images recursively (only for images folders)\n  -o OUTPUT, --output OUTPUT\n                        output folder (default is current folder)\n  -P PREFIX, --prefix PREFIX\n                        generated filename prefix\n  -S SUFFIX, --suffix SUFFIX\n                        generated filename prefix\n  --polaroid, --no-polaroid\n                        use polaroid style\n  --shadow, --no-shadow\n                        add shadow to thumbnails\n  --auto_orient, --no-auto_orient\n                        auto orient thumbnails\n  --title, --no-title   add file/folder name as preview title (default: True)\n  --filenames, --no-filenames\n                        add filenames under thumbnails (ignored for videos)\n  -B BACKGROUND, --background BACKGROUND\n                        montage background color, list of colors: https://imagemagick.org/script/color.php\n  -C COLUMNS, --columns COLUMNS\n                        preview columns count (default is 6)\n  -R ROWS, --rows ROWS  preview rows count\n  --size SIZE           thumbnail size (default is 256x256)\n  --crop, --no-crop     crop thumbnails (default: False)\n  --fill, --no-fill     fill thumbnails (default: False)\n  --offset OFFSET       thumbnail offset (default is 10)\n```\n\n# Usage: `previewer gif`\n\n```sh\n$ previewer gif --help               \nusage: previewer gif [-h] [-r] [-o OUTPUT] [-P PREFIX] [-S SUFFIX] [--delay DELAY | --fps DELAY] [-n COUNT | --speed SPEED] [--colors COLORS] [--size SIZE] [--crop | --no-crop] [--fill | --no-fill]\n                     input_files [input_files ...]\n\npositional arguments:\n  input_files           folders containing images or video files\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -r, --recursive       list images recursively (only for images folders)\n  -o OUTPUT, --output OUTPUT\n                        output folder (default is current folder)\n  -P PREFIX, --prefix PREFIX\n                        generated filename prefix\n  -S SUFFIX, --suffix SUFFIX\n                        generated filename prefix\n  --delay DELAY         delay for frames in ms, default is 500\n  --fps DELAY           frame per second, default is 2\n  -n COUNT, --count COUNT\n                        thumbnails count for videos (default calculated given --delay/--fps)\n  --speed SPEED         calculate frames count to extract to respect given speed (only for videos)\n  --colors COLORS       gif colors\n  --size SIZE           thumbnail size (default is 640x480)\n  --crop, --no-crop     crop thumbnails (default: False)\n  --fill, --no-fill     fill thumbnails (default: False)\n```\n\n# Usage: `previewer video-thumbnailer`\n\n```sh\n$ previewer video-thumbnailer --help\nusage: previewer video-thumbnailer [-h] [-o OUTPUT] [-n COUNT] [--size SIZE] [--crop | --no-crop] [--fill | --no-fill] videos [videos ...]\n\npositional arguments:\n  videos                video file\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -o OUTPUT, --output OUTPUT\n                        output folder (default is a new folder in current directory)\n  -n COUNT, --count COUNT\n                        thumbnails count (default is 20)\n  --size SIZE           thumbnail size\n  --crop, --no-crop     crop thumbnails (default is False) (default: False)\n  --fill, --no-fill     fill thumbnails (defailt is False) (default: False)\n```\n\n# Usage: `previewer folder-thumbnailer`\n\n```sh\n$ previewer folder-thumbnailer --help\nusage: previewer folder-thumbnailer [-h] [-o OUTPUT] [-r] --size SIZE [--crop | --no-crop] [--fill | --no-fill] folders [folders ...]\n\npositional arguments:\n  folders               folders containging images\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -o OUTPUT, --output OUTPUT\n                        output folder (default is a new folder in current directory)\n  -r, --recursive       list images recursively (only for images folders)\n  --size SIZE           thumbnail size\n  --crop, --no-crop     crop thumbnails (default is False) (default: False)\n  --fill, --no-fill     fill thumbnails (defailt is False) (default: False)\n```\n',
    'author': 'Sébastien MB',
    'author_email': 'seb@essembeh.org',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/essembeh/previewer',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
