# printnanny-api-client
Official API client library forprintnanny.ai print-nanny.com

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.0
- Package version: 0.89.1
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen
For more information, please visit [https://print-nanny.com](https://print-nanny.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import printnanny_api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import printnanny_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import printnanny_api_client
from printnanny_api_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = printnanny_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'

# Configure Bearer authorization: tokenAuth
configuration = printnanny_api_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with printnanny_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = printnanny_api_client.AlertSettingsApi(api_client)
    
    try:
        api_response = api_instance.alert_settings_get_or_create_retrieve()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AlertSettingsApi->alert_settings_get_or_create_retrieve: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertSettingsApi* | [**alert_settings_get_or_create_retrieve**](docs/AlertSettingsApi.md#alert_settings_get_or_create_retrieve) | **GET** /api/alert-settings/get-or-create/ | 
*AlertSettingsApi* | [**alert_settings_partial_update**](docs/AlertSettingsApi.md#alert_settings_partial_update) | **PATCH** /api/alert-settings/{id}/ | 
*AlertSettingsApi* | [**alert_settings_update**](docs/AlertSettingsApi.md#alert_settings_update) | **PUT** /api/alert-settings/{id}/ | 
*AlertsApi* | [**alerts_list**](docs/AlertsApi.md#alerts_list) | **GET** /api/alerts/ | 
*AlertsApi* | [**alerts_partial_update**](docs/AlertsApi.md#alerts_partial_update) | **PATCH** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_recent**](docs/AlertsApi.md#alerts_recent) | **GET** /api/alerts/recent/ | 
*AlertsApi* | [**alerts_retrieve**](docs/AlertsApi.md#alerts_retrieve) | **GET** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_seen**](docs/AlertsApi.md#alerts_seen) | **PATCH** /api/alerts/seen/ | 
*AlertsApi* | [**alerts_unread**](docs/AlertsApi.md#alerts_unread) | **GET** /api/alerts/unread/ | 
*AlertsApi* | [**alerts_update**](docs/AlertsApi.md#alerts_update) | **PUT** /api/alerts/{id}/ | 
*AuthApi* | [**auth_email_create**](docs/AuthApi.md#auth_email_create) | **POST** /auth/email/ | 
*AuthApi* | [**auth_mobile_create**](docs/AuthApi.md#auth_mobile_create) | **POST** /auth/mobile/ | 
*AuthApi* | [**auth_token_create**](docs/AuthApi.md#auth_token_create) | **POST** /auth/token/ | 
*AuthApi* | [**auth_verify_create**](docs/AuthApi.md#auth_verify_create) | **POST** /auth/verify/ | 
*AuthApi* | [**auth_verify_email_create**](docs/AuthApi.md#auth_verify_email_create) | **POST** /auth/verify/email/ | 
*AuthApi* | [**auth_verify_mobile_create**](docs/AuthApi.md#auth_verify_mobile_create) | **POST** /auth/verify/mobile/ | 
*ClientApi* | [**api_config_retreive**](docs/ClientApi.md#api_config_retreive) | **GET** /api/client | 
*CommandsApi* | [**commands_create**](docs/CommandsApi.md#commands_create) | **POST** /api/commands/ | 
*CommandsApi* | [**commands_list**](docs/CommandsApi.md#commands_list) | **GET** /api/commands/ | 
*CommandsApi* | [**commands_retrieve**](docs/CommandsApi.md#commands_retrieve) | **GET** /api/commands/{id}/ | 
*ConfigApi* | [**api_config_retreive**](docs/ConfigApi.md#api_config_retreive) | **GET** /api/client | 
*DevicesApi* | [**cloudiot_device_update_or_create**](docs/DevicesApi.md#cloudiot_device_update_or_create) | **POST** /api/devices/{device_id}/cloudiot/update-or-create/ | 
*DevicesApi* | [**devices_cloudiot_create**](docs/DevicesApi.md#devices_cloudiot_create) | **POST** /api/devices/{device_id}/cloudiot/ | 
*DevicesApi* | [**devices_cloudiot_list**](docs/DevicesApi.md#devices_cloudiot_list) | **GET** /api/devices/{device_id}/cloudiot/ | 
*DevicesApi* | [**devices_cloudiot_partial_update**](docs/DevicesApi.md#devices_cloudiot_partial_update) | **PATCH** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_cloudiot_retrieve**](docs/DevicesApi.md#devices_cloudiot_retrieve) | **GET** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_cloudiot_update**](docs/DevicesApi.md#devices_cloudiot_update) | **PUT** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_create**](docs/DevicesApi.md#devices_create) | **POST** /api/devices/ | 
*DevicesApi* | [**devices_janus_cloud_stream_get_or_create**](docs/DevicesApi.md#devices_janus_cloud_stream_get_or_create) | **POST** /api/devices/{device_id}/janus-cloud-streams/get-or-create/ | 
*DevicesApi* | [**devices_janus_cloud_streams_create**](docs/DevicesApi.md#devices_janus_cloud_streams_create) | **POST** /api/devices/{device_id}/janus-cloud-streams/ | 
*DevicesApi* | [**devices_janus_cloud_streams_list**](docs/DevicesApi.md#devices_janus_cloud_streams_list) | **GET** /api/devices/{device_id}/janus-cloud-streams/ | 
*DevicesApi* | [**devices_janus_cloud_streams_partial_update**](docs/DevicesApi.md#devices_janus_cloud_streams_partial_update) | **PATCH** /api/devices/{device_id}/janus-cloud-streams/{id}/ | 
*DevicesApi* | [**devices_janus_cloud_streams_retrieve**](docs/DevicesApi.md#devices_janus_cloud_streams_retrieve) | **GET** /api/devices/{device_id}/janus-cloud-streams/{id}/ | 
*DevicesApi* | [**devices_janus_cloud_streams_update**](docs/DevicesApi.md#devices_janus_cloud_streams_update) | **PUT** /api/devices/{device_id}/janus-cloud-streams/{id}/ | 
*DevicesApi* | [**devices_janus_edge_stream_get_or_create**](docs/DevicesApi.md#devices_janus_edge_stream_get_or_create) | **POST** /api/devices/{device_id}/janus-edge-streams/get-or-create/ | 
*DevicesApi* | [**devices_janus_edge_streams_create**](docs/DevicesApi.md#devices_janus_edge_streams_create) | **POST** /api/devices/{device_id}/janus-edge-streams/ | 
*DevicesApi* | [**devices_janus_edge_streams_list**](docs/DevicesApi.md#devices_janus_edge_streams_list) | **GET** /api/devices/{device_id}/janus-edge-streams/ | 
*DevicesApi* | [**devices_janus_edge_streams_partial_update**](docs/DevicesApi.md#devices_janus_edge_streams_partial_update) | **PATCH** /api/devices/{device_id}/janus-edge-streams/{id}/ | 
*DevicesApi* | [**devices_janus_edge_streams_retrieve**](docs/DevicesApi.md#devices_janus_edge_streams_retrieve) | **GET** /api/devices/{device_id}/janus-edge-streams/{id}/ | 
*DevicesApi* | [**devices_janus_edge_streams_update**](docs/DevicesApi.md#devices_janus_edge_streams_update) | **PUT** /api/devices/{device_id}/janus-edge-streams/{id}/ | 
*DevicesApi* | [**devices_janus_streams_list**](docs/DevicesApi.md#devices_janus_streams_list) | **GET** /api/devices/{device_id}/janus-streams/ | 
*DevicesApi* | [**devices_janus_streams_retrieve**](docs/DevicesApi.md#devices_janus_streams_retrieve) | **GET** /api/devices/{device_id}/janus-streams/{id}/ | 
*DevicesApi* | [**devices_license_download_retrieve**](docs/DevicesApi.md#devices_license_download_retrieve) | **GET** /api/devices/{device_id}/license/download/ | 
*DevicesApi* | [**devices_list**](docs/DevicesApi.md#devices_list) | **GET** /api/devices/ | 
*DevicesApi* | [**devices_octoprint_servers_list**](docs/DevicesApi.md#devices_octoprint_servers_list) | **GET** /api/devices/{device_id}/octoprint-servers/ | 
*DevicesApi* | [**devices_partial_update**](docs/DevicesApi.md#devices_partial_update) | **PATCH** /api/devices/{id}/ | 
*DevicesApi* | [**devices_public_keys_create**](docs/DevicesApi.md#devices_public_keys_create) | **POST** /api/devices/{device_id}/public-keys/ | 
*DevicesApi* | [**devices_public_keys_list**](docs/DevicesApi.md#devices_public_keys_list) | **GET** /api/devices/{device_id}/public-keys/ | 
*DevicesApi* | [**devices_public_keys_partial_update**](docs/DevicesApi.md#devices_public_keys_partial_update) | **PATCH** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_public_keys_retrieve**](docs/DevicesApi.md#devices_public_keys_retrieve) | **GET** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_public_keys_update**](docs/DevicesApi.md#devices_public_keys_update) | **PUT** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_retrieve**](docs/DevicesApi.md#devices_retrieve) | **GET** /api/devices/{id}/ | 
*DevicesApi* | [**devices_retrieve_hostname**](docs/DevicesApi.md#devices_retrieve_hostname) | **GET** /api/devices/{hostname} | 
*DevicesApi* | [**devices_system_info_create**](docs/DevicesApi.md#devices_system_info_create) | **POST** /api/devices/{device_id}/system-info/ | 
*DevicesApi* | [**devices_system_info_list**](docs/DevicesApi.md#devices_system_info_list) | **GET** /api/devices/{device_id}/system-info/ | 
*DevicesApi* | [**devices_system_info_partial_update**](docs/DevicesApi.md#devices_system_info_partial_update) | **PATCH** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_system_info_retrieve**](docs/DevicesApi.md#devices_system_info_retrieve) | **GET** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_system_info_update**](docs/DevicesApi.md#devices_system_info_update) | **PUT** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_update**](docs/DevicesApi.md#devices_update) | **PUT** /api/devices/{id}/ | 
*DevicesApi* | [**public_key_update_or_create**](docs/DevicesApi.md#public_key_update_or_create) | **POST** /api/devices/{device_id}/public-keys/update-or-create/ | 
*DevicesApi* | [**system_info_update_or_create**](docs/DevicesApi.md#system_info_update_or_create) | **POST** /api/devices/{device_id}/system-info/update-or-create/ | 
*EventsApi* | [**commands_create**](docs/EventsApi.md#commands_create) | **POST** /api/commands/ | 
*EventsApi* | [**commands_list**](docs/EventsApi.md#commands_list) | **GET** /api/commands/ | 
*EventsApi* | [**commands_retrieve**](docs/EventsApi.md#commands_retrieve) | **GET** /api/commands/{id}/ | 
*EventsApi* | [**events_create**](docs/EventsApi.md#events_create) | **POST** /api/events/ | 
*EventsApi* | [**events_list**](docs/EventsApi.md#events_list) | **GET** /api/events/ | 
*EventsApi* | [**events_retrieve**](docs/EventsApi.md#events_retrieve) | **GET** /api/events/{id}/ | 
*JanusApi* | [**devices_janus_cloud_stream_get_or_create**](docs/JanusApi.md#devices_janus_cloud_stream_get_or_create) | **POST** /api/devices/{device_id}/janus-cloud-streams/get-or-create/ | 
*JanusApi* | [**devices_janus_cloud_streams_create**](docs/JanusApi.md#devices_janus_cloud_streams_create) | **POST** /api/devices/{device_id}/janus-cloud-streams/ | 
*JanusApi* | [**devices_janus_cloud_streams_list**](docs/JanusApi.md#devices_janus_cloud_streams_list) | **GET** /api/devices/{device_id}/janus-cloud-streams/ | 
*JanusApi* | [**devices_janus_cloud_streams_retrieve**](docs/JanusApi.md#devices_janus_cloud_streams_retrieve) | **GET** /api/devices/{device_id}/janus-cloud-streams/{id}/ | 
*JanusApi* | [**devices_janus_cloud_streams_update**](docs/JanusApi.md#devices_janus_cloud_streams_update) | **PUT** /api/devices/{device_id}/janus-cloud-streams/{id}/ | 
*JanusApi* | [**devices_janus_edge_stream_get_or_create**](docs/JanusApi.md#devices_janus_edge_stream_get_or_create) | **POST** /api/devices/{device_id}/janus-edge-streams/get-or-create/ | 
*JanusApi* | [**devices_janus_edge_streams_create**](docs/JanusApi.md#devices_janus_edge_streams_create) | **POST** /api/devices/{device_id}/janus-edge-streams/ | 
*JanusApi* | [**devices_janus_edge_streams_list**](docs/JanusApi.md#devices_janus_edge_streams_list) | **GET** /api/devices/{device_id}/janus-edge-streams/ | 
*JanusApi* | [**devices_janus_edge_streams_retrieve**](docs/JanusApi.md#devices_janus_edge_streams_retrieve) | **GET** /api/devices/{device_id}/janus-edge-streams/{id}/ | 
*JanusApi* | [**devices_janus_edge_streams_update**](docs/JanusApi.md#devices_janus_edge_streams_update) | **PUT** /api/devices/{device_id}/janus-edge-streams/{id}/ | 
*JanusApi* | [**devices_janus_streams_list**](docs/JanusApi.md#devices_janus_streams_list) | **GET** /api/devices/{device_id}/janus-streams/ | 
*JanusApi* | [**devices_janus_streams_retrieve**](docs/JanusApi.md#devices_janus_streams_retrieve) | **GET** /api/devices/{device_id}/janus-streams/{id}/ | 
*JanusApi* | [**users_janus_auth_create**](docs/JanusApi.md#users_janus_auth_create) | **POST** /api/users/{user_id}/janus-auth/ | 
*JanusApi* | [**users_janus_auth_list**](docs/JanusApi.md#users_janus_auth_list) | **GET** /api/users/{user_id}/janus-auth/ | 
*JanusApi* | [**users_janus_auth_retrieve**](docs/JanusApi.md#users_janus_auth_retrieve) | **GET** /api/users/{user_id}/janus-auth/{id}/ | 
*JanusApi* | [**users_janus_auth_update_or_create**](docs/JanusApi.md#users_janus_auth_update_or_create) | **POST** /api/users/{user_id}/janus-auth/update-or-create/ | 
*OctoprintApi* | [**octoprint_backups_create**](docs/OctoprintApi.md#octoprint_backups_create) | **POST** /api/octoprint/backups/ | 
*OctoprintApi* | [**octoprint_backups_list**](docs/OctoprintApi.md#octoprint_backups_list) | **GET** /api/octoprint/backups/ | 
*OctoprintApi* | [**octoprint_backups_retrieve**](docs/OctoprintApi.md#octoprint_backups_retrieve) | **GET** /api/octoprint/backups/{id}/ | 
*OctoprintApi* | [**octoprint_gcode_files_create**](docs/OctoprintApi.md#octoprint_gcode_files_create) | **POST** /api/octoprint/gcode-files/ | 
*OctoprintApi* | [**octoprint_gcode_files_list**](docs/OctoprintApi.md#octoprint_gcode_files_list) | **GET** /api/octoprint/gcode-files/ | 
*OctoprintApi* | [**octoprint_gcode_files_retrieve**](docs/OctoprintApi.md#octoprint_gcode_files_retrieve) | **GET** /api/octoprint/gcode-files/{id}/ | 
*OctoprintApi* | [**octoprint_printer_profiles_create**](docs/OctoprintApi.md#octoprint_printer_profiles_create) | **POST** /api/octoprint/printer-profiles/ | 
*OctoprintApi* | [**octoprint_printer_profiles_list**](docs/OctoprintApi.md#octoprint_printer_profiles_list) | **GET** /api/octoprint/printer-profiles/ | 
*OctoprintApi* | [**octoprint_printer_profiles_partial_update**](docs/OctoprintApi.md#octoprint_printer_profiles_partial_update) | **PATCH** /api/octoprint/printer-profiles/{id}/ | 
*OctoprintApi* | [**octoprint_printer_profiles_update**](docs/OctoprintApi.md#octoprint_printer_profiles_update) | **PUT** /api/octoprint/printer-profiles/{id}/ | 
*OctoprintApi* | [**octoprint_profile_update_or_create**](docs/OctoprintApi.md#octoprint_profile_update_or_create) | **POST** /api/octoprint/printer-profiles/update-or-create/ | 
*OctoprintApi* | [**octoprint_server_update_or_create**](docs/OctoprintApi.md#octoprint_server_update_or_create) | **POST** /api/octoprint-servers/update-or-create/ | 
*OctoprintApi* | [**octoprint_settings_create**](docs/OctoprintApi.md#octoprint_settings_create) | **POST** /api/octoprint/settings/ | 
*OctoprintApi* | [**octoprint_settings_list**](docs/OctoprintApi.md#octoprint_settings_list) | **GET** /api/octoprint/settings/ | 
*OctoprintApi* | [**octoprint_settings_partial_update**](docs/OctoprintApi.md#octoprint_settings_partial_update) | **PATCH** /api/octoprint/settings/{id}/ | 
*OctoprintApi* | [**octoprint_settings_update**](docs/OctoprintApi.md#octoprint_settings_update) | **PUT** /api/octoprint/settings/{id}/ | 
*OctoprintApi* | [**octoprint_settings_update_or_create**](docs/OctoprintApi.md#octoprint_settings_update_or_create) | **POST** /api/octoprint/settings/update-or-create/ | 
*OctoprintServersApi* | [**octoprint_servers_create**](docs/OctoprintServersApi.md#octoprint_servers_create) | **POST** /api/octoprint-servers/ | 
*OctoprintServersApi* | [**octoprint_servers_list**](docs/OctoprintServersApi.md#octoprint_servers_list) | **GET** /api/octoprint-servers/ | 
*OctoprintServersApi* | [**octoprint_servers_partial_update**](docs/OctoprintServersApi.md#octoprint_servers_partial_update) | **PATCH** /api/octoprint-servers/{id}/ | 
*OctoprintServersApi* | [**octoprint_servers_update**](docs/OctoprintServersApi.md#octoprint_servers_update) | **PUT** /api/octoprint-servers/{id}/ | 
*PartnersGeeks3dApi* | [**alerts_list2**](docs/PartnersGeeks3dApi.md#alerts_list2) | **GET** /api/partners/3d-geeks/{id}/alerts/ | 
*PartnersGeeks3dApi* | [**metadata_retrieve**](docs/PartnersGeeks3dApi.md#metadata_retrieve) | **GET** /api/partners/3d-geeks/{id}/ | 
*SchemaApi* | [**schema_retrieve**](docs/SchemaApi.md#schema_retrieve) | **GET** /api/schema/ | 
*UsersApi* | [**users_janus_auth_create**](docs/UsersApi.md#users_janus_auth_create) | **POST** /api/users/{user_id}/janus-auth/ | 
*UsersApi* | [**users_janus_auth_list**](docs/UsersApi.md#users_janus_auth_list) | **GET** /api/users/{user_id}/janus-auth/ | 
*UsersApi* | [**users_janus_auth_retrieve**](docs/UsersApi.md#users_janus_auth_retrieve) | **GET** /api/users/{user_id}/janus-auth/{id}/ | 
*UsersApi* | [**users_janus_auth_update_or_create**](docs/UsersApi.md#users_janus_auth_update_or_create) | **POST** /api/users/{user_id}/janus-auth/update-or-create/ | 
*UsersApi* | [**users_me_retrieve**](docs/UsersApi.md#users_me_retrieve) | **GET** /api/users/me/ | 
*UsersApi* | [**users_partial_update**](docs/UsersApi.md#users_partial_update) | **PATCH** /api/users/{id}/ | 
*UsersApi* | [**users_retrieve**](docs/UsersApi.md#users_retrieve) | **GET** /api/users/{id}/ | 
*UsersApi* | [**users_update**](docs/UsersApi.md#users_update) | **PUT** /api/users/{id}/ | 


## Documentation For Models

 - [Alert](docs/Alert.md)
 - [AlertBulkResponse](docs/AlertBulkResponse.md)
 - [AlertMethodsEnum](docs/AlertMethodsEnum.md)
 - [AlertRequest](docs/AlertRequest.md)
 - [AlertSettings](docs/AlertSettings.md)
 - [AlertSettingsRequest](docs/AlertSettingsRequest.md)
 - [CallbackTokenAuthRequest](docs/CallbackTokenAuthRequest.md)
 - [CallbackTokenVerification](docs/CallbackTokenVerification.md)
 - [CallbackTokenVerificationRequest](docs/CallbackTokenVerificationRequest.md)
 - [CloudiotDevice](docs/CloudiotDevice.md)
 - [CloudiotDeviceRequest](docs/CloudiotDeviceRequest.md)
 - [DetailResponse](docs/DetailResponse.md)
 - [Device](docs/Device.md)
 - [DeviceRequest](docs/DeviceRequest.md)
 - [DeviceUrls](docs/DeviceUrls.md)
 - [EmailAuthRequest](docs/EmailAuthRequest.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [EventSource](docs/EventSource.md)
 - [EventTypeEnum](docs/EventTypeEnum.md)
 - [EventTypesEnum](docs/EventTypesEnum.md)
 - [GcodeFile](docs/GcodeFile.md)
 - [JanusAuth](docs/JanusAuth.md)
 - [JanusAuthRequest](docs/JanusAuthRequest.md)
 - [JanusCloudStream](docs/JanusCloudStream.md)
 - [JanusCloudStreamRequest](docs/JanusCloudStreamRequest.md)
 - [JanusConfigType](docs/JanusConfigType.md)
 - [JanusEdgeStream](docs/JanusEdgeStream.md)
 - [JanusEdgeStreamRequest](docs/JanusEdgeStreamRequest.md)
 - [JanusStream](docs/JanusStream.md)
 - [License](docs/License.md)
 - [MobileAuthRequest](docs/MobileAuthRequest.md)
 - [OctoPrintBackup](docs/OctoPrintBackup.md)
 - [OctoPrintEvent](docs/OctoPrintEvent.md)
 - [OctoPrintEventModel](docs/OctoPrintEventModel.md)
 - [OctoPrintEventName](docs/OctoPrintEventName.md)
 - [OctoPrintEventRequest](docs/OctoPrintEventRequest.md)
 - [OctoPrintServer](docs/OctoPrintServer.md)
 - [OctoPrintServerRequest](docs/OctoPrintServerRequest.md)
 - [OctoPrintSettings](docs/OctoPrintSettings.md)
 - [OctoPrintSettingsRequest](docs/OctoPrintSettingsRequest.md)
 - [OctoPrinterProfile](docs/OctoPrinterProfile.md)
 - [OctoPrinterProfileRequest](docs/OctoPrinterProfileRequest.md)
 - [PaginatedAlertList](docs/PaginatedAlertList.md)
 - [PaginatedCloudiotDeviceList](docs/PaginatedCloudiotDeviceList.md)
 - [PaginatedDeviceList](docs/PaginatedDeviceList.md)
 - [PaginatedGcodeFileList](docs/PaginatedGcodeFileList.md)
 - [PaginatedJanusAuthList](docs/PaginatedJanusAuthList.md)
 - [PaginatedJanusCloudStreamList](docs/PaginatedJanusCloudStreamList.md)
 - [PaginatedJanusEdgeStreamList](docs/PaginatedJanusEdgeStreamList.md)
 - [PaginatedJanusStreamList](docs/PaginatedJanusStreamList.md)
 - [PaginatedOctoPrintBackupList](docs/PaginatedOctoPrintBackupList.md)
 - [PaginatedOctoPrintServerList](docs/PaginatedOctoPrintServerList.md)
 - [PaginatedOctoPrintSettingsList](docs/PaginatedOctoPrintSettingsList.md)
 - [PaginatedOctoPrinterProfileList](docs/PaginatedOctoPrinterProfileList.md)
 - [PaginatedPolymorphicCommandList](docs/PaginatedPolymorphicCommandList.md)
 - [PaginatedPolymorphicEventList](docs/PaginatedPolymorphicEventList.md)
 - [PaginatedPublicKeyList](docs/PaginatedPublicKeyList.md)
 - [PaginatedSystemInfoList](docs/PaginatedSystemInfoList.md)
 - [Partner3DGeeksAlert](docs/Partner3DGeeksAlert.md)
 - [Partner3DGeeksMetadata](docs/Partner3DGeeksMetadata.md)
 - [PatchedAlertBulkRequestRequest](docs/PatchedAlertBulkRequestRequest.md)
 - [PatchedAlertRequest](docs/PatchedAlertRequest.md)
 - [PatchedAlertSettingsRequest](docs/PatchedAlertSettingsRequest.md)
 - [PatchedCloudiotDeviceRequest](docs/PatchedCloudiotDeviceRequest.md)
 - [PatchedDeviceRequest](docs/PatchedDeviceRequest.md)
 - [PatchedJanusCloudStreamRequest](docs/PatchedJanusCloudStreamRequest.md)
 - [PatchedJanusEdgeStreamRequest](docs/PatchedJanusEdgeStreamRequest.md)
 - [PatchedOctoPrintServerRequest](docs/PatchedOctoPrintServerRequest.md)
 - [PatchedOctoPrintSettingsRequest](docs/PatchedOctoPrintSettingsRequest.md)
 - [PatchedOctoPrinterProfileRequest](docs/PatchedOctoPrinterProfileRequest.md)
 - [PatchedPublicKeyRequest](docs/PatchedPublicKeyRequest.md)
 - [PatchedSystemInfoRequest](docs/PatchedSystemInfoRequest.md)
 - [PatchedUserRequest](docs/PatchedUserRequest.md)
 - [PolymorphicCommand](docs/PolymorphicCommand.md)
 - [PolymorphicCommandCreateRequest](docs/PolymorphicCommandCreateRequest.md)
 - [PolymorphicEvent](docs/PolymorphicEvent.md)
 - [PolymorphicEventCreateRequest](docs/PolymorphicEventCreateRequest.md)
 - [PrintNannyApiConfig](docs/PrintNannyApiConfig.md)
 - [PublicKey](docs/PublicKey.md)
 - [PublicKeyRequest](docs/PublicKeyRequest.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [SystemInfoRequest](docs/SystemInfoRequest.md)
 - [TestEvent](docs/TestEvent.md)
 - [TestEventModel](docs/TestEventModel.md)
 - [TestEventName](docs/TestEventName.md)
 - [TestEventRequest](docs/TestEventRequest.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [User](docs/User.md)
 - [UserRequest](docs/UserRequest.md)
 - [WebRTCCommand](docs/WebRTCCommand.md)
 - [WebRTCCommandCreateRequest](docs/WebRTCCommandCreateRequest.md)
 - [WebRTCCommandModel](docs/WebRTCCommandModel.md)
 - [WebRTCCommandName](docs/WebRTCCommandName.md)
 - [WebRTCEvent](docs/WebRTCEvent.md)
 - [WebRTCEventModel](docs/WebRTCEventModel.md)
 - [WebRTCEventName](docs/WebRTCEventName.md)
 - [WebRTCEventRequest](docs/WebRTCEventRequest.md)


## Documentation For Authorization


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## tokenAuth

- **Type**: Bearer authentication


## Author

leigh@printnanny.ai


