import type { StackAsset } from "aws-cdk-lib/pipelines";
/**
 * A helper class that generates a single script file required to publish assets.
 */
export declare class PublishAssetScriptGenerator {
    private readonly cdkoutDir;
    private readonly assets;
    private readonly addOnlyTemplatesToOutput;
    /**
     * A map that stores unique asset IDs and their corresponding output variable names.
     */
    readonly assetIdMap: Map<string, string>;
    /**
     * The complete script content that will be written to a file.
     */
    readonly content: string;
    /**
     * Constructs a new instance of the `PublishAssetScriptGenerator` class.
     *
     * @param cdkoutDir - The output directory for CDK assets.
     * @param assets - A list of `StackAsset` objects to be published.
     * @param addOnlyTemplatesToOutput - If `true`, only assets marked as templates will be added to the output map.
     */
    constructor(cdkoutDir: string, assets: StackAsset[], addOnlyTemplatesToOutput?: boolean);
    /**
     * Generates the publish commands for each asset and stores them as script content.
     *
     * @returns A string representing all commands to be included in the publish script.
     *
     * @remarks
     * The method iterates over each asset, creating a publish command for it, and appends it to
     * the list of script commands. If `addOnlyTemplatesToOutput` is set to `true`, only assets
     * marked as templates are added to the `assetIdMap` for outputting.
     */
    private generatePublishScripts;
    /**
     * Writes the generated publish script content to a specified file.
     *
     * @param filePath - The path where the script file should be saved.
     *
     * @remarks
     * This method creates the necessary directories if they do not exist and writes
     * the accumulated `content` to the specified file path.
     */
    writePublishScript(filePath: string): void;
    /**
     * Returns the path to an asset relative to the assembly directory.
     *
     * @param p - The absolute path to an asset.
     * @returns The path relative to the assembly directory in POSIX format.
     */
    private relativeToAssembly;
}
