"use strict";
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const cdk_nag_1 = require("cdk-nag");
const src_1 = require("../src");
const TEST_CASES = {
    "multiple-aspects": [new src_1.AwsPrototypingChecks(), new cdk_nag_1.AwsSolutionsChecks()],
    default: undefined,
    "single-aspect": [new src_1.AwsPrototypingChecks()],
};
describe("PDK Nag Aspect Tests", () => {
    Object.entries(TEST_CASES).forEach(([testCase, nagPacks]) => {
        test(testCase, () => {
            const app = src_1.PDKNag.app({
                nagPacks,
                failOnError: false,
                failOnWarning: false,
            });
            const stack = new aws_cdk_lib_1.Stack(app, "MyStack");
            new aws_s3_1.Bucket(stack, "Bucket");
            app.synth();
            const nagPacksSet = new Set(app.nagPacks?.map((pack) => pack.readPackName));
            const messages = app
                .nagResults()
                .filter((result) => result.messages
                .map((message) => message.messageDescription)
                .filter((messageDescription) => !nagPacksSet.has(messageDescription.split("-")[0])).length > 0);
            expect(messages.length).toEqual(0);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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