# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2019-04-18 06:09
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('bee_django_course_simple', '0006_auto_20190418_1318'),
    ]

    operations = [
        migrations.CreateModel(
            name='UserCourse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.IntegerField(default=0, verbose_name='\u72b6\u6001')),
                ('passed_at', models.DateTimeField(blank=True, null=True)),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_course_simple.Course', verbose_name='\u8bfe\u7a0b')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='simple_course_user', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-created_at'],
                'db_table': 'bee_django_course_simple_user_course',
            },
        ),
        migrations.CreateModel(
            name='UserPart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('passed_at', models.DateTimeField(blank=True, null=True)),
                ('status', models.IntegerField(default=0)),
                ('part', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_course_simple.Part')),
            ],
            options={
                'ordering': ['part__number'],
                'db_table': 'bee_django_course_simple_user_part',
            },
        ),
        migrations.CreateModel(
            name='UserQuestion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('passed_at', models.DateTimeField(auto_now_add=True)),
                ('answer_option_id', models.IntegerField(null=True)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_course_simple.Question')),
                ('user_part', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_course_simple.UserPart')),
            ],
            options={
                'ordering': ['question__number'],
                'db_table': 'bee_django_course_simple_user_question',
            },
        ),
        migrations.CreateModel(
            name='UserSection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('passed_at', models.DateTimeField(blank=True, null=True)),
                ('status', models.IntegerField(default=0)),
                ('section', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_course_simple.Section')),
                ('user_course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_course_simple.UserCourse')),
            ],
            options={
                'ordering': ['section__number'],
                'db_table': 'bee_django_course_simple_user_section',
            },
        ),
        migrations.CreateModel(
            name='UserVideo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('passed_at', models.DateTimeField(auto_now_add=True)),
                ('user_part', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_course_simple.UserPart')),
                ('video', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_course_simple.Video')),
            ],
            options={
                'ordering': ['video__number'],
                'db_table': 'bee_django_course_simple_user_video',
            },
        ),
        migrations.AddField(
            model_name='userpart',
            name='user_section',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_course_simple.UserSection'),
        ),
    ]
