KEY_ALGORITHM_RS256 = "RS256"
KEY_ALGORITHM_RS384 = "RS384"
KEY_ALGORITHM_RS512 = "RS512"
KEY_ALGORITHM_PS256 = "PS256"
KEY_ALGORITHM_PS384 = "PS384"
KEY_ALGORITHM_PS512 = "PS512"
RSA_ALGORITHMS = (
    KEY_ALGORITHM_RS256,
    KEY_ALGORITHM_RS384,
    KEY_ALGORITHM_RS512,
    KEY_ALGORITHM_PS256,
    KEY_ALGORITHM_PS384,
    KEY_ALGORITHM_PS512,
)
KEY_ALGORITHM_ES256 = "ES256"
KEY_ALGORITHM_ES384 = "ES384"
KEY_ALGORITHM_ES512 = "ES512"
EC_ALGORITHMS = (KEY_ALGORITHM_ES256, KEY_ALGORITHM_ES384, KEY_ALGORITHM_ES512)
KEY_ALGORITHM_EdDSA = "EdDSA"
EdDSA_ALGORITHMS = (KEY_ALGORITHM_EdDSA,)

ALLOWED_ALGORITHMS = (
    # RSA
    KEY_ALGORITHM_RS256,
    KEY_ALGORITHM_RS384,
    KEY_ALGORITHM_RS512,
    # RSA_P
    KEY_ALGORITHM_PS256,
    KEY_ALGORITHM_PS384,
    KEY_ALGORITHM_PS512,
    # EC
    KEY_ALGORITHM_ES256,
    KEY_ALGORITHM_ES384,
    KEY_ALGORITHM_ES512,
    # EdDSA
    KEY_ALGORITHM_EdDSA,
)

EdDSA_CURVE_Ed25519 = "Ed25519"
EdDSA_CURVE_Ed448 = "Ed448"

ALLOWED_EdDSA_CURVES = (EdDSA_CURVE_Ed25519, EdDSA_CURVE_Ed448)


RSA_SIZE_1024 = 1024
RSA_SIZE_2048 = 2048
RSA_SIZE_4096 = 4096
ALLOWED_RSA_SIZES = (
    RSA_SIZE_1024,
    RSA_SIZE_2048,
    RSA_SIZE_4096,
)
DEFAULT_RSA_EXPONENT = 65537


EC_CURVE_MAP = {
    KEY_ALGORITHM_ES256: "P-256",
    KEY_ALGORITHM_PS384: "P-384",
    KEY_ALGORITHM_ES512: "P-521",
}


KEY_TYPE_RSA = "RSA"
KEY_TYPE_ELLIPTIC_CURVE = "EC"
KEY_TYPE_EDWARDS_CURVE = "Ed"
