# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# System
from typing import Dict, List, Optional
import traceback, html

# Pip
from kcu import strings

# ---------------------------------------------------------------------------------------------------------------------------------------- #

__REDDIT_TAG = '&#x200B;'

# ------------------------------------------------------------ Public methods ------------------------------------------------------------ #

def clean_text(text: Optional[str]) -> Optional[str]:
    if text is None:
        return None

    return strings.htmlunescape(text).replace('\n' + __REDDIT_TAG + '\n', '\n').replace(__REDDIT_TAG, '')

# ---------------------------------------------------------------------------------------------------------------------------------------- #