"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkloadScheduling = exports.Workload = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const pod = require("./pod");
const utils_1 = require("./utils");
/**
 * A workload is an application running on Kubernetes. Whether your workload is a single
 * component or several that work together, on Kubernetes you run it inside a set of pods.
 * In Kubernetes, a Pod represents a set of running containers on your cluster.
 */
class Workload extends pod.AbstractPod {
    constructor(scope, id, props = {}) {
        var _c;
        super(scope, id, props);
        this._matchLabels = {};
        this._matchExpressions = [];
        this.podMetadata = new cdk8s_1.ApiObjectMetadataDefinition(props.podMetadata);
        this.scheduling = new WorkloadScheduling(this);
        this.connections = new pod.PodConnections(this);
        const matcher = cdk8s_1.Names.toLabelValue(this);
        this.podMetadata.addLabel(pod.Pod.ADDRESS_LABEL, matcher);
        if ((_c = props.select) !== null && _c !== void 0 ? _c : true) {
            this.select(pod.LabelSelector.of({ labels: { [pod.Pod.ADDRESS_LABEL]: matcher } }));
        }
    }
    /**
     * Configure selectors for this workload.
     */
    select(...selectors) {
        var _c, _d;
        for (const selector of selectors) {
            const kube = selector._toKube();
            this._matchExpressions.push(...(_c = kube.matchExpressions) !== null && _c !== void 0 ? _c : []);
            for (const [key, value] of Object.entries((_d = kube.matchLabels) !== null && _d !== void 0 ? _d : {})) {
                this._matchLabels[key] = value;
            }
        }
    }
    /**
     * The label matchers this workload will use in order to select pods.
     *
     * Returns a a copy. Use `select()` to add label matchers.
     */
    get matchLabels() {
        return { ...this._matchLabels };
    }
    /**
     * The expression matchers this workload will use in order to select pods.
     *
     * Returns a a copy. Use `select()` to add expression matchers.
     */
    get matchExpressions() {
        return [...this._matchExpressions];
    }
    /**
     * @internal
     */
    _toLabelSelector() {
        return {
            matchExpressions: utils_1.undefinedIfEmpty(this._matchExpressions),
            matchLabels: utils_1.undefinedIfEmpty(this._matchLabels),
        };
    }
    /**
     * @internal
     */
    _toPodSpec() {
        const scheduling = this.scheduling._toKube();
        return {
            ...super._toPodSpec(),
            affinity: scheduling.affinity,
            nodeName: scheduling.nodeName,
            tolerations: scheduling.tolerations,
        };
    }
}
exports.Workload = Workload;
_a = JSII_RTTI_SYMBOL_1;
Workload[_a] = { fqn: "cdk8s-plus-22.Workload", version: "2.0.0-rc.8" };
/**
 * Controls the pod scheduling strategy of this workload.
 * It offers some additional API's on top of the core pod scheduling.
 */
class WorkloadScheduling extends pod.PodScheduling {
    /**
     * Spread the pods in this workload by the topology key.
     * A spread is a separation of the pod from itself and is used to
     * balance out pod replicas across a given topology.
     */
    spread(options = {}) {
        var _c;
        this.separate(this.instance, { weight: options.weight, topology: (_c = options.topology) !== null && _c !== void 0 ? _c : pod.Topology.HOSTNAME });
    }
}
exports.WorkloadScheduling = WorkloadScheduling;
_b = JSII_RTTI_SYMBOL_1;
WorkloadScheduling[_b] = { fqn: "cdk8s-plus-22.WorkloadScheduling", version: "2.0.0-rc.8" };
//# sourceMappingURL=data:application/json;base64,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