"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PersistentVolumeMode = exports.PersistentVolumeAccessMode = exports.PersistentVolumeClaim = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const base = require("./base");
const k8s = require("./imports/k8s");
class ImportedPersistentVolumeClaim extends constructs_1.Construct {
    constructor(scope, id, name) {
        super(scope, id);
        this._name = name;
    }
    get name() {
        return this._name;
    }
    get apiVersion() {
        return k8s.KubePersistentVolumeClaim.GVK.apiVersion;
    }
    get apiGroup() {
        return '';
    }
    get kind() {
        return k8s.KubePersistentVolumeClaim.GVK.kind;
    }
}
/**
 * A PersistentVolumeClaim (PVC) is a request for storage by a user.
 * It is similar to a Pod. Pods consume node resources and PVCs consume PV resources.
 * Pods can request specific levels of resources (CPU and Memory).
 * Claims can request specific size and access modes
 */
class PersistentVolumeClaim extends base.Resource {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        this.resourceType = 'persistentvolumeclaims';
        this.storage = props.storage;
        this.volumeMode = (_b = props.volumeMode) !== null && _b !== void 0 ? _b : PersistentVolumeMode.FILE_SYSTEM;
        this.storageClassName = props.storageClassName;
        this._accessModes = props.accessModes;
        if (props.volume) {
            this.bind(props.volume);
        }
        this.apiObject = new k8s.KubePersistentVolumeClaim(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
    }
    /**
     * Imports a pvc from the cluster as a reference.
     */
    static fromClaimName(scope, id, claimName) {
        return new ImportedPersistentVolumeClaim(scope, id, claimName);
    }
    /**
     * Access modes requirement of this claim.
     */
    get accessModes() {
        return this._accessModes ? [...this._accessModes] : undefined;
    }
    /**
     * PV this claim is bound to. Undefined means the claim is not bound
     * to any specific volume.
     */
    get volume() {
        return this._volume;
    }
    /**
     * Bind a claim to a specific volume.
     * Note that you must also bind the volume to the claim.
     *
     * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding
     *
     * @param vol The PV to bind to.
     */
    bind(vol) {
        if (this._volume && this._volume.name !== vol.name) {
            throw new Error(`Cannot bind claim '${this.name}' to volume '${vol.name}' since it is already bound to volume '${this._volume.name}'`);
        }
        this._volume = vol;
    }
    /**
     * @internal
     */
    _toKube() {
        var _b;
        const storage = this.storage ? k8s.Quantity.fromString(this.storage.toGibibytes() + 'Gi') : undefined;
        return {
            volumeName: this.volume ? this.volume.name : undefined,
            accessModes: (_b = this.accessModes) === null || _b === void 0 ? void 0 : _b.map(a => a.toString()),
            resources: storage ? { requests: { storage } } : undefined,
            volumeMode: this.volumeMode,
            storageClassName: this.storageClassName,
        };
    }
}
exports.PersistentVolumeClaim = PersistentVolumeClaim;
_a = JSII_RTTI_SYMBOL_1;
PersistentVolumeClaim[_a] = { fqn: "cdk8s-plus-22.PersistentVolumeClaim", version: "2.0.0-rc.8" };
/**
 * Access Modes.
 */
var PersistentVolumeAccessMode;
(function (PersistentVolumeAccessMode) {
    /**
     * The volume can be mounted as read-write by a single node.
     * ReadWriteOnce access mode still can allow multiple pods to access
     * the volume when the pods are running on the same node.
     */
    PersistentVolumeAccessMode["READ_WRITE_ONCE"] = "ReadWriteOnce";
    /**
     * The volume can be mounted as read-only by many nodes.
     */
    PersistentVolumeAccessMode["READ_ONLY_MANY"] = "ReadOnlyMany";
    /**
     * The volume can be mounted as read-write by many nodes.
     */
    PersistentVolumeAccessMode["READ_WRITE_MANY"] = "ReadWriteMany";
    /**
     * The volume can be mounted as read-write by a single Pod.
     * Use ReadWriteOncePod access mode if you want to ensure that
     * only one pod across whole cluster can read that PVC or write to it.
     * This is only supported for CSI volumes and Kubernetes version 1.22+.
     */
    PersistentVolumeAccessMode["READ_WRITE_ONCE_POD"] = "ReadWriteOncePod";
})(PersistentVolumeAccessMode = exports.PersistentVolumeAccessMode || (exports.PersistentVolumeAccessMode = {}));
/**
 * Volume Modes.
 */
var PersistentVolumeMode;
(function (PersistentVolumeMode) {
    /**
     * Volume is ounted into Pods into a directory.
     * If the volume is backed by a block device and the device is empty,
     * Kubernetes creates a filesystem on the device before mounting it
     * for the first time.
     */
    PersistentVolumeMode["FILE_SYSTEM"] = "Filesystem";
    /**
     * Use a volume as a raw block device. Such volume is presented into a Pod as a block device,
     * without any filesystem on it. This mode is useful to provide a Pod the fastest possible way
     * to access a volume, without any filesystem layer between the Pod
     * and the volume. On the other hand, the application running in
     * the Pod must know how to handle a raw block device
     */
    PersistentVolumeMode["BLOCK"] = "Block";
})(PersistentVolumeMode = exports.PersistentVolumeMode || (exports.PersistentVolumeMode = {}));
//# sourceMappingURL=data:application/json;base64,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