# Generated by Django 4.1.7 on 2023-03-26 14:56

from django.db import migrations, models
import django.db.models.deletion
import mptt.fields


def rebuild_tree(apps, schema_editor):
    from ..models import InventoryItemGroup 
    if hasattr(InventoryItemGroup,'_tree_manager'):
        InventoryItemGroup._tree_manager.rebuild()


class Migration(migrations.Migration):

    dependencies = [
        ('netbox_inventory', '0003_add_inventoryitemgroup'),
    ]

    operations = [
        migrations.AddField(
            model_name='inventoryitemgroup',
            name='description',
            field=models.CharField(blank=True, max_length=200),
        ),
        migrations.AddField(
            model_name='inventoryitemgroup',
            name='level',
            field=models.PositiveIntegerField(default=0, editable=False),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='inventoryitemgroup',
            name='lft',
            field=models.PositiveIntegerField(default=0, editable=False),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='inventoryitemgroup',
            name='parent',
            field=mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='netbox_inventory.inventoryitemgroup'),
        ),
        migrations.AddField(
            model_name='inventoryitemgroup',
            name='rght',
            field=models.PositiveIntegerField(default=0, editable=False),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='inventoryitemgroup',
            name='tree_id',
            field=models.PositiveIntegerField(db_index=True, default=0, editable=False),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='inventoryitemgroup',
            name='name',
            field=models.CharField(max_length=100),
        ),
        migrations.RunPython(rebuild_tree, migrations.RunPython.noop),
        migrations.AddConstraint(
            model_name='inventoryitemgroup',
            constraint=models.UniqueConstraint(fields=('parent', 'name'), name='netbox_inventory_inventoryitemgroup_parent_name'),
        ),
        migrations.AddConstraint(
            model_name='inventoryitemgroup',
            constraint=models.UniqueConstraint(condition=models.Q(('parent__isnull', True)), fields=('name',), name='netbox_inventory_inventoryitemgroup_name', violation_error_message='A top-level group with this name already exists.'),
        ),
    ]
