from __future__ import absolute_import, division, print_function, unicode_literals
import re
from setuptools import setup

# get version number
with open('canvasapi/__init__.py', 'r') as fd:
    version = re.search(
        r'^__version__\s*=\s*[\'"]([^\'"]*)[\'"]',
        fd.read(),
        re.MULTILINE
    ).group(1)

if not version:
    raise RuntimeError('Cannot find version information')

setup(
    name='canvasapi',
    version=version,
    description='API wrapper for the Canvas LMS',
    url='https://github.com/ucfopen/canvasapi',
    author='University of Central Florida - Center for Distributed Learning',
    author_email='techrangers@ucf.edu',
    license='MIT License',
    packages=['canvasapi'],
    include_package_data=True,
    install_requires=['pytz', 'requests', 'six'],
    zip_safe=False,
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Intended Audience :: Education',
        'Intended Audience :: Information Technology',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Topic :: Software Development :: Libraries',
    ],
)
