//---------------------------------------------------------------------------
/*
	Risa [りさ]      alias 吉里吉里3 [kirikiri-3]
	 stands for "Risa Is a Stagecraft Architecture"
	Copyright (C) 2000 W.Dee <dee@kikyou.info> and contributors

	See details of license at "license.txt"
*/
//---------------------------------------------------------------------------
//! @file
//! @brief UNICODE->CP932(≒SJIS) 変換
//---------------------------------------------------------------------------
// UNICODEとSJIS(cp932)の変換マップについては unicode.org を参照のこと


#include "tjsCommHead.h"

//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
/**
 * UNICODEとShiftJISコードの組を表す型
 */
struct tUnicodeAndSJISPair
{
	tjs_uint16 Unicode;
	tjs_uint16 SJIS;
};
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
/**
 * UNICODEとShiftJISコードの組(UNICODEでソート済み)
 */
static const tUnicodeAndSJISPair UnicodeAndSJISPair[] = {
{ 0x0000U, 0x0000U },{ 0x0001U, 0x0001U },{ 0x0002U, 0x0002U },
{ 0x0003U, 0x0003U },{ 0x0004U, 0x0004U },{ 0x0005U, 0x0005U },
{ 0x0006U, 0x0006U },{ 0x0007U, 0x0007U },{ 0x0008U, 0x0008U },
{ 0x0009U, 0x0009U },{ 0x000AU, 0x000AU },{ 0x000BU, 0x000BU },
{ 0x000CU, 0x000CU },{ 0x000DU, 0x000DU },{ 0x000EU, 0x000EU },
{ 0x000FU, 0x000FU },{ 0x0010U, 0x0010U },{ 0x0011U, 0x0011U },
{ 0x0012U, 0x0012U },{ 0x0013U, 0x0013U },{ 0x0014U, 0x0014U },
{ 0x0015U, 0x0015U },{ 0x0016U, 0x0016U },{ 0x0017U, 0x0017U },
{ 0x0018U, 0x0018U },{ 0x0019U, 0x0019U },{ 0x001AU, 0x001AU },
{ 0x001BU, 0x001BU },{ 0x001CU, 0x001CU },{ 0x001DU, 0x001DU },
{ 0x001EU, 0x001EU },{ 0x001FU, 0x001FU },{ 0x0020U, 0x0020U },
{ 0x0021U, 0x0021U },{ 0x0022U, 0x0022U },{ 0x0023U, 0x0023U },
{ 0x0024U, 0x0024U },{ 0x0025U, 0x0025U },{ 0x0026U, 0x0026U },
{ 0x0027U, 0x0027U },{ 0x0028U, 0x0028U },{ 0x0029U, 0x0029U },
{ 0x002AU, 0x002AU },{ 0x002BU, 0x002BU },{ 0x002CU, 0x002CU },
{ 0x002DU, 0x002DU },{ 0x002EU, 0x002EU },{ 0x002FU, 0x002FU },
{ 0x0030U, 0x0030U },{ 0x0031U, 0x0031U },{ 0x0032U, 0x0032U },
{ 0x0033U, 0x0033U },{ 0x0034U, 0x0034U },{ 0x0035U, 0x0035U },
{ 0x0036U, 0x0036U },{ 0x0037U, 0x0037U },{ 0x0038U, 0x0038U },
{ 0x0039U, 0x0039U },{ 0x003AU, 0x003AU },{ 0x003BU, 0x003BU },
{ 0x003CU, 0x003CU },{ 0x003DU, 0x003DU },{ 0x003EU, 0x003EU },
{ 0x003FU, 0x003FU },{ 0x0040U, 0x0040U },{ 0x0041U, 0x0041U },
{ 0x0042U, 0x0042U },{ 0x0043U, 0x0043U },{ 0x0044U, 0x0044U },
{ 0x0045U, 0x0045U },{ 0x0046U, 0x0046U },{ 0x0047U, 0x0047U },
{ 0x0048U, 0x0048U },{ 0x0049U, 0x0049U },{ 0x004AU, 0x004AU },
{ 0x004BU, 0x004BU },{ 0x004CU, 0x004CU },{ 0x004DU, 0x004DU },
{ 0x004EU, 0x004EU },{ 0x004FU, 0x004FU },{ 0x0050U, 0x0050U },
{ 0x0051U, 0x0051U },{ 0x0052U, 0x0052U },{ 0x0053U, 0x0053U },
{ 0x0054U, 0x0054U },{ 0x0055U, 0x0055U },{ 0x0056U, 0x0056U },
{ 0x0057U, 0x0057U },{ 0x0058U, 0x0058U },{ 0x0059U, 0x0059U },
{ 0x005AU, 0x005AU },{ 0x005BU, 0x005BU },{ 0x005CU, 0x005CU },
{ 0x005DU, 0x005DU },{ 0x005EU, 0x005EU },{ 0x005FU, 0x005FU },
{ 0x0060U, 0x0060U },{ 0x0061U, 0x0061U },{ 0x0062U, 0x0062U },
{ 0x0063U, 0x0063U },{ 0x0064U, 0x0064U },{ 0x0065U, 0x0065U },
{ 0x0066U, 0x0066U },{ 0x0067U, 0x0067U },{ 0x0068U, 0x0068U },
{ 0x0069U, 0x0069U },{ 0x006AU, 0x006AU },{ 0x006BU, 0x006BU },
{ 0x006CU, 0x006CU },{ 0x006DU, 0x006DU },{ 0x006EU, 0x006EU },
{ 0x006FU, 0x006FU },{ 0x0070U, 0x0070U },{ 0x0071U, 0x0071U },
{ 0x0072U, 0x0072U },{ 0x0073U, 0x0073U },{ 0x0074U, 0x0074U },
{ 0x0075U, 0x0075U },{ 0x0076U, 0x0076U },{ 0x0077U, 0x0077U },
{ 0x0078U, 0x0078U },{ 0x0079U, 0x0079U },{ 0x007AU, 0x007AU },
{ 0x007BU, 0x007BU },{ 0x007CU, 0x007CU },{ 0x007DU, 0x007DU },
{ 0x007EU, 0x007EU },{ 0x007FU, 0x007FU },{ 0x00A7U, 0x8198U },
{ 0x00A8U, 0x814EU },{ 0x00B0U, 0x818BU },{ 0x00B1U, 0x817DU },
{ 0x00B4U, 0x814CU },{ 0x00B6U, 0x81F7U },{ 0x00D7U, 0x817EU },
{ 0x00F7U, 0x8180U },{ 0x0391U, 0x839FU },{ 0x0392U, 0x83A0U },
{ 0x0393U, 0x83A1U },{ 0x0394U, 0x83A2U },{ 0x0395U, 0x83A3U },
{ 0x0396U, 0x83A4U },{ 0x0397U, 0x83A5U },{ 0x0398U, 0x83A6U },
{ 0x0399U, 0x83A7U },{ 0x039AU, 0x83A8U },{ 0x039BU, 0x83A9U },
{ 0x039CU, 0x83AAU },{ 0x039DU, 0x83ABU },{ 0x039EU, 0x83ACU },
{ 0x039FU, 0x83ADU },{ 0x03A0U, 0x83AEU },{ 0x03A1U, 0x83AFU },
{ 0x03A3U, 0x83B0U },{ 0x03A4U, 0x83B1U },{ 0x03A5U, 0x83B2U },
{ 0x03A6U, 0x83B3U },{ 0x03A7U, 0x83B4U },{ 0x03A8U, 0x83B5U },
{ 0x03A9U, 0x83B6U },{ 0x03B1U, 0x83BFU },{ 0x03B2U, 0x83C0U },
{ 0x03B3U, 0x83C1U },{ 0x03B4U, 0x83C2U },{ 0x03B5U, 0x83C3U },
{ 0x03B6U, 0x83C4U },{ 0x03B7U, 0x83C5U },{ 0x03B8U, 0x83C6U },
{ 0x03B9U, 0x83C7U },{ 0x03BAU, 0x83C8U },{ 0x03BBU, 0x83C9U },
{ 0x03BCU, 0x83CAU },{ 0x03BDU, 0x83CBU },{ 0x03BEU, 0x83CCU },
{ 0x03BFU, 0x83CDU },{ 0x03C0U, 0x83CEU },{ 0x03C1U, 0x83CFU },
{ 0x03C3U, 0x83D0U },{ 0x03C4U, 0x83D1U },{ 0x03C5U, 0x83D2U },
{ 0x03C6U, 0x83D3U },{ 0x03C7U, 0x83D4U },{ 0x03C8U, 0x83D5U },
{ 0x03C9U, 0x83D6U },{ 0x0401U, 0x8446U },{ 0x0410U, 0x8440U },
{ 0x0411U, 0x8441U },{ 0x0412U, 0x8442U },{ 0x0413U, 0x8443U },
{ 0x0414U, 0x8444U },{ 0x0415U, 0x8445U },{ 0x0416U, 0x8447U },
{ 0x0417U, 0x8448U },{ 0x0418U, 0x8449U },{ 0x0419U, 0x844AU },
{ 0x041AU, 0x844BU },{ 0x041BU, 0x844CU },{ 0x041CU, 0x844DU },
{ 0x041DU, 0x844EU },{ 0x041EU, 0x844FU },{ 0x041FU, 0x8450U },
{ 0x0420U, 0x8451U },{ 0x0421U, 0x8452U },{ 0x0422U, 0x8453U },
{ 0x0423U, 0x8454U },{ 0x0424U, 0x8455U },{ 0x0425U, 0x8456U },
{ 0x0426U, 0x8457U },{ 0x0427U, 0x8458U },{ 0x0428U, 0x8459U },
{ 0x0429U, 0x845AU },{ 0x042AU, 0x845BU },{ 0x042BU, 0x845CU },
{ 0x042CU, 0x845DU },{ 0x042DU, 0x845EU },{ 0x042EU, 0x845FU },
{ 0x042FU, 0x8460U },{ 0x0430U, 0x8470U },{ 0x0431U, 0x8471U },
{ 0x0432U, 0x8472U },{ 0x0433U, 0x8473U },{ 0x0434U, 0x8474U },
{ 0x0435U, 0x8475U },{ 0x0436U, 0x8477U },{ 0x0437U, 0x8478U },
{ 0x0438U, 0x8479U },{ 0x0439U, 0x847AU },{ 0x043AU, 0x847BU },
{ 0x043BU, 0x847CU },{ 0x043CU, 0x847DU },{ 0x043DU, 0x847EU },
{ 0x043EU, 0x8480U },{ 0x043FU, 0x8481U },{ 0x0440U, 0x8482U },
{ 0x0441U, 0x8483U },{ 0x0442U, 0x8484U },{ 0x0443U, 0x8485U },
{ 0x0444U, 0x8486U },{ 0x0445U, 0x8487U },{ 0x0446U, 0x8488U },
{ 0x0447U, 0x8489U },{ 0x0448U, 0x848AU },{ 0x0449U, 0x848BU },
{ 0x044AU, 0x848CU },{ 0x044BU, 0x848DU },{ 0x044CU, 0x848EU },
{ 0x044DU, 0x848FU },{ 0x044EU, 0x8490U },{ 0x044FU, 0x8491U },
{ 0x0451U, 0x8476U },{ 0x2010U, 0x815DU },{ 0x2015U, 0x815CU },
{ 0x2018U, 0x8165U },{ 0x2019U, 0x8166U },{ 0x201CU, 0x8167U },
{ 0x201DU, 0x8168U },{ 0x2020U, 0x81F5U },{ 0x2021U, 0x81F6U },
{ 0x2025U, 0x8164U },{ 0x2026U, 0x8163U },{ 0x2030U, 0x81F1U },
{ 0x2032U, 0x818CU },{ 0x2033U, 0x818DU },{ 0x203BU, 0x81A6U },
{ 0x2103U, 0x818EU },{ 0x2116U, 0xFA59U },{ 0x2121U, 0xFA5AU },
{ 0x212BU, 0x81F0U },{ 0x2160U, 0xFA4AU },{ 0x2161U, 0xFA4BU },
{ 0x2162U, 0xFA4CU },{ 0x2163U, 0xFA4DU },{ 0x2164U, 0xFA4EU },
{ 0x2165U, 0xFA4FU },{ 0x2166U, 0xFA50U },{ 0x2167U, 0xFA51U },
{ 0x2168U, 0xFA52U },{ 0x2169U, 0xFA53U },{ 0x2170U, 0xFA40U },
{ 0x2171U, 0xFA41U },{ 0x2172U, 0xFA42U },{ 0x2173U, 0xFA43U },
{ 0x2174U, 0xFA44U },{ 0x2175U, 0xFA45U },{ 0x2176U, 0xFA46U },
{ 0x2177U, 0xFA47U },{ 0x2178U, 0xFA48U },{ 0x2179U, 0xFA49U },
{ 0x2190U, 0x81A9U },{ 0x2191U, 0x81AAU },{ 0x2192U, 0x81A8U },
{ 0x2193U, 0x81ABU },{ 0x21D2U, 0x81CBU },{ 0x21D4U, 0x81CCU },
{ 0x2200U, 0x81CDU },{ 0x2202U, 0x81DDU },{ 0x2203U, 0x81CEU },
{ 0x2207U, 0x81DEU },{ 0x2208U, 0x81B8U },{ 0x220BU, 0x81B9U },
{ 0x2211U, 0x8794U },{ 0x221AU, 0x8795U },{ 0x221DU, 0x81E5U },
{ 0x221EU, 0x8187U },{ 0x221FU, 0x8798U },{ 0x2220U, 0x8797U },
{ 0x2225U, 0x8161U },{ 0x2227U, 0x81C8U },{ 0x2228U, 0x81C9U },
{ 0x2229U, 0x879BU },{ 0x222AU, 0x879CU },{ 0x222BU, 0x8792U },
{ 0x222CU, 0x81E8U },{ 0x222EU, 0x8793U },{ 0x2234U, 0x8188U },
{ 0x2235U, 0xFA5BU },{ 0x223DU, 0x81E4U },{ 0x2252U, 0x8790U },
{ 0x2260U, 0x8182U },{ 0x2261U, 0x8791U },{ 0x2266U, 0x8185U },
{ 0x2267U, 0x8186U },{ 0x226AU, 0x81E1U },{ 0x226BU, 0x81E2U },
{ 0x2282U, 0x81BCU },{ 0x2283U, 0x81BDU },{ 0x2286U, 0x81BAU },
{ 0x2287U, 0x81BBU },{ 0x22A5U, 0x8796U },{ 0x22BFU, 0x8799U },
{ 0x2312U, 0x81DCU },{ 0x2460U, 0x8740U },{ 0x2461U, 0x8741U },
{ 0x2462U, 0x8742U },{ 0x2463U, 0x8743U },{ 0x2464U, 0x8744U },
{ 0x2465U, 0x8745U },{ 0x2466U, 0x8746U },{ 0x2467U, 0x8747U },
{ 0x2468U, 0x8748U },{ 0x2469U, 0x8749U },{ 0x246AU, 0x874AU },
{ 0x246BU, 0x874BU },{ 0x246CU, 0x874CU },{ 0x246DU, 0x874DU },
{ 0x246EU, 0x874EU },{ 0x246FU, 0x874FU },{ 0x2470U, 0x8750U },
{ 0x2471U, 0x8751U },{ 0x2472U, 0x8752U },{ 0x2473U, 0x8753U },
{ 0x2500U, 0x849FU },{ 0x2501U, 0x84AAU },{ 0x2502U, 0x84A0U },
{ 0x2503U, 0x84ABU },{ 0x250CU, 0x84A1U },{ 0x250FU, 0x84ACU },
{ 0x2510U, 0x84A2U },{ 0x2513U, 0x84ADU },{ 0x2514U, 0x84A4U },
{ 0x2517U, 0x84AFU },{ 0x2518U, 0x84A3U },{ 0x251BU, 0x84AEU },
{ 0x251CU, 0x84A5U },{ 0x251DU, 0x84BAU },{ 0x2520U, 0x84B5U },
{ 0x2523U, 0x84B0U },{ 0x2524U, 0x84A7U },{ 0x2525U, 0x84BCU },
{ 0x2528U, 0x84B7U },{ 0x252BU, 0x84B2U },{ 0x252CU, 0x84A6U },
{ 0x252FU, 0x84B6U },{ 0x2530U, 0x84BBU },{ 0x2533U, 0x84B1U },
{ 0x2534U, 0x84A8U },{ 0x2537U, 0x84B8U },{ 0x2538U, 0x84BDU },
{ 0x253BU, 0x84B3U },{ 0x253CU, 0x84A9U },{ 0x253FU, 0x84B9U },
{ 0x2542U, 0x84BEU },{ 0x254BU, 0x84B4U },{ 0x25A0U, 0x81A1U },
{ 0x25A1U, 0x81A0U },{ 0x25B2U, 0x81A3U },{ 0x25B3U, 0x81A2U },
{ 0x25BCU, 0x81A5U },{ 0x25BDU, 0x81A4U },{ 0x25C6U, 0x819FU },
{ 0x25C7U, 0x819EU },{ 0x25CBU, 0x819BU },{ 0x25CEU, 0x819DU },
{ 0x25CFU, 0x819CU },{ 0x25EFU, 0x81FCU },{ 0x2605U, 0x819AU },
{ 0x2606U, 0x8199U },{ 0x2640U, 0x818AU },{ 0x2642U, 0x8189U },
{ 0x266AU, 0x81F4U },{ 0x266DU, 0x81F3U },{ 0x266FU, 0x81F2U },
{ 0x3000U, 0x8140U },{ 0x3001U, 0x8141U },{ 0x3002U, 0x8142U },
{ 0x3003U, 0x8156U },{ 0x3005U, 0x8158U },{ 0x3006U, 0x8159U },
{ 0x3007U, 0x815AU },{ 0x3008U, 0x8171U },{ 0x3009U, 0x8172U },
{ 0x300AU, 0x8173U },{ 0x300BU, 0x8174U },{ 0x300CU, 0x8175U },
{ 0x300DU, 0x8176U },{ 0x300EU, 0x8177U },{ 0x300FU, 0x8178U },
{ 0x3010U, 0x8179U },{ 0x3011U, 0x817AU },{ 0x3012U, 0x81A7U },
{ 0x3013U, 0x81ACU },{ 0x3014U, 0x816BU },{ 0x3015U, 0x816CU },
{ 0x301DU, 0x8780U },{ 0x301FU, 0x8781U },{ 0x3041U, 0x829FU },
{ 0x3042U, 0x82A0U },{ 0x3043U, 0x82A1U },{ 0x3044U, 0x82A2U },
{ 0x3045U, 0x82A3U },{ 0x3046U, 0x82A4U },{ 0x3047U, 0x82A5U },
{ 0x3048U, 0x82A6U },{ 0x3049U, 0x82A7U },{ 0x304AU, 0x82A8U },
{ 0x304BU, 0x82A9U },{ 0x304CU, 0x82AAU },{ 0x304DU, 0x82ABU },
{ 0x304EU, 0x82ACU },{ 0x304FU, 0x82ADU },{ 0x3050U, 0x82AEU },
{ 0x3051U, 0x82AFU },{ 0x3052U, 0x82B0U },{ 0x3053U, 0x82B1U },
{ 0x3054U, 0x82B2U },{ 0x3055U, 0x82B3U },{ 0x3056U, 0x82B4U },
{ 0x3057U, 0x82B5U },{ 0x3058U, 0x82B6U },{ 0x3059U, 0x82B7U },
{ 0x305AU, 0x82B8U },{ 0x305BU, 0x82B9U },{ 0x305CU, 0x82BAU },
{ 0x305DU, 0x82BBU },{ 0x305EU, 0x82BCU },{ 0x305FU, 0x82BDU },
{ 0x3060U, 0x82BEU },{ 0x3061U, 0x82BFU },{ 0x3062U, 0x82C0U },
{ 0x3063U, 0x82C1U },{ 0x3064U, 0x82C2U },{ 0x3065U, 0x82C3U },
{ 0x3066U, 0x82C4U },{ 0x3067U, 0x82C5U },{ 0x3068U, 0x82C6U },
{ 0x3069U, 0x82C7U },{ 0x306AU, 0x82C8U },{ 0x306BU, 0x82C9U },
{ 0x306CU, 0x82CAU },{ 0x306DU, 0x82CBU },{ 0x306EU, 0x82CCU },
{ 0x306FU, 0x82CDU },{ 0x3070U, 0x82CEU },{ 0x3071U, 0x82CFU },
{ 0x3072U, 0x82D0U },{ 0x3073U, 0x82D1U },{ 0x3074U, 0x82D2U },
{ 0x3075U, 0x82D3U },{ 0x3076U, 0x82D4U },{ 0x3077U, 0x82D5U },
{ 0x3078U, 0x82D6U },{ 0x3079U, 0x82D7U },{ 0x307AU, 0x82D8U },
{ 0x307BU, 0x82D9U },{ 0x307CU, 0x82DAU },{ 0x307DU, 0x82DBU },
{ 0x307EU, 0x82DCU },{ 0x307FU, 0x82DDU },{ 0x3080U, 0x82DEU },
{ 0x3081U, 0x82DFU },{ 0x3082U, 0x82E0U },{ 0x3083U, 0x82E1U },
{ 0x3084U, 0x82E2U },{ 0x3085U, 0x82E3U },{ 0x3086U, 0x82E4U },
{ 0x3087U, 0x82E5U },{ 0x3088U, 0x82E6U },{ 0x3089U, 0x82E7U },
{ 0x308AU, 0x82E8U },{ 0x308BU, 0x82E9U },{ 0x308CU, 0x82EAU },
{ 0x308DU, 0x82EBU },{ 0x308EU, 0x82ECU },{ 0x308FU, 0x82EDU },
{ 0x3090U, 0x82EEU },{ 0x3091U, 0x82EFU },{ 0x3092U, 0x82F0U },
{ 0x3093U, 0x82F1U },{ 0x309BU, 0x814AU },{ 0x309CU, 0x814BU },
{ 0x309DU, 0x8154U },{ 0x309EU, 0x8155U },{ 0x30A1U, 0x8340U },
{ 0x30A2U, 0x8341U },{ 0x30A3U, 0x8342U },{ 0x30A4U, 0x8343U },
{ 0x30A5U, 0x8344U },{ 0x30A6U, 0x8345U },{ 0x30A7U, 0x8346U },
{ 0x30A8U, 0x8347U },{ 0x30A9U, 0x8348U },{ 0x30AAU, 0x8349U },
{ 0x30ABU, 0x834AU },{ 0x30ACU, 0x834BU },{ 0x30ADU, 0x834CU },
{ 0x30AEU, 0x834DU },{ 0x30AFU, 0x834EU },{ 0x30B0U, 0x834FU },
{ 0x30B1U, 0x8350U },{ 0x30B2U, 0x8351U },{ 0x30B3U, 0x8352U },
{ 0x30B4U, 0x8353U },{ 0x30B5U, 0x8354U },{ 0x30B6U, 0x8355U },
{ 0x30B7U, 0x8356U },{ 0x30B8U, 0x8357U },{ 0x30B9U, 0x8358U },
{ 0x30BAU, 0x8359U },{ 0x30BBU, 0x835AU },{ 0x30BCU, 0x835BU },
{ 0x30BDU, 0x835CU },{ 0x30BEU, 0x835DU },{ 0x30BFU, 0x835EU },
{ 0x30C0U, 0x835FU },{ 0x30C1U, 0x8360U },{ 0x30C2U, 0x8361U },
{ 0x30C3U, 0x8362U },{ 0x30C4U, 0x8363U },{ 0x30C5U, 0x8364U },
{ 0x30C6U, 0x8365U },{ 0x30C7U, 0x8366U },{ 0x30C8U, 0x8367U },
{ 0x30C9U, 0x8368U },{ 0x30CAU, 0x8369U },{ 0x30CBU, 0x836AU },
{ 0x30CCU, 0x836BU },{ 0x30CDU, 0x836CU },{ 0x30CEU, 0x836DU },
{ 0x30CFU, 0x836EU },{ 0x30D0U, 0x836FU },{ 0x30D1U, 0x8370U },
{ 0x30D2U, 0x8371U },{ 0x30D3U, 0x8372U },{ 0x30D4U, 0x8373U },
{ 0x30D5U, 0x8374U },{ 0x30D6U, 0x8375U },{ 0x30D7U, 0x8376U },
{ 0x30D8U, 0x8377U },{ 0x30D9U, 0x8378U },{ 0x30DAU, 0x8379U },
{ 0x30DBU, 0x837AU },{ 0x30DCU, 0x837BU },{ 0x30DDU, 0x837CU },
{ 0x30DEU, 0x837DU },{ 0x30DFU, 0x837EU },{ 0x30E0U, 0x8380U },
{ 0x30E1U, 0x8381U },{ 0x30E2U, 0x8382U },{ 0x30E3U, 0x8383U },
{ 0x30E4U, 0x8384U },{ 0x30E5U, 0x8385U },{ 0x30E6U, 0x8386U },
{ 0x30E7U, 0x8387U },{ 0x30E8U, 0x8388U },{ 0x30E9U, 0x8389U },
{ 0x30EAU, 0x838AU },{ 0x30EBU, 0x838BU },{ 0x30ECU, 0x838CU },
{ 0x30EDU, 0x838DU },{ 0x30EEU, 0x838EU },{ 0x30EFU, 0x838FU },
{ 0x30F0U, 0x8390U },{ 0x30F1U, 0x8391U },{ 0x30F2U, 0x8392U },
{ 0x30F3U, 0x8393U },{ 0x30F4U, 0x8394U },{ 0x30F5U, 0x8395U },
{ 0x30F6U, 0x8396U },{ 0x30FBU, 0x8145U },{ 0x30FCU, 0x815BU },
{ 0x30FDU, 0x8152U },{ 0x30FEU, 0x8153U },{ 0x3231U, 0xFA58U },
{ 0x3232U, 0x878BU },{ 0x3239U, 0x878CU },{ 0x32A4U, 0x8785U },
{ 0x32A5U, 0x8786U },{ 0x32A6U, 0x8787U },{ 0x32A7U, 0x8788U },
{ 0x32A8U, 0x8789U },{ 0x3303U, 0x8765U },{ 0x330DU, 0x8769U },
{ 0x3314U, 0x8760U },{ 0x3318U, 0x8763U },{ 0x3322U, 0x8761U },
{ 0x3323U, 0x876BU },{ 0x3326U, 0x876AU },{ 0x3327U, 0x8764U },
{ 0x332BU, 0x876CU },{ 0x3336U, 0x8766U },{ 0x333BU, 0x876EU },
{ 0x3349U, 0x875FU },{ 0x334AU, 0x876DU },{ 0x334DU, 0x8762U },
{ 0x3351U, 0x8767U },{ 0x3357U, 0x8768U },{ 0x337BU, 0x877EU },
{ 0x337CU, 0x878FU },{ 0x337DU, 0x878EU },{ 0x337EU, 0x878DU },
{ 0x338EU, 0x8772U },{ 0x338FU, 0x8773U },{ 0x339CU, 0x876FU },
{ 0x339DU, 0x8770U },{ 0x339EU, 0x8771U },{ 0x33A1U, 0x8775U },
{ 0x33C4U, 0x8774U },{ 0x33CDU, 0x8783U },{ 0x4E00U, 0x88EAU },
{ 0x4E01U, 0x929AU },{ 0x4E03U, 0x8EB5U },{ 0x4E07U, 0x969CU },
{ 0x4E08U, 0x8FE4U },{ 0x4E09U, 0x8E4FU },{ 0x4E0AU, 0x8FE3U },
{ 0x4E0BU, 0x89BAU },{ 0x4E0DU, 0x9573U },{ 0x4E0EU, 0x975EU },
{ 0x4E10U, 0x98A0U },{ 0x4E11U, 0x894EU },{ 0x4E14U, 0x8A8EU },
{ 0x4E15U, 0x98A1U },{ 0x4E16U, 0x90A2U },{ 0x4E17U, 0x99C0U },
{ 0x4E18U, 0x8B75U },{ 0x4E19U, 0x95B8U },{ 0x4E1EU, 0x8FE5U },
{ 0x4E21U, 0x97BCU },{ 0x4E26U, 0x95C0U },{ 0x4E28U, 0xFA68U },
{ 0x4E2AU, 0x98A2U },{ 0x4E2DU, 0x9286U },{ 0x4E31U, 0x98A3U },
{ 0x4E32U, 0x8BF8U },{ 0x4E36U, 0x98A4U },{ 0x4E38U, 0x8ADBU },
{ 0x4E39U, 0x924FU },{ 0x4E3BU, 0x8EE5U },{ 0x4E3CU, 0x98A5U },
{ 0x4E3FU, 0x98A6U },{ 0x4E42U, 0x98A7U },{ 0x4E43U, 0x9454U },
{ 0x4E45U, 0x8B76U },{ 0x4E4BU, 0x9456U },{ 0x4E4DU, 0x93E1U },
{ 0x4E4EU, 0x8CC1U },{ 0x4E4FU, 0x9652U },{ 0x4E55U, 0xE568U },
{ 0x4E56U, 0x98A8U },{ 0x4E57U, 0x8FE6U },{ 0x4E58U, 0x98A9U },
{ 0x4E59U, 0x89B3U },{ 0x4E5DU, 0x8BE3U },{ 0x4E5EU, 0x8CEEU },
{ 0x4E5FU, 0x96E7U },{ 0x4E62U, 0x9BA4U },{ 0x4E71U, 0x9790U },
{ 0x4E73U, 0x93FBU },{ 0x4E7EU, 0x8AA3U },{ 0x4E80U, 0x8B54U },
{ 0x4E82U, 0x98AAU },{ 0x4E85U, 0x98ABU },{ 0x4E86U, 0x97B9U },
{ 0x4E88U, 0x975CU },{ 0x4E89U, 0x9188U },{ 0x4E8AU, 0x98ADU },
{ 0x4E8BU, 0x8E96U },{ 0x4E8CU, 0x93F1U },{ 0x4E8EU, 0x98B0U },
{ 0x4E91U, 0x895DU },{ 0x4E92U, 0x8CDDU },{ 0x4E94U, 0x8CDCU },
{ 0x4E95U, 0x88E4U },{ 0x4E98U, 0x986AU },{ 0x4E99U, 0x9869U },
{ 0x4E9BU, 0x8DB1U },{ 0x4E9CU, 0x889FU },{ 0x4E9EU, 0x98B1U },
{ 0x4E9FU, 0x98B2U },{ 0x4EA0U, 0x98B3U },{ 0x4EA1U, 0x9653U },
{ 0x4EA2U, 0x98B4U },{ 0x4EA4U, 0x8CF0U },{ 0x4EA5U, 0x88E5U },
{ 0x4EA6U, 0x9692U },{ 0x4EA8U, 0x8B9CU },{ 0x4EABU, 0x8B9DU },
{ 0x4EACU, 0x8B9EU },{ 0x4EADU, 0x92E0U },{ 0x4EAEU, 0x97BAU },
{ 0x4EB0U, 0x98B5U },{ 0x4EB3U, 0x98B6U },{ 0x4EB6U, 0x98B7U },
{ 0x4EBAU, 0x906CU },{ 0x4EC0U, 0x8F59U },{ 0x4EC1U, 0x906DU },
{ 0x4EC2U, 0x98BCU },{ 0x4EC4U, 0x98BAU },{ 0x4EC6U, 0x98BBU },
{ 0x4EC7U, 0x8B77U },{ 0x4ECAU, 0x8DA1U },{ 0x4ECBU, 0x89EEU },
{ 0x4ECDU, 0x98B9U },{ 0x4ECEU, 0x98B8U },{ 0x4ECFU, 0x95A7U },
{ 0x4ED4U, 0x8E65U },{ 0x4ED5U, 0x8E64U },{ 0x4ED6U, 0x91BCU },
{ 0x4ED7U, 0x98BDU },{ 0x4ED8U, 0x9574U },{ 0x4ED9U, 0x90E5U },
{ 0x4EDDU, 0x8157U },{ 0x4EDEU, 0x98BEU },{ 0x4EDFU, 0x98C0U },
{ 0x4EE1U, 0xFA69U },{ 0x4EE3U, 0x91E3U },{ 0x4EE4U, 0x97DFU },
{ 0x4EE5U, 0x88C8U },{ 0x4EEDU, 0x98BFU },{ 0x4EEEU, 0x89BCU },
{ 0x4EF0U, 0x8BC2U },{ 0x4EF2U, 0x9287U },{ 0x4EF6U, 0x8C8FU },
{ 0x4EF7U, 0x98C1U },{ 0x4EFBU, 0x9443U },{ 0x4EFCU, 0xFA6AU },
{ 0x4F00U, 0xFA6BU },{ 0x4F01U, 0x8AE9U },{ 0x4F03U, 0xFA6CU },
{ 0x4F09U, 0x98C2U },{ 0x4F0AU, 0x88C9U },{ 0x4F0DU, 0x8CDEU },
{ 0x4F0EU, 0x8AEAU },{ 0x4F0FU, 0x959AU },{ 0x4F10U, 0x94B0U },
{ 0x4F11U, 0x8B78U },{ 0x4F1AU, 0x89EFU },{ 0x4F1CU, 0x98E5U },
{ 0x4F1DU, 0x9360U },{ 0x4F2FU, 0x948CU },{ 0x4F30U, 0x98C4U },
{ 0x4F34U, 0x94BAU },{ 0x4F36U, 0x97E0U },{ 0x4F38U, 0x904CU },
{ 0x4F39U, 0xFA6DU },{ 0x4F3AU, 0x8E66U },{ 0x4F3CU, 0x8E97U },
{ 0x4F3DU, 0x89BEU },{ 0x4F43U, 0x92CFU },{ 0x4F46U, 0x9241U },
{ 0x4F47U, 0x98C8U },{ 0x4F4DU, 0x88CAU },{ 0x4F4EU, 0x92E1U },
{ 0x4F4FU, 0x8F5AU },{ 0x4F50U, 0x8DB2U },{ 0x4F51U, 0x9743U },
{ 0x4F53U, 0x91CCU },{ 0x4F55U, 0x89BDU },{ 0x4F56U, 0xFA6EU },
{ 0x4F57U, 0x98C7U },{ 0x4F59U, 0x975DU },{ 0x4F5AU, 0x98C3U },
{ 0x4F5BU, 0x98C5U },{ 0x4F5CU, 0x8DECU },{ 0x4F5DU, 0x98C6U },
{ 0x4F5EU, 0x9B43U },{ 0x4F69U, 0x98CEU },{ 0x4F6FU, 0x98D1U },
{ 0x4F70U, 0x98CFU },{ 0x4F73U, 0x89C0U },{ 0x4F75U, 0x95B9U },
{ 0x4F76U, 0x98C9U },{ 0x4F7BU, 0x98CDU },{ 0x4F7CU, 0x8CF1U },
{ 0x4F7FU, 0x8E67U },{ 0x4F83U, 0x8AA4U },{ 0x4F86U, 0x98D2U },
{ 0x4F88U, 0x98CAU },{ 0x4F8AU, 0xFA70U },{ 0x4F8BU, 0x97E1U },
{ 0x4F8DU, 0x8E98U },{ 0x4F8FU, 0x98CBU },{ 0x4F91U, 0x98D0U },
{ 0x4F92U, 0xFA6FU },{ 0x4F94U, 0xFA72U },{ 0x4F96U, 0x98D3U },
{ 0x4F98U, 0x98CCU },{ 0x4F9AU, 0xFA71U },{ 0x4F9BU, 0x8B9FU },
{ 0x4F9DU, 0x88CBU },{ 0x4FA0U, 0x8BA0U },{ 0x4FA1U, 0x89BFU },
{ 0x4FABU, 0x9B44U },{ 0x4FADU, 0x9699U },{ 0x4FAEU, 0x958EU },
{ 0x4FAFU, 0x8CF2U },{ 0x4FB5U, 0x904EU },{ 0x4FB6U, 0x97B5U },
{ 0x4FBFU, 0x95D6U },{ 0x4FC2U, 0x8C57U },{ 0x4FC3U, 0x91A3U },
{ 0x4FC4U, 0x89E2U },{ 0x4FC9U, 0xFA61U },{ 0x4FCAU, 0x8F72U },
{ 0x4FCDU, 0xFA73U },{ 0x4FCEU, 0x98D7U },{ 0x4FD0U, 0x98DCU },
{ 0x4FD1U, 0x98DAU },{ 0x4FD4U, 0x98D5U },{ 0x4FD7U, 0x91ADU },
{ 0x4FD8U, 0x98D8U },{ 0x4FDAU, 0x98DBU },{ 0x4FDBU, 0x98D9U },
{ 0x4FDDU, 0x95DBU },{ 0x4FDFU, 0x98D6U },{ 0x4FE1U, 0x904DU },
{ 0x4FE3U, 0x9693U },{ 0x4FE4U, 0x98DDU },{ 0x4FE5U, 0x98DEU },
{ 0x4FEEU, 0x8F43U },{ 0x4FEFU, 0x98EBU },{ 0x4FF3U, 0x946FU },
{ 0x4FF5U, 0x9555U },{ 0x4FF6U, 0x98E6U },{ 0x4FF8U, 0x95EEU },
{ 0x4FFAU, 0x89B4U },{ 0x4FFEU, 0x98EAU },{ 0x4FFFU, 0xFA76U },
{ 0x5005U, 0x98E4U },{ 0x5006U, 0x98EDU },{ 0x5009U, 0x9171U },
{ 0x500BU, 0x8CC2U },{ 0x500DU, 0x947BU },{ 0x500FU, 0xE0C5U },
{ 0x5011U, 0x98ECU },{ 0x5012U, 0x937CU },{ 0x5014U, 0x98E1U },
{ 0x5016U, 0x8CF4U },{ 0x5019U, 0x8CF3U },{ 0x501AU, 0x98DFU },
{ 0x501EU, 0xFA77U },{ 0x501FU, 0x8ED8U },{ 0x5021U, 0x98E7U },
{ 0x5022U, 0xFA75U },{ 0x5023U, 0x95EDU },{ 0x5024U, 0x926CU },
{ 0x5025U, 0x98E3U },{ 0x5026U, 0x8C91U },{ 0x5028U, 0x98E0U },
{ 0x5029U, 0x98E8U },{ 0x502AU, 0x98E2U },{ 0x502BU, 0x97CFU },
{ 0x502CU, 0x98E9U },{ 0x502DU, 0x9860U },{ 0x5036U, 0x8BE4U },
{ 0x5039U, 0x8C90U },{ 0x5040U, 0xFA74U },{ 0x5042U, 0xFA7AU },
{ 0x5043U, 0x98EEU },{ 0x5046U, 0xFA78U },{ 0x5047U, 0x98EFU },
{ 0x5048U, 0x98F3U },{ 0x5049U, 0x88CCU },{ 0x504FU, 0x95CEU },
{ 0x5050U, 0x98F2U },{ 0x5055U, 0x98F1U },{ 0x5056U, 0x98F5U },
{ 0x505AU, 0x98F4U },{ 0x505CU, 0x92E2U },{ 0x5065U, 0x8C92U },
{ 0x506CU, 0x98F6U },{ 0x5070U, 0xFA79U },{ 0x5072U, 0x8EC3U },
{ 0x5074U, 0x91A4U },{ 0x5075U, 0x92E3U },{ 0x5076U, 0x8BF4U },
{ 0x5078U, 0x98F7U },{ 0x507DU, 0x8B55U },{ 0x5080U, 0x98F8U },
{ 0x5085U, 0x98FAU },{ 0x508DU, 0x9654U },{ 0x5091U, 0x8C86U },
{ 0x5094U, 0xFA7BU },{ 0x5098U, 0x8E50U },{ 0x5099U, 0x94F5U },
{ 0x509AU, 0x98F9U },{ 0x50ACU, 0x8DC3U },{ 0x50ADU, 0x9762U },
{ 0x50B2U, 0x98FCU },{ 0x50B3U, 0x9942U },{ 0x50B4U, 0x98FBU },
{ 0x50B5U, 0x8DC2U },{ 0x50B7U, 0x8F9DU },{ 0x50BEU, 0x8C58U },
{ 0x50C2U, 0x9943U },{ 0x50C5U, 0x8BCDU },{ 0x50C9U, 0x9940U },
{ 0x50CAU, 0x9941U },{ 0x50CDU, 0x93ADU },{ 0x50CFU, 0x919CU },
{ 0x50D1U, 0x8BA1U },{ 0x50D5U, 0x966CU },{ 0x50D6U, 0x9944U },
{ 0x50D8U, 0xFA7DU },{ 0x50DAU, 0x97BBU },{ 0x50DEU, 0x9945U },
{ 0x50E3U, 0x9948U },{ 0x50E5U, 0x9946U },{ 0x50E7U, 0x916DU },
{ 0x50EDU, 0x9947U },{ 0x50EEU, 0x9949U },{ 0x50F4U, 0xFA7CU },
{ 0x50F5U, 0x994BU },{ 0x50F9U, 0x994AU },{ 0x50FBU, 0x95C6U },
{ 0x5100U, 0x8B56U },{ 0x5101U, 0x994DU },{ 0x5102U, 0x994EU },
{ 0x5104U, 0x89ADU },{ 0x5109U, 0x994CU },{ 0x5112U, 0x8EF2U },
{ 0x5114U, 0x9951U },{ 0x5115U, 0x9950U },{ 0x5116U, 0x994FU },
{ 0x5118U, 0x98D4U },{ 0x511AU, 0x9952U },{ 0x511FU, 0x8F9EU },
{ 0x5121U, 0x9953U },{ 0x512AU, 0x9744U },{ 0x5132U, 0x96D7U },
{ 0x5137U, 0x9955U },{ 0x513AU, 0x9954U },{ 0x513BU, 0x9957U },
{ 0x513CU, 0x9956U },{ 0x513FU, 0x9958U },{ 0x5140U, 0x9959U },
{ 0x5141U, 0x88F2U },{ 0x5143U, 0x8CB3U },{ 0x5144U, 0x8C5AU },
{ 0x5145U, 0x8F5BU },{ 0x5146U, 0x929BU },{ 0x5147U, 0x8BA2U },
{ 0x5148U, 0x90E6U },{ 0x5149U, 0x8CF5U },{ 0x514AU, 0xFA7EU },
{ 0x514BU, 0x8D8EU },{ 0x514CU, 0x995BU },{ 0x514DU, 0x96C6U },
{ 0x514EU, 0x9365U },{ 0x5150U, 0x8E99U },{ 0x5152U, 0x995AU },
{ 0x5154U, 0x995CU },{ 0x515AU, 0x937DU },{ 0x515CU, 0x8A95U },
{ 0x5162U, 0x995DU },{ 0x5164U, 0xFA80U },{ 0x5165U, 0x93FCU },
{ 0x5168U, 0x9153U },{ 0x5169U, 0x995FU },{ 0x516AU, 0x9960U },
{ 0x516BU, 0x94AAU },{ 0x516CU, 0x8CF6U },{ 0x516DU, 0x985AU },
{ 0x516EU, 0x9961U },{ 0x5171U, 0x8BA4U },{ 0x5175U, 0x95BAU },
{ 0x5176U, 0x91B4U },{ 0x5177U, 0x8BEFU },{ 0x5178U, 0x9354U },
{ 0x517CU, 0x8C93U },{ 0x5180U, 0x9962U },{ 0x5182U, 0x9963U },
{ 0x5185U, 0x93E0U },{ 0x5186U, 0x897EU },{ 0x5189U, 0x9966U },
{ 0x518AU, 0x8DFBU },{ 0x518CU, 0x9965U },{ 0x518DU, 0x8DC4U },
{ 0x518FU, 0x9967U },{ 0x5190U, 0xE3ECU },{ 0x5191U, 0x9968U },
{ 0x5192U, 0x9660U },{ 0x5193U, 0x9969U },{ 0x5195U, 0x996AU },
{ 0x5196U, 0x996BU },{ 0x5197U, 0x8FE7U },{ 0x5199U, 0x8ECAU },
{ 0x519DU, 0xFA81U },{ 0x51A0U, 0x8AA5U },{ 0x51A2U, 0x996EU },
{ 0x51A4U, 0x996CU },{ 0x51A5U, 0x96BBU },{ 0x51A6U, 0x996DU },
{ 0x51A8U, 0x9579U },{ 0x51A9U, 0x996FU },{ 0x51AAU, 0x9970U },
{ 0x51ABU, 0x9971U },{ 0x51ACU, 0x937EU },{ 0x51B0U, 0x9975U },
{ 0x51B1U, 0x9973U },{ 0x51B2U, 0x9974U },{ 0x51B3U, 0x9972U },
{ 0x51B4U, 0x8DE1U },{ 0x51B5U, 0x9976U },{ 0x51B6U, 0x96E8U },
{ 0x51B7U, 0x97E2U },{ 0x51BDU, 0x9977U },{ 0x51BEU, 0xFA82U },
{ 0x51C4U, 0x90A6U },{ 0x51C5U, 0x9978U },{ 0x51C6U, 0x8F79U },
{ 0x51C9U, 0x9979U },{ 0x51CBU, 0x929CU },{ 0x51CCU, 0x97BDU },
{ 0x51CDU, 0x9380U },{ 0x51D6U, 0x99C3U },{ 0x51DBU, 0x997AU },
{ 0x51DCU, 0xEAA3U },{ 0x51DDU, 0x8BC3U },{ 0x51E0U, 0x997BU },
{ 0x51E1U, 0x967DU },{ 0x51E6U, 0x8F88U },{ 0x51E7U, 0x91FAU },
{ 0x51E9U, 0x997DU },{ 0x51EAU, 0x93E2U },{ 0x51ECU, 0xFA83U },
{ 0x51EDU, 0x997EU },{ 0x51F0U, 0x9980U },{ 0x51F1U, 0x8A4DU },
{ 0x51F5U, 0x9981U },{ 0x51F6U, 0x8BA5U },{ 0x51F8U, 0x93CAU },
{ 0x51F9U, 0x899AU },{ 0x51FAU, 0x8F6FU },{ 0x51FDU, 0x949FU },
{ 0x51FEU, 0x9982U },{ 0x5200U, 0x9381U },{ 0x5203U, 0x906EU },
{ 0x5204U, 0x9983U },{ 0x5206U, 0x95AAU },{ 0x5207U, 0x90D8U },
{ 0x5208U, 0x8AA0U },{ 0x520AU, 0x8AA7U },{ 0x520BU, 0x9984U },
{ 0x520EU, 0x9986U },{ 0x5211U, 0x8C59U },{ 0x5214U, 0x9985U },
{ 0x5215U, 0xFA84U },{ 0x5217U, 0x97F1U },{ 0x521DU, 0x8F89U },
{ 0x5224U, 0x94BBU },{ 0x5225U, 0x95CAU },{ 0x5227U, 0x9987U },
{ 0x5229U, 0x9798U },{ 0x522AU, 0x9988U },{ 0x522EU, 0x9989U },
{ 0x5230U, 0x939EU },{ 0x5233U, 0x998AU },{ 0x5236U, 0x90A7U },
{ 0x5237U, 0x8DFCU },{ 0x5238U, 0x8C94U },{ 0x5239U, 0x998BU },
{ 0x523AU, 0x8E68U },{ 0x523BU, 0x8D8FU },{ 0x5243U, 0x92E4U },
{ 0x5244U, 0x998DU },{ 0x5247U, 0x91A5U },{ 0x524AU, 0x8DEDU },
{ 0x524BU, 0x998EU },{ 0x524CU, 0x998FU },{ 0x524DU, 0x914FU },
{ 0x524FU, 0x998CU },{ 0x5254U, 0x9991U },{ 0x5256U, 0x9655U },
{ 0x525BU, 0x8D84U },{ 0x525EU, 0x9990U },{ 0x5263U, 0x8C95U },
{ 0x5264U, 0x8DDCU },{ 0x5265U, 0x948DU },{ 0x5269U, 0x9994U },
{ 0x526AU, 0x9992U },{ 0x526FU, 0x959BU },{ 0x5270U, 0x8FE8U },
{ 0x5271U, 0x999BU },{ 0x5272U, 0x8A84U },{ 0x5273U, 0x9995U },
{ 0x5274U, 0x9993U },{ 0x5275U, 0x916EU },{ 0x527DU, 0x9997U },
{ 0x527FU, 0x9996U },{ 0x5283U, 0x8A63U },{ 0x5287U, 0x8C80U },
{ 0x5288U, 0x999CU },{ 0x5289U, 0x97ABU },{ 0x528DU, 0x9998U },
{ 0x5291U, 0x999DU },{ 0x5292U, 0x999AU },{ 0x5294U, 0x9999U },
{ 0x529BU, 0x97CDU },{ 0x529CU, 0xFA85U },{ 0x529FU, 0x8CF7U },
{ 0x52A0U, 0x89C1U },{ 0x52A3U, 0x97F2U },{ 0x52A6U, 0xFA86U },
{ 0x52A9U, 0x8F95U },{ 0x52AAU, 0x9377U },{ 0x52ABU, 0x8D85U },
{ 0x52ACU, 0x99A0U },{ 0x52ADU, 0x99A1U },{ 0x52AFU, 0xFB77U },
{ 0x52B1U, 0x97E3U },{ 0x52B4U, 0x984AU },{ 0x52B5U, 0x99A3U },
{ 0x52B9U, 0x8CF8U },{ 0x52BCU, 0x99A2U },{ 0x52BEU, 0x8A4EU },
{ 0x52C0U, 0xFA87U },{ 0x52C1U, 0x99A4U },{ 0x52C3U, 0x9675U },
{ 0x52C5U, 0x92BAU },{ 0x52C7U, 0x9745U },{ 0x52C9U, 0x95D7U },
{ 0x52CDU, 0x99A5U },{ 0x52D2U, 0xE8D3U },{ 0x52D5U, 0x93AEU },
{ 0x52D7U, 0x99A6U },{ 0x52D8U, 0x8AA8U },{ 0x52D9U, 0x96B1U },
{ 0x52DBU, 0xFA88U },{ 0x52DDU, 0x8F9FU },{ 0x52DEU, 0x99A7U },
{ 0x52DFU, 0x95E5U },{ 0x52E0U, 0x99ABU },{ 0x52E2U, 0x90A8U },
{ 0x52E3U, 0x99A8U },{ 0x52E4U, 0x8BCEU },{ 0x52E6U, 0x99A9U },
{ 0x52E7U, 0x8AA9U },{ 0x52F2U, 0x8C4DU },{ 0x52F3U, 0x99ACU },
{ 0x52F5U, 0x99ADU },{ 0x52F8U, 0x99AEU },{ 0x52F9U, 0x99AFU },
{ 0x52FAU, 0x8ED9U },{ 0x52FEU, 0x8CF9U },{ 0x52FFU, 0x96DCU },
{ 0x5300U, 0xFA89U },{ 0x5301U, 0x96E6U },{ 0x5302U, 0x93F5U },
{ 0x5305U, 0x95EFU },{ 0x5306U, 0x99B0U },{ 0x5307U, 0xFA8AU },
{ 0x5308U, 0x99B1U },{ 0x530DU, 0x99B3U },{ 0x530FU, 0x99B5U },
{ 0x5310U, 0x99B4U },{ 0x5315U, 0x99B6U },{ 0x5316U, 0x89BBU },
{ 0x5317U, 0x966BU },{ 0x5319U, 0x8DFAU },{ 0x531AU, 0x99B7U },
{ 0x531DU, 0x9178U },{ 0x5320U, 0x8FA0U },{ 0x5321U, 0x8BA7U },
{ 0x5323U, 0x99B8U },{ 0x5324U, 0xFA8BU },{ 0x532AU, 0x94D9U },
{ 0x532FU, 0x99B9U },{ 0x5331U, 0x99BAU },{ 0x5333U, 0x99BBU },
{ 0x5338U, 0x99BCU },{ 0x5339U, 0x9543U },{ 0x533AU, 0x8BE6U },
{ 0x533BU, 0x88E3U },{ 0x533FU, 0x93BDU },{ 0x5340U, 0x99BDU },
{ 0x5341U, 0x8F5CU },{ 0x5343U, 0x90E7U },{ 0x5345U, 0x99BFU },
{ 0x5346U, 0x99BEU },{ 0x5347U, 0x8FA1U },{ 0x5348U, 0x8CDFU },
{ 0x5349U, 0x99C1U },{ 0x534AU, 0x94BCU },{ 0x534DU, 0x99C2U },
{ 0x5351U, 0x94DAU },{ 0x5352U, 0x91B2U },{ 0x5353U, 0x91ECU },
{ 0x5354U, 0x8BA6U },{ 0x5357U, 0x93ECU },{ 0x5358U, 0x9250U },
{ 0x535AU, 0x948EU },{ 0x535CU, 0x966DU },{ 0x535EU, 0x99C4U },
{ 0x5360U, 0x90E8U },{ 0x5366U, 0x8C54U },{ 0x5369U, 0x99C5U },
{ 0x536EU, 0x99C6U },{ 0x536FU, 0x894BU },{ 0x5370U, 0x88F3U },
{ 0x5371U, 0x8AEBU },{ 0x5372U, 0xFA8CU },{ 0x5373U, 0x91A6U },
{ 0x5374U, 0x8B70U },{ 0x5375U, 0x9791U },{ 0x5377U, 0x99C9U },
{ 0x5378U, 0x89B5U },{ 0x537BU, 0x99C8U },{ 0x537FU, 0x8BA8U },
{ 0x5382U, 0x99CAU },{ 0x5384U, 0x96EFU },{ 0x5393U, 0xFA8DU },
{ 0x5396U, 0x99CBU },{ 0x5398U, 0x97D0U },{ 0x539AU, 0x8CFAU },
{ 0x539FU, 0x8CB4U },{ 0x53A0U, 0x99CCU },{ 0x53A5U, 0x99CEU },
{ 0x53A6U, 0x99CDU },{ 0x53A8U, 0x907EU },{ 0x53A9U, 0x8958U },
{ 0x53ADU, 0x897DU },{ 0x53AEU, 0x99CFU },{ 0x53B0U, 0x99D0U },
{ 0x53B2U, 0xFA8EU },{ 0x53B3U, 0x8CB5U },{ 0x53B6U, 0x99D1U },
{ 0x53BBU, 0x8B8EU },{ 0x53C2U, 0x8E51U },{ 0x53C3U, 0x99D2U },
{ 0x53C8U, 0x9694U },{ 0x53C9U, 0x8DB3U },{ 0x53CAU, 0x8B79U },
{ 0x53CBU, 0x9746U },{ 0x53CCU, 0x916FU },{ 0x53CDU, 0x94BDU },
{ 0x53CEU, 0x8EFBU },{ 0x53D4U, 0x8F66U },{ 0x53D6U, 0x8EE6U },
{ 0x53D7U, 0x8EF3U },{ 0x53D9U, 0x8F96U },{ 0x53DBU, 0x94BEU },
{ 0x53DDU, 0xFA8FU },{ 0x53DFU, 0x99D5U },{ 0x53E1U, 0x8962U },
{ 0x53E2U, 0x9170U },{ 0x53E3U, 0x8CFBU },{ 0x53E4U, 0x8CC3U },
{ 0x53E5U, 0x8BE5U },{ 0x53E8U, 0x99D9U },{ 0x53E9U, 0x9240U },
{ 0x53EAU, 0x91FCU },{ 0x53EBU, 0x8BA9U },{ 0x53ECU, 0x8FA2U },
{ 0x53EDU, 0x99DAU },{ 0x53EEU, 0x99D8U },{ 0x53EFU, 0x89C2U },
{ 0x53F0U, 0x91E4U },{ 0x53F1U, 0x8EB6U },{ 0x53F2U, 0x8E6AU },
{ 0x53F3U, 0x8945U },{ 0x53F6U, 0x8A90U },{ 0x53F7U, 0x8D86U },
{ 0x53F8U, 0x8E69U },{ 0x53FAU, 0x99DBU },{ 0x5401U, 0x99DCU },
{ 0x5403U, 0x8B68U },{ 0x5404U, 0x8A65U },{ 0x5408U, 0x8D87U },
{ 0x5409U, 0x8B67U },{ 0x540AU, 0x92DDU },{ 0x540BU, 0x8944U },
{ 0x540CU, 0x93AFU },{ 0x540DU, 0x96BCU },{ 0x540EU, 0x8D40U },
{ 0x540FU, 0x9799U },{ 0x5410U, 0x9366U },{ 0x5411U, 0x8CFCU },
{ 0x541BU, 0x8C4EU },{ 0x541DU, 0x99E5U },{ 0x541FU, 0x8BE1U },
{ 0x5420U, 0x9669U },{ 0x5426U, 0x94DBU },{ 0x5429U, 0x99E4U },
{ 0x542BU, 0x8ADCU },{ 0x542CU, 0x99DFU },{ 0x542DU, 0x99E0U },
{ 0x542EU, 0x99E2U },{ 0x5436U, 0x99E3U },{ 0x5438U, 0x8B7AU },
{ 0x5439U, 0x9081U },{ 0x543BU, 0x95ABU },{ 0x543CU, 0x99E1U },
{ 0x543DU, 0x99DDU },{ 0x543EU, 0x8CE1U },{ 0x5440U, 0x99DEU },
{ 0x5442U, 0x9843U },{ 0x5446U, 0x95F0U },{ 0x5448U, 0x92E6U },
{ 0x5449U, 0x8CE0U },{ 0x544AU, 0x8D90U },{ 0x544EU, 0x99E6U },
{ 0x5451U, 0x93DBU },{ 0x545FU, 0x99EAU },{ 0x5468U, 0x8EFCU },
{ 0x546AU, 0x8EF4U },{ 0x5470U, 0x99EDU },{ 0x5471U, 0x99EBU },
{ 0x5473U, 0x96A1U },{ 0x5475U, 0x99E8U },{ 0x5476U, 0x99F1U },
{ 0x5477U, 0x99ECU },{ 0x547BU, 0x99EFU },{ 0x547CU, 0x8CC4U },
{ 0x547DU, 0x96BDU },{ 0x5480U, 0x99F0U },{ 0x5484U, 0x99F2U },
{ 0x5486U, 0x99F4U },{ 0x548AU, 0xFA92U },{ 0x548BU, 0x8DEEU },
{ 0x548CU, 0x9861U },{ 0x548EU, 0x99E9U },{ 0x548FU, 0x99E7U },
{ 0x5490U, 0x99F3U },{ 0x5492U, 0x99EEU },{ 0x549CU, 0xFA91U },
{ 0x54A2U, 0x99F6U },{ 0x54A4U, 0x9A42U },{ 0x54A5U, 0x99F8U },
{ 0x54A8U, 0x99FCU },{ 0x54A9U, 0xFA93U },{ 0x54ABU, 0x9A40U },
{ 0x54ACU, 0x99F9U },{ 0x54AFU, 0x9A5DU },{ 0x54B2U, 0x8DE7U },
{ 0x54B3U, 0x8A50U },{ 0x54B8U, 0x99F7U },{ 0x54BCU, 0x9A44U },
{ 0x54BDU, 0x88F4U },{ 0x54BEU, 0x9A43U },{ 0x54C0U, 0x88A3U },
{ 0x54C1U, 0x9569U },{ 0x54C2U, 0x9A41U },{ 0x54C4U, 0x99FAU },
{ 0x54C7U, 0x99F5U },{ 0x54C8U, 0x99FBU },{ 0x54C9U, 0x8DC6U },
{ 0x54D8U, 0x9A45U },{ 0x54E1U, 0x88F5U },{ 0x54E2U, 0x9A4EU },
{ 0x54E5U, 0x9A46U },{ 0x54E6U, 0x9A47U },{ 0x54E8U, 0x8FA3U },
{ 0x54E9U, 0x9689U },{ 0x54EDU, 0x9A4CU },{ 0x54EEU, 0x9A4BU },
{ 0x54F2U, 0x934EU },{ 0x54FAU, 0x9A4DU },{ 0x54FDU, 0x9A4AU },
{ 0x54FFU, 0xFA94U },{ 0x5504U, 0x8953U },{ 0x5506U, 0x8DB4U },
{ 0x5507U, 0x904FU },{ 0x550FU, 0x9A48U },{ 0x5510U, 0x9382U },
{ 0x5514U, 0x9A49U },{ 0x5516U, 0x88A0U },{ 0x552EU, 0x9A53U },
{ 0x552FU, 0x9742U },{ 0x5531U, 0x8FA5U },{ 0x5533U, 0x9A59U },
{ 0x5538U, 0x9A58U },{ 0x5539U, 0x9A4FU },{ 0x553EU, 0x91C1U },
{ 0x5540U, 0x9A50U },{ 0x5544U, 0x91EDU },{ 0x5545U, 0x9A55U },
{ 0x5546U, 0x8FA4U },{ 0x554CU, 0x9A52U },{ 0x554FU, 0x96E2U },
{ 0x5553U, 0x8C5BU },{ 0x5556U, 0x9A56U },{ 0x5557U, 0x9A57U },
{ 0x555CU, 0x9A54U },{ 0x555DU, 0x9A5AU },{ 0x5563U, 0x9A51U },
{ 0x557BU, 0x9A60U },{ 0x557CU, 0x9A65U },{ 0x557EU, 0x9A61U },
{ 0x5580U, 0x9A5CU },{ 0x5583U, 0x9A66U },{ 0x5584U, 0x9150U },
{ 0x5586U, 0xFA95U },{ 0x5587U, 0x9A68U },{ 0x5589U, 0x8D41U },
{ 0x558AU, 0x9A5EU },{ 0x558BU, 0x929DU },{ 0x5598U, 0x9A62U },
{ 0x5599U, 0x9A5BU },{ 0x559AU, 0x8AABU },{ 0x559CU, 0x8AECU },
{ 0x559DU, 0x8A85U },{ 0x559EU, 0x9A63U },{ 0x559FU, 0x9A5FU },
{ 0x55A7U, 0x8C96U },{ 0x55A8U, 0x9A69U },{ 0x55A9U, 0x9A67U },
{ 0x55AAU, 0x9172U },{ 0x55ABU, 0x8B69U },{ 0x55ACU, 0x8BAAU },
{ 0x55AEU, 0x9A64U },{ 0x55B0U, 0x8BF2U },{ 0x55B6U, 0x8963U },
{ 0x55C4U, 0x9A6DU },{ 0x55C5U, 0x9A6BU },{ 0x55C7U, 0x9AA5U },
{ 0x55D4U, 0x9A70U },{ 0x55DAU, 0x9A6AU },{ 0x55DCU, 0x9A6EU },
{ 0x55DFU, 0x9A6CU },{ 0x55E3U, 0x8E6BU },{ 0x55E4U, 0x9A6FU },
{ 0x55F7U, 0x9A72U },{ 0x55F9U, 0x9A77U },{ 0x55FDU, 0x9A75U },
{ 0x55FEU, 0x9A74U },{ 0x5606U, 0x9251U },{ 0x5609U, 0x89C3U },
{ 0x5614U, 0x9A71U },{ 0x5616U, 0x9A73U },{ 0x5617U, 0x8FA6U },
{ 0x5618U, 0x8952U },{ 0x561BU, 0x9A76U },{ 0x5629U, 0x89DCU },
{ 0x562FU, 0x9A82U },{ 0x5631U, 0x8FFAU },{ 0x5632U, 0x9A7DU },
{ 0x5634U, 0x9A7BU },{ 0x5636U, 0x9A7CU },{ 0x5638U, 0x9A7EU },
{ 0x5642U, 0x895CU },{ 0x564CU, 0x9158U },{ 0x564EU, 0x9A78U },
{ 0x5650U, 0x9A79U },{ 0x565BU, 0x8A9AU },{ 0x5664U, 0x9A81U },
{ 0x5668U, 0x8AEDU },{ 0x566AU, 0x9A84U },{ 0x566BU, 0x9A80U },
{ 0x566CU, 0x9A83U },{ 0x5674U, 0x95ACU },{ 0x5678U, 0x93D3U },
{ 0x567AU, 0x94B6U },{ 0x5680U, 0x9A86U },{ 0x5686U, 0x9A85U },
{ 0x5687U, 0x8A64U },{ 0x568AU, 0x9A87U },{ 0x568FU, 0x9A8AU },
{ 0x5694U, 0x9A89U },{ 0x56A0U, 0x9A88U },{ 0x56A2U, 0x9458U },
{ 0x56A5U, 0x9A8BU },{ 0x56AEU, 0x9A8CU },{ 0x56B4U, 0x9A8EU },
{ 0x56B6U, 0x9A8DU },{ 0x56BCU, 0x9A90U },{ 0x56C0U, 0x9A93U },
{ 0x56C1U, 0x9A91U },{ 0x56C2U, 0x9A8FU },{ 0x56C3U, 0x9A92U },
{ 0x56C8U, 0x9A94U },{ 0x56CEU, 0x9A95U },{ 0x56D1U, 0x9A96U },
{ 0x56D3U, 0x9A97U },{ 0x56D7U, 0x9A98U },{ 0x56D8U, 0x9964U },
{ 0x56DAU, 0x8EFAU },{ 0x56DBU, 0x8E6CU },{ 0x56DEU, 0x89F1U },
{ 0x56E0U, 0x88F6U },{ 0x56E3U, 0x9263U },{ 0x56EEU, 0x9A99U },
{ 0x56F0U, 0x8DA2U },{ 0x56F2U, 0x88CDU },{ 0x56F3U, 0x907DU },
{ 0x56F9U, 0x9A9AU },{ 0x56FAU, 0x8CC5U },{ 0x56FDU, 0x8D91U },
{ 0x56FFU, 0x9A9CU },{ 0x5700U, 0x9A9BU },{ 0x5703U, 0x95DEU },
{ 0x5704U, 0x9A9DU },{ 0x5708U, 0x9A9FU },{ 0x5709U, 0x9A9EU },
{ 0x570BU, 0x9AA0U },{ 0x570DU, 0x9AA1U },{ 0x570FU, 0x8C97U },
{ 0x5712U, 0x8980U },{ 0x5713U, 0x9AA2U },{ 0x5716U, 0x9AA4U },
{ 0x5718U, 0x9AA3U },{ 0x571CU, 0x9AA6U },{ 0x571FU, 0x9379U },
{ 0x5726U, 0x9AA7U },{ 0x5727U, 0x88B3U },{ 0x5728U, 0x8DDDU },
{ 0x572DU, 0x8C5CU },{ 0x5730U, 0x926EU },{ 0x5737U, 0x9AA8U },
{ 0x5738U, 0x9AA9U },{ 0x573BU, 0x9AABU },{ 0x5740U, 0x9AACU },
{ 0x5742U, 0x8DE2U },{ 0x5747U, 0x8BCFU },{ 0x574AU, 0x9656U },
{ 0x574EU, 0x9AAAU },{ 0x574FU, 0x9AADU },{ 0x5750U, 0x8DBFU },
{ 0x5751U, 0x8D42U },{ 0x5759U, 0xFA96U },{ 0x5761U, 0x9AB1U },
{ 0x5764U, 0x8DA3U },{ 0x5765U, 0xFA97U },{ 0x5766U, 0x9252U },
{ 0x5769U, 0x9AAEU },{ 0x576AU, 0x92D8U },{ 0x577FU, 0x9AB2U },
{ 0x5782U, 0x9082U },{ 0x5788U, 0x9AB0U },{ 0x5789U, 0x9AB3U },
{ 0x578BU, 0x8C5EU },{ 0x5793U, 0x9AB4U },{ 0x57A0U, 0x9AB5U },
{ 0x57A2U, 0x8D43U },{ 0x57A3U, 0x8A5FU },{ 0x57A4U, 0x9AB7U },
{ 0x57AAU, 0x9AB8U },{ 0x57ACU, 0xFA98U },{ 0x57B0U, 0x9AB9U },
{ 0x57B3U, 0x9AB6U },{ 0x57C0U, 0x9AAFU },{ 0x57C3U, 0x9ABAU },
{ 0x57C6U, 0x9ABBU },{ 0x57C7U, 0xFA9AU },{ 0x57C8U, 0xFA99U },
{ 0x57CBU, 0x9684U },{ 0x57CEU, 0x8FE9U },{ 0x57D2U, 0x9ABDU },
{ 0x57D3U, 0x9ABEU },{ 0x57D4U, 0x9ABCU },{ 0x57D6U, 0x9AC0U },
{ 0x57DCU, 0x9457U },{ 0x57DFU, 0x88E6U },{ 0x57E0U, 0x9575U },
{ 0x57E3U, 0x9AC1U },{ 0x57F4U, 0x8FFBU },{ 0x57F7U, 0x8EB7U },
{ 0x57F9U, 0x947CU },{ 0x57FAU, 0x8AEEU },{ 0x57FCU, 0x8DE9U },
{ 0x5800U, 0x9678U },{ 0x5802U, 0x93B0U },{ 0x5805U, 0x8C98U },
{ 0x5806U, 0x91CDU },{ 0x580AU, 0x9ABFU },{ 0x580BU, 0x9AC2U },
{ 0x5815U, 0x91C2U },{ 0x5819U, 0x9AC3U },{ 0x581DU, 0x9AC4U },
{ 0x5821U, 0x9AC6U },{ 0x5824U, 0x92E7U },{ 0x582AU, 0x8AACU },
{ 0x582FU, 0xEA9FU },{ 0x5830U, 0x8981U },{ 0x5831U, 0x95F1U },
{ 0x5834U, 0x8FEAU },{ 0x5835U, 0x9367U },{ 0x583AU, 0x8DE4U },
{ 0x583DU, 0x9ACCU },{ 0x5840U, 0x95BBU },{ 0x5841U, 0x97DBU },
{ 0x584AU, 0x89F2U },{ 0x584BU, 0x9AC8U },{ 0x5851U, 0x9159U },
{ 0x5852U, 0x9ACBU },{ 0x5854U, 0x9383U },{ 0x5857U, 0x9368U },
{ 0x5858U, 0x9384U },{ 0x5859U, 0x94B7U },{ 0x585AU, 0x92CBU },
{ 0x585EU, 0x8DC7U },{ 0x5862U, 0x9AC7U },{ 0x5869U, 0x8996U },
{ 0x586BU, 0x9355U },{ 0x5870U, 0x9AC9U },{ 0x5872U, 0x9AC5U },
{ 0x5875U, 0x906FU },{ 0x5879U, 0x9ACDU },{ 0x587EU, 0x8F6DU },
{ 0x5883U, 0x8BABU },{ 0x5885U, 0x9ACEU },{ 0x5893U, 0x95E6U },
{ 0x5897U, 0x919DU },{ 0x589CU, 0x92C4U },{ 0x589EU, 0xFA9DU },
{ 0x589FU, 0x9AD0U },{ 0x58A8U, 0x966EU },{ 0x58ABU, 0x9AD1U },
{ 0x58AEU, 0x9AD6U },{ 0x58B2U, 0xFA9EU },{ 0x58B3U, 0x95ADU },
{ 0x58B8U, 0x9AD5U },{ 0x58B9U, 0x9ACFU },{ 0x58BAU, 0x9AD2U },
{ 0x58BBU, 0x9AD4U },{ 0x58BEU, 0x8DA4U },{ 0x58C1U, 0x95C7U },
{ 0x58C5U, 0x9AD7U },{ 0x58C7U, 0x9264U },{ 0x58CAU, 0x89F3U },
{ 0x58CCU, 0x8FEBU },{ 0x58D1U, 0x9AD9U },{ 0x58D3U, 0x9AD8U },
{ 0x58D5U, 0x8D88U },{ 0x58D7U, 0x9ADAU },{ 0x58D8U, 0x9ADCU },
{ 0x58D9U, 0x9ADBU },{ 0x58DCU, 0x9ADEU },{ 0x58DEU, 0x9AD3U },
{ 0x58DFU, 0x9AE0U },{ 0x58E4U, 0x9ADFU },{ 0x58E5U, 0x9ADDU },
{ 0x58EBU, 0x8E6DU },{ 0x58ECU, 0x9070U },{ 0x58EEU, 0x9173U },
{ 0x58EFU, 0x9AE1U },{ 0x58F0U, 0x90BAU },{ 0x58F1U, 0x88EBU },
{ 0x58F2U, 0x9484U },{ 0x58F7U, 0x92D9U },{ 0x58F9U, 0x9AE3U },
{ 0x58FAU, 0x9AE2U },{ 0x58FBU, 0x9AE4U },{ 0x58FCU, 0x9AE5U },
{ 0x58FDU, 0x9AE6U },{ 0x5902U, 0x9AE7U },{ 0x5909U, 0x95CFU },
{ 0x590AU, 0x9AE8U },{ 0x590BU, 0xFA9FU },{ 0x590FU, 0x89C4U },
{ 0x5910U, 0x9AE9U },{ 0x5915U, 0x975BU },{ 0x5916U, 0x8A4FU },
{ 0x5918U, 0x99C7U },{ 0x5919U, 0x8F67U },{ 0x591AU, 0x91BDU },
{ 0x591BU, 0x9AEAU },{ 0x591CU, 0x96E9U },{ 0x5922U, 0x96B2U },
{ 0x5925U, 0x9AECU },{ 0x5927U, 0x91E5U },{ 0x5929U, 0x9356U },
{ 0x592AU, 0x91BEU },{ 0x592BU, 0x9576U },{ 0x592CU, 0x9AEDU },
{ 0x592DU, 0x9AEEU },{ 0x592EU, 0x899BU },{ 0x5931U, 0x8EB8U },
{ 0x5932U, 0x9AEFU },{ 0x5937U, 0x88CEU },{ 0x5938U, 0x9AF0U },
{ 0x593EU, 0x9AF1U },{ 0x5944U, 0x8982U },{ 0x5947U, 0x8AEFU },
{ 0x5948U, 0x93DEU },{ 0x5949U, 0x95F2U },{ 0x594EU, 0x9AF5U },
{ 0x594FU, 0x9174U },{ 0x5950U, 0x9AF4U },{ 0x5951U, 0x8C5FU },
{ 0x5953U, 0xFAA0U },{ 0x5954U, 0x967AU },{ 0x5955U, 0x9AF3U },
{ 0x5957U, 0x9385U },{ 0x5958U, 0x9AF7U },{ 0x595AU, 0x9AF6U },
{ 0x595BU, 0xFAA1U },{ 0x595DU, 0xFAA2U },{ 0x5960U, 0x9AF9U },
{ 0x5962U, 0x9AF8U },{ 0x5963U, 0xFAA3U },{ 0x5965U, 0x899CU },
{ 0x5967U, 0x9AFAU },{ 0x5968U, 0x8FA7U },{ 0x5969U, 0x9AFCU },
{ 0x596AU, 0x9244U },{ 0x596CU, 0x9AFBU },{ 0x596EU, 0x95B1U },
{ 0x5973U, 0x8F97U },{ 0x5974U, 0x937AU },{ 0x5978U, 0x9B40U },
{ 0x597DU, 0x8D44U },{ 0x5981U, 0x9B41U },{ 0x5982U, 0x9440U },
{ 0x5983U, 0x94DCU },{ 0x5984U, 0x96CFU },{ 0x598AU, 0x9444U },
{ 0x598DU, 0x9B4AU },{ 0x5993U, 0x8B57U },{ 0x5996U, 0x9764U },
{ 0x5999U, 0x96ADU },{ 0x599BU, 0x9BAAU },{ 0x599DU, 0x9B42U },
{ 0x59A3U, 0x9B45U },{ 0x59A4U, 0xFAA4U },{ 0x59A5U, 0x91C3U },
{ 0x59A8U, 0x9657U },{ 0x59ACU, 0x9369U },{ 0x59B2U, 0x9B46U },
{ 0x59B9U, 0x9685U },{ 0x59BAU, 0xFAA5U },{ 0x59BBU, 0x8DC8U },
{ 0x59BEU, 0x8FA8U },{ 0x59C6U, 0x9B47U },{ 0x59C9U, 0x8E6FU },
{ 0x59CBU, 0x8E6EU },{ 0x59D0U, 0x88B7U },{ 0x59D1U, 0x8CC6U },
{ 0x59D3U, 0x90A9U },{ 0x59D4U, 0x88CFU },{ 0x59D9U, 0x9B4BU },
{ 0x59DAU, 0x9B4CU },{ 0x59DCU, 0x9B49U },{ 0x59E5U, 0x8957U },
{ 0x59E6U, 0x8AADU },{ 0x59E8U, 0x9B48U },{ 0x59EAU, 0x96C3U },
{ 0x59EBU, 0x9550U },{ 0x59F6U, 0x88A6U },{ 0x59FBU, 0x88F7U },
{ 0x59FFU, 0x8E70U },{ 0x5A01U, 0x88D0U },{ 0x5A03U, 0x88A1U },
{ 0x5A09U, 0x9B51U },{ 0x5A11U, 0x9B4FU },{ 0x5A18U, 0x96BAU },
{ 0x5A1AU, 0x9B52U },{ 0x5A1CU, 0x9B50U },{ 0x5A1FU, 0x9B4EU },
{ 0x5A20U, 0x9050U },{ 0x5A25U, 0x9B4DU },{ 0x5A29U, 0x95D8U },
{ 0x5A2FU, 0x8CE2U },{ 0x5A35U, 0x9B56U },{ 0x5A36U, 0x9B57U },
{ 0x5A3CU, 0x8FA9U },{ 0x5A40U, 0x9B53U },{ 0x5A41U, 0x984BU },
{ 0x5A46U, 0x946BU },{ 0x5A49U, 0x9B55U },{ 0x5A5AU, 0x8DA5U },
{ 0x5A62U, 0x9B58U },{ 0x5A66U, 0x9577U },{ 0x5A6AU, 0x9B59U },
{ 0x5A6CU, 0x9B54U },{ 0x5A7FU, 0x96B9U },{ 0x5A92U, 0x947DU },
{ 0x5A9AU, 0x9B5AU },{ 0x5A9BU, 0x9551U },{ 0x5ABCU, 0x9B5BU },
{ 0x5ABDU, 0x9B5FU },{ 0x5ABEU, 0x9B5CU },{ 0x5AC1U, 0x89C5U },
{ 0x5AC2U, 0x9B5EU },{ 0x5AC9U, 0x8EB9U },{ 0x5ACBU, 0x9B5DU },
{ 0x5ACCU, 0x8C99U },{ 0x5AD0U, 0x9B6BU },{ 0x5AD6U, 0x9B64U },
{ 0x5AD7U, 0x9B61U },{ 0x5AE1U, 0x9284U },{ 0x5AE3U, 0x9B60U },
{ 0x5AE6U, 0x9B62U },{ 0x5AE9U, 0x9B63U },{ 0x5AFAU, 0x9B65U },
{ 0x5AFBU, 0x9B66U },{ 0x5B09U, 0x8AF0U },{ 0x5B0BU, 0x9B68U },
{ 0x5B0CU, 0x9B67U },{ 0x5B16U, 0x9B69U },{ 0x5B22U, 0x8FECU },
{ 0x5B2AU, 0x9B6CU },{ 0x5B2CU, 0x92DAU },{ 0x5B30U, 0x8964U },
{ 0x5B32U, 0x9B6AU },{ 0x5B36U, 0x9B6DU },{ 0x5B3EU, 0x9B6EU },
{ 0x5B40U, 0x9B71U },{ 0x5B43U, 0x9B6FU },{ 0x5B45U, 0x9B70U },
{ 0x5B50U, 0x8E71U },{ 0x5B51U, 0x9B72U },{ 0x5B54U, 0x8D45U },
{ 0x5B55U, 0x9B73U },{ 0x5B56U, 0xFAA6U },{ 0x5B57U, 0x8E9AU },
{ 0x5B58U, 0x91B6U },{ 0x5B5AU, 0x9B74U },{ 0x5B5BU, 0x9B75U },
{ 0x5B5CU, 0x8E79U },{ 0x5B5DU, 0x8D46U },{ 0x5B5FU, 0x96D0U },
{ 0x5B63U, 0x8B47U },{ 0x5B64U, 0x8CC7U },{ 0x5B65U, 0x9B76U },
{ 0x5B66U, 0x8A77U },{ 0x5B69U, 0x9B77U },{ 0x5B6BU, 0x91B7U },
{ 0x5B70U, 0x9B78U },{ 0x5B71U, 0x9BA1U },{ 0x5B73U, 0x9B79U },
{ 0x5B75U, 0x9B7AU },{ 0x5B78U, 0x9B7BU },{ 0x5B7AU, 0x9B7DU },
{ 0x5B80U, 0x9B7EU },{ 0x5B83U, 0x9B80U },{ 0x5B85U, 0x91EEU },
{ 0x5B87U, 0x8946U },{ 0x5B88U, 0x8EE7U },{ 0x5B89U, 0x88C0U },
{ 0x5B8BU, 0x9176U },{ 0x5B8CU, 0x8AAEU },{ 0x5B8DU, 0x8EB3U },
{ 0x5B8FU, 0x8D47U },{ 0x5B95U, 0x9386U },{ 0x5B97U, 0x8F40U },
{ 0x5B98U, 0x8AAFU },{ 0x5B99U, 0x9288U },{ 0x5B9AU, 0x92E8U },
{ 0x5B9BU, 0x88B6U },{ 0x5B9CU, 0x8B58U },{ 0x5B9DU, 0x95F3U },
{ 0x5B9FU, 0x8EC0U },{ 0x5BA2U, 0x8B71U },{ 0x5BA3U, 0x90E9U },
{ 0x5BA4U, 0x8EBAU },{ 0x5BA5U, 0x9747U },{ 0x5BA6U, 0x9B81U },
{ 0x5BAEU, 0x8B7BU },{ 0x5BB0U, 0x8DC9U },{ 0x5BB3U, 0x8A51U },
{ 0x5BB4U, 0x8983U },{ 0x5BB5U, 0x8FAAU },{ 0x5BB6U, 0x89C6U },
{ 0x5BB8U, 0x9B82U },{ 0x5BB9U, 0x9765U },{ 0x5BBFU, 0x8F68U },
{ 0x5BC0U, 0xFAA7U },{ 0x5BC2U, 0x8EE2U },{ 0x5BC3U, 0x9B83U },
{ 0x5BC4U, 0x8AF1U },{ 0x5BC5U, 0x93D0U },{ 0x5BC6U, 0x96A7U },
{ 0x5BC7U, 0x9B84U },{ 0x5BC9U, 0x9B85U },{ 0x5BCCU, 0x9578U },
{ 0x5BD0U, 0x9B87U },{ 0x5BD2U, 0x8AA6U },{ 0x5BD3U, 0x8BF5U },
{ 0x5BD4U, 0x9B86U },{ 0x5BD8U, 0xFAA9U },{ 0x5BDBU, 0x8AB0U },
{ 0x5BDDU, 0x9051U },{ 0x5BDEU, 0x9B8BU },{ 0x5BDFU, 0x8E40U },
{ 0x5BE1U, 0x89C7U },{ 0x5BE2U, 0x9B8AU },{ 0x5BE4U, 0x9B88U },
{ 0x5BE5U, 0x9B8CU },{ 0x5BE6U, 0x9B89U },{ 0x5BE7U, 0x944AU },
{ 0x5BE8U, 0x9ECBU },{ 0x5BE9U, 0x9052U },{ 0x5BEBU, 0x9B8DU },
{ 0x5BECU, 0xFAAAU },{ 0x5BEEU, 0x97BEU },{ 0x5BF0U, 0x9B8EU },
{ 0x5BF3U, 0x9B90U },{ 0x5BF5U, 0x929EU },{ 0x5BF6U, 0x9B8FU },
{ 0x5BF8U, 0x90A1U },{ 0x5BFAU, 0x8E9BU },{ 0x5BFEU, 0x91CEU },
{ 0x5BFFU, 0x8EF5U },{ 0x5C01U, 0x9595U },{ 0x5C02U, 0x90EAU },
{ 0x5C04U, 0x8ECBU },{ 0x5C05U, 0x9B91U },{ 0x5C06U, 0x8FABU },
{ 0x5C07U, 0x9B92U },{ 0x5C08U, 0x9B93U },{ 0x5C09U, 0x88D1U },
{ 0x5C0AU, 0x91B8U },{ 0x5C0BU, 0x9071U },{ 0x5C0DU, 0x9B94U },
{ 0x5C0EU, 0x93B1U },{ 0x5C0FU, 0x8FACU },{ 0x5C11U, 0x8FADU },
{ 0x5C13U, 0x9B95U },{ 0x5C16U, 0x90EBU },{ 0x5C1AU, 0x8FAEU },
{ 0x5C1EU, 0xFAABU },{ 0x5C20U, 0x9B96U },{ 0x5C22U, 0x9B97U },
{ 0x5C24U, 0x96DEU },{ 0x5C28U, 0x9B98U },{ 0x5C2DU, 0x8BC4U },
{ 0x5C31U, 0x8F41U },{ 0x5C38U, 0x9B99U },{ 0x5C39U, 0x9B9AU },
{ 0x5C3AU, 0x8EDAU },{ 0x5C3BU, 0x904BU },{ 0x5C3CU, 0x93F2U },
{ 0x5C3DU, 0x9073U },{ 0x5C3EU, 0x94F6U },{ 0x5C3FU, 0x9441U },
{ 0x5C40U, 0x8BC7U },{ 0x5C41U, 0x9B9BU },{ 0x5C45U, 0x8B8FU },
{ 0x5C46U, 0x9B9CU },{ 0x5C48U, 0x8BFCU },{ 0x5C4AU, 0x93CDU },
{ 0x5C4BU, 0x89AEU },{ 0x5C4DU, 0x8E72U },{ 0x5C4EU, 0x9B9DU },
{ 0x5C4FU, 0x9BA0U },{ 0x5C50U, 0x9B9FU },{ 0x5C51U, 0x8BFBU },
{ 0x5C53U, 0x9B9EU },{ 0x5C55U, 0x9357U },{ 0x5C5EU, 0x91AEU },
{ 0x5C60U, 0x936AU },{ 0x5C61U, 0x8EC6U },{ 0x5C64U, 0x9177U },
{ 0x5C65U, 0x979AU },{ 0x5C6CU, 0x9BA2U },{ 0x5C6EU, 0x9BA3U },
{ 0x5C6FU, 0x93D4U },{ 0x5C71U, 0x8E52U },{ 0x5C76U, 0x9BA5U },
{ 0x5C79U, 0x9BA6U },{ 0x5C8CU, 0x9BA7U },{ 0x5C90U, 0x8AF2U },
{ 0x5C91U, 0x9BA8U },{ 0x5C94U, 0x9BA9U },{ 0x5CA1U, 0x89AAU },
{ 0x5CA6U, 0xFAACU },{ 0x5CA8U, 0x915AU },{ 0x5CA9U, 0x8AE2U },
{ 0x5CABU, 0x9BABU },{ 0x5CACU, 0x96A6U },{ 0x5CB1U, 0x91D0U },
{ 0x5CB3U, 0x8A78U },{ 0x5CB6U, 0x9BADU },{ 0x5CB7U, 0x9BAFU },
{ 0x5CB8U, 0x8ADDU },{ 0x5CBAU, 0xFAADU },{ 0x5CBBU, 0x9BACU },
{ 0x5CBCU, 0x9BAEU },{ 0x5CBEU, 0x9BB1U },{ 0x5CC5U, 0x9BB0U },
{ 0x5CC7U, 0x9BB2U },{ 0x5CD9U, 0x9BB3U },{ 0x5CE0U, 0x93BBU },
{ 0x5CE1U, 0x8BACU },{ 0x5CE8U, 0x89E3U },{ 0x5CE9U, 0x9BB4U },
{ 0x5CEAU, 0x9BB9U },{ 0x5CEDU, 0x9BB7U },{ 0x5CEFU, 0x95F5U },
{ 0x5CF0U, 0x95F4U },{ 0x5CF5U, 0xFAAEU },{ 0x5CF6U, 0x9387U },
{ 0x5CFAU, 0x9BB6U },{ 0x5CFBU, 0x8F73U },{ 0x5CFDU, 0x9BB5U },
{ 0x5D07U, 0x9092U },{ 0x5D0BU, 0x9BBAU },{ 0x5D0EU, 0x8DE8U },
{ 0x5D11U, 0x9BC0U },{ 0x5D14U, 0x9BC1U },{ 0x5D15U, 0x9BBBU },
{ 0x5D16U, 0x8A52U },{ 0x5D17U, 0x9BBCU },{ 0x5D18U, 0x9BC5U },
{ 0x5D19U, 0x9BC4U },{ 0x5D1AU, 0x9BC3U },{ 0x5D1BU, 0x9BBFU },
{ 0x5D1FU, 0x9BBEU },{ 0x5D22U, 0x9BC2U },{ 0x5D27U, 0xFAAFU },
{ 0x5D29U, 0x95F6U },{ 0x5D42U, 0xFAB2U },{ 0x5D4BU, 0x9BC9U },
{ 0x5D4CU, 0x9BC6U },{ 0x5D4EU, 0x9BC8U },{ 0x5D50U, 0x9792U },
{ 0x5D52U, 0x9BC7U },{ 0x5D53U, 0xFAB0U },{ 0x5D5CU, 0x9BBDU },
{ 0x5D69U, 0x9093U },{ 0x5D6CU, 0x9BCAU },{ 0x5D6DU, 0xFAB3U },
{ 0x5D6FU, 0x8DB5U },{ 0x5D73U, 0x9BCBU },{ 0x5D76U, 0x9BCCU },
{ 0x5D82U, 0x9BCFU },{ 0x5D84U, 0x9BCEU },{ 0x5D87U, 0x9BCDU },
{ 0x5D8BU, 0x9388U },{ 0x5D8CU, 0x9BB8U },{ 0x5D90U, 0x9BD5U },
{ 0x5D9DU, 0x9BD1U },{ 0x5DA2U, 0x9BD0U },{ 0x5DACU, 0x9BD2U },
{ 0x5DAEU, 0x9BD3U },{ 0x5DB7U, 0x9BD6U },{ 0x5DB8U, 0xFAB4U },
{ 0x5DB9U, 0xFAB5U },{ 0x5DBAU, 0x97E4U },{ 0x5DBCU, 0x9BD7U },
{ 0x5DBDU, 0x9BD4U },{ 0x5DC9U, 0x9BD8U },{ 0x5DCCU, 0x8ADEU },
{ 0x5DCDU, 0x9BD9U },{ 0x5DD0U, 0xFAB6U },{ 0x5DD2U, 0x9BDBU },
{ 0x5DD3U, 0x9BDAU },{ 0x5DD6U, 0x9BDCU },{ 0x5DDBU, 0x9BDDU },
{ 0x5DDDU, 0x90ECU },{ 0x5DDEU, 0x8F42U },{ 0x5DE1U, 0x8F84U },
{ 0x5DE3U, 0x9183U },{ 0x5DE5U, 0x8D48U },{ 0x5DE6U, 0x8DB6U },
{ 0x5DE7U, 0x8D49U },{ 0x5DE8U, 0x8B90U },{ 0x5DEBU, 0x9BDEU },
{ 0x5DEEU, 0x8DB7U },{ 0x5DF1U, 0x8CC8U },{ 0x5DF2U, 0x9BDFU },
{ 0x5DF3U, 0x96A4U },{ 0x5DF4U, 0x9462U },{ 0x5DF5U, 0x9BE0U },
{ 0x5DF7U, 0x8D4AU },{ 0x5DFBU, 0x8AAAU },{ 0x5DFDU, 0x9246U },
{ 0x5DFEU, 0x8BD0U },{ 0x5E02U, 0x8E73U },{ 0x5E03U, 0x957AU },
{ 0x5E06U, 0x94BFU },{ 0x5E0BU, 0x9BE1U },{ 0x5E0CU, 0x8AF3U },
{ 0x5E11U, 0x9BE4U },{ 0x5E16U, 0x929FU },{ 0x5E19U, 0x9BE3U },
{ 0x5E1AU, 0x9BE2U },{ 0x5E1BU, 0x9BE5U },{ 0x5E1DU, 0x92E9U },
{ 0x5E25U, 0x9083U },{ 0x5E2BU, 0x8E74U },{ 0x5E2DU, 0x90C8U },
{ 0x5E2FU, 0x91D1U },{ 0x5E30U, 0x8B41U },{ 0x5E33U, 0x92A0U },
{ 0x5E36U, 0x9BE6U },{ 0x5E37U, 0x9BE7U },{ 0x5E38U, 0x8FEDU },
{ 0x5E3DU, 0x9658U },{ 0x5E40U, 0x9BEAU },{ 0x5E43U, 0x9BE9U },
{ 0x5E44U, 0x9BE8U },{ 0x5E45U, 0x959DU },{ 0x5E47U, 0x9BF1U },
{ 0x5E4CU, 0x9679U },{ 0x5E4EU, 0x9BEBU },{ 0x5E54U, 0x9BEDU },
{ 0x5E55U, 0x968BU },{ 0x5E57U, 0x9BECU },{ 0x5E5FU, 0x9BEEU },
{ 0x5E61U, 0x94A6U },{ 0x5E62U, 0x9BEFU },{ 0x5E63U, 0x95BCU },
{ 0x5E64U, 0x9BF0U },{ 0x5E72U, 0x8AB1U },{ 0x5E73U, 0x95BDU },
{ 0x5E74U, 0x944EU },{ 0x5E75U, 0x9BF2U },{ 0x5E76U, 0x9BF3U },
{ 0x5E78U, 0x8D4BU },{ 0x5E79U, 0x8AB2U },{ 0x5E7AU, 0x9BF4U },
{ 0x5E7BU, 0x8CB6U },{ 0x5E7CU, 0x9763U },{ 0x5E7DU, 0x9748U },
{ 0x5E7EU, 0x8AF4U },{ 0x5E7FU, 0x9BF6U },{ 0x5E81U, 0x92A1U },
{ 0x5E83U, 0x8D4CU },{ 0x5E84U, 0x8FAFU },{ 0x5E87U, 0x94DDU },
{ 0x5E8AU, 0x8FB0U },{ 0x5E8FU, 0x8F98U },{ 0x5E95U, 0x92EAU },
{ 0x5E96U, 0x95F7U },{ 0x5E97U, 0x9358U },{ 0x5E9AU, 0x8D4DU },
{ 0x5E9CU, 0x957BU },{ 0x5EA0U, 0x9BF7U },{ 0x5EA6U, 0x9378U },
{ 0x5EA7U, 0x8DC0U },{ 0x5EABU, 0x8CC9U },{ 0x5EADU, 0x92EBU },
{ 0x5EB5U, 0x88C1U },{ 0x5EB6U, 0x8F8EU },{ 0x5EB7U, 0x8D4EU },
{ 0x5EB8U, 0x9766U },{ 0x5EC1U, 0x9BF8U },{ 0x5EC2U, 0x9BF9U },
{ 0x5EC3U, 0x9470U },{ 0x5EC8U, 0x9BFAU },{ 0x5EC9U, 0x97F5U },
{ 0x5ECAU, 0x984CU },{ 0x5ECFU, 0x9BFCU },{ 0x5ED0U, 0x9BFBU },
{ 0x5ED3U, 0x8A66U },{ 0x5ED6U, 0x9C40U },{ 0x5EDAU, 0x9C43U },
{ 0x5EDBU, 0x9C44U },{ 0x5EDDU, 0x9C42U },{ 0x5EDFU, 0x955FU },
{ 0x5EE0U, 0x8FB1U },{ 0x5EE1U, 0x9C46U },{ 0x5EE2U, 0x9C45U },
{ 0x5EE3U, 0x9C41U },{ 0x5EE8U, 0x9C47U },{ 0x5EE9U, 0x9C48U },
{ 0x5EECU, 0x9C49U },{ 0x5EF0U, 0x9C4CU },{ 0x5EF1U, 0x9C4AU },
{ 0x5EF3U, 0x9C4BU },{ 0x5EF4U, 0x9C4DU },{ 0x5EF6U, 0x8984U },
{ 0x5EF7U, 0x92ECU },{ 0x5EF8U, 0x9C4EU },{ 0x5EFAU, 0x8C9AU },
{ 0x5EFBU, 0x89F4U },{ 0x5EFCU, 0x9455U },{ 0x5EFEU, 0x9C4FU },
{ 0x5EFFU, 0x93F9U },{ 0x5F01U, 0x95D9U },{ 0x5F03U, 0x9C50U },
{ 0x5F04U, 0x984DU },{ 0x5F09U, 0x9C51U },{ 0x5F0AU, 0x95BEU },
{ 0x5F0BU, 0x9C54U },{ 0x5F0CU, 0x989FU },{ 0x5F0DU, 0x98AFU },
{ 0x5F0FU, 0x8EAEU },{ 0x5F10U, 0x93F3U },{ 0x5F11U, 0x9C55U },
{ 0x5F13U, 0x8B7CU },{ 0x5F14U, 0x92A2U },{ 0x5F15U, 0x88F8U },
{ 0x5F16U, 0x9C56U },{ 0x5F17U, 0x95A4U },{ 0x5F18U, 0x8D4FU },
{ 0x5F1BU, 0x926FU },{ 0x5F1FU, 0x92EDU },{ 0x5F21U, 0xFAB7U },
{ 0x5F25U, 0x96EDU },{ 0x5F26U, 0x8CB7U },{ 0x5F27U, 0x8CCAU },
{ 0x5F29U, 0x9C57U },{ 0x5F2DU, 0x9C58U },{ 0x5F2FU, 0x9C5EU },
{ 0x5F31U, 0x8EE3U },{ 0x5F34U, 0xFAB8U },{ 0x5F35U, 0x92A3U },
{ 0x5F37U, 0x8BADU },{ 0x5F38U, 0x9C59U },{ 0x5F3CU, 0x954AU },
{ 0x5F3EU, 0x9265U },{ 0x5F41U, 0x9C5AU },{ 0x5F45U, 0xFA67U },
{ 0x5F48U, 0x9C5BU },{ 0x5F4AU, 0x8BAEU },{ 0x5F4CU, 0x9C5CU },
{ 0x5F4EU, 0x9C5DU },{ 0x5F51U, 0x9C5FU },{ 0x5F53U, 0x9396U },
{ 0x5F56U, 0x9C60U },{ 0x5F57U, 0x9C61U },{ 0x5F59U, 0x9C62U },
{ 0x5F5CU, 0x9C53U },{ 0x5F5DU, 0x9C52U },{ 0x5F61U, 0x9C63U },
{ 0x5F62U, 0x8C60U },{ 0x5F66U, 0x9546U },{ 0x5F67U, 0xFAB9U },
{ 0x5F69U, 0x8DCAU },{ 0x5F6AU, 0x9556U },{ 0x5F6BU, 0x92A4U },
{ 0x5F6CU, 0x956AU },{ 0x5F6DU, 0x9C64U },{ 0x5F70U, 0x8FB2U },
{ 0x5F71U, 0x8965U },{ 0x5F73U, 0x9C65U },{ 0x5F77U, 0x9C66U },
{ 0x5F79U, 0x96F0U },{ 0x5F7CU, 0x94DEU },{ 0x5F7FU, 0x9C69U },
{ 0x5F80U, 0x899DU },{ 0x5F81U, 0x90AAU },{ 0x5F82U, 0x9C68U },
{ 0x5F83U, 0x9C67U },{ 0x5F84U, 0x8C61U },{ 0x5F85U, 0x91D2U },
{ 0x5F87U, 0x9C6DU },{ 0x5F88U, 0x9C6BU },{ 0x5F8AU, 0x9C6AU },
{ 0x5F8BU, 0x97A5U },{ 0x5F8CU, 0x8CE3U },{ 0x5F90U, 0x8F99U },
{ 0x5F91U, 0x9C6CU },{ 0x5F92U, 0x936BU },{ 0x5F93U, 0x8F5DU },
{ 0x5F97U, 0x93BEU },{ 0x5F98U, 0x9C70U },{ 0x5F99U, 0x9C6FU },
{ 0x5F9EU, 0x9C6EU },{ 0x5FA0U, 0x9C71U },{ 0x5FA1U, 0x8CE4U },
{ 0x5FA8U, 0x9C72U },{ 0x5FA9U, 0x959CU },{ 0x5FAAU, 0x8F7AU },
{ 0x5FADU, 0x9C73U },{ 0x5FAEU, 0x94F7U },{ 0x5FB3U, 0x93BFU },
{ 0x5FB4U, 0x92A5U },{ 0x5FB7U, 0xFABAU },{ 0x5FB9U, 0x934FU },
{ 0x5FBCU, 0x9C74U },{ 0x5FBDU, 0x8B4AU },{ 0x5FC3U, 0x9053U },
{ 0x5FC5U, 0x954BU },{ 0x5FCCU, 0x8AF5U },{ 0x5FCDU, 0x9445U },
{ 0x5FD6U, 0x9C75U },{ 0x5FD7U, 0x8E75U },{ 0x5FD8U, 0x9659U },
{ 0x5FD9U, 0x965AU },{ 0x5FDCU, 0x899EU },{ 0x5FDDU, 0x9C7AU },
{ 0x5FDEU, 0xFABBU },{ 0x5FE0U, 0x9289U },{ 0x5FE4U, 0x9C77U },
{ 0x5FEBU, 0x89F5U },{ 0x5FF0U, 0x9CABU },{ 0x5FF1U, 0x9C79U },
{ 0x5FF5U, 0x944FU },{ 0x5FF8U, 0x9C78U },{ 0x5FFBU, 0x9C76U },
{ 0x5FFDU, 0x8D9AU },{ 0x5FFFU, 0x9C7CU },{ 0x600EU, 0x9C83U },
{ 0x600FU, 0x9C89U },{ 0x6010U, 0x9C81U },{ 0x6012U, 0x937BU },
{ 0x6015U, 0x9C86U },{ 0x6016U, 0x957CU },{ 0x6019U, 0x9C80U },
{ 0x601BU, 0x9C85U },{ 0x601CU, 0x97E5U },{ 0x601DU, 0x8E76U },
{ 0x6020U, 0x91D3U },{ 0x6021U, 0x9C7DU },{ 0x6025U, 0x8B7DU },
{ 0x6026U, 0x9C88U },{ 0x6027U, 0x90ABU },{ 0x6028U, 0x8985U },
{ 0x6029U, 0x9C82U },{ 0x602AU, 0x89F6U },{ 0x602BU, 0x9C87U },
{ 0x602FU, 0x8BAFU },{ 0x6031U, 0x9C84U },{ 0x603AU, 0x9C8AU },
{ 0x6041U, 0x9C8CU },{ 0x6042U, 0x9C96U },{ 0x6043U, 0x9C94U },
{ 0x6046U, 0x9C91U },{ 0x604AU, 0x9C90U },{ 0x604BU, 0x97F6U },
{ 0x604DU, 0x9C92U },{ 0x6050U, 0x8BB0U },{ 0x6052U, 0x8D50U },
{ 0x6055U, 0x8F9AU },{ 0x6059U, 0x9C99U },{ 0x605AU, 0x9C8BU },
{ 0x605DU, 0xFABCU },{ 0x605FU, 0x9C8FU },{ 0x6060U, 0x9C7EU },
{ 0x6062U, 0x89F8U },{ 0x6063U, 0x9C93U },{ 0x6064U, 0x9C95U },
{ 0x6065U, 0x9270U },{ 0x6068U, 0x8DA6U },{ 0x6069U, 0x89B6U },
{ 0x606AU, 0x9C8DU },{ 0x606BU, 0x9C98U },{ 0x606CU, 0x9C97U },
{ 0x606DU, 0x8BB1U },{ 0x606FU, 0x91A7U },{ 0x6070U, 0x8A86U },
{ 0x6075U, 0x8C62U },{ 0x6077U, 0x9C8EU },{ 0x6081U, 0x9C9AU },
{ 0x6083U, 0x9C9DU },{ 0x6084U, 0x9C9FU },{ 0x6085U, 0xFABDU },
{ 0x6089U, 0x8EBBU },{ 0x608AU, 0xFABEU },{ 0x608BU, 0x9CA5U },
{ 0x608CU, 0x92EEU },{ 0x608DU, 0x9C9BU },{ 0x6092U, 0x9CA3U },
{ 0x6094U, 0x89F7U },{ 0x6096U, 0x9CA1U },{ 0x6097U, 0x9CA2U },
{ 0x609AU, 0x9C9EU },{ 0x609BU, 0x9CA0U },{ 0x609FU, 0x8CE5U },
{ 0x60A0U, 0x9749U },{ 0x60A3U, 0x8AB3U },{ 0x60A6U, 0x8978U },
{ 0x60A7U, 0x9CA4U },{ 0x60A9U, 0x9459U },{ 0x60AAU, 0x88ABU },
{ 0x60B2U, 0x94DFU },{ 0x60B3U, 0x9C7BU },{ 0x60B4U, 0x9CAAU },
{ 0x60B5U, 0x9CAEU },{ 0x60B6U, 0x96E3U },{ 0x60B8U, 0x9CA7U },
{ 0x60BCU, 0x9389U },{ 0x60BDU, 0x9CACU },{ 0x60C5U, 0x8FEEU },
{ 0x60C6U, 0x9CADU },{ 0x60C7U, 0x93D5U },{ 0x60D1U, 0x9866U },
{ 0x60D3U, 0x9CA9U },{ 0x60D5U, 0xFAC0U },{ 0x60D8U, 0x9CAFU },
{ 0x60DAU, 0x8D9BU },{ 0x60DCU, 0x90C9U },{ 0x60DEU, 0xFABFU },
{ 0x60DFU, 0x88D2U },{ 0x60E0U, 0x9CA8U },{ 0x60E1U, 0x9CA6U },
{ 0x60E3U, 0x9179U },{ 0x60E7U, 0x9C9CU },{ 0x60E8U, 0x8E53U },
{ 0x60F0U, 0x91C4U },{ 0x60F1U, 0x9CBBU },{ 0x60F2U, 0xFAC2U },
{ 0x60F3U, 0x917AU },{ 0x60F4U, 0x9CB6U },{ 0x60F6U, 0x9CB3U },
{ 0x60F7U, 0x9CB4U },{ 0x60F9U, 0x8EE4U },{ 0x60FAU, 0x9CB7U },
{ 0x60FBU, 0x9CBAU },{ 0x6100U, 0x9CB5U },{ 0x6101U, 0x8F44U },
{ 0x6103U, 0x9CB8U },{ 0x6106U, 0x9CB2U },{ 0x6108U, 0x96FAU },
{ 0x6109U, 0x96F9U },{ 0x610DU, 0x9CBCU },{ 0x610EU, 0x9CBDU },
{ 0x610FU, 0x88D3U },{ 0x6111U, 0xFAC3U },{ 0x6115U, 0x9CB1U },
{ 0x611AU, 0x8BF0U },{ 0x611BU, 0x88A4U },{ 0x611FU, 0x8AB4U },
{ 0x6120U, 0xFAC1U },{ 0x6121U, 0x9CB9U },{ 0x6127U, 0x9CC1U },
{ 0x6128U, 0x9CC0U },{ 0x612CU, 0x9CC5U },{ 0x6130U, 0xFAC5U },
{ 0x6134U, 0x9CC6U },{ 0x6137U, 0xFAC4U },{ 0x613CU, 0x9CC4U },
{ 0x613DU, 0x9CC7U },{ 0x613EU, 0x9CBFU },{ 0x613FU, 0x9CC3U },
{ 0x6142U, 0x9CC8U },{ 0x6144U, 0x9CC9U },{ 0x6147U, 0x9CBEU },
{ 0x6148U, 0x8E9CU },{ 0x614AU, 0x9CC2U },{ 0x614BU, 0x91D4U },
{ 0x614CU, 0x8D51U },{ 0x614DU, 0x9CB0U },{ 0x614EU, 0x9054U },
{ 0x6153U, 0x9CD6U },{ 0x6155U, 0x95E7U },{ 0x6158U, 0x9CCCU },
{ 0x6159U, 0x9CCDU },{ 0x615AU, 0x9CCEU },{ 0x615DU, 0x9CD5U },
{ 0x615FU, 0x9CD4U },{ 0x6162U, 0x969DU },{ 0x6163U, 0x8AB5U },
{ 0x6165U, 0x9CD2U },{ 0x6167U, 0x8C64U },{ 0x6168U, 0x8A53U },
{ 0x616BU, 0x9CCFU },{ 0x616EU, 0x97B6U },{ 0x616FU, 0x9CD1U },
{ 0x6170U, 0x88D4U },{ 0x6171U, 0x9CD3U },{ 0x6173U, 0x9CCAU },
{ 0x6174U, 0x9CD0U },{ 0x6175U, 0x9CD7U },{ 0x6176U, 0x8C63U },
{ 0x6177U, 0x9CCBU },{ 0x617EU, 0x977CU },{ 0x6182U, 0x974AU },
{ 0x6187U, 0x9CDAU },{ 0x618AU, 0x9CDEU },{ 0x618EU, 0x919EU },
{ 0x6190U, 0x97F7U },{ 0x6191U, 0x9CDFU },{ 0x6194U, 0x9CDCU },
{ 0x6196U, 0x9CD9U },{ 0x6198U, 0xFAC6U },{ 0x6199U, 0x9CD8U },
{ 0x619AU, 0x9CDDU },{ 0x61A4U, 0x95AEU },{ 0x61A7U, 0x93B2U },
{ 0x61A9U, 0x8C65U },{ 0x61ABU, 0x9CE0U },{ 0x61ACU, 0x9CDBU },
{ 0x61AEU, 0x9CE1U },{ 0x61B2U, 0x8C9BU },{ 0x61B6U, 0x89AFU },
{ 0x61BAU, 0x9CE9U },{ 0x61BEU, 0x8AB6U },{ 0x61C3U, 0x9CE7U },
{ 0x61C6U, 0x9CE8U },{ 0x61C7U, 0x8DA7U },{ 0x61C8U, 0x9CE6U },
{ 0x61C9U, 0x9CE4U },{ 0x61CAU, 0x9CE3U },{ 0x61CBU, 0x9CEAU },
{ 0x61CCU, 0x9CE2U },{ 0x61CDU, 0x9CECU },{ 0x61D0U, 0x89F9U },
{ 0x61E3U, 0x9CEEU },{ 0x61E6U, 0x9CEDU },{ 0x61F2U, 0x92A6U },
{ 0x61F4U, 0x9CF1U },{ 0x61F6U, 0x9CEFU },{ 0x61F7U, 0x9CE5U },
{ 0x61F8U, 0x8C9CU },{ 0x61FAU, 0x9CF0U },{ 0x61FCU, 0x9CF4U },
{ 0x61FDU, 0x9CF3U },{ 0x61FEU, 0x9CF5U },{ 0x61FFU, 0x9CF2U },
{ 0x6200U, 0x9CF6U },{ 0x6208U, 0x9CF7U },{ 0x6209U, 0x9CF8U },
{ 0x620AU, 0x95E8U },{ 0x620CU, 0x9CFAU },{ 0x620DU, 0x9CF9U },
{ 0x620EU, 0x8F5EU },{ 0x6210U, 0x90ACU },{ 0x6211U, 0x89E4U },
{ 0x6212U, 0x89FAU },{ 0x6213U, 0xFAC7U },{ 0x6214U, 0x9CFBU },
{ 0x6216U, 0x88BDU },{ 0x621AU, 0x90CAU },{ 0x621BU, 0x9CFCU },
{ 0x621DU, 0xE6C1U },{ 0x621EU, 0x9D40U },{ 0x621FU, 0x8C81U },
{ 0x6221U, 0x9D41U },{ 0x6226U, 0x90EDU },{ 0x622AU, 0x9D42U },
{ 0x622EU, 0x9D43U },{ 0x622FU, 0x8B59U },{ 0x6230U, 0x9D44U },
{ 0x6232U, 0x9D45U },{ 0x6233U, 0x9D46U },{ 0x6234U, 0x91D5U },
{ 0x6238U, 0x8CCBU },{ 0x623BU, 0x96DFU },{ 0x623FU, 0x965BU },
{ 0x6240U, 0x8F8AU },{ 0x6241U, 0x9D47U },{ 0x6247U, 0x90EEU },
{ 0x6248U, 0xE7BBU },{ 0x6249U, 0x94E0U },{ 0x624BU, 0x8EE8U },
{ 0x624DU, 0x8DCBU },{ 0x624EU, 0x9D48U },{ 0x6253U, 0x91C5U },
{ 0x6255U, 0x95A5U },{ 0x6258U, 0x91EFU },{ 0x625BU, 0x9D4BU },
{ 0x625EU, 0x9D49U },{ 0x6260U, 0x9D4CU },{ 0x6263U, 0x9D4AU },
{ 0x6268U, 0x9D4DU },{ 0x626EU, 0x95AFU },{ 0x6271U, 0x88B5U },
{ 0x6276U, 0x957DU },{ 0x6279U, 0x94E1U },{ 0x627CU, 0x9D4EU },
{ 0x627EU, 0x9D51U },{ 0x627FU, 0x8FB3U },{ 0x6280U, 0x8B5AU },
{ 0x6282U, 0x9D4FU },{ 0x6283U, 0x9D56U },{ 0x6284U, 0x8FB4U },
{ 0x6289U, 0x9D50U },{ 0x628AU, 0x9463U },{ 0x6291U, 0x977DU },
{ 0x6292U, 0x9D52U },{ 0x6293U, 0x9D53U },{ 0x6294U, 0x9D57U },
{ 0x6295U, 0x938AU },{ 0x6296U, 0x9D54U },{ 0x6297U, 0x8D52U },
{ 0x6298U, 0x90DCU },{ 0x629BU, 0x9D65U },{ 0x629CU, 0x94B2U },
{ 0x629EU, 0x91F0U },{ 0x62A6U, 0xFAC8U },{ 0x62ABU, 0x94E2U },
{ 0x62ACU, 0x9DABU },{ 0x62B1U, 0x95F8U },{ 0x62B5U, 0x92EFU },
{ 0x62B9U, 0x9695U },{ 0x62BBU, 0x9D5AU },{ 0x62BCU, 0x899FU },
{ 0x62BDU, 0x928AU },{ 0x62C2U, 0x9D63U },{ 0x62C5U, 0x9253U },
{ 0x62C6U, 0x9D5DU },{ 0x62C7U, 0x9D64U },{ 0x62C8U, 0x9D5FU },
{ 0x62C9U, 0x9D66U },{ 0x62CAU, 0x9D62U },{ 0x62CCU, 0x9D61U },
{ 0x62CDU, 0x948FU },{ 0x62CFU, 0x9D5BU },{ 0x62D0U, 0x89FBU },
{ 0x62D1U, 0x9D59U },{ 0x62D2U, 0x8B91U },{ 0x62D3U, 0x91F1U },
{ 0x62D4U, 0x9D55U },{ 0x62D7U, 0x9D58U },{ 0x62D8U, 0x8D53U },
{ 0x62D9U, 0x90D9U },{ 0x62DBU, 0x8FB5U },{ 0x62DCU, 0x9D60U },
{ 0x62DDU, 0x9471U },{ 0x62E0U, 0x8B92U },{ 0x62E1U, 0x8A67U },
{ 0x62ECU, 0x8A87U },{ 0x62EDU, 0x9040U },{ 0x62EEU, 0x9D68U },
{ 0x62EFU, 0x9D6DU },{ 0x62F1U, 0x9D69U },{ 0x62F3U, 0x8C9DU },
{ 0x62F5U, 0x9D6EU },{ 0x62F6U, 0x8E41U },{ 0x62F7U, 0x8D89U },
{ 0x62FEU, 0x8F45U },{ 0x62FFU, 0x9D5CU },{ 0x6301U, 0x8E9DU },
{ 0x6302U, 0x9D6BU },{ 0x6307U, 0x8E77U },{ 0x6308U, 0x9D6CU },
{ 0x6309U, 0x88C2U },{ 0x630CU, 0x9D67U },{ 0x6311U, 0x92A7U },
{ 0x6319U, 0x8B93U },{ 0x631FU, 0x8BB2U },{ 0x6327U, 0x9D6AU },
{ 0x6328U, 0x88A5U },{ 0x632BU, 0x8DC1U },{ 0x632FU, 0x9055U },
{ 0x633AU, 0x92F0U },{ 0x633DU, 0x94D2U },{ 0x633EU, 0x9D70U },
{ 0x633FU, 0x917DU },{ 0x6349U, 0x91A8U },{ 0x634CU, 0x8E4AU },
{ 0x634DU, 0x9D71U },{ 0x634FU, 0x9D73U },{ 0x6350U, 0x9D6FU },
{ 0x6355U, 0x95DFU },{ 0x6357U, 0x92BBU },{ 0x635CU, 0x917BU },
{ 0x6367U, 0x95F9U },{ 0x6368U, 0x8ECCU },{ 0x6369U, 0x9D80U },
{ 0x636BU, 0x9D7EU },{ 0x636EU, 0x9098U },{ 0x6372U, 0x8C9EU },
{ 0x6376U, 0x9D78U },{ 0x6377U, 0x8FB7U },{ 0x637AU, 0x93E6U },
{ 0x637BU, 0x9450U },{ 0x6380U, 0x9D76U },{ 0x6383U, 0x917CU },
{ 0x6388U, 0x8EF6U },{ 0x6389U, 0x9D7BU },{ 0x638CU, 0x8FB6U },
{ 0x638EU, 0x9D75U },{ 0x638FU, 0x9D7AU },{ 0x6392U, 0x9472U },
{ 0x6396U, 0x9D74U },{ 0x6398U, 0x8C40U },{ 0x639BU, 0x8A7CU },
{ 0x639FU, 0x9D7CU },{ 0x63A0U, 0x97A9U },{ 0x63A1U, 0x8DCCU },
{ 0x63A2U, 0x9254U },{ 0x63A3U, 0x9D79U },{ 0x63A5U, 0x90DAU },
{ 0x63A7U, 0x8D54U },{ 0x63A8U, 0x9084U },{ 0x63A9U, 0x8986U },
{ 0x63AAU, 0x915BU },{ 0x63ABU, 0x9D77U },{ 0x63ACU, 0x8B64U },
{ 0x63B2U, 0x8C66U },{ 0x63B4U, 0x92CDU },{ 0x63B5U, 0x9D7DU },
{ 0x63BBU, 0x917EU },{ 0x63BEU, 0x9D81U },{ 0x63C0U, 0x9D83U },
{ 0x63C3U, 0x91B5U },{ 0x63C4U, 0x9D89U },{ 0x63C6U, 0x9D84U },
{ 0x63C9U, 0x9D86U },{ 0x63CFU, 0x9560U },{ 0x63D0U, 0x92F1U },
{ 0x63D2U, 0x9D87U },{ 0x63D6U, 0x974BU },{ 0x63DAU, 0x9767U },
{ 0x63DBU, 0x8AB7U },{ 0x63E1U, 0x88ACU },{ 0x63E3U, 0x9D85U },
{ 0x63E9U, 0x9D82U },{ 0x63EEU, 0x8AF6U },{ 0x63F4U, 0x8987U },
{ 0x63F5U, 0xFAC9U },{ 0x63F6U, 0x9D88U },{ 0x63FAU, 0x9768U },
{ 0x6406U, 0x9D8CU },{ 0x640DU, 0x91B9U },{ 0x640FU, 0x9D93U },
{ 0x6413U, 0x9D8DU },{ 0x6416U, 0x9D8AU },{ 0x6417U, 0x9D91U },
{ 0x641CU, 0x9D72U },{ 0x6426U, 0x9D8EU },{ 0x6428U, 0x9D92U },
{ 0x642CU, 0x94C0U },{ 0x642DU, 0x938BU },{ 0x6434U, 0x9D8BU },
{ 0x6436U, 0x9D8FU },{ 0x643AU, 0x8C67U },{ 0x643EU, 0x8DEFU },
{ 0x6442U, 0x90DBU },{ 0x644EU, 0x9D97U },{ 0x6458U, 0x9345U },
{ 0x6460U, 0xFACAU },{ 0x6467U, 0x9D94U },{ 0x6469U, 0x9680U },
{ 0x646FU, 0x9D95U },{ 0x6476U, 0x9D96U },{ 0x6478U, 0x96CCU },
{ 0x647AU, 0x90A0U },{ 0x6483U, 0x8C82U },{ 0x6488U, 0x9D9DU },
{ 0x6492U, 0x8E54U },{ 0x6493U, 0x9D9AU },{ 0x6495U, 0x9D99U },
{ 0x649AU, 0x9451U },{ 0x649DU, 0xFACBU },{ 0x649EU, 0x93B3U },
{ 0x64A4U, 0x9350U },{ 0x64A5U, 0x9D9BU },{ 0x64A9U, 0x9D9CU },
{ 0x64ABU, 0x958FU },{ 0x64ADU, 0x9464U },{ 0x64AEU, 0x8E42U },
{ 0x64B0U, 0x90EFU },{ 0x64B2U, 0x966FU },{ 0x64B9U, 0x8A68U },
{ 0x64BBU, 0x9DA3U },{ 0x64BCU, 0x9D9EU },{ 0x64C1U, 0x9769U },
{ 0x64C2U, 0x9DA5U },{ 0x64C5U, 0x9DA1U },{ 0x64C7U, 0x9DA2U },
{ 0x64CDU, 0x9180U },{ 0x64CEU, 0xFACCU },{ 0x64D2U, 0x9DA0U },
{ 0x64D4U, 0x9D5EU },{ 0x64D8U, 0x9DA4U },{ 0x64DAU, 0x9D9FU },
{ 0x64E0U, 0x9DA9U },{ 0x64E1U, 0x9DAAU },{ 0x64E2U, 0x9346U },
{ 0x64E3U, 0x9DACU },{ 0x64E6U, 0x8E43U },{ 0x64E7U, 0x9DA7U },
{ 0x64ECU, 0x8B5BU },{ 0x64EFU, 0x9DADU },{ 0x64F1U, 0x9DA6U },
{ 0x64F2U, 0x9DB1U },{ 0x64F4U, 0x9DB0U },{ 0x64F6U, 0x9DAFU },
{ 0x64FAU, 0x9DB2U },{ 0x64FDU, 0x9DB4U },{ 0x64FEU, 0x8FEFU },
{ 0x6500U, 0x9DB3U },{ 0x6505U, 0x9DB7U },{ 0x6518U, 0x9DB5U },
{ 0x651CU, 0x9DB6U },{ 0x651DU, 0x9D90U },{ 0x6523U, 0x9DB9U },
{ 0x6524U, 0x9DB8U },{ 0x652AU, 0x9D98U },{ 0x652BU, 0x9DBAU },
{ 0x652CU, 0x9DAEU },{ 0x652FU, 0x8E78U },{ 0x6534U, 0x9DBBU },
{ 0x6535U, 0x9DBCU },{ 0x6536U, 0x9DBEU },{ 0x6537U, 0x9DBDU },
{ 0x6538U, 0x9DBFU },{ 0x6539U, 0x89FCU },{ 0x653BU, 0x8D55U },
{ 0x653EU, 0x95FAU },{ 0x653FU, 0x90ADU },{ 0x6545U, 0x8CCCU },
{ 0x6548U, 0x9DC1U },{ 0x654DU, 0x9DC4U },{ 0x654EU, 0xFACDU },
{ 0x654FU, 0x9571U },{ 0x6551U, 0x8B7EU },{ 0x6555U, 0x9DC3U },
{ 0x6556U, 0x9DC2U },{ 0x6557U, 0x9473U },{ 0x6558U, 0x9DC5U },
{ 0x6559U, 0x8BB3U },{ 0x655DU, 0x9DC7U },{ 0x655EU, 0x9DC6U },
{ 0x6562U, 0x8AB8U },{ 0x6563U, 0x8E55U },{ 0x6566U, 0x93D6U },
{ 0x656CU, 0x8C68U },{ 0x6570U, 0x9094U },{ 0x6572U, 0x9DC8U },
{ 0x6574U, 0x90AEU },{ 0x6575U, 0x9347U },{ 0x6577U, 0x957EU },
{ 0x6578U, 0x9DC9U },{ 0x6582U, 0x9DCAU },{ 0x6583U, 0x9DCBU },
{ 0x6587U, 0x95B6U },{ 0x6588U, 0x9B7CU },{ 0x6589U, 0x90C4U },
{ 0x658CU, 0x956BU },{ 0x658EU, 0x8DD6U },{ 0x6590U, 0x94E3U },
{ 0x6591U, 0x94C1U },{ 0x6597U, 0x936CU },{ 0x6599U, 0x97BFU },
{ 0x659BU, 0x9DCDU },{ 0x659CU, 0x8ECEU },{ 0x659FU, 0x9DCEU },
{ 0x65A1U, 0x88B4U },{ 0x65A4U, 0x8BD2U },{ 0x65A5U, 0x90CBU },
{ 0x65A7U, 0x9580U },{ 0x65ABU, 0x9DCFU },{ 0x65ACU, 0x8E61U },
{ 0x65ADU, 0x9266U },{ 0x65AFU, 0x8E7AU },{ 0x65B0U, 0x9056U },
{ 0x65B7U, 0x9DD0U },{ 0x65B9U, 0x95FBU },{ 0x65BCU, 0x8997U },
{ 0x65BDU, 0x8E7BU },{ 0x65C1U, 0x9DD3U },{ 0x65C3U, 0x9DD1U },
{ 0x65C4U, 0x9DD4U },{ 0x65C5U, 0x97B7U },{ 0x65C6U, 0x9DD2U },
{ 0x65CBU, 0x90F9U },{ 0x65CCU, 0x9DD5U },{ 0x65CFU, 0x91B0U },
{ 0x65D2U, 0x9DD6U },{ 0x65D7U, 0x8AF8U },{ 0x65D9U, 0x9DD8U },
{ 0x65DBU, 0x9DD7U },{ 0x65E0U, 0x9DD9U },{ 0x65E1U, 0x9DDAU },
{ 0x65E2U, 0x8AF9U },{ 0x65E5U, 0x93FAU },{ 0x65E6U, 0x9255U },
{ 0x65E7U, 0x8B8CU },{ 0x65E8U, 0x8E7CU },{ 0x65E9U, 0x9181U },
{ 0x65ECU, 0x8F7BU },{ 0x65EDU, 0x88AEU },{ 0x65F1U, 0x9DDBU },
{ 0x65FAU, 0x89A0U },{ 0x65FBU, 0x9DDFU },{ 0x6600U, 0xFACEU },
{ 0x6602U, 0x8D56U },{ 0x6603U, 0x9DDEU },{ 0x6606U, 0x8DA9U },
{ 0x6607U, 0x8FB8U },{ 0x6609U, 0xFAD1U },{ 0x660AU, 0x9DDDU },
{ 0x660CU, 0x8FB9U },{ 0x660EU, 0x96BEU },{ 0x660FU, 0x8DA8U },
{ 0x6613U, 0x88D5U },{ 0x6614U, 0x90CCU },{ 0x6615U, 0xFACFU },
{ 0x661CU, 0x9DE4U },{ 0x661EU, 0xFAD3U },{ 0x661FU, 0x90AFU },
{ 0x6620U, 0x8966U },{ 0x6624U, 0xFAD4U },{ 0x6625U, 0x8F74U },
{ 0x6627U, 0x9686U },{ 0x6628U, 0x8DF0U },{ 0x662DU, 0x8FBAU },
{ 0x662EU, 0xFAD2U },{ 0x662FU, 0x90A5U },{ 0x6631U, 0xFA63U },
{ 0x6634U, 0x9DE3U },{ 0x6635U, 0x9DE1U },{ 0x6636U, 0x9DE2U },
{ 0x663BU, 0xFAD0U },{ 0x663CU, 0x928BU },{ 0x663FU, 0x9E45U },
{ 0x6641U, 0x9DE8U },{ 0x6642U, 0x8E9EU },{ 0x6643U, 0x8D57U },
{ 0x6644U, 0x9DE6U },{ 0x6649U, 0x9DE7U },{ 0x664BU, 0x9057U },
{ 0x664FU, 0x9DE5U },{ 0x6652U, 0x8E4EU },{ 0x6657U, 0xFAD6U },
{ 0x6659U, 0xFAD7U },{ 0x665DU, 0x9DEAU },{ 0x665EU, 0x9DE9U },
{ 0x665FU, 0x9DEEU },{ 0x6662U, 0x9DEFU },{ 0x6664U, 0x9DEBU },
{ 0x6665U, 0xFAD5U },{ 0x6666U, 0x8A41U },{ 0x6667U, 0x9DECU },
{ 0x6668U, 0x9DEDU },{ 0x6669U, 0x94D3U },{ 0x666EU, 0x9581U },
{ 0x666FU, 0x8C69U },{ 0x6670U, 0x9DF0U },{ 0x6673U, 0xFAD9U },
{ 0x6674U, 0x90B0U },{ 0x6676U, 0x8FBBU },{ 0x667AU, 0x9271U },
{ 0x6681U, 0x8BC5U },{ 0x6683U, 0x9DF1U },{ 0x6684U, 0x9DF5U },
{ 0x6687U, 0x89C9U },{ 0x6688U, 0x9DF2U },{ 0x6689U, 0x9DF4U },
{ 0x668EU, 0x9DF3U },{ 0x6691U, 0x8F8BU },{ 0x6696U, 0x9267U },
{ 0x6697U, 0x88C3U },{ 0x6698U, 0x9DF6U },{ 0x6699U, 0xFADAU },
{ 0x669DU, 0x9DF7U },{ 0x66A0U, 0xFADBU },{ 0x66A2U, 0x92A8U },
{ 0x66A6U, 0x97EFU },{ 0x66ABU, 0x8E62U },{ 0x66AEU, 0x95E9U },
{ 0x66B2U, 0xFADCU },{ 0x66B4U, 0x965CU },{ 0x66B8U, 0x9E41U },
{ 0x66B9U, 0x9DF9U },{ 0x66BCU, 0x9DFCU },{ 0x66BEU, 0x9DFBU },
{ 0x66BFU, 0xFADDU },{ 0x66C1U, 0x9DF8U },{ 0x66C4U, 0x9E40U },
{ 0x66C7U, 0x93DCU },{ 0x66C9U, 0x9DFAU },{ 0x66D6U, 0x9E42U },
{ 0x66D9U, 0x8F8CU },{ 0x66DAU, 0x9E43U },{ 0x66DCU, 0x976AU },
{ 0x66DDU, 0x9498U },{ 0x66E0U, 0x9E44U },{ 0x66E6U, 0x9E46U },
{ 0x66E9U, 0x9E47U },{ 0x66F0U, 0x9E48U },{ 0x66F2U, 0x8BC8U },
{ 0x66F3U, 0x8967U },{ 0x66F4U, 0x8D58U },{ 0x66F5U, 0x9E49U },
{ 0x66F7U, 0x9E4AU },{ 0x66F8U, 0x8F91U },{ 0x66F9U, 0x9182U },
{ 0x66FAU, 0xFADEU },{ 0x66FBU, 0xFA66U },{ 0x66FCU, 0x99D6U },
{ 0x66FDU, 0x915DU },{ 0x66FEU, 0x915CU },{ 0x66FFU, 0x91D6U },
{ 0x6700U, 0x8DC5U },{ 0x6703U, 0x98F0U },{ 0x6708U, 0x8C8EU },
{ 0x6709U, 0x974CU },{ 0x670BU, 0x95FCU },{ 0x670DU, 0x959EU },
{ 0x670EU, 0xFADFU },{ 0x670FU, 0x9E4BU },{ 0x6714U, 0x8DF1U },
{ 0x6715U, 0x92BDU },{ 0x6716U, 0x9E4CU },{ 0x6717U, 0x984EU },
{ 0x671BU, 0x965DU },{ 0x671DU, 0x92A9U },{ 0x671EU, 0x9E4DU },
{ 0x671FU, 0x8AFAU },{ 0x6726U, 0x9E4EU },{ 0x6727U, 0x9E4FU },
{ 0x6728U, 0x96D8U },{ 0x672AU, 0x96A2U },{ 0x672BU, 0x9696U },
{ 0x672CU, 0x967BU },{ 0x672DU, 0x8E44U },{ 0x672EU, 0x9E51U },
{ 0x6731U, 0x8EE9U },{ 0x6734U, 0x9670U },{ 0x6736U, 0x9E53U },
{ 0x6737U, 0x9E56U },{ 0x6738U, 0x9E55U },{ 0x673AU, 0x8AF7U },
{ 0x673DU, 0x8B80U },{ 0x673FU, 0x9E52U },{ 0x6741U, 0x9E54U },
{ 0x6746U, 0x9E57U },{ 0x6749U, 0x9099U },{ 0x674EU, 0x979BU },
{ 0x674FU, 0x88C7U },{ 0x6750U, 0x8DDEU },{ 0x6751U, 0x91BAU },
{ 0x6753U, 0x8EDBU },{ 0x6756U, 0x8FF1U },{ 0x6759U, 0x9E5AU },
{ 0x675CU, 0x936DU },{ 0x675EU, 0x9E58U },{ 0x675FU, 0x91A9U },
{ 0x6760U, 0x9E59U },{ 0x6761U, 0x8FF0U },{ 0x6762U, 0x96DBU },
{ 0x6763U, 0x9E5BU },{ 0x6764U, 0x9E5CU },{ 0x6765U, 0x9788U },
{ 0x6766U, 0xFAE1U },{ 0x676AU, 0x9E61U },{ 0x676DU, 0x8D59U },
{ 0x676FU, 0x9474U },{ 0x6770U, 0x9E5EU },{ 0x6771U, 0x938CU },
{ 0x6772U, 0x9DDCU },{ 0x6773U, 0x9DE0U },{ 0x6775U, 0x8B6EU },
{ 0x6777U, 0x9466U },{ 0x677CU, 0x9E60U },{ 0x677EU, 0x8FBCU },
{ 0x677FU, 0x94C2U },{ 0x6785U, 0x9E66U },{ 0x6787U, 0x94F8U },
{ 0x6789U, 0x9E5DU },{ 0x678BU, 0x9E63U },{ 0x678CU, 0x9E62U },
{ 0x6790U, 0x90CDU },{ 0x6795U, 0x968DU },{ 0x6797U, 0x97D1U },
{ 0x679AU, 0x9687U },{ 0x679CU, 0x89CAU },{ 0x679DU, 0x8E7DU },
{ 0x67A0U, 0x9867U },{ 0x67A1U, 0x9E65U },{ 0x67A2U, 0x9095U },
{ 0x67A6U, 0x9E64U },{ 0x67A9U, 0x9E5FU },{ 0x67AFU, 0x8CCDU },
{ 0x67B3U, 0x9E6BU },{ 0x67B4U, 0x9E69U },{ 0x67B6U, 0x89CBU },
{ 0x67B7U, 0x9E67U },{ 0x67B8U, 0x9E6DU },{ 0x67B9U, 0x9E73U },
{ 0x67BBU, 0xFAE2U },{ 0x67C0U, 0xFAE4U },{ 0x67C1U, 0x91C6U },
{ 0x67C4U, 0x95BFU },{ 0x67C6U, 0x9E75U },{ 0x67CAU, 0x9541U },
{ 0x67CEU, 0x9E74U },{ 0x67CFU, 0x9490U },{ 0x67D0U, 0x965EU },
{ 0x67D1U, 0x8AB9U },{ 0x67D3U, 0x90F5U },{ 0x67D4U, 0x8F5FU },
{ 0x67D8U, 0x92D1U },{ 0x67DAU, 0x974DU },{ 0x67DDU, 0x9E70U },
{ 0x67DEU, 0x9E6FU },{ 0x67E2U, 0x9E71U },{ 0x67E4U, 0x9E6EU },
{ 0x67E7U, 0x9E76U },{ 0x67E9U, 0x9E6CU },{ 0x67ECU, 0x9E6AU },
{ 0x67EEU, 0x9E72U },{ 0x67EFU, 0x9E68U },{ 0x67F1U, 0x928CU },
{ 0x67F3U, 0x96F6U },{ 0x67F4U, 0x8EC4U },{ 0x67F5U, 0x8DF2U },
{ 0x67FBU, 0x8DB8U },{ 0x67FEU, 0x968FU },{ 0x67FFU, 0x8A60U },
{ 0x6801U, 0xFAE5U },{ 0x6802U, 0x92CCU },{ 0x6803U, 0x93C8U },
{ 0x6804U, 0x8968U },{ 0x6813U, 0x90F0U },{ 0x6816U, 0x90B2U },
{ 0x6817U, 0x8C49U },{ 0x681EU, 0x9E78U },{ 0x6821U, 0x8D5AU },
{ 0x6822U, 0x8A9CU },{ 0x6829U, 0x9E7AU },{ 0x682AU, 0x8A94U },
{ 0x682BU, 0x9E81U },{ 0x6832U, 0x9E7DU },{ 0x6834U, 0x90F1U },
{ 0x6838U, 0x8A6AU },{ 0x6839U, 0x8DAAU },{ 0x683CU, 0x8A69U },
{ 0x683DU, 0x8DCDU },{ 0x6840U, 0x9E7BU },{ 0x6841U, 0x8C85U },
{ 0x6842U, 0x8C6AU },{ 0x6843U, 0x938DU },{ 0x6844U, 0xFAE6U },
{ 0x6846U, 0x9E79U },{ 0x6848U, 0x88C4U },{ 0x684DU, 0x9E7CU },
{ 0x684EU, 0x9E7EU },{ 0x6850U, 0x8BCBU },{ 0x6851U, 0x8C4BU },
{ 0x6852U, 0xFAE3U },{ 0x6853U, 0x8ABAU },{ 0x6854U, 0x8B6AU },
{ 0x6859U, 0x9E82U },{ 0x685CU, 0x8DF7U },{ 0x685DU, 0x9691U },
{ 0x685FU, 0x8E56U },{ 0x6863U, 0x9E83U },{ 0x6867U, 0x954FU },
{ 0x6874U, 0x9E8FU },{ 0x6876U, 0x89B1U },{ 0x6877U, 0x9E84U },
{ 0x687EU, 0x9E95U },{ 0x687FU, 0x9E85U },{ 0x6881U, 0x97C0U },
{ 0x6883U, 0x9E8CU },{ 0x6885U, 0x947EU },{ 0x688DU, 0x9E94U },
{ 0x688FU, 0x9E87U },{ 0x6893U, 0x88B2U },{ 0x6894U, 0x9E89U },
{ 0x6897U, 0x8D5BU },{ 0x689BU, 0x9E8BU },{ 0x689DU, 0x9E8AU },
{ 0x689FU, 0x9E86U },{ 0x68A0U, 0x9E91U },{ 0x68A2U, 0x8FBDU },
{ 0x68A6U, 0x9AEBU },{ 0x68A7U, 0x8CE6U },{ 0x68A8U, 0x979CU },
{ 0x68ADU, 0x9E88U },{ 0x68AFU, 0x92F2U },{ 0x68B0U, 0x8A42U },
{ 0x68B1U, 0x8DABU },{ 0x68B3U, 0x9E80U },{ 0x68B5U, 0x9E90U },
{ 0x68B6U, 0x8A81U },{ 0x68B9U, 0x9E8EU },{ 0x68BAU, 0x9E92U },
{ 0x68BCU, 0x938EU },{ 0x68C4U, 0x8AFCU },{ 0x68C6U, 0x9EB0U },
{ 0x68C8U, 0xFA64U },{ 0x68C9U, 0x96C7U },{ 0x68CAU, 0x9E97U },
{ 0x68CBU, 0x8AFBU },{ 0x68CDU, 0x9E9EU },{ 0x68CFU, 0xFAE7U },
{ 0x68D2U, 0x965FU },{ 0x68D4U, 0x9E9FU },{ 0x68D5U, 0x9EA1U },
{ 0x68D7U, 0x9EA5U },{ 0x68D8U, 0x9E99U },{ 0x68DAU, 0x9249U },
{ 0x68DFU, 0x938FU },{ 0x68E0U, 0x9EA9U },{ 0x68E1U, 0x9E9CU },
{ 0x68E3U, 0x9EA6U },{ 0x68E7U, 0x9EA0U },{ 0x68EEU, 0x9058U },
{ 0x68EFU, 0x9EAAU },{ 0x68F2U, 0x90B1U },{ 0x68F9U, 0x9EA8U },
{ 0x68FAU, 0x8ABBU },{ 0x6900U, 0x986FU },{ 0x6901U, 0x9E96U },
{ 0x6904U, 0x9EA4U },{ 0x6905U, 0x88D6U },{ 0x6908U, 0x9E98U },
{ 0x690BU, 0x96B8U },{ 0x690CU, 0x9E9DU },{ 0x690DU, 0x9041U },
{ 0x690EU, 0x92C5U },{ 0x690FU, 0x9E93U },{ 0x6912U, 0x9EA3U },
{ 0x6919U, 0x909AU },{ 0x691AU, 0x9EADU },{ 0x691BU, 0x8A91U },
{ 0x691CU, 0x8C9FU },{ 0x6921U, 0x9EAFU },{ 0x6922U, 0x9E9AU },
{ 0x6923U, 0x9EAEU },{ 0x6925U, 0x9EA7U },{ 0x6926U, 0x9E9BU },
{ 0x6928U, 0x9EABU },{ 0x692AU, 0x9EACU },{ 0x6930U, 0x9EBDU },
{ 0x6934U, 0x93CCU },{ 0x6936U, 0x9EA2U },{ 0x6939U, 0x9EB9U },
{ 0x693DU, 0x9EBBU },{ 0x693FU, 0x92D6U },{ 0x694AU, 0x976BU },
{ 0x6953U, 0x9596U },{ 0x6954U, 0x9EB6U },{ 0x6955U, 0x91C8U },
{ 0x6959U, 0x9EBCU },{ 0x695AU, 0x915EU },{ 0x695CU, 0x9EB3U },
{ 0x695DU, 0x9EC0U },{ 0x695EU, 0x9EBFU },{ 0x6960U, 0x93EDU },
{ 0x6961U, 0x9EBEU },{ 0x6962U, 0x93E8U },{ 0x6968U, 0xFAE9U },
{ 0x696AU, 0x9EC2U },{ 0x696BU, 0x9EB5U },{ 0x696DU, 0x8BC6U },
{ 0x696EU, 0x9EB8U },{ 0x696FU, 0x8F7CU },{ 0x6973U, 0x9480U },
{ 0x6974U, 0x9EBAU },{ 0x6975U, 0x8BC9U },{ 0x6977U, 0x9EB2U },
{ 0x6978U, 0x9EB4U },{ 0x6979U, 0x9EB1U },{ 0x697CU, 0x984FU },
{ 0x697DU, 0x8A79U },{ 0x697EU, 0x9EB7U },{ 0x6981U, 0x9EC1U },
{ 0x6982U, 0x8A54U },{ 0x698AU, 0x8DE5U },{ 0x698EU, 0x897CU },
{ 0x6991U, 0x9ED2U },{ 0x6994U, 0x9850U },{ 0x6995U, 0x9ED5U },
{ 0x6998U, 0xFAEBU },{ 0x699BU, 0x9059U },{ 0x699CU, 0x9ED4U },
{ 0x69A0U, 0x9ED3U },{ 0x69A7U, 0x9ED0U },{ 0x69AEU, 0x9EC4U },
{ 0x69B1U, 0x9EE1U },{ 0x69B2U, 0x9EC3U },{ 0x69B4U, 0x9ED6U },
{ 0x69BBU, 0x9ECEU },{ 0x69BEU, 0x9EC9U },{ 0x69BFU, 0x9EC6U },
{ 0x69C1U, 0x9EC7U },{ 0x69C3U, 0x9ECFU },{ 0x69C7U, 0xEAA0U },
{ 0x69CAU, 0x9ECCU },{ 0x69CBU, 0x8D5CU },{ 0x69CCU, 0x92C6U },
{ 0x69CDU, 0x9184U },{ 0x69CEU, 0x9ECAU },{ 0x69D0U, 0x9EC5U },
{ 0x69D3U, 0x9EC8U },{ 0x69D8U, 0x976CU },{ 0x69D9U, 0x968AU },
{ 0x69DDU, 0x9ECDU },{ 0x69DEU, 0x9ED7U },{ 0x69E2U, 0xFAECU },
{ 0x69E7U, 0x9EDFU },{ 0x69E8U, 0x9ED8U },{ 0x69EBU, 0x9EE5U },
{ 0x69EDU, 0x9EE3U },{ 0x69F2U, 0x9EDEU },{ 0x69F9U, 0x9EDDU },
{ 0x69FBU, 0x92CEU },{ 0x69FDU, 0x9185U },{ 0x69FFU, 0x9EDBU },
{ 0x6A02U, 0x9ED9U },{ 0x6A05U, 0x9EE0U },{ 0x6A0AU, 0x9EE6U },
{ 0x6A0BU, 0x94F3U },{ 0x6A0CU, 0x9EECU },{ 0x6A12U, 0x9EE7U },
{ 0x6A13U, 0x9EEAU },{ 0x6A14U, 0x9EE4U },{ 0x6A17U, 0x9294U },
{ 0x6A19U, 0x9557U },{ 0x6A1BU, 0x9EDAU },{ 0x6A1EU, 0x9EE2U },
{ 0x6A1FU, 0x8FBEU },{ 0x6A21U, 0x96CDU },{ 0x6A22U, 0x9EF6U },
{ 0x6A23U, 0x9EE9U },{ 0x6A29U, 0x8CA0U },{ 0x6A2AU, 0x89A1U },
{ 0x6A2BU, 0x8A7EU },{ 0x6A2EU, 0x9ED1U },{ 0x6A30U, 0xFAEDU },
{ 0x6A35U, 0x8FBFU },{ 0x6A36U, 0x9EEEU },{ 0x6A38U, 0x9EF5U },
{ 0x6A39U, 0x8EF7U },{ 0x6A3AU, 0x8A92U },{ 0x6A3DU, 0x924DU },
{ 0x6A44U, 0x9EEBU },{ 0x6A46U, 0xFAEFU },{ 0x6A47U, 0x9EF0U },
{ 0x6A48U, 0x9EF4U },{ 0x6A4BU, 0x8BB4U },{ 0x6A58U, 0x8B6BU },
{ 0x6A59U, 0x9EF2U },{ 0x6A5FU, 0x8B40U },{ 0x6A61U, 0x93C9U },
{ 0x6A62U, 0x9EF1U },{ 0x6A66U, 0x9EF3U },{ 0x6A6BU, 0xFAEEU },
{ 0x6A72U, 0x9EEDU },{ 0x6A73U, 0xFAF0U },{ 0x6A78U, 0x9EEFU },
{ 0x6A7EU, 0xFAF1U },{ 0x6A7FU, 0x8A80U },{ 0x6A80U, 0x9268U },
{ 0x6A84U, 0x9EFAU },{ 0x6A8DU, 0x9EF8U },{ 0x6A8EU, 0x8CE7U },
{ 0x6A90U, 0x9EF7U },{ 0x6A97U, 0x9F40U },{ 0x6A9CU, 0x9E77U },
{ 0x6AA0U, 0x9EF9U },{ 0x6AA2U, 0x9EFBU },{ 0x6AA3U, 0x9EFCU },
{ 0x6AAAU, 0x9F4BU },{ 0x6AACU, 0x9F47U },{ 0x6AAEU, 0x9E8DU },
{ 0x6AB3U, 0x9F46U },{ 0x6AB8U, 0x9F45U },{ 0x6ABBU, 0x9F42U },
{ 0x6AC1U, 0x9EE8U },{ 0x6AC2U, 0x9F44U },{ 0x6AC3U, 0x9F43U },
{ 0x6AD1U, 0x9F49U },{ 0x6AD3U, 0x9845U },{ 0x6ADAU, 0x9F4CU },
{ 0x6ADBU, 0x8BF9U },{ 0x6ADEU, 0x9F48U },{ 0x6ADFU, 0x9F4AU },
{ 0x6AE2U, 0xFAF2U },{ 0x6AE4U, 0xFAF3U },{ 0x6AE8U, 0x94A5U },
{ 0x6AEAU, 0x9F4DU },{ 0x6AFAU, 0x9F51U },{ 0x6AFBU, 0x9F4EU },
{ 0x6B04U, 0x9793U },{ 0x6B05U, 0x9F4FU },{ 0x6B0AU, 0x9EDCU },
{ 0x6B12U, 0x9F52U },{ 0x6B16U, 0x9F53U },{ 0x6B1DU, 0x8954U },
{ 0x6B1FU, 0x9F55U },{ 0x6B20U, 0x8C87U },{ 0x6B21U, 0x8E9FU },
{ 0x6B23U, 0x8BD3U },{ 0x6B27U, 0x89A2U },{ 0x6B32U, 0x977EU },
{ 0x6B37U, 0x9F57U },{ 0x6B38U, 0x9F56U },{ 0x6B39U, 0x9F59U },
{ 0x6B3AU, 0x8B5CU },{ 0x6B3DU, 0x8BD4U },{ 0x6B3EU, 0x8ABCU },
{ 0x6B43U, 0x9F5CU },{ 0x6B47U, 0x9F5BU },{ 0x6B49U, 0x9F5DU },
{ 0x6B4CU, 0x89CCU },{ 0x6B4EU, 0x9256U },{ 0x6B50U, 0x9F5EU },
{ 0x6B53U, 0x8ABDU },{ 0x6B54U, 0x9F60U },{ 0x6B59U, 0x9F5FU },
{ 0x6B5BU, 0x9F61U },{ 0x6B5FU, 0x9F62U },{ 0x6B61U, 0x9F63U },
{ 0x6B62U, 0x8E7EU },{ 0x6B63U, 0x90B3U },{ 0x6B64U, 0x8D9FU },
{ 0x6B66U, 0x9590U },{ 0x6B69U, 0x95E0U },{ 0x6B6AU, 0x9863U },
{ 0x6B6FU, 0x8E95U },{ 0x6B73U, 0x8DCEU },{ 0x6B74U, 0x97F0U },
{ 0x6B78U, 0x9F64U },{ 0x6B79U, 0x9F65U },{ 0x6B7BU, 0x8E80U },
{ 0x6B7FU, 0x9F66U },{ 0x6B80U, 0x9F67U },{ 0x6B83U, 0x9F69U },
{ 0x6B84U, 0x9F68U },{ 0x6B86U, 0x9677U },{ 0x6B89U, 0x8F7DU },
{ 0x6B8AU, 0x8EEAU },{ 0x6B8BU, 0x8E63U },{ 0x6B8DU, 0x9F6AU },
{ 0x6B95U, 0x9F6CU },{ 0x6B96U, 0x9042U },{ 0x6B98U, 0x9F6BU },
{ 0x6B9EU, 0x9F6DU },{ 0x6BA4U, 0x9F6EU },{ 0x6BAAU, 0x9F6FU },
{ 0x6BABU, 0x9F70U },{ 0x6BAFU, 0x9F71U },{ 0x6BB1U, 0x9F73U },
{ 0x6BB2U, 0x9F72U },{ 0x6BB3U, 0x9F74U },{ 0x6BB4U, 0x89A3U },
{ 0x6BB5U, 0x9269U },{ 0x6BB7U, 0x9F75U },{ 0x6BBAU, 0x8E45U },
{ 0x6BBBU, 0x8A6BU },{ 0x6BBCU, 0x9F76U },{ 0x6BBFU, 0x9361U },
{ 0x6BC0U, 0x9ACAU },{ 0x6BC5U, 0x8B42U },{ 0x6BC6U, 0x9F77U },
{ 0x6BCBU, 0x9F78U },{ 0x6BCDU, 0x95EAU },{ 0x6BCEU, 0x9688U },
{ 0x6BD2U, 0x93C5U },{ 0x6BD3U, 0x9F79U },{ 0x6BD4U, 0x94E4U },
{ 0x6BD6U, 0xFAF4U },{ 0x6BD8U, 0x94F9U },{ 0x6BDBU, 0x96D1U },
{ 0x6BDFU, 0x9F7AU },{ 0x6BEBU, 0x9F7CU },{ 0x6BECU, 0x9F7BU },
{ 0x6BEFU, 0x9F7EU },{ 0x6BF3U, 0x9F7DU },{ 0x6C08U, 0x9F81U },
{ 0x6C0FU, 0x8E81U },{ 0x6C11U, 0x96AFU },{ 0x6C13U, 0x9F82U },
{ 0x6C14U, 0x9F83U },{ 0x6C17U, 0x8B43U },{ 0x6C1BU, 0x9F84U },
{ 0x6C23U, 0x9F86U },{ 0x6C24U, 0x9F85U },{ 0x6C34U, 0x9085U },
{ 0x6C37U, 0x9558U },{ 0x6C38U, 0x8969U },{ 0x6C3EU, 0x94C3U },
{ 0x6C3FU, 0xFAF5U },{ 0x6C40U, 0x92F3U },{ 0x6C41U, 0x8F60U },
{ 0x6C42U, 0x8B81U },{ 0x6C4EU, 0x94C4U },{ 0x6C50U, 0x8EACU },
{ 0x6C55U, 0x9F88U },{ 0x6C57U, 0x8ABEU },{ 0x6C5AU, 0x8998U },
{ 0x6C5CU, 0xFAF6U },{ 0x6C5DU, 0x93F0U },{ 0x6C5EU, 0x9F87U },
{ 0x6C5FU, 0x8D5DU },{ 0x6C60U, 0x9272U },{ 0x6C62U, 0x9F89U },
{ 0x6C68U, 0x9F91U },{ 0x6C6AU, 0x9F8AU },{ 0x6C6FU, 0xFAF8U },
{ 0x6C70U, 0x91BFU },{ 0x6C72U, 0x8B82U },{ 0x6C73U, 0x9F92U },
{ 0x6C7AU, 0x8C88U },{ 0x6C7DU, 0x8B44U },{ 0x6C7EU, 0x9F90U },
{ 0x6C81U, 0x9F8EU },{ 0x6C82U, 0x9F8BU },{ 0x6C83U, 0x9780U },
{ 0x6C86U, 0xFAF7U },{ 0x6C88U, 0x92BEU },{ 0x6C8CU, 0x93D7U },
{ 0x6C8DU, 0x9F8CU },{ 0x6C90U, 0x9F94U },{ 0x6C92U, 0x9F93U },
{ 0x6C93U, 0x8C42U },{ 0x6C96U, 0x89ABU },{ 0x6C99U, 0x8DB9U },
{ 0x6C9AU, 0x9F8DU },{ 0x6C9BU, 0x9F8FU },{ 0x6CA1U, 0x9676U },
{ 0x6CA2U, 0x91F2U },{ 0x6CABU, 0x9697U },{ 0x6CAEU, 0x9F9CU },
{ 0x6CB1U, 0x9F9DU },{ 0x6CB3U, 0x89CDU },{ 0x6CB8U, 0x95A6U },
{ 0x6CB9U, 0x96FBU },{ 0x6CBAU, 0x9F9FU },{ 0x6CBBU, 0x8EA1U },
{ 0x6CBCU, 0x8FC0U },{ 0x6CBDU, 0x9F98U },{ 0x6CBEU, 0x9F9EU },
{ 0x6CBFU, 0x8988U },{ 0x6CC1U, 0x8BB5U },{ 0x6CC4U, 0x9F95U },
{ 0x6CC5U, 0x9F9AU },{ 0x6CC9U, 0x90F2U },{ 0x6CCAU, 0x9491U },
{ 0x6CCCU, 0x94E5U },{ 0x6CD3U, 0x9F97U },{ 0x6CD5U, 0x9640U },
{ 0x6CD7U, 0x9F99U },{ 0x6CD9U, 0x9FA2U },{ 0x6CDAU, 0xFAF9U },
{ 0x6CDBU, 0x9FA0U },{ 0x6CDDU, 0x9F9BU },{ 0x6CE1U, 0x9641U },
{ 0x6CE2U, 0x9467U },{ 0x6CE3U, 0x8B83U },{ 0x6CE5U, 0x9344U },
{ 0x6CE8U, 0x928DU },{ 0x6CEAU, 0x9FA3U },{ 0x6CEFU, 0x9FA1U },
{ 0x6CF0U, 0x91D7U },{ 0x6CF1U, 0x9F96U },{ 0x6CF3U, 0x896AU },
{ 0x6D04U, 0xFAFAU },{ 0x6D0BU, 0x976DU },{ 0x6D0CU, 0x9FAEU },
{ 0x6D12U, 0x9FADU },{ 0x6D17U, 0x90F4U },{ 0x6D19U, 0x9FAAU },
{ 0x6D1BU, 0x978CU },{ 0x6D1EU, 0x93B4U },{ 0x6D1FU, 0x9FA4U },
{ 0x6D25U, 0x92C3U },{ 0x6D29U, 0x896BU },{ 0x6D2AU, 0x8D5EU },
{ 0x6D2BU, 0x9FA7U },{ 0x6D32U, 0x8F46U },{ 0x6D33U, 0x9FACU },
{ 0x6D35U, 0x9FABU },{ 0x6D36U, 0x9FA6U },{ 0x6D38U, 0x9FA9U },
{ 0x6D3BU, 0x8A88U },{ 0x6D3DU, 0x9FA8U },{ 0x6D3EU, 0x9468U },
{ 0x6D41U, 0x97ACU },{ 0x6D44U, 0x8FF2U },{ 0x6D45U, 0x90F3U },
{ 0x6D59U, 0x9FB4U },{ 0x6D5AU, 0x9FB2U },{ 0x6D5CU, 0x956CU },
{ 0x6D63U, 0x9FAFU },{ 0x6D64U, 0x9FB1U },{ 0x6D66U, 0x8959U },
{ 0x6D69U, 0x8D5FU },{ 0x6D6AU, 0x9851U },{ 0x6D6CU, 0x8A5CU },
{ 0x6D6EU, 0x9582U },{ 0x6D6FU, 0xFAFCU },{ 0x6D74U, 0x9781U },
{ 0x6D77U, 0x8A43U },{ 0x6D78U, 0x905AU },{ 0x6D79U, 0x9FB3U },
{ 0x6D85U, 0x9FB8U },{ 0x6D87U, 0xFAFBU },{ 0x6D88U, 0x8FC1U },
{ 0x6D8CU, 0x974FU },{ 0x6D8EU, 0x9FB5U },{ 0x6D93U, 0x9FB0U },
{ 0x6D95U, 0x9FB6U },{ 0x6D96U, 0xFB40U },{ 0x6D99U, 0x97DCU },
{ 0x6D9BU, 0x9393U },{ 0x6D9CU, 0x93C0U },{ 0x6DACU, 0xFB41U },
{ 0x6DAFU, 0x8A55U },{ 0x6DB2U, 0x8974U },{ 0x6DB5U, 0x9FBCU },
{ 0x6DB8U, 0x9FBFU },{ 0x6DBCU, 0x97C1U },{ 0x6DC0U, 0x9784U },
{ 0x6DC5U, 0x9FC6U },{ 0x6DC6U, 0x9FC0U },{ 0x6DC7U, 0x9FBDU },
{ 0x6DCBU, 0x97D2U },{ 0x6DCCU, 0x9FC3U },{ 0x6DCFU, 0xFB42U },
{ 0x6DD1U, 0x8F69U },{ 0x6DD2U, 0x9FC5U },{ 0x6DD5U, 0x9FCAU },
{ 0x6DD8U, 0x9391U },{ 0x6DD9U, 0x9FC8U },{ 0x6DDEU, 0x9FC2U },
{ 0x6DE1U, 0x9257U },{ 0x6DE4U, 0x9FC9U },{ 0x6DE6U, 0x9FBEU },
{ 0x6DE8U, 0x9FC4U },{ 0x6DEAU, 0x9FCBU },{ 0x6DEBU, 0x88FAU },
{ 0x6DECU, 0x9FC1U },{ 0x6DEEU, 0x9FCCU },{ 0x6DF1U, 0x905BU },
{ 0x6DF2U, 0xFB44U },{ 0x6DF3U, 0x8F7EU },{ 0x6DF5U, 0x95A3U },
{ 0x6DF7U, 0x8DACU },{ 0x6DF8U, 0xFB43U },{ 0x6DF9U, 0x9FB9U },
{ 0x6DFAU, 0x9FC7U },{ 0x6DFBU, 0x9359U },{ 0x6DFCU, 0xFB45U },
{ 0x6E05U, 0x90B4U },{ 0x6E07U, 0x8A89U },{ 0x6E08U, 0x8DCFU },
{ 0x6E09U, 0x8FC2U },{ 0x6E0AU, 0x9FBBU },{ 0x6E0BU, 0x8F61U },
{ 0x6E13U, 0x8C6BU },{ 0x6E15U, 0x9FBAU },{ 0x6E19U, 0x9FD0U },
{ 0x6E1AU, 0x8F8DU },{ 0x6E1BU, 0x8CB8U },{ 0x6E1DU, 0x9FDFU },
{ 0x6E1FU, 0x9FD9U },{ 0x6E20U, 0x8B94U },{ 0x6E21U, 0x936EU },
{ 0x6E23U, 0x9FD4U },{ 0x6E24U, 0x9FDDU },{ 0x6E25U, 0x88ADU },
{ 0x6E26U, 0x8951U },{ 0x6E27U, 0xFB48U },{ 0x6E29U, 0x89B7U },
{ 0x6E2BU, 0x9FD6U },{ 0x6E2CU, 0x91AAU },{ 0x6E2DU, 0x9FCDU },
{ 0x6E2EU, 0x9FCFU },{ 0x6E2FU, 0x8D60U },{ 0x6E38U, 0x9FE0U },
{ 0x6E39U, 0xFB46U },{ 0x6E3AU, 0x9FDBU },{ 0x6E3CU, 0xFB49U },
{ 0x6E3EU, 0x9FD3U },{ 0x6E43U, 0x9FDAU },{ 0x6E4AU, 0x96A9U },
{ 0x6E4DU, 0x9FD8U },{ 0x6E4EU, 0x9FDCU },{ 0x6E56U, 0x8CCEU },
{ 0x6E58U, 0x8FC3U },{ 0x6E5BU, 0x9258U },{ 0x6E5CU, 0xFB47U },
{ 0x6E5FU, 0x9FD2U },{ 0x6E67U, 0x974EU },{ 0x6E6BU, 0x9FD5U },
{ 0x6E6EU, 0x9FCEU },{ 0x6E6FU, 0x9392U },{ 0x6E72U, 0x9FD1U },
{ 0x6E76U, 0x9FD7U },{ 0x6E7EU, 0x9870U },{ 0x6E7FU, 0x8EBCU },
{ 0x6E80U, 0x969EU },{ 0x6E82U, 0x9FE1U },{ 0x6E8CU, 0x94ACU },
{ 0x6E8FU, 0x9FEDU },{ 0x6E90U, 0x8CB9U },{ 0x6E96U, 0x8F80U },
{ 0x6E98U, 0x9FE3U },{ 0x6E9CU, 0x97ADU },{ 0x6E9DU, 0x8D61U },
{ 0x6E9FU, 0x9FF0U },{ 0x6EA2U, 0x88ECU },{ 0x6EA5U, 0x9FEEU },
{ 0x6EAAU, 0x9FE2U },{ 0x6EAFU, 0x9FE8U },{ 0x6EB2U, 0x9FEAU },
{ 0x6EB6U, 0x976EU },{ 0x6EB7U, 0x9FE5U },{ 0x6EBAU, 0x934DU },
{ 0x6EBDU, 0x9FE7U },{ 0x6EBFU, 0xFB4AU },{ 0x6EC2U, 0x9FEFU },
{ 0x6EC4U, 0x9FE9U },{ 0x6EC5U, 0x96C5U },{ 0x6EC9U, 0x9FE4U },
{ 0x6ECBU, 0x8EA0U },{ 0x6ECCU, 0x9FFCU },{ 0x6ED1U, 0x8A8AU },
{ 0x6ED3U, 0x9FE6U },{ 0x6ED4U, 0x9FEBU },{ 0x6ED5U, 0x9FECU },
{ 0x6EDDU, 0x91EAU },{ 0x6EDEU, 0x91D8U },{ 0x6EECU, 0x9FF4U },
{ 0x6EEFU, 0x9FFAU },{ 0x6EF2U, 0x9FF8U },{ 0x6EF4U, 0x9348U },
{ 0x6EF7U, 0xE042U },{ 0x6EF8U, 0x9FF5U },{ 0x6EFEU, 0x9FF6U },
{ 0x6EFFU, 0x9FDEU },{ 0x6F01U, 0x8B99U },{ 0x6F02U, 0x9559U },
{ 0x6F06U, 0x8EBDU },{ 0x6F09U, 0x8D97U },{ 0x6F0FU, 0x9852U },
{ 0x6F11U, 0x9FF2U },{ 0x6F13U, 0xE041U },{ 0x6F14U, 0x8989U },
{ 0x6F15U, 0x9186U },{ 0x6F20U, 0x9499U },{ 0x6F22U, 0x8ABFU },
{ 0x6F23U, 0x97F8U },{ 0x6F2BU, 0x969FU },{ 0x6F2CU, 0x92D0U },
{ 0x6F31U, 0x9FF9U },{ 0x6F32U, 0x9FFBU },{ 0x6F38U, 0x9151U },
{ 0x6F3EU, 0xE040U },{ 0x6F3FU, 0x9FF7U },{ 0x6F41U, 0x9FF1U },
{ 0x6F45U, 0x8AC1U },{ 0x6F54U, 0x8C89U },{ 0x6F58U, 0xE04EU },
{ 0x6F5BU, 0xE049U },{ 0x6F5CU, 0x90F6U },{ 0x6F5FU, 0x8A83U },
{ 0x6F64U, 0x8F81U },{ 0x6F66U, 0xE052U },{ 0x6F6DU, 0xE04BU },
{ 0x6F6EU, 0x92AAU },{ 0x6F6FU, 0xE048U },{ 0x6F70U, 0x92D7U },
{ 0x6F74U, 0xE06BU },{ 0x6F78U, 0xE045U },{ 0x6F7AU, 0xE044U },
{ 0x6F7CU, 0xE04DU },{ 0x6F80U, 0xE047U },{ 0x6F81U, 0xE046U },
{ 0x6F82U, 0xE04CU },{ 0x6F84U, 0x909FU },{ 0x6F86U, 0xE043U },
{ 0x6F88U, 0xFB4BU },{ 0x6F8EU, 0xE04FU },{ 0x6F91U, 0xE050U },
{ 0x6F97U, 0x8AC0U },{ 0x6FA1U, 0xE055U },{ 0x6FA3U, 0xE054U },
{ 0x6FA4U, 0xE056U },{ 0x6FAAU, 0xE059U },{ 0x6FB1U, 0x9362U },
{ 0x6FB3U, 0xE053U },{ 0x6FB5U, 0xFB4CU },{ 0x6FB9U, 0xE057U },
{ 0x6FC0U, 0x8C83U },{ 0x6FC1U, 0x91F7U },{ 0x6FC2U, 0xE051U },
{ 0x6FC3U, 0x945AU },{ 0x6FC6U, 0xE058U },{ 0x6FD4U, 0xE05DU },
{ 0x6FD5U, 0xE05BU },{ 0x6FD8U, 0xE05EU },{ 0x6FDBU, 0xE061U },
{ 0x6FDFU, 0xE05AU },{ 0x6FE0U, 0x8D8AU },{ 0x6FE1U, 0x9447U },
{ 0x6FE4U, 0x9FB7U },{ 0x6FEBU, 0x9794U },{ 0x6FECU, 0xE05CU },
{ 0x6FEEU, 0xE060U },{ 0x6FEFU, 0x91F3U },{ 0x6FF1U, 0xE05FU },
{ 0x6FF3U, 0xE04AU },{ 0x6FF5U, 0xFB4DU },{ 0x6FF6U, 0xE889U },
{ 0x6FFAU, 0xE064U },{ 0x6FFEU, 0xE068U },{ 0x7001U, 0xE066U },
{ 0x7005U, 0xFB4EU },{ 0x7007U, 0xFB4FU },{ 0x7009U, 0xE062U },
{ 0x700BU, 0xE063U },{ 0x700FU, 0xE067U },{ 0x7011U, 0xE065U },
{ 0x7015U, 0x956DU },{ 0x7018U, 0xE06DU },{ 0x701AU, 0xE06AU },
{ 0x701BU, 0xE069U },{ 0x701DU, 0xE06CU },{ 0x701EU, 0x93D2U },
{ 0x701FU, 0xE06EU },{ 0x7026U, 0x9295U },{ 0x7027U, 0x91EBU },
{ 0x7028U, 0xFB50U },{ 0x702CU, 0x90A3U },{ 0x7030U, 0xE06FU },
{ 0x7032U, 0xE071U },{ 0x703EU, 0xE070U },{ 0x704CU, 0x9FF3U },
{ 0x7051U, 0xE072U },{ 0x7058U, 0x93E5U },{ 0x7063U, 0xE073U },
{ 0x706BU, 0x89CEU },{ 0x706FU, 0x9394U },{ 0x7070U, 0x8A44U },
{ 0x7078U, 0x8B84U },{ 0x707CU, 0x8EDCU },{ 0x707DU, 0x8DD0U },
{ 0x7085U, 0xFB51U },{ 0x7089U, 0x9846U },{ 0x708AU, 0x9086U },
{ 0x708EU, 0x898AU },{ 0x7092U, 0xE075U },{ 0x7099U, 0xE074U },
{ 0x70ABU, 0xFB52U },{ 0x70ACU, 0xE078U },{ 0x70ADU, 0x9259U },
{ 0x70AEU, 0xE07BU },{ 0x70AFU, 0xE076U },{ 0x70B3U, 0xE07AU },
{ 0x70B8U, 0xE079U },{ 0x70B9U, 0x935FU },{ 0x70BAU, 0x88D7U },
{ 0x70BBU, 0xFA62U },{ 0x70C8U, 0x97F3U },{ 0x70CBU, 0xE07DU },
{ 0x70CFU, 0x8947U },{ 0x70D9U, 0xE080U },{ 0x70DDU, 0xE07EU },
{ 0x70DFU, 0xE07CU },{ 0x70F1U, 0xE077U },{ 0x70F9U, 0x9642U },
{ 0x70FDU, 0xE082U },{ 0x7104U, 0xFB54U },{ 0x7109U, 0xE081U },
{ 0x710FU, 0xFB53U },{ 0x7114U, 0x898BU },{ 0x7119U, 0xE084U },
{ 0x711AU, 0x95B0U },{ 0x711CU, 0xE083U },{ 0x7121U, 0x96B3U },
{ 0x7126U, 0x8FC5U },{ 0x7136U, 0x9152U },{ 0x713CU, 0x8FC4U },
{ 0x7146U, 0xFB56U },{ 0x7147U, 0xFB57U },{ 0x7149U, 0x97F9U },
{ 0x714CU, 0xE08AU },{ 0x714EU, 0x90F7U },{ 0x7155U, 0xE086U },
{ 0x7156U, 0xE08BU },{ 0x7159U, 0x898CU },{ 0x715CU, 0xFB55U },
{ 0x7162U, 0xE089U },{ 0x7164U, 0x9481U },{ 0x7165U, 0xE085U },
{ 0x7166U, 0xE088U },{ 0x7167U, 0x8FC6U },{ 0x7169U, 0x94CFU },
{ 0x716CU, 0xE08CU },{ 0x716EU, 0x8ECFU },{ 0x717DU, 0x90F8U },
{ 0x7184U, 0xE08FU },{ 0x7188U, 0xE087U },{ 0x718AU, 0x8C46U },
{ 0x718FU, 0xE08DU },{ 0x7194U, 0x976FU },{ 0x7195U, 0xE090U },
{ 0x7199U, 0xEAA4U },{ 0x719FU, 0x8F6EU },{ 0x71A8U, 0xE091U },
{ 0x71ACU, 0xE092U },{ 0x71B1U, 0x944DU },{ 0x71B9U, 0xE094U },
{ 0x71BEU, 0xE095U },{ 0x71C1U, 0xFB59U },{ 0x71C3U, 0x9452U },
{ 0x71C8U, 0x9395U },{ 0x71C9U, 0xE097U },{ 0x71CEU, 0xE099U },
{ 0x71D0U, 0x97D3U },{ 0x71D2U, 0xE096U },{ 0x71D4U, 0xE098U },
{ 0x71D5U, 0x898DU },{ 0x71D7U, 0xE093U },{ 0x71DFU, 0x9A7AU },
{ 0x71E0U, 0xE09AU },{ 0x71E5U, 0x9187U },{ 0x71E6U, 0x8E57U },
{ 0x71E7U, 0xE09CU },{ 0x71ECU, 0xE09BU },{ 0x71EDU, 0x9043U },
{ 0x71EEU, 0x99D7U },{ 0x71F5U, 0xE09DU },{ 0x71F9U, 0xE09FU },
{ 0x71FBU, 0xE08EU },{ 0x71FCU, 0xE09EU },{ 0x71FEU, 0xFB5AU },
{ 0x71FFU, 0xE0A0U },{ 0x7206U, 0x949AU },{ 0x720DU, 0xE0A1U },
{ 0x7210U, 0xE0A2U },{ 0x721BU, 0xE0A3U },{ 0x7228U, 0xE0A4U },
{ 0x722AU, 0x92DCU },{ 0x722CU, 0xE0A6U },{ 0x722DU, 0xE0A5U },
{ 0x7230U, 0xE0A7U },{ 0x7232U, 0xE0A8U },{ 0x7235U, 0x8EDDU },
{ 0x7236U, 0x9583U },{ 0x723AU, 0x96EAU },{ 0x723BU, 0xE0A9U },
{ 0x723CU, 0xE0AAU },{ 0x723DU, 0x9175U },{ 0x723EU, 0x8EA2U },
{ 0x723FU, 0xE0ABU },{ 0x7240U, 0xE0ACU },{ 0x7246U, 0xE0ADU },
{ 0x7247U, 0x95D0U },{ 0x7248U, 0x94C5U },{ 0x724BU, 0xE0AEU },
{ 0x724CU, 0x9476U },{ 0x7252U, 0x92ABU },{ 0x7258U, 0xE0AFU },
{ 0x7259U, 0x89E5U },{ 0x725BU, 0x8B8DU },{ 0x725DU, 0x96C4U },
{ 0x725FU, 0x96B4U },{ 0x7261U, 0x89B2U },{ 0x7262U, 0x9853U },
{ 0x7267U, 0x9671U },{ 0x7269U, 0x95A8U },{ 0x7272U, 0x90B5U },
{ 0x7274U, 0xE0B0U },{ 0x7279U, 0x93C1U },{ 0x727DU, 0x8CA1U },
{ 0x727EU, 0xE0B1U },{ 0x7280U, 0x8DD2U },{ 0x7281U, 0xE0B3U },
{ 0x7282U, 0xE0B2U },{ 0x7287U, 0xE0B4U },{ 0x7292U, 0xE0B5U },
{ 0x7296U, 0xE0B6U },{ 0x72A0U, 0x8B5DU },{ 0x72A2U, 0xE0B7U },
{ 0x72A7U, 0xE0B8U },{ 0x72ACU, 0x8CA2U },{ 0x72AFU, 0x94C6U },
{ 0x72B1U, 0xFB5BU },{ 0x72B2U, 0xE0BAU },{ 0x72B6U, 0x8FF3U },
{ 0x72B9U, 0xE0B9U },{ 0x72BEU, 0xFB5CU },{ 0x72C2U, 0x8BB6U },
{ 0x72C3U, 0xE0BBU },{ 0x72C4U, 0xE0BDU },{ 0x72C6U, 0xE0BCU },
{ 0x72CEU, 0xE0BEU },{ 0x72D0U, 0x8CCFU },{ 0x72D2U, 0xE0BFU },
{ 0x72D7U, 0x8BE7U },{ 0x72D9U, 0x915FU },{ 0x72DBU, 0x8D9DU },
{ 0x72E0U, 0xE0C1U },{ 0x72E1U, 0xE0C2U },{ 0x72E2U, 0xE0C0U },
{ 0x72E9U, 0x8EEBU },{ 0x72ECU, 0x93C6U },{ 0x72EDU, 0x8BB7U },
{ 0x72F7U, 0xE0C4U },{ 0x72F8U, 0x924BU },{ 0x72F9U, 0xE0C3U },
{ 0x72FCU, 0x9854U },{ 0x72FDU, 0x9482U },{ 0x730AU, 0xE0C7U },
{ 0x7316U, 0xE0C9U },{ 0x7317U, 0xE0C6U },{ 0x731BU, 0x96D2U },
{ 0x731CU, 0xE0C8U },{ 0x731DU, 0xE0CAU },{ 0x731FU, 0x97C2U },
{ 0x7324U, 0xFB5DU },{ 0x7325U, 0xE0CEU },{ 0x7329U, 0xE0CDU },
{ 0x732AU, 0x9296U },{ 0x732BU, 0x944CU },{ 0x732EU, 0x8CA3U },
{ 0x732FU, 0xE0CCU },{ 0x7334U, 0xE0CBU },{ 0x7336U, 0x9750U },
{ 0x7337U, 0x9751U },{ 0x733EU, 0xE0CFU },{ 0x733FU, 0x898EU },
{ 0x7344U, 0x8D96U },{ 0x7345U, 0x8E82U },{ 0x734EU, 0xE0D0U },
{ 0x734FU, 0xE0D1U },{ 0x7357U, 0xE0D3U },{ 0x7363U, 0x8F62U },
{ 0x7368U, 0xE0D5U },{ 0x736AU, 0xE0D4U },{ 0x7370U, 0xE0D6U },
{ 0x7372U, 0x8A6CU },{ 0x7375U, 0xE0D8U },{ 0x7377U, 0xFB5FU },
{ 0x7378U, 0xE0D7U },{ 0x737AU, 0xE0DAU },{ 0x737BU, 0xE0D9U },
{ 0x7384U, 0x8CBAU },{ 0x7387U, 0x97A6U },{ 0x7389U, 0x8BCAU },
{ 0x738BU, 0x89A4U },{ 0x7396U, 0x8BE8U },{ 0x73A9U, 0x8ADFU },
{ 0x73B2U, 0x97E6U },{ 0x73B3U, 0xE0DCU },{ 0x73BBU, 0xE0DEU },
{ 0x73BDU, 0xFB60U },{ 0x73C0U, 0xE0DFU },{ 0x73C2U, 0x89CFU },
{ 0x73C8U, 0xE0DBU },{ 0x73C9U, 0xFB61U },{ 0x73CAU, 0x8E58U },
{ 0x73CDU, 0x92BFU },{ 0x73CEU, 0xE0DDU },{ 0x73D2U, 0xFB64U },
{ 0x73D6U, 0xFB62U },{ 0x73DEU, 0xE0E2U },{ 0x73E0U, 0x8EECU },
{ 0x73E3U, 0xFB63U },{ 0x73E5U, 0xE0E0U },{ 0x73EAU, 0x8C5DU },
{ 0x73EDU, 0x94C7U },{ 0x73EEU, 0xE0E1U },{ 0x73F1U, 0xE0FCU },
{ 0x73F5U, 0xFB66U },{ 0x73F8U, 0xE0E7U },{ 0x73FEU, 0x8CBBU },
{ 0x7403U, 0x8B85U },{ 0x7405U, 0xE0E4U },{ 0x7406U, 0x979DU },
{ 0x7407U, 0xFB65U },{ 0x7409U, 0x97AEU },{ 0x7422U, 0x91F4U },
{ 0x7425U, 0xE0E6U },{ 0x7426U, 0xFB67U },{ 0x7429U, 0xFB69U },
{ 0x742AU, 0xFB68U },{ 0x742EU, 0xFB6AU },{ 0x7432U, 0xE0E8U },
{ 0x7433U, 0x97D4U },{ 0x7434U, 0x8BD5U },{ 0x7435U, 0x94FAU },
{ 0x7436U, 0x9469U },{ 0x743AU, 0xE0E9U },{ 0x743FU, 0xE0EBU },
{ 0x7441U, 0xE0EEU },{ 0x7455U, 0xE0EAU },{ 0x7459U, 0xE0EDU },
{ 0x745AU, 0x8CE8U },{ 0x745BU, 0x896CU },{ 0x745CU, 0xE0EFU },
{ 0x745EU, 0x9090U },{ 0x745FU, 0xE0ECU },{ 0x7460U, 0x97DAU },
{ 0x7462U, 0xFB6BU },{ 0x7463U, 0xE0F2U },{ 0x7464U, 0xEAA2U },
{ 0x7469U, 0xE0F0U },{ 0x746AU, 0xE0F3U },{ 0x746FU, 0xE0E5U },
{ 0x7470U, 0xE0F1U },{ 0x7473U, 0x8DBAU },{ 0x7476U, 0xE0F4U },
{ 0x747EU, 0xE0F5U },{ 0x7483U, 0x979EU },{ 0x7489U, 0xFB6CU },
{ 0x748BU, 0xE0F6U },{ 0x749EU, 0xE0F7U },{ 0x749FU, 0xFB6DU },
{ 0x74A2U, 0xE0E3U },{ 0x74A7U, 0xE0F8U },{ 0x74B0U, 0x8AC2U },
{ 0x74BDU, 0x8EA3U },{ 0x74CAU, 0xE0F9U },{ 0x74CFU, 0xE0FAU },
{ 0x74D4U, 0xE0FBU },{ 0x74DCU, 0x895AU },{ 0x74E0U, 0xE140U },
{ 0x74E2U, 0x955AU },{ 0x74E3U, 0xE141U },{ 0x74E6U, 0x8AA2U },
{ 0x74E7U, 0xE142U },{ 0x74E9U, 0xE143U },{ 0x74EEU, 0xE144U },
{ 0x74F0U, 0xE146U },{ 0x74F1U, 0xE147U },{ 0x74F2U, 0xE145U },
{ 0x74F6U, 0x9572U },{ 0x74F7U, 0xE149U },{ 0x74F8U, 0xE148U },
{ 0x7501U, 0xFB6EU },{ 0x7503U, 0xE14BU },{ 0x7504U, 0xE14AU },
{ 0x7505U, 0xE14CU },{ 0x750CU, 0xE14DU },{ 0x750DU, 0xE14FU },
{ 0x750EU, 0xE14EU },{ 0x7511U, 0x8D99U },{ 0x7513U, 0xE151U },
{ 0x7515U, 0xE150U },{ 0x7518U, 0x8AC3U },{ 0x751AU, 0x9072U },
{ 0x751CU, 0x935BU },{ 0x751EU, 0xE152U },{ 0x751FU, 0x90B6U },
{ 0x7523U, 0x8E59U },{ 0x7525U, 0x8999U },{ 0x7526U, 0xE153U },
{ 0x7528U, 0x9770U },{ 0x752BU, 0x95E1U },{ 0x752CU, 0xE154U },
{ 0x752FU, 0xFAA8U },{ 0x7530U, 0x9363U },{ 0x7531U, 0x9752U },
{ 0x7532U, 0x8D62U },{ 0x7533U, 0x905CU },{ 0x7537U, 0x926AU },
{ 0x7538U, 0x99B2U },{ 0x753AU, 0x92ACU },{ 0x753BU, 0x89E6U },
{ 0x753CU, 0xE155U },{ 0x7544U, 0xE156U },{ 0x7546U, 0xE15BU },
{ 0x7549U, 0xE159U },{ 0x754AU, 0xE158U },{ 0x754BU, 0x9DC0U },
{ 0x754CU, 0x8A45U },{ 0x754DU, 0xE157U },{ 0x754FU, 0x88D8U },
{ 0x7551U, 0x94A8U },{ 0x7554U, 0x94C8U },{ 0x7559U, 0x97AFU },
{ 0x755AU, 0xE15CU },{ 0x755BU, 0xE15AU },{ 0x755CU, 0x927BU },
{ 0x755DU, 0x90A4U },{ 0x7560U, 0x94A9U },{ 0x7562U, 0x954CU },
{ 0x7564U, 0xE15EU },{ 0x7565U, 0x97AAU },{ 0x7566U, 0x8C6CU },
{ 0x7567U, 0xE15FU },{ 0x7569U, 0xE15DU },{ 0x756AU, 0x94D4U },
{ 0x756BU, 0xE160U },{ 0x756DU, 0xE161U },{ 0x756FU, 0xFB6FU },
{ 0x7570U, 0x88D9U },{ 0x7573U, 0x8FF4U },{ 0x7574U, 0xE166U },
{ 0x7576U, 0xE163U },{ 0x7577U, 0x93EBU },{ 0x7578U, 0xE162U },
{ 0x757FU, 0x8B45U },{ 0x7582U, 0xE169U },{ 0x7586U, 0xE164U },
{ 0x7587U, 0xE165U },{ 0x7589U, 0xE168U },{ 0x758AU, 0xE167U },
{ 0x758BU, 0x9544U },{ 0x758EU, 0x9161U },{ 0x758FU, 0x9160U },
{ 0x7591U, 0x8B5EU },{ 0x7594U, 0xE16AU },{ 0x759AU, 0xE16BU },
{ 0x759DU, 0xE16CU },{ 0x75A3U, 0xE16EU },{ 0x75A5U, 0xE16DU },
{ 0x75ABU, 0x8975U },{ 0x75B1U, 0xE176U },{ 0x75B2U, 0x94E6U },
{ 0x75B3U, 0xE170U },{ 0x75B5U, 0xE172U },{ 0x75B8U, 0xE174U },
{ 0x75B9U, 0x905DU },{ 0x75BCU, 0xE175U },{ 0x75BDU, 0xE173U },
{ 0x75BEU, 0x8EBEU },{ 0x75C2U, 0xE16FU },{ 0x75C3U, 0xE171U },
{ 0x75C5U, 0x9561U },{ 0x75C7U, 0x8FC7U },{ 0x75CAU, 0xE178U },
{ 0x75CDU, 0xE177U },{ 0x75D2U, 0xE179U },{ 0x75D4U, 0x8EA4U },
{ 0x75D5U, 0x8DADU },{ 0x75D8U, 0x9397U },{ 0x75D9U, 0xE17AU },
{ 0x75DBU, 0x92C9U },{ 0x75DEU, 0xE17CU },{ 0x75E2U, 0x979FU },
{ 0x75E3U, 0xE17BU },{ 0x75E9U, 0x9189U },{ 0x75F0U, 0xE182U },
{ 0x75F2U, 0xE184U },{ 0x75F3U, 0xE185U },{ 0x75F4U, 0x9273U },
{ 0x75FAU, 0xE183U },{ 0x75FCU, 0xE180U },{ 0x75FEU, 0xE17DU },
{ 0x75FFU, 0xE17EU },{ 0x7601U, 0xE181U },{ 0x7609U, 0xE188U },
{ 0x760BU, 0xE186U },{ 0x760DU, 0xE187U },{ 0x761FU, 0xE189U },
{ 0x7620U, 0xE18BU },{ 0x7621U, 0xE18CU },{ 0x7622U, 0xE18DU },
{ 0x7624U, 0xE18EU },{ 0x7627U, 0xE18AU },{ 0x7630U, 0xE190U },
{ 0x7634U, 0xE18FU },{ 0x763BU, 0xE191U },{ 0x7642U, 0x97C3U },
{ 0x7646U, 0xE194U },{ 0x7647U, 0xE192U },{ 0x7648U, 0xE193U },
{ 0x764CU, 0x8AE0U },{ 0x7652U, 0x96FCU },{ 0x7656U, 0x95C8U },
{ 0x7658U, 0xE196U },{ 0x765CU, 0xE195U },{ 0x7661U, 0xE197U },
{ 0x7662U, 0xE198U },{ 0x7667U, 0xE19CU },{ 0x7668U, 0xE199U },
{ 0x7669U, 0xE19AU },{ 0x766AU, 0xE19BU },{ 0x766CU, 0xE19DU },
{ 0x7670U, 0xE19EU },{ 0x7672U, 0xE19FU },{ 0x7676U, 0xE1A0U },
{ 0x7678U, 0xE1A1U },{ 0x767AU, 0x94ADU },{ 0x767BU, 0x936FU },
{ 0x767CU, 0xE1A2U },{ 0x767DU, 0x9492U },{ 0x767EU, 0x9553U },
{ 0x7680U, 0xE1A3U },{ 0x7682U, 0xFB70U },{ 0x7683U, 0xE1A4U },
{ 0x7684U, 0x9349U },{ 0x7686U, 0x8A46U },{ 0x7687U, 0x8D63U },
{ 0x7688U, 0xE1A5U },{ 0x768BU, 0xE1A6U },{ 0x768EU, 0xE1A7U },
{ 0x7690U, 0x8E48U },{ 0x7693U, 0xE1A9U },{ 0x7696U, 0xE1A8U },
{ 0x7699U, 0xE1AAU },{ 0x769AU, 0xE1ABU },{ 0x769BU, 0xFB73U },
{ 0x769CU, 0xFB71U },{ 0x769EU, 0xFB72U },{ 0x76A6U, 0xFB74U },
{ 0x76AEU, 0x94E7U },{ 0x76B0U, 0xE1ACU },{ 0x76B4U, 0xE1ADU },
{ 0x76B7U, 0xEA89U },{ 0x76B8U, 0xE1AEU },{ 0x76B9U, 0xE1AFU },
{ 0x76BAU, 0xE1B0U },{ 0x76BFU, 0x8E4DU },{ 0x76C2U, 0xE1B1U },
{ 0x76C3U, 0x9475U },{ 0x76C6U, 0x967EU },{ 0x76C8U, 0x896DU },
{ 0x76CAU, 0x8976U },{ 0x76CDU, 0xE1B2U },{ 0x76D2U, 0xE1B4U },
{ 0x76D6U, 0xE1B3U },{ 0x76D7U, 0x9390U },{ 0x76DBU, 0x90B7U },
{ 0x76DCU, 0x9F58U },{ 0x76DEU, 0xE1B5U },{ 0x76DFU, 0x96BFU },
{ 0x76E1U, 0xE1B6U },{ 0x76E3U, 0x8AC4U },{ 0x76E4U, 0x94D5U },
{ 0x76E5U, 0xE1B7U },{ 0x76E7U, 0xE1B8U },{ 0x76EAU, 0xE1B9U },
{ 0x76EEU, 0x96DAU },{ 0x76F2U, 0x96D3U },{ 0x76F4U, 0x92BCU },
{ 0x76F8U, 0x918AU },{ 0x76FBU, 0xE1BBU },{ 0x76FEU, 0x8F82U },
{ 0x7701U, 0x8FC8U },{ 0x7704U, 0xE1BEU },{ 0x7707U, 0xE1BDU },
{ 0x7708U, 0xE1BCU },{ 0x7709U, 0x94FBU },{ 0x770BU, 0x8AC5U },
{ 0x770CU, 0x8CA7U },{ 0x771BU, 0xE1C4U },{ 0x771EU, 0xE1C1U },
{ 0x771FU, 0x905EU },{ 0x7720U, 0x96B0U },{ 0x7724U, 0xE1C0U },
{ 0x7725U, 0xE1C2U },{ 0x7726U, 0xE1C3U },{ 0x7729U, 0xE1BFU },
{ 0x7737U, 0xE1C5U },{ 0x7738U, 0xE1C6U },{ 0x773AU, 0x92ADU },
{ 0x773CU, 0x8AE1U },{ 0x7740U, 0x9285U },{ 0x7746U, 0xFB76U },
{ 0x7747U, 0xE1C7U },{ 0x775AU, 0xE1C8U },{ 0x775BU, 0xE1CBU },
{ 0x7761U, 0x9087U },{ 0x7763U, 0x93C2U },{ 0x7765U, 0xE1CCU },
{ 0x7766U, 0x9672U },{ 0x7768U, 0xE1C9U },{ 0x776BU, 0xE1CAU },
{ 0x7779U, 0xE1CFU },{ 0x777EU, 0xE1CEU },{ 0x777FU, 0xE1CDU },
{ 0x778BU, 0xE1D1U },{ 0x778EU, 0xE1D0U },{ 0x7791U, 0xE1D2U },
{ 0x779EU, 0xE1D4U },{ 0x77A0U, 0xE1D3U },{ 0x77A5U, 0x95CBU },
{ 0x77ACU, 0x8F75U },{ 0x77ADU, 0x97C4U },{ 0x77B0U, 0xE1D5U },
{ 0x77B3U, 0x93B5U },{ 0x77B6U, 0xE1D6U },{ 0x77B9U, 0xE1D7U },
{ 0x77BBU, 0xE1DBU },{ 0x77BCU, 0xE1D9U },{ 0x77BDU, 0xE1DAU },
{ 0x77BFU, 0xE1D8U },{ 0x77C7U, 0xE1DCU },{ 0x77CDU, 0xE1DDU },
{ 0x77D7U, 0xE1DEU },{ 0x77DAU, 0xE1DFU },{ 0x77DBU, 0x96B5U },
{ 0x77DCU, 0xE1E0U },{ 0x77E2U, 0x96EEU },{ 0x77E3U, 0xE1E1U },
{ 0x77E5U, 0x926DU },{ 0x77E7U, 0x948AU },{ 0x77E9U, 0x8BE9U },
{ 0x77EDU, 0x925AU },{ 0x77EEU, 0xE1E2U },{ 0x77EFU, 0x8BB8U },
{ 0x77F3U, 0x90CEU },{ 0x77FCU, 0xE1E3U },{ 0x7802U, 0x8DBBU },
{ 0x780CU, 0xE1E4U },{ 0x7812U, 0xE1E5U },{ 0x7814U, 0x8CA4U },
{ 0x7815U, 0x8DD3U },{ 0x7820U, 0xE1E7U },{ 0x7821U, 0xFB78U },
{ 0x7825U, 0x9375U },{ 0x7826U, 0x8DD4U },{ 0x7827U, 0x8B6DU },
{ 0x7832U, 0x9643U },{ 0x7834U, 0x946AU },{ 0x783AU, 0x9376U },
{ 0x783FU, 0x8D7BU },{ 0x7845U, 0xE1E9U },{ 0x784EU, 0xFB79U },
{ 0x785DU, 0x8FC9U },{ 0x7864U, 0xFB7AU },{ 0x786BU, 0x97B0U },
{ 0x786CU, 0x8D64U },{ 0x786FU, 0x8CA5U },{ 0x7872U, 0x94A1U },
{ 0x7874U, 0xE1EBU },{ 0x787AU, 0xFB7BU },{ 0x787CU, 0xE1EDU },
{ 0x7881U, 0x8CE9U },{ 0x7886U, 0xE1ECU },{ 0x7887U, 0x92F4U },
{ 0x788CU, 0xE1EFU },{ 0x788DU, 0x8A56U },{ 0x788EU, 0xE1EAU },
{ 0x7891U, 0x94E8U },{ 0x7893U, 0x894FU },{ 0x7895U, 0x8DEAU },
{ 0x7897U, 0x9871U },{ 0x789AU, 0xE1EEU },{ 0x78A3U, 0xE1F0U },
{ 0x78A7U, 0x95C9U },{ 0x78A9U, 0x90D7U },{ 0x78AAU, 0xE1F2U },
{ 0x78AFU, 0xE1F3U },{ 0x78B5U, 0xE1F1U },{ 0x78BAU, 0x8A6DU },
{ 0x78BCU, 0xE1F9U },{ 0x78BEU, 0xE1F8U },{ 0x78C1U, 0x8EA5U },
{ 0x78C5U, 0xE1FAU },{ 0x78C6U, 0xE1F5U },{ 0x78CAU, 0xE1FBU },
{ 0x78CBU, 0xE1F6U },{ 0x78D0U, 0x94D6U },{ 0x78D1U, 0xE1F4U },
{ 0x78D4U, 0xE1F7U },{ 0x78DAU, 0xE241U },{ 0x78E7U, 0xE240U },
{ 0x78E8U, 0x9681U },{ 0x78ECU, 0xE1FCU },{ 0x78EFU, 0x88E9U },
{ 0x78F4U, 0xE243U },{ 0x78FDU, 0xE242U },{ 0x7901U, 0x8FCAU },
{ 0x7907U, 0xE244U },{ 0x790EU, 0x9162U },{ 0x7911U, 0xE246U },
{ 0x7912U, 0xE245U },{ 0x7919U, 0xE247U },{ 0x7926U, 0xE1E6U },
{ 0x792AU, 0xE1E8U },{ 0x792BU, 0xE249U },{ 0x792CU, 0xE248U },
{ 0x7930U, 0xFB7CU },{ 0x793AU, 0x8EA6U },{ 0x793CU, 0x97E7U },
{ 0x793EU, 0x8ED0U },{ 0x7940U, 0xE24AU },{ 0x7941U, 0x8C56U },
{ 0x7947U, 0x8B5FU },{ 0x7948U, 0x8B46U },{ 0x7949U, 0x8E83U },
{ 0x7950U, 0x9753U },{ 0x7953U, 0xE250U },{ 0x7955U, 0xE24FU },
{ 0x7956U, 0x9163U },{ 0x7957U, 0xE24CU },{ 0x795AU, 0xE24EU },
{ 0x795DU, 0x8F6AU },{ 0x795EU, 0x905FU },{ 0x795FU, 0xE24DU },
{ 0x7960U, 0xE24BU },{ 0x7962U, 0x9449U },{ 0x7965U, 0x8FCBU },
{ 0x7968U, 0x955BU },{ 0x796DU, 0x8DD5U },{ 0x7977U, 0x9398U },
{ 0x797AU, 0xE251U },{ 0x797FU, 0xE252U },{ 0x7980U, 0xE268U },
{ 0x7981U, 0x8BD6U },{ 0x7984U, 0x985CU },{ 0x7985U, 0x9154U },
{ 0x798AU, 0xE253U },{ 0x798DU, 0x89D0U },{ 0x798EU, 0x92F5U },
{ 0x798FU, 0x959FU },{ 0x7994U, 0xFB81U },{ 0x799BU, 0xFB83U },
{ 0x799DU, 0xE254U },{ 0x79A6U, 0x8B9AU },{ 0x79A7U, 0xE255U },
{ 0x79AAU, 0xE257U },{ 0x79AEU, 0xE258U },{ 0x79B0U, 0x9448U },
{ 0x79B3U, 0xE259U },{ 0x79B9U, 0xE25AU },{ 0x79BAU, 0xE25BU },
{ 0x79BDU, 0x8BD7U },{ 0x79BEU, 0x89D1U },{ 0x79BFU, 0x93C3U },
{ 0x79C0U, 0x8F47U },{ 0x79C1U, 0x8E84U },{ 0x79C9U, 0xE25CU },
{ 0x79CBU, 0x8F48U },{ 0x79D1U, 0x89C8U },{ 0x79D2U, 0x9562U },
{ 0x79D5U, 0xE25DU },{ 0x79D8U, 0x94E9U },{ 0x79DFU, 0x9164U },
{ 0x79E1U, 0xE260U },{ 0x79E3U, 0xE261U },{ 0x79E4U, 0x9489U },
{ 0x79E6U, 0x9060U },{ 0x79E7U, 0xE25EU },{ 0x79E9U, 0x9281U },
{ 0x79ECU, 0xE25FU },{ 0x79F0U, 0x8FCCU },{ 0x79FBU, 0x88DAU },
{ 0x7A00U, 0x8B48U },{ 0x7A08U, 0xE262U },{ 0x7A0BU, 0x92F6U },
{ 0x7A0DU, 0xE263U },{ 0x7A0EU, 0x90C5U },{ 0x7A14U, 0x96ABU },
{ 0x7A17U, 0x9542U },{ 0x7A18U, 0xE264U },{ 0x7A19U, 0xE265U },
{ 0x7A1AU, 0x9274U },{ 0x7A1CU, 0x97C5U },{ 0x7A1FU, 0xE267U },
{ 0x7A20U, 0xE266U },{ 0x7A2EU, 0x8EEDU },{ 0x7A31U, 0xE269U },
{ 0x7A32U, 0x88EEU },{ 0x7A37U, 0xE26CU },{ 0x7A3BU, 0xE26AU },
{ 0x7A3CU, 0x89D2U },{ 0x7A3DU, 0x8C6DU },{ 0x7A3EU, 0xE26BU },
{ 0x7A3FU, 0x8D65U },{ 0x7A40U, 0x8D92U },{ 0x7A42U, 0x95E4U },
{ 0x7A43U, 0xE26DU },{ 0x7A46U, 0x9673U },{ 0x7A49U, 0xE26FU },
{ 0x7A4DU, 0x90CFU },{ 0x7A4EU, 0x896EU },{ 0x7A4FU, 0x89B8U },
{ 0x7A50U, 0x88AAU },{ 0x7A57U, 0xE26EU },{ 0x7A61U, 0xE270U },
{ 0x7A62U, 0xE271U },{ 0x7A63U, 0x8FF5U },{ 0x7A69U, 0xE272U },
{ 0x7A6BU, 0x8A6EU },{ 0x7A70U, 0xE274U },{ 0x7A74U, 0x8C8AU },
{ 0x7A76U, 0x8B86U },{ 0x7A79U, 0xE275U },{ 0x7A7AU, 0x8BF3U },
{ 0x7A7DU, 0xE276U },{ 0x7A7FU, 0x90FAU },{ 0x7A81U, 0x93CBU },
{ 0x7A83U, 0x90DEU },{ 0x7A84U, 0x8DF3U },{ 0x7A88U, 0xE277U },
{ 0x7A92U, 0x9282U },{ 0x7A93U, 0x918BU },{ 0x7A95U, 0xE279U },
{ 0x7A96U, 0xE27BU },{ 0x7A97U, 0xE278U },{ 0x7A98U, 0xE27AU },
{ 0x7A9FU, 0x8C41U },{ 0x7AA9U, 0xE27CU },{ 0x7AAAU, 0x8C45U },
{ 0x7AAEU, 0x8B87U },{ 0x7AAFU, 0x9771U },{ 0x7AB0U, 0xE27EU },
{ 0x7AB6U, 0xE280U },{ 0x7ABAU, 0x894DU },{ 0x7ABFU, 0xE283U },
{ 0x7AC3U, 0x8A96U },{ 0x7AC4U, 0xE282U },{ 0x7AC5U, 0xE281U },
{ 0x7AC7U, 0xE285U },{ 0x7AC8U, 0xE27DU },{ 0x7ACAU, 0xE286U },
{ 0x7ACBU, 0x97A7U },{ 0x7ACDU, 0xE287U },{ 0x7ACFU, 0xE288U },
{ 0x7AD1U, 0xFB84U },{ 0x7AD2U, 0x9AF2U },{ 0x7AD3U, 0xE28AU },
{ 0x7AD5U, 0xE289U },{ 0x7AD9U, 0xE28BU },{ 0x7ADAU, 0xE28CU },
{ 0x7ADCU, 0x97B3U },{ 0x7ADDU, 0xE28DU },{ 0x7ADFU, 0xE8EDU },
{ 0x7AE0U, 0x8FCDU },{ 0x7AE1U, 0xE28EU },{ 0x7AE2U, 0xE28FU },
{ 0x7AE3U, 0x8F76U },{ 0x7AE5U, 0x93B6U },{ 0x7AE6U, 0xE290U },
{ 0x7AE7U, 0xFB85U },{ 0x7AEAU, 0x9247U },{ 0x7AEBU, 0xFB87U },
{ 0x7AEDU, 0xE291U },{ 0x7AEFU, 0x925BU },{ 0x7AF0U, 0xE292U },
{ 0x7AF6U, 0x8BA3U },{ 0x7AF8U, 0x995EU },{ 0x7AF9U, 0x927CU },
{ 0x7AFAU, 0x8EB1U },{ 0x7AFFU, 0x8AC6U },{ 0x7B02U, 0xE293U },
{ 0x7B04U, 0xE2A0U },{ 0x7B06U, 0xE296U },{ 0x7B08U, 0x8B88U },
{ 0x7B0AU, 0xE295U },{ 0x7B0BU, 0xE2A2U },{ 0x7B0FU, 0xE294U },
{ 0x7B11U, 0x8FCEU },{ 0x7B18U, 0xE298U },{ 0x7B19U, 0xE299U },
{ 0x7B1BU, 0x934AU },{ 0x7B1EU, 0xE29AU },{ 0x7B20U, 0x8A7DU },
{ 0x7B25U, 0x9079U },{ 0x7B26U, 0x9584U },{ 0x7B28U, 0xE29CU },
{ 0x7B2CU, 0x91E6U },{ 0x7B33U, 0xE297U },{ 0x7B35U, 0xE29BU },
{ 0x7B36U, 0xE29DU },{ 0x7B39U, 0x8DF9U },{ 0x7B45U, 0xE2A4U },
{ 0x7B46U, 0x954DU },{ 0x7B48U, 0x94A4U },{ 0x7B49U, 0x9399U },
{ 0x7B4BU, 0x8BD8U },{ 0x7B4CU, 0xE2A3U },{ 0x7B4DU, 0xE2A1U },
{ 0x7B4FU, 0x94B3U },{ 0x7B50U, 0xE29EU },{ 0x7B51U, 0x927DU },
{ 0x7B52U, 0x939BU },{ 0x7B54U, 0x939AU },{ 0x7B56U, 0x8DF4U },
{ 0x7B5DU, 0xE2B6U },{ 0x7B65U, 0xE2A6U },{ 0x7B67U, 0xE2A8U },
{ 0x7B6CU, 0xE2ABU },{ 0x7B6EU, 0xE2ACU },{ 0x7B70U, 0xE2A9U },
{ 0x7B71U, 0xE2AAU },{ 0x7B74U, 0xE2A7U },{ 0x7B75U, 0xE2A5U },
{ 0x7B7AU, 0xE29FU },{ 0x7B86U, 0x95CDU },{ 0x7B87U, 0x89D3U },
{ 0x7B8BU, 0xE2B3U },{ 0x7B8DU, 0xE2B0U },{ 0x7B8FU, 0xE2B5U },
{ 0x7B92U, 0xE2B4U },{ 0x7B94U, 0x9493U },{ 0x7B95U, 0x96A5U },
{ 0x7B97U, 0x8E5AU },{ 0x7B98U, 0xE2AEU },{ 0x7B99U, 0xE2B7U },
{ 0x7B9AU, 0xE2B2U },{ 0x7B9CU, 0xE2B1U },{ 0x7B9DU, 0xE2ADU },
{ 0x7B9EU, 0xFB88U },{ 0x7B9FU, 0xE2AFU },{ 0x7BA1U, 0x8AC7U },
{ 0x7BAAU, 0x925CU },{ 0x7BADU, 0x90FBU },{ 0x7BB1U, 0x94A0U },
{ 0x7BB4U, 0xE2BCU },{ 0x7BB8U, 0x94A2U },{ 0x7BC0U, 0x90DFU },
{ 0x7BC1U, 0xE2B9U },{ 0x7BC4U, 0x94CDU },{ 0x7BC6U, 0xE2BDU },
{ 0x7BC7U, 0x95D1U },{ 0x7BC9U, 0x927AU },{ 0x7BCBU, 0xE2B8U },
{ 0x7BCCU, 0xE2BAU },{ 0x7BCFU, 0xE2BBU },{ 0x7BDDU, 0xE2BEU },
{ 0x7BE0U, 0x8EC2U },{ 0x7BE4U, 0x93C4U },{ 0x7BE5U, 0xE2C3U },
{ 0x7BE6U, 0xE2C2U },{ 0x7BE9U, 0xE2BFU },{ 0x7BEDU, 0x9855U },
{ 0x7BF3U, 0xE2C8U },{ 0x7BF6U, 0xE2CCU },{ 0x7BF7U, 0xE2C9U },
{ 0x7C00U, 0xE2C5U },{ 0x7C07U, 0xE2C6U },{ 0x7C0DU, 0xE2CBU },
{ 0x7C11U, 0xE2C0U },{ 0x7C12U, 0x99D3U },{ 0x7C13U, 0xE2C7U },
{ 0x7C14U, 0xE2C1U },{ 0x7C17U, 0xE2CAU },{ 0x7C1FU, 0xE2D0U },
{ 0x7C21U, 0x8AC8U },{ 0x7C23U, 0xE2CDU },{ 0x7C27U, 0xE2CEU },
{ 0x7C2AU, 0xE2CFU },{ 0x7C2BU, 0xE2D2U },{ 0x7C37U, 0xE2D1U },
{ 0x7C38U, 0x94F4U },{ 0x7C3DU, 0xE2D3U },{ 0x7C3EU, 0x97FAU },
{ 0x7C3FU, 0x95EBU },{ 0x7C40U, 0xE2D8U },{ 0x7C43U, 0xE2D5U },
{ 0x7C4CU, 0xE2D4U },{ 0x7C4DU, 0x90D0U },{ 0x7C4FU, 0xE2D7U },
{ 0x7C50U, 0xE2D9U },{ 0x7C54U, 0xE2D6U },{ 0x7C56U, 0xE2DDU },
{ 0x7C58U, 0xE2DAU },{ 0x7C5FU, 0xE2DBU },{ 0x7C60U, 0xE2C4U },
{ 0x7C64U, 0xE2DCU },{ 0x7C65U, 0xE2DEU },{ 0x7C6CU, 0xE2DFU },
{ 0x7C73U, 0x95C4U },{ 0x7C75U, 0xE2E0U },{ 0x7C7EU, 0x96E0U },
{ 0x7C81U, 0x8BCCU },{ 0x7C82U, 0x8C48U },{ 0x7C83U, 0xE2E1U },
{ 0x7C89U, 0x95B2U },{ 0x7C8BU, 0x9088U },{ 0x7C8DU, 0x96AEU },
{ 0x7C90U, 0xE2E2U },{ 0x7C92U, 0x97B1U },{ 0x7C95U, 0x9494U },
{ 0x7C97U, 0x9165U },{ 0x7C98U, 0x9453U },{ 0x7C9BU, 0x8F6CU },
{ 0x7C9FU, 0x88BEU },{ 0x7CA1U, 0xE2E7U },{ 0x7CA2U, 0xE2E5U },
{ 0x7CA4U, 0xE2E3U },{ 0x7CA5U, 0x8A9FU },{ 0x7CA7U, 0x8FCFU },
{ 0x7CA8U, 0xE2E8U },{ 0x7CABU, 0xE2E6U },{ 0x7CADU, 0xE2E4U },
{ 0x7CAEU, 0xE2ECU },{ 0x7CB1U, 0xE2EBU },{ 0x7CB2U, 0xE2EAU },
{ 0x7CB3U, 0xE2E9U },{ 0x7CB9U, 0xE2EDU },{ 0x7CBDU, 0xE2EEU },
{ 0x7CBEU, 0x90B8U },{ 0x7CC0U, 0xE2EFU },{ 0x7CC2U, 0xE2F1U },
{ 0x7CC5U, 0xE2F0U },{ 0x7CCAU, 0x8CD0U },{ 0x7CCEU, 0x9157U },
{ 0x7CD2U, 0xE2F3U },{ 0x7CD6U, 0x939CU },{ 0x7CD8U, 0xE2F2U },
{ 0x7CDCU, 0xE2F4U },{ 0x7CDEU, 0x95B3U },{ 0x7CDFU, 0x918CU },
{ 0x7CE0U, 0x8D66U },{ 0x7CE2U, 0xE2F5U },{ 0x7CE7U, 0x97C6U },
{ 0x7CEFU, 0xE2F7U },{ 0x7CF2U, 0xE2F8U },{ 0x7CF4U, 0xE2F9U },
{ 0x7CF6U, 0xE2FAU },{ 0x7CF8U, 0x8E85U },{ 0x7CFAU, 0xE2FBU },
{ 0x7CFBU, 0x8C6EU },{ 0x7CFEU, 0x8B8AU },{ 0x7D00U, 0x8B49U },
{ 0x7D02U, 0xE340U },{ 0x7D04U, 0x96F1U },{ 0x7D05U, 0x8D67U },
{ 0x7D06U, 0xE2FCU },{ 0x7D0AU, 0xE343U },{ 0x7D0BU, 0x96E4U },
{ 0x7D0DU, 0x945BU },{ 0x7D10U, 0x9552U },{ 0x7D14U, 0x8F83U },
{ 0x7D15U, 0xE342U },{ 0x7D17U, 0x8ED1U },{ 0x7D18U, 0x8D68U },
{ 0x7D19U, 0x8E86U },{ 0x7D1AU, 0x8B89U },{ 0x7D1BU, 0x95B4U },
{ 0x7D1CU, 0xE341U },{ 0x7D20U, 0x9166U },{ 0x7D21U, 0x9661U },
{ 0x7D22U, 0x8DF5U },{ 0x7D2BU, 0x8E87U },{ 0x7D2CU, 0x92DBU },
{ 0x7D2EU, 0xE346U },{ 0x7D2FU, 0x97DDU },{ 0x7D30U, 0x8DD7U },
{ 0x7D32U, 0xE347U },{ 0x7D33U, 0x9061U },{ 0x7D35U, 0xE349U },
{ 0x7D39U, 0x8FD0U },{ 0x7D3AU, 0x8DAEU },{ 0x7D3FU, 0xE348U },
{ 0x7D42U, 0x8F49U },{ 0x7D43U, 0x8CBCU },{ 0x7D44U, 0x9167U },
{ 0x7D45U, 0xE344U },{ 0x7D46U, 0xE34AU },{ 0x7D48U, 0xFB8AU },
{ 0x7D4BU, 0xE345U },{ 0x7D4CU, 0x8C6FU },{ 0x7D4EU, 0xE34DU },
{ 0x7D4FU, 0xE351U },{ 0x7D50U, 0x8C8BU },{ 0x7D56U, 0xE34CU },
{ 0x7D5BU, 0xE355U },{ 0x7D5CU, 0xFB8BU },{ 0x7D5EU, 0x8D69U },
{ 0x7D61U, 0x978DU },{ 0x7D62U, 0x88BAU },{ 0x7D63U, 0xE352U },
{ 0x7D66U, 0x8B8BU },{ 0x7D68U, 0xE34FU },{ 0x7D6EU, 0xE350U },
{ 0x7D71U, 0x939DU },{ 0x7D72U, 0xE34EU },{ 0x7D73U, 0xE34BU },
{ 0x7D75U, 0x8A47U },{ 0x7D76U, 0x90E2U },{ 0x7D79U, 0x8CA6U },
{ 0x7D7DU, 0xE357U },{ 0x7D89U, 0xE354U },{ 0x7D8FU, 0xE356U },
{ 0x7D93U, 0xE353U },{ 0x7D99U, 0x8C70U },{ 0x7D9AU, 0x91B1U },
{ 0x7D9BU, 0xE358U },{ 0x7D9CU, 0x918EU },{ 0x7D9FU, 0xE365U },
{ 0x7DA0U, 0xFB8DU },{ 0x7DA2U, 0xE361U },{ 0x7DA3U, 0xE35BU },
{ 0x7DABU, 0xE35FU },{ 0x7DACU, 0x8EF8U },{ 0x7DADU, 0x88DBU },
{ 0x7DAEU, 0xE35AU },{ 0x7DAFU, 0xE362U },{ 0x7DB0U, 0xE366U },
{ 0x7DB1U, 0x8D6AU },{ 0x7DB2U, 0x96D4U },{ 0x7DB4U, 0x92D4U },
{ 0x7DB5U, 0xE35CU },{ 0x7DB7U, 0xFB8CU },{ 0x7DB8U, 0xE364U },
{ 0x7DBAU, 0xE359U },{ 0x7DBBU, 0x925DU },{ 0x7DBDU, 0xE35EU },
{ 0x7DBEU, 0x88BBU },{ 0x7DBFU, 0x96C8U },{ 0x7DC7U, 0xE35DU },
{ 0x7DCAU, 0x8BD9U },{ 0x7DCBU, 0x94EAU },{ 0x7DCFU, 0x918DU },
{ 0x7DD1U, 0x97CEU },{ 0x7DD2U, 0x8F8FU },{ 0x7DD5U, 0xE38EU },
{ 0x7DD6U, 0xFB8EU },{ 0x7DD8U, 0xE367U },{ 0x7DDAU, 0x90FCU },
{ 0x7DDCU, 0xE363U },{ 0x7DDDU, 0xE368U },{ 0x7DDEU, 0xE36AU },
{ 0x7DE0U, 0x92F7U },{ 0x7DE1U, 0xE36DU },{ 0x7DE4U, 0xE369U },
{ 0x7DE8U, 0x95D2U },{ 0x7DE9U, 0x8AC9U },{ 0x7DECU, 0x96C9U },
{ 0x7DEFU, 0x88DCU },{ 0x7DF2U, 0xE36CU },{ 0x7DF4U, 0x97FBU },
{ 0x7DFBU, 0xE36BU },{ 0x7E01U, 0x898FU },{ 0x7E04U, 0x93EAU },
{ 0x7E05U, 0xE36EU },{ 0x7E09U, 0xE375U },{ 0x7E0AU, 0xE36FU },
{ 0x7E0BU, 0xE376U },{ 0x7E12U, 0xE372U },{ 0x7E1BU, 0x949BU },
{ 0x7E1EU, 0x8EC8U },{ 0x7E1FU, 0xE374U },{ 0x7E21U, 0xE371U },
{ 0x7E22U, 0xE377U },{ 0x7E23U, 0xE370U },{ 0x7E26U, 0x8F63U },
{ 0x7E2BU, 0x9644U },{ 0x7E2EU, 0x8F6BU },{ 0x7E31U, 0xE373U },
{ 0x7E32U, 0xE380U },{ 0x7E35U, 0xE37BU },{ 0x7E37U, 0xE37EU },
{ 0x7E39U, 0xE37CU },{ 0x7E3AU, 0xE381U },{ 0x7E3BU, 0xE37AU },
{ 0x7E3DU, 0xE360U },{ 0x7E3EU, 0x90D1U },{ 0x7E41U, 0x94C9U },
{ 0x7E43U, 0xE37DU },{ 0x7E46U, 0xE378U },{ 0x7E4AU, 0x9140U },
{ 0x7E4BU, 0x8C71U },{ 0x7E4DU, 0x8F4AU },{ 0x7E52U, 0xFB8FU },
{ 0x7E54U, 0x9044U },{ 0x7E55U, 0x9155U },{ 0x7E56U, 0xE384U },
{ 0x7E59U, 0xE386U },{ 0x7E5AU, 0xE387U },{ 0x7E5DU, 0xE383U },
{ 0x7E5EU, 0xE385U },{ 0x7E66U, 0xE379U },{ 0x7E67U, 0xE382U },
{ 0x7E69U, 0xE38AU },{ 0x7E6AU, 0xE389U },{ 0x7E6DU, 0x969AU },
{ 0x7E70U, 0x8C4AU },{ 0x7E79U, 0xE388U },{ 0x7E7BU, 0xE38CU },
{ 0x7E7CU, 0xE38BU },{ 0x7E7DU, 0xE38FU },{ 0x7E7FU, 0xE391U },
{ 0x7E82U, 0x8E5BU },{ 0x7E83U, 0xE38DU },{ 0x7E88U, 0xE392U },
{ 0x7E89U, 0xE393U },{ 0x7E8AU, 0xFA5CU },{ 0x7E8CU, 0xE394U },
{ 0x7E8EU, 0xE39AU },{ 0x7E8FU, 0x935AU },{ 0x7E90U, 0xE396U },
{ 0x7E92U, 0xE395U },{ 0x7E93U, 0xE397U },{ 0x7E94U, 0xE398U },
{ 0x7E96U, 0xE399U },{ 0x7E9BU, 0xE39BU },{ 0x7E9CU, 0xE39CU },
{ 0x7F36U, 0x8ACAU },{ 0x7F38U, 0xE39DU },{ 0x7F3AU, 0xE39EU },
{ 0x7F45U, 0xE39FU },{ 0x7F47U, 0xFB90U },{ 0x7F4CU, 0xE3A0U },
{ 0x7F4DU, 0xE3A1U },{ 0x7F4EU, 0xE3A2U },{ 0x7F50U, 0xE3A3U },
{ 0x7F51U, 0xE3A4U },{ 0x7F54U, 0xE3A6U },{ 0x7F55U, 0xE3A5U },
{ 0x7F58U, 0xE3A7U },{ 0x7F5FU, 0xE3A8U },{ 0x7F60U, 0xE3A9U },
{ 0x7F67U, 0xE3ACU },{ 0x7F68U, 0xE3AAU },{ 0x7F69U, 0xE3ABU },
{ 0x7F6AU, 0x8DDFU },{ 0x7F6BU, 0x8C72U },{ 0x7F6EU, 0x9275U },
{ 0x7F70U, 0x94B1U },{ 0x7F72U, 0x8F90U },{ 0x7F75U, 0x946CU },
{ 0x7F77U, 0x94EBU },{ 0x7F78U, 0xE3ADU },{ 0x7F79U, 0x9CEBU },
{ 0x7F82U, 0xE3AEU },{ 0x7F83U, 0xE3B0U },{ 0x7F85U, 0x9785U },
{ 0x7F86U, 0xE3AFU },{ 0x7F87U, 0xE3B2U },{ 0x7F88U, 0xE3B1U },
{ 0x7F8AU, 0x9772U },{ 0x7F8CU, 0xE3B3U },{ 0x7F8EU, 0x94FCU },
{ 0x7F94U, 0xE3B4U },{ 0x7F9AU, 0xE3B7U },{ 0x7F9DU, 0xE3B6U },
{ 0x7F9EU, 0xE3B5U },{ 0x7FA1U, 0xFB91U },{ 0x7FA3U, 0xE3B8U },
{ 0x7FA4U, 0x8C51U },{ 0x7FA8U, 0x9141U },{ 0x7FA9U, 0x8B60U },
{ 0x7FAEU, 0xE3BCU },{ 0x7FAFU, 0xE3B9U },{ 0x7FB2U, 0xE3BAU },
{ 0x7FB6U, 0xE3BDU },{ 0x7FB8U, 0xE3BEU },{ 0x7FB9U, 0xE3BBU },
{ 0x7FBDU, 0x8948U },{ 0x7FC1U, 0x89A5U },{ 0x7FC5U, 0xE3C0U },
{ 0x7FC6U, 0xE3C1U },{ 0x7FCAU, 0xE3C2U },{ 0x7FCCU, 0x9782U },
{ 0x7FD2U, 0x8F4BU },{ 0x7FD4U, 0xE3C4U },{ 0x7FD5U, 0xE3C3U },
{ 0x7FE0U, 0x9089U },{ 0x7FE1U, 0xE3C5U },{ 0x7FE6U, 0xE3C6U },
{ 0x7FE9U, 0xE3C7U },{ 0x7FEBU, 0x8AE3U },{ 0x7FF0U, 0x8ACBU },
{ 0x7FF3U, 0xE3C8U },{ 0x7FF9U, 0xE3C9U },{ 0x7FFBU, 0x967CU },
{ 0x7FFCU, 0x9783U },{ 0x8000U, 0x9773U },{ 0x8001U, 0x9856U },
{ 0x8003U, 0x8D6CU },{ 0x8004U, 0xE3CCU },{ 0x8005U, 0x8ED2U },
{ 0x8006U, 0xE3CBU },{ 0x800BU, 0xE3CDU },{ 0x800CU, 0x8EA7U },
{ 0x8010U, 0x91CFU },{ 0x8012U, 0xE3CEU },{ 0x8015U, 0x8D6BU },
{ 0x8017U, 0x96D5U },{ 0x8018U, 0xE3CFU },{ 0x8019U, 0xE3D0U },
{ 0x801CU, 0xE3D1U },{ 0x8021U, 0xE3D2U },{ 0x8028U, 0xE3D3U },
{ 0x8033U, 0x8EA8U },{ 0x8036U, 0x96EBU },{ 0x803BU, 0xE3D5U },
{ 0x803DU, 0x925EU },{ 0x803FU, 0xE3D4U },{ 0x8046U, 0xE3D7U },
{ 0x804AU, 0xE3D6U },{ 0x8052U, 0xE3D8U },{ 0x8056U, 0x90B9U },
{ 0x8058U, 0xE3D9U },{ 0x805AU, 0xE3DAU },{ 0x805EU, 0x95B7U },
{ 0x805FU, 0xE3DBU },{ 0x8061U, 0x918FU },{ 0x8062U, 0xE3DCU },
{ 0x8068U, 0xE3DDU },{ 0x806FU, 0x97FCU },{ 0x8070U, 0xE3E0U },
{ 0x8072U, 0xE3DFU },{ 0x8073U, 0xE3DEU },{ 0x8074U, 0x92AEU },
{ 0x8076U, 0xE3E1U },{ 0x8077U, 0x9045U },{ 0x8079U, 0xE3E2U },
{ 0x807DU, 0xE3E3U },{ 0x807EU, 0x9857U },{ 0x807FU, 0xE3E4U },
{ 0x8084U, 0xE3E5U },{ 0x8085U, 0xE3E7U },{ 0x8086U, 0xE3E6U },
{ 0x8087U, 0x94A3U },{ 0x8089U, 0x93F7U },{ 0x808BU, 0x985DU },
{ 0x808CU, 0x94A7U },{ 0x8093U, 0xE3E9U },{ 0x8096U, 0x8FD1U },
{ 0x8098U, 0x9549U },{ 0x809AU, 0xE3EAU },{ 0x809BU, 0xE3E8U },
{ 0x809DU, 0x8ACCU },{ 0x80A1U, 0x8CD2U },{ 0x80A2U, 0x8E88U },
{ 0x80A5U, 0x94ECU },{ 0x80A9U, 0x8CA8U },{ 0x80AAU, 0x9662U },
{ 0x80ACU, 0xE3EDU },{ 0x80ADU, 0xE3EBU },{ 0x80AFU, 0x8D6DU },
{ 0x80B1U, 0x8D6EU },{ 0x80B2U, 0x88E7U },{ 0x80B4U, 0x8DE6U },
{ 0x80BAU, 0x9478U },{ 0x80C3U, 0x88DDU },{ 0x80C4U, 0xE3F2U },
{ 0x80C6U, 0x925FU },{ 0x80CCU, 0x9477U },{ 0x80CEU, 0x91D9U },
{ 0x80D6U, 0xE3F4U },{ 0x80D9U, 0xE3F0U },{ 0x80DAU, 0xE3F3U },
{ 0x80DBU, 0xE3EEU },{ 0x80DDU, 0xE3F1U },{ 0x80DEU, 0x9645U },
{ 0x80E1U, 0x8CD3U },{ 0x80E4U, 0x88FBU },{ 0x80E5U, 0xE3EFU },
{ 0x80EFU, 0xE3F6U },{ 0x80F1U, 0xE3F7U },{ 0x80F4U, 0x93B7U },
{ 0x80F8U, 0x8BB9U },{ 0x80FCU, 0xE445U },{ 0x80FDU, 0x945CU },
{ 0x8102U, 0x8E89U },{ 0x8105U, 0x8BBAU },{ 0x8106U, 0x90C6U },
{ 0x8107U, 0x9865U },{ 0x8108U, 0x96ACU },{ 0x8109U, 0xE3F5U },
{ 0x810AU, 0x90D2U },{ 0x811AU, 0x8B72U },{ 0x811BU, 0xE3F8U },
{ 0x8123U, 0xE3FAU },{ 0x8129U, 0xE3F9U },{ 0x812FU, 0xE3FBU },
{ 0x8131U, 0x9245U },{ 0x8133U, 0x945DU },{ 0x8139U, 0x92AFU },
{ 0x813EU, 0xE442U },{ 0x8146U, 0xE441U },{ 0x814BU, 0xE3FCU },
{ 0x814EU, 0x9074U },{ 0x8150U, 0x9585U },{ 0x8151U, 0xE444U },
{ 0x8153U, 0xE443U },{ 0x8154U, 0x8D6FU },{ 0x8155U, 0x9872U },
{ 0x815FU, 0xE454U },{ 0x8165U, 0xE448U },{ 0x8166U, 0xE449U },
{ 0x816BU, 0x8EEEU },{ 0x816EU, 0xE447U },{ 0x8170U, 0x8D98U },
{ 0x8171U, 0xE446U },{ 0x8174U, 0xE44AU },{ 0x8178U, 0x92B0U },
{ 0x8179U, 0x95A0U },{ 0x817AU, 0x9142U },{ 0x817FU, 0x91DAU },
{ 0x8180U, 0xE44EU },{ 0x8182U, 0xE44FU },{ 0x8183U, 0xE44BU },
{ 0x8188U, 0xE44CU },{ 0x818AU, 0xE44DU },{ 0x818FU, 0x8D70U },
{ 0x8193U, 0xE455U },{ 0x8195U, 0xE451U },{ 0x819AU, 0x9586U },
{ 0x819CU, 0x968CU },{ 0x819DU, 0x9547U },{ 0x81A0U, 0xE450U },
{ 0x81A3U, 0xE453U },{ 0x81A4U, 0xE452U },{ 0x81A8U, 0x9663U },
{ 0x81A9U, 0xE456U },{ 0x81B0U, 0xE457U },{ 0x81B3U, 0x9156U },
{ 0x81B5U, 0xE458U },{ 0x81B8U, 0xE45AU },{ 0x81BAU, 0xE45EU },
{ 0x81BDU, 0xE45BU },{ 0x81BEU, 0xE459U },{ 0x81BFU, 0x945EU },
{ 0x81C0U, 0xE45CU },{ 0x81C2U, 0xE45DU },{ 0x81C6U, 0x89B0U },
{ 0x81C8U, 0xE464U },{ 0x81C9U, 0xE45FU },{ 0x81CDU, 0xE460U },
{ 0x81D1U, 0xE461U },{ 0x81D3U, 0x919FU },{ 0x81D8U, 0xE463U },
{ 0x81D9U, 0xE462U },{ 0x81DAU, 0xE465U },{ 0x81DFU, 0xE466U },
{ 0x81E0U, 0xE467U },{ 0x81E3U, 0x9062U },{ 0x81E5U, 0x89E7U },
{ 0x81E7U, 0xE468U },{ 0x81E8U, 0x97D5U },{ 0x81EAU, 0x8EA9U },
{ 0x81EDU, 0x8F4CU },{ 0x81F3U, 0x8E8AU },{ 0x81F4U, 0x9276U },
{ 0x81FAU, 0xE469U },{ 0x81FBU, 0xE46AU },{ 0x81FCU, 0x8950U },
{ 0x81FEU, 0xE46BU },{ 0x8201U, 0xE46CU },{ 0x8202U, 0xE46DU },
{ 0x8205U, 0xE46EU },{ 0x8207U, 0xE46FU },{ 0x8208U, 0x8BBBU },
{ 0x8209U, 0x9DA8U },{ 0x820AU, 0xE470U },{ 0x820CU, 0x90E3U },
{ 0x820DU, 0xE471U },{ 0x820EU, 0x8EC9U },{ 0x8210U, 0xE472U },
{ 0x8212U, 0x98AEU },{ 0x8216U, 0xE473U },{ 0x8217U, 0x95DCU },
{ 0x8218U, 0x8ADAU },{ 0x821BU, 0x9143U },{ 0x821CU, 0x8F77U },
{ 0x821EU, 0x9591U },{ 0x821FU, 0x8F4DU },{ 0x8229U, 0xE474U },
{ 0x822AU, 0x8D71U },{ 0x822BU, 0xE475U },{ 0x822CU, 0x94CAU },
{ 0x822EU, 0xE484U },{ 0x8233U, 0xE477U },{ 0x8235U, 0x91C7U },
{ 0x8236U, 0x9495U },{ 0x8237U, 0x8CBDU },{ 0x8238U, 0xE476U },
{ 0x8239U, 0x9144U },{ 0x8240U, 0xE478U },{ 0x8247U, 0x92F8U },
{ 0x8258U, 0xE47AU },{ 0x8259U, 0xE479U },{ 0x825AU, 0xE47CU },
{ 0x825DU, 0xE47BU },{ 0x825FU, 0xE47DU },{ 0x8262U, 0xE480U },
{ 0x8264U, 0xE47EU },{ 0x8266U, 0x8ACDU },{ 0x8268U, 0xE481U },
{ 0x826AU, 0xE482U },{ 0x826BU, 0xE483U },{ 0x826EU, 0x8DAFU },
{ 0x826FU, 0x97C7U },{ 0x8271U, 0xE485U },{ 0x8272U, 0x9046U },
{ 0x8276U, 0x8990U },{ 0x8277U, 0xE486U },{ 0x8278U, 0xE487U },
{ 0x827EU, 0xE488U },{ 0x828BU, 0x88F0U },{ 0x828DU, 0xE489U },
{ 0x8292U, 0xE48AU },{ 0x8299U, 0x9587U },{ 0x829DU, 0x8EC5U },
{ 0x829FU, 0xE48CU },{ 0x82A5U, 0x8A48U },{ 0x82A6U, 0x88B0U },
{ 0x82ABU, 0xE48BU },{ 0x82ACU, 0xE48EU },{ 0x82ADU, 0x946DU },
{ 0x82AFU, 0x9063U },{ 0x82B1U, 0x89D4U },{ 0x82B3U, 0x9646U },
{ 0x82B8U, 0x8C7CU },{ 0x82B9U, 0x8BDAU },{ 0x82BBU, 0xE48DU },
{ 0x82BDU, 0x89E8U },{ 0x82C5U, 0x8AA1U },{ 0x82D1U, 0x8991U },
{ 0x82D2U, 0xE492U },{ 0x82D3U, 0x97E8U },{ 0x82D4U, 0x91DBU },
{ 0x82D7U, 0x9563U },{ 0x82D9U, 0xE49EU },{ 0x82DBU, 0x89D5U },
{ 0x82DCU, 0xE49CU },{ 0x82DEU, 0xE49AU },{ 0x82DFU, 0xE491U },
{ 0x82E1U, 0xE48FU },{ 0x82E3U, 0xE490U },{ 0x82E5U, 0x8EE1U },
{ 0x82E6U, 0x8BEAU },{ 0x82E7U, 0x9297U },{ 0x82EBU, 0x93CFU },
{ 0x82F1U, 0x8970U },{ 0x82F3U, 0xE494U },{ 0x82F4U, 0xE493U },
{ 0x82F9U, 0xE499U },{ 0x82FAU, 0xE495U },{ 0x82FBU, 0xE498U },
{ 0x8301U, 0xFB93U },{ 0x8302U, 0x96CEU },{ 0x8303U, 0xE497U },
{ 0x8304U, 0x89D6U },{ 0x8305U, 0x8A9DU },{ 0x8306U, 0xE49BU },
{ 0x8309U, 0xE49DU },{ 0x830EU, 0x8C73U },{ 0x8316U, 0xE4A1U },
{ 0x8317U, 0xE4AAU },{ 0x8318U, 0xE4ABU },{ 0x831CU, 0x88A9U },
{ 0x8323U, 0xE4B2U },{ 0x8328U, 0x88EFU },{ 0x832BU, 0xE4A9U },
{ 0x832FU, 0xE4A8U },{ 0x8331U, 0xE4A3U },{ 0x8332U, 0xE4A2U },
{ 0x8334U, 0xE4A0U },{ 0x8335U, 0xE49FU },{ 0x8336U, 0x9283U },
{ 0x8338U, 0x91F9U },{ 0x8339U, 0xE4A5U },{ 0x8340U, 0xE4A4U },
{ 0x8345U, 0xE4A7U },{ 0x8349U, 0x9190U },{ 0x834AU, 0x8C74U },
{ 0x834FU, 0x8960U },{ 0x8350U, 0xE4A6U },{ 0x8352U, 0x8D72U },
{ 0x8358U, 0x9191U },{ 0x8362U, 0xFB94U },{ 0x8373U, 0xE4B8U },
{ 0x8375U, 0xE4B9U },{ 0x8377U, 0x89D7U },{ 0x837BU, 0x89ACU },
{ 0x837CU, 0xE4B6U },{ 0x837FU, 0xFB95U },{ 0x8385U, 0xE4ACU },
{ 0x8387U, 0xE4B4U },{ 0x8389U, 0xE4BBU },{ 0x838AU, 0xE4B5U },
{ 0x838EU, 0xE4B3U },{ 0x8393U, 0xE496U },{ 0x8396U, 0xE4B1U },
{ 0x839AU, 0xE4ADU },{ 0x839EU, 0x8ACEU },{ 0x839FU, 0xE4AFU },
{ 0x83A0U, 0xE4BAU },{ 0x83A2U, 0xE4B0U },{ 0x83A8U, 0xE4BCU },
{ 0x83AAU, 0xE4AEU },{ 0x83ABU, 0x949CU },{ 0x83B1U, 0x9789U },
{ 0x83B5U, 0xE4B7U },{ 0x83BDU, 0xE4CDU },{ 0x83C1U, 0xE4C5U },
{ 0x83C5U, 0x909BU },{ 0x83C7U, 0xFB96U },{ 0x83CAU, 0x8B65U },
{ 0x83CCU, 0x8BDBU },{ 0x83CEU, 0xE4C0U },{ 0x83D3U, 0x89D9U },
{ 0x83D6U, 0x8FD2U },{ 0x83D8U, 0xE4C3U },{ 0x83DCU, 0x8DD8U },
{ 0x83DFU, 0x9370U },{ 0x83E0U, 0xE4C8U },{ 0x83E9U, 0x95ECU },
{ 0x83EBU, 0xE4BFU },{ 0x83EFU, 0x89D8U },{ 0x83F0U, 0x8CD4U },
{ 0x83F1U, 0x9548U },{ 0x83F2U, 0xE4C9U },{ 0x83F4U, 0xE4BDU },
{ 0x83F6U, 0xFB97U },{ 0x83F7U, 0xE4C6U },{ 0x83FBU, 0xE4D0U },
{ 0x83FDU, 0xE4C1U },{ 0x8403U, 0xE4C2U },{ 0x8404U, 0x93B8U },
{ 0x8407U, 0xE4C7U },{ 0x840BU, 0xE4C4U },{ 0x840CU, 0x9647U },
{ 0x840DU, 0xE4CAU },{ 0x840EU, 0x88DEU },{ 0x8413U, 0xE4BEU },
{ 0x8420U, 0xE4CCU },{ 0x8422U, 0xE4CBU },{ 0x8429U, 0x948BU },
{ 0x842AU, 0xE4D2U },{ 0x842CU, 0xE4DDU },{ 0x8431U, 0x8A9EU },
{ 0x8435U, 0xE4E0U },{ 0x8438U, 0xE4CEU },{ 0x843CU, 0xE4D3U },
{ 0x843DU, 0x978EU },{ 0x8446U, 0xE4DCU },{ 0x8448U, 0xFB98U },
{ 0x8449U, 0x9774U },{ 0x844EU, 0x97A8U },{ 0x8457U, 0x9298U },
{ 0x845BU, 0x8A8BU },{ 0x8461U, 0x9592U },{ 0x8462U, 0xE4E2U },
{ 0x8463U, 0x939FU },{ 0x8466U, 0x88AFU },{ 0x8469U, 0xE4DBU },
{ 0x846BU, 0xE4D7U },{ 0x846CU, 0x9192U },{ 0x846DU, 0xE4D1U },
{ 0x846EU, 0xE4D9U },{ 0x846FU, 0xE4DEU },{ 0x8471U, 0x944BU },
{ 0x8475U, 0x88A8U },{ 0x8477U, 0xE4D6U },{ 0x8479U, 0xE4DFU },
{ 0x847AU, 0x9598U },{ 0x8482U, 0xE4DAU },{ 0x8484U, 0xE4D5U },
{ 0x848BU, 0x8FD3U },{ 0x8490U, 0x8F4EU },{ 0x8494U, 0x8EAAU },
{ 0x8499U, 0x96D6U },{ 0x849CU, 0x9566U },{ 0x849FU, 0xE4E5U },
{ 0x84A1U, 0xE4EEU },{ 0x84ADU, 0xE4D8U },{ 0x84B2U, 0x8A97U },
{ 0x84B4U, 0xFB99U },{ 0x84B8U, 0x8FF6U },{ 0x84B9U, 0xE4E3U },
{ 0x84BBU, 0xE4E8U },{ 0x84BCU, 0x9193U },{ 0x84BFU, 0xE4E4U },
{ 0x84C1U, 0xE4EBU },{ 0x84C4U, 0x927EU },{ 0x84C6U, 0xE4ECU },
{ 0x84C9U, 0x9775U },{ 0x84CAU, 0xE4E1U },{ 0x84CBU, 0x8A57U },
{ 0x84CDU, 0xE4E7U },{ 0x84D0U, 0xE4EAU },{ 0x84D1U, 0x96AAU },
{ 0x84D6U, 0xE4EDU },{ 0x84D9U, 0xE4E6U },{ 0x84DAU, 0xE4E9U },
{ 0x84DCU, 0xFA60U },{ 0x84ECU, 0x9648U },{ 0x84EEU, 0x9840U },
{ 0x84F4U, 0xE4F1U },{ 0x84FCU, 0xE4F8U },{ 0x84FFU, 0xE4F0U },
{ 0x8500U, 0x8EC1U },{ 0x8506U, 0xE4CFU },{ 0x8511U, 0x95CCU },
{ 0x8513U, 0x96A0U },{ 0x8514U, 0xE4F7U },{ 0x8515U, 0xE4F6U },
{ 0x8517U, 0xE4F2U },{ 0x8518U, 0xE4F3U },{ 0x851AU, 0x8955U },
{ 0x851FU, 0xE4F5U },{ 0x8521U, 0xE4EFU },{ 0x8526U, 0x92D3U },
{ 0x852CU, 0xE4F4U },{ 0x852DU, 0x88FCU },{ 0x8535U, 0x91A0U },
{ 0x853DU, 0x95C1U },{ 0x8540U, 0xE4F9U },{ 0x8541U, 0xE540U },
{ 0x8543U, 0x94D7U },{ 0x8548U, 0xE4FCU },{ 0x8549U, 0x8FD4U },
{ 0x854AU, 0x8EC7U },{ 0x854BU, 0xE542U },{ 0x854EU, 0x8BBCU },
{ 0x8553U, 0xFB9AU },{ 0x8555U, 0xE543U },{ 0x8557U, 0x9599U },
{ 0x8558U, 0xE4FBU },{ 0x8559U, 0xFB9BU },{ 0x855AU, 0xE4D4U },
{ 0x8563U, 0xE4FAU },{ 0x8568U, 0x986EU },{ 0x8569U, 0x93A0U },
{ 0x856AU, 0x9593U },{ 0x856BU, 0xFB9CU },{ 0x856DU, 0xE54AU },
{ 0x8577U, 0xE550U },{ 0x857EU, 0xE551U },{ 0x8580U, 0xE544U },
{ 0x8584U, 0x9496U },{ 0x8587U, 0xE54EU },{ 0x8588U, 0xE546U },
{ 0x858AU, 0xE548U },{ 0x8590U, 0xE552U },{ 0x8591U, 0xE547U },
{ 0x8594U, 0xE54BU },{ 0x8597U, 0x8992U },{ 0x8599U, 0x93E3U },
{ 0x859BU, 0xE54CU },{ 0x859CU, 0xE54FU },{ 0x85A4U, 0xE545U },
{ 0x85A6U, 0x9145U },{ 0x85A8U, 0xE549U },{ 0x85A9U, 0x8E46U },
{ 0x85AAU, 0x9064U },{ 0x85ABU, 0x8C4FU },{ 0x85ACU, 0x96F2U },
{ 0x85AEU, 0x96F7U },{ 0x85AFU, 0x8F92U },{ 0x85B0U, 0xFB9EU },
{ 0x85B9U, 0xE556U },{ 0x85BAU, 0xE554U },{ 0x85C1U, 0x986DU },
{ 0x85C9U, 0xE553U },{ 0x85CDU, 0x9795U },{ 0x85CFU, 0xE555U },
{ 0x85D0U, 0xE557U },{ 0x85D5U, 0xE558U },{ 0x85DCU, 0xE55BU },
{ 0x85DDU, 0xE559U },{ 0x85E4U, 0x93A1U },{ 0x85E5U, 0xE55AU },
{ 0x85E9U, 0x94CBU },{ 0x85EAU, 0xE54DU },{ 0x85F7U, 0x8F93U },
{ 0x85F9U, 0xE55CU },{ 0x85FAU, 0xE561U },{ 0x85FBU, 0x9194U },
{ 0x85FEU, 0xE560U },{ 0x8602U, 0xE541U },{ 0x8606U, 0xE562U },
{ 0x8607U, 0x9168U },{ 0x860AU, 0xE55DU },{ 0x860BU, 0xE55FU },
{ 0x8613U, 0xE55EU },{ 0x8616U, 0x9F50U },{ 0x8617U, 0x9F41U },
{ 0x861AU, 0xE564U },{ 0x8622U, 0xE563U },{ 0x862DU, 0x9796U },
{ 0x862FU, 0xE1BAU },{ 0x8630U, 0xE565U },{ 0x863FU, 0xE566U },
{ 0x864DU, 0xE567U },{ 0x864EU, 0x8CD5U },{ 0x8650U, 0x8B73U },
{ 0x8654U, 0xE569U },{ 0x8655U, 0x997CU },{ 0x865AU, 0x8B95U },
{ 0x865CU, 0x97B8U },{ 0x865EU, 0x8BF1U },{ 0x865FU, 0xE56AU },
{ 0x8667U, 0xE56BU },{ 0x866BU, 0x928EU },{ 0x8671U, 0xE56CU },
{ 0x8679U, 0x93F8U },{ 0x867BU, 0x88B8U },{ 0x868AU, 0x89E1U },
{ 0x868BU, 0xE571U },{ 0x868CU, 0xE572U },{ 0x8693U, 0xE56DU },
{ 0x8695U, 0x8E5CU },{ 0x86A3U, 0xE56EU },{ 0x86A4U, 0x9461U },
{ 0x86A9U, 0xE56FU },{ 0x86AAU, 0xE570U },{ 0x86ABU, 0xE57AU },
{ 0x86AFU, 0xE574U },{ 0x86B0U, 0xE577U },{ 0x86B6U, 0xE573U },
{ 0x86C4U, 0xE575U },{ 0x86C6U, 0xE576U },{ 0x86C7U, 0x8ED6U },
{ 0x86C9U, 0xE578U },{ 0x86CBU, 0x9260U },{ 0x86CDU, 0x8C75U },
{ 0x86CEU, 0x8A61U },{ 0x86D4U, 0xE57BU },{ 0x86D9U, 0x8A5EU },
{ 0x86DBU, 0xE581U },{ 0x86DEU, 0xE57CU },{ 0x86DFU, 0xE580U },
{ 0x86E4U, 0x94B8U },{ 0x86E9U, 0xE57DU },{ 0x86ECU, 0xE57EU },
{ 0x86EDU, 0x9567U },{ 0x86EEU, 0x94D8U },{ 0x86EFU, 0xE582U },
{ 0x86F8U, 0x91FBU },{ 0x86F9U, 0xE58CU },{ 0x86FBU, 0xE588U },
{ 0x86FEU, 0x89E9U },{ 0x8700U, 0xE586U },{ 0x8702U, 0x9649U },
{ 0x8703U, 0xE587U },{ 0x8706U, 0xE584U },{ 0x8708U, 0xE585U },
{ 0x8709U, 0xE58AU },{ 0x870AU, 0xE58DU },{ 0x870DU, 0xE58BU },
{ 0x8711U, 0xE589U },{ 0x8712U, 0xE583U },{ 0x8718U, 0x9277U },
{ 0x871AU, 0xE594U },{ 0x871CU, 0x96A8U },{ 0x8725U, 0xE592U },
{ 0x8729U, 0xE593U },{ 0x8734U, 0xE58EU },{ 0x8737U, 0xE590U },
{ 0x873BU, 0xE591U },{ 0x873FU, 0xE58FU },{ 0x8749U, 0x90E4U },
{ 0x874BU, 0x9858U },{ 0x874CU, 0xE598U },{ 0x874EU, 0xE599U },
{ 0x8753U, 0xE59FU },{ 0x8755U, 0x9049U },{ 0x8757U, 0xE59BU },
{ 0x8759U, 0xE59EU },{ 0x875FU, 0xE596U },{ 0x8760U, 0xE595U },
{ 0x8763U, 0xE5A0U },{ 0x8766U, 0x89DAU },{ 0x8768U, 0xE59CU },
{ 0x876AU, 0xE5A1U },{ 0x876EU, 0xE59DU },{ 0x8774U, 0xE59AU },
{ 0x8776U, 0x92B1U },{ 0x8778U, 0xE597U },{ 0x877FU, 0x9488U },
{ 0x8782U, 0xE5A5U },{ 0x878DU, 0x975AU },{ 0x879FU, 0xE5A4U },
{ 0x87A2U, 0xE5A3U },{ 0x87ABU, 0xE5ACU },{ 0x87AFU, 0xE5A6U },
{ 0x87B3U, 0xE5AEU },{ 0x87BAU, 0x9786U },{ 0x87BBU, 0xE5B1U },
{ 0x87BDU, 0xE5A8U },{ 0x87C0U, 0xE5A9U },{ 0x87C4U, 0xE5ADU },
{ 0x87C6U, 0xE5B0U },{ 0x87C7U, 0xE5AFU },{ 0x87CBU, 0xE5A7U },
{ 0x87D0U, 0xE5AAU },{ 0x87D2U, 0xE5BBU },{ 0x87E0U, 0xE5B4U },
{ 0x87EFU, 0xE5B2U },{ 0x87F2U, 0xE5B3U },{ 0x87F6U, 0xE5B8U },
{ 0x87F7U, 0xE5B9U },{ 0x87F9U, 0x8A49U },{ 0x87FBU, 0x8B61U },
{ 0x87FEU, 0xE5B7U },{ 0x8805U, 0xE5A2U },{ 0x8807U, 0xFBA1U },
{ 0x880DU, 0xE5B6U },{ 0x880EU, 0xE5BAU },{ 0x880FU, 0xE5B5U },
{ 0x8811U, 0xE5BCU },{ 0x8815U, 0xE5BEU },{ 0x8816U, 0xE5BDU },
{ 0x8821U, 0xE5C0U },{ 0x8822U, 0xE5BFU },{ 0x8823U, 0xE579U },
{ 0x8827U, 0xE5C4U },{ 0x8831U, 0xE5C1U },{ 0x8836U, 0xE5C2U },
{ 0x8839U, 0xE5C3U },{ 0x883BU, 0xE5C5U },{ 0x8840U, 0x8C8CU },
{ 0x8842U, 0xE5C7U },{ 0x8844U, 0xE5C6U },{ 0x8846U, 0x8F4FU },
{ 0x884CU, 0x8D73U },{ 0x884DU, 0x9FA5U },{ 0x8852U, 0xE5C8U },
{ 0x8853U, 0x8F70U },{ 0x8857U, 0x8A58U },{ 0x8859U, 0xE5C9U },
{ 0x885BU, 0x8971U },{ 0x885DU, 0x8FD5U },{ 0x885EU, 0xE5CAU },
{ 0x8861U, 0x8D74U },{ 0x8862U, 0xE5CBU },{ 0x8863U, 0x88DFU },
{ 0x8868U, 0x955CU },{ 0x886BU, 0xE5CCU },{ 0x8870U, 0x908AU },
{ 0x8872U, 0xE5D3U },{ 0x8875U, 0xE5D0U },{ 0x8877U, 0x928FU },
{ 0x887DU, 0xE5D1U },{ 0x887EU, 0xE5CEU },{ 0x887FU, 0x8BDCU },
{ 0x8881U, 0xE5CDU },{ 0x8882U, 0xE5D4U },{ 0x8888U, 0x8C55U },
{ 0x888BU, 0x91DCU },{ 0x888DU, 0xE5DAU },{ 0x8892U, 0xE5D6U },
{ 0x8896U, 0x91B3U },{ 0x8897U, 0xE5D5U },{ 0x8899U, 0xE5D8U },
{ 0x889EU, 0xE5CFU },{ 0x88A2U, 0xE5D9U },{ 0x88A4U, 0xE5DBU },
{ 0x88ABU, 0x94EDU },{ 0x88AEU, 0xE5D7U },{ 0x88B0U, 0xE5DCU },
{ 0x88B1U, 0xE5DEU },{ 0x88B4U, 0x8CD1U },{ 0x88B5U, 0xE5D2U },
{ 0x88B7U, 0x88BFU },{ 0x88BFU, 0xE5DDU },{ 0x88C1U, 0x8DD9U },
{ 0x88C2U, 0x97F4U },{ 0x88C3U, 0xE5DFU },{ 0x88C4U, 0xE5E0U },
{ 0x88C5U, 0x9195U },{ 0x88CFU, 0x97A0U },{ 0x88D4U, 0xE5E1U },
{ 0x88D5U, 0x9754U },{ 0x88D8U, 0xE5E2U },{ 0x88D9U, 0xE5E3U },
{ 0x88DCU, 0x95E2U },{ 0x88DDU, 0xE5E4U },{ 0x88DFU, 0x8DBEU },
{ 0x88E1U, 0x97A1U },{ 0x88E8U, 0xE5E9U },{ 0x88F2U, 0xE5EAU },
{ 0x88F3U, 0x8FD6U },{ 0x88F4U, 0xE5E8U },{ 0x88F5U, 0xFBA2U },
{ 0x88F8U, 0x9787U },{ 0x88F9U, 0xE5E5U },{ 0x88FCU, 0xE5E7U },
{ 0x88FDU, 0x90BBU },{ 0x88FEU, 0x909EU },{ 0x8902U, 0xE5E6U },
{ 0x8904U, 0xE5EBU },{ 0x8907U, 0x95A1U },{ 0x890AU, 0xE5EDU },
{ 0x890CU, 0xE5ECU },{ 0x8910U, 0x8A8CU },{ 0x8912U, 0x964AU },
{ 0x8913U, 0xE5EEU },{ 0x891CU, 0xFA5DU },{ 0x891DU, 0xE5FAU },
{ 0x891EU, 0xE5F0U },{ 0x8925U, 0xE5F1U },{ 0x892AU, 0xE5F2U },
{ 0x892BU, 0xE5F3U },{ 0x8936U, 0xE5F7U },{ 0x8938U, 0xE5F8U },
{ 0x893BU, 0xE5F6U },{ 0x8941U, 0xE5F4U },{ 0x8943U, 0xE5EFU },
{ 0x8944U, 0xE5F5U },{ 0x894CU, 0xE5F9U },{ 0x894DU, 0xE8B5U },
{ 0x8956U, 0x89A6U },{ 0x895EU, 0xE5FCU },{ 0x895FU, 0x8BDDU },
{ 0x8960U, 0xE5FBU },{ 0x8964U, 0xE641U },{ 0x8966U, 0xE640U },
{ 0x896AU, 0xE643U },{ 0x896DU, 0xE642U },{ 0x896FU, 0xE644U },
{ 0x8972U, 0x8F50U },{ 0x8974U, 0xE645U },{ 0x8977U, 0xE646U },
{ 0x897EU, 0xE647U },{ 0x897FU, 0x90BCU },{ 0x8981U, 0x9776U },
{ 0x8983U, 0xE648U },{ 0x8986U, 0x95A2U },{ 0x8987U, 0x9465U },
{ 0x8988U, 0xE649U },{ 0x898AU, 0xE64AU },{ 0x898BU, 0x8CA9U },
{ 0x898FU, 0x8B4BU },{ 0x8993U, 0xE64BU },{ 0x8996U, 0x8E8BU },
{ 0x8997U, 0x9460U },{ 0x8998U, 0xE64CU },{ 0x899AU, 0x8A6FU },
{ 0x89A1U, 0xE64DU },{ 0x89A6U, 0xE64FU },{ 0x89A7U, 0x9797U },
{ 0x89A9U, 0xE64EU },{ 0x89AAU, 0x9065U },{ 0x89ACU, 0xE650U },
{ 0x89AFU, 0xE651U },{ 0x89B2U, 0xE652U },{ 0x89B3U, 0x8ACFU },
{ 0x89BAU, 0xE653U },{ 0x89BDU, 0xE654U },{ 0x89BFU, 0xE655U },
{ 0x89C0U, 0xE656U },{ 0x89D2U, 0x8A70U },{ 0x89DAU, 0xE657U },
{ 0x89DCU, 0xE658U },{ 0x89DDU, 0xE659U },{ 0x89E3U, 0x89F0U },
{ 0x89E6U, 0x9047U },{ 0x89E7U, 0xE65AU },{ 0x89F4U, 0xE65BU },
{ 0x89F8U, 0xE65CU },{ 0x8A00U, 0x8CBEU },{ 0x8A02U, 0x92F9U },
{ 0x8A03U, 0xE65DU },{ 0x8A08U, 0x8C76U },{ 0x8A0AU, 0x9075U },
{ 0x8A0CU, 0xE660U },{ 0x8A0EU, 0x93A2U },{ 0x8A10U, 0xE65FU },
{ 0x8A12U, 0xFBA3U },{ 0x8A13U, 0x8C50U },{ 0x8A16U, 0xE65EU },
{ 0x8A17U, 0x91F5U },{ 0x8A18U, 0x8B4CU },{ 0x8A1BU, 0xE661U },
{ 0x8A1DU, 0xE662U },{ 0x8A1FU, 0x8FD7U },{ 0x8A23U, 0x8C8DU },
{ 0x8A25U, 0xE663U },{ 0x8A2AU, 0x964BU },{ 0x8A2DU, 0x90DDU },
{ 0x8A31U, 0x8B96U },{ 0x8A33U, 0x96F3U },{ 0x8A34U, 0x9169U },
{ 0x8A36U, 0xE664U },{ 0x8A37U, 0xFBA4U },{ 0x8A3AU, 0x9066U },
{ 0x8A3BU, 0x9290U },{ 0x8A3CU, 0x8FD8U },{ 0x8A41U, 0xE665U },
{ 0x8A46U, 0xE668U },{ 0x8A48U, 0xE669U },{ 0x8A50U, 0x8DBCU },
{ 0x8A51U, 0x91C0U },{ 0x8A52U, 0xE667U },{ 0x8A54U, 0x8FD9U },
{ 0x8A55U, 0x955DU },{ 0x8A5BU, 0xE666U },{ 0x8A5EU, 0x8E8CU },
{ 0x8A60U, 0x8972U },{ 0x8A62U, 0xE66DU },{ 0x8A63U, 0x8C77U },
{ 0x8A66U, 0x8E8EU },{ 0x8A69U, 0x8E8DU },{ 0x8A6BU, 0x986CU },
{ 0x8A6CU, 0xE66CU },{ 0x8A6DU, 0xE66BU },{ 0x8A6EU, 0x9146U },
{ 0x8A70U, 0x8B6CU },{ 0x8A71U, 0x9862U },{ 0x8A72U, 0x8A59U },
{ 0x8A73U, 0x8FDAU },{ 0x8A79U, 0xFBA5U },{ 0x8A7CU, 0xE66AU },
{ 0x8A82U, 0xE66FU },{ 0x8A84U, 0xE670U },{ 0x8A85U, 0xE66EU },
{ 0x8A87U, 0x8CD6U },{ 0x8A89U, 0x975FU },{ 0x8A8CU, 0x8E8FU },
{ 0x8A8DU, 0x9446U },{ 0x8A91U, 0xE673U },{ 0x8A93U, 0x90BEU },
{ 0x8A95U, 0x9261U },{ 0x8A98U, 0x9755U },{ 0x8A9AU, 0xE676U },
{ 0x8A9EU, 0x8CEAU },{ 0x8AA0U, 0x90BDU },{ 0x8AA1U, 0xE672U },
{ 0x8AA3U, 0xE677U },{ 0x8AA4U, 0x8CEBU },{ 0x8AA5U, 0xE674U },
{ 0x8AA6U, 0xE675U },{ 0x8AA7U, 0xFBA6U },{ 0x8AA8U, 0xE671U },
{ 0x8AACU, 0x90E0U },{ 0x8AADU, 0x93C7U },{ 0x8AB0U, 0x924EU },
{ 0x8AB2U, 0x89DBU },{ 0x8AB9U, 0x94EEU },{ 0x8ABCU, 0x8B62U },
{ 0x8ABEU, 0xFBA7U },{ 0x8ABFU, 0x92B2U },{ 0x8AC2U, 0xE67AU },
{ 0x8AC4U, 0xE678U },{ 0x8AC7U, 0x926BU },{ 0x8ACBU, 0x90BFU },
{ 0x8ACCU, 0x8AD0U },{ 0x8ACDU, 0xE679U },{ 0x8ACFU, 0x907AU },
{ 0x8AD2U, 0x97C8U },{ 0x8AD6U, 0x985FU },{ 0x8ADAU, 0xE67BU },
{ 0x8ADBU, 0xE687U },{ 0x8ADCU, 0x92B3U },{ 0x8ADEU, 0xE686U },
{ 0x8ADFU, 0xFBA8U },{ 0x8AE0U, 0xE683U },{ 0x8AE1U, 0xE68BU },
{ 0x8AE2U, 0xE684U },{ 0x8AE4U, 0xE680U },{ 0x8AE6U, 0x92FAU },
{ 0x8AE7U, 0xE67EU },{ 0x8AEBU, 0xE67CU },{ 0x8AEDU, 0x9740U },
{ 0x8AEEU, 0x8E90U },{ 0x8AF1U, 0xE681U },{ 0x8AF3U, 0xE67DU },
{ 0x8AF6U, 0xFBAAU },{ 0x8AF7U, 0xE685U },{ 0x8AF8U, 0x8F94U },
{ 0x8AFAU, 0x8CBFU },{ 0x8AFEU, 0x91F8U },{ 0x8B00U, 0x9664U },
{ 0x8B01U, 0x8979U },{ 0x8B02U, 0x88E0U },{ 0x8B04U, 0x93A3U },
{ 0x8B07U, 0xE689U },{ 0x8B0CU, 0xE688U },{ 0x8B0EU, 0x93E4U },
{ 0x8B10U, 0xE68DU },{ 0x8B14U, 0xE682U },{ 0x8B16U, 0xE68CU },
{ 0x8B17U, 0xE68EU },{ 0x8B19U, 0x8CAAU },{ 0x8B1AU, 0xE68AU },
{ 0x8B1BU, 0x8D75U },{ 0x8B1DU, 0x8ED3U },{ 0x8B20U, 0xE68FU },
{ 0x8B21U, 0x9777U },{ 0x8B26U, 0xE692U },{ 0x8B28U, 0xE695U },
{ 0x8B2BU, 0xE693U },{ 0x8B2CU, 0x9554U },{ 0x8B33U, 0xE690U },
{ 0x8B39U, 0x8BDEU },{ 0x8B3EU, 0xE694U },{ 0x8B41U, 0xE696U },
{ 0x8B49U, 0xE69AU },{ 0x8B4CU, 0xE697U },{ 0x8B4EU, 0xE699U },
{ 0x8B4FU, 0xE698U },{ 0x8B53U, 0xFBABU },{ 0x8B56U, 0xE69BU },
{ 0x8B58U, 0x8EAFU },{ 0x8B5AU, 0xE69DU },{ 0x8B5BU, 0xE69CU },
{ 0x8B5CU, 0x9588U },{ 0x8B5FU, 0xE69FU },{ 0x8B66U, 0x8C78U },
{ 0x8B6BU, 0xE69EU },{ 0x8B6CU, 0xE6A0U },{ 0x8B6FU, 0xE6A1U },
{ 0x8B70U, 0x8B63U },{ 0x8B71U, 0xE3BFU },{ 0x8B72U, 0x8FF7U },
{ 0x8B74U, 0xE6A2U },{ 0x8B77U, 0x8CECU },{ 0x8B7DU, 0xE6A3U },
{ 0x8B7FU, 0xFBACU },{ 0x8B80U, 0xE6A4U },{ 0x8B83U, 0x8E5DU },
{ 0x8B8AU, 0x9DCCU },{ 0x8B8CU, 0xE6A5U },{ 0x8B8EU, 0xE6A6U },
{ 0x8B90U, 0x8F51U },{ 0x8B92U, 0xE6A7U },{ 0x8B93U, 0xE6A8U },
{ 0x8B96U, 0xE6A9U },{ 0x8B99U, 0xE6AAU },{ 0x8B9AU, 0xE6ABU },
{ 0x8C37U, 0x924AU },{ 0x8C3AU, 0xE6ACU },{ 0x8C3FU, 0xE6AEU },
{ 0x8C41U, 0xE6ADU },{ 0x8C46U, 0x93A4U },{ 0x8C48U, 0xE6AFU },
{ 0x8C4AU, 0x964CU },{ 0x8C4CU, 0xE6B0U },{ 0x8C4EU, 0xE6B1U },
{ 0x8C50U, 0xE6B2U },{ 0x8C55U, 0xE6B3U },{ 0x8C5AU, 0x93D8U },
{ 0x8C61U, 0x8FDBU },{ 0x8C62U, 0xE6B4U },{ 0x8C6AU, 0x8D8BU },
{ 0x8C6BU, 0x98ACU },{ 0x8C6CU, 0xE6B5U },{ 0x8C78U, 0xE6B6U },
{ 0x8C79U, 0x955EU },{ 0x8C7AU, 0xE6B7U },{ 0x8C7CU, 0xE6BFU },
{ 0x8C82U, 0xE6B8U },{ 0x8C85U, 0xE6BAU },{ 0x8C89U, 0xE6B9U },
{ 0x8C8AU, 0xE6BBU },{ 0x8C8CU, 0x9665U },{ 0x8C8DU, 0xE6BCU },
{ 0x8C8EU, 0xE6BDU },{ 0x8C94U, 0xE6BEU },{ 0x8C98U, 0xE6C0U },
{ 0x8C9DU, 0x8A4CU },{ 0x8C9EU, 0x92E5U },{ 0x8CA0U, 0x9589U },
{ 0x8CA1U, 0x8DE0U },{ 0x8CA2U, 0x8D76U },{ 0x8CA7U, 0x956EU },
{ 0x8CA8U, 0x89DDU },{ 0x8CA9U, 0x94CCU },{ 0x8CAAU, 0xE6C3U },
{ 0x8CABU, 0x8AD1U },{ 0x8CACU, 0x90D3U },{ 0x8CADU, 0xE6C2U },
{ 0x8CAEU, 0xE6C7U },{ 0x8CAFU, 0x9299U },{ 0x8CB0U, 0x96E1U },
{ 0x8CB2U, 0xE6C5U },{ 0x8CB3U, 0xE6C6U },{ 0x8CB4U, 0x8B4DU },
{ 0x8CB6U, 0xE6C8U },{ 0x8CB7U, 0x9483U },{ 0x8CB8U, 0x91DDU },
{ 0x8CBBU, 0x94EFU },{ 0x8CBCU, 0x935CU },{ 0x8CBDU, 0xE6C4U },
{ 0x8CBFU, 0x9666U },{ 0x8CC0U, 0x89EAU },{ 0x8CC1U, 0xE6CAU },
{ 0x8CC2U, 0x9847U },{ 0x8CC3U, 0x92C0U },{ 0x8CC4U, 0x9864U },
{ 0x8CC7U, 0x8E91U },{ 0x8CC8U, 0xE6C9U },{ 0x8CCAU, 0x91AFU },
{ 0x8CCDU, 0xE6DAU },{ 0x8CCEU, 0x9147U },{ 0x8CD1U, 0x93F6U },
{ 0x8CD3U, 0x956FU },{ 0x8CDAU, 0xE6CDU },{ 0x8CDBU, 0x8E5EU },
{ 0x8CDCU, 0x8E92U },{ 0x8CDEU, 0x8FDCU },{ 0x8CE0U, 0x9485U },
{ 0x8CE2U, 0x8CABU },{ 0x8CE3U, 0xE6CCU },{ 0x8CE4U, 0xE6CBU },
{ 0x8CE6U, 0x958AU },{ 0x8CEAU, 0x8EBFU },{ 0x8CEDU, 0x9371U },
{ 0x8CF0U, 0xFBADU },{ 0x8CF4U, 0xFBAEU },{ 0x8CFAU, 0xE6CFU },
{ 0x8CFBU, 0xE6D0U },{ 0x8CFCU, 0x8D77U },{ 0x8CFDU, 0xE6CEU },
{ 0x8D04U, 0xE6D1U },{ 0x8D05U, 0xE6D2U },{ 0x8D07U, 0xE6D4U },
{ 0x8D08U, 0x91A1U },{ 0x8D0AU, 0xE6D3U },{ 0x8D0BU, 0x8AE4U },
{ 0x8D0DU, 0xE6D6U },{ 0x8D0FU, 0xE6D5U },{ 0x8D10U, 0xE6D7U },
{ 0x8D12U, 0xFBAFU },{ 0x8D13U, 0xE6D9U },{ 0x8D14U, 0xE6DBU },
{ 0x8D16U, 0xE6DCU },{ 0x8D64U, 0x90D4U },{ 0x8D66U, 0x8ECDU },
{ 0x8D67U, 0xE6DDU },{ 0x8D6BU, 0x8A71U },{ 0x8D6DU, 0xE6DEU },
{ 0x8D70U, 0x9196U },{ 0x8D71U, 0xE6DFU },{ 0x8D73U, 0xE6E0U },
{ 0x8D74U, 0x958BU },{ 0x8D76U, 0xFBB0U },{ 0x8D77U, 0x8B4EU },
{ 0x8D81U, 0xE6E1U },{ 0x8D85U, 0x92B4U },{ 0x8D8AU, 0x897AU },
{ 0x8D99U, 0xE6E2U },{ 0x8DA3U, 0x8EEFU },{ 0x8DA8U, 0x9096U },
{ 0x8DB3U, 0x91ABU },{ 0x8DBAU, 0xE6E5U },{ 0x8DBEU, 0xE6E4U },
{ 0x8DC2U, 0xE6E3U },{ 0x8DCBU, 0xE6EBU },{ 0x8DCCU, 0xE6E9U },
{ 0x8DCFU, 0xE6E6U },{ 0x8DD6U, 0xE6E8U },{ 0x8DDAU, 0xE6E7U },
{ 0x8DDBU, 0xE6EAU },{ 0x8DDDU, 0x8B97U },{ 0x8DDFU, 0xE6EEU },
{ 0x8DE1U, 0x90D5U },{ 0x8DE3U, 0xE6EFU },{ 0x8DE8U, 0x8CD7U },
{ 0x8DEAU, 0xE6ECU },{ 0x8DEBU, 0xE6EDU },{ 0x8DEFU, 0x9848U },
{ 0x8DF3U, 0x92B5U },{ 0x8DF5U, 0x9148U },{ 0x8DFCU, 0xE6F0U },
{ 0x8DFFU, 0xE6F3U },{ 0x8E08U, 0xE6F1U },{ 0x8E09U, 0xE6F2U },
{ 0x8E0AU, 0x9778U },{ 0x8E0FU, 0x93A5U },{ 0x8E10U, 0xE6F6U },
{ 0x8E1DU, 0xE6F4U },{ 0x8E1EU, 0xE6F5U },{ 0x8E1FU, 0xE6F7U },
{ 0x8E2AU, 0xE748U },{ 0x8E30U, 0xE6FAU },{ 0x8E34U, 0xE6FBU },
{ 0x8E35U, 0xE6F9U },{ 0x8E42U, 0xE6F8U },{ 0x8E44U, 0x92FBU },
{ 0x8E47U, 0xE740U },{ 0x8E48U, 0xE744U },{ 0x8E49U, 0xE741U },
{ 0x8E4AU, 0xE6FCU },{ 0x8E4CU, 0xE742U },{ 0x8E50U, 0xE743U },
{ 0x8E55U, 0xE74AU },{ 0x8E59U, 0xE745U },{ 0x8E5FU, 0x90D6U },
{ 0x8E60U, 0xE747U },{ 0x8E63U, 0xE749U },{ 0x8E64U, 0xE746U },
{ 0x8E72U, 0xE74CU },{ 0x8E74U, 0x8F52U },{ 0x8E76U, 0xE74BU },
{ 0x8E7CU, 0xE74DU },{ 0x8E81U, 0xE74EU },{ 0x8E84U, 0xE751U },
{ 0x8E85U, 0xE750U },{ 0x8E87U, 0xE74FU },{ 0x8E8AU, 0xE753U },
{ 0x8E8BU, 0xE752U },{ 0x8E8DU, 0x96F4U },{ 0x8E91U, 0xE755U },
{ 0x8E93U, 0xE754U },{ 0x8E94U, 0xE756U },{ 0x8E99U, 0xE757U },
{ 0x8EA1U, 0xE759U },{ 0x8EAAU, 0xE758U },{ 0x8EABU, 0x9067U },
{ 0x8EACU, 0xE75AU },{ 0x8EAFU, 0x8BEBU },{ 0x8EB0U, 0xE75BU },
{ 0x8EB1U, 0xE75DU },{ 0x8EBEU, 0xE75EU },{ 0x8EC5U, 0xE75FU },
{ 0x8EC6U, 0xE75CU },{ 0x8EC8U, 0xE760U },{ 0x8ECAU, 0x8ED4U },
{ 0x8ECBU, 0xE761U },{ 0x8ECCU, 0x8B4FU },{ 0x8ECDU, 0x8C52U },
{ 0x8ECFU, 0xFBB2U },{ 0x8ED2U, 0x8CACU },{ 0x8EDBU, 0xE762U },
{ 0x8EDFU, 0x93EEU },{ 0x8EE2U, 0x935DU },{ 0x8EE3U, 0xE763U },
{ 0x8EEBU, 0xE766U },{ 0x8EF8U, 0x8EB2U },{ 0x8EFBU, 0xE765U },
{ 0x8EFCU, 0xE764U },{ 0x8EFDU, 0x8C79U },{ 0x8EFEU, 0xE767U },
{ 0x8F03U, 0x8A72U },{ 0x8F05U, 0xE769U },{ 0x8F09U, 0x8DDAU },
{ 0x8F0AU, 0xE768U },{ 0x8F0CU, 0xE771U },{ 0x8F12U, 0xE76BU },
{ 0x8F13U, 0xE76DU },{ 0x8F14U, 0x95E3U },{ 0x8F15U, 0xE76AU },
{ 0x8F19U, 0xE76CU },{ 0x8F1BU, 0xE770U },{ 0x8F1CU, 0xE76EU },
{ 0x8F1DU, 0x8B50U },{ 0x8F1FU, 0xE76FU },{ 0x8F26U, 0xE772U },
{ 0x8F29U, 0x9479U },{ 0x8F2AU, 0x97D6U },{ 0x8F2FU, 0x8F53U },
{ 0x8F33U, 0xE773U },{ 0x8F38U, 0x9741U },{ 0x8F39U, 0xE775U },
{ 0x8F3BU, 0xE774U },{ 0x8F3EU, 0xE778U },{ 0x8F3FU, 0x9760U },
{ 0x8F42U, 0xE777U },{ 0x8F44U, 0x8A8DU },{ 0x8F45U, 0xE776U },
{ 0x8F46U, 0xE77BU },{ 0x8F49U, 0xE77AU },{ 0x8F4CU, 0xE779U },
{ 0x8F4DU, 0x9351U },{ 0x8F4EU, 0xE77CU },{ 0x8F57U, 0xE77DU },
{ 0x8F5CU, 0xE77EU },{ 0x8F5FU, 0x8D8CU },{ 0x8F61U, 0x8C44U },
{ 0x8F62U, 0xE780U },{ 0x8F63U, 0xE781U },{ 0x8F64U, 0xE782U },
{ 0x8F9BU, 0x9068U },{ 0x8F9CU, 0xE783U },{ 0x8F9EU, 0x8EABU },
{ 0x8F9FU, 0xE784U },{ 0x8FA3U, 0xE785U },{ 0x8FA7U, 0x999FU },
{ 0x8FA8U, 0x999EU },{ 0x8FADU, 0xE786U },{ 0x8FAEU, 0xE390U },
{ 0x8FAFU, 0xE787U },{ 0x8FB0U, 0x9243U },{ 0x8FB1U, 0x904AU },
{ 0x8FB2U, 0x945FU },{ 0x8FB7U, 0xE788U },{ 0x8FBAU, 0x95D3U },
{ 0x8FBBU, 0x92D2U },{ 0x8FBCU, 0x8D9EU },{ 0x8FBFU, 0x9248U },
{ 0x8FC2U, 0x8949U },{ 0x8FC4U, 0x9698U },{ 0x8FC5U, 0x9076U },
{ 0x8FCEU, 0x8C7DU },{ 0x8FD1U, 0x8BDFU },{ 0x8FD4U, 0x95D4U },
{ 0x8FDAU, 0xE789U },{ 0x8FE2U, 0xE78BU },{ 0x8FE5U, 0xE78AU },
{ 0x8FE6U, 0x89DEU },{ 0x8FE9U, 0x93F4U },{ 0x8FEAU, 0xE78CU },
{ 0x8FEBU, 0x9497U },{ 0x8FEDU, 0x9352U },{ 0x8FEFU, 0xE78DU },
{ 0x8FF0U, 0x8F71U },{ 0x8FF4U, 0xE78FU },{ 0x8FF7U, 0x96C0U },
{ 0x8FF8U, 0xE79EU },{ 0x8FF9U, 0xE791U },{ 0x8FFAU, 0xE792U },
{ 0x8FFDU, 0x92C7U },{ 0x9000U, 0x91DEU },{ 0x9001U, 0x9197U },
{ 0x9003U, 0x93A6U },{ 0x9005U, 0xE790U },{ 0x9006U, 0x8B74U },
{ 0x900BU, 0xE799U },{ 0x900DU, 0xE796U },{ 0x900EU, 0xE7A3U },
{ 0x900FU, 0x93A7U },{ 0x9010U, 0x9280U },{ 0x9011U, 0xE793U },
{ 0x9013U, 0x92FCU },{ 0x9014U, 0x9372U },{ 0x9015U, 0xE794U },
{ 0x9016U, 0xE798U },{ 0x9017U, 0x9080U },{ 0x9019U, 0x9487U },
{ 0x901AU, 0x92CAU },{ 0x901DU, 0x90C0U },{ 0x901EU, 0xE797U },
{ 0x901FU, 0x91ACU },{ 0x9020U, 0x91A2U },{ 0x9021U, 0xE795U },
{ 0x9022U, 0x88A7U },{ 0x9023U, 0x9841U },{ 0x9027U, 0xE79AU },
{ 0x902EU, 0x91DFU },{ 0x9031U, 0x8F54U },{ 0x9032U, 0x9069U },
{ 0x9035U, 0xE79CU },{ 0x9036U, 0xE79BU },{ 0x9038U, 0x88EDU },
{ 0x9039U, 0xE79DU },{ 0x903CU, 0x954EU },{ 0x903EU, 0xE7A5U },
{ 0x9041U, 0x93D9U },{ 0x9042U, 0x908BU },{ 0x9045U, 0x9278U },
{ 0x9047U, 0x8BF6U },{ 0x9049U, 0xE7A4U },{ 0x904AU, 0x9756U },
{ 0x904BU, 0x895EU },{ 0x904DU, 0x95D5U },{ 0x904EU, 0x89DFU },
{ 0x904FU, 0xE79FU },{ 0x9050U, 0xE7A0U },{ 0x9051U, 0xE7A1U },
{ 0x9052U, 0xE7A2U },{ 0x9053U, 0x93B9U },{ 0x9054U, 0x9242U },
{ 0x9055U, 0x88E1U },{ 0x9056U, 0xE7A6U },{ 0x9058U, 0xE7A7U },
{ 0x9059U, 0xEAA1U },{ 0x905CU, 0x91BBU },{ 0x905EU, 0xE7A8U },
{ 0x9060U, 0x8993U },{ 0x9061U, 0x916BU },{ 0x9063U, 0x8CADU },
{ 0x9065U, 0x9779U },{ 0x9067U, 0xFBB5U },{ 0x9068U, 0xE7A9U },
{ 0x9069U, 0x934BU },{ 0x906DU, 0x9198U },{ 0x906EU, 0x8ED5U },
{ 0x906FU, 0xE7AAU },{ 0x9072U, 0xE7ADU },{ 0x9075U, 0x8F85U },
{ 0x9076U, 0xE7ABU },{ 0x9077U, 0x914AU },{ 0x9078U, 0x9149U },
{ 0x907AU, 0x88E2U },{ 0x907CU, 0x97C9U },{ 0x907DU, 0xE7AFU },
{ 0x907FU, 0x94F0U },{ 0x9080U, 0xE7B1U },{ 0x9081U, 0xE7B0U },
{ 0x9082U, 0xE7AEU },{ 0x9083U, 0xE284U },{ 0x9084U, 0x8AD2U },
{ 0x9087U, 0xE78EU },{ 0x9089U, 0xE7B3U },{ 0x908AU, 0xE7B2U },
{ 0x908FU, 0xE7B4U },{ 0x9091U, 0x9757U },{ 0x90A3U, 0x93DFU },
{ 0x90A6U, 0x964DU },{ 0x90A8U, 0xE7B5U },{ 0x90AAU, 0x8ED7U },
{ 0x90AFU, 0xE7B6U },{ 0x90B1U, 0xE7B7U },{ 0x90B5U, 0xE7B8U },
{ 0x90B8U, 0x9340U },{ 0x90C1U, 0x88E8U },{ 0x90CAU, 0x8D78U },
{ 0x90CEU, 0x9859U },{ 0x90DBU, 0xE7BCU },{ 0x90DEU, 0xFBB6U },
{ 0x90E1U, 0x8C53U },{ 0x90E2U, 0xE7B9U },{ 0x90E4U, 0xE7BAU },
{ 0x90E8U, 0x9594U },{ 0x90EDU, 0x8A73U },{ 0x90F5U, 0x9758U },
{ 0x90F7U, 0x8BBDU },{ 0x90FDU, 0x9373U },{ 0x9102U, 0xE7BDU },
{ 0x9112U, 0xE7BEU },{ 0x9115U, 0xFBB8U },{ 0x9119U, 0xE7BFU },
{ 0x9127U, 0xFBB9U },{ 0x912DU, 0x9341U },{ 0x9130U, 0xE7C1U },
{ 0x9132U, 0xE7C0U },{ 0x9149U, 0x93D1U },{ 0x914AU, 0xE7C2U },
{ 0x914BU, 0x8F55U },{ 0x914CU, 0x8EDEU },{ 0x914DU, 0x947AU },
{ 0x914EU, 0x9291U },{ 0x9152U, 0x8EF0U },{ 0x9154U, 0x908CU },
{ 0x9156U, 0xE7C3U },{ 0x9158U, 0xE7C4U },{ 0x9162U, 0x907CU },
{ 0x9163U, 0xE7C5U },{ 0x9165U, 0xE7C6U },{ 0x9169U, 0xE7C7U },
{ 0x916AU, 0x978FU },{ 0x916CU, 0x8F56U },{ 0x9172U, 0xE7C9U },
{ 0x9173U, 0xE7C8U },{ 0x9175U, 0x8D79U },{ 0x9177U, 0x8D93U },
{ 0x9178U, 0x8E5FU },{ 0x9182U, 0xE7CCU },{ 0x9187U, 0x8F86U },
{ 0x9189U, 0xE7CBU },{ 0x918BU, 0xE7CAU },{ 0x918DU, 0x91E7U },
{ 0x9190U, 0x8CEDU },{ 0x9192U, 0x90C1U },{ 0x9197U, 0x94AEU },
{ 0x919CU, 0x8F58U },{ 0x91A2U, 0xE7CDU },{ 0x91A4U, 0x8FDDU },
{ 0x91AAU, 0xE7D0U },{ 0x91ABU, 0xE7CEU },{ 0x91AFU, 0xE7CFU },
{ 0x91B4U, 0xE7D2U },{ 0x91B5U, 0xE7D1U },{ 0x91B8U, 0x8FF8U },
{ 0x91BAU, 0xE7D3U },{ 0x91C0U, 0xE7D4U },{ 0x91C1U, 0xE7D5U },
{ 0x91C6U, 0x94CEU },{ 0x91C7U, 0x8DD1U },{ 0x91C8U, 0x8EDFU },
{ 0x91C9U, 0xE7D6U },{ 0x91CBU, 0xE7D7U },{ 0x91CCU, 0x97A2U },
{ 0x91CDU, 0x8F64U },{ 0x91CEU, 0x96ECU },{ 0x91CFU, 0x97CAU },
{ 0x91D0U, 0xE7D8U },{ 0x91D1U, 0x8BE0U },{ 0x91D6U, 0xE7D9U },
{ 0x91D7U, 0xFBBBU },{ 0x91D8U, 0x9342U },{ 0x91DAU, 0xFBBAU },
{ 0x91DBU, 0xE7DCU },{ 0x91DCU, 0x8A98U },{ 0x91DDU, 0x906AU },
{ 0x91DEU, 0xFBBCU },{ 0x91DFU, 0xE7DAU },{ 0x91E1U, 0xE7DBU },
{ 0x91E3U, 0x92DEU },{ 0x91E4U, 0xFBBFU },{ 0x91E5U, 0xFBC0U },
{ 0x91E6U, 0x9674U },{ 0x91E7U, 0x8BFAU },{ 0x91EDU, 0xFBBDU },
{ 0x91EEU, 0xFBBEU },{ 0x91F5U, 0xE7DEU },{ 0x91F6U, 0xE7DFU },
{ 0x91FCU, 0xE7DDU },{ 0x91FFU, 0xE7E1U },{ 0x9206U, 0xFBC1U },
{ 0x920AU, 0xFBC3U },{ 0x920DU, 0x93DDU },{ 0x920EU, 0x8A62U },
{ 0x9210U, 0xFBC2U },{ 0x9211U, 0xE7E5U },{ 0x9214U, 0xE7E2U },
{ 0x9215U, 0xE7E4U },{ 0x921EU, 0xE7E0U },{ 0x9229U, 0xE86EU },
{ 0x922CU, 0xE7E3U },{ 0x9234U, 0x97E9U },{ 0x9237U, 0x8CD8U },
{ 0x9239U, 0xFBCAU },{ 0x923AU, 0xFBC4U },{ 0x923CU, 0xFBC6U },
{ 0x923FU, 0xE7EDU },{ 0x9240U, 0xFBC5U },{ 0x9244U, 0x9353U },
{ 0x9245U, 0xE7E8U },{ 0x9248U, 0xE7EBU },{ 0x9249U, 0xE7E9U },
{ 0x924BU, 0xE7EEU },{ 0x924EU, 0xFBC7U },{ 0x9250U, 0xE7EFU },
{ 0x9251U, 0xFBC9U },{ 0x9257U, 0xE7E7U },{ 0x9259U, 0xFBC8U },
{ 0x925AU, 0xE7F4U },{ 0x925BU, 0x8994U },{ 0x925EU, 0xE7E6U },
{ 0x9262U, 0x94ABU },{ 0x9264U, 0xE7EAU },{ 0x9266U, 0x8FDEU },
{ 0x9267U, 0xFBCBU },{ 0x9271U, 0x8D7AU },{ 0x9277U, 0xFBCDU },
{ 0x9278U, 0xFBCEU },{ 0x927EU, 0x9667U },{ 0x9280U, 0x8BE2U },
{ 0x9283U, 0x8F65U },{ 0x9285U, 0x93BAU },{ 0x9288U, 0xFA5FU },
{ 0x9291U, 0x914CU },{ 0x9293U, 0xE7F2U },{ 0x9295U, 0xE7ECU },
{ 0x9296U, 0xE7F1U },{ 0x9298U, 0x96C1U },{ 0x929AU, 0x92B6U },
{ 0x929BU, 0xE7F3U },{ 0x929CU, 0xE7F0U },{ 0x92A7U, 0xFBCCU },
{ 0x92ADU, 0x914BU },{ 0x92B7U, 0xE7F7U },{ 0x92B9U, 0xE7F6U },
{ 0x92CFU, 0xE7F5U },{ 0x92D0U, 0xFBD2U },{ 0x92D2U, 0x964EU },
{ 0x92D3U, 0xFBD6U },{ 0x92D5U, 0xFBD4U },{ 0x92D7U, 0xFBD0U },
{ 0x92D9U, 0xFBD1U },{ 0x92E0U, 0xFBD5U },{ 0x92E4U, 0x8F9BU },
{ 0x92E7U, 0xFBCFU },{ 0x92E9U, 0xE7F8U },{ 0x92EAU, 0x95DDU },
{ 0x92EDU, 0x8973U },{ 0x92F2U, 0x9565U },{ 0x92F3U, 0x9292U },
{ 0x92F8U, 0x8B98U },{ 0x92F9U, 0xFA65U },{ 0x92FAU, 0xE7FAU },
{ 0x92FBU, 0xFBD9U },{ 0x92FCU, 0x8D7CU },{ 0x92FFU, 0xFBDCU },
{ 0x9302U, 0xFBDEU },{ 0x9306U, 0x8E4BU },{ 0x930FU, 0xE7F9U },
{ 0x9310U, 0x908DU },{ 0x9318U, 0x908EU },{ 0x9319U, 0xE840U },
{ 0x931AU, 0xE842U },{ 0x931DU, 0xFBDDU },{ 0x931EU, 0xFBDBU },
{ 0x9320U, 0x8FF9U },{ 0x9321U, 0xFBD8U },{ 0x9322U, 0xE841U },
{ 0x9323U, 0xE843U },{ 0x9325U, 0xFBD7U },{ 0x9326U, 0x8BD1U },
{ 0x9328U, 0x9564U },{ 0x932BU, 0x8EE0U },{ 0x932CU, 0x9842U },
{ 0x932EU, 0xE7FCU },{ 0x932FU, 0x8DF6U },{ 0x9332U, 0x985EU },
{ 0x9335U, 0xE845U },{ 0x933AU, 0xE844U },{ 0x933BU, 0xE846U },
{ 0x9344U, 0xE7FBU },{ 0x9348U, 0xFA5EU },{ 0x934BU, 0x93E7U },
{ 0x934DU, 0x9374U },{ 0x9354U, 0x92D5U },{ 0x9356U, 0xE84BU },
{ 0x9357U, 0xFBE0U },{ 0x935BU, 0x9262U },{ 0x935CU, 0xE847U },
{ 0x9360U, 0xE848U },{ 0x936CU, 0x8C4CU },{ 0x936EU, 0xE84AU },
{ 0x9370U, 0xFBDFU },{ 0x9375U, 0x8CAEU },{ 0x937CU, 0xE849U },
{ 0x937EU, 0x8FDFU },{ 0x938CU, 0x8A99U },{ 0x9394U, 0xE84FU },
{ 0x9396U, 0x8DBDU },{ 0x9397U, 0x9199U },{ 0x939AU, 0x92C8U },
{ 0x93A4U, 0xFBE1U },{ 0x93A7U, 0x8A5AU },{ 0x93ACU, 0xE84DU },
{ 0x93ADU, 0xE84EU },{ 0x93AEU, 0x92C1U },{ 0x93B0U, 0xE84CU },
{ 0x93B9U, 0xE850U },{ 0x93C3U, 0xE856U },{ 0x93C6U, 0xFBE2U },
{ 0x93C8U, 0xE859U },{ 0x93D0U, 0xE858U },{ 0x93D1U, 0x934CU },
{ 0x93D6U, 0xE851U },{ 0x93D7U, 0xE852U },{ 0x93D8U, 0xE855U },
{ 0x93DDU, 0xE857U },{ 0x93DEU, 0xFBE3U },{ 0x93E1U, 0x8BBEU },
{ 0x93E4U, 0xE85AU },{ 0x93E5U, 0xE854U },{ 0x93E8U, 0xE853U },
{ 0x93F8U, 0xFBE4U },{ 0x9403U, 0xE85EU },{ 0x9407U, 0xE85FU },
{ 0x9410U, 0xE860U },{ 0x9413U, 0xE85DU },{ 0x9414U, 0xE85CU },
{ 0x9418U, 0x8FE0U },{ 0x9419U, 0x93A8U },{ 0x941AU, 0xE85BU },
{ 0x9421U, 0xE864U },{ 0x942BU, 0xE862U },{ 0x9431U, 0xFBE5U },
{ 0x9435U, 0xE863U },{ 0x9436U, 0xE861U },{ 0x9438U, 0x91F6U },
{ 0x943AU, 0xE865U },{ 0x9441U, 0xE866U },{ 0x9444U, 0xE868U },
{ 0x9445U, 0xFBE6U },{ 0x9448U, 0xFBE7U },{ 0x9451U, 0x8AD3U },
{ 0x9452U, 0xE867U },{ 0x9453U, 0x96F8U },{ 0x945AU, 0xE873U },
{ 0x945BU, 0xE869U },{ 0x945EU, 0xE86CU },{ 0x9460U, 0xE86AU },
{ 0x9462U, 0xE86BU },{ 0x946AU, 0xE86DU },{ 0x9470U, 0xE86FU },
{ 0x9475U, 0xE870U },{ 0x9477U, 0xE871U },{ 0x947CU, 0xE874U },
{ 0x947DU, 0xE872U },{ 0x947EU, 0xE875U },{ 0x947FU, 0xE877U },
{ 0x9481U, 0xE876U },{ 0x9577U, 0x92B7U },{ 0x9580U, 0x96E5U },
{ 0x9582U, 0xE878U },{ 0x9583U, 0x914DU },{ 0x9587U, 0xE879U },
{ 0x9589U, 0x95C2U },{ 0x958AU, 0xE87AU },{ 0x958BU, 0x8A4AU },
{ 0x958FU, 0x895BU },{ 0x9591U, 0x8AD5U },{ 0x9592U, 0xFBE8U },
{ 0x9593U, 0x8AD4U },{ 0x9594U, 0xE87BU },{ 0x9596U, 0xE87CU },
{ 0x9598U, 0xE87DU },{ 0x9599U, 0xE87EU },{ 0x95A0U, 0xE880U },
{ 0x95A2U, 0x8AD6U },{ 0x95A3U, 0x8A74U },{ 0x95A4U, 0x8D7DU },
{ 0x95A5U, 0x94B4U },{ 0x95A7U, 0xE882U },{ 0x95A8U, 0xE881U },
{ 0x95ADU, 0xE883U },{ 0x95B2U, 0x897BU },{ 0x95B9U, 0xE886U },
{ 0x95BBU, 0xE885U },{ 0x95BCU, 0xE884U },{ 0x95BEU, 0xE887U },
{ 0x95C3U, 0xE88AU },{ 0x95C7U, 0x88C5U },{ 0x95CAU, 0xE888U },
{ 0x95CCU, 0xE88CU },{ 0x95CDU, 0xE88BU },{ 0x95D4U, 0xE88EU },
{ 0x95D5U, 0xE88DU },{ 0x95D6U, 0xE88FU },{ 0x95D8U, 0x93ACU },
{ 0x95DCU, 0xE890U },{ 0x95E1U, 0xE891U },{ 0x95E2U, 0xE893U },
{ 0x95E5U, 0xE892U },{ 0x961CU, 0x958CU },{ 0x9621U, 0xE894U },
{ 0x9628U, 0xE895U },{ 0x962AU, 0x8DE3U },{ 0x962EU, 0xE896U },
{ 0x962FU, 0xE897U },{ 0x9632U, 0x9668U },{ 0x963BU, 0x916AU },
{ 0x963FU, 0x88A2U },{ 0x9640U, 0x91C9U },{ 0x9642U, 0xE898U },
{ 0x9644U, 0x958DU },{ 0x964BU, 0xE89BU },{ 0x964CU, 0xE899U },
{ 0x964DU, 0x8D7EU },{ 0x964FU, 0xE89AU },{ 0x9650U, 0x8CC0U },
{ 0x965BU, 0x95C3U },{ 0x965CU, 0xE89DU },{ 0x965DU, 0xE89FU },
{ 0x965EU, 0xE89EU },{ 0x965FU, 0xE8A0U },{ 0x9662U, 0x8940U },
{ 0x9663U, 0x9077U },{ 0x9664U, 0x8F9CU },{ 0x9665U, 0x8AD7U },
{ 0x9666U, 0xE8A1U },{ 0x966AU, 0x9486U },{ 0x966CU, 0xE8A3U },
{ 0x9670U, 0x8941U },{ 0x9672U, 0xE8A2U },{ 0x9673U, 0x92C2U },
{ 0x9675U, 0x97CBU },{ 0x9676U, 0x93A9U },{ 0x9677U, 0xE89CU },
{ 0x9678U, 0x97A4U },{ 0x967AU, 0x8CAFU },{ 0x967DU, 0x977AU },
{ 0x9685U, 0x8BF7U },{ 0x9686U, 0x97B2U },{ 0x9688U, 0x8C47U },
{ 0x968AU, 0x91E0U },{ 0x968BU, 0xE440U },{ 0x968DU, 0xE8A4U },
{ 0x968EU, 0x8A4BU },{ 0x968FU, 0x908FU },{ 0x9694U, 0x8A75U },
{ 0x9695U, 0xE8A6U },{ 0x9697U, 0xE8A7U },{ 0x9698U, 0xE8A5U },
{ 0x9699U, 0x8C84U },{ 0x969BU, 0x8DDBU },{ 0x969CU, 0x8FE1U },
{ 0x969DU, 0xFBEBU },{ 0x96A0U, 0x8942U },{ 0x96A3U, 0x97D7U },
{ 0x96A7U, 0xE8A9U },{ 0x96A8U, 0xE7ACU },{ 0x96AAU, 0xE8A8U },
{ 0x96AFU, 0xFBECU },{ 0x96B0U, 0xE8ACU },{ 0x96B1U, 0xE8AAU },
{ 0x96B2U, 0xE8ABU },{ 0x96B4U, 0xE8ADU },{ 0x96B6U, 0xE8AEU },
{ 0x96B7U, 0x97EAU },{ 0x96B8U, 0xE8AFU },{ 0x96B9U, 0xE8B0U },
{ 0x96BBU, 0x90C7U },{ 0x96BCU, 0x94B9U },{ 0x96C0U, 0x909DU },
{ 0x96C1U, 0x8AE5U },{ 0x96C4U, 0x9759U },{ 0x96C5U, 0x89EBU },
{ 0x96C6U, 0x8F57U },{ 0x96C7U, 0x8CD9U },{ 0x96C9U, 0xE8B3U },
{ 0x96CBU, 0xE8B2U },{ 0x96CCU, 0x8E93U },{ 0x96CDU, 0xE8B4U },
{ 0x96CEU, 0xE8B1U },{ 0x96D1U, 0x8E47U },{ 0x96D5U, 0xE8B8U },
{ 0x96D6U, 0xE5ABU },{ 0x96D9U, 0x99D4U },{ 0x96DBU, 0x9097U },
{ 0x96DCU, 0xE8B6U },{ 0x96E2U, 0x97A3U },{ 0x96E3U, 0x93EFU },
{ 0x96E8U, 0x894AU },{ 0x96EAU, 0x90E1U },{ 0x96EBU, 0x8EB4U },
{ 0x96F0U, 0x95B5U },{ 0x96F2U, 0x895FU },{ 0x96F6U, 0x97EBU },
{ 0x96F7U, 0x978BU },{ 0x96F9U, 0xE8B9U },{ 0x96FBU, 0x9364U },
{ 0x9700U, 0x8EF9U },{ 0x9704U, 0xE8BAU },{ 0x9706U, 0xE8BBU },
{ 0x9707U, 0x906BU },{ 0x9708U, 0xE8BCU },{ 0x970AU, 0x97ECU },
{ 0x970DU, 0xE8B7U },{ 0x970EU, 0xE8BEU },{ 0x970FU, 0xE8C0U },
{ 0x9711U, 0xE8BFU },{ 0x9713U, 0xE8BDU },{ 0x9716U, 0xE8C1U },
{ 0x9719U, 0xE8C2U },{ 0x971CU, 0x919AU },{ 0x971EU, 0x89E0U },
{ 0x9724U, 0xE8C3U },{ 0x9727U, 0x96B6U },{ 0x972AU, 0xE8C4U },
{ 0x9730U, 0xE8C5U },{ 0x9732U, 0x9849U },{ 0x9733U, 0xFBEDU },
{ 0x9738U, 0x9E50U },{ 0x9739U, 0xE8C6U },{ 0x973BU, 0xFBEEU },
{ 0x973DU, 0xE8C7U },{ 0x973EU, 0xE8C8U },{ 0x9742U, 0xE8CCU },
{ 0x9743U, 0xFBEFU },{ 0x9744U, 0xE8C9U },{ 0x9746U, 0xE8CAU },
{ 0x9748U, 0xE8CBU },{ 0x9749U, 0xE8CDU },{ 0x974DU, 0xFBF0U },
{ 0x974FU, 0xFBF1U },{ 0x9751U, 0xFBF2U },{ 0x9752U, 0x90C2U },
{ 0x9755U, 0xFBF3U },{ 0x9756U, 0x96F5U },{ 0x9759U, 0x90C3U },
{ 0x975CU, 0xE8CEU },{ 0x975EU, 0x94F1U },{ 0x9760U, 0xE8CFU },
{ 0x9761U, 0xEA72U },{ 0x9762U, 0x96CAU },{ 0x9764U, 0xE8D0U },
{ 0x9766U, 0xE8D1U },{ 0x9768U, 0xE8D2U },{ 0x9769U, 0x8A76U },
{ 0x976BU, 0xE8D4U },{ 0x976DU, 0x9078U },{ 0x9771U, 0xE8D5U },
{ 0x9774U, 0x8C43U },{ 0x9779U, 0xE8D6U },{ 0x977AU, 0xE8DAU },
{ 0x977CU, 0xE8D8U },{ 0x9781U, 0xE8D9U },{ 0x9784U, 0x8A93U },
{ 0x9785U, 0xE8D7U },{ 0x9786U, 0xE8DBU },{ 0x978BU, 0xE8DCU },
{ 0x978DU, 0x88C6U },{ 0x978FU, 0xE8DDU },{ 0x9790U, 0xE8DEU },
{ 0x9798U, 0x8FE2U },{ 0x979CU, 0xE8DFU },{ 0x97A0U, 0x8B66U },
{ 0x97A3U, 0xE8E2U },{ 0x97A6U, 0xE8E1U },{ 0x97A8U, 0xE8E0U },
{ 0x97ABU, 0xE691U },{ 0x97ADU, 0x95DAU },{ 0x97B3U, 0xE8E3U },
{ 0x97B4U, 0xE8E4U },{ 0x97C3U, 0xE8E5U },{ 0x97C6U, 0xE8E6U },
{ 0x97C8U, 0xE8E7U },{ 0x97CBU, 0xE8E8U },{ 0x97D3U, 0x8AD8U },
{ 0x97DCU, 0xE8E9U },{ 0x97EDU, 0xE8EAU },{ 0x97EEU, 0x9442U },
{ 0x97F2U, 0xE8ECU },{ 0x97F3U, 0x89B9U },{ 0x97F5U, 0xE8EFU },
{ 0x97F6U, 0xE8EEU },{ 0x97FBU, 0x8943U },{ 0x97FFU, 0x8BBFU },
{ 0x9801U, 0x95C5U },{ 0x9802U, 0x92B8U },{ 0x9803U, 0x8DA0U },
{ 0x9805U, 0x8D80U },{ 0x9806U, 0x8F87U },{ 0x9808U, 0x907BU },
{ 0x980CU, 0xE8F1U },{ 0x980FU, 0xE8F0U },{ 0x9810U, 0x9761U },
{ 0x9811U, 0x8AE6U },{ 0x9812U, 0x94D0U },{ 0x9813U, 0x93DAU },
{ 0x9817U, 0x909CU },{ 0x9818U, 0x97CCU },{ 0x981AU, 0x8C7AU },
{ 0x9821U, 0xE8F4U },{ 0x9824U, 0xE8F3U },{ 0x982CU, 0x966AU },
{ 0x982DU, 0x93AAU },{ 0x9834U, 0x896FU },{ 0x9837U, 0xE8F5U },
{ 0x9838U, 0xE8F2U },{ 0x983BU, 0x9570U },{ 0x983CU, 0x978AU },
{ 0x983DU, 0xE8F6U },{ 0x9846U, 0xE8F7U },{ 0x984BU, 0xE8F9U },
{ 0x984CU, 0x91E8U },{ 0x984DU, 0x8A7AU },{ 0x984EU, 0x8A7BU },
{ 0x984FU, 0xE8F8U },{ 0x9854U, 0x8AE7U },{ 0x9855U, 0x8CB0U },
{ 0x9857U, 0xFBF4U },{ 0x9858U, 0x8AE8U },{ 0x985BU, 0x935EU },
{ 0x985EU, 0x97DEU },{ 0x9865U, 0xFBF5U },{ 0x9867U, 0x8CDAU },
{ 0x986BU, 0xE8FAU },{ 0x986FU, 0xE8FBU },{ 0x9870U, 0xE8FCU },
{ 0x9871U, 0xE940U },{ 0x9873U, 0xE942U },{ 0x9874U, 0xE941U },
{ 0x98A8U, 0x9597U },{ 0x98AAU, 0xE943U },{ 0x98AFU, 0xE944U },
{ 0x98B1U, 0xE945U },{ 0x98B6U, 0xE946U },{ 0x98C3U, 0xE948U },
{ 0x98C4U, 0xE947U },{ 0x98C6U, 0xE949U },{ 0x98DBU, 0x94F2U },
{ 0x98DCU, 0xE3CAU },{ 0x98DFU, 0x9048U },{ 0x98E2U, 0x8B51U },
{ 0x98E9U, 0xE94AU },{ 0x98EBU, 0xE94BU },{ 0x98EDU, 0x99AAU },
{ 0x98EEU, 0x9F5AU },{ 0x98EFU, 0x94D1U },{ 0x98F2U, 0x88F9U },
{ 0x98F4U, 0x88B9U },{ 0x98FCU, 0x8E94U },{ 0x98FDU, 0x964FU },
{ 0x98FEU, 0x8FFCU },{ 0x9903U, 0xE94CU },{ 0x9905U, 0x96DDU },
{ 0x9909U, 0xE94DU },{ 0x990AU, 0x977BU },{ 0x990CU, 0x8961U },
{ 0x9910U, 0x8E60U },{ 0x9912U, 0xE94EU },{ 0x9913U, 0x89ECU },
{ 0x9914U, 0xE94FU },{ 0x9918U, 0xE950U },{ 0x991DU, 0xE952U },
{ 0x991EU, 0xE953U },{ 0x9920U, 0xE955U },{ 0x9921U, 0xE951U },
{ 0x9924U, 0xE954U },{ 0x9927U, 0xFBF8U },{ 0x9928U, 0x8AD9U },
{ 0x992CU, 0xE956U },{ 0x992EU, 0xE957U },{ 0x993DU, 0xE958U },
{ 0x993EU, 0xE959U },{ 0x9942U, 0xE95AU },{ 0x9945U, 0xE95CU },
{ 0x9949U, 0xE95BU },{ 0x994BU, 0xE95EU },{ 0x994CU, 0xE961U },
{ 0x9950U, 0xE95DU },{ 0x9951U, 0xE95FU },{ 0x9952U, 0xE960U },
{ 0x9955U, 0xE962U },{ 0x9957U, 0x8BC0U },{ 0x9996U, 0x8EF1U },
{ 0x9997U, 0xE963U },{ 0x9998U, 0xE964U },{ 0x9999U, 0x8D81U },
{ 0x999EU, 0xFBFAU },{ 0x99A5U, 0xE965U },{ 0x99A8U, 0x8A5DU },
{ 0x99ACU, 0x946EU },{ 0x99ADU, 0xE966U },{ 0x99AEU, 0xE967U },
{ 0x99B3U, 0x9279U },{ 0x99B4U, 0x93E9U },{ 0x99BCU, 0xE968U },
{ 0x99C1U, 0x949DU },{ 0x99C4U, 0x91CAU },{ 0x99C5U, 0x8977U },
{ 0x99C6U, 0x8BECU },{ 0x99C8U, 0x8BEDU },{ 0x99D0U, 0x9293U },
{ 0x99D1U, 0xE96DU },{ 0x99D2U, 0x8BEEU },{ 0x99D5U, 0x89EDU },
{ 0x99D8U, 0xE96CU },{ 0x99DBU, 0xE96AU },{ 0x99DDU, 0xE96BU },
{ 0x99DFU, 0xE969U },{ 0x99E2U, 0xE977U },{ 0x99EDU, 0xE96EU },
{ 0x99EEU, 0xE96FU },{ 0x99F1U, 0xE970U },{ 0x99F2U, 0xE971U },
{ 0x99F8U, 0xE973U },{ 0x99FBU, 0xE972U },{ 0x99FFU, 0x8F78U },
{ 0x9A01U, 0xE974U },{ 0x9A05U, 0xE976U },{ 0x9A0EU, 0x8B52U },
{ 0x9A0FU, 0xE975U },{ 0x9A12U, 0x919BU },{ 0x9A13U, 0x8CB1U },
{ 0x9A19U, 0xE978U },{ 0x9A28U, 0x91CBU },{ 0x9A2BU, 0xE979U },
{ 0x9A30U, 0x93ABU },{ 0x9A37U, 0xE97AU },{ 0x9A3EU, 0xE980U },
{ 0x9A40U, 0xE97DU },{ 0x9A42U, 0xE97CU },{ 0x9A43U, 0xE97EU },
{ 0x9A45U, 0xE97BU },{ 0x9A4DU, 0xE982U },{ 0x9A4EU, 0xFBFBU },
{ 0x9A55U, 0xE981U },{ 0x9A57U, 0xE984U },{ 0x9A5AU, 0x8BC1U },
{ 0x9A5BU, 0xE983U },{ 0x9A5FU, 0xE985U },{ 0x9A62U, 0xE986U },
{ 0x9A64U, 0xE988U },{ 0x9A65U, 0xE987U },{ 0x9A69U, 0xE989U },
{ 0x9A6AU, 0xE98BU },{ 0x9A6BU, 0xE98AU },{ 0x9AA8U, 0x8D9CU },
{ 0x9AADU, 0xE98CU },{ 0x9AB0U, 0xE98DU },{ 0x9AB8U, 0x8A5BU },
{ 0x9ABCU, 0xE98EU },{ 0x9AC0U, 0xE98FU },{ 0x9AC4U, 0x9091U },
{ 0x9ACFU, 0xE990U },{ 0x9AD1U, 0xE991U },{ 0x9AD3U, 0xE992U },
{ 0x9AD4U, 0xE993U },{ 0x9AD8U, 0x8D82U },{ 0x9AD9U, 0xFBFCU },
{ 0x9ADCU, 0xFC40U },{ 0x9ADEU, 0xE994U },{ 0x9ADFU, 0xE995U },
{ 0x9AE2U, 0xE996U },{ 0x9AE3U, 0xE997U },{ 0x9AE6U, 0xE998U },
{ 0x9AEAU, 0x94AFU },{ 0x9AEBU, 0xE99AU },{ 0x9AEDU, 0x9545U },
{ 0x9AEEU, 0xE99BU },{ 0x9AEFU, 0xE999U },{ 0x9AF1U, 0xE99DU },
{ 0x9AF4U, 0xE99CU },{ 0x9AF7U, 0xE99EU },{ 0x9AFBU, 0xE99FU },
{ 0x9B06U, 0xE9A0U },{ 0x9B18U, 0xE9A1U },{ 0x9B1AU, 0xE9A2U },
{ 0x9B1FU, 0xE9A3U },{ 0x9B22U, 0xE9A4U },{ 0x9B23U, 0xE9A5U },
{ 0x9B25U, 0xE9A6U },{ 0x9B27U, 0xE9A7U },{ 0x9B28U, 0xE9A8U },
{ 0x9B29U, 0xE9A9U },{ 0x9B2AU, 0xE9AAU },{ 0x9B2EU, 0xE9ABU },
{ 0x9B2FU, 0xE9ACU },{ 0x9B31U, 0x9F54U },{ 0x9B32U, 0xE9ADU },
{ 0x9B3BU, 0xE2F6U },{ 0x9B3CU, 0x8B53U },{ 0x9B41U, 0x8A40U },
{ 0x9B42U, 0x8DB0U },{ 0x9B43U, 0xE9AFU },{ 0x9B44U, 0xE9AEU },
{ 0x9B45U, 0x96A3U },{ 0x9B4DU, 0xE9B1U },{ 0x9B4EU, 0xE9B2U },
{ 0x9B4FU, 0xE9B0U },{ 0x9B51U, 0xE9B3U },{ 0x9B54U, 0x9682U },
{ 0x9B58U, 0xE9B4U },{ 0x9B5AU, 0x8B9BU },{ 0x9B6FU, 0x9844U },
{ 0x9B72U, 0xFC42U },{ 0x9B74U, 0xE9B5U },{ 0x9B75U, 0xFC41U },
{ 0x9B83U, 0xE9B7U },{ 0x9B8EU, 0x88BCU },{ 0x9B8FU, 0xFC43U },
{ 0x9B91U, 0xE9B8U },{ 0x9B92U, 0x95A9U },{ 0x9B93U, 0xE9B6U },
{ 0x9B96U, 0xE9B9U },{ 0x9B97U, 0xE9BAU },{ 0x9B9FU, 0xE9BBU },
{ 0x9BA0U, 0xE9BCU },{ 0x9BA8U, 0xE9BDU },{ 0x9BAAU, 0x968EU },
{ 0x9BABU, 0x8E4CU },{ 0x9BADU, 0x8DF8U },{ 0x9BAEU, 0x914EU },
{ 0x9BB1U, 0xFC44U },{ 0x9BB4U, 0xE9BEU },{ 0x9BB9U, 0xE9C1U },
{ 0x9BBBU, 0xFC45U },{ 0x9BC0U, 0xE9BFU },{ 0x9BC6U, 0xE9C2U },
{ 0x9BC9U, 0x8CEFU },{ 0x9BCAU, 0xE9C0U },{ 0x9BCFU, 0xE9C3U },
{ 0x9BD1U, 0xE9C4U },{ 0x9BD2U, 0xE9C5U },{ 0x9BD4U, 0xE9C9U },
{ 0x9BD6U, 0x8E49U },{ 0x9BDBU, 0x91E2U },{ 0x9BE1U, 0xE9CAU },
{ 0x9BE2U, 0xE9C7U },{ 0x9BE3U, 0xE9C6U },{ 0x9BE4U, 0xE9C8U },
{ 0x9BE8U, 0x8C7EU },{ 0x9BF0U, 0xE9CEU },{ 0x9BF1U, 0xE9CDU },
{ 0x9BF2U, 0xE9CCU },{ 0x9BF5U, 0x88B1U },{ 0x9C00U, 0xFC46U },
{ 0x9C04U, 0xE9D8U },{ 0x9C06U, 0xE9D4U },{ 0x9C08U, 0xE9D5U },
{ 0x9C09U, 0xE9D1U },{ 0x9C0AU, 0xE9D7U },{ 0x9C0CU, 0xE9D3U },
{ 0x9C0DU, 0x8A82U },{ 0x9C10U, 0x986BU },{ 0x9C12U, 0xE9D6U },
{ 0x9C13U, 0xE9D2U },{ 0x9C14U, 0xE9D0U },{ 0x9C15U, 0xE9CFU },
{ 0x9C1BU, 0xE9DAU },{ 0x9C21U, 0xE9DDU },{ 0x9C24U, 0xE9DCU },
{ 0x9C25U, 0xE9DBU },{ 0x9C2DU, 0x9568U },{ 0x9C2EU, 0xE9D9U },
{ 0x9C2FU, 0x88F1U },{ 0x9C30U, 0xE9DEU },{ 0x9C32U, 0xE9E0U },
{ 0x9C39U, 0x8A8FU },{ 0x9C3AU, 0xE9CBU },{ 0x9C3BU, 0x8956U },
{ 0x9C3EU, 0xE9E2U },{ 0x9C46U, 0xE9E1U },{ 0x9C47U, 0xE9DFU },
{ 0x9C48U, 0x924CU },{ 0x9C52U, 0x9690U },{ 0x9C57U, 0x97D8U },
{ 0x9C5AU, 0xE9E3U },{ 0x9C60U, 0xE9E4U },{ 0x9C67U, 0xE9E5U },
{ 0x9C76U, 0xE9E6U },{ 0x9C78U, 0xE9E7U },{ 0x9CE5U, 0x92B9U },
{ 0x9CE7U, 0xE9E8U },{ 0x9CE9U, 0x94B5U },{ 0x9CEBU, 0xE9EDU },
{ 0x9CECU, 0xE9E9U },{ 0x9CF0U, 0xE9EAU },{ 0x9CF3U, 0x9650U },
{ 0x9CF4U, 0x96C2U },{ 0x9CF6U, 0x93CEU },{ 0x9D03U, 0xE9EEU },
{ 0x9D06U, 0xE9EFU },{ 0x9D07U, 0x93BCU },{ 0x9D08U, 0xE9ECU },
{ 0x9D09U, 0xE9EBU },{ 0x9D0EU, 0x89A8U },{ 0x9D12U, 0xE9F7U },
{ 0x9D15U, 0xE9F6U },{ 0x9D1BU, 0x8995U },{ 0x9D1FU, 0xE9F4U },
{ 0x9D23U, 0xE9F3U },{ 0x9D26U, 0xE9F1U },{ 0x9D28U, 0x8A9BU },
{ 0x9D2AU, 0xE9F0U },{ 0x9D2BU, 0x8EB0U },{ 0x9D2CU, 0x89A7U },
{ 0x9D3BU, 0x8D83U },{ 0x9D3EU, 0xE9FAU },{ 0x9D3FU, 0xE9F9U },
{ 0x9D41U, 0xE9F8U },{ 0x9D44U, 0xE9F5U },{ 0x9D46U, 0xE9FBU },
{ 0x9D48U, 0xE9FCU },{ 0x9D50U, 0xEA44U },{ 0x9D51U, 0xEA43U },
{ 0x9D59U, 0xEA45U },{ 0x9D5CU, 0x894CU },{ 0x9D5DU, 0xEA40U },
{ 0x9D5EU, 0xEA41U },{ 0x9D60U, 0x8D94U },{ 0x9D61U, 0x96B7U },
{ 0x9D64U, 0xEA42U },{ 0x9D6BU, 0xFC48U },{ 0x9D6CU, 0x9651U },
{ 0x9D6FU, 0xEA4AU },{ 0x9D70U, 0xFC47U },{ 0x9D72U, 0xEA46U },
{ 0x9D7AU, 0xEA4BU },{ 0x9D87U, 0xEA48U },{ 0x9D89U, 0xEA47U },
{ 0x9D8FU, 0x8C7BU },{ 0x9D9AU, 0xEA4CU },{ 0x9DA4U, 0xEA4DU },
{ 0x9DA9U, 0xEA4EU },{ 0x9DABU, 0xEA49U },{ 0x9DAFU, 0xE9F2U },
{ 0x9DB2U, 0xEA4FU },{ 0x9DB4U, 0x92DFU },{ 0x9DB8U, 0xEA53U },
{ 0x9DBAU, 0xEA54U },{ 0x9DBBU, 0xEA52U },{ 0x9DC1U, 0xEA51U },
{ 0x9DC2U, 0xEA57U },{ 0x9DC4U, 0xEA50U },{ 0x9DC6U, 0xEA55U },
{ 0x9DCFU, 0xEA56U },{ 0x9DD3U, 0xEA59U },{ 0x9DD9U, 0xEA58U },
{ 0x9DE6U, 0xEA5BU },{ 0x9DEDU, 0xEA5CU },{ 0x9DEFU, 0xEA5DU },
{ 0x9DF2U, 0x9868U },{ 0x9DF8U, 0xEA5AU },{ 0x9DF9U, 0x91E9U },
{ 0x9DFAU, 0x8DEBU },{ 0x9DFDU, 0xEA5EU },{ 0x9E19U, 0xFC4AU },
{ 0x9E1AU, 0xEA5FU },{ 0x9E1BU, 0xEA60U },{ 0x9E1EU, 0xEA61U },
{ 0x9E75U, 0xEA62U },{ 0x9E78U, 0x8CB2U },{ 0x9E79U, 0xEA63U },
{ 0x9E7DU, 0xEA64U },{ 0x9E7FU, 0x8EADU },{ 0x9E81U, 0xEA65U },
{ 0x9E88U, 0xEA66U },{ 0x9E8BU, 0xEA67U },{ 0x9E8CU, 0xEA68U },
{ 0x9E91U, 0xEA6BU },{ 0x9E92U, 0xEA69U },{ 0x9E93U, 0x985BU },
{ 0x9E95U, 0xEA6AU },{ 0x9E97U, 0x97EDU },{ 0x9E9DU, 0xEA6CU },
{ 0x9E9FU, 0x97D9U },{ 0x9EA5U, 0xEA6DU },{ 0x9EA6U, 0x949EU },
{ 0x9EA9U, 0xEA6EU },{ 0x9EAAU, 0xEA70U },{ 0x9EADU, 0xEA71U },
{ 0x9EB8U, 0xEA6FU },{ 0x9EB9U, 0x8D8DU },{ 0x9EBAU, 0x96CBU },
{ 0x9EBBU, 0x9683U },{ 0x9EBCU, 0x9BF5U },{ 0x9EBEU, 0x9F80U },
{ 0x9EBFU, 0x969BU },{ 0x9EC4U, 0x89A9U },{ 0x9ECCU, 0xEA73U },
{ 0x9ECDU, 0x8B6FU },{ 0x9ECEU, 0xEA74U },{ 0x9ECFU, 0xEA75U },
{ 0x9ED0U, 0xEA76U },{ 0x9ED1U, 0xFC4BU },{ 0x9ED2U, 0x8D95U },
{ 0x9ED4U, 0xEA77U },{ 0x9ED8U, 0xE0D2U },{ 0x9ED9U, 0x96D9U },
{ 0x9EDBU, 0x91E1U },{ 0x9EDCU, 0xEA78U },{ 0x9EDDU, 0xEA7AU },
{ 0x9EDEU, 0xEA79U },{ 0x9EE0U, 0xEA7BU },{ 0x9EE5U, 0xEA7CU },
{ 0x9EE8U, 0xEA7DU },{ 0x9EEFU, 0xEA7EU },{ 0x9EF4U, 0xEA80U },
{ 0x9EF6U, 0xEA81U },{ 0x9EF7U, 0xEA82U },{ 0x9EF9U, 0xEA83U },
{ 0x9EFBU, 0xEA84U },{ 0x9EFCU, 0xEA85U },{ 0x9EFDU, 0xEA86U },
{ 0x9F07U, 0xEA87U },{ 0x9F08U, 0xEA88U },{ 0x9F0EU, 0x9343U },
{ 0x9F13U, 0x8CDBU },{ 0x9F15U, 0xEA8AU },{ 0x9F20U, 0x916CU },
{ 0x9F21U, 0xEA8BU },{ 0x9F2CU, 0xEA8CU },{ 0x9F3BU, 0x9540U },
{ 0x9F3EU, 0xEA8DU },{ 0x9F4AU, 0xEA8EU },{ 0x9F4BU, 0xE256U },
{ 0x9F4EU, 0xE6D8U },{ 0x9F4FU, 0xE8EBU },{ 0x9F52U, 0xEA8FU },
{ 0x9F54U, 0xEA90U },{ 0x9F5FU, 0xEA92U },{ 0x9F60U, 0xEA93U },
{ 0x9F61U, 0xEA94U },{ 0x9F62U, 0x97EEU },{ 0x9F63U, 0xEA91U },
{ 0x9F66U, 0xEA95U },{ 0x9F67U, 0xEA96U },{ 0x9F6AU, 0xEA98U },
{ 0x9F6CU, 0xEA97U },{ 0x9F72U, 0xEA9AU },{ 0x9F76U, 0xEA9BU },
{ 0x9F77U, 0xEA99U },{ 0x9F8DU, 0x97B4U },{ 0x9F95U, 0xEA9CU },
{ 0x9F9CU, 0xEA9DU },{ 0x9F9DU, 0xE273U },{ 0x9FA0U, 0xEA9EU },
{ 0xF929U, 0xFAE0U },{ 0xF9DCU, 0xFBE9U },{ 0xFA0EU, 0xFA90U },
{ 0xFA0FU, 0xFA9BU },{ 0xFA10U, 0xFA9CU },{ 0xFA11U, 0xFAB1U },
{ 0xFA12U, 0xFAD8U },{ 0xFA13U, 0xFAE8U },{ 0xFA14U, 0xFAEAU },
{ 0xFA15U, 0xFB58U },{ 0xFA16U, 0xFB5EU },{ 0xFA17U, 0xFB75U },
{ 0xFA18U, 0xFB7DU },{ 0xFA19U, 0xFB7EU },{ 0xFA1AU, 0xFB80U },
{ 0xFA1BU, 0xFB82U },{ 0xFA1CU, 0xFB86U },{ 0xFA1DU, 0xFB89U },
{ 0xFA1EU, 0xFB92U },{ 0xFA1FU, 0xFB9DU },{ 0xFA20U, 0xFB9FU },
{ 0xFA21U, 0xFBA0U },{ 0xFA22U, 0xFBA9U },{ 0xFA23U, 0xFBB1U },
{ 0xFA24U, 0xFBB3U },{ 0xFA25U, 0xFBB4U },{ 0xFA26U, 0xFBB7U },
{ 0xFA27U, 0xFBD3U },{ 0xFA28U, 0xFBDAU },{ 0xFA29U, 0xFBEAU },
{ 0xFA2AU, 0xFBF6U },{ 0xFA2BU, 0xFBF7U },{ 0xFA2CU, 0xFBF9U },
{ 0xFA2DU, 0xFC49U },{ 0xFF01U, 0x8149U },{ 0xFF02U, 0xFA57U },
{ 0xFF03U, 0x8194U },{ 0xFF04U, 0x8190U },{ 0xFF05U, 0x8193U },
{ 0xFF06U, 0x8195U },{ 0xFF07U, 0xFA56U },{ 0xFF08U, 0x8169U },
{ 0xFF09U, 0x816AU },{ 0xFF0AU, 0x8196U },{ 0xFF0BU, 0x817BU },
{ 0xFF0CU, 0x8143U },{ 0xFF0DU, 0x817CU },{ 0xFF0EU, 0x8144U },
{ 0xFF0FU, 0x815EU },{ 0xFF10U, 0x824FU },{ 0xFF11U, 0x8250U },
{ 0xFF12U, 0x8251U },{ 0xFF13U, 0x8252U },{ 0xFF14U, 0x8253U },
{ 0xFF15U, 0x8254U },{ 0xFF16U, 0x8255U },{ 0xFF17U, 0x8256U },
{ 0xFF18U, 0x8257U },{ 0xFF19U, 0x8258U },{ 0xFF1AU, 0x8146U },
{ 0xFF1BU, 0x8147U },{ 0xFF1CU, 0x8183U },{ 0xFF1DU, 0x8181U },
{ 0xFF1EU, 0x8184U },{ 0xFF1FU, 0x8148U },{ 0xFF20U, 0x8197U },
{ 0xFF21U, 0x8260U },{ 0xFF22U, 0x8261U },{ 0xFF23U, 0x8262U },
{ 0xFF24U, 0x8263U },{ 0xFF25U, 0x8264U },{ 0xFF26U, 0x8265U },
{ 0xFF27U, 0x8266U },{ 0xFF28U, 0x8267U },{ 0xFF29U, 0x8268U },
{ 0xFF2AU, 0x8269U },{ 0xFF2BU, 0x826AU },{ 0xFF2CU, 0x826BU },
{ 0xFF2DU, 0x826CU },{ 0xFF2EU, 0x826DU },{ 0xFF2FU, 0x826EU },
{ 0xFF30U, 0x826FU },{ 0xFF31U, 0x8270U },{ 0xFF32U, 0x8271U },
{ 0xFF33U, 0x8272U },{ 0xFF34U, 0x8273U },{ 0xFF35U, 0x8274U },
{ 0xFF36U, 0x8275U },{ 0xFF37U, 0x8276U },{ 0xFF38U, 0x8277U },
{ 0xFF39U, 0x8278U },{ 0xFF3AU, 0x8279U },{ 0xFF3BU, 0x816DU },
{ 0xFF3CU, 0x815FU },{ 0xFF3DU, 0x816EU },{ 0xFF3EU, 0x814FU },
{ 0xFF3FU, 0x8151U },{ 0xFF40U, 0x814DU },{ 0xFF41U, 0x8281U },
{ 0xFF42U, 0x8282U },{ 0xFF43U, 0x8283U },{ 0xFF44U, 0x8284U },
{ 0xFF45U, 0x8285U },{ 0xFF46U, 0x8286U },{ 0xFF47U, 0x8287U },
{ 0xFF48U, 0x8288U },{ 0xFF49U, 0x8289U },{ 0xFF4AU, 0x828AU },
{ 0xFF4BU, 0x828BU },{ 0xFF4CU, 0x828CU },{ 0xFF4DU, 0x828DU },
{ 0xFF4EU, 0x828EU },{ 0xFF4FU, 0x828FU },{ 0xFF50U, 0x8290U },
{ 0xFF51U, 0x8291U },{ 0xFF52U, 0x8292U },{ 0xFF53U, 0x8293U },
{ 0xFF54U, 0x8294U },{ 0xFF55U, 0x8295U },{ 0xFF56U, 0x8296U },
{ 0xFF57U, 0x8297U },{ 0xFF58U, 0x8298U },{ 0xFF59U, 0x8299U },
{ 0xFF5AU, 0x829AU },{ 0xFF5BU, 0x816FU },{ 0xFF5CU, 0x8162U },
{ 0xFF5DU, 0x8170U },{ 0xFF5EU, 0x8160U },{ 0xFF61U, 0x00A1U },
{ 0xFF62U, 0x00A2U },{ 0xFF63U, 0x00A3U },{ 0xFF64U, 0x00A4U },
{ 0xFF65U, 0x00A5U },{ 0xFF66U, 0x00A6U },{ 0xFF67U, 0x00A7U },
{ 0xFF68U, 0x00A8U },{ 0xFF69U, 0x00A9U },{ 0xFF6AU, 0x00AAU },
{ 0xFF6BU, 0x00ABU },{ 0xFF6CU, 0x00ACU },{ 0xFF6DU, 0x00ADU },
{ 0xFF6EU, 0x00AEU },{ 0xFF6FU, 0x00AFU },{ 0xFF70U, 0x00B0U },
{ 0xFF71U, 0x00B1U },{ 0xFF72U, 0x00B2U },{ 0xFF73U, 0x00B3U },
{ 0xFF74U, 0x00B4U },{ 0xFF75U, 0x00B5U },{ 0xFF76U, 0x00B6U },
{ 0xFF77U, 0x00B7U },{ 0xFF78U, 0x00B8U },{ 0xFF79U, 0x00B9U },
{ 0xFF7AU, 0x00BAU },{ 0xFF7BU, 0x00BBU },{ 0xFF7CU, 0x00BCU },
{ 0xFF7DU, 0x00BDU },{ 0xFF7EU, 0x00BEU },{ 0xFF7FU, 0x00BFU },
{ 0xFF80U, 0x00C0U },{ 0xFF81U, 0x00C1U },{ 0xFF82U, 0x00C2U },
{ 0xFF83U, 0x00C3U },{ 0xFF84U, 0x00C4U },{ 0xFF85U, 0x00C5U },
{ 0xFF86U, 0x00C6U },{ 0xFF87U, 0x00C7U },{ 0xFF88U, 0x00C8U },
{ 0xFF89U, 0x00C9U },{ 0xFF8AU, 0x00CAU },{ 0xFF8BU, 0x00CBU },
{ 0xFF8CU, 0x00CCU },{ 0xFF8DU, 0x00CDU },{ 0xFF8EU, 0x00CEU },
{ 0xFF8FU, 0x00CFU },{ 0xFF90U, 0x00D0U },{ 0xFF91U, 0x00D1U },
{ 0xFF92U, 0x00D2U },{ 0xFF93U, 0x00D3U },{ 0xFF94U, 0x00D4U },
{ 0xFF95U, 0x00D5U },{ 0xFF96U, 0x00D6U },{ 0xFF97U, 0x00D7U },
{ 0xFF98U, 0x00D8U },{ 0xFF99U, 0x00D9U },{ 0xFF9AU, 0x00DAU },
{ 0xFF9BU, 0x00DBU },{ 0xFF9CU, 0x00DCU },{ 0xFF9DU, 0x00DDU },
{ 0xFF9EU, 0x00DEU },{ 0xFF9FU, 0x00DFU },{ 0xFFE0U, 0x8191U },
{ 0xFFE1U, 0x8192U },{ 0xFFE2U, 0xFA54U },{ 0xFFE3U, 0x8150U },
{ 0xFFE4U, 0xFA55U },{ 0xFFE5U, 0x818FU },};

//---------------------------------------------------------------------------
/**
 * UNICODEとShiftJISコードの組の数
 */
#define NumUnicodeAndSJISPair \
	(sizeof(UnicodeAndSJISPair) / sizeof(UnicodeAndSJISPair[0]))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
/**
 * UNICODEをShiftJIS(CP932)に変換する
 * @param in	変換したい文字
 * @return	変換されたShiftJIS文字(0=変換失敗)
 * @note	ShiftJIS 文字は 16bit 数値で返される(実際の戻り値の型はtjs_uint)
 * @note	が、いわゆる半角文字の場合は上位8ビットは0、いわゆる全角文字は
 * @note	ShiftJISコードがそのまま入る。
 */
tjs_uint UnicodeToSJIS(tjs_char in)
{
	// UnicodeAndSJISPair に対して二分検索を行う
	if(in >= 0x10000) return 0;
		// 0x10000 以上のコードポイントに対してはSJIS文字変換は定義されていない

	tjs_uint s = 0, e = NumUnicodeAndSJISPair;
	while(e - s > 1)
	{
		tjs_int m = (s + e) / 2;
		if(UnicodeAndSJISPair[m].Unicode <= static_cast<tjs_uint16>(in))
			s = m;
		else
			e = m;
	}
	if(UnicodeAndSJISPair[s].Unicode == static_cast<tjs_uint16>(in))
		return UnicodeAndSJISPair[s].SJIS; // 見つかった
	return 0;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
/**
 * UNICODE文字列をCP932に変換する
 * @param in	入力 UNICODE 文字列
 * @param out	出力 CP932文字列 (NULLの場合は書き込まれない)
 * @return	出力された文字数
 *			(最後に\0は書き込まれないしその文字数も含まれないので注意)
 *			(tjs_size)-1 = 異常な文字が見つかった
 */
tjs_size UnicodeToSJISString(const tjs_char *in, tjs_nchar* out )
{
	tjs_size count = 0;
	while(*in)
	{
		tjs_uint c = UnicodeToSJIS(*in);
		if( c == 0 )
			return static_cast<tjs_size>(-1); // invalid character found
		if(out)
		{
			if( c & 0xff00 )
				*out++ = static_cast<tjs_nchar>((c>>8)&0xff);
			*out++ = static_cast<tjs_nchar>( c&0xff );
		}
		if( c & 0xff00 )
			count++;
		count++;
		in++;
	}
	return count;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
/**
 * UNICODE文字列をCP932に変換する
 * @param in	入力 UNICODE 文字列
 * @param out	出力 CP932文字列 (NULLの場合は書き込まれない)
 * @param limit 出力バッファサイズ
 * @return	出力された文字数
 *			(最後に\0は書き込まれないしその文字数も含まれないので注意)
 *			(tjs_size)-1 = 異常な文字が見つかった
 */
tjs_size UnicodeToSJISString(const tjs_char *in, tjs_nchar* out, tjs_size limit )
{
	if( out == NULL ) return UnicodeToSJISString(in,NULL);

	tjs_size count = 0;
	while( (*in) && count < limit )
	{
		tjs_uint c = UnicodeToSJIS(*in);
		if( c == 0 )
			return static_cast<tjs_size>(-1); // invalid character found
		if( c & 0xff00 )
		{
			if( (count+1) >= limit )
				break;
			*out++ = static_cast<tjs_nchar>((c>>8)&0xff);
			count++;
		}
		*out++ = static_cast<tjs_nchar>( c&0xff );
		count++;
		in++;
	}
	return count;
}
//---------------------------------------------------------------------------
#ifdef SELFTEST

#include <stdio.h>
#include "cp932_uni.h"

int main(void)
{
	for(tjs_uint i = 1; i < 65536; i++)
	{
		tjs_uint sjis = UnicodeToSJIS(i);
		if(sjis == 0) continue;
		tjs_uint uni_out = SJISToUnicode(sjis);
		if(uni_out != i)
		{
			printf("fail: uni input:%x, sjis:%x, uni output:%x\n",
				i, sjis, uni_out);
		}
	}
}

#endif

