#include "tjsCommHead.h"
#include "tjsError.h"
#include "MsgIntf.h"

static bool loaded_messages = false;

void TVPLoadMessage()
{
	if( loaded_messages ) return;
	loaded_messages = true;
	TJSInternalError.AssignMessage(TJS_W("Internal error"));
	TJSWarning.AssignMessage(TJS_W("Warning: "));
	TJSWarnEvalOperator.AssignMessage(TJS_W("Non-global post-! operator is used (note that the post-! operator behavior is changed on TJS2 version 2.4.1)"));
	TJSNarrowToWideConversionError.AssignMessage(TJS_W("Cannot convert given narrow string to wide string"));
	TJSVariantConvertError.AssignMessage(TJS_W("Cannot convert the variable type (%1 to %2)"));
	TJSVariantConvertErrorToObject.AssignMessage(TJS_W("Cannot convert the variable type (%1 to Object)"));
	TJSIDExpected.AssignMessage(TJS_W("Specify an ID"));
	TJSSubstitutionInBooleanContext.AssignMessage(TJS_W("Substitution in boolean context (use form of '(A=B)!=0' to compare to zero)"));
	TJSCannotModifyLHS.AssignMessage(TJS_W("This expression cannot be used as a lvalue"));
	TJSInsufficientMem.AssignMessage(TJS_W("Insufficient memory"));
	TJSCannotGetResult.AssignMessage(TJS_W("Cannot get the value of this expression"));
	TJSNullAccess.AssignMessage(TJS_W("Accessing to null object"));
	TJSMemberNotFound.AssignMessage(TJS_W("Member \"%1\" does not exist"));
	TJSMemberNotFoundNoNameGiven.AssignMessage(TJS_W("Member does not exist"));
	TJSNotImplemented.AssignMessage(TJS_W("Called method is not implemented"));
	TJSInvalidParam.AssignMessage(TJS_W("Invalid argument"));
	TJSBadParamCount.AssignMessage(TJS_W("Invalid argument count"));
	TJSInvalidType.AssignMessage(TJS_W("Not a function or invalid method/property type"));
	TJSSpecifyDicOrArray.AssignMessage(TJS_W("Specify a Dictionary object or an Array object"));
	TJSSpecifyArray.AssignMessage(TJS_W("Specify an Array object"));
	TJSStringDeallocError.AssignMessage(TJS_W("Cannot free the string memory block"));
	TJSStringAllocError.AssignMessage(TJS_W("Cannot allocate the string memory block"));
	TJSMisplacedBreakContinue.AssignMessage(TJS_W("Cannot place \"break\" or \"continue\" here"));
	TJSMisplacedCase.AssignMessage(TJS_W("Cannot place \"case\" here"));
	TJSMisplacedReturn.AssignMessage(TJS_W("Cannot place \"return\" here"));
	TJSStringParseError.AssignMessage(TJS_W("Un-terminated string/regexp/octet literal"));
	TJSNumberError.AssignMessage(TJS_W("Cannot be parsed as a number"));
	TJSUnclosedComment.AssignMessage(TJS_W("Un-terminated comment"));
	TJSInvalidChar.AssignMessage(TJS_W("Invalid character \'%1\'"));
	TJSExpected.AssignMessage(TJS_W("Expected %1"));
	TJSSyntaxError.AssignMessage(TJS_W("Syntax error (%1)"));
	TJSPPError.AssignMessage(TJS_W("Error in conditional compiling expression"));
	TJSCannotGetSuper.AssignMessage(TJS_W("Super class does not exist or cannot specify the super class"));
	TJSInvalidOpecode.AssignMessage(TJS_W("Invalid VM code"));
	TJSRangeError.AssignMessage(TJS_W("The value is out of the range"));
	TJSAccessDenyed.AssignMessage(TJS_W("Invalid operation for Read-only or Write-only property"));
	TJSNativeClassCrash.AssignMessage(TJS_W("Invalid object context"));
	TJSInvalidObject.AssignMessage(TJS_W("The object is already invalidated"));
	TJSCannotOmit.AssignMessage(TJS_W("\"...\" is used out of functions"));
	TJSCannotParseDate.AssignMessage(TJS_W("Invalid date format"));
	TJSInvalidValueForTimestamp.AssignMessage(TJS_W("Invalid value for date/time"));
	TJSExceptionNotFound.AssignMessage(TJS_W("Cannot convert exception because \"Exception\" does not exist"));
	TJSInvalidFormatString.AssignMessage(TJS_W("Invalid format string"));
	TJSDivideByZero.AssignMessage(TJS_W("Division by zero"));
	TJSNotReconstructiveRandomizeData.AssignMessage(TJS_W("Cannot reconstruct random seeds"));
	TJSSymbol.AssignMessage(TJS_W("ID"));
	TJSCallHistoryIsFromOutOfTJS2Script.AssignMessage(TJS_W("[out of TJS2 script]"));
	TJSNObjectsWasNotFreed.AssignMessage(TJS_W("Total %1 Object(s) was not freed"));
	TJSObjectCreationHistoryDelimiter.AssignMessage(TJS_W(" <-- "));
	TJSObjectWasNotFreed.AssignMessage(TJS_W("Object %1 [%2] wes not freed / The object was created at : %2"));
	TJSGroupByObjectTypeAndHistory.AssignMessage(TJS_W("Group by object type and location where the object was created"));
	TJSGroupByObjectType.AssignMessage(TJS_W("Group by object type"));
	TJSObjectCountingMessageGroupByObjectTypeAndHistory.AssignMessage(TJS_W("%1 time(s) : [%2] %3"));
	TJSObjectCountingMessageTJSGroupByObjectType.AssignMessage(TJS_W("%1 time(s) : [%2]"));
	TJSWarnRunningCodeOnDeletingObject.AssignMessage(TJS_W("%4: Running code on deleting-in-progress object %1[%2] / The object was created at : %3"));
	TJSWriteError.AssignMessage(TJS_W("Write error"));
	TJSReadError.AssignMessage(TJS_W("Read error"));
	TJSSeekError.AssignMessage(TJS_W("Seek error"));
	TJSByteCodeBroken.AssignMessage(TJS_W("Bytecode read error. File is broken or it's not bytecode file."));
	TJSObjectHashMapLogVersionMismatch.AssignMessage(TJS_W("Object Hash Map log version mismatch"));
	TJSCurruptedObjectHashMapLog.AssignMessage(TJS_W("Currupted Object Hash Map log"));
	TJSUnknownFailure.AssignMessage(TJS_W("Unknown failure : %08X"));
	TJSUnknownPackUnpackTemplateCharcter.AssignMessage(TJS_W("Unknown pack/unpack TEMPLATE charcter"));
	TJSUnknownBitStringCharacter.AssignMessage(TJS_W("Unknown bit string charcter"));
	TJSUnknownHexStringCharacter.AssignMessage(TJS_W("Unknown Hex string charcter"));
	TJSNotSupportedUuencode.AssignMessage(TJS_W("Not supported uuencode"));
	TJSNotSupportedBER.AssignMessage(TJS_W("Not supported BER"));
	TJSNotSupportedUnpackLP.AssignMessage(TJS_W("Not supported unpack \'p\'"));
	TJSNotSupportedUnpackP.AssignMessage(TJS_W("Not supported unpack \'P\'"));
	TVPVersionInformation.AssignMessage(TJS_W("Kirikiri SDL2 Executable core /%1 (Compiled on %DATE% %TIME%) TJS2/%2 Copyright (C) 1997-2013 W.Dee and contributors All rights reserved."));
	TVPVersionInformation2.AssignMessage(TJS_W("The details of version information can be perused if -about is attached and started. "));
	TVPDownloadPageURL.AssignMessage(TJS_W("https://github.com/uyjulian/krkrsdl2"));
	TVPInternalError.AssignMessage(TJS_W("Internal Error: at %1 line %2"));
	TVPInvalidParam.AssignMessage(TJS_W("Invalid Parameter"));
	TVPWarnDebugOptionEnabled.AssignMessage(TJS_W("Debug option enabled"));
	TVPCommandLineParamIgnoredAndDefaultUsed.AssignMessage(TJS_W("Command line parameter %1 = %2 is invalid. It's used default."));
	TVPInvalidCommandLineParam.AssignMessage(TJS_W("Command line parameter %1 = %2 is invalid."));
	TVPNotImplemented.AssignMessage(TJS_W("Not implemented"));
	TVPCannotOpenStorage.AssignMessage(TJS_W("Cannot open storage %1"));
	TVPCannotFindStorage.AssignMessage(TJS_W("Cannot find storage %1"));
	TVPCannotOpenStorageForWrite.AssignMessage(TJS_W("Cannot open storage %1 for writing"));
	TVPStorageInArchiveNotFound.AssignMessage(TJS_W("Cannot find storage %1 in archive %2"));
	TVPInvalidPathName.AssignMessage(TJS_W("Invalid path name %1"));
	TVPUnsupportedMediaName.AssignMessage(TJS_W("Not supported media type \"%1\""));
	TVPCannotUnbindXP3EXE.AssignMessage(TJS_W("Cannot unbind XP3 exe %1"));
	TVPCannotFindXP3Mark.AssignMessage(TJS_W("%1 is not XP3 archive or unsupported"));
	TVPMissingPathDelimiterAtLast.AssignMessage(TJS_W("Use path delimiter '>' or '/'"));
	TVPFilenameContainsSharpWarn.AssignMessage(TJS_W("(Attention) Filename \"%1\" contains '#'"));
	TVPCannotGetLocalName.AssignMessage(TJS_W("Cannot get local name from %1"));
	TVPReadError.AssignMessage(TJS_W("Read error"));
	TVPWriteError.AssignMessage(TJS_W("Write error"));
	TVPSeekError.AssignMessage(TJS_W("Seek error"));
	TVPTruncateError.AssignMessage(TJS_W("Truncate error"));
	TVPInsufficientMemory.AssignMessage(TJS_W("Cannot allocate memory"));
	TVPUncompressionFailed.AssignMessage(TJS_W("Unpompression failed"));
	TVPCompressionFailed.AssignMessage(TJS_W("Compression failed"));
	TVPCannotWriteToArchive.AssignMessage(TJS_W("Cannot write to archive"));
	TVPUnsupportedCipherMode.AssignMessage(TJS_W("%1 is unsupported cipger mode"));
	TVPUnsupportedEncoding.AssignMessage(TJS_W("%1 is unsupported encoding"));
	TVPUnsupportedModeString.AssignMessage(TJS_W("%1 is unsupported mode string"));
	TVPUnknownGraphicFormat.AssignMessage(TJS_W("Unknown graphic format %1"));
	TVPCannotSuggestGraphicExtension.AssignMessage(TJS_W("Cannot suggest graphics extension for %1"));
	TVPMaskSizeMismatch.AssignMessage(TJS_W("Mask size mismath"));
	TVPProvinceSizeMismatch.AssignMessage(TJS_W("Province image %1 size mismatch"));
	TVPImageLoadError.AssignMessage(TJS_W("Image Load Error /%1"));
	TVPJPEGLoadError.AssignMessage(TJS_W("JPEG Read Error /%1"));
	TVPPNGLoadError.AssignMessage(TJS_W("PNG Read Error /%1"));
	TVPERILoadError.AssignMessage(TJS_W("ERI Read Error /%1"));
	TVPTLGLoadError.AssignMessage(TJS_W("TLG Read Error /%1"));
	TVPInvalidImageSaveType.AssignMessage(TJS_W("Invalid image save type (%1)"));
	TVPInvalidOperationFor8BPP.AssignMessage(TJS_W("Invalid operation for 8bpp"));
	TVPInvalidOperationFor32BPP.AssignMessage(TJS_W("Invalid operation for 32bpp"));
	TVPSpecifyWindow.AssignMessage(TJS_W("Specify Window class object"));
	TVPSpecifyLayer.AssignMessage(TJS_W("Specify Layer class object"));
	TVPSpecifyLayerOrBitmap.AssignMessage(TJS_W("Specify Layer or Bitmap class object"));
	TVPCannotAcceptModeAuto.AssignMessage(TJS_W("Cannot accept omAuto mode"));
	TVPCannotCreateEmptyLayerImage.AssignMessage(TJS_W("Cannot create empty layer image"));
	TVPCannotSetPrimaryInvisible.AssignMessage(TJS_W("Cannot set primary layer invisible"));
	TVPCannotMovePrimary.AssignMessage(TJS_W("Cannot move primary layer"));
	TVPCannotSetParentSelf.AssignMessage(TJS_W("Cannot set parent self"));
	TVPCannotMoveNextToSelfOrNotSiblings.AssignMessage(TJS_W("Cannot move next to self or not siblings"));
	TVPCannotMovePrimaryOrSiblingless.AssignMessage(TJS_W("Cannot move primary or siblingless"));
	TVPCannotMoveToUnderOtherPrimaryLayer.AssignMessage(TJS_W("Cannot move to under Other primary layer"));
	TVPInvalidImagePosition.AssignMessage(TJS_W("Invalid Image position"));
	TVPCannotSetModeToDisabledOrModal.AssignMessage(TJS_W("Cannot set Mode to disabled or modal"));
	TVPNotDrawableLayerType.AssignMessage(TJS_W("Not drawable layer type"));
	TVPSourceLayerHasNoImage.AssignMessage(TJS_W("Source layer has no image"));
	TVPUnsupportedLayerType.AssignMessage(TJS_W("Unsupported layer type %1"));
	TVPNotDrawableFaceType.AssignMessage(TJS_W("Not drawble face type %1"));
	TVPCannotConvertLayerTypeUsingGivenDirection.AssignMessage(TJS_W("Cannot convert layer type using given direction"));
	TVPNegativeOpacityNotSupportedOnThisFace.AssignMessage(TJS_W("Negative opacity not supported on this face"));
	TVPSrcRectOutOfBitmap.AssignMessage(TJS_W("Source rectangle out of bitmap"));
	TVPBoxBlurAreaMustContainCenterPixel.AssignMessage(TJS_W("Box blur area must contain center pixel"));
	TVPBoxBlurAreaMustBeSmallerThan16Million.AssignMessage(TJS_W("Box blur area must be smaller than 16 million"));
	TVPCannotChangeFocusInProcessingFocus.AssignMessage(TJS_W("Cannot change focus in processing focus"));
	TVPWindowHasNoLayer.AssignMessage(TJS_W("Window has no layer"));
	TVPWindowHasAlreadyPrimaryLayer.AssignMessage(TJS_W("Window has already primary layer"));
	TVPSpecifiedEventNeedsParameter.AssignMessage(TJS_W("Specified event %1 needs parameter"));
	TVPSpecifiedEventNeedsParameter2.AssignMessage(TJS_W("Specified event %1 needs parameter %2"));
	TVPSpecifiedEventNameIsUnknown.AssignMessage(TJS_W("Specified event name %1 is unknown"));
	TVPOutOfRectangle.AssignMessage(TJS_W("Out of Rectangle"));
	TVPInvalidMethodInUpdating.AssignMessage(TJS_W("Invalid method in updating"));
	TVPCannotCreateInstance.AssignMessage(TJS_W("Cannot create instance"));
	TVPUnknownWaveFormat.AssignMessage(TJS_W("Unknown wave format %1"));
	TVPCurrentTransitionMustBeStopping.AssignMessage(TJS_W("Current transition must be stopping"));
	TVPTransHandlerError.AssignMessage(TJS_W("Transition handler error %1"));
	TVPTransAlreadyRegistered.AssignMessage(TJS_W("Transition %1 already registerd"));
	TVPCannotFindTransHander.AssignMessage(TJS_W("Cannot find transition handler %1"));
	TVPSpecifyTransitionSource.AssignMessage(TJS_W("Specify transition source"));
	TVPLayerCannotHaveImage.AssignMessage(TJS_W("This layer cannot have image"));
	TVPTransitionSourceAndDestinationMustHaveImage.AssignMessage(TJS_W("Transition source and destination must have image"));
	TVPCannotLoadRuleGraphic.AssignMessage(TJS_W("Cannot load rule graphics %1"));
	TVPSpecifyOption.AssignMessage(TJS_W("Specify option %1"));
	TVPTransitionLayerSizeMismatch.AssignMessage(TJS_W("Transition layer size mismatch %1 and %2"));
	TVPTransitionMutualSource.AssignMessage(TJS_W("Transition mutual source"));
	TVPHoldDestinationAlphaParameterIsNowDeprecated.AssignMessage(TJS_W("Warring : Method %1 %2th parameter had is ignore. Hold destination alpha parameter is now deprecated."));
	TVPCannotConnectMultipleWaveSoundBufferAtOnce.AssignMessage(TJS_W("Cannot connect multiple wave sound buffer at once"));
	TVPInvalidWindowSizeMustBeIn64to32768.AssignMessage(TJS_W("Invalid window size must be in 64 to 32768"));
	TVPInvalidOverlapCountMustBeIn2to32.AssignMessage(TJS_W("Invalid overlap count must be in 2 to 32"));
	TVPCurrentlyAsyncLoadBitmap.AssignMessage(TJS_W("Currently async load bitmap"));
	TVPFaildClipboardCopy.AssignMessage(TJS_W("copying to clipboard failed."));
	TVPInvalidUTF16ToUTF8.AssignMessage(TJS_W("Invalid UTF-16 to UTF-8"));
	TVPInfoLoadingStartupScript.AssignMessage(TJS_W("(info) Loading startup script : "));
	TVPInfoStartupScriptEnded.AssignMessage(TJS_W("(info) Startup script ended."));
	TVPTjsCharMustBeTwoOrFour.AssignMessage(TJS_W("sizeof(tjs_char) must be 2 or 4."));
	TVPMediaNameHadAlreadyBeenRegistered.AssignMessage(TJS_W("Media name \"%1\" had already been registered"));
	TVPMediaNameIsNotRegistered.AssignMessage(TJS_W("Media name \"%1\" is not registered"));
	TVPInfoRebuildingAutoPath.AssignMessage(TJS_W("(info) Rebuilding Auto Path Table ..."));
	TVPInfoTotalFileFoundAndActivated.AssignMessage(TJS_W("(info) Total %1 file(s) found, %2 file(s) activated. (%3ms)"));
	TVPErrorInRetrievingSystemOnActivateOnDeactivate.AssignMessage(TJS_W("Error in retrieving System.onActivate/onDeactivate : %1"));
	TVPTheHostIsNotA16BitUnicodeSystem.AssignMessage(TJS_W("The host is not a 16-bit unicode system."));
	TVPInfoTryingToReadXp3VirtualFileSystemInformationFrom.AssignMessage(TJS_W("(info) Trying to read XP3 virtual file system information from : %1"));
	TVPSpecifiedStorageHadBeenProtected.AssignMessage(TJS_W("Specified storage had been protected!"));
	TVPInfoFailed.AssignMessage(TJS_W("(info) Failed."));
	TVPInfoDoneWithContains.AssignMessage(TJS_W("(info) Done. (contains %1 file(s), %2 segment(s))"));
	TVPSeparatorCRLF.AssignMessage(TJS_W("\r\n\r\n\r\n==============================================================================\r\n==============================================================================\r\n"));
	TVPSeparatorCR.AssignMessage(TJS_W("\n\n\n==============================================================================\n==============================================================================\n"));
	TVPDefaultFontName.AssignMessage(TJS_W("DEFAULT_GUI_FONT"));
	TVPCannotOpenFontFile.AssignMessage(TJS_W("Can't open font file '%1$s'"));
	TVPFontCannotBeUsed.AssignMessage(TJS_W("Font '%1$s' cannot be used"));
	TVPFontRasterizeError.AssignMessage(TJS_W("Font Rasterize error."));
	TVPBitFieldsNotSupported.AssignMessage(TJS_W("BITFIELDS not supported."));
	TVPCompressedBmpNotSupported.AssignMessage(TJS_W("Compressed BMP not supported."));
	TVPUnsupportedColorModeForPalettImage.AssignMessage(TJS_W("Unsupported color mode for palettized image."));
	TVPNotWindowsBmp.AssignMessage(TJS_W("This is not a Windows BMP file or an OS/2 BMP file."));
	TVPUnsupportedHeaderVersion.AssignMessage(TJS_W("Non-supported header version."));
	TVPInfoTouching.AssignMessage(TJS_W("(info) Touching "));
	TVPAbortedTimeOut.AssignMessage(TJS_W(" ... aborted [timed out]"));
	TVPAbortedLimitByte.AssignMessage(TJS_W(" ... aborted [limit bytes exceeded]"));
	TVPFaildGlyphForDrawGlyph.AssignMessage(TJS_W("Faild glyph for DrawGlyph."));
	TVPLayerObjectIsNotProperlyConstructed.AssignMessage(TJS_W("Panic! Layer object is not properly constructed. The constructor was not called??"));
	TVPUnknownUpdateType.AssignMessage(TJS_W("Unknown update type"));
	TVPUnknownTransitionType.AssignMessage(TJS_W("Unknown transition type"));
	TVPUnsupportedUpdateTypeTutGiveUpdate.AssignMessage(TJS_W("Update type of tutGiveUpdate is not yet supported"));
	TVPErrorCode.AssignMessage(TJS_W("error code : "));
	TVPUnsupportedJpegPalette.AssignMessage(TJS_W("JPEG does not support palettized image"));
	TVPLibpngError.AssignMessage(TJS_W("libpng error."));
	TVPUnsupportedColorTypePalette.AssignMessage(TJS_W("Unsupported color type for palattized image"));
	TVPUnsupportedColorType.AssignMessage(TJS_W("Unsupported color type"));
	TVPTooLargeImage.AssignMessage(TJS_W("Too large image"));
	TVPPngSaveError.AssignMessage(TJS_W("PNG save error."));
	TVPTlgUnsupportedUniversalTransitionRule.AssignMessage(TJS_W("TLG cannot be used as universal transition rule, province(_p) or mask(_m) images."));
	TVPUnsupportedColorCount.AssignMessage(TJS_W("Unsupported color count : "));
	TVPDataFlagMustBeZero.AssignMessage(TJS_W("Data flag must be 0 (any flags are not yet supported)"));
	TVPUnsupportedColorTypeColon.AssignMessage(TJS_W("Unsupported color type : "));
	TVPUnsupportedExternalGolombBitLengthTable.AssignMessage(TJS_W("External golomb bit length table is not yet supported."));
	TVPUnsupportedEntropyCodingMethod.AssignMessage(TJS_W("Unsupported entropy coding method"));
	TVPInvalidTlgHeaderOrVersion.AssignMessage(TJS_W("Invalid TLG header or unsupported TLG version."));
	TVPTlgMalformedTagMissionColonAfterNameLength.AssignMessage(TJS_W("Malformed TLG SDS tag structure, missing colon after name length"));
	TVPTlgMalformedTagMissionEqualsAfterName.AssignMessage(TJS_W("Malformed TLG SDS tag structure, missing equals after name"));
	TVPTlgMalformedTagMissionColonAfterVaueLength.AssignMessage(TJS_W("Malformed TLG SDS tag structure, missing colon after value length"));
	TVPTlgMalformedTagMissionCommaAfterTag.AssignMessage(TJS_W("Malformed TLG SDS tag structure, missing comma after a tag"));
	TVPFileSizeIsZero.AssignMessage(TJS_W("File size is zero."));
	TVPMemoryAllocationError.AssignMessage(TJS_W("Memory allocation error."));
	TVPFileReadError.AssignMessage(TJS_W("File read error."));
	TVPInvalidPrerenderedFontFile.AssignMessage(TJS_W("Signature not found or invalid pre-rendered font file."));
	TVPNot16BitUnicodeFontFile.AssignMessage(TJS_W("Not a 16-bit UNICODE font file."));
	TVPInvalidHeaderVersion.AssignMessage(TJS_W("Invalid header version."));
	TVPTlgInsufficientMemory.AssignMessage(TJS_W("SaveTLG6: Insufficient memory"));
	TVPTlgTooLargeBitLength.AssignMessage(TJS_W("SaveTLG6: Too large bit length (given image may be too large)"));
	TVPCannotRetriveInterfaceFromDrawDevice.AssignMessage(TJS_W("Could not retrive interface from given draw device"));
	TVPIllegalCharacterConversionUTF16toUTF8.AssignMessage(TJS_W("Illegal character conversion. UTF-16 to UTF-8."));
	TVPRequireLayerTreeOwnerInterfaceInterface.AssignMessage(TJS_W("require layerTreeOwnerInterface interface"));
	TVPScriptExceptionRaised.AssignMessage(TJS_W("Script exception raised"));
	TVPHardwareExceptionRaised.AssignMessage(TJS_W("Hardware exception raised"));
	TVPMainCDPName.AssignMessage(TJS_W("Script Editor (Main)"));
	TVPExceptionCDPName.AssignMessage(TJS_W("Script Editor (Exception)"));
	TVPCannnotLocateUIDLLForFolderSelection.AssignMessage(TJS_W("Not found krdevui.dll"));
	TVPInvalidUIDLL.AssignMessage(TJS_W("Invalid krdevui.dll"));
	TVPInvalidBPP.AssignMessage(TJS_W("Invalid bpp"));
	TVPCannotLoadPlugin.AssignMessage(TJS_W("Cannot load Plugin %1"));
	TVPNotValidPlugin.AssignMessage(TJS_W("Not valid plugin %1"));
	TVPPluginUninitFailed.AssignMessage(TJS_W("Faild to release plugin"));
	TVPCannnotLinkPluginWhilePluginLinking.AssignMessage(TJS_W("Cannot link plugin while plugin linking"));
	TVPNotSusiePlugin.AssignMessage(TJS_W("Not Susie Plugin"));
	TVPSusiePluginError.AssignMessage(TJS_W("Susie Plugin error : %1"));
	TVPCannotReleasePlugin.AssignMessage(TJS_W("Cannot release plugin"));
	TVPNotLoadedPlugin.AssignMessage(TJS_W("Not loaded plugin %1"));
	TVPCannotAllocateBitmapBits.AssignMessage(TJS_W("Cannot allocate memory for Bitmap : %1 (size=%2)"));
	TVPScanLineRangeOver.AssignMessage(TJS_W("Scan line %1 is range over (0 to %2)"));
	TVPPluginError.AssignMessage(TJS_W("Plugin Error : %1"));
	TVPInvalidCDDADrive.AssignMessage(TJS_W("Invalid CD-DA Drive"));
	TVPCDDADriveNotFound.AssignMessage(TJS_W("CD-DA Drive not found"));
	TVPMCIError.AssignMessage(TJS_W("MCI Error : %1"));
	TVPInvalidSMF.AssignMessage(TJS_W("Invalid SMF : %1"));
	TVPMalformedMIDIMessage.AssignMessage(TJS_W("Malformed MIDI Message"));
	TVPCannotInitDirectSound.AssignMessage(TJS_W("DirectSound Initialize file : %1"));
	TVPCannotCreateDSSecondaryBuffer.AssignMessage(TJS_W("Cannot create DirectSound secondary buffer : %1/%2"));
	TVPInvalidLoopInformation.AssignMessage(TJS_W("Invalid loop information %1"));
	TVPNotChildMenuItem.AssignMessage(TJS_W("Not child menu Item"));
	TVPCannotInitDirect3D.AssignMessage(TJS_W("Cannot initialize Direct3D : %1"));
	TVPCannotFindDisplayMode.AssignMessage(TJS_W("Cannot find display mode : %1"));
	TVPCannotSwitchToFullScreen.AssignMessage(TJS_W("Cannot switch to fullscreen : %1"));
	TVPInvalidPropertyInFullScreen.AssignMessage(TJS_W("Invalid property in fullscreen : %1"));
	TVPInvalidMethodInFullScreen.AssignMessage(TJS_W("Invalid method in fullscreen : %1"));
	TVPCannotLoadCursor.AssignMessage(TJS_W("Cannot load mouse cursor : %1"));
	TVPCannotLoadKrMovieDLL.AssignMessage(TJS_W("Cannot load krmovie.dll"));
	TVPInvalidKrMovieDLL.AssignMessage(TJS_W("Invalid krmovie.dll"));
	TVPErrorInKrMovieDLL.AssignMessage(TJS_W("Error in krmovie.dll : %1"));
	TVPWindowAlreadyMissing.AssignMessage(TJS_W("Window already missing"));
	TVPPrerenderedFontMappingFailed.AssignMessage(TJS_W("Prerendered font mapping failed : %1"));
	TVPConfigFailOriginalFileCannotBeRewritten.AssignMessage(TJS_W("Cannot write %1."));
	TVPConfigFailTempExeNotErased.AssignMessage(TJS_W("Did not exit %1. Cannot delete file."));
	TVPExecutionFail.AssignMessage(TJS_W("Cannot execute %1."));
	TVPPluginUnboundFunctionError.AssignMessage(TJS_W("Plugin require %1 funcion. Bat not found function in this file."));
	TVPExceptionHadBeenOccured.AssignMessage(TJS_W(" = (Exception)"));
	TVPConsoleResult.AssignMessage(TJS_W("Console : "));
	TVPInfoListingFiles.AssignMessage(TJS_W("(info) Listing files in %1 …"));
	TVPInfoTotalPhysicalMemory.AssignMessage(TJS_W("(info) Total physical memory : %1"));
	TVPInfoSelectedProjectDirectory.AssignMessage(TJS_W("(info) Selected project directory : %1"));
	TVPTooSmallExecutableSize.AssignMessage(TJS_W("too small executable size."));
	TVPInfoLoadingExecutableEmbeddedOptionsFailed.AssignMessage(TJS_W("(info) Loading executable embedded options failed (ignoring) : %1"));
	TVPInfoLoadingExecutableEmbeddedOptionsSucceeded.AssignMessage(TJS_W("(info) Loading executable embedded options succeeded."));
	TVPFileNotFound.AssignMessage(TJS_W("file not found."));
	TVPInfoLoadingConfigurationFileFailed.AssignMessage(TJS_W("(info) Loading configuration file \"%1\" failed (ignoring) : %2"));
	TVPInfoLoadingConfigurationFileSucceeded.AssignMessage(TJS_W("(info) Loading configuration file \"%1\" succeeded."));
	TVPInfoDataPathDoesNotExistTryingToMakeIt.AssignMessage(TJS_W("(info) Data path does not exist, trying to make it ... %1"));
	TVPOk.AssignMessage(TJS_W("ok."));
	TVPFaild.AssignMessage(TJS_W("failed."));
	TVPInfoDataPath.AssignMessage(TJS_W("(info) Data path : %1"));
	TVPInfoSpecifiedOptionEarlierItemHasMorePriority.AssignMessage(TJS_W("(info) Specified option(s) (earlier item has more priority) :"));
	TVPNone.AssignMessage(TJS_W(" (none)"));
	TVPInfoCpuClockRoughly.AssignMessage(TJS_W("(info) CPU clock (roughly) : %dMHz"));
	TVPProgramStartedOn.AssignMessage(TJS_W("Program started on %1 (%2)"));
	TVPKirikiri.AssignMessage(TJS_W("Kirikiri"));
	TVPUnknownError.AssignMessage(TJS_W("Unknown error!"));
	TVPExitCode.AssignMessage(TJS_W("Exit code: %d\n"));
	TVPFatalError.AssignMessage(TJS_W("Fatal Error"));
	TVPEnableDigitizer.AssignMessage(TJS_W("Enable Digitizer"));
	TVPTouchIntegratedTouch.AssignMessage(TJS_W("The device has an integrated touch digitizer. "));
	TVPTouchExternalTouch.AssignMessage(TJS_W("The device has an external touch digitizer. "));
	TVPTouchIntegratedPen.AssignMessage(TJS_W("The device has an integrated pen digitizer."));
	TVPTouchExternalPen.AssignMessage(TJS_W("The device has an external pen digitizer."));
	TVPTouchMultiInput.AssignMessage(TJS_W("The device supports multiple sources of digitizer input. "));
	TVPTouchReady.AssignMessage(TJS_W("The device is ready to receive digitizer input."));
	TVPCpuCheckFailure.AssignMessage(TJS_W("CPU check failure."));
	TVPCpuCheckFailureCpuFamilyOrLesserIsNotSupported.AssignMessage(TJS_W("CPU check failure: CPU family 4 or lesser is not supported\r\n%1"));
	TVPInfoCpuNumber.AssignMessage(TJS_W("(info) CPU #%1 : "));
	TVPCpuCheckFailureNotSupprtedCpu.AssignMessage(TJS_W("CPU check failure: Not supported CPU\r\n%1"));
	TVPInfoFinallyDetectedCpuFeatures.AssignMessage(TJS_W("(info) finally detected CPU features : %1"));
	TVPCpuCheckFailureNotSupportedCpu.AssignMessage(TJS_W("CPU check failure: Not supported CPU\r\n%1"));
	TVPInfoCpuClock.AssignMessage(TJS_W("(info) CPU clock : %.1fMHz"));
	TVPLayerBitmapBufferUnderrunDetectedCheckYourDrawingCode.AssignMessage(TJS_W("Layer bitmap: Buffer underrun detected. Check your drawing code!"));
	TVPLayerBitmapBufferOverrunDetectedCheckYourDrawingCode.AssignMessage(TJS_W("Layer bitmap: Buffer overrun detected. Check your drawing code!"));
	TVPFaildToCreateDirect3D.AssignMessage(TJS_W("Faild to create Direct3D9."));
	TVPFaildToDecideBackbufferFormat.AssignMessage(TJS_W("Faild to decide backbuffer format."));
	TVPFaildToCreateDirect3DDevice.AssignMessage(TJS_W("Faild to create Direct3D9 Device."));
	TVPFaildToSetViewport.AssignMessage(TJS_W("Faild to set viewport."));
	TVPFaildToSetRenderState.AssignMessage(TJS_W("Faild to set render state."));
	TVPWarningImageSizeTooLargeMayBeCannotCreateTexture.AssignMessage(TJS_W("warning : Image size too large. May be cannot create texture."));
	TVPUsePowerOfTwoSurface.AssignMessage(TJS_W("Use power of two surface."));
	TVPCannotAllocateD3DOffScreenSurface.AssignMessage(TJS_W("Cannot allocate D3D off-screen surface/HR=%1"));
	TVPBasicDrawDeviceFailedToCreateDirect3DDevices.AssignMessage(TJS_W("BasicDrawDevice: Failed to create Direct3D devices: %1"));
	TVPBasicDrawDeviceFailedToCreateDirect3DDevicesUnknownReason.AssignMessage(TJS_W("BasicDrawDevice: Failed to create Direct3D devices: unknown reason"));
	TVPBasicDrawDeviceTextureHasAlreadyBeenLocked.AssignMessage(TJS_W("BasicDrawDevice: Texture has already been locked (StartBitmapCompletion() has been called twice without EndBitmapCompletion()), unlocking the texture."));
	TVPInternalErrorResult.AssignMessage(TJS_W("Internal error/HR=%1"));
	TVPBasicDrawDeviceInfPolygonDrawingFailed.AssignMessage(TJS_W("BasicDrawDevice: (inf) Polygon drawing failed/HR=%1"));
	TVPBasicDrawDeviceInfDirect3DDevicePresentFailed.AssignMessage(TJS_W("BasicDrawDevice: (inf) IDirect3DDevice::Present failed/HR=%1"));
	TVPChangeDisplaySettingsFailedDispChangeRestart.AssignMessage(TJS_W("ChangeDisplaySettings failed: DISP_CHANGE_RESTART"));
	TVPChangeDisplaySettingsFailedDispChangeBadFlags.AssignMessage(TJS_W("ChangeDisplaySettings failed: DISP_CHANGE_BADFLAGS"));
	TVPChangeDisplaySettingsFailedDispChangeBadParam.AssignMessage(TJS_W("ChangeDisplaySettings failed: DISP_CHANGE_BADPARAM"));
	TVPChangeDisplaySettingsFailedDispChangeFailed.AssignMessage(TJS_W("ChangeDisplaySettings failed: DISP_CHANGE_FAILED"));
	TVPChangeDisplaySettingsFailedDispChangeBadMode.AssignMessage(TJS_W("ChangeDisplaySettings failed: DISP_CHANGE_BADMODE"));
	TVPChangeDisplaySettingsFailedDispChangeNotUpdated.AssignMessage(TJS_W("ChangeDisplaySettings failed: DISP_CHANGE_NOTUPDATED"));
	TVPChangeDisplaySettingsFailedUnknownReason.AssignMessage(TJS_W("ChangeDisplaySettings failed: unknown reason (%1)"));
	TVPFailedToCreateScreenDC.AssignMessage(TJS_W("Failed to create screen DC"));
	TVPFailedToCreateOffscreenBitmap.AssignMessage(TJS_W("Failed to create offscreen bitmap"));
	TVPFailedToCreateOffscreenDC.AssignMessage(TJS_W("Failed to create offscreen DC"));
	TVPInfoSusiePluginInfo.AssignMessage(TJS_W("(info) Susie plugin info : %1"));
	TVPSusiePluginUnsupportedBitmapHeader.AssignMessage(TJS_W("Non-supported bitmap header was given from susie plug-in."));
	TVPBasicDrawDeviceFailedToCreateDirect3DDevice.AssignMessage(TJS_W("BasicDrawDevice: Failed to create Direct3D Device: %1"));
	TVPBasicDrawDeviceFailedToCreateDirect3DDeviceUnknownReason.AssignMessage(TJS_W("BasicDrawDevice: Failed to create Direct3D Device: unknown reason"));
	TVPCouldNotCreateAnyDrawDevice.AssignMessage(TJS_W("Fatal: Could not create any drawer objects."));
	TVPBasicDrawDeviceDoesNotSupporteLayerManagerMoreThanOne.AssignMessage(TJS_W("\"basic draw\" device does not support layer manager more than 1"));
	TVPInvalidVideoSize.AssignMessage(TJS_W("Invalid video size"));
	TVPRoughVsyncIntervalReadFromApi.AssignMessage(TJS_W("Rough VSync interval read from API : %1"));
	TVPRoughVsyncIntervalStillSeemsWrong.AssignMessage(TJS_W("Rough VSync interval still seems wrong, assuming default value (16)"));
	TVPInfoFoundDirect3DInterface.AssignMessage(TJS_W("(info) IDirect3D9 or higher detected. Retrieving current Direct3D driver information..."));
	TVPInfoFaild.AssignMessage(TJS_W("(info) Failed."));
	TVPInfoDirect3D.AssignMessage(TJS_W("(info) Loading Direct3D ..."));
	TVPCannotLoadD3DDLL.AssignMessage(TJS_W("Cannot load d3d9.dll"));
	TVPNotFoundDirect3DCreate.AssignMessage(TJS_W("Missing Direct3DCreate9 in d3d9.dll"));
	TVPInfoEnvironmentUsing.AssignMessage(TJS_W("(info) environment: using %1"));
	TVPInfoSearchBestFullscreenResolution.AssignMessage(TJS_W("(info) Searching best fullscreen resolution ..."));
	TVPInfoConditionPreferredScreenMode.AssignMessage(TJS_W("(info) condition: preferred screen mode: %1"));
	TVPInfoConditionMode.AssignMessage(TJS_W("(info) condition: mode: %1"));
	TVPInfoConditionZoomMode.AssignMessage(TJS_W("(info) condition: zoom mode: %1"));
	TVPInfoEnvironmentDefaultScreenMode.AssignMessage(TJS_W("(info) environment: default screen mode: %1"));
	TVPInfoEnvironmentDefaultScreenAspectRatio.AssignMessage(TJS_W("(info) environment: default screen aspect ratio: %1 : %2"));
	TVPInfoEnvironmentAvailableDisplayModes.AssignMessage(TJS_W("(info) environment: available display modes:"));
	TVPInfoNotFoundScreenModeFromDriver.AssignMessage(TJS_W("(info) Panic! There is no reasonable candidate screen mode provided from the driver ... trying to use the default screen size and color depth ..."));
	TVPInfoResultCandidates.AssignMessage(TJS_W("(info) result: candidates:"));
	TVPInfoTryScreenMode.AssignMessage(TJS_W("(info) Trying screen mode: %1"));
	TVPAllScreenModeError.AssignMessage(TJS_W("All screen mode has been tested, but no modes available at all."));
	TVPInfoChangeScreenModeSuccess.AssignMessage(TJS_W("(info) Changing screen mode succeeded"));
	TVPSelectXP3FileOrFolder.AssignMessage(TJS_W("Select XP3 file or folder"));
	TVPD3dErrDeviceLost.AssignMessage(TJS_W("D3D : The device has been lost but cannot be reset at this time."));
	TVPD3dErrDriverIinternalError.AssignMessage(TJS_W("D3D : Internal driver error. Applications should destroy and recreate the device when receiving this error. "));
	TVPD3dErrInvalidCall.AssignMessage(TJS_W("D3D : The method call is invalid. For example, a method's parameter may not be a valid pointer."));
	TVPD3dErrOutOfVideoMemory.AssignMessage(TJS_W("D3D : Direct3D does not have enough display memory to perform the operation. "));
	TVPD3dErrOutOfMemory.AssignMessage(TJS_W("D3D : Direct3D could not allocate sufficient memory to complete the call."));
	TVPD3dErrWrongTextureFormat.AssignMessage(TJS_W("D3D : The pixel format of the texture surface is not valid."));
	TVPD3dErrUnsuportedColorOperation.AssignMessage(TJS_W("D3D : The device does not support a specified texture-blending operation for color values."));
	TVPD3dErrUnsuportedColorArg.AssignMessage(TJS_W("D3D : The device does not support a specified texture-blending argument for color values."));
	TVPD3dErrUnsuportedAalphtOperation.AssignMessage(TJS_W("D3D : The device does not support a specified texture-blending operation for the alpha channel."));
	TVPD3dErrUnsuportedAlphaArg.AssignMessage(TJS_W("D3D : The device does not support a specified texture-blending argument for the alpha channel."));
	TVPD3dErrTooManyOperations.AssignMessage(TJS_W("D3D : The application is requesting more texture-filtering operations than the device supports."));
	TVPD3dErrConflictioningTextureFilter.AssignMessage(TJS_W("D3D : The current texture filters cannot be used together."));
	TVPD3dErrUnsuportedFactorValue.AssignMessage(TJS_W("D3D : The device does not support the specified texture factor value. Not used; provided only to support older drivers."));
	TVPD3dErrConflictioningRenderState.AssignMessage(TJS_W("D3D : The currently set render states cannot be used together."));
	TVPD3dErrUnsupportedTextureFilter.AssignMessage(TJS_W("D3D : The device does not support the specified texture filter."));
	TVPD3dErrConflictioningTexturePalette.AssignMessage(TJS_W("D3D : The current textures cannot be used simultaneously."));
	TVPD3dErrNotFound.AssignMessage(TJS_W("D3D : The requested item was not found."));
	TVPD3dErrMoreData.AssignMessage(TJS_W("D3D : There is more data available than the specified buffer size can hold."));
	TVPD3dErrDeviceNotReset.AssignMessage(TJS_W("D3D : The device has been lost but can be reset at this time."));
	TVPD3dErrNotAvailable.AssignMessage(TJS_W("D3D : This device does not support the queried technique."));
	TVPD3dErrInvalidDevice.AssignMessage(TJS_W("D3D : The requested device type is not valid."));
	TVPD3dErrDriverInvalidCall.AssignMessage(TJS_W("D3D : Not used."));
	TVPD3dErrWasStillDrawing.AssignMessage(TJS_W("D3D : The previous blit operation that is transferring information to or from this surface is incomplete."));
	TVPD3dErrDeviceHung.AssignMessage(TJS_W("D3D : The device that returned this code caused the hardware adapter to be reset by the OS."));
	TVPD3dErrUnsupportedOverlay.AssignMessage(TJS_W("D3D : The device does not support overlay for the specified size or display mode. "));
	TVPD3dErrUnsupportedOverlayFormat.AssignMessage(TJS_W("D3D : The device does not support overlay for the specified surface format. "));
	TVPD3dErrCannotProtectContent.AssignMessage(TJS_W("D3D : The specified content cannot be protected."));
	TVPD3dErrUnsupportedCrypto.AssignMessage(TJS_W("D3D : The specified cryptographic algorithm is not supported."));
	TVPD3dErrPresentStatisticsDisJoint.AssignMessage(TJS_W("D3D : The present statistics have no orderly sequence."));
	TVPD3dErrDeviceRemoved.AssignMessage(TJS_W("D3D : The hardware adapter has been removed."));
	TVPD3dOkNoAutoGen.AssignMessage(TJS_W("D3D : This is a success code. However, the autogeneration of mipmaps is not supported for this format."));
	TVPD3dErrFail.AssignMessage(TJS_W("D3D : An undetermined error occurred inside the Direct3D subsystem."));
	TVPD3dErrInvalidArg.AssignMessage(TJS_W("D3D : An invalid parameter was passed to the returning function."));
	TVPD3dUnknownError.AssignMessage(TJS_W("D3D : Unknown error."));
	TVPExceptionAccessViolation.AssignMessage(TJS_W("Access Violation: The thread attempts to read from or write to a virtual address for which it does not have access."));
	TVPExceptionBreakpoint.AssignMessage(TJS_W("Break Point: A breakpoint is encountered."));
	TVPExceptionDatatypeMisalignment.AssignMessage(TJS_W("Data Type Misalignment: The thread attempts to read or write data that is misaligned on hardware that does not provide alignment. For example, 16-bit values must be aligned on 2-byte boundaries, 32-bit values on 4-byte boundaries, and so on."));
	TVPExceptionSingleStep.AssignMessage(TJS_W("Single Step: A trace trap or other single instruction mechanism signals that one instruction is executed."));
	TVPExceptionArrayBoundsExceeded.AssignMessage(TJS_W("Array Bounds Exceede: The thread attempts to access an array element that is out of bounds, and the underlying hardware supports bounds checking."));
	TVPExceptionFltDenormalOperand.AssignMessage(TJS_W("Denormal Operand: One of the operands in a floating point operation is denormal. A denormal value is one that is too small to represent as a standard floating point value."));
	TVPExceptionFltDivideByZero.AssignMessage(TJS_W("Divide By Zero: The thread attempts to divide a floating point value by a floating point divisor of 0 (zero)."));
	TVPExceptionFltInexactResult.AssignMessage(TJS_W("Inexact Result: The result of a floating point operation cannot be represented exactly as a decimal fraction."));
	TVPExceptionFltInvalidOperation.AssignMessage(TJS_W("Invalid Operation: A floating point exception that is not included in this list."));
	TVPExceptionFltOverflow.AssignMessage(TJS_W("Overflow: The exponent of a floating point operation is greater than the magnitude allowed by the corresponding type."));
	TVPExceptionFltStackCheck.AssignMessage(TJS_W("Stack Check: The stack has overflowed or underflowed, because of a floating point operation."));
	TVPExceptionFltUnderflow.AssignMessage(TJS_W("Underflow: The exponent of a floating point operation is less than the magnitude allowed by the corresponding type."));
	TVPExceptionIntDivideByZero.AssignMessage(TJS_W("Divide By Zero: The thread attempts to divide an integer value by an integer divisor of 0 (zero)."));
	TVPExceptionIntOverflow.AssignMessage(TJS_W("Overflow: The result of an integer operation creates a value that is too large to be held by the destination register. In some cases, this will result in a carry out of the most significant bit of the result. Some operations do not set the carry flag."));
	TVPExceptionPrivInstruction.AssignMessage(TJS_W("Priv Instruction: The thread attempts to execute an instruction with an operation that is not allowed in the current computer mode."));
	TVPExceptionNoncontinuableException.AssignMessage(TJS_W("Noncontinuable Exception: The thread attempts to continue execution after a non-continuable exception occurs."));
	TVPExceptionGuardPage.AssignMessage(TJS_W("Guard Page: The thread accessed memory allocated with the PAGE_GUARD modifier."));
	TVPExceptionIllegalInstruction.AssignMessage(TJS_W("Illegal Instruction: The thread tries to execute an invalid instruction."));
	TVPExceptionInPageError.AssignMessage(TJS_W("In Page Error: The thread tries to access a page that is not present, and the system is unable to load the page. For example, this exception might occur if a network connection is lost while running a program over a network."));
	TVPExceptionInvalidDisposition.AssignMessage(TJS_W("Invalid Disposition: An exception handler returns an invalid disposition to the exception dispatcher. Programmers using a high-level language such as C should never encounter this exception."));
	TVPExceptionInvalidHandle.AssignMessage(TJS_W("Invalid Handle: The thread used a handle to a kernel object that was invalid (probably because it had been closed.)"));
	TVPExceptionStackOverflow.AssignMessage(TJS_W("Stack Overflow: The thread uses up its stack."));
	TVPExceptionUnwindCconsolidate.AssignMessage(TJS_W("Unwind Consolidate: A frame consolidation has been executed."));
	TVPCannotShowModalAreadyShowed.AssignMessage(TJS_W("Cannot Show Modal."));
	TVPCannotShowModalSingleWindow.AssignMessage(TJS_W("Cannot Show Modal. When it is single window."));
}
