// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.dashboard', ['core']);

  angular.module('ajenti.dashboard').run(function(customization) {
    return customization.plugins.dashboard = {
      allowMove: true,
      allowRemove: true,
      allowAdd: true,
      defaultConfig: {
        widgetsLeft: [
          {
            id: 'w1',
            typeId: 'hostname'
          }, {
            id: 'w2',
            typeId: 'cpu'
          }, {
            id: 'w3',
            typeId: 'loadavg'
          }
        ],
        widgetsRight: [
          {
            id: 'w4',
            typeId: 'uptime'
          }, {
            id: 'w5',
            typeId: 'memory'
          }
        ]
      }
    };
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('core').config(function($routeProvider) {
    return $routeProvider.when('/view/dashboard', {
      templateUrl: '/dashboard:resources/partial/index.html',
      controller: 'DashboardIndexController'
    });
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.dashboard').controller('DashboardIndexController', function($scope, $interval, gettext, notify, pageTitle, customization, dashboard, config) {
    pageTitle.set(gettext('Dashboard'));
    $scope.ready = false;
    dashboard.getAvailableWidgets().then(function(data) {
      var w, _i, _len, _results;
      $scope.availableWidgets = data;
      $scope.widgetTypes = {};
      _results = [];
      for (_i = 0, _len = data.length; _i < _len; _i++) {
        w = data[_i];
        _results.push($scope.widgetTypes[w.id] = w);
      }
      return _results;
    });
    $scope.addWidget = function(w) {
      var widget;
      widget = {
        id: Math.floor(Math.random() * 0x10000000).toString(16),
        typeId: w.id
      };
      $scope.userConfig.dashboard.widgetsLeft.push(widget);
      return $scope.save().then(function() {
        if (w.config_template) {
          $scope.configureWidget(widget);
        }
        return $scope.refresh();
      });
    };
    config.getUserConfig().then(function(userConfig) {
      var updateInterval, _base;
      $scope.userConfig = userConfig;
      if ((_base = $scope.userConfig).dashboard == null) {
        _base.dashboard = customization.plugins.dashboard.defaultConfig;
      }
      updateInterval = $interval(function() {
        return $scope.refresh();
      }, 1000);
      return $scope.$on('$destroy', function() {
        return $interval.cancel(updateInterval);
      });
    });
    $scope.onSort = function() {
      return $scope.save();
    };
    $scope.refresh = function() {
      var rq, w, _i, _len, _ref;
      rq = [];
      _ref = $scope.userConfig.dashboard.widgetsLeft.concat($scope.userConfig.dashboard.widgetsRight);
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        w = _ref[_i];
        rq.push({
          id: w.id,
          typeId: w.typeId,
          config: w.config || {}
        });
      }
      return dashboard.getValues(rq).then(function(data) {
        var resp, _j, _len1, _results;
        $scope.ready = true;
        _results = [];
        for (_j = 0, _len1 = data.length; _j < _len1; _j++) {
          resp = data[_j];
          _results.push($scope.$broadcast('widget-update', resp.id, resp.data));
        }
        return _results;
      });
    };
    $scope.configureWidget = function(widget) {
      if (widget.config == null) {
        widget.config = {};
      }
      return $scope.configuredWidget = widget;
    };
    $scope.saveWidgetConfig = function() {
      $scope.save().then(function() {
        return $scope.refresh();
      });
      return $scope.configuredWidget = null;
    };
    $scope.removeWidget = function(widget) {
      $scope.userConfig.dashboard.widgetsLeft.remove(widget);
      $scope.userConfig.dashboard.widgetsRight.remove(widget);
      return $scope.save();
    };
    return $scope.save = function() {
      return config.setUserConfig($scope.userConfig);
    };
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.dashboard').controller('CPUWidgetController', function($scope) {
    return $scope.$on('widget-update', function($event, id, data) {
      var x, _i, _len;
      if (id !== $scope.widget.id) {
        return;
      }
      $scope.avg = 0;
      $scope.cores = 0;
      for (_i = 0, _len = data.length; _i < _len; _i++) {
        x = data[_i];
        $scope.avg += x / data.length;
        if (x > 0) {
          $scope.cores += 1;
        }
      }
      $scope.avgPercent = Math.floor($scope.avg * 100);
      return $scope.values = data;
    });
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.dashboard').controller('HostnameWidgetController', function($scope) {
    return $scope.$on('widget-update', function($event, id, data) {
      if (id !== $scope.widget.id) {
        return;
      }
      return $scope.hostname = data;
    });
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.dashboard').controller('LoadAverageWidgetController', function($scope) {
    return $scope.$on('widget-update', function($event, id, data) {
      if (id !== $scope.widget.id) {
        return;
      }
      return $scope.load = data;
    });
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.dashboard').controller('MemoryWidgetController', function($scope) {
    return $scope.$on('widget-update', function($event, id, data) {
      if (id !== $scope.widget.id) {
        return;
      }
      $scope.used = data.used;
      $scope.total = data.total;
      return $scope.usage = Math.floor(100 * $scope.used / $scope.total);
    });
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.dashboard').controller('UptimeWidgetController', function($scope) {
    return $scope.$on('widget-update', function($event, id, data) {
      if (id !== $scope.widget.id) {
        return;
      }
      return $scope.uptime = data;
    });
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.dashboard').service('dashboard', function($http, $q) {
    this.getAvailableWidgets = function() {
      var q;
      q = $q.defer();
      $http.get("/api/dashboard/widgets").success(function(data) {
        return q.resolve(data);
      }).error(function(err) {
        return q.reject(err);
      });
      return q.promise;
    };
    this.getValues = function(data) {
      var q;
      q = $q.defer();
      $http.post("/api/dashboard/get-values", data, {
        ignoreLoadingBar: true
      }).success(function(data) {
        return q.resolve(data);
      }).error(function(err) {
        return q.reject(err);
      });
      return q.promise;
    };
    return this;
  });

}).call(this);

