"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sonarqubeScanner = exports.createSonarqubeProject = exports.generateSonarqubeReports = void 0;
const cube = (path, action = "GET", args) => `curl -X ${action} -u $SONARQUBE_TOKEN: "$SONARQUBE_ENDPOINT${path}" ${args || ""}`;
const setupSonarqubeQualityGates = (defaultProfileOrGateName, specificProfileOrGateName) => [
    `export DEFAULT_GATE=\`${cube(`/api/qualitygates/search?gateName=${defaultProfileOrGateName}`)}\``,
    `export SPECIFIC_GATE=\`${cube(`/api/qualitygates/search?gateName=${specificProfileOrGateName}`)}\``,
    `if [[ "$(echo $SPECIFIC_GATE | jq .errors)" == "null" && "$(echo $SPECIFIC_GATE | jq '.results | length')" -gt 0 ]]; then export GATE_NAME=${specificProfileOrGateName}; else export GATE_NAME=${defaultProfileOrGateName}; fi`,
    `${cube("/api/qualitygates/select?projectKey=$PROJECT_NAME&gateName=$GATE_NAME", "POST")}`,
];
const setupSonarqubeQualityProfiles = (defaultProfileOrGateName, specificProfileOrGateName) => [
    `export DEFAULT_PROFILE=\`${cube(`/api/qualityprofiles/search?qualityProfile=${defaultProfileOrGateName}`)} | jq .profiles\``,
    `export SPECIFIC_PROFILE=\`${cube(`/api/qualityprofiles/search?qualityProfile=${specificProfileOrGateName}`)} | jq .profiles\``,
    `export MERGED_PROFILES=\`jq --argjson arr1 "$DEFAULT_PROFILE" --argjson arr2 "$SPECIFIC_PROFILE" -n '$arr1 + $arr2 | group_by(.language) | map(.[-1])'\``,
    `echo $MERGED_PROFILES | jq -c '.[]' | while read i; do ${cube("/api/qualityprofiles/add_project?project=$PROJECT_NAME&language=`echo $i | jq -r .language`&qualityProfile=`echo $i | jq -r .name`", "POST")}; done`,
];
const setupSonarqubePermissions = (authorizedGroup) => !authorizedGroup
    ? []
    : [
        "admin",
        "codeviewer",
        "issueadmin",
        "securityhotspotadmin",
        "scan",
        "user",
    ].map((p) => `${cube(`/api/permissions/add_group?projectKey=$PROJECT_NAME&groupName=${authorizedGroup}&permission=${p}`, "POST")}`);
const setupSonarqubeProject = ({ sonarqubeTags, sonarqubeAuthorizedGroup, sonarqubeDefaultProfileOrGateName, sonarqubeSpecificProfileOrGateName, }) => {
    return [
        ...setupSonarqubePermissions(sonarqubeAuthorizedGroup),
        `${cube("/api/project_branches/rename?project=$PROJECT_NAME&name=mainline", "POST")}`,
        `${cube(`/api/project_tags/set?project=$PROJECT_NAME&tags=${[
            sonarqubeAuthorizedGroup,
            ...(sonarqubeTags || []),
        ].join(",")}`, "POST")}`,
        ...setupSonarqubeQualityProfiles(sonarqubeDefaultProfileOrGateName, sonarqubeSpecificProfileOrGateName),
        ...setupSonarqubeQualityGates(sonarqubeDefaultProfileOrGateName, sonarqubeSpecificProfileOrGateName),
    ].join(";");
};
exports.generateSonarqubeReports = () => [
    cube("/api/bitegarden/report/pdf_issues_breakdown?resource=$PROJECT_NAME&branch=mainline", "GET", "--output reports/prototype-issues-report.pdf"),
    cube("/api/bitegarden/report/pdf?resource=$PROJECT_NAME&branch=mainline", "GET", "--output reports/prototype-executive-report.pdf"),
    cube("/api/security_reports/download?project=$PROJECT_NAME", "GET", "--output reports/prototype-security-report.pdf"),
];
exports.createSonarqubeProject = (props) => [
    `CREATE_PROJECT_OUTPUT=\`${cube("/api/projects/create?name=$PROJECT_NAME&project=$PROJECT_NAME&visibility=private", "POST")}\``,
    `if [[ "$(echo $CREATE_PROJECT_OUTPUT | jq .errors)" == "null" ]]; then ${setupSonarqubeProject(props)}; fi;`,
];
exports.sonarqubeScanner = (excludeGlobsForScan) => [
    "npx sonarqube-scanner -Dsonar.login=$SONARQUBE_TOKEN",
    "-Dsonar.projectKey=$PROJECT_NAME",
    "-Dsonar.projectName=$PROJECT_NAME",
    "-Dsonar.projectVersion=`echo $RESOLVED_SOURCE_VERSION | cut -c1-7`",
    "-Dsonar.branch.name=mainline",
    "-Dsonar.host.url=$SONARQUBE_ENDPOINT",
    "-Dsonar.cfn.nag.reportFiles=reports/cfn-nag-report.json",
    "-Dsonar.dependencyCheck.htmlReportPath=reports/dependency-check-report.html",
    "-Dsonar.javascript.lcov.reportPaths=**/coverage/lcov.info",
    "-Dsonar.clover.reportPath=**/coverage/clover.xml",
    `-Dsonar.exclusions="**/reports/**,**/coverage/**${excludeGlobsForScan ? `,${excludeGlobsForScan.join(",")}` : ""}"`,
    "-Dsonar.sources=.",
].join(" ");
//# sourceMappingURL=data:application/json;base64,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