"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayHttpApiEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const base_1 = require("./base");
/**
 * Call HTTP API endpoint as a Task
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 */
class CallApiGatewayHttpApiEndpoint extends base_1.CallApiGatewayEndpointBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_CallApiGatewayHttpApiEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CallApiGatewayHttpApiEndpoint);
            }
            throw error;
        }
        this.apiEndpoint = this.getApiEndpoint();
        this.arnForExecuteApi = this.getArnForExecuteApi();
        this.stageName = props.stageName;
        this.taskPolicies = this.createPolicyStatements();
    }
    getApiEndpoint() {
        const apiStack = this.props.apiStack;
        return `${this.props.apiId}.execute-api.${apiStack.region}.${apiStack.urlSuffix}`;
    }
    getArnForExecuteApi() {
        const { apiId, stageName, method, apiPath } = this.props;
        return this.props.apiStack.formatArn({
            service: 'execute-api',
            resource: apiId,
            arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
            resourceName: `${stageName}/${method}${apiPath}`,
        });
    }
}
exports.CallApiGatewayHttpApiEndpoint = CallApiGatewayHttpApiEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CallApiGatewayHttpApiEndpoint[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.CallApiGatewayHttpApiEndpoint", version: "1.189.0" };
//# sourceMappingURL=data:application/json;base64,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