# coding: utf-8

"""
    Connection Rest API 2.0

    IDEA StatiCa Connection API, used for the automated design and calculation of steel connections.

    The version of the OpenAPI document: 2.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ideastatica_connection_api.models.con_load_effect_member_load import ConLoadEffectMemberLoad
from typing import Optional, Set
from typing_extensions import Self

class ConLoadEffect(BaseModel):
    """
    ConLoadEffect
    """ # noqa: E501
    is_percentage: Optional[StrictBool] = Field(default=None, alias="isPercentage")
    member_loadings: Optional[List[ConLoadEffectMemberLoad]] = Field(default=None, alias="memberLoadings")
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["isPercentage", "memberLoadings", "id", "name", "active"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConLoadEffect from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in member_loadings (list)
        _items = []
        if self.member_loadings:
            for _item_member_loadings in self.member_loadings:
                if _item_member_loadings:
                    _items.append(_item_member_loadings.to_dict())
            _dict['memberLoadings'] = _items
        # set to None if member_loadings (nullable) is None
        # and model_fields_set contains the field
        if self.member_loadings is None and "member_loadings" in self.model_fields_set:
            _dict['memberLoadings'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConLoadEffect from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isPercentage": obj.get("isPercentage"),
            "memberLoadings": [ConLoadEffectMemberLoad.from_dict(_item) for _item in obj["memberLoadings"]] if obj.get("memberLoadings") is not None else None,
            "id": obj.get("id"),
            "name": obj.get("name"),
            "active": obj.get("active")
        })
        return _obj


