# Examples for Users

- **Create examples for meaningful workflows**: When implementing new functionality, add examples to the `examples/` folder that demonstrate real-world usage patterns
- **Focus on multi-step operations**: Examples should showcase common workflows that combine multiple client methods, such as:
  - Fetching all monitors for a model and then collecting their current metric values
  - Iterating through all organizations and spaces to collect models
  - Creating a dashboard and populating it with widgets for multiple models
  - Setting up monitors across a model's lifecycle stages

## Example Structure

Every example should include:

- **Standard setup section**: Copy the basic setup from existing examples, including:
  ```python
  # Import statements
  from arize_toolkit import Client

  # Authentication setup
  # Note: Set ARIZE_API_KEY environment variable or pass directly
  client = Client(organization="your_org", space="your_space")
  ```
- **Step-by-step documentation**: Use clear comments and markdown cells (for notebooks) to explain:
  - What the code is doing
  - Why each step is necessary
  - What the expected output looks like
  - Common variations or parameters users might want to adjust

## Example Guidelines

- **One example per workflow, not per function**: Don't create an example for every client method. Instead, create examples that demonstrate complete workflows
- **Include error handling**: Show users how to handle common error cases
- **Use realistic data**: Examples should reflect actual use cases, not just minimal test data
- **Provide context**: Explain when and why a user would want to perform these operations

## Example Naming

- Use descriptive filenames: `monitor_metrics_collection.py`, `cross_org_model_inventory.ipynb`
- Include a brief description at the top of each file explaining the example's purpose
- Number examples if they should be run in sequence: `01_setup_monitors.py`, `02_collect_metrics.py`
