import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DefaultPrivilegesConfig extends cdktf.TerraformMetaArguments {
    /**
     * The database to grant default privileges for this role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/default_privileges#database DefaultPrivileges#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * The PostgreSQL object type to set the default privileges on (one of: table, sequence, function, type).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/default_privileges#object_type DefaultPrivileges#object_type}
     *
     * @stability stable
     */
    readonly objectType: string;
    /**
     * Target role for which to alter default privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/default_privileges#owner DefaultPrivileges#owner}
     *
     * @stability stable
     */
    readonly owner: string;
    /**
     * The list of privileges to apply as default privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/default_privileges#privileges DefaultPrivileges#privileges}
     *
     * @stability stable
     */
    readonly privileges: string[];
    /**
     * The name of the role to which grant default privileges on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/default_privileges#role DefaultPrivileges#role}
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * The database schema to set default privileges for this role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/default_privileges#schema DefaultPrivileges#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Permit the grant recipient to grant it to others.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/default_privileges#with_grant_option DefaultPrivileges#with_grant_option}
     *
     * @stability stable
     */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/default_privileges postgresql_default_privileges}.
 *
 * @stability stable
 */
export declare class DefaultPrivileges extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/default_privileges postgresql_default_privileges} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DefaultPrivilegesConfig);
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _objectType?;
    /**
     * @stability stable
     */
    get objectType(): string;
    /**
     * @stability stable
     */
    set objectType(value: string);
    /**
     * @stability stable
     */
    get objectTypeInput(): string | undefined;
    private _owner?;
    /**
     * @stability stable
     */
    get owner(): string;
    /**
     * @stability stable
     */
    set owner(value: string);
    /**
     * @stability stable
     */
    get ownerInput(): string | undefined;
    private _privileges?;
    /**
     * @stability stable
     */
    get privileges(): string[];
    /**
     * @stability stable
     */
    set privileges(value: string[]);
    /**
     * @stability stable
     */
    get privilegesInput(): string[] | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    resetSchema(): void;
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _withGrantOption?;
    /**
     * @stability stable
     */
    get withGrantOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withGrantOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithGrantOption(): void;
    /**
     * @stability stable
     */
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
