[![MseeP.ai Security Assessment Badge](https://mseep.net/pr/darkclaw921-fast-bitrix24-mcp-badge.png)](https://mseep.ai/app/darkclaw921-fast-bitrix24-mcp)


[![Verified on MseeP](https://mseep.ai/badge.svg)](https://mseep.ai/app/ed1c0f4e-cc57-4120-9a5e-5e3fc65414f4)
![PyPI - Format](https://img.shields.io/pypi/format/fast-bitrix24-mcp)
![PyPI - Status](https://img.shields.io/pypi/status/fast-bitrix24-mcp)
<!-- ![PyPI - Downloads](https://img.shields.io/pypi/dm/fast-bitrix24-mcp) -->
[![PyPI Downloads](https://static.pepy.tech/badge/fast-bitrix24-mcp/week)](https://pepy.tech/projects/fast-bitrix24-mcp)

# Поддержка и развитие
Проект активно развивается. Вопросы и предложения по улучшению приветствуются через Issues.

# MCP сервер для взаимодействия с Bitrix24 rest api на основе fast-bitrix24


На данный момент сервер поддерживает следsующие сущности:
- сделки
    - `list_deal` - Список сделок по фильтрам
    - `get_stages` - Получение стадий сделок в человекочитаемом виде, сгруппированных по воронкам
    - `get_category_stages` - Получение стадий для конкретной воронки в человекочитаемом виде
    - `get_deals_at_risk` - Получение сделок в риске (описание ниже в разделе "Пояснения")
    - `get_sales_funnel` - Получение воронки продаж за период
    - `get_top_clients_by_deals_sum` - Получение топ-N клиентов по сумме сделок
    - `daily_summary` - Получение ежедневного отчета
    
- пользовательские поля
    - `get_all_info_fields` - Получение всех ID, названий и значений полей сделки, контакта, компании, задач, лида
- контакты
    - `list_contact` - Список контактов по фильтрам
- компании
    - `list_company` - Список компаний по фильтрам
- пользователи
    - `list_user` - Список пользователей по фильтрам
    - `get_user_activity` - Получение активности пользователя по id
    - `get_all_managers_activity_report` - Получение активности всех менеджеров за указанный период с определением неактивных пользователей
- лиды
    - `list_lead` - Список лидов по фильтрам
- задачи
    - `list_task` - Список задач по фильтрам
    - `get_task_time_tracking` - Получение времени выполнения задачи по id
    - `get_task` - Получение задачи по id
    - `get_task_comments_list` - Получение списка комментариев к задаче по id
    - `get_task_checklist_items` - Получение списка пунктов чеклиста задачи по id

- хелпер
    - `export_entities_to_json` - Экспорт элементов сущности в JSON (сделки, контакты, компании, лиды)
    - `analyze_export_file` - Анализ экспортированных данных (сумма, количество, среднее значение, минимальное значение, максимальное значение)
    - `analyze_tasks_export` - Анализ экспортированных данных для задач (сумма, количество, среднее значение, минимальное значение, максимальное значение)
    - `export_task_fields_to_json` - Экспорт описания полей задач   
    - `datetime_now` - Получение текущей даты и времени в московской зоне
    - `get_managers_with_declined_activity` - Получение выявление менеджеров со сниженной активностью



поддержка человеческого названия полей даже для полей типа список
например:
- какая сумма сделок где поле 'этаж доставки' равно 'в подвал'?
- какая сумма сделок которые нужно доставить в подвал
- как называется поле у сделки с id UF_CRM_1749724770090?
- у каких пользователях есть просроченные задачи?

# Установка и запуск сервера
установите переменные окружения из файла .env.example
```bash
cp .env.example .env
```

установите зависимости 
```bash
uv sync
```
или установите пакет
```bash
uv add fast-bitrix24-mcp
```

создайте файл для запуска сервера
```python
from fast_bitrix24_mcp.main import mcp

if __name__ == "__main__":  
    mcp.run(transport="http", host="0.0.0.0", port=8000)
    # mcp.run(transport="streamable-http", host="127.0.0.1", port=9000)
```

запустите сервер
```bash
uv run main.py
```


## Авторизация запросов
Сервер принимает только авторизованные запросы. Токен берётся из переменной окружения `AUTH_TOKEN` (файл `.env`).

1) Установите токен в `.env`:
```bash
AUTH_TOKEN=ваш_секретный_токен
```

2) Пример авторизованного запроса к HTTP MCP эндпоинту (по умолчанию путь `/mcp`):
```bash
curl -X POST \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer $AUTH_TOKEN" \
  http://localhost:8000/mcp \
  
```


# inspector
ui для тестирования сервера
```bash
npx @modelcontextprotocol/inspector
```

# Пример использования в langchain
```python
from langchain_mcp_adapters.client import MultiServerMCPClient
from langgraph.prebuilt import create_react_agent
from dotenv import load_dotenv
from pprint import pprint
load_dotenv()

client = MultiServerMCPClient(
    {
        
        "bitrix24-main": {
            "url": "http://localhost:8000/mcp",
            "transport": "http",
            "headers": {
                "Authorization": f"Bearer {os.getenv('AUTH_TOKEN')}"
            }
        },

    }
)
async def main():
    tools = await client.get_tools()
  
    promts = await client.get_prompt('bitrix24-main', 'main_prompt')
    promts=promts[0].content    
    # agent = create_react_agent("openai:gpt-4.1-nano-2025-04-14", tools, prompt=promt)
    agent = create_react_agent("openai:gpt-4.1-nano-2025-04-14", tools, prompt=promts, debug=True)
    # math_response = await agent.ainvoke({"messages": "сколько сделок с названием Обновленная тестовая сделка ?"})
    # math_response = await agent.ainvoke({"messages": "как называется поле у сделки с id UF_CRM_1749724770090?"})
    # math_response = await agent.ainvoke({"messages": "какая сумма сделок где поле 'этаж доставки' равно 'в подвал'"})
    # math_response = await agent.ainvoke({"messages": "какая сумма сделок у которых этаж доставки 'в подвал'?"})
    math_response = await agent.ainvoke({"messages": "покажи статистику по сделкам за сегодня и позавчера"})


    token=0
    for message in math_response["messages"]:
        print(message.content + "\n\n")
        
    # pprint(math_response)
    token=math_response["messages"][-1].usage_metadata['total_tokens']
    print(f'token: {token}')
    
        

    while True:
        message = input("Введите сообщение: ")
        math_response["messages"].append({"role": "user", "content": message})
        math_response = await agent.ainvoke(math_response)
        for message in math_response["messages"]:
            print(message.content + "\n\n")

if __name__ == "__main__":
    import asyncio
    asyncio.run(main())
``` 

)

# Пояснения
примеры сделок в риске:

2. Консультация: Бытовая техника (ID: 22)
   Стадия: В работе (EXECUTING)
   Причины риска:
     • Последняя активность была 3 дней назад (2025-12-05 12:35:35)
   Активность за последние 3 дня:
     • Дела в таймлайне: 0 (встречи, звонки, письма, действия и т.д.)
     • Звонки: 0
     • Комментарии: 7
     • Задачи: 0
   Последняя активность: 2025-12-05 12:35:35

3. Заказ ИСДМ на апрель 2026г. АО "КМЗ-Спецмаш" (ID: 19985)
   Воронка: CRM: ОСНОВНОЕ ПР-ВО
   Стадия: КП отправлено (C3:EXECUTING)
   Причины риска:
     • Отсутствует активность (звонки, комментарии, задачи) более 3 дней
   Активность за последние 3 дня:
     • Дела в таймлайне: 0 (встречи, звонки, письма, действия и т.д.)
     • Звонки: 0
     • Комментарии: 0
     • Задачи: 0



# пример главного промта для взаимодействия с сервером
сначала нужно получить все поля сущности чтобы узнать какие поля иммел в виду пользователь используй get_all_info_fields entity: 'deal' | 'contact' | 'company' | 'user' | 'task' | 'lead' | 'all'
сначала нужно получить все поля сущности используй fields_get_all_info_fields. 

после нужно получить список  сущностей используй export_entities_to_json entity: 'deal' | 'contact' | 'company' | 'user' | 'task' | 'lead' этот метод создаст файл в котором будет список элементов сущности.    

далее можно анализировать эти данные используй analyze_export_file
если нужно узнать текущую дату и время в московской зоне используй datetime_now
если выводишь какие то поля то выводи их в человеко-читаемом виде эта информация есть в get_all_info_fields

при работе с задачами нужно сначала получить описания полей задач используй export_task_fields_to_json
потом все как и с остальными сущностями


после того как вы получили данные используй export_entities_to_json чтобы экспортировать данные в файл и затем используй analyze_export_file чтобы проанализировать данные чтобы получить необходимую информацию так как export_entities_to_json только создает файл но не анализирует данные

если пользователь просит получить даныые из какой-то воронки или стадии то используй get_stages или get_category_stages чтобы получить необходимые CATEGORY_ID и STAGE_ID и передай их в filter_fields или select_fields

если что-то касаеться менеджеров или пользователей то сначала нужно получить список пользователей используй user_list_user и передай id пользователя в filter_fields или select_fields

если пользователь прости посчитать что-то по сделкам за какой-то период но нужно фильтровать по отпределенному полю, которое нызваеться "время попадания в {название стадии}" это пользователькочитаемое поле и его нужно передать в filter_fields или select_fields

Пояснения:
Менеджер считается снизившим активность, если за последние 7 дней у него:
• количество задач упало на 30%+ по сравнению с предыдущей неделей;
• количество звонков снизилось на 25%+

Сводка должна включать:
• Кол-во новых лидов и сделок;
• Сколько задач создано и выполнено;
• Кол-во звонков (входящих/исходящих);

Сделка считается «в риске», если выполняется одно или несколько условий:
• статус сделки не менялся более 5 рабочих дней;
• отсутствует активность (звонки, комментарии, задачи) более 3 дней;

Менеджер нуждаеться в помощи если у него:
• много просроченных задач;
• мало активности;
• плохое качество звонков;
• нет сделок переданных в производство(стадия)


доступные инструменты:
- user_list_user: Список пользователей 
- helper_analyze_export_file: Анализ экспортированных данных из файла JSON
- helper_export_entities_to_json: Экспорт элементов сущности в JSON
- helper_export_task_fields_to_json: Экспорт описания полей задач
- helper_datetime_now: Получение текущей даты и времени в московской зоне
- user_get_user_activity: Получение активности пользователя по id
- user_get_all_managers_activity_report: Получение активности всех менеджеров за указанный период с определением неактивных пользователей



описание инструментов:
helper_analyze_export_file:
Анализ экспортированных данных из файла JSON
    - file_path: путь к файлу JSON
    - operation: операция анализа ('count', 'sum', 'avg', 'min', 'max')
    - fields: список полей для анализа (например ['UF_CRM_1749724770090', 'TITLE'])
    - condition: условие фильтрации. Может быть:
      - строкой с операторами: 'DATE_CREATE >= "2025-11-03 00:00:00" and DATE_CREATE <= "2025-11-09 23:59:59"'
      - словарем: {'DATE_CREATE': {'>=': '2025-11-03T00:00:00', '<=': '2025-11-09T23:59:59'}}
      - словарем с операторами в строках: {'DATE_CREATE': '>= 2025-11-03T00:00:00'} (будет автоматически преобразован)
      - JSON строкой: '{"DATE_CREATE": ">= 2025-11-03T00:00:00"}' (будет автоматически распарсена)
    - group_by: группировка по полям (например ['UF_CRM_1749724770090'])
    
helper_export_entities_to_json:
Экспорт элементов сущности в JSON
    - entity: 'deal' | 'contact' | 'company' | 'user' | 'task'
    - filter_fields: фильтр Bitrix24 (например {"CLOSED": "N", ">=DATE_CREATE": "2025-06-01"})
    - select_fields: список полей; ['*', 'UF_*'] означает все поля
    - filename: имя файла (опционально). Если не указано, сформируется автоматически в папке exports
    Возвращает: {"entity": str, "count": int, "file": str}

user_get_all_managers_activity_report
Получение активности всех менеджеров за указанный период с определением неактивных пользователей
    
    Возвращает детальную статистику активности всех менеджеров:
    - Общая статистика по всем менеджерам (звонки, встречи, email, задачи, сделки, лиды, комментарии)
    - Список активных менеджеров с детальной статистикой
    - Список неактивных менеджеров (без активности за период)
    
    Args:
        days: Количество дней для анализа (по умолчанию 30)
        include_inactive: Включать ли информацию о неактивных менеджерах (по умолчанию True)
        only_inactive: Если True, возвращает только список неактивных менеджеров без детальной статистики активных (по умолчанию False)
    
    Returns:
        dict: Словарь с общей статистикой, списком активных и неактивных менеджеров (или только неактивных, если only_inactive=True)

user_get_user_activity
Получение полной активности пользователя за указанный период
    
    Возвращает детальную статистику активности менеджера:
    - Звонки (входящие, исходящие, пропущенные)
    - Встречи
    - Email-сообщения
    - Задачи (всего, завершено, в работе)
    - Сделки (создано, выиграно)
    - Лиды (создано, конвертировано)
    - События календаря
    - Комментарии во всех сущностях CRM
    
    Args:
        manager_id: ID пользователя/менеджера в Bitrix24
        days: Количество дней для анализа (по умолчанию 30)
    
    Returns:
        dict: Словарь с полной статистикой активности пользователя






Ты — аналитик CRM-системы  Bitrix24. Твоя задача — провести комплексный анализ по запросу пользователя  с использованием последовательных системных методов. Помни что ты можешь спрашивать у пользователя больше инормации для более точного анализа.
Выполни пошагово:

1. Получи структуру сущностей для выбранного типа данных:
Используй fields_get_all_info_fields или get_all_info_fields для entity: {{entity_type}} (возможные значения: 'deal' | 'contact' | 'company' | 'user' | 'task' | 'lead' | 'all').

2. Экспортируй список элементов сущности в JSON-файл командой export_entities_to_json entity: {{entity_type}}.

3. После экспорта проведи анализ файла через analyze_export_file, чтобы извлечь нужную информацию.
4. Если работаешь с задачами — предварительно получи описания полей через export_task_fields_to_json, затем действуй аналогично шагам выше.

5. Если анализ касается воронок или стадий, получи данные о стадиях через get_stages или get_category_stages и передай найденные CATEGORY_ID и STAGE_ID в filter_fields или select_fields.
6. Для анализа активности менеджеров сначала получи список пользователей командой user_list_user, затем фильтруй данные по ID пользователя.

7. Если пользователь спрашивает что-то по сделкам например какая сумма сделок за период в какой-то стадии то он имеет в виду какая сумма сделок за период была в этой стадии(это смотрится по пользовательскому полю формата UF_CRM_H_{ID_СТАДИИ но может польностью не совпадать}) это поле показывает когда сделка попала в эту стадию

8. Для получения текущей даты и времени в московском часовом поясе используй datetime_now.
9. Все поля при выводе данных представляй в человеко-читаемом виде (описания доступны через get_all_info_fields).

Аналитические цели и критерии:
Менеджер считается снизившим активность, если за последние 7 дней:
• количество задач уменьшилось ≥30% по сравнению с предыдущей неделей;
• количество звонков снизилось ≥25%.
Сделка считается «в риске», если:
• статус не менялся более 5 рабочих дней;
• не было активности (звонков, комментариев, задач) более 3 дней.
Менеджер нуждается в помощи, если у него:
• большое количество просроченных задач;
• низкий уровень активности;
• низкое качество звонков;
• отсутствуют сделки, переданные в производство (определённая стадия).
Ожидаемый результат:
Создай отчёт, включающий:
• Количество новых лидов и сделок;
• Количество созданных и завершённых задач;
• Количество звонков (входящих и исходящих);
• Долю сделок в риске;
• Перечень менеджеров, нуждающихся в поддержке, с указанием причин.
