"use strict";
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const artifact_1 = require("../lib/artifact");
const pipeline_1 = require("../lib/pipeline");
const validation_1 = require("../lib/validation");
const fake_source_action_1 = require("./fake-source-action");
function stageForTesting() {
    const stack = new cdk.Stack();
    const pipeline = new pipeline_1.Pipeline(stack, 'Pipeline');
    return pipeline.addStage({ stageName: 'stage' });
}
module.exports = {
    'name validation'(test) {
        const cases = [
            { name: 'BlahBleep123.@-_', shouldPassValidation: true, explanation: 'should be valid' },
            { name: '', shouldPassValidation: false, explanation: 'the empty string should be invalid' },
            { name: ' BlahBleep', shouldPassValidation: false, explanation: 'spaces should be invalid' },
            { name: '!BlahBleep', shouldPassValidation: false, explanation: '\'!\' should be invalid' }
        ];
        cases.forEach(testCase => {
            const name = testCase.name;
            const validationBlock = () => { validation_1.validateName('test thing', name); };
            if (testCase.shouldPassValidation) {
                test.doesNotThrow(validationBlock, Error, `${name} failed validation but ${testCase.explanation}`);
            }
            else {
                test.throws(validationBlock, Error, `${name} passed validation but ${testCase.explanation}`);
            }
        });
        test.done();
    },
    'Stage validation': {
        'should fail if Stage has no Actions'(test) {
            const stage = stageForTesting();
            test.deepEqual(stage.validate().length, 1);
            test.done();
        }
    },
    'Pipeline validation': {
        'should fail if Pipeline has no Stages'(test) {
            const stack = new cdk.Stack();
            const pipeline = new pipeline_1.Pipeline(stack, 'Pipeline');
            test.deepEqual(core_1.ConstructNode.validate(pipeline.node).length, 1);
            test.done();
        },
        'should fail if Pipeline has a Source Action in a non-first Stage'(test) {
            const stack = new cdk.Stack();
            const pipeline = new pipeline_1.Pipeline(stack, 'Pipeline');
            pipeline.addStage({
                stageName: 'FirstStage',
                actions: [
                    new fake_source_action_1.FakeSourceAction({
                        actionName: 'FakeSource',
                        output: new artifact_1.Artifact(),
                    }),
                ],
            });
            test.deepEqual(core_1.ConstructNode.validate(pipeline.node).length, 1);
            test.done();
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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