"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * This class is private to the aws-codepipeline package.
 */
class FullActionDescriptor {
    constructor(action, actionConfig, actionRole) {
        const actionProperties = action.actionProperties;
        this.actionName = actionProperties.actionName;
        this.category = actionProperties.category;
        this.owner = actionProperties.owner || 'AWS';
        this.provider = actionProperties.provider;
        this.version = actionProperties.version || '1';
        this.runOrder = actionProperties.runOrder === undefined ? 1 : actionProperties.runOrder;
        this.artifactBounds = actionProperties.artifactBounds;
        this.inputs = deduplicateArtifacts(actionProperties.inputs);
        this.outputs = deduplicateArtifacts(actionProperties.outputs);
        this.region = actionProperties.region;
        this.role = actionProperties.role !== undefined ? actionProperties.role : actionRole;
        this.configuration = actionConfig.configuration;
    }
}
exports.FullActionDescriptor = FullActionDescriptor;
function deduplicateArtifacts(artifacts) {
    const ret = new Array();
    for (const artifact of artifacts || []) {
        if (artifact.artifactName) {
            if (ret.find(a => a.artifactName === artifact.artifactName)) {
                continue;
            }
        }
        else {
            if (ret.find(a => a === artifact)) {
                continue;
            }
        }
        ret.push(artifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnVsbC1hY3Rpb24tZGVzY3JpcHRvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImZ1bGwtYWN0aW9uLWRlc2NyaXB0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFJQTs7R0FFRztBQUNILE1BQWEsb0JBQW9CO0lBYy9CLFlBQVksTUFBZSxFQUFFLFlBQTBCLEVBQUUsVUFBaUM7UUFDeEYsTUFBTSxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDakQsSUFBSSxDQUFDLFVBQVUsR0FBRyxnQkFBZ0IsQ0FBQyxVQUFVLENBQUM7UUFDOUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxnQkFBZ0IsQ0FBQyxRQUFRLENBQUM7UUFDMUMsSUFBSSxDQUFDLEtBQUssR0FBRyxnQkFBZ0IsQ0FBQyxLQUFLLElBQUksS0FBSyxDQUFDO1FBQzdDLElBQUksQ0FBQyxRQUFRLEdBQUcsZ0JBQWdCLENBQUMsUUFBUSxDQUFDO1FBQzFDLElBQUksQ0FBQyxPQUFPLEdBQUcsZ0JBQWdCLENBQUMsT0FBTyxJQUFJLEdBQUcsQ0FBQztRQUMvQyxJQUFJLENBQUMsUUFBUSxHQUFHLGdCQUFnQixDQUFDLFFBQVEsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsZ0JBQWdCLENBQUMsUUFBUSxDQUFDO1FBQ3hGLElBQUksQ0FBQyxjQUFjLEdBQUcsZ0JBQWdCLENBQUMsY0FBYyxDQUFDO1FBQ3RELElBQUksQ0FBQyxNQUFNLEdBQUcsb0JBQW9CLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDNUQsSUFBSSxDQUFDLE9BQU8sR0FBRyxvQkFBb0IsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUM5RCxJQUFJLENBQUMsTUFBTSxHQUFHLGdCQUFnQixDQUFDLE1BQU0sQ0FBQztRQUN0QyxJQUFJLENBQUMsSUFBSSxHQUFHLGdCQUFnQixDQUFDLElBQUksS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO1FBRXJGLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLGFBQWEsQ0FBQztJQUNsRCxDQUFDO0NBQ0Y7QUE5QkQsb0RBOEJDO0FBRUQsU0FBUyxvQkFBb0IsQ0FBQyxTQUFzQjtJQUNsRCxNQUFNLEdBQUcsR0FBRyxJQUFJLEtBQUssRUFBWSxDQUFDO0lBQ2xDLEtBQUssTUFBTSxRQUFRLElBQUksU0FBUyxJQUFJLEVBQUUsRUFBRTtRQUN0QyxJQUFJLFFBQVEsQ0FBQyxZQUFZLEVBQUU7WUFDekIsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFlBQVksS0FBSyxRQUFRLENBQUMsWUFBWSxDQUFDLEVBQUU7Z0JBQzNELFNBQVM7YUFDVjtTQUNGO2FBQU07WUFDTCxJQUFJLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEtBQUssUUFBUSxDQUFDLEVBQUU7Z0JBQ2pDLFNBQVM7YUFDVjtTQUNGO1FBRUQsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztLQUNwQjtJQUNELE9BQU8sR0FBRyxDQUFDO0FBQ2IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpYW0gPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtaWFtJyk7XG5pbXBvcnQgeyBBY3Rpb25BcnRpZmFjdEJvdW5kcywgQWN0aW9uQ2F0ZWdvcnksIEFjdGlvbkNvbmZpZywgSUFjdGlvbiB9IGZyb20gJy4vYWN0aW9uJztcbmltcG9ydCB7IEFydGlmYWN0IH0gZnJvbSAnLi9hcnRpZmFjdCc7XG5cbi8qKlxuICogVGhpcyBjbGFzcyBpcyBwcml2YXRlIHRvIHRoZSBhd3MtY29kZXBpcGVsaW5lIHBhY2thZ2UuXG4gKi9cbmV4cG9ydCBjbGFzcyBGdWxsQWN0aW9uRGVzY3JpcHRvciB7XG4gIHB1YmxpYyByZWFkb25seSBhY3Rpb25OYW1lOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBjYXRlZ29yeTogQWN0aW9uQ2F0ZWdvcnk7XG4gIHB1YmxpYyByZWFkb25seSBvd25lcjogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgcHJvdmlkZXI6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHZlcnNpb246IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHJ1bk9yZGVyOiBudW1iZXI7XG4gIHB1YmxpYyByZWFkb25seSBhcnRpZmFjdEJvdW5kczogQWN0aW9uQXJ0aWZhY3RCb3VuZHM7XG4gIHB1YmxpYyByZWFkb25seSBpbnB1dHM6IEFydGlmYWN0W107XG4gIHB1YmxpYyByZWFkb25seSBvdXRwdXRzOiBBcnRpZmFjdFtdO1xuICBwdWJsaWMgcmVhZG9ubHkgcmVnaW9uPzogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgcm9sZT86IGlhbS5JUm9sZTtcbiAgcHVibGljIHJlYWRvbmx5IGNvbmZpZ3VyYXRpb246IGFueTtcblxuICBjb25zdHJ1Y3RvcihhY3Rpb246IElBY3Rpb24sIGFjdGlvbkNvbmZpZzogQWN0aW9uQ29uZmlnLCBhY3Rpb25Sb2xlOiBpYW0uSVJvbGUgfCB1bmRlZmluZWQpIHtcbiAgICBjb25zdCBhY3Rpb25Qcm9wZXJ0aWVzID0gYWN0aW9uLmFjdGlvblByb3BlcnRpZXM7XG4gICAgdGhpcy5hY3Rpb25OYW1lID0gYWN0aW9uUHJvcGVydGllcy5hY3Rpb25OYW1lO1xuICAgIHRoaXMuY2F0ZWdvcnkgPSBhY3Rpb25Qcm9wZXJ0aWVzLmNhdGVnb3J5O1xuICAgIHRoaXMub3duZXIgPSBhY3Rpb25Qcm9wZXJ0aWVzLm93bmVyIHx8ICdBV1MnO1xuICAgIHRoaXMucHJvdmlkZXIgPSBhY3Rpb25Qcm9wZXJ0aWVzLnByb3ZpZGVyO1xuICAgIHRoaXMudmVyc2lvbiA9IGFjdGlvblByb3BlcnRpZXMudmVyc2lvbiB8fCAnMSc7XG4gICAgdGhpcy5ydW5PcmRlciA9IGFjdGlvblByb3BlcnRpZXMucnVuT3JkZXIgPT09IHVuZGVmaW5lZCA/IDEgOiBhY3Rpb25Qcm9wZXJ0aWVzLnJ1bk9yZGVyO1xuICAgIHRoaXMuYXJ0aWZhY3RCb3VuZHMgPSBhY3Rpb25Qcm9wZXJ0aWVzLmFydGlmYWN0Qm91bmRzO1xuICAgIHRoaXMuaW5wdXRzID0gZGVkdXBsaWNhdGVBcnRpZmFjdHMoYWN0aW9uUHJvcGVydGllcy5pbnB1dHMpO1xuICAgIHRoaXMub3V0cHV0cyA9IGRlZHVwbGljYXRlQXJ0aWZhY3RzKGFjdGlvblByb3BlcnRpZXMub3V0cHV0cyk7XG4gICAgdGhpcy5yZWdpb24gPSBhY3Rpb25Qcm9wZXJ0aWVzLnJlZ2lvbjtcbiAgICB0aGlzLnJvbGUgPSBhY3Rpb25Qcm9wZXJ0aWVzLnJvbGUgIT09IHVuZGVmaW5lZCA/IGFjdGlvblByb3BlcnRpZXMucm9sZSA6IGFjdGlvblJvbGU7XG5cbiAgICB0aGlzLmNvbmZpZ3VyYXRpb24gPSBhY3Rpb25Db25maWcuY29uZmlndXJhdGlvbjtcbiAgfVxufVxuXG5mdW5jdGlvbiBkZWR1cGxpY2F0ZUFydGlmYWN0cyhhcnRpZmFjdHM/OiBBcnRpZmFjdFtdKTogQXJ0aWZhY3RbXSB7XG4gIGNvbnN0IHJldCA9IG5ldyBBcnJheTxBcnRpZmFjdD4oKTtcbiAgZm9yIChjb25zdCBhcnRpZmFjdCBvZiBhcnRpZmFjdHMgfHwgW10pIHtcbiAgICBpZiAoYXJ0aWZhY3QuYXJ0aWZhY3ROYW1lKSB7XG4gICAgICBpZiAocmV0LmZpbmQoYSA9PiBhLmFydGlmYWN0TmFtZSA9PT0gYXJ0aWZhY3QuYXJ0aWZhY3ROYW1lKSkge1xuICAgICAgICBjb250aW51ZTtcbiAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgaWYgKHJldC5maW5kKGEgPT4gYSA9PT0gYXJ0aWZhY3QpKSB7XG4gICAgICAgIGNvbnRpbnVlO1xuICAgICAgfVxuICAgIH1cblxuICAgIHJldC5wdXNoKGFydGlmYWN0KTtcbiAgfVxuICByZXR1cm4gcmV0O1xufVxuIl19