import iam = require('@aws-cdk/aws-iam');
import { ActionArtifactBounds, ActionCategory, ActionConfig, IAction } from './action';
import { Artifact } from './artifact';
/**
 * This class is private to the aws-codepipeline package.
 */
export declare class FullActionDescriptor {
    readonly actionName: string;
    readonly category: ActionCategory;
    readonly owner: string;
    readonly provider: string;
    readonly version: string;
    readonly runOrder: number;
    readonly artifactBounds: ActionArtifactBounds;
    readonly inputs: Artifact[];
    readonly outputs: Artifact[];
    readonly region?: string;
    readonly role?: iam.IRole;
    readonly configuration: any;
    constructor(action: IAction, actionConfig: ActionConfig, actionRole: iam.IRole | undefined);
}
