import s3 = require('@aws-cdk/aws-s3');
import cdk = require('@aws-cdk/core');
/**
 * Construction properties for {@link CrossRegionSupportStack}.
 * This interface is private to the aws-codepipeline package.
 */
export interface CrossRegionSupportStackProps {
    /**
     * The name of the Stack the Pipeline itself belongs to.
     * Used to generate a more friendly name for the support Stack.
     */
    readonly pipelineStackName: string;
    /**
     * The AWS region this Stack resides in.
     */
    readonly region: string;
    /**
     * The AWS account ID this Stack belongs to.
     *
     * @example '012345678901'
     */
    readonly account: string;
}
/**
 * A Stack containing resources required for the cross-region CodePipeline functionality to work.
 * This class is private to the aws-codepipeline package.
 */
export declare class CrossRegionSupportStack extends cdk.Stack {
    /**
     * The name of the S3 Bucket used for replicating the Pipeline's artifacts into the region.
     */
    readonly replicationBucket: s3.IBucket;
    constructor(scope: cdk.Construct, id: string, props: CrossRegionSupportStackProps);
}
