# decompyle3 version 3.9.0
# Python bytecode version base 3.7.0 (3394)
# Decompiled from: Python 3.7.16 (default, Jan 17 2023, 09:28:58)
# [Clang 14.0.6 ]
# Embedded file name: output/Live/mac_universal_64_static/Release/python-bundle/MIDI Remote Scripts/Push2/device_parameter_icons.py
# Compiled at: 2023-12-21 15:35:34
# Size of source mod 2**32: 40281 bytes
IMAGE_ID_TO_FILENAME = {
    "amp_bass": ("amp_bass.svg", ""),
    "amp_blues": ("amp_blues.svg", ""),
    "amp_boost": ("amp_boost.svg", ""),
    "amp_clean": ("amp_clean.svg", ""),
    "amp_heavy": ("amp_heavy.svg", ""),
    "amp_lead": ("amp_lead.svg", ""),
    "amp_rock": ("amp_rock.svg", ""),
    "armed": ("armed.svg", ""),
    "cabinet_1x12": ("cabinet_1x12.svg", ""),
    "cabinet_2x12": ("cabinet_2x12.svg", ""),
    "cabinet_4x10": ("cabinet_4x10.svg", ""),
    "cabinet_4x10bass": ("cabinet_4x10bass.svg", ""),
    "cabinet_4x12": ("cabinet_4x12.svg", ""),
    "cancel_x": ("cancel_x.svg", ""),
    "circuit_clean": ("circuit_clean.svg", ""),
    "circuit_ms2": ("circuit_ms2.svg", ""),
    "circuit_osr": ("circuit_osr.svg", ""),
    "circuit_prd": ("circuit_prd.svg", ""),
    "circuit_smp": ("circuit_smp.svg", ""),
    "chorus_ensemble_classic": ("chorus_ensemble_classic.svg", ""),
    "chorus_ensemble_ensemble": ("chorus_ensemble_ensemble.svg", ""),
    "chorus_ensemble_vibrato": ("chorus_ensemble_vibrato.svg", ""),
    "co_beam": ("co_beam.svg", ""),
    "co_marimba": ("co_marimba.svg", ""),
    "co_membrane": ("co_membrane.svg", ""),
    "co_pipe": ("co_pipe.svg", ""),
    "co_plate": ("co_plate.svg", ""),
    "co_string": ("co_string.svg", ""),
    "co_tube": ("co_tube.svg", ""),
    "compressor_expand": ("compressor_expand.svg", ""),
    "compressor_peak": ("compressor_peak.svg", ""),
    "compressor_rms": ("compressor_rms.svg", ""),
    "control_off": ("control_off.svg", ""),
    "control_on": ("control_on.svg", ""),
    "delay_16th_1": ("delay_16th_1.svg", ""),
    "delay_16th_2": ("delay_16th_2.svg", ""),
    "delay_16th_3": ("delay_16th_3.svg", ""),
    "delay_16th_4": ("delay_16th_4.svg", ""),
    "delay_16th_5": ("delay_16th_5.svg", ""),
    "delay_16th_6": ("delay_16th_6.svg", ""),
    "delay_16th_8": ("delay_16th_8.svg", ""),
    "delay_16th_16": ("delay_16th_16.svg", ""),
    "delay_pingpong_on": ("delay_pingpong_on.svg", ""),
    "delay_pingpong_off": ("delay_pingpong_off.svg", ""),
    "device_pad": ("device_pad.svg", ""),
    "device_rack_drum": ("device_rack_drum.svg", ""),
    "device_rack_effect": ("device_rack_effect.svg", ""),
    "device_rack_instrument": ("device_rack_instrument.svg", ""),
    "drumbuss_soft": ("drumbuss_soft.svg", ""),
    "drumbuss_medium": ("drumbuss_medium.svg", ""),
    "drumbuss_hard": ("drumbuss_hard.svg", ""),
    "echo_16th": ("echo_16th.svg", ""),
    "echo_dotted": ("echo_dotted.svg", ""),
    "echo_note": ("echo_note.svg", ""),
    "echo_triplet": ("echo_triplet.svg", ""),
    "eq8_band1": ("eq8_band1.svg", ""),
    "eq8_band2": ("eq8_band2.svg", ""),
    "eq8_band3": ("eq8_band3.svg", ""),
    "eq8_band4": ("eq8_band4.svg", ""),
    "eq8_band5": ("eq8_band5.svg", ""),
    "eq8_band6": ("eq8_band6.svg", ""),
    "eq8_band7": ("eq8_band7.svg", ""),
    "eq8_band8": ("eq8_band8.svg", ""),
    "filter_band_12": ("filter_band_12.svg", "12BandPass_small.svg"),
    "filter_band_24": ("filter_band_24.svg", "24BandPass_small.svg"),
    "filter_band_6": ("filter_band_6.svg", ""),
    "filter_band_ladr": ("filter_band_ladr.svg", ""),
    "filter_band_ms2": ("filter_band_ms2.svg", ""),
    "filter_band_osr": ("filter_band_osr.svg", ""),
    "filter_band_prd": ("filter_band_prd.svg", ""),
    "filter_band_svf": ("filter_band_svf.svg", ""),
    "filter_bell": ("filter_bell.svg", "Bell_small.svg"),
    "filter_formant_12": ("filter_formant_12.svg", ""),
    "filter_formant_6": ("filter_formant_6.svg", ""),
    "filter_high_12": ("filter_high_12.svg", "12HighPass_small.svg"),
    "filter_high_24": ("filter_high_24.svg", "24HighPass_small.svg"),
    "filter_high_48": ("filter_high_48.svg", "24HighPass_small.svg"),
    "filter_high_ladr": ("filter_high_ladr.svg", ""),
    "filter_high_ms2": ("filter_high_ms2.svg", ""),
    "filter_high_osr": ("filter_high_osr.svg", ""),
    "filter_high_prd": ("filter_high_prd.svg", ""),
    "filter_high_shelf": ("filter_high_shelf.svg", "HighShelf_small.svg"),
    "filter_high_svf": ("filter_high_svf.svg", ""),
    "filter_low_12": ("filter_low_12.svg", "12LowPass_small.svg"),
    "filter_low_24": ("filter_low_24.svg", "24LowPass_small.svg"),
    "filter_low_48": ("filter_low_24.svg", "24LowPass_small.svg"),
    "filter_low_ladr": ("filter_low_ladr.svg", ""),
    "filter_low_ms2": ("filter_low_ms2.svg", ""),
    "filter_low_osr": ("filter_low_osr.svg", ""),
    "filter_low_prd": ("filter_low_prd.svg", ""),
    "filter_low_shelf": ("filter_low_shelf.svg", "LowShelf_small.svg"),
    "filter_low_svf": ("filter_low_svf.svg", ""),
    "filter_morph_12": ("filter_morph_12.svg", "12Morph_small.svg"),
    "filter_morph_24": ("filter_morph_24.svg", "24Morph_small.svg"),
    "filter_notch_12": ("filter_notch_12.svg", "12Notch_small.svg"),
    "filter_notch_24": ("filter_notch_24.svg", "24Notch_small.svg"),
    "icon_horizontal1": ("icon_horizontal1.svg", ""),
    "icon_horizontal15": ("icon_horizontal15.svg", ""),
    "lfo_free": ("lfo_free.svg", ""),
    "lfo_phase": ("lfo_phase.svg", ""),
    "lfo_ratio": ("lfo_ratio.svg", ""),
    "lfo_spin": ("lfo_spin.svg", ""),
    "lfo_sync": ("lfo_sync.svg", ""),
    "lfo_sine_small": ("", "lfo_sine_small.svg"),
    "lfo_triangle_small": ("", "lfo_triangle_small.svg"),
    "lfo_saw_up_small": ("", "lfo_saw_up_small.svg"),
    "lfo_saw_down_small": ("", "lfo_saw_down_small.svg"),
    "lfo_square_small": ("", "lfo_square_small.svg"),
    "lfo_random_small": ("", "lfo_random_small.svg"),
    "lfo_time": ("lfo_time.svg", ""),
    "meld_osc_basic_shapes": ("meld_osc_basic_shapes.svg", ""),
    "meld_osc_bitgrunge": ("meld_osc_bitgrunge.svg", ""),
    "meld_osc_bubbles": ("meld_osc_bubbles.svg", ""),
    "meld_osc_chip": ("meld_osc_chip.svg", ""),
    "meld_osc_crackle": ("meld_osc_crackle.svg", ""),
    "meld_osc_dual_basic_shapes": ("meld_osc_dual_basic_shapes.svg", ""),
    "meld_osc_extratone": ("meld_osc_extratone.svg", ""),
    "meld_osc_filtered_noise": ("meld_osc_filtered_noise.svg", ""),
    "meld_osc_fold_fm": ("meld_osc_fold_fm.svg", ""),
    "meld_osc_harmonic_fm": ("meld_osc_harmonic_fm.svg", ""),
    "meld_osc_noise_loop": ("meld_osc_noise_loop.svg", ""),
    "meld_osc_noisy_shapes": ("meld_osc_noisy_shapes.svg", ""),
    "meld_osc_rain": ("meld_osc_rain.svg", ""),
    "meld_osc_shepards_pi": ("meld_osc_shepards_pi.svg", ""),
    "meld_osc_simple_fm": ("meld_osc_simple_fm.svg", ""),
    "meld_osc_square_5th": ("meld_osc_square_5th.svg", ""),
    "meld_osc_square_sync": ("meld_osc_square_sync.svg", ""),
    "meld_osc_squelch": ("meld_osc_squelch.svg", ""),
    "meld_osc_sub": ("meld_osc_sub.svg", ""),
    "meld_osc_swarm_sine": ("meld_osc_swarm_sine.svg", ""),
    "meld_osc_swarm_saw": ("meld_osc_swarm_saw.svg", ""),
    "meld_osc_swarm_square": ("meld_osc_swarm_square.svg", ""),
    "meld_osc_swarm_triangle": ("meld_osc_swarm_triangle.svg", ""),
    "meld_osc_tarp": ("meld_osc_tarp.svg", ""),
    "mic_condenser": ("mic_condenser.svg", ""),
    "mic_dynamic": ("mic_dynamic.svg", ""),
    "mic_far": ("mic_far.svg", ""),
    "mic_nearoff": ("mic_nearoff.svg", ""),
    "mic_nearon": ("mic_nearon.svg", ""),
    "osc_a": ("osc_a.svg", ""),
    "osc_alg_1": ("osc_alg_1.svg", ""),
    "osc_alg_10": ("osc_alg_10.svg", ""),
    "osc_alg_11": ("osc_alg_11.svg", ""),
    "osc_alg_2": ("osc_alg_2.svg", ""),
    "osc_alg_3": ("osc_alg_3.svg", ""),
    "osc_alg_4": ("osc_alg_4.svg", ""),
    "osc_alg_5": ("osc_alg_5.svg", ""),
    "osc_alg_6": ("osc_alg_6.svg", ""),
    "osc_alg_7": ("osc_alg_7.svg", ""),
    "osc_alg_8": ("osc_alg_8.svg", ""),
    "osc_alg_9": ("osc_alg_9.svg", ""),
    "osc_b": ("osc_b.svg", ""),
    "osc_c": ("osc_c.svg", ""),
    "osc_d": ("osc_d.svg", ""),
    "pedal_distortion": ("pedal_distortion.svg", ""),
    "pedal_fuzz": ("pedal_fuzz.svg", ""),
    "pedal_overdrive": ("pedal_overdrive.svg", ""),
    "phase_inverted": ("phase_inverted.svg", ""),
    "phase_normal": ("phase_normal.svg", ""),
    "route_in": ("route_in.svg", ""),
    "route_out": ("route_out.svg", ""),
    "simpler_1shot": ("simpler_1shot.svg", ""),
    "simpler_adsr": ("simpler_adsr.svg", ""),
    "simpler_slice": ("simpler_slice.svg", ""),
    "spectraltime_manual": ("spectraltime_manual.svg", ""),
    "spectraltime_retrigger": ("spectraltime_retrigger.svg", ""),
    "tension_bow": ("tension_bow.svg", ""),
    "tension_hammer": ("tension_hammer.svg", ""),
    "tension_hammerbounce": ("tension_hammerbounce.svg", ""),
    "tension_plectrum": ("tension_plectrum.svg", ""),
    "tension_plectum": ("tension_plectum.svg", ""),
    "track_group": ("track_group.svg", ""),
    "transmute_mod_mode_chorus": ("transmute_chorus.svg", ""),
    "transmute_mod_mode_granular": ("transmute_granular.svg", ""),
    "transmute_mod_mode_none": ("transmute_none.svg", ""),
    "transmute_mod_mode_wander": ("transmute_wander.svg", ""),
    "tube_a": ("tube_a.svg", ""),
    "utility_left": ("utility_left.svg", ""),
    "utility_right": ("utility_right.svg", ""),
    "utility_stereo": ("utility_stereo.svg", ""),
    "utility_swap": ("utility_swap.svg", ""),
    "tube_b": ("tube_b.svg", ""),
    "tube_c": ("tube_c.svg", ""),
    "voicemode_mono": ("voicemode_mono.svg", ""),
    "voicemode_poly": ("voicemode_poly.svg", ""),
    "voicemode_stereo": ("utility_stereo.svg", ""),
    "voicemode_unison": ("voicemode_unison.svg", ""),
    "voices_2": ("voices_2.svg", ""),
    "voices_3": ("voices_3.svg", ""),
    "voices_4": ("voices_4.svg", ""),
    "voices_5": ("voices_5.svg", ""),
    "voices_6": ("voices_6.svg", ""),
    "voices_7": ("voices_7.svg", ""),
    "voices_8": ("voices_8.svg", ""),
    "wave_linenv": ("wave_linenv.svg", ""),
    "wave_logenv": ("wave_logenv.svg", ""),
    "wave_noise_loop": ("wave_noise_loop.svg", ""),
    "wave_noiseramp": ("wave_noiseramp.svg", ""),
    "wave_noise_white": ("wave_noise_white.svg", ""),
    "wave_pulse": ("", "wave_pulse_small.svg"),
    "wave_saturated": ("", "wave_saturated_small.svg"),
    "wave_sharktooth": ("", "wave_sharktooth_small.svg"),
    "wave_saw_16": ("wave_saw_16.svg", ""),
    "wave_saw_3": ("wave_saw_3.svg", ""),
    "wave_saw_32": ("wave_saw_32.svg", ""),
    "wave_saw_4": ("wave_saw_4.svg", ""),
    "wave_saw_6": ("wave_saw_6.svg", ""),
    "wave_saw_64": ("wave_saw_64.svg", ""),
    "wave_saw_8": ("wave_saw_8.svg", ""),
    "wave_saw_down": ("wave_saw_down.svg", ""),
    "wave_saw_up": ("wave_saw_up.svg", "wave_saw_small.svg"),
    "wave_sh_mono": ("wave_sh_mono.svg", ""),
    "wave_sh_stereo": ("wave_sh_stereo.svg", ""),
    "wave_sine": ("wave_sine.svg", "wave_sine_small.svg"),
    "wave_sine_4bit": ("wave_sine_4bit.svg", ""),
    "wave_sine_8bit": ("wave_sine_8bit.svg", ""),
    "wave_square": ("wave_square.svg", "wave_square_small.svg"),
    "wave_square_16": ("wave_square_16.svg", ""),
    "wave_square_3": ("wave_square_3.svg", ""),
    "wave_square_32": ("wave_square_32.svg", ""),
    "wave_square_4": ("wave_square_4.svg", ""),
    "wave_square_6": ("wave_square_6.svg", ""),
    "wave_square_64": ("wave_square_64.svg", ""),
    "wave_square_8": ("wave_square_8.svg", ""),
    "wave_triangle": ("wave_triangle.svg", "wave_triangle_small.svg"),
    "wave_user": ("wave_user.svg", ""),
    "wavetable_effect_classic": ("wavetable_effect_classic.svg", ""),
    "wavetable_effect_fm": ("wavetable_effect_fm.svg", ""),
    "wavetable_effect_modern": ("wavetable_effect_modern.svg", ""),
    "wavetable_effect_none": ("wavetable_effect_none.svg", ""),
    "wavetable_env_loop": ("wavetable_env_loop.svg", ""),
    "wavetable_env_loop_none": ("wavetable_env_loop_none.svg", ""),
    "wavetable_env_loop_trigger": ("wavetable_env_loop_trigger.svg", ""),
    "wavetable_env_slope": ("wavetable_env_slope.svg", ""),
    "wavetable_env_time": ("wavetable_env_time.svg", ""),
    "wavetable_env_value": ("wavetable_env_value.svg", ""),
    "wavetable_filter_1": ("", "wavetable_filter_1_small.svg"),
    "wavetable_filter_2": ("", "wavetable_filter_2_small.svg"),
    "wavetable_filter_3": ("", "wavetable_filter_3_small.svg"),
    "wavetable_filter_4": ("", "wavetable_filter_4_small.svg"),
    "wavetable_filter_5": ("", "wavetable_filter_5_small.svg"),
    "wavetable_filter_switch_1": ("wavetable_filter_switch_1.svg", ""),
    "wavetable_filter_switch_2": ("wavetable_filter_switch_2.svg", ""),
    "wavetable_octave_0": ("wavetable_octave_0.svg", ""),
    "wavetable_octave_minus_1": ("wavetable_octave_minus_1.svg", ""),
    "wavetable_octave_minus_2": ("wavetable_octave_minus_2.svg", ""),
    "wavetable_osc_1": ("wavetable_osc_1.svg", ""),
    "wavetable_osc_2": ("wavetable_osc_2.svg", ""),
    "wavetable_osc_mix": ("wavetable_osc_mix.svg", ""),
    "wavetable_osc_sub": ("wavetable_osc_sub.svg", ""),
    "wavetable_routing_parallel": ("wavetable_routing_parallel.svg", ""),
    "wavetable_routing_serial": ("wavetable_routing_serial.svg", ""),
    "wavetable_routing_split": ("wavetable_routing_split.svg", ""),
    "wavetable_unison_classic": ("wavetable_unison_classic.svg", ""),
    "wavetable_unison_shimmer": ("wavetable_unison_shimmer.svg", ""),
    "wavetable_unison_noise": ("wavetable_unison_noise.svg", ""),
    "wavetable_unison_none": ("wavetable_unison_none.svg", ""),
    "wavetable_unison_phase_sync": ("wavetable_unison_phase_sync.svg", ""),
    "wavetable_unison_position_spread": ("wavetable_unison_position_spread.svg", ""),
    "wavetable_unison_random": ("wavetable_unison_random.svg", ""),
    "workflow_clip": ("workflow_clip.svg", ""),
    "workflow_scene": ("workflow_scene.svg", ""),
    "hybrid_reverb_section_convolution": ("hybrid_reverb_section_convolution.svg", ""),
    "hybrid_reverb_section_algo": ("hybrid_reverb_section_algo.svg", ""),
    "hybrid_reverb_section_mix": ("hybrid_reverb_section_mix.svg", ""),
    "hybrid_reverb_section_eq": ("hybrid_reverb_section_eq.svg", ""),
    "hybrid_reverb_type_darkhall": ("hybrid_reverb_type_darkhall.svg", ""),
    "hybrid_reverb_type_shimmer": ("hybrid_reverb_type_shimmer.svg", ""),
    "hybrid_reverb_type_tides": ("hybrid_reverb_type_tides.svg", ""),
    "hybrid_reverb_type_quartz": ("hybrid_reverb_type_quartz.svg", ""),
    "hybrid_reverb_type_prism": ("hybrid_reverb_type_prism.svg", ""),
    "hybrid_reverb_vintage_1": ("hybrid_reverb_vintage_1.svg", ""),
    "hybrid_reverb_vintage_2": ("hybrid_reverb_vintage_2.svg", ""),
    "hybrid_reverb_vintage_3": ("hybrid_reverb_vintage_3.svg", ""),
    "hybrid_reverb_vintage_4": ("hybrid_reverb_vintage_4.svg", ""),
    "hybrid_reverb_vintage_5": ("hybrid_reverb_vintage_5.svg", ""),
    "hybrid_reverb_routing_serial": ("hybrid_route_serial_eqoff.svg", ""),
    "hybrid_reverb_routing_parallel": ("hybrid_route_parallel_eqoff.svg", ""),
    "hybrid_reverb_routing_convo": ("hybrid_route_convo_eqoff.svg", ""),
    "hybrid_reverb_routing_algo": ("hybrid_route_algo_eqoff.svg", ""),
    "hybrid_reverb_routing_serial_eq": ("hybrid_route_serial_eqon_paoff.svg", ""),
    "hybrid_reverb_routing_parallel_eq": ("hybrid_route_parallel_eqon_paoff.svg", ""),
    "hybrid_reverb_routing_convo_eq": ("hybrid_route_convo_eqon.svg", ""),
    "hybrid_reverb_routing_algo_eq": ("hybrid_route_algo_eqon_paoff.svg", ""),
    "hybrid_reverb_routing_serial_eq_pre_algo": ("hybrid_route_serial_eqon_paon.svg", ""),
    "hybrid_reverb_routing_parallel_eq_pre_algo": ("hybrid_route_parallel_eqon_paon.svg", ""),
    "hybrid_reverb_routing_convo_eq_pre_algo": ("hybrid_route_convo_eqon.svg", ""),
    "hybrid_reverb_routing_algo_eq_pre_algo": ("hybrid_route_algo_eqon_paon.svg", ""),
}
DRIFT_OSC1 = (
    "wave_sine",
    "wave_triangle",
    "wave_sharktooth",
    "wave_saturated",
    "wave_saw_up",
    "wave_pulse",
    "wave_square",
)
DRIFT_OSC2 = ("wave_sine", "wave_triangle", "wave_saturated", "wave_saw_up", "wave_square")
DRIFT_LFO = (
    "wave_sine",
    "wave_triangle",
    "wave_saw_up",
    "wave_saw_down",
    "wave_square",
    "wave_sh_mono",
    "wave_noiseramp",
    "wave_linenv",
    "wave_logenv",
)
DRIFT_LFO_MODES = ("lfo_free", "lfo_time", "lfo_ratio", "lfo_sync")
DRIFT_VOICE_MODES = ("voicemode_poly", "voicemode_mono", "voicemode_stereo", "voicemode_unison")
DRIFT_FILTERS = ("filter_low_12", "filter_low_24")
MELD_OSCILLATOR_TYPES = (
    "meld_osc_basic_shapes",
    "meld_osc_dual_basic_shapes",
    "meld_osc_noisy_shapes",
    "meld_osc_square_sync",
    "meld_osc_square_5th",
    "meld_osc_sub",
    "meld_osc_swarm_sine",
    "meld_osc_swarm_triangle",
    "meld_osc_swarm_saw",
    "meld_osc_swarm_square",
    "meld_osc_harmonic_fm",
    "meld_osc_fold_fm",
    "meld_osc_squelch",
    "meld_osc_simple_fm",
    "meld_osc_chip",
    "meld_osc_shepards_pi",
    "meld_osc_tarp",
    "meld_osc_extratone",
    "meld_osc_noise_loop",
    "meld_osc_filtered_noise",
    "meld_osc_bitgrunge",
    "meld_osc_crackle",
    "meld_osc_rain",
    "meld_osc_bubbles",
)
OPERATOR_OSCILLATORS = (
    "wave_sine",
    "wave_sine_4bit",
    "wave_sine_8bit",
    "wave_saw_3",
    "wave_saw_4",
    "wave_saw_6",
    "wave_saw_8",
    "wave_saw_16",
    "wave_saw_32",
    "wave_saw_64",
    "wave_saw_down",
    "wave_square_3",
    "wave_square_4",
    "wave_square_6",
    "wave_square_8",
    "wave_square_16",
    "wave_square_32",
    "wave_square_64",
    "wave_square",
    "wave_triangle",
    "wave_noise_loop",
    "wave_noise_white",
    "wave_user",
)
ACTIVATE = ("control_off", "control_on")
ANALOG_OSCILLATORS = ("wave_sine", "wave_saw_down", "wave_square", "wave_noise_white")
ANALOG_L_F_O = ("wave_sine", "wave_triangle", "wave_square", "wave_noise_white", "wave_noise_white")
ANALOG_FILTERS = (
    "filter_low_12",
    "filter_low_24",
    "filter_band_6",
    "filter_band_12",
    "filter_notch_12",
    "filter_notch_24",
    "filter_high_12",
    "filter_high_24",
    "filter_formant_6",
    "filter_formant_12",
)
RESONANCE_TYPES = ("co_beam", "co_marimba", "co_string", "co_membrane", "co_plate", "co_pipe", "co_tube")
COLLISION_FILTERS = ("filter_low_12", "filter_high_12", "filter_band_12", "filter_band_6")
COLLISION_L_F_O = (
    "wave_sine",
    "wave_square",
    "wave_triangle",
    "wave_saw_up",
    "wave_saw_down",
    "wave_sh_mono",
    "wave_noise_white",
)
IMPULSE_FILTERS = (
    "filter_low_12",
    "filter_low_24",
    "filter_band_12",
    "filter_band_24",
    "filter_high_12",
    "filter_high_24",
    "filter_notch_12",
)
SAMPLER_OSCILLATORS = ("wave_sine", "wave_square", "wave_triangle", "wave_saw_down", "wave_saw_up", "wave_sh_mono")
LFO_WAVEFORMS = (
    "wave_sine",
    "wave_square",
    "wave_triangle",
    "wave_saw_up",
    "wave_saw_down",
    "wave_sh_stereo",
    "wave_sh_mono",
)
STEREO_MODE = ("lfo_phase", "lfo_spin")
SYNC = ("lfo_free", "lfo_sync")
EQ8_FILTER_TYPES = (
    "filter_high_48",
    "filter_high_12",
    "filter_low_shelf",
    "filter_bell",
    "filter_notch_24",
    "filter_high_shelf",
    "filter_low_12",
    "filter_low_48",
)
CYTOMIC_FILTER_TYPES = ("filter_low_48", "filter_high_48", "filter_band_24", "filter_notch_24", "filter_morph_24")
FILTER_CIRCUIT_TYPES = ("circuit_clean", "circuit_osr", "circuit_ms2", "circuit_smp", "circuit_prd")
COMPRESSOR_MODES = ("compressor_peak", "compressor_rms", "compressor_expand")
WAVETABLE_LOOP_MODE = ("wavetable_env_loop_none", "wavetable_env_loop_trigger", "wavetable_env_loop")
WAVETABLE_OSCILLATOR_SWITCH = ("wavetable_osc_1", "wavetable_osc_2", "wavetable_osc_sub", "wavetable_osc_mix")
WAVETABLE_OSCILLATOR_EFFECT_TYPES = (
    "wavetable_effect_none",
    "wavetable_effect_fm",
    "wavetable_effect_classic",
    "wavetable_effect_modern",
)
WAVETABLE_FILTER_TYPES = (
    "wavetable_filter_1",
    "wavetable_filter_2",
    "wavetable_filter_3",
    "wavetable_filter_4",
    "wavetable_filter_5",
)
WAVETABLE_LFO_TYPES = (
    "lfo_sine_small",
    "lfo_triangle_small",
    "lfo_saw_down_small",
    "lfo_square_small",
    "lfo_random_small",
)
WAVETABLE_VOICES = ("voices_2", "voices_3", "voices_4", "voices_5", "voices_6", "voices_7", "voices_8")
GENERIC_PARAMETER_IMAGES = {
    "LFO Waveform": LFO_WAVEFORMS,
    "Waveform": ("wave_sine", "wave_triangle", "wave_saw_down", "wave_sh_stereo"),
    "Filter Type": ("filter_low_48", "filter_high_48", "filter_band_24", "filter_notch_24"),
    "Ext. In On": ACTIVATE,
    "LFO Sync": SYNC,
    "Sync": SYNC,
    "Adaptive Q": ACTIVATE,
    "LFO Stereo Mode": STEREO_MODE,
    "Side Listen": ACTIVATE,
    "EQ On": ACTIVATE,
    "EQ Mode": (
        "filter_low_shelf",
        "filter_bell",
        "filter_high_shelf",
        "filter_low_48",
        "filter_band_24",
        "filter_high_48",
    ),
}
DEVICE_PARAMETER_IMAGES = {
    "Drift": {
        "Osc 1 Wave": DRIFT_OSC1,
        "Osc 2 Wave": DRIFT_OSC2,
        "Voice Mode": DRIFT_VOICE_MODES,
        "LFO Wave": DRIFT_LFO,
        "LFO Time Mode": DRIFT_LFO_MODES,
        "Cyc Env Time Mode": DRIFT_LFO_MODES,
        "LP Type": DRIFT_FILTERS,
    },
    "InstrumentMeld": {
        "MeldVoice_EngineA_Oscillator_OscillatorType": MELD_OSCILLATOR_TYPES,
        "MeldVoice_EngineB_Oscillator_OscillatorType": MELD_OSCILLATOR_TYPES,
    },
    "UltraAnalog": {
        "OSC1 On/Off": ACTIVATE,
        "OSC2 On/Off": ACTIVATE,
        "F1 On/Off": ACTIVATE,
        "F2 On/Off": ACTIVATE,
        "AMP1 On/Off": ACTIVATE,
        "AMP2 On/Off": ACTIVATE,
        "Noise On/Off": ACTIVATE,
        "Unison On/Off": ACTIVATE,
        "Glide On/Off": ACTIVATE,
        "Glide Legato": ACTIVATE,
        "LFO1 On/Off": ACTIVATE,
        "LFO1 Sync": SYNC,
        "LFO2 On/Off": ACTIVATE,
        "LFO2 Sync": SYNC,
        "Vib On/Off": ACTIVATE,
        "OSC1 Shape": ANALOG_OSCILLATORS,
        "OSC2 Shape": ANALOG_OSCILLATORS,
        "F1 Type": ANALOG_FILTERS,
        "F2 Type": ANALOG_FILTERS,
        "LFO1 Shape": ANALOG_L_F_O,
        "LFO2 Shape": ANALOG_L_F_O,
    },
    "ChannelEq": {"Highpass On": ACTIVATE},
    "Collision": {
        "Res 1 Type": RESONANCE_TYPES,
        "Res 2 Type": RESONANCE_TYPES,
        "Mallet On/Off": ACTIVATE,
        "Noise On/Off": ACTIVATE,
        "Res 1 On/Off": ACTIVATE,
        "Res 2 On/Off": ACTIVATE,
        "LFO 1 On/Off": ACTIVATE,
        "LFO 2 On/Off": ACTIVATE,
        "Noise Filter Type": COLLISION_FILTERS,
        "LFO 1 Shape": COLLISION_L_F_O,
        "LFO 2 Shape": COLLISION_L_F_O,
        "LFO 1 Sync": SYNC,
        "LFO 2 Sync": SYNC,
    },
    "InstrumentImpulse": {
        "1 Filter Type": IMPULSE_FILTERS,
        "2 Filter Type": IMPULSE_FILTERS,
        "3 Filter Type": IMPULSE_FILTERS,
        "4 Filter Type": IMPULSE_FILTERS,
        "5 Filter Type": IMPULSE_FILTERS,
        "6 Filter Type": IMPULSE_FILTERS,
        "7 Filter Type": IMPULSE_FILTERS,
        "8 Filter Type": IMPULSE_FILTERS,
    },
    "StringStudio": {
        "Exciter Type": ("tension_bow", "tension_hammer", "tension_hammerbounce", "tension_plectrum"),
        "Filter Type": (
            "filter_low_12",
            "filter_low_24",
            "filter_band_6",
            "filter_band_12",
            "filter_notch_12",
            "filter_notch_24",
            "filter_high_12",
            "filter_high_24",
            "filter_formant_6",
            "filter_formant_12",
        ),
        "Exc On/Off": ACTIVATE,
        "E Pos Abs": ACTIVATE,
        "Pickup On/Off": ACTIVATE,
        "Damper On": ACTIVATE,
        "Damper Gated": ACTIVATE,
        "D Pos Abs": ACTIVATE,
        "Term On/Off": ACTIVATE,
        "Body On/Off": ACTIVATE,
        "Filter On/Off": ACTIVATE,
        "LFO On/Off": ACTIVATE,
        "Vibrato On/Off": ACTIVATE,
        "Unison On/Off": ACTIVATE,
        "Porta On/Off": ACTIVATE,
        "Porta Legato": ACTIVATE,
        "Porta Prop": ACTIVATE,
        "FEG On/Off": ACTIVATE,
        "LFO Sync On": SYNC,
        "LFO Shape": ("wave_sine", "wave_triangle", "wave_square", "wave_sh_mono", "wave_noise_white"),
    },
    "Operator": {
        "Oscillator": ("osc_a", "osc_b", "osc_c", "osc_d"),
        "Algorithm": (
            "osc_alg_1",
            "osc_alg_2",
            "osc_alg_3",
            "osc_alg_4",
            "osc_alg_5",
            "osc_alg_6",
            "osc_alg_7",
            "osc_alg_8",
            "osc_alg_9",
            "osc_alg_10",
            "osc_alg_11",
        ),
        "Filter Type": CYTOMIC_FILTER_TYPES,
        "Filter Circuit - LP/HP": FILTER_CIRCUIT_TYPES,
        "Filter Circuit - BP/NO/Morph": FILTER_CIRCUIT_TYPES,
        "LFO Type": (
            "wave_sine",
            "wave_square",
            "wave_triangle",
            "wave_saw_up",
            "wave_saw_down",
            "wave_sh_mono",
            "wave_noise_white",
        ),
        "Osc-A Wave": OPERATOR_OSCILLATORS,
        "Osc-B Wave": OPERATOR_OSCILLATORS,
        "Osc-C Wave": OPERATOR_OSCILLATORS,
        "Osc-D Wave": OPERATOR_OSCILLATORS,
        "Filter On": ACTIVATE,
        "Osc-A On": ACTIVATE,
        "A Quantize": ACTIVATE,
        "B Quantize": ACTIVATE,
        "C Quantize": ACTIVATE,
        "D Quantize": ACTIVATE,
        "Osc-A Retrig": ACTIVATE,
        "A Fix On ": ACTIVATE,
        "Osc-B On": ACTIVATE,
        "Osc-B Quantize": ACTIVATE,
        "Osc-B Retrig": ACTIVATE,
        "B Fix On ": ACTIVATE,
        "Osc-C On": ACTIVATE,
        "Osc-C Quantize": ACTIVATE,
        "Osc-C Retrig": ACTIVATE,
        "C Fix On ": ACTIVATE,
        "Osc-D On": ACTIVATE,
        "Osc-D Quantize": ACTIVATE,
        "Osc-D Retrig": ACTIVATE,
        "D Fix On ": ACTIVATE,
        "LFO On": ACTIVATE,
        "LFO Retrigger": ACTIVATE,
        "Glide On": ACTIVATE,
        "Pe On": ACTIVATE,
        "LFO < Pe": ACTIVATE,
        "Osc-A < Pe": ACTIVATE,
        "Osc-B < Pe": ACTIVATE,
        "Osc-C < Pe": ACTIVATE,
        "Osc-D < Pe": ACTIVATE,
        "Filt < LFO": ACTIVATE,
        "Osc-A < LFO": ACTIVATE,
        "Osc-B < LFO": ACTIVATE,
        "Osc-C < LFO": ACTIVATE,
        "Osc-D < LFO": ACTIVATE,
    },
    "MultiSampler": {
        "F On": ACTIVATE,
        "Fe On": ACTIVATE,
        "Shaper On": ACTIVATE,
        "Osc On": ACTIVATE,
        "O Fix On": ACTIVATE,
        "O Type": OPERATOR_OSCILLATORS,
        "Pe On": ACTIVATE,
        "L 1 On": ACTIVATE,
        "L 1 Sync": SYNC,
        "L 1 Retrig": ACTIVATE,
        "L 1 Wave": SAMPLER_OSCILLATORS,
        "L 2 On": ACTIVATE,
        "L 2 Sync": SYNC,
        "L 2 St Mode": STEREO_MODE,
        "L 2 Retrig": ACTIVATE,
        "L 2 Wave": SAMPLER_OSCILLATORS,
        "L 3 On": ACTIVATE,
        "L 3 Sync": SYNC,
        "L 3 St Mode": STEREO_MODE,
        "L 3 Retrig": ACTIVATE,
        "L 3 Wave": SAMPLER_OSCILLATORS,
        "Ae On": ACTIVATE,
        "Filter Type": CYTOMIC_FILTER_TYPES,
        "Filter Circuit - LP/HP": FILTER_CIRCUIT_TYPES,
        "Filter Circuit - BP/NO/Morph": FILTER_CIRCUIT_TYPES,
    },
    "OriginalSimpler": {
        "F On": ACTIVATE,
        "Fe On": ACTIVATE,
        "L On": ACTIVATE,
        "L Retrig": ACTIVATE,
        "Pe On": ACTIVATE,
        "L Wave": ("wave_sine", "wave_square", "wave_triangle", "wave_saw_down", "wave_saw_up", "wave_sh_mono"),
        "Filter Type": CYTOMIC_FILTER_TYPES,
        "Filter Circuit - LP/HP": FILTER_CIRCUIT_TYPES,
        "Filter Circuit - BP/NO/Morph": FILTER_CIRCUIT_TYPES,
    },
    "Amp": {
        "Amp Type": ("amp_clean", "amp_boost", "amp_blues", "amp_rock", "amp_lead", "amp_heavy", "amp_bass"),
        "Dual Mono": ACTIVATE,
    },
    "AutoFilter": {
        "LFO Quantize On": ACTIVATE,
        "Filter Type": CYTOMIC_FILTER_TYPES,
        "Filter Circuit - LP/HP": FILTER_CIRCUIT_TYPES,
        "Filter Circuit - BP/NO/Morph": FILTER_CIRCUIT_TYPES,
    },
    "AutoPan": {"Invert": ("phase_normal", "phase_inverted"), "LFO Type": SYNC, "Stereo Mode": STEREO_MODE},
    "BeatRepeat": {"Filter On": ACTIVATE, "Repeat": ACTIVATE, "Block Triplets": ACTIVATE},
    "Cabinet": {
        "Dual Mono": ACTIVATE,
        "Cabinet Type": ("cabinet_1x12", "cabinet_2x12", "cabinet_4x12", "cabinet_4x10", "cabinet_4x10bass"),
        "Microphone Type": ("mic_condenser", "mic_dynamic"),
        "Microphone Position": ("mic_nearon", "mic_nearoff", "mic_far"),
    },
    "Chorus": {"LFO Extend On": ACTIVATE, "Link On": ACTIVATE},
    "Chorus2": {"Mode": ("chorus_ensemble_classic", "chorus_ensemble_ensemble", "chorus_ensemble_vibrato")},
    "Compressor2": {"Auto Release On/Off": ACTIVATE, "Makeup": ACTIVATE, "Model": COMPRESSOR_MODES},
    "Corpus": {
        "Resonance Type": RESONANCE_TYPES,
        "LFO On/Off": ACTIVATE,
        "LFO Shape": (
            "wave_sine",
            "wave_square",
            "wave_triangle",
            "wave_saw_up",
            "wave_saw_down",
            "wave_sh_mono",
            "wave_noise_white",
        ),
        "LFO Stereo Mode": STEREO_MODE,
        "MIDI Frequency": ACTIVATE,
        "Note Off": ACTIVATE,
        "Filter On/Off": ACTIVATE,
    },
    "Delay": {
        "L 16th": (
            "delay_16th_1",
            "delay_16th_2",
            "delay_16th_3",
            "delay_16th_4",
            "delay_16th_5",
            "delay_16th_6",
            "delay_16th_8",
            "delay_16th_16",
        ),
        "R 16th": (
            "delay_16th_1",
            "delay_16th_2",
            "delay_16th_3",
            "delay_16th_4",
            "delay_16th_5",
            "delay_16th_6",
            "delay_16th_8",
            "delay_16th_16",
        ),
        "Channel": ("utility_stereo", "utility_left", "utility_right"),
        "Link Switch": ("utility_stereo", "utility_left"),
        "L Sync Enum": SYNC,
        "R Sync Enum": SYNC,
        "Ping Pong": ("delay_pingpong_off", "delay_pingpong_on"),
    },
    "DrumBuss": {"Drive Type": ("drumbuss_soft", "drumbuss_medium", "drumbuss_hard")},
    "Tube": {"Tube Type": ("tube_a", "tube_b", "tube_c")},
    "Echo": {
        "L Sync Mode": ("echo_note", "echo_triplet", "echo_dotted", "echo_16th"),
        "R Sync Mode": ("echo_note", "echo_triplet", "echo_dotted", "echo_16th"),
        "Mod Wave": (
            "lfo_sine_small",
            "lfo_triangle_small",
            "lfo_saw_up_small",
            "lfo_saw_down_small",
            "lfo_square_small",
            "lfo_random_small",
        ),
        "Link": ACTIVATE,
        "Ping Pong": ACTIVATE,
        "Repitch": ACTIVATE,
        "Filter On": ACTIVATE,
        "Mod Sync": ACTIVATE,
    },
    "Eq8": {
        "Band": (
            "eq8_band1",
            "eq8_band2",
            "eq8_band3",
            "eq8_band4",
            "eq8_band5",
            "eq8_band6",
            "eq8_band7",
            "eq8_band8",
        ),
        "1 Filter Type A": EQ8_FILTER_TYPES,
        "2 Filter Type A": EQ8_FILTER_TYPES,
        "3 Filter Type A": EQ8_FILTER_TYPES,
        "4 Filter Type A": EQ8_FILTER_TYPES,
        "5 Filter Type A": EQ8_FILTER_TYPES,
        "6 Filter Type A": EQ8_FILTER_TYPES,
        "7 Filter Type A": EQ8_FILTER_TYPES,
        "8 Filter Type A": EQ8_FILTER_TYPES,
        "1 Filter On A": ACTIVATE,
        "2 Filter On A": ACTIVATE,
        "3 Filter On A": ACTIVATE,
        "4 Filter On A": ACTIVATE,
        "5 Filter On A": ACTIVATE,
        "6 Filter On A": ACTIVATE,
        "7 Filter On A": ACTIVATE,
        "8 Filter On A": ACTIVATE,
        "1 Filter Type B": EQ8_FILTER_TYPES,
        "2 Filter Type B": EQ8_FILTER_TYPES,
        "3 Filter Type B": EQ8_FILTER_TYPES,
        "4 Filter Type B": EQ8_FILTER_TYPES,
        "5 Filter Type B": EQ8_FILTER_TYPES,
        "6 Filter Type B": EQ8_FILTER_TYPES,
        "7 Filter Type B": EQ8_FILTER_TYPES,
        "8 Filter Type B": EQ8_FILTER_TYPES,
        "1 Filter On B": ACTIVATE,
        "2 Filter On B": ACTIVATE,
        "3 Filter On B": ACTIVATE,
        "4 Filter On B": ACTIVATE,
        "5 Filter On B": ACTIVATE,
        "6 Filter On B": ACTIVATE,
        "7 Filter On B": ACTIVATE,
        "8 Filter On B": ACTIVATE,
    },
    "FilterEQ3": {"LowOn": ACTIVATE, "MidOn": ACTIVATE, "HighOn": ACTIVATE},
    "FilterDelay": {
        "1 Input On": ACTIVATE,
        "2 Input On": ACTIVATE,
        "3 Input On": ACTIVATE,
        "1 Delay Mode": ACTIVATE,
        "2 Delay Mode": ACTIVATE,
        "3 Delay Mode": ACTIVATE,
    },
    "FrequencyShifter": {"Wide": ACTIVATE, "Drive On/Off": ACTIVATE},
    "GlueCompressor": {"Peak Clip In": ACTIVATE},
    "GrainDelay": {"Delay Mode": ACTIVATE},
    "Hybrid": {
        "Section": (
            "hybrid_reverb_section_convolution",
            "hybrid_reverb_section_algo",
            "hybrid_reverb_section_mix",
            "hybrid_reverb_section_eq",
        ),
        "Algo Type": (
            "hybrid_reverb_type_darkhall",
            "hybrid_reverb_type_quartz",
            "hybrid_reverb_type_shimmer",
            "hybrid_reverb_type_tides",
            "hybrid_reverb_type_prism",
        ),
        "Vintage Copy": (
            "hybrid_reverb_vintage_1",
            "hybrid_reverb_vintage_2",
            "hybrid_reverb_vintage_3",
            "hybrid_reverb_vintage_4",
            "hybrid_reverb_vintage_5",
        ),
        "Routing Eq Off": (
            "hybrid_reverb_routing_serial",
            "hybrid_reverb_routing_parallel",
            "hybrid_reverb_routing_algo",
            "hybrid_reverb_routing_convo",
        ),
        "Routing Eq On PreAlgo Off": (
            "hybrid_reverb_routing_serial_eq",
            "hybrid_reverb_routing_parallel_eq",
            "hybrid_reverb_routing_algo_eq",
            "hybrid_reverb_routing_convo_eq",
        ),
        "Routing Eq On PreAlgo On": (
            "hybrid_reverb_routing_serial_eq_pre_algo",
            "hybrid_reverb_routing_parallel_eq_pre_algo",
            "hybrid_reverb_routing_algo_eq_pre_algo",
            "hybrid_reverb_routing_convo_eq_pre_algo",
        ),
    },
    "InstrumentVector": {
        "Oscillator": WAVETABLE_OSCILLATOR_SWITCH,
        "Osc 1 Effect Type": WAVETABLE_OSCILLATOR_EFFECT_TYPES,
        "Osc 2 Effect Type": WAVETABLE_OSCILLATOR_EFFECT_TYPES,
        "Sub Transpose": ("wavetable_octave_0", "wavetable_octave_minus_1", "wavetable_octave_minus_2"),
        "Filter": ("wavetable_filter_switch_1", "wavetable_filter_switch_2"),
        "Filter 1 Type": WAVETABLE_FILTER_TYPES,
        "Filter 2 Type": WAVETABLE_FILTER_TYPES,
        "Filter 1 On": ACTIVATE,
        "Filter 2 On": ACTIVATE,
        "Filter 1 LP/HP": FILTER_CIRCUIT_TYPES,
        "Filter 2 LP/HP": FILTER_CIRCUIT_TYPES,
        "Filter 1 BP/NO/Morph": FILTER_CIRCUIT_TYPES,
        "Filter 2 BP/NO/Morph": FILTER_CIRCUIT_TYPES,
        "Filter Routing": ("wavetable_routing_serial", "wavetable_routing_parallel", "wavetable_routing_split"),
        "Amp Env View": ("wavetable_env_time", "wavetable_env_slope"),
        "Mod Env View": ("wavetable_env_time", "wavetable_env_slope", "wavetable_env_value"),
        "Amp Loop Mode": WAVETABLE_LOOP_MODE,
        "Env 2 Loop Mode": WAVETABLE_LOOP_MODE,
        "Env 3 Loop Mode": WAVETABLE_LOOP_MODE,
        "LFO 1 Shape": WAVETABLE_LFO_TYPES,
        "LFO 2 Shape": WAVETABLE_LFO_TYPES,
        "LFO 1 Retrigger": ACTIVATE,
        "LFO 2 Retrigger": ACTIVATE,
        "Mono On": ACTIVATE,
        "Unison Mode": (
            "wavetable_unison_none",
            "wavetable_unison_classic",
            "wavetable_unison_shimmer",
            "wavetable_unison_noise",
            "wavetable_unison_phase_sync",
            "wavetable_unison_position_spread",
            "wavetable_unison_random",
        ),
        "Unison Voices": WAVETABLE_VOICES,
        "Poly Voices": WAVETABLE_VOICES,
    },
    "Limiter": {"Auto": ACTIVATE, "Link Channels": ACTIVATE},
    "Looper": {"Reverse": ACTIVATE},
    "MultibandDynamics": {
        "Band Activator (Low)": ACTIVATE,
        "Band Activator (Mid)": ACTIVATE,
        "Band Activator (High)": ACTIVATE,
        "Soft Knee On/Off": ACTIVATE,
    },
    "Pedal": {"Type": ("pedal_overdrive", "pedal_distortion", "pedal_fuzz"), "Sub": ACTIVATE},
    "Redux": {"Bit On": ACTIVATE},
    "Redux2": {"DC Shift": ACTIVATE, "Pre-Filter On": ACTIVATE},
    "Resonator": {
        "Const": ACTIVATE,
        "Filter On": ACTIVATE,
        "I On": ACTIVATE,
        "II On": ACTIVATE,
        "III On": ACTIVATE,
        "IV On": ACTIVATE,
        "V On": ACTIVATE,
    },
    "Reverb": {
        "In LowCut On": ACTIVATE,
        "In HighCut On": ACTIVATE,
        "ER Spin On": ACTIVATE,
        "HiFilter On": ACTIVATE,
        "LowShelf On": ACTIVATE,
        "Freeze On": ACTIVATE,
        "Flat On": ACTIVATE,
        "Cut On": ACTIVATE,
        "Chorus On": ACTIVATE,
    },
    "Saturator": {"Color": ACTIVATE, "Soft Clip": ACTIVATE},
    "StereoGain": {
        "Mute": ACTIVATE,
        "BlockDc": ACTIVATE,
        "Channel Mode": ("utility_left", "utility_stereo", "utility_right", "utility_swap"),
        "Left Inv": ACTIVATE,
        "Right Inv": ACTIVATE,
    },
    "Transmute": {
        "Mod Mode": (
            "transmute_mod_mode_none",
            "transmute_mod_mode_chorus",
            "transmute_mod_mode_wander",
            "transmute_mod_mode_granular",
        ),
    },
    "Spectral": {"Mode": ("spectraltime_manual", "spectraltime_retrigger"), "On": ACTIVATE, "Delay On": ACTIVATE},
    "Vinyl": {"Tracing On": ACTIVATE, "Pinch On": ACTIVATE},
    "Vocoder": {"Precise/Retro": ACTIVATE, "Enhance": ACTIVATE},
    "MidiArpeggiator": {"Hold On": ACTIVATE, "Sync On": ACTIVATE, "Velocity On": ACTIVATE, "Vel. Retrigger": ACTIVATE},
    "MidiNoteLength": {"Trigger Source": ACTIVATE, "Sync On": ACTIVATE},
    "MidiRandom": {"Mode": ACTIVATE},
    "MidiScale": {"Fold": ACTIVATE},
}


def get_image_filenames_from_ids(image_ids, small_images=False, image_id_to_filename=IMAGE_ID_TO_FILENAME):
    image_index = 1 if small_images else 0
    return [image_id_to_filename.get(image_id, ("", ""))[image_index] for image_id in image_ids]


def get_image_filenames(
    parameter_name,
    device_type,
    small_images=False,
    device_parameter_images=DEVICE_PARAMETER_IMAGES,
    generic_parameter_images=GENERIC_PARAMETER_IMAGES,
    image_id_to_filename=IMAGE_ID_TO_FILENAME,
):
    image_ids = []
    if device_type in device_parameter_images and parameter_name in device_parameter_images[device_type]:
        image_ids = device_parameter_images[device_type][parameter_name]
    else:
        if parameter_name in generic_parameter_images:
            image_ids = generic_parameter_images[parameter_name]
    return get_image_filenames_from_ids(image_ids, small_images=small_images, image_id_to_filename=image_id_to_filename)
