# coding: utf-8

"""
    Fox API

     Warning: Please add a custom user agent header to your requests. This would help us fighting against DDoS attacks in future, while keeping your application's access to the API. In future, this may be a mandatory requirement.  To reduce the system load, the API endpoints are rate limited. The default limit is 30 requests per minute. Contact admin@orangefox.tech if you need a higher limit.  The requests may be logged for analytics and development purposes. 

    The version of the OpenAPI document: 5.2.1
    Contact: admin@orangefox.tech
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import Any, List, Optional
from typing_extensions import Annotated
from foxclient.models.device_response import DeviceResponse
from foxclient.models.list_response_short_device_response import ListResponseShortDeviceResponse
from foxclient.models.list_response_str import ListResponseStr

from foxclient.api_client import ApiClient, RequestSerialized
from foxclient.api_response import ApiResponse
from foxclient.rest import RESTResponseType


class DeviceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def get_device(
        self,
        device_id: Optional[Any] = None,
        id: Annotated[Optional[Any], Field(description="Filter by Device ID (deprecated)")] = None,
        codename: Annotated[Optional[StrictStr], Field(description="Not recommended to use when you can")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeviceResponse:
        """Get Device

        Extended get device method, including the ability to get a device using device codename instead of the ID.  /device/get?codename=lavender   Due to the reasons mentioned in the /device route, identification devices using their codenames are considered  unrecommended.

        :param device_id:
        :type device_id: AnyOf
        :param id: Filter by Device ID (deprecated)
        :type id: AnyOf
        :param codename: Not recommended to use when you can
        :type codename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_device_serialize(
            device_id=device_id,
            id=id,
            codename=codename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeviceResponse",
            '404': None,
            '400': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_device_with_http_info(
        self,
        device_id: Optional[Any] = None,
        id: Annotated[Optional[Any], Field(description="Filter by Device ID (deprecated)")] = None,
        codename: Annotated[Optional[StrictStr], Field(description="Not recommended to use when you can")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeviceResponse]:
        """Get Device

        Extended get device method, including the ability to get a device using device codename instead of the ID.  /device/get?codename=lavender   Due to the reasons mentioned in the /device route, identification devices using their codenames are considered  unrecommended.

        :param device_id:
        :type device_id: AnyOf
        :param id: Filter by Device ID (deprecated)
        :type id: AnyOf
        :param codename: Not recommended to use when you can
        :type codename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_device_serialize(
            device_id=device_id,
            id=id,
            codename=codename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeviceResponse",
            '404': None,
            '400': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_device_without_preload_content(
        self,
        device_id: Optional[Any] = None,
        id: Annotated[Optional[Any], Field(description="Filter by Device ID (deprecated)")] = None,
        codename: Annotated[Optional[StrictStr], Field(description="Not recommended to use when you can")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Device

        Extended get device method, including the ability to get a device using device codename instead of the ID.  /device/get?codename=lavender   Due to the reasons mentioned in the /device route, identification devices using their codenames are considered  unrecommended.

        :param device_id:
        :type device_id: AnyOf
        :param id: Filter by Device ID (deprecated)
        :type id: AnyOf
        :param codename: Not recommended to use when you can
        :type codename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_device_serialize(
            device_id=device_id,
            id=id,
            codename=codename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeviceResponse",
            '404': None,
            '400': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_device_serialize(
        self,
        device_id,
        id,
        codename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if device_id is not None:
            
            _query_params.append(('device_id', device_id))
            
        if id is not None:
            
            _query_params.append(('_id', id))
            
        if codename is not None:
            
            _query_params.append(('codename', codename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/devices/get',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_device_deprecated(
        self,
        device_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeviceResponse:
        """(Deprecated) Get Device Short

        Gets device info using device ID.

        :param device_id: (required)
        :type device_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /devices/{device_id} is deprecated.", DeprecationWarning)

        _param = self._get_device_deprecated_serialize(
            device_id=device_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeviceResponse",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_device_deprecated_with_http_info(
        self,
        device_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeviceResponse]:
        """(Deprecated) Get Device Short

        Gets device info using device ID.

        :param device_id: (required)
        :type device_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /devices/{device_id} is deprecated.", DeprecationWarning)

        _param = self._get_device_deprecated_serialize(
            device_id=device_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeviceResponse",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_device_deprecated_without_preload_content(
        self,
        device_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Get Device Short

        Gets device info using device ID.

        :param device_id: (required)
        :type device_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /devices/{device_id} is deprecated.", DeprecationWarning)

        _param = self._get_device_deprecated_serialize(
            device_id=device_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeviceResponse",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_device_deprecated_serialize(
        self,
        device_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if device_id is not None:
            _path_params['device_id'] = device_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/devices/{device_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_devices(
        self,
        id: Annotated[Optional[List[Any]], Field(description="Filter by Device IDs")] = None,
        id2: Annotated[Optional[List[Any]], Field(description="Filter by Device IDs (deprecated)")] = None,
        oem_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by OEM names")] = None,
        codename: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by device codenames")] = None,
        model_name: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by model names")] = None,
        supported: Annotated[Optional[StrictBool], Field(description="Supported status")] = None,
        maintainer: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by maintainer ID")] = None,
        freezed: Annotated[Optional[StrictBool], Field(description="Filter by Freezed status")] = None,
        has_releases: Annotated[Optional[StrictBool], Field(description="Filter by has releases status")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Skip query results")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit query results (0 means unlimited)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponseShortDeviceResponse:
        """Get Devices

        Get a device list.  Device ID is the internal OrangeFox device identifier (https://www.mongodb.com/docs/manual/reference/method/ObjectId/). Please only use it for identification instead of codename or model_name if it's possible. You would find two Device ID query parameters here, the _id one is left deprecated due to historical reasons,  please use id instead.  Please note that using model_name is unrecommended and considered deprecated as it's very inconsistent around some  OEMs that play with the names around. As of the current moment, the API won't support unified model names at all! In short, do not use model_name as device's identification.  Be careful using codenames, there are a lot of problems and pain about those. Some OEMs keep releasing new phones with the same hardware as the old ones and may or may not update or change the codename for those. Currently, API doesn't support unified devices; they would have only one codename.  Our OEMs database would not include subbrands, they instead would be added to the model name. Like oem_name: \"Xiaomi\" model_name: \"Poco F5 Pro\". The exclusions are merged ones, like OnePlus, as calling those BBK OnePlus is really weird in the respective  communities.  Note: You will get only a shortened device object with this method, if you want to get a full one, use \"/device/<device_id>\" or \"/device/get\" method instead.

        :param id: Filter by Device IDs
        :type id: List[object]
        :param id2: Filter by Device IDs (deprecated)
        :type id2: List[object]
        :param oem_name: Filter by OEM names
        :type oem_name: List[str]
        :param codename: Filter by device codenames
        :type codename: List[Optional[str]]
        :param model_name: Filter by model names
        :type model_name: List[Optional[str]]
        :param supported: Supported status
        :type supported: bool
        :param maintainer: Filter by maintainer ID
        :type maintainer: List[Optional[str]]
        :param freezed: Filter by Freezed status
        :type freezed: bool
        :param has_releases: Filter by has releases status
        :type has_releases: bool
        :param skip: Skip query results
        :type skip: int
        :param limit: Limit query results (0 means unlimited)
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_devices_serialize(
            id=id,
            id2=id2,
            oem_name=oem_name,
            codename=codename,
            model_name=model_name,
            supported=supported,
            maintainer=maintainer,
            freezed=freezed,
            has_releases=has_releases,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponseShortDeviceResponse",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_devices_with_http_info(
        self,
        id: Annotated[Optional[List[Any]], Field(description="Filter by Device IDs")] = None,
        id2: Annotated[Optional[List[Any]], Field(description="Filter by Device IDs (deprecated)")] = None,
        oem_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by OEM names")] = None,
        codename: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by device codenames")] = None,
        model_name: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by model names")] = None,
        supported: Annotated[Optional[StrictBool], Field(description="Supported status")] = None,
        maintainer: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by maintainer ID")] = None,
        freezed: Annotated[Optional[StrictBool], Field(description="Filter by Freezed status")] = None,
        has_releases: Annotated[Optional[StrictBool], Field(description="Filter by has releases status")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Skip query results")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit query results (0 means unlimited)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponseShortDeviceResponse]:
        """Get Devices

        Get a device list.  Device ID is the internal OrangeFox device identifier (https://www.mongodb.com/docs/manual/reference/method/ObjectId/). Please only use it for identification instead of codename or model_name if it's possible. You would find two Device ID query parameters here, the _id one is left deprecated due to historical reasons,  please use id instead.  Please note that using model_name is unrecommended and considered deprecated as it's very inconsistent around some  OEMs that play with the names around. As of the current moment, the API won't support unified model names at all! In short, do not use model_name as device's identification.  Be careful using codenames, there are a lot of problems and pain about those. Some OEMs keep releasing new phones with the same hardware as the old ones and may or may not update or change the codename for those. Currently, API doesn't support unified devices; they would have only one codename.  Our OEMs database would not include subbrands, they instead would be added to the model name. Like oem_name: \"Xiaomi\" model_name: \"Poco F5 Pro\". The exclusions are merged ones, like OnePlus, as calling those BBK OnePlus is really weird in the respective  communities.  Note: You will get only a shortened device object with this method, if you want to get a full one, use \"/device/<device_id>\" or \"/device/get\" method instead.

        :param id: Filter by Device IDs
        :type id: List[object]
        :param id2: Filter by Device IDs (deprecated)
        :type id2: List[object]
        :param oem_name: Filter by OEM names
        :type oem_name: List[str]
        :param codename: Filter by device codenames
        :type codename: List[Optional[str]]
        :param model_name: Filter by model names
        :type model_name: List[Optional[str]]
        :param supported: Supported status
        :type supported: bool
        :param maintainer: Filter by maintainer ID
        :type maintainer: List[Optional[str]]
        :param freezed: Filter by Freezed status
        :type freezed: bool
        :param has_releases: Filter by has releases status
        :type has_releases: bool
        :param skip: Skip query results
        :type skip: int
        :param limit: Limit query results (0 means unlimited)
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_devices_serialize(
            id=id,
            id2=id2,
            oem_name=oem_name,
            codename=codename,
            model_name=model_name,
            supported=supported,
            maintainer=maintainer,
            freezed=freezed,
            has_releases=has_releases,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponseShortDeviceResponse",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_devices_without_preload_content(
        self,
        id: Annotated[Optional[List[Any]], Field(description="Filter by Device IDs")] = None,
        id2: Annotated[Optional[List[Any]], Field(description="Filter by Device IDs (deprecated)")] = None,
        oem_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by OEM names")] = None,
        codename: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by device codenames")] = None,
        model_name: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by model names")] = None,
        supported: Annotated[Optional[StrictBool], Field(description="Supported status")] = None,
        maintainer: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by maintainer ID")] = None,
        freezed: Annotated[Optional[StrictBool], Field(description="Filter by Freezed status")] = None,
        has_releases: Annotated[Optional[StrictBool], Field(description="Filter by has releases status")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Skip query results")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit query results (0 means unlimited)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Devices

        Get a device list.  Device ID is the internal OrangeFox device identifier (https://www.mongodb.com/docs/manual/reference/method/ObjectId/). Please only use it for identification instead of codename or model_name if it's possible. You would find two Device ID query parameters here, the _id one is left deprecated due to historical reasons,  please use id instead.  Please note that using model_name is unrecommended and considered deprecated as it's very inconsistent around some  OEMs that play with the names around. As of the current moment, the API won't support unified model names at all! In short, do not use model_name as device's identification.  Be careful using codenames, there are a lot of problems and pain about those. Some OEMs keep releasing new phones with the same hardware as the old ones and may or may not update or change the codename for those. Currently, API doesn't support unified devices; they would have only one codename.  Our OEMs database would not include subbrands, they instead would be added to the model name. Like oem_name: \"Xiaomi\" model_name: \"Poco F5 Pro\". The exclusions are merged ones, like OnePlus, as calling those BBK OnePlus is really weird in the respective  communities.  Note: You will get only a shortened device object with this method, if you want to get a full one, use \"/device/<device_id>\" or \"/device/get\" method instead.

        :param id: Filter by Device IDs
        :type id: List[object]
        :param id2: Filter by Device IDs (deprecated)
        :type id2: List[object]
        :param oem_name: Filter by OEM names
        :type oem_name: List[str]
        :param codename: Filter by device codenames
        :type codename: List[Optional[str]]
        :param model_name: Filter by model names
        :type model_name: List[Optional[str]]
        :param supported: Supported status
        :type supported: bool
        :param maintainer: Filter by maintainer ID
        :type maintainer: List[Optional[str]]
        :param freezed: Filter by Freezed status
        :type freezed: bool
        :param has_releases: Filter by has releases status
        :type has_releases: bool
        :param skip: Skip query results
        :type skip: int
        :param limit: Limit query results (0 means unlimited)
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_devices_serialize(
            id=id,
            id2=id2,
            oem_name=oem_name,
            codename=codename,
            model_name=model_name,
            supported=supported,
            maintainer=maintainer,
            freezed=freezed,
            has_releases=has_releases,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponseShortDeviceResponse",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_devices_serialize(
        self,
        id,
        id2,
        oem_name,
        codename,
        model_name,
        supported,
        maintainer,
        freezed,
        has_releases,
        skip,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'id': 'multi',
            '_id': 'multi',
            'oem_name': 'multi',
            'codename': 'multi',
            'model_name': 'multi',
            'maintainer': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if id2 is not None:
            
            _query_params.append(('_id', id2))
            
        if oem_name is not None:
            
            _query_params.append(('oem_name', oem_name))
            
        if codename is not None:
            
            _query_params.append(('codename', codename))
            
        if model_name is not None:
            
            _query_params.append(('model_name', model_name))
            
        if supported is not None:
            
            _query_params.append(('supported', supported))
            
        if maintainer is not None:
            
            _query_params.append(('maintainer', maintainer))
            
        if freezed is not None:
            
            _query_params.append(('freezed', freezed))
            
        if has_releases is not None:
            
            _query_params.append(('has_releases', has_releases))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/devices/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_oems(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponseStr:
        """Get Oems

        Lists all OEM names

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_oems_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponseStr",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_oems_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponseStr]:
        """Get Oems

        Lists all OEM names

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_oems_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponseStr",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_oems_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Oems

        Lists all OEM names

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_oems_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponseStr",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_oems_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/oems/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


