import json
import os
from multiprocessing.pool import ThreadPool
import pkg_resources

class ZipCache:
    def __init__(self):
        self.folder_path = './zip'
        self.check_cache_exist()
    
    def write_file(self, data):
        zipcode, jdata = data
        with open(f"{self.folder_path}/{zipcode}", "w") as output_file:
            output_file.write(json.dumps(jdata))

    def check_cache_exist(self):
        current_dir = os.getcwd()
        if not os.path.exists(os.path.join(current_dir, self.folder_path)):
            print("No exisitng zip cache !!!")
            os.makedirs(os.path.join(current_dir, self.folder_path))
        
        file_count = len([name for name in os.listdir(self.folder_path) if os.path.isfile(os.path.join(self.folder_path, name))]) 
        if file_count != 41481:
            jdata = self.zipCodes()
            with ThreadPool() as pool:
                    pool.map(self.write_file, jdata.items())
            print("Cache created successfully !!")
    
    def getData(self, filename):
        try:
            with open(f"{self.folder_path}/{filename}", "r") as input_file: 
                data = input_file.read().replace('"','').split('_')
                return {"lat":data[0],"lng":data[1]}
        except:
            return {}
        
    def zipCodes(self):
        return {"99553": "54.143_-165.7854", "99571": "55.1858_-162.7211", "99583": "54.8542_-163.4113", "99612": "55.0628_-162.3056", "99661": "55.3192_-160.4914", "99546": "51.874_-176.634", "99547": "52.1961_-174.2006", "99591": "56.5944_-169.6186", "99638": "52.9381_-168.8678", "99660": "57.1842_-170.2764", "99685": "53.8871_-166.5199", "99692": "53.8898_-166.5422", "99501": "61.2116_-149.8761", "99502": "61.1661_-149.96", "99503": "61.19_-149.8938", "99504": "61.2037_-149.7447", "99505": "59.8666_-158.5996", "99506": "59.8666_-158.5996", "99507": "61.1535_-149.8289", "99508": "61.206_-149.8101", "99509": "61.2181_-149.9003", "99510": "61.1446_-149.8784", "99511": "61.0683_-149.8005", "99513": "61.2149_-149.8862", "99514": "61.2181_-149.9003", "99515": "61.1194_-149.8974", "99516": "61.1054_-149.78", "99517": "61.1901_-149.9361", "99518": "61.1549_-149.8866", "99519": "61.1089_-149.4403", "99520": "61.2181_-149.9003", "99521": "61.2181_-149.9003", "99522": "61.2181_-149.9003", "99523": "61.2181_-149.9003", "99524": "61.2181_-149.9003", "99529": "61.1515_-149.9443", "99530": "61.1515_-149.9443", "99540": "61.1089_-149.4403", "99567": "61.4098_-149.4537", "99577": "61.3114_-149.5085", "99587": "60.9577_-149.1406", "99599": "61.1872_-149.8804", "99695": "61.1089_-149.4403", "99545": "59.9599_-162.8919", "99551": "60.9094_-161.4314", "99552": "60.9122_-161.2139", "99557": "61.5783_-159.5222", "99559": "60.7922_-161.7558", "99561": "60.1537_-164.2103", "99575": "61.8181_-158.0025", "99578": "60.2151_-162.0323", "99589": "59.1189_-161.5875", "99607": "61.541_-160.3261", "99609": "60.8956_-162.5181", "99614": "59.9232_-164.101", "99621": "60.8122_-161.4358", "99622": "59.8644_-163.1342", "99626": "61.5138_-160.36", "99630": "60.3657_-166.2836", "99634": "60.6967_-161.9519", "99637": "60.5338_-165.1037", "99641": "60.8969_-162.4594", "99651": "59.0131_-161.8164", "99655": "59.7381_-161.8749", "99656": "61.7611_-157.3125", "99668": "61.7025_-157.1697", "99679": "61.1088_-160.9389", "99680": "60.3431_-162.6631", "99681": "60.5856_-165.2558", "99690": "60.4794_-164.7239", "99613": "58.6883_-156.6614", "99633": "58.783_-156.8992", "99670": "58.6639_-156.9756", "99704": "64.2966_-149.1608", "99729": "63.3955_-148.8973", "99743": "63.9171_-149.0111", "99744": "64.3442_-149.1869", "99755": "63.5436_-149.9867", "99555": "59.2697_-158.6199", "99569": "58.8173_-158.5299", "99576": "59.0402_-158.5231", "99580": "59.3628_-157.4782", "99628": "59.0096_-158.9897", "99636": "59.4882_-157.2905", "99678": "59.0619_-160.3764", "99701": "64.8378_-147.7164", "99702": "64.6735_-147.0805", "99703": "64.8283_-147.6557", "99705": "64.7805_-147.3694", "99706": "64.8521_-147.9377", "99707": "64.8378_-147.7164", "99708": "64.9475_-147.8564", "99709": "64.8544_-147.8469", "99710": "64.8378_-147.7164", "99711": "64.8378_-147.7164", "99712": "64.9109_-147.5105", "99714": "64.5091_-146.953", "99716": "64.8746_-146.8982", "99725": "64.871_-148.0949", "99775": "64.8591_-147.8267", "99790": "64.8378_-147.7164", "99827": "59.2519_-135.542", "99801": "58.3628_-134.5294", "99802": "58.3019_-134.4197", "99803": "58.3019_-134.4197", "99811": "58.3019_-134.4197", "99812": "58.3271_-134.4742", "99821": "58.4494_-134.7003", "99824": "58.2756_-134.395", "99850": "58.3019_-134.4197", "99556": "59.8371_-151.7078", "99568": "60.2311_-151.3936", "99572": "60.4767_-149.8235", "99603": "59.5374_-151.2356", "99605": "60.8726_-149.4683", "99610": "60.3164_-151.2896", "99611": "60.6145_-151.2546", "99631": "60.6148_-149.4056", "99635": "60.7007_-151.2766", "99639": "60.0108_-151.6396", "99663": "59.4495_-151.7009", "99664": "60.1329_-149.3985", "99669": "60.4818_-151.1358", "99672": "60.5136_-150.8532", "99682": "61.0681_-151.1369", "99901": "55.372_-131.6832", "99928": "55.3954_-131.6754", "99950": "55.3422_-131.6478", "99550": "57.8675_-152.8822", "99608": "57.5689_-154.4551", "99615": "57.6036_-153.3751", "99619": "57.79_-152.4072", "99624": "57.54_-153.9786", "99643": "57.2028_-153.3039", "99644": "57.9236_-152.5022", "99697": "57.79_-152.4072", "99554": "62.6944_-164.6475", "99563": "61.529_-165.5905", "99581": "62.7818_-164.5335", "99585": "61.9287_-162.268", "99604": "61.527_-166.1151", "99620": "63.0295_-163.5542", "99632": "62.1123_-163.6644", "99650": "61.9462_-162.8747", "99657": "61.7744_-161.3939", "99658": "62.1172_-163.2376", "99662": "61.845_-165.5819", "99666": "62.5309_-164.8496", "99548": "56.2448_-158.7578", "99549": "56.9643_-158.5664", "99564": "56.3016_-158.4157", "99565": "58.2687_-156.6484", "99579": "58.2062_-157.3422", "99606": "59.7525_-154.8236", "99625": "59.2905_-156.6503", "99640": "59.9736_-154.8458", "99647": "59.8681_-154.0757", "99648": "55.9453_-159.2593", "99649": "57.5642_-157.5792", "99653": "60.2025_-154.3128", "99623": "61.5463_-149.5901", "99629": "61.5841_-149.4436", "99645": "61.6303_-148.9872", "99652": "61.5214_-149.9544", "99654": "61.5923_-149.3959", "99667": "61.9903_-151.3978", "99674": "61.7327_-148.7837", "99676": "62.2605_-150.1101", "99683": "62.3167_-150.2314", "99687": "61.5313_-149.4784", "99688": "61.8966_-150.0038", "99694": "61.6303_-149.8181", "99659": "63.4776_-162.1091", "99671": "63.5222_-162.2881", "99684": "63.8835_-160.7884", "99739": "64.6217_-162.2604", "99742": "63.7766_-171.7017", "99753": "64.9319_-161.1569", "99762": "64.5011_-165.4064", "99769": "63.6797_-170.4709", "99771": "64.3537_-161.1932", "99772": "66.2306_-166.1373", "99778": "65.2402_-166.3833", "99783": "65.6092_-168.0875", "99784": "64.6814_-163.4056", "99785": "65.3342_-166.4786", "99721": "68.1433_-151.7358", "99723": "71.2346_-156.8174", "99734": "70.2922_-148.6694", "99747": "70.1319_-143.6239", "99759": "69.7439_-163.0084", "99766": "68.3486_-166.7347", "99782": "70.6369_-160.0383", "99789": "70.1927_-150.9971", "99791": "70.4947_-157.4411", "99727": "65.9789_-161.1262", "99736": "66.0737_-162.714", "99749": "66.975_-160.4228", "99750": "67.7269_-164.5333", "99751": "66.9072_-156.8811", "99752": "66.8985_-162.5981", "99761": "67.5711_-162.9653", "99763": "66.8364_-161.0441", "99770": "66.6039_-160.0069", "99773": "66.8881_-157.1364", "99786": "67.0861_-157.8514", "99903": "55.7408_-132.2564", "99918": "55.9524_-132.7503", "99919": "55.6609_-132.5138", "99921": "55.4732_-133.1171", "99922": "55.2087_-132.8259", "99923": "55.9169_-130.0247", "99925": "55.5526_-133.0555", "99926": "55.1215_-131.579", "99927": "56.3528_-133.6211", "99835": "57.0514_-135.3166", "99689": "59.812_-139.5505", "99820": "57.5005_-134.586", "99825": "58.1944_-136.3433", "99826": "58.4284_-135.7615", "99829": "58.0977_-135.4316", "99832": "57.9608_-136.2275", "99840": "59.4685_-135.3018", "99841": "57.7808_-135.2189", "99731": "63.952_-146.451", "99732": "64.0733_-141.9361", "99737": "64.0378_-145.7322", "99738": "64.7881_-141.2", "99764": "62.9617_-141.9372", "99776": "63.3853_-143.3464", "99780": "63.3367_-142.9856", "99566": "61.5156_-144.4396", "99573": "61.977_-145.3297", "99574": "60.5362_-145.7534", "99586": "62.3014_-145.3027", "99588": "62.1039_-145.6617", "99677": "60.8906_-146.6703", "99686": "61.101_-146.9", "99693": "60.7734_-148.6839", "99830": "56.9736_-133.936", "99833": "56.8271_-133.1607", "99836": "56.2497_-134.6444", "99929": "56.4335_-132.3529", "99558": "62.6561_-160.2067", "99590": "62.9036_-160.0647", "99602": "62.1926_-159.8251", "99627": "62.9457_-155.5712", "99665": "62.6822_-159.5619", "99675": "62.9886_-156.0642", "99691": "63.0133_-154.375", "99720": "66.5656_-152.6456", "99722": "68.1269_-145.5378", "99724": "66.3594_-147.3964", "99726": "65.2264_-151.0251", "99730": "65.4681_-144.7489", "99733": "65.8245_-144.0826", "99740": "66.5647_-145.2739", "99741": "64.7333_-156.9275", "99745": "66.0382_-154.2644", "99746": "65.6899_-156.292", "99748": "64.3305_-158.7243", "99754": "64.8803_-157.7008", "99756": "65.0011_-150.6339", "99757": "63.8828_-152.3122", "99758": "65.0584_-149.6912", "99760": "64.5577_-149.0867", "99765": "64.7194_-158.1031", "99767": "65.509_-150.1619", "99768": "64.7201_-155.5039", "99774": "66.0064_-149.0908", "99777": "65.1719_-152.0789", "99781": "67.0104_-146.4137", "99788": "66.6544_-143.7222", "36003": "32.4625_-86.7149", "36006": "32.6596_-86.7178", "36008": "32.5016_-86.5727", "36051": "32.6841_-86.4946", "36066": "32.4787_-86.43", "36067": "32.4715_-86.4831", "36068": "32.464_-86.4597", "36749": "32.5104_-86.8138", "36507": "30.8635_-87.7644", "36511": "30.3128_-87.7431", "36526": "30.6197_-87.8895", "36527": "30.6959_-87.8867", "36530": "30.3942_-87.589", "36532": "30.5012_-87.8835", "36533": "30.4841_-87.8606", "36535": "30.4007_-87.6857", "36536": "30.4222_-87.7064", "36542": "30.2717_-87.7589", "36547": "30.246_-87.7008", "36549": "30.3972_-87.4745", "36550": "31.2246_-87.7548", "36551": "30.618_-87.7562", "36555": "30.3996_-87.7761", "36559": "30.5623_-87.9005", "36561": "30.281_-87.5815", "36562": "31.0403_-87.6667", "36564": "30.4741_-87.9192", "36567": "30.5616_-87.6373", "36574": "30.5048_-87.4659", "36576": "30.5222_-87.7457", "36577": "30.6749_-87.9153", "36578": "30.7476_-87.7787", "36579": "31.0129_-87.8633", "36580": "30.4752_-87.6992", "36016": "31.8874_-85.4509", "36017": "31.6852_-85.5904", "36027": "31.9051_-85.1656", "36048": "31.7943_-85.5581", "36072": "31.8913_-85.1455", "35034": "32.9357_-87.2114", "35035": "33.0427_-86.9517", "35042": "32.9503_-87.1192", "35074": "33.2251_-87.1264", "35184": "33.1424_-87.1369", "35188": "33.2068_-87.15", "36792": "32.8888_-86.907", "36793": "32.8646_-86.9567", "35013": "33.9222_-86.4493", "35031": "34.0929_-86.5686", "35049": "33.9778_-86.5598", "35079": "33.9534_-86.7455", "35097": "33.905_-86.6261", "35121": "33.9259_-86.4741", "35133": "33.8168_-86.6008", "36029": "32.2165_-85.8888", "36053": "32.0955_-85.5315", "36061": "32.0928_-85.7046", "36089": "32.1443_-85.7149", "36015": "31.6427_-86.7343", "36030": "31.8501_-86.8372", "36033": "31.6287_-86.734", "36037": "31.81_-86.6229", "36456": "31.545_-86.7356", "36201": "33.6539_-85.8382", "36202": "33.7622_-85.8378", "36203": "33.5815_-85.8328", "36204": "33.7622_-85.8378", "36205": "33.7358_-85.7933", "36206": "33.7191_-85.8389", "36207": "33.6803_-85.7137", "36250": "33.7808_-85.8924", "36253": "33.7622_-85.8378", "36254": "33.6573_-85.6991", "36257": "33.7622_-85.8378", "36260": "33.6031_-85.9608", "36265": "33.831_-85.7752", "36271": "33.7788_-86.0254", "36272": "33.8389_-85.646", "36277": "33.7563_-85.8107", "36279": "33.8226_-85.8927", "36852": "32.7831_-85.2756", "36854": "32.8113_-85.1749", "36855": "33.0424_-85.3243", "36862": "32.9252_-85.4426", "36863": "32.8616_-85.2161", "35959": "34.2417_-85.6026", "35960": "34.1116_-85.6092", "35973": "34.3573_-85.5589", "35983": "34.1911_-85.7705", "36275": "33.9778_-85.5521", "35045": "32.8355_-86.6425", "35046": "32.9229_-86.545", "35085": "32.9805_-86.7181", "35171": "32.9157_-86.7158", "36091": "32.7499_-86.5114", "36750": "32.8045_-86.8717", "36790": "32.7332_-86.8963", "36904": "32.0829_-88.2064", "36908": "31.8666_-88.3265", "36910": "32.2299_-88.1684", "36912": "32.2177_-88.3234", "36913": "31.9304_-88.4589", "36915": "31.9879_-88.3367", "36916": "32.2094_-88.049", "36919": "31.7668_-88.3091", "36921": "31.9155_-88.151", "36922": "32.3038_-88.1476", "36436": "31.7635_-87.7106", "36446": "31.7925_-87.72", "36451": "31.7088_-87.7772", "36482": "31.6395_-87.6565", "36524": "31.7843_-88.0715", "36540": "31.4258_-87.6822", "36545": "31.5131_-87.8672", "36727": "31.9213_-88.008", "36784": "31.9067_-87.7598", "35082": "33.1162_-86.1386", "36251": "33.2474_-85.829", "36255": "33.2171_-85.7108", "36258": "33.4573_-85.6793", "36266": "33.3286_-85.7346", "36267": "33.1915_-85.9258", "36261": "33.7066_-85.5099", "36262": "33.7717_-85.4381", "36264": "33.6115_-85.5885", "36269": "33.7529_-85.3789", "36273": "33.5616_-85.3786", "36323": "31.4137_-86.0777", "36330": "31.3408_-85.8421", "36331": "31.2978_-85.9036", "36346": "31.5652_-85.971", "36351": "31.369_-85.9404", "36453": "31.1926_-86.1514", "35616": "34.7442_-87.9724", "35646": "34.711_-87.5221", "35660": "34.7578_-87.6971", "35661": "34.7561_-87.6304", "35662": "34.7448_-87.6675", "35674": "34.6874_-87.6833", "36401": "31.458_-86.9258", "36429": "31.2627_-86.7711", "36432": "31.2991_-87.0225", "36454": "31.3366_-87.1855", "36473": "31.3058_-87.2137", "36475": "31.4256_-87.172", "35072": "33.0746_-86.0781", "35089": "32.9791_-86.0484", "35136": "32.878_-86.24", "35183": "33.0238_-86.3042", "36026": "32.8139_-86.1051", "36038": "31.4068_-86.4841", "36420": "31.2971_-86.4905", "36442": "31.0172_-86.3385", "36455": "31.0105_-86.3497", "36467": "31.2799_-86.2571", "36474": "31.4399_-86.6121", "36476": "31.3533_-86.541", "36483": "31.0223_-86.6293", "36009": "31.571_-86.2743", "36028": "31.5066_-86.3663", "36034": "31.6641_-86.171", "36041": "31.9283_-86.2971", "36042": "31.8784_-86.3981", "36049": "31.7074_-86.2566", "36062": "31.8488_-86.2077", "36071": "31.7062_-86.3715", "35019": "34.2683_-86.6213", "35033": "33.9737_-87.0043", "35053": "34.0821_-87.0484", "35055": "34.1761_-86.8298", "35056": "34.1748_-86.8436", "35057": "34.0878_-86.9447", "35058": "34.2098_-86.752", "35070": "34.0058_-86.7499", "35077": "34.0516_-86.7848", "35083": "34.1901_-86.6174", "35087": "34.2837_-86.5519", "35098": "34.1377_-87.0266", "35179": "34.2621_-86.9125", "36311": "31.583_-85.7077", "36317": "31.6446_-85.3911", "36322": "31.2811_-85.7305", "36350": "31.3191_-85.4938", "36352": "31.3311_-85.5992", "36360": "31.4391_-85.6436", "36361": "31.4591_-85.6405", "36362": "31.348_-85.7214", "36371": "31.3074_-85.5263", "36374": "31.5748_-85.537", "36701": "32.4197_-87.0245", "36702": "32.4074_-87.0211", "36703": "32.4156_-87.0135", "36758": "32.6176_-86.9475", "36759": "32.4266_-87.2702", "36761": "32.1899_-87.0633", "36767": "32.2949_-87.2214", "36773": "32.3002_-87.3693", "36775": "32.2844_-86.992", "36785": "32.3239_-86.8646", "35961": "34.268_-85.862", "35962": "34.2588_-86.0306", "35963": "34.3568_-85.9292", "35967": "34.4368_-85.7124", "35968": "34.4898_-85.7657", "35971": "34.4373_-85.9288", "35974": "34.3592_-86.024", "35975": "34.4359_-86.04", "35978": "34.6186_-85.7274", "35981": "34.7351_-85.6416", "35984": "34.5872_-85.5777", "35986": "34.4989_-85.8446", "35988": "34.559_-85.7921", "35989": "34.5697_-85.6272", "36020": "32.5056_-86.3322", "36022": "32.6082_-86.3958", "36024": "32.6542_-86.0316", "36025": "32.5454_-86.3161", "36045": "32.619_-85.9486", "36054": "32.4995_-86.3641", "36078": "32.551_-85.8978", "36080": "32.69_-86.2393", "36092": "32.5927_-86.2153", "36093": "32.5622_-86.0994", "36426": "31.1294_-87.0961", "36427": "31.1052_-87.0722", "36441": "31.0402_-87.2664", "36502": "31.0572_-87.4873", "36503": "31.0238_-87.4939", "36504": "31.0158_-87.4972", "36543": "31.2202_-87.4619", "35901": "34.048_-85.9246", "35902": "34.0143_-86.0066", "35903": "33.9845_-85.9077", "35904": "34.0217_-86.0495", "35905": "33.9352_-85.9576", "35906": "33.9318_-86.0898", "35907": "33.8979_-86.0245", "35952": "34.071_-86.2096", "35954": "34.0296_-86.0967", "35972": "33.9976_-86.2346", "35990": "34.0657_-86.3064", "35542": "33.7008_-87.6897", "35545": "33.6476_-87.9314", "35546": "33.6945_-87.6226", "35555": "33.6974_-87.8346", "35559": "33.9151_-87.7417", "35571": "34.3417_-87.959", "35581": "34.347_-87.7154", "35582": "34.4513_-88.1129", "35585": "34.4246_-87.8145", "35593": "34.3712_-88.0774", "35653": "34.5066_-87.7257", "35654": "34.4675_-87.6478", "36313": "31.1732_-85.7933", "36314": "31.0132_-85.7456", "36316": "31.1767_-85.8135", "36318": "31.1388_-85.9182", "36340": "31.0414_-85.8847", "36344": "31.086_-85.7192", "36349": "31.1212_-85.5592", "36375": "31.0956_-85.583", "36477": "31.1049_-86.0674", "35443": "32.7746_-88.0267", "35448": "32.9137_-87.9925", "35462": "32.8889_-87.9303", "35469": "32.9824_-87.7919", "35491": "32.9237_-88.0853", "36740": "32.6108_-87.8441", "35441": "32.8553_-87.7219", "35474": "32.9108_-87.5935", "36742": "32.5298_-87.6985", "36744": "32.7167_-87.5905", "36765": "32.5515_-87.5615", "36776": "32.7578_-87.7402", "36310": "31.5755_-85.279", "36345": "31.3534_-85.3323", "36353": "31.4403_-85.3287", "36373": "31.501_-85.1135", "36301": "31.1481_-85.3718", "36302": "31.2232_-85.3905", "36303": "31.2668_-85.3971", "36304": "31.156_-85.3559", "36305": "31.2197_-85.4828", "36312": "31.1888_-85.2535", "36319": "31.3352_-85.1455", "36320": "31.0507_-85.3154", "36321": "31.2025_-85.3014", "36343": "31.1002_-85.1234", "36370": "31.1403_-85.1573", "36376": "31.2656_-85.2544", "35740": "34.9446_-85.7277", "35744": "34.6046_-85.9067", "35745": "34.913_-86.1716", "35746": "34.8259_-85.9846", "35751": "34.7955_-86.2743", "35752": "34.7304_-85.9532", "35755": "34.5001_-86.1353", "35764": "34.7031_-86.3068", "35765": "34.6809_-85.8478", "35766": "34.8713_-86.2513", "35768": "34.7507_-86.1422", "35769": "34.618_-86.0562", "35771": "34.5433_-85.994", "35772": "34.8769_-85.8508", "35774": "34.7632_-86.2295", "35776": "34.6689_-86.2296", "35958": "34.945_-85.6324", "35966": "34.8076_-85.7084", "35979": "34.8391_-85.6196", "35005": "33.5884_-86.9597", "35006": "33.4343_-87.1675", "35015": "33.5793_-86.6375", "35020": "33.409_-86.9475", "35021": "33.5446_-86.9292", "35022": "33.3224_-86.9657", "35023": "33.468_-87.0924", "35036": "33.6379_-86.9167", "35048": "33.7026_-86.5997", "35060": "33.5589_-86.9294", "35061": "33.4654_-86.9564", "35064": "33.4735_-86.9183", "35068": "33.6017_-86.8265", "35071": "33.7189_-86.8225", "35073": "33.6539_-86.9803", "35091": "33.7684_-86.8084", "35094": "33.5283_-86.5748", "35111": "33.2845_-87.1024", "35116": "33.7392_-86.7726", "35117": "33.6768_-86.8717", "35118": "33.5363_-87.051", "35119": "33.649_-86.7686", "35123": "33.7387_-86.6461", "35126": "33.7299_-86.6451", "35127": "33.4883_-86.9766", "35139": "33.7111_-86.9759", "35142": "33.4069_-86.8735", "35172": "33.819_-86.7434", "35173": "33.6339_-86.5981", "35180": "33.8529_-86.8198", "35181": "33.5446_-86.9292", "35201": "33.5207_-86.8025", "35202": "33.5207_-86.8025", "35203": "33.521_-86.8066", "35204": "33.5179_-86.8372", "35205": "33.4951_-86.8059", "35206": "33.5678_-86.7199", "35207": "33.5594_-86.8153", "35208": "33.4977_-86.8799", "35209": "33.4653_-86.8082", "35210": "33.5452_-86.6655", "35211": "33.4816_-86.859", "35212": "33.5409_-86.7495", "35213": "33.5066_-86.7428", "35214": "33.5554_-86.887", "35215": "33.6493_-86.7057", "35216": "33.4188_-86.7867", "35217": "33.5887_-86.765", "35218": "33.506_-86.893", "35219": "33.5446_-86.9292", "35220": "33.5446_-86.9292", "35221": "33.4523_-86.8935", "35222": "33.5219_-86.7666", "35223": "33.4995_-86.7268", "35224": "33.5191_-86.9342", "35226": "33.3967_-86.8346", "35228": "33.4558_-86.9118", "35229": "33.4629_-86.7904", "35231": "33.5446_-86.9292", "35232": "33.5446_-86.9292", "35233": "33.5062_-86.8003", "35234": "33.5378_-86.8068", "35235": "33.6328_-86.6493", "35236": "33.5446_-86.9292", "35237": "33.5207_-86.8025", "35238": "33.5446_-86.9292", "35243": "33.4459_-86.7502", "35244": "33.3538_-86.8254", "35246": "33.5207_-86.8025", "35249": "33.5207_-86.8025", "35253": "33.5446_-86.9292", "35254": "33.5446_-86.9292", "35255": "33.5446_-86.9292", "35259": "33.5446_-86.9292", "35260": "33.5446_-86.9292", "35261": "33.5446_-86.9292", "35266": "33.3729_-86.8531", "35270": "33.5206_-86.8025", "35282": "33.5446_-86.9292", "35283": "33.5207_-86.8025", "35285": "33.5446_-86.9292", "35287": "33.5207_-86.8025", "35288": "33.4458_-86.9285", "35290": "33.5446_-86.9292", "35291": "33.5207_-86.8025", "35292": "33.5207_-86.8025", "35293": "33.5446_-86.9292", "35294": "33.5446_-86.9292", "35295": "33.5207_-86.8025", "35296": "33.5446_-86.9292", "35297": "33.5446_-86.9292", "35298": "33.5446_-86.9292", "35544": "33.9429_-88.0157", "35552": "34.0282_-88.17", "35574": "33.6153_-87.9948", "35576": "33.5401_-88.2", "35586": "33.8549_-88.1508", "35592": "33.7613_-88.0979", "35610": "34.9424_-87.2734", "35617": "34.9387_-87.7714", "35630": "34.8305_-87.656", "35631": "34.87_-87.7069", "35632": "34.87_-87.7069", "35633": "34.8825_-87.7398", "35634": "34.9186_-87.6136", "35645": "34.9016_-87.5082", "35648": "34.9559_-87.3935", "35652": "34.8495_-87.3237", "35677": "34.9357_-87.9624", "35618": "34.6719_-87.3143", "35643": "34.6476_-87.1804", "35650": "34.5058_-87.2224", "35651": "34.4793_-87.4769", "35672": "34.6491_-87.4262", "36801": "32.6454_-85.3783", "36802": "32.5782_-85.349", "36803": "32.6454_-85.3783", "36804": "32.5768_-85.312", "36830": "32.5475_-85.4682", "36831": "32.6099_-85.4808", "36832": "32.592_-85.5189", "36849": "32.6024_-85.4873", "36865": "32.6043_-85.5933", "36872": "32.5782_-85.349", "36874": "32.6212_-85.184", "36877": "32.5401_-85.0985", "36879": "32.7632_-85.5144", "35611": "34.8036_-86.9707", "35612": "34.7749_-87.0305", "35613": "34.8317_-86.8867", "35614": "34.8474_-87.0607", "35615": "34.6568_-86.8792", "35620": "34.929_-86.9739", "35647": "34.9596_-87.1006", "35649": "34.6259_-86.8746", "35671": "34.6796_-86.9625", "35739": "34.9804_-86.8346", "35742": "34.7731_-86.7928", "36032": "31.996_-86.5761", "36040": "32.1957_-86.655", "36047": "32.0862_-86.488", "36752": "32.2943_-86.6471", "36031": "32.2507_-85.7524", "36039": "32.3129_-85.8838", "36075": "32.3836_-85.9162", "36083": "32.4316_-85.6861", "36087": "32.4093_-85.738", "36088": "32.4145_-85.7253", "36866": "32.5437_-85.6871", "35741": "34.7167_-86.4687", "35748": "34.714_-86.394", "35749": "34.8273_-86.7499", "35750": "34.9496_-86.5935", "35756": "34.643_-86.8168", "35757": "34.7782_-86.7442", "35758": "34.7108_-86.7425", "35759": "34.8618_-86.5789", "35760": "34.5494_-86.3961", "35761": "34.9_-86.4487", "35762": "34.789_-86.5719", "35763": "34.6215_-86.4644", "35767": "34.7698_-86.4808", "35773": "34.9116_-86.7", "35801": "34.7269_-86.5673", "35802": "34.6679_-86.5603", "35803": "34.6205_-86.551", "35804": "34.7284_-86.5853", "35805": "34.7059_-86.6165", "35806": "34.7448_-86.6704", "35807": "34.734_-86.5229", "35808": "34.6845_-86.6538", "35809": "34.734_-86.5229", "35810": "34.7784_-86.6091", "35811": "34.7789_-86.5438", "35812": "34.734_-86.5229", "35813": "34.734_-86.5229", "35814": "34.734_-86.5229", "35815": "34.734_-86.5229", "35816": "34.7389_-86.6249", "35824": "34.6583_-86.7295", "35893": "34.7304_-86.5861", "35894": "34.734_-86.5229", "35895": "34.7304_-86.5861", "35896": "34.7543_-86.6546", "35897": "34.734_-86.5229", "35898": "34.734_-86.5229", "35899": "34.7339_-86.6456", "36732": "32.4908_-87.8397", "36736": "32.0672_-87.7454", "36738": "32.4233_-87.6181", "36745": "32.414_-87.8986", "36748": "32.3053_-87.7954", "36754": "32.1419_-87.6998", "36763": "32.2516_-87.9494", "36764": "32.1129_-87.9881", "36782": "32.0773_-87.9228", "36783": "32.2538_-87.5974", "35543": "34.1649_-87.7396", "35548": "34.0377_-87.7563", "35563": "33.9676_-87.9024", "35564": "34.2678_-87.8608", "35570": "34.1534_-88.0085", "35594": "33.9303_-87.7972", "35016": "34.3283_-86.4896", "35175": "34.4093_-86.4628", "35747": "34.4959_-86.259", "35950": "34.2739_-86.2064", "35951": "34.3223_-86.1935", "35956": "34.1437_-86.148", "35957": "34.1921_-86.1941", "35964": "34.1737_-86.3236", "35976": "34.3449_-86.2752", "35980": "34.19_-86.3173", "36421": "31.3247_-86.5067", "36505": "30.9394_-88.0159", "36509": "30.408_-88.2507", "36512": "31.0105_-88.0242", "36521": "30.9912_-88.1311", "36522": "31.0425_-88.2549", "36523": "30.3903_-88.2076", "36525": "30.9013_-88.0174", "36528": "30.2521_-88.1096", "36541": "30.4983_-88.3282", "36544": "30.4802_-88.2396", "36560": "31.0974_-88.035", "36568": "30.5035_-88.2542", "36571": "30.8332_-88.0934", "36572": "30.8516_-88.0533", "36575": "30.7544_-88.2667", "36582": "30.5444_-88.1807", "36587": "30.8137_-88.3332", "36590": "30.488_-88.2533", "36601": "30.6944_-88.0431", "36602": "30.6888_-88.0453", "36603": "30.6921_-88.0562", "36604": "30.682_-88.0678", "36605": "30.6341_-88.0846", "36606": "30.6729_-88.1009", "36607": "30.6975_-88.1029", "36608": "30.6817_-88.2945", "36609": "30.6605_-88.1618", "36610": "30.7309_-88.0789", "36611": "30.7705_-88.0781", "36612": "30.7518_-88.1131", "36613": "30.7951_-88.1823", "36615": "30.6411_-88.0622", "36616": "30.671_-88.1267", "36617": "30.7145_-88.0918", "36618": "30.7322_-88.1758", "36619": "30.5928_-88.1946", "36628": "30.6944_-88.0431", "36633": "30.6589_-88.178", "36640": "30.6589_-88.178", "36641": "30.6589_-88.178", "36644": "30.6944_-88.0431", "36652": "30.6944_-88.0431", "36660": "30.6589_-88.178", "36663": "30.6944_-88.0431", "36670": "30.6589_-88.178", "36671": "30.6589_-88.178", "36675": "30.6944_-88.0431", "36685": "30.6589_-88.178", "36688": "30.6962_-88.1821", "36689": "30.6589_-88.178", "36691": "30.6944_-88.0431", "36693": "30.6311_-88.1588", "36695": "30.6474_-88.2292", "36425": "31.7273_-87.1719", "36439": "31.4279_-87.3414", "36444": "31.7238_-87.4412", "36445": "31.4235_-87.3817", "36449": "31.3368_-87.4258", "36457": "31.3612_-87.4353", "36458": "31.5147_-87.4084", "36460": "31.5153_-87.341", "36461": "31.5221_-87.3411", "36470": "31.5141_-87.4933", "36471": "31.59_-87.26", "36480": "31.3135_-87.5705", "36481": "31.8085_-87.3164", "36013": "32.2937_-85.9827", "36036": "32.0194_-86.1292", "36043": "32.2243_-86.3932", "36046": "31.9657_-86.2844", "36052": "32.1283_-86.0413", "36057": "32.2334_-86.2085", "36064": "32.3357_-86.0959", "36065": "32.0726_-86.0606", "36069": "32.0677_-86.2463", "36101": "32.357_-86.2578", "36102": "32.2334_-86.2085", "36103": "32.3462_-86.2873", "36104": "32.373_-86.3081", "36105": "32.3257_-86.3104", "36106": "32.3543_-86.2673", "36107": "32.3804_-86.2799", "36108": "32.3417_-86.3529", "36109": "32.3834_-86.2434", "36110": "32.4217_-86.275", "36111": "32.3374_-86.2715", "36112": "32.3808_-86.3491", "36113": "32.3846_-86.3039", "36114": "32.404_-86.2539", "36115": "32.4076_-86.2474", "36116": "32.3129_-86.2421", "36117": "32.3736_-86.1833", "36118": "32.2334_-86.2085", "36119": "32.2334_-86.2085", "36120": "32.2334_-86.2085", "36121": "32.2334_-86.2085", "36123": "32.3668_-86.3", "36124": "32.2334_-86.2085", "36125": "32.2334_-86.2085", "36130": "32.2334_-86.2085", "36131": "32.2334_-86.2085", "36132": "32.2334_-86.2085", "36135": "32.2334_-86.2085", "36140": "32.2334_-86.2085", "36141": "32.2334_-86.2085", "36142": "32.2334_-86.2085", "36177": "32.2334_-86.2085", "36191": "32.2334_-86.2085", "35601": "34.5896_-86.9887", "35602": "34.6059_-86.9833", "35603": "34.5484_-87.0004", "35609": "34.6059_-86.9833", "35619": "34.3873_-87.1454", "35621": "34.3323_-86.7589", "35622": "34.3477_-86.9131", "35640": "34.4482_-86.9242", "35670": "34.4995_-86.8009", "35673": "34.5918_-87.0913", "35699": "34.6059_-86.9833", "35754": "34.4996_-86.6129", "35775": "34.542_-86.6871", "36756": "32.6463_-87.3314", "36786": "32.447_-87.4934", "35442": "33.1228_-88.1667", "35447": "33.2485_-88.1321", "35461": "33.4157_-88.2167", "35466": "33.3469_-87.9005", "35471": "33.2626_-88.0885", "35481": "33.3959_-88.0203", "36005": "31.8368_-85.7998", "36010": "31.7013_-85.8177", "36035": "31.7946_-86.1277", "36079": "31.7595_-86.0107", "36081": "31.7945_-85.9655", "36082": "31.8028_-85.9546", "36263": "33.463_-85.334", "36274": "33.1512_-85.3722", "36276": "33.1492_-85.5513", "36278": "33.3019_-85.4737", "36280": "33.3743_-85.3997", "36851": "32.1468_-85.0738", "36856": "32.2965_-84.9972", "36858": "32.2845_-85.3029", "36859": "32.2298_-85.0082", "36860": "32.2454_-85.3959", "36867": "32.4978_-85.0234", "36868": "32.4646_-85.0206", "36869": "32.4204_-85.0796", "36870": "32.4781_-85.124", "36871": "32.1733_-85.1312", "36875": "32.3053_-85.1677", "35004": "33.6035_-86.4668", "35052": "33.5895_-86.3923", "35054": "33.5296_-86.3007", "35112": "33.6862_-86.475", "35120": "33.6756_-86.409", "35125": "33.5979_-86.3432", "35128": "33.5873_-86.3366", "35131": "33.7367_-86.1619", "35135": "33.6166_-86.1996", "35146": "33.7386_-86.4394", "35182": "33.7068_-86.2567", "35953": "33.8374_-86.2552", "35987": "33.9417_-86.2289", "35007": "33.1934_-86.7944", "35040": "33.1098_-86.756", "35043": "33.2982_-86.6563", "35051": "33.177_-86.6161", "35078": "33.3234_-86.4424", "35080": "33.2663_-86.902", "35114": "33.2317_-86.8727", "35115": "33.1248_-86.8622", "35124": "33.2932_-86.768", "35137": "33.2063_-86.7812", "35143": "33.0785_-86.5536", "35144": "33.2293_-86.825", "35147": "33.4461_-86.4917", "35176": "33.4807_-86.5013", "35178": "33.401_-86.3994", "35185": "33.3356_-86.5437", "35186": "33.2293_-86.5299", "35187": "33.081_-86.8793", "35242": "33.3813_-86.7046", "35459": "32.755_-88.3057", "35460": "32.672_-88.1206", "35464": "32.821_-88.1589", "35470": "32.5843_-88.1872", "35477": "32.8726_-88.2374", "36901": "32.449_-88.1336", "36907": "32.411_-88.3611", "36925": "32.4728_-88.2683", "35014": "33.404_-86.2339", "35032": "33.2649_-86.3364", "35044": "33.2459_-86.3641", "35096": "33.6059_-86.1112", "35149": "33.2512_-86.2025", "35150": "33.1717_-86.2713", "35151": "33.1756_-86.3574", "35160": "33.4354_-86.1134", "35161": "33.4202_-86.1028", "36268": "33.541_-85.9363", "35010": "32.9164_-85.9368", "35011": "32.9902_-85.958", "36023": "32.8002_-85.8034", "36256": "33.0335_-85.7538", "36850": "32.7827_-85.6474", "36853": "32.8224_-85.7704", "36861": "32.8797_-85.8487", "35401": "33.1969_-87.5627", "35402": "33.3066_-87.4532", "35403": "33.2045_-87.527", "35404": "33.1826_-87.4827", "35405": "33.1617_-87.5144", "35406": "33.2722_-87.536", "35407": "33.3066_-87.4532", "35440": "33.311_-87.1898", "35444": "33.2775_-87.309", "35446": "33.2306_-87.7547", "35449": "33.1359_-87.3384", "35452": "33.2934_-87.6888", "35453": "33.1767_-87.3871", "35456": "33.0618_-87.4422", "35457": "33.294_-87.7766", "35458": "33.2562_-87.7922", "35463": "33.0843_-87.6975", "35468": "33.3407_-87.3047", "35473": "33.2723_-87.5825", "35475": "33.3992_-87.5599", "35476": "33.2273_-87.5943", "35478": "33.3066_-87.4532", "35480": "33.1274_-87.7624", "35482": "33.3066_-87.4532", "35486": "33.2098_-87.5692", "35487": "33.3072_-87.5859", "35490": "33.175_-87.2574", "35038": "33.7079_-87.0875", "35062": "33.7357_-87.0546", "35063": "33.8256_-87.0161", "35130": "33.6561_-87.1007", "35148": "33.768_-87.0445", "35501": "33.8312_-87.2775", "35502": "33.8312_-87.2775", "35503": "33.9152_-87.3074", "35504": "33.8927_-87.1667", "35549": "33.9093_-87.5403", "35550": "33.768_-87.1841", "35554": "33.9315_-87.6194", "35560": "33.6795_-87.2374", "35573": "33.9018_-87.552", "35578": "33.9299_-87.4324", "35579": "33.7002_-87.3686", "35580": "33.7213_-87.2658", "35584": "33.8201_-87.0779", "35587": "33.847_-87.4372", "36513": "31.1552_-88.01", "36518": "31.4876_-88.2699", "36529": "31.2168_-88.3172", "36538": "31.6468_-88.1332", "36539": "31.3488_-88.3766", "36548": "31.491_-87.9687", "36553": "31.2361_-88.0511", "36556": "31.1913_-88.0075", "36558": "31.6269_-88.3559", "36569": "31.533_-88.0521", "36581": "31.3696_-88.0122", "36583": "31.4067_-88.1758", "36584": "31.2584_-88.3865", "36585": "31.4102_-88.0705", "36435": "31.8889_-87.3926", "36720": "32.1585_-87.3468", "36722": "32.0668_-87.5597", "36723": "32.0779_-87.2814", "36726": "32.0047_-87.295", "36728": "32.182_-87.4836", "36741": "32.0061_-86.9817", "36751": "31.8504_-87.5682", "36753": "32.0481_-87.2623", "36766": "31.947_-87.0745", "36768": "31.9265_-87.0047", "36769": "31.9735_-87.5771", "35540": "34.2056_-87.1948", "35541": "34.0632_-87.1828", "35551": "34.1701_-87.6059", "35553": "34.1387_-87.3974", "35565": "34.2314_-87.5938", "35572": "34.118_-87.2618", "35575": "34.053_-87.5398", "35577": "34.0934_-87.6008", "72003": "34.4146_-91.431", "72026": "34.5095_-91.299", "72038": "34.4528_-91.2692", "72042": "34.2853_-91.3336", "72048": "34.2435_-91.1398", "72055": "34.1218_-91.38", "72073": "34.4034_-91.679", "72140": "34.3878_-91.1463", "72160": "34.4854_-91.5487", "72166": "34.0893_-91.2437", "71635": "33.156_-91.9975", "71642": "33.3631_-91.9088", "71646": "33.2058_-91.8023", "71658": "33.3075_-91.5228", "71661": "33.1213_-91.5428", "71663": "33.2318_-91.5139", "71676": "33.0576_-91.5723", "72537": "36.4618_-92.2284", "72544": "36.4105_-92.1951", "72617": "36.0068_-92.3917", "72623": "36.4724_-92.3296", "72626": "36.2712_-92.5354", "72635": "36.3175_-92.4736", "72642": "36.373_-92.5422", "72651": "36.3933_-92.4881", "72653": "36.3312_-92.3753", "72654": "36.3353_-92.3852", "72658": "36.2066_-92.273", "72659": "36.2095_-92.2843", "72711": "36.4047_-94.0713", "72712": "36.3577_-94.2224", "72713": "36.3115_-94.3503", "72714": "36.4676_-94.2166", "72715": "36.4677_-94.3209", "72716": "36.3729_-94.2088", "72718": "36.2738_-94.2183", "72719": "36.367_-94.3089", "72722": "36.3347_-94.4534", "72732": "36.4288_-93.9512", "72733": "36.4864_-93.9277", "72734": "36.2652_-94.4751", "72736": "36.4155_-94.4779", "72739": "36.4416_-94.339", "72745": "36.2554_-94.1308", "72747": "36.3811_-94.5783", "72751": "36.4539_-94.118", "72756": "36.3363_-94.1148", "72757": "36.332_-94.1185", "72758": "36.3169_-94.1545", "72761": "36.18_-94.528", "72768": "36.4794_-94.4521", "72260": "34.7399_-92.34", "72601": "36.2417_-93.1062", "72602": "36.2298_-93.1077", "72611": "36.2998_-93.2792", "72615": "36.3083_-93.0321", "72630": "36.4645_-92.9202", "72633": "36.1534_-92.915", "72644": "36.3848_-93.0039", "72662": "36.4612_-93.1888", "72682": "36.1351_-92.7541", "71631": "33.5497_-92.2604", "71647": "33.39_-92.156", "71651": "33.3889_-92.2966", "71671": "33.614_-92.0778", "71744": "33.5376_-92.5295", "71745": "33.5101_-92.3988", "71766": "33.7768_-92.4862", "72613": "36.4311_-93.6994", "72616": "36.3519_-93.5587", "72631": "36.435_-93.7673", "72632": "36.4175_-93.7379", "72638": "36.3224_-93.4059", "72660": "36.4613_-93.4321", "71638": "33.5241_-91.4394", "71640": "33.1213_-91.2716", "71653": "33.3274_-91.2825", "71721": "33.8887_-93.2041", "71728": "34.0103_-93.0976", "71743": "33.9125_-93.1417", "71772": "33.8309_-93.1263", "71920": "34.229_-93.3791", "71921": "34.2594_-93.4206", "71923": "34.1153_-93.069", "71962": "34.0551_-93.2897", "71998": "34.1209_-93.0538", "71999": "34.1209_-93.0538", "72422": "36.4155_-90.587", "72424": "36.3897_-90.7231", "72430": "36.3348_-90.2253", "72435": "36.3176_-90.599", "72441": "36.437_-90.3837", "72453": "36.283_-90.6702", "72454": "36.387_-90.1926", "72456": "36.4317_-90.2751", "72461": "36.2672_-90.2702", "72464": "36.4534_-90.1454", "72470": "36.4536_-90.7281", "72044": "35.6321_-92.157", "72067": "35.5685_-92.1341", "72130": "35.6674_-92.0933", "72131": "35.405_-92.1333", "72179": "35.5106_-91.8648", "72523": "35.6414_-91.8333", "72530": "35.6616_-91.9398", "72543": "35.5103_-92.0392", "72545": "35.5352_-92.0213", "72546": "35.5816_-91.9305", "72581": "35.547_-91.9704", "71652": "33.86_-92.3014", "71660": "33.7588_-92.1939", "71665": "33.9453_-92.1188", "71740": "33.0891_-93.1987", "71752": "33.3622_-93.193", "71753": "33.2647_-93.2392", "71754": "33.2426_-93.23", "71770": "33.36_-93.2949", "71861": "33.108_-93.446", "72027": "35.3981_-92.5582", "72030": "35.3955_-92.702", "72063": "35.2907_-92.7783", "72080": "35.5699_-92.8251", "72107": "35.1356_-92.5498", "72110": "35.1692_-92.7354", "72127": "35.1575_-92.6204", "72156": "35.2701_-92.6754", "72157": "35.2749_-92.5457", "72401": "35.833_-90.6965", "72402": "35.8088_-90.6529", "72403": "35.8305_-90.7039", "72404": "35.7792_-90.766", "72405": "35.7792_-90.766", "72411": "35.7456_-90.5507", "72414": "35.8368_-90.4005", "72416": "35.9086_-90.7848", "72417": "35.9165_-90.5762", "72419": "35.759_-90.3358", "72421": "35.8301_-90.941", "72427": "35.864_-90.9428", "72437": "35.8171_-90.4423", "72447": "35.9002_-90.3437", "72467": "35.8422_-90.6735", "72921": "35.5_-94.2073", "72932": "35.603_-94.3749", "72934": "35.6898_-94.202", "72935": "35.4923_-94.1377", "72946": "35.6464_-94.1497", "72947": "35.5172_-93.9885", "72948": "35.6743_-94.4124", "72952": "35.5468_-94.2913", "72955": "35.5748_-94.4349", "72956": "35.454_-94.3278", "72957": "35.4368_-94.3483", "72301": "35.1484_-90.1779", "72303": "35.1465_-90.1845", "72325": "35.3093_-90.2362", "72327": "35.2119_-90.3351", "72331": "35.2799_-90.4503", "72332": "35.1042_-90.3133", "72339": "35.4057_-90.2714", "72364": "35.2077_-90.1989", "72376": "35.0834_-90.255", "72384": "35.3439_-90.2978", "72324": "35.3991_-90.7613", "72347": "35.3995_-90.9823", "72373": "35.2586_-90.5564", "72387": "35.3245_-90.7712", "72396": "35.233_-90.793", "71725": "34.0751_-92.5554", "71742": "33.8176_-92.4225", "71748": "33.9118_-92.4246", "71763": "33.9143_-92.8532", "71630": "33.6143_-91.2325", "71639": "33.8921_-91.4861", "71654": "33.6297_-91.3928", "71662": "33.842_-91.5022", "71666": "33.7609_-91.2757", "71670": "33.6981_-91.4433", "71674": "33.8907_-91.2815", "72379": "34.0665_-91.0071", "71655": "33.625_-91.7948", "71656": "33.629_-91.791", "71657": "33.629_-91.791", "71675": "33.6213_-91.9257", "71677": "33.7471_-91.4649", "72032": "35.0842_-92.4236", "72033": "35.1053_-92.3549", "72034": "35.0823_-92.4683", "72035": "35.1053_-92.3549", "72039": "35.3673_-92.4096", "72047": "35.2087_-92.2123", "72058": "35.2295_-92.3578", "72061": "35.3239_-92.2878", "72106": "34.9669_-92.4001", "72111": "35.2265_-92.124", "72173": "35.0719_-92.1832", "72181": "35.1645_-92.453", "72820": "35.41_-93.7286", "72821": "35.4346_-93.7598", "72928": "35.2971_-93.9454", "72930": "35.4252_-94.0409", "72933": "35.3115_-94.0337", "72949": "35.5246_-93.8374", "72515": "36.2901_-92.055", "72520": "36.4025_-91.7262", "72531": "36.3238_-92.0934", "72538": "36.4364_-92.0995", "72539": "36.2942_-91.7474", "72554": "36.4076_-91.5757", "72576": "36.3766_-91.8759", "72578": "36.4747_-91.8891", "72583": "36.3924_-91.9932", "71901": "34.5268_-92.9587", "71902": "34.5814_-93.0994", "71903": "34.5814_-93.0994", "71909": "34.6484_-92.983", "71910": "34.672_-92.9988", "71913": "34.5317_-93.0638", "71914": "34.5137_-92.9685", "71949": "34.7094_-93.0382", "71956": "34.5976_-93.1539", "71964": "34.4351_-93.242", "71968": "34.515_-93.2897", "72087": "34.5562_-92.834", "72057": "34.1309_-92.3109", "72084": "34.1856_-92.5979", "72128": "34.3023_-92.6095", "72129": "34.3079_-92.5131", "72150": "34.3165_-92.3657", "72412": "36.1281_-90.6914", "72425": "36.1995_-90.7345", "72436": "36.2359_-90.4811", "72443": "36.1951_-90.3837", "72450": "36.06_-90.5251", "72451": "36.0584_-90.4973", "72474": "36.0413_-90.6718", "71801": "33.6736_-93.6068", "71802": "33.6671_-93.5916", "71825": "33.8718_-93.5771", "71831": "33.7935_-93.807", "71838": "33.6299_-93.8086", "71847": "33.923_-93.6266", "71855": "33.9028_-93.7714", "71862": "33.7546_-93.6735", "71929": "34.311_-93.1872", "71933": "34.3848_-93.3819", "71941": "34.2212_-92.9094", "71942": "34.2235_-93.0024", "72019": "34.604_-92.6259", "72104": "34.3557_-92.8292", "72105": "34.4374_-92.8943", "71833": "34.1323_-94.0152", "71851": "33.8639_-93.9188", "71852": "33.9576_-93.8707", "71859": "33.7599_-93.8767", "71971": "34.2921_-94.0314", "72165": "35.5762_-91.4539", "72501": "35.7826_-91.6352", "72503": "35.7346_-91.5343", "72522": "35.8184_-91.4387", "72524": "35.8184_-91.3375", "72526": "35.8729_-91.754", "72527": "35.7411_-91.6985", "72534": "35.6023_-91.7341", "72550": "35.7177_-91.7414", "72553": "35.6941_-91.4753", "72562": "35.7118_-91.4394", "72564": "35.6131_-91.4703", "72568": "35.5893_-91.632", "72571": "35.6638_-91.534", "72575": "35.6919_-91.5989", "72579": "35.7545_-91.5073", "72512": "36.2025_-91.7553", "72517": "36.1358_-91.9513", "72519": "36.1202_-92.1867", "72528": "36.2229_-92.1177", "72536": "36.1703_-91.776", "72540": "35.9266_-91.9103", "72556": "36.0635_-91.9079", "72561": "35.9759_-91.785", "72565": "36.2114_-91.9258", "72566": "36.1677_-92.1073", "72573": "36.0688_-91.791", "72584": "36.163_-91.8471", "72585": "36.1865_-92.0088", "72587": "36.2345_-91.8154", "72005": "35.562_-91.1104", "72014": "35.4291_-91.1057", "72043": "35.6336_-91.2592", "72075": "35.6414_-91.3072", "72112": "35.5988_-91.2571", "72169": "35.3844_-91.2232", "72431": "35.6498_-91.074", "72471": "35.8274_-91.1264", "72473": "35.7307_-91.2003", "71601": "34.209_-91.9859", "71602": "34.274_-92.091", "71603": "34.1897_-92.0448", "71611": "34.2615_-91.9551", "71612": "34.274_-92.091", "71613": "34.1579_-92.0713", "71659": "34.1465_-91.7951", "72004": "34.3062_-91.8289", "72079": "34.3934_-92.2029", "72132": "34.4526_-92.1758", "72133": "34.1715_-91.5656", "72152": "34.3581_-91.9933", "72168": "34.4414_-91.9163", "72175": "34.3936_-91.7549", "72182": "34.4291_-92.0599", "72830": "35.4908_-93.4911", "72832": "35.4371_-93.672", "72839": "35.6155_-93.2726", "72840": "35.4436_-93.6142", "72845": "35.3749_-93.3618", "72846": "35.4349_-93.3552", "72852": "35.7095_-93.5585", "72854": "35.6575_-93.4311", "71826": "33.107_-93.6275", "71827": "33.3753_-93.447", "71839": "33.3352_-93.7316", "71845": "33.3736_-93.5953", "71860": "33.3569_-93.5013", "72410": "35.9423_-91.081", "72415": "36.1149_-91.1176", "72433": "36.0326_-90.9715", "72434": "36.1976_-91.1854", "72440": "35.9813_-91.2676", "72445": "35.9728_-91.0235", "72457": "36.0865_-91.0673", "72458": "36.08_-91.1482", "72459": "36.2029_-91.2593", "72465": "35.9643_-90.8954", "72466": "36.0908_-91.2745", "72469": "35.9673_-91.2935", "72476": "36.0244_-90.9288", "72572": "35.8781_-91.3004", "72311": "34.7195_-90.8969", "72320": "34.8548_-90.5377", "72341": "34.8838_-90.7666", "72352": "34.7697_-90.7552", "72360": "34.7759_-90.7785", "72368": "34.803_-91.006", "71643": "34.0345_-91.5768", "71644": "34.1032_-91.7057", "71667": "33.9405_-91.8653", "71678": "33.9787_-91.6991", "71820": "33.7944_-94.2681", "71822": "33.6787_-94.1351", "71836": "33.7176_-94.3881", "71853": "33.5826_-94.0427", "71865": "33.7475_-94.1518", "71866": "33.8583_-94.3952", "72826": "35.1304_-93.7116", "72835": "35.278_-93.3462", "72851": "35.3189_-93.4446", "72855": "35.2941_-93.7265", "72863": "35.3585_-93.5454", "72865": "35.3153_-93.5991", "72927": "35.1364_-93.9274", "72943": "35.1587_-93.8003", "72951": "35.2917_-93.8899", "72007": "34.9921_-91.9798", "72023": "34.9457_-92.0318", "72024": "34.7933_-91.7459", "72037": "34.5387_-91.874", "72046": "34.5575_-91.9484", "72072": "34.4857_-91.7624", "72083": "34.6041_-92.0078", "72086": "34.7832_-91.9214", "72176": "34.9532_-91.9004", "72721": "35.8607_-93.8112", "72738": "36.1422_-93.8633", "72740": "36.1043_-93.7279", "72742": "36.0485_-93.5044", "72752": "35.8346_-93.6181", "72760": "35.8496_-93.7347", "72773": "36.0114_-93.8526", "72776": "35.9356_-93.621", "72619": "36.371_-92.5938", "72634": "36.2682_-92.578", "72661": "36.4442_-92.5832", "72668": "36.435_-92.7615", "72672": "36.2486_-92.8416", "72677": "36.2523_-92.6907", "72687": "36.2253_-92.7245", "71834": "33.1054_-93.9543", "71837": "33.3025_-93.901", "71840": "33.3837_-93.9096", "71854": "33.431_-93.8765", "72310": "35.9201_-89.7981", "72313": "35.5365_-90.1268", "72315": "35.9273_-89.919", "72316": "35.9273_-89.919", "72319": "35.9598_-89.972", "72321": "35.8173_-89.9393", "72329": "35.6253_-90.0138", "72330": "35.5954_-90.2157", "72338": "35.4591_-90.1884", "72350": "35.5052_-90.1478", "72351": "35.6737_-90.0963", "72358": "35.7608_-89.922", "72370": "35.7019_-89.9798", "72391": "35.6831_-90.2626", "72395": "35.566_-90.0427", "72426": "35.8554_-90.0418", "72428": "35.7337_-90.1838", "72438": "35.9332_-90.1955", "72442": "35.8439_-90.1806", "72021": "34.8781_-91.1886", "72029": "34.6601_-91.2564", "72069": "34.5993_-91.1844", "72108": "34.7348_-91.1046", "72134": "34.6286_-91.3771", "71935": "34.3913_-93.7637", "71957": "34.5612_-93.5749", "71960": "34.4596_-93.6743", "71961": "34.6113_-93.8211", "71965": "34.6399_-93.7429", "71966": "34.619_-93.7769", "71969": "34.6462_-93.6741", "71970": "34.6687_-93.5376", "71722": "33.7038_-93.1588", "71828": "33.7008_-93.2941", "71835": "33.6929_-93.4232", "71857": "33.804_-93.3725", "71858": "33.5926_-93.2766", "71864": "33.7008_-93.2941", "72624": "36.0979_-93.3099", "72628": "35.853_-93.3174", "72640": "36.0152_-93.046", "72641": "36.0038_-93.2048", "72648": "36.0695_-93.1566", "72655": "35.9407_-93.0654", "72666": "35.9451_-93.2677", "72670": "36.0242_-93.3646", "72683": "35.9473_-93.0774", "72685": "36.083_-92.9716", "71701": "33.5948_-92.8513", "71711": "33.589_-92.8426", "71720": "33.7298_-92.618", "71726": "33.6652_-92.9969", "71751": "33.4169_-92.777", "71764": "33.455_-93.0214", "72001": "35.047_-92.9033", "72016": "34.9847_-92.6308", "72025": "35.0322_-93.047", "72070": "35.0362_-92.6913", "72125": "35.0443_-92.7958", "72126": "34.9701_-92.8472", "72312": "34.5467_-90.7679", "72328": "34.1335_-90.9751", "72333": "34.3118_-90.8939", "72342": "34.5325_-90.6298", "72353": "34.3286_-90.9652", "72355": "34.5979_-90.7523", "72366": "34.5485_-90.9413", "72367": "34.2198_-90.9504", "72369": "34.4542_-90.7684", "72374": "34.5394_-90.8813", "72383": "34.4762_-91.0187", "72389": "34.3466_-90.8869", "72390": "34.5496_-90.6545", "71922": "34.0362_-93.4207", "71940": "34.0238_-93.5247", "71943": "34.3192_-93.5559", "71950": "34.2513_-93.741", "71952": "34.314_-93.8509", "71958": "34.1017_-93.7109", "71959": "34.2273_-93.8905", "72354": "35.6069_-90.3359", "72365": "35.5349_-90.4194", "72377": "35.674_-90.3401", "72386": "35.4865_-90.3519", "72429": "35.514_-90.955", "72432": "35.5722_-90.7038", "72472": "35.5882_-90.562", "72475": "35.5631_-90.9207", "72479": "35.6291_-90.9289", "71932": "34.5372_-94.0972", "71937": "34.4192_-94.3923", "71944": "34.237_-94.3255", "71945": "34.4877_-94.3714", "71953": "34.5814_-94.221", "71972": "34.3941_-94.2535", "71973": "34.3088_-94.3403", "72679": "35.7341_-92.8391", "72801": "35.2842_-93.1315", "72802": "35.3067_-93.0712", "72811": "35.2784_-93.1338", "72812": "35.4231_-93.0544", "72823": "35.2449_-92.9507", "72837": "35.4074_-93.1355", "72843": "35.5499_-92.9616", "72847": "35.3744_-93.2736", "72856": "35.7854_-93.0812", "72858": "35.2398_-93.0564", "72017": "34.8733_-91.3945", "72040": "34.9751_-91.5113", "72041": "34.7447_-91.4982", "72064": "34.7838_-91.5767", "72066": "34.9901_-91.7368", "72170": "34.5772_-91.4633", "72002": "34.6313_-92.4727", "72053": "34.7093_-92.2283", "72065": "34.5208_-92.2758", "72076": "34.919_-92.1419", "72078": "34.8662_-92.1101", "72099": "34.9074_-92.1397", "72103": "34.6478_-92.3849", "72113": "34.8491_-92.4059", "72114": "34.7666_-92.2629", "72115": "34.7695_-92.2671", "72116": "34.8059_-92.2305", "72117": "34.7658_-92.1524", "72118": "34.8337_-92.3289", "72119": "34.8017_-92.2598", "72120": "34.8807_-92.2303", "72124": "34.7519_-92.3925", "72135": "34.8829_-92.5192", "72142": "34.6942_-92.1157", "72164": "34.6873_-92.2399", "72180": "34.5338_-92.2089", "72183": "34.6012_-92.1938", "72190": "34.7519_-92.3925", "72199": "34.8272_-92.2847", "72201": "34.7483_-92.2819", "72202": "34.7363_-92.2741", "72203": "34.8835_-92.3908", "72204": "34.7269_-92.344", "72205": "34.751_-92.3455", "72206": "34.6836_-92.2776", "72207": "34.7721_-92.3565", "72209": "34.6725_-92.3529", "72210": "34.7076_-92.466", "72211": "34.7413_-92.4222", "72212": "34.7871_-92.4222", "72214": "34.7621_-92.2282", "72215": "34.7519_-92.3925", "72216": "34.8178_-92.2357", "72217": "34.8302_-92.1702", "72219": "34.7519_-92.3925", "72221": "34.7519_-92.3925", "72222": "34.7519_-92.3925", "72223": "34.7902_-92.5044", "72225": "34.7519_-92.3925", "72227": "34.7757_-92.3724", "72231": "34.8019_-92.1894", "72255": "34.7464_-92.2894", "72295": "34.7519_-92.3925", "72413": "36.2844_-90.8538", "72444": "36.4386_-90.8749", "72449": "36.1797_-90.8241", "72455": "36.2829_-90.9968", "72460": "36.3104_-91.2094", "72462": "36.3744_-90.7676", "72478": "36.4803_-91.0515", "72322": "35.0562_-90.8288", "72326": "35.0881_-90.8895", "72335": "35.0091_-90.7886", "72336": "35.0081_-90.7898", "72340": "34.9358_-91.0292", "72346": "35.0973_-90.4586", "72348": "34.9454_-90.4741", "72359": "35.0252_-90.7086", "72372": "34.9663_-90.9049", "72392": "34.9207_-91.1086", "72394": "35.0592_-90.6293", "72011": "34.5091_-92.4828", "72015": "34.4933_-92.5896", "72018": "34.5645_-92.5868", "72022": "34.6068_-92.492", "72089": "34.5959_-92.489", "72122": "34.7853_-92.7482", "72158": "34.635_-92.6597", "72167": "34.4508_-92.6547", "72841": "34.8762_-93.764", "72926": "34.7654_-94.0629", "72944": "35.0432_-94.2204", "72950": "34.8003_-93.9509", "72958": "34.9026_-94.0772", "72636": "35.9879_-92.7163", "72639": "35.9991_-92.5042", "72645": "35.8272_-92.5663", "72650": "35.9267_-92.6402", "72669": "36.0675_-92.8864", "72675": "35.9877_-92.7928", "72686": "35.7681_-92.8668", "72901": "35.3653_-94.411", "72902": "35.3862_-94.4091", "72903": "35.3427_-94.3784", "72904": "35.4051_-94.3872", "72905": "35.3859_-94.3985", "72906": "35.3859_-94.3985", "72908": "35.3219_-94.4028", "72913": "35.3859_-94.3985", "72914": "35.3859_-94.3985", "72916": "35.2502_-94.3703", "72917": "35.3859_-94.3985", "72918": "35.3859_-94.3985", "72919": "35.3859_-94.3985", "72923": "35.333_-94.3082", "72936": "35.1955_-94.253", "72937": "35.1945_-94.3983", "72938": "35.0222_-94.3819", "72940": "35.0963_-94.3313", "72941": "35.3661_-94.1917", "72945": "35.0932_-94.3533", "71823": "33.8115_-94.1251", "71832": "34.0442_-94.3386", "71841": "34.157_-94.3165", "71842": "33.9392_-94.2959", "71846": "33.9306_-94.1276", "72482": "36.2453_-91.3792", "72513": "36.2201_-91.6421", "72521": "35.9517_-91.5444", "72525": "36.311_-91.597", "72529": "36.3011_-91.5281", "72532": "36.0855_-91.598", "72542": "36.3227_-91.411", "72569": "36.0767_-91.4793", "72577": "36.0664_-91.642", "72051": "35.7682_-92.3043", "72533": "35.992_-92.2182", "72555": "35.7756_-91.8718", "72560": "35.8208_-92.0389", "72567": "35.8265_-91.8958", "72657": "35.919_-92.1272", "72663": "35.9403_-92.3459", "72680": "35.8845_-92.2913", "71724": "33.3261_-92.5464", "71730": "33.2073_-92.6629", "71731": "33.2076_-92.6663", "71747": "33.0459_-92.1942", "71749": "33.0163_-92.7243", "71750": "33.1968_-92.4829", "71758": "33.3085_-92.9443", "71759": "33.316_-92.6629", "71762": "33.3398_-92.7442", "71765": "33.1195_-92.3621", "72013": "35.4683_-92.3779", "72028": "35.5773_-92.5456", "72031": "35.6045_-92.4758", "72088": "35.6027_-92.2742", "72141": "35.508_-92.5867", "72153": "35.6498_-92.3143", "72629": "35.7252_-92.5575", "72701": "36.052_-94.1534", "72702": "36.0626_-94.1574", "72703": "36.0992_-94.1716", "72704": "36.0877_-94.3093", "72717": "35.8477_-94.4441", "72727": "36.0177_-94.0073", "72728": "36.21_-94.2546", "72729": "35.7823_-94.4638", "72730": "36.0436_-94.2539", "72735": "36.0876_-93.9666", "72737": "35.9942_-94.1752", "72741": "36.1329_-94.1655", "72744": "35.9569_-94.4272", "72749": "35.8654_-94.4432", "72753": "35.9918_-94.3169", "72762": "36.1835_-94.1762", "72764": "36.1716_-94.0428", "72765": "36.1725_-94.1535", "72766": "36.1867_-94.1288", "72769": "36.0138_-94.5", "72770": "36.15_-94.2429", "72774": "35.9082_-94.2304", "72959": "35.8312_-94.1187", "72010": "35.3113_-91.5502", "72012": "35.0937_-91.9074", "72020": "35.4277_-91.519", "72045": "35.1142_-92.0901", "72052": "35.1443_-91.7772", "72060": "35.1144_-91.6242", "72068": "35.1903_-91.7108", "72081": "35.325_-91.6491", "72082": "35.2388_-91.6731", "72085": "35.3617_-91.8293", "72102": "35.1132_-91.8216", "72121": "35.4216_-91.796", "72136": "35.2155_-92.0699", "72137": "35.3214_-92.062", "72139": "35.3609_-91.5071", "72143": "35.2436_-91.7317", "72145": "35.2774_-91.7326", "72149": "35.2474_-91.7314", "72178": "35.2032_-91.6064", "72006": "35.2788_-91.3527", "72036": "35.0178_-91.229", "72059": "35.1554_-91.3432", "72074": "35.0529_-91.1262", "72101": "35.2473_-91.1793", "72123": "35.2588_-91.237", "72824": "35.1038_-93.4518", "72827": "34.9016_-93.5919", "72828": "34.9161_-93.5157", "72829": "35.1018_-93.1773", "72833": "35.0495_-93.3929", "72834": "35.1955_-93.1873", "72838": "34.8881_-93.6802", "72842": "35.0832_-93.5955", "72853": "35.0309_-93.2136", "72857": "34.9668_-93.3099", "72860": "34.9475_-93.4017", "85920": "33.8279_-109.1283", "85924": "34.4458_-109.6741", "85925": "34.1077_-109.294", "85927": "34.0052_-109.4664", "85930": "34.0754_-109.8532", "85932": "33.9531_-109.2092", "85936": "34.501_-109.3796", "85938": "34.1702_-109.3315", "85940": "34.2575_-109.6929", "86028": "35.2375_-109.5229", "86502": "35.2375_-109.5229", "86503": "36.1304_-109.6037", "86504": "35.7445_-109.0765", "86505": "35.7114_-109.542", "86506": "35.2831_-109.207", "86507": "36.4181_-109.2446", "86508": "35.3539_-109.0537", "86511": "35.6447_-109.0956", "86512": "35.2164_-109.3337", "86514": "36.7797_-109.359", "86515": "35.6676_-109.0784", "86535": "36.7773_-109.861", "86538": "36.4083_-109.634", "86540": "35.8964_-109.4487", "86544": "35.2375_-109.5229", "86545": "36.7181_-109.6259", "86547": "36.5131_-109.4734", "86556": "36.3071_-109.2176", "85602": "31.9883_-110.2941", "85603": "31.4086_-109.9117", "85605": "32.3265_-109.487", "85606": "32.0979_-109.9239", "85607": "31.3511_-109.5447", "85608": "31.4151_-109.596", "85609": "32.0281_-110.0387", "85610": "31.7139_-109.6193", "85613": "31.5587_-110.3441", "85615": "31.4035_-110.2047", "85616": "31.6639_-110.3334", "85617": "31.5121_-109.8438", "85620": "31.3373_-109.9413", "85625": "31.8885_-109.6119", "85626": "31.3572_-109.5635", "85627": "31.9995_-110.2862", "85630": "31.8973_-110.2154", "85632": "32.0423_-109.1748", "85635": "31.5365_-110.2666", "85636": "31.6687_-110.2801", "85638": "31.7216_-110.0584", "85643": "32.373_-109.8631", "85644": "32.2529_-109.832", "85650": "31.4892_-110.2153", "85655": "31.3447_-109.5468", "85670": "31.8801_-109.7543", "85671": "31.5545_-110.3037", "85931": "34.4513_-110.8644", "86001": "35.1859_-111.662", "86002": "35.1981_-111.6513", "86003": "35.1981_-111.6513", "86004": "35.2257_-111.5741", "86005": "35.1545_-111.6789", "86011": "35.1981_-111.6513", "86015": "35.2381_-111.8335", "86016": "35.7504_-111.6188", "86017": "34.9412_-111.641", "86018": "35.2563_-111.95", "86020": "35.9922_-111.5038", "86022": "36.9044_-112.4979", "86023": "35.9421_-112.1309", "86024": "34.6616_-111.3404", "86035": "35.3365_-110.9927", "86036": "36.737_-111.8229", "86038": "34.9083_-111.463", "86040": "36.9147_-111.4558", "86044": "36.7093_-110.8411", "86045": "36.1037_-111.2686", "86046": "35.5434_-112.1707", "86052": "36.2105_-112.0613", "86053": "36.4025_-111.3518", "86336": "34.8266_-111.7506", "86339": "34.8697_-111.761", "86351": "34.7784_-111.7851", "86435": "36.2242_-112.6932", "85135": "33.0041_-110.7868", "85192": "33.0057_-110.7727", "85501": "33.4024_-110.7892", "85502": "33.3942_-110.7865", "85532": "33.4154_-110.8149", "85539": "33.3992_-110.8687", "85541": "34.2198_-111.2878", "85542": "33.3103_-110.4554", "85544": "34.3435_-111.5353", "85545": "33.6358_-110.9749", "85547": "34.2575_-111.2878", "85550": "33.3456_-110.455", "85553": "33.8317_-111.2946", "85554": "34.1014_-110.9637", "85530": "33.1265_-110.117", "85531": "32.8692_-109.7878", "85535": "32.9612_-109.8954", "85536": "33.0333_-109.9717", "85543": "32.9097_-109.856", "85546": "32.8295_-109.6266", "85548": "32.797_-109.7522", "85551": "32.8126_-109.634", "85552": "32.8504_-109.7461", "85533": "33.1323_-109.2462", "85534": "32.881_-109.2157", "85540": "33.0787_-109.3654", "85922": "33.6512_-109.0685", "85325": "33.9578_-114.0036", "85328": "33.3164_-114.665", "85334": "33.6177_-114.5077", "85344": "34.15_-114.2891", "85346": "33.7292_-114.1925", "85348": "33.7481_-113.5715", "85357": "34.0422_-113.458", "85359": "33.6669_-114.2396", "85371": "33.9906_-114.3963", "85001": "33.4484_-112.074", "85002": "33.4484_-112.074", "85003": "33.4511_-112.0774", "85004": "33.4557_-112.0686", "85005": "33.4484_-112.074", "85006": "33.465_-112.0474", "85007": "33.4523_-112.0893", "85008": "33.4665_-111.9984", "85009": "33.4564_-112.1284", "85010": "33.4484_-112.074", "85011": "33.4484_-112.074", "85012": "33.5097_-112.0678", "85013": "33.5085_-112.0827", "85014": "33.5103_-112.0556", "85015": "33.5082_-112.1011", "85016": "33.5021_-112.0305", "85017": "33.5153_-112.1212", "85018": "33.4958_-111.9883", "85019": "33.5123_-112.1417", "85020": "33.5623_-112.0559", "85021": "33.56_-112.0927", "85022": "33.6315_-112.052", "85023": "33.6324_-112.1118", "85024": "33.6617_-112.037", "85025": "33.4484_-112.074", "85026": "33.4484_-112.074", "85027": "33.6819_-112.0996", "85028": "33.5851_-112.0087", "85029": "33.5961_-112.1199", "85030": "33.4484_-112.074", "85031": "33.4939_-112.1696", "85032": "33.6238_-112.0044", "85033": "33.4944_-112.2132", "85034": "33.4413_-112.0421", "85035": "33.4724_-112.1832", "85036": "33.4484_-112.074", "85037": "33.4913_-112.2468", "85038": "33.4484_-112.074", "85039": "33.4484_-112.074", "85040": "33.4061_-112.0265", "85041": "33.3889_-112.0954", "85042": "33.3794_-112.0283", "85043": "33.4491_-112.1972", "85044": "33.3291_-111.9943", "85045": "33.3022_-112.1226", "85046": "33.4484_-112.074", "85048": "33.316_-112.0669", "85050": "33.6863_-111.9963", "85051": "33.5591_-112.1332", "85053": "33.6299_-112.1316", "85054": "33.6731_-111.9461", "85060": "33.4484_-112.074", "85061": "33.4484_-112.074", "85062": "33.4484_-112.074", "85063": "33.4484_-112.074", "85064": "33.4484_-112.074", "85065": "33.4484_-112.074", "85066": "33.4484_-112.074", "85067": "33.4484_-112.074", "85068": "33.4484_-112.074", "85069": "33.4484_-112.074", "85070": "33.4484_-112.074", "85071": "33.4484_-112.074", "85072": "33.4484_-112.074", "85073": "33.4484_-112.074", "85074": "33.4484_-112.074", "85075": "33.4484_-112.074", "85076": "33.4484_-112.074", "85078": "33.4484_-112.074", "85079": "33.4484_-112.074", "85080": "33.4484_-112.074", "85082": "33.4484_-112.074", "85083": "33.7352_-112.1294", "85085": "33.7529_-112.0893", "85086": "33.8155_-112.1202", "85087": "33.9235_-112.1279", "85097": "33.4484_-112.074", "85098": "33.4484_-112.074", "85127": "33.2125_-111.697", "85142": "33.2487_-111.6343", "85190": "33.5264_-111.3892", "85201": "33.4317_-111.8469", "85202": "33.3851_-111.8724", "85203": "33.437_-111.8057", "85204": "33.3992_-111.7896", "85205": "33.4368_-111.7129", "85206": "33.4026_-111.7242", "85207": "33.4321_-111.6426", "85208": "33.3984_-111.6513", "85209": "33.3782_-111.6406", "85210": "33.3887_-111.8428", "85211": "33.4663_-111.8373", "85212": "33.3425_-111.6353", "85213": "33.4367_-111.7731", "85214": "33.4125_-111.8319", "85215": "33.4707_-111.7188", "85216": "33.4125_-111.8319", "85224": "33.3301_-111.8632", "85225": "33.3105_-111.8239", "85226": "33.3092_-111.9198", "85233": "33.3354_-111.8153", "85234": "33.3527_-111.7809", "85236": "33.3024_-111.6969", "85244": "33.3213_-111.8888", "85246": "33.3062_-111.8413", "85248": "33.2509_-111.8593", "85249": "33.2414_-111.7745", "85250": "33.5218_-111.9049", "85251": "33.4936_-111.9167", "85252": "33.4995_-111.8684", "85253": "33.5494_-111.9565", "85254": "33.6165_-111.9554", "85255": "33.6968_-111.8892", "85256": "33.4858_-111.8533", "85257": "33.4669_-111.9151", "85258": "33.5647_-111.8931", "85259": "33.5879_-111.8404", "85260": "33.6013_-111.8867", "85261": "33.5092_-111.899", "85262": "33.7752_-111.7791", "85263": "33.7225_-111.6757", "85264": "33.6118_-111.6806", "85266": "33.7669_-111.9182", "85267": "33.5092_-111.899", "85268": "33.6085_-111.7237", "85269": "33.6117_-111.7174", "85271": "33.5092_-111.899", "85274": "33.4125_-111.8319", "85275": "33.4125_-111.8319", "85277": "33.4125_-111.8319", "85280": "33.4014_-111.9313", "85281": "33.4227_-111.9261", "85282": "33.3917_-111.9249", "85283": "33.3665_-111.9312", "85284": "33.3363_-111.9197", "85285": "33.4148_-111.9093", "85286": "33.2711_-111.8311", "85287": "33.4285_-111.9349", "85295": "33.3054_-111.7408", "85296": "33.3354_-111.7406", "85297": "33.2781_-111.7096", "85298": "33.2522_-111.7022", "85299": "33.3528_-111.789", "85301": "33.5311_-112.1767", "85302": "33.5675_-112.1753", "85303": "33.5262_-112.2149", "85304": "33.5943_-112.1746", "85305": "33.5291_-112.2482", "85306": "33.6239_-112.1776", "85307": "33.5376_-112.3137", "85308": "33.6539_-112.1694", "85309": "33.5387_-112.186", "85310": "33.7047_-112.1641", "85311": "33.5387_-112.186", "85312": "33.5387_-112.186", "85318": "33.5387_-112.186", "85320": "33.9186_-113.2134", "85322": "33.3133_-112.7891", "85323": "33.4321_-112.3438", "85326": "33.3703_-112.5838", "85327": "33.8333_-111.9508", "85329": "33.4353_-112.2979", "85331": "33.8851_-111.9349", "85335": "33.6082_-112.3241", "85337": "32.9306_-112.7468", "85338": "33.4368_-112.3834", "85339": "33.3436_-112.1716", "85340": "33.5098_-112.4135", "85342": "33.8567_-112.6232", "85343": "33.3481_-112.6774", "85345": "33.5761_-112.2344", "85351": "33.6061_-112.2797", "85353": "33.4347_-112.2774", "85354": "33.4228_-112.9528", "85355": "33.5673_-112.4387", "85358": "33.9686_-112.7296", "85361": "33.7637_-112.6142", "85363": "33.5908_-112.3013", "85372": "33.5975_-112.2718", "85373": "33.6588_-112.3214", "85374": "33.63_-112.3314", "85375": "33.6856_-112.3659", "85376": "33.662_-112.3413", "85377": "33.824_-111.913", "85378": "33.6306_-112.3332", "85379": "33.6021_-112.3736", "85380": "33.5806_-112.2374", "85381": "33.6048_-112.2237", "85382": "33.6308_-112.2072", "85383": "33.7169_-112.238", "85385": "33.5806_-112.2374", "85387": "33.7129_-112.4375", "85388": "33.6134_-112.4512", "85390": "33.8944_-112.8603", "85392": "33.4777_-112.3093", "85395": "33.479_-112.3947", "85396": "33.468_-112.4787", "85360": "34.7033_-113.6113", "86021": "36.9903_-112.9758", "86401": "35.1328_-113.7033", "86402": "35.2632_-114.0637", "86403": "34.4814_-114.3483", "86404": "34.5575_-114.3307", "86405": "34.4839_-114.3225", "86406": "34.4228_-114.125", "86409": "35.2633_-114.0223", "86411": "35.3692_-113.7272", "86412": "35.3972_-113.8432", "86413": "35.3002_-114.2215", "86426": "35.0052_-114.5687", "86427": "35.0043_-114.5812", "86429": "35.1715_-114.5386", "86430": "35.1473_-114.5433", "86431": "35.3896_-114.2221", "86432": "36.8872_-113.9297", "86433": "35.0285_-114.3837", "86434": "35.5378_-113.4202", "86436": "34.7784_-114.4817", "86437": "35.3788_-113.6141", "86438": "34.8722_-114.1494", "86439": "35.1478_-114.5683", "86440": "34.8929_-114.5951", "86441": "35.5692_-114.3777", "86442": "35.106_-114.5947", "86443": "35.2106_-114.1792", "86444": "35.9822_-114.0775", "86445": "35.7759_-114.5001", "86446": "34.8499_-114.5917", "85901": "34.2998_-110", "85902": "34.2981_-110.0352", "85911": "34.0448_-110.4854", "85912": "34.2666_-110.2031", "85923": "34.3617_-110.2954", "85926": "33.7906_-109.9887", "85928": "34.41_-110.5883", "85929": "34.1662_-109.9869", "85933": "34.4086_-110.56", "85934": "34.3003_-110.2457", "85935": "34.1175_-109.9197", "85937": "34.4959_-110.0807", "85939": "34.439_-110.0858", "85941": "33.8021_-109.9937", "85942": "34.7814_-110.0435", "86025": "34.9085_-110.1434", "86029": "34.9806_-110.0582", "86030": "35.9278_-110.6729", "86031": "35.4056_-110.0848", "86032": "34.9814_-110.3373", "86033": "36.6883_-110.2652", "86034": "35.8082_-110.2845", "86039": "35.8742_-110.6235", "86042": "35.8617_-110.3875", "86043": "35.7933_-110.5051", "86047": "35.0242_-110.6974", "86054": "36.6159_-110.6477", "86510": "36.1002_-110.2211", "86520": "36.1708_-109.9465", "85321": "32.2295_-112.6542", "85341": "31.8826_-112.8157", "85601": "31.5885_-111.316", "85614": "31.8543_-111.0003", "85619": "32.3763_-110.7605", "85622": "31.8269_-111.0755", "85629": "31.9452_-111.0002", "85633": "31.4887_-111.5421", "85634": "32.0315_-112.0065", "85639": "31.814_-111.8257", "85641": "32.0027_-110.7053", "85652": "32.4201_-111.1132", "85653": "32.4047_-111.2736", "85654": "32.4148_-111.1562", "85701": "32.2139_-110.9694", "85702": "32.2217_-110.9265", "85703": "32.2217_-110.9265", "85704": "32.3379_-110.9855", "85705": "32.2691_-110.9845", "85706": "32.1392_-110.9451", "85707": "32.1696_-110.8751", "85708": "32.18_-110.8693", "85709": "32.2008_-110.898", "85710": "32.2138_-110.824", "85711": "32.2127_-110.8829", "85712": "32.25_-110.8869", "85713": "32.1941_-110.9739", "85714": "32.1707_-110.9719", "85715": "32.2519_-110.82", "85716": "32.2468_-110.9222", "85717": "32.2217_-110.9265", "85718": "32.3112_-110.9179", "85719": "32.2474_-110.9491", "85720": "32.2217_-110.9265", "85721": "32.2338_-110.95", "85722": "32.2217_-110.9265", "85723": "32.2217_-110.9265", "85724": "32.2406_-110.9443", "85725": "32.2217_-110.9265", "85726": "32.2027_-110.9453", "85728": "32.2217_-110.9265", "85730": "32.181_-110.819", "85731": "32.2217_-110.9265", "85732": "32.2217_-110.9265", "85733": "32.2217_-110.9265", "85734": "32.0651_-110.9353", "85735": "32.093_-111.3472", "85736": "31.9011_-111.3702", "85737": "32.4142_-110.9466", "85738": "32.5056_-110.9211", "85739": "32.465_-110.8922", "85740": "32.2217_-110.9265", "85741": "32.3472_-111.0419", "85742": "32.4076_-111.065", "85743": "32.3366_-111.1771", "85744": "32.2217_-110.9265", "85745": "32.2434_-111.0179", "85746": "32.1422_-111.0506", "85747": "32.0984_-110.7272", "85748": "32.215_-110.7758", "85749": "32.2733_-110.7658", "85750": "32.2974_-110.8404", "85751": "32.2217_-110.9265", "85752": "32.2217_-110.9265", "85754": "32.2217_-110.9265", "85755": "32.4227_-110.9768", "85756": "32.0839_-110.9004", "85757": "32.1336_-111.0973", "85775": "32.2217_-110.9265", "85117": "33.3284_-111.327", "85118": "33.3284_-111.3502", "85119": "33.4001_-111.5028", "85120": "33.3931_-111.5768", "85121": "33.1405_-111.9128", "85122": "32.8905_-111.754", "85123": "32.7559_-111.671", "85128": "32.9574_-111.5344", "85130": "32.8151_-111.7054", "85131": "32.7509_-111.5833", "85132": "32.9969_-111.3612", "85137": "33.0594_-110.9123", "85138": "33.0073_-111.9324", "85139": "32.9576_-112.0534", "85140": "33.1911_-111.528", "85141": "32.6686_-111.4549", "85143": "33.1911_-111.528", "85145": "32.58_-111.341", "85147": "33.1234_-111.7384", "85172": "32.8823_-111.966", "85173": "33.2887_-111.0985", "85178": "33.405_-111.547", "85191": "32.9827_-111.4429", "85193": "32.8554_-111.7973", "85194": "32.8984_-111.6261", "85618": "32.7239_-110.644", "85623": "32.6005_-110.7961", "85631": "32.6209_-110.5992", "85658": "32.4305_-111.1459", "85611": "31.6598_-110.5254", "85621": "31.377_-110.9435", "85624": "31.5353_-110.6968", "85628": "31.532_-110.9093", "85637": "31.6731_-110.6188", "85640": "31.5696_-111.0534", "85645": "31.6723_-111.0986", "85646": "31.6126_-111.0459", "85648": "31.5084_-111.0757", "85662": "31.532_-110.9093", "85324": "34.0755_-112.134", "85332": "34.1764_-112.768", "85362": "34.2508_-112.7567", "86301": "34.5917_-112.4265", "86302": "34.5749_-112.4915", "86303": "34.4958_-112.3783", "86304": "34.5967_-112.4907", "86305": "34.8185_-112.9584", "86312": "34.6683_-112.3078", "86313": "34.7067_-112.3977", "86314": "34.6019_-112.3264", "86315": "34.7055_-112.2639", "86320": "35.215_-112.5027", "86321": "34.5785_-113.1755", "86322": "34.5697_-111.8551", "86323": "34.7757_-112.4731", "86324": "34.7711_-112.0579", "86325": "34.7256_-111.9086", "86326": "34.7055_-112.0091", "86327": "34.5368_-112.2567", "86329": "34.5009_-112.2374", "86331": "34.7486_-112.1086", "86332": "34.4541_-112.8966", "86333": "34.3655_-112.1296", "86334": "35.0313_-112.5441", "86335": "34.638_-111.7842", "86337": "35.3212_-112.9548", "86338": "34.5053_-112.6855", "86340": "34.7067_-112.3977", "86341": "34.7766_-111.7679", "86342": "34.6417_-111.7872", "86343": "34.2241_-112.334", "85333": "32.8679_-113.4631", "85336": "32.5545_-114.785", "85347": "32.7517_-113.9891", "85349": "32.487_-114.7822", "85350": "32.5634_-114.7127", "85352": "32.6934_-113.9763", "85356": "32.6935_-114.1561", "85364": "32.7015_-114.6424", "85365": "32.7093_-114.4905", "85366": "32.61_-114.6312", "85367": "32.6566_-114.4042", "85369": "32.7253_-114.6244", "94501": "37.7706_-122.2648", "94502": "37.7351_-122.2431", "94536": "37.5605_-121.9999", "94537": "37.6802_-121.9215", "94538": "37.5308_-121.9712", "94539": "37.5176_-121.9287", "94540": "37.6802_-121.9215", "94541": "37.674_-122.0894", "94542": "37.6586_-122.0472", "94543": "37.6688_-122.0808", "94544": "37.6374_-122.067", "94545": "37.6332_-122.0971", "94546": "37.7015_-122.0782", "94550": "37.683_-121.763", "94551": "37.7526_-121.77", "94552": "37.7131_-122.0381", "94555": "37.5735_-122.0469", "94557": "37.6802_-121.9215", "94560": "37.5368_-122.032", "94566": "37.6658_-121.8755", "94568": "37.7166_-121.9226", "94577": "37.7205_-122.1587", "94578": "37.7024_-122.124", "94579": "37.6892_-122.1507", "94580": "37.6787_-122.1295", "94586": "37.6094_-121.8986", "94587": "37.5895_-122.0497", "94588": "37.6873_-121.8957", "94601": "37.7806_-122.2166", "94602": "37.8011_-122.2104", "94603": "37.7402_-122.171", "94604": "37.8044_-122.2708", "94605": "37.7641_-122.1633", "94606": "37.7957_-122.2429", "94607": "37.8071_-122.2851", "94608": "37.8365_-122.2804", "94609": "37.8361_-122.2637", "94610": "37.8126_-122.2443", "94611": "37.8471_-122.2223", "94612": "37.8085_-122.2668", "94613": "37.7811_-122.1866", "94614": "37.7277_-122.2046", "94615": "37.8067_-122.3004", "94617": "37.8078_-122.2717", "94618": "37.8431_-122.2402", "94619": "37.7878_-122.1884", "94620": "37.8244_-122.2316", "94621": "37.7589_-122.1853", "94622": "37.799_-122.2337", "94623": "37.8044_-122.2708", "94624": "37.8044_-122.2708", "94649": "37.8044_-122.2708", "94659": "37.8044_-122.2708", "94660": "37.8044_-122.2708", "94661": "37.8044_-122.2708", "94662": "37.8313_-122.2852", "94666": "37.8044_-122.2708", "94701": "37.8606_-122.2967", "94702": "37.8656_-122.2851", "94703": "37.863_-122.2749", "94704": "37.8664_-122.257", "94705": "37.8571_-122.25", "94706": "37.89_-122.2954", "94707": "37.8927_-122.2761", "94708": "37.8918_-122.2604", "94709": "37.8784_-122.2655", "94710": "37.8696_-122.2959", "94712": "37.8716_-122.2727", "94720": "37.8738_-122.2549", "95646": "38.6918_-120.0736", "96120": "38.7713_-119.8327", "95601": "38.4194_-120.823", "95629": "38.5234_-120.6763", "95640": "38.3324_-120.9418", "95642": "38.3545_-120.7573", "95644": "38.6707_-120.1135", "95654": "38.3515_-120.7752", "95665": "38.4049_-120.6544", "95666": "38.4319_-120.5719", "95669": "38.4916_-120.8819", "95675": "38.5463_-120.743", "95685": "38.4175_-120.7951", "95689": "38.4765_-120.6017", "95699": "38.4411_-120.8533", "95914": "39.3885_-121.4052", "95916": "39.6776_-121.3689", "95917": "39.4162_-121.7189", "95926": "39.7458_-121.8444", "95927": "39.8117_-121.9398", "95928": "39.7224_-121.8113", "95929": "39.7301_-121.8414", "95930": "39.5327_-121.1575", "95938": "39.633_-121.7886", "95940": "39.622_-121.2669", "95941": "39.521_-121.2423", "95942": "39.8821_-121.6728", "95948": "39.3532_-121.7137", "95954": "39.8912_-121.58", "95958": "39.5522_-121.7644", "95965": "39.6054_-121.5751", "95966": "39.4877_-121.4698", "95967": "39.7155_-121.6551", "95968": "39.4361_-121.5454", "95969": "39.7555_-121.6069", "95973": "39.8032_-121.8673", "95974": "39.4959_-121.748", "95976": "39.7346_-121.8331", "95978": "39.9077_-121.5269", "95221": "38.0838_-120.5608", "95222": "38.071_-120.5722", "95223": "38.3086_-120.268", "95224": "38.2044_-120.3688", "95225": "38.1838_-120.8894", "95226": "38.2271_-120.8533", "95228": "37.944_-120.6423", "95229": "38.1144_-120.4538", "95232": "38.3554_-120.5778", "95233": "38.1919_-120.3644", "95245": "38.3152_-120.5591", "95246": "38.2328_-120.4994", "95247": "38.1345_-120.4516", "95248": "38.3405_-120.5161", "95249": "38.1904_-120.6441", "95251": "38.1013_-120.4676", "95252": "38.162_-120.8572", "95254": "38.1983_-120.9793", "95255": "38.4197_-120.4759", "95257": "38.3793_-120.4627", "95912": "39.0138_-122.0274", "95932": "39.2345_-122.0277", "95950": "39.0744_-121.8927", "95955": "39.3163_-122.1849", "95970": "39.4168_-122.0519", "95979": "39.3176_-122.5393", "95987": "39.1337_-122.2162", "94505": "37.8989_-121.6054", "94506": "37.8321_-121.9167", "94507": "37.8537_-122.0229", "94509": "37.9939_-121.8089", "94511": "38.0266_-121.6425", "94513": "37.9324_-121.6894", "94514": "37.8254_-121.6236", "94516": "37.8339_-122.165", "94517": "37.9154_-121.91", "94518": "37.9504_-122.0263", "94519": "37.9841_-122.0119", "94520": "37.9823_-122.0362", "94521": "37.9575_-121.975", "94522": "37.978_-122.0311", "94523": "37.954_-122.0737", "94524": "37.978_-122.0311", "94525": "38.0519_-122.2177", "94526": "37.814_-121.966", "94527": "37.9535_-121.9578", "94528": "37.8387_-121.9667", "94529": "37.978_-122.0311", "94530": "37.9156_-122.2985", "94531": "37.9658_-121.7758", "94547": "38.0066_-122.2637", "94548": "37.9726_-121.6652", "94549": "37.8961_-122.1119", "94553": "37.9864_-122.135", "94556": "37.8437_-122.1242", "94561": "37.994_-121.7036", "94563": "37.8787_-122.1728", "94564": "37.9969_-122.2875", "94565": "38.0031_-121.9172", "94569": "38.046_-122.1866", "94570": "37.7772_-121.9554", "94572": "38.0307_-122.2581", "94575": "37.7772_-121.9554", "94582": "37.7636_-121.9155", "94583": "37.7562_-121.9522", "94595": "37.8753_-122.0703", "94596": "37.9053_-122.0549", "94597": "37.9182_-122.0717", "94598": "37.9194_-122.0259", "94801": "37.94_-122.362", "94802": "37.9358_-122.3477", "94803": "37.9693_-122.2901", "94804": "37.9265_-122.3342", "94805": "37.9417_-122.3238", "94806": "37.9724_-122.3369", "94807": "37.9358_-122.3477", "94808": "37.9358_-122.3477", "94820": "37.9771_-122.2952", "94850": "37.9358_-122.3477", "95531": "41.7817_-124.1332", "95532": "41.7561_-124.2005", "95538": "41.8679_-124.149", "95543": "41.9056_-123.831", "95548": "41.5804_-124.0387", "95567": "41.9404_-124.1587", "95613": "38.8_-120.8891", "95614": "38.8923_-120.9802", "95619": "38.6865_-120.8145", "95623": "38.633_-120.8498", "95633": "38.8665_-120.8567", "95634": "38.9185_-120.7599", "95635": "38.9143_-120.9001", "95636": "38.6489_-120.5098", "95651": "38.8278_-120.9238", "95656": "38.55_-120.7304", "95664": "38.8135_-121.0308", "95667": "38.7195_-120.8046", "95672": "38.7194_-120.9945", "95682": "38.6465_-120.9641", "95684": "38.5953_-120.5949", "95709": "38.747_-120.6743", "95720": "38.7825_-120.2569", "95721": "38.8338_-120.0416", "95726": "38.7708_-120.5427", "95735": "38.8092_-120.1242", "95762": "38.685_-121.068", "96142": "39.0644_-120.1357", "96150": "38.917_-119.9865", "96151": "38.9039_-119.995", "96152": "38.9271_-119.999", "96154": "38.8753_-120.0188", "96155": "38.8449_-120.043", "96156": "38.9352_-119.9676", "96157": "38.9344_-119.9767", "96158": "38.8981_-119.9984", "93210": "36.1624_-120.3489", "93234": "36.2371_-120.102", "93242": "36.4378_-119.7156", "93602": "37.0726_-119.4572", "93605": "37.2032_-119.2492", "93606": "36.8032_-120.0185", "93607": "36.5898_-119.8994", "93608": "36.4921_-120.3353", "93609": "36.5358_-119.8446", "93611": "36.8253_-119.6802", "93612": "36.8149_-119.7106", "93613": "36.8252_-119.7029", "93616": "36.6543_-119.5929", "93621": "36.7446_-119.0899", "93622": "36.8651_-120.47", "93624": "36.3386_-120.1118", "93625": "36.6282_-119.671", "93626": "37.0422_-119.6807", "93627": "36.5316_-120.0982", "93628": "36.7515_-118.9575", "93630": "36.7306_-120.0724", "93631": "36.508_-119.5433", "93634": "37.253_-119.1748", "93640": "36.7424_-120.4093", "93641": "36.6894_-119.0477", "93642": "37.3266_-119.0176", "93646": "36.6255_-119.3204", "93648": "36.6103_-119.5375", "93649": "36.8417_-119.3496", "93650": "36.8411_-119.801", "93651": "36.9938_-119.5268", "93652": "36.6024_-119.904", "93654": "36.6044_-119.4378", "93656": "36.4295_-119.872", "93657": "36.7243_-119.5478", "93660": "36.6059_-120.1889", "93662": "36.5695_-119.617", "93664": "37.1397_-119.273", "93667": "36.9943_-119.3914", "93668": "36.6584_-120.2617", "93675": "36.7071_-119.1814", "93701": "36.7487_-119.7867", "93702": "36.74_-119.7532", "93703": "36.7684_-119.7594", "93704": "36.7991_-119.8016", "93705": "36.7863_-119.8286", "93706": "36.6486_-119.9987", "93707": "36.7464_-119.6397", "93708": "36.7464_-119.6397", "93709": "36.7464_-119.6397", "93710": "36.8236_-119.7621", "93711": "36.8303_-119.8319", "93712": "36.7464_-119.6397", "93714": "36.7464_-119.6397", "93715": "36.7464_-119.6397", "93716": "36.7464_-119.6397", "93717": "36.7464_-119.6397", "93718": "36.7464_-119.6397", "93720": "36.8579_-119.7655", "93721": "36.7377_-119.7843", "93722": "36.7918_-119.8801", "93723": "36.7863_-119.9532", "93724": "36.7464_-119.6397", "93725": "36.6207_-119.7308", "93726": "36.7949_-119.7604", "93727": "36.7528_-119.7061", "93728": "36.7581_-119.8113", "93729": "36.7464_-119.6397", "93730": "36.8878_-119.7589", "93737": "36.7477_-119.7724", "93740": "36.7464_-119.6397", "93741": "36.7464_-119.6397", "93744": "36.7464_-119.6397", "93745": "36.7464_-119.6397", "93747": "36.7464_-119.6397", "93750": "36.7464_-119.6397", "93755": "36.7464_-119.6397", "93760": "36.7464_-119.6397", "93761": "36.7464_-119.6397", "93764": "36.7464_-119.6397", "93765": "36.7464_-119.6397", "93771": "36.7464_-119.6397", "93772": "36.7464_-119.6397", "93773": "36.7464_-119.6397", "93774": "36.7464_-119.6397", "93775": "36.7464_-119.6397", "93776": "36.7464_-119.6397", "93777": "36.7464_-119.6397", "93778": "36.7464_-119.6397", "93779": "36.7464_-119.6397", "93786": "36.7464_-119.6397", "93790": "36.7464_-119.6397", "93791": "36.7464_-119.6397", "93792": "36.7464_-119.6397", "93793": "36.7464_-119.6397", "93794": "36.7464_-119.6397", "93844": "36.7464_-119.6397", "93888": "36.7464_-119.6397", "95913": "39.6197_-122.1927", "95920": "39.4568_-121.9515", "95939": "39.5306_-122.6124", "95943": "39.6069_-122.0384", "95951": "39.7386_-122.0085", "95963": "39.7314_-122.2534", "95988": "39.5353_-122.2597", "95501": "40.7938_-124.1573", "95502": "40.7965_-124.1737", "95503": "40.7592_-124.1593", "95511": "40.1676_-123.6192", "95514": "40.2987_-123.6576", "95518": "40.8685_-124.0856", "95519": "40.9465_-124.0834", "95521": "40.8742_-124.0765", "95524": "40.8266_-124.0552", "95525": "40.9374_-123.8913", "95526": "40.4693_-123.7998", "95528": "40.507_-123.9743", "95534": "40.7965_-124.1737", "95536": "40.5259_-124.2514", "95537": "40.7268_-124.2174", "95540": "40.5835_-124.1473", "95542": "40.0864_-123.7991", "95545": "40.2421_-124.0972", "95546": "41.0504_-123.6742", "95547": "40.5485_-124.0847", "95549": "40.6405_-123.8826", "95550": "40.7775_-123.8486", "95551": "40.6589_-124.2251", "95553": "40.2397_-123.8077", "95554": "40.2841_-123.7945", "95555": "41.3596_-124.0317", "95556": "41.3115_-123.5399", "95558": "40.2868_-124.2271", "95559": "40.2008_-123.7735", "95560": "40.1201_-123.8234", "95562": "40.4987_-124.1102", "95564": "40.8037_-124.1936", "95565": "40.4583_-124.0517", "95569": "40.3437_-123.9095", "95570": "41.0593_-124.1431", "95571": "40.3218_-123.9217", "95573": "40.9484_-123.6276", "95589": "40.0231_-124.0139", "92222": "32.7822_-114.5619", "92227": "32.9792_-115.5296", "92231": "32.6832_-115.5028", "92232": "32.6789_-115.4989", "92233": "33.167_-115.5114", "92243": "32.7893_-115.5665", "92244": "32.7948_-115.6927", "92249": "32.7218_-115.4383", "92250": "32.8104_-115.3775", "92251": "32.847_-115.573", "92257": "33.3784_-115.6965", "92259": "32.7387_-115.9942", "92266": "33.3696_-114.7355", "92273": "32.7941_-115.6948", "92275": "33.3092_-115.9578", "92281": "33.038_-115.5914", "92283": "32.9818_-114.6854", "92331": "34.0922_-117.4612", "92328": "36.4672_-116.8937", "92384": "35.973_-116.2711", "92389": "35.9021_-116.1544", "93513": "37.1679_-118.2916", "93514": "37.5014_-118.4048", "93515": "37.3635_-118.3951", "93522": "36.2948_-117.5957", "93526": "36.8396_-118.2048", "93530": "36.4886_-117.8741", "93542": "35.9366_-117.9067", "93545": "36.5798_-118.0578", "93549": "36.23_-117.9552", "93203": "35.1966_-118.8336", "93205": "35.587_-118.4847", "93206": "35.4033_-119.4659", "93215": "35.7715_-119.2459", "93216": "35.7688_-119.2471", "93220": "35.3475_-118.8718", "93222": "34.8469_-119.1568", "93224": "35.1786_-119.5412", "93225": "34.8265_-119.0355", "93226": "35.7377_-118.7169", "93238": "35.755_-118.4047", "93240": "35.669_-118.457", "93241": "35.2571_-118.9124", "93243": "34.8818_-118.8566", "93249": "35.6163_-119.6943", "93250": "35.6758_-119.2272", "93251": "35.3031_-119.6366", "93252": "35.0589_-119.401", "93255": "35.6824_-118.0959", "93263": "35.497_-119.2801", "93268": "35.1482_-119.4557", "93276": "35.2992_-119.3584", "93280": "35.648_-119.4487", "93283": "35.6391_-118.2859", "93285": "35.7246_-118.4559", "93287": "35.7068_-118.8439", "93301": "35.3866_-119.0171", "93302": "35.3733_-119.0187", "93303": "35.2944_-118.9052", "93304": "35.3396_-119.0218", "93305": "35.3855_-118.986", "93306": "35.3867_-118.9391", "93307": "35.3275_-118.9839", "93308": "35.4244_-119.0433", "93309": "35.3384_-119.0627", "93311": "35.3039_-119.1056", "93312": "35.3935_-119.1205", "93313": "35.2974_-119.0509", "93314": "35.3863_-119.17", "93380": "35.2944_-118.9052", "93383": "35.2944_-118.9052", "93384": "35.3733_-119.0187", "93385": "35.2944_-118.9052", "93386": "35.2944_-118.9052", "93387": "35.2944_-118.9052", "93388": "35.2944_-118.9052", "93389": "35.2944_-118.9052", "93390": "35.2944_-118.9052", "93501": "35.0478_-118.1735", "93502": "35.0525_-118.174", "93504": "35.1871_-117.8854", "93505": "35.1278_-117.9651", "93516": "35.0037_-117.6629", "93518": "35.3701_-118.4612", "93519": "35.3089_-117.9684", "93523": "34.9261_-117.9351", "93524": "34.932_-117.9071", "93527": "35.6397_-117.857", "93528": "35.3708_-117.6427", "93531": "35.2375_-118.6076", "93554": "35.3866_-117.7159", "93555": "35.6225_-117.6709", "93556": "35.6225_-117.6709", "93560": "34.8664_-118.3409", "93561": "35.1322_-118.449", "93581": "35.1322_-118.449", "93596": "34.9994_-117.6498", "93202": "36.3095_-119.7053", "93204": "35.9877_-120.1227", "93212": "36.0865_-119.5607", "93230": "36.3314_-119.6491", "93232": "36.3275_-119.6457", "93239": "36.0083_-119.9618", "93245": "36.2682_-119.8173", "93246": "36.1389_-119.8947", "93266": "36.179_-119.8236", "95422": "38.9576_-122.636", "95423": "39.0664_-122.6558", "95424": "38.9666_-122.65", "95426": "38.8155_-122.7132", "95435": "39.0043_-122.8755", "95443": "39.0263_-122.733", "95451": "38.9421_-122.7777", "95453": "39.047_-122.9328", "95457": "38.8915_-122.5914", "95458": "39.0783_-122.7846", "95461": "38.7824_-122.6487", "95464": "39.1194_-122.8315", "95467": "38.8036_-122.5407", "95485": "39.1804_-122.9144", "95493": "39.1821_-122.9711", "96009": "41.1315_-121.1286", "96068": "41.0957_-121.183", "96109": "40.0008_-120.1077", "96113": "40.1485_-120.1713", "96114": "40.2963_-120.5098", "96117": "40.4073_-120.4092", "96119": "40.9766_-120.5548", "96121": "40.1828_-120.3895", "96123": "40.7985_-120.3652", "96127": "40.4163_-120.653", "96128": "40.3509_-120.4068", "96130": "40.3983_-120.6464", "96132": "40.9509_-120.613", "96136": "40.3406_-120.2824", "96137": "40.3038_-121.0226", "90001": "33.9731_-118.2479", "90002": "33.9497_-118.2462", "90003": "33.9653_-118.2727", "90004": "34.0762_-118.3029", "90005": "34.0585_-118.3012", "90006": "34.0493_-118.2917", "90007": "34.0294_-118.2871", "90008": "34.0116_-118.3411", "90009": "34.0522_-118.2437", "90010": "34.0606_-118.3027", "90011": "34.0079_-118.2582", "90012": "34.0614_-118.2385", "90013": "34.0448_-118.2434", "90014": "34.0443_-118.2509", "90015": "34.0434_-118.2716", "90016": "34.0298_-118.3528", "90017": "34.0559_-118.2666", "90018": "34.029_-118.3152", "90019": "34.0482_-118.3343", "90020": "34.0665_-118.3022", "90021": "34.0333_-118.2447", "90022": "34.0245_-118.1561", "90023": "34.0245_-118.1975", "90024": "34.0637_-118.4408", "90025": "34.0447_-118.4487", "90026": "34.0766_-118.2646", "90027": "34.104_-118.2925", "90028": "34.1005_-118.3254", "90029": "34.09_-118.2944", "90030": "34.0522_-118.2437", "90031": "34.0783_-118.2113", "90032": "34.0818_-118.1753", "90033": "34.0487_-118.2084", "90034": "34.029_-118.4005", "90035": "34.0531_-118.3806", "90036": "34.0699_-118.3492", "90037": "34.003_-118.2863", "90038": "34.0898_-118.3215", "90039": "34.1121_-118.2594", "90040": "33.9909_-118.1532", "90041": "34.1339_-118.2082", "90042": "34.1145_-118.1929", "90043": "33.9871_-118.3321", "90044": "33.9551_-118.2901", "90045": "33.9631_-118.3941", "90046": "34.1074_-118.3652", "90047": "33.9569_-118.3073", "90048": "34.0737_-118.372", "90049": "34.066_-118.474", "90050": "34.0522_-118.2437", "90051": "34.0522_-118.2437", "90052": "34.0522_-118.2437", "90053": "34.0522_-118.2437", "90054": "34.0522_-118.2437", "90055": "34.0522_-118.2437", "90056": "33.9853_-118.3707", "90057": "34.0622_-118.2763", "90058": "33.9994_-118.2133", "90059": "33.9293_-118.2463", "90060": "34.0522_-118.2437", "90061": "33.9245_-118.2716", "90062": "34.0032_-118.3073", "90063": "34.0451_-118.1859", "90064": "34.0353_-118.4259", "90065": "34.1073_-118.2266", "90066": "34.003_-118.4298", "90067": "34.0551_-118.4095", "90068": "34.1156_-118.3305", "90069": "34.0906_-118.3788", "90070": "34.0522_-118.2437", "90071": "34.0529_-118.2549", "90072": "34.0522_-118.2437", "90073": "33.7866_-118.2987", "90074": "34.0522_-118.2437", "90075": "34.0522_-118.2437", "90076": "34.0522_-118.2437", "90077": "34.1112_-118.4502", "90078": "34.0522_-118.2437", "90079": "33.7866_-118.2987", "90080": "34.0522_-118.2437", "90081": "34.0522_-118.2437", "90082": "34.0522_-118.2437", "90083": "34.0522_-118.2437", "90084": "34.0522_-118.2437", "90086": "34.0522_-118.2437", "90087": "34.0522_-118.2437", "90088": "34.0522_-118.2437", "90089": "33.7866_-118.2987", "90090": "34.0725_-118.2418", "90091": "34.0522_-118.2437", "90093": "34.0522_-118.2437", "90094": "33.9728_-118.4276", "90095": "33.7866_-118.2987", "90096": "34.0522_-118.2437", "90099": "34.0522_-118.2437", "90134": "34.0522_-118.2437", "90189": "34.0515_-118.2559", "90201": "33.9653_-118.1515", "90202": "33.9775_-118.187", "90209": "34.0736_-118.4004", "90210": "34.0901_-118.4065", "90211": "34.0652_-118.383", "90212": "34.0619_-118.3995", "90213": "34.0736_-118.4004", "90220": "33.8748_-118.2402", "90221": "33.8796_-118.2168", "90222": "33.9099_-118.2357", "90223": "33.8958_-118.2201", "90224": "33.7866_-118.2987", "90230": "33.9949_-118.3991", "90231": "34.0211_-118.3965", "90232": "34.0168_-118.3973", "90233": "34.0211_-118.3965", "90239": "33.94_-118.1326", "90240": "33.9581_-118.1174", "90241": "33.9416_-118.1306", "90242": "33.9218_-118.1395", "90245": "33.9243_-118.4119", "90247": "33.8925_-118.2961", "90248": "33.8766_-118.2835", "90249": "33.8998_-118.3199", "90250": "33.9143_-118.3493", "90251": "33.9164_-118.3526", "90254": "33.8643_-118.3955", "90255": "33.9769_-118.2161", "90260": "33.8879_-118.351", "90261": "33.8872_-118.3526", "90262": "33.9241_-118.2013", "90263": "34.005_-118.8101", "90264": "34.005_-118.8101", "90265": "34.0402_-118.7351", "90266": "33.8896_-118.3996", "90267": "33.7866_-118.2987", "90270": "33.989_-118.1877", "90272": "34.0481_-118.5265", "90274": "33.7669_-118.3806", "90275": "33.7515_-118.367", "90277": "33.8307_-118.3832", "90278": "33.8707_-118.3715", "90280": "33.9462_-118.2013", "90290": "34.1076_-118.6023", "90291": "33.9938_-118.4635", "90292": "33.9779_-118.4525", "90293": "33.9577_-118.4373", "90294": "33.9908_-118.4601", "90295": "33.7866_-118.2987", "90296": "33.7866_-118.2987", "90301": "33.955_-118.3556", "90302": "33.9745_-118.3548", "90303": "33.9377_-118.3321", "90304": "33.9379_-118.3586", "90305": "33.9583_-118.3259", "90306": "33.9617_-118.3531", "90307": "33.7866_-118.2987", "90308": "33.9617_-118.3531", "90309": "33.7866_-118.2987", "90310": "33.7866_-118.2987", "90311": "33.9617_-118.3531", "90312": "33.9617_-118.3531", "90401": "34.0176_-118.4907", "90402": "34.0349_-118.503", "90403": "34.0287_-118.4924", "90404": "34.0268_-118.4733", "90405": "34.01_-118.4717", "90406": "34.0195_-118.4912", "90407": "34.0195_-118.4912", "90408": "34.0195_-118.4912", "90409": "34.0195_-118.4912", "90410": "34.0195_-118.4912", "90411": "34.0195_-118.4912", "90501": "33.8268_-118.3118", "90502": "33.8286_-118.292", "90503": "33.8397_-118.3542", "90504": "33.8708_-118.3295", "90505": "33.8106_-118.3507", "90506": "33.7866_-118.2987", "90507": "33.7866_-118.2987", "90508": "33.7866_-118.2987", "90509": "33.7866_-118.2987", "90510": "33.7866_-118.2987", "90601": "34.0011_-118.0371", "90602": "33.9693_-118.0337", "90603": "33.9432_-117.9927", "90604": "33.9299_-118.0121", "90605": "33.9413_-118.0356", "90606": "33.9777_-118.0658", "90607": "33.9792_-118.0328", "90608": "33.9792_-118.0328", "90609": "33.9792_-118.0328", "90610": "33.9792_-118.0328", "90637": "33.9172_-118.012", "90638": "33.9067_-118.0101", "90639": "33.9058_-118.0182", "90640": "34.0133_-118.113", "90650": "33.9056_-118.0818", "90651": "33.9022_-118.0817", "90652": "33.9022_-118.0817", "90660": "33.9886_-118.0883", "90661": "33.9831_-118.0967", "90662": "33.9831_-118.0967", "90670": "33.9464_-118.0838", "90671": "33.9472_-118.0853", "90701": "33.8654_-118.0731", "90702": "33.8658_-118.0831", "90703": "33.8669_-118.0686", "90704": "33.332_-118.3437", "90706": "33.8867_-118.1265", "90707": "33.8817_-118.117", "90710": "33.797_-118.2991", "90711": "33.7866_-118.2987", "90712": "33.8512_-118.1457", "90713": "33.8473_-118.1115", "90714": "33.8512_-118.1339", "90715": "33.8405_-118.0767", "90716": "33.8296_-118.073", "90717": "33.7938_-118.3172", "90723": "33.8969_-118.1632", "90731": "33.7339_-118.2914", "90732": "33.742_-118.3121", "90733": "33.7866_-118.2987", "90734": "33.7866_-118.2987", "90744": "33.7855_-118.2645", "90745": "33.823_-118.2684", "90746": "33.8584_-118.2554", "90747": "33.8671_-118.2538", "90748": "33.78_-118.2626", "90749": "33.7866_-118.2987", "90755": "33.8029_-118.1677", "90801": "33.767_-118.1892", "90802": "33.7706_-118.182", "90803": "33.7619_-118.1341", "90804": "33.7857_-118.1357", "90805": "33.8635_-118.1801", "90806": "33.8045_-118.1876", "90807": "33.8315_-118.1811", "90808": "33.8241_-118.1103", "90809": "33.7866_-118.2987", "90810": "33.8193_-118.2325", "90813": "33.782_-118.1835", "90814": "33.7716_-118.148", "90815": "33.7939_-118.1192", "90822": "33.7927_-118.1638", "90831": "33.7678_-118.1994", "90832": "33.767_-118.1892", "90833": "33.7678_-118.1994", "90834": "33.7678_-118.1994", "90835": "33.7678_-118.1994", "90840": "33.7843_-118.1157", "90842": "33.7866_-118.2987", "90844": "33.767_-118.1892", "90846": "33.8249_-118.1504", "90847": "33.7866_-118.2987", "90848": "33.7866_-118.2987", "90853": "33.7866_-118.2987", "90895": "33.8392_-118.2202", "90899": "33.767_-118.1892", "91001": "34.1912_-118.1392", "91003": "34.1897_-118.1312", "91006": "34.1324_-118.0264", "91007": "34.1243_-118.0515", "91008": "34.149_-117.9644", "91009": "34.1395_-117.9773", "91010": "34.1407_-117.9567", "91011": "34.2217_-118.2051", "91012": "34.1992_-118.1879", "91016": "34.144_-118.0014", "91017": "34.1481_-117.999", "91020": "34.2114_-118.2305", "91021": "34.2064_-118.2242", "91023": "34.2264_-118.0662", "91024": "34.1651_-118.0519", "91025": "34.1617_-118.0528", "91030": "34.1109_-118.1547", "91031": "34.1161_-118.1503", "91040": "34.2618_-118.3371", "91041": "34.2669_-118.3023", "91042": "34.2544_-118.2849", "91043": "34.2522_-118.2884", "91046": "34.2114_-118.2395", "91066": "34.1397_-118.0353", "91077": "34.1397_-118.0353", "91101": "34.1468_-118.1391", "91102": "34.1478_-118.1445", "91103": "34.1669_-118.1551", "91104": "34.1678_-118.1261", "91105": "34.1355_-118.1636", "91106": "34.1435_-118.1266", "91107": "34.151_-118.0889", "91108": "34.1207_-118.1117", "91109": "34.1478_-118.1445", "91110": "34.1478_-118.1445", "91114": "34.1478_-118.1445", "91115": "34.1478_-118.1445", "91116": "34.1478_-118.1445", "91117": "34.1478_-118.1445", "91118": "34.1214_-118.1065", "91121": "34.1478_-118.1445", "91123": "34.1478_-118.1445", "91124": "34.1478_-118.1445", "91125": "34.1478_-118.1445", "91126": "34.1478_-118.1445", "91129": "34.1478_-118.1445", "91182": "34.1478_-118.1445", "91184": "34.1478_-118.1445", "91185": "34.1478_-118.1445", "91188": "34.1478_-118.1445", "91189": "34.1478_-118.1445", "91199": "34.1478_-118.1436", "91201": "34.1716_-118.2899", "91202": "34.1652_-118.2656", "91203": "34.1517_-118.2636", "91204": "34.1379_-118.2599", "91205": "34.1378_-118.2425", "91206": "34.1556_-118.2322", "91207": "34.1649_-118.2451", "91208": "34.1921_-118.235", "91209": "34.1425_-118.2551", "91210": "34.1425_-118.2551", "91214": "34.2316_-118.2457", "91221": "34.1425_-118.2551", "91222": "34.1425_-118.2551", "91224": "34.2242_-118.2401", "91225": "34.1425_-118.2551", "91226": "34.1425_-118.2551", "91301": "34.1227_-118.7573", "91302": "34.1419_-118.6641", "91303": "34.1993_-118.5983", "91304": "34.2197_-118.6111", "91305": "34.2011_-118.5981", "91306": "34.2092_-118.5749", "91307": "34.1963_-118.6389", "91308": "34.1973_-118.644", "91309": "34.2011_-118.5981", "91310": "34.4889_-118.6229", "91311": "34.2583_-118.5914", "91313": "34.2572_-118.6012", "91316": "34.1655_-118.5175", "91321": "34.3795_-118.523", "91322": "34.3847_-118.5309", "91324": "34.2367_-118.5466", "91325": "34.2353_-118.5188", "91326": "34.2619_-118.582", "91327": "34.2283_-118.5368", "91328": "34.2283_-118.5368", "91329": "34.2283_-118.5368", "91330": "34.2283_-118.5368", "91331": "34.2556_-118.4208", "91333": "34.2625_-118.427", "91334": "34.2625_-118.427", "91335": "34.2007_-118.5391", "91337": "34.2011_-118.5365", "91340": "34.2875_-118.4352", "91341": "34.2819_-118.439", "91342": "34.3054_-118.4322", "91343": "34.2366_-118.4758", "91344": "34.2771_-118.4992", "91345": "34.2619_-118.4587", "91346": "34.2572_-118.467", "91350": "34.4336_-118.5007", "91351": "34.4262_-118.449", "91352": "34.2209_-118.3699", "91353": "34.2175_-118.3704", "91354": "34.4466_-118.5374", "91355": "34.3985_-118.5535", "91356": "34.1671_-118.5414", "91357": "34.1733_-118.554", "91364": "34.1557_-118.6", "91365": "34.1683_-118.6059", "91367": "34.1767_-118.6159", "91371": "34.1683_-118.6059", "91372": "34.1578_-118.6384", "91376": "34.1364_-118.7745", "91380": "34.3917_-118.5426", "91381": "34.3775_-118.6131", "91382": "34.3917_-118.5426", "91383": "34.3917_-118.5426", "91384": "34.4827_-118.6254", "91385": "34.4436_-118.6095", "91386": "34.4233_-118.472", "91387": "34.4132_-118.426", "91390": "34.4684_-118.5261", "91392": "34.3078_-118.4492", "91393": "34.2364_-118.4847", "91394": "34.2647_-118.5231", "91395": "34.2572_-118.467", "91396": "34.2133_-118.572", "91401": "34.1802_-118.4324", "91402": "34.2262_-118.447", "91403": "34.1514_-118.4603", "91404": "34.1867_-118.449", "91405": "34.2001_-118.4456", "91406": "34.2006_-118.4868", "91407": "34.1867_-118.449", "91408": "34.1867_-118.449", "91409": "34.1867_-118.449", "91410": "34.1867_-118.449", "91411": "34.1781_-118.4574", "91412": "34.2247_-118.4498", "91413": "34.1511_-118.4492", "91416": "34.1592_-118.5012", "91423": "34.1526_-118.4322", "91426": "34.1592_-118.5012", "91436": "34.151_-118.4882", "91470": "34.1867_-118.449", "91482": "34.1867_-118.449", "91495": "34.1511_-118.4492", "91496": "34.1867_-118.449", "91499": "34.1867_-118.449", "91501": "34.1862_-118.3009", "91502": "34.1745_-118.3059", "91503": "34.1808_-118.309", "91504": "34.2001_-118.3264", "91505": "34.169_-118.3442", "91506": "34.1717_-118.3231", "91507": "34.1808_-118.309", "91508": "34.1808_-118.309", "91510": "34.1808_-118.309", "91521": "34.1808_-118.309", "91522": "34.1808_-118.309", "91523": "34.1808_-118.309", "91526": "34.1808_-118.309", "91601": "34.1687_-118.3713", "91602": "34.151_-118.3663", "91603": "34.1722_-118.379", "91604": "34.143_-118.3913", "91605": "34.2057_-118.4001", "91606": "34.1872_-118.3865", "91607": "34.1672_-118.3989", "91608": "34.1383_-118.3528", "91609": "34.1722_-118.379", "91610": "33.7866_-118.2987", "91611": "34.1722_-118.379", "91612": "34.1722_-118.379", "91614": "34.1486_-118.3965", "91615": "34.1722_-118.379", "91616": "34.1722_-118.379", "91617": "34.1649_-118.3965", "91618": "34.1722_-118.379", "91702": "34.1248_-117.9031", "91706": "34.0964_-117.9682", "91711": "34.1092_-117.7183", "91714": "34.0197_-117.9587", "91715": "34.0197_-117.9587", "91716": "34.0197_-117.9587", "91722": "34.0972_-117.9065", "91723": "34.086_-117.8843", "91724": "34.0938_-117.856", "91731": "34.0791_-118.0371", "91732": "34.0705_-118.0149", "91733": "34.0557_-118.0444", "91734": "34.0686_-118.0276", "91735": "34.0686_-118.0276", "91740": "34.1287_-117.8552", "91741": "34.1537_-117.8437", "91744": "34.0289_-117.9373", "91745": "33.9977_-117.9652", "91746": "34.0443_-117.9862", "91747": "34.02_-117.9495", "91748": "33.9818_-117.8969", "91749": "34.02_-117.9495", "91750": "34.1159_-117.7708", "91754": "34.0534_-118.1271", "91755": "34.048_-118.115", "91756": "34.0625_-118.1228", "91759": "34.2361_-117.6601", "91765": "34.0066_-117.8098", "91766": "34.0418_-117.7569", "91767": "34.0812_-117.7362", "91768": "34.0662_-117.7763", "91769": "34.0553_-117.7523", "91770": "34.0658_-118.0853", "91771": "34.0806_-118.0728", "91772": "34.0806_-118.0728", "91773": "34.1023_-117.8169", "91775": "34.1155_-118.0857", "91776": "34.089_-118.0955", "91778": "34.0961_-118.1058", "91780": "34.1016_-118.0537", "91788": "34.0203_-117.8653", "91789": "34.0183_-117.8546", "91790": "34.0673_-117.9366", "91791": "34.0653_-117.8978", "91792": "34.0229_-117.8975", "91793": "34.0686_-117.939", "91801": "34.0914_-118.1293", "91802": "34.0953_-118.127", "91803": "34.0745_-118.1434", "91804": "34.0953_-118.127", "91896": "34.0953_-118.127", "91899": "34.0953_-118.127", "93510": "34.4835_-118.1959", "93532": "34.6847_-118.5442", "93534": "34.6909_-118.1491", "93535": "34.7131_-117.8783", "93536": "34.7471_-118.3687", "93539": "34.698_-118.1367", "93543": "34.4891_-117.9708", "93544": "34.493_-117.7543", "93550": "34.4133_-118.0917", "93551": "34.6017_-118.231", "93552": "34.5715_-118.0231", "93553": "34.4225_-117.9055", "93563": "34.3966_-117.7604", "93584": "34.698_-118.1367", "93586": "34.698_-118.1367", "93590": "34.5794_-118.1165", "93591": "34.6019_-117.8123", "93599": "34.5794_-118.1165", "93601": "37.4076_-119.7233", "93604": "37.3244_-119.5568", "93610": "37.1014_-120.2691", "93614": "37.2214_-119.7455", "93637": "36.9403_-120.082", "93638": "37.0402_-120.0335", "93639": "36.9613_-120.0607", "93643": "37.2125_-119.5143", "93644": "37.3476_-119.6449", "93645": "37.1639_-119.6652", "93653": "37.279_-119.8766", "93669": "37.281_-119.557", "94901": "37.9691_-122.5105", "94903": "38.0339_-122.5855", "94904": "37.9479_-122.5363", "94912": "37.9735_-122.5311", "94913": "37.9735_-122.5311", "94914": "37.9521_-122.5572", "94915": "38.0739_-122.5594", "94920": "37.8843_-122.4637", "94924": "37.9079_-122.6947", "94925": "37.9223_-122.5132", "94929": "38.2508_-122.9653", "94930": "37.9883_-122.5937", "94933": "38.0122_-122.6907", "94937": "38.1126_-122.8877", "94938": "38.0139_-122.7016", "94939": "37.9367_-122.5362", "94940": "38.1762_-122.89", "94941": "37.8958_-122.5339", "94942": "37.906_-122.545", "94945": "38.1163_-122.5714", "94946": "38.0546_-122.6964", "94947": "38.0973_-122.5837", "94948": "38.1489_-122.5737", "94949": "38.0618_-122.5404", "94950": "38.0467_-122.7699", "94956": "38.0691_-122.8069", "94957": "37.9624_-122.555", "94960": "37.9846_-122.5711", "94963": "38.0133_-122.6639", "94964": "37.9416_-122.4844", "94965": "37.8601_-122.4946", "94966": "37.8591_-122.4853", "94970": "37.902_-122.6393", "94971": "38.2427_-122.9145", "94973": "38.0069_-122.6382", "94974": "37.9413_-122.485", "94976": "37.9255_-122.5275", "94977": "37.9341_-122.5353", "94978": "37.9871_-122.5889", "94979": "37.9746_-122.5616", "94998": "38.1173_-122.5684", "93623": "37.4785_-119.6404", "95306": "37.4404_-120.1438", "95311": "37.7197_-120.1197", "95318": "37.6747_-119.7841", "95325": "37.4676_-120.2793", "95338": "37.4931_-119.9219", "95345": "37.5757_-119.9601", "95389": "37.7314_-119.6489", "95410": "39.2131_-123.72", "95415": "39.0197_-123.3856", "95417": "39.6949_-123.5527", "95418": "39.2214_-123.2154", "95420": "39.3629_-123.7944", "95427": "39.2767_-123.5873", "95428": "39.82_-123.0585", "95429": "39.7168_-123.3533", "95432": "39.1593_-123.7219", "95437": "39.4402_-123.7703", "95445": "38.8251_-123.5399", "95449": "38.938_-123.0703", "95454": "39.6627_-123.4929", "95456": "39.2707_-123.7883", "95459": "39.0097_-123.6523", "95460": "39.3173_-123.7739", "95463": "39.185_-123.5268", "95466": "39.0657_-123.445", "95468": "38.9152_-123.6", "95469": "39.3932_-123.0647", "95470": "39.2779_-123.2243", "95481": "39.1269_-123.1658", "95482": "39.1552_-123.1951", "95488": "39.6843_-123.7686", "95490": "39.4493_-123.3679", "95494": "38.9235_-123.2973", "95585": "39.8481_-123.6615", "95587": "39.9465_-123.7552", "93620": "37.0025_-120.6333", "93635": "37.0627_-120.8544", "93636": "36.9528_-119.8806", "93661": "37.1869_-120.6504", "93665": "36.9644_-120.6532", "95301": "37.3489_-120.6028", "95303": "37.4548_-120.6931", "95312": "37.4197_-120.6663", "95315": "37.4273_-120.7752", "95317": "37.1391_-120.5251", "95322": "37.2001_-121.0047", "95324": "37.4002_-120.8723", "95333": "37.2496_-120.2667", "95334": "37.3763_-120.7252", "95340": "37.2983_-120.4649", "95341": "37.2308_-120.5144", "95343": "37.3082_-120.48", "95344": "37.3082_-120.48", "95348": "37.3302_-120.508", "95365": "37.2908_-120.3185", "95369": "37.5354_-120.378", "95374": "37.3283_-120.8764", "95388": "37.4014_-120.6045", "96006": "41.2175_-120.9432", "96015": "41.4664_-120.9218", "96054": "41.2347_-121.2156", "96101": "41.4767_-120.5456", "96104": "41.4759_-120.1516", "96108": "41.7336_-120.3741", "96110": "41.3163_-120.1158", "96112": "41.8644_-120.162", "96115": "41.6682_-120.1814", "96116": "41.2329_-120.5079", "93512": "37.8926_-118.5647", "93517": "38.2566_-119.208", "93529": "37.7773_-119.0825", "93541": "37.989_-119.1234", "93546": "37.6094_-118.8656", "96107": "38.5029_-119.4828", "96133": "38.6415_-119.5122", "93426": "35.8093_-120.9728", "93450": "35.9857_-120.8612", "93901": "36.6677_-121.6596", "93902": "36.6777_-121.6555", "93905": "36.6811_-121.6176", "93906": "36.7103_-121.6438", "93907": "36.7563_-121.6703", "93908": "36.6011_-121.6729", "93912": "36.6777_-121.6555", "93915": "36.6777_-121.6555", "93920": "36.2458_-121.7009", "93921": "36.5552_-121.9233", "93922": "36.5433_-121.9263", "93923": "36.5457_-121.8949", "93924": "36.4787_-121.7244", "93925": "36.595_-121.432", "93926": "36.49_-121.4103", "93927": "36.3202_-121.2451", "93928": "35.9708_-121.176", "93930": "36.2028_-121.1273", "93932": "35.95_-121.0626", "93933": "36.6849_-121.7934", "93940": "36.5802_-121.8443", "93942": "36.6002_-121.8947", "93943": "36.597_-121.8741", "93944": "36.6062_-121.9089", "93950": "36.6167_-121.922", "93953": "36.5907_-121.942", "93954": "36.1289_-121.0205", "93955": "36.6217_-121.7935", "93960": "36.4196_-121.3243", "93962": "36.6261_-121.6555", "95004": "36.8769_-121.6324", "95012": "36.7658_-121.758", "95039": "36.8175_-121.7773", "94503": "38.1668_-122.2553", "94508": "38.5769_-122.4477", "94515": "38.5823_-122.5814", "94558": "38.4549_-122.2564", "94559": "38.2904_-122.2841", "94562": "38.4379_-122.3991", "94567": "38.6152_-122.4278", "94573": "38.4585_-122.4225", "94574": "38.5138_-122.4619", "94576": "38.5494_-122.4764", "94581": "38.2971_-122.2855", "94599": "38.4016_-122.3608", "95712": "39.143_-120.9666", "95724": "39.318_-120.356", "95728": "39.317_-120.4259", "95924": "39.1988_-121.02", "95945": "39.2081_-121.0069", "95946": "39.2019_-121.2026", "95949": "39.1193_-121.0938", "95959": "39.3017_-120.9717", "95960": "39.3765_-121.0891", "95975": "39.2286_-121.1509", "95977": "39.2076_-121.3001", "95986": "39.3569_-120.8", "96111": "39.3928_-120.0212", "96160": "39.328_-120.1833", "96161": "39.3385_-120.1729", "96162": "39.328_-120.1833", "90620": "33.8439_-118.008", "90621": "33.8772_-117.9893", "90622": "33.8462_-118.0031", "90623": "33.8491_-118.0398", "90624": "33.8584_-118.0033", "90630": "33.8181_-118.0357", "90631": "33.9331_-117.9493", "90632": "33.9143_-117.9547", "90633": "33.9345_-117.9452", "90680": "33.7991_-117.9956", "90720": "33.7956_-118.0648", "90721": "33.8023_-118.069", "90740": "33.7602_-118.0808", "90742": "33.7164_-118.069", "90743": "33.7264_-118.0833", "92602": "33.7419_-117.7467", "92603": "33.6245_-117.794", "92604": "33.6899_-117.7868", "92605": "33.7151_-118.0077", "92606": "33.6951_-117.8224", "92607": "33.5269_-117.7117", "92609": "33.624_-117.6908", "92610": "33.6748_-117.6649", "92612": "33.6607_-117.8264", "92614": "33.6829_-117.8298", "92615": "33.6566_-117.9699", "92616": "33.6519_-117.8361", "92617": "33.6425_-117.8417", "92618": "33.7074_-117.7054", "92619": "33.6706_-117.7645", "92620": "33.7009_-117.7564", "92623": "33.6942_-117.8126", "92624": "33.46_-117.6632", "92625": "33.6021_-117.8743", "92626": "33.6801_-117.9085", "92627": "33.6483_-117.9155", "92628": "33.6401_-117.9159", "92629": "33.4743_-117.6964", "92630": "33.6437_-117.6868", "92637": "33.6103_-117.7253", "92646": "33.6654_-117.9686", "92647": "33.721_-118.0033", "92648": "33.6773_-118.0051", "92649": "33.718_-118.0505", "92650": "33.6795_-117.7609", "92651": "33.5429_-117.7813", "92652": "33.543_-117.7815", "92653": "33.5916_-117.6985", "92654": "33.6042_-117.7154", "92655": "33.7446_-117.984", "92656": "33.5701_-117.7086", "92657": "33.5943_-117.8334", "92658": "33.6422_-117.8631", "92659": "33.6222_-117.9235", "92660": "33.6295_-117.8684", "92661": "33.6045_-117.9021", "92662": "33.6062_-117.8931", "92663": "33.621_-117.9321", "92672": "33.4361_-117.6231", "92673": "33.4615_-117.6375", "92674": "33.4409_-117.6211", "92675": "33.5085_-117.6565", "92676": "33.7451_-117.6153", "92677": "33.5145_-117.7084", "92678": "33.6643_-117.5896", "92679": "33.6625_-117.5903", "92683": "33.7524_-117.9939", "92684": "33.7627_-118.0072", "92685": "33.7528_-117.9951", "92688": "33.6512_-117.5938", "92690": "33.6117_-117.643", "92691": "33.6128_-117.6622", "92692": "33.6144_-117.6433", "92693": "33.4977_-117.6651", "92694": "33.5472_-117.6238", "92697": "33.6485_-117.8387", "92698": "33.6686_-117.8386", "92701": "33.7523_-117.8541", "92702": "33.7365_-117.8714", "92703": "33.7489_-117.9072", "92704": "33.7249_-117.909", "92705": "33.754_-117.7919", "92706": "33.7691_-117.8855", "92707": "33.7086_-117.8701", "92708": "33.7102_-117.9503", "92711": "33.7669_-117.8043", "92712": "33.7496_-117.875", "92728": "33.714_-117.9284", "92735": "33.7188_-117.8546", "92780": "33.7364_-117.8229", "92781": "33.7369_-117.8181", "92782": "33.7346_-117.7869", "92799": "33.7205_-117.9098", "92801": "33.8428_-117.9546", "92802": "33.8085_-117.9228", "92803": "33.8397_-117.9388", "92804": "33.8186_-117.9729", "92805": "33.8359_-117.9086", "92806": "33.8356_-117.8681", "92807": "33.8544_-117.7858", "92808": "33.8579_-117.7513", "92809": "33.8426_-117.9388", "92811": "33.8674_-117.831", "92812": "33.817_-117.9286", "92814": "33.8173_-117.9607", "92815": "33.8319_-117.9121", "92816": "33.8401_-117.8867", "92817": "33.8512_-117.7915", "92821": "33.9291_-117.8845", "92822": "33.9187_-117.8892", "92823": "33.923_-117.798", "92825": "33.8356_-117.9132", "92831": "33.8873_-117.8946", "92832": "33.868_-117.9265", "92833": "33.8766_-117.9551", "92834": "33.8768_-117.897", "92835": "33.8994_-117.9063", "92836": "33.8755_-117.9038", "92837": "33.8695_-117.9611", "92838": "33.8934_-117.931", "92840": "33.7869_-117.9273", "92841": "33.7817_-117.9766", "92842": "33.7783_-117.9456", "92843": "33.7671_-117.929", "92844": "33.7661_-117.9738", "92845": "33.7787_-118.0267", "92846": "33.788_-118.0325", "92850": "33.8442_-117.9555", "92856": "33.7841_-117.8435", "92857": "33.8317_-117.8491", "92859": "33.8027_-117.7867", "92861": "33.8205_-117.8104", "92862": "33.7915_-117.714", "92863": "33.8153_-117.8273", "92864": "33.8143_-117.8308", "92865": "33.8263_-117.8511", "92866": "33.7877_-117.8423", "92867": "33.811_-117.8493", "92868": "33.7875_-117.8776", "92869": "33.7868_-117.7934", "92870": "33.8744_-117.8543", "92871": "33.8829_-117.8557", "92885": "33.8911_-117.8222", "92886": "33.9058_-117.7865", "92887": "33.8841_-117.7304", "92899": "33.8373_-117.8712", "95602": "38.9829_-121.0944", "95603": "38.9115_-121.08", "95604": "38.9029_-121.067", "95631": "39.0682_-120.7224", "95648": "38.8942_-121.2908", "95650": "38.8071_-121.1698", "95658": "38.8763_-121.143", "95661": "38.7346_-121.234", "95663": "38.8567_-121.1791", "95677": "38.7877_-121.2366", "95678": "38.7609_-121.2867", "95681": "38.9953_-121.368", "95701": "39.2441_-120.7531", "95703": "39.0007_-120.9924", "95713": "39.0783_-120.9549", "95714": "39.1978_-120.8262", "95715": "39.2968_-120.6727", "95717": "39.171_-120.8601", "95722": "39.0031_-121.0292", "95736": "39.0375_-120.9713", "95746": "38.7435_-121.1897", "95747": "38.7703_-121.3372", "95765": "38.8136_-121.2677", "96140": "39.2319_-120.0753", "96141": "39.0786_-120.1734", "96143": "39.2401_-120.0233", "96145": "39.1806_-120.1445", "96146": "39.1752_-120.1954", "96148": "39.2448_-120.0521", "95915": "40.006_-121.2491", "95923": "39.5645_-121.5751", "95934": "40.0673_-120.9248", "95947": "40.1699_-120.9014", "95956": "39.9296_-121.0608", "95971": "39.9284_-120.9698", "95980": "39.9175_-121.3222", "95983": "40.0357_-120.7353", "95984": "40.0509_-121.1268", "96020": "40.2975_-121.2273", "96103": "40.1919_-120.1746", "96105": "39.7977_-120.1396", "96106": "39.7546_-120.5951", "96122": "39.8105_-120.4691", "96129": "39.7721_-120.4051", "96135": "39.8043_-120.1783", "91752": "33.9938_-117.5236", "92201": "33.7207_-116.2168", "92202": "33.7529_-116.0556", "92203": "33.7532_-116.2676", "92210": "33.7163_-116.3381", "92211": "33.7644_-116.3398", "92220": "33.9282_-116.8899", "92223": "33.9504_-116.9701", "92225": "33.6103_-114.5963", "92226": "33.5987_-114.6525", "92230": "33.9086_-116.7739", "92234": "33.8098_-116.4665", "92235": "33.7797_-116.4653", "92236": "33.675_-116.1772", "92239": "33.809_-115.3666", "92240": "33.9531_-116.5219", "92241": "33.8763_-116.354", "92247": "33.6736_-116.2951", "92253": "33.6685_-116.3081", "92254": "33.545_-116.0187", "92255": "33.7225_-116.377", "92258": "33.9228_-116.5431", "92260": "33.7225_-116.377", "92261": "33.6604_-116.4082", "92262": "33.8414_-116.5347", "92263": "33.7611_-116.5359", "92264": "33.8018_-116.517", "92270": "33.7643_-116.4225", "92274": "33.5578_-116.1572", "92276": "33.8082_-116.3713", "92282": "33.989_-116.6566", "92320": "33.9946_-117.043", "92501": "33.9924_-117.3694", "92502": "33.9533_-117.3962", "92503": "33.9208_-117.4589", "92504": "33.9315_-117.4119", "92505": "33.9228_-117.4867", "92506": "33.9455_-117.3757", "92507": "33.9761_-117.3389", "92508": "33.8897_-117.3043", "92509": "34.0033_-117.445", "92513": "33.9533_-117.3962", "92514": "33.9533_-117.3962", "92515": "33.9533_-117.3962", "92516": "33.9533_-117.3962", "92517": "33.9533_-117.3962", "92518": "33.9533_-117.3962", "92519": "33.9533_-117.3962", "92521": "33.9533_-117.3962", "92522": "33.9533_-117.3962", "92530": "33.6598_-117.3485", "92531": "33.6681_-117.3273", "92532": "33.6927_-117.303", "92536": "33.4473_-116.7997", "92539": "33.5688_-116.7135", "92543": "33.7416_-116.973", "92544": "33.739_-116.9243", "92545": "33.7399_-117.0151", "92546": "33.7476_-116.9731", "92548": "33.7453_-117.1118", "92549": "33.7304_-116.7107", "92551": "33.8814_-117.2261", "92552": "33.9375_-117.2306", "92553": "33.9157_-117.2351", "92554": "33.9375_-117.2306", "92555": "33.9377_-117.1851", "92556": "33.9375_-117.2306", "92557": "33.9553_-117.2457", "92561": "33.7042_-116.7259", "92562": "33.5631_-117.2738", "92563": "33.569_-117.1783", "92564": "33.5539_-117.2139", "92567": "33.8123_-117.1048", "92570": "33.7852_-117.3166", "92571": "33.811_-117.218", "92572": "33.7825_-117.2286", "92581": "33.7839_-116.9586", "92582": "33.7883_-116.9819", "92583": "33.7967_-116.9324", "92584": "33.6647_-117.1743", "92585": "33.7467_-117.1721", "92586": "33.7044_-117.1969", "92587": "33.707_-117.245", "92589": "33.4936_-117.1484", "92590": "33.4903_-117.1824", "92591": "33.5217_-117.1286", "92592": "33.4983_-117.0958", "92593": "33.4936_-117.1484", "92595": "33.6021_-117.264", "92596": "33.6243_-117.0885", "92599": "33.7825_-117.2286", "92860": "33.9247_-117.5517", "92877": "33.8753_-117.5664", "92878": "33.8753_-117.5664", "92879": "33.8797_-117.5354", "92880": "33.9208_-117.6096", "92881": "33.8241_-117.5198", "92882": "33.8419_-117.6043", "92883": "33.7541_-117.474", "94203": "38.5816_-121.4944", "94204": "38.5816_-121.4944", "94205": "38.5816_-121.4944", "94206": "38.5816_-121.4944", "94207": "38.5816_-121.4944", "94208": "38.5816_-121.4944", "94209": "38.5816_-121.4944", "94211": "38.5816_-121.4944", "94229": "38.5816_-121.4944", "94230": "38.5816_-121.4944", "94232": "38.5816_-121.4944", "94234": "38.5816_-121.4944", "94235": "38.5816_-121.4944", "94236": "38.5816_-121.4944", "94237": "38.5816_-121.4944", "94239": "38.5816_-121.4944", "94240": "38.5816_-121.4944", "94244": "38.5816_-121.4944", "94245": "38.5816_-121.4944", "94247": "38.5816_-121.4944", "94248": "38.5816_-121.4944", "94249": "38.5816_-121.4944", "94250": "38.5816_-121.4944", "94252": "38.5816_-121.4944", "94254": "38.5816_-121.4944", "94256": "38.5816_-121.4944", "94257": "38.5816_-121.4944", "94258": "38.5816_-121.4944", "94259": "38.5816_-121.4944", "94261": "38.5816_-121.4944", "94262": "38.5816_-121.4944", "94263": "38.5816_-121.4944", "94267": "38.5816_-121.4944", "94268": "38.5816_-121.4944", "94269": "38.5816_-121.4944", "94271": "38.5816_-121.4944", "94273": "38.5816_-121.4944", "94274": "38.5816_-121.4944", "94277": "38.5816_-121.4944", "94278": "38.5816_-121.4944", "94279": "38.5816_-121.4944", "94280": "38.5816_-121.4944", "94282": "38.5816_-121.4944", "94283": "38.5816_-121.4944", "94284": "38.5816_-121.4944", "94285": "38.5816_-121.4944", "94286": "38.5816_-121.4944", "94287": "38.5816_-121.4944", "94288": "38.5816_-121.4944", "94289": "38.5816_-121.4944", "94290": "38.5816_-121.4944", "94291": "38.5816_-121.4944", "94293": "38.5816_-121.4944", "94294": "38.5816_-121.4944", "94295": "38.5816_-121.4944", "94296": "38.5816_-121.4944", "94297": "38.5816_-121.4944", "94298": "38.5816_-121.4944", "94299": "38.5816_-121.4944", "95608": "38.6284_-121.3287", "95609": "38.6257_-121.3272", "95610": "38.6946_-121.2692", "95611": "38.7072_-121.28", "95615": "38.3137_-121.563", "95621": "38.6952_-121.3075", "95624": "38.4232_-121.3599", "95626": "38.7233_-121.4497", "95628": "38.6554_-121.2611", "95630": "38.6709_-121.1529", "95632": "38.2691_-121.3", "95638": "38.3119_-121.1729", "95639": "38.3702_-121.5143", "95641": "38.157_-121.6066", "95652": "38.6621_-121.3955", "95655": "38.5579_-121.291", "95660": "38.6707_-121.3781", "95662": "38.6845_-121.2256", "95670": "38.6072_-121.2761", "95671": "38.7065_-121.1694", "95673": "38.6895_-121.4479", "95680": "38.2386_-121.5594", "95683": "38.5143_-121.0964", "95690": "38.2396_-121.5443", "95693": "38.3983_-121.2303", "95741": "38.5891_-121.3016", "95742": "38.5981_-121.2153", "95757": "38.4081_-121.4294", "95758": "38.4243_-121.437", "95759": "38.407_-121.3752", "95763": "38.678_-121.175", "95811": "38.5762_-121.488", "95812": "38.5822_-121.4943", "95813": "38.6026_-121.4475", "95814": "38.5804_-121.4922", "95815": "38.6093_-121.4443", "95816": "38.5728_-121.4675", "95817": "38.5498_-121.4583", "95818": "38.5568_-121.4929", "95819": "38.5683_-121.4366", "95820": "38.5347_-121.4451", "95821": "38.6239_-121.3837", "95822": "38.5091_-121.4935", "95823": "38.4797_-121.4438", "95824": "38.5178_-121.4419", "95825": "38.5892_-121.4057", "95826": "38.5539_-121.3693", "95827": "38.5662_-121.3286", "95828": "38.4826_-121.4006", "95829": "38.4689_-121.344", "95830": "38.4896_-121.2772", "95831": "38.4962_-121.5297", "95832": "38.4695_-121.4883", "95833": "38.6157_-121.5053", "95834": "38.6383_-121.5072", "95835": "38.6626_-121.4834", "95836": "38.7198_-121.5343", "95837": "38.6817_-121.603", "95838": "38.6406_-121.444", "95840": "38.5816_-121.4933", "95841": "38.6627_-121.3406", "95842": "38.6865_-121.3494", "95843": "38.7159_-121.3648", "95851": "38.6026_-121.4475", "95852": "38.6026_-121.4475", "95853": "38.6026_-121.4475", "95860": "38.6105_-121.3799", "95864": "38.5878_-121.3769", "95865": "38.596_-121.3978", "95866": "38.596_-121.3978", "95867": "38.5816_-121.4933", "95894": "38.5816_-121.4933", "95899": "38.5383_-121.5549", "95023": "36.8337_-121.3439", "95024": "36.8586_-121.3982", "95043": "36.4985_-120.9744", "95045": "36.8463_-121.5346", "95075": "36.767_-121.3017", "91701": "34.1376_-117.5999", "91708": "33.954_-117.6404", "91709": "33.9797_-117.7308", "91710": "34.0125_-117.6844", "91729": "34.1064_-117.5931", "91730": "34.107_-117.5941", "91737": "34.1467_-117.5803", "91739": "34.1705_-117.5182", "91743": "34.065_-117.5864", "91758": "34.0633_-117.6509", "91761": "34.0316_-117.6187", "91762": "34.0584_-117.6665", "91763": "34.0733_-117.6987", "91764": "34.0763_-117.6254", "91784": "34.141_-117.6581", "91785": "34.1144_-117.6583", "91786": "34.1144_-117.6583", "92242": "34.1652_-114.3197", "92248": "33.6736_-116.2951", "92252": "34.1502_-116.3038", "92256": "34.0606_-116.5656", "92267": "34.2872_-114.143", "92268": "34.1887_-116.5048", "92277": "34.1455_-116.0601", "92278": "34.238_-116.0604", "92280": "34.1561_-114.5656", "92284": "34.1559_-116.4313", "92285": "34.3103_-116.5241", "92286": "34.1803_-116.35", "92301": "34.5841_-117.4242", "92304": "34.5578_-115.7444", "92305": "34.1531_-116.9485", "92307": "34.5291_-117.2132", "92308": "34.4698_-117.1927", "92309": "35.3606_-116.0638", "92310": "35.2625_-116.6966", "92311": "34.8914_-117.0387", "92312": "34.8986_-117.0228", "92313": "34.031_-117.3129", "92314": "34.261_-116.8131", "92315": "34.235_-116.9053", "92316": "34.0662_-117.3993", "92317": "34.2112_-117.0796", "92318": "34.0483_-117.2309", "92321": "34.2545_-117.1533", "92322": "34.2544_-117.3265", "92323": "35.2378_-115.4992", "92324": "34.0315_-117.2874", "92325": "34.2433_-117.2811", "92327": "34.8668_-116.8876", "92329": "34.4261_-117.5723", "92332": "34.5881_-115.5771", "92333": "34.2583_-116.9515", "92334": "34.0922_-117.435", "92335": "34.0794_-117.4551", "92336": "34.1173_-117.4378", "92337": "34.0498_-117.4706", "92338": "34.7211_-116.16", "92339": "34.0937_-116.9362", "92340": "34.4264_-117.3009", "92341": "34.2348_-117.066", "92342": "34.7499_-117.3367", "92344": "34.4239_-117.4075", "92345": "34.4222_-117.3025", "92346": "34.1283_-117.2087", "92347": "34.9279_-117.1809", "92350": "34.0483_-117.2612", "92352": "34.2606_-117.2016", "92354": "34.0528_-117.2513", "92356": "34.447_-116.9189", "92357": "34.0483_-117.2612", "92358": "34.2558_-117.5186", "92359": "34.0774_-117.1126", "92363": "34.7824_-114.5871", "92364": "35.4667_-115.2722", "92365": "34.885_-116.7464", "92366": "35.4703_-115.545", "92368": "34.6178_-117.3327", "92369": "34.1358_-117.2239", "92371": "34.4449_-117.5196", "92372": "34.4429_-117.6403", "92373": "34.0397_-117.1804", "92374": "34.065_-117.1672", "92375": "34.0556_-117.1825", "92376": "34.1132_-117.3771", "92377": "34.1561_-117.4042", "92378": "34.2297_-117.225", "92382": "34.2102_-117.1109", "92385": "34.2353_-117.1792", "92386": "34.2372_-116.8277", "92391": "34.2379_-117.2348", "92392": "34.4802_-117.4082", "92393": "34.5361_-117.2912", "92394": "34.5563_-117.3528", "92395": "34.5016_-117.2944", "92397": "34.3628_-117.6249", "92398": "34.905_-116.8203", "92399": "34.0282_-117.0489", "92401": "34.1105_-117.2898", "92402": "34.1083_-117.2898", "92403": "34.1083_-117.2898", "92404": "34.1426_-117.2606", "92405": "34.1446_-117.3013", "92406": "34.1083_-117.2898", "92407": "34.2166_-117.3908", "92408": "34.0831_-117.2711", "92410": "34.1069_-117.2975", "92411": "34.1214_-117.3172", "92413": "34.1083_-117.2898", "92415": "34.1083_-117.2898", "92418": "34.1083_-117.2898", "92423": "34.1083_-117.2898", "92427": "34.1083_-117.2898", "93558": "35.3479_-117.6214", "93562": "35.7481_-117.3808", "93592": "35.7627_-117.3728", "91901": "32.8282_-116.7543", "91902": "32.6671_-117.0221", "91903": "32.8351_-116.7664", "91905": "32.6719_-116.32", "91906": "32.6605_-116.4905", "91908": "32.6578_-117.03", "91909": "32.6401_-117.0842", "91910": "32.6371_-117.0676", "91911": "32.6084_-117.0565", "91912": "32.6401_-117.0842", "91913": "32.6513_-116.9852", "91914": "32.6587_-116.9652", "91915": "32.6315_-116.9408", "91916": "32.873_-116.6027", "91917": "32.6152_-116.7285", "91921": "32.6401_-117.0842", "91931": "32.8497_-116.5583", "91932": "32.5783_-117.1148", "91933": "32.5839_-117.1131", "91934": "32.6249_-116.1952", "91935": "32.7163_-116.8323", "91941": "32.7604_-117.0115", "91942": "32.7835_-117.0189", "91943": "32.7678_-117.0231", "91944": "32.7678_-117.0231", "91945": "32.7332_-117.0326", "91946": "32.7426_-117.0314", "91948": "32.8676_-116.4206", "91950": "32.6749_-117.0897", "91951": "32.6781_-117.0992", "91962": "32.835_-116.5127", "91963": "32.6205_-116.6037", "91976": "32.7448_-116.9989", "91977": "32.724_-116.9976", "91978": "32.7329_-116.9596", "91979": "32.7448_-116.9989", "91980": "32.5889_-116.6192", "91987": "32.5773_-116.6275", "92003": "33.294_-117.1897", "92004": "33.2386_-116.3514", "92007": "33.023_-117.2745", "92008": "33.1602_-117.325", "92009": "33.0954_-117.2619", "92010": "33.1639_-117.3009", "92011": "33.1072_-117.2943", "92013": "33.1581_-117.3506", "92014": "32.9665_-117.249", "92018": "33.1581_-117.3506", "92019": "32.7777_-116.9191", "92020": "32.7928_-116.9665", "92021": "32.8178_-116.9223", "92022": "32.7948_-116.9625", "92023": "33.036_-117.292", "92024": "33.0535_-117.2689", "92025": "33.1101_-117.07", "92026": "33.1605_-117.0978", "92027": "33.1388_-117.052", "92028": "33.369_-117.229", "92029": "33.0895_-117.1128", "92030": "33.1192_-117.0864", "92033": "33.1192_-117.0864", "92036": "33.0534_-116.5658", "92037": "32.8455_-117.2521", "92038": "32.8473_-117.2742", "92039": "32.8473_-117.2742", "92040": "32.8562_-116.9201", "92046": "33.1192_-117.0864", "92049": "33.1959_-117.3795", "92051": "33.1959_-117.3795", "92052": "33.1959_-117.3795", "92054": "33.2072_-117.3573", "92055": "33.2433_-117.3768", "92056": "33.1968_-117.2831", "92057": "33.2407_-117.3025", "92058": "33.1959_-117.3795", "92059": "33.3777_-117.0717", "92060": "33.3228_-116.8786", "92061": "33.3063_-116.9596", "92064": "32.9756_-117.0402", "92065": "33.0293_-116.8535", "92066": "33.21_-116.5167", "92067": "33.005_-117.2157", "92068": "33.232_-117.3236", "92069": "33.1444_-117.1697", "92070": "33.1476_-116.6963", "92071": "32.8486_-116.9862", "92072": "32.8384_-116.9739", "92074": "32.9628_-117.0359", "92075": "32.9937_-117.2598", "92078": "33.1193_-117.185", "92079": "33.1434_-117.1661", "92081": "33.1644_-117.2403", "92082": "33.249_-117.0122", "92083": "33.1978_-117.2482", "92084": "33.2131_-117.2243", "92085": "33.2_-117.2425", "92086": "33.3096_-116.6527", "92088": "33.3764_-117.2511", "92091": "32.9623_-117.0462", "92092": "32.8473_-117.2742", "92093": "32.8473_-117.2742", "92096": "33.1434_-117.1661", "92101": "32.7185_-117.1593", "92102": "32.7139_-117.1219", "92103": "32.7466_-117.1636", "92104": "32.7454_-117.1272", "92105": "32.7423_-117.0947", "92106": "32.7272_-117.2268", "92107": "32.7425_-117.2433", "92108": "32.7783_-117.1335", "92109": "32.7969_-117.2405", "92110": "32.7635_-117.2028", "92111": "32.7972_-117.1708", "92112": "32.7153_-117.1573", "92113": "32.697_-117.1153", "92114": "32.7059_-117.0524", "92115": "32.7607_-117.0721", "92116": "32.7624_-117.1242", "92117": "32.8239_-117.1965", "92118": "32.6807_-117.1698", "92119": "32.8036_-117.0261", "92120": "32.7958_-117.0707", "92121": "32.8919_-117.2035", "92122": "32.8577_-117.2115", "92123": "32.7973_-117.1392", "92124": "32.8201_-117.0986", "92126": "32.9161_-117.1402", "92127": "33.0279_-117.0856", "92128": "33.0067_-117.069", "92129": "32.9652_-117.1213", "92130": "32.9555_-117.2252", "92131": "32.9123_-117.0898", "92132": "32.6437_-117.1384", "92134": "32.7242_-117.1466", "92135": "32.7153_-117.1573", "92136": "32.6834_-117.1219", "92137": "32.8538_-117.1197", "92138": "32.7153_-117.1573", "92139": "32.6806_-117.0474", "92140": "32.7434_-117.2004", "92142": "32.7153_-117.1573", "92143": "33.2553_-116.5664", "92145": "32.8891_-117.1005", "92147": "32.7153_-117.1573", "92149": "32.7153_-117.1573", "92150": "32.7153_-117.1573", "92152": "32.7153_-117.1573", "92153": "32.7153_-117.1573", "92154": "32.5753_-117.0707", "92155": "32.6716_-117.1657", "92158": "32.7153_-117.1573", "92159": "32.7153_-117.1573", "92160": "32.7153_-117.1573", "92161": "32.8718_-117.2291", "92163": "32.7153_-117.1573", "92165": "32.7153_-117.1573", "92166": "32.7153_-117.1573", "92167": "32.7153_-117.1573", "92168": "32.7153_-117.1573", "92169": "32.7153_-117.1573", "92170": "32.7153_-117.1573", "92171": "32.7153_-117.1573", "92172": "32.7153_-117.1573", "92173": "32.5626_-117.043", "92174": "32.7153_-117.1573", "92175": "32.7153_-117.1573", "92176": "32.7153_-117.1573", "92177": "32.7153_-117.1573", "92178": "32.6859_-117.1831", "92179": "32.7153_-117.1573", "92182": "32.7751_-117.0762", "92186": "32.7153_-117.1573", "92187": "32.7153_-117.1573", "92190": "32.7153_-117.1573", "92191": "32.7153_-117.1573", "92192": "32.7153_-117.1573", "92193": "32.7153_-117.1573", "92195": "32.7153_-117.1573", "92196": "32.7153_-117.1573", "92197": "32.7153_-117.1573", "92198": "32.7153_-117.1573", "92199": "32.7516_-117.1918", "94102": "37.7813_-122.4167", "94103": "37.7725_-122.4147", "94104": "37.7915_-122.4018", "94105": "37.7864_-122.3892", "94107": "37.7621_-122.3971", "94108": "37.7929_-122.4079", "94109": "37.7917_-122.4186", "94110": "37.7509_-122.4153", "94111": "37.7974_-122.4001", "94112": "37.7195_-122.4411", "94114": "37.7587_-122.433", "94115": "37.7856_-122.4358", "94116": "37.7441_-122.4863", "94117": "37.7712_-122.4413", "94118": "37.7812_-122.4614", "94119": "37.7749_-122.4194", "94120": "37.7749_-122.4194", "94121": "37.7786_-122.4892", "94122": "37.7593_-122.4836", "94123": "37.7999_-122.4342", "94124": "37.7309_-122.3886", "94125": "37.7749_-122.4194", "94126": "37.7749_-122.4194", "94127": "37.7354_-122.4571", "94129": "37.8005_-122.465", "94130": "37.8231_-122.3693", "94131": "37.745_-122.4383", "94132": "37.7211_-122.4754", "94133": "37.8002_-122.4091", "94134": "37.719_-122.4096", "94137": "37.7749_-122.4194", "94139": "37.7749_-122.4194", "94140": "37.7749_-122.4194", "94141": "37.7749_-122.4194", "94142": "37.7749_-122.4194", "94143": "37.7631_-122.4586", "94144": "37.7749_-122.4194", "94145": "37.7749_-122.4194", "94146": "37.7749_-122.4194", "94147": "37.7749_-122.4194", "94151": "37.7749_-122.4194", "94158": "37.7694_-122.3867", "94159": "37.7749_-122.4194", "94160": "37.7749_-122.4194", "94161": "37.7749_-122.4194", "94163": "37.7749_-122.4194", "94164": "37.7749_-122.4194", "94172": "37.7749_-122.4194", "94177": "37.7749_-122.4194", "94188": "37.7749_-122.4194", "95201": "37.958_-121.2876", "95202": "37.9606_-121.2871", "95203": "37.9532_-121.3116", "95204": "37.9743_-121.3154", "95205": "37.9625_-121.2624", "95206": "37.9177_-121.3123", "95207": "38.0024_-121.3238", "95208": "37.9304_-121.436", "95209": "38.0377_-121.3445", "95210": "38.025_-121.2972", "95211": "37.9809_-121.311", "95212": "38.0315_-121.2589", "95213": "37.9054_-121.2222", "95214": "37.9053_-121.2262", "95215": "37.9551_-121.2041", "95219": "38.01_-121.3698", "95220": "38.2004_-121.2186", "95227": "38.1929_-121.0811", "95230": "37.9299_-121.0002", "95231": "37.878_-121.2827", "95234": "37.9344_-121.4261", "95236": "38.032_-121.0493", "95237": "38.1613_-121.1424", "95240": "38.1222_-121.2555", "95241": "38.1327_-121.2724", "95242": "38.1308_-121.3345", "95253": "38.138_-121.205", "95258": "38.1551_-121.3086", "95267": "38.0003_-121.3174", "95269": "38.0187_-121.3225", "95296": "37.9577_-121.2908", "95297": "38.0025_-121.324", "95304": "37.7319_-121.4096", "95320": "37.7983_-121.0006", "95330": "37.8209_-121.2827", "95336": "37.8134_-121.2132", "95337": "37.7808_-121.2344", "95366": "37.7491_-121.1284", "95376": "37.7383_-121.4345", "95377": "37.6567_-121.4955", "95378": "37.6761_-121.433", "95385": "37.6176_-121.2581", "95391": "37.7695_-121.5397", "95686": "38.2261_-121.4236", "93401": "35.2635_-120.6509", "93402": "35.3172_-120.8333", "93403": "35.2828_-120.6596", "93405": "35.2901_-120.6817", "93406": "35.2828_-120.6596", "93407": "35.2828_-120.6596", "93408": "35.2828_-120.6596", "93409": "35.2211_-120.6364", "93410": "35.3471_-120.4553", "93412": "35.3111_-120.8324", "93420": "35.1661_-120.4651", "93421": "35.1186_-120.5907", "93422": "35.4754_-120.6638", "93423": "35.4282_-120.7695", "93424": "35.18_-120.7318", "93428": "35.5566_-121.084", "93430": "35.4446_-120.8908", "93432": "35.4779_-120.4361", "93433": "35.121_-120.6173", "93435": "35.4919_-120.9763", "93442": "35.3795_-120.8447", "93443": "35.3658_-120.8499", "93444": "35.0298_-120.4894", "93445": "35.1019_-120.608", "93446": "35.6406_-120.7003", "93447": "35.7562_-120.6935", "93448": "35.1428_-120.6413", "93449": "35.1578_-120.6522", "93451": "35.9004_-120.5929", "93452": "35.6668_-121.144", "93453": "35.3584_-120.2596", "93461": "35.6513_-120.372", "93465": "35.5551_-120.7107", "93475": "35.1004_-120.6111", "93483": "35.1216_-120.6213", "94002": "37.5174_-122.2927", "94005": "37.6811_-122.4001", "94010": "37.5671_-122.3676", "94011": "37.5841_-122.3661", "94014": "37.6875_-122.4388", "94015": "37.6787_-122.478", "94016": "37.7058_-122.4619", "94017": "37.7058_-122.4619", "94018": "37.5101_-122.4734", "94019": "37.4791_-122.4459", "94020": "37.2726_-122.2495", "94021": "37.2708_-122.2807", "94025": "37.4396_-122.1864", "94026": "37.3811_-122.3348", "94027": "37.4563_-122.2002", "94028": "37.3702_-122.2182", "94030": "37.6004_-122.402", "94037": "37.5428_-122.5052", "94038": "37.531_-122.5068", "94044": "37.6196_-122.4816", "94060": "37.2065_-122.3649", "94061": "37.4647_-122.2304", "94062": "37.4245_-122.296", "94063": "37.4815_-122.2091", "94064": "37.3811_-122.3348", "94065": "37.5331_-122.2486", "94066": "37.6247_-122.429", "94070": "37.4969_-122.2674", "94074": "37.3255_-122.3556", "94080": "37.6574_-122.4235", "94083": "37.6547_-122.4077", "94128": "37.6216_-122.3929", "94303": "37.4673_-122.1388", "94401": "37.5735_-122.3225", "94402": "37.5507_-122.3276", "94403": "37.5395_-122.2998", "94404": "37.5538_-122.27", "94497": "37.5347_-122.3259", "93013": "34.4036_-119.5183", "93014": "34.3989_-119.5185", "93067": "34.4214_-119.5965", "93101": "34.4197_-119.7078", "93102": "34.4208_-119.6982", "93103": "34.4291_-119.6833", "93105": "34.4369_-119.7285", "93106": "34.4329_-119.8371", "93107": "34.4218_-119.8637", "93108": "34.4378_-119.6159", "93109": "34.4038_-119.7194", "93110": "34.4418_-119.7647", "93111": "34.4453_-119.8025", "93116": "34.4358_-119.8276", "93117": "34.4296_-119.8612", "93118": "34.4358_-119.8276", "93120": "34.4208_-119.6982", "93121": "34.4208_-119.6982", "93130": "34.4208_-119.6982", "93140": "34.4208_-119.6982", "93150": "34.4208_-119.6982", "93160": "34.4208_-119.6982", "93190": "34.4208_-119.6982", "93199": "34.2628_-119.8486", "93254": "34.9967_-119.8238", "93427": "34.6209_-120.1922", "93429": "34.8458_-120.535", "93434": "34.96_-120.5703", "93436": "34.6583_-120.4506", "93437": "34.7532_-120.5171", "93438": "34.6392_-120.4579", "93440": "34.7457_-120.2049", "93441": "34.6678_-120.1149", "93454": "34.9545_-120.4325", "93455": "34.8286_-120.4268", "93456": "34.953_-120.4357", "93457": "34.953_-120.4357", "93458": "34.9535_-120.4957", "93460": "34.624_-120.0713", "93463": "34.6488_-120.1701", "93464": "34.6744_-120.1115", "94022": "37.3814_-122.1258", "94023": "37.3852_-122.1141", "94024": "37.3547_-122.0862", "94035": "37.3861_-122.0839", "94039": "37.3861_-122.0839", "94040": "37.3855_-122.088", "94041": "37.3893_-122.0783", "94042": "37.3861_-122.0839", "94043": "37.4056_-122.0775", "94085": "37.3886_-122.0177", "94086": "37.3764_-122.0238", "94087": "37.3502_-122.0349", "94088": "37.3688_-122.0363", "94089": "37.3983_-122.0006", "94301": "37.4443_-122.1497", "94302": "37.4419_-122.143", "94304": "37.4334_-122.1842", "94305": "37.4236_-122.1619", "94306": "37.418_-122.1274", "94309": "37.4419_-122.143", "95002": "37.426_-121.9736", "95008": "37.2803_-121.9539", "95009": "37.2872_-121.9488", "95011": "37.294_-121.9571", "95013": "37.2123_-121.7416", "95014": "37.318_-122.0449", "95015": "37.323_-122.0527", "95020": "37.0139_-121.5773", "95021": "37.0095_-121.5705", "95026": "37.1584_-121.986", "95030": "37.2296_-121.9834", "95031": "37.1574_-121.9676", "95032": "37.2417_-121.9554", "95033": "37.1539_-121.9816", "95035": "37.4352_-121.895", "95036": "37.424_-121.906", "95037": "37.1353_-121.6501", "95038": "37.1525_-121.6722", "95042": "37.1771_-121.8207", "95044": "37.1584_-121.986", "95046": "37.0911_-121.5999", "95050": "37.3492_-121.953", "95051": "37.3483_-121.9844", "95052": "37.3522_-121.9583", "95053": "37.3498_-121.9378", "95054": "37.3924_-121.9623", "95055": "37.3451_-121.9769", "95056": "37.3997_-121.9608", "95070": "37.2713_-122.0227", "95071": "37.2593_-122.0302", "95101": "37.3894_-121.8868", "95103": "37.3378_-121.8908", "95106": "37.3378_-121.8908", "95108": "37.3378_-121.8908", "95109": "37.3378_-121.8908", "95110": "37.3391_-121.9016", "95111": "37.2827_-121.8265", "95112": "37.3476_-121.887", "95113": "37.3329_-121.8916", "95115": "37.3378_-121.8908", "95116": "37.3518_-121.8508", "95117": "37.3108_-121.9623", "95118": "37.2568_-121.8896", "95119": "37.2329_-121.7875", "95120": "37.2144_-121.8574", "95121": "37.3042_-121.8099", "95122": "37.3293_-121.8339", "95123": "37.2458_-121.8306", "95124": "37.2563_-121.9229", "95125": "37.296_-121.8939", "95126": "37.3249_-121.9153", "95127": "37.3692_-121.8208", "95128": "37.3163_-121.9356", "95129": "37.3066_-122.0002", "95130": "37.2886_-121.9818", "95131": "37.3864_-121.88", "95132": "37.4031_-121.8585", "95133": "37.3729_-121.856", "95134": "37.4087_-121.9406", "95135": "37.2974_-121.7562", "95136": "37.2685_-121.849", "95138": "37.2602_-121.7709", "95139": "37.2252_-121.7687", "95140": "37.3511_-121.6384", "95141": "37.3394_-121.895", "95148": "37.3304_-121.7913", "95150": "37.3866_-121.897", "95151": "37.3198_-121.8262", "95152": "37.4022_-121.847", "95153": "37.2488_-121.8459", "95154": "37.2649_-121.9139", "95155": "37.31_-121.9011", "95156": "37.3576_-121.8416", "95157": "37.3008_-121.9777", "95158": "37.2625_-121.8779", "95159": "37.3179_-121.9349", "95160": "37.2187_-121.8601", "95161": "37.3894_-121.8868", "95164": "37.3916_-121.9203", "95170": "37.3103_-122.0093", "95172": "37.334_-121.8847", "95173": "37.3352_-121.8938", "95190": "37.3894_-121.8868", "95191": "37.3262_-121.9158", "95192": "37.3383_-121.8801", "95193": "37.2441_-121.8287", "95194": "37.3894_-121.8868", "95196": "37.3338_-121.8894", "95001": "36.979_-121.898", "95003": "36.9797_-121.8902", "95005": "37.0882_-122.0887", "95006": "37.1547_-122.1365", "95007": "37.1063_-122.105", "95010": "36.9767_-121.9555", "95017": "37.0423_-122.2137", "95018": "37.0662_-122.0618", "95019": "36.9356_-121.7767", "95041": "37.0511_-122.0575", "95060": "37.0313_-122.1198", "95061": "36.9741_-122.0308", "95062": "36.9721_-121.9881", "95063": "36.9792_-122.0088", "95064": "36.9959_-122.0578", "95065": "37.0089_-121.9849", "95066": "37.0597_-122.0152", "95067": "37.0511_-122.0136", "95073": "37.0048_-121.9507", "95076": "36.9102_-121.7569", "95077": "36.9116_-121.7575", "96001": "40.5605_-122.4116", "96002": "40.5486_-122.3339", "96003": "40.6278_-122.353", "96007": "40.4574_-122.3282", "96008": "40.7409_-122.0725", "96011": "40.9749_-121.825", "96013": "40.8949_-121.655", "96016": "40.9337_-121.5677", "96017": "41.1103_-122.3161", "96019": "40.6969_-122.3683", "96022": "40.3691_-122.3375", "96028": "41.0393_-121.4606", "96033": "40.7035_-122.6229", "96040": "40.7677_-121.4637", "96047": "40.4318_-122.654", "96049": "40.7098_-122.3116", "96051": "40.9105_-122.4106", "96056": "41.0502_-121.3991", "96062": "40.5653_-122.1111", "96065": "40.9124_-121.9233", "96069": "40.6863_-122.0409", "96070": "40.7352_-122.1944", "96071": "40.6256_-121.4585", "96073": "40.5767_-122.2398", "96076": "40.376_-122.937", "96079": "40.6866_-122.3348", "96084": "40.794_-121.9419", "96087": "40.6109_-122.4968", "96088": "40.505_-121.8857", "96089": "40.6579_-122.4273", "96095": "40.6388_-122.5597", "96096": "40.6525_-121.8771", "96099": "40.7043_-122.3878", "95910": "39.4826_-120.8483", "95936": "39.569_-120.8344", "95944": "39.5399_-120.8844", "96118": "39.663_-120.2297", "96124": "39.6139_-120.4046", "96125": "39.5936_-120.6269", "96126": "39.5825_-120.3711", "95568": "41.4533_-123.4634", "96014": "41.3833_-122.764", "96023": "41.9194_-121.9739", "96025": "41.2124_-122.2734", "96027": "41.4463_-123.01", "96031": "41.2191_-123.2363", "96032": "41.617_-122.8832", "96034": "41.5105_-122.5371", "96037": "41.5403_-122.9366", "96038": "41.6125_-122.5258", "96039": "41.8018_-123.388", "96044": "41.9077_-122.5265", "96050": "41.8637_-122.8197", "96057": "41.2475_-122.1128", "96058": "41.883_-121.9445", "96064": "41.7243_-122.4638", "96067": "41.3174_-122.324", "96085": "41.7736_-122.9882", "96086": "41.8866_-123.2438", "96094": "41.4226_-122.3861", "96097": "41.7206_-122.6376", "96134": "41.9316_-121.4347", "94510": "38.0685_-122.1614", "94512": "38.1504_-121.8443", "94533": "38.2671_-122.0357", "94534": "38.2423_-122.1314", "94535": "38.2743_-121.9463", "94571": "38.1637_-121.7016", "94585": "38.2408_-122.042", "94589": "38.1582_-122.2804", "94590": "38.1053_-122.2474", "94591": "38.0985_-122.2124", "94592": "38.0968_-122.2699", "95620": "38.4403_-121.8088", "95625": "38.3482_-121.91", "95687": "38.3482_-121.9538", "95688": "38.3847_-121.9887", "95696": "38.43_-122.0168", "94922": "38.3514_-122.9741", "94923": "38.3309_-123.0373", "94926": "38.3396_-122.7011", "94927": "38.3396_-122.7011", "94928": "38.347_-122.6941", "94931": "38.3259_-122.7048", "94951": "38.3153_-122.6483", "94952": "38.2403_-122.6777", "94953": "38.2324_-122.6367", "94954": "38.2507_-122.6155", "94955": "38.2324_-122.6367", "94972": "38.318_-122.9242", "94975": "38.2324_-122.6367", "94999": "38.2675_-122.6581", "95401": "38.4432_-122.7547", "95402": "38.4399_-122.7096", "95403": "38.4822_-122.7473", "95404": "38.4405_-122.7144", "95405": "38.4386_-122.6727", "95406": "38.4399_-122.7096", "95407": "38.4089_-122.7339", "95409": "38.4592_-122.6393", "95412": "38.7026_-123.3539", "95416": "38.3141_-122.4843", "95419": "38.425_-122.9485", "95421": "38.5918_-123.1965", "95425": "38.7931_-123.0074", "95430": "38.4538_-123.055", "95431": "38.3488_-122.5108", "95433": "38.2993_-122.4867", "95436": "38.4923_-122.9042", "95439": "38.4947_-122.7761", "95441": "38.7173_-122.8834", "95442": "38.3662_-122.5196", "95444": "38.4335_-122.8676", "95446": "38.5055_-122.9965", "95448": "38.6184_-122.862", "95450": "38.4987_-123.1974", "95452": "38.4168_-122.5547", "95462": "38.4706_-123.0172", "95465": "38.4087_-122.9954", "95471": "38.521_-122.9769", "95472": "38.3941_-122.8433", "95473": "38.4022_-122.8227", "95476": "38.2849_-122.4696", "95480": "38.7082_-123.3478", "95486": "38.4741_-123.0242", "95487": "38.2725_-122.4375", "95492": "38.5443_-122.8073", "95497": "38.7256_-123.4675", "95307": "37.5833_-120.9496", "95313": "37.4218_-121.0411", "95316": "37.539_-120.7758", "95319": "37.6382_-120.9005", "95323": "37.6156_-120.7011", "95326": "37.5964_-120.8627", "95328": "37.5591_-120.9148", "95329": "37.6899_-120.3851", "95350": "37.6746_-121.0113", "95351": "37.6236_-120.9966", "95352": "37.6566_-121.0191", "95353": "37.6424_-120.9999", "95354": "37.6409_-120.9749", "95355": "37.6717_-120.9482", "95356": "37.7005_-121.0252", "95357": "37.6693_-120.8817", "95358": "37.6237_-121.0438", "95360": "37.3097_-121.0805", "95361": "37.7741_-120.8377", "95363": "37.4826_-121.1648", "95367": "37.7298_-120.942", "95368": "37.7083_-121.0864", "95380": "37.4888_-120.8535", "95381": "37.4994_-120.8428", "95382": "37.5239_-120.8517", "95386": "37.652_-120.7292", "95387": "37.5452_-121.2255", "95397": "37.6566_-121.0191", "95659": "38.8657_-121.557", "95668": "38.8115_-121.4982", "95674": "38.967_-121.4773", "95676": "38.8702_-121.7052", "95953": "39.2601_-121.6923", "95957": "39.052_-121.8061", "95982": "39.1779_-121.7758", "95991": "39.1051_-121.6202", "95992": "39.023_-121.6116", "95993": "39.1237_-121.6611", "96021": "39.9296_-122.196", "96029": "39.9024_-122.4918", "96035": "40.043_-122.1649", "96055": "40.0497_-122.0992", "96059": "40.4331_-121.8365", "96061": "40.3263_-121.5228", "96063": "40.3564_-121.571", "96074": "39.8772_-122.5814", "96075": "40.3514_-121.765", "96078": "40.0815_-122.1705", "96080": "40.1795_-122.2383", "96090": "40.0271_-122.1233", "96092": "39.9272_-122.025", "95527": "40.7897_-123.4113", "95552": "40.3316_-123.3904", "95563": "40.8558_-123.573", "95595": "40.2147_-123.3911", "96010": "40.748_-123.229", "96024": "40.6342_-122.9239", "96041": "40.5504_-123.1634", "96046": "40.6137_-123.4488", "96048": "40.7411_-123.0718", "96052": "40.746_-122.8426", "96091": "41.0615_-122.7239", "96093": "40.7317_-122.9353", "93201": "35.8877_-119.4873", "93207": "35.8818_-118.6561", "93208": "36.1427_-118.6093", "93218": "35.8916_-119.0473", "93219": "35.8744_-119.281", "93221": "36.3041_-119.1293", "93223": "36.3002_-119.2054", "93227": "36.3572_-119.4254", "93235": "36.3856_-119.2189", "93237": "36.4727_-118.9029", "93244": "36.4969_-118.9941", "93247": "36.2096_-119.0884", "93256": "35.9553_-119.2564", "93257": "36.0686_-119.0315", "93258": "36.0331_-119.0073", "93260": "35.8135_-118.6643", "93261": "35.805_-119.1315", "93262": "36.6007_-118.711", "93265": "36.1363_-118.7961", "93267": "36.1472_-119.0792", "93270": "35.957_-119.0312", "93271": "36.4377_-118.8875", "93272": "36.0546_-119.3078", "93274": "36.2022_-119.338", "93275": "36.2077_-119.3473", "93277": "36.3114_-119.3065", "93278": "36.3302_-119.2921", "93279": "36.3302_-119.2921", "93282": "36.1296_-119.5161", "93286": "36.4313_-119.0918", "93290": "36.3291_-119.2925", "93291": "36.3551_-119.301", "93292": "36.3302_-119.2921", "93603": "36.6313_-119.0132", "93615": "36.5243_-119.287", "93618": "36.5349_-119.3909", "93619": "36.8432_-119.6518", "93633": "36.7341_-118.9588", "93647": "36.5464_-119.2815", "93666": "36.5455_-119.3401", "93670": "36.4718_-119.2594", "93673": "36.4552_-119.4848", "95305": "37.8235_-120.2582", "95309": "37.8594_-120.4069", "95310": "38.044_-120.3971", "95321": "37.8298_-120.1037", "95327": "37.8906_-120.4717", "95335": "38.093_-120.1344", "95346": "38.0675_-120.1794", "95347": "37.8108_-120.2988", "95364": "38.1889_-119.9924", "95370": "37.9957_-120.3368", "95372": "37.9926_-120.2624", "95373": "37.9666_-120.3108", "95375": "38.2042_-120.0101", "95379": "37.9678_-120.2357", "95383": "38.0454_-120.2178", "91319": "34.1842_-118.9107", "91320": "34.1774_-118.9358", "91358": "34.1706_-118.8376", "91359": "34.1458_-118.8056", "91360": "34.2092_-118.8739", "91361": "34.1472_-118.8383", "91362": "34.1948_-118.8232", "91377": "34.185_-118.7669", "93001": "34.3308_-119.3584", "93002": "34.2783_-119.2932", "93003": "34.2846_-119.2222", "93004": "34.2788_-119.1651", "93005": "34.2783_-119.2932", "93006": "34.2783_-119.2932", "93007": "34.2783_-119.2932", "93009": "34.3562_-119.1462", "93010": "34.2313_-119.0464", "93011": "34.2164_-119.0376", "93012": "34.2218_-118.9866", "93015": "34.3992_-118.9182", "93016": "34.3992_-118.9182", "93020": "34.2856_-118.882", "93021": "34.2784_-118.8771", "93022": "34.402_-119.2982", "93023": "34.4451_-119.2565", "93024": "34.448_-119.2429", "93030": "34.2141_-119.175", "93031": "34.0324_-119.1343", "93032": "34.1975_-119.1771", "93033": "34.1685_-119.1717", "93034": "34.0324_-119.1343", "93035": "34.1822_-119.216", "93036": "34.2351_-119.182", "93040": "34.4352_-118.7855", "93041": "34.1626_-119.1973", "93042": "34.1134_-119.1124", "93043": "34.1621_-119.2074", "93044": "34.1478_-119.1951", "93060": "34.3547_-119.0713", "93061": "34.3542_-119.0593", "93062": "34.2694_-118.7815", "93063": "34.3046_-118.6844", "93064": "34.2582_-118.7107", "93065": "34.2656_-118.7653", "93066": "34.2798_-119.0115", "93094": "34.2694_-118.7815", "93099": "34.2694_-118.7815", "95605": "38.5927_-121.5325", "95606": "38.8065_-122.2039", "95607": "38.7209_-122.0912", "95612": "38.3945_-121.5641", "95616": "38.5538_-121.7418", "95617": "38.5494_-121.7253", "95618": "38.5449_-121.7405", "95627": "38.7061_-122.0152", "95637": "38.8407_-122.2036", "95645": "38.8517_-121.7334", "95653": "38.6802_-121.9721", "95679": "38.8953_-122.3079", "95691": "38.5673_-121.5516", "95694": "38.5322_-121.9676", "95695": "38.6816_-121.8052", "95697": "38.7343_-121.8066", "95698": "38.8204_-121.9191", "95776": "38.6808_-121.7411", "95798": "38.5805_-121.5291", "95799": "38.5713_-121.5715", "95937": "38.887_-121.9992", "95692": "39.0337_-121.4235", "95901": "39.1663_-121.5105", "95903": "39.1115_-121.3604", "95918": "39.2882_-121.3303", "95919": "39.4525_-121.2612", "95922": "39.4518_-121.0486", "95925": "39.4685_-121.1936", "95935": "39.3662_-121.2256", "95961": "39.0861_-121.5497", "95962": "39.3459_-121.2663", "95972": "39.4256_-121.3252", "95981": "39.687_-121.045", "80011": "39.7378_-104.8152", "80019": "39.7656_-104.7069", "80022": "39.8259_-104.9113", "80024": "39.8445_-104.9188", "80030": "39.8302_-105.037", "80031": "39.8753_-105.0345", "80035": "39.8367_-105.0372", "80036": "39.8367_-105.0372", "80037": "39.8083_-104.9339", "80040": "39.7294_-104.8319", "80042": "39.7294_-104.8319", "80045": "39.7467_-104.8384", "80102": "39.7589_-104.4275", "80136": "39.7814_-104.2683", "80137": "39.7623_-104.5834", "80221": "39.838_-104.9988", "80229": "39.8671_-104.9227", "80233": "39.9015_-104.9407", "80234": "39.9108_-105.0109", "80241": "39.868_-104.9719", "80260": "39.8672_-105.0041", "80601": "39.943_-104.7866", "80602": "39.9636_-104.9072", "80603": "39.9515_-104.7746", "80614": "39.9239_-104.9614", "80640": "39.8983_-104.8718", "81101": "37.4703_-105.8786", "81102": "37.476_-105.8818", "81136": "37.7232_-105.8712", "81146": "37.6358_-105.8069", "80010": "39.7368_-104.8646", "80012": "39.6987_-104.8377", "80013": "39.6575_-104.7846", "80014": "39.6662_-104.835", "80015": "39.6255_-104.7874", "80016": "39.6012_-104.7394", "80017": "39.6948_-104.7881", "80018": "39.7102_-104.7071", "80041": "39.7388_-104.4083", "80044": "39.7388_-104.4083", "80046": "39.7388_-104.4083", "80047": "39.7388_-104.4083", "80103": "39.6985_-104.2019", "80105": "39.5931_-104.068", "80110": "39.6463_-105.0092", "80111": "39.6123_-104.8799", "80112": "39.5805_-104.9011", "80113": "39.6405_-104.9614", "80120": "39.5994_-105.0044", "80121": "39.6111_-104.9532", "80122": "39.5814_-104.9557", "80150": "39.6478_-104.9878", "80151": "39.6478_-104.9878", "80155": "39.6478_-104.9878", "80160": "39.6133_-105.0166", "80161": "39.6133_-105.0166", "80165": "39.6133_-105.0166", "80166": "39.6133_-105.0166", "81121": "37.0281_-107.4192", "81128": "37.0364_-106.8434", "81147": "37.2523_-107.0385", "81157": "37.2694_-107.0098", "81029": "37.1195_-102.5464", "81064": "37.2723_-102.9145", "81073": "37.4067_-102.6173", "81084": "37.5214_-102.4332", "81087": "37.373_-102.4437", "81090": "37.3521_-102.2537", "81038": "37.9555_-103.0725", "81044": "37.959_-103.015", "81054": "37.923_-103.0884", "81057": "38.085_-102.8869", "80020": "39.9245_-105.0609", "80025": "39.9324_-105.288", "80026": "39.998_-105.0963", "80027": "39.9789_-105.1456", "80038": "39.9205_-105.0867", "80301": "40.0497_-105.2143", "80302": "40.0172_-105.2851", "80303": "39.9914_-105.2392", "80304": "40.0375_-105.2771", "80305": "39.9807_-105.2531", "80306": "40.1022_-105.3847", "80307": "40.0878_-105.3735", "80308": "40.0277_-105.3868", "80309": "40.015_-105.2705", "80310": "40.015_-105.2705", "80314": "40.0878_-105.3735", "80455": "40.1155_-105.3886", "80466": "39.9703_-105.4813", "80471": "39.9319_-105.4283", "80481": "40.0726_-105.508", "80501": "40.1779_-105.1009", "80502": "40.1672_-105.1019", "80503": "40.1559_-105.1624", "80510": "40.2268_-105.5201", "80533": "40.1815_-105.2327", "80540": "40.2357_-105.3231", "80544": "40.1039_-105.1708", "80023": "39.9619_-105.0148", "81201": "38.5259_-105.9978", "81211": "38.838_-106.1471", "81227": "38.553_-106.2946", "81228": "39.0307_-106.2566", "81236": "38.7103_-106.1166", "81242": "38.5128_-106.0772", "80802": "38.8417_-102.194", "80810": "38.8198_-102.3582", "80825": "38.804_-102.8198", "80862": "38.8041_-103.0798", "80436": "39.7647_-105.6003", "80438": "39.7614_-105.6844", "80444": "39.7061_-105.6975", "80452": "39.7402_-105.5983", "80476": "39.6996_-105.7507", "81120": "37.0855_-106.0379", "81124": "37.2839_-106.1114", "81129": "37.1011_-106.0265", "81140": "37.2907_-106.0054", "81141": "37.1755_-105.9278", "81148": "37.1721_-105.9858", "81151": "37.2583_-105.9047", "81123": "37.4317_-105.5178", "81126": "37.162_-105.3783", "81133": "37.427_-105.4049", "81138": "37.0028_-105.6242", "81152": "37.1066_-105.4781", "81033": "38.1931_-103.8561", "81034": "38.1931_-103.8561", "81062": "38.2019_-103.941", "81063": "38.2095_-103.8003", "81076": "38.2444_-103.6556", "81252": "38.123_-105.4332", "81253": "38.1217_-105.1477", "81410": "38.7975_-107.9738", "81413": "38.9119_-107.9268", "81414": "38.7887_-107.9862", "81415": "38.6941_-107.6149", "81416": "38.7349_-108.0604", "81418": "38.845_-107.9625", "81419": "38.8124_-107.7472", "81420": "38.7817_-107.7808", "81428": "38.865_-107.5985", "80201": "39.7263_-104.8568", "80202": "39.7491_-104.9946", "80203": "39.7313_-104.9811", "80204": "39.734_-105.0259", "80205": "39.759_-104.9661", "80206": "39.7331_-104.9524", "80207": "39.7584_-104.9177", "80208": "39.7392_-104.9847", "80209": "39.7074_-104.9686", "80210": "39.679_-104.9631", "80211": "39.7665_-105.0204", "80212": "39.7683_-105.0493", "80216": "39.7835_-104.9669", "80217": "39.7392_-104.9847", "80218": "39.7327_-104.9717", "80219": "39.6956_-105.0341", "80220": "39.7312_-104.9129", "80222": "39.671_-104.9279", "80223": "39.7002_-105.0028", "80224": "39.688_-104.9108", "80227": "39.6667_-105.0854", "80230": "39.7218_-104.8951", "80231": "39.6793_-104.8843", "80235": "39.6472_-105.0795", "80236": "39.6535_-105.0376", "80237": "39.6431_-104.8987", "80238": "39.7392_-104.9847", "80239": "39.7878_-104.8288", "80243": "39.7392_-104.9847", "80244": "39.7392_-104.9847", "80246": "39.7086_-104.9312", "80247": "39.6971_-104.8819", "80248": "39.7392_-104.9847", "80249": "39.7783_-104.7557", "80250": "39.7392_-104.9847", "80251": "39.7392_-104.9847", "80252": "39.7392_-104.9847", "80256": "39.7474_-104.9928", "80257": "39.7392_-104.9847", "80259": "39.7462_-104.9913", "80261": "39.7379_-104.985", "80262": "39.731_-104.9384", "80263": "39.7392_-104.9847", "80264": "39.7426_-104.9863", "80265": "39.7392_-104.9847", "80266": "39.7472_-104.9915", "80271": "39.7392_-104.9847", "80273": "39.7273_-104.9875", "80274": "39.7439_-104.9876", "80281": "39.7439_-104.9876", "80290": "39.7436_-104.9876", "80291": "39.7439_-104.9876", "80293": "39.7458_-104.9907", "80294": "39.7491_-104.989", "80299": "39.7392_-104.9847", "81320": "37.7182_-108.7917", "81324": "37.7632_-108.9181", "81332": "37.6905_-108.0324", "80104": "39.3722_-104.8561", "80108": "39.4455_-104.853", "80109": "39.3643_-104.9014", "80116": "39.3728_-104.7256", "80118": "39.2011_-104.8546", "80124": "39.5517_-104.8863", "80125": "39.4845_-105.0561", "80126": "39.5437_-104.9691", "80129": "39.5397_-105.0109", "80130": "39.5414_-104.9218", "80131": "39.4764_-105.0075", "80134": "39.4895_-104.8447", "80135": "39.3113_-105.0676", "80138": "39.5102_-104.7216", "80163": "39.3479_-104.9947", "80423": "39.8691_-106.6763", "80426": "39.8739_-106.8856", "80463": "39.9134_-106.7309", "81620": "39.6313_-106.5108", "81621": "39.3535_-106.9988", "81631": "39.6341_-106.7588", "81632": "39.6382_-106.6206", "81637": "39.6618_-106.9671", "81645": "39.5805_-106.4176", "81649": "39.5122_-106.3681", "81655": "39.7028_-106.6786", "81657": "39.6512_-106.3234", "81658": "39.6242_-106.4973", "80101": "39.4203_-103.9846", "80106": "39.0969_-104.5746", "80107": "39.3836_-104.592", "80117": "39.324_-104.4523", "80830": "39.132_-103.9132", "80835": "39.2087_-104.0702", "80132": "39.1007_-104.8542", "80133": "39.1205_-104.9148", "80808": "38.9648_-104.3553", "80809": "38.8967_-104.9722", "80817": "38.6996_-104.7005", "80819": "38.9389_-105.0094", "80829": "38.855_-104.9058", "80831": "38.9541_-104.5472", "80832": "39.0736_-104.1247", "80833": "38.7642_-104.0241", "80840": "39.0896_-103.8188", "80841": "39.0896_-103.8188", "80864": "38.7753_-104.2184", "80901": "38.8339_-104.8214", "80902": "38.7536_-104.8063", "80903": "38.8388_-104.8145", "80904": "38.8533_-104.8595", "80905": "38.8377_-104.837", "80906": "38.7902_-104.8199", "80907": "38.876_-104.817", "80908": "39.0237_-104.6933", "80909": "38.852_-104.7735", "80910": "38.8152_-104.7703", "80911": "38.7457_-104.7223", "80912": "38.8339_-104.8214", "80913": "38.73_-104.7536", "80914": "38.8192_-104.7012", "80915": "38.8558_-104.7134", "80916": "38.8076_-104.7403", "80917": "38.886_-104.7399", "80918": "38.9129_-104.7734", "80919": "38.9268_-104.8464", "80920": "38.9497_-104.767", "80921": "39.0487_-104.814", "80922": "38.905_-104.6982", "80923": "38.9189_-104.7045", "80924": "38.9676_-104.7211", "80925": "38.7378_-104.6459", "80926": "38.6981_-104.8505", "80927": "38.9286_-104.6583", "80928": "38.6233_-104.457", "80929": "38.7968_-104.6079", "80930": "38.8289_-104.5269", "80931": "38.8339_-104.8214", "80932": "38.8339_-104.8214", "80933": "38.8339_-104.8214", "80934": "38.8339_-104.8214", "80935": "38.8339_-104.8214", "80936": "38.8339_-104.8214", "80937": "38.8339_-104.8214", "80938": "38.9047_-104.6634", "80939": "38.8776_-104.6774", "80941": "38.8339_-104.8214", "80942": "38.8339_-104.8214", "80944": "38.8339_-104.8214", "80946": "38.8339_-104.8214", "80947": "38.8339_-104.8214", "80949": "38.8339_-104.8214", "80950": "38.8339_-104.8214", "80951": "38.8881_-104.6556", "80960": "38.8339_-104.8214", "80962": "38.8339_-104.8214", "80970": "38.8339_-104.8214", "80977": "38.8339_-104.8214", "80995": "38.8339_-104.8214", "80997": "38.8339_-104.8214", "81212": "38.4451_-105.2178", "81215": "38.4776_-105.4766", "81221": "38.3611_-105.1483", "81222": "38.3824_-105.7843", "81223": "38.3703_-105.6881", "81226": "38.385_-105.1232", "81232": "38.2653_-105.6117", "81233": "38.41_-105.7698", "81240": "38.4336_-105.0113", "81244": "38.3697_-105.1639", "81290": "38.3903_-105.1186", "81601": "39.5296_-107.3252", "81602": "39.5505_-107.3248", "81623": "39.2511_-107.2044", "81635": "39.4519_-108.0529", "81636": "39.4305_-108.0239", "81647": "39.5709_-107.5428", "81650": "39.5491_-107.7898", "81652": "39.5028_-107.6657", "80422": "39.816_-105.4753", "80427": "39.8019_-105.5142", "80474": "39.9172_-105.5011", "80442": "39.945_-105.8172", "80446": "40.0739_-105.9285", "80447": "40.2289_-105.8605", "80451": "40.0712_-106.0693", "80459": "40.0632_-106.3955", "80468": "39.9539_-106.093", "80478": "39.9797_-105.8615", "80482": "39.8939_-105.7845", "81210": "38.82_-106.6603", "81224": "38.8691_-106.9619", "81225": "38.9006_-106.9631", "81230": "38.5511_-106.931", "81231": "38.5458_-106.9253", "81237": "38.5908_-106.6028", "81239": "38.5371_-106.6352", "81241": "38.6179_-106.5146", "81243": "38.2822_-107.1084", "81434": "38.9468_-107.3781", "81235": "37.9868_-107.302", "81040": "37.7878_-105.1849", "81055": "37.5117_-105.0575", "81089": "37.6465_-104.7798", "80430": "40.5383_-106.5321", "80434": "40.8597_-106.3131", "80473": "40.4667_-106.1857", "80480": "40.71_-106.2767", "80001": "39.8028_-105.0875", "80002": "39.7945_-105.0984", "80003": "39.8286_-105.0655", "80004": "39.8141_-105.1177", "80005": "39.8422_-105.1097", "80006": "39.8028_-105.0875", "80007": "39.8634_-105.1724", "80021": "39.8854_-105.1139", "80033": "39.774_-105.0962", "80034": "39.7661_-105.0772", "80123": "39.6206_-105.0901", "80127": "39.592_-105.1328", "80128": "39.5918_-105.0832", "80162": "39.522_-105.2239", "80214": "39.7436_-105.0643", "80215": "39.7435_-105.1009", "80225": "39.6971_-105.1204", "80226": "39.7123_-105.0918", "80228": "39.6888_-105.156", "80232": "39.6895_-105.0908", "80401": "39.7305_-105.1915", "80402": "39.7555_-105.2211", "80403": "39.8232_-105.2825", "80419": "39.522_-105.2239", "80425": "39.3867_-105.2703", "80433": "39.5197_-105.3169", "80437": "39.522_-105.2239", "80439": "39.6374_-105.3402", "80453": "39.6684_-105.2442", "80454": "39.6296_-105.2514", "80457": "39.6481_-105.2782", "80465": "39.6125_-105.1746", "80470": "39.4667_-105.3741", "81021": "38.4068_-103.3697", "81036": "38.4408_-102.5549", "81045": "38.4474_-103.1505", "81071": "38.4667_-102.2921", "80805": "39.3448_-102.4281", "80807": "39.3106_-102.2583", "80815": "39.3127_-103.0624", "80834": "39.3183_-102.8822", "80836": "39.3087_-102.5979", "80861": "39.3236_-102.7393", "80429": "39.2258_-106.3117", "80461": "39.2497_-106.3015", "81251": "39.1011_-106.4416", "81122": "37.2603_-107.6137", "81137": "37.1264_-107.6395", "81301": "37.2874_-107.8617", "81302": "37.2753_-107.8801", "81303": "37.1156_-107.8909", "81326": "37.1654_-108.1219", "81329": "37.0926_-108.1252", "80511": "40.6281_-105.5692", "80512": "40.6265_-105.261", "80513": "40.2993_-105.1055", "80515": "40.4275_-105.3831", "80517": "40.3658_-105.5142", "80521": "40.5813_-105.1039", "80522": "40.6429_-105.057", "80523": "40.5853_-105.0844", "80524": "40.5986_-105.0581", "80525": "40.5384_-105.0547", "80526": "40.5473_-105.1076", "80527": "40.5853_-105.0844", "80528": "40.4961_-105.0002", "80532": "40.4578_-105.447", "80535": "40.6347_-105.1488", "80536": "40.8701_-105.3766", "80537": "40.3849_-105.0916", "80538": "40.4262_-105.09", "80539": "40.3978_-105.075", "80541": "40.4875_-105.2108", "80545": "40.8659_-105.6893", "80547": "40.5291_-104.9853", "80549": "40.7255_-105.0318", "80553": "40.5853_-105.0844", "81020": "37.3933_-104.6769", "81024": "37.2081_-104.7198", "81027": "37.0518_-103.8741", "81046": "37.2796_-104.3584", "81049": "37.3328_-103.3736", "81059": "37.5192_-104.223", "81081": "37.0757_-104.1184", "81082": "37.2691_-104.5038", "81091": "37.1702_-104.8247", "80804": "39.3025_-103.271", "80818": "39.3383_-103.4607", "80821": "39.0843_-103.499", "80823": "38.7119_-103.5006", "80826": "39.2639_-103.6922", "80828": "39.2713_-103.6856", "80722": "40.5082_-103.2749", "80726": "40.8747_-102.8472", "80728": "40.637_-102.8688", "80736": "40.7692_-103.0968", "80741": "40.5708_-103.4719", "80745": "40.8842_-103.3728", "80747": "40.9519_-103.1166", "80751": "40.6306_-103.2212", "81501": "39.0783_-108.5457", "81502": "39.0179_-108.4814", "81503": "39.0307_-108.4361", "81504": "39.0791_-108.4916", "81505": "39.1071_-108.5968", "81506": "39.1032_-108.5491", "81507": "39.0157_-108.6129", "81520": "39.0805_-108.4496", "81521": "39.1637_-108.7218", "81522": "38.6784_-108.9719", "81523": "38.9894_-108.781", "81524": "39.2279_-108.8149", "81525": "39.2554_-108.9296", "81526": "39.1032_-108.368", "81527": "38.9744_-108.399", "81624": "39.2453_-107.9249", "81630": "39.3118_-108.2304", "81643": "39.1612_-108.1044", "81646": "39.1891_-108.0604", "81130": "37.8164_-106.9277", "81610": "40.2566_-108.9652", "81625": "40.5224_-107.5615", "81626": "40.5152_-107.5465", "81633": "40.377_-108.399", "81638": "40.325_-107.5841", "81640": "40.6738_-108.3699", "81653": "40.9979_-107.3388", "81321": "37.3549_-108.5837", "81323": "37.4666_-108.4717", "81327": "37.5177_-108.6546", "81328": "37.3471_-108.2982", "81330": "37.2313_-108.4825", "81331": "37.5888_-108.8095", "81334": "37.2084_-108.72", "81335": "37.5344_-108.7173", "81220": "38.3876_-107.4824", "81401": "38.4678_-107.8752", "81402": "38.4851_-107.886", "81403": "38.3602_-107.9381", "81411": "38.2509_-108.9799", "81422": "38.2183_-108.5687", "81424": "38.2682_-108.5476", "81425": "38.5976_-107.9921", "81429": "38.3711_-108.9698", "81431": "38.1865_-108.3895", "80649": "40.3639_-104.0973", "80653": "40.3681_-103.9678", "80654": "40.1598_-104.0468", "80701": "40.2541_-103.8031", "80705": "40.2707_-103.8338", "80723": "40.2603_-103.6279", "80733": "40.3459_-103.5057", "80750": "40.3307_-103.5971", "81030": "38.107_-103.5102", "81039": "38.1231_-104.0299", "81050": "37.9546_-103.6644", "81058": "38.1109_-103.8766", "81067": "38.049_-103.7251", "81077": "38.0145_-103.6283", "81427": "38.0258_-107.6726", "81432": "38.1381_-107.7533", "80420": "39.2839_-106.0628", "80421": "39.4482_-105.4693", "80432": "39.1587_-105.817", "80440": "39.2256_-105.9994", "80448": "39.4612_-105.6583", "80449": "38.9673_-105.8788", "80456": "39.2759_-105.6865", "80475": "39.4211_-105.5542", "80820": "38.8146_-105.5784", "80827": "39.0342_-105.4347", "80721": "40.6824_-102.1706", "80731": "40.6406_-102.6052", "80734": "40.5825_-102.2825", "80746": "40.6106_-102.4722", "81611": "39.1951_-106.8236", "81612": "39.2234_-106.8828", "81615": "39.2212_-106.932", "81642": "39.3199_-106.6596", "81654": "39.2258_-107.0303", "81656": "39.2831_-106.8985", "81041": "38.0545_-102.3271", "81043": "38.1195_-102.2168", "81047": "38.0205_-102.1415", "81052": "38.0841_-102.6192", "81092": "38.159_-102.7147", "81001": "38.2879_-104.5848", "81002": "38.2544_-104.6091", "81003": "38.2843_-104.6234", "81004": "38.2441_-104.6278", "81005": "38.2352_-104.66", "81006": "38.2447_-104.5318", "81007": "38.387_-104.7792", "81008": "38.3133_-104.6284", "81009": "38.1286_-104.5523", "81010": "38.1286_-104.5523", "81011": "38.1286_-104.5523", "81012": "38.1286_-104.5523", "81019": "37.9441_-104.8412", "81022": "38.1025_-104.5298", "81023": "38.0837_-104.9724", "81025": "38.2646_-104.2585", "81069": "37.9236_-104.9303", "81641": "40.0387_-107.8925", "81648": "40.0828_-108.7991", "81132": "37.6447_-106.4073", "81135": "37.5756_-106.097", "81144": "37.5731_-106.1408", "81154": "37.6725_-106.6125", "80428": "40.7268_-106.9215", "80467": "40.2567_-106.9296", "80469": "40.1907_-106.9735", "80477": "40.485_-106.8317", "80479": "40.0603_-106.8081", "80483": "40.1304_-106.9116", "80487": "40.6327_-106.9318", "80488": "40.6197_-106.8607", "81639": "40.4945_-107.2571", "81125": "37.7343_-106.0906", "81131": "37.953_-105.6879", "81143": "38.0452_-105.8411", "81149": "38.0977_-106.1876", "81155": "38.2952_-106.1102", "81248": "38.4033_-106.4161", "81433": "37.809_-107.6667", "81325": "37.9344_-108.9299", "81423": "38.1104_-108.2845", "81426": "37.8569_-107.8326", "81430": "38.0167_-108.0534", "81435": "37.94_-107.8214", "80737": "40.9708_-102.2575", "80744": "40.9459_-102.3874", "80749": "40.9103_-102.5291", "80424": "39.4753_-106.0225", "80435": "39.5952_-105.9741", "80443": "39.5589_-106.1332", "80497": "39.6411_-106.108", "80498": "39.7647_-106.2211", "80813": "38.8261_-105.1499", "80814": "38.9576_-105.1994", "80816": "38.8546_-105.3121", "80860": "38.71_-105.14", "80863": "38.9969_-105.0623", "80866": "38.9939_-105.0569", "80720": "40.1803_-103.2259", "80740": "39.7909_-103.4142", "80743": "40.203_-102.9392", "80757": "39.805_-103.5752", "80801": "39.6909_-103.1373", "80812": "39.6848_-102.9904", "80504": "40.1306_-104.9504", "80514": "40.0836_-104.9297", "80516": "40.0597_-105.0686", "80520": "40.1125_-104.9366", "80530": "40.0978_-104.9293", "80534": "40.3355_-104.9236", "80542": "40.2347_-104.9994", "80543": "40.3294_-104.8552", "80546": "40.525_-104.8505", "80550": "40.4837_-104.8994", "80551": "40.4775_-104.9014", "80610": "40.5938_-104.7356", "80611": "40.6392_-104.2871", "80612": "40.8666_-104.8859", "80615": "40.5273_-104.7146", "80620": "40.3803_-104.6971", "80621": "40.108_-104.8013", "80622": "40.5378_-104.4585", "80623": "40.2854_-104.7825", "80624": "40.4696_-104.5", "80631": "40.385_-104.6806", "80632": "40.3766_-104.7629", "80633": "40.4233_-104.7091", "80634": "40.4109_-104.7541", "80638": "40.4233_-104.7091", "80639": "40.3993_-104.7017", "80642": "40.0606_-104.6532", "80643": "40.0958_-104.4464", "80644": "40.3963_-104.5288", "80645": "40.3211_-104.7268", "80646": "40.4824_-104.7054", "80648": "40.7265_-104.785", "80650": "40.6359_-104.7638", "80651": "40.2131_-104.8028", "80652": "40.0878_-104.282", "80729": "40.8716_-104.2346", "80732": "40.9751_-104.3053", "80742": "40.6851_-103.839", "80754": "40.687_-103.6387", "80727": "40.1138_-102.4828", "80735": "39.8167_-102.4262", "80755": "39.9331_-102.3193", "80758": "40.0685_-102.393", "80759": "40.1301_-102.7072", "80822": "39.6564_-102.6788", "80824": "39.6171_-102.4776", "06404": "41.3665_-73.2571", "06440": "41.4276_-73.3551", "06468": "41.3312_-73.2243", "06470": "41.3931_-73.3167", "06482": "41.4087_-73.2485", "06484": "41.3047_-73.1294", "06491": "41.3866_-73.1872", "06601": "41.167_-73.2048", "06602": "41.1798_-73.189", "06604": "41.1796_-73.2019", "06605": "41.1668_-73.2163", "06606": "41.2091_-73.2086", "06607": "41.1784_-73.165", "06608": "41.1895_-73.1811", "06610": "41.2005_-73.1688", "06611": "41.2564_-73.2111", "06612": "41.2523_-73.2871", "06614": "41.216_-73.1304", "06615": "41.177_-73.1336", "06673": "41.167_-73.2048", "06699": "41.167_-73.2048", "06784": "41.5714_-73.4947", "06801": "41.3813_-73.4008", "06804": "41.465_-73.398", "06807": "41.053_-73.5935", "06810": "41.3917_-73.4532", "06811": "41.424_-73.4716", "06812": "41.473_-73.4978", "06813": "41.3948_-73.454", "06814": "41.3089_-73.3637", "06816": "41.3089_-73.3637", "06817": "41.3948_-73.454", "06820": "41.0768_-73.4853", "06824": "41.1692_-73.2681", "06825": "41.1928_-73.2402", "06828": "41.169_-73.2334", "06829": "41.2555_-73.4279", "06830": "41.0427_-73.6262", "06831": "41.0549_-73.6594", "06836": "41.0265_-73.6285", "06838": "41.1238_-73.3195", "06840": "41.151_-73.4944", "06850": "41.1222_-73.4358", "06851": "41.1323_-73.4058", "06852": "41.3089_-73.3637", "06853": "41.0702_-73.4397", "06854": "41.0957_-73.4285", "06855": "41.1014_-73.4011", "06856": "41.1112_-73.4204", "06857": "41.3089_-73.3637", "06858": "41.1105_-73.4162", "06860": "41.3089_-73.3637", "06870": "41.0354_-73.5673", "06875": "41.3089_-73.3637", "06876": "41.314_-73.3504", "06877": "41.2977_-73.4973", "06878": "41.038_-73.5811", "06879": "41.2815_-73.4982", "06880": "41.1434_-73.3496", "06881": "41.1415_-73.3579", "06883": "41.2195_-73.3715", "06888": "41.3089_-73.3637", "06889": "41.141_-73.3469", "06890": "41.1428_-73.2884", "06896": "41.2711_-73.3863", "06897": "41.2018_-73.4383", "06901": "41.0531_-73.539", "06902": "41.0602_-73.5445", "06903": "41.1352_-73.5684", "06904": "41.0534_-73.5387", "06905": "41.0888_-73.5435", "06906": "41.0692_-73.5236", "06907": "41.0942_-73.5203", "06910": "41.0391_-73.5591", "06911": "41.0534_-73.5387", "06912": "41.0534_-73.5387", "06913": "41.0534_-73.5387", "06914": "41.0534_-73.5387", "06920": "41.0534_-73.5387", "06921": "41.0499_-73.538", "06922": "41.0516_-73.5143", "06926": "41.0412_-73.5386", "06927": "41.0534_-73.5387", "06001": "41.7905_-72.8653", "06002": "41.8316_-72.7249", "06006": "41.8526_-72.6437", "06010": "41.6823_-72.9302", "06011": "41.6718_-72.9493", "06013": "41.7573_-72.9444", "06016": "41.9042_-72.5444", "06019": "41.8384_-72.8987", "06020": "41.8539_-72.9028", "06022": "41.8513_-72.9283", "06023": "41.6128_-72.719", "06025": "41.6889_-72.5345", "06026": "41.9322_-72.7459", "06027": "42.0016_-72.9242", "06028": "41.8592_-72.603", "06030": "41.7918_-72.7188", "06032": "41.7284_-72.8415", "06033": "41.7073_-72.5727", "06034": "41.7918_-72.7188", "06035": "41.9602_-72.7994", "06037": "41.6215_-72.7457", "06040": "41.7777_-72.5244", "06041": "41.7759_-72.5215", "06042": "41.7966_-72.5292", "06045": "41.7759_-72.5215", "06050": "41.666_-72.7784", "06051": "41.6667_-72.7722", "06052": "41.6588_-72.7989", "06053": "41.6867_-72.7908", "06059": "41.8997_-72.8907", "06060": "42.0219_-72.8409", "06062": "41.6727_-72.8644", "06064": "41.9048_-72.6787", "06067": "41.6583_-72.6632", "06070": "41.8759_-72.8012", "06073": "41.6571_-72.5722", "06074": "41.8341_-72.5576", "06078": "41.99_-72.642", "06080": "41.9818_-72.6506", "06081": "41.9077_-72.7678", "06082": "41.989_-72.5652", "06083": "41.9762_-72.5918", "06085": "41.7477_-72.8874", "06087": "41.7576_-72.885", "06088": "41.9099_-72.6029", "06089": "41.8372_-72.8253", "06090": "41.9556_-72.862", "06091": "42.0076_-72.9707", "06092": "41.8718_-72.8577", "06093": "42.0115_-72.7362", "06095": "41.8561_-72.6639", "06096": "41.9261_-72.6458", "06101": "41.7801_-72.6771", "06102": "41.7918_-72.7188", "06103": "41.7672_-72.676", "06104": "41.7918_-72.7188", "06105": "41.7691_-72.701", "06106": "41.7498_-72.6947", "06107": "41.7556_-72.7532", "06108": "41.7803_-72.618", "06109": "41.7013_-72.6763", "06110": "41.7326_-72.7337", "06111": "41.686_-72.7296", "06112": "41.7905_-72.6964", "06114": "41.7403_-72.6807", "06115": "41.7588_-72.6794", "06117": "41.79_-72.7457", "06118": "41.7472_-72.6103", "06119": "41.7628_-72.7268", "06120": "41.786_-72.6758", "06123": "41.7637_-72.6851", "06126": "41.7637_-72.6851", "06127": "41.7918_-72.7188", "06128": "41.7918_-72.7188", "06129": "41.7918_-72.7188", "06131": "41.7918_-72.7188", "06132": "41.7637_-72.6851", "06133": "41.7918_-72.7188", "06134": "41.7637_-72.6851", "06137": "41.7918_-72.7188", "06138": "41.7918_-72.7188", "06140": "41.7918_-72.7188", "06141": "41.7918_-72.7188", "06142": "41.7918_-72.7188", "06143": "41.7918_-72.7188", "06144": "41.7918_-72.7188", "06145": "41.7918_-72.7188", "06146": "41.7918_-72.7188", "06147": "41.7918_-72.7188", "06150": "41.7918_-72.7188", "06151": "41.7918_-72.7188", "06152": "41.7637_-72.6851", "06153": "41.7918_-72.7188", "06154": "41.7715_-72.6867", "06155": "41.7693_-72.6865", "06156": "41.7679_-72.6907", "06160": "41.7665_-72.6933", "06161": "41.766_-72.6718", "06167": "41.7637_-72.6851", "06176": "41.7918_-72.7188", "06180": "41.7918_-72.7188", "06183": "41.7638_-72.673", "06199": "41.9274_-72.6804", "06444": "41.5637_-72.9257", "06447": "41.6412_-72.4609", "06467": "41.5659_-72.8918", "06479": "41.5797_-72.899", "06489": "41.6052_-72.8727", "06018": "42.0248_-73.3232", "06021": "41.9895_-73.0957", "06024": "42.0158_-73.2913", "06031": "41.9559_-73.3632", "06039": "41.9516_-73.4377", "06057": "41.8468_-73.0104", "06058": "41.9854_-73.1992", "06061": "41.8765_-72.967", "06063": "41.9293_-72.914", "06065": "41.9686_-73.0145", "06068": "42.0015_-73.4215", "06069": "41.8714_-73.4578", "06079": "42.032_-73.4038", "06094": "41.8963_-73.1463", "06098": "41.9252_-73.0663", "06750": "41.7215_-73.252", "06751": "41.6387_-73.2091", "06752": "41.5287_-73.3609", "06753": "41.8281_-73.3323", "06754": "41.8187_-73.371", "06755": "41.6486_-73.4835", "06756": "41.8335_-73.2429", "06757": "41.7316_-73.4583", "06758": "41.6754_-73.242", "06759": "41.7541_-73.2", "06763": "41.6881_-73.1765", "06776": "41.5817_-73.4128", "06777": "41.6903_-73.3103", "06778": "41.7077_-73.109", "06779": "41.5909_-73.0873", "06781": "41.6699_-72.9915", "06782": "41.6611_-73.0449", "06783": "41.5509_-73.2993", "06785": "41.6951_-73.469", "06786": "41.6762_-73.0092", "06787": "41.6786_-73.0886", "06790": "41.8131_-73.1156", "06791": "41.7701_-73.0728", "06792": "41.7549_-73.0582", "06793": "41.6296_-73.2884", "06794": "41.6559_-73.3274", "06795": "41.6057_-73.1221", "06796": "41.8689_-73.3313", "06798": "41.5521_-73.2083", "06409": "41.3474_-72.4173", "06412": "41.4049_-72.4643", "06413": "41.2912_-72.528", "06414": "41.5667_-72.5581", "06416": "41.6105_-72.6663", "06417": "41.3765_-72.4486", "06419": "41.3696_-72.5712", "06422": "41.465_-72.6875", "06423": "41.4696_-72.4059", "06424": "41.5761_-72.5093", "06426": "41.3549_-72.3965", "06438": "41.4627_-72.505", "06441": "41.4682_-72.5751", "06442": "41.3421_-72.4404", "06455": "41.5168_-72.7186", "06456": "41.554_-72.5501", "06457": "41.5569_-72.6652", "06459": "41.5565_-72.6582", "06469": "41.5078_-72.4419", "06475": "41.2913_-72.385", "06480": "41.5852_-72.6128", "06481": "41.5341_-72.6997", "06498": "41.2927_-72.4563", "06401": "41.3427_-73.0742", "06403": "41.4369_-73.0597", "06405": "41.28_-72.8106", "06408": "41.3657_-72.9275", "06410": "41.5055_-72.9081", "06411": "41.499_-72.9007", "06418": "41.3229_-73.08", "06437": "41.3154_-72.6968", "06443": "41.309_-72.6153", "06450": "41.5334_-72.7997", "06451": "41.5401_-72.8189", "06460": "41.2175_-73.0549", "06461": "41.2338_-73.0747", "06471": "41.3323_-72.7809", "06472": "41.3962_-72.7809", "06473": "41.3822_-72.8585", "06477": "41.2815_-73.0287", "06478": "41.4202_-73.1296", "06483": "41.3862_-73.0817", "06487": "41.4709_-73.2515", "06488": "41.4767_-73.2241", "06492": "41.46_-72.8222", "06493": "41.3657_-72.9275", "06494": "41.3657_-72.9275", "06495": "41.3885_-72.8795", "06501": "41.3082_-72.9282", "06502": "41.3082_-72.9282", "06503": "41.3082_-72.9282", "06504": "41.3657_-72.9275", "06505": "41.3082_-72.9282", "06506": "41.3082_-72.9282", "06507": "41.3082_-72.9282", "06508": "41.3082_-72.9282", "06509": "41.3082_-72.9282", "06510": "41.3087_-72.9271", "06511": "41.3184_-72.9318", "06512": "41.3082_-72.9282", "06513": "41.3072_-72.8654", "06514": "41.362_-72.9361", "06515": "41.3293_-72.9664", "06516": "41.2701_-72.9638", "06517": "41.3484_-72.9117", "06518": "41.4097_-72.911", "06519": "41.2963_-72.9373", "06520": "41.3082_-72.9282", "06521": "41.3082_-72.9282", "06524": "41.4262_-73.0007", "06525": "41.3082_-72.9282", "06530": "41.3082_-72.9282", "06531": "41.3082_-72.9282", "06532": "41.3082_-72.9282", "06533": "41.3082_-72.9282", "06534": "41.3082_-72.9282", "06535": "41.3082_-72.9282", "06536": "41.3082_-72.9282", "06537": "41.3657_-72.9275", "06538": "41.3657_-72.9275", "06540": "41.2996_-72.9188", "06701": "41.5582_-73.0515", "06702": "41.5566_-73.0385", "06703": "41.5582_-73.0515", "06704": "41.5754_-73.0318", "06705": "41.5503_-72.9963", "06706": "41.5363_-73.0306", "06708": "41.5511_-73.0645", "06710": "41.5675_-73.0468", "06712": "41.5022_-72.9788", "06716": "41.597_-72.9828", "06720": "41.5582_-73.0515", "06721": "41.5582_-73.0515", "06722": "41.5582_-73.0515", "06723": "41.5582_-73.0515", "06724": "41.5582_-73.0515", "06725": "41.5582_-73.0515", "06726": "41.5582_-73.0515", "06749": "41.5582_-73.0515", "06762": "41.5343_-73.1131", "06770": "41.492_-73.0493", "06249": "41.633_-72.244", "06254": "41.6161_-72.1425", "06320": "41.3507_-72.1062", "06330": "41.6263_-72.0775", "06333": "41.3668_-72.233", "06334": "41.5465_-72.1711", "06335": "41.4285_-72.0672", "06336": "41.5795_-72.1963", "06338": "41.4757_-71.9574", "06339": "41.4401_-71.9956", "06340": "41.3572_-72.0579", "06349": "41.3997_-72.0904", "06350": "41.6445_-72.0677", "06351": "41.6052_-71.9808", "06353": "41.479_-72.1512", "06355": "41.3616_-71.9774", "06357": "41.3253_-72.2108", "06359": "41.4531_-71.8727", "06360": "41.5371_-72.0849", "06365": "41.5224_-71.9934", "06370": "41.4706_-72.1904", "06371": "41.3347_-72.3086", "06372": "41.3882_-71.9495", "06375": "41.4032_-72.1172", "06376": "41.2967_-72.2633", "06378": "41.3664_-71.9155", "06379": "41.3735_-71.8478", "06380": "41.5653_-72.0529", "06382": "41.4622_-72.1126", "06383": "41.6016_-72.0404", "06384": "41.5831_-71.855", "06385": "41.3469_-72.1458", "06388": "41.3441_-71.9765", "06389": "41.5598_-72.1237", "06415": "41.5662_-72.3441", "06420": "41.4966_-72.2725", "06439": "41.4212_-72.4141", "06474": "41.5809_-72.4012", "06029": "41.9114_-72.4626", "06043": "41.7689_-72.4396", "06066": "41.8501_-72.4649", "06071": "41.9978_-72.4583", "06072": "41.9765_-72.4906", "06075": "41.9848_-72.289", "06076": "41.9661_-72.2899", "06077": "41.9916_-72.2577", "06084": "41.8696_-72.3718", "06231": "41.629_-72.3646", "06232": "41.7332_-72.3767", "06237": "41.6973_-72.3072", "06238": "41.7822_-72.3332", "06248": "41.6842_-72.3986", "06250": "41.7698_-72.2011", "06251": "41.7993_-72.3065", "06265": "41.8554_-72.3015", "06268": "41.7997_-72.2478", "06269": "41.808_-72.251", "06279": "41.8966_-72.2622", "06226": "41.7149_-72.2134", "06230": "41.8473_-72.0253", "06233": "41.8768_-71.8612", "06234": "41.7807_-71.9541", "06235": "41.8026_-72.1372", "06239": "41.7982_-71.8807", "06241": "41.854_-71.8683", "06242": "41.8771_-72.0895", "06243": "41.8452_-71.8026", "06244": "41.9843_-71.981", "06245": "42.0198_-71.9417", "06246": "41.9711_-71.8917", "06247": "41.7671_-72.0662", "06255": "41.9784_-71.8997", "06256": "41.7451_-72.1601", "06258": "41.889_-71.9682", "06259": "41.8697_-71.982", "06260": "41.9185_-71.8968", "06262": "42.0217_-71.9391", "06263": "41.8391_-71.9063", "06264": "41.6958_-72.087", "06266": "41.6677_-72.1681", "06267": "41.9439_-71.9453", "06277": "41.9803_-71.8376", "06278": "41.889_-72.1476", "06280": "41.7027_-72.1526", "06281": "41.9602_-72.004", "06282": "41.9153_-72.0937", "06331": "41.6844_-72.001", "06332": "41.7229_-71.9067", "06354": "41.721_-71.885", "06373": "41.6937_-71.8084", "06374": "41.6775_-71.922", "06377": "41.7156_-71.8196", "06387": "41.7445_-71.9133", "20001": "38.9122_-77.0177", "20002": "38.9024_-76.9901", "20003": "38.8829_-76.9895", "20004": "38.893_-77.0263", "20005": "38.9067_-77.0312", "20006": "38.8964_-77.0447", "20007": "38.9144_-77.074", "20008": "38.9363_-77.0599", "20009": "38.9202_-77.0375", "20010": "38.9327_-77.0322", "20011": "38.9518_-77.0203", "20012": "38.9757_-77.0282", "20013": "38.8933_-77.0146", "20015": "38.9658_-77.068", "20016": "38.9381_-77.086", "20017": "38.9367_-76.994", "20018": "38.9277_-76.9762", "20019": "38.8902_-76.9376", "20020": "38.86_-76.9742", "20022": "38.945_-77.0364", "20024": "38.8759_-77.016", "20026": "38.8933_-77.0146", "20027": "38.9007_-77.0501", "20029": "38.8933_-77.0146", "20030": "38.8933_-77.0146", "20032": "38.8338_-76.9995", "20033": "38.8933_-77.0146", "20035": "38.8933_-77.0146", "20036": "38.9087_-77.0414", "20037": "38.9014_-77.0504", "20038": "38.8933_-77.0146", "20039": "38.8933_-77.0146", "20040": "38.8933_-77.0146", "20041": "38.8933_-77.0146", "20042": "38.8933_-77.0146", "20043": "38.8933_-77.0146", "20044": "38.8933_-77.0146", "20045": "38.8966_-77.0319", "20047": "38.8933_-77.0146", "20049": "38.8959_-77.021", "20050": "38.8933_-77.0146", "20052": "38.9001_-77.0479", "20053": "38.8933_-77.0146", "20055": "38.9016_-77.021", "20056": "38.8933_-77.0146", "20057": "38.8933_-77.0146", "20058": "38.8933_-77.0146", "20059": "38.8933_-77.0146", "20060": "38.918_-77.0204", "20061": "38.8933_-77.0146", "20062": "38.9_-77.0369", "20063": "38.9053_-77.0466", "20064": "38.9332_-76.9963", "20065": "38.8834_-77.0282", "20066": "38.8933_-77.0146", "20067": "38.8933_-77.0146", "20068": "38.8951_-77.0364", "20069": "38.8933_-77.0146", "20070": "38.8933_-77.0146", "20071": "38.8933_-77.0146", "20073": "38.897_-77.0251", "20074": "38.8933_-77.0146", "20075": "38.8933_-77.0146", "20076": "38.8933_-77.0146", "20077": "38.8933_-77.0146", "20078": "38.8933_-77.0146", "20080": "38.8933_-77.0146", "20081": "38.8933_-77.0146", "20082": "38.8933_-77.0146", "20090": "38.8933_-77.0146", "20091": "38.8933_-77.0146", "20201": "38.8933_-77.0146", "20202": "38.8933_-77.0146", "20203": "38.9053_-77.0466", "20204": "38.8933_-77.0146", "20206": "38.8933_-77.0146", "20207": "38.8933_-77.0146", "20208": "38.8966_-77.0117", "20210": "38.8933_-77.0146", "20211": "38.8933_-77.0146", "20212": "38.8933_-77.0146", "20213": "38.8933_-77.0146", "20214": "38.8933_-77.0146", "20215": "38.8933_-77.0146", "20216": "38.8919_-77.0141", "20217": "38.8933_-77.0146", "20218": "38.8933_-77.0146", "20219": "38.8933_-77.0146", "20220": "38.8933_-77.0146", "20221": "38.8933_-77.0146", "20222": "38.8933_-77.0146", "20223": "38.8933_-77.0146", "20224": "38.8933_-77.0146", "20226": "38.8933_-77.0146", "20227": "38.8933_-77.0146", "20228": "38.8951_-77.0364", "20229": "38.8933_-77.0146", "20230": "38.8951_-77.0364", "20232": "38.9006_-77.0391", "20233": "38.8933_-77.0146", "20235": "38.9154_-77.0572", "20237": "38.895_-77.0367", "20238": "38.8933_-77.0146", "20239": "38.8933_-77.0146", "20240": "38.8971_-77.0409", "20241": "38.8933_-77.0146", "20242": "38.8678_-77.0289", "20244": "38.8933_-77.0146", "20245": "38.8951_-77.0364", "20250": "38.8873_-77.0327", "20251": "38.8933_-77.0146", "20252": "38.9584_-77.0519", "20254": "38.8933_-77.0146", "20260": "38.8933_-77.0146", "20261": "38.8933_-77.0146", "20262": "38.8933_-77.0146", "20265": "38.8933_-77.0146", "20266": "38.8933_-77.0146", "20268": "38.8933_-77.0146", "20270": "38.8933_-77.0146", "20277": "38.8933_-77.0146", "20289": "38.8933_-77.0146", "20299": "38.8933_-77.0146", "20301": "38.8894_-77.0311", "20303": "38.8933_-77.0146", "20306": "38.8933_-77.0146", "20310": "38.8933_-77.0146", "20314": "38.8933_-77.0146", "20317": "38.9363_-77.0123", "20318": "38.8933_-77.0146", "20319": "38.8667_-77.0166", "20330": "38.8933_-77.0146", "20340": "38.8933_-77.0146", "20350": "38.8933_-77.0146", "20355": "38.8951_-77.0369", "20370": "38.8933_-77.0146", "20372": "38.8933_-77.0146", "20373": "38.8951_-77.0364", "20374": "38.8951_-77.0364", "20375": "38.8262_-77.0174", "20376": "38.9164_-76.9947", "20380": "38.8933_-77.0146", "20388": "38.8951_-77.0364", "20389": "38.8933_-77.0146", "20390": "38.8933_-77.0146", "20391": "38.8951_-77.0364", "20392": "38.8933_-77.0146", "20393": "38.8933_-77.0146", "20394": "38.8933_-77.0146", "20395": "38.8933_-77.0146", "20398": "38.8951_-77.0364", "20401": "38.8933_-77.0146", "20402": "38.8933_-77.0146", "20403": "38.8933_-77.0146", "20404": "38.8992_-77.0089", "20405": "38.8951_-77.0364", "20406": "38.8933_-77.0146", "20407": "38.8933_-77.0146", "20408": "38.8933_-77.0146", "20409": "38.8933_-77.0146", "20410": "38.8933_-77.0146", "20411": "38.884_-77.0221", "20412": "38.8953_-77.0221", "20413": "38.8933_-77.0146", "20414": "38.884_-77.0221", "20415": "38.8933_-77.0146", "20416": "38.8933_-77.0146", "20417": "38.907_-77.0058", "20418": "38.9043_-77.0572", "20419": "38.8933_-77.0146", "20420": "38.9035_-77.0276", "20421": "38.8933_-77.0146", "20422": "38.8933_-77.0146", "20423": "38.8933_-77.0146", "20424": "38.8933_-77.0146", "20425": "38.8933_-77.0146", "20426": "38.8933_-77.0146", "20427": "38.9021_-77.0476", "20428": "38.8933_-77.0146", "20429": "38.8933_-77.0146", "20431": "38.8986_-77.0428", "20433": "38.9_-77.042", "20434": "38.8933_-77.0146", "20435": "38.8994_-77.0403", "20436": "38.8959_-77.0211", "20437": "38.9028_-77.0485", "20439": "38.8933_-77.0146", "20440": "38.9139_-77.0453", "20441": "38.9239_-77.0363", "20442": "38.896_-77.0177", "20444": "38.8933_-77.0146", "20447": "38.8847_-77.0252", "20451": "38.8977_-77.0444", "20453": "38.8933_-77.0146", "20456": "38.8981_-77.0401", "20460": "38.8764_-77.0188", "20463": "38.8933_-77.0146", "20468": "38.8933_-77.0146", "20469": "38.8933_-77.0146", "20470": "38.8933_-77.0146", "20472": "38.8933_-77.0146", "20500": "38.8946_-77.0355", "20501": "38.8987_-77.0362", "20502": "38.8987_-77.0362", "20503": "38.9007_-77.0431", "20504": "38.8933_-77.0146", "20505": "38.8933_-77.0146", "20506": "38.8994_-77.0377", "20507": "38.8933_-77.0146", "20508": "38.8933_-77.0146", "20509": "38.8987_-77.0356", "20510": "38.8933_-77.0146", "20511": "38.8951_-77.0364", "20515": "38.8933_-77.0146", "20520": "38.8932_-77.049", "20521": "38.8933_-77.0146", "20522": "38.8932_-77.049", "20523": "38.8945_-77.0478", "20524": "38.9024_-77.0326", "20525": "38.8933_-77.0146", "20526": "38.9022_-77.0437", "20527": "38.9029_-77.0361", "20528": "38.8951_-77.0369", "20529": "38.8973_-77.0142", "20530": "38.8976_-77.027", "20531": "38.8938_-77.0218", "20533": "38.9011_-77.0326", "20534": "38.8941_-77.0125", "20535": "38.8941_-77.0251", "20536": "38.9012_-77.0169", "20537": "38.8941_-77.0251", "20538": "38.8933_-77.0146", "20539": "38.8933_-77.0146", "20540": "38.8874_-77.0047", "20541": "38.8874_-77.0047", "20542": "38.9408_-77.0283", "20543": "38.8933_-77.0146", "20544": "38.8933_-77.0146", "20546": "38.891_-77.0211", "20547": "38.8933_-77.0146", "20548": "38.8981_-77.0177", "20549": "38.8933_-77.0146", "20551": "38.892_-77.0452", "20552": "38.8933_-77.0146", "20553": "38.8873_-77.0231", "20554": "38.8933_-77.0146", "20555": "38.9_-77.0401", "20557": "38.8874_-77.0047", "20559": "38.8874_-77.0047", "20560": "38.8933_-77.0146", "20565": "38.8919_-77.0189", "20566": "38.8971_-77.0554", "20570": "38.8991_-77.0401", "20571": "38.9006_-77.0346", "20572": "38.8933_-77.0146", "20573": "38.8933_-77.0146", "20575": "38.8933_-77.0146", "20576": "38.8937_-77.0236", "20577": "38.9008_-77.0345", "20578": "38.8933_-77.0146", "20579": "38.9043_-77.0446", "20580": "38.8933_-77.0146", "20581": "38.8933_-77.0146", "20585": "38.8933_-77.0146", "20586": "38.9022_-77.0474", "20590": "38.884_-77.0221", "20591": "38.8933_-77.0146", "20593": "38.8933_-77.0146", "20594": "38.8849_-77.0184", "20597": "38.8933_-77.0146", "20599": "38.8933_-77.0146", "56901": "38.8952_-77.0365", "56915": "38.8952_-77.0365", "56920": "38.8952_-77.0365", "56933": "38.8952_-77.0365", "56944": "38.8952_-77.0365", "56972": "38.8951_-77.0364", "19901": "39.1564_-75.4955", "19902": "39.1253_-75.4818", "19903": "39.1087_-75.448", "19904": "39.1605_-75.5974", "19905": "39.1582_-75.5244", "19906": "39.157_-75.5294", "19934": "39.0991_-75.5966", "19936": "39.2184_-75.5848", "19938": "39.2564_-75.6904", "19943": "39.0225_-75.5829", "19946": "39.0342_-75.4545", "19952": "38.924_-75.5843", "19953": "39.1542_-75.6935", "19954": "38.9114_-75.5064", "19955": "39.2256_-75.6642", "19961": "39.1663_-75.4483", "19962": "39.0735_-75.5083", "19964": "39.0998_-75.7287", "19977": "39.2934_-75.6008", "19979": "39.0419_-75.5726", "19980": "39.0724_-75.5711", "19701": "39.6102_-75.6747", "19702": "39.6349_-75.6993", "19703": "39.8044_-75.4649", "19706": "39.5725_-75.5957", "19707": "39.776_-75.6889", "19708": "39.5776_-75.6901", "19709": "39.4815_-75.6832", "19710": "39.7898_-75.5891", "19711": "39.7011_-75.7375", "19712": "39.5645_-75.597", "19713": "39.6699_-75.7151", "19714": "39.5645_-75.597", "19715": "39.5645_-75.597", "19716": "39.6896_-75.7584", "19717": "39.6837_-75.7497", "19718": "39.5645_-75.597", "19720": "39.5929_-75.6515", "19721": "39.5645_-75.597", "19725": "39.5645_-75.597", "19726": "39.6621_-75.5663", "19730": "39.4592_-75.6536", "19731": "39.5129_-75.5852", "19732": "39.7939_-75.5738", "19733": "39.5555_-75.6505", "19734": "39.3819_-75.6834", "19735": "39.8029_-75.5916", "19736": "39.8082_-75.6755", "19801": "39.7378_-75.5497", "19802": "39.7564_-75.534", "19803": "39.7994_-75.5317", "19804": "39.7168_-75.6184", "19805": "39.7434_-75.5827", "19806": "39.7571_-75.5635", "19807": "39.7949_-75.6161", "19808": "39.7359_-75.6647", "19809": "39.7647_-75.5069", "19810": "39.8188_-75.5064", "19850": "39.5645_-75.597", "19880": "39.5645_-75.597", "19884": "39.7459_-75.5466", "19885": "39.7459_-75.5466", "19886": "39.7459_-75.5466", "19890": "39.5645_-75.597", "19891": "39.5645_-75.597", "19892": "39.5645_-75.597", "19893": "39.7459_-75.5466", "19894": "39.7459_-75.5466", "19895": "39.7459_-75.5466", "19896": "39.5645_-75.597", "19897": "39.5645_-75.597", "19898": "39.7459_-75.5466", "19899": "39.7459_-75.5466", "19930": "38.531_-75.0674", "19931": "38.5685_-75.6243", "19933": "38.7366_-75.6088", "19939": "38.5596_-75.2113", "19940": "38.477_-75.5759", "19941": "38.8057_-75.4056", "19944": "38.4865_-75.0589", "19945": "38.5177_-75.2006", "19947": "38.679_-75.3932", "19950": "38.8175_-75.5935", "19951": "38.6723_-75.2236", "19956": "38.5537_-75.5631", "19958": "38.7381_-75.1747", "19960": "38.8613_-75.4", "19963": "38.9218_-75.4299", "19966": "38.6595_-75.2464", "19967": "38.5496_-75.1232", "19968": "38.7687_-75.2953", "19969": "38.7521_-75.1877", "19970": "38.5617_-75.0966", "19971": "38.7209_-75.076", "19973": "38.6404_-75.6041", "19975": "38.4654_-75.1573", "32601": "29.6489_-82.325", "32602": "29.6299_-82.3966", "32603": "29.6515_-82.3493", "32604": "29.5733_-82.3979", "32605": "29.6785_-82.3679", "32606": "29.6954_-82.4023", "32607": "29.6456_-82.4033", "32608": "29.6132_-82.3873", "32609": "29.7005_-82.308", "32610": "29.6813_-82.3539", "32611": "29.6813_-82.3539", "32612": "29.6813_-82.3539", "32614": "29.6813_-82.3539", "32615": "29.8135_-82.472", "32616": "29.792_-82.496", "32618": "29.5597_-82.5108", "32627": "29.6516_-82.3248", "32631": "29.7439_-82.1034", "32633": "29.4869_-82.2312", "32635": "29.6813_-82.3539", "32640": "29.574_-82.1056", "32641": "29.6824_-82.2014", "32643": "29.841_-82.6156", "32653": "29.7728_-82.3782", "32654": "29.4536_-82.1065", "32655": "29.8175_-82.6006", "32658": "29.8433_-82.4048", "32662": "29.5116_-82.1004", "32667": "29.5122_-82.3053", "32669": "29.6609_-82.5852", "32694": "29.7871_-82.1608", "32040": "30.2861_-82.2041", "32063": "30.2737_-82.1325", "32072": "30.2041_-82.4287", "32087": "30.2522_-82.2729", "32401": "30.1606_-85.6494", "32402": "30.2345_-85.692", "32403": "30.0583_-85.5762", "32404": "30.1653_-85.5763", "32405": "30.1949_-85.6727", "32406": "30.2345_-85.692", "32407": "30.2007_-85.8136", "32408": "30.1655_-85.7116", "32409": "30.3117_-85.6923", "32410": "29.9395_-85.4096", "32411": "30.2345_-85.692", "32412": "30.2345_-85.692", "32413": "30.3105_-85.9106", "32417": "30.1595_-85.6598", "32438": "30.4753_-85.4293", "32444": "30.2362_-85.6467", "32466": "30.3269_-85.5169", "32042": "29.9689_-82.1226", "32044": "29.8575_-82.1483", "32058": "30.0472_-82.1055", "32091": "29.9583_-82.1185", "32622": "29.919_-82.2956", "32754": "28.6974_-80.8663", "32775": "28.7702_-80.872", "32780": "28.5697_-80.8191", "32781": "28.6122_-80.8076", "32783": "28.6122_-80.8076", "32796": "28.6271_-80.8429", "32815": "28.3067_-80.6862", "32899": "28.3067_-80.6862", "32901": "28.0691_-80.62", "32902": "28.0836_-80.6081", "32903": "28.1091_-80.5787", "32904": "28.0673_-80.678", "32905": "28.0313_-80.5995", "32906": "28.0671_-80.6503", "32907": "28.0168_-80.6739", "32908": "27.9816_-80.6894", "32909": "27.9694_-80.6473", "32910": "28.0345_-80.5887", "32911": "28.0345_-80.5887", "32912": "28.0836_-80.6081", "32919": "28.0836_-80.6081", "32920": "28.3903_-80.6043", "32922": "28.3672_-80.7465", "32923": "28.4275_-80.829", "32924": "28.3067_-80.6862", "32925": "28.1743_-80.584", "32926": "28.391_-80.787", "32927": "28.4566_-80.7978", "32931": "28.3325_-80.6121", "32932": "28.3206_-80.6092", "32934": "28.1331_-80.7112", "32935": "28.1384_-80.6524", "32936": "28.0836_-80.6081", "32937": "28.178_-80.602", "32940": "28.2061_-80.685", "32941": "27.9246_-80.5235", "32949": "27.9289_-80.5264", "32950": "27.9761_-80.5788", "32951": "28.0219_-80.5389", "32952": "28.2764_-80.6568", "32953": "28.3888_-80.7301", "32954": "28.5392_-80.672", "32955": "28.3134_-80.7319", "32956": "28.3298_-80.7323", "32959": "28.3067_-80.6862", "32976": "27.8679_-80.5416", "33004": "26.0476_-80.1447", "33008": "25.9812_-80.1484", "33009": "25.985_-80.1407", "33019": "26.007_-80.1219", "33020": "26.0161_-80.1517", "33021": "26.0218_-80.1891", "33022": "26.0134_-80.1442", "33023": "25.9894_-80.2153", "33024": "26.0296_-80.2489", "33025": "25.9921_-80.2712", "33026": "26.0229_-80.2974", "33027": "25.9974_-80.3248", "33028": "26.0185_-80.3449", "33029": "25.9924_-80.4089", "33060": "26.2315_-80.1235", "33061": "26.2539_-80.1342", "33062": "26.2343_-80.0941", "33063": "26.2674_-80.2092", "33064": "26.2785_-80.1157", "33065": "26.2729_-80.2603", "33066": "26.2535_-80.1775", "33067": "26.3033_-80.2415", "33068": "26.216_-80.2205", "33069": "26.2288_-80.1635", "33071": "26.2435_-80.2601", "33072": "26.2335_-80.0924", "33073": "26.2997_-80.181", "33074": "26.2379_-80.1248", "33075": "26.2712_-80.2706", "33076": "26.3168_-80.2753", "33077": "26.2379_-80.1248", "33081": "26.0112_-80.1495", "33082": "26.0031_-80.2239", "33083": "26.0112_-80.1495", "33084": "26.0112_-80.1495", "33093": "26.2445_-80.2064", "33097": "26.2517_-80.1789", "33301": "26.1216_-80.1288", "33302": "26.1223_-80.1434", "33303": "26.1969_-80.0952", "33304": "26.1387_-80.1218", "33305": "26.1497_-80.1229", "33306": "26.1656_-80.1118", "33307": "26.1223_-80.1434", "33308": "26.0984_-80.1822", "33309": "26.1817_-80.1746", "33310": "26.1443_-80.2069", "33311": "26.1421_-80.1728", "33312": "26.0968_-80.181", "33313": "26.1487_-80.2075", "33314": "26.0697_-80.2246", "33315": "26.0989_-80.1541", "33316": "26.1042_-80.126", "33317": "26.1122_-80.2264", "33318": "26.1184_-80.252", "33319": "26.1848_-80.2406", "33320": "26.1625_-80.2582", "33321": "26.212_-80.2696", "33322": "26.1502_-80.2745", "33323": "26.152_-80.3165", "33324": "26.1255_-80.2644", "33325": "26.1097_-80.3215", "33326": "26.1158_-80.3681", "33327": "26.1168_-80.4156", "33328": "26.0671_-80.2723", "33329": "26.1223_-80.1434", "33330": "26.0663_-80.3339", "33331": "26.048_-80.3749", "33332": "26.0596_-80.4146", "33334": "26.1845_-80.1344", "33335": "26.0892_-80.336", "33336": "26.1219_-80.1436", "33337": "26.129_-80.2601", "33338": "26.1223_-80.1434", "33339": "26.1223_-80.1434", "33340": "26.1223_-80.1434", "33345": "26.1654_-80.2959", "33346": "26.1223_-80.1434", "33348": "26.1223_-80.1434", "33349": "26.1223_-80.1434", "33351": "26.1793_-80.2746", "33355": "26.1223_-80.1434", "33359": "26.1223_-80.1434", "33388": "26.1342_-80.2318", "33394": "26.1221_-80.139", "33441": "26.3096_-80.0992", "33442": "26.3124_-80.1412", "33443": "26.3184_-80.0998", "33973": "26.602_-81.7311", "32421": "30.5319_-85.1704", "32424": "30.4394_-85.062", "32430": "30.3568_-85.1898", "32449": "30.4059_-85.1974", "33927": "26.9324_-82.2168", "33938": "26.902_-82", "33946": "26.8323_-82.2648", "33947": "26.8842_-82.2691", "33948": "26.9827_-82.1412", "33949": "26.9939_-82.0984", "33950": "26.9152_-82.0532", "33951": "26.9708_-81.9845", "33952": "26.9905_-82.0964", "33953": "27.004_-82.2117", "33954": "27.0228_-82.1108", "33955": "26.824_-81.9547", "33980": "26.9298_-82.0454", "33981": "26.9379_-82.2388", "33982": "26.9668_-81.9545", "33983": "27.0074_-82.0163", "34423": "28.867_-82.5727", "34428": "28.9584_-82.5993", "34429": "28.8547_-82.6669", "34433": "28.9949_-82.5196", "34434": "28.9938_-82.4241", "34436": "28.7304_-82.3077", "34441": "28.9311_-82.372", "34442": "28.9223_-82.39", "34445": "28.9669_-82.4207", "34446": "28.7508_-82.5139", "34447": "28.8049_-82.5743", "34448": "28.788_-82.568", "34450": "28.834_-82.2822", "34451": "28.8358_-82.3304", "34452": "28.8358_-82.3304", "34453": "28.8723_-82.3454", "34460": "28.8593_-82.5087", "34461": "28.8516_-82.4876", "34464": "28.9169_-82.4582", "34465": "28.9295_-82.4892", "34487": "28.7814_-82.6151", "32003": "30.0933_-81.719", "32006": "30.107_-81.7167", "32030": "30.1056_-81.769", "32043": "29.9983_-81.7647", "32050": "30.0689_-81.8604", "32065": "30.1382_-81.7742", "32067": "30.1661_-81.7065", "32068": "30.084_-81.8645", "32073": "30.1637_-81.7291", "32079": "29.9849_-81.8022", "32160": "29.7683_-81.9907", "32656": "29.7976_-81.9899", "34101": "26.1423_-81.796", "34102": "26.134_-81.7953", "34103": "26.1917_-81.8039", "34104": "26.1529_-81.7417", "34105": "26.1938_-81.7636", "34106": "26.1423_-81.796", "34107": "26.1423_-81.796", "34108": "26.2416_-81.8071", "34109": "26.2534_-81.7644", "34110": "26.2823_-81.7573", "34112": "26.1184_-81.7361", "34113": "26.0426_-81.7182", "34114": "26.0143_-81.5856", "34116": "26.1873_-81.711", "34117": "26.1156_-81.5239", "34119": "26.2665_-81.7146", "34120": "26.3304_-81.5871", "34137": "25.9542_-81.3575", "34138": "25.8129_-81.362", "34139": "25.857_-81.3778", "34140": "25.9248_-81.6456", "34141": "25.8734_-81.1599", "34142": "26.1844_-81.4152", "34143": "26.4642_-81.5047", "34145": "25.9388_-81.6968", "34146": "25.9412_-81.7184", "32024": "30.1055_-82.6878", "32025": "30.1601_-82.6396", "32038": "29.9207_-82.6879", "32055": "30.2702_-82.6254", "32056": "30.1897_-82.6393", "32061": "30.0754_-82.5385", "34265": "27.1861_-81.8099", "34266": "27.1861_-81.8667", "34267": "27.1861_-81.8099", "34268": "27.1603_-81.8823", "34269": "27.0675_-81.9855", "32628": "29.6372_-83.2032", "32648": "29.4869_-83.2616", "32680": "29.6699_-83.005", "32692": "29.3295_-83.14", "32099": "30.3375_-81.7686", "32201": "30.3894_-81.6808", "32202": "30.3299_-81.6517", "32203": "30.3228_-81.547", "32204": "30.3189_-81.6854", "32205": "30.3172_-81.722", "32206": "30.3511_-81.6488", "32207": "30.2908_-81.6321", "32208": "30.3937_-81.6889", "32209": "30.3584_-81.692", "32210": "30.2687_-81.7473", "32211": "30.348_-81.5882", "32212": "30.2132_-81.69", "32214": "30.3449_-81.6831", "32216": "30.2787_-81.5831", "32217": "30.2407_-81.617", "32218": "30.4507_-81.6626", "32219": "30.4034_-81.7635", "32220": "30.329_-81.8176", "32221": "30.2837_-81.8202", "32222": "30.2292_-81.8131", "32223": "30.1548_-81.63", "32224": "30.3031_-81.4404", "32225": "30.351_-81.5061", "32226": "30.4735_-81.5448", "32227": "30.3802_-81.416", "32228": "30.3824_-81.4369", "32229": "30.3449_-81.6831", "32231": "30.3449_-81.6831", "32232": "30.3449_-81.6831", "32233": "30.3483_-81.4159", "32234": "30.2757_-81.9686", "32235": "30.3449_-81.6831", "32236": "30.3449_-81.6831", "32237": "30.3449_-81.6831", "32238": "30.3449_-81.6831", "32239": "30.3449_-81.6831", "32240": "30.2947_-81.3931", "32241": "30.3449_-81.6831", "32244": "30.2231_-81.7556", "32245": "30.3449_-81.6831", "32246": "30.2933_-81.5092", "32247": "30.3449_-81.6831", "32250": "30.2801_-81.4165", "32254": "30.3415_-81.7358", "32255": "30.3322_-81.6557", "32256": "30.2214_-81.5571", "32257": "30.1927_-81.605", "32258": "30.1459_-81.5739", "32266": "30.3155_-81.4051", "32277": "30.3704_-81.5864", "32501": "30.4223_-87.2248", "32502": "30.4095_-87.2229", "32503": "30.4564_-87.2104", "32504": "30.4873_-87.1872", "32505": "30.4481_-87.2589", "32506": "30.4129_-87.3092", "32507": "30.3737_-87.3126", "32508": "30.3511_-87.2749", "32509": "30.4643_-87.3403", "32511": "30.4061_-87.2917", "32512": "30.3943_-87.2991", "32513": "30.5571_-87.2596", "32514": "30.5241_-87.2167", "32516": "30.4213_-87.2169", "32520": "30.4124_-87.2035", "32521": "30.4213_-87.2169", "32522": "30.4213_-87.2169", "32523": "30.4213_-87.2169", "32524": "30.4213_-87.2169", "32526": "30.4756_-87.3179", "32533": "30.6143_-87.3251", "32534": "30.5301_-87.2793", "32535": "30.9687_-87.3216", "32559": "30.3563_-87.2773", "32560": "30.5818_-87.2929", "32568": "30.8686_-87.4539", "32577": "30.6902_-87.3852", "32591": "30.4213_-87.2169", "32110": "29.4562_-81.3244", "32135": "29.4661_-81.2828", "32136": "29.475_-81.1303", "32137": "29.5565_-81.219", "32142": "29.4661_-81.2828", "32143": "29.585_-81.2078", "32164": "29.4861_-81.2045", "32318": "30.4383_-84.2807", "32320": "29.7255_-85.0063", "32322": "29.8692_-84.6358", "32323": "29.8826_-84.5964", "32328": "29.7495_-84.8162", "32329": "29.726_-84.9856", "32324": "30.6834_-84.828", "32330": "30.5696_-84.7453", "32332": "30.6171_-84.6599", "32333": "30.6092_-84.4143", "32343": "30.485_-84.4768", "32351": "30.5867_-84.6094", "32352": "30.6512_-84.5866", "32353": "30.5497_-84.6069", "32619": "29.7837_-82.8711", "32693": "29.6133_-82.8176", "33471": "26.8327_-81.2188", "33944": "26.9464_-81.3091", "32456": "29.8119_-85.303", "32457": "29.8119_-85.303", "32465": "30.0933_-85.2048", "32052": "30.5029_-82.9322", "32053": "30.5482_-83.135", "32096": "30.3387_-82.7765", "33834": "27.6019_-81.8507", "33865": "27.4127_-81.928", "33873": "27.5517_-81.8074", "33890": "27.48_-81.7423", "33440": "26.7172_-80.9492", "33930": "26.5398_-81.4356", "33935": "26.7321_-81.434", "33975": "26.7633_-81.4388", "34601": "28.5658_-82.3737", "34602": "28.5093_-82.2957", "34603": "28.5642_-82.4165", "34604": "28.4409_-82.4612", "34605": "28.5059_-82.4226", "34606": "28.4655_-82.5981", "34607": "28.5065_-82.6267", "34608": "28.4797_-82.5562", "34609": "28.4794_-82.5083", "34611": "28.5642_-82.4165", "34613": "28.5466_-82.5213", "34614": "28.6622_-82.5236", "34636": "28.655_-82.2677", "34661": "28.6436_-82.2638", "33825": "27.6001_-81.5015", "33826": "27.5959_-81.5062", "33852": "27.2945_-81.3649", "33857": "27.415_-81.1965", "33862": "27.2931_-81.3629", "33870": "27.4924_-81.4357", "33871": "27.4858_-81.4079", "33872": "27.4703_-81.4872", "33875": "27.4676_-81.4581", "33876": "27.4287_-81.3519", "33960": "27.1203_-81.3909", "33503": "27.7648_-82.2734", "33508": "27.9318_-82.295", "33509": "27.9378_-82.2859", "33510": "27.9551_-82.2966", "33511": "27.9056_-82.2881", "33527": "27.992_-82.2138", "33530": "27.9068_-82.1767", "33534": "27.8411_-82.3698", "33547": "27.8293_-82.1357", "33548": "28.1385_-82.4821", "33549": "28.1367_-82.461", "33550": "27.9797_-82.3065", "33556": "28.1421_-82.5905", "33558": "28.1474_-82.5152", "33563": "28.013_-82.1339", "33564": "28.0296_-82.1347", "33565": "28.0699_-82.1576", "33566": "28.0094_-82.1138", "33567": "27.922_-82.1216", "33568": "27.872_-82.4388", "33569": "27.845_-82.3125", "33570": "27.7015_-82.4355", "33571": "27.7201_-82.453", "33572": "27.7716_-82.4102", "33573": "27.7147_-82.3538", "33575": "27.7144_-82.4291", "33579": "27.8024_-82.2755", "33583": "27.872_-82.4388", "33584": "27.9922_-82.2863", "33586": "27.6784_-82.4787", "33587": "27.9634_-82.2073", "33592": "28.0617_-82.3082", "33594": "27.9408_-82.242", "33595": "27.9379_-82.2364", "33596": "27.8925_-82.243", "33598": "27.7015_-82.3151", "33601": "27.9961_-82.582", "33602": "27.9614_-82.4597", "33603": "27.9845_-82.463", "33604": "28.0173_-82.4578", "33605": "27.9671_-82.4334", "33606": "27.9475_-82.4584", "33607": "27.9625_-82.4895", "33608": "27.8434_-82.4884", "33609": "27.9425_-82.5057", "33610": "27.9951_-82.4046", "33611": "27.8914_-82.5067", "33612": "28.0502_-82.45", "33613": "28.0772_-82.4455", "33614": "28.0091_-82.5034", "33615": "28.0081_-82.5805", "33616": "27.8742_-82.5203", "33617": "28.0384_-82.3949", "33618": "28.0763_-82.4852", "33619": "27.9382_-82.3756", "33620": "28.06_-82.4079", "33621": "27.8491_-82.4946", "33622": "27.9475_-82.4584", "33623": "27.9475_-82.4584", "33624": "28.079_-82.5268", "33625": "28.0726_-82.559", "33626": "28.0509_-82.6164", "33629": "27.921_-82.5079", "33630": "27.872_-82.4388", "33631": "27.872_-82.4388", "33633": "27.872_-82.4388", "33634": "28.0068_-82.556", "33635": "28.0301_-82.6048", "33637": "28.0338_-82.3659", "33646": "28.094_-82.4021", "33647": "28.1147_-82.3678", "33650": "27.872_-82.4388", "33655": "27.9475_-82.4584", "33660": "27.872_-82.4388", "33661": "27.872_-82.4388", "33662": "27.872_-82.4388", "33663": "27.872_-82.4388", "33664": "27.872_-82.4388", "33672": "27.9475_-82.4584", "33673": "27.872_-82.4388", "33674": "27.872_-82.4388", "33675": "27.872_-82.4388", "33677": "27.872_-82.4388", "33679": "27.872_-82.4388", "33680": "27.872_-82.4388", "33681": "27.872_-82.4388", "33682": "27.872_-82.4388", "33684": "27.872_-82.4388", "33685": "27.872_-82.4388", "33686": "27.872_-82.4388", "33687": "27.872_-82.4388", "33688": "27.872_-82.4388", "33689": "27.9475_-82.4584", "33694": "27.872_-82.4388", "32425": "30.8464_-85.69", "32452": "30.9821_-85.6185", "32455": "30.7041_-85.9546", "32464": "30.8747_-85.913", "32948": "27.7643_-80.6019", "32957": "27.8359_-80.4931", "32958": "27.7901_-80.4784", "32960": "27.633_-80.4031", "32961": "27.6175_-80.4231", "32962": "27.5885_-80.3923", "32963": "27.6898_-80.3757", "32964": "27.6386_-80.3973", "32965": "27.6386_-80.3973", "32966": "27.6372_-80.4794", "32967": "27.6972_-80.4416", "32968": "27.5999_-80.4382", "32969": "27.709_-80.5726", "32970": "27.7484_-80.4362", "32971": "27.7192_-80.4206", "32978": "27.709_-80.5726", "32420": "30.6412_-85.3756", "32423": "30.9514_-85.0972", "32426": "30.9563_-85.3766", "32431": "30.8004_-85.3847", "32432": "30.7158_-85.0784", "32440": "30.9426_-85.5136", "32442": "30.7148_-85.021", "32443": "30.8667_-85.1153", "32445": "30.9602_-85.1639", "32446": "30.7996_-85.2293", "32447": "30.7603_-85.2022", "32448": "30.6749_-85.2122", "32460": "30.7276_-84.9337", "32336": "30.3772_-83.8129", "32337": "30.4778_-84.0228", "32344": "30.5197_-83.8925", "32345": "30.5451_-83.8713", "32361": "30.3585_-83.9871", "32753": "28.883_-81.3087", "32013": "30.1941_-83.2913", "32066": "30.04_-83.1462", "32102": "29.165_-81.5399", "32158": "28.9175_-81.9229", "32159": "28.9299_-81.9256", "32702": "29.0219_-81.6323", "32726": "28.855_-81.6789", "32727": "28.8555_-81.6741", "32735": "28.8866_-81.7391", "32736": "28.9102_-81.5235", "32756": "28.8111_-81.6536", "32757": "28.774_-81.6439", "32767": "28.9993_-81.503", "32776": "28.8035_-81.5323", "32778": "28.801_-81.734", "32784": "28.9254_-81.6801", "34705": "28.7088_-81.7195", "34711": "28.5525_-81.7574", "34712": "28.5494_-81.7729", "34713": "28.5494_-81.7729", "34715": "28.6259_-81.7306", "34729": "28.6219_-81.7034", "34731": "28.8639_-81.8998", "34736": "28.5644_-81.8745", "34737": "28.6971_-81.7976", "34748": "28.808_-81.8858", "34749": "28.8108_-81.8779", "34753": "28.583_-81.8941", "34755": "28.5744_-81.7462", "34756": "28.5972_-81.6794", "34762": "28.7545_-81.9151", "34788": "28.8887_-81.7827", "34789": "28.8108_-81.8779", "34797": "28.7444_-81.8263", "33901": "26.6204_-81.8725", "33902": "26.6239_-81.8836", "33903": "26.693_-81.9125", "33904": "26.6065_-81.9502", "33905": "26.6693_-81.7605", "33906": "26.5529_-81.9486", "33907": "26.5681_-81.8736", "33908": "26.5025_-81.9276", "33909": "26.6939_-81.9452", "33910": "26.5529_-81.9486", "33911": "26.5963_-81.8824", "33912": "26.4972_-81.8246", "33913": "26.5228_-81.7065", "33914": "26.5557_-82.0206", "33915": "26.6599_-81.8934", "33916": "26.6466_-81.8429", "33917": "26.7357_-81.8435", "33918": "26.6673_-81.8801", "33919": "26.5567_-81.9034", "33920": "26.7147_-81.6351", "33921": "26.7545_-82.2611", "33922": "26.6627_-82.1401", "33924": "26.5215_-82.1802", "33928": "26.4351_-81.8102", "33929": "26.4381_-81.8068", "33931": "26.4527_-81.9501", "33932": "26.5529_-81.9486", "33936": "26.5936_-81.6619", "33945": "26.6583_-82.1434", "33956": "26.529_-82.0916", "33957": "26.4514_-82.0868", "33965": "26.4637_-81.7722", "33966": "26.5824_-81.832", "33970": "26.5647_-81.6208", "33971": "26.6388_-81.6992", "33972": "26.6492_-81.6167", "33974": "26.5677_-81.5954", "33976": "26.5952_-81.6849", "33990": "26.6265_-81.9677", "33991": "26.6281_-82.0182", "33993": "26.6786_-82.0254", "33994": "26.5529_-81.9486", "34133": "26.3398_-81.7787", "34134": "26.3626_-81.8183", "34135": "26.3771_-81.7334", "34136": "26.3398_-81.7787", "32301": "30.4286_-84.2593", "32302": "30.4383_-84.2807", "32303": "30.4874_-84.3189", "32304": "30.4478_-84.3211", "32305": "30.334_-84.287", "32306": "30.4425_-84.2986", "32307": "30.4257_-84.2877", "32308": "30.4771_-84.2246", "32309": "30.5422_-84.1413", "32310": "30.3991_-84.3298", "32311": "30.4156_-84.187", "32312": "30.5185_-84.2627", "32313": "30.4793_-84.3462", "32314": "30.4793_-84.3462", "32315": "30.4793_-84.3462", "32316": "30.4793_-84.3462", "32317": "30.4651_-84.1128", "32362": "30.3193_-84.2674", "32395": "30.4793_-84.3462", "32399": "30.4383_-84.2807", "32621": "29.461_-82.6356", "32625": "29.171_-83.0168", "32626": "29.4832_-82.8809", "32639": "29.2447_-82.7402", "32644": "29.4602_-82.8553", "32668": "29.2813_-82.4917", "32683": "29.3109_-82.7945", "32696": "29.3977_-82.4856", "34449": "29.0955_-82.6561", "34498": "29.0305_-82.719", "32321": "30.4223_-84.9466", "32334": "30.3639_-84.8054", "32335": "30.0206_-84.9806", "32360": "30.3511_-84.8203", "32059": "30.3979_-83.2844", "32331": "30.4512_-83.6474", "32340": "30.4802_-83.4067", "32341": "30.4776_-83.3914", "32350": "30.5997_-83.3405", "34201": "27.4047_-82.4705", "34202": "27.4067_-82.39", "34203": "27.4547_-82.5359", "34204": "27.4272_-82.4387", "34205": "27.4841_-82.5834", "34206": "27.4989_-82.5748", "34207": "27.4394_-82.5778", "34208": "27.4678_-82.512", "34209": "27.4759_-82.6167", "34210": "27.4544_-82.6358", "34211": "27.45_-82.3773", "34212": "27.4978_-82.4101", "34215": "27.4713_-82.6823", "34216": "27.5291_-82.7317", "34217": "27.4859_-82.7102", "34218": "27.4995_-82.7099", "34219": "27.5572_-82.396", "34220": "27.5214_-82.5723", "34221": "27.5429_-82.563", "34222": "27.5382_-82.5006", "34228": "27.4125_-82.659", "34243": "27.4072_-82.5303", "34250": "27.5722_-82.5832", "34251": "27.3648_-82.1849", "34260": "27.4272_-82.4387", "34264": "27.4475_-82.5462", "34270": "27.4054_-82.5435", "34280": "27.4272_-82.4387", "34281": "27.4272_-82.4387", "34282": "27.4272_-82.4387", "32111": "29.0607_-81.969", "32113": "29.3918_-82.1062", "32133": "29.0088_-81.9094", "32134": "29.391_-81.8551", "32179": "29.0643_-81.8857", "32182": "29.4856_-81.9589", "32183": "29.0597_-81.9051", "32192": "29.3268_-82.1046", "32195": "28.9782_-81.8932", "32617": "29.3048_-82.1262", "32634": "29.3509_-82.2765", "32663": "29.3424_-82.2126", "32664": "29.438_-82.2295", "32681": "29.4236_-82.2168", "32686": "29.3754_-82.244", "34420": "29.0531_-82.0375", "34421": "29.2407_-82.0875", "34430": "29.0491_-82.4609", "34431": "29.1392_-82.5328", "34432": "29.1015_-82.3413", "34470": "29.1989_-82.0874", "34471": "29.1605_-82.1288", "34472": "29.1253_-82.0086", "34473": "29.0058_-82.1828", "34474": "29.1565_-82.2095", "34475": "29.2573_-82.161", "34476": "29.1159_-82.2422", "34477": "29.1872_-82.1401", "34478": "29.1872_-82.1123", "34479": "29.2541_-82.1095", "34480": "29.1056_-82.098", "34481": "29.1281_-82.2975", "34482": "29.2611_-82.2195", "34483": "29.2407_-82.0875", "34488": "29.2635_-81.9532", "34489": "29.2152_-82.0972", "34491": "29.0112_-82.0325", "34492": "28.998_-82.0161", "33455": "27.0813_-80.1509", "33475": "27.0595_-80.1364", "34956": "27.0615_-80.4803", "34957": "27.2356_-80.2277", "34958": "27.2424_-80.2246", "34990": "27.1656_-80.2916", "34991": "27.1678_-80.2662", "34992": "27.1442_-80.2006", "34994": "27.1968_-80.2538", "34995": "27.1754_-80.2415", "34996": "27.1929_-80.2164", "34997": "27.1398_-80.2129", "33002": "25.8576_-80.2781", "33010": "25.8325_-80.2808", "33011": "25.8576_-80.2781", "33012": "25.8654_-80.3059", "33013": "25.8594_-80.2725", "33014": "25.8963_-80.3063", "33015": "25.9388_-80.3165", "33016": "25.8803_-80.3368", "33017": "25.8576_-80.2781", "33018": "25.9098_-80.3889", "33030": "25.4766_-80.4839", "33031": "25.5323_-80.5075", "33032": "25.5303_-80.3918", "33033": "25.4906_-80.438", "33034": "25.2846_-80.6246", "33035": "25.4573_-80.4572", "33039": "25.5021_-80.3997", "33054": "25.9097_-80.247", "33055": "25.9476_-80.2778", "33056": "25.942_-80.2456", "33090": "25.5584_-80.4582", "33092": "25.5584_-80.4582", "33101": "25.7791_-80.1978", "33102": "25.7743_-80.1937", "33106": "25.8527_-80.3012", "33109": "25.7588_-80.1376", "33111": "25.7743_-80.1937", "33114": "25.7215_-80.2684", "33116": "25.7743_-80.1937", "33119": "25.7845_-80.132", "33122": "25.8001_-80.281", "33124": "25.7743_-80.1937", "33125": "25.7825_-80.2341", "33126": "25.7763_-80.2919", "33127": "25.8143_-80.2051", "33128": "25.7756_-80.2089", "33129": "25.7559_-80.2013", "33130": "25.7672_-80.2059", "33131": "25.7629_-80.1895", "33132": "25.7867_-80.18", "33133": "25.7378_-80.2248", "33134": "25.768_-80.2714", "33135": "25.7664_-80.2317", "33136": "25.7864_-80.2042", "33137": "25.8156_-80.1897", "33138": "25.8521_-80.1821", "33139": "25.7873_-80.1564", "33140": "25.8198_-80.1337", "33141": "25.8486_-80.1446", "33142": "25.813_-80.232", "33143": "25.7022_-80.2978", "33144": "25.7626_-80.3096", "33145": "25.7539_-80.2253", "33146": "25.7205_-80.2728", "33147": "25.8507_-80.2366", "33149": "25.6921_-80.1625", "33150": "25.8512_-80.207", "33151": "25.8321_-80.2094", "33152": "25.7955_-80.3129", "33153": "25.8655_-80.1936", "33154": "25.7907_-80.13", "33155": "25.7392_-80.3103", "33156": "25.6682_-80.2973", "33157": "25.6062_-80.3426", "33158": "25.6364_-80.3187", "33160": "25.9449_-80.1391", "33161": "25.8934_-80.1758", "33162": "25.9286_-80.183", "33163": "25.945_-80.2145", "33164": "25.7743_-80.1937", "33165": "25.7343_-80.3588", "33166": "25.8301_-80.2926", "33167": "25.8856_-80.2292", "33168": "25.8902_-80.2101", "33169": "25.9441_-80.2144", "33170": "25.5584_-80.4582", "33172": "25.7735_-80.3572", "33173": "25.6992_-80.3618", "33174": "25.7628_-80.3611", "33175": "25.7341_-80.4068", "33176": "25.6574_-80.3627", "33177": "25.5968_-80.4046", "33178": "25.8141_-80.3549", "33179": "25.9571_-80.1814", "33180": "25.9597_-80.1403", "33181": "25.8965_-80.157", "33182": "25.7877_-80.4166", "33183": "25.7_-80.413", "33184": "25.7574_-80.403", "33185": "25.7274_-80.4497", "33186": "25.6694_-80.4085", "33187": "25.596_-80.507", "33188": "25.7743_-80.1937", "33189": "25.573_-80.3374", "33190": "25.5593_-80.3483", "33191": "25.7743_-80.1937", "33192": "25.7743_-80.1937", "33193": "25.6964_-80.4401", "33194": "25.5584_-80.4582", "33195": "25.7729_-80.187", "33196": "25.6615_-80.441", "33197": "25.7743_-80.1937", "33198": "25.7743_-80.1937", "33199": "25.7743_-80.1937", "33206": "25.7743_-80.1937", "33222": "25.7577_-80.3748", "33231": "25.7743_-80.1937", "33233": "25.7743_-80.1937", "33234": "25.7743_-80.1937", "33238": "25.7743_-80.1937", "33239": "25.7907_-80.13", "33242": "25.7743_-80.1937", "33243": "25.7743_-80.1937", "33245": "25.7743_-80.1937", "33247": "25.7743_-80.1937", "33255": "25.7743_-80.1937", "33256": "25.7743_-80.1937", "33257": "25.7743_-80.1937", "33261": "25.7743_-80.1937", "33265": "25.7743_-80.1937", "33266": "25.7743_-80.1937", "33269": "25.7743_-80.1937", "33280": "25.7743_-80.1937", "33283": "25.7743_-80.1937", "33296": "25.7743_-80.1937", "33299": "25.7743_-80.1937", "33001": "24.8306_-80.8049", "33036": "24.9233_-80.63", "33037": "25.0865_-80.4473", "33040": "24.5552_-81.7816", "33041": "24.5552_-81.7816", "33042": "24.667_-81.5099", "33043": "24.68_-81.362", "33045": "24.5552_-81.7816", "33050": "24.7279_-81.0386", "33051": "24.7234_-81.0203", "33052": "24.7233_-81.0632", "33070": "25.0108_-80.5218", "32009": "30.4193_-81.9724", "32011": "30.552_-81.8145", "32034": "30.6697_-81.4626", "32035": "30.6697_-81.4626", "32041": "30.6233_-81.5902", "32046": "30.6884_-81.9345", "32097": "30.6222_-81.5906", "32531": "30.8316_-86.677", "32536": "30.7644_-86.5917", "32537": "30.742_-86.6552", "32539": "30.7773_-86.4832", "32540": "30.3935_-86.4958", "32541": "30.3949_-86.4692", "32542": "30.5393_-86.6087", "32544": "30.4229_-86.6985", "32547": "30.4487_-86.6255", "32548": "30.4206_-86.6286", "32549": "30.4208_-86.6194", "32564": "30.7416_-86.7198", "32567": "30.9524_-86.4003", "32569": "30.4085_-86.7352", "32578": "30.5169_-86.4822", "32579": "30.4456_-86.5717", "32580": "30.5092_-86.5009", "32588": "30.6612_-86.5945", "34972": "27.4203_-80.9454", "34973": "27.2439_-80.8298", "34974": "27.2002_-80.841", "32703": "28.6354_-81.4888", "32704": "28.6762_-81.5119", "32709": "28.5462_-81.0116", "32710": "28.6128_-81.4987", "32712": "28.712_-81.5136", "32751": "28.6255_-81.3646", "32768": "28.6985_-81.5698", "32777": "28.765_-81.6306", "32789": "28.5978_-81.3534", "32790": "28.5663_-81.2608", "32792": "28.5974_-81.3036", "32793": "28.5663_-81.2608", "32794": "28.6278_-81.3631", "32798": "28.7194_-81.5762", "32801": "28.5399_-81.3727", "32802": "28.5383_-81.3792", "32803": "28.5559_-81.3535", "32804": "28.5754_-81.3955", "32805": "28.5302_-81.4045", "32806": "28.514_-81.357", "32807": "28.5515_-81.3051", "32808": "28.5803_-81.4396", "32809": "28.4637_-81.3948", "32810": "28.6214_-81.4294", "32811": "28.5163_-81.4516", "32812": "28.4998_-81.3288", "32814": "28.5702_-81.3265", "32816": "28.5663_-81.2608", "32817": "28.5891_-81.2277", "32818": "28.5801_-81.4846", "32819": "28.4522_-81.4678", "32820": "28.5725_-81.1219", "32821": "28.3957_-81.4666", "32822": "28.4944_-81.2902", "32824": "28.3932_-81.3622", "32825": "28.5469_-81.2571", "32826": "28.5826_-81.1907", "32827": "28.4317_-81.343", "32828": "28.5523_-81.1795", "32829": "28.4671_-81.2417", "32830": "28.3822_-81.569", "32831": "28.4656_-81.151", "32832": "28.3774_-81.1888", "32833": "28.5088_-81.0703", "32834": "28.5663_-81.2608", "32835": "28.5289_-81.4787", "32836": "28.4115_-81.525", "32837": "28.3949_-81.4179", "32839": "28.4871_-81.4082", "32853": "28.5663_-81.2608", "32854": "28.5663_-81.2608", "32855": "28.5383_-81.3792", "32856": "28.5484_-81.4201", "32857": "28.5663_-81.2608", "32858": "28.5663_-81.2608", "32859": "28.4429_-81.4026", "32860": "28.5663_-81.2608", "32861": "28.5663_-81.2608", "32862": "28.5383_-81.3792", "32867": "28.5663_-81.2608", "32868": "28.5663_-81.2608", "32869": "28.5663_-81.2608", "32872": "28.5383_-81.3792", "32877": "28.5663_-81.2608", "32878": "28.5663_-81.2608", "32885": "28.5456_-81.3782", "32886": "28.5383_-81.3792", "32887": "28.5663_-81.2608", "32891": "28.5663_-81.2608", "32896": "28.5419_-81.3791", "32897": "28.5383_-81.3792", "34734": "28.5384_-81.5208", "34740": "28.5454_-81.6507", "34760": "28.5547_-81.6322", "34761": "28.5837_-81.5326", "34777": "28.5416_-81.6058", "34778": "28.5653_-81.5862", "34786": "28.5006_-81.5354", "34787": "28.5423_-81.5911", "33848": "28.2774_-81.5069", "34739": "27.8767_-81.05", "34741": "28.3051_-81.4242", "34742": "28.3047_-81.4167", "34743": "28.3306_-81.3544", "34744": "28.3078_-81.3681", "34745": "28.3047_-81.4167", "34746": "28.268_-81.4675", "34747": "28.3037_-81.5898", "34758": "28.1984_-81.487", "34769": "28.248_-81.2876", "34770": "28.2489_-81.2812", "34771": "28.273_-81.2003", "34772": "28.1905_-81.2645", "34773": "28.1293_-81.0176", "33401": "26.7165_-80.0679", "33402": "26.7153_-80.0534", "33403": "26.8035_-80.0756", "33404": "26.7832_-80.0638", "33405": "26.67_-80.0582", "33406": "26.6396_-80.0827", "33407": "26.7492_-80.0725", "33408": "26.8289_-80.0603", "33409": "26.7162_-80.0965", "33410": "26.8234_-80.1387", "33411": "26.6644_-80.1741", "33412": "26.8055_-80.2482", "33413": "26.6555_-80.1596", "33414": "26.6587_-80.2414", "33415": "26.656_-80.126", "33416": "26.6654_-80.0929", "33417": "26.7197_-80.1248", "33418": "26.8234_-80.1387", "33419": "26.7153_-80.0534", "33420": "26.7153_-80.0534", "33421": "26.7084_-80.2306", "33422": "26.7153_-80.0534", "33424": "26.5253_-80.0664", "33425": "26.5253_-80.0664", "33426": "26.5175_-80.0834", "33427": "26.376_-80.1072", "33428": "26.3446_-80.2109", "33429": "26.3587_-80.0831", "33430": "26.6843_-80.6724", "33431": "26.3799_-80.0975", "33432": "26.3462_-80.0844", "33433": "26.3464_-80.1564", "33434": "26.3839_-80.1749", "33435": "26.5254_-80.061", "33436": "26.5354_-80.1124", "33437": "26.5312_-80.1418", "33438": "26.8592_-80.6337", "33444": "26.4564_-80.0793", "33445": "26.4564_-80.1054", "33446": "26.4517_-80.158", "33448": "26.4615_-80.0728", "33449": "26.6048_-80.2149", "33454": "26.6237_-80.1253", "33458": "26.9339_-80.1201", "33459": "26.6931_-80.8145", "33460": "26.6182_-80.056", "33461": "26.6232_-80.0946", "33462": "26.5747_-80.0794", "33463": "26.5955_-80.1291", "33464": "26.3587_-80.0831", "33465": "26.6283_-80.1326", "33466": "26.6171_-80.0723", "33467": "26.6104_-80.1683", "33468": "26.9342_-80.0942", "33469": "26.9831_-80.108", "33470": "26.7383_-80.276", "33472": "26.5384_-80.1856", "33473": "26.5088_-80.1896", "33474": "26.5253_-80.0664", "33476": "26.8142_-80.6629", "33477": "26.9217_-80.077", "33478": "26.9212_-80.2144", "33480": "26.7206_-80.0388", "33481": "26.3587_-80.0831", "33482": "26.4615_-80.0728", "33483": "26.4546_-80.0656", "33484": "26.4543_-80.1346", "33486": "26.3481_-80.1104", "33487": "26.4116_-80.0928", "33488": "26.3587_-80.0831", "33493": "26.6701_-80.7312", "33496": "26.403_-80.1813", "33497": "26.3587_-80.0831", "33498": "26.3907_-80.2161", "33499": "26.3587_-80.0831", "33523": "28.4247_-82.2185", "33524": "28.1822_-82.1523", "33525": "28.3318_-82.2446", "33526": "28.3101_-82.2478", "33537": "28.4658_-82.172", "33539": "28.213_-82.1657", "33540": "28.2151_-82.1506", "33541": "28.2311_-82.2057", "33542": "28.2303_-82.1779", "33543": "28.2397_-82.3279", "33544": "28.2397_-82.3279", "33545": "28.2697_-82.2903", "33559": "28.1801_-82.4169", "33574": "28.3348_-82.2693", "33576": "28.3371_-82.2882", "33578": "27.8633_-82.3499", "33593": "28.4625_-82.1948", "34610": "28.4079_-82.5398", "34637": "28.2782_-82.4625", "34638": "28.2478_-82.4962", "34639": "28.2258_-82.4547", "34652": "28.2326_-82.7327", "34653": "28.2444_-82.6986", "34654": "28.3022_-82.6264", "34655": "28.2129_-82.6807", "34656": "28.2442_-82.7193", "34667": "28.3648_-82.6757", "34668": "28.3011_-82.6927", "34669": "28.3506_-82.6288", "34673": "28.2717_-82.7195", "34674": "28.3644_-82.6934", "34679": "28.4302_-82.6616", "34680": "28.2167_-82.7223", "34690": "28.1913_-82.7279", "34691": "28.1913_-82.756", "34692": "28.188_-82.7346", "33701": "27.7723_-82.6386", "33702": "27.8427_-82.6448", "33703": "27.817_-82.6264", "33704": "27.7954_-82.6373", "33705": "27.7391_-82.6435", "33706": "27.7456_-82.7516", "33707": "27.7549_-82.7208", "33708": "27.8116_-82.8014", "33709": "27.8201_-82.7308", "33710": "27.7898_-82.7243", "33711": "27.7465_-82.6897", "33712": "27.7353_-82.6663", "33713": "27.789_-82.6779", "33714": "27.8176_-82.6776", "33715": "27.6705_-82.7119", "33716": "27.8738_-82.64", "33729": "27.8819_-82.6644", "33730": "27.7709_-82.6793", "33731": "27.8918_-82.7248", "33732": "27.8918_-82.7248", "33733": "27.7709_-82.6793", "33734": "27.8918_-82.7248", "33736": "27.8918_-82.7248", "33737": "27.8918_-82.7248", "33738": "27.8918_-82.7248", "33740": "27.8918_-82.7248", "33741": "27.8918_-82.7248", "33742": "27.8918_-82.7248", "33743": "27.8918_-82.7248", "33744": "27.8142_-82.7782", "33747": "27.8918_-82.7248", "33755": "27.9781_-82.7815", "33756": "27.947_-82.7943", "33757": "27.8918_-82.7248", "33758": "27.8918_-82.7248", "33759": "27.975_-82.7019", "33760": "27.9004_-82.7152", "33761": "28.031_-82.7239", "33762": "27.8942_-82.6746", "33763": "28.0173_-82.7461", "33764": "27.916_-82.7343", "33765": "27.9902_-82.7433", "33766": "27.8918_-82.7248", "33767": "27.9598_-82.8286", "33769": "27.8918_-82.7248", "33770": "27.917_-82.8027", "33771": "27.9085_-82.7568", "33772": "27.8466_-82.7954", "33773": "27.8802_-82.7534", "33774": "27.8839_-82.8265", "33775": "27.8397_-82.7912", "33776": "27.8505_-82.8263", "33777": "27.8688_-82.7344", "33778": "27.884_-82.8025", "33779": "27.8397_-82.7725", "33780": "27.8918_-82.7248", "33781": "27.8387_-82.7151", "33782": "27.8681_-82.7086", "33784": "27.8918_-82.7248", "33785": "27.8868_-82.8435", "33786": "27.9229_-82.8393", "34660": "28.067_-82.7784", "34677": "28.046_-82.6848", "34681": "28.0914_-82.7798", "34682": "28.0781_-82.7637", "34683": "28.0662_-82.7585", "34684": "28.0848_-82.7253", "34685": "28.0967_-82.6964", "34688": "28.1458_-82.6825", "34689": "28.1385_-82.743", "34695": "28.0096_-82.6967", "34697": "27.8918_-82.7248", "34698": "28.0284_-82.7794", "33801": "28.0381_-81.9392", "33802": "28.021_-81.9852", "33803": "28.014_-81.9523", "33804": "28.0395_-81.9498", "33805": "28.072_-81.9609", "33806": "28.0395_-81.9498", "33807": "28.0395_-81.9498", "33809": "28.1762_-81.9591", "33810": "28.1479_-82.0372", "33811": "27.9865_-82.0139", "33812": "27.9729_-81.8931", "33813": "27.9611_-81.9398", "33815": "28.0496_-82.0069", "33820": "28.0026_-81.6186", "33823": "28.0724_-81.8122", "33827": "27.8163_-81.5139", "33830": "27.8957_-81.8127", "33831": "27.8964_-81.8431", "33835": "27.6993_-81.9494", "33836": "28.1672_-81.6316", "33837": "28.1963_-81.6079", "33838": "28.0194_-81.6212", "33839": "27.9787_-81.7564", "33840": "28.0086_-81.9076", "33841": "27.7464_-81.7823", "33843": "27.7211_-81.5148", "33844": "28.1145_-81.6201", "33845": "28.0026_-81.6186", "33846": "27.9647_-81.8672", "33847": "27.8178_-81.8245", "33849": "28.1975_-82.0396", "33850": "28.0895_-81.7271", "33851": "28.0369_-81.628", "33853": "27.9002_-81.5847", "33854": "27.966_-81.6965", "33855": "27.798_-81.3572", "33856": "27.8557_-81.4309", "33858": "28.242_-81.5667", "33859": "27.8774_-81.6221", "33860": "27.902_-82.0015", "33863": "27.8903_-82.0315", "33867": "27.7686_-81.1966", "33868": "28.1987_-81.8083", "33877": "27.9769_-81.6144", "33880": "27.9873_-81.7625", "33881": "28.0452_-81.7325", "33882": "28.0294_-81.7321", "33883": "28.0222_-81.7329", "33884": "27.981_-81.6736", "33885": "28.0026_-81.6186", "33888": "28.0231_-81.7234", "33896": "28.2531_-81.6509", "33897": "28.3112_-81.6643", "33898": "27.8643_-81.5719", "33967": "26.4722_-81.8122", "34714": "28.4113_-81.7812", "34759": "28.0946_-81.499", "32007": "29.7996_-81.6273", "32112": "29.4272_-81.5579", "32131": "29.6609_-81.5879", "32138": "29.7277_-81.9184", "32139": "29.3842_-81.6183", "32140": "29.7581_-81.8622", "32147": "29.6227_-81.8137", "32148": "29.627_-81.8894", "32149": "29.6242_-81.8926", "32157": "29.4839_-81.5729", "32177": "29.6577_-81.6595", "32178": "29.6486_-81.6376", "32181": "29.5002_-81.5915", "32185": "29.7368_-81.958", "32187": "29.5888_-81.5921", "32189": "29.5594_-81.6406", "32193": "29.4905_-81.653", "32666": "29.7325_-82.0279", "33112": "25.7964_-80.3849", "32004": "30.2397_-81.3856", "32033": "29.7882_-81.462", "32080": "29.7964_-81.2649", "32081": "30.1204_-81.4128", "32082": "30.1223_-81.3627", "32084": "29.9175_-81.3668", "32085": "29.9377_-81.4206", "32086": "29.8285_-81.3237", "32092": "29.9475_-81.5264", "32095": "30.011_-81.4108", "32145": "29.7051_-81.4909", "32259": "30.0815_-81.5477", "32260": "29.9377_-81.4206", "34945": "27.4382_-80.444", "34946": "27.5008_-80.36", "34947": "27.4493_-80.3592", "34948": "27.3822_-80.409", "34949": "27.3896_-80.2615", "34950": "27.4486_-80.3385", "34951": "27.5391_-80.4052", "34952": "27.2889_-80.298", "34953": "27.2625_-80.3793", "34954": "27.3822_-80.409", "34979": "27.3822_-80.409", "34981": "27.4049_-80.3623", "34982": "27.3908_-80.3246", "34983": "27.3094_-80.345", "34984": "27.2655_-80.3389", "34985": "27.2939_-80.3503", "34986": "27.3215_-80.403", "34987": "27.2606_-80.4771", "34988": "27.3868_-80.5037", "32530": "30.5986_-87.0315", "32561": "30.3571_-87.1639", "32562": "30.3571_-87.1639", "32563": "30.3962_-87.0274", "32565": "30.8985_-87.1332", "32566": "30.4212_-86.8926", "32570": "30.6604_-87.0473", "32571": "30.6698_-87.1794", "32572": "30.6592_-87.0497", "32583": "30.5761_-87.0663", "34223": "26.9667_-82.3599", "34224": "26.92_-82.3048", "34229": "27.1838_-82.4853", "34230": "27.335_-82.5372", "34231": "27.2666_-82.5163", "34232": "27.3262_-82.4724", "34233": "27.2866_-82.477", "34234": "27.3688_-82.5268", "34235": "27.3672_-82.4848", "34236": "27.3269_-82.5433", "34237": "27.3369_-82.5128", "34238": "27.2427_-82.4751", "34239": "27.3111_-82.5195", "34240": "27.339_-82.3473", "34241": "27.2822_-82.4181", "34242": "27.2566_-82.5398", "34249": "27.2664_-82.4841", "34272": "27.147_-82.4255", "34274": "27.144_-82.4645", "34275": "27.1384_-82.4518", "34276": "27.3364_-82.5307", "34277": "27.3364_-82.5307", "34278": "27.3316_-82.5285", "34284": "27.1675_-82.381", "34285": "27.0933_-82.4498", "34286": "27.0748_-82.1756", "34287": "27.0478_-82.2416", "34288": "27.0498_-82.1288", "34289": "27.0808_-82.1516", "34290": "27.0459_-82.2491", "34291": "27.0997_-82.2095", "34292": "27.09_-82.37", "34293": "27.0606_-82.352", "34295": "27.086_-82.4389", "32701": "28.6666_-81.365", "32707": "28.6617_-81.3122", "32708": "28.6831_-81.2814", "32714": "28.6625_-81.4117", "32715": "28.6611_-81.3656", "32716": "28.7448_-81.2233", "32718": "28.7448_-81.2233", "32719": "28.7448_-81.2233", "32730": "28.6513_-81.3418", "32732": "28.7503_-81.1114", "32733": "28.6133_-81.2581", "32746": "28.7577_-81.3508", "32747": "28.8272_-81.3329", "32750": "28.712_-81.3552", "32752": "28.7448_-81.2233", "32762": "28.7448_-81.2233", "32765": "28.6513_-81.2066", "32766": "28.6607_-81.1134", "32771": "28.8013_-81.285", "32772": "28.8072_-81.2502", "32773": "28.7644_-81.282", "32779": "28.7168_-81.4126", "32791": "28.7448_-81.2233", "32795": "28.7448_-81.2233", "32799": "28.7448_-81.2233", "32162": "28.9341_-81.9599", "32163": "28.9338_-81.9914", "33513": "28.6611_-82.1553", "33514": "28.6635_-81.9963", "33521": "28.7997_-82.0701", "33538": "28.7953_-82.1363", "33585": "28.7356_-82.0616", "33597": "28.549_-82.0805", "34484": "28.9059_-82.0612", "34785": "28.8454_-82.0347", "32008": "29.9395_-82.8993", "32060": "30.1759_-83.0304", "32062": "30.1509_-82.9662", "32064": "30.2956_-82.9844", "32071": "30.0381_-82.93", "32094": "30.1796_-82.8505", "32347": "30.1668_-83.616", "32348": "29.9665_-83.6594", "32356": "29.8539_-83.4421", "32357": "30.288_-83.6318", "32359": "29.6739_-83.3723", "32026": "30.0699_-82.1927", "32054": "30.0035_-82.3828", "32083": "30.0704_-82.2001", "32697": "29.9315_-82.4255", "32105": "29.2005_-81.4065", "32114": "29.2012_-81.0371", "32115": "29.2108_-81.0228", "32116": "29.1091_-80.9843", "32117": "29.2353_-81.0658", "32118": "29.2219_-81.0095", "32119": "29.16_-81.0269", "32120": "29.2108_-81.0228", "32121": "29.2108_-81.0228", "32122": "29.2108_-81.0228", "32123": "29.1383_-80.9956", "32124": "29.1419_-81.1402", "32125": "29.2108_-81.0228", "32126": "29.2108_-81.0228", "32127": "29.1383_-80.9956", "32128": "29.1383_-80.9956", "32129": "29.1372_-81.0241", "32130": "29.1166_-81.3488", "32132": "28.9818_-80.9103", "32141": "28.9455_-80.8969", "32168": "29.0247_-80.9584", "32169": "29.0172_-80.8885", "32170": "29.0258_-80.927", "32173": "29.2858_-81.0559", "32174": "29.2833_-81.0882", "32175": "29.2858_-81.0559", "32176": "29.3222_-81.0584", "32180": "29.2226_-81.4353", "32190": "29.3201_-81.5279", "32198": "29.2108_-81.0228", "32706": "28.9664_-81.2371", "32713": "28.8846_-81.3065", "32720": "29.0266_-81.3349", "32721": "28.9973_-81.2995", "32722": "29.0861_-81.3542", "32723": "29.0275_-81.3068", "32724": "29.0422_-81.2863", "32725": "28.8989_-81.2473", "32728": "29.0227_-81.1722", "32738": "28.9093_-81.1922", "32739": "29.0227_-81.1722", "32744": "28.9806_-81.2334", "32745": "28.7676_-81.3522", "32759": "28.87_-80.8551", "32763": "28.9453_-81.2995", "32764": "28.8426_-81.1562", "32774": "28.9489_-81.2987", "32326": "30.176_-84.3752", "32327": "30.2108_-84.3205", "32346": "30.0153_-84.3912", "32355": "30.1631_-84.2083", "32358": "30.0714_-84.4549", "32422": "30.7056_-86.0314", "32433": "30.8494_-86.2023", "32434": "30.7432_-86.3149", "32435": "30.721_-86.1152", "32439": "30.4896_-86.1684", "32459": "30.3659_-86.2458", "32461": "30.2835_-86.0305", "32538": "30.9709_-86.3111", "32550": "30.385_-86.3473", "32427": "30.7123_-85.8014", "32428": "30.7107_-85.5486", "32437": "30.4352_-85.8881", "32462": "30.6267_-85.7553", "32463": "30.6321_-85.5888", "31513": "31.7837_-82.3486", "31515": "31.7783_-82.3485", "31562": "30.5224_-82.0376", "31563": "31.6489_-82.1982", "31624": "31.3035_-82.7319", "31642": "31.3106_-82.8591", "31650": "31.3455_-83.0449", "31510": "31.5465_-82.4633", "31721": "31.5105_-84.3087", "39837": "31.173_-84.731", "39841": "31.2984_-84.7175", "39845": "31.0505_-84.8801", "39862": "31.4849_-84.5128", "39870": "31.3164_-84.3367", "31034": "33.0227_-83.247", "31059": "33.0846_-83.238", "31061": "33.08_-83.2379", "31062": "33.0491_-83.2174", "30511": "34.4574_-83.476", "30547": "34.3563_-83.4974", "30558": "34.2529_-83.5616", "30011": "34.0191_-83.8261", "30620": "33.9261_-83.7282", "30666": "33.9602_-83.5893", "30680": "33.9985_-83.7115", "30103": "34.3595_-84.9176", "30120": "34.187_-84.8204", "30121": "34.2079_-84.7673", "30123": "34.2442_-84.8457", "30137": "34.12_-84.757", "30145": "34.2501_-84.9973", "30171": "34.3379_-84.7376", "30178": "34.1229_-84.9739", "30184": "34.2717_-84.7383", "31750": "31.7248_-83.2495", "39840": "31.7706_-84.7936", "31622": "31.394_-83.2132", "31639": "31.2074_-83.2319", "31645": "31.0825_-83.2143", "31749": "31.3736_-83.3552", "31052": "32.7773_-83.825", "31201": "32.8095_-83.6168", "31202": "32.8407_-83.6324", "31203": "32.8067_-83.6913", "31204": "32.8424_-83.6766", "31205": "32.8067_-83.6913", "31206": "32.7914_-83.679", "31207": "32.8304_-83.6486", "31208": "32.8067_-83.6913", "31209": "32.8067_-83.6913", "31210": "32.8926_-83.7455", "31211": "32.8869_-83.6021", "31213": "32.8393_-83.6388", "31216": "32.7486_-83.7477", "31217": "32.8118_-83.565", "31220": "32.8595_-83.802", "31221": "32.8407_-83.6324", "31294": "32.8407_-83.6324", "31295": "32.8102_-83.569", "31296": "32.8067_-83.6913", "31297": "32.7004_-83.6572", "31014": "32.3981_-83.3229", "31542": "31.1431_-82.1207", "31543": "31.3199_-81.9596", "31553": "31.1827_-81.9722", "31566": "31.2448_-81.8039", "31625": "31.0074_-83.5219", "31629": "30.7722_-83.6792", "31638": "30.9416_-83.4993", "31643": "30.7797_-83.5567", "31720": "30.8902_-83.7407", "31308": "32.1273_-81.4983", "31321": "32.1812_-81.6656", "31324": "31.8962_-81.294", "30415": "32.294_-81.628", "30450": "32.555_-81.9123", "30452": "32.3382_-81.8728", "30458": "32.4408_-81.774", "30459": "32.447_-81.7777", "30460": "32.4179_-81.7823", "30461": "32.45_-81.7158", "30426": "33.0437_-81.7106", "30441": "32.8638_-82.2042", "30456": "32.9809_-81.773", "30811": "33.0918_-82.2265", "30816": "33.1719_-82.1834", "30830": "33.1013_-81.9908", "30216": "33.25_-83.9079", "30233": "33.282_-83.9784", "30234": "33.3224_-84.0287", "39842": "31.7703_-84.5238", "39866": "31.5374_-84.5994", "39886": "31.7608_-84.6092", "31547": "30.7906_-81.5607", "31548": "30.7977_-81.7075", "31558": "30.7305_-81.5465", "31565": "31.0427_-81.5697", "31568": "30.9952_-81.7782", "31569": "30.9437_-81.6783", "30439": "32.401_-82.0607", "30451": "32.3902_-81.9568", "30108": "33.5373_-85.2533", "30109": "33.6534_-85.1362", "30112": "33.5809_-85.0792", "30116": "33.6045_-85.0499", "30117": "33.5798_-85.0812", "30118": "33.5712_-85.0961", "30119": "33.6189_-85.0736", "30150": "33.643_-85.1818", "30170": "33.4322_-85.1671", "30179": "33.7677_-85.0133", "30180": "33.7173_-84.9297", "30185": "33.5111_-84.9254", "30726": "34.9765_-85.1413", "30736": "34.9205_-85.1549", "30742": "34.9506_-85.2432", "31537": "30.8508_-82.0116", "31302": "32.1177_-81.3085", "31322": "32.1149_-81.252", "31328": "32.0068_-80.8509", "31401": "32.0749_-81.0883", "31402": "32.0835_-81.0998", "31403": "31.9714_-81.0716", "31404": "32.0543_-81.0492", "31405": "32.0391_-81.1242", "31406": "31.989_-81.0979", "31407": "32.1491_-81.1632", "31408": "32.1082_-81.1746", "31409": "32.0093_-81.157", "31410": "32.0175_-80.997", "31411": "31.9268_-81.0381", "31412": "32.0835_-81.0998", "31414": "31.9714_-81.0716", "31415": "32.0753_-81.1289", "31416": "32.0053_-81.0477", "31418": "31.9714_-81.0716", "31419": "31.9959_-81.2358", "31420": "31.9714_-81.0716", "31421": "31.9714_-81.0716", "31805": "32.299_-84.7645", "30730": "34.403_-85.4038", "30731": "34.5864_-85.4774", "30747": "34.4859_-85.3362", "30753": "34.5468_-85.3112", "30107": "34.3393_-84.3758", "30114": "34.2505_-84.4909", "30115": "34.1993_-84.4199", "30142": "34.174_-84.5013", "30146": "34.2429_-84.4583", "30151": "34.382_-84.371", "30169": "34.234_-84.4904", "30183": "34.3217_-84.562", "30188": "34.106_-84.5117", "30189": "34.1281_-84.5717", "30601": "33.9761_-83.3632", "30602": "33.9433_-83.3724", "30603": "33.9609_-83.3779", "30604": "33.9443_-83.3891", "30605": "33.9321_-83.3525", "30606": "33.9461_-83.418", "30607": "34.007_-83.4278", "30608": "33.9443_-83.3891", "30609": "33.9464_-83.3774", "30612": "33.9443_-83.3891", "30683": "33.9543_-83.2906", "39823": "31.3791_-84.9353", "39824": "31.52_-84.867", "39836": "31.6726_-84.8903", "39846": "31.5607_-84.7381", "39851": "31.6264_-85.0548", "39854": "31.8854_-85.1059", "39867": "31.8343_-84.9255", "30236": "33.5242_-84.359", "30237": "33.5007_-84.3513", "30238": "33.4944_-84.3797", "30250": "33.4429_-84.3136", "30260": "33.5849_-84.3247", "30273": "33.5808_-84.2782", "30274": "33.5531_-84.4003", "30287": "33.5007_-84.3513", "30288": "33.6369_-84.3371", "30294": "33.6166_-84.2939", "30296": "33.5667_-84.4364", "30297": "33.6115_-84.3745", "30298": "33.5007_-84.3513", "31623": "31.0744_-82.644", "31630": "30.9885_-82.8715", "31631": "30.6819_-82.5665", "31634": "31.0509_-82.7613", "30006": "33.9526_-84.5499", "30007": "33.9125_-84.5572", "30008": "33.8972_-84.592", "30060": "33.9382_-84.5403", "30061": "33.9328_-84.556", "30062": "34.0025_-84.4633", "30063": "33.9653_-84.5112", "30064": "33.9343_-84.6076", "30065": "33.9125_-84.5572", "30066": "34.0378_-84.5038", "30067": "33.9282_-84.4733", "30068": "33.9679_-84.4385", "30069": "33.9125_-84.5572", "30080": "33.8796_-84.5023", "30081": "33.8588_-84.7106", "30082": "33.8631_-84.5382", "30090": "33.9525_-84.5471", "30101": "34.0756_-84.6477", "30102": "34.0707_-84.5894", "30106": "33.8369_-84.6307", "30111": "33.9125_-84.5572", "30126": "33.8332_-84.6031", "30127": "33.9135_-84.6859", "30144": "34.0287_-84.6047", "30152": "33.9951_-84.6544", "30156": "34.0177_-84.625", "30160": "34.0177_-84.625", "30168": "33.7838_-84.5952", "31144": "34.0233_-84.6156", "31512": "31.5367_-82.9976", "31519": "31.6484_-82.905", "31533": "31.4973_-82.8465", "31534": "31.5088_-82.8499", "31535": "31.4551_-82.8561", "31554": "31.4498_-82.6032", "31567": "31.6143_-82.7243", "31722": "31.0682_-83.6238", "31744": "31.3136_-83.9253", "31747": "31.1789_-83.5889", "31753": "31.2054_-83.8776", "31756": "31.2173_-83.9704", "31768": "31.1792_-83.7641", "31771": "31.2462_-83.6549", "31776": "31.1727_-83.7924", "31788": "31.0855_-83.6821", "30802": "33.6271_-82.2856", "30809": "33.5412_-82.1398", "30813": "33.4504_-82.1982", "30814": "33.417_-82.3097", "30917": "33.5277_-82.2355", "39813": "31.442_-84.7241", "31620": "31.1251_-83.4213", "31627": "31.0403_-83.3915", "31637": "31.2664_-83.4481", "31647": "31.179_-83.4476", "30220": "33.2473_-84.835", "30229": "33.2322_-84.5685", "30259": "33.2734_-84.7566", "30263": "33.3696_-84.8194", "30264": "33.361_-84.8142", "30265": "33.3958_-84.7121", "30271": "33.3514_-84.7561", "30275": "33.4299_-84.8744", "30276": "33.2845_-84.5918", "30277": "33.4013_-84.654", "30289": "33.326_-84.6371", "31050": "32.7243_-83.9977", "31066": "32.8202_-84.0456", "31078": "32.7222_-84.0451", "31010": "31.9172_-83.7854", "31015": "31.9566_-83.7835", "31712": "31.8496_-83.7277", "30738": "34.8139_-85.5019", "30752": "34.9017_-85.5171", "30757": "34.9779_-85.4305", "30534": "34.4537_-84.155", "39815": "30.7493_-84.4846", "39818": "30.8845_-84.5655", "39819": "30.9039_-84.569", "39852": "30.8024_-84.5471", "30002": "33.7717_-84.2607", "30021": "33.8101_-84.2388", "30030": "33.7699_-84.295", "30031": "33.7748_-84.2963", "30032": "33.7408_-84.2632", "30033": "33.8123_-84.2819", "30034": "33.6954_-84.2489", "30035": "33.7278_-84.2143", "30036": "33.7748_-84.2963", "30037": "33.7748_-84.2963", "30038": "33.6823_-84.161", "30058": "33.7356_-84.1009", "30072": "33.7906_-84.2053", "30074": "33.7454_-84.1316", "30079": "33.7934_-84.2585", "30083": "33.7942_-84.2018", "30084": "33.857_-84.216", "30085": "33.8545_-84.2171", "30086": "33.8913_-84.0746", "30087": "33.8082_-84.1702", "30088": "33.758_-84.1802", "30319": "33.8687_-84.3351", "30322": "33.7952_-84.3248", "30329": "33.8236_-84.3214", "30333": "33.8913_-84.0746", "30340": "33.8932_-84.2539", "30341": "33.8879_-84.2905", "30345": "33.8513_-84.287", "30346": "33.9267_-84.3334", "30350": "33.9795_-84.3411", "30356": "33.8913_-84.0746", "30359": "33.8913_-84.0746", "30360": "33.9378_-84.2716", "30362": "33.8913_-84.0746", "30366": "33.8913_-84.0746", "31119": "33.8913_-84.0746", "31141": "33.8913_-84.0746", "31145": "33.8913_-84.0746", "31146": "33.8913_-84.0746", "39901": "33.8913_-84.0746", "31011": "32.1046_-83.0646", "31012": "32.3982_-83.174", "31023": "32.2084_-83.186", "31077": "31.938_-83.1837", "31007": "32.189_-83.9332", "31051": "32.1471_-83.8774", "31063": "32.3026_-84.0041", "31070": "32.1967_-83.7209", "31091": "32.2558_-83.7447", "31092": "32.0913_-83.7922", "31701": "31.5678_-84.1619", "31702": "31.5948_-84.1948", "31703": "31.5785_-84.1557", "31704": "31.55_-84.0612", "31705": "31.5464_-84.0783", "31706": "31.5593_-84.1765", "31707": "31.5789_-84.2118", "31708": "31.5911_-84.1324", "31782": "31.5431_-84.2196", "30122": "33.7655_-84.6469", "30133": "33.6897_-84.7446", "30134": "33.7606_-84.7477", "30135": "33.6989_-84.7454", "30154": "33.7515_-84.7477", "30187": "33.6634_-84.8639", "39832": "31.1745_-85.037", "39834": "30.8757_-84.445", "31648": "30.7065_-83.019", "31303": "32.5126_-81.3086", "31307": "32.1736_-81.3992", "31312": "32.314_-81.3896", "31318": "32.1499_-81.3722", "31326": "32.296_-81.2354", "31329": "32.3697_-81.3618", "30624": "34.1919_-83.0284", "30634": "34.1853_-82.9434", "30635": "34.1082_-82.8448", "30401": "32.5699_-82.3462", "30425": "32.6549_-82.1002", "30447": "32.5041_-82.4848", "30448": "32.4759_-82.3726", "30464": "32.4421_-82.2151", "30471": "32.6129_-82.1979", "31002": "32.5635_-82.5695", "30414": "32.1524_-81.9743", "30417": "32.165_-81.908", "30423": "32.1519_-81.8346", "30429": "32.156_-81.9337", "30513": "34.8555_-84.3281", "30541": "34.9129_-84.5391", "30555": "34.9739_-84.4291", "30559": "34.9341_-84.2541", "30560": "34.8714_-84.2115", "30205": "33.2984_-84.4769", "30214": "33.4679_-84.4806", "30215": "33.3943_-84.4738", "30269": "33.3915_-84.5635", "30290": "33.4719_-84.5914", "31169": "33.3967_-84.5958", "30105": "34.4411_-85.1843", "30124": "34.1167_-85.3379", "30129": "34.3333_-85.2337", "30147": "34.1707_-85.1825", "30149": "34.2804_-85.1821", "30161": "34.2507_-85.1465", "30162": "34.2905_-85.2138", "30163": "34.3333_-85.2337", "30164": "34.3333_-85.2337", "30165": "34.2837_-85.2231", "30172": "34.3333_-85.2337", "30173": "34.1593_-85.1429", "30028": "34.2897_-84.1796", "30040": "34.2321_-84.158", "30041": "34.2037_-84.1031", "30520": "34.3478_-83.1267", "30521": "34.3631_-83.2547", "30553": "34.4528_-83.113", "30639": "34.2743_-83.147", "30662": "34.2778_-83.1406", "30004": "34.1124_-84.302", "30005": "34.0782_-84.2281", "30009": "34.077_-84.3033", "30022": "34.0268_-84.2422", "30023": "34.0754_-84.2941", "30075": "34.0408_-84.3859", "30076": "34.0213_-84.3104", "30077": "34.0232_-84.3616", "30213": "33.5648_-84.5809", "30268": "33.5242_-84.679", "30272": "33.6259_-84.5163", "30291": "33.5832_-84.5499", "30301": "33.8444_-84.4741", "30302": "33.749_-84.388", "30303": "33.7525_-84.3888", "30304": "33.8482_-84.4293", "30305": "33.832_-84.3851", "30306": "33.786_-84.3514", "30307": "33.7691_-84.336", "30308": "33.7718_-84.3757", "30309": "33.7984_-84.3883", "30310": "33.7278_-84.4232", "30311": "33.723_-84.4702", "30312": "33.7467_-84.3781", "30313": "33.7683_-84.3935", "30314": "33.7561_-84.4255", "30315": "33.7051_-84.3808", "30316": "33.7217_-84.3339", "30317": "33.7498_-84.3169", "30318": "33.7865_-84.4454", "30320": "33.6568_-84.4236", "30321": "33.749_-84.388", "30324": "33.8206_-84.3549", "30325": "33.8444_-84.4741", "30326": "33.8482_-84.3582", "30327": "33.8627_-84.42", "30328": "33.9335_-84.3958", "30331": "33.7224_-84.5205", "30332": "33.7763_-84.398", "30334": "33.7489_-84.3872", "30336": "33.7406_-84.5545", "30337": "33.6428_-84.4618", "30338": "33.9669_-84.3249", "30339": "33.8713_-84.4629", "30342": "33.8842_-84.3761", "30343": "33.749_-84.388", "30344": "33.6919_-84.448", "30348": "33.8444_-84.4741", "30349": "33.6053_-84.4813", "30353": "33.749_-84.388", "30354": "33.6675_-84.3896", "30355": "33.8444_-84.4741", "30357": "33.8444_-84.4741", "30358": "33.749_-84.388", "30361": "33.8444_-84.4741", "30363": "33.791_-84.3992", "30364": "33.8444_-84.4741", "30368": "33.8444_-84.4741", "30369": "33.8444_-84.4741", "30370": "33.749_-84.388", "30371": "33.8444_-84.4741", "30374": "33.749_-84.388", "30375": "33.8444_-84.4741", "30377": "33.8444_-84.4741", "30378": "33.8444_-84.4741", "30380": "33.8444_-84.4741", "30384": "33.8444_-84.4741", "30385": "33.8444_-84.4741", "30388": "33.8444_-84.4741", "30392": "33.749_-84.388", "30394": "33.749_-84.388", "30396": "33.8444_-84.4741", "30398": "33.8444_-84.4741", "31106": "33.8444_-84.4741", "31107": "33.8444_-84.4741", "31126": "33.8444_-84.4741", "31131": "33.8444_-84.4741", "31136": "33.7473_-84.3824", "31139": "33.8444_-84.4741", "31150": "33.8444_-84.4741", "31156": "33.8444_-84.4741", "31192": "33.8444_-84.4741", "31193": "33.8444_-84.4741", "31195": "33.8444_-84.4741", "31196": "33.8444_-84.4741", "30522": "34.7804_-84.3908", "30536": "34.655_-84.3554", "30539": "34.684_-84.4727", "30540": "34.6775_-84.4812", "30810": "33.2471_-82.5766", "30820": "33.2052_-82.6817", "31520": "31.1807_-81.4949", "31521": "31.15_-81.4915", "31522": "31.23_-81.3502", "31523": "31.2189_-81.546", "31524": "31.222_-81.4826", "31525": "31.2804_-81.5305", "31527": "31.074_-81.4128", "31561": "31.1989_-81.3322", "30139": "34.4362_-84.6999", "30701": "34.4965_-84.9345", "30703": "34.5026_-84.9511", "30732": "34.569_-84.7119", "30733": "34.4145_-85.0312", "30734": "34.5404_-84.727", "30735": "34.5833_-84.9068", "30746": "34.5519_-85.026", "39827": "30.9528_-84.2069", "39829": "30.7462_-84.3125", "39897": "30.8836_-84.3246", "30642": "33.5637_-83.1702", "30665": "33.5368_-83.081", "30669": "33.6345_-83.0879", "30678": "33.4581_-83.0802", "30003": "33.9604_-84.0379", "30010": "33.9604_-84.0379", "30017": "33.8901_-83.9632", "30019": "33.9883_-83.8795", "30024": "34.0425_-84.0262", "30026": "33.9792_-84.1263", "30029": "33.9792_-84.1263", "30039": "33.8178_-84.0229", "30042": "33.9295_-84.1032", "30043": "34.0031_-84.0126", "30044": "33.9418_-84.0706", "30045": "33.9367_-83.9573", "30046": "33.9496_-83.9942", "30047": "33.8656_-84.0725", "30048": "33.9604_-84.0379", "30049": "33.9495_-83.9922", "30052": "33.8769_-83.8968", "30071": "33.9381_-84.1972", "30078": "33.8635_-84.0081", "30091": "33.9604_-84.0379", "30092": "33.9701_-84.2216", "30093": "33.906_-84.184", "30095": "34.0256_-84.1304", "30096": "33.9845_-84.1529", "30097": "34.026_-84.147", "30098": "33.9604_-84.0379", "30099": "33.9595_-84.105", "30515": "33.9604_-84.0379", "30518": "34.1124_-83.9965", "30519": "34.0797_-83.9308", "30510": "34.4591_-83.602", "30523": "34.645_-83.5243", "30531": "34.5209_-83.5453", "30535": "34.5756_-83.5696", "30563": "34.5678_-83.4713", "30580": "34.6766_-83.4358", "30501": "34.3073_-83.8256", "30502": "34.213_-83.7949", "30503": "34.3454_-83.9505", "30504": "34.2723_-83.8793", "30506": "34.3562_-83.8882", "30507": "34.2591_-83.7716", "30527": "34.4761_-83.7853", "30542": "34.1819_-83.9024", "30543": "34.3001_-83.6757", "30554": "34.3876_-83.6663", "30564": "34.4342_-83.8949", "30566": "34.2372_-83.894", "31087": "33.2571_-83.0892", "30110": "33.7309_-85.1286", "30113": "33.8283_-85.1506", "30140": "33.8823_-85.2349", "30176": "33.7602_-85.3", "30182": "33.684_-85.2197", "31804": "32.6242_-84.9207", "31807": "32.6312_-84.7895", "31811": "32.7418_-84.8848", "31822": "32.8735_-84.896", "31823": "32.8226_-84.8204", "31826": "32.8101_-84.696", "31831": "32.6793_-84.7425", "30516": "34.3996_-83.0484", "30643": "34.3571_-82.9296", "30217": "33.278_-85.134", "30228": "33.4124_-84.2947", "30248": "33.3449_-84.0982", "30252": "33.4768_-84.055", "30253": "33.451_-84.1544", "30281": "33.5633_-84.2165", "31005": "32.546_-83.6047", "31013": "32.3386_-83.6926", "31025": "32.3336_-83.7304", "31028": "32.6344_-83.6768", "31047": "32.4672_-83.6128", "31069": "32.4605_-83.7283", "31088": "32.5934_-83.6416", "31093": "32.6368_-83.6395", "31095": "32.4874_-83.6697", "31098": "32.6181_-83.5739", "31099": "32.6462_-83.6513", "31760": "31.7063_-83.4086", "31769": "31.6209_-83.2498", "31774": "31.5929_-83.2565", "31798": "31.5952_-83.1075", "30517": "34.1389_-83.7812", "30529": "34.2134_-83.448", "30530": "34.1683_-83.4022", "30548": "34.0866_-83.7803", "30549": "34.1062_-83.5708", "30565": "34.097_-83.421", "30567": "34.1796_-83.6634", "30575": "34.1951_-83.7187", "30599": "34.204_-83.4571", "30055": "33.4314_-83.7908", "31038": "33.1421_-83.6404", "31064": "33.3118_-83.714", "31085": "33.435_-83.6269", "31532": "31.7226_-82.7526", "31539": "31.8606_-82.5909", "30413": "32.8632_-82.4708", "30434": "33.0163_-82.3836", "30477": "32.8747_-82.4025", "30803": "33.141_-82.515", "30818": "33.2652_-82.3294", "30823": "33.1894_-82.4597", "30833": "33.2104_-82.381", "30442": "32.7877_-81.9618", "30822": "32.9129_-81.8538", "31049": "32.7078_-82.5274", "31096": "32.7219_-82.7262", "31032": "33.0172_-83.54", "31033": "33.0519_-83.4312", "30204": "33.0457_-84.1515", "30257": "33.141_-84.1759", "31635": "31.0381_-83.0889", "31649": "31.0229_-83.0139", "30454": "32.3915_-82.7479", "31009": "32.3174_-83.0268", "31019": "32.4356_-83.0528", "31021": "32.4593_-82.9381", "31022": "32.5259_-83.0899", "31027": "32.5482_-82.8718", "31040": "32.5401_-82.915", "31065": "32.5619_-83.1601", "31075": "32.3799_-82.967", "31763": "31.6812_-84.1593", "31787": "31.8847_-84.2271", "31301": "31.7741_-81.6186", "31309": "31.8645_-81.4232", "31310": "31.8068_-81.4371", "31313": "31.8513_-81.6072", "31314": "31.8701_-81.6318", "31315": "31.8938_-81.5902", "31320": "31.8018_-81.3909", "31323": "31.7357_-81.4671", "31333": "31.7705_-81.6208", "30817": "33.7773_-82.4435", "31316": "31.7705_-81.7453", "31601": "30.7539_-83.3321", "31602": "30.8931_-83.3278", "31603": "30.828_-83.2522", "31604": "30.828_-83.2522", "31605": "30.946_-83.2474", "31606": "30.7989_-83.1891", "31632": "30.9913_-83.3727", "31636": "30.6906_-83.1753", "31641": "30.8985_-83.1224", "31698": "30.8485_-83.2878", "31699": "30.9785_-83.2165", "30533": "34.5299_-83.9798", "30597": "34.5277_-83.9809", "30806": "33.528_-82.5104", "30808": "33.407_-82.3955", "30824": "33.4774_-82.4942", "31304": "31.5094_-81.3695", "31305": "31.3826_-81.4312", "31319": "31.459_-81.3689", "31327": "31.3974_-81.2787", "31331": "31.5673_-81.4182", "31041": "32.3696_-84.188", "31057": "32.452_-83.9435", "31068": "32.2842_-84.083", "30627": "33.9852_-83.0038", "30628": "34.0382_-83.2191", "30629": "34.0888_-83.122", "30633": "34.1708_-83.2758", "30646": "34.0478_-83.311", "30647": "34.1726_-83.2921", "31803": "32.2542_-84.4898", "30218": "33.1274_-84.5836", "30222": "33.0468_-84.7402", "30251": "33.2101_-84.7444", "30293": "32.9813_-84.5986", "31816": "32.8721_-84.6312", "31830": "32.9063_-84.7167", "39817": "30.9381_-84.5934", "31716": "31.3878_-84.1135", "31730": "31.2199_-84.2297", "31739": "31.1616_-84.0668", "31779": "31.1272_-84.1564", "31784": "31.26_-84.0422", "31004": "32.947_-83.8006", "31016": "32.9003_-84.0626", "31029": "33.0508_-83.9362", "31046": "33.1194_-83.8235", "31086": "32.9895_-83.8761", "30410": "32.2143_-82.4762", "30412": "32.0775_-82.4825", "30445": "32.184_-82.5867", "30470": "32.3188_-82.5593", "30473": "32.0483_-82.5089", "30623": "33.7373_-83.5143", "30625": "33.5368_-83.3435", "30645": "33.8013_-83.5164", "30650": "33.5947_-83.4618", "30663": "33.6163_-83.6023", "30705": "34.7589_-84.7943", "30708": "34.9618_-84.6646", "30711": "34.9412_-84.7645", "30724": "34.8251_-84.7633", "30751": "34.9814_-84.7352", "31808": "32.6288_-85.0017", "31820": "32.5616_-84.8559", "31829": "32.5601_-84.7448", "31901": "32.473_-84.9795", "31902": "32.5243_-84.9558", "31903": "32.4245_-84.9481", "31904": "32.5161_-84.9785", "31905": "32.3923_-84.9315", "31906": "32.4638_-84.9484", "31907": "32.4779_-84.898", "31908": "32.5349_-84.9065", "31909": "32.5369_-84.9274", "31914": "32.491_-84.8741", "31917": "32.491_-84.8741", "31993": "32.4821_-84.9771", "31995": "32.4958_-84.964", "31997": "32.491_-84.8741", "31998": "32.491_-84.8741", "31999": "32.461_-84.9877", "30014": "33.5293_-83.8496", "30015": "33.5968_-83.8602", "30016": "33.5146_-83.8626", "30054": "33.6706_-83.874", "30056": "33.5149_-83.7072", "30070": "33.5712_-83.8951", "30621": "33.8081_-83.4777", "30622": "33.934_-83.5055", "30638": "33.7558_-83.4201", "30677": "33.8542_-83.408", "30619": "33.8803_-83.2341", "30630": "33.9076_-83.1646", "30648": "33.8799_-83.0858", "30667": "33.7715_-83.1159", "30671": "33.7405_-83.1706", "30132": "33.9163_-84.8278", "30141": "33.8673_-84.7699", "30157": "33.9045_-84.8621", "31008": "32.6181_-83.789", "31030": "32.5496_-83.8887", "30143": "34.462_-84.4759", "30148": "34.4398_-84.303", "30175": "34.5394_-84.4912", "30177": "34.4027_-84.3785", "31516": "31.2931_-82.2617", "31518": "31.4833_-82.215", "31551": "31.4783_-82.217", "31556": "31.4126_-82.1155", "31557": "31.3903_-82.1274", "30206": "33.0998_-84.447", "30256": "33.0134_-84.3169", "30258": "32.9978_-84.4558", "30292": "33.1598_-84.3795", "30295": "33.1002_-84.3108", "30104": "34.0666_-85.0696", "30125": "34.0112_-85.2459", "30138": "33.949_-85.3877", "30153": "33.9979_-85.0594", "31036": "32.2778_-83.4948", "31024": "33.3127_-83.3628", "31026": "33.3304_-83.377", "30525": "34.8826_-83.4065", "30537": "34.9777_-83.3199", "30552": "34.7617_-83.4038", "30562": "34.9181_-83.3854", "30568": "34.9576_-83.3901", "30573": "34.742_-83.3977", "30576": "34.8174_-83.4333", "30581": "34.8045_-83.4191", "30805": "33.2941_-82.203", "30812": "33.3726_-82.0321", "30815": "33.3433_-82.0887", "30901": "33.4601_-81.973", "30903": "33.386_-82.091", "30904": "33.4737_-82.0131", "30905": "33.413_-82.1337", "30906": "33.3589_-82.0099", "30907": "33.5229_-82.0852", "30909": "33.4717_-82.0834", "30912": "33.4705_-81.9881", "30914": "33.386_-82.091", "30916": "33.386_-82.091", "30919": "33.386_-82.091", "30999": "33.386_-82.091", "30012": "33.7192_-84.0021", "30013": "33.6436_-83.9684", "30094": "33.6111_-84.0683", "31806": "32.239_-84.3039", "30424": "32.5771_-81.7151", "30446": "32.581_-81.4826", "30449": "32.5281_-81.5332", "30455": "32.723_-81.7933", "30467": "32.7439_-81.6287", "39825": "30.9788_-84.7373", "39859": "31.013_-84.8138", "39861": "31.1824_-85.0121", "30212": "33.2782_-84.2888", "30223": "33.2549_-84.2728", "30224": "33.2404_-84.2734", "30266": "33.2657_-84.299", "30284": "33.3453_-84.2898", "30538": "34.5037_-83.2587", "30557": "34.487_-83.1849", "30577": "34.5665_-83.3114", "30598": "34.5942_-83.3557", "31814": "32.1752_-84.8252", "31815": "32.0435_-84.8022", "31821": "32.1176_-84.9711", "31825": "32.0846_-84.6667", "31709": "32.0404_-84.2153", "31711": "32.1559_-84.164", "31719": "32.0833_-84.2975", "31735": "31.9617_-83.9581", "31743": "31.9502_-84.0271", "31764": "31.954_-84.0783", "31780": "32.0339_-84.3586", "31801": "32.5195_-84.5927", "31810": "32.5799_-84.5508", "31812": "32.608_-84.4574", "31827": "32.6797_-84.5462", "31836": "32.79_-84.5654", "30631": "33.5708_-82.8872", "30664": "33.56_-82.7948", "30420": "32.2642_-82.1333", "30421": "32.1852_-82.1095", "30427": "31.9467_-81.9483", "30438": "32.1605_-82.0196", "30453": "32.0548_-82.1478", "30499": "32.0869_-82.1179", "31006": "32.5726_-84.2343", "31039": "32.596_-84.3844", "31058": "32.509_-84.3999", "31076": "32.5541_-84.1011", "31081": "32.4325_-84.2738", "31037": "32.0738_-82.9146", "31055": "32.068_-82.9007", "31060": "31.9618_-83.0588", "31083": "32.0488_-82.8171", "31544": "31.8481_-82.975", "31549": "31.9251_-82.7073", "39826": "31.8308_-84.364", "39828": "30.8768_-84.2091", "39885": "31.7191_-84.3479", "31626": "30.7855_-83.7971", "31738": "30.9859_-83.8752", "31757": "30.8536_-83.8883", "31758": "30.8366_-83.9788", "31765": "31.0625_-84.0824", "31773": "30.9742_-84.055", "31778": "30.9401_-83.7409", "31792": "30.8385_-83.9696", "31799": "30.8366_-83.9788", "31727": "31.4417_-83.5037", "31733": "31.5439_-83.5509", "31775": "31.33_-83.5974", "31793": "31.4619_-83.5873", "31794": "31.4639_-83.4999", "31795": "31.4718_-83.6468", "30436": "32.1711_-82.3078", "30474": "32.1934_-82.4067", "30475": "32.1775_-82.3739", "30546": "34.9063_-83.7274", "30582": "34.9588_-83.8688", "30457": "32.3869_-82.5871", "30230": "33.1644_-84.9309", "30240": "33.0243_-85.0739", "30241": "33.0249_-84.9577", "30261": "33.0457_-85.049", "31833": "32.8337_-85.1197", "31714": "31.7059_-83.6608", "31783": "31.7979_-83.5235", "31790": "31.6553_-83.6064", "31017": "32.6057_-83.2454", "31020": "32.7151_-83.4558", "31044": "32.7411_-83.3859", "30512": "34.8763_-83.992", "30514": "34.8762_-83.9582", "30572": "34.7253_-84.0496", "30285": "32.9717_-84.2424", "30286": "32.9015_-84.3324", "31097": "32.9156_-84.1593", "30707": "34.858_-85.3221", "30725": "34.9252_-85.3524", "30728": "34.692_-85.2602", "30739": "34.8065_-85.2415", "30741": "34.9535_-85.2968", "30750": "34.9335_-85.3794", "30018": "33.718_-83.8015", "30025": "33.6791_-83.6835", "30641": "33.7613_-83.595", "30655": "33.7883_-83.7013", "30656": "33.8386_-83.7104", "31501": "31.2243_-82.3596", "31502": "31.2137_-82.3557", "31503": "31.2137_-82.3557", "31550": "31.1088_-82.5742", "31552": "31.2506_-82.6441", "31564": "31.248_-82.4737", "30807": "33.4535_-82.646", "30819": "33.4599_-82.5901", "30821": "33.4789_-82.7356", "30828": "33.4091_-82.6357", "31045": "33.2963_-82.7774", "31018": "32.9443_-82.6227", "31035": "32.842_-82.7159", "31067": "32.8554_-82.9499", "31082": "32.975_-82.8406", "31089": "32.9063_-82.84", "31094": "33.1255_-82.8039", "31545": "31.6043_-81.8871", "31546": "31.5319_-81.8049", "31555": "31.6999_-81.9943", "31560": "31.5168_-82.0397", "31598": "31.5782_-81.8802", "31599": "31.5782_-81.8802", "31824": "32.074_-84.5489", "31832": "31.9637_-84.5756", "39877": "31.8939_-84.5112", "30411": "32.133_-82.7944", "30428": "32.1572_-82.6759", "30528": "34.5839_-83.75", "30545": "34.6866_-83.7399", "30571": "34.7162_-83.6931", "30270": "33.3968_-84.59", "30710": "34.9326_-84.9458", "30719": "34.7698_-84.9702", "30720": "34.7635_-84.9875", "30721": "34.7792_-84.9339", "30722": "34.7595_-84.9513", "30740": "34.7745_-85.0561", "30755": "34.8541_-85.0468", "30756": "34.9012_-84.9738", "31001": "31.9648_-83.3068", "31071": "32.0907_-83.5158", "31072": "31.9425_-83.5579", "31079": "31.9491_-83.445", "31084": "31.9605_-83.601", "30660": "33.7856_-82.9504", "30668": "33.8778_-82.747", "30673": "33.7265_-82.7429", "31003": "32.6064_-83.2095", "31031": "32.8813_-83.3029", "31042": "32.8088_-83.174", "31054": "32.8468_-83.204", "31090": "32.8219_-83.0844", "31772": "31.7798_-83.9706", "31781": "31.5384_-83.7843", "31789": "31.513_-83.7385", "31791": "31.5393_-83.8607", "31796": "31.831_-83.9188", "96704": "19.4386_-155.8875", "96710": "19.8882_-155.1333", "96718": "19.5935_-155.438", "96719": "20.238_-155.838", "96720": "19.7025_-155.0939", "96721": "19.7299_-155.0907", "96725": "19.6103_-155.9176", "96726": "19.4273_-155.9133", "96727": "20.0827_-155.488", "96728": "19.8728_-155.1177", "96737": "19.1002_-155.7258", "96738": "19.9724_-155.818", "96739": "19.5606_-155.9623", "96740": "19.6531_-155.9798", "96743": "20.0081_-155.7052", "96745": "19.5935_-155.438", "96749": "19.5893_-154.9926", "96750": "19.5261_-155.93", "96755": "20.2183_-155.799", "96760": "19.5693_-155.0349", "96764": "19.9802_-155.2323", "96771": "19.5506_-155.0864", "96772": "19.0668_-155.6575", "96773": "19.935_-155.1668", "96774": "20.0119_-155.2747", "96776": "20.0271_-155.3697", "96777": "19.2079_-155.4815", "96778": "19.5089_-154.9231", "96780": "19.9751_-155.2203", "96781": "19.7916_-155.0984", "96783": "19.8353_-155.113", "96785": "19.4801_-155.1974", "96701": "21.3908_-157.9332", "96706": "21.3274_-158.0103", "96707": "21.3453_-158.087", "96709": "21.3233_-158.0058", "96712": "21.6312_-158.0693", "96717": "21.6139_-157.9157", "96730": "21.5481_-157.8495", "96731": "21.675_-157.9725", "96734": "21.4063_-157.7448", "96744": "21.4228_-157.8115", "96759": "21.463_-158.0639", "96762": "21.6253_-157.941", "96782": "21.4084_-157.9652", "96786": "21.5006_-158.0435", "96789": "21.4531_-158.0174", "96791": "21.5766_-158.1267", "96792": "21.4352_-158.1781", "96795": "21.3418_-157.7131", "96797": "21.3982_-158.0124", "96801": "21.3278_-157.8294", "96802": "21.306_-157.8587", "96803": "21.306_-157.8585", "96804": "21.306_-157.8585", "96805": "21.3062_-157.8585", "96806": "21.3062_-157.8585", "96807": "21.3062_-157.8585", "96808": "21.3062_-157.8585", "96809": "21.3062_-157.8585", "96810": "21.3062_-157.8585", "96811": "21.3278_-157.8294", "96812": "21.3061_-157.8585", "96813": "21.3179_-157.8521", "96814": "21.2998_-157.8439", "96815": "21.2811_-157.8266", "96816": "21.2887_-157.8006", "96817": "21.3295_-157.8615", "96818": "21.3532_-157.9269", "96819": "21.3488_-157.8759", "96820": "21.351_-157.8795", "96821": "21.2928_-157.7552", "96822": "21.3117_-157.8298", "96823": "21.3072_-157.8465", "96824": "21.2808_-157.7552", "96825": "21.2987_-157.6985", "96826": "21.2941_-157.8284", "96828": "21.294_-157.8226", "96830": "21.2841_-157.834", "96836": "21.2899_-157.8384", "96837": "21.315_-157.8633", "96838": "21.349_-157.875", "96839": "21.3206_-157.8126", "96840": "21.3068_-157.8607", "96841": "21.3103_-157.8594", "96843": "21.3055_-157.853", "96844": "21.2951_-157.8162", "96846": "21.3206_-157.8699", "96847": "21.3022_-157.8443", "96848": "21.3206_-157.8126", "96849": "21.3341_-157.9172", "96850": "21.3095_-157.863", "96853": "21.4061_-157.9609", "96854": "21.4877_-158.0351", "96857": "21.4963_-158.0646", "96858": "21.3416_-157.8918", "96859": "21.4061_-157.9609", "96860": "21.3448_-157.9774", "96861": "21.3967_-157.8994", "96863": "21.4505_-157.768", "96898": "19.2836_166.6419", "96703": "22.1423_-159.3139", "96705": "21.9074_-159.5832", "96714": "22.1603_-159.5471", "96715": "21.9977_-159.3592", "96716": "21.9156_-159.592", "96722": "22.2192_-159.4866", "96741": "21.9259_-159.5303", "96746": "22.0868_-159.3448", "96747": "21.9213_-159.6241", "96751": "22.106_-159.3085", "96752": "21.9735_-159.7199", "96754": "22.2073_-159.3954", "96756": "21.9083_-159.4749", "96765": "21.9309_-159.4993", "96766": "21.9816_-159.3683", "96769": "21.9454_-159.9214", "96796": "21.9571_-159.6689", "96708": "20.9071_-156.3", "96713": "20.7616_-156.0397", "96729": "21.173_-157.0791", "96732": "20.8814_-156.4783", "96733": "20.8895_-156.4743", "96742": "21.1929_-156.9835", "96748": "21.0905_-156.969", "96753": "20.7441_-156.4475", "96757": "21.1601_-157.0277", "96761": "20.9174_-156.6772", "96763": "20.8293_-156.921", "96767": "20.8666_-156.6467", "96768": "20.8469_-156.3327", "96770": "21.1422_-157.2193", "96779": "20.9154_-156.3802", "96784": "20.8666_-156.6467", "96788": "20.8559_-156.3259", "96790": "20.7534_-156.326", "96793": "20.8966_-156.5036", "50002": "41.5137_-94.6444", "50837": "41.2589_-94.6669", "50846": "41.2896_-94.5419", "50849": "41.3133_-94.4408", "50858": "41.2192_-94.3705", "50839": "41.0487_-94.8231", "50841": "40.9871_-94.7358", "50857": "40.954_-94.8731", "50859": "41.0577_-94.5942", "52140": "43.4421_-91.5076", "52146": "43.1698_-91.2188", "52151": "43.3661_-91.266", "52160": "43.4899_-91.2942", "52162": "43.0036_-91.5478", "52170": "43.2078_-91.2976", "52172": "43.264_-91.48", "52544": "40.7326_-92.8728", "52549": "40.6344_-92.9219", "52555": "40.6414_-92.827", "52571": "40.8825_-92.8534", "52572": "40.6866_-92.6833", "52574": "40.7883_-92.9284", "52581": "40.7751_-93.0386", "52593": "40.7808_-92.7421", "52594": "40.8416_-92.6935", "50025": "41.73_-94.9164", "50042": "41.5524_-94.974", "50076": "41.5768_-94.8571", "50110": "41.8401_-94.9812", "50117": "41.6506_-94.9157", "51543": "41.6352_-95.0553", "52206": "41.9881_-91.876", "52208": "41.8992_-92.2574", "52209": "41.9063_-92.0829", "52229": "42.1588_-92.1644", "52249": "42.0156_-92.2179", "52257": "41.9061_-92.1793", "52313": "42.255_-92.0927", "52315": "41.9927_-91.9779", "52318": "41.8992_-91.892", "52332": "42.0848_-91.8746", "52345": "42.2365_-91.8881", "52346": "42.0194_-92.1046", "52349": "42.1743_-91.9892", "52351": "41.877_-91.8369", "52354": "41.904_-91.9965", "50613": "42.5241_-92.4497", "50614": "42.4698_-92.3095", "50623": "42.5253_-92.2207", "50626": "42.578_-92.1588", "50634": "42.4161_-92.2149", "50643": "42.3905_-92.4549", "50651": "42.3416_-92.1862", "50667": "42.4672_-92.2162", "50701": "42.4778_-92.3661", "50702": "42.4731_-92.3365", "50703": "42.5149_-92.3269", "50704": "42.4698_-92.3095", "50707": "42.4755_-92.2812", "50031": "42.0387_-94.1436", "50036": "42.0694_-93.8781", "50037": "42.0597_-93.8802", "50040": "42.1706_-94.1052", "50099": "42.0597_-93.8802", "50152": "41.9387_-93.8371", "50156": "41.8841_-93.8448", "50212": "42.0351_-94.0063", "50223": "42.1604_-94.0102", "50622": "42.6731_-92.3417", "50631": "42.8827_-92.3063", "50647": "42.6465_-92.4791", "50666": "42.8503_-92.5116", "50668": "42.6929_-92.2154", "50674": "42.8419_-92.1186", "50676": "42.8105_-92.2659", "50677": "42.7748_-92.404", "50607": "42.6203_-91.7335", "50629": "42.6162_-92.0326", "50641": "42.6076_-91.9105", "50644": "42.4674_-91.8803", "50648": "42.4823_-92.0456", "50650": "42.5946_-91.6701", "50671": "42.6356_-91.8127", "50682": "42.4912_-91.7315", "52210": "42.3309_-92.0059", "52326": "42.3956_-91.7679", "52329": "42.37_-91.8441", "50510": "42.7784_-94.9824", "50565": "42.8612_-94.9836", "50568": "42.6157_-94.9946", "50576": "42.826_-95.1652", "50585": "42.9065_-95.1388", "50588": "42.6474_-95.1961", "50592": "42.7262_-95.1853", "51002": "42.6771_-95.3129", "51033": "42.8742_-95.2512", "50602": "42.7615_-92.783", "50604": "42.587_-92.8751", "50605": "42.8318_-93.021", "50608": "42.5824_-92.9599", "50611": "42.7741_-92.8864", "50619": "42.8041_-92.6588", "50625": "42.7368_-92.9673", "50636": "42.8958_-92.8024", "50649": "42.6626_-92.9112", "50660": "42.5831_-92.6164", "50665": "42.5714_-92.7688", "50670": "42.7061_-92.5888", "50538": "42.2692_-94.4226", "50551": "42.4871_-94.757", "50552": "42.4555_-94.4569", "50561": "42.423_-94.8597", "50563": "42.5285_-94.5304", "50575": "42.5511_-94.6839", "50579": "42.3961_-94.6292", "50586": "42.3561_-94.4464", "51449": "42.2705_-94.7458", "51453": "42.2619_-94.5566", "50058": "41.894_-94.68", "51401": "42.072_-94.8667", "51430": "42.0573_-95.0371", "51436": "42.1758_-95.0007", "51440": "41.9055_-94.8149", "51443": "42.0618_-94.7148", "51444": "42.0048_-94.9731", "51451": "42.1845_-94.6917", "51452": "42.1254_-94.7754", "51455": "41.9072_-95.0556", "51459": "42.0414_-94.6321", "51463": "41.9121_-94.932", "50020": "41.45_-94.7794", "50022": "41.4003_-95.0101", "50274": "41.3846_-94.8405", "50843": "41.2632_-94.871", "50853": "41.2499_-94.7649", "51535": "41.235_-95.1375", "51544": "41.2963_-95.062", "51552": "41.4547_-95.0973", "52216": "41.8896_-91.0605", "52255": "41.8594_-90.9382", "52306": "41.9039_-91.2764", "52337": "41.8963_-91.1662", "52358": "41.6726_-91.3141", "52721": "41.7353_-90.9656", "52747": "41.6145_-90.91", "52772": "41.7563_-91.1362", "50401": "43.1499_-93.1954", "50402": "43.1536_-93.201", "50428": "43.1406_-93.385", "50433": "42.9222_-93.0421", "50457": "42.9137_-93.4773", "50464": "43.246_-93.1226", "50467": "43.2066_-93.0857", "50469": "43.0032_-93.2167", "50477": "42.9622_-93.3115", "50479": "42.9684_-93.4088", "50482": "43.1262_-93.4706", "51005": "42.6912_-95.4381", "51012": "42.7482_-95.5568", "51014": "42.8086_-95.7124", "51029": "42.8608_-95.5453", "51035": "42.82_-95.8034", "51037": "42.7874_-95.6408", "51049": "42.6303_-95.642", "51061": "42.5781_-95.7295", "50603": "43.1482_-92.4237", "50630": "42.9593_-92.1983", "50645": "43.0403_-92.4865", "50658": "42.9528_-92.5298", "50659": "43.056_-92.3131", "50661": "43.1174_-92.4144", "52154": "43.0932_-92.144", "50174": "41.0376_-93.953", "50213": "41.0295_-93.7712", "50275": "41_-93.6083", "51047": "42.9328_-95.3377", "51301": "43.1451_-95.1457", "51333": "43.1548_-94.9854", "51338": "43.1609_-95.3228", "51340": "43.0824_-95.1511", "51341": "43.0157_-95.0431", "51343": "43.0333_-95.0582", "51357": "43.0488_-95.2679", "51366": "42.9502_-94.9951", "52042": "42.6541_-91.395", "52043": "42.8496_-91.4143", "52044": "42.7624_-91.3203", "52047": "42.9522_-91.339", "52048": "42.7453_-91.2593", "52049": "42.8762_-91.2156", "52052": "42.7594_-91.119", "52066": "42.6783_-90.9518", "52072": "42.922_-91.3778", "52076": "42.6832_-91.5409", "52077": "42.7904_-91.5429", "52156": "43.0493_-91.4583", "52157": "43.0237_-91.1887", "52158": "43.036_-91.1931", "52159": "43.034_-91.3934", "52037": "41.9961_-90.6087", "52254": "41.9745_-90.8265", "52701": "41.9792_-90.2518", "52727": "41.9629_-90.3388", "52729": "41.8111_-90.7416", "52730": "41.7886_-90.2709", "52731": "41.9779_-90.4782", "52732": "41.8517_-90.2078", "52733": "41.8445_-90.1887", "52734": "41.8444_-90.1885", "52736": "41.8445_-90.1887", "52742": "41.8267_-90.5237", "52750": "41.9799_-90.3819", "52751": "41.8501_-90.6695", "52757": "41.8017_-90.3549", "52771": "41.9991_-90.2187", "52774": "41.9081_-90.5954", "52777": "41.8259_-90.8402", "51432": "41.9119_-95.1356", "51439": "42.0707_-95.5992", "51441": "42.1238_-95.3045", "51442": "42.0196_-95.3636", "51448": "42.1794_-95.3115", "51454": "41.8922_-95.2391", "51460": "42.1304_-95.5746", "51461": "42.1646_-95.4443", "51465": "42.0338_-95.1778", "51467": "42.1084_-95.1273", "51520": "41.9504_-95.4623", "51528": "41.9134_-95.4862", "50003": "41.6221_-94.038", "50038": "41.5242_-93.8838", "50039": "41.8284_-93.9963", "50063": "41.6862_-93.9707", "50066": "41.8324_-94.2171", "50069": "41.5208_-94.0303", "50070": "41.5198_-94.2145", "50109": "41.7611_-93.8244", "50146": "41.6422_-94.2406", "50167": "41.7562_-94.015", "50220": "41.8397_-94.1022", "50233": "41.5873_-94.1897", "50261": "41.4699_-93.9207", "50263": "41.593_-93.8592", "50276": "41.8452_-93.9056", "52537": "40.7324_-92.3987", "52552": "40.8253_-92.5051", "52560": "40.8591_-92.3247", "52584": "40.6941_-92.258", "50065": "40.6346_-93.8105", "50067": "40.743_-93.8317", "50103": "40.7711_-93.6117", "50108": "40.8137_-93.9544", "50140": "40.6229_-93.9349", "50144": "40.7373_-93.7429", "50262": "40.8645_-93.8073", "50264": "40.8739_-93.7387", "50654": "42.4794_-91.5913", "52035": "42.6383_-91.1963", "52036": "42.4766_-91.3112", "52038": "42.594_-91.5477", "52041": "42.5001_-91.2597", "52050": "42.5939_-91.3233", "52057": "42.4834_-91.449", "52223": "42.4297_-91.331", "52237": "42.3422_-91.2461", "52330": "42.3436_-91.4848", "52601": "40.8087_-91.117", "52623": "40.854_-91.314", "52637": "41.0059_-91.1321", "52638": "40.8296_-91.2631", "52650": "40.9419_-91.185", "52655": "40.8321_-91.1799", "52660": "40.9835_-91.3026", "51331": "43.3637_-95.1282", "51347": "43.4452_-95.3216", "51351": "43.3196_-95.1615", "51355": "43.3889_-95.1369", "51360": "43.4262_-95.1123", "51363": "43.4318_-94.9469", "51364": "43.3241_-94.9737", "52001": "42.515_-90.6819", "52002": "42.5122_-90.7384", "52003": "42.4649_-90.6829", "52004": "42.5006_-90.6646", "52032": "42.3321_-90.863", "52033": "42.287_-91.0144", "52039": "42.5526_-90.8608", "52040": "42.4833_-91.1183", "52045": "42.4439_-90.9313", "52046": "42.4451_-91.0083", "52053": "42.5808_-90.973", "52056": "42.5783_-91.0621", "52065": "42.5678_-91.0976", "52068": "42.4435_-90.8094", "52073": "42.6171_-90.8115", "52078": "42.393_-91.1069", "52079": "42.2775_-90.7507", "52099": "42.5006_-90.6646", "50514": "43.4024_-94.4853", "50531": "43.4664_-94.6242", "50578": "43.2977_-94.5291", "51334": "43.4017_-94.818", "51365": "43.3189_-94.7964", "50606": "42.7338_-91.6668", "50655": "42.7752_-91.8908", "50662": "42.6811_-91.9131", "50664": "42.7012_-92.0762", "50681": "42.7812_-92.0122", "52135": "43.013_-91.6552", "52141": "42.9548_-91.6454", "52142": "42.8494_-91.8139", "52147": "42.9487_-91.9578", "52164": "42.8626_-91.8846", "52166": "43.0664_-91.9335", "52169": "42.855_-91.6639", "52171": "43.0433_-92.0302", "52175": "42.9438_-91.8334", "50435": "43.143_-92.724", "50458": "43.1479_-93.0002", "50468": "43.0573_-92.952", "50471": "43.142_-92.8885", "50616": "43.0683_-92.6761", "50620": "43.1584_-92.5905", "50653": "42.9645_-92.8917", "50041": "42.633_-93.2449", "50227": "42.5974_-93.4279", "50420": "42.8114_-93.445", "50427": "42.8349_-93.2226", "50431": "42.7382_-93.37", "50441": "42.7405_-93.211", "50452": "42.7598_-93.3518", "50475": "42.8779_-93.2156", "50633": "42.6755_-93.1294", "51639": "40.7215_-95.4776", "51640": "40.6149_-95.6258", "51645": "40.8631_-95.4358", "51648": "40.7401_-95.8093", "51649": "40.8704_-95.5624", "51650": "40.6629_-95.5773", "51652": "40.7507_-95.6403", "51653": "40.9004_-95.6729", "51654": "40.8424_-95.7605", "50050": "42.1614_-94.4933", "50059": "42.0363_-94.397", "50064": "42.1075_-94.2408", "50107": "42.0296_-94.2336", "50129": "42.0093_-94.3888", "50217": "42.1658_-94.273", "50235": "41.9257_-94.2132", "51462": "42.0124_-94.5518", "50609": "42.2367_-92.8162", "50621": "42.2342_-92.8865", "50624": "42.473_-92.6122", "50638": "42.3672_-92.7773", "50642": "42.4011_-92.7999", "50657": "42.3433_-92.6738", "50669": "42.3131_-92.5948", "50673": "42.5264_-92.7119", "50680": "42.4494_-92.9398", "50026": "41.8341_-94.4415", "50029": "41.8519_-94.5583", "50048": "41.505_-94.5194", "50115": "41.6837_-94.4864", "50128": "41.8419_-94.3204", "50164": "41.5348_-94.409", "50216": "41.6967_-94.3606", "50250": "41.5033_-94.3186", "50277": "41.7753_-94.3503", "50034": "42.4937_-93.6594", "50075": "42.3009_-93.549", "50130": "42.3139_-93.6428", "50132": "42.3945_-93.7279", "50231": "42.2383_-93.6008", "50246": "42.2904_-93.7751", "50249": "42.2847_-93.9029", "50271": "42.4883_-93.5449", "50595": "42.4657_-93.8262", "50423": "43.1006_-93.7752", "50430": "42.9927_-93.9575", "50432": "43.2233_-93.7924", "50438": "43.1144_-93.5944", "50439": "42.9383_-93.5824", "50447": "42.9434_-93.7728", "50449": "43.0136_-93.5879", "50484": "43.2226_-93.9109", "50006": "42.5179_-93.3841", "50043": "42.4179_-93.3755", "50102": "42.2455_-93.3955", "50122": "42.3022_-93.2939", "50126": "42.5138_-93.2709", "50206": "42.2693_-93.1753", "50230": "42.3241_-93.4234", "50258": "42.2521_-93.0562", "50259": "42.3831_-93.2506", "50269": "42.2718_-93.0214", "50601": "42.5527_-93.0608", "50627": "42.3572_-93.1037", "50672": "42.4178_-93.0629", "51529": "41.8603_-95.6257", "51545": "41.8083_-96.0314", "51546": "41.643_-95.7889", "51550": "41.6921_-95.8742", "51555": "41.5644_-95.8913", "51556": "41.6371_-95.9852", "51557": "41.7089_-96.0072", "51563": "41.5647_-95.5658", "51564": "41.8214_-95.9192", "51579": "41.7373_-95.7008", "52630": "40.8372_-91.7119", "52641": "40.9646_-91.5614", "52642": "40.9774_-91.6923", "52644": "41.0374_-91.4138", "52645": "40.9161_-91.3986", "52647": "41.1342_-91.5449", "52649": "40.8568_-91.6336", "52652": "41.1043_-91.547", "52654": "41.1449_-91.6589", "52659": "41.1257_-91.4379", "50466": "43.3719_-92.5554", "50628": "43.2786_-92.3981", "52134": "43.473_-92.4155", "52136": "43.363_-92.126", "52155": "43.4556_-92.2733", "52163": "43.217_-92.0927", "50519": "42.8661_-94.2781", "50520": "42.7794_-94.4002", "50529": "42.7214_-94.1993", "50541": "42.7067_-94.4108", "50545": "42.7975_-94.0799", "50548": "42.7196_-94.2132", "50558": "42.8666_-94.1747", "50570": "42.8764_-94.3786", "50577": "42.8491_-94.0074", "50582": "42.7635_-94.2719", "50591": "42.6889_-94.039", "51006": "42.3327_-95.6045", "51020": "42.5105_-95.4298", "51025": "42.4948_-95.565", "51431": "42.3363_-95.3675", "51445": "42.34_-95.4645", "52203": "41.8313_-91.8855", "52204": "41.8_-91.8707", "52220": "41.7292_-91.9977", "52236": "41.7339_-91.8795", "52251": "41.7564_-92.1873", "52301": "41.7863_-92.072", "52307": "41.7954_-91.9018", "52308": "41.5733_-92.1599", "52316": "41.5241_-92.0893", "52325": "41.5702_-92.0052", "52334": "41.7576_-91.9263", "52347": "41.729_-92.2842", "52361": "41.6393_-92.024", "52030": "42.1536_-90.5924", "52031": "42.2582_-90.4356", "52054": "42.3044_-90.6177", "52060": "42.0778_-90.6771", "52064": "42.1006_-90.3367", "52069": "42.0539_-90.3954", "52070": "42.0737_-90.1955", "52071": "42.3196_-90.4903", "52074": "42.0727_-90.473", "52075": "42.1674_-90.4846", "52207": "42.0732_-90.82", "52309": "42.0772_-90.8786", "50028": "41.8204_-93.1583", "50054": "41.6788_-93.2588", "50127": "41.7771_-93.2058", "50135": "41.7184_-92.9114", "50137": "41.608_-92.9046", "50153": "41.5698_-92.7877", "50168": "41.7898_-93.288", "50170": "41.5222_-93.1019", "50208": "41.6992_-93.0455", "50228": "41.5854_-93.241", "50232": "41.5798_-93.0198", "50251": "41.574_-92.8451", "52533": "40.9905_-92.1431", "52556": "41.0039_-91.9576", "52557": "41.0166_-91.9682", "52567": "40.9499_-92.025", "52580": "41.1228_-92.0664", "52635": "41.0119_-91.7645", "52235": "41.5557_-91.5308", "52240": "41.6355_-91.5016", "52241": "41.6937_-91.5906", "52242": "41.6627_-91.5477", "52243": "41.6611_-91.5302", "52244": "41.5727_-91.6619", "52245": "41.6649_-91.5151", "52246": "41.6438_-91.5669", "52317": "41.7443_-91.6061", "52322": "41.6507_-91.7724", "52333": "41.8099_-91.5086", "52338": "41.8268_-91.6739", "52340": "41.7018_-91.6773", "52755": "41.4988_-91.4363", "52205": "42.1078_-91.2851", "52212": "42.1161_-91.0871", "52252": "42.192_-91.2258", "52305": "42.0035_-91.3217", "52310": "42.2326_-91.1989", "52312": "42.006_-91.2459", "52320": "41.9954_-91.1409", "52321": "42.107_-91.0151", "52323": "41.9854_-90.9543", "52362": "42.0604_-90.994", "50104": "41.4868_-92.3867", "50136": "41.4613_-92.2395", "50255": "41.4547_-92.3357", "50268": "41.3953_-92.3548", "52231": "41.3728_-92.0388", "52248": "41.3504_-91.9641", "52335": "41.4529_-92.068", "52355": "41.4364_-92.1765", "52550": "41.3167_-92.3359", "52562": "41.3363_-92.1784", "52563": "41.1826_-92.3097", "52568": "41.1948_-92.2715", "52576": "41.2001_-92.1354", "52585": "41.1939_-91.9739", "52591": "41.3301_-92.2019", "50451": "43.3772_-94.0938", "50480": "43.2456_-94.0367", "50483": "43.0977_-94.0038", "50511": "43.066_-94.2306", "50517": "43.2935_-94.2108", "50522": "43.2062_-94.2122", "50539": "43.242_-94.4044", "50556": "43.4346_-94.1503", "50559": "43.1666_-94.3586", "50560": "42.9868_-94.0959", "50590": "43.4022_-94.3193", "50598": "43.0619_-94.4269", "52619": "40.5317_-91.5663", "52624": "40.7417_-91.3374", "52625": "40.6612_-91.5745", "52627": "40.633_-91.3398", "52631": "40.77_-91.6138", "52632": "40.4094_-91.3982", "52639": "40.5139_-91.424", "52648": "40.7628_-91.5368", "52656": "40.715_-91.4397", "52657": "40.7695_-91.5171", "52658": "40.7067_-91.2268", "52202": "42.1583_-91.6392", "52213": "42.1898_-91.7758", "52214": "42.1982_-91.4914", "52218": "42.2792_-91.5413", "52219": "42.2383_-91.4224", "52227": "41.8943_-91.5738", "52228": "41.9153_-91.7801", "52233": "42.0425_-91.677", "52253": "41.9212_-91.3861", "52302": "42.0411_-91.5941", "52314": "41.9287_-91.4274", "52324": "42.0365_-91.7877", "52328": "42.0731_-91.6648", "52336": "42.0607_-91.4394", "52341": "42.1039_-91.729", "52344": "42.29_-91.6824", "52352": "42.2867_-91.7807", "52401": "41.9743_-91.6554", "52402": "42.0188_-91.6612", "52403": "41.9843_-91.6259", "52404": "41.9521_-91.6853", "52405": "41.9804_-91.7098", "52406": "42.0083_-91.6441", "52407": "42.0794_-91.5992", "52408": "42.0794_-91.5992", "52409": "42.0794_-91.5992", "52410": "42.0794_-91.5992", "52411": "42.0493_-91.7263", "52497": "42.0794_-91.5992", "52498": "42.0794_-91.5992", "52499": "42.0794_-91.5992", "52640": "41.0984_-91.2581", "52646": "41.1003_-91.0439", "52653": "41.207_-91.1719", "52737": "41.2593_-91.3747", "52738": "41.2926_-91.3006", "52752": "41.2759_-91.1885", "52754": "41.293_-91.204", "50049": "41.0226_-93.3042", "50068": "40.9355_-93.4796", "50151": "41.0585_-93.4836", "50238": "40.9456_-93.1784", "50272": "41.0959_-93.2559", "51230": "43.3201_-96.291", "51235": "43.2872_-96.202", "51237": "43.3439_-95.9894", "51240": "43.3047_-96.4363", "51241": "43.4387_-96.4252", "51242": "43.4443_-96.3361", "51243": "43.4496_-95.8926", "51246": "43.4272_-96.1781", "50033": "41.363_-93.7928", "50072": "41.4709_-94.1294", "50155": "41.2104_-94.1825", "50218": "41.3499_-93.8803", "50222": "41.2145_-93.9437", "50240": "41.2924_-93.8242", "50257": "41.2076_-93.841", "50273": "41.3391_-94.0088", "50027": "41.4883_-92.4703", "50143": "41.3647_-92.8081", "50207": "41.464_-92.6848", "52534": "41.272_-92.6819", "52543": "41.2121_-92.509", "52561": "41.2117_-92.4362", "52577": "41.2942_-92.6439", "52586": "41.3309_-92.472", "52595": "41.2864_-92.6184", "50044": "41.2094_-92.8963", "50057": "41.1838_-93.1582", "50062": "41.225_-93.2413", "50116": "41.19_-92.959", "50119": "41.303_-92.9318", "50138": "41.3164_-93.0954", "50163": "41.225_-93.2413", "50214": "41.4518_-93.0348", "50219": "41.4082_-92.9172", "50225": "41.3738_-93.2712", "50252": "41.4636_-93.301", "50256": "41.2756_-92.8753", "50005": "42.1143_-92.9882", "50051": "42.09_-93.1688", "50078": "41.9374_-92.865", "50106": "41.9012_-92.8101", "50120": "41.9337_-92.9829", "50141": "41.8829_-92.9263", "50142": "42.0066_-92.7756", "50148": "42.184_-92.9833", "50158": "42.0405_-92.9127", "50162": "41.9323_-93.0856", "50234": "41.9177_-93.1796", "50239": "42.152_-93.1824", "50247": "42.0109_-93.1673", "51533": "41.0284_-95.4106", "51534": "41.047_-95.7389", "51540": "41.0132_-95.5008", "51541": "41.1254_-95.4586", "51551": "41.0074_-95.584", "51554": "41.1414_-95.7005", "51561": "41.0271_-95.8046", "51571": "41.113_-95.6269", "50426": "43.415_-93.0149", "50454": "43.3919_-92.7344", "50455": "43.45_-92.6048", "50460": "43.2355_-92.72", "50461": "43.2872_-92.8144", "50472": "43.4061_-92.9235", "50476": "43.4457_-92.761", "50481": "43.3564_-92.789", "51010": "42.0744_-95.9086", "51034": "42.1585_-95.7909", "51040": "42.037_-96.1072", "51051": "42.198_-95.9769", "51060": "42.0581_-95.7125", "51063": "42.1522_-96.1822", "51523": "41.9237_-96.0827", "51558": "41.9186_-95.829", "51572": "41.9942_-95.7825", "50150": "41.1272_-92.9293", "52531": "41.0287_-92.7946", "52569": "40.9665_-93.0145", "50847": "41.1427_-94.9842", "50864": "40.9437_-94.9796", "51532": "41.1306_-95.1602", "51566": "41.0079_-95.2269", "51573": "40.9859_-95.0988", "51591": "41.0303_-95.1562", "52720": "41.5614_-91.1748", "52739": "41.3805_-91.3465", "52749": "41.3486_-91.1237", "52759": "41.4625_-90.8088", "52760": "41.5646_-91.0859", "52761": "41.4304_-91.0509", "52766": "41.4766_-91.2931", "52769": "41.5914_-90.8588", "52776": "41.5701_-91.2668", "52778": "41.5858_-91.01", "51009": "42.9444_-95.5515", "51046": "42.9703_-95.7083", "51058": "42.9826_-95.4807", "51201": "43.1808_-95.8401", "51231": "43.1179_-95.7417", "51245": "43.0759_-95.6533", "51248": "43.189_-95.6622", "51346": "43.18_-95.4817", "51232": "43.3053_-95.7655", "51249": "43.4069_-95.7424", "51345": "43.4568_-95.4426", "51350": "43.2845_-95.593", "51354": "43.391_-95.5204", "51601": "40.7581_-95.3648", "51603": "40.7656_-95.3722", "51630": "40.6122_-95.2054", "51631": "40.5991_-94.9956", "51632": "40.7491_-95.038", "51636": "40.6686_-95.2217", "51637": "40.6249_-95.1157", "51638": "40.8404_-95.2888", "51647": "40.6127_-95.3096", "51651": "40.6575_-95.025", "51656": "40.7374_-95.1562", "50515": "43.037_-94.8478", "50527": "42.9633_-94.7975", "50528": "43.1507_-94.5107", "50536": "43.1082_-94.6825", "50562": "42.9417_-94.6746", "50597": "42.9574_-94.4564", "51342": "43.2277_-94.7334", "51358": "43.1448_-94.8842", "51001": "42.8354_-96.5225", "51008": "42.8093_-96.2626", "51024": "42.604_-96.305", "51028": "42.6191_-95.9762", "51031": "42.7962_-96.1704", "51038": "42.7047_-96.2283", "51045": "42.8199_-96.0566", "51050": "42.8149_-95.9544", "51062": "42.6953_-96.492", "50540": "42.6051_-94.8297", "50546": "42.8411_-94.7252", "50554": "42.8409_-94.8508", "50571": "42.6419_-94.5432", "50573": "42.8783_-94.6205", "50574": "42.7296_-94.6737", "50581": "42.8082_-94.5166", "50593": "42.6598_-94.8979", "50007": "41.8159_-93.6063", "50009": "41.6475_-93.4724", "50021": "41.7212_-93.5682", "50023": "41.7194_-93.6266", "50032": "41.6658_-93.5432", "50035": "41.7017_-93.4527", "50073": "41.7917_-93.5222", "50111": "41.7018_-93.7821", "50131": "41.673_-93.7028", "50169": "41.6609_-93.37", "50226": "41.7549_-93.6893", "50237": "41.5515_-93.4202", "50243": "41.8571_-93.6973", "50265": "41.5805_-93.7447", "50266": "41.5695_-93.7994", "50301": "41.6727_-93.5722", "50302": "41.6727_-93.5722", "50303": "41.6727_-93.5722", "50304": "41.6727_-93.5722", "50305": "41.6727_-93.5722", "50306": "41.6727_-93.5722", "50307": "41.6005_-93.6091", "50308": "41.6727_-93.5722", "50309": "41.5887_-93.6212", "50310": "41.6255_-93.6736", "50311": "41.601_-93.6729", "50312": "41.5855_-93.6719", "50313": "41.6381_-93.6203", "50314": "41.603_-93.633", "50315": "41.5444_-93.6192", "50316": "41.6092_-93.6", "50317": "41.6122_-93.5296", "50318": "41.6727_-93.5722", "50319": "41.5921_-93.604", "50320": "41.5487_-93.5827", "50321": "41.5476_-93.6618", "50322": "41.6295_-93.723", "50323": "41.6294_-93.7717", "50324": "41.6032_-93.7152", "50325": "41.6067_-93.7457", "50327": "41.5839_-93.5199", "50328": "41.6727_-93.5722", "50329": "41.6727_-93.5722", "50330": "41.6727_-93.5722", "50331": "41.6727_-93.5722", "50332": "41.6727_-93.5722", "50333": "41.6727_-93.5722", "50334": "41.6727_-93.5722", "50335": "41.6727_-93.5722", "50336": "41.6727_-93.5722", "50339": "41.6727_-93.5722", "50340": "41.6727_-93.5722", "50359": "41.6727_-93.5722", "50360": "41.6727_-93.5722", "50361": "41.6727_-93.5722", "50362": "41.6727_-93.5722", "50363": "41.6727_-93.5722", "50364": "41.6727_-93.5722", "50367": "41.6727_-93.5722", "50368": "41.6727_-93.5722", "50369": "41.6727_-93.5722", "50380": "41.6727_-93.5722", "50381": "41.6727_-93.5722", "50391": "41.6727_-93.5722", "50392": "41.5878_-93.6274", "50393": "41.6727_-93.5722", "50394": "41.6727_-93.5722", "50395": "41.6727_-93.5722", "50396": "41.6727_-93.5722", "50398": "41.6267_-93.7122", "50936": "41.6727_-93.5722", "50940": "41.6727_-93.5722", "50947": "41.6727_-93.5722", "50950": "41.6727_-93.5722", "50980": "41.6727_-93.5722", "50981": "41.6727_-93.5722", "50982": "41.6006_-93.6089", "50983": "41.6006_-93.6089", "51501": "41.2324_-95.8751", "51502": "41.2619_-95.8608", "51503": "41.2616_-95.8251", "51510": "41.2925_-95.9141", "51521": "41.4768_-95.3509", "51525": "41.2367_-95.4181", "51526": "41.3644_-95.8276", "51536": "41.3832_-95.3445", "51542": "41.463_-95.8802", "51548": "41.2932_-95.6813", "51549": "41.1916_-95.4314", "51553": "41.4654_-95.5519", "51559": "41.4564_-95.6794", "51560": "41.312_-95.379", "51570": "41.5339_-95.4469", "51575": "41.2307_-95.6086", "51576": "41.3603_-95.627", "51577": "41.4623_-95.218", "51593": "41.498_-95.3636", "50112": "41.7421_-92.7344", "50157": "41.7695_-92.5354", "50171": "41.5928_-92.5276", "50242": "41.5656_-92.6987", "52211": "41.7321_-92.4285", "52221": "41.6378_-92.3479", "52222": "41.5717_-92.3645", "52232": "41.808_-92.3538", "50074": "40.8505_-94.0841", "50133": "40.6861_-94.0607", "50835": "40.7082_-94.3689", "50845": "40.8226_-94.3552", "50854": "40.7142_-94.2321", "50860": "40.6053_-94.3595", "50863": "40.8516_-94.1908", "50535": "42.4483_-95.1726", "50567": "42.518_-95.0939", "50583": "42.4262_-94.9796", "51053": "42.5055_-95.2846", "51433": "42.2763_-94.8711", "51450": "42.3154_-95.0486", "51458": "42.3095_-95.2501", "51466": "42.2653_-95.0852", "52722": "41.5509_-90.4942", "52726": "41.5112_-90.738", "52728": "41.4564_-90.7235", "52745": "41.7113_-90.7553", "52746": "41.7093_-90.6829", "52748": "41.6635_-90.5634", "52753": "41.6082_-90.3628", "52756": "41.7213_-90.5534", "52758": "41.743_-90.4539", "52765": "41.7132_-90.8599", "52767": "41.5746_-90.4213", "52768": "41.6858_-90.3706", "52773": "41.6453_-90.7256", "52801": "41.5208_-90.5745", "52802": "41.5164_-90.6141", "52803": "41.5385_-90.5613", "52804": "41.5386_-90.6115", "52805": "41.613_-90.6063", "52806": "41.5733_-90.6038", "52807": "41.5618_-90.5403", "52808": "41.613_-90.6063", "52809": "41.613_-90.6063", "51446": "41.7751_-95.1919", "51447": "41.7308_-95.2671", "51527": "41.8053_-95.3537", "51530": "41.7925_-95.421", "51531": "41.5829_-95.07", "51537": "41.6437_-95.3111", "51562": "41.7288_-95.487", "51565": "41.6484_-95.5108", "51578": "41.7199_-95.3952", "51003": "42.9782_-96.0173", "51011": "42.9163_-96.5145", "51022": "42.9693_-95.8972", "51023": "43.0013_-96.473", "51027": "42.9666_-96.3232", "51036": "42.9626_-96.1655", "51041": "43.0185_-96.0565", "51234": "43.2034_-95.9823", "51238": "43.0793_-95.9142", "51239": "43.1952_-96.1392", "51244": "43.2439_-95.9353", "51247": "43.2014_-96.3103", "51250": "43.0814_-96.18", "50010": "42.0379_-93.6003", "50011": "42.036_-93.4652", "50012": "42.0236_-93.6485", "50013": "42.0235_-93.6408", "50014": "42.0486_-93.6945", "50046": "41.9025_-93.5305", "50055": "41.9032_-93.3008", "50056": "42.0131_-93.3071", "50105": "42.1148_-93.6399", "50124": "41.8994_-93.6024", "50134": "41.9488_-93.6644", "50154": "42.1665_-93.3978", "50161": "41.8967_-93.4001", "50201": "42.019_-93.4462", "50236": "42.1646_-93.5063", "50244": "41.8765_-93.6812", "50248": "42.1835_-93.5988", "50278": "42.1535_-93.2928", "50173": "41.9709_-92.7006", "50612": "42.2552_-92.4098", "50632": "42.0872_-92.6894", "50635": "42.1774_-92.7141", "50652": "42.2643_-92.693", "50675": "42.1847_-92.4827", "52215": "41.9131_-92.4078", "52217": "42.0789_-92.3763", "52224": "42.169_-92.3187", "52225": "42.0088_-92.3314", "52339": "41.9616_-92.58", "52342": "42.0077_-92.5662", "52348": "41.99_-92.3799", "50833": "40.6683_-94.7324", "50836": "40.6242_-94.5049", "50840": "40.7935_-94.4944", "50848": "40.7909_-94.7506", "50851": "40.8841_-94.5612", "50862": "40.795_-94.6416", "51646": "40.7422_-94.8917", "50149": "41.1233_-94.0639", "50254": "41.0029_-94.0686", "50801": "41.0499_-94.3471", "50830": "41.0401_-94.194", "50831": "40.9314_-94.2193", "50842": "41.0398_-94.4616", "50861": "40.9017_-94.2633", "52535": "40.8626_-91.9534", "52542": "40.6546_-92.0465", "52551": "40.8378_-92.0859", "52565": "40.7424_-91.9704", "52570": "40.6721_-92.1438", "52573": "40.6458_-91.9027", "52588": "40.864_-92.1736", "52620": "40.7148_-91.7897", "52626": "40.6397_-91.7447", "52651": "40.8584_-91.8141", "52501": "41.0309_-92.4098", "52530": "40.9957_-92.3162", "52536": "40.9555_-92.6195", "52548": "41.086_-92.5303", "52553": "41.1533_-92.6221", "52554": "40.9261_-92.2268", "52566": "41.1438_-92.5006", "50001": "41.3737_-93.3767", "50047": "41.4814_-93.4921", "50061": "41.4849_-93.7539", "50118": "41.4596_-93.4022", "50125": "41.3143_-93.588", "50139": "41.1988_-93.3838", "50145": "41.2071_-93.4993", "50160": "41.373_-93.7358", "50166": "41.2904_-93.4454", "50210": "41.1883_-93.6976", "50211": "41.4861_-93.6573", "50229": "41.383_-93.7344", "50241": "41.3084_-93.7369", "52201": "41.3202_-91.5472", "52247": "41.4823_-91.7057", "52327": "41.4758_-91.5741", "52353": "41.3015_-91.6987", "52356": "41.47_-91.84", "52359": "41.3585_-91.8075", "52540": "41.1543_-91.8284", "52621": "41.2093_-91.5414", "50008": "40.7023_-93.3724", "50052": "40.6342_-93.448", "50060": "40.7771_-93.3274", "50123": "40.8469_-93.5101", "50147": "40.6004_-93.4862", "50165": "40.8494_-93.3055", "52583": "40.7585_-93.1527", "52590": "40.6724_-93.1368", "50501": "42.5088_-94.1807", "50516": "42.6144_-94.1461", "50518": "42.5159_-94.3703", "50521": "42.3413_-94.1143", "50523": "42.3494_-94.282", "50524": "42.5954_-94.308", "50530": "42.2594_-94.061", "50532": "42.4493_-94.0592", "50543": "42.2767_-94.2987", "50544": "42.2531_-94.1961", "50557": "42.3526_-94.0342", "50566": "42.434_-94.3199", "50569": "42.4031_-94.1388", "50594": "42.5623_-94.0335", "50424": "43.3732_-93.9376", "50436": "43.2692_-93.6356", "50450": "43.4167_-93.5336", "50453": "43.3425_-93.6895", "50465": "43.4767_-93.9171", "50473": "43.4673_-93.6423", "50478": "43.3875_-93.7517", "52101": "43.3227_-91.7939", "52132": "43.1974_-91.9126", "52133": "43.1361_-91.6643", "52144": "43.1339_-91.9134", "52149": "43.4638_-91.6899", "52161": "43.1379_-91.7734", "52165": "43.2979_-92.0034", "52168": "43.2032_-91.9441", "51004": "42.387_-95.8948", "51007": "42.4292_-96.1986", "51015": "42.345_-96.0875", "51016": "42.4743_-95.7804", "51018": "42.4642_-95.6775", "51019": "42.2693_-95.7263", "51026": "42.2897_-96.0796", "51030": "42.5047_-96.2189", "51039": "42.4819_-96.0656", "51044": "42.2646_-95.8616", "51048": "42.5335_-95.8922", "51052": "42.3306_-96.2879", "51054": "42.4019_-96.3534", "51055": "42.2427_-96.2306", "51056": "42.2408_-95.9486", "51101": "42.4972_-96.4029", "51102": "42.3684_-96.318", "51103": "42.5068_-96.4295", "51104": "42.5254_-96.4005", "51105": "42.5032_-96.3829", "51106": "42.4671_-96.3528", "51108": "42.5469_-96.3617", "51109": "42.5173_-96.4803", "51111": "42.4089_-96.3713", "50434": "43.2644_-93.4183", "50440": "43.311_-93.0797", "50444": "43.2802_-93.3788", "50446": "43.3761_-93.4454", "50448": "43.3536_-93.2105", "50456": "43.2891_-93.2018", "50459": "43.4506_-93.2419", "50071": "42.661_-93.5058", "50101": "42.6912_-93.6035", "50421": "42.8511_-93.62", "50470": "42.7596_-93.557", "50525": "42.7271_-93.7277", "50526": "42.733_-93.7352", "50533": "42.6609_-93.9049", "50542": "42.7581_-93.9194", "50599": "42.5844_-93.8216", "83616": "43.7069_-116.362", "83634": "43.487_-116.3819", "83642": "43.615_-116.3975", "83669": "43.7013_-116.4967", "83680": "43.6121_-116.3915", "83701": "43.6038_-116.2729", "83702": "43.6322_-116.2052", "83703": "43.6601_-116.2524", "83704": "43.633_-116.2951", "83705": "43.5851_-116.2191", "83706": "43.5885_-116.191", "83707": "43.6135_-116.2035", "83708": "43.4599_-116.244", "83709": "43.5741_-116.2941", "83711": "43.4599_-116.244", "83712": "43.6023_-116.1649", "83713": "43.634_-116.3419", "83714": "43.7318_-116.2797", "83715": "43.4599_-116.244", "83716": "43.5345_-115.9711", "83717": "43.4599_-116.244", "83719": "43.4599_-116.244", "83720": "43.4599_-116.244", "83722": "43.4599_-116.244", "83724": "43.6195_-116.1952", "83725": "43.4599_-116.244", "83726": "43.4599_-116.244", "83728": "43.6135_-116.2035", "83729": "43.4599_-116.244", "83731": "43.4599_-116.244", "83732": "43.4599_-116.244", "83735": "43.6135_-116.2035", "83756": "43.4599_-116.244", "83799": "43.6135_-116.2035", "83612": "44.7628_-116.4518", "83632": "44.5491_-116.443", "83643": "44.6255_-116.4493", "83654": "44.994_-116.2874", "83201": "42.8876_-112.4381", "83202": "42.9357_-112.4679", "83204": "42.8465_-112.4434", "83205": "42.8062_-112.4103", "83206": "42.8713_-112.4455", "83209": "42.6395_-112.3138", "83214": "42.56_-112.1746", "83234": "42.4181_-112.109", "83245": "42.7964_-112.2465", "83246": "42.6185_-112.0176", "83250": "42.6336_-112.1758", "83281": "42.3195_-111.9781", "83220": "42.3191_-111.3926", "83223": "42.184_-111.4086", "83233": "42.1774_-111.2174", "83238": "42.3136_-111.0722", "83239": "42.4821_-111.3708", "83254": "42.352_-111.3195", "83261": "42.2242_-111.4208", "83272": "42.1128_-111.3897", "83287": "42.0459_-111.4633", "83824": "47.126_-116.8937", "83830": "47.116_-116.3831", "83851": "47.3278_-116.8662", "83861": "47.2977_-116.5681", "83866": "47.1544_-116.431", "83870": "47.1707_-116.9027", "83203": "43.0331_-112.4285", "83210": "43.0049_-112.84", "83215": "43.4449_-112.8128", "83218": "43.3155_-112.1644", "83221": "43.1943_-112.3615", "83236": "43.3021_-112.1588", "83256": "43.2226_-112.4423", "83262": "43.1336_-112.6295", "83274": "43.3769_-112.1075", "83277": "43.0803_-112.673", "83313": "43.4397_-114.2498", "83320": "43.2744_-113.8926", "83333": "43.5239_-114.3064", "83340": "43.6692_-114.4858", "83348": "43.3101_-114.0861", "83353": "43.6853_-114.3313", "83354": "43.5946_-114.3226", "83602": "44.0804_-116.124", "83622": "44.0909_-115.8243", "83629": "43.9229_-116.1809", "83631": "43.8834_-115.708", "83637": "44.1106_-115.5285", "83646": "43.6498_-116.4306", "83666": "43.9633_-115.9759", "83804": "48.0223_-116.9909", "83809": "48.0482_-116.5939", "83811": "48.1405_-116.1699", "83813": "48.1248_-116.6571", "83821": "48.5228_-116.8408", "83822": "48.1552_-116.9781", "83825": "48.2516_-116.611", "83836": "48.2444_-116.2795", "83840": "48.3102_-116.5135", "83841": "48.1702_-116.756", "83848": "48.6339_-116.9473", "83852": "48.3055_-116.5338", "83856": "48.1664_-116.9066", "83860": "48.2035_-116.5455", "83864": "48.312_-116.5332", "83865": "48.3633_-116.6256", "83401": "43.5518_-111.8919", "83402": "43.4934_-112.0578", "83403": "43.4666_-112.0341", "83404": "43.475_-112.0124", "83405": "43.4666_-112.0341", "83406": "43.4732_-111.9661", "83415": "43.4666_-112.0341", "83427": "43.5263_-111.933", "83428": "43.3861_-111.2527", "83449": "43.456_-111.3416", "83454": "43.5936_-111.9573", "83805": "48.7306_-116.3322", "83826": "48.9994_-116.1813", "83845": "48.7464_-116.1796", "83847": "48.6049_-116.3196", "83853": "48.992_-116.4775", "83213": "43.6355_-113.3176", "83244": "43.9087_-113.0878", "83255": "43.7296_-113.4544", "83322": "43.5282_-114.7307", "83327": "43.3675_-114.7908", "83337": "43.3005_-115.0512", "83605": "43.6627_-116.7", "83606": "43.7249_-116.7989", "83607": "43.6186_-116.7501", "83626": "43.669_-116.8315", "83630": "43.6027_-116.7903", "83641": "43.3784_-116.5489", "83644": "43.7191_-116.6112", "83651": "43.5834_-116.5848", "83652": "43.7071_-116.6208", "83653": "43.5851_-116.753", "83656": "43.7259_-116.7997", "83660": "43.7896_-116.9401", "83676": "43.6579_-116.9122", "83686": "43.5441_-116.566", "83687": "43.5937_-116.536", "83217": "42.7205_-111.8429", "83230": "42.7191_-111.5967", "83241": "42.55_-111.74", "83276": "42.6718_-111.5699", "83285": "43.0269_-111.2541", "83311": "42.3896_-113.5567", "83312": "42.0846_-113.6283", "83318": "42.5244_-113.7931", "83323": "42.5245_-113.4338", "83342": "42.2741_-113.3927", "83346": "42.194_-113.872", "83423": "44.1858_-112.3259", "83446": "44.3605_-112.1869", "83520": "46.5394_-116.3233", "83541": "46.5354_-116.513", "83544": "46.4952_-116.2404", "83546": "46.4924_-115.8071", "83553": "46.3807_-115.9386", "83827": "46.7835_-116.1799", "83226": "44.4969_-114.1946", "83227": "44.2733_-114.4102", "83235": "44.6919_-114.0484", "83251": "43.9111_-113.612", "83278": "44.3714_-114.8561", "83601": "43.8479_-115.2538", "83623": "42.9622_-115.316", "83627": "42.9457_-115.4662", "83633": "42.9799_-115.1899", "83647": "43.1392_-115.6963", "83648": "43.7914_-116.4012", "83228": "42.216_-111.9957", "83232": "42.1184_-111.9858", "83237": "42.0288_-111.7871", "83263": "42.1109_-111.8565", "83283": "42.3794_-111.6841", "83286": "42.0446_-111.9715", "83420": "44.0153_-111.4253", "83421": "44.0011_-111.5351", "83429": "44.4466_-111.3679", "83433": "44.3192_-111.6017", "83436": "43.8881_-111.6042", "83438": "43.9594_-111.7577", "83445": "43.963_-111.7036", "83451": "43.8907_-111.6504", "83617": "43.9089_-116.4927", "83636": "43.8963_-116.6462", "83657": "44.2418_-116.2732", "83670": "43.9948_-116.3232", "83314": "42.9449_-114.9104", "83330": "42.9373_-114.712", "83332": "42.8142_-114.887", "83355": "42.7579_-114.7154", "83522": "46.0448_-116.3733", "83525": "45.7896_-115.5024", "83526": "46.1349_-116.3982", "83530": "45.9272_-116.1076", "83531": "45.9632_-116.2563", "83533": "46.1155_-116.2724", "83539": "46.116_-115.9459", "83542": "45.557_-116.2669", "83547": "45.3068_-116.3517", "83549": "45.397_-116.3006", "83552": "46.002_-115.9269", "83554": "45.7521_-116.2889", "83671": "45.2641_-115.6765", "83425": "43.9308_-112.1872", "83431": "43.6725_-112.0189", "83434": "43.7266_-111.9837", "83435": "43.9862_-112.5783", "83442": "43.6715_-111.9005", "83443": "43.5197_-111.5266", "83444": "43.7116_-112.1196", "83450": "43.8586_-112.42", "83325": "42.5868_-114.2467", "83335": "42.5955_-114.135", "83338": "42.7178_-114.5012", "83801": "47.9267_-116.7318", "83803": "47.9822_-116.5494", "83810": "47.5522_-116.4431", "83814": "47.6928_-116.785", "83815": "47.7248_-116.789", "83816": "47.6777_-116.7805", "83833": "47.5017_-116.7446", "83835": "47.7989_-116.7423", "83842": "47.4625_-116.5683", "83854": "47.7205_-116.9353", "83858": "47.8241_-116.8873", "83869": "47.9657_-116.868", "83876": "47.4292_-116.9056", "83877": "47.718_-116.9516", "83535": "46.5754_-116.7188", "83537": "46.6286_-116.6049", "83806": "46.8588_-116.3935", "83823": "46.8061_-116.5238", "83832": "46.5714_-116.929", "83834": "46.9376_-116.7025", "83843": "46.7309_-116.9897", "83844": "46.7324_-117.0002", "83855": "46.9448_-116.9141", "83857": "46.8996_-116.8287", "83871": "46.7426_-116.7681", "83872": "46.8583_-116.9732", "83229": "45.093_-114.2317", "83253": "44.6044_-113.912", "83462": "45.255_-113.8573", "83463": "45.5704_-113.9913", "83464": "44.7389_-113.4926", "83465": "44.8516_-113.6198", "83466": "45.4242_-114.0419", "83467": "45.1571_-113.8784", "83468": "44.9681_-113.8167", "83469": "45.3769_-114.277", "83523": "46.2453_-116.4677", "83536": "46.2186_-116.0347", "83543": "46.2475_-116.2393", "83548": "46.3361_-116.5333", "83555": "46.2383_-116.6204", "83324": "42.9125_-114.2664", "83349": "43.0588_-114.1508", "83352": "42.9474_-114.3822", "83440": "43.81_-111.789", "83441": "43.7761_-111.691", "83448": "43.8477_-111.6932", "83460": "43.826_-111.7897", "83336": "42.5599_-113.7709", "83343": "42.773_-113.5098", "83347": "42.624_-113.7971", "83350": "42.6888_-113.6481", "83501": "46.3646_-116.8609", "83524": "46.378_-116.6536", "83540": "46.4124_-116.7902", "83545": "46.4807_-116.4114", "83243": "42.1619_-112.6539", "83252": "42.1808_-112.262", "83604": "42.614_-115.8419", "83624": "42.9896_-116.0934", "83628": "43.6138_-116.9472", "83639": "43.5399_-116.824", "83650": "42.8481_-116.6371", "83619": "44.0027_-116.9143", "83655": "43.959_-116.8048", "83661": "44.0782_-116.9203", "83211": "42.6352_-112.9458", "83212": "42.5026_-112.5585", "83271": "42.5556_-112.854", "83802": "47.2714_-115.866", "83808": "47.3219_-116.0703", "83812": "47.0107_-116.2529", "83837": "47.5431_-116.1253", "83839": "47.5509_-116.2887", "83846": "47.4709_-115.7926", "83849": "47.5211_-116.021", "83850": "47.5018_-116.2647", "83867": "47.4981_-115.9657", "83868": "47.5362_-116.2062", "83873": "47.4908_-115.962", "83874": "47.6271_-115.8585", "83422": "43.7263_-111.1199", "83424": "43.8724_-111.1895", "83452": "43.7814_-111.2118", "83455": "43.6148_-111.1259", "83301": "42.5565_-114.4693", "83302": "42.218_-114.5942", "83303": "42.563_-114.4609", "83316": "42.6008_-114.7825", "83321": "42.521_-114.8734", "83328": "42.5653_-114.614", "83334": "42.5249_-114.2994", "83341": "42.5287_-114.3657", "83344": "42.4776_-114.1606", "83611": "44.6927_-115.6417", "83615": "44.6659_-116.0369", "83635": "44.8327_-116.0848", "83638": "44.8918_-116.0789", "83677": "44.9698_-115.4963", "83610": "44.5922_-116.6757", "83645": "44.442_-116.7038", "83672": "44.2522_-116.9651", "62301": "39.9307_-91.3763", "62305": "39.9601_-91.3026", "62306": "39.9356_-91.4099", "62320": "40.0293_-91.0769", "62324": "40.0133_-90.9554", "62325": "40.0554_-91.1747", "62338": "39.9925_-91.2452", "62339": "40.1203_-91.0296", "62346": "40.1572_-90.9844", "62347": "39.8892_-91.0869", "62348": "40.1775_-91.3785", "62349": "40.1532_-91.213", "62351": "40.0857_-91.2899", "62359": "40.0366_-91.2053", "62360": "39.8153_-91.2627", "62365": "39.8004_-91.1436", "62376": "40.0809_-91.3733", "62914": "37.0123_-89.1811", "62957": "37.302_-89.4531", "62962": "37.1034_-89.3494", "62969": "37.1674_-89.3537", "62988": "37.2345_-89.2763", "62990": "37.221_-89.4599", "62993": "37.1528_-89.3256", "62019": "39.0344_-89.4909", "62086": "38.9693_-89.5653", "62246": "38.8933_-89.4052", "62262": "38.9311_-89.2463", "62273": "38.78_-89.5981", "62275": "38.7846_-89.5247", "62284": "38.8739_-89.3266", "61008": "42.2595_-88.8509", "61011": "42.3835_-88.9185", "61012": "42.4087_-88.7465", "61038": "42.251_-88.7437", "61065": "42.3594_-88.8428", "62353": "39.9803_-90.7414", "62375": "40.0117_-90.8661", "62378": "39.8883_-90.6741", "61312": "41.4437_-89.2219", "61314": "41.314_-89.6795", "61315": "41.2894_-89.3686", "61317": "41.4264_-89.2126", "61320": "41.3547_-89.1705", "61322": "41.3092_-89.3252", "61323": "41.4362_-89.396", "61328": "41.505_-89.4634", "61329": "41.3825_-89.219", "61330": "41.5376_-89.297", "61337": "41.4245_-89.3693", "61338": "41.4555_-89.6697", "61344": "41.4036_-89.8201", "61345": "41.2905_-89.7944", "61346": "41.5122_-89.7199", "61349": "41.5371_-89.4574", "61356": "41.3629_-89.427", "61359": "41.3613_-89.2691", "61361": "41.3949_-89.7115", "61362": "41.3279_-89.2042", "61368": "41.2891_-89.508", "61374": "41.55_-89.3534", "61376": "41.5394_-89.6092", "61379": "41.3785_-89.5744", "62006": "39.0725_-90.6591", "62013": "38.9495_-90.5887", "62036": "38.8961_-90.5602", "62045": "39.2235_-90.6995", "62047": "39.1547_-90.624", "62053": "39.3064_-90.6269", "62065": "39.2353_-90.6235", "62070": "39.2925_-90.7493", "61014": "41.9962_-89.8963", "61046": "42.0935_-89.8247", "61051": "41.9674_-89.7801", "61053": "42.1053_-89.9845", "61074": "42.0956_-90.1401", "61078": "42.161_-89.7481", "61285": "41.9816_-90.0844", "62611": "39.8979_-90.3636", "62612": "39.9386_-90.0792", "62618": "40.0044_-90.4229", "62622": "39.9796_-90.3524", "62627": "40.0374_-90.1163", "62691": "39.9512_-90.2123", "60949": "40.3747_-88.138", "61801": "40.1095_-88.2036", "61802": "40.0746_-88.1691", "61803": "40.1059_-88.2247", "61815": "40.1134_-88.3695", "61816": "39.9142_-87.9948", "61820": "40.111_-88.2407", "61821": "40.1073_-88.2788", "61822": "40.1317_-88.2854", "61824": "40.1164_-88.2434", "61825": "40.1164_-88.2434", "61826": "40.1131_-88.3613", "61840": "40.3131_-88.277", "61843": "40.2991_-88.356", "61845": "40.3554_-88.4202", "61847": "40.3028_-88.0317", "61849": "40.0346_-87.9627", "61851": "39.9502_-88.4451", "61852": "39.9012_-88.0753", "61853": "40.1964_-88.3928", "61859": "40.1401_-87.9665", "61862": "40.3101_-87.957", "61863": "39.9151_-88.2743", "61864": "40.0052_-88.1595", "61866": "40.3107_-88.1462", "61871": "40.1924_-87.9742", "61872": "39.9613_-88.3447", "61873": "40.1207_-88.0472", "61874": "40.0654_-88.2528", "61875": "40.107_-88.4267", "61877": "40.0232_-88.069", "61878": "40.2402_-88.183", "61880": "39.985_-88.2596", "62083": "39.3743_-89.1983", "62510": "39.5095_-89.0398", "62517": "39.5917_-89.424", "62531": "39.6612_-89.3779", "62540": "39.5838_-89.4185", "62546": "39.4153_-89.4541", "62547": "39.769_-89.2489", "62555": "39.4775_-89.1951", "62556": "39.4699_-89.3733", "62557": "39.3971_-89.1048", "62567": "39.6405_-89.1913", "62568": "39.5489_-89.2945", "62570": "39.588_-89.4495", "62420": "39.3017_-87.9913", "62423": "39.449_-87.5867", "62441": "39.422_-87.6923", "62442": "39.3174_-87.8707", "62474": "39.4564_-87.9961", "62477": "39.2402_-87.6512", "62434": "38.8284_-88.3204", "62824": "38.6695_-88.3516", "62839": "38.6703_-88.4919", "62858": "38.7718_-88.5065", "62879": "38.7639_-88.3631", "62899": "38.6359_-88.6348", "62215": "38.532_-89.6202", "62216": "38.6089_-89.6034", "62218": "38.5385_-89.4578", "62219": "38.6058_-89.4319", "62230": "38.6188_-89.5284", "62231": "38.6066_-89.3805", "62245": "38.5487_-89.5413", "62250": "38.5408_-89.2661", "62252": "38.6018_-89.2915", "62253": "38.7769_-89.2975", "62265": "38.5315_-89.6922", "62266": "38.4857_-89.6816", "62293": "38.6191_-89.6447", "61912": "39.5254_-88.0341", "61920": "39.4869_-88.1761", "61931": "39.6012_-88.3141", "61938": "39.4802_-88.3762", "61943": "39.6516_-88.0253", "62440": "39.3958_-88.253", "62469": "39.3938_-88.3488", "60004": "42.112_-87.9792", "60005": "42.0639_-87.9856", "60006": "42.0884_-87.9806", "60007": "42.0076_-87.9931", "60008": "42.073_-88.0191", "60009": "42.0039_-87.9703", "60016": "42.0467_-87.8859", "60017": "42.0288_-87.8944", "60018": "42.0155_-87.8687", "60019": "42.0243_-87.9071", "60022": "42.1333_-87.7615", "60025": "42.0758_-87.8223", "60026": "42.0698_-87.7878", "60029": "42.058_-87.7916", "60038": "42.098_-88.0141", "60043": "42.0884_-87.7165", "60053": "42.0431_-87.7899", "60055": "42.098_-88.0141", "60056": "42.0624_-87.9377", "60062": "42.1254_-87.8465", "60065": "42.1275_-87.829", "60067": "42.1139_-88.0429", "60068": "42.0122_-87.8417", "60070": "42.1058_-87.9395", "60074": "42.1458_-88.023", "60076": "42.0362_-87.7328", "60077": "42.0345_-87.7541", "60078": "42.1103_-88.0342", "60082": "42.1164_-87.8121", "60090": "42.134_-87.9341", "60091": "42.0765_-87.7246", "60093": "42.1054_-87.7535", "60094": "42.1103_-88.0342", "60095": "42.1103_-88.0342", "60103": "41.9794_-88.2063", "60104": "41.8825_-87.8786", "60107": "42.0225_-88.169", "60130": "41.8744_-87.8106", "60131": "41.9339_-87.8734", "60141": "41.8623_-87.8355", "60153": "41.8793_-87.8433", "60154": "41.8524_-87.8845", "60155": "41.8577_-87.8562", "60159": "42.0334_-88.0834", "60160": "41.9003_-87.8581", "60161": "41.9006_-87.8567", "60162": "41.8725_-87.9016", "60163": "41.8888_-87.909", "60164": "41.9214_-87.8924", "60165": "41.903_-87.8811", "60168": "42.0334_-88.0834", "60169": "42.0493_-88.1065", "60171": "41.9279_-87.8387", "60173": "42.0581_-88.0482", "60176": "41.9563_-87.8692", "60179": "42.0793_-88.2237", "60192": "42.0428_-88.0798", "60193": "42.0144_-88.0935", "60194": "42.0289_-88.1167", "60195": "42.0764_-88.1093", "60196": "42.0564_-88.0725", "60201": "42.0546_-87.6943", "60202": "42.0302_-87.6865", "60203": "42.0485_-87.7176", "60204": "42.0411_-87.6901", "60208": "42.0586_-87.6845", "60209": "42.0497_-87.6794", "60301": "41.8886_-87.7986", "60302": "41.8925_-87.7895", "60303": "41.885_-87.7845", "60304": "41.8725_-87.7877", "60305": "41.8951_-87.8159", "60402": "41.8347_-87.7914", "60406": "41.6582_-87.6795", "60409": "41.6153_-87.5483", "60411": "41.5087_-87.5904", "60412": "41.5061_-87.6356", "60415": "41.7017_-87.7774", "60418": "41.6446_-87.7415", "60419": "41.6257_-87.598", "60422": "41.5406_-87.6837", "60425": "41.5467_-87.6126", "60426": "41.6103_-87.6534", "60429": "41.5738_-87.6849", "60430": "41.5556_-87.6616", "60438": "41.566_-87.5446", "60443": "41.5102_-87.7406", "60445": "41.635_-87.7362", "60452": "41.6077_-87.7542", "60453": "41.7143_-87.7516", "60454": "41.8119_-87.6873", "60455": "41.7431_-87.8066", "60456": "41.7311_-87.7315", "60457": "41.7262_-87.8289", "60458": "41.7447_-87.8346", "60459": "41.7447_-87.7699", "60461": "41.5134_-87.6742", "60462": "41.6194_-87.8423", "60463": "41.6621_-87.7927", "60464": "41.6624_-87.8521", "60465": "41.7004_-87.8263", "60466": "41.479_-87.6828", "60467": "41.6018_-87.8899", "60469": "41.6277_-87.6872", "60471": "41.4819_-87.7238", "60472": "41.6423_-87.7089", "60473": "41.5979_-87.5938", "60475": "41.4686_-87.6386", "60476": "41.5727_-87.6078", "60477": "41.5825_-87.805", "60478": "41.5637_-87.7247", "60480": "41.7364_-87.8786", "60482": "41.6895_-87.7863", "60499": "41.8119_-87.6873", "60501": "41.7801_-87.824", "60513": "41.8217_-87.8492", "60525": "41.7842_-87.8689", "60526": "41.8318_-87.874", "60534": "41.813_-87.8236", "60546": "41.8379_-87.8213", "60558": "41.8049_-87.8995", "60601": "41.8858_-87.6181", "60602": "41.8829_-87.6321", "60603": "41.8798_-87.6285", "60604": "41.8785_-87.633", "60605": "41.8713_-87.6277", "60606": "41.8868_-87.6386", "60607": "41.8721_-87.6578", "60608": "41.8515_-87.6694", "60609": "41.8097_-87.6533", "60610": "41.9033_-87.6336", "60611": "41.8971_-87.6223", "60612": "41.8805_-87.6873", "60613": "41.9543_-87.6575", "60614": "41.9229_-87.6483", "60615": "41.8022_-87.6006", "60616": "41.8426_-87.6306", "60617": "41.7257_-87.556", "60618": "41.9464_-87.7042", "60619": "41.7458_-87.6054", "60620": "41.7411_-87.6543", "60621": "41.775_-87.6421", "60622": "41.9019_-87.6779", "60623": "41.849_-87.7157", "60624": "41.8804_-87.7223", "60625": "41.9703_-87.7042", "60626": "42.0095_-87.6689", "60628": "41.6934_-87.6243", "60629": "41.7781_-87.7069", "60630": "41.9699_-87.7603", "60631": "41.9951_-87.8082", "60632": "41.8093_-87.7052", "60633": "41.6642_-87.5612", "60634": "41.9463_-87.8061", "60636": "41.776_-87.6674", "60637": "41.7813_-87.6051", "60638": "41.7814_-87.7705", "60639": "41.9202_-87.7535", "60640": "41.9719_-87.6624", "60641": "41.9453_-87.7474", "60642": "41.9008_-87.6528", "60643": "41.6996_-87.6628", "60644": "41.8829_-87.7582", "60645": "42.0086_-87.6947", "60646": "41.993_-87.7596", "60647": "41.9209_-87.7043", "60649": "41.762_-87.5703", "60651": "41.9025_-87.7393", "60652": "41.7454_-87.7135", "60653": "41.8196_-87.6126", "60654": "41.8923_-87.6373", "60655": "41.6948_-87.7038", "60656": "41.9735_-87.8658", "60657": "41.9399_-87.6528", "60659": "41.9972_-87.7166", "60660": "41.9909_-87.6629", "60661": "41.8814_-87.643", "60664": "41.8119_-87.6873", "60666": "41.85_-87.6501", "60668": "41.8119_-87.6873", "60669": "41.8119_-87.6873", "60670": "41.8119_-87.6873", "60673": "41.8119_-87.6873", "60674": "41.8119_-87.6873", "60675": "41.8119_-87.6873", "60677": "41.8119_-87.6873", "60678": "41.8119_-87.6873", "60680": "41.8119_-87.6873", "60681": "41.8119_-87.6873", "60682": "41.837_-87.685", "60684": "41.8119_-87.6873", "60685": "41.8119_-87.6873", "60686": "41.8756_-87.6378", "60687": "41.8119_-87.6873", "60688": "41.8724_-87.6688", "60689": "41.8745_-87.6353", "60690": "41.8119_-87.6873", "60691": "41.8119_-87.6873", "60693": "41.85_-87.6501", "60694": "41.8119_-87.6873", "60695": "41.8839_-87.6317", "60696": "41.8684_-87.6649", "60697": "41.8119_-87.6873", "60699": "41.8119_-87.6873", "60701": "41.8119_-87.6873", "60706": "41.9643_-87.8162", "60707": "41.9232_-87.8185", "60712": "42.008_-87.7361", "60714": "42.0312_-87.8112", "60803": "41.6721_-87.7357", "60804": "41.8378_-87.7602", "60805": "41.722_-87.7024", "60827": "41.6496_-87.6301", "62413": "39.1179_-87.8029", "62427": "38.9096_-87.6837", "62433": "39.1064_-87.6695", "62449": "39.001_-87.895", "62451": "39.0028_-87.6157", "62454": "39.007_-87.7484", "62464": "38.9898_-87.8396", "62478": "39.1938_-87.7131", "62428": "39.274_-88.1246", "62435": "39.3743_-88.2445", "62436": "39.2076_-88.2474", "62447": "39.322_-88.4503", "62468": "39.2772_-88.2468", "60111": "42.0086_-88.8306", "60112": "41.92_-88.6887", "60115": "41.9008_-88.7548", "60129": "42.0225_-88.9439", "60135": "42.0981_-88.6908", "60145": "42.1057_-88.7695", "60146": "42.1014_-88.8685", "60150": "41.9183_-88.8688", "60178": "41.9911_-88.6928", "60520": "41.7691_-88.6448", "60548": "41.6353_-88.6393", "60550": "41.7638_-88.8752", "60552": "41.6383_-88.6816", "60556": "41.7504_-88.7754", "61727": "40.1487_-88.9627", "61735": "40.1848_-88.7637", "61749": "40.0967_-89.0859", "61750": "40.1235_-88.8597", "61777": "40.2323_-88.9673", "61778": "40.2437_-89.1143", "61842": "40.2447_-88.6634", "61882": "40.1177_-88.7531", "61910": "39.687_-88.3037", "61911": "39.7077_-88.4555", "61913": "39.8044_-88.4494", "61919": "39.8_-88.1468", "61930": "39.7018_-88.1486", "61941": "39.8009_-88.0784", "61942": "39.7848_-88.0001", "61953": "39.7995_-88.2816", "61956": "39.8687_-88.1616", "60101": "41.9335_-88.0054", "60105": "41.955_-87.9401", "60106": "41.9501_-87.945", "60108": "41.9483_-88.0782", "60116": "41.9125_-88.1348", "60117": "41.8397_-88.0887", "60126": "41.8927_-87.941", "60128": "41.8397_-88.0887", "60132": "41.8397_-88.0887", "60133": "41.9995_-88.1451", "60137": "41.8661_-88.0648", "60138": "41.8775_-88.067", "60139": "41.9205_-88.0793", "60143": "41.972_-88.0202", "60148": "41.8721_-88.016", "60157": "41.9814_-88.0512", "60172": "41.9798_-88.0857", "60181": "41.8799_-87.9782", "60184": "41.9525_-88.2536", "60185": "41.8886_-88.2022", "60186": "41.8848_-88.204", "60187": "41.8724_-88.1123", "60188": "41.9178_-88.137", "60189": "41.8397_-88.0887", "60190": "41.8744_-88.1516", "60191": "41.9602_-87.981", "60197": "41.9125_-88.1348", "60199": "41.8397_-88.0887", "60399": "41.9545_-87.9377", "60439": "41.7074_-87.9756", "60504": "41.7523_-88.2453", "60514": "41.7965_-87.9569", "60515": "41.8034_-88.0138", "60516": "41.7602_-88.0159", "60517": "41.7518_-88.0489", "60519": "41.7775_-88.2428", "60521": "41.8001_-87.9287", "60522": "41.8397_-88.0887", "60523": "41.8371_-87.9638", "60527": "41.7447_-87.9334", "60532": "41.7862_-88.0879", "60540": "41.7662_-88.141", "60555": "41.828_-88.1921", "60559": "41.7728_-87.9757", "60561": "41.7434_-87.9805", "60563": "41.7895_-88.169", "60565": "41.7328_-88.1282", "60566": "41.8397_-88.0887", "60567": "41.7859_-88.1473", "60569": "41.8122_-88.2172", "60572": "41.7606_-88.3201", "60598": "41.8397_-88.0887", "60599": "41.8397_-88.0887", "61917": "39.6923_-87.9263", "61924": "39.7996_-87.6556", "61932": "39.8009_-87.8747", "61933": "39.5525_-87.9352", "61940": "39.8008_-87.7955", "61944": "39.6132_-87.6976", "61949": "39.6453_-87.8617", "61955": "39.5811_-87.5889", "62476": "38.5209_-88.0048", "62806": "38.374_-88.0636", "62815": "38.449_-88.0025", "62818": "38.3764_-87.9928", "62833": "38.365_-88.1335", "62401": "39.1217_-88.5611", "62411": "39.0634_-88.7481", "62414": "39.1835_-88.8038", "62424": "39.0319_-88.4074", "62426": "38.9021_-88.6645", "62443": "38.9645_-88.6234", "62445": "39.1573_-88.335", "62461": "39.1881_-88.6418", "62467": "39.132_-88.4767", "62473": "38.9906_-88.5584", "62011": "39.1128_-89.2125", "62080": "39.1445_-89.1087", "62247": "38.9434_-89.1684", "62418": "38.9891_-88.9494", "62458": "39.0315_-88.8552", "62471": "38.9439_-89.1041", "62838": "38.8469_-88.7614", "62880": "38.8697_-88.856", "62885": "38.8446_-89.079", "60919": "40.9819_-88.1921", "60933": "40.4648_-88.2712", "60936": "40.4659_-88.3609", "60946": "40.9126_-88.209", "60952": "40.5714_-88.2551", "60957": "40.4565_-88.099", "60959": "40.7556_-88.1873", "60962": "40.6193_-88.1804", "61773": "40.5823_-88.3815", "62812": "38_-88.9227", "62819": "37.9764_-89.0209", "62822": "37.9849_-89.0574", "62825": "37.9946_-89.0672", "62836": "38.0702_-88.8504", "62840": "37.9943_-88.9417", "62856": "37.9559_-88.8403", "62865": "37.9687_-89.1159", "62874": "37.9182_-88.9767", "62884": "38.0894_-89.0574", "62890": "37.8804_-88.7684", "62891": "38.0222_-89.0351", "62896": "37.8979_-88.9307", "62897": "38.0872_-88.9014", "62983": "37.879_-89.1141", "62999": "37.8991_-89.0523", "61415": "40.6549_-90.4461", "61427": "40.4995_-90.1811", "61431": "40.6047_-90.2875", "61432": "40.6442_-90.1653", "61433": "40.5603_-90.1798", "61441": "40.3594_-90.2967", "61459": "40.4978_-90.3885", "61477": "40.4855_-90.2856", "61482": "40.3784_-90.4239", "61484": "40.3062_-90.422", "61501": "40.2311_-90.3443", "61519": "40.4663_-90.091", "61520": "40.5601_-90.0242", "61524": "40.4912_-90.0318", "61531": "40.6832_-90.035", "61542": "40.383_-90.1563", "61543": "40.3902_-90.0026", "61544": "40.695_-90.2616", "61553": "40.6259_-90.0323", "61563": "40.4912_-90.0505", "62867": "37.8999_-88.1285", "62871": "37.8904_-88.2865", "62934": "37.7278_-88.3445", "62954": "37.6952_-88.2491", "62979": "37.8042_-88.2612", "62984": "37.7132_-88.1785", "62016": "39.3009_-90.4092", "62027": "39.2836_-90.5329", "62044": "39.3491_-90.2089", "62050": "39.4674_-90.5128", "62054": "39.2037_-90.3719", "62078": "39.4806_-90.4829", "62081": "39.2831_-90.2558", "62082": "39.4846_-90.3498", "62092": "39.4288_-90.4019", "62098": "39.3762_-90.2933", "60407": "41.2288_-88.269", "60416": "41.2908_-88.2823", "60424": "41.1775_-88.338", "60437": "41.1631_-88.5535", "60444": "41.2264_-88.4217", "60447": "41.4615_-88.2786", "60450": "41.3672_-88.4178", "60474": "41.1728_-88.2767", "60479": "41.2501_-88.517", "62817": "37.9546_-88.4678", "62828": "38.1975_-88.6363", "62829": "37.995_-88.4917", "62859": "38.0939_-88.5286", "62860": "38.013_-88.6961", "61450": "40.5846_-90.9687", "62311": "40.2341_-90.9554", "62313": "40.3283_-91.197", "62316": "40.2341_-91.0705", "62321": "40.4129_-91.1005", "62329": "40.5714_-91.1682", "62330": "40.572_-91.1255", "62334": "40.395_-91.2496", "62336": "40.4689_-91.1704", "62341": "40.3964_-91.339", "62354": "40.5261_-91.3318", "62358": "40.5978_-91.2991", "62367": "40.3236_-90.9672", "62373": "40.2865_-91.3726", "62379": "40.3544_-91.4348", "62380": "40.255_-91.1826", "62919": "37.4692_-88.1653", "62931": "37.4665_-88.2867", "62955": "37.5008_-88.2383", "62982": "37.424_-88.3462", "61418": "40.8531_-90.8561", "61425": "40.7551_-91.0564", "61437": "40.8377_-90.9941", "61454": "40.6761_-91.0391", "61460": "40.7618_-90.857", "61469": "40.9442_-90.9302", "61471": "40.6959_-90.8274", "61480": "40.7523_-90.9257", "61233": "41.2954_-90.2905", "61234": "41.398_-89.9129", "61235": "41.4162_-90.0225", "61238": "41.3114_-90.1805", "61241": "41.4885_-90.321", "61254": "41.4688_-90.1711", "61258": "41.522_-89.9122", "61262": "41.2888_-90.3304", "61273": "41.3634_-90.3849", "61274": "41.3637_-90.2681", "61413": "41.193_-90.3821", "61419": "41.1977_-90.1183", "61434": "41.1656_-90.0481", "61443": "41.2411_-89.9274", "61468": "41.2525_-90.3876", "61490": "41.1849_-90.2833", "60911": "40.8844_-87.9411", "60912": "40.9672_-87.6217", "60918": "40.6018_-88.0361", "60922": "41.0254_-87.8959", "60924": "40.5858_-87.8759", "60926": "40.5676_-87.804", "60927": "40.9394_-87.9202", "60928": "40.7417_-87.849", "60930": "40.8244_-87.9868", "60931": "40.8891_-87.6046", "60938": "40.768_-87.9933", "60939": "40.5673_-87.7845", "60945": "40.8269_-87.5847", "60948": "40.5241_-88.0927", "60951": "40.9052_-87.7443", "60953": "40.6293_-87.6853", "60955": "40.712_-87.9958", "60956": "40.967_-87.7161", "60966": "40.7803_-87.5736", "60967": "40.6145_-87.5928", "60968": "40.684_-88.0999", "60970": "40.7734_-87.7309", "60973": "40.5339_-87.6561", "60974": "40.7151_-87.7307", "62901": "37.72_-89.2158", "62902": "37.6636_-89.1173", "62903": "37.6704_-89.2778", "62907": "37.8793_-89.4654", "62916": "37.9228_-89.5799", "62924": "37.8147_-89.2218", "62927": "37.9398_-89.2379", "62932": "37.9155_-89.2336", "62940": "37.7406_-89.444", "62942": "37.6322_-89.4999", "62950": "37.7437_-89.5444", "62958": "37.6176_-89.209", "62966": "37.7655_-89.3317", "62971": "37.8651_-89.3834", "62975": "37.6501_-89.3693", "62994": "37.9051_-89.3269", "62432": "39.1228_-88.1397", "62448": "38.9847_-88.1704", "62459": "38.928_-88.0291", "62475": "38.895_-88.0979", "62479": "39.0182_-88.3175", "62480": "38.9757_-88.0172", "62481": "39.13_-88.0105", "62810": "38.2153_-88.7558", "62814": "38.3531_-88.7587", "62816": "38.198_-88.9229", "62830": "38.4333_-88.9657", "62846": "38.1527_-88.8894", "62864": "38.317_-88.9105", "62866": "38.1654_-88.9676", "62872": "38.275_-88.775", "62883": "38.1731_-89.0927", "62889": "38.425_-88.8702", "62894": "38.2089_-89.039", "62898": "38.3844_-89.0745", "62012": "39.0361_-90.1443", "62022": "39.0312_-90.3011", "62028": "38.9594_-90.3541", "62030": "39.1546_-90.1642", "62031": "39.1086_-90.5297", "62037": "39.0021_-90.4323", "62052": "39.1213_-90.3338", "62063": "39.1986_-90.1542", "61001": "42.4714_-90.1201", "61025": "42.4875_-90.6046", "61028": "42.3089_-90.1986", "61036": "42.4182_-90.4195", "61041": "42.2594_-90.2897", "61059": "42.4558_-89.9454", "61075": "42.4715_-90.258", "61085": "42.3492_-90.0202", "61087": "42.489_-89.986", "62908": "37.3266_-88.9507", "62909": "37.4472_-88.8768", "62912": "37.4637_-88.9806", "62923": "37.365_-88.9747", "62939": "37.575_-88.9655", "62943": "37.3794_-88.7583", "62967": "37.578_-88.7454", "62972": "37.5367_-88.7688", "62985": "37.4673_-88.7551", "62995": "37.4205_-88.8879", "60109": "42.0458_-88.539", "60110": "42.123_-88.2606", "60118": "42.0962_-88.2902", "60119": "41.8824_-88.4611", "60120": "42.0384_-88.2606", "60121": "42.0372_-88.2812", "60122": "42.0671_-88.305", "60123": "42.0376_-88.3186", "60124": "42.0293_-88.3747", "60134": "41.886_-88.311", "60136": "42.0984_-88.3691", "60140": "42.0807_-88.517", "60144": "41.8353_-88.522", "60147": "41.937_-88.4202", "60151": "41.9232_-88.5999", "60174": "41.9194_-88.307", "60175": "41.9478_-88.3918", "60177": "41.9969_-88.2986", "60183": "41.937_-88.4202", "60502": "41.7845_-88.2616", "60505": "41.7582_-88.2971", "60506": "41.7664_-88.3446", "60507": "41.7606_-88.3201", "60510": "41.8482_-88.3098", "60511": "41.7593_-88.5376", "60539": "41.8241_-88.3315", "60542": "41.8089_-88.3274", "60554": "41.7741_-88.4397", "60568": "41.7606_-88.3201", "60901": "41.1166_-87.8696", "60910": "41.0798_-87.8114", "60913": "41.1573_-88.0619", "60914": "41.1661_-87.879", "60915": "41.1454_-87.8601", "60917": "41.0433_-88.1772", "60935": "41.1676_-88.1845", "60940": "41.2477_-87.648", "60941": "41.0464_-88.0858", "60944": "41.0634_-87.625", "60950": "41.2514_-87.8468", "60954": "41.1593_-87.6575", "60958": "41.0646_-87.5917", "60961": "41.1005_-88.2089", "60964": "41.0487_-87.6564", "60969": "41.1088_-88.1465", "60512": "41.7016_-88.4398", "60536": "41.5984_-88.5529", "60537": "41.5614_-88.5975", "60538": "41.7177_-88.332", "60541": "41.5267_-88.527", "60543": "41.6849_-88.3453", "60545": "41.667_-88.5384", "60560": "41.6387_-88.4438", "61401": "40.9521_-90.3698", "61402": "40.9478_-90.3712", "61410": "40.8023_-90.4009", "61414": "41.1128_-90.1598", "61428": "40.9551_-90.1398", "61430": "40.9402_-90.3109", "61436": "40.8765_-90.1747", "61439": "41.0276_-90.3575", "61448": "40.9107_-90.2871", "61458": "40.7849_-90.2008", "61467": "41.0832_-90.2391", "61472": "41.1103_-90.39", "61474": "40.7289_-90.3798", "61485": "41.0256_-90.0933", "61488": "41.0224_-90.2723", "61489": "40.9277_-90.0267", "61572": "40.7878_-90.0265", "60002": "42.4648_-88.1178", "60010": "42.1614_-88.1383", "60011": "42.3228_-87.6101", "60015": "42.1705_-87.859", "60020": "42.3937_-88.1648", "60030": "42.3524_-88.0545", "60031": "42.3669_-87.9452", "60035": "42.1794_-87.8059", "60037": "42.2097_-87.8056", "60040": "42.2035_-87.8141", "60041": "42.3631_-88.1587", "60042": "42.2742_-88.1926", "60044": "42.282_-87.856", "60045": "42.2374_-87.8482", "60046": "42.3813_-87.9991", "60047": "42.2165_-88.0769", "60048": "42.281_-87.95", "60060": "42.2636_-88.0048", "60061": "42.2288_-87.9719", "60064": "42.3247_-87.8564", "60069": "42.1976_-87.9261", "60073": "42.3668_-88.0888", "60075": "42.4906_-87.9126", "60079": "42.3636_-87.8448", "60083": "42.446_-87.904", "60084": "42.2636_-88.1333", "60085": "42.3542_-87.8651", "60086": "42.4333_-87.7766", "60087": "42.3989_-87.8554", "60088": "42.3032_-87.8642", "60089": "42.1598_-87.9644", "60096": "42.4793_-87.8318", "60099": "42.4442_-87.8389", "60470": "41.153_-88.6502", "60518": "41.5859_-88.9103", "60531": "41.6066_-88.7716", "60549": "41.4995_-88.7509", "60551": "41.5164_-88.6706", "60557": "41.4409_-88.7703", "61301": "41.3442_-89.0955", "61316": "41.2617_-89.1237", "61321": "40.9547_-88.9628", "61325": "41.2386_-88.8168", "61332": "41.1895_-88.9806", "61334": "41.145_-89.075", "61341": "41.3302_-88.6947", "61342": "41.5443_-89.1083", "61348": "41.2928_-89.0553", "61350": "41.3526_-88.8416", "61354": "41.333_-89.1265", "61358": "40.9844_-89.0388", "61360": "41.3152_-88.61", "61364": "41.1225_-88.8307", "61370": "41.2327_-89.089", "61371": "41.4991_-89.0219", "61372": "41.4678_-89.0831", "61373": "41.363_-89.0008", "62417": "38.7067_-87.7657", "62439": "38.7309_-87.6784", "62460": "38.5921_-87.6487", "62466": "38.7171_-87.8638", "60530": "41.7864_-88.9714", "60553": "41.8475_-89.0151", "61006": "41.8643_-89.2086", "61021": "41.8478_-89.4893", "61031": "41.858_-89.3171", "61042": "41.6973_-89.5695", "61057": "41.8316_-89.3896", "61310": "41.7042_-89.3472", "61318": "41.685_-89.0877", "61324": "41.7711_-89.4123", "61331": "41.7488_-89.2827", "61353": "41.6852_-88.9674", "61367": "41.6331_-89.2354", "61378": "41.7292_-89.1909", "60420": "41.0887_-88.4159", "60460": "41.0238_-88.5156", "60920": "41.0248_-88.3072", "60921": "40.7484_-88.2937", "60929": "40.8781_-88.2765", "60934": "40.9692_-88.3589", "61311": "41.0426_-88.8642", "61313": "41.0719_-88.6498", "61319": "41.031_-88.7668", "61333": "40.9896_-88.8811", "61739": "40.745_-88.5165", "61740": "40.879_-88.862", "61741": "40.7513_-88.4111", "61743": "40.8757_-88.7817", "61764": "40.8764_-88.6328", "61769": "40.8885_-88.4094", "61775": "40.6476_-88.404", "61723": "40.2586_-89.23", "61751": "40.2193_-89.2852", "62512": "40.1437_-89.1948", "62518": "40.0582_-89.19", "62519": "39.9374_-89.4023", "62541": "39.9706_-89.3505", "62543": "39.9711_-89.1725", "62548": "40.0045_-89.2935", "62634": "40.0132_-89.452", "62635": "40.2967_-89.4714", "62643": "40.2451_-89.4519", "62656": "40.1451_-89.3684", "62666": "40.0967_-89.5818", "62671": "40.1682_-89.5604", "61411": "40.3852_-90.5037", "61416": "40.495_-90.5646", "61420": "40.5516_-90.8595", "61422": "40.5539_-90.506", "61438": "40.5578_-90.6735", "61440": "40.3256_-90.6105", "61455": "40.4617_-90.6787", "61470": "40.618_-90.4727", "61475": "40.5832_-90.7316", "62326": "40.4156_-90.7846", "62374": "40.414_-90.8556", "60001": "42.3248_-88.4525", "60012": "42.2662_-88.3213", "60013": "42.2196_-88.2426", "60014": "42.2308_-88.3324", "60021": "42.1936_-88.2205", "60033": "42.4227_-88.6048", "60034": "42.4642_-88.4176", "60039": "42.3248_-88.4525", "60050": "42.3311_-88.2955", "60051": "42.3542_-88.2294", "60071": "42.4669_-88.29", "60072": "42.4048_-88.3054", "60081": "42.4413_-88.2237", "60097": "42.3849_-88.3534", "60098": "42.3198_-88.4477", "60102": "42.1641_-88.3064", "60142": "42.1756_-88.4268", "60152": "42.2442_-88.6074", "60156": "42.1817_-88.3304", "60180": "42.2103_-88.5283", "61701": "40.4783_-88.9893", "61702": "40.5192_-88.8643", "61704": "40.4705_-88.9433", "61705": "40.44_-89.067", "61709": "40.4614_-88.953", "61710": "40.4777_-88.9542", "61720": "40.5441_-88.5266", "61722": "40.412_-88.6296", "61724": "40.3401_-88.5227", "61725": "40.6029_-89.1098", "61726": "40.7446_-88.7219", "61728": "40.5704_-88.62", "61730": "40.536_-88.735", "61731": "40.603_-88.4943", "61732": "40.5364_-89.1885", "61736": "40.3989_-88.8686", "61737": "40.4432_-88.7371", "61744": "40.7439_-88.884", "61745": "40.3307_-88.9776", "61748": "40.6205_-88.9759", "61752": "40.3468_-88.7598", "61753": "40.6357_-88.8062", "61754": "40.3282_-89.1645", "61758": "40.5167_-88.8259", "61761": "40.5124_-88.9883", "61770": "40.432_-88.5247", "61772": "40.4174_-89.0822", "61774": "40.4376_-89.2164", "61776": "40.5533_-88.8886", "61790": "40.5103_-88.998", "61791": "40.5192_-88.8643", "61799": "40.4885_-88.9396", "61756": "40.0342_-88.9578", "62501": "39.934_-88.8052", "62513": "39.6978_-89.1136", "62514": "39.7624_-89.0507", "62521": "39.8395_-88.9465", "62522": "39.8432_-88.9861", "62523": "39.8417_-88.9534", "62524": "39.854_-88.9815", "62525": "39.854_-88.9815", "62526": "39.8583_-88.9382", "62532": "39.78_-88.9808", "62535": "39.9248_-88.9691", "62537": "39.8567_-89.085", "62544": "39.7041_-88.988", "62549": "39.7705_-88.8659", "62551": "39.8582_-89.1701", "62554": "39.9351_-88.8547", "62573": "39.9454_-89.0741", "62009": "39.0939_-89.8031", "62014": "39.0408_-89.9624", "62023": "39.1118_-89.7855", "62033": "39.1341_-89.8442", "62069": "39.0705_-89.7448", "62079": "39.1159_-90.1237", "62085": "39.0828_-89.8043", "62088": "39.0135_-89.7857", "62093": "39.0695_-89.8565", "62626": "39.2885_-89.8661", "62630": "39.2608_-90.0784", "62640": "39.3838_-89.8501", "62649": "39.3752_-90.0672", "62667": "39.476_-89.9794", "62672": "39.398_-89.8045", "62674": "39.4227_-90.0311", "62683": "39.4803_-90.1048", "62685": "39.1952_-89.9607", "62690": "39.5064_-89.7783", "62001": "38.8822_-89.7441", "62002": "38.9087_-90.1568", "62010": "38.9074_-90.0344", "62018": "38.9124_-90.0826", "62021": "38.9832_-89.9786", "62024": "38.8803_-90.083", "62025": "38.805_-89.9637", "62026": "38.8114_-89.9532", "62034": "38.7609_-89.9706", "62035": "38.946_-90.206", "62040": "38.7261_-90.1106", "62046": "38.8901_-89.8457", "62048": "38.8278_-90.0926", "62058": "38.969_-89.7668", "62060": "38.6811_-90.1566", "62061": "38.7793_-89.7786", "62062": "38.7138_-89.9658", "62067": "38.9318_-89.9618", "62074": "38.9676_-89.7392", "62084": "38.8482_-90.0798", "62087": "38.8225_-90.0583", "62090": "38.6706_-90.1689", "62095": "38.8643_-90.0875", "62097": "38.9449_-89.8532", "62234": "38.6835_-89.9853", "62249": "38.7631_-89.6789", "62281": "38.7059_-89.7925", "62294": "38.7243_-89.8708", "62801": "38.5241_-89.1365", "62807": "38.7231_-88.9157", "62849": "38.6136_-88.7689", "62853": "38.5147_-88.9127", "62854": "38.7559_-88.813", "62870": "38.6088_-89.0552", "62875": "38.7549_-89.0942", "62881": "38.6264_-88.9481", "62882": "38.6131_-89.114", "62892": "38.8033_-89.083", "62893": "38.467_-89.0328", "61369": "41.0046_-89.1348", "61375": "41.0327_-89.2483", "61377": "41.0548_-89.0416", "61424": "41.078_-89.6332", "61537": "41.1115_-89.3743", "61540": "41.0216_-89.4008", "61541": "40.9823_-89.2354", "61565": "41.0134_-89.4571", "61570": "40.9141_-89.283", "61532": "40.3594_-89.8334", "61546": "40.416_-89.7898", "61567": "40.3303_-89.9312", "62617": "40.1536_-90.1661", "62633": "40.2279_-89.8903", "62644": "40.3_-90.061", "62655": "40.1587_-90.0043", "62664": "40.2023_-89.6982", "62682": "40.3011_-89.6872", "62910": "37.1542_-88.5334", "62953": "37.2092_-88.8442", "62960": "37.1753_-88.7252", "62613": "39.9917_-89.6684", "62642": "40.1017_-89.7469", "62659": "40.0311_-89.7867", "62673": "40.0994_-89.9601", "62675": "40.0117_-89.8482", "62688": "39.9445_-89.9373", "61231": "41.2008_-90.7416", "61260": "41.2262_-90.8518", "61263": "41.2599_-90.6128", "61272": "41.2153_-90.9879", "61276": "41.2996_-90.5866", "61281": "41.3027_-90.4939", "61412": "41.0521_-90.5436", "61442": "41.1043_-90.9263", "61465": "41.1987_-90.4598", "61466": "41.1006_-90.4736", "61476": "41.0732_-90.8257", "61486": "41.2024_-90.5936", "62236": "38.4325_-90.2027", "62244": "38.1797_-90.1974", "62248": "38.3044_-89.9935", "62256": "38.3043_-90.1356", "62279": "38.1521_-90.1346", "62295": "38.2805_-90.3122", "62298": "38.3223_-90.1478", "62015": "39.2114_-89.5305", "62017": "39.0908_-89.3945", "62032": "39.1039_-89.2946", "62049": "39.1494_-89.4881", "62051": "39.2089_-89.4104", "62056": "39.1793_-89.6499", "62075": "39.3036_-89.2853", "62076": "39.3434_-89.2191", "62077": "39.0317_-89.5237", "62089": "39.1309_-89.492", "62091": "39.0473_-89.635", "62094": "39.2469_-89.3414", "62533": "39.4401_-89.617", "62538": "39.3719_-89.538", "62560": "39.3106_-89.5851", "62572": "39.3688_-89.6545", "62601": "39.7517_-90.0458", "62628": "39.7716_-90.4113", "62631": "39.823_-90.3722", "62638": "39.6222_-90.0889", "62650": "39.7339_-90.229", "62651": "39.6983_-90.2615", "62660": "39.8589_-90.2007", "62665": "39.8173_-90.5339", "62668": "39.5723_-90.2379", "62692": "39.587_-89.9449", "62695": "39.6289_-90.219", "61914": "39.6348_-88.7543", "61925": "39.7119_-88.7975", "61928": "39.4796_-88.5242", "61937": "39.7192_-88.6417", "61951": "39.5934_-88.6038", "60113": "41.9312_-88.9566", "61007": "42.1905_-89.5939", "61010": "42.1292_-89.2659", "61015": "41.9933_-89.2117", "61020": "42.0979_-89.0838", "61030": "42.1229_-89.5831", "61043": "42.0647_-89.0957", "61047": "42.1532_-89.3959", "61049": "42.0507_-89.034", "61052": "42.105_-89.0169", "61054": "42.0479_-89.4346", "61061": "42.0095_-89.3444", "61064": "41.989_-89.5984", "61068": "41.9282_-89.071", "61084": "42.1183_-89.1898", "61091": "41.9034_-89.5409", "61451": "40.9335_-89.9349", "61517": "40.8407_-89.897", "61523": "40.9013_-89.5068", "61525": "40.8444_-89.6397", "61526": "40.9454_-89.5858", "61528": "40.779_-89.723", "61529": "40.7726_-89.9289", "61533": "40.576_-89.8113", "61536": "40.6798_-89.7952", "61539": "40.5571_-89.7685", "61547": "40.6117_-89.7184", "61552": "40.818_-89.568", "61562": "40.8743_-89.5067", "61569": "40.6795_-89.9135", "61601": "40.6931_-89.5898", "61602": "40.6936_-89.589", "61603": "40.7132_-89.577", "61604": "40.7111_-89.6324", "61605": "40.6775_-89.6263", "61606": "40.6989_-89.6122", "61607": "40.6321_-89.6903", "61612": "40.7442_-89.7184", "61613": "40.7425_-89.6279", "61614": "40.7681_-89.6026", "61615": "40.7661_-89.645", "61616": "40.7473_-89.574", "61625": "40.6963_-89.6166", "61629": "40.692_-89.5887", "61630": "40.7442_-89.7184", "61633": "40.7312_-89.6031", "61634": "40.6896_-89.5926", "61636": "40.6999_-89.5951", "61637": "40.7025_-89.5898", "61638": "40.7969_-89.6111", "61639": "40.7098_-89.5636", "61641": "40.64_-89.652", "61643": "40.7442_-89.7184", "61650": "40.7442_-89.7184", "61651": "40.7442_-89.7184", "61652": "40.8767_-89.5091", "61653": "40.7442_-89.7184", "61654": "40.7442_-89.7184", "61655": "40.7442_-89.7184", "61656": "40.7442_-89.7184", "62238": "38.0427_-89.5661", "62274": "38.0903_-89.3858", "62832": "38.0137_-89.2333", "62888": "38.138_-89.2231", "62997": "37.9848_-89.5899", "61813": "39.9222_-88.5688", "61818": "39.8681_-88.7256", "61830": "39.9972_-88.6962", "61839": "40.1107_-88.6392", "61854": "40.2147_-88.5179", "61855": "39.9238_-88.6599", "61856": "40.0263_-88.5686", "61884": "40.1009_-88.5193", "61929": "39.7946_-88.5793", "61936": "39.7983_-88.7272", "62312": "39.7047_-91.0265", "62314": "39.7612_-90.8832", "62323": "39.8071_-90.663", "62340": "39.7084_-90.7249", "62343": "39.7186_-91.2338", "62345": "39.6953_-91.1637", "62352": "39.5645_-90.6504", "62355": "39.4202_-90.7692", "62356": "39.6342_-91.0886", "62357": "39.6996_-90.844", "62361": "39.4441_-90.638", "62362": "39.7823_-90.7471", "62363": "39.6013_-90.8073", "62366": "39.4467_-90.877", "62370": "39.5328_-90.9722", "62928": "37.4829_-88.5791", "62938": "37.3602_-88.4886", "62947": "37.5634_-88.44", "62941": "37.251_-89.0083", "62956": "37.2911_-88.9739", "62963": "37.0865_-89.1637", "62964": "37.1188_-89.2001", "62970": "37.1935_-89.0933", "62973": "37.3113_-89.0831", "62976": "37.2146_-89.1968", "62992": "37.277_-89.1834", "62996": "37.1578_-89.1825", "61326": "41.2642_-89.225", "61327": "41.2352_-89.3218", "61335": "41.173_-89.2187", "61336": "41.1164_-89.227", "61340": "41.266_-89.2491", "61363": "41.2567_-89.1778", "61560": "41.1949_-89.4409", "62217": "38.1754_-89.8414", "62233": "37.9188_-89.8218", "62237": "38.1753_-89.6479", "62241": "38.0054_-89.9008", "62242": "38.0926_-89.917", "62259": "37.9101_-89.8398", "62261": "38.0507_-90.0163", "62272": "38.0126_-89.617", "62277": "38.0831_-90.0959", "62278": "38.1907_-89.9884", "62280": "37.8322_-89.6214", "62286": "38.1318_-89.7035", "62288": "38.0057_-89.6665", "62292": "38.2122_-89.6895", "62297": "38.0203_-89.8297", "62419": "38.6351_-88.0037", "62421": "38.7429_-87.9727", "62425": "38.8306_-88.0973", "62450": "38.7334_-88.0809", "62452": "38.59_-88.0647", "62868": "38.7119_-88.219", "61201": "41.4913_-90.5648", "61204": "41.5549_-90.616", "61232": "41.4392_-90.7176", "61236": "41.5147_-90.3577", "61237": "41.3368_-90.8522", "61239": "41.4948_-90.3907", "61240": "41.4351_-90.4652", "61242": "41.6928_-90.3071", "61244": "41.5118_-90.4321", "61256": "41.5559_-90.4093", "61257": "41.5929_-90.2263", "61259": "41.3892_-90.8925", "61264": "41.4262_-90.5739", "61265": "41.4906_-90.498", "61266": "41.5067_-90.5151", "61275": "41.6013_-90.3263", "61278": "41.5817_-90.3435", "61279": "41.3277_-90.6384", "61282": "41.5007_-90.4126", "61284": "41.3828_-90.734", "61299": "41.5203_-90.5416", "62059": "38.44_-89.9835", "62071": "38.6516_-90.1639", "62201": "38.6427_-90.1387", "62202": "38.6163_-90.1591", "62203": "38.5992_-90.0744", "62204": "38.6308_-90.095", "62205": "38.6149_-90.1275", "62206": "38.5514_-90.1544", "62207": "38.587_-90.1278", "62208": "38.596_-90.0071", "62220": "38.5127_-89.9847", "62221": "38.5396_-89.9583", "62222": "38.44_-89.9835", "62223": "38.5456_-90.0378", "62225": "38.5432_-89.859", "62226": "38.5352_-90.0006", "62232": "38.6345_-90.0135", "62239": "38.5162_-90.2104", "62240": "38.5349_-90.2208", "62243": "38.408_-89.9181", "62254": "38.6053_-89.7992", "62255": "38.295_-89.7922", "62257": "38.2455_-89.7501", "62258": "38.4745_-89.7877", "62260": "38.4443_-90.0888", "62264": "38.316_-89.8728", "62269": "38.5718_-89.8957", "62282": "38.3632_-89.7139", "62285": "38.4231_-89.9896", "62289": "38.5967_-89.7512", "62917": "37.6842_-88.6328", "62930": "37.8139_-88.4434", "62935": "37.8274_-88.6235", "62946": "37.7257_-88.544", "62965": "37.765_-88.5167", "62977": "37.8256_-88.5324", "62987": "37.6432_-88.6228", "62515": "39.8499_-89.3879", "62520": "39.8563_-89.4603", "62530": "39.5692_-89.6626", "62536": "39.6327_-89.6581", "62539": "39.8499_-89.2513", "62545": "39.7778_-89.4064", "62558": "39.6086_-89.5678", "62561": "39.8663_-89.5087", "62563": "39.7182_-89.5649", "62615": "39.5918_-89.744", "62625": "39.9169_-89.6891", "62629": "39.6737_-89.7112", "62661": "39.6704_-89.8588", "62662": "39.5509_-89.8459", "62670": "39.7681_-89.855", "62677": "39.8331_-89.8686", "62684": "39.9121_-89.5877", "62689": "39.5394_-89.7621", "62693": "39.9542_-89.5487", "62701": "39.8_-89.6495", "62702": "39.8317_-89.6465", "62703": "39.7622_-89.6275", "62704": "39.7725_-89.6889", "62705": "39.8017_-89.6437", "62706": "39.7989_-89.6534", "62707": "39.8544_-89.6544", "62708": "39.8061_-89.5864", "62711": "39.7655_-89.7293", "62712": "39.7533_-89.58", "62715": "39.8017_-89.6437", "62716": "39.8482_-89.5364", "62719": "39.7495_-89.606", "62722": "39.7495_-89.606", "62723": "39.7495_-89.606", "62726": "39.7495_-89.606", "62736": "39.7495_-89.606", "62739": "39.8017_-89.6437", "62756": "39.7495_-89.606", "62757": "39.8017_-89.6437", "62761": "39.8524_-89.541", "62762": "39.7495_-89.606", "62763": "39.7495_-89.606", "62764": "39.7495_-89.606", "62765": "39.8017_-89.6437", "62766": "39.7495_-89.606", "62767": "39.7495_-89.606", "62769": "39.8017_-89.6437", "62776": "39.7495_-89.606", "62777": "39.7495_-89.606", "62781": "39.7495_-89.606", "62786": "39.7495_-89.606", "62791": "39.7495_-89.606", "62794": "39.7495_-89.606", "62796": "39.7495_-89.606", "61452": "40.2339_-90.619", "62319": "40.1511_-90.7544", "62344": "40.1544_-90.8531", "62624": "40.1289_-90.3721", "62639": "40.07_-90.429", "62681": "40.1133_-90.5432", "62610": "39.5606_-90.434", "62621": "39.7296_-90.5313", "62663": "39.5405_-90.3317", "62694": "39.6266_-90.4664", "61957": "39.4302_-88.5857", "62422": "39.2326_-88.8868", "62431": "39.2245_-88.9812", "62438": "39.3134_-88.8715", "62444": "39.2664_-88.7337", "62462": "39.2176_-88.4803", "62463": "39.272_-88.6319", "62465": "39.3641_-88.6279", "62534": "39.5193_-88.7468", "62550": "39.6248_-89.019", "62553": "39.2884_-89.0836", "62565": "39.458_-88.8058", "62571": "39.39_-88.9597", "61421": "41.1532_-89.6521", "61426": "41.1183_-89.7071", "61449": "41.1095_-89.9575", "61479": "40.9872_-89.652", "61483": "41.1009_-89.8606", "61491": "41.0599_-89.7782", "61559": "40.9093_-89.7723", "61013": "42.3761_-89.6365", "61018": "42.4031_-89.5468", "61019": "42.4422_-89.4067", "61027": "42.332_-89.7612", "61032": "42.2991_-89.6345", "61039": "42.2176_-89.4712", "61044": "42.3155_-89.9195", "61048": "42.3791_-89.8253", "61050": "42.4281_-89.7643", "61060": "42.4728_-89.6448", "61062": "42.261_-89.8393", "61067": "42.2996_-89.4627", "61070": "42.4103_-89.4759", "61089": "42.4838_-89.806", "61534": "40.4198_-89.6549", "61535": "40.5925_-89.5345", "61550": "40.6148_-89.4604", "61554": "40.5674_-89.6243", "61555": "40.5607_-89.6502", "61558": "40.5675_-89.6407", "61564": "40.4945_-89.6518", "61568": "40.5053_-89.4833", "61571": "40.7034_-89.4194", "61610": "40.6428_-89.5988", "61611": "40.6731_-89.5514", "61635": "40.6661_-89.5801", "61721": "40.3613_-89.3231", "61733": "40.6224_-89.3323", "61734": "40.369_-89.5321", "61747": "40.4273_-89.4214", "61755": "40.5396_-89.3458", "61759": "40.4359_-89.3165", "62905": "37.5681_-89.3172", "62906": "37.4668_-89.2207", "62920": "37.5424_-89.2457", "62926": "37.3712_-89.1349", "62952": "37.4461_-89.2915", "62961": "37.3409_-89.2542", "62998": "37.512_-89.4408", "60932": "40.4633_-87.8056", "60942": "40.4639_-87.6662", "60960": "40.4559_-87.8884", "60963": "40.3625_-87.6692", "61810": "39.9188_-87.9312", "61811": "40.3007_-87.608", "61812": "40.2175_-87.8943", "61814": "40.2552_-87.6138", "61817": "40.0699_-87.7113", "61831": "40.2207_-87.7987", "61832": "40.137_-87.6217", "61833": "40.0964_-87.644", "61834": "40.1602_-87.6729", "61841": "40.0373_-87.8365", "61844": "40.1192_-87.8797", "61846": "39.9792_-87.6365", "61848": "40.304_-87.7007", "61850": "39.9268_-87.7388", "61857": "40.1165_-87.8447", "61858": "40.1167_-87.7825", "61865": "40.309_-87.8232", "61870": "39.9155_-87.6346", "61876": "39.911_-87.8248", "61883": "40.0451_-87.636", "62410": "38.5232_-87.7219", "62811": "38.3845_-87.9081", "62852": "38.3514_-87.8661", "62855": "38.4034_-87.8187", "62863": "38.4147_-87.7911", "61417": "40.7799_-90.5059", "61423": "40.889_-90.5001", "61435": "40.9863_-90.5491", "61447": "40.8638_-90.7457", "61453": "41.0153_-90.7364", "61462": "40.9107_-90.6448", "61473": "40.7238_-90.6514", "61478": "40.7579_-90.7606", "62214": "38.3815_-89.5794", "62263": "38.3352_-89.3841", "62268": "38.2573_-89.596", "62271": "38.4319_-89.523", "62803": "38.4455_-89.3069", "62808": "38.306_-89.2311", "62831": "38.2239_-89.2123", "62848": "38.4366_-89.1648", "62876": "38.2607_-89.1989", "62877": "38.4082_-89.1756", "62446": "38.5222_-88.2185", "62809": "38.2845_-88.3642", "62823": "38.5159_-88.4375", "62837": "38.3782_-88.3593", "62842": "38.4413_-88.4144", "62843": "38.3645_-88.2075", "62850": "38.5223_-88.537", "62851": "38.3691_-88.6481", "62878": "38.5806_-88.4641", "62886": "38.3923_-88.5306", "62895": "38.3328_-88.5833", "62820": "38.2082_-88.2147", "62821": "38.0808_-88.167", "62827": "38.166_-88.0595", "62834": "37.9762_-88.1202", "62835": "38.0927_-88.3325", "62844": "38.2627_-88.0035", "62861": "38.0356_-88.0456", "62862": "38.2447_-88.3338", "62869": "37.9773_-88.3243", "62887": "38.1699_-88.3726", "61037": "41.7865_-89.761", "61071": "41.7665_-89.6925", "61081": "41.8055_-89.7054", "61230": "41.7659_-90.2081", "61243": "41.6316_-89.6972", "61250": "41.656_-90.0843", "61251": "41.7285_-90.0457", "61252": "41.8522_-90.1507", "61261": "41.7199_-89.9169", "61270": "41.8167_-89.969", "61277": "41.6312_-89.9467", "61283": "41.6522_-89.7948", "60401": "41.3444_-87.6115", "60403": "41.5548_-88.0987", "60404": "41.5076_-88.2169", "60408": "41.2657_-88.2231", "60410": "41.4347_-88.2138", "60417": "41.439_-87.6027", "60421": "41.426_-88.0864", "60423": "41.5094_-87.8248", "60428": "41.5998_-87.6906", "60431": "41.4712_-87.9391", "60432": "41.5378_-88.0572", "60433": "41.5119_-88.0569", "60434": "41.5254_-88.0842", "60435": "41.5454_-88.1299", "60436": "41.4884_-88.1572", "60440": "41.6976_-88.0873", "60441": "41.593_-88.0507", "60442": "41.4289_-87.9771", "60446": "41.6404_-88.0696", "60448": "41.5342_-87.8911", "60449": "41.4191_-87.7748", "60451": "41.5067_-87.9631", "60468": "41.3361_-87.7897", "60481": "41.3078_-88.1467", "60484": "41.4418_-87.7101", "60487": "41.5636_-87.8342", "60490": "41.679_-88.1403", "60491": "41.6028_-87.9599", "60503": "41.7199_-88.2548", "60544": "41.6009_-88.1994", "60564": "41.704_-88.1952", "60585": "41.6558_-88.2203", "60586": "41.5642_-88.2178", "62841": "37.8612_-88.9973", "62915": "37.7814_-89.1192", "62918": "37.7748_-89.0978", "62921": "37.8053_-89.0801", "62922": "37.6195_-88.8367", "62933": "37.7726_-89.025", "62948": "37.8019_-89.0232", "62949": "37.8366_-89.1424", "62951": "37.8245_-88.9209", "62959": "37.7257_-88.9294", "62974": "37.8047_-88.8081", "61016": "42.2206_-88.9619", "61024": "42.4337_-89.3094", "61063": "42.3051_-89.3472", "61072": "42.4544_-89.0887", "61073": "42.4217_-88.9943", "61077": "42.2368_-89.358", "61079": "42.4445_-89.1976", "61080": "42.4837_-89.0298", "61088": "42.2727_-89.2373", "61101": "42.2922_-89.1161", "61102": "42.2547_-89.1247", "61103": "42.301_-89.0833", "61104": "42.2554_-89.0768", "61105": "42.2711_-89.094", "61106": "42.3254_-89.1705", "61107": "42.2786_-89.0361", "61108": "42.2514_-89.0235", "61109": "42.2166_-89.0512", "61110": "42.3254_-89.1705", "61111": "42.3295_-89.0335", "61112": "42.2456_-88.9704", "61114": "42.3185_-88.9972", "61115": "42.3545_-89.0397", "61125": "42.3254_-89.1705", "61126": "42.3254_-89.1705", "61130": "42.3254_-89.1705", "61131": "42.3254_-89.1705", "61132": "42.3254_-89.1705", "61516": "40.8306_-89.1165", "61530": "40.7152_-89.2706", "61545": "40.8793_-89.3703", "61548": "40.7844_-89.4309", "61561": "40.7956_-89.2093", "61729": "40.6208_-89.1994", "61738": "40.7389_-89.012", "61742": "40.6329_-89.2727", "61760": "40.8985_-89.0349", "61771": "40.7224_-89.1271", "46711": "40.6716_-84.9343", "46733": "40.8273_-84.9314", "46740": "40.6071_-84.9621", "46769": "40.645_-85.033", "46772": "40.7005_-84.8441", "46780": "40.7778_-84.8422", "46782": "40.832_-85.0054", "46704": "41.1038_-85.2925", "46741": "41.2108_-84.9406", "46743": "41.2285_-84.8386", "46745": "40.9524_-85.0075", "46748": "41.2391_-85.1677", "46765": "41.2249_-85.0301", "46773": "40.987_-84.8937", "46774": "41.0699_-85.0117", "46797": "41.1253_-84.8533", "46798": "40.9371_-85.1958", "46799": "40.9188_-85.2824", "46801": "41.0938_-85.0707", "46802": "41.0707_-85.1543", "46803": "41.0695_-85.1074", "46804": "41.0508_-85.256", "46805": "41.0977_-85.1189", "46806": "41.048_-85.1135", "46807": "41.0491_-85.1462", "46808": "41.0939_-85.1621", "46809": "41.0254_-85.1834", "46814": "41.0456_-85.3058", "46815": "41.1053_-85.0624", "46816": "41.0165_-85.0976", "46818": "41.1468_-85.2067", "46819": "41.0052_-85.1527", "46825": "41.1465_-85.1232", "46835": "41.1371_-85.0685", "46845": "41.1958_-85.1191", "46850": "41.0938_-85.0707", "46851": "41.0938_-85.0707", "46852": "41.0938_-85.0707", "46853": "41.0938_-85.0707", "46854": "41.0938_-85.0707", "46855": "41.0938_-85.0707", "46856": "41.0938_-85.0707", "46857": "41.0938_-85.0707", "46858": "41.0938_-85.0707", "46859": "41.0938_-85.0707", "46860": "41.0938_-85.0707", "46861": "41.0938_-85.0707", "46862": "41.0938_-85.0707", "46863": "41.0938_-85.0707", "46864": "41.0938_-85.0707", "46865": "41.1263_-85.0907", "46866": "41.0938_-85.0707", "46867": "41.0938_-85.0707", "46868": "41.0938_-85.0707", "46869": "41.0938_-85.0707", "46885": "41.0938_-85.0707", "46895": "41.0938_-85.0707", "46896": "41.0938_-85.0707", "46897": "41.0938_-85.0707", "46898": "41.0938_-85.0707", "46899": "41.0938_-85.0707", "47201": "39.2055_-85.9317", "47202": "39.2014_-85.9214", "47203": "39.2301_-85.8855", "47226": "39.2826_-85.8685", "47232": "39.1243_-85.8153", "47236": "39.1522_-85.7261", "47244": "39.2676_-85.698", "47246": "39.3039_-85.7714", "47247": "39.0593_-85.8886", "47280": "39.2953_-85.9498", "47917": "40.4793_-87.4796", "47921": "40.518_-87.3789", "47942": "40.6945_-87.4232", "47944": "40.6255_-87.309", "47970": "40.517_-87.1225", "47971": "40.5217_-87.2526", "47984": "40.5053_-87.4542", "47986": "40.5055_-87.207", "47348": "40.4541_-85.3758", "47359": "40.5577_-85.2513", "46052": "40.0449_-86.4641", "46071": "40.1133_-86.5898", "46075": "40_-86.3507", "46077": "39.9561_-86.2767", "46102": "39.9956_-86.6198", "46147": "39.9579_-86.6236", "46160": "39.3628_-86.2803", "47435": "39.1963_-86.2302", "47448": "39.2367_-86.222", "46913": "40.5163_-86.5204", "46915": "40.4777_-86.3866", "46916": "40.6767_-86.5075", "46917": "40.5996_-86.5152", "46920": "40.4785_-86.4462", "46923": "40.5734_-86.6788", "46929": "40.5445_-86.5016", "46977": "40.6411_-86.5739", "47997": "40.6677_-86.7236", "46932": "40.5862_-86.1972", "46942": "40.7361_-86.3734", "46947": "40.7604_-86.3599", "46950": "40.8614_-86.4077", "46961": "40.7621_-86.1936", "46967": "40.6947_-86.1951", "46978": "40.8645_-86.5078", "46988": "40.8547_-86.2126", "46994": "40.6772_-86.2805", "46998": "40.5686_-86.3467", "47104": "38.5399_-85.4218", "47106": "38.4362_-85.9215", "47111": "38.4568_-85.6606", "47126": "38.5398_-85.7734", "47129": "38.311_-85.7645", "47130": "38.3078_-85.7359", "47131": "38.437_-85.705", "47132": "38.2868_-85.7321", "47133": "38.2868_-85.7321", "47134": "38.2868_-85.7321", "47141": "38.5856_-85.6436", "47143": "38.4642_-85.7775", "47144": "38.2868_-85.7321", "47147": "38.6128_-85.5217", "47162": "38.5575_-85.4599", "47163": "38.5423_-85.6647", "47172": "38.4046_-85.788", "47177": "38.6037_-85.7744", "47190": "38.437_-85.705", "47199": "38.2868_-85.7321", "47833": "39.3812_-87.0052", "47834": "39.521_-87.1278", "47837": "39.5913_-87.1132", "47840": "39.391_-87.0935", "47841": "39.2727_-87.1082", "47845": "39.1934_-87.2311", "47846": "39.3435_-87.1956", "47853": "39.5372_-87.0729", "47857": "39.5269_-87.0869", "47868": "39.4462_-86.9631", "47881": "39.4875_-87.1889", "46035": "40.1956_-86.6593", "46039": "40.3757_-86.3201", "46041": "40.3044_-86.4689", "46050": "40.2031_-86.3324", "46057": "40.3108_-86.3753", "46058": "40.3433_-86.6613", "46065": "40.4109_-86.608", "46067": "40.4156_-86.5147", "47116": "38.3185_-86.6059", "47118": "38.3258_-86.4429", "47123": "38.282_-86.4843", "47137": "38.1865_-86.3838", "47140": "38.3736_-86.3578", "47145": "38.3445_-86.3003", "47174": "38.2259_-86.4908", "47175": "38.3463_-86.5387", "47501": "38.6536_-87.1707", "47519": "38.6698_-86.9983", "47529": "38.8772_-87.085", "47558": "38.6521_-87.0476", "47562": "38.8187_-86.9752", "47568": "38.8062_-87.1522", "47001": "39.0719_-84.9452", "47018": "38.9962_-85.055", "47022": "39.2059_-84.9616", "47025": "39.1401_-84.8658", "47032": "39.0945_-85.0638", "47060": "39.3008_-84.881", "47225": "39.4241_-85.3477", "47240": "39.2998_-85.4918", "47261": "39.292_-85.4918", "47263": "39.3083_-85.3297", "47272": "39.4277_-85.5994", "47283": "39.1749_-85.5856", "46705": "41.5347_-85.0504", "46706": "41.359_-85.0468", "46721": "41.4287_-84.8787", "46730": "41.4504_-85.137", "46738": "41.3482_-85.1347", "46785": "41.324_-84.9043", "46788": "41.2696_-84.9398", "46793": "41.4402_-85.0221", "47302": "40.1684_-85.3807", "47303": "40.218_-85.379", "47304": "40.2111_-85.4291", "47305": "40.1933_-85.3862", "47306": "40.2023_-85.4082", "47307": "40.1621_-85.4428", "47308": "40.2279_-85.3967", "47320": "40.292_-85.258", "47334": "40.1257_-85.511", "47338": "40.3377_-85.3544", "47342": "40.2948_-85.4898", "47367": "40.0792_-85.39", "47383": "40.1693_-85.2738", "47396": "40.1836_-85.496", "47513": "38.3006_-86.7102", "47521": "38.3878_-86.7568", "47527": "38.4728_-86.7832", "47532": "38.2336_-86.8607", "47541": "38.2456_-87.0361", "47542": "38.2979_-86.9533", "47545": "38.4137_-87.0009", "47546": "38.3604_-86.9295", "47547": "38.3647_-86.8762", "47549": "38.3647_-86.8762", "47575": "38.3211_-86.8234", "47580": "38.3414_-86.7565", "46507": "41.7169_-85.8262", "46514": "41.7101_-85.9729", "46515": "41.682_-85.9767", "46516": "41.6763_-85.9621", "46517": "41.6469_-85.9728", "46526": "41.5848_-85.8581", "46527": "41.5977_-85.8581", "46528": "41.6248_-85.8391", "46540": "41.6754_-85.7114", "46543": "41.5335_-85.7072", "46550": "41.4493_-85.9945", "46553": "41.4917_-85.8338", "46573": "41.5401_-86.0205", "46133": "39.6124_-85.2735", "47322": "39.657_-85.168", "47331": "39.6435_-85.1464", "47119": "38.351_-85.8996", "47122": "38.3029_-85.9617", "47124": "38.3535_-86.0083", "47146": "38.2985_-85.897", "47150": "38.3089_-85.8221", "47151": "38.2856_-85.8241", "47918": "40.2811_-87.2241", "47932": "40.1326_-87.3819", "47949": "40.0835_-87.1545", "47952": "40.0174_-87.2569", "47958": "40.1641_-87.1475", "47969": "40.2035_-87.147", "47987": "40.1186_-87.2602", "47988": "39.9865_-87.1477", "47003": "39.5676_-84.8161", "47010": "39.4992_-84.836", "47012": "39.4213_-84.9994", "47016": "39.3459_-84.8924", "47024": "39.4916_-85.208", "47030": "39.4288_-85.1504", "47035": "39.31_-84.9007", "47036": "39.3862_-85.2385", "46910": "41.0389_-86.0395", "46912": "41.0537_-86.1253", "46922": "41.1384_-86.4164", "46931": "40.9473_-86.2628", "46935": "40.9475_-86.4044", "46939": "41.0087_-86.4061", "46945": "41.1217_-86.3858", "46975": "41.0655_-86.231", "47639": "38.1895_-87.5798", "47640": "38.4623_-87.4983", "47647": "38.2284_-87.412", "47648": "38.2471_-87.5682", "47649": "38.333_-87.4536", "47654": "38.2523_-87.3917", "47660": "38.3361_-87.3519", "47665": "38.2744_-87.7091", "47666": "38.4143_-87.5958", "47670": "38.3525_-87.5691", "47683": "38.2764_-87.3778", "46928": "40.4188_-85.6713", "46930": "40.4099_-85.571", "46933": "40.4879_-85.6055", "46938": "40.4815_-85.6365", "46952": "40.5743_-85.6741", "46953": "40.5359_-85.6616", "46957": "40.3887_-85.4994", "46986": "40.5112_-85.8265", "46987": "40.5647_-85.7656", "46989": "40.4548_-85.499", "46991": "40.6174_-85.5148", "47424": "39.0295_-86.8675", "47438": "39.1723_-87.2023", "47439": "39.0371_-86.9616", "47441": "39.0461_-87.1723", "47443": "38.9717_-87.1016", "47445": "39.122_-87.1917", "47449": "38.9229_-87.0081", "47453": "38.9253_-86.7742", "47457": "38.9128_-86.9039", "47459": "39.119_-86.7378", "47465": "39.0369_-87.0502", "47471": "39.123_-86.9991", "46030": "40.1776_-86.0409", "46031": "40.2103_-86.019", "46032": "39.9712_-86.1245", "46033": "39.9744_-86.0829", "46034": "40.1298_-86.0381", "46037": "39.9559_-85.9601", "46038": "39.9575_-86.023", "46060": "40.0563_-86.0163", "46061": "40.0725_-86.0523", "46062": "40.0617_-86.0555", "46069": "40.135_-86.2205", "46074": "40.0489_-86.1499", "46082": "40.0725_-86.0523", "46085": "39.9556_-86.0139", "46262": "39.7684_-86.158", "46280": "39.9416_-86.1157", "46288": "39.9347_-86.1633", "46290": "39.9347_-86.1633", "46040": "39.9323_-85.848", "46055": "39.9081_-85.9228", "46117": "39.8388_-85.6258", "46129": "39.8215_-85.7652", "46140": "39.7902_-85.8141", "46154": "39.8568_-85.7684", "46163": "39.7233_-85.9052", "46186": "39.8957_-85.6144", "47107": "38.3678_-86.0619", "47110": "38.097_-86.1723", "47112": "38.2189_-86.1145", "47114": "38.2876_-86.0664", "47115": "38.3361_-86.2109", "47117": "38.1244_-85.9589", "47135": "38.0527_-86.0844", "47136": "38.2448_-85.9593", "47142": "38.0437_-86.1846", "47160": "38.1645_-86.051", "47161": "38.3399_-86.0887", "47164": "38.4105_-86.0888", "47166": "38.3034_-86.169", "46103": "39.6886_-86.6136", "46112": "39.8466_-86.3869", "46118": "39.6682_-86.4959", "46121": "39.6878_-86.6703", "46122": "39.7628_-86.5343", "46123": "39.7629_-86.3996", "46149": "39.8843_-86.5429", "46165": "39.8671_-86.6388", "46167": "39.8615_-86.4645", "46168": "39.6893_-86.3919", "46180": "39.6391_-86.6182", "46148": "39.806_-85.5261", "47337": "39.8031_-85.4371", "47344": "39.8789_-85.464", "47351": "39.904_-85.5205", "47352": "39.8283_-85.3621", "47356": "40.0475_-85.5368", "47360": "39.9941_-85.2581", "47361": "40.0042_-85.3851", "47362": "39.9208_-85.3663", "47366": "39.8634_-85.263", "47384": "39.9158_-85.5182", "47385": "39.8271_-85.445", "47386": "40.0527_-85.3833", "47387": "39.8319_-85.2724", "47388": "40.006_-85.4434", "46901": "40.4988_-86.1453", "46902": "40.4509_-86.1352", "46903": "40.4696_-86.1189", "46904": "40.4696_-86.1189", "46936": "40.4791_-85.9582", "46937": "40.4187_-86.0181", "46965": "40.4127_-86.1015", "46979": "40.4151_-86.2675", "46995": "40.4421_-86.2155", "46702": "40.8618_-85.6067", "46713": "40.9442_-85.6239", "46750": "40.8811_-85.5054", "46770": "40.8331_-85.319", "46783": "40.96_-85.3526", "46792": "40.6886_-85.4183", "47220": "38.8836_-86.0486", "47228": "38.9745_-85.9628", "47229": "38.8067_-85.847", "47235": "38.9957_-86.1241", "47249": "38.9606_-86.2033", "47260": "38.8255_-86.1897", "47264": "38.9526_-86.275", "47274": "38.9571_-85.8825", "47281": "38.8174_-86.069", "46310": "41.1713_-87.2491", "46380": "41.1948_-86.9686", "46392": "41.1779_-87.0699", "47943": "41.075_-87.2575", "47977": "40.7667_-87.1599", "47978": "40.9948_-87.1037", "47326": "40.5446_-84.9117", "47336": "40.3883_-85.2255", "47369": "40.5082_-85.1492", "47371": "40.4306_-84.9928", "47373": "40.3265_-85.162", "47381": "40.3818_-84.8669", "47224": "38.887_-85.2213", "47230": "38.7759_-85.6304", "47231": "38.8905_-85.5092", "47243": "38.7138_-85.4763", "47250": "38.7649_-85.407", "47223": "39.0491_-85.4789", "47227": "38.8526_-85.6434", "47245": "38.9831_-85.7405", "47265": "39.0018_-85.6272", "47270": "38.8558_-85.7487", "47273": "39.0665_-85.7129", "47282": "38.9848_-85.6094", "46106": "39.5_-86.1797", "46124": "39.3626_-85.9707", "46131": "39.4854_-86.0608", "46142": "39.6224_-86.149", "46143": "39.596_-86.1309", "46162": "39.5605_-85.9656", "46164": "39.3656_-86.0976", "46181": "39.3696_-86.1838", "46184": "39.5611_-86.0723", "47512": "38.7727_-87.3137", "47516": "38.7563_-87.4313", "47524": "38.5076_-87.5537", "47528": "38.8106_-87.2519", "47535": "38.8627_-87.3127", "47557": "38.6001_-87.3641", "47561": "38.8579_-87.3879", "47573": "38.7441_-87.3214", "47578": "38.8817_-87.2025", "47591": "38.6734_-87.5098", "47596": "38.8628_-87.2256", "47597": "38.6671_-87.3062", "46502": "41.254_-85.9697", "46508": "41.1547_-85.9693", "46510": "41.1165_-85.8686", "46524": "41.2918_-86.035", "46538": "41.3266_-85.816", "46539": "41.1615_-86.0299", "46542": "41.4011_-85.8554", "46555": "41.3326_-85.7103", "46562": "41.2124_-85.7061", "46567": "41.4065_-85.7184", "46580": "41.2438_-85.8508", "46581": "41.2394_-85.8643", "46582": "41.2842_-85.8547", "46590": "41.211_-85.8305", "46982": "41.0743_-85.8792", "46565": "41.6633_-85.5932", "46571": "41.5634_-85.5317", "46746": "41.7286_-85.4727", "46761": "41.652_-85.404", "46771": "41.6848_-85.2797", "46786": "41.5326_-85.2722", "46789": "41.5835_-85.1992", "46795": "41.557_-85.315", "46303": "41.3713_-87.4764", "46307": "41.4236_-87.3556", "46308": "41.417_-87.3653", "46311": "41.492_-87.5108", "46312": "41.6349_-87.4627", "46319": "41.5335_-87.4228", "46320": "41.6099_-87.5079", "46321": "41.5544_-87.5011", "46322": "41.55_-87.4569", "46323": "41.5878_-87.4532", "46324": "41.584_-87.5034", "46325": "41.4615_-87.3728", "46327": "41.6327_-87.5113", "46342": "41.5263_-87.2525", "46355": "41.3594_-87.2708", "46356": "41.2845_-87.4191", "46373": "41.4495_-87.4764", "46375": "41.4922_-87.4605", "46376": "41.19_-87.4779", "46377": "41.1917_-87.3398", "46394": "41.6787_-87.5005", "46401": "41.5907_-87.3199", "46402": "41.5997_-87.3385", "46403": "41.6036_-87.259", "46404": "41.5899_-87.3732", "46405": "41.5686_-87.2622", "46406": "41.5878_-87.4062", "46407": "41.5804_-87.335", "46408": "41.5422_-87.3588", "46409": "41.5412_-87.3271", "46410": "41.4957_-87.3509", "46411": "41.4615_-87.3728", "46340": "41.4088_-86.7759", "46345": "41.526_-86.6997", "46346": "41.4802_-86.6919", "46348": "41.3157_-86.8682", "46350": "41.5994_-86.7077", "46352": "41.499_-86.7099", "46360": "41.698_-86.8699", "46361": "41.7035_-86.9151", "46365": "41.6091_-86.544", "46371": "41.7229_-86.5841", "46382": "41.4602_-86.8355", "46390": "41.3845_-86.8764", "46391": "41.5365_-86.9013", "47420": "38.9132_-86.5489", "47421": "38.8729_-86.4871", "47436": "38.948_-86.3703", "47437": "38.7222_-86.671", "47446": "38.7426_-86.4761", "47451": "38.8938_-86.5246", "47462": "38.9507_-86.6139", "47467": "38.7687_-86.3428", "47470": "38.7735_-86.6285", "46001": "40.2561_-85.6681", "46011": "40.1146_-85.7253", "46012": "40.1309_-85.6536", "46013": "40.0619_-85.6801", "46014": "40.1617_-85.7197", "46015": "40.0938_-85.6578", "46016": "40.0988_-85.6846", "46017": "40.0742_-85.6069", "46018": "40.1617_-85.7197", "46036": "40.2803_-85.8391", "46044": "40.2285_-85.7791", "46048": "39.9573_-85.7981", "46051": "40.0854_-85.844", "46056": "39.9944_-85.6227", "46063": "40.2715_-85.7281", "46064": "39.9975_-85.7466", "46070": "40.3398_-85.6403", "46107": "39.7154_-86.0933", "46113": "39.6405_-86.3118", "46183": "39.6531_-86.2828", "46201": "39.775_-86.1093", "46202": "39.7851_-86.1595", "46203": "39.743_-86.1179", "46204": "39.772_-86.1535", "46205": "39.8268_-86.1386", "46206": "39.7613_-86.1613", "46207": "39.7673_-86.1606", "46208": "39.8299_-86.1794", "46209": "39.7795_-86.1328", "46211": "39.7795_-86.1328", "46213": "39.9213_-86.0344", "46214": "39.7924_-86.2875", "46216": "39.8647_-86.0136", "46217": "39.6782_-86.1976", "46218": "39.8082_-86.1014", "46219": "39.7821_-86.0495", "46220": "39.8647_-86.1181", "46221": "39.7509_-86.1924", "46222": "39.789_-86.2136", "46224": "39.794_-86.2707", "46225": "39.7406_-86.1569", "46226": "39.8326_-86.0836", "46227": "39.6789_-86.1302", "46228": "39.8462_-86.1951", "46229": "39.7886_-85.9779", "46230": "39.7795_-86.1328", "46231": "39.7038_-86.3029", "46234": "39.8088_-86.3163", "46235": "39.8471_-85.9741", "46236": "39.8689_-85.9765", "46237": "39.673_-86.0757", "46239": "39.7265_-86.0005", "46240": "39.9069_-86.1238", "46241": "39.7096_-86.2614", "46242": "39.7795_-86.1328", "46244": "39.7795_-86.1328", "46247": "39.7795_-86.1328", "46249": "39.859_-86.0061", "46250": "39.9048_-86.0673", "46251": "39.7795_-86.1328", "46253": "39.7795_-86.1328", "46254": "39.849_-86.272", "46255": "39.7684_-86.158", "46256": "39.8977_-86.0094", "46259": "39.667_-85.9981", "46260": "39.8977_-86.1797", "46266": "39.7684_-86.158", "46268": "39.8682_-86.2123", "46274": "39.7795_-86.1328", "46275": "39.7795_-86.1328", "46277": "39.7795_-86.1328", "46278": "39.8726_-86.2768", "46282": "39.7795_-86.1328", "46283": "39.7795_-86.1328", "46285": "39.7795_-86.1328", "46291": "39.7795_-86.1328", "46295": "39.7795_-86.1328", "46296": "39.796_-86.1495", "46298": "39.7795_-86.1328", "46501": "41.2308_-86.2506", "46504": "41.3098_-86.1174", "46506": "41.4467_-86.1932", "46511": "41.22_-86.4269", "46513": "41.3619_-86.4443", "46537": "41.4599_-86.3102", "46563": "41.353_-86.3015", "46570": "41.2166_-86.1095", "46572": "41.4098_-86.4025", "47522": "38.8949_-86.9002", "47553": "38.6629_-86.9137", "47581": "38.6791_-86.7761", "46911": "40.6105_-85.9497", "46914": "40.6423_-86.0961", "46919": "40.577_-85.8763", "46921": "40.9103_-86.1011", "46926": "40.867_-86.0752", "46951": "40.9618_-86.1264", "46958": "40.8224_-86.1162", "46959": "40.6147_-86.1064", "46970": "40.7492_-86.068", "46971": "40.6683_-86.1378", "47401": "39.1401_-86.5083", "47402": "39.1732_-86.5015", "47403": "39.1263_-86.5769", "47404": "39.195_-86.5757", "47405": "39.1682_-86.5186", "47406": "39.1745_-86.5183", "47407": "39.1732_-86.5015", "47408": "39.2303_-86.4692", "47426": "39.1732_-86.5015", "47429": "39.2545_-86.6196", "47434": "39.013_-86.5457", "47458": "39.0712_-86.5069", "47463": "39.0859_-86.6689", "47464": "39.2998_-86.6482", "47468": "39.2514_-86.4189", "47916": "39.9836_-87.0554", "47933": "40.0325_-86.9074", "47940": "40.1118_-86.7645", "47954": "39.9132_-86.8031", "47955": "40.1833_-86.8905", "47965": "39.9524_-86.9206", "47967": "40.1812_-86.9789", "47968": "39.9883_-86.7528", "47989": "39.902_-87.0178", "47990": "40.0858_-87.0512", "47994": "40.1666_-87.0664", "46111": "39.5396_-86.3701", "46125": "39.5214_-86.6414", "46151": "39.4776_-86.4668", "46157": "39.5714_-86.4894", "46158": "39.5915_-86.3642", "46166": "39.4042_-86.5779", "46349": "41.1387_-87.4454", "46372": "41.1434_-87.322", "46379": "41.1671_-87.4335", "46381": "41.1711_-87.3313", "47922": "40.8655_-87.3527", "47948": "40.7669_-87.2999", "47951": "40.7877_-87.4471", "47963": "40.9645_-87.4187", "47964": "40.9521_-87.2986", "46701": "41.3482_-85.4142", "46710": "41.3689_-85.2414", "46732": "41.3751_-85.6031", "46755": "41.4482_-85.2609", "46760": "41.3953_-85.5483", "46763": "41.2991_-85.1901", "46767": "41.4662_-85.5927", "46784": "41.4849_-85.3743", "46794": "41.457_-85.4822", "46796": "41.3361_-85.5002", "47040": "38.9567_-84.8807", "47432": "38.5324_-86.6196", "47452": "38.6535_-86.4532", "47454": "38.5507_-86.449", "47469": "38.6208_-86.5899", "47427": "39.2303_-87.0458", "47431": "39.2151_-86.85", "47433": "39.345_-86.6583", "47455": "39.3165_-86.9562", "47456": "39.4429_-86.6696", "47460": "39.2891_-86.7789", "47830": "39.7791_-87.2218", "47832": "39.8348_-87.256", "47836": "39.645_-87.1775", "47859": "39.9062_-87.178", "47860": "39.7219_-87.3303", "47862": "39.7961_-87.3607", "47872": "39.7682_-87.1978", "47874": "39.6239_-87.3086", "47514": "38.1572_-86.5859", "47515": "38.1981_-86.6821", "47520": "37.9495_-86.7156", "47525": "38.0239_-86.577", "47551": "38.1011_-86.6044", "47574": "37.9372_-86.534", "47576": "38.1834_-86.6058", "47586": "37.9655_-86.7457", "47564": "38.4662_-87.0985", "47567": "38.4789_-87.2883", "47584": "38.2523_-87.2572", "47585": "38.2835_-87.1205", "47590": "38.368_-87.099", "47598": "38.364_-87.2223", "46301": "41.6925_-86.9775", "46302": "41.3542_-87.1304", "46304": "41.6143_-87.047", "46341": "41.3155_-87.2088", "46347": "41.3091_-87.024", "46368": "41.5672_-87.1757", "46383": "41.4547_-87.0656", "46384": "41.4905_-87.0761", "46385": "41.4706_-87.0783", "46393": "41.5116_-87.1792", "47612": "38.193_-87.6992", "47616": "38.2069_-87.9166", "47620": "37.9506_-87.8569", "47631": "38.1245_-87.9172", "47633": "38.172_-87.8027", "47638": "38.0828_-87.7543", "46960": "41.1383_-86.5179", "46985": "40.9602_-86.5404", "46996": "41.0562_-86.6307", "47946": "40.9709_-86.8553", "47957": "41.0897_-86.8808", "46105": "39.7612_-86.812", "46120": "39.5148_-86.7939", "46128": "39.6475_-86.7469", "46135": "39.6495_-86.8686", "46170": "39.5742_-86.8653", "46171": "39.5464_-86.95", "46172": "39.8325_-86.7902", "46175": "39.8366_-86.967", "47340": "40.1945_-85.1254", "47354": "40.0475_-85.2108", "47355": "40.0519_-84.93", "47358": "40.0582_-85.0919", "47368": "40.1938_-85.1963", "47380": "40.2804_-85.0371", "47382": "40.2347_-84.9185", "47390": "40.2024_-84.8268", "47394": "40.1696_-85.0044", "47006": "39.3001_-85.2221", "47017": "38.949_-85.2122", "47021": "38.9703_-85.1504", "47023": "39.0498_-85.3739", "47031": "39.1503_-85.1324", "47033": "39.2814_-85.1739", "47034": "39.2048_-85.327", "47037": "39.1573_-85.2938", "47039": "39.1116_-85.2551", "47041": "39.237_-85.0947", "47042": "39.0511_-85.2235", "46104": "39.6488_-85.5828", "46115": "39.7466_-85.5754", "46127": "39.729_-85.3331", "46146": "39.5781_-85.578", "46150": "39.5742_-85.6194", "46155": "39.7437_-85.43", "46156": "39.4955_-85.5044", "46173": "39.6192_-85.4321", "46530": "41.7427_-86.1411", "46536": "41.5253_-86.2714", "46544": "41.6507_-86.1623", "46545": "41.6835_-86.1682", "46546": "41.662_-86.1586", "46552": "41.7051_-86.4838", "46554": "41.5425_-86.4133", "46556": "41.7002_-86.2379", "46561": "41.6695_-86.087", "46574": "41.4667_-86.4831", "46595": "41.5259_-86.1694", "46601": "41.6727_-86.2535", "46613": "41.6546_-86.2479", "46614": "41.6255_-86.2433", "46615": "41.6741_-86.2104", "46616": "41.6919_-86.2647", "46617": "41.685_-86.2351", "46619": "41.6674_-86.3153", "46624": "41.7332_-86.2833", "46626": "41.6774_-86.2525", "46628": "41.7015_-86.2949", "46634": "41.5968_-86.293", "46635": "41.7168_-86.2078", "46637": "41.7299_-86.2407", "46660": "41.5968_-86.293", "46680": "41.5968_-86.293", "46699": "41.5968_-86.293", "47102": "38.7478_-85.7962", "47138": "38.6523_-85.6252", "47170": "38.6885_-85.7987", "46110": "39.5666_-85.9141", "46126": "39.6295_-85.8913", "46130": "39.6751_-85.7848", "46144": "39.6617_-85.6476", "46161": "39.6675_-85.6934", "46176": "39.5043_-85.7875", "46182": "39.4688_-85.6644", "47234": "39.3774_-85.7679", "47523": "38.1706_-87.007", "47531": "38.0224_-86.8364", "47536": "38.1114_-86.8361", "47537": "38.0855_-87.0441", "47550": "38.0429_-86.9497", "47552": "38.1242_-86.996", "47556": "38.1664_-86.9172", "47577": "38.1712_-86.8092", "47579": "38.1176_-86.9286", "47588": "38.0331_-86.7981", "47611": "38.0148_-87.0364", "47615": "37.9703_-86.9568", "47617": "37.9036_-87.2499", "47634": "37.9136_-87.201", "47635": "37.8858_-87.077", "46366": "41.215_-86.7759", "46374": "41.2111_-86.8725", "46531": "41.3496_-86.5243", "46532": "41.3931_-86.5948", "46534": "41.2809_-86.6082", "46968": "41.1756_-86.5543", "46703": "41.6563_-85.0198", "46737": "41.7331_-84.9452", "46742": "41.5566_-84.8951", "46747": "41.5328_-85.0811", "46776": "41.7309_-85.1465", "46779": "41.5843_-85.0213", "47838": "38.9763_-87.3667", "47848": "39.0691_-87.2599", "47849": "39.1901_-87.547", "47850": "39.2685_-87.5024", "47852": "39.0805_-87.4496", "47855": "39.1833_-87.2994", "47861": "39.0564_-87.5675", "47865": "39.0212_-87.3886", "47879": "39.1784_-87.3936", "47882": "39.101_-87.4102", "47011": "38.876_-85.0719", "47019": "38.8728_-84.988", "47020": "38.8224_-84.9399", "47038": "38.8537_-84.8515", "47043": "38.7724_-85.0852", "47901": "40.4177_-86.8884", "47902": "40.3887_-86.8949", "47903": "40.3044_-86.8245", "47904": "40.4276_-86.8735", "47905": "40.4001_-86.8602", "47906": "40.444_-86.9237", "47907": "40.4249_-86.9162", "47909": "40.3228_-86.8881", "47920": "40.5248_-86.8238", "47924": "40.4876_-86.7631", "47930": "40.247_-86.725", "47941": "40.3761_-86.774", "47962": "40.4732_-87.0276", "47981": "40.258_-86.9208", "47983": "40.2845_-86.7724", "47992": "40.3581_-87.0575", "47996": "40.3887_-86.8949", "46045": "40.2898_-86.1494", "46047": "40.2836_-85.9475", "46049": "40.2884_-86.2297", "46068": "40.3732_-86.1086", "46072": "40.2817_-86.0433", "46076": "40.3669_-85.9476", "47325": "39.6845_-84.9881", "47353": "39.6126_-84.9089", "47618": "38.1081_-87.5589", "47701": "37.9971_-87.575", "47702": "37.9971_-87.575", "47703": "37.9971_-87.575", "47704": "37.9971_-87.575", "47705": "37.9971_-87.575", "47706": "37.9971_-87.575", "47708": "37.9718_-87.572", "47710": "38.0086_-87.5746", "47711": "38.0617_-87.5548", "47712": "37.929_-87.6604", "47713": "37.9623_-87.5577", "47714": "37.9591_-87.5293", "47715": "37.9678_-87.4855", "47716": "37.9971_-87.575", "47719": "37.9971_-87.575", "47720": "38.0599_-87.638", "47721": "37.978_-87.6008", "47722": "37.9702_-87.542", "47724": "37.9971_-87.575", "47725": "38.1071_-87.5256", "47728": "37.9971_-87.575", "47730": "37.9971_-87.575", "47731": "37.9971_-87.575", "47732": "37.9971_-87.575", "47733": "37.9971_-87.575", "47734": "37.9971_-87.575", "47735": "37.9971_-87.575", "47736": "37.9971_-87.575", "47737": "37.9971_-87.575", "47740": "37.9971_-87.575", "47747": "37.9971_-87.575", "47750": "37.9623_-87.5055", "47831": "39.665_-87.5206", "47842": "39.6591_-87.4208", "47847": "39.839_-87.4712", "47854": "39.7712_-87.4041", "47875": "39.8778_-87.4436", "47884": "39.6221_-87.4548", "47928": "39.93_-87.459", "47966": "39.8842_-87.4086", "47974": "40.0737_-87.4648", "47801": "39.4667_-87.4139", "47802": "39.407_-87.402", "47803": "39.4657_-87.354", "47804": "39.4937_-87.3945", "47805": "39.5327_-87.3255", "47807": "39.471_-87.4009", "47808": "39.4336_-87.4101", "47809": "39.471_-87.4111", "47851": "39.5737_-87.2454", "47858": "39.2733_-87.2637", "47863": "39.5803_-87.4616", "47866": "39.2929_-87.3355", "47869": "39.275_-87.4972", "47870": "39.3712_-87.4759", "47871": "39.39_-87.3", "47876": "39.5109_-87.4672", "47878": "39.4928_-87.2665", "47880": "39.6006_-87.4196", "47885": "39.4984_-87.4688", "46940": "40.6909_-85.6971", "46941": "40.8199_-85.7204", "46943": "40.9743_-85.8375", "46946": "41.0356_-85.7358", "46962": "40.9986_-85.7842", "46974": "40.9482_-85.9301", "46980": "40.9567_-85.7405", "46984": "40.6714_-85.8288", "46990": "40.8987_-85.7485", "46992": "40.7909_-85.8321", "47975": "40.4328_-87.2317", "47982": "40.1967_-87.5265", "47991": "40.2659_-87.4384", "47993": "40.3142_-87.4039", "47601": "38.0474_-87.262", "47610": "38.0423_-87.3756", "47613": "38.2053_-87.4179", "47619": "38.1961_-87.2935", "47629": "38.0624_-87.2452", "47630": "37.9637_-87.3938", "47637": "38.1232_-87.1388", "47108": "38.669_-86.2358", "47120": "38.4331_-86.1897", "47125": "38.4626_-86.318", "47165": "38.4931_-86.017", "47167": "38.6071_-86.0787", "47324": "39.7412_-84.8519", "47327": "39.8182_-85.1685", "47330": "39.8081_-85.0032", "47335": "39.8127_-85.2044", "47339": "39.9781_-85.088", "47341": "39.9634_-84.909", "47345": "39.8916_-85.0494", "47346": "39.9228_-85.1601", "47357": "39.7763_-85.1423", "47370": "39.8613_-85.1474", "47374": "39.8324_-84.8936", "47375": "39.8289_-84.8902", "47392": "39.9119_-84.9351", "47393": "39.958_-84.9984", "46714": "40.7368_-85.1622", "46731": "40.793_-85.0904", "46759": "40.5897_-85.2767", "46766": "40.7002_-85.2774", "46777": "40.8806_-85.157", "46778": "40.6114_-85.1526", "46781": "40.6419_-85.2562", "46791": "40.8369_-85.2403", "47923": "40.6011_-86.8753", "47925": "40.8825_-86.7453", "47926": "40.7612_-86.5936", "47929": "40.6693_-86.8626", "47950": "40.7674_-86.6556", "47959": "40.8612_-86.8635", "47960": "40.7626_-86.755", "47980": "40.7606_-86.8691", "47995": "40.7516_-87.029", "46723": "41.229_-85.3244", "46725": "41.1619_-85.4737", "46764": "41.1646_-85.6139", "46787": "41.0726_-85.6143", "66732": "37.8035_-95.1546", "66742": "37.9232_-95.3467", "66748": "37.8045_-95.422", "66749": "37.9245_-95.4", "66751": "37.917_-95.2991", "66755": "37.9342_-95.1647", "66772": "37.7517_-95.1545", "66015": "38.0761_-95.3287", "66032": "38.2859_-95.2594", "66033": "38.3524_-95.1188", "66039": "38.1104_-95.1886", "66091": "38.1686_-95.3096", "66093": "38.1718_-95.4665", "66002": "39.5594_-95.1304", "66016": "39.483_-95.2863", "66023": "39.5222_-95.4008", "66041": "39.5952_-95.3036", "66058": "39.5388_-95.5175", "67057": "37.03_-98.6547", "67061": "37.0984_-98.4003", "67065": "37.4485_-98.5351", "67070": "37.0172_-98.4859", "67071": "37.3569_-98.8098", "67104": "37.2845_-98.5848", "67138": "37.2492_-98.4142", "67143": "37.3786_-98.9159", "67511": "38.4528_-99.0115", "67525": "38.5409_-98.5372", "67526": "38.3565_-98.5849", "67530": "38.3936_-98.7751", "67544": "38.4789_-98.7565", "67564": "38.5167_-98.9365", "67567": "38.2782_-98.9814", "66701": "37.8216_-94.7148", "66716": "37.9214_-95.0303", "66738": "38.0134_-94.7183", "66741": "37.7175_-94.6613", "66754": "38.0228_-94.8735", "66769": "37.8367_-94.8805", "66779": "37.8473_-94.9752", "66424": "39.688_-95.4138", "66425": "39.8445_-95.711", "66434": "39.7914_-95.6004", "66439": "39.6789_-95.5299", "66515": "39.9356_-95.712", "66527": "39.7177_-95.6751", "66532": "39.8182_-95.4567", "66842": "38.0298_-96.6746", "67002": "37.6985_-97.1179", "67010": "37.6836_-96.9648", "67012": "37.658_-96.5329", "67017": "37.7946_-97.0971", "67039": "37.5195_-96.9948", "67041": "38.0545_-97.1284", "67042": "37.8226_-96.8543", "67072": "37.531_-96.6791", "67074": "37.6813_-96.7526", "67123": "37.9389_-97.0198", "67132": "37.796_-96.6482", "67133": "37.5784_-97.1173", "67144": "37.8005_-96.9918", "67154": "37.9612_-97.1308", "66843": "38.26_-96.8228", "66845": "38.3565_-96.5418", "66850": "38.3779_-96.6675", "66862": "38.1448_-96.5541", "66869": "38.4129_-96.5172", "67024": "37.1265_-96.4701", "67334": "37.0262_-96.1783", "67355": "37.037_-96.0121", "67360": "37.0568_-96.1404", "67361": "37.1297_-96.1732", "66713": "37.0281_-94.7393", "66725": "37.1699_-94.8899", "66728": "37.1694_-94.7041", "66739": "37.0632_-94.6557", "66770": "37.081_-94.7175", "66773": "37.2809_-94.8092", "66778": "37.0005_-94.8409", "66781": "37.2912_-94.7286", "66782": "37.2851_-94.9261", "67731": "39.7579_-101.5319", "67756": "39.6804_-101.9093", "67831": "37.1823_-99.759", "67840": "37.0384_-99.9835", "67865": "37.4425_-100.0088", "67432": "39.3844_-97.1278", "67447": "39.4803_-97.0149", "67458": "39.1834_-97.2499", "67468": "39.4607_-97.2467", "67487": "39.2249_-97.0229", "66901": "39.5516_-97.6568", "66938": "39.5758_-97.408", "66948": "39.6021_-97.8631", "67417": "39.4472_-97.5304", "67445": "39.3621_-97.8418", "67466": "39.3481_-97.4579", "66839": "38.2363_-95.7336", "66852": "38.1012_-95.8874", "66856": "38.4161_-95.8222", "66857": "38.0874_-95.6227", "66871": "38.3782_-95.5982", "67029": "37.2479_-99.3115", "67127": "37.1968_-99.4816", "67155": "37.3318_-99.1846", "67005": "37.0676_-97.0357", "67008": "37.4343_-96.7661", "67019": "37.3209_-96.757", "67023": "37.3161_-96.6645", "67038": "37.1641_-96.6917", "67102": "37.2377_-96.8389", "67131": "37.4413_-97.0059", "67146": "37.3939_-97.1108", "67156": "37.2416_-96.98", "66711": "37.6341_-94.6548", "66712": "37.5573_-94.6949", "66724": "37.3694_-94.8424", "66734": "37.6163_-94.8479", "66735": "37.5219_-94.7096", "66743": "37.5091_-94.8569", "66746": "37.6576_-94.9892", "66753": "37.3468_-95.0376", "66756": "37.5442_-94.6839", "66760": "37.342_-94.6199", "66762": "37.3951_-94.7105", "66763": "37.4466_-94.6916", "66780": "37.5967_-95.0455", "67635": "39.6094_-100.4112", "67643": "39.6762_-100.2834", "67653": "39.8447_-100.2007", "67749": "39.8275_-100.5314", "67410": "38.9371_-97.2063", "67431": "38.9722_-97.017", "67441": "38.9063_-97.1122", "67449": "38.6767_-96.8941", "67451": "38.6776_-97.1061", "67480": "38.9194_-97.3518", "67482": "39.0269_-97.2597", "67492": "38.8131_-96.9619", "66008": "39.7174_-95.1765", "66017": "39.7154_-95.2744", "66024": "39.7573_-94.8824", "66035": "39.8608_-95.2583", "66087": "39.7906_-95.1434", "66090": "39.7625_-94.9255", "66094": "39.9627_-95.2982", "66006": "38.7953_-95.2276", "66025": "38.933_-95.1022", "66044": "39.0289_-95.2086", "66045": "38.959_-95.2499", "66046": "38.9369_-95.242", "66047": "38.9407_-95.2779", "66049": "38.9704_-95.2769", "66050": "39.0154_-95.4392", "67519": "37.9347_-99.0936", "67547": "37.9247_-99.4116", "67552": "37.9062_-99.248", "67563": "37.8828_-99.5498", "67345": "37.3745_-96.1959", "67346": "37.3668_-96.4396", "67349": "37.4809_-96.2563", "67352": "37.3905_-96.0814", "67353": "37.3649_-96.3069", "67601": "38.8782_-99.3348", "67627": "38.9276_-99.2161", "67637": "38.9471_-99.5285", "67660": "38.7153_-99.1718", "67667": "38.7128_-99.3322", "67671": "38.8589_-99.1391", "67674": "38.8672_-99.0759", "67439": "38.7312_-98.2057", "67450": "38.59_-98.4159", "67454": "38.7091_-98.1575", "67459": "38.5652_-98.29", "67490": "38.8134_-98.4432", "67846": "37.9769_-100.8621", "67851": "37.9931_-100.9893", "67868": "37.906_-100.7523", "67801": "37.7569_-100.0241", "67834": "37.553_-99.6325", "67842": "37.6323_-99.7642", "67843": "37.7303_-99.937", "67876": "37.8235_-99.737", "67882": "37.7806_-99.8921", "66042": "38.4347_-95.0804", "66067": "38.6142_-95.2745", "66076": "38.6153_-95.4489", "66078": "38.4847_-95.2764", "66079": "38.5666_-95.1234", "66080": "38.4074_-95.2489", "66092": "38.7137_-95.0916", "66095": "38.4902_-95.4226", "66441": "39.0299_-96.8396", "66442": "39.0619_-96.7873", "66514": "39.1692_-96.91", "67736": "38.887_-100.4867", "67737": "39.103_-100.468", "67738": "39.0851_-100.6621", "67751": "39.0788_-100.3469", "67752": "39.0363_-100.2337", "67625": "39.3782_-99.6788", "67642": "39.3566_-99.8429", "67650": "39.3229_-100.0733", "67659": "39.3482_-99.9719", "67880": "37.5792_-101.3488", "67835": "37.8127_-100.3438", "67837": "37.568_-100.6148", "67841": "37.6414_-100.2496", "67853": "37.8293_-100.5143", "67867": "37.6016_-100.4461", "67879": "38.4962_-101.7656", "66853": "37.9791_-96.1691", "66855": "38.1125_-96.0267", "66860": "38.1278_-96.1213", "66863": "37.8329_-96.0818", "66870": "37.8976_-96.0329", "67045": "37.8265_-96.2959", "67047": "37.621_-96.0435", "67122": "37.6372_-96.3695", "67137": "37.617_-96.2252", "67836": "38.0215_-102.007", "67857": "37.9347_-101.546", "67878": "37.9826_-101.7687", "67003": "37.1512_-98.0285", "67009": "37.2528_-98.2264", "67018": "37.0838_-97.8754", "67036": "37.2674_-97.8689", "67049": "37.1903_-97.8634", "67058": "37.2909_-98.018", "67150": "37.0022_-98.1826", "67020": "38.0261_-97.6666", "67056": "38.0064_-97.5118", "67062": "38.136_-97.4495", "67114": "38.0451_-97.3435", "67117": "38.0743_-97.3473", "67135": "37.9167_-97.4225", "67151": "38.1239_-97.2361", "67870": "37.4409_-100.9691", "67877": "37.5221_-100.8208", "67849": "38.109_-99.6928", "67854": "38.0738_-99.9327", "66416": "39.5155_-95.8517", "66418": "39.2655_-95.9608", "66419": "39.354_-95.6127", "66436": "39.4436_-95.7525", "66440": "39.2552_-95.6867", "66509": "39.3489_-95.6928", "66516": "39.6063_-95.727", "66540": "39.5013_-95.9652", "66552": "39.5974_-95.6158", "66054": "39.1668_-95.2183", "66060": "39.4095_-95.3236", "66066": "39.2152_-95.3135", "66070": "39.2136_-95.4404", "66073": "39.0875_-95.3731", "66088": "39.3484_-95.467", "66097": "39.3245_-95.2696", "66429": "39.0972_-95.5397", "66512": "39.2038_-95.5476", "66936": "39.8932_-98.3499", "66941": "39.7562_-98.4462", "66942": "39.7795_-97.9889", "66949": "39.6719_-98.1472", "66956": "39.7833_-98.2152", "66963": "39.6286_-98.0661", "66970": "39.935_-98.035", "66018": "38.9462_-94.9714", "66021": "38.7811_-95.0094", "66030": "38.8075_-94.9157", "66031": "38.8249_-94.8992", "66051": "38.8999_-94.832", "66061": "38.8865_-94.8204", "66062": "38.8733_-94.7752", "66063": "38.8999_-94.832", "66083": "38.7631_-94.8246", "66085": "38.7902_-94.6643", "66201": "39.0278_-94.6558", "66202": "39.0278_-94.6558", "66203": "39.0417_-94.7202", "66204": "38.9928_-94.6771", "66205": "39.0278_-94.6558", "66206": "38.9667_-94.6169", "66207": "38.9575_-94.6452", "66208": "38.9917_-94.6336", "66209": "38.9667_-94.6169", "66210": "38.9273_-94.7143", "66211": "38.9667_-94.6169", "66212": "38.9568_-94.6832", "66213": "38.8982_-94.7049", "66214": "38.9649_-94.7209", "66215": "38.9536_-94.7336", "66216": "39.0417_-94.7202", "66217": "39.0417_-94.7202", "66218": "39.0417_-94.7202", "66219": "38.9536_-94.7336", "66220": "38.9536_-94.7336", "66221": "38.8636_-94.7103", "66222": "39.0278_-94.6558", "66223": "38.8619_-94.661", "66224": "38.8591_-94.6314", "66225": "38.8999_-94.832", "66226": "39.0417_-94.7202", "66227": "38.9536_-94.7336", "66250": "38.9536_-94.7336", "66251": "38.8999_-94.832", "66276": "38.8999_-94.832", "66282": "38.8999_-94.832", "66283": "38.8999_-94.832", "66285": "38.9536_-94.7336", "66286": "39.0417_-94.7202", "67838": "38.0068_-101.1431", "67860": "37.9382_-101.2713", "67035": "37.6309_-98.3564", "67068": "37.5964_-98.1304", "67111": "37.6099_-97.9503", "67112": "37.4344_-98.4171", "67118": "37.4501_-97.8662", "67142": "37.441_-98.1751", "67159": "37.4373_-98.2874", "67054": "37.6084_-99.3011", "67059": "37.6096_-99.134", "67109": "37.5716_-99.4639", "67330": "37.1873_-95.2983", "67332": "37.0601_-95.2115", "67336": "37.0418_-95.0796", "67341": "37.3243_-95.4116", "67342": "37.0561_-95.3442", "67354": "37.2091_-95.4247", "67356": "37.1823_-95.1335", "67357": "37.3389_-95.2693", "67839": "38.4742_-100.4647", "67850": "38.5664_-100.6159", "66007": "39.1281_-94.957", "66020": "39.3391_-95.0999", "66027": "39.3485_-94.9265", "66043": "39.2502_-94.8994", "66048": "39.3015_-94.9339", "66052": "39.0014_-95.0391", "66086": "39.1026_-95.1051", "67418": "39.1816_-98.0711", "67423": "38.9844_-97.9818", "67455": "39.1027_-98.2149", "67481": "39.0324_-98.373", "66010": "38.0908_-95.0053", "66014": "38.213_-94.9934", "66040": "39.0478_-95.1538", "66056": "38.156_-94.8186", "66072": "38.3303_-94.9871", "66075": "38.1823_-94.7057", "66767": "38.0718_-94.7008", "67747": "39.079_-101.035", "67748": "39.1121_-100.858", "67764": "39.061_-101.2216", "66801": "38.4184_-96.1871", "66830": "38.6393_-96.1017", "66833": "38.652_-96.1735", "66835": "38.5098_-96.2608", "66854": "38.2833_-95.9997", "66864": "38.3948_-96.0168", "66865": "38.2578_-96.1891", "66868": "38.529_-95.9895", "67107": "38.206_-97.5088", "67428": "38.3858_-97.4291", "67443": "38.3824_-97.5359", "67456": "38.5761_-97.6739", "67460": "38.3763_-97.6702", "67464": "38.556_-97.8381", "67476": "38.5508_-97.4303", "67491": "38.3845_-97.8965", "67546": "38.2232_-97.7951", "66840": "38.1222_-96.8634", "66851": "38.2415_-96.9346", "66858": "38.4933_-96.9626", "66859": "38.5657_-96.9799", "66861": "38.3554_-97.0204", "66866": "38.1737_-97.1184", "67053": "38.2468_-97.3463", "67063": "38.3449_-97.2122", "67073": "38.3771_-97.3043", "67438": "38.5038_-97.2555", "67475": "38.5777_-97.0759", "67483": "38.5534_-97.1774", "66403": "39.8707_-96.2676", "66406": "39.8988_-96.4286", "66411": "39.675_-96.6359", "66412": "39.8775_-96.7458", "66427": "39.7333_-96.5223", "66438": "39.8488_-96.5063", "66508": "39.8428_-96.6422", "66518": "39.9598_-96.6235", "66541": "39.9798_-96.3279", "66544": "39.6946_-96.278", "66548": "39.6971_-96.7498", "67844": "37.3542_-100.1981", "67864": "37.2821_-100.3364", "67869": "37.2701_-100.5732", "66013": "38.7283_-94.6887", "66026": "38.4102_-94.8718", "66036": "38.6581_-94.8521", "66053": "38.6073_-94.6829", "66064": "38.4888_-94.962", "66071": "38.572_-94.8937", "67420": "39.4416_-98.1192", "67430": "39.5115_-98.4335", "67446": "39.4958_-98.3155", "67452": "39.243_-98.4017", "67478": "39.3851_-97.9328", "67485": "39.3436_-98.4644", "67301": "37.2292_-95.7165", "67333": "37.0224_-95.9091", "67335": "37.2668_-95.559", "67337": "37.0441_-95.6328", "67340": "37.0596_-95.7131", "67344": "37.3146_-95.9135", "67347": "37.0917_-95.9414", "67351": "37.1576_-95.6017", "67363": "37.3281_-95.717", "67364": "37.037_-95.8237", "66838": "38.5674_-96.8396", "66846": "38.6959_-96.5469", "66849": "38.8389_-96.5802", "66872": "38.789_-96.7637", "66873": "38.6361_-96.6753", "67950": "37.0154_-101.9012", "67953": "37.2834_-101.7004", "67954": "37.1089_-101.6447", "66404": "39.8816_-96.1801", "66408": "39.9571_-95.961", "66415": "39.7381_-96.1486", "66417": "39.6572_-96.0294", "66428": "39.6654_-95.9574", "66522": "39.8639_-95.9392", "66534": "39.8993_-95.8113", "66538": "39.8473_-96.0316", "66550": "39.6428_-95.8231", "66720": "37.6749_-95.457", "66733": "37.6044_-95.2514", "66740": "37.4724_-95.3707", "66771": "37.518_-95.1688", "66775": "37.6811_-95.1388", "66776": "37.4527_-95.4671", "67515": "38.6403_-100.0462", "67516": "38.4565_-99.7016", "67518": "38.4445_-100.1949", "67521": "38.6239_-99.7328", "67560": "38.4388_-99.9029", "67572": "38.64_-99.9267", "67584": "38.6411_-100.138", "67622": "39.8891_-99.7042", "67629": "39.7375_-100.1776", "67645": "39.6105_-100.0028", "67654": "39.8407_-99.8878", "66413": "38.7634_-95.84", "66414": "38.8206_-95.6871", "66451": "38.6356_-95.6802", "66510": "38.5027_-95.629", "66523": "38.6269_-95.8303", "66524": "38.7922_-95.5616", "66528": "38.5785_-95.5362", "66537": "38.788_-95.748", "66543": "38.6419_-95.6012", "67437": "39.5028_-98.5441", "67473": "39.4194_-98.6961", "67474": "39.5455_-98.6904", "67623": "39.4514_-98.9539", "67651": "39.2013_-98.9829", "67422": "39.0224_-97.6031", "67436": "39.2731_-97.7717", "67467": "39.1295_-97.6688", "67484": "38.9916_-97.8319", "67523": "38.2104_-99.5275", "67529": "38.0649_-99.2374", "67550": "38.1946_-99.101", "67574": "38.2148_-99.4048", "67621": "39.8037_-99.1255", "67639": "39.6704_-99.2996", "67644": "39.6717_-99.1204", "67646": "39.6611_-99.5687", "67647": "39.9517_-99.5391", "67661": "39.7623_-99.3328", "67664": "39.837_-99.5683", "66407": "39.2273_-96.1866", "66422": "39.3048_-96.0593", "66426": "39.4398_-96.5068", "66432": "39.4942_-96.0769", "66520": "39.4125_-96.6002", "66521": "39.4889_-96.17", "66535": "39.2108_-96.4345", "66536": "39.1987_-96.0683", "66547": "39.21_-96.3153", "66549": "39.4138_-96.4374", "67021": "37.7847_-98.9017", "67028": "37.5125_-98.8504", "67066": "37.7397_-98.7361", "67124": "37.6502_-98.73", "67134": "37.5101_-98.6642", "67730": "39.7926_-101.0318", "67739": "39.9036_-100.8139", "67744": "39.863_-100.9604", "67745": "39.7923_-101.3227", "67501": "38.055_-97.9311", "67502": "38.1156_-97.8937", "67504": "37.9532_-98.0859", "67505": "38.0282_-97.9431", "67510": "37.9626_-98.2071", "67514": "37.8598_-98.159", "67522": "38.1309_-97.7691", "67543": "37.8989_-97.7828", "67561": "38.1412_-98.0674", "67566": "37.9671_-98.0798", "67568": "37.9658_-98.2988", "67570": "37.7783_-97.9886", "67581": "37.9557_-98.4068", "67583": "37.8224_-98.3591", "67585": "37.9412_-97.8711", "66930": "39.7044_-97.4465", "66935": "39.8241_-97.629", "66939": "39.7851_-97.89", "66940": "39.7975_-97.4496", "66959": "39.9272_-97.5403", "66960": "39.9582_-97.4243", "66961": "39.8279_-97.6509", "66964": "39.9376_-97.8435", "66966": "39.7939_-97.7786", "67427": "38.5018_-98.4016", "67444": "38.5037_-98.1858", "67457": "38.4079_-98.0113", "67512": "38.2343_-98.3112", "67524": "38.3635_-98.3556", "67554": "38.3349_-98.1831", "67573": "38.2877_-98.4119", "67579": "38.2126_-98.2055", "66449": "39.3644_-96.8589", "66502": "39.1938_-96.5858", "66503": "39.2458_-96.6336", "66505": "39.3049_-96.6753", "66506": "39.196_-96.5839", "66517": "39.1153_-96.7101", "66531": "39.3005_-96.8222", "66554": "39.4879_-96.7828", "67632": "39.3242_-99.5811", "67657": "39.2531_-99.5593", "67663": "39.2308_-99.3008", "67669": "39.4376_-99.2871", "67675": "39.4431_-99.1037", "67513": "38.457_-99.5378", "67520": "38.5193_-99.1986", "67548": "38.5311_-99.3097", "67553": "38.6557_-99.3203", "67556": "38.5957_-99.554", "67559": "38.4372_-99.4234", "67565": "38.5353_-99.0534", "67575": "38.4533_-99.3079", "67626": "38.8758_-98.704", "67634": "38.8348_-98.5695", "67640": "38.8722_-99.0112", "67648": "39.0581_-98.5352", "67649": "39.1039_-98.6851", "67658": "39.0756_-98.9207", "67665": "38.8806_-98.8595", "67673": "39.0877_-98.7785", "67401": "38.8237_-97.6421", "67402": "38.8403_-97.6114", "67416": "38.6676_-97.6203", "67425": "38.7858_-97.863", "67442": "38.6648_-97.7554", "67448": "38.7047_-97.4338", "67470": "38.896_-97.523", "67871": "38.4823_-100.9064", "67001": "37.7797_-97.6366", "67016": "37.8866_-97.5166", "67025": "37.6353_-97.7686", "67026": "37.5076_-97.5082", "67030": "37.7782_-97.5405", "67037": "37.553_-97.2549", "67050": "37.6767_-97.66", "67052": "37.6597_-97.5753", "67055": "37.7833_-97.2054", "67060": "37.5647_-97.3553", "67067": "37.7934_-97.2737", "67101": "37.7747_-97.4689", "67108": "37.8684_-97.6591", "67120": "37.5054_-97.3408", "67147": "37.8616_-97.2621", "67149": "37.5696_-97.6306", "67201": "37.6922_-97.3375", "67202": "37.6899_-97.3355", "67203": "37.7048_-97.3638", "67204": "37.7488_-97.3566", "67205": "37.7639_-97.4269", "67206": "37.7038_-97.2253", "67207": "37.671_-97.2179", "67208": "37.7024_-97.2811", "67209": "37.6779_-97.4235", "67210": "37.6379_-97.2613", "67211": "37.6662_-97.3165", "67212": "37.7007_-97.4383", "67213": "37.668_-97.3591", "67214": "37.7051_-97.3133", "67215": "37.6333_-97.425", "67216": "37.6223_-97.3136", "67217": "37.6266_-97.3581", "67218": "37.669_-97.2802", "67219": "37.7719_-97.3175", "67220": "37.7667_-97.2805", "67221": "37.6066_-97.2979", "67223": "37.7367_-97.499", "67226": "37.7379_-97.2479", "67227": "37.6281_-97.4916", "67228": "37.7742_-97.1711", "67230": "37.6808_-97.1558", "67232": "37.6395_-97.1714", "67235": "37.7149_-97.499", "67260": "37.7194_-97.2936", "67275": "37.6936_-97.4804", "67276": "37.6936_-97.4804", "67277": "37.6936_-97.4804", "67278": "37.6922_-97.3375", "67859": "37.2042_-100.7014", "67901": "37.0438_-100.9286", "67905": "37.0216_-100.938", "66402": "38.9167_-95.8199", "66409": "38.9442_-95.5825", "66420": "38.9645_-95.9172", "66533": "39.1451_-95.9553", "66539": "39.1102_-95.8552", "66542": "39.0217_-95.5379", "66546": "38.9045_-95.7015", "66601": "39.0483_-95.678", "66603": "39.0553_-95.6802", "66604": "39.0405_-95.7178", "66605": "39.0151_-95.6439", "66606": "39.0583_-95.7095", "66607": "39.0421_-95.6449", "66608": "39.0858_-95.6867", "66609": "38.9919_-95.6681", "66610": "38.9822_-95.7461", "66611": "39.0142_-95.6981", "66612": "39.0427_-95.6818", "66614": "39.0154_-95.7469", "66615": "39.0446_-95.7906", "66616": "39.0645_-95.6413", "66617": "39.1271_-95.6384", "66618": "39.1329_-95.7023", "66619": "38.9536_-95.7236", "66620": "39.0429_-95.7697", "66621": "39.0333_-95.7015", "66622": "39.0429_-95.7697", "66624": "39.0429_-95.7697", "66625": "39.0483_-95.678", "66626": "39.0483_-95.678", "66629": "39.0483_-95.678", "66630": "39.0483_-95.678", "66636": "39.0483_-95.678", "66647": "39.0429_-95.7697", "66667": "39.0429_-95.7697", "66675": "39.0429_-95.7697", "66683": "39.0483_-95.678", "66699": "39.0483_-95.678", "67740": "39.3322_-100.4758", "67757": "39.5216_-100.5257", "67733": "39.3579_-101.521", "67735": "39.3491_-101.7164", "67741": "39.3438_-102.0015", "66932": "39.7719_-98.9077", "66951": "39.7692_-99.0308", "66952": "39.8077_-98.556", "66967": "39.8042_-98.7842", "67628": "39.6602_-98.9369", "67638": "39.6439_-98.8476", "67545": "38.1485_-98.6408", "67557": "37.9433_-98.9481", "67576": "38.0022_-98.7601", "67578": "37.9554_-98.5929", "67855": "37.5694_-101.7194", "67862": "37.5451_-101.9109", "67951": "37.1682_-101.3346", "67952": "37.3172_-101.2427", "67004": "37.284_-97.7557", "67013": "37.4052_-97.2852", "67022": "37.0452_-97.6247", "67031": "37.3903_-97.6284", "67051": "37.0809_-97.1795", "67103": "37.2518_-97.5416", "67105": "37.2578_-97.6521", "67106": "37.4401_-97.7592", "67110": "37.4764_-97.232", "67119": "37.2653_-97.1761", "67140": "37.05_-97.4042", "67152": "37.2778_-97.391", "67701": "39.383_-101.0442", "67732": "39.3655_-101.373", "67734": "39.4296_-100.8948", "67743": "39.3841_-101.2096", "67753": "39.4267_-100.7461", "67631": "39.0038_-100.0862", "67656": "38.9914_-99.7323", "67672": "39.025_-99.8796", "66401": "39.0092_-96.2923", "66423": "38.8514_-96.1016", "66431": "38.79_-95.9617", "66501": "39.0535_-96.2379", "66507": "39.0447_-96.0397", "66526": "39.0803_-96.1818", "66834": "38.8636_-96.48", "67758": "38.8857_-101.7431", "67761": "38.8747_-101.5735", "67762": "38.8649_-101.9512", "66933": "39.6841_-96.8676", "66937": "39.6201_-97.2611", "66943": "39.7061_-96.9775", "66944": "39.852_-97.3081", "66945": "39.8927_-96.8689", "66946": "39.96_-96.9735", "66953": "39.6847_-97.0854", "66955": "39.9845_-97.3453", "66958": "39.8616_-97.1825", "66962": "39.6192_-97.1122", "66968": "39.8223_-97.0484", "67861": "38.4987_-101.3589", "67863": "38.4875_-101.2129", "66710": "37.5197_-95.6483", "66714": "37.6118_-95.7038", "66717": "37.7011_-95.7014", "66736": "37.5717_-95.7484", "66757": "37.4257_-95.6765", "66759": "37.569_-95.9379", "66758": "37.9669_-95.5497", "66761": "37.9228_-95.5353", "66777": "37.7953_-95.9368", "66783": "37.8801_-95.7289", "66012": "39.0672_-94.9227", "66101": "39.1157_-94.6271", "66102": "39.1132_-94.6693", "66103": "39.0668_-94.6282", "66104": "39.1375_-94.6792", "66105": "39.085_-94.6356", "66106": "39.0694_-94.7178", "66109": "39.1434_-94.7856", "66110": "39.0966_-94.7495", "66111": "39.0803_-94.7806", "66112": "39.116_-94.764", "66113": "39.0735_-94.7233", "66115": "39.1364_-94.616", "66117": "39.1142_-94.6275", "66118": "39.1011_-94.6144", "66119": "39.0966_-94.7495", "66160": "39.0966_-94.7495", "42715": "36.9553_-85.4036", "42720": "37.1803_-85.3197", "42728": "37.1161_-85.2656", "42741": "37.007_-85.2487", "42742": "37.0912_-85.465", "42753": "37.2313_-85.172", "42120": "36.6775_-86.2636", "42153": "36.6673_-86.0498", "42164": "36.7614_-86.1929", "40342": "38.0189_-84.9299", "42022": "37.1459_-88.9455", "42024": "37.0493_-89.0408", "42056": "37.083_-88.973", "42060": "36.9687_-88.8309", "42087": "36.968_-89.0177", "42123": "36.8124_-85.985", "42127": "37.117_-85.9443", "42130": "36.913_-85.7753", "42131": "36.8134_-85.9173", "42141": "36.9882_-85.9221", "42142": "36.9959_-85.9119", "42152": "37.0988_-85.8165", "42156": "36.8516_-86.0523", "42160": "37.0939_-86.0464", "40358": "38.0849_-83.7008", "40360": "38.1532_-83.7564", "40366": "38.0867_-83.7571", "40371": "38.104_-83.6316", "40374": "38.2147_-83.8932", "40813": "36.7223_-83.6221", "40845": "36.7714_-83.5551", "40856": "36.7606_-83.5841", "40902": "36.8283_-83.6415", "40913": "36.9442_-83.556", "40940": "36.607_-83.9484", "40955": "36.7692_-83.7082", "40958": "36.8093_-83.5892", "40965": "36.6172_-83.7231", "40977": "36.7159_-83.7668", "40988": "36.8323_-83.5346", "41005": "39.015_-84.7736", "41021": "39.029_-84.6195", "41022": "38.9624_-84.7478", "41042": "38.9941_-84.642", "41048": "39.0755_-84.7007", "41080": "39.0416_-84.8371", "41091": "38.9435_-84.7274", "41092": "38.839_-84.6907", "41094": "38.8875_-84.6328", "40348": "38.2963_-84.1513", "40357": "38.1464_-84.1077", "40361": "38.2083_-84.245", "40362": "38.2098_-84.253", "41101": "38.4722_-82.6461", "41102": "38.4218_-82.7173", "41105": "38.3703_-82.6948", "41114": "38.3703_-82.6948", "41129": "38.3799_-82.6321", "41168": "38.3089_-82.7476", "40422": "37.6465_-84.7747", "40423": "37.6456_-84.7722", "40440": "37.5822_-84.8028", "40452": "37.6033_-84.9492", "40464": "37.5778_-84.9281", "40468": "37.6375_-84.9665", "41002": "38.763_-83.9954", "41004": "38.6644_-84.0786", "41043": "38.7506_-84.1566", "41044": "38.6357_-83.99", "41061": "38.5817_-84.1566", "41310": "37.6405_-83.2441", "41317": "37.4476_-83.1892", "41339": "37.4868_-83.2913", "41348": "37.4418_-83.2976", "41366": "37.5946_-83.2187", "41385": "37.6477_-83.3806", "41390": "37.4102_-83.3747", "40111": "37.7731_-86.6282", "40115": "37.7358_-86.2378", "40140": "37.7828_-86.3575", "40143": "37.7512_-86.4537", "40144": "37.8023_-86.4148", "40145": "37.6506_-86.3012", "40146": "37.8762_-86.2965", "40152": "37.6194_-86.4491", "40153": "37.8023_-86.4148", "40170": "37.9048_-86.524", "40171": "37.9616_-86.4615", "40176": "37.9237_-86.3441", "40178": "37.6792_-86.4273", "40047": "38.0452_-85.5586", "40109": "38.0546_-85.7713", "40110": "37.9346_-85.6555", "40129": "38.0764_-85.6774", "40150": "37.8511_-85.7246", "40165": "38.0045_-85.6888", "40166": "37.9885_-85.7159", "42201": "37.2539_-86.6817", "42219": "37.1709_-86.7678", "42252": "37.2483_-86.5093", "42261": "37.2002_-86.6859", "42273": "37.2048_-86.8592", "42288": "37.1834_-86.6339", "42411": "37.213_-88.0112", "42445": "37.1151_-87.8632", "42020": "36.6923_-88.2929", "42036": "36.7155_-88.236", "42049": "36.5422_-88.3319", "42054": "36.6731_-88.4238", "42071": "36.6099_-88.3032", "42076": "36.55_-88.0955", "41001": "38.9406_-84.3943", "41007": "38.9056_-84.3171", "41059": "39.0067_-84.3538", "41071": "39.0563_-84.4787", "41072": "38.9638_-84.3689", "41073": "39.1024_-84.4787", "41074": "39.1114_-84.4712", "41075": "39.0786_-84.4523", "41076": "39.0262_-84.4408", "41085": "39.0343_-84.3908", "41099": "38.9638_-84.3689", "42021": "36.7903_-89.0128", "42023": "36.8634_-89.0209", "42035": "36.8963_-88.8728", "42070": "36.7987_-88.8998", "41008": "38.6696_-85.173", "41045": "38.7188_-85.0557", "41083": "38.661_-84.9732", "41098": "38.6179_-85.0663", "41128": "38.4339_-83.1336", "41132": "38.2597_-82.8562", "41142": "38.2897_-83.0811", "41143": "38.3326_-82.9485", "41146": "38.2766_-82.8982", "41164": "38.3001_-83.1741", "41173": "38.262_-83.2847", "41181": "38.2045_-82.9076", "42516": "37.2337_-84.7583", "42528": "37.1906_-84.9835", "42539": "37.3146_-84.9719", "42541": "37.3591_-84.8321", "42565": "37.1568_-84.8799", "42566": "37.3074_-84.8124", "42217": "37.0344_-87.4891", "42221": "36.8434_-87.3039", "42223": "36.6543_-87.4606", "42232": "36.8564_-87.6545", "42236": "36.7085_-87.6082", "42240": "36.8621_-87.4851", "42241": "36.8656_-87.4912", "42254": "36.6582_-87.6563", "42262": "36.6652_-87.4255", "42266": "36.7759_-87.3556", "40391": "37.9872_-84.1789", "40392": "37.9901_-84.1797", "40914": "37.1623_-83.5688", "40932": "37.2198_-83.7883", "40941": "37.1237_-83.7463", "40944": "37.0904_-83.6944", "40951": "37.1206_-83.7783", "40962": "37.1511_-83.7793", "40972": "37.2695_-83.6491", "40983": "37.333_-83.7666", "42602": "36.6857_-85.1407", "42603": "36.7824_-85.0275", "42033": "37.2706_-88.0825", "42037": "37.1595_-88.1845", "42064": "37.3254_-88.1005", "42717": "36.8068_-85.397", "42759": "36.8306_-85.5015", "42301": "37.7513_-87.1554", "42302": "37.7455_-87.1128", "42303": "37.7559_-87.0803", "42304": "37.7455_-87.1128", "42334": "37.735_-87.3317", "42355": "37.8436_-86.9999", "42356": "37.6932_-87.3238", "42366": "37.7183_-86.9372", "42376": "37.6206_-87.0591", "42377": "37.6967_-87.2869", "42378": "37.6834_-86.8699", "42163": "37.0689_-86.1364", "42207": "37.2975_-86.2794", "42210": "37.2229_-86.2923", "42259": "37.2802_-86.1688", "42275": "37.256_-86.407", "42285": "37.2641_-86.2978", "41149": "38.0462_-83.0506", "41171": "38.1316_-83.0797", "40336": "37.6858_-83.9862", "40472": "37.6867_-83.9387", "40502": "38.0174_-84.4854", "40503": "38.001_-84.5282", "40504": "38.0406_-84.5433", "40505": "38.0612_-84.4583", "40506": "38.0287_-84.5075", "40507": "38.0464_-84.4953", "40508": "38.0513_-84.499", "40509": "38.0102_-84.4274", "40510": "38.0702_-84.591", "40511": "38.0932_-84.5007", "40512": "38.0283_-84.4715", "40513": "38.0139_-84.5815", "40514": "37.9833_-84.5767", "40515": "37.9651_-84.4708", "40516": "38.0544_-84.3548", "40517": "37.9849_-84.4816", "40522": "38.0283_-84.4715", "40523": "38.0283_-84.4715", "40524": "38.0283_-84.4715", "40526": "38.0283_-84.4715", "40533": "38.0283_-84.4715", "40536": "38.0321_-84.5084", "40544": "38.0283_-84.4715", "40546": "38.0283_-84.4715", "40550": "38.0283_-84.4715", "40555": "38.0283_-84.4715", "40574": "38.0283_-84.4715", "40575": "38.0283_-84.4715", "40576": "38.0283_-84.4715", "40577": "38.0283_-84.4715", "40578": "38.0283_-84.4715", "40579": "38.0283_-84.4715", "40580": "38.0283_-84.4715", "40581": "38.0283_-84.4715", "40582": "38.0283_-84.4715", "40583": "38.0283_-84.4715", "40588": "38.0283_-84.4715", "40591": "38.0283_-84.4715", "40598": "38.0771_-84.5296", "41037": "38.4195_-83.8255", "41039": "38.4157_-83.8733", "41041": "38.428_-83.708", "41049": "38.2929_-83.6697", "41065": "38.3501_-83.5271", "41081": "38.3481_-83.7186", "41093": "38.3374_-83.5625", "41601": "37.6074_-82.7225", "41602": "37.737_-82.7582", "41603": "37.5707_-82.6806", "41604": "37.3774_-82.6869", "41605": "37.5555_-82.6267", "41606": "37.3465_-82.7403", "41607": "37.6253_-82.8418", "41612": "37.3465_-82.7165", "41615": "37.5467_-82.6705", "41616": "37.5767_-82.8708", "41619": "37.4933_-82.7575", "41621": "37.6246_-82.7227", "41622": "37.517_-82.806", "41630": "37.4798_-82.8316", "41631": "37.4576_-82.6645", "41635": "37.5368_-82.6332", "41636": "37.3994_-82.7292", "41640": "37.5087_-82.8518", "41642": "37.5956_-82.6463", "41643": "37.471_-82.8294", "41645": "37.5381_-82.7976", "41647": "37.4355_-82.7203", "41649": "37.5708_-82.7819", "41650": "37.3536_-82.6763", "41651": "37.4548_-82.7646", "41653": "37.661_-82.7636", "41655": "37.5055_-82.706", "41659": "37.5741_-82.6271", "41660": "37.422_-82.6405", "41663": "37.5725_-82.6452", "41666": "37.4367_-82.801", "41667": "37.317_-82.7041", "41669": "37.3314_-82.7156", "40601": "38.2281_-84.8697", "40602": "38.2341_-84.8748", "40603": "38.2341_-84.8748", "40604": "38.2341_-84.8748", "40618": "38.2341_-84.8748", "40619": "38.2341_-84.8748", "40620": "38.2341_-84.8748", "40621": "38.2009_-84.8733", "40622": "38.2009_-84.8733", "42041": "36.5475_-88.8749", "42050": "36.5593_-89.1947", "41046": "38.7229_-84.8116", "41086": "38.7256_-84.8813", "41095": "38.7807_-84.8496", "40410": "37.7145_-84.6491", "40444": "37.6584_-84.5969", "40461": "37.6092_-84.4269", "41010": "38.5302_-84.5846", "41030": "38.7741_-84.5982", "41035": "38.7049_-84.6237", "41052": "38.6398_-84.7755", "41054": "38.5932_-84.5786", "41097": "38.6292_-84.5744", "42027": "36.93_-88.6223", "42039": "36.7767_-88.7918", "42040": "36.6_-88.5186", "42051": "36.8478_-88.6788", "42061": "36.8862_-88.7728", "42063": "36.5603_-88.5692", "42066": "36.7327_-88.6506", "42069": "36.9197_-88.752", "42079": "36.5748_-88.5815", "42082": "36.9044_-88.5153", "42085": "36.5694_-88.8084", "42088": "36.6253_-88.7394", "40119": "37.5522_-86.4836", "42712": "37.5278_-86.1395", "42721": "37.4222_-86.4702", "42726": "37.4336_-86.2083", "42754": "37.4603_-86.3249", "42755": "37.4801_-86.2939", "42762": "37.4446_-86.4008", "42743": "37.243_-85.5236", "42782": "37.3419_-85.6194", "41121": "38.4322_-82.8094", "41139": "38.5188_-82.7212", "41144": "38.5368_-82.9191", "41169": "38.5173_-82.6977", "41174": "38.7087_-83.0162", "41175": "38.7148_-82.9366", "41183": "38.5511_-82.7396", "42348": "37.8503_-86.7638", "42351": "37.909_-86.8957", "42364": "37.7523_-86.8136", "42368": "37.7403_-86.7414", "40121": "37.8928_-85.9489", "40122": "37.8911_-85.9636", "40159": "37.7235_-85.9769", "40160": "37.8267_-85.9404", "40162": "37.7525_-85.9954", "40175": "37.8589_-86.0069", "40177": "37.9954_-85.9545", "42701": "37.6848_-85.8784", "42702": "37.694_-85.8591", "42724": "37.669_-86.0545", "42732": "37.6061_-86.0906", "42740": "37.6034_-85.8921", "42776": "37.5221_-85.923", "42784": "37.4568_-85.9086", "42788": "37.5438_-86.0395", "40801": "36.8654_-83.2879", "40806": "36.8749_-83.3141", "40807": "36.9648_-82.9485", "40808": "36.9798_-83.2171", "40810": "36.934_-83.3242", "40815": "36.7812_-83.2914", "40818": "36.8202_-83.2445", "40819": "36.8201_-83.4707", "40820": "36.7558_-83.1838", "40823": "36.9711_-82.9771", "40824": "36.8356_-83.3753", "40828": "36.8398_-83.2233", "40829": "36.7974_-83.2645", "40830": "36.7656_-83.3262", "40831": "36.7596_-83.3499", "40843": "36.8757_-82.9943", "40847": "36.8537_-83.1571", "40849": "36.8899_-83.1433", "40854": "36.8481_-83.353", "40855": "36.9603_-82.9198", "40863": "36.7521_-83.4629", "40865": "36.9039_-83.2381", "40870": "36.9448_-83.1177", "40873": "36.8165_-83.419", "40927": "36.8713_-83.0414", "40964": "36.7843_-83.3299", "41003": "38.516_-84.3611", "41031": "38.3964_-84.2949", "42713": "37.3741_-85.896", "42722": "37.2696_-85.7203", "42729": "37.3149_-86.0813", "42746": "37.2249_-85.7542", "42749": "37.1849_-85.8785", "42765": "37.2898_-85.9201", "42402": "37.8709_-87.4625", "42406": "37.7443_-87.7", "42419": "37.8072_-87.5991", "42420": "37.8274_-87.5632", "42451": "37.8588_-87.3704", "42452": "37.6758_-87.5266", "42457": "37.8323_-87.7889", "42458": "37.8399_-87.4247", "40007": "38.4529_-85.0169", "40011": "38.5231_-85.1611", "40019": "38.3696_-85.1782", "40036": "38.4219_-84.9586", "40050": "38.4374_-85.1756", "40055": "38.4809_-85.317", "40057": "38.3598_-85.1072", "40058": "38.4941_-85.1242", "40068": "38.3933_-85.2656", "40070": "38.4921_-85.252", "40075": "38.5521_-85.1019", "42031": "36.6675_-88.9676", "42032": "36.7598_-89.1034", "42408": "37.1964_-87.6821", "42410": "37.2742_-87.5119", "42413": "37.4382_-87.4751", "42431": "37.3256_-87.4953", "42436": "37.4067_-87.5639", "42440": "37.249_-87.4615", "42441": "37.3683_-87.6865", "42442": "37.1834_-87.4605", "42453": "37.1604_-87.5697", "42464": "37.1788_-87.3644", "40402": "37.3052_-83.9711", "40434": "37.3951_-83.9402", "40447": "37.4338_-84.0251", "40481": "37.4862_-84.0905", "40486": "37.3693_-83.8619", "40488": "37.4748_-84.0427", "40018": "38.2331_-85.4558", "40023": "38.1652_-85.4282", "40025": "38.2997_-85.6487", "40027": "38.3297_-85.633", "40041": "38.2536_-85.6622", "40059": "38.356_-85.6083", "40118": "38.1087_-85.7549", "40201": "38.189_-85.6768", "40202": "38.2507_-85.7476", "40203": "38.2493_-85.7694", "40204": "38.2369_-85.7249", "40205": "38.2222_-85.6885", "40206": "38.2503_-85.7034", "40207": "38.2628_-85.6663", "40208": "38.22_-85.7648", "40209": "38.1901_-85.7519", "40210": "38.2306_-85.7905", "40211": "38.242_-85.8127", "40212": "38.2651_-85.8045", "40213": "38.1839_-85.7106", "40214": "38.1593_-85.778", "40215": "38.1913_-85.7847", "40216": "38.1865_-85.8335", "40217": "38.2174_-85.7404", "40218": "38.189_-85.654", "40219": "38.1381_-85.6953", "40220": "38.2149_-85.6245", "40221": "38.189_-85.6768", "40222": "38.2674_-85.6237", "40223": "38.2651_-85.5582", "40224": "38.189_-85.6768", "40225": "38.189_-85.6768", "40228": "38.1442_-85.6265", "40229": "38.0891_-85.6548", "40231": "38.189_-85.6768", "40232": "38.189_-85.6768", "40233": "38.189_-85.6768", "40241": "38.3045_-85.5815", "40242": "38.2785_-85.594", "40243": "38.2422_-85.5353", "40245": "38.2683_-85.4845", "40250": "38.189_-85.6768", "40251": "38.189_-85.6768", "40252": "38.189_-85.6768", "40253": "38.189_-85.6768", "40255": "38.189_-85.6768", "40256": "38.189_-85.6768", "40257": "38.189_-85.6768", "40258": "38.1457_-85.8641", "40259": "38.2542_-85.7594", "40261": "38.189_-85.6768", "40266": "38.189_-85.6768", "40268": "38.189_-85.6768", "40269": "38.189_-85.6768", "40270": "38.2542_-85.7594", "40272": "38.0846_-85.851", "40280": "38.2467_-85.6853", "40281": "38.189_-85.6768", "40282": "38.189_-85.6768", "40283": "38.189_-85.6768", "40285": "38.189_-85.6768", "40287": "38.189_-85.6768", "40289": "38.2542_-85.7594", "40290": "38.189_-85.6768", "40291": "38.1313_-85.5754", "40292": "38.189_-85.6768", "40293": "38.2542_-85.7594", "40294": "38.2542_-85.7594", "40295": "38.2542_-85.7594", "40296": "38.2542_-85.7594", "40297": "38.2542_-85.7594", "40298": "38.2542_-85.7594", "40299": "38.1768_-85.5218", "40339": "37.9434_-84.6419", "40340": "37.8662_-84.5795", "40356": "37.8808_-84.5646", "40390": "37.8602_-84.6714", "41204": "37.8216_-82.6704", "41216": "37.7579_-82.8182", "41219": "37.9231_-82.9221", "41222": "37.7805_-82.8416", "41226": "37.9856_-82.9602", "41234": "37.8078_-82.7415", "41238": "37.8101_-82.9424", "41240": "37.8242_-82.7945", "41254": "37.8795_-82.7251", "41255": "37.8922_-82.8446", "41256": "37.8253_-82.8823", "41257": "37.9166_-82.8034", "41260": "37.822_-82.7526", "41263": "37.8507_-82.7602", "41265": "37.7481_-82.7054", "41268": "37.7862_-82.7807", "41271": "37.8313_-82.7264", "41274": "37.8703_-82.81", "41011": "39.0708_-84.5212", "41012": "38.9447_-84.5205", "41014": "39.0642_-84.5118", "41015": "39.0217_-84.4989", "41016": "39.0873_-84.549", "41017": "39.03_-84.559", "41018": "39.0082_-84.5977", "41019": "38.9447_-84.5205", "41025": "39.0603_-84.6309", "41051": "38.9354_-84.5479", "41053": "38.8684_-84.4561", "41063": "38.8394_-84.5069", "41725": "37.3318_-83.0327", "41740": "37.3499_-83.0471", "41743": "37.3064_-83.0904", "41759": "37.2207_-83.0552", "41772": "37.4073_-83.0153", "41817": "37.3582_-82.9252", "41822": "37.3359_-82.9804", "41828": "37.3136_-82.7975", "41831": "37.3794_-82.9523", "41834": "37.2409_-82.9488", "41836": "37.2692_-82.9161", "41839": "37.4331_-82.9018", "41843": "37.2868_-82.8741", "41844": "37.3491_-82.8742", "41847": "37.2172_-82.9424", "41859": "37.3976_-82.7836", "41861": "37.4043_-82.8261", "41862": "37.3485_-82.7926", "40734": "36.9467_-83.9828", "40771": "36.8586_-84.0347", "40903": "36.8388_-83.8329", "40906": "36.8665_-83.8888", "40915": "36.8868_-83.8282", "40921": "36.7708_-83.9009", "40923": "36.9195_-83.851", "40930": "36.877_-83.7377", "40935": "36.829_-83.7702", "40939": "36.7934_-83.7419", "40943": "36.9691_-83.8539", "40946": "36.8713_-83.83", "40949": "36.8904_-83.8716", "40953": "36.9362_-83.8045", "40982": "36.9327_-83.6901", "40995": "36.761_-83.8155", "40997": "36.8911_-83.6616", "42716": "37.512_-85.6986", "42748": "37.5746_-85.7232", "42757": "37.4165_-85.7308", "42764": "37.426_-85.6191", "40724": "37.0926_-83.8702", "40729": "37.2488_-84.138", "40737": "37.0156_-84.1436", "40740": "37.0256_-84.0282", "40741": "37.1549_-84.0961", "40742": "37.1376_-84.1156", "40743": "37.1345_-84.0457", "40744": "37.0995_-84.1131", "40745": "37.1376_-84.1156", "40750": "37.1289_-84.0833", "40755": "37.1678_-84.1166", "41124": "38.027_-82.8513", "41159": "38.0152_-82.9558", "41160": "38.027_-82.9724", "41180": "38.1634_-82.7897", "41201": "38.0741_-82.7447", "41230": "38.1043_-82.6056", "41232": "37.9315_-82.7349", "41264": "37.9416_-82.6739", "41311": "37.5999_-83.714", "41347": "37.5442_-83.6008", "41368": "37.5829_-83.6471", "41397": "37.6867_-83.6702", "40803": "37.0114_-83.4553", "40816": "37.0098_-83.3494", "40827": "37.0547_-83.4561", "40840": "36.954_-83.3907", "40844": "37.0773_-83.3916", "40858": "37.0037_-83.4135", "40868": "37.0883_-83.3907", "40874": "36.984_-83.4667", "40979": "37.0226_-83.5152", "41714": "37.1939_-83.5035", "41749": "37.1877_-83.4169", "41762": "37.2187_-83.4974", "41764": "37.1214_-83.2539", "41766": "37.1851_-83.4288", "41775": "37.1079_-83.3563", "41776": "37.1671_-83.2913", "41777": "37.0565_-83.2361", "40826": "37.0618_-82.7706", "40862": "37.0129_-82.8795", "41517": "37.1893_-82.599", "41537": "37.1911_-82.6513", "41804": "37.1551_-82.9956", "41810": "37.1865_-82.6971", "41812": "37.2409_-82.7696", "41815": "37.1615_-82.7974", "41819": "36.9891_-83.0655", "41821": "37.0837_-83.0027", "41824": "37.1932_-82.8754", "41825": "37.2246_-82.7228", "41826": "37.1699_-82.9258", "41832": "37.1531_-82.9548", "41833": "37.0233_-82.9878", "41835": "37.2137_-82.6734", "41837": "37.1302_-82.7427", "41838": "37.1766_-82.7517", "41840": "37.1876_-82.711", "41845": "37.1252_-82.9035", "41848": "37.1102_-82.9407", "41849": "37.1765_-82.7358", "41855": "37.1906_-82.7851", "41858": "37.1388_-82.855", "41135": "38.3563_-83.2877", "41141": "38.5869_-83.2", "41166": "38.6271_-83.1056", "41179": "38.4699_-83.2702", "41189": "38.5723_-83.5605", "40419": "37.4465_-84.4939", "40437": "37.4595_-84.8528", "40442": "37.3818_-84.7148", "40448": "37.446_-84.6998", "40484": "37.5245_-84.6912", "40489": "37.3499_-84.6655", "42028": "37.2392_-88.3379", "42045": "37.0762_-88.2647", "42047": "37.2831_-88.3714", "42058": "37.0611_-88.4665", "42078": "37.2553_-88.2711", "42081": "37.2387_-88.3757", "42083": "37.1457_-88.285", "42202": "36.6914_-86.8585", "42206": "36.8818_-86.7198", "42256": "37.0037_-86.9887", "42265": "36.7595_-86.9804", "42276": "36.8453_-86.8823", "42038": "37.0664_-88.0494", "42055": "37.0619_-88.1498", "42001": "37.0634_-88.6632", "42002": "37.0855_-88.7125", "42003": "37.0368_-88.5934", "42053": "37.0872_-88.8764", "42086": "37.0922_-88.7611", "42631": "36.7437_-84.4808", "42634": "36.8347_-84.4436", "42635": "36.6807_-84.3984", "42638": "36.6734_-84.4722", "42647": "36.7082_-84.5165", "42649": "36.6191_-84.4308", "42653": "36.7217_-84.4676", "42322": "37.6162_-87.3964", "42327": "37.575_-87.2773", "42350": "37.4471_-87.1692", "42352": "37.5045_-87.1239", "42371": "37.5076_-87.2806", "42372": "37.4177_-87.2736", "40385": "37.7426_-84.1441", "40403": "37.5799_-84.2749", "40404": "37.5687_-84.2963", "40405": "37.5545_-84.2083", "40475": "37.7546_-84.2955", "40476": "37.7479_-84.2947", "41426": "37.7843_-83.0109", "41464": "37.6751_-83.0218", "41465": "37.7325_-83.0298", "41632": "37.5892_-82.9452", "40009": "37.4662_-85.1436", "40033": "37.5658_-85.2668", "40037": "37.6421_-85.4113", "40049": "37.6603_-85.3932", "40060": "37.538_-85.43", "40062": "37.6047_-85.4251", "40063": "37.5795_-85.3551", "40328": "37.5758_-85.0824", "42025": "36.8806_-88.3548", "42029": "37.0147_-88.3811", "42044": "36.9655_-88.2667", "42048": "36.7762_-88.2622", "41203": "37.8401_-82.439", "41214": "37.8265_-82.5513", "41224": "37.8754_-82.5337", "41231": "37.8259_-82.4013", "41250": "37.7379_-82.4523", "41262": "37.8687_-82.5971", "41267": "37.875_-82.4386", "41034": "38.691_-83.8718", "41055": "38.522_-83.861", "41056": "38.6207_-83.8067", "41062": "38.7054_-83.9191", "41096": "38.6123_-83.808", "40104": "38.0393_-86.2991", "40108": "37.9662_-86.1084", "40117": "37.9113_-86.1542", "40142": "37.8951_-86.2155", "40155": "37.9371_-85.9918", "40157": "38.0301_-86.4082", "40161": "38.006_-86.3984", "40316": "37.9159_-83.538", "40322": "37.947_-83.6084", "40346": "37.9807_-83.7447", "40387": "37.978_-83.4675", "40310": "37.7534_-84.7666", "40330": "37.8033_-84.8607", "40372": "37.9167_-84.8577", "42124": "36.8705_-85.644", "42129": "37.0008_-85.6095", "42154": "37.0556_-85.6985", "42166": "36.8883_-85.7083", "42214": "37.1177_-85.7038", "42133": "36.72_-85.952", "42140": "36.654_-85.8134", "42151": "36.6535_-85.5698", "42157": "36.7723_-85.8195", "42167": "36.7236_-85.7009", "40334": "38.0161_-83.7713", "40337": "37.964_-83.8558", "40353": "38.0548_-83.9388", "41352": "37.8235_-83.3335", "41408": "37.7901_-83.2741", "41413": "37.9856_-83.0907", "41421": "37.9708_-83.1193", "41425": "37.8912_-83.4444", "41451": "37.872_-83.2582", "41472": "37.9215_-83.2596", "41477": "37.914_-83.2338", "42321": "37.1716_-87.0559", "42323": "37.1737_-87.0349", "42324": "37.1511_-86.9774", "42325": "37.343_-87.233", "42326": "37.1999_-87.0001", "42330": "37.3007_-87.1202", "42332": "37.2533_-87.0897", "42337": "37.2136_-87.048", "42339": "37.084_-87.0079", "42344": "37.2467_-87.2976", "42345": "37.2076_-87.1806", "42367": "37.2429_-87.1549", "42374": "37.3375_-87.1419", "40004": "37.8083_-85.4613", "40008": "37.908_-85.2862", "40012": "37.9025_-85.2015", "40013": "37.9125_-85.4658", "40020": "37.934_-85.3862", "40048": "37.8472_-85.4694", "40051": "37.6438_-85.547", "40052": "37.632_-85.5083", "40107": "37.7408_-85.5948", "40311": "38.3212_-84.0279", "40350": "38.2926_-83.8929", "42320": "37.387_-86.8729", "42328": "37.4079_-87.009", "42333": "37.3418_-86.77", "42338": "37.552_-86.7776", "42343": "37.6297_-86.7263", "42347": "37.4785_-86.918", "42349": "37.4234_-86.6987", "42354": "37.3778_-86.9298", "42361": "37.5259_-86.6875", "42369": "37.3554_-87.0065", "42370": "37.449_-86.7389", "40010": "38.3735_-85.4507", "40014": "38.3326_-85.461", "40026": "38.4113_-85.5708", "40031": "38.4029_-85.3928", "40032": "38.4046_-85.4605", "40056": "38.3039_-85.4834", "40077": "38.4921_-85.4524", "40355": "38.6277_-84.8756", "40359": "38.4986_-84.8086", "40363": "38.5218_-85.0139", "41314": "37.4965_-83.6574", "41351": "37.3126_-83.5916", "41364": "37.3871_-83.6752", "41386": "37.3986_-83.7049", "41006": "38.8013_-84.3446", "41033": "38.7623_-84.4859", "41040": "38.6643_-84.3451", "40981": "37.3313_-83.387", "41367": "37.397_-83.227", "41701": "37.2983_-83.1912", "41702": "37.2495_-83.1932", "41712": "37.3638_-83.1546", "41713": "37.2254_-83.2736", "41719": "37.2983_-83.2544", "41721": "37.301_-83.4936", "41722": "37.315_-83.1561", "41723": "37.2632_-83.3007", "41727": "37.3479_-83.3563", "41729": "37.2649_-83.2174", "41731": "37.134_-83.0768", "41735": "37.0233_-83.0956", "41736": "37.3758_-83.2419", "41739": "37.3394_-83.1303", "41745": "37.3353_-83.4347", "41746": "37.2101_-83.0917", "41751": "37.2184_-83.1427", "41754": "37.3003_-83.3219", "41760": "37.1971_-83.0817", "41763": "37.0705_-83.1136", "41773": "37.202_-83.0658", "41774": "37.1585_-83.1405", "41778": "37.283_-83.3212", "41501": "37.5161_-82.5173", "41502": "37.4793_-82.5188", "41503": "37.667_-82.2886", "41512": "37.2589_-82.4613", "41513": "37.3478_-82.3406", "41514": "37.6401_-82.2573", "41519": "37.5899_-82.3308", "41520": "37.279_-82.5773", "41522": "37.3109_-82.4091", "41524": "37.4266_-82.2562", "41526": "37.4332_-82.511", "41527": "37.6432_-82.2991", "41528": "37.5512_-82.1434", "41531": "37.5928_-82.2328", "41534": "37.2876_-82.4713", "41535": "37.5964_-82.2797", "41538": "37.3165_-82.5829", "41539": "37.5068_-82.3271", "41540": "37.3592_-82.3092", "41542": "37.3148_-82.465", "41543": "37.5624_-82.2803", "41544": "37.5969_-82.1674", "41547": "37.5311_-82.0916", "41548": "37.3815_-82.2727", "41549": "37.2898_-82.5999", "41553": "37.4987_-82.1584", "41554": "37.4484_-82.2985", "41555": "37.5466_-82.2621", "41557": "37.4935_-82.4221", "41558": "37.5426_-82.2085", "41559": "37.3744_-82.3831", "41560": "37.3799_-82.5616", "41561": "37.3316_-82.4626", "41562": "37.4063_-82.4673", "41563": "37.2311_-82.5286", "41564": "37.6076_-82.3648", "41566": "37.4029_-82.2071", "41567": "37.5859_-82.271", "41568": "37.5093_-82.0784", "41571": "37.6275_-82.4356", "41572": "37.3197_-82.6114", "40312": "37.8524_-83.9309", "40376": "37.7951_-83.7041", "40380": "37.8223_-83.7853", "42501": "37.1029_-84.5443", "42502": "37.092_-84.6041", "42503": "37.1566_-84.5248", "42518": "36.9525_-84.6314", "42519": "36.9393_-84.5357", "42533": "37.0677_-84.5927", "42544": "37.0631_-84.7192", "42553": "37.1683_-84.6487", "42558": "36.9492_-84.5815", "42564": "37.1114_-84.5929", "42567": "37.2642_-84.6066", "41064": "38.5218_-84.048", "40409": "37.3815_-84.4336", "40445": "37.3074_-84.2318", "40456": "37.3983_-84.3379", "40460": "37.3734_-84.2528", "40473": "37.3879_-84.3316", "40492": "37.4234_-84.3022", "40313": "38.1287_-83.4425", "40317": "38.1765_-83.2682", "40319": "38.1403_-83.5337", "40351": "38.199_-83.4436", "42629": "36.968_-85.0968", "42642": "37.0551_-85.0375", "40324": "38.2117_-84.5562", "40370": "38.3908_-84.5384", "40379": "38.2888_-84.6818", "40003": "38.2608_-85.0651", "40022": "38.1561_-85.3476", "40065": "38.2162_-85.2243", "40066": "38.1973_-85.2122", "40067": "38.2312_-85.3548", "40076": "38.1054_-85.1288", "42134": "36.7254_-86.57", "42135": "36.7223_-86.5772", "40046": "38.0352_-85.1641", "40071": "38.0471_-85.3829", "42718": "37.3466_-85.3508", "42719": "37.3379_-85.3304", "42733": "37.3393_-85.1918", "42758": "37.3726_-85.1966", "42204": "36.7167_-87.0661", "42216": "37.0045_-87.1521", "42220": "36.9094_-87.1678", "42234": "36.7149_-87.1502", "42280": "36.9278_-87.1003", "42286": "36.7314_-87.2611", "42211": "36.802_-87.8286", "42215": "36.9496_-87.6648", "40006": "38.5864_-85.3133", "40045": "38.6925_-85.3659", "42437": "37.6869_-87.9439", "42459": "37.5487_-87.9965", "42460": "37.494_-87.9328", "42461": "37.7677_-87.9263", "42462": "37.743_-87.8067", "42101": "37.0174_-86.4518", "42102": "36.9223_-86.387", "42103": "36.9663_-86.3933", "42104": "36.9375_-86.4481", "42122": "36.863_-86.3632", "42128": "36.9834_-86.394", "42159": "36.9985_-86.2501", "42170": "36.8557_-86.5623", "42171": "37.0581_-86.1938", "42274": "36.9241_-86.5979", "40040": "37.7568_-85.059", "40061": "37.774_-85.2011", "40069": "37.7342_-85.2107", "40078": "37.8373_-85.1362", "42633": "36.8674_-84.8254", "42404": "37.4756_-87.8368", "42409": "37.5106_-87.7019", "42444": "37.641_-87.6439", "42450": "37.405_-87.7505", "42455": "37.5889_-87.5255", "42456": "37.5054_-87.5053", "42463": "37.488_-87.8661", "40701": "36.9344_-84.1021", "40702": "36.9374_-84.1031", "40730": "36.7039_-84.1415", "40759": "36.8242_-84.104", "40763": "36.7025_-83.955", "40769": "36.747_-84.1394", "41301": "37.7287_-83.494", "41332": "37.7981_-83.421", "41360": "37.7749_-83.6321", "41365": "37.7093_-83.6314", "40347": "38.1487_-84.6928", "40383": "38.0413_-84.7287", "40384": "38.0526_-84.7299", "70516": "30.3446_-92.3459", "70525": "30.4013_-92.224", "70526": "30.2148_-92.3777", "70527": "30.2284_-92.3018", "70531": "30.251_-92.5002", "70534": "30.1808_-92.4643", "70537": "30.2683_-92.5532", "70543": "30.3313_-92.4957", "70556": "30.1861_-92.5722", "70559": "30.1298_-92.4767", "70578": "30.2349_-92.2685", "70638": "30.8547_-92.7815", "70644": "30.7962_-92.9517", "70648": "30.4607_-92.8693", "70651": "30.5648_-92.9583", "70654": "30.7144_-92.9068", "70655": "30.6162_-92.7527", "70658": "30.521_-93.0477", "71463": "30.8172_-92.664", "70346": "30.1018_-90.997", "70707": "30.2047_-90.8695", "70718": "30.201_-90.8689", "70725": "30.13_-90.9651", "70728": "30.2954_-90.9458", "70734": "30.2196_-91.0079", "70737": "30.2473_-90.918", "70738": "30.1388_-90.924", "70769": "30.3073_-90.9405", "70774": "30.2385_-90.8435", "70778": "30.1854_-90.8631", "70339": "29.9476_-91.1885", "70341": "30.026_-91.0444", "70372": "29.8345_-90.9613", "70390": "29.9288_-91.0266", "70391": "29.9902_-91.0588", "70393": "29.9974_-91.0232", "71320": "31.1055_-91.9073", "71322": "30.8641_-92.1466", "71323": "31.2482_-92.2099", "71327": "30.9862_-92.0581", "71329": "30.9294_-91.9479", "71331": "31.2275_-92.0967", "71333": "30.9161_-92.067", "71339": "31.0307_-91.9315", "71341": "31.0534_-92.1399", "71350": "31.0615_-92.0543", "71351": "31.1396_-92.0831", "71355": "31.0988_-91.8748", "71362": "30.9365_-91.9847", "71369": "30.9771_-91.8259", "70634": "30.8287_-93.2685", "70637": "30.6859_-92.9843", "70652": "30.58_-93.2548", "70653": "30.6716_-93.5613", "70657": "30.4703_-93.2337", "70660": "30.5329_-93.465", "70662": "30.8277_-93.017", "71001": "32.5556_-92.9245", "71008": "32.2523_-92.9084", "71016": "32.2452_-93.0936", "71028": "32.5299_-93.0706", "71045": "32.3613_-93.1848", "71068": "32.3263_-93.2982", "71070": "32.197_-92.917", "71080": "32.366_-93.1011", "71006": "32.6976_-93.691", "71037": "32.5507_-93.5657", "71051": "32.3886_-93.5026", "71064": "32.9074_-93.6905", "71067": "32.5791_-93.5226", "71110": "32.5137_-93.6404", "71111": "32.5449_-93.7038", "71112": "32.486_-93.6767", "71113": "32.6276_-93.609", "71171": "32.516_-93.7321", "71172": "32.6276_-93.609", "71004": "32.7544_-93.8508", "71007": "32.3662_-94.0034", "71009": "32.5719_-93.8871", "71029": "32.8251_-93.8293", "71033": "32.4429_-93.973", "71043": "32.8967_-93.8834", "71044": "32.9934_-93.9022", "71047": "32.3161_-93.8881", "71060": "32.6626_-93.973", "71061": "32.7451_-93.9838", "71069": "32.9701_-93.9885", "71082": "32.8423_-93.9504", "71101": "32.5037_-93.7487", "71102": "32.6076_-93.7526", "71103": "32.4945_-93.7727", "71104": "32.483_-93.7349", "71105": "32.4589_-93.7143", "71106": "32.3912_-93.7116", "71107": "32.6016_-93.8738", "71108": "32.4486_-93.7814", "71109": "32.474_-93.8013", "71115": "32.3401_-93.6092", "71118": "32.3977_-93.8025", "71119": "32.4771_-93.8726", "71120": "32.6076_-93.7526", "71129": "32.4141_-93.8742", "71130": "32.6076_-93.7526", "71133": "32.6076_-93.7526", "71134": "32.6076_-93.7526", "71135": "32.6076_-93.7526", "71136": "32.6076_-93.7526", "71137": "32.6076_-93.7526", "71138": "32.6076_-93.7526", "71148": "32.6076_-93.7526", "71149": "32.6076_-93.7526", "71150": "32.5056_-93.7434", "71151": "32.6076_-93.7526", "71152": "32.6076_-93.7526", "71153": "32.6076_-93.7526", "71154": "32.6076_-93.7526", "71156": "32.6076_-93.7526", "71161": "32.6076_-93.7526", "71162": "32.6076_-93.7526", "71163": "32.6076_-93.7526", "71164": "32.6076_-93.7526", "71165": "32.6076_-93.7526", "71166": "32.6076_-93.7526", "70601": "30.2285_-93.188", "70602": "30.2642_-93.3265", "70605": "30.1693_-93.2218", "70606": "30.2642_-93.3265", "70607": "30.1244_-93.1835", "70609": "30.2642_-93.3265", "70611": "30.322_-93.2111", "70612": "30.2642_-93.3265", "70615": "30.2585_-93.1146", "70616": "30.2642_-93.3265", "70629": "30.2642_-93.3265", "70630": "30.1054_-93.0372", "70633": "30.4211_-93.4151", "70646": "30.097_-92.9146", "70647": "30.2219_-93.0259", "70661": "30.3085_-93.6615", "70663": "30.219_-93.3639", "70664": "30.2642_-93.3265", "70665": "30.2009_-93.4437", "70668": "30.2015_-93.5728", "70669": "30.2613_-93.2688", "71415": "32.0344_-92.1381", "71418": "32.1022_-92.1177", "71435": "32.067_-92.1698", "71441": "31.9648_-92.1825", "70631": "29.7911_-93.438", "70632": "29.8646_-93.0033", "70643": "29.7644_-92.9261", "70645": "29.9822_-93.375", "71340": "31.7779_-91.8133", "71343": "31.6862_-91.8678", "71363": "31.6377_-92.0068", "71368": "31.8507_-91.6807", "71401": "31.7835_-91.9935", "71425": "31.9064_-91.8751", "71003": "32.6451_-93.0239", "71038": "32.9278_-93.0691", "71040": "32.7749_-93.0288", "71048": "32.8452_-92.8878", "71079": "32.9238_-92.8215", "71316": "31.3016_-91.8216", "71326": "31.7158_-91.5163", "71334": "31.6602_-91.5502", "71354": "31.4499_-91.7182", "71373": "31.5782_-91.4695", "71377": "31.6094_-91.7808", "71027": "32.245_-93.6915", "71030": "32.1858_-93.801", "71032": "32.105_-93.7941", "71046": "32.1622_-93.951", "71049": "31.9943_-93.9627", "71050": "32.0977_-93.9521", "71052": "32.0239_-93.698", "71063": "31.8966_-93.5634", "71078": "32.2848_-93.8003", "70704": "30.5159_-91.0804", "70714": "30.5814_-91.1429", "70739": "30.5984_-90.9705", "70770": "30.6133_-90.9943", "70791": "30.6561_-91.1358", "70801": "30.4492_-91.1856", "70802": "30.4438_-91.1775", "70803": "30.405_-91.1868", "70804": "30.3863_-91.1339", "70805": "30.486_-91.1481", "70806": "30.4485_-91.13", "70807": "30.5768_-91.2246", "70808": "30.4066_-91.1468", "70809": "30.4089_-91.0842", "70810": "30.3633_-91.0919", "70811": "30.5317_-91.1167", "70812": "30.5052_-91.1181", "70813": "30.5201_-91.1949", "70814": "30.4848_-91.0689", "70815": "30.4558_-91.0596", "70816": "30.4273_-91.0356", "70817": "30.3904_-91.0021", "70818": "30.5408_-91.05", "70819": "30.4668_-91.0156", "70820": "30.3795_-91.1671", "70821": "30.4613_-91.0447", "70822": "30.5159_-91.0804", "70823": "30.5159_-91.0804", "70825": "30.5159_-91.0804", "70826": "30.5159_-91.0804", "70827": "30.4338_-91.0825", "70831": "30.5159_-91.0804", "70833": "30.5159_-91.0804", "70835": "30.5159_-91.0804", "70836": "30.392_-91.0892", "70837": "30.5159_-91.0804", "70873": "30.5305_-91.1163", "70874": "30.5902_-91.2054", "70879": "30.5159_-91.0804", "70884": "30.5159_-91.0804", "70891": "30.4492_-91.1547", "70892": "30.4507_-91.1546", "70893": "30.413_-91.1715", "70894": "30.5159_-91.0804", "70895": "30.5159_-91.0804", "70896": "30.5159_-91.0804", "70898": "30.5159_-91.0804", "71254": "32.8071_-91.1906", "71276": "32.5756_-91.1496", "71286": "32.6705_-91.2288", "70722": "30.8249_-90.9331", "70730": "30.8131_-91.11", "70748": "30.8087_-91.1987", "70761": "30.9518_-91.0629", "70777": "30.7383_-91.07", "70789": "30.9473_-91.0655", "70515": "30.4978_-92.5736", "70524": "30.5709_-92.3202", "70554": "30.6496_-92.4196", "70576": "30.7831_-92.4163", "70580": "30.675_-92.4265", "70585": "30.8707_-92.404", "70586": "30.6924_-92.2737", "71367": "30.8998_-92.2964", "71219": "32.2897_-91.7132", "71230": "32.2407_-91.5901", "71243": "32.0434_-91.8257", "71249": "32.0349_-91.7468", "71295": "32.1592_-91.7108", "71324": "32.0971_-91.699", "71336": "32.0349_-91.592", "71378": "31.9913_-91.6768", "71407": "31.5157_-92.4882", "71417": "31.5079_-92.6568", "71423": "31.5979_-92.5665", "71432": "31.745_-92.3952", "71454": "31.6674_-92.8412", "71467": "31.5_-92.4005", "70513": "29.8981_-91.9062", "70544": "29.9032_-91.6544", "70552": "30.0683_-91.6596", "70560": "30.001_-91.82", "70562": "30.0035_-91.8187", "70563": "30.0245_-91.7496", "70569": "29.9239_-91.7831", "70721": "30.2184_-91.0925", "70740": "30.3879_-91.4383", "70757": "30.4626_-91.5099", "70764": "30.2684_-91.2524", "70765": "30.2891_-91.2343", "70772": "30.4408_-91.4562", "70776": "30.2528_-91.0857", "70780": "30.2982_-91.1799", "70788": "30.1545_-91.1773", "71226": "32.2922_-92.4374", "71238": "32.3988_-92.3479", "71247": "32.2768_-92.7235", "71251": "32.2483_-92.6944", "71268": "32.3564_-92.7085", "70001": "29.9871_-90.1695", "70002": "30.0098_-90.163", "70003": "29.9975_-90.2146", "70004": "29.9841_-90.1529", "70005": "30.0005_-90.1331", "70006": "30.0129_-90.1915", "70009": "29.9841_-90.1529", "70010": "29.9841_-90.1529", "70011": "29.9841_-90.1529", "70033": "29.9841_-90.1529", "70036": "29.6964_-90.1122", "70053": "29.9108_-90.0531", "70054": "29.9146_-90.054", "70055": "29.9841_-90.1529", "70056": "29.8872_-90.0331", "70058": "29.8725_-90.0673", "70059": "29.9035_-90.0773", "70060": "29.9841_-90.1529", "70062": "29.9912_-90.2479", "70063": "29.9941_-90.2417", "70064": "29.9941_-90.2417", "70065": "30.0252_-90.2522", "70067": "29.7143_-90.1052", "70072": "29.8598_-90.1105", "70073": "29.8994_-90.1004", "70094": "29.8973_-90.2033", "70096": "29.906_-90.1423", "70097": "29.9565_-90.2635", "70121": "29.9614_-90.1577", "70123": "29.9511_-90.206", "70141": "29.9546_-90.0751", "70181": "29.6779_-90.0901", "70183": "29.9546_-90.0751", "70358": "29.2297_-90.0088", "70532": "30.4715_-92.6996", "70546": "30.2201_-92.6574", "70549": "30.091_-92.6825", "70581": "30.2464_-92.7421", "70591": "30.2363_-92.819", "70640": "30.3655_-92.9122", "70650": "30.2374_-92.9232", "70501": "30.2361_-92.0083", "70502": "30.2241_-92.0198", "70503": "30.1843_-92.0497", "70504": "30.2139_-92.0187", "70505": "30.2023_-92.0188", "70506": "30.2077_-92.0656", "70507": "30.2813_-92.016", "70508": "30.1582_-92.0236", "70509": "30.1565_-92", "70518": "30.1219_-91.9502", "70520": "30.3244_-92.0423", "70529": "30.1912_-92.1525", "70558": "30.1038_-92.0765", "70583": "30.2504_-92.0981", "70592": "30.0975_-92.0096", "70593": "30.2081_-92.0951", "70596": "30.2241_-92.0198", "70598": "30.2081_-92.0951", "70301": "29.7992_-90.8096", "70302": "29.7958_-90.8229", "70310": "29.8033_-90.8169", "70345": "29.5232_-90.3393", "70354": "29.4311_-90.2981", "70355": "29.7076_-90.4849", "70357": "29.3821_-90.2639", "70371": "29.8652_-90.5962", "70373": "29.5724_-90.3817", "70374": "29.6155_-90.4442", "70375": "29.6938_-90.5496", "70394": "29.7178_-90.5999", "71342": "31.6748_-92.1137", "71371": "31.6531_-92.1993", "71465": "31.8734_-92.2214", "71479": "31.8569_-92.374", "71480": "31.865_-92.2915", "71227": "32.5556_-92.5224", "71235": "32.6949_-92.6785", "71245": "32.5244_-92.7158", "71270": "32.5308_-92.6439", "71272": "32.5258_-92.6493", "71273": "32.6065_-92.6484", "71275": "32.5384_-92.7995", "70449": "30.2716_-90.7043", "70462": "30.4157_-90.5775", "70706": "30.6085_-90.9038", "70711": "30.5149_-90.5964", "70726": "30.459_-90.9027", "70727": "30.3375_-90.8434", "70733": "30.2952_-90.7951", "70744": "30.5556_-90.6652", "70754": "30.4741_-90.7673", "70785": "30.5247_-90.8557", "70786": "30.5502_-90.9582", "71233": "32.3257_-90.927", "71282": "32.4326_-91.0645", "71284": "32.4085_-91.1868", "71220": "32.7894_-91.9078", "71221": "32.7562_-91.8723", "71223": "32.9123_-91.6822", "71229": "32.6971_-91.8634", "71250": "32.9663_-91.5965", "71261": "32.7718_-91.7716", "71264": "32.6243_-91.7618", "71002": "32.1378_-93.0906", "71031": "32_-92.9611", "71066": "31.8741_-93.1966", "71411": "31.8959_-93.0936", "71414": "31.8216_-93.0296", "71416": "31.5432_-92.9182", "71428": "31.6124_-93.098", "71434": "31.433_-92.9435", "71450": "31.7726_-93.3954", "71452": "31.6104_-92.9745", "71455": "31.4016_-92.974", "71456": "31.6615_-93.0241", "71457": "31.7617_-93.0916", "71458": "31.7476_-93.0791", "71468": "31.5157_-93.1488", "71469": "31.7715_-93.321", "71497": "31.7476_-93.0791", "70112": "29.9605_-90.0753", "70113": "29.9405_-90.0848", "70114": "29.9379_-90.0331", "70115": "29.9289_-90.1005", "70116": "29.9686_-90.0646", "70117": "29.9703_-90.0312", "70118": "29.9504_-90.1236", "70119": "29.9746_-90.0852", "70122": "30.0056_-90.0644", "70124": "30.0071_-90.1094", "70125": "29.9512_-90.1028", "70126": "29.9987_-90.0446", "70127": "30.0313_-89.9758", "70128": "30.0487_-89.9585", "70129": "30.0877_-89.8462", "70130": "29.9324_-90.0739", "70131": "29.9168_-89.996", "70139": "29.9546_-90.0751", "70142": "29.9546_-90.0751", "70143": "29.9546_-90.0751", "70145": "29.9546_-90.0751", "70146": "29.9546_-90.0751", "70148": "30.0309_-90.068", "70150": "29.9546_-90.0751", "70151": "29.9546_-90.0751", "70152": "29.9546_-90.0751", "70153": "29.9546_-90.0751", "70154": "29.9546_-90.0751", "70156": "29.9546_-90.0751", "70157": "29.9546_-90.0751", "70158": "29.9229_-90.0709", "70159": "29.9546_-90.0751", "70160": "29.9546_-90.0751", "70161": "29.9546_-90.0751", "70162": "29.9546_-90.0751", "70163": "29.95_-90.0755", "70164": "29.9546_-90.0751", "70165": "29.9546_-90.0751", "70166": "29.9546_-90.0751", "70167": "29.9546_-90.0751", "70170": "29.9546_-90.0751", "70172": "29.9546_-90.0751", "70174": "29.9546_-90.0751", "70175": "29.9546_-90.0751", "70176": "29.9546_-90.0751", "70177": "29.9546_-90.0751", "70178": "29.9546_-90.0751", "70179": "29.9546_-90.0751", "70182": "29.9546_-90.0751", "70184": "29.9546_-90.0751", "70185": "29.9546_-90.0751", "70186": "29.9546_-90.0751", "70187": "29.9546_-90.0751", "70189": "29.9546_-90.0751", "70190": "29.9546_-90.0751", "70195": "29.9546_-90.0751", "71201": "32.5286_-92.1061", "71202": "32.3868_-92.0722", "71203": "32.553_-92.0422", "71207": "32.5093_-92.1193", "71209": "32.5277_-92.0756", "71210": "32.4908_-92.1594", "71211": "32.4908_-92.1594", "71212": "32.5093_-92.1193", "71213": "32.4908_-92.1594", "71217": "32.5116_-92.0849", "71225": "32.5248_-92.3299", "71240": "32.6443_-92.0365", "71280": "32.7119_-92.0981", "71281": "32.4908_-92.1594", "71291": "32.5317_-92.176", "71292": "32.4566_-92.1854", "71294": "32.4908_-92.1594", "70037": "29.8345_-90.0042", "70038": "29.3079_-89.3814", "70040": "29.7361_-89.9197", "70041": "29.3519_-89.5242", "70050": "29.3814_-89.5926", "70081": "29.1816_-89.2576", "70082": "29.542_-89.7512", "70083": "29.47_-89.6847", "70091": "29.2659_-89.3761", "70093": "29.8549_-89.9906", "70715": "30.8298_-91.6944", "70732": "30.596_-91.6165", "70736": "30.6376_-91.3423", "70747": "30.8736_-91.6766", "70749": "30.6326_-91.4332", "70752": "30.5799_-91.4217", "70753": "30.9324_-91.7403", "70755": "30.5524_-91.5332", "70756": "30.5563_-91.6418", "70759": "30.7245_-91.5959", "70760": "30.7014_-91.4421", "70762": "30.5983_-91.4577", "70773": "30.6035_-91.3813", "70783": "30.6814_-91.4033", "71301": "31.2885_-92.4633", "71302": "31.2683_-92.4242", "71303": "31.3048_-92.5089", "71306": "31.3113_-92.4451", "71307": "31.2034_-92.5269", "71309": "31.3047_-92.6196", "71315": "31.1397_-92.3984", "71325": "31.0201_-92.2951", "71328": "31.3574_-92.1654", "71330": "31.1093_-92.2395", "71346": "31.106_-92.389", "71348": "31.3541_-92.3335", "71359": "31.3224_-92.4343", "71360": "31.2232_-92.3203", "71361": "31.3692_-92.4198", "71365": "31.1894_-92.2487", "71405": "31.4151_-92.3945", "71409": "31.3216_-92.6867", "71424": "31.1465_-92.7171", "71427": "31.3849_-92.8812", "71430": "31.0243_-92.5108", "71431": "31.2587_-92.6775", "71433": "31.0262_-92.616", "71438": "31.1669_-92.7375", "71447": "31.4207_-92.8312", "71448": "31.0066_-92.5526", "71466": "31.2077_-92.7392", "71472": "31.1976_-92.7858", "71477": "31.3999_-92.6042", "71485": "31.1635_-92.5322", "71019": "32.0231_-93.2648", "71034": "32.1752_-93.3047", "71218": "32.3632_-91.7693", "71232": "32.3929_-91.4714", "71259": "32.3331_-91.7976", "71269": "32.4456_-91.7433", "71279": "32.4865_-91.8593", "71065": "31.8086_-93.5136", "71406": "31.71_-93.4959", "71419": "31.7339_-93.6902", "71426": "31.4937_-93.4602", "71429": "31.4275_-93.5179", "71449": "31.5851_-93.4641", "71460": "31.4693_-93.5749", "71462": "31.6938_-93.7167", "71486": "31.6138_-93.6636", "70032": "29.9612_-89.9965", "70043": "29.9466_-89.9611", "70044": "29.9676_-89.9514", "70075": "29.9335_-89.9214", "70085": "29.8611_-89.8364", "70092": "29.9043_-89.896", "70030": "29.8134_-90.4407", "70031": "29.9435_-90.2925", "70039": "29.8973_-90.3934", "70047": "29.9642_-90.3682", "70057": "29.9668_-90.4082", "70070": "29.9251_-90.3693", "70078": "29.9817_-90.3859", "70079": "30.0057_-90.4198", "70080": "29.877_-90.4352", "70087": "29.9581_-90.3124", "70441": "30.8647_-90.7256", "70453": "30.7032_-90.7672", "70052": "30.0527_-90.6902", "70071": "30.0447_-90.7008", "70086": "30.0276_-90.8605", "70090": "29.9694_-90.7097", "70723": "30.0208_-90.8298", "70743": "30.0206_-90.7814", "70763": "30.0352_-90.7374", "70792": "30.0279_-90.8028", "70049": "30.0319_-90.5817", "70051": "30.0535_-90.6201", "70068": "30.0777_-90.4895", "70069": "30.0912_-90.4832", "70076": "30.0575_-90.6369", "70084": "30.0603_-90.5518", "70512": "30.3981_-91.9263", "70535": "30.5116_-92.3985", "70541": "30.4201_-92.0462", "70550": "30.5165_-92.1841", "70551": "30.4752_-91.9737", "70570": "30.5144_-92.0897", "70571": "30.5335_-92.0815", "70577": "30.5478_-91.9286", "70584": "30.3884_-92.0934", "70589": "30.6839_-92.0252", "70750": "30.5379_-91.7563", "71345": "30.7292_-91.9755", "71353": "30.6626_-91.7565", "71356": "30.8299_-92.0426", "71358": "30.7065_-91.9114", "70517": "30.2948_-91.8296", "70519": "30.0797_-91.9114", "70521": "30.3364_-91.8492", "70582": "30.2237_-91.7794", "70340": "29.6663_-91.102", "70342": "29.6929_-91.2518", "70380": "29.6977_-91.2654", "70381": "29.6946_-91.2593", "70392": "29.6967_-91.2812", "70514": "29.8488_-91.5458", "70522": "29.7523_-91.4397", "70523": "29.8796_-91.5337", "70538": "29.7857_-91.5026", "70540": "29.7633_-91.467", "70420": "30.4837_-90.0041", "70431": "30.6134_-89.9557", "70433": "30.4876_-90.0959", "70434": "30.4755_-90.1004", "70435": "30.5661_-90.1098", "70437": "30.6145_-90.1879", "70445": "30.322_-89.9297", "70447": "30.4287_-90.1773", "70448": "30.3666_-90.0487", "70452": "30.3944_-89.7732", "70457": "30.5269_-90.1126", "70458": "30.2784_-89.7712", "70459": "30.4255_-89.8813", "70460": "30.2916_-89.8129", "70461": "30.2726_-89.729", "70463": "30.6491_-89.8926", "70464": "30.5347_-89.8859", "70469": "30.2752_-89.7812", "70470": "30.4255_-89.8813", "70471": "30.4207_-90.0589", "70401": "30.5191_-90.4879", "70402": "30.514_-90.4804", "70403": "30.4911_-90.4697", "70404": "30.5046_-90.4629", "70421": "30.2902_-90.4018", "70422": "30.7266_-90.509", "70436": "30.8128_-90.5207", "70442": "30.692_-90.339", "70443": "30.6351_-90.5277", "70444": "30.8892_-90.4728", "70446": "30.5884_-90.3567", "70451": "30.5519_-90.4859", "70454": "30.4406_-90.4422", "70455": "30.5063_-90.3352", "70456": "30.7717_-90.5243", "70465": "30.8764_-90.5089", "70466": "30.5668_-90.482", "71357": "32.0656_-91.2578", "71366": "31.9248_-91.2784", "71375": "31.8076_-91.3872", "70343": "29.5485_-90.6087", "70344": "29.4634_-90.598", "70352": "29.6964_-90.9444", "70353": "29.3695_-90.697", "70356": "29.6625_-90.9776", "70359": "29.6903_-90.7807", "70360": "29.5943_-90.7548", "70361": "29.5958_-90.7195", "70363": "29.5601_-90.6917", "70364": "29.6299_-90.7268", "70377": "29.4744_-90.544", "70395": "29.7123_-90.8513", "70397": "29.4516_-90.7651", "71222": "32.8221_-92.6579", "71234": "32.6525_-92.3745", "71241": "32.7534_-92.318", "71256": "32.9529_-92.6858", "71260": "32.8716_-92.2862", "71277": "32.955_-92.587", "70510": "29.9466_-92.2416", "70511": "29.9747_-92.1343", "70528": "29.9474_-91.9889", "70533": "29.9522_-92.0343", "70542": "30.0255_-92.5338", "70548": "29.9771_-92.3025", "70555": "30.0722_-92.107", "70575": "29.9485_-92.1571", "70639": "30.9684_-93.5203", "70656": "30.933_-92.9548", "70659": "30.9243_-93.2749", "71403": "31.2149_-93.3829", "71439": "31.3226_-93.3683", "71443": "31.3374_-93.1657", "71446": "31.1256_-93.1736", "71459": "31.0466_-93.2054", "71461": "31.1149_-93.2716", "71474": "31.257_-93.017", "71475": "31.2024_-93.1274", "71496": "31.1435_-93.261", "70426": "30.9224_-89.8567", "70427": "30.7733_-89.8653", "70429": "30.791_-89.8487", "70438": "30.8577_-90.1155", "70450": "30.9536_-90.2769", "70467": "30.8938_-89.8295", "71018": "32.819_-93.4259", "71021": "32.9721_-93.4492", "71023": "32.49_-93.3996", "71024": "32.5192_-93.2142", "71039": "32.447_-93.2852", "71055": "32.6323_-93.2886", "71058": "32.6154_-93.2868", "71071": "32.9434_-93.4404", "71072": "32.9713_-93.2963", "71073": "32.5095_-93.3009", "71075": "33.0005_-93.4596", "70710": "30.3557_-91.2613", "70719": "30.3877_-91.2526", "70729": "30.548_-91.4187", "70767": "30.472_-91.2541", "71237": "32.6161_-91.4913", "71242": "32.8239_-91.3989", "71253": "32.9946_-91.3162", "71263": "32.8731_-91.4302", "71266": "32.7154_-91.4648", "70712": "30.9656_-91.5979", "70775": "30.8694_-91.4186", "70782": "30.9601_-91.5396", "70784": "30.9175_-91.3581", "70787": "30.9468_-91.4612", "71404": "31.776_-92.7958", "71410": "31.9657_-92.7757", "71422": "32.0701_-92.6783", "71440": "31.9393_-92.5988", "71471": "31.7596_-92.959", "71473": "32.0686_-92.4429", "71483": "31.9214_-92.6366", "02532": "41.7455_-70.5905", "02534": "41.6694_-70.6234", "02536": "41.5968_-70.5671", "02537": "41.7283_-70.44", "02540": "41.5648_-70.6217", "02541": "41.5515_-70.6148", "02542": "41.6531_-70.5537", "02543": "41.5263_-70.6643", "02553": "41.7196_-70.612", "02556": "41.6417_-70.623", "02559": "41.6881_-70.6105", "02561": "41.7703_-70.5337", "02562": "41.7933_-70.5196", "02563": "41.7113_-70.4775", "02574": "41.6039_-70.6382", "02601": "41.6601_-70.2967", "02630": "41.6983_-70.3001", "02631": "41.7492_-70.0699", "02632": "41.6606_-70.3532", "02633": "41.6889_-69.9722", "02634": "41.6487_-70.3481", "02635": "41.6243_-70.4364", "02637": "41.7014_-70.2772", "02638": "41.7322_-70.1911", "02639": "41.6649_-70.1327", "02641": "41.7426_-70.162", "02642": "41.8408_-69.9849", "02643": "41.7843_-69.962", "02644": "41.6827_-70.5143", "02645": "41.7008_-70.0579", "02646": "41.6703_-70.0722", "02647": "41.635_-70.3063", "02648": "41.6703_-70.4163", "02649": "41.6181_-70.4854", "02650": "41.703_-69.9666", "02651": "41.8243_-69.9818", "02652": "42.0338_-70.0875", "02653": "41.7792_-69.9822", "02655": "41.63_-70.3837", "02657": "42.0534_-70.1865", "02659": "41.6801_-70.0241", "02660": "41.7097_-70.1585", "02661": "41.6862_-70.0329", "02662": "41.7567_-69.9841", "02663": "41.9182_-69.9953", "02664": "41.6739_-70.1949", "02666": "41.9988_-70.0564", "02667": "41.9289_-70.0186", "02668": "41.7002_-70.372", "02669": "41.6812_-69.9911", "02670": "41.6626_-70.1681", "02671": "41.6694_-70.1135", "02672": "41.6356_-70.3233", "02673": "41.6614_-70.2363", "02675": "41.7051_-70.227", "01029": "42.1909_-73.0517", "01201": "42.4531_-73.2471", "01202": "42.3929_-73.2285", "01203": "42.3929_-73.2285", "01220": "42.6223_-73.1172", "01222": "42.0596_-73.3202", "01223": "42.3594_-73.1203", "01224": "42.5126_-73.1929", "01225": "42.5611_-73.158", "01226": "42.475_-73.1603", "01227": "42.4737_-73.1662", "01229": "42.2793_-73.3435", "01230": "42.1959_-73.3607", "01235": "42.4298_-73.0724", "01236": "42.2653_-73.3745", "01237": "42.5173_-73.2282", "01238": "42.299_-73.2317", "01240": "42.3642_-73.2713", "01242": "42.3386_-73.2509", "01244": "42.1228_-73.254", "01245": "42.1867_-73.2065", "01247": "42.6955_-73.08", "01252": "42.1986_-73.4462", "01253": "42.1931_-73.0918", "01254": "42.3784_-73.3645", "01255": "42.1094_-73.1163", "01256": "42.577_-73.0233", "01257": "42.1001_-73.3611", "01258": "42.1012_-73.4566", "01259": "42.078_-73.2609", "01260": "42.2779_-73.2773", "01262": "42.301_-73.3223", "01263": "42.3929_-73.2285", "01264": "42.22_-73.1979", "01266": "42.3348_-73.3825", "01267": "42.7089_-73.2036", "01270": "42.515_-73.0412", "01343": "42.6427_-72.9862", "02048": "42.0212_-71.2178", "02334": "42.0235_-71.1324", "02356": "42.059_-71.1123", "02357": "42.0645_-71.0871", "02375": "42.0257_-71.0988", "02702": "41.7975_-71.0607", "02703": "41.9296_-71.3009", "02712": "41.9487_-71.2259", "02714": "41.7562_-71.0671", "02715": "41.8125_-71.1427", "02717": "41.7635_-70.9677", "02718": "41.8736_-71.0192", "02719": "41.6409_-70.8896", "02720": "41.7182_-71.14", "02721": "41.6883_-71.1574", "02722": "41.7015_-71.155", "02723": "41.6926_-71.1332", "02724": "41.685_-71.1748", "02725": "41.7223_-71.178", "02726": "41.756_-71.1492", "02740": "41.6347_-70.9372", "02741": "41.6362_-70.9342", "02742": "41.6362_-70.9342", "02743": "41.6997_-70.9087", "02744": "41.6127_-70.9167", "02745": "41.6913_-70.9355", "02746": "41.66_-70.9324", "02747": "41.6338_-70.9958", "02748": "41.5665_-70.9843", "02760": "41.9775_-71.3298", "02761": "41.9834_-71.3328", "02763": "41.9726_-71.3082", "02764": "41.8529_-71.1485", "02766": "41.9718_-71.1894", "02767": "41.9324_-71.0469", "02768": "41.7562_-71.0671", "02769": "41.8515_-71.2545", "02771": "41.8378_-71.3224", "02777": "41.7473_-71.2122", "02779": "41.8353_-71.0765", "02780": "41.905_-71.1026", "02783": "41.7562_-71.0671", "02790": "41.6211_-71.089", "02791": "41.5223_-71.0745", "02535": "41.3575_-70.7416", "02539": "41.3889_-70.5339", "02552": "41.3798_-70.6431", "02557": "41.4543_-70.562", "02568": "41.45_-70.5937", "02575": "41.4213_-70.6428", "02713": "41.4218_-70.9313", "01810": "42.6496_-71.1565", "01812": "42.6472_-71.1842", "01830": "42.7856_-71.0721", "01831": "42.7711_-71.1221", "01832": "42.7792_-71.1095", "01833": "42.7281_-70.9822", "01834": "42.753_-71.027", "01835": "42.7528_-71.0843", "01840": "42.708_-71.1638", "01841": "42.7115_-71.167", "01842": "42.707_-71.1631", "01843": "42.6911_-71.1605", "01844": "42.728_-71.181", "01845": "42.6826_-71.109", "01860": "42.8346_-71.0047", "01885": "42.707_-71.0639", "01899": "42.6584_-71.137", "01901": "42.4612_-70.9467", "01902": "42.4698_-70.942", "01903": "42.4668_-70.9495", "01904": "42.4889_-70.9647", "01905": "42.4694_-70.9728", "01906": "42.4633_-71.0111", "01907": "42.4746_-70.9098", "01908": "42.4261_-70.9277", "01910": "42.4548_-70.9747", "01913": "42.8559_-70.9367", "01915": "42.5608_-70.8759", "01921": "42.6797_-71.0114", "01922": "42.7568_-70.9351", "01923": "42.5694_-70.9425", "01929": "42.6286_-70.7828", "01930": "42.6208_-70.6721", "01931": "42.6159_-70.662", "01936": "42.6354_-70.8791", "01937": "42.5862_-70.9745", "01938": "42.6809_-70.8494", "01940": "42.5327_-71.0339", "01944": "42.5796_-70.7674", "01945": "42.4984_-70.8653", "01949": "42.5942_-71.013", "01950": "42.813_-70.8847", "01951": "42.7835_-70.8474", "01952": "42.8507_-70.8588", "01960": "42.5326_-70.9612", "01961": "42.6354_-70.8791", "01965": "42.5581_-70.8257", "01966": "42.658_-70.6194", "01969": "42.7138_-70.907", "01970": "42.5151_-70.9003", "01971": "42.6354_-70.8791", "01982": "42.6185_-70.8561", "01983": "42.6415_-70.9488", "01984": "42.6017_-70.8786", "01985": "42.7949_-70.9778", "05501": "42.6472_-71.1842", "05544": "42.6472_-71.1842", "01054": "42.4682_-72.4993", "01072": "42.482_-72.4213", "01093": "42.4427_-72.6525", "01301": "42.6013_-72.6236", "01302": "42.5222_-72.6242", "01330": "42.5232_-72.811", "01337": "42.6952_-72.5772", "01338": "42.5736_-72.8213", "01339": "42.608_-72.8901", "01340": "42.679_-72.7265", "01341": "42.5138_-72.7025", "01342": "42.5406_-72.6072", "01344": "42.6076_-72.4292", "01346": "42.6853_-72.8391", "01347": "42.5566_-72.5181", "01349": "42.582_-72.4926", "01350": "42.7215_-72.9762", "01351": "42.5429_-72.5328", "01354": "42.6404_-72.4995", "01355": "42.5146_-72.3062", "01360": "42.6887_-72.451", "01364": "42.6129_-72.2924", "01367": "42.6953_-72.9258", "01370": "42.6022_-72.7391", "01373": "42.4756_-72.6153", "01375": "42.4539_-72.5676", "01376": "42.5954_-72.5557", "01378": "42.6671_-72.3397", "01379": "42.5656_-72.4009", "01380": "42.5534_-72.3927", "01001": "42.0702_-72.6227", "01008": "42.1829_-72.9361", "01009": "42.2061_-72.3405", "01010": "42.1165_-72.1885", "01011": "42.2794_-72.9888", "01013": "42.1487_-72.6079", "01014": "42.1707_-72.6048", "01020": "42.1764_-72.5761", "01021": "42.1707_-72.6048", "01022": "42.1934_-72.5544", "01028": "42.0672_-72.5056", "01030": "42.0718_-72.6751", "01034": "42.1127_-72.952", "01036": "42.0648_-72.4318", "01040": "42.202_-72.6262", "01041": "42.2043_-72.6162", "01056": "42.1728_-72.471", "01057": "42.101_-72.3196", "01069": "42.1762_-72.3288", "01071": "42.1471_-72.8403", "01077": "42.0511_-72.7706", "01079": "42.1929_-72.3296", "01080": "42.1819_-72.3624", "01081": "42.0627_-72.2046", "01085": "42.1251_-72.7495", "01086": "42.1734_-72.848", "01089": "42.1151_-72.6411", "01090": "42.1707_-72.6048", "01095": "42.1245_-72.4464", "01097": "42.164_-72.8295", "01101": "42.1015_-72.5898", "01102": "42.1707_-72.6048", "01103": "42.1029_-72.5887", "01104": "42.1288_-72.5778", "01105": "42.0999_-72.5783", "01106": "42.0507_-72.5676", "01107": "42.1179_-72.6065", "01108": "42.0853_-72.5584", "01109": "42.1145_-72.5543", "01111": "42.1707_-72.6048", "01115": "42.1029_-72.5916", "01116": "42.1707_-72.6048", "01118": "42.0929_-72.5274", "01119": "42.1247_-72.5121", "01128": "42.0944_-72.4889", "01129": "42.1223_-72.4876", "01138": "42.1707_-72.6048", "01139": "42.1707_-72.6048", "01144": "42.1018_-72.5915", "01151": "42.1532_-72.505", "01152": "42.1707_-72.6048", "01199": "42.1199_-72.605", "01521": "42.0403_-72.1544", "01002": "42.3671_-72.4646", "01003": "42.3919_-72.5248", "01004": "42.3845_-72.5132", "01007": "42.2751_-72.411", "01012": "42.3923_-72.8256", "01026": "42.4633_-72.9202", "01027": "42.2668_-72.669", "01032": "42.4404_-72.7995", "01033": "42.2557_-72.52", "01035": "42.3606_-72.5715", "01038": "42.3844_-72.6167", "01039": "42.3818_-72.7032", "01050": "42.2653_-72.8733", "01053": "42.3543_-72.7034", "01059": "42.4104_-72.5309", "01060": "42.3223_-72.6313", "01061": "42.3696_-72.636", "01062": "42.3219_-72.6928", "01063": "42.3179_-72.6402", "01066": "42.4112_-72.6223", "01070": "42.5144_-72.9183", "01073": "42.2247_-72.7194", "01075": "42.2375_-72.5811", "01082": "42.2618_-72.2583", "01084": "42.3903_-72.8709", "01088": "42.3906_-72.6469", "01096": "42.4085_-72.778", "01098": "42.3843_-72.9314", "01243": "42.3561_-73.0104", "01431": "42.6745_-71.8174", "01432": "42.5591_-71.5788", "01450": "42.6124_-71.5584", "01460": "42.5401_-71.4877", "01463": "42.6689_-71.5934", "01464": "42.5734_-71.6483", "01469": "42.6525_-71.6896", "01470": "42.6112_-71.5745", "01471": "42.6112_-71.5745", "01472": "42.6043_-71.6273", "01474": "42.6678_-71.7522", "01701": "42.3007_-71.4255", "01702": "42.2822_-71.4339", "01703": "42.4464_-71.4594", "01704": "42.4464_-71.4594", "01705": "42.4464_-71.4594", "01718": "42.4851_-71.4328", "01719": "42.4884_-71.5178", "01720": "42.4751_-71.4483", "01721": "42.2539_-71.4583", "01730": "42.4843_-71.2768", "01731": "42.4567_-71.2795", "01741": "42.5286_-71.3519", "01742": "42.4567_-71.3747", "01746": "42.2026_-71.4361", "01748": "42.219_-71.5302", "01749": "42.3918_-71.5609", "01752": "42.3509_-71.5434", "01754": "42.4321_-71.455", "01760": "42.2875_-71.3574", "01770": "42.2331_-71.3787", "01773": "42.4217_-71.3137", "01775": "42.4308_-71.515", "01776": "42.3837_-71.4282", "01778": "42.3486_-71.3588", "01784": "42.2376_-71.562", "01801": "42.4829_-71.1574", "01803": "42.5089_-71.2004", "01805": "42.5048_-71.1956", "01813": "42.4793_-71.1523", "01815": "42.4793_-71.1523", "01821": "42.5519_-71.2518", "01822": "42.5584_-71.2689", "01824": "42.5911_-71.3556", "01826": "42.6764_-71.3186", "01827": "42.6739_-71.4952", "01850": "42.656_-71.3051", "01851": "42.6315_-71.3329", "01852": "42.6344_-71.2983", "01853": "42.6334_-71.3162", "01854": "42.6493_-71.3355", "01862": "42.5757_-71.2902", "01863": "42.6347_-71.3908", "01864": "42.5819_-71.0947", "01865": "42.5379_-71.2689", "01866": "42.5293_-71.2281", "01867": "42.528_-71.109", "01876": "42.6028_-71.2232", "01879": "42.6724_-71.4158", "01880": "42.5009_-71.0685", "01886": "42.5864_-71.4401", "01887": "42.5581_-71.1723", "01888": "42.4793_-71.1523", "01889": "42.5716_-71.1096", "01890": "42.453_-71.1441", "02138": "42.377_-71.1256", "02139": "42.3647_-71.1042", "02140": "42.3932_-71.1338", "02141": "42.3687_-71.0836", "02142": "42.362_-71.083", "02143": "42.3829_-71.1028", "02144": "42.4003_-71.1221", "02145": "42.3907_-71.0929", "02148": "42.4291_-71.0605", "02149": "42.4112_-71.0514", "02153": "42.4184_-71.1062", "02155": "42.4173_-71.1087", "02156": "42.4223_-71.1328", "02176": "42.4581_-71.0632", "02180": "42.4828_-71.0978", "02212": "42.3584_-71.0598", "02238": "42.3751_-71.1056", "02420": "42.4563_-71.2167", "02421": "42.4426_-71.2265", "02451": "42.3986_-71.2451", "02452": "42.3943_-71.218", "02453": "42.3654_-71.2317", "02454": "42.3567_-71.2505", "02455": "42.3621_-71.2055", "02456": "42.4464_-71.4594", "02458": "42.3528_-71.1875", "02459": "42.3341_-71.1833", "02460": "42.352_-71.2084", "02461": "42.3168_-71.2084", "02462": "42.3299_-71.2562", "02464": "42.3129_-71.2195", "02465": "42.3492_-71.2267", "02466": "42.3441_-71.248", "02467": "42.3164_-71.1612", "02468": "42.3271_-71.2315", "02471": "42.3709_-71.1828", "02472": "42.37_-71.1773", "02474": "42.4202_-71.1565", "02475": "42.4204_-71.1801", "02476": "42.4162_-71.1752", "02477": "42.3709_-71.1828", "02478": "42.3959_-71.1787", "02479": "42.3876_-71.1828", "02493": "42.3589_-71.3001", "02495": "42.3626_-71.2023", "02554": "41.2725_-70.0932", "02564": "41.2639_-69.9626", "02584": "41.2778_-70.046", "02019": "42.0746_-71.4768", "02021": "42.1645_-71.1355", "02025": "42.2395_-70.8128", "02026": "42.2437_-71.1637", "02027": "42.18_-71.0892", "02030": "42.2362_-71.2854", "02032": "42.1532_-71.2179", "02035": "42.0649_-71.2441", "02038": "42.0935_-71.4058", "02052": "42.1845_-71.3048", "02053": "42.1514_-71.4217", "02054": "42.1669_-71.3607", "02056": "42.1177_-71.3269", "02062": "42.1868_-71.2033", "02067": "42.1094_-71.1759", "02070": "42.0348_-71.387", "02071": "42.0992_-71.2752", "02072": "42.1253_-71.1074", "02081": "42.1444_-71.2544", "02090": "42.2148_-71.2104", "02093": "42.0617_-71.3396", "02169": "42.2491_-70.9978", "02170": "42.2671_-71.0186", "02171": "42.2825_-71.0241", "02184": "42.2093_-70.9963", "02185": "42.18_-71.0892", "02186": "42.2537_-71.0771", "02187": "42.2668_-71.0717", "02188": "42.2113_-70.9582", "02189": "42.214_-70.9203", "02190": "42.1751_-70.9495", "02191": "42.2459_-70.9467", "02269": "42.2529_-71.0023", "02322": "42.1258_-71.0437", "02343": "42.1464_-71.0083", "02368": "42.1736_-71.0514", "02445": "42.3259_-71.1341", "02446": "42.3431_-71.123", "02447": "42.3329_-71.1162", "02457": "42.2987_-71.2595", "02481": "42.3106_-71.2747", "02482": "42.2945_-71.2992", "02492": "42.2798_-71.2501", "02494": "42.2945_-71.2328", "02762": "42.0124_-71.3275", "02018": "42.1745_-70.8837", "02020": "42.0818_-70.6439", "02040": "42.1793_-70.7495", "02041": "42.0696_-70.6491", "02043": "42.2245_-70.8911", "02044": "42.2418_-70.8898", "02045": "42.2853_-70.8754", "02047": "42.1428_-70.6935", "02050": "42.1062_-70.6993", "02051": "42.1512_-70.7341", "02055": "42.2404_-70.762", "02059": "42.1432_-70.7703", "02060": "42.219_-70.7856", "02061": "42.1596_-70.8217", "02065": "42.0972_-70.6516", "02066": "42.2032_-70.7525", "02301": "42.0794_-71.04", "02302": "42.0847_-71.0002", "02303": "42.0834_-71.0184", "02304": "42.0834_-71.0184", "02305": "42.0834_-71.0184", "02324": "41.9773_-70.9723", "02325": "41.9873_-70.9728", "02327": "42.0407_-70.8272", "02330": "41.8883_-70.7678", "02331": "41.9705_-70.7014", "02332": "42.0399_-70.7163", "02333": "42.0315_-70.945", "02337": "42.0098_-70.962", "02338": "42.0002_-70.8448", "02339": "42.1214_-70.857", "02340": "42.1137_-70.8161", "02341": "42.0616_-70.8651", "02344": "41.8932_-70.9112", "02345": "41.8882_-70.581", "02346": "41.8884_-70.893", "02347": "41.8374_-70.9582", "02348": "41.8459_-70.9495", "02349": "41.8932_-70.9112", "02350": "42.0185_-70.8475", "02351": "42.1167_-70.9543", "02355": "41.9169_-70.8013", "02358": "42.0932_-70.7925", "02359": "42.0621_-70.8044", "02360": "41.9104_-70.642", "02361": "41.9705_-70.7014", "02362": "41.9584_-70.6673", "02364": "41.995_-70.741", "02366": "41.8501_-70.7044", "02367": "41.9655_-70.8046", "02370": "42.1293_-70.9133", "02379": "42.0255_-71.0161", "02381": "41.9316_-70.5611", "02382": "42.0816_-70.9381", "02538": "41.7682_-70.6532", "02558": "41.7476_-70.6582", "02571": "41.7541_-70.7116", "02576": "41.7796_-70.7642", "02738": "41.7095_-70.7613", "02739": "41.6618_-70.8164", "02770": "41.7591_-70.8523", "02108": "42.3576_-71.0684", "02109": "42.36_-71.0545", "02110": "42.3576_-71.0514", "02111": "42.3503_-71.0629", "02112": "42.3584_-71.0598", "02113": "42.3657_-71.056", "02114": "42.3611_-71.0682", "02115": "42.3427_-71.0922", "02116": "42.3492_-71.0768", "02117": "42.3585_-71.058", "02118": "42.3362_-71.0729", "02119": "42.3251_-71.0953", "02120": "42.3307_-71.0912", "02121": "42.2973_-71.0745", "02122": "42.2973_-71.0745", "02123": "42.3389_-70.9196", "02124": "42.2918_-71.0717", "02125": "42.2973_-71.0745", "02126": "42.2739_-71.0939", "02127": "42.3347_-71.0375", "02128": "42.3642_-71.0257", "02129": "42.3778_-71.0627", "02130": "42.3126_-71.1115", "02131": "42.2836_-71.1295", "02132": "42.2787_-71.1589", "02133": "42.3584_-71.0598", "02134": "42.3535_-71.1329", "02135": "42.3478_-71.1566", "02136": "42.254_-71.1261", "02137": "42.2404_-71.137", "02150": "42.3963_-71.0325", "02151": "42.4138_-71.0052", "02152": "42.3763_-70.98", "02163": "42.3253_-71.1122", "02196": "42.3584_-71.0598", "02199": "42.3479_-71.0825", "02201": "42.3584_-71.0598", "02203": "42.3615_-71.0604", "02204": "42.3389_-70.9196", "02205": "42.3503_-71.0539", "02206": "42.3389_-70.9196", "02210": "42.3489_-71.0465", "02211": "42.3584_-71.0598", "02215": "42.3471_-71.1027", "02217": "42.3389_-70.9196", "02222": "42.3644_-71.0633", "02241": "42.3584_-71.0598", "02266": "42.3584_-71.0598", "02283": "42.3389_-70.9196", "02284": "42.3389_-70.9196", "02293": "42.3584_-71.0598", "02297": "42.3584_-71.0598", "02298": "42.3823_-71.0323", "01005": "42.4097_-72.1084", "01031": "42.3322_-72.1986", "01037": "42.3479_-72.2253", "01068": "42.348_-72.0513", "01074": "42.3854_-72.0954", "01083": "42.204_-72.1994", "01092": "42.2029_-72.229", "01094": "42.3582_-72.1408", "01331": "42.5959_-72.2267", "01366": "42.4898_-72.1893", "01368": "42.6722_-72.1964", "01420": "42.5796_-71.8031", "01430": "42.6496_-71.9267", "01434": "42.5385_-71.6115", "01436": "42.5936_-72.0646", "01438": "42.5631_-72.037", "01440": "42.574_-71.9898", "01441": "42.5459_-71.9106", "01451": "42.4986_-71.5753", "01452": "42.4865_-72.0012", "01453": "42.5274_-71.7563", "01462": "42.5884_-71.7266", "01467": "42.4871_-71.6131", "01468": "42.546_-72.065", "01473": "42.5483_-71.9096", "01475": "42.6789_-72.0475", "01501": "42.2055_-71.8391", "01503": "42.3844_-71.6356", "01504": "42.0287_-71.5269", "01505": "42.3377_-71.731", "01506": "42.1991_-72.0989", "01507": "42.1379_-71.9664", "01508": "42.1459_-71.9884", "01509": "42.1731_-71.9787", "01510": "42.4181_-71.6828", "01515": "42.2193_-72.0481", "01516": "42.0528_-71.7509", "01518": "42.1228_-72.1178", "01519": "42.2004_-71.6868", "01520": "42.342_-71.8414", "01522": "42.3755_-71.8706", "01523": "42.451_-71.6868", "01524": "42.237_-71.9188", "01525": "42.0973_-71.6448", "01526": "42.0945_-71.7476", "01527": "42.1968_-71.7644", "01529": "42.0331_-71.5798", "01531": "42.3198_-72.1306", "01532": "42.3182_-71.6464", "01534": "42.1494_-71.6564", "01535": "42.2665_-72.0821", "01536": "42.2297_-71.7037", "01537": "42.1655_-71.886", "01538": "42.0876_-71.6412", "01540": "42.1129_-71.8687", "01541": "42.4508_-71.8762", "01542": "42.1997_-71.9069", "01543": "42.3762_-71.949", "01545": "42.2848_-71.7205", "01546": "42.3648_-71.8969", "01550": "42.075_-72.0353", "01560": "42.176_-71.6927", "01561": "42.4435_-71.6861", "01562": "42.2441_-71.9906", "01564": "42.4354_-71.7752", "01566": "42.1126_-72.0842", "01568": "42.1756_-71.6032", "01569": "42.0744_-71.6329", "01570": "42.0521_-71.8486", "01571": "42.0489_-71.8932", "01581": "42.2679_-71.6176", "01583": "42.3584_-71.7838", "01585": "42.2441_-72.1511", "01586": "42.1712_-71.8037", "01588": "42.1153_-71.6644", "01590": "42.1266_-71.7552", "01601": "42.2626_-71.8023", "01602": "42.2703_-71.8417", "01603": "42.245_-71.838", "01604": "42.2541_-71.7746", "01605": "42.2894_-71.7888", "01606": "42.311_-71.7958", "01607": "42.2303_-71.7938", "01608": "42.2624_-71.8003", "01609": "42.2826_-71.8277", "01610": "42.2492_-71.8108", "01611": "42.2373_-71.875", "01612": "42.3066_-71.9202", "01613": "42.2933_-71.802", "01614": "42.2626_-71.8023", "01615": "42.2626_-71.8023", "01653": "42.3648_-71.8969", "01655": "42.3648_-71.8969", "01740": "42.4365_-71.6076", "01745": "42.2934_-71.5028", "01747": "42.1268_-71.5376", "01756": "42.0967_-71.5499", "01757": "42.1511_-71.5274", "01772": "42.2939_-71.532", "21501": "39.6529_-78.7625", "21502": "39.5992_-78.8444", "21503": "39.6529_-78.7625", "21504": "39.5807_-78.6906", "21505": "39.594_-78.8434", "21521": "39.5331_-79.0281", "21524": "39.6967_-78.8031", "21528": "39.6528_-78.9014", "21529": "39.7083_-78.7774", "21530": "39.6993_-78.5739", "21532": "39.6494_-78.9306", "21539": "39.5757_-78.9915", "21540": "39.4774_-79.0594", "21542": "39.5901_-78.9497", "21543": "39.6343_-78.95", "21545": "39.6991_-78.8739", "21555": "39.5846_-78.6044", "21556": "39.5725_-78.844", "21557": "39.5214_-78.9062", "21560": "39.5654_-78.7164", "21562": "39.4905_-79.014", "21766": "39.6876_-78.3781", "20711": "38.8029_-76.6628", "20724": "39.0958_-76.8155", "20733": "38.8018_-76.5248", "20751": "38.7829_-76.5515", "20755": "39.1059_-76.7467", "20758": "38.7361_-76.5835", "20764": "38.8368_-76.5109", "20765": "38.8446_-76.5456", "20776": "38.8582_-76.6145", "20778": "38.8252_-76.5391", "20779": "38.7671_-76.5752", "21012": "39.0476_-76.4941", "21032": "39.0489_-76.5935", "21035": "38.9374_-76.6375", "21037": "38.9149_-76.5424", "21054": "39.0407_-76.6819", "21056": "39.0751_-76.4324", "21060": "39.1702_-76.5798", "21061": "39.1618_-76.6297", "21062": "38.9742_-76.5949", "21076": "39.1551_-76.7215", "21077": "39.1561_-76.6977", "21090": "39.2092_-76.6681", "21106": "38.8876_-76.5119", "21108": "39.1041_-76.619", "21113": "39.0762_-76.6996", "21114": "39.0112_-76.6802", "21122": "39.1206_-76.495", "21123": "38.9742_-76.5949", "21140": "38.9504_-76.5854", "21144": "39.1275_-76.698", "21146": "39.0811_-76.5577", "21225": "39.2259_-76.6153", "21226": "39.2109_-76.5597", "21240": "39.1753_-76.6732", "21401": "38.9898_-76.5501", "21402": "38.9871_-76.4715", "21403": "38.9524_-76.491", "21404": "38.9784_-76.4922", "21405": "39.0305_-76.5515", "21409": "39.0416_-76.4377", "21411": "38.9742_-76.5949", "21412": "38.9742_-76.5949", "21013": "39.5194_-76.4927", "21020": "39.5213_-76.8047", "21022": "39.3979_-76.6717", "21023": "39.533_-76.7432", "21027": "39.3634_-76.3711", "21030": "39.4919_-76.6677", "21031": "39.4805_-76.6553", "21051": "39.4731_-76.4484", "21052": "39.207_-76.4456", "21053": "39.694_-76.7223", "21057": "39.4575_-76.5153", "21065": "39.4883_-76.6538", "21071": "39.477_-76.815", "21082": "39.474_-76.4695", "21087": "39.4558_-76.4147", "21092": "39.4729_-76.523", "21093": "39.4332_-76.6546", "21094": "39.439_-76.5921", "21105": "39.7114_-76.6595", "21111": "39.5662_-76.5979", "21117": "39.4269_-76.7769", "21120": "39.6422_-76.6737", "21128": "39.401_-76.451", "21131": "39.4833_-76.5776", "21133": "39.3746_-76.8002", "21136": "39.46_-76.8135", "21139": "39.4093_-76.6486", "21152": "39.5483_-76.6819", "21153": "39.4104_-76.713", "21155": "39.5676_-76.7972", "21156": "39.4372_-76.3966", "21162": "39.3923_-76.4132", "21163": "39.3498_-76.8456", "21204": "39.4072_-76.6038", "21207": "39.3296_-76.7341", "21208": "39.3764_-76.729", "21219": "39.2296_-76.4455", "21220": "39.3401_-76.4153", "21221": "39.3086_-76.4533", "21222": "39.2655_-76.4935", "21227": "39.2309_-76.6969", "21228": "39.2782_-76.7401", "21234": "39.3876_-76.5418", "21236": "39.3914_-76.4871", "21237": "39.3361_-76.5014", "21244": "39.3331_-76.7849", "21250": "39.2582_-76.7131", "21251": "39.439_-76.5921", "21252": "39.4015_-76.6019", "21282": "39.3743_-76.7225", "21284": "39.4015_-76.6019", "21285": "39.4015_-76.6019", "21286": "39.4143_-76.5761", "20610": "38.5254_-76.6161", "20615": "38.418_-76.5478", "20629": "38.3364_-76.4524", "20639": "38.6095_-76.6003", "20657": "38.3661_-76.4346", "20676": "38.4952_-76.5349", "20678": "38.5336_-76.5955", "20685": "38.4501_-76.511", "20688": "38.3293_-76.4651", "20689": "38.649_-76.5767", "20714": "38.7119_-76.5367", "20732": "38.6698_-76.5376", "20736": "38.6955_-76.6061", "20754": "38.7408_-76.6427", "21609": "38.7406_-75.9587", "21629": "38.8595_-75.8357", "21632": "38.7147_-75.7754", "21636": "39.023_-75.7926", "21639": "38.9616_-75.8059", "21640": "39.0672_-75.7948", "21641": "38.9206_-75.9388", "21649": "39.1082_-75.7622", "21655": "38.7465_-75.9163", "21660": "38.9568_-75.8848", "21670": "39.1362_-75.766", "21048": "39.4991_-76.9101", "21074": "39.6146_-76.8644", "21088": "39.7187_-76.8439", "21102": "39.6747_-76.8941", "21104": "39.3342_-76.9132", "21157": "39.5642_-76.9807", "21158": "39.607_-77.0294", "21757": "39.5656_-77.2817", "21776": "39.5162_-77.1034", "21784": "39.4567_-76.9696", "21787": "39.6658_-77.1691", "21791": "39.5799_-77.1319", "21797": "39.3464_-77.0647", "21901": "39.6045_-75.9538", "21902": "39.553_-76.0725", "21903": "39.5649_-76.0592", "21904": "39.6151_-76.0633", "21911": "39.6882_-76.0492", "21912": "39.4283_-75.7996", "21913": "39.4015_-75.8654", "21914": "39.5729_-75.9795", "21915": "39.5133_-75.8406", "21916": "39.6462_-75.8716", "21917": "39.6695_-76.0934", "21918": "39.6778_-76.1572", "21919": "39.4271_-75.9403", "21920": "39.658_-75.8282", "21921": "39.6264_-75.8458", "21922": "39.6068_-75.8333", "21930": "39.3662_-75.8845", "20601": "38.6371_-76.8778", "20602": "38.584_-76.8942", "20603": "38.6294_-76.9769", "20604": "38.5095_-76.9817", "20611": "38.4731_-76.9789", "20612": "38.5093_-76.6797", "20616": "38.6415_-77.0766", "20617": "38.5426_-76.8465", "20625": "38.262_-76.8502", "20632": "38.4382_-76.9729", "20637": "38.5207_-76.7817", "20640": "38.6001_-77.1622", "20643": "38.5039_-77.1483", "20645": "38.2926_-76.9059", "20646": "38.5257_-76.9865", "20658": "38.5633_-77.1596", "20661": "38.3436_-76.8846", "20662": "38.4462_-77.1983", "20664": "38.3298_-76.9175", "20675": "38.5855_-77.0093", "20677": "38.4994_-77.0419", "20682": "38.2836_-76.8481", "20693": "38.4672_-77.095", "20695": "38.5974_-76.9903", "21613": "38.5643_-76.0874", "21622": "38.4278_-76.1696", "21626": "38.3295_-76.1142", "21627": "38.2426_-76.0531", "21631": "38.5921_-75.9568", "21634": "38.3223_-76.2244", "21643": "38.6438_-75.863", "21648": "38.4782_-76.2412", "21659": "38.603_-75.7749", "21664": "38.6093_-75.9474", "21669": "38.4631_-76.2964", "21672": "38.2726_-76.0596", "21675": "38.2899_-76.0863", "21677": "38.5026_-76.1833", "21835": "38.5403_-75.963", "21869": "38.4774_-75.8729", "21701": "39.4461_-77.335", "21702": "39.4926_-77.4612", "21703": "39.3647_-77.4636", "21704": "39.3455_-77.3832", "21705": "39.4143_-77.4105", "21709": "39.47_-77.3921", "21710": "39.291_-77.4552", "21714": "39.4203_-77.5051", "21716": "39.3164_-77.623", "21717": "39.3309_-77.4274", "21718": "39.3923_-77.6275", "21727": "39.694_-77.3357", "21754": "39.3267_-77.2964", "21755": "39.3653_-77.5441", "21758": "39.3479_-77.6513", "21759": "39.5694_-77.2905", "21762": "39.4822_-77.2468", "21769": "39.4416_-77.5502", "21770": "39.3512_-77.2494", "21771": "39.3881_-77.1723", "21773": "39.5282_-77.5513", "21774": "39.4096_-77.2759", "21775": "39.5645_-77.2947", "21777": "39.2791_-77.5328", "21778": "39.6057_-77.3296", "21780": "39.6828_-77.4693", "21788": "39.6109_-77.3989", "21790": "39.2667_-77.5101", "21792": "39.4748_-77.1855", "21793": "39.4787_-77.3484", "21798": "39.5311_-77.2972", "21520": "39.6355_-79.3085", "21522": "39.6023_-79.2234", "21523": "39.4861_-79.083", "21531": "39.6665_-79.4219", "21536": "39.6551_-79.1241", "21538": "39.4169_-79.2222", "21541": "39.5656_-79.3823", "21550": "39.4339_-79.3167", "21561": "39.4764_-79.2402", "21001": "39.5109_-76.1805", "21005": "39.4771_-76.1208", "21009": "39.4744_-76.2997", "21010": "39.3982_-76.2743", "21014": "39.5394_-76.3564", "21015": "39.5303_-76.3153", "21017": "39.4756_-76.242", "21018": "39.5093_-76.3851", "21028": "39.5648_-76.249", "21034": "39.654_-76.2278", "21040": "39.4277_-76.3055", "21047": "39.527_-76.4328", "21050": "39.5755_-76.4008", "21078": "39.5523_-76.1171", "21084": "39.6162_-76.4684", "21085": "39.4242_-76.3541", "21130": "39.4716_-76.2117", "21132": "39.6959_-76.4113", "21154": "39.6574_-76.3713", "21160": "39.7077_-76.316", "21161": "39.6618_-76.5666", "20588": "38.7504_-76.8544", "20701": "39.1332_-76.7988", "20723": "39.1208_-76.8435", "20759": "39.1502_-76.93", "20763": "39.138_-76.8218", "20777": "39.1843_-76.9686", "20794": "39.1484_-76.7922", "21029": "39.2125_-76.9515", "21036": "39.2339_-76.9968", "21041": "39.2364_-76.9419", "21042": "39.2726_-76.8614", "21043": "39.2548_-76.8001", "21044": "39.2141_-76.8788", "21045": "39.2051_-76.8322", "21046": "39.1702_-76.8538", "21075": "39.2058_-76.7531", "21150": "39.2364_-76.9419", "21723": "39.3211_-77.0051", "21737": "39.2546_-77.0198", "21738": "39.2795_-77.0148", "21765": "39.3378_-77.072", "21794": "39.2934_-76.966", "21610": "39.3655_-76.0639", "21620": "39.2125_-76.0802", "21635": "39.3374_-75.8717", "21645": "39.2978_-75.9818", "21650": "39.3126_-75.8215", "21651": "39.2743_-75.8951", "21661": "39.1344_-76.2305", "21667": "39.3293_-76.0455", "21678": "39.2963_-76.1008", "20810": "38.9806_-77.1008", "20811": "38.9806_-77.1008", "20812": "38.9693_-77.1435", "20813": "39.144_-77.2076", "20814": "39.0003_-77.1022", "20815": "38.978_-77.082", "20816": "38.9585_-77.1153", "20817": "38.9896_-77.1538", "20818": "38.9743_-77.1591", "20824": "38.9807_-77.1003", "20825": "39.0029_-77.0712", "20827": "39.144_-77.2076", "20830": "39.1552_-77.0667", "20832": "39.1526_-77.0749", "20833": "39.1871_-77.0603", "20837": "39.1386_-77.4067", "20838": "39.2233_-77.3764", "20839": "39.179_-77.4128", "20841": "39.21_-77.3167", "20842": "39.2126_-77.4199", "20847": "39.084_-77.1528", "20848": "39.144_-77.2076", "20849": "39.084_-77.1528", "20850": "39.087_-77.168", "20851": "39.0763_-77.1234", "20852": "39.0496_-77.1204", "20853": "39.0887_-77.095", "20854": "39.0388_-77.1922", "20855": "39.1345_-77.1477", "20857": "39.084_-77.1528", "20859": "39.144_-77.2076", "20860": "39.1503_-77.0291", "20861": "39.151_-76.9924", "20862": "39.1838_-77.0163", "20866": "39.0922_-76.9339", "20868": "39.1223_-76.9722", "20871": "39.2387_-77.2794", "20872": "39.2761_-77.2131", "20874": "39.1355_-77.2822", "20875": "39.144_-77.2076", "20876": "39.188_-77.2358", "20877": "39.1419_-77.189", "20878": "39.1125_-77.2515", "20879": "39.173_-77.1855", "20880": "39.1388_-77.1726", "20882": "39.2335_-77.1458", "20883": "39.0883_-77.1568", "20884": "39.144_-77.2076", "20885": "39.1874_-77.2028", "20886": "39.1757_-77.1873", "20889": "39.144_-77.2076", "20891": "39.0257_-77.0764", "20892": "39.0024_-77.1034", "20894": "39.144_-77.2076", "20895": "39.0298_-77.0793", "20896": "39.0365_-77.0931", "20897": "39.144_-77.2076", "20898": "39.144_-77.2076", "20899": "39.1403_-77.222", "20901": "39.0191_-77.0076", "20902": "39.04_-77.0444", "20903": "39.0095_-76.9846", "20904": "39.0668_-76.9969", "20905": "39.1148_-77.0059", "20906": "39.084_-77.0613", "20907": "38.9907_-77.0261", "20908": "38.9907_-77.0261", "20910": "38.9982_-77.0338", "20911": "38.9907_-77.0261", "20912": "38.9832_-77.0007", "20914": "38.9907_-77.0261", "20915": "38.9907_-77.0261", "20916": "38.9907_-77.0261", "20918": "38.9907_-77.0261", "20993": "39.0336_-76.9861", "20997": "38.9907_-77.0261", "20607": "38.672_-77.0162", "20608": "38.5825_-76.7149", "20613": "38.6922_-76.832", "20623": "38.7531_-76.8369", "20697": "38.8336_-76.8777", "20703": "38.8336_-76.8777", "20704": "39.0348_-76.9075", "20705": "39.0455_-76.9242", "20706": "38.9675_-76.8551", "20707": "39.1077_-76.872", "20708": "39.0499_-76.8345", "20709": "39.0993_-76.8483", "20710": "38.9421_-76.9261", "20712": "38.9431_-76.9652", "20715": "38.9797_-76.7435", "20716": "38.9263_-76.7098", "20717": "38.8336_-76.8777", "20718": "38.8336_-76.8777", "20719": "38.8336_-76.8777", "20720": "38.9885_-76.791", "20721": "38.9194_-76.7871", "20722": "38.9407_-76.9531", "20725": "39.0993_-76.8483", "20726": "39.0993_-76.8483", "20731": "38.8851_-76.9158", "20735": "38.7549_-76.9026", "20737": "38.9601_-76.9147", "20738": "38.8336_-76.8777", "20740": "38.9963_-76.9299", "20741": "38.8336_-76.8777", "20742": "38.9896_-76.9457", "20743": "38.8897_-76.8925", "20744": "38.7587_-76.9835", "20745": "38.8108_-76.9898", "20746": "38.8425_-76.9222", "20747": "38.8539_-76.8891", "20748": "38.8222_-76.9478", "20749": "38.8336_-76.8777", "20750": "38.8034_-76.9897", "20752": "38.8487_-76.9239", "20753": "38.8336_-76.8777", "20757": "38.814_-76.9455", "20762": "38.8062_-76.8756", "20768": "39.0046_-76.8755", "20769": "38.9766_-76.8053", "20770": "38.9996_-76.884", "20771": "39.0046_-76.8755", "20772": "38.8377_-76.798", "20773": "38.8159_-76.7497", "20774": "38.8682_-76.8156", "20775": "38.8336_-76.8777", "20781": "38.9506_-76.9347", "20782": "38.9647_-76.9649", "20783": "39.0005_-76.9723", "20784": "38.9513_-76.8958", "20785": "38.9223_-76.8755", "20787": "38.9871_-76.9824", "20788": "38.9694_-76.9509", "20790": "38.8336_-76.8777", "20791": "38.8336_-76.8777", "20792": "38.8158_-76.75", "20797": "38.8336_-76.8777", "20799": "38.8336_-76.8777", "20913": "38.9779_-77.0075", "21607": "39.1299_-75.8601", "21617": "39.0564_-76.045", "21619": "38.9583_-76.2842", "21623": "39.146_-75.988", "21628": "39.233_-75.9195", "21638": "38.9456_-76.1997", "21644": "39.1182_-75.8769", "21656": "39.0346_-76.0921", "21657": "38.9456_-75.9777", "21658": "39.0025_-76.1424", "21666": "38.9394_-76.3371", "21668": "39.1823_-75.85", "21690": "39.0346_-76.0921", "20606": "38.2471_-76.7481", "20609": "38.2826_-76.7466", "20618": "38.2844_-76.7929", "20619": "38.3006_-76.5312", "20620": "38.2275_-76.521", "20621": "38.351_-76.7833", "20622": "38.475_-76.8038", "20624": "38.3407_-76.7264", "20626": "38.237_-76.7646", "20627": "38.2768_-76.704", "20628": "38.1533_-76.3575", "20630": "38.1719_-76.4731", "20634": "38.2674_-76.4954", "20635": "38.3121_-76.6077", "20636": "38.3524_-76.5626", "20650": "38.2774_-76.638", "20653": "38.2495_-76.4529", "20656": "38.3593_-76.6833", "20659": "38.4293_-76.7254", "20660": "38.3754_-76.6955", "20667": "38.2177_-76.4429", "20670": "38.2791_-76.4381", "20674": "38.1397_-76.5047", "20680": "38.1169_-76.3711", "20684": "38.1441_-76.4083", "20686": "38.1871_-76.4344", "20687": "38.0828_-76.3477", "20690": "38.1653_-76.5399", "20692": "38.1899_-76.5087", "21817": "37.9845_-75.8429", "21821": "38.1533_-75.9496", "21824": "37.9938_-76.0351", "21836": "38.1154_-75.7558", "21838": "38.0266_-75.7579", "21853": "38.1919_-75.7072", "21857": "38.039_-75.663", "21866": "37.9666_-76.0235", "21867": "38.104_-75.7913", "21871": "38.101_-75.7406", "21890": "38.0927_-75.8882", "21601": "38.7768_-76.0758", "21612": "38.7515_-76.2764", "21624": "38.8368_-76.2714", "21625": "38.8704_-76.0029", "21647": "38.8192_-76.2806", "21652": "38.7246_-76.2824", "21653": "38.7518_-76.178", "21654": "38.6864_-76.1538", "21662": "38.714_-76.2097", "21663": "38.783_-76.2215", "21665": "38.7374_-76.3278", "21671": "38.7063_-76.3377", "21673": "38.6647_-76.0507", "21676": "38.7846_-76.3001", "21679": "38.9281_-76.0814", "21711": "39.6457_-78.0104", "21713": "39.552_-77.6957", "21715": "39.3869_-77.658", "21719": "39.6958_-77.4955", "21720": "39.6473_-77.5842", "21721": "39.6425_-77.6372", "21722": "39.6658_-77.9064", "21733": "39.5594_-77.7604", "21734": "39.609_-77.7044", "21740": "39.632_-77.7372", "21741": "39.6418_-77.72", "21742": "39.6573_-77.6921", "21746": "39.5638_-77.7206", "21747": "39.6418_-77.72", "21749": "39.6418_-77.72", "21750": "39.6991_-78.1762", "21756": "39.4563_-77.6944", "21767": "39.6996_-77.7499", "21779": "39.4431_-77.658", "21781": "39.5699_-77.7607", "21782": "39.4424_-77.7511", "21783": "39.647_-77.5706", "21795": "39.593_-77.8087", "21801": "38.3824_-75.6336", "21802": "38.3884_-75.6276", "21803": "38.3884_-75.6276", "21804": "38.3508_-75.5338", "21810": "38.2873_-75.688", "21814": "38.2953_-75.8914", "21826": "38.3225_-75.6228", "21830": "38.4026_-75.6963", "21837": "38.4864_-75.7414", "21840": "38.2672_-75.9021", "21849": "38.3914_-75.4737", "21850": "38.3755_-75.4076", "21852": "38.3287_-75.3755", "21856": "38.3339_-75.7851", "21861": "38.5389_-75.7192", "21865": "38.2833_-75.8465", "21874": "38.3939_-75.3552", "21875": "38.4445_-75.5583", "21811": "38.3475_-75.1866", "21813": "38.4296_-75.1855", "21822": "38.2807_-75.651", "21829": "38.0958_-75.3902", "21841": "38.2489_-75.2893", "21842": "38.3365_-75.0849", "21843": "38.3365_-75.0849", "21851": "38.0714_-75.555", "21862": "38.4003_-75.2166", "21863": "38.1868_-75.405", "21864": "38.0452_-75.4108", "21872": "38.4121_-75.2811", "21201": "39.2946_-76.6252", "21202": "39.2998_-76.6075", "21203": "39.2847_-76.6205", "21205": "39.3009_-76.5799", "21206": "39.3365_-76.5411", "21209": "39.3716_-76.6744", "21210": "39.3507_-76.6321", "21211": "39.3316_-76.6336", "21212": "39.3626_-76.61", "21213": "39.3127_-76.581", "21214": "39.3521_-76.5644", "21215": "39.3446_-76.6794", "21216": "39.3093_-76.6699", "21217": "39.3064_-76.6393", "21218": "39.3265_-76.6048", "21223": "39.287_-76.6476", "21224": "39.2876_-76.5568", "21229": "39.2856_-76.6899", "21230": "39.2645_-76.6224", "21231": "39.2892_-76.59", "21233": "39.2847_-76.6205", "21235": "39.2847_-76.6205", "21239": "39.361_-76.5891", "21241": "39.2847_-76.6205", "21263": "39.2847_-76.6205", "21264": "39.2847_-76.6205", "21270": "39.2847_-76.6205", "21273": "39.2847_-76.6205", "21275": "39.2847_-76.6205", "21278": "39.2847_-76.6205", "21279": "39.2847_-76.6205", "21280": "39.2847_-76.6205", "21281": "39.2847_-76.6205", "21287": "39.2975_-76.5927", "21288": "39.2847_-76.6205", "21289": "39.2847_-76.6205", "21290": "39.2933_-76.6238", "21297": "39.2847_-76.6205", "21298": "39.2847_-76.6205", "04210": "44.0948_-70.239", "04211": "44.197_-70.2395", "04212": "44.197_-70.2395", "04222": "43.9684_-70.1846", "04223": "44.0239_-70.2857", "04228": "44.3994_-70.1303", "04230": "44.0627_-70.327", "04236": "44.1891_-70.1455", "04240": "44.0985_-70.1916", "04241": "44.197_-70.2395", "04243": "44.197_-70.2395", "04250": "44.0255_-70.1139", "04252": "43.9978_-70.0734", "04253": "44.4079_-70.215", "04254": "44.4325_-70.1427", "04256": "44.1117_-70.3917", "04258": "44.1461_-70.3399", "04263": "44.2834_-70.1253", "04266": "44.358_-70.2558", "04274": "44.0474_-70.3899", "04280": "44.1133_-70.0748", "04282": "44.2557_-70.2494", "04288": "44.1712_-70.3659", "04291": "44.0409_-70.453", "04471": "45.8911_-67.8471", "04497": "45.6645_-68.1055", "04730": "46.1189_-67.863", "04732": "46.6184_-68.3876", "04733": "45.8125_-68.4089", "04734": "46.5048_-67.8686", "04735": "46.4222_-67.8415", "04736": "46.8706_-68.0204", "04737": "46.6109_-69.5223", "04738": "46.755_-68.0964", "04739": "47.01_-68.691", "04740": "46.6357_-67.9018", "04741": "47.4589_-69.2243", "04742": "46.7623_-67.8402", "04743": "47.2587_-68.5895", "04744": "47.2389_-68.5839", "04745": "47.2826_-68.3917", "04746": "47.3044_-68.1542", "04747": "46.0169_-68.2667", "04750": "46.9248_-67.8451", "04751": "46.8929_-67.9643", "04756": "47.3294_-68.3328", "04757": "46.6746_-68.1536", "04758": "46.5223_-67.863", "04760": "46.3007_-67.8414", "04761": "46.1004_-68.0034", "04762": "46.9559_-68.1154", "04763": "46.1088_-68.1298", "04764": "46.402_-68.5218", "04766": "46.8816_-68.2391", "04768": "46.7753_-68.4877", "04769": "46.6842_-68.0118", "04772": "47.2387_-68.3232", "04773": "47.3343_-68.2314", "04774": "47.1407_-68.9503", "04775": "46.6573_-68.405", "04776": "45.8731_-68.3847", "04779": "47.1222_-68.323", "04780": "46.1464_-68.2064", "04781": "47.1295_-68.5973", "04783": "47.0423_-68.1395", "04785": "47.1589_-67.9459", "04786": "46.7883_-68.1338", "04787": "46.5945_-67.9302", "04003": "43.7341_-69.9952", "04009": "44.052_-70.7241", "04011": "43.8973_-69.9779", "04013": "43.799_-70.0698", "04015": "43.9596_-70.526", "04017": "43.7354_-70.1169", "04019": "43.6955_-70.1071", "04021": "43.7974_-70.2649", "04024": "43.8646_-70.6922", "04029": "43.9017_-70.6878", "04032": "43.857_-70.1031", "04033": "43.857_-70.1031", "04034": "43.857_-70.1031", "04038": "43.6843_-70.468", "04039": "43.8942_-70.3429", "04040": "44.1071_-70.6539", "04050": "43.692_-70.1551", "04055": "43.9681_-70.5988", "04057": "44.0987_-70.6987", "04062": "43.7958_-70.4143", "04066": "43.7727_-69.9668", "04069": "43.89_-70.1955", "04070": "43.577_-70.2736", "04071": "43.9219_-70.4498", "04074": "43.5835_-70.3457", "04077": "43.91_-70.5245", "04078": "43.8208_-70.1208", "04079": "43.7811_-69.9955", "04082": "43.7362_-70.4237", "04084": "43.8142_-70.4807", "04085": "43.7719_-70.6396", "04091": "43.8299_-70.749", "04092": "43.6843_-70.358", "04096": "43.8009_-70.175", "04097": "43.838_-70.2001", "04098": "43.677_-70.3712", "04101": "43.6606_-70.2589", "04102": "43.6602_-70.2898", "04103": "43.6876_-70.2876", "04104": "43.6615_-70.2553", "04105": "43.734_-70.2625", "04106": "43.6318_-70.2709", "04107": "43.6017_-70.2301", "04108": "43.6589_-70.194", "04109": "43.6783_-70.1987", "04110": "43.759_-70.1993", "04112": "43.6615_-70.2553", "04116": "43.6415_-70.2409", "04122": "43.6615_-70.2553", "04123": "43.6615_-70.2553", "04124": "43.6615_-70.2553", "04260": "43.9608_-70.2974", "04225": "44.6027_-70.2265", "04227": "44.5734_-70.3037", "04234": "44.6159_-70.1928", "04239": "44.516_-70.2099", "04262": "44.5473_-70.2381", "04285": "44.7016_-70.4249", "04294": "44.5928_-70.2281", "04936": "45.3356_-70.6283", "04938": "44.6653_-70.1329", "04940": "44.6226_-70.0752", "04947": "44.9854_-70.1832", "04955": "44.6458_-70.0139", "04956": "44.7967_-70.122", "04964": "44.9664_-70.7737", "04966": "44.8375_-70.3601", "04970": "44.9631_-70.6658", "04982": "45.1116_-70.423", "04983": "44.8224_-70.2221", "04984": "44.6954_-70.2426", "04992": "44.6628_-70.153", "04408": "44.8861_-68.2959", "04416": "44.6015_-68.7768", "04420": "44.413_-68.798", "04421": "44.4156_-68.7929", "04431": "44.5612_-68.6647", "04472": "44.5458_-68.7313", "04476": "44.4645_-68.7111", "04605": "44.5548_-68.4121", "04607": "44.4731_-68.0899", "04609": "44.3738_-68.2448", "04612": "44.2415_-68.358", "04613": "44.3842_-68.0317", "04614": "44.4343_-68.5885", "04616": "44.2541_-68.5565", "04617": "44.3756_-68.7313", "04624": "44.4053_-67.985", "04625": "44.2484_-68.2603", "04627": "44.234_-68.6448", "04629": "44.4176_-68.5225", "04634": "44.6087_-68.2417", "04635": "44.1181_-68.3625", "04640": "44.5046_-68.2402", "04642": "44.334_-68.8042", "04644": "44.4192_-68.2506", "04646": "44.262_-68.2339", "04650": "44.2847_-68.7058", "04653": "44.2401_-68.3439", "04660": "44.3347_-68.3087", "04662": "44.2941_-68.2849", "04664": "44.5458_-68.1279", "04669": "44.411_-68.0141", "04672": "44.4306_-68.2836", "04673": "44.3136_-68.6863", "04674": "44.2859_-68.3986", "04675": "44.299_-68.2463", "04676": "44.3355_-68.6377", "04677": "44.4907_-68.1787", "04679": "44.2823_-68.3265", "04681": "44.1752_-68.6746", "04683": "44.2059_-68.7047", "04684": "44.4883_-68.5063", "04685": "44.1451_-68.4517", "04693": "44.39_-68.0843", "04259": "44.2208_-70.0263", "04265": "44.2753_-70.0367", "04284": "44.3493_-70.0712", "04330": "44.3232_-69.7665", "04332": "44.4141_-69.7519", "04333": "44.3106_-69.7795", "04336": "44.3157_-69.818", "04338": "44.3106_-69.7795", "04343": "44.3217_-69.8964", "04344": "44.2523_-69.7913", "04345": "44.207_-69.7858", "04346": "44.2347_-69.7506", "04347": "44.2864_-69.8057", "04349": "44.4383_-70.0748", "04350": "44.1634_-69.9581", "04351": "44.358_-69.867", "04352": "44.4993_-69.9903", "04355": "44.4032_-69.9506", "04358": "44.3953_-69.5804", "04359": "44.1801_-69.7567", "04360": "44.5475_-70.003", "04363": "44.3009_-69.5806", "04364": "44.3229_-69.9576", "04901": "44.5543_-69.6178", "04903": "44.5492_-69.7132", "04910": "44.5355_-69.4683", "04917": "44.4688_-69.8606", "04918": "44.5265_-69.887", "04926": "44.8526_-69.502", "04927": "44.644_-69.5284", "04935": "44.4478_-69.6059", "04962": "44.4862_-69.6225", "04963": "44.5173_-69.7401", "04989": "44.4405_-69.6519", "04547": "43.9807_-69.3349", "04563": "43.9867_-69.2721", "04574": "44.2693_-69.3842", "04645": "44.0561_-68.6206", "04841": "44.1123_-69.1139", "04843": "44.2137_-69.0767", "04847": "44.2589_-69.1467", "04851": "43.8651_-68.887", "04853": "44.1436_-68.8667", "04854": "44.0732_-69.0894", "04855": "43.9273_-69.2528", "04856": "44.1888_-69.0901", "04858": "44.0378_-69.1359", "04859": "44.0104_-69.1707", "04860": "43.9555_-69.2315", "04861": "44.0846_-69.1888", "04862": "44.2619_-69.2771", "04863": "44.0397_-68.8368", "04864": "44.1271_-69.2479", "04865": "44.1924_-69.1211", "04341": "44.2588_-69.551", "04342": "44.0785_-69.7457", "04348": "44.2204_-69.5133", "04353": "44.1884_-69.5751", "04535": "44.0878_-69.6344", "04537": "43.8945_-69.6273", "04538": "43.8518_-69.6278", "04539": "43.9519_-69.4954", "04541": "43.8843_-69.4792", "04543": "44.0293_-69.5042", "04544": "43.8262_-69.5939", "04549": "44.0213_-69.5233", "04551": "44.0104_-69.4402", "04553": "44.0499_-69.5331", "04554": "43.8605_-69.5079", "04555": "44.0943_-69.4828", "04556": "43.9792_-69.6197", "04558": "43.8924_-69.5289", "04564": "43.925_-69.4662", "04568": "43.8677_-69.5614", "04570": "44.0213_-69.5233", "04571": "43.8826_-69.6801", "04572": "44.1046_-69.3745", "04573": "43.9462_-69.5516", "04575": "43.849_-69.6434", "04576": "43.8199_-69.6626", "04578": "44.0074_-69.6826", "04852": "43.7642_-69.3164", "04010": "43.9381_-70.9087", "04016": "44.181_-70.8917", "04022": "43.9755_-70.7924", "04037": "44.0313_-70.9668", "04041": "43.8622_-70.8531", "04051": "44.1614_-70.93", "04068": "43.8262_-70.9243", "04088": "44.1931_-70.7163", "04216": "44.6637_-70.7967", "04217": "44.4162_-70.8037", "04219": "44.3957_-70.6435", "04220": "44.2877_-70.3683", "04221": "44.4602_-70.2998", "04224": "44.5548_-70.4241", "04226": "44.6084_-70.6993", "04231": "44.2641_-70.8875", "04237": "44.4959_-70.7167", "04238": "44.2021_-70.3754", "04255": "44.3184_-70.6509", "04257": "44.5628_-70.5358", "04261": "44.6895_-71.0112", "04267": "44.2317_-70.7687", "04268": "44.2127_-70.5601", "04270": "44.1118_-70.5098", "04271": "44.2641_-70.4985", "04275": "44.6566_-70.6092", "04276": "44.5434_-70.5645", "04281": "44.2167_-70.5012", "04286": "44.4021_-70.8601", "04289": "44.3253_-70.5732", "04290": "44.4944_-70.4435", "04292": "44.374_-70.4469", "04401": "44.8242_-68.7918", "04402": "44.8012_-68.7778", "04410": "45.0855_-68.9235", "04411": "44.9015_-68.6263", "04412": "44.7874_-68.7539", "04417": "45.2349_-68.379", "04418": "45.0803_-68.6509", "04419": "44.8053_-68.9942", "04422": "45.067_-69.0869", "04427": "44.9805_-69.0109", "04428": "44.7917_-68.5777", "04429": "44.7208_-68.6165", "04430": "45.63_-68.5728", "04434": "44.7932_-69.1322", "04435": "44.9679_-69.1079", "04444": "44.7411_-68.8731", "04448": "45.2456_-68.6666", "04449": "44.9914_-68.8878", "04450": "44.9183_-68.9342", "04451": "45.5984_-68.2366", "04453": "45.1789_-68.8345", "04455": "45.3635_-68.2909", "04456": "44.8843_-68.9837", "04457": "45.3508_-68.5077", "04459": "45.5264_-68.352", "04460": "45.607_-68.5227", "04461": "44.9393_-68.6296", "04462": "45.6596_-68.7101", "04468": "44.943_-68.675", "04469": "45.0028_-68.6334", "04473": "44.8865_-68.7172", "04474": "44.7263_-68.7876", "04475": "45.1815_-68.5871", "04487": "45.4264_-68.1108", "04488": "44.8843_-69.1069", "04489": "44.9084_-68.6864", "04493": "45.2378_-68.5338", "04495": "45.4568_-68.3575", "04765": "46.0132_-68.4647", "04777": "45.8637_-68.5053", "04928": "44.926_-69.2323", "04930": "45.0203_-69.2797", "04932": "44.6991_-69.1025", "04933": "44.8209_-69.2225", "04939": "45.0149_-69.157", "04953": "44.8393_-69.2675", "04969": "44.7699_-69.2266", "04406": "45.2345_-69.5699", "04414": "45.3412_-69.0423", "04415": "45.3512_-69.0581", "04426": "45.1877_-69.2045", "04441": "45.4716_-69.5844", "04442": "45.4796_-69.6939", "04443": "45.1735_-69.3975", "04463": "45.2446_-68.976", "04464": "45.2981_-69.488", "04479": "45.1406_-69.3218", "04481": "45.2465_-69.1021", "04485": "45.3609_-69.6202", "04008": "44.0101_-69.8984", "04086": "43.9814_-69.9378", "04287": "44.0575_-69.9656", "04357": "44.1042_-69.8211", "04530": "43.9062_-69.8266", "04548": "43.8054_-69.7453", "04562": "43.7688_-69.815", "04565": "43.7733_-69.8635", "04579": "43.9503_-69.7891", "04478": "45.8641_-69.8768", "04911": "44.7831_-69.9309", "04912": "44.9388_-69.6695", "04920": "45.0682_-69.8857", "04923": "45.0513_-69.4419", "04924": "44.745_-69.5498", "04925": "45.241_-69.9386", "04929": "44.7615_-69.3227", "04937": "44.6463_-69.6802", "04942": "44.973_-69.5481", "04943": "44.8782_-69.4718", "04944": "44.6847_-69.6425", "04945": "45.6351_-70.2492", "04950": "44.8096_-69.8449", "04954": "44.8842_-70.0967", "04957": "44.6899_-69.8306", "04958": "44.8797_-69.9119", "04961": "44.9251_-70.0231", "04965": "44.8576_-69.3811", "04967": "44.7871_-69.4022", "04971": "44.9293_-69.3992", "04975": "44.6245_-69.5869", "04976": "44.7772_-69.6976", "04978": "44.6301_-69.8075", "04979": "44.9676_-69.833", "04985": "45.3839_-69.9841", "04354": "44.3843_-69.4334", "04438": "44.5979_-68.934", "04496": "44.6552_-68.8862", "04848": "44.3082_-68.9073", "04849": "44.3048_-69.0824", "04850": "44.2979_-69.1075", "04915": "44.4354_-69.0148", "04921": "44.5678_-69.1404", "04922": "44.6848_-69.38", "04941": "44.4633_-69.319", "04949": "44.3741_-69.3306", "04951": "44.5927_-69.0317", "04952": "44.4107_-69.1471", "04972": "44.5148_-68.8128", "04973": "44.377_-69.2196", "04974": "44.4877_-68.9311", "04981": "44.5141_-68.856", "04986": "44.5744_-69.2487", "04987": "44.6757_-69.2549", "04988": "44.6007_-69.3328", "04413": "45.5507_-67.7436", "04424": "45.6687_-67.8688", "04454": "45.5459_-67.5269", "04490": "45.4304_-67.7473", "04491": "45.5634_-67.4297", "04492": "45.3492_-67.678", "04606": "44.583_-67.7146", "04611": "44.513_-67.6056", "04619": "45.1715_-67.2641", "04622": "44.6228_-67.9436", "04623": "44.6699_-67.7534", "04626": "44.6753_-67.2499", "04628": "44.8961_-67.2244", "04630": "44.7424_-67.3821", "04631": "44.92_-67.0074", "04637": "45.1795_-67.7744", "04643": "44.6122_-67.8147", "04648": "44.6582_-67.5777", "04649": "44.5509_-67.6044", "04652": "44.9043_-67.0408", "04654": "44.7215_-67.482", "04655": "44.682_-67.4073", "04657": "45.0193_-67.3829", "04658": "44.5366_-67.8844", "04666": "44.9654_-67.2002", "04667": "44.9888_-67.0929", "04668": "45.2131_-67.6008", "04671": "45.067_-67.1433", "04680": "44.4971_-67.9503", "04686": "44.9854_-67.6991", "04691": "44.7622_-67.2515", "04694": "45.1035_-67.4722", "03901": "43.2899_-70.855", "03902": "43.2133_-70.6397", "03903": "43.1309_-70.7822", "03904": "43.0921_-70.7429", "03905": "43.0976_-70.7121", "03906": "43.3254_-70.7212", "03907": "43.2541_-70.6094", "03908": "43.2292_-70.7859", "03909": "43.1544_-70.6578", "03910": "43.1715_-70.6089", "03911": "43.1368_-70.6456", "04001": "43.5494_-70.9307", "04002": "43.4875_-70.6961", "04004": "43.6131_-70.5498", "04005": "43.4935_-70.4883", "04006": "43.4448_-70.3414", "04007": "43.4581_-70.5053", "04014": "43.3657_-70.6044", "04020": "43.7796_-70.7784", "04027": "43.4597_-70.9152", "04028": "43.7334_-70.8434", "04030": "43.5995_-70.6906", "04042": "43.5946_-70.6051", "04043": "43.3881_-70.5478", "04046": "43.3923_-70.4729", "04047": "43.745_-70.9092", "04048": "43.6963_-70.7866", "04049": "43.726_-70.6752", "04054": "43.2763_-70.5978", "04056": "43.6584_-70.8689", "04061": "43.64_-70.7298", "04063": "43.5006_-70.3862", "04064": "43.5254_-70.3883", "04072": "43.5209_-70.4546", "04073": "43.4285_-70.7585", "04076": "43.5674_-70.8286", "04083": "43.4715_-70.8064", "04087": "43.5661_-70.7431", "04090": "43.3144_-70.5969", "04093": "43.6379_-70.5189", "04094": "43.4061_-70.5733", "04095": "43.601_-70.9027", "96960": "7.1128_171.237", "96970": "8.786_167.7365", "48705": "44.702_-83.5994", "48721": "44.8138_-83.3407", "48728": "44.7336_-83.832", "48737": "44.5582_-83.6899", "48738": "44.548_-83.3269", "48740": "44.6546_-83.3424", "48742": "44.7111_-83.3947", "48745": "44.5833_-83.4355", "48762": "44.8224_-83.5044", "49806": "46.4446_-86.9115", "49816": "46.3477_-86.929", "49822": "46.427_-87.0497", "49825": "46.3549_-86.9701", "49826": "46.3483_-87.0332", "49839": "46.6529_-85.9836", "49862": "46.3994_-86.6983", "49884": "46.3512_-86.4823", "49891": "46.1947_-86.9502", "49895": "46.3535_-86.6345", "49010": "42.5256_-85.8661", "49070": "42.537_-85.6417", "49078": "42.4723_-85.7035", "49080": "42.4544_-85.5994", "49311": "42.633_-85.643", "49314": "42.7312_-85.8404", "49323": "42.7231_-85.7628", "49328": "42.6421_-85.7322", "49335": "42.737_-85.6635", "49344": "42.5936_-85.6282", "49348": "42.6643_-85.6191", "49406": "42.6369_-86.2022", "49408": "42.5777_-86.1249", "49416": "42.5203_-86.2275", "49419": "42.6881_-85.9747", "49450": "42.4651_-86.0799", "49453": "42.6456_-86.1655", "49707": "45.079_-83.4602", "49744": "45.0124_-83.6535", "49747": "44.8947_-83.6059", "49753": "45.0429_-83.7491", "49766": "44.9104_-83.4592", "49611": "44.9737_-84.9745", "49612": "44.8779_-85.2241", "49615": "44.9765_-85.2265", "49622": "45.0748_-85.2673", "49627": "45.1072_-85.3501", "49629": "44.8955_-85.4082", "49648": "45.0126_-85.3539", "49659": "44.9116_-85.0634", "49729": "45.1599_-85.2633", "48658": "43.9733_-83.9433", "48659": "44.0669_-84.0505", "48703": "44.0338_-83.702", "48749": "44.0499_-83.843", "48765": "44.1105_-83.7019", "48766": "44.1293_-83.8491", "49908": "46.8048_-88.5758", "49919": "46.5413_-88.5371", "49946": "46.7704_-88.421", "49962": "46.8747_-88.1732", "49970": "46.5413_-88.6049", "48897": "42.7057_-85.1326", "49035": "42.5951_-85.3086", "49046": "42.5141_-85.4067", "49050": "42.5015_-85.2495", "49058": "42.643_-85.2937", "49060": "42.4237_-85.3998", "49073": "42.5937_-85.122", "49325": "42.7661_-85.3133", "49333": "42.6932_-85.4759", "48611": "43.608_-84.1027", "48613": "43.9267_-84.1053", "48631": "43.6794_-83.9927", "48634": "43.7714_-84.0513", "48650": "43.8491_-84.0082", "48706": "43.6088_-83.953", "48707": "43.7378_-83.9333", "48708": "43.5821_-83.8781", "48710": "43.5566_-83.9943", "48732": "43.6069_-83.8217", "48747": "43.5286_-83.7672", "49616": "44.5955_-86.0961", "49617": "44.6306_-86.0025", "49628": "44.6194_-86.2265", "49635": "44.6311_-86.2212", "49640": "44.6954_-86.0376", "49650": "44.7317_-85.8528", "49683": "44.5198_-85.946", "49022": "42.1086_-86.4234", "49023": "42.1167_-86.4542", "49038": "42.203_-86.3225", "49039": "42.2248_-86.3723", "49084": "42.1834_-86.3828", "49085": "42.064_-86.4783", "49098": "42.1938_-86.2604", "49101": "41.9488_-86.4913", "49102": "41.9484_-86.285", "49103": "41.948_-86.354", "49104": "41.9464_-86.3389", "49106": "41.9362_-86.5543", "49107": "41.8327_-86.3708", "49111": "42.0151_-86.2972", "49113": "41.8198_-86.5035", "49115": "41.8771_-86.6302", "49116": "41.8485_-86.6694", "49117": "41.7927_-86.746", "49119": "41.8744_-86.549", "49120": "41.8202_-86.2368", "49125": "41.8829_-86.5885", "49126": "42.0521_-86.3921", "49127": "42.022_-86.5119", "49128": "41.815_-86.6154", "49129": "41.8255_-86.6911", "49028": "41.8643_-85.1838", "49036": "41.9255_-85.0057", "49082": "41.9442_-84.8839", "49089": "42.0107_-85.2408", "49094": "42.0551_-85.1356", "49255": "41.7928_-84.8496", "49011": "42.103_-85.2317", "49014": "42.303_-85.1304", "49015": "42.3028_-85.2128", "49016": "42.2464_-85.0045", "49017": "42.3173_-85.1782", "49018": "42.2464_-85.0045", "49020": "42.3953_-85.2322", "49029": "42.1239_-85.105", "49033": "42.2127_-85.1128", "49037": "42.3453_-85.2178", "49051": "42.1961_-85.2311", "49068": "42.272_-84.9583", "49092": "42.0863_-84.9926", "49224": "42.2581_-84.7561", "49245": "42.1416_-84.8157", "49031": "41.8968_-85.9923", "49047": "41.991_-86.1168", "49061": "41.9129_-85.8341", "49067": "42.0275_-85.7988", "49095": "41.8955_-85.8755", "49112": "41.7913_-86.0263", "49130": "41.7827_-85.8529", "49711": "45.3583_-85.0973", "49712": "45.2052_-85.0183", "49713": "45.2116_-84.8916", "49720": "45.2654_-85.2297", "49727": "45.1539_-85.1387", "49782": "45.6684_-85.5473", "49796": "45.2661_-84.9337", "49701": "45.7777_-84.7298", "49705": "45.3637_-84.4695", "49716": "45.5068_-84.7467", "49717": "45.4408_-84.7112", "49721": "45.608_-84.4867", "49749": "45.427_-84.5956", "49761": "45.5595_-84.5221", "49791": "45.4838_-84.5936", "49792": "45.3588_-84.2953", "49799": "45.2861_-84.6065", "49710": "46.2848_-84.2173", "49715": "46.3891_-84.6981", "49724": "46.327_-84.3878", "49725": "45.9939_-83.9396", "49726": "46.0055_-83.7367", "49728": "46.4088_-85.0136", "49736": "46.079_-84.145", "49748": "46.3908_-85.1764", "49752": "46.275_-84.5148", "49768": "46.5951_-85.0973", "49774": "46.1559_-84.3663", "49780": "46.2585_-84.8004", "49783": "46.4151_-84.2854", "49784": "46.4108_-84.3365", "49785": "46.1815_-84.4054", "49786": "46.4108_-84.3365", "49788": "46.2627_-84.4626", "49793": "46.1936_-85.019", "48617": "43.8223_-84.7635", "48622": "43.8342_-84.8754", "48625": "44.0285_-84.7729", "48632": "43.8575_-85.0219", "48633": "43.9634_-84.947", "48808": "42.8206_-84.4545", "48820": "42.8428_-84.5797", "48822": "42.8263_-84.759", "48831": "43.0886_-84.3869", "48833": "43.1036_-84.5139", "48835": "42.9941_-84.76", "48853": "43.0992_-84.6898", "48866": "42.9969_-84.3649", "48879": "43.0059_-84.5719", "48894": "42.9328_-84.8083", "49733": "44.8382_-84.6824", "49738": "44.671_-84.6913", "49739": "44.683_-84.6104", "49807": "45.6956_-87.2073", "49818": "45.9104_-87.2237", "49829": "45.7659_-87.089", "49835": "45.7549_-86.5776", "49837": "45.8813_-87.1152", "49864": "45.8424_-86.6558", "49872": "45.9925_-87.0792", "49878": "45.9107_-86.8845", "49880": "46.0503_-87.1331", "49894": "45.7849_-87.0734", "49801": "45.8219_-88.0683", "49802": "45.8006_-88.0773", "49815": "46.1546_-88.0772", "49831": "45.9972_-87.8257", "49834": "45.9438_-87.7584", "49852": "45.7772_-87.8151", "49870": "45.7862_-87.9047", "49876": "45.7999_-87.9922", "49877": "46.1297_-87.7367", "49881": "46.0813_-88.0676", "49892": "45.7623_-87.8168", "48813": "42.5702_-84.8352", "48821": "42.6501_-84.6486", "48827": "42.5166_-84.6565", "48837": "42.7529_-84.7373", "48861": "42.7377_-84.8979", "48876": "42.6398_-84.7346", "48890": "42.7693_-84.9813", "48908": "42.5961_-84.8382", "48917": "42.7376_-84.6244", "49021": "42.4525_-85.0489", "49076": "42.4459_-84.8973", "49096": "42.6392_-85.011", "49706": "45.4405_-84.7924", "49718": "45.7424_-84.7735", "49722": "45.4167_-84.867", "49723": "45.6254_-85.0419", "49737": "45.5802_-85.1137", "49740": "45.5251_-85.0062", "49755": "45.6377_-84.7986", "49764": "45.4236_-84.8281", "49769": "45.5703_-84.8425", "49770": "45.3559_-84.9133", "48411": "42.94_-83.5369", "48420": "43.1779_-83.7249", "48423": "43.0348_-83.5268", "48430": "42.7851_-83.7294", "48433": "43.072_-83.8424", "48436": "42.8813_-83.8855", "48437": "43.1123_-83.6154", "48438": "42.9147_-83.4845", "48439": "42.9282_-83.6264", "48449": "42.9693_-83.9279", "48451": "42.8104_-83.7993", "48457": "43.1754_-83.8824", "48458": "43.116_-83.6895", "48463": "43.1706_-83.5172", "48473": "42.9468_-83.817", "48480": "42.918_-83.617", "48501": "42.9659_-83.7808", "48502": "43.0151_-83.6948", "48503": "43.0128_-83.6914", "48504": "43.0573_-83.7498", "48505": "43.0634_-83.7001", "48506": "43.0653_-83.631", "48507": "42.9821_-83.734", "48509": "43.0259_-83.6041", "48519": "42.9859_-83.6135", "48529": "42.9744_-83.6629", "48531": "43.002_-83.6925", "48532": "43.0111_-83.803", "48550": "43.0349_-83.6887", "48551": "42.979_-83.7131", "48552": "42.9779_-83.7131", "48553": "42.9736_-83.7203", "48554": "42.9722_-83.7946", "48555": "43.0113_-83.7108", "48556": "43.0327_-83.6463", "48557": "43.0806_-83.7837", "48612": "43.8866_-84.4241", "48624": "44.0296_-84.4968", "48638": "43.4343_-84.0091", "48652": "43.8517_-84.2134", "49911": "46.4802_-90.0515", "49938": "46.4638_-90.1588", "49947": "46.3551_-89.6774", "49959": "46.4727_-89.9976", "49968": "46.4752_-89.9424", "49969": "46.2542_-89.2108", "49610": "44.7894_-85.4884", "49633": "44.5721_-85.2531", "49637": "44.6428_-85.7113", "49643": "44.6518_-85.8022", "49649": "44.5756_-85.5262", "49666": "44.6261_-85.5287", "49673": "44.9559_-85.49", "49684": "44.694_-85.6763", "49685": "44.8162_-85.5751", "49686": "44.7631_-85.6206", "49690": "44.802_-85.4347", "49696": "44.8162_-85.5751", "48615": "43.3935_-84.5023", "48662": "43.3962_-84.4243", "48801": "43.3809_-84.6635", "48806": "43.1891_-84.488", "48807": "43.1615_-84.3597", "48830": "43.3639_-84.8362", "48832": "43.4106_-84.7631", "48847": "43.2828_-84.6088", "48856": "43.1689_-84.7552", "48862": "43.2484_-84.5433", "48871": "43.1649_-84.666", "48874": "43.1863_-84.6017", "48877": "43.4017_-84.8429", "48880": "43.4278_-84.5952", "48889": "43.3091_-84.7907", "49227": "41.957_-84.7677", "49232": "41.7361_-84.7245", "49239": "41.7825_-84.6047", "49242": "41.924_-84.6208", "49249": "42.0484_-84.4455", "49250": "41.9798_-84.6451", "49252": "42.0369_-84.7673", "49257": "42.0548_-84.5039", "49258": "42.0603_-84.6594", "49262": "41.9715_-84.5208", "49266": "41.8384_-84.5974", "49271": "41.8963_-84.444", "49274": "41.8442_-84.7648", "49281": "42.023_-84.3794", "49282": "42.0388_-84.406", "49288": "41.7386_-84.4496", "49905": "47.0937_-88.6613", "49913": "47.2439_-88.4588", "49916": "47.002_-88.5546", "49917": "47.2842_-88.3875", "49921": "47.0914_-88.5809", "49922": "47.1196_-88.5115", "49930": "47.1367_-88.5654", "49931": "47.1158_-88.558", "49934": "47.1733_-88.4293", "49942": "47.2694_-88.4184", "49945": "47.1784_-88.2973", "49952": "46.7748_-88.8799", "49955": "47.0404_-88.6704", "49958": "46.7949_-88.6251", "49961": "46.5047_-88.7085", "49963": "47.0719_-88.652", "49965": "46.9109_-88.8532", "48413": "43.8067_-83.0054", "48432": "43.9014_-82.9825", "48441": "43.8312_-82.6886", "48445": "43.948_-82.9755", "48467": "44.0223_-82.9984", "48468": "43.928_-82.7529", "48470": "43.7404_-82.7414", "48475": "43.6896_-82.964", "48720": "43.8377_-83.3525", "48725": "43.9429_-83.2659", "48731": "43.8344_-83.1786", "48754": "43.7206_-83.2307", "48755": "43.8179_-83.2755", "48759": "43.7289_-83.4366", "48805": "42.5992_-84.372", "48819": "42.5505_-84.2939", "48823": "42.7388_-84.4764", "48824": "42.7283_-84.4882", "48825": "42.7238_-84.4648", "48826": "42.737_-84.4839", "48840": "42.7531_-84.3989", "48842": "42.6394_-84.5242", "48854": "42.5796_-84.4561", "48864": "42.7053_-84.4187", "48892": "42.663_-84.1701", "48895": "42.6967_-84.2926", "48901": "42.7325_-84.5555", "48906": "42.7635_-84.558", "48909": "42.7325_-84.5555", "48910": "42.7008_-84.549", "48911": "42.6797_-84.5772", "48912": "42.7371_-84.5244", "48913": "42.7325_-84.5555", "48915": "42.7391_-84.5704", "48916": "42.7325_-84.5555", "48918": "42.7325_-84.5555", "48919": "42.7286_-84.5517", "48922": "42.7325_-84.5587", "48924": "42.7325_-84.5555", "48929": "42.7325_-84.5587", "48930": "42.7325_-84.5587", "48933": "42.7334_-84.5571", "48937": "42.7487_-84.559", "48951": "42.7035_-84.5365", "48956": "42.7325_-84.5587", "48980": "42.7325_-84.5555", "49251": "42.4603_-84.4207", "49264": "42.4487_-84.5535", "49285": "42.4604_-84.1752", "48809": "43.0885_-85.2313", "48815": "42.8302_-85.2494", "48845": "43.0923_-84.8422", "48846": "42.9859_-85.071", "48849": "42.7863_-85.1357", "48851": "42.9634_-84.9209", "48860": "43.0439_-84.9391", "48865": "43.0895_-85.1165", "48870": "43.1125_-84.9856", "48873": "43.0007_-84.8492", "48875": "42.8624_-84.9139", "48881": "42.9357_-85.203", "48887": "43.0595_-85.2628", "48730": "44.3008_-83.4776", "48739": "44.3819_-83.8359", "48743": "44.4197_-83.8719", "48748": "44.3137_-83.6839", "48750": "44.4465_-83.3619", "48763": "44.2675_-83.5449", "48764": "44.2665_-83.5192", "48770": "44.2325_-83.8068", "49902": "46.0438_-88.3771", "49903": "46.2321_-88.4508", "49915": "46.0643_-88.6329", "49920": "46.1093_-88.3505", "49927": "46.0526_-88.5917", "49935": "46.093_-88.646", "49964": "46.0797_-88.629", "48804": "43.6406_-84.8474", "48858": "43.6013_-84.7736", "48859": "43.5647_-84.8473", "48878": "43.6843_-84.7833", "48883": "43.5657_-84.5873", "48893": "43.6453_-85.0046", "48896": "43.5234_-84.9017", "49310": "43.5228_-85.0589", "49201": "42.2545_-84.3875", "49202": "42.2634_-84.4083", "49203": "42.229_-84.4132", "49204": "42.2459_-84.4013", "49230": "42.1044_-84.2414", "49234": "42.1235_-84.3521", "49237": "42.1875_-84.6529", "49240": "42.2711_-84.194", "49241": "42.1025_-84.5848", "49246": "42.1191_-84.4976", "49254": "42.2271_-84.3161", "49259": "42.3703_-84.2485", "49261": "42.1643_-84.2458", "49263": "42.1582_-84.1838", "49269": "42.2739_-84.5999", "49272": "42.3903_-84.3428", "49277": "42.3887_-84.4589", "49283": "42.2069_-84.5501", "49284": "42.3805_-84.7039", "49001": "42.2736_-85.5457", "49002": "42.1938_-85.5639", "49003": "42.2454_-85.5299", "49004": "42.3518_-85.5621", "49005": "42.2917_-85.5872", "49006": "42.2922_-85.633", "49007": "42.3024_-85.5882", "49008": "42.2624_-85.6096", "49009": "42.2809_-85.6863", "49012": "42.3563_-85.354", "49019": "42.2454_-85.5299", "49024": "42.1974_-85.6194", "49034": "42.234_-85.3238", "49041": "42.2867_-85.5133", "49048": "42.3189_-85.5152", "49052": "42.1391_-85.3227", "49053": "42.2948_-85.4237", "49074": "42.2454_-85.5299", "49077": "42.2589_-85.6775", "49081": "42.1718_-85.6178", "49083": "42.3757_-85.4447", "49087": "42.1329_-85.6637", "49088": "42.1819_-85.4685", "49097": "42.1209_-85.5024", "49646": "44.7355_-85.1207", "49676": "44.8449_-85.2943", "49680": "44.6401_-85.2472", "49301": "42.9566_-85.481", "49302": "42.8243_-85.4256", "49306": "43.075_-85.5632", "49315": "42.8016_-85.7136", "49316": "42.8187_-85.5244", "49317": "43.0712_-85.4809", "49319": "43.2215_-85.5452", "49321": "43.0578_-85.6845", "49330": "43.2362_-85.7399", "49331": "42.955_-85.3653", "49341": "43.1152_-85.5136", "49343": "43.2981_-85.5367", "49345": "43.1619_-85.6877", "49351": "43.12_-85.56", "49355": "42.9542_-85.4889", "49356": "42.9542_-85.4889", "49357": "42.9542_-85.4889", "49418": "42.8939_-85.7619", "49468": "42.9097_-85.7631", "49501": "42.9842_-85.6291", "49502": "42.9634_-85.6681", "49503": "42.9659_-85.6527", "49504": "42.9737_-85.7265", "49505": "43.012_-85.6309", "49506": "42.944_-85.6213", "49507": "42.9318_-85.6542", "49508": "42.8894_-85.6219", "49509": "42.9134_-85.7053", "49510": "43.0314_-85.5503", "49512": "42.8802_-85.5352", "49514": "43.0314_-85.5503", "49515": "43.0314_-85.5503", "49516": "43.0314_-85.5503", "49518": "43.0314_-85.5503", "49519": "42.8977_-85.7186", "49523": "42.9634_-85.6681", "49525": "43.0135_-85.6027", "49528": "42.8811_-85.6239", "49530": "43.0314_-85.5503", "49544": "43.0073_-85.7255", "49546": "42.928_-85.5483", "49548": "42.8697_-85.6628", "49555": "42.9634_-85.6681", "49560": "43.0314_-85.5503", "49588": "43.0314_-85.5503", "49599": "43.0314_-85.5503", "49805": "47.2879_-88.4129", "49901": "47.2933_-88.3897", "49918": "47.4688_-87.8884", "49950": "47.3526_-88.2889", "49304": "43.8894_-85.8819", "49402": "43.9333_-86.0345", "49623": "43.8892_-85.6356", "49642": "43.8872_-85.7759", "49644": "44.0966_-85.939", "49656": "44.0545_-85.6826", "48003": "42.926_-83.0362", "48412": "43.0547_-83.1668", "48421": "43.1503_-83.3811", "48428": "42.9378_-83.1501", "48440": "42.9545_-83.4033", "48444": "43.0425_-83.0708", "48446": "43.0579_-83.3332", "48455": "42.9414_-83.2891", "48461": "43.2069_-83.2267", "48464": "43.2183_-83.4242", "48727": "43.31_-83.1741", "48760": "43.3141_-83.272", "49621": "44.8605_-85.8138", "49630": "44.8144_-85.9999", "49636": "44.8734_-85.9887", "49653": "44.9856_-85.7329", "49654": "45.0793_-85.9896", "49664": "44.859_-85.8814", "49670": "45.1157_-85.6173", "49674": "45.0556_-85.589", "49682": "44.9656_-85.6423", "49220": "42.0036_-84.3122", "49221": "41.9005_-84.0446", "49228": "41.8276_-83.8773", "49229": "41.9887_-83.8377", "49233": "42.0604_-84.3254", "49235": "41.8636_-84.2147", "49236": "42.0639_-83.9442", "49238": "41.8909_-83.7847", "49247": "41.8581_-84.338", "49248": "41.7704_-84.0011", "49253": "41.9671_-84.2767", "49256": "41.7386_-84.2192", "49265": "42.0295_-84.1839", "49268": "41.8729_-83.9263", "49276": "41.7953_-83.8011", "49279": "41.8259_-84.1016", "49286": "41.9953_-83.9555", "49287": "42.0369_-84.0768", "49289": "41.7683_-84.1076", "48114": "42.57_-83.7484", "48116": "42.5371_-83.7756", "48137": "42.496_-84.0847", "48139": "42.4523_-83.8147", "48143": "42.4573_-83.8366", "48169": "42.4596_-83.9099", "48353": "42.6356_-83.7147", "48816": "42.7598_-83.9486", "48836": "42.6614_-84.0721", "48843": "42.6159_-83.9248", "48844": "42.6035_-83.9112", "48855": "42.6871_-83.914", "49853": "46.297_-85.7307", "49868": "46.3438_-85.515", "49719": "46.0024_-84.3488", "49745": "46.0217_-84.4284", "49757": "45.8578_-84.6245", "49760": "46.0441_-85.0078", "49762": "46.126_-85.4462", "49775": "45.7549_-84.447", "49781": "45.9985_-84.6978", "49820": "46.2048_-85.7865", "49827": "46.204_-85.6005", "49838": "46.0747_-85.7338", "48005": "42.8409_-82.8899", "48015": "42.4788_-83.0248", "48021": "42.4658_-82.9459", "48026": "42.5423_-82.947", "48035": "42.5512_-82.9167", "48036": "42.5938_-82.9133", "48038": "42.6206_-82.9608", "48042": "42.6735_-82.9163", "48043": "42.5978_-82.8823", "48044": "42.6442_-82.8985", "48045": "42.5877_-82.8215", "48046": "42.5973_-82.878", "48047": "42.673_-82.7753", "48048": "42.7443_-82.8042", "48050": "42.7859_-82.7979", "48051": "42.6938_-82.8207", "48062": "42.8389_-82.7996", "48065": "42.84_-83.0388", "48066": "42.5034_-82.9387", "48080": "42.4706_-82.9022", "48081": "42.4941_-82.899", "48082": "42.5269_-82.8841", "48088": "42.5164_-82.9832", "48089": "42.4685_-82.9974", "48090": "42.4775_-83.0277", "48091": "42.4665_-83.0593", "48092": "42.5125_-83.0643", "48093": "42.5149_-82.9968", "48094": "42.7262_-83.0268", "48095": "42.7682_-83.0395", "48096": "42.754_-82.9163", "48310": "42.5648_-83.0701", "48311": "42.5803_-83.0302", "48312": "42.5592_-83.0029", "48313": "42.6005_-82.9998", "48314": "42.6124_-83.0345", "48315": "42.671_-82.9988", "48316": "42.6885_-83.0548", "48317": "42.6413_-83.0504", "48318": "42.6261_-83.0335", "48397": "42.4917_-83.0402", "49613": "44.5232_-86.2061", "49614": "44.4311_-86.1425", "49619": "44.2966_-85.9964", "49625": "44.4503_-85.8879", "49626": "44.2413_-86.2913", "49634": "44.2153_-86.2873", "49645": "44.3692_-86.0467", "49660": "44.2635_-86.1825", "49675": "44.3646_-86.21", "49689": "44.2133_-85.9555", "49808": "46.8158_-87.7285", "49814": "46.4685_-87.8306", "49819": "46.0508_-87.4921", "49833": "46.2888_-87.3418", "49841": "46.3311_-87.4397", "49849": "46.4387_-87.7091", "49855": "46.5786_-87.4545", "49861": "46.5308_-88.0914", "49865": "46.6041_-87.6148", "49866": "46.5007_-87.5829", "49871": "46.4416_-87.5764", "49879": "46.368_-87.9938", "49885": "46.349_-87.2481", "49405": "43.9324_-86.1777", "49410": "44.0363_-86.2169", "49411": "44.112_-86.2652", "49431": "43.9688_-86.4403", "49454": "43.9547_-86.2801", "49458": "43.9536_-86.1148", "49305": "43.7507_-85.1547", "49307": "43.6897_-85.4797", "49320": "43.7553_-85.2783", "49332": "43.6813_-85.228", "49336": "43.506_-85.4473", "49338": "43.7677_-85.5213", "49340": "43.6032_-85.1574", "49342": "43.7379_-85.3219", "49346": "43.6017_-85.4446", "49812": "45.5917_-87.5439", "49821": "45.4887_-87.6079", "49845": "45.6922_-87.3513", "49847": "45.7149_-87.6227", "49848": "45.3748_-87.6206", "49858": "45.1343_-87.6215", "49863": "45.6089_-87.5529", "49873": "45.841_-87.4816", "49874": "45.6792_-87.5319", "49886": "45.6958_-87.511", "49887": "45.4166_-87.6258", "49893": "45.3017_-87.5805", "49896": "45.6649_-87.3997", "48618": "43.7494_-84.5911", "48620": "43.7774_-84.3813", "48628": "43.7882_-84.3296", "48640": "43.6376_-84.268", "48641": "43.5383_-84.3878", "48642": "43.6375_-84.1979", "48657": "43.7204_-84.3954", "48667": "43.6156_-84.2472", "48670": "43.6375_-84.2568", "48674": "43.6129_-84.1971", "48686": "43.6473_-84.3873", "49632": "44.2529_-85.017", "49651": "44.3767_-85.0946", "49657": "44.2172_-85.2283", "49667": "44.3433_-84.9446", "48110": "42.0082_-83.6643", "48117": "42.0529_-83.3755", "48131": "41.9514_-83.6522", "48133": "41.7829_-83.4958", "48140": "41.8549_-83.5916", "48144": "41.7531_-83.6259", "48145": "41.8585_-83.4715", "48157": "41.8146_-83.4382", "48159": "42.0288_-83.5179", "48160": "42.0914_-83.6776", "48161": "41.908_-83.4719", "48162": "41.9293_-83.4448", "48166": "41.9766_-83.2804", "48177": "41.8076_-83.5793", "48179": "42.0624_-83.2663", "48182": "41.7682_-83.5797", "49267": "41.7683_-83.6856", "49270": "41.8757_-83.6877", "48811": "43.1695_-84.8653", "48812": "43.4138_-84.9753", "48818": "43.2624_-84.8993", "48829": "43.4116_-85.028", "48834": "43.1497_-85.0666", "48838": "43.1793_-85.2497", "48850": "43.4269_-85.2924", "48852": "43.3503_-85.0517", "48884": "43.2126_-85.0468", "48885": "43.2358_-85.1207", "48886": "43.4337_-85.1416", "48888": "43.3058_-85.0995", "48891": "43.387_-84.9082", "49322": "43.3645_-85.3792", "49326": "43.2239_-85.3159", "49329": "43.4083_-85.4856", "49339": "43.3355_-85.5134", "49347": "43.3156_-85.3685", "49709": "44.9924_-84.148", "49746": "45.0691_-83.9468", "49756": "44.8538_-84.2973", "49303": "43.2768_-85.8313", "49318": "43.2381_-85.8254", "49415": "43.1443_-86.1388", "49425": "43.4415_-86.1509", "49437": "43.4242_-86.374", "49440": "43.2326_-86.2492", "49441": "43.1962_-86.2738", "49442": "43.2329_-86.1885", "49443": "43.2342_-86.2484", "49444": "43.1791_-86.1989", "49445": "43.2952_-86.279", "49451": "43.2091_-85.9648", "49457": "43.3414_-86.1633", "49461": "43.3904_-86.3315", "49463": "43.372_-86.4237", "49309": "43.7321_-85.8778", "49312": "43.6853_-85.8159", "49327": "43.3392_-85.8368", "49337": "43.4198_-85.7594", "49349": "43.5398_-85.7586", "49412": "43.4652_-85.9626", "49413": "43.5543_-85.8009", "48007": "42.6061_-83.2976", "48009": "42.5444_-83.2133", "48012": "42.5467_-83.2113", "48017": "42.5365_-83.1503", "48025": "42.5219_-83.2519", "48030": "42.4608_-83.0982", "48033": "42.4723_-83.294", "48034": "42.4969_-83.2911", "48037": "42.5675_-83.15", "48067": "42.4906_-83.1366", "48068": "42.4895_-83.1446", "48069": "42.471_-83.1438", "48070": "42.4825_-83.1749", "48071": "42.5016_-83.1027", "48072": "42.5028_-83.1887", "48073": "42.519_-83.157", "48075": "42.4638_-83.2255", "48076": "42.4981_-83.2058", "48083": "42.5597_-83.1138", "48084": "42.5627_-83.1799", "48085": "42.6006_-83.1198", "48086": "42.4734_-83.2219", "48098": "42.5991_-83.1789", "48099": "42.5876_-83.1737", "48165": "42.5076_-83.6342", "48178": "42.4567_-83.659", "48220": "42.4586_-83.1363", "48237": "42.4662_-83.184", "48301": "42.5445_-83.2792", "48302": "42.5848_-83.2821", "48303": "42.5836_-83.2455", "48304": "42.587_-83.2359", "48306": "42.7262_-83.1566", "48307": "42.6593_-83.1225", "48308": "42.6806_-83.1338", "48309": "42.6626_-83.1837", "48320": "42.6114_-83.3356", "48321": "42.6601_-83.3863", "48322": "42.5424_-83.3793", "48323": "42.5683_-83.3805", "48324": "42.5961_-83.3819", "48325": "42.6601_-83.3863", "48326": "42.6583_-83.2375", "48327": "42.6438_-83.4076", "48328": "42.6429_-83.3546", "48329": "42.6877_-83.3879", "48330": "42.6754_-83.3637", "48331": "42.5051_-83.4072", "48332": "42.4645_-83.3763", "48333": "42.4645_-83.3763", "48334": "42.5065_-83.3484", "48335": "42.4617_-83.4053", "48336": "42.4656_-83.3638", "48340": "42.668_-83.2893", "48341": "42.6294_-83.3041", "48342": "42.6439_-83.2792", "48343": "42.6389_-83.291", "48346": "42.7239_-83.4232", "48347": "42.6601_-83.3863", "48348": "42.7605_-83.404", "48350": "42.7496_-83.5358", "48356": "42.6692_-83.5895", "48357": "42.6595_-83.637", "48359": "42.7231_-83.2769", "48360": "42.7429_-83.272", "48361": "42.7845_-83.2397", "48362": "42.7763_-83.2748", "48363": "42.7732_-83.1711", "48366": "42.8214_-83.1502", "48367": "42.8437_-83.1406", "48370": "42.8265_-83.2005", "48371": "42.8223_-83.2829", "48374": "42.4735_-83.5224", "48375": "42.4604_-83.4577", "48376": "42.471_-83.4748", "48377": "42.4992_-83.4773", "48380": "42.602_-83.6508", "48381": "42.5758_-83.5924", "48382": "42.5834_-83.5009", "48383": "42.658_-83.5398", "48386": "42.641_-83.4738", "48387": "42.6148_-83.4469", "48390": "42.5582_-83.4773", "48391": "42.5378_-83.481", "48393": "42.534_-83.5285", "48442": "42.7905_-83.6127", "48462": "42.8409_-83.4288", "49420": "43.7068_-86.3142", "49421": "43.5965_-86.0607", "49436": "43.6825_-86.4533", "49446": "43.5556_-86.3448", "49449": "43.8237_-86.3868", "49452": "43.5116_-86.3446", "49455": "43.6079_-86.3615", "49459": "43.7626_-86.083", "48610": "44.1395_-84.1872", "48635": "44.3976_-83.9905", "48654": "44.4167_-84.1256", "48661": "44.279_-84.2286", "48756": "44.21_-84.0212", "48761": "44.5014_-83.8686", "49910": "46.5881_-89.5973", "49912": "46.528_-89.168", "49925": "46.5404_-89.3145", "49929": "46.7809_-89.1146", "49948": "46.7474_-89.0649", "49953": "46.8275_-89.3485", "49960": "46.7537_-89.1958", "49967": "46.4864_-89.027", "49971": "46.7538_-89.584", "49631": "43.8888_-85.2649", "49639": "43.8481_-85.4059", "49655": "44.0457_-85.43", "49665": "44.0463_-85.155", "49677": "43.8868_-85.513", "49679": "43.8776_-85.1465", "49688": "44.1072_-85.4901", "48619": "44.8264_-84.0261", "48621": "44.7205_-84.0525", "48636": "44.6001_-84.2931", "48647": "44.6665_-84.1353", "49730": "45.0645_-84.8562", "49734": "45.0275_-84.6748", "49735": "45.0125_-84.6723", "49751": "45.0152_-84.3857", "49795": "45.1532_-84.6511", "49797": "44.8702_-84.6598", "49401": "42.9711_-85.9249", "49403": "43.1494_-85.8538", "49404": "43.0601_-85.9517", "49409": "43.0809_-86.2154", "49417": "43.0378_-86.1912", "49422": "42.7875_-86.1089", "49423": "42.7692_-86.1164", "49424": "42.8135_-86.1426", "49426": "42.8748_-85.8751", "49427": "42.8267_-85.8444", "49428": "42.9104_-85.8276", "49429": "42.9072_-85.792", "49430": "43.0103_-85.8975", "49434": "42.7697_-86.2055", "49435": "43.0532_-85.842", "49448": "43.0883_-86.1028", "49456": "43.0887_-86.1915", "49460": "42.9099_-86.1317", "49464": "42.8256_-86.0104", "49534": "43.0141_-85.7543", "49743": "45.2975_-83.8542", "49759": "45.4309_-84.0854", "49765": "45.3365_-84.2123", "49776": "45.2233_-83.6393", "49777": "45.2969_-83.5023", "49779": "45.4123_-83.8355", "48627": "44.3871_-84.7013", "48629": "44.3147_-84.7647", "48630": "44.3275_-84.7745", "48651": "44.2974_-84.6627", "48653": "44.4839_-84.6601", "48656": "44.3665_-84.4247", "48415": "43.2649_-83.7903", "48417": "43.2404_-83.9511", "48601": "43.4047_-83.9156", "48602": "43.4248_-83.9745", "48603": "43.4631_-84.0297", "48604": "43.4732_-83.9514", "48605": "43.4588_-84.0518", "48606": "43.3485_-84.0326", "48607": "43.4301_-83.9319", "48608": "43.3485_-84.0326", "48609": "43.3869_-84.0926", "48614": "43.2548_-84.2978", "48616": "43.1824_-84.1122", "48623": "43.5161_-84.1822", "48626": "43.4099_-84.2266", "48637": "43.3939_-84.3308", "48649": "43.1505_-84.2094", "48655": "43.2863_-84.1598", "48663": "43.4195_-83.9508", "48722": "43.3553_-83.8549", "48724": "43.4586_-83.9303", "48734": "43.341_-83.7475", "48787": "43.335_-83.7494", "48001": "42.6367_-82.5866", "48002": "42.9388_-82.9198", "48004": "42.8241_-82.6652", "48006": "43.0752_-82.6955", "48014": "43.0263_-82.9298", "48022": "42.9872_-82.7854", "48023": "42.7023_-82.6688", "48027": "42.9443_-82.6916", "48028": "42.585_-82.586", "48032": "43.1223_-82.5998", "48039": "42.6859_-82.5499", "48040": "42.9135_-82.4813", "48041": "42.941_-82.8046", "48049": "43.0349_-82.5748", "48054": "42.7769_-82.5437", "48059": "43.0888_-82.4905", "48060": "42.9958_-82.4599", "48061": "42.9709_-82.4249", "48063": "42.8892_-82.6675", "48064": "42.7674_-82.6728", "48074": "42.9051_-82.5679", "48079": "42.8255_-82.5133", "48097": "43.126_-82.8295", "49030": "41.8459_-85.3345", "49032": "41.9217_-85.4963", "49040": "41.9576_-85.3306", "49042": "41.846_-85.6571", "49066": "42.0294_-85.3497", "49072": "42.0143_-85.4727", "49075": "41.9189_-85.4489", "49091": "41.8089_-85.4264", "49093": "41.9596_-85.6371", "49099": "41.7929_-85.675", "48401": "43.3619_-82.6479", "48410": "43.5589_-82.9455", "48416": "43.2171_-82.9978", "48419": "43.4258_-82.6022", "48422": "43.2622_-82.6337", "48426": "43.4775_-83.0638", "48427": "43.5151_-82.7191", "48434": "43.6632_-82.6133", "48450": "43.2435_-82.5301", "48453": "43.3399_-83.0573", "48454": "43.193_-82.8393", "48456": "43.6814_-82.7299", "48465": "43.6257_-82.7017", "48466": "43.2694_-82.8193", "48469": "43.4329_-82.5468", "48471": "43.4055_-82.8409", "48472": "43.4886_-82.9301", "49817": "45.8997_-86.5307", "49836": "46.2363_-85.9159", "49840": "46.0115_-86.0214", "49854": "46.0062_-86.2555", "49883": "46.388_-85.9708", "48414": "42.882_-84.1207", "48418": "42.8059_-83.973", "48429": "42.9117_-83.9877", "48460": "43.1388_-83.9851", "48476": "42.9406_-84.0328", "48817": "43.0414_-84.0276", "48841": "43.1143_-84.2369", "48848": "42.8627_-84.353", "48857": "42.8385_-84.1768", "48867": "42.9934_-84.1595", "48872": "42.82_-84.2313", "48882": "42.804_-84.2959", "48435": "43.2645_-83.3796", "48701": "43.5844_-83.5393", "48723": "43.4833_-83.3835", "48726": "43.5797_-83.1733", "48729": "43.4735_-83.1702", "48733": "43.5126_-83.5835", "48735": "43.6543_-83.2628", "48741": "43.3982_-83.1847", "48744": "43.3562_-83.3725", "48746": "43.2718_-83.5619", "48757": "43.4531_-83.7015", "48758": "43.4073_-83.6762", "48767": "43.6473_-83.4699", "48768": "43.3691_-83.5844", "49013": "42.3312_-86.1311", "49026": "42.3842_-85.9568", "49027": "42.3465_-86.0725", "49043": "42.2911_-86.2743", "49045": "42.1012_-86.0338", "49055": "42.3702_-85.8536", "49056": "42.3761_-86.0541", "49057": "42.2088_-86.1687", "49062": "42.3618_-85.8141", "49063": "42.4136_-86.1298", "49064": "42.2076_-86.0525", "49065": "42.1545_-85.829", "49071": "42.2451_-85.7943", "49079": "42.2349_-85.9005", "49090": "42.4041_-86.2542", "48103": "42.2794_-83.784", "48104": "42.2694_-83.7282", "48105": "42.3042_-83.7068", "48106": "42.2535_-83.8366", "48107": "42.2535_-83.8366", "48108": "42.2328_-83.7015", "48109": "42.2776_-83.7409", "48113": "42.2535_-83.8366", "48115": "42.1602_-83.9117", "48118": "42.3207_-84.0334", "48130": "42.3583_-83.9", "48158": "42.1555_-84.0332", "48175": "42.4056_-83.5781", "48176": "42.1698_-83.7849", "48189": "42.4289_-83.7828", "48190": "42.1244_-83.5946", "48191": "42.1292_-83.5687", "48197": "42.2325_-83.6336", "48198": "42.2439_-83.583", "48101": "42.2522_-83.212", "48111": "42.1949_-83.4854", "48112": "42.2048_-83.4852", "48120": "42.3223_-83.1763", "48121": "42.2399_-83.1508", "48122": "42.2812_-83.1826", "48123": "42.2399_-83.1508", "48124": "42.2941_-83.2536", "48125": "42.2768_-83.2606", "48126": "42.3349_-83.1801", "48127": "42.3353_-83.2864", "48128": "42.32_-83.2701", "48134": "42.1055_-83.2795", "48135": "42.3242_-83.3402", "48136": "42.2399_-83.1508", "48138": "42.1352_-83.1561", "48141": "42.294_-83.3146", "48146": "42.2422_-83.1807", "48150": "42.3615_-83.3649", "48151": "42.3684_-83.3527", "48152": "42.4258_-83.3636", "48153": "42.3684_-83.3527", "48154": "42.3958_-83.3772", "48164": "42.1449_-83.3589", "48167": "42.4262_-83.4794", "48168": "42.4086_-83.4978", "48170": "42.3688_-83.4799", "48173": "42.0731_-83.2127", "48174": "42.2223_-83.3966", "48180": "42.2317_-83.2673", "48183": "42.1382_-83.2179", "48184": "42.2768_-83.3758", "48185": "42.3358_-83.3846", "48186": "42.289_-83.3686", "48187": "42.332_-83.4695", "48188": "42.291_-83.465", "48192": "42.2084_-83.1616", "48193": "42.1782_-83.2461", "48195": "42.2044_-83.1999", "48201": "42.3474_-83.0604", "48202": "42.377_-83.0796", "48203": "42.4212_-83.1009", "48204": "42.3661_-83.1422", "48205": "42.4313_-82.9813", "48206": "42.3749_-83.1087", "48207": "42.3524_-83.0271", "48208": "42.3495_-83.0927", "48209": "42.3097_-83.1155", "48210": "42.3376_-83.1303", "48211": "42.3809_-83.0409", "48212": "42.4081_-83.0583", "48213": "42.3982_-82.9925", "48214": "42.3669_-82.9938", "48215": "42.3773_-82.9513", "48216": "42.3275_-83.0827", "48217": "42.2719_-83.1545", "48218": "42.2692_-83.1364", "48219": "42.426_-83.2495", "48221": "42.426_-83.15", "48222": "42.2399_-83.1508", "48223": "42.3945_-83.2454", "48224": "42.4098_-82.9441", "48225": "42.4377_-82.9289", "48226": "42.3333_-83.0484", "48227": "42.3883_-83.1937", "48228": "42.3547_-83.2168", "48229": "42.2519_-83.1489", "48230": "42.3847_-82.9244", "48231": "42.3314_-83.0458", "48232": "42.3314_-83.0458", "48233": "42.2399_-83.1508", "48234": "42.4337_-83.0434", "48235": "42.4261_-83.1951", "48236": "42.4274_-82.9002", "48238": "42.3959_-83.1411", "48239": "42.3756_-83.2889", "48240": "42.4264_-83.3017", "48242": "42.2166_-83.3532", "48243": "42.3314_-83.0458", "48244": "42.2399_-83.1508", "48255": "42.3314_-83.0458", "48260": "42.2399_-83.1508", "48264": "42.3314_-83.0458", "48265": "42.2399_-83.1508", "48266": "42.2399_-83.1508", "48267": "42.3314_-83.0458", "48268": "42.3314_-83.0458", "48269": "42.3314_-83.0458", "48272": "42.3314_-83.0458", "48275": "42.3314_-83.0458", "48277": "42.2399_-83.1508", "48278": "42.2399_-83.1508", "48279": "42.3314_-83.0458", "48288": "42.2399_-83.1508", "49601": "44.2504_-85.43", "49618": "44.2916_-85.6144", "49620": "44.5199_-85.6935", "49638": "44.2972_-85.7396", "49663": "44.4152_-85.4202", "49668": "44.4075_-85.7061", "55748": "46.9968_-93.5994", "55752": "46.9772_-93.3064", "55760": "46.6072_-93.3076", "55785": "46.9232_-93.7464", "55787": "46.6444_-93.1272", "56350": "46.1957_-93.3774", "56431": "46.4799_-93.6454", "56469": "46.6895_-93.5627", "55005": "45.3887_-93.2315", "55011": "45.3414_-93.235", "55014": "45.1528_-93.144", "55070": "45.3903_-93.3598", "55303": "45.2825_-93.4186", "55304": "45.2377_-93.2724", "55421": "45.0523_-93.2541", "55432": "45.095_-93.2396", "55433": "45.1643_-93.3193", "55434": "45.1681_-93.2504", "55448": "45.1907_-93.3021", "55449": "45.1697_-93.1889", "56501": "46.8172_-95.8453", "56502": "46.8172_-95.8453", "56511": "46.8719_-95.9881", "56521": "47.0076_-95.944", "56544": "46.7565_-95.5212", "56554": "46.8176_-96.067", "56569": "47.1029_-95.9151", "56570": "46.9329_-95.2353", "56575": "47.0133_-95.3197", "56577": "46.9747_-95.8228", "56578": "46.8862_-95.7246", "56591": "47.0966_-95.8434", "56593": "46.8035_-95.3535", "56601": "47.572_-94.8013", "56619": "47.4736_-94.8803", "56630": "47.7381_-94.4961", "56647": "47.7324_-94.6477", "56650": "47.9272_-94.5382", "56663": "47.4651_-94.4834", "56666": "48.0372_-94.917", "56667": "47.7436_-94.9803", "56670": "47.8689_-94.9404", "56671": "47.8654_-95.0643", "56678": "47.548_-95.1205", "56683": "47.6566_-94.6747", "56685": "48.177_-94.5037", "56687": "47.5036_-95.0011", "56329": "45.6919_-93.9148", "56333": "45.6917_-94.0563", "56357": "45.7022_-93.8164", "56367": "45.7364_-94.1658", "56379": "45.604_-94.1591", "56210": "45.5593_-96.5589", "56211": "45.5539_-96.706", "56225": "45.4577_-96.4182", "56227": "45.2907_-96.1753", "56240": "45.5602_-96.4209", "56276": "45.2597_-96.3289", "56278": "45.3296_-96.4596", "56001": "44.1538_-93.996", "56002": "44.1591_-94.0092", "56010": "43.8903_-94.1774", "56024": "44.1546_-93.8719", "56034": "44.0467_-94.1791", "56037": "43.9952_-94.0677", "56055": "44.1202_-94.2184", "56063": "44.2221_-93.8289", "56065": "43.9331_-93.9542", "56078": "44.0077_-93.7833", "56080": "44.0817_-93.8571", "56090": "43.9706_-94.2142", "56019": "44.1111_-94.9134", "56030": "44.3258_-94.6052", "56041": "44.1527_-94.4933", "56073": "44.3044_-94.4644", "56084": "44.2286_-94.4347", "56085": "44.2821_-94.7273", "56087": "44.2329_-94.9792", "55707": "46.5196_-92.6292", "55718": "46.6484_-92.471", "55720": "46.7546_-92.5408", "55726": "46.6718_-92.8739", "55733": "46.7126_-92.3569", "55749": "46.4664_-92.375", "55757": "46.5029_-92.9047", "55767": "46.4472_-92.7466", "55780": "46.6831_-92.6927", "55797": "46.5921_-92.3718", "55798": "46.6691_-93.0069", "55315": "44.7169_-93.6879", "55317": "44.8679_-93.5359", "55318": "44.8061_-93.6083", "55322": "44.7646_-93.7982", "55339": "44.7315_-93.9643", "55360": "44.9022_-93.8859", "55367": "44.8994_-93.9701", "55368": "44.7736_-93.9216", "55383": "44.768_-93.9275", "55386": "44.8582_-93.6561", "55387": "44.851_-93.7784", "55388": "44.9595_-93.8482", "55397": "44.7929_-93.918", "55473": "44.98_-93.2638", "55550": "44.8055_-93.7665", "55551": "44.8055_-93.7665", "55553": "44.8055_-93.7665", "55554": "44.8055_-93.7665", "55558": "44.8055_-93.7665", "55568": "44.8055_-93.7665", "55583": "44.8055_-93.7665", "55594": "44.8055_-93.7665", "56430": "47.0741_-94.5628", "56435": "46.8699_-94.3959", "56452": "46.9884_-94.5033", "56473": "46.3607_-94.4895", "56474": "46.6938_-94.4477", "56484": "47.0877_-94.5847", "56626": "47.3477_-94.2519", "56633": "47.3516_-94.6119", "56641": "47.2069_-94.2575", "56655": "47.0248_-94.1982", "56662": "46.8375_-93.9443", "56672": "47.0874_-93.9196", "56222": "44.9639_-95.3499", "56260": "44.9226_-95.4845", "56262": "45.1143_-95.869", "56265": "44.9688_-95.6765", "56295": "45.0412_-95.834", "55002": "45.5134_-92.8942", "55012": "45.4482_-92.7894", "55013": "45.3611_-92.8921", "55032": "45.5962_-93.0395", "55045": "45.3873_-92.8421", "55056": "45.5114_-92.9802", "55069": "45.6855_-92.9655", "55074": "45.3576_-92.7609", "55078": "45.398_-92.9874", "55079": "45.3975_-93.0177", "55084": "45.4576_-92.733", "55092": "45.3364_-92.9675", "56514": "46.6522_-96.4198", "56525": "46.6667_-96.7398", "56529": "46.8782_-96.7022", "56536": "47.0705_-96.5052", "56546": "47.0999_-96.727", "56547": "46.882_-96.5583", "56549": "46.9777_-96.4092", "56552": "47.0014_-96.2888", "56560": "46.8677_-96.7572", "56561": "46.8739_-96.7695", "56562": "46.8739_-96.7695", "56563": "46.8739_-96.7695", "56580": "46.7703_-96.5985", "56585": "47.0903_-96.2824", "56621": "47.487_-95.4133", "56634": "47.7146_-95.3752", "56644": "47.749_-95.499", "56652": "47.7334_-95.2481", "56676": "47.5004_-95.245", "55604": "47.7758_-90.3391", "55605": "47.9591_-89.6989", "55606": "47.8342_-90.0476", "55612": "47.6831_-90.6381", "55613": "47.5422_-90.9338", "55615": "47.5738_-90.8363", "56101": "43.8831_-95.1373", "56118": "43.8942_-95.0457", "56145": "44.0737_-95.1547", "56159": "43.939_-94.9273", "56174": "44.0524_-95.3019", "56183": "44.0654_-95.4232", "56401": "46.3502_-94.1", "56425": "46.3429_-94.2822", "56441": "46.5091_-93.9874", "56442": "46.6773_-94.1128", "56444": "46.4446_-93.8849", "56447": "46.7478_-93.9484", "56448": "46.747_-94.0656", "56449": "46.2099_-94.2527", "56450": "46.2314_-93.8341", "56455": "46.4778_-93.9789", "56456": "46.6461_-94.3347", "56459": "46.4987_-94.2519", "56465": "46.5393_-94.1344", "56468": "46.4929_-94.2976", "56472": "46.6257_-94.2684", "55010": "44.5472_-93.1531", "55024": "44.6628_-93.1539", "55031": "44.6028_-92.9467", "55033": "44.7129_-92.8637", "55044": "44.6749_-93.2578", "55065": "44.5274_-93.0196", "55068": "44.7394_-93.1258", "55075": "44.8881_-93.046", "55076": "44.8288_-93.0391", "55077": "44.8283_-93.094", "55085": "44.6748_-92.9683", "55118": "44.8965_-93.1034", "55120": "44.8704_-93.1434", "55121": "44.8471_-93.1543", "55122": "44.786_-93.2202", "55123": "44.806_-93.1409", "55124": "44.7497_-93.2029", "55150": "44.8858_-93.1612", "55306": "44.7307_-93.2921", "55337": "44.7609_-93.2753", "55924": "44.0522_-92.9888", "55927": "44.0325_-92.8554", "55940": "43.8923_-92.8175", "55944": "44.024_-92.7464", "55955": "44.0657_-92.76", "55985": "44.152_-92.8825", "56308": "45.8817_-95.382", "56315": "45.9652_-95.5987", "56319": "45.9726_-95.3105", "56326": "46.0153_-95.6951", "56332": "45.9847_-95.5066", "56341": "45.831_-95.5416", "56343": "45.8176_-95.6945", "56354": "46.0545_-95.3258", "56355": "45.9356_-95.2398", "56360": "45.8768_-95.1332", "56013": "43.6394_-94.0924", "56014": "43.5746_-93.8211", "56023": "43.7719_-94.0225", "56025": "43.7658_-93.9011", "56027": "43.5201_-94.0984", "56033": "43.5638_-93.9361", "56047": "43.7316_-94.2375", "56051": "43.5414_-93.7102", "56068": "43.8295_-93.8282", "56097": "43.7434_-93.7321", "56098": "43.7755_-94.1632", "55922": "43.5667_-91.913", "55923": "43.8362_-92.1574", "55935": "43.7284_-92.1423", "55939": "43.5663_-92.0145", "55949": "43.7174_-91.9877", "55954": "43.5446_-91.7806", "55961": "43.5972_-92.4157", "55962": "43.7769_-91.8443", "55965": "43.6641_-92.096", "55971": "43.8216_-91.7536", "55975": "43.6823_-92.368", "55990": "43.7146_-92.2679", "56007": "43.6537_-93.3707", "56009": "43.6466_-93.5823", "56016": "43.763_-93.3232", "56020": "43.615_-93.5283", "56029": "43.5089_-93.4824", "56032": "43.7658_-93.5641", "56035": "43.8235_-93.2671", "56036": "43.5577_-93.2618", "56042": "43.804_-93.477", "56043": "43.6386_-93.2377", "56045": "43.7608_-93.2041", "56089": "43.5593_-93.4206", "55009": "44.496_-92.864", "55018": "44.4265_-92.9554", "55026": "44.52_-92.3582", "55027": "44.4022_-92.5717", "55066": "44.5528_-92.5486", "55089": "44.603_-92.7263", "55946": "44.2552_-93.0197", "55963": "44.211_-92.6613", "55983": "44.3121_-92.8103", "55992": "44.3032_-92.6719", "56248": "45.8086_-96.1434", "56274": "45.8858_-96.1342", "56309": "46.0781_-95.8214", "56311": "45.8996_-95.8754", "56339": "45.8233_-95.7955", "56531": "45.9953_-95.9671", "56590": "46.0562_-96.1144", "55111": "44.8828_-93.2007", "55305": "44.9528_-93.4372", "55311": "45.0725_-93.4558", "55316": "45.17_-93.3819", "55323": "44.953_-93.5763", "55327": "45.1982_-93.4668", "55331": "44.9007_-93.5791", "55340": "45.08_-93.576", "55343": "44.914_-93.4481", "55344": "44.8574_-93.4376", "55345": "44.9138_-93.485", "55346": "44.8771_-93.483", "55347": "44.8342_-93.4389", "55348": "45.0072_-93.6558", "55356": "44.9912_-93.5818", "55357": "45.1061_-93.6692", "55359": "44.9787_-93.7002", "55361": "44.9402_-93.5927", "55364": "44.9382_-93.6561", "55369": "45.1284_-93.4589", "55374": "45.1715_-93.5814", "55375": "44.9041_-93.749", "55384": "44.9356_-93.6341", "55391": "44.9847_-93.5422", "55392": "45.0159_-93.4719", "55401": "44.9835_-93.2683", "55402": "44.9762_-93.2759", "55403": "44.9673_-93.2828", "55404": "44.9609_-93.2642", "55405": "44.9702_-93.3047", "55406": "44.9384_-93.2214", "55407": "44.9378_-93.2545", "55408": "44.9466_-93.2862", "55409": "44.9264_-93.2818", "55410": "44.9124_-93.3188", "55411": "44.9996_-93.3005", "55412": "45.0242_-93.302", "55413": "44.998_-93.2552", "55414": "44.9779_-93.2199", "55415": "44.9742_-93.2585", "55416": "44.9497_-93.3373", "55417": "44.9054_-93.2361", "55418": "45.0192_-93.2401", "55419": "44.9026_-93.2886", "55420": "44.8358_-93.2778", "55422": "45.0096_-93.3424", "55423": "44.8756_-93.2553", "55424": "44.9052_-93.3403", "55425": "44.8427_-93.2363", "55426": "44.955_-93.3829", "55427": "45_-93.391", "55428": "45.0632_-93.3811", "55429": "45.0645_-93.3413", "55430": "45.0639_-93.3022", "55431": "44.8288_-93.3118", "55435": "44.8735_-93.3346", "55436": "44.9034_-93.374", "55437": "44.8261_-93.3538", "55438": "44.8266_-93.375", "55439": "44.8744_-93.3753", "55440": "44.98_-93.2638", "55441": "45.0058_-93.4193", "55442": "45.0467_-93.431", "55443": "45.1194_-93.3431", "55444": "45.1178_-93.3054", "55445": "45.1232_-93.3797", "55446": "45.04_-93.4865", "55447": "45.0033_-93.4875", "55450": "44.8811_-93.2207", "55454": "44.9682_-93.2429", "55455": "44.9735_-93.2331", "55458": "44.98_-93.2638", "55459": "44.98_-93.2638", "55460": "44.98_-93.2638", "55467": "44.9861_-93.2708", "55470": "44.98_-93.2638", "55472": "44.98_-93.2638", "55474": "44.98_-93.2638", "55478": "44.98_-93.2638", "55479": "44.98_-93.2638", "55480": "44.98_-93.2638", "55483": "44.98_-93.2638", "55484": "44.98_-93.2638", "55485": "44.98_-93.2638", "55486": "44.98_-93.2638", "55487": "44.98_-93.2638", "55488": "44.98_-93.2638", "55569": "45.1194_-93.4025", "55570": "45.0159_-93.4719", "55571": "45.0159_-93.4719", "55572": "45.0883_-93.7344", "55573": "45.0159_-93.4719", "55574": "45.0159_-93.4719", "55575": "45.0608_-94.0733", "55576": "45.0159_-93.4719", "55577": "45.0159_-93.4719", "55578": "45.0159_-93.4719", "55579": "45.0159_-93.4719", "55593": "45.0159_-93.4719", "55595": "45.0159_-93.4719", "55596": "45.0159_-93.4719", "55597": "45.0159_-93.4719", "55598": "45.0159_-93.4719", "55599": "45.0159_-93.4719", "55919": "43.6707_-91.3012", "55921": "43.6221_-91.4837", "55931": "43.5084_-91.4632", "55941": "43.7509_-91.3455", "55943": "43.7929_-91.5626", "55947": "43.8307_-91.3263", "55974": "43.5623_-91.6368", "56433": "47.001_-94.7234", "56436": "47.158_-94.6906", "56458": "47.215_-95.0021", "56461": "47.2368_-94.7772", "56467": "46.9319_-94.846", "56470": "46.9377_-95.0383", "55006": "45.7175_-93.2037", "55008": "45.5576_-93.2889", "55017": "45.6787_-93.4419", "55029": "45.6352_-93.1952", "55040": "45.4682_-93.2266", "55080": "45.6675_-93.2433", "55709": "47.2868_-93.3723", "55716": "47.3229_-93.2763", "55721": "47.2691_-93.6392", "55722": "47.2888_-93.4277", "55730": "47.2372_-93.5302", "55742": "47.1924_-93.1469", "55744": "47.2348_-93.5115", "55745": "47.2372_-93.5302", "55753": "47.398_-93.0784", "55764": "47.3219_-93.2939", "55769": "47.42_-93.2168", "55775": "47.3151_-93.1937", "55784": "47.0739_-93.1964", "55786": "47.3164_-93.3904", "55793": "47.1361_-93.2764", "56628": "47.7502_-93.6707", "56631": "47.543_-93.7966", "56636": "47.3829_-93.8498", "56637": "47.5888_-93.7749", "56639": "47.8472_-93.5799", "56657": "47.5485_-93.6236", "56659": "47.6147_-94.068", "56680": "47.6359_-93.922", "56681": "47.6362_-94.1475", "56688": "47.7462_-93.963", "56111": "43.5946_-94.9051", "56137": "43.7979_-95.3267", "56143": "43.6457_-94.9938", "56150": "43.6545_-95.1848", "56161": "43.723_-95.3381", "55051": "45.8958_-93.2942", "56358": "45.8476_-93.4359", "56201": "45.1393_-95.0523", "56209": "45.1116_-94.7938", "56216": "44.9501_-95.0588", "56251": "45.1426_-94.9183", "56253": "44.966_-94.9014", "56273": "45.2949_-94.948", "56279": "45.131_-95.1753", "56281": "44.9371_-95.1865", "56282": "45.0181_-95.2208", "56288": "45.2241_-94.9116", "56289": "45.3583_-95.2049", "56720": "48.5722_-96.8964", "56728": "48.7749_-96.9445", "56729": "48.6669_-96.5969", "56731": "48.9211_-97.0934", "56732": "48.5916_-96.5511", "56733": "48.6337_-96.9614", "56734": "48.7787_-96.6431", "56735": "48.9153_-96.6366", "56740": "48.9975_-97.2045", "56755": "48.9458_-97.1703", "56627": "48.156_-93.7296", "56629": "48.6247_-94.1677", "56649": "48.601_-93.411", "56653": "48.3852_-93.5399", "56654": "48.5164_-93.8407", "56658": "48.0904_-93.8292", "56660": "47.9495_-94.1467", "56661": "47.844_-94.2043", "56668": "48.613_-93.3488", "56669": "48.2463_-93.7842", "56679": "48.5866_-93.399", "56212": "45.1556_-96.3224", "56218": "44.8507_-95.9421", "56232": "44.9327_-96.0545", "56256": "44.9946_-96.1645", "56257": "44.9636_-96.4094", "55601": "47.256_-91.3566", "55603": "47.4197_-91.2096", "55607": "47.6604_-91.4989", "55609": "46.9539_-91.778", "55614": "47.3585_-91.2205", "55616": "47.0394_-91.6783", "56623": "48.6927_-94.5995", "56686": "48.8022_-94.9556", "56711": "49.3453_-95.0627", "56741": "49.3135_-94.8492", "56017": "44.3201_-93.8286", "56028": "44.2231_-93.6965", "56050": "44.2842_-93.9453", "56052": "44.3133_-93.5741", "56057": "44.3853_-93.7214", "56058": "44.4582_-93.8856", "56069": "44.4356_-93.581", "56071": "44.5402_-93.5805", "56096": "44.2238_-93.5751", "56113": "44.4091_-96.1999", "56136": "44.4995_-96.4078", "56142": "44.4633_-96.2473", "56149": "44.2782_-96.291", "56178": "44.2773_-96.1302", "56115": "44.2253_-95.8838", "56132": "44.2293_-95.7672", "56157": "44.4032_-95.9233", "56169": "44.3201_-95.9426", "56175": "44.2342_-95.6213", "56229": "44.6003_-95.6925", "56239": "44.5078_-95.8936", "56258": "44.4481_-95.7795", "56264": "44.5587_-95.9767", "56291": "44.5951_-96.0526", "55312": "44.7281_-94.3306", "55336": "44.778_-94.1616", "55350": "44.8946_-94.3847", "55354": "44.8739_-94.0551", "55370": "44.7657_-94.0506", "55381": "44.9139_-94.1974", "55385": "44.7259_-94.4516", "55395": "44.9585_-94.0552", "56516": "47.4491_-95.9454", "56557": "47.3362_-95.8856", "56566": "47.2601_-95.6283", "56589": "47.192_-95.8871", "56710": "48.202_-96.9915", "56713": "48.3314_-96.8671", "56724": "48.4104_-95.7903", "56727": "48.3071_-95.6398", "56737": "48.4426_-96.1232", "56738": "48.2895_-96.255", "56744": "48.2066_-97.1163", "56757": "48.4525_-96.8674", "56758": "48.4526_-96.4723", "56760": "48.2349_-96.4749", "56762": "48.2614_-96.7726", "56031": "43.6376_-94.451", "56039": "43.7061_-94.3307", "56075": "43.7353_-94.4357", "56088": "43.82_-94.4319", "56121": "43.5382_-94.6149", "56127": "43.5531_-94.7876", "56162": "43.8616_-94.6873", "56171": "43.6611_-94.7269", "56176": "43.7827_-94.7186", "56181": "43.6705_-94.5886", "55324": "45.1029_-94.4249", "55325": "45.1032_-94.3305", "55329": "45.302_-94.6039", "55355": "45.1263_-94.5268", "55389": "45.3087_-94.4297", "56228": "44.959_-94.6978", "56243": "45.1532_-94.6878", "55371": "45.5851_-93.5961", "56313": "45.7845_-93.5522", "56330": "45.7028_-93.6958", "56342": "46.1696_-93.4741", "56353": "45.7795_-93.6453", "56359": "46.0902_-93.6867", "56363": "45.6974_-93.6465", "56386": "46.1121_-93.4972", "56314": "45.8121_-94.4175", "56317": "45.8975_-94.0936", "56328": "45.9552_-94.535", "56338": "46.0678_-93.8812", "56344": "46.0394_-94.0633", "56345": "45.9811_-94.3604", "56364": "46.0081_-94.0853", "56373": "45.8589_-94.2211", "56382": "45.9431_-94.6289", "56384": "45.8097_-94.5755", "56388": "45.5572_-94.2242", "56443": "46.2022_-94.6185", "56466": "46.2881_-94.5638", "56475": "46.0734_-94.5005", "55909": "43.5591_-92.7305", "55912": "43.6695_-92.9784", "55918": "43.7248_-92.8738", "55926": "43.716_-92.7268", "55933": "43.6348_-92.7104", "55936": "43.7101_-92.5692", "55950": "43.7452_-92.9702", "55951": "43.5315_-92.5065", "55953": "43.5309_-92.9328", "55967": "43.79_-92.531", "55970": "43.6036_-92.8319", "55973": "43.809_-92.7595", "55977": "43.5458_-92.6335", "55982": "43.807_-92.8734", "56114": "43.9706_-95.6002", "56122": "43.9163_-95.9296", "56123": "44.0946_-95.6953", "56125": "44.0533_-95.5499", "56131": "43.8753_-95.5979", "56141": "43.9026_-95.7718", "56151": "44.0095_-95.9797", "56172": "43.9856_-95.7554", "56003": "44.2172_-94.0942", "56021": "44.2791_-94.3482", "56054": "44.4073_-94.4365", "56074": "44.2724_-94.1867", "56082": "44.3351_-93.9811", "56110": "43.6197_-95.9273", "56117": "43.5336_-95.6515", "56119": "43.7032_-95.4807", "56129": "43.5265_-96.0112", "56153": "43.8404_-96.0128", "56155": "43.7339_-95.9682", "56165": "43.7136_-95.7389", "56167": "43.562_-95.4502", "56168": "43.624_-95.7767", "56185": "43.7692_-95.8324", "56187": "43.6286_-95.6059", "56510": "47.3253_-96.5973", "56519": "47.1896_-96.553", "56541": "47.1588_-96.1309", "56545": "47.3675_-96.2152", "56548": "47.3551_-96.798", "56550": "47.2689_-96.7987", "56574": "47.1831_-96.7777", "56581": "47.4554_-96.7838", "56584": "47.2509_-96.2464", "55901": "44.0496_-92.4896", "55902": "44.0032_-92.4835", "55903": "43.9966_-92.5409", "55904": "44.0105_-92.3973", "55905": "44.0225_-92.4668", "55906": "44.1078_-92.4053", "55920": "44.0373_-92.6308", "55929": "44.0015_-92.1415", "55934": "44.0099_-92.2648", "55960": "44.1489_-92.485", "55976": "43.8555_-92.4885", "56324": "46.1738_-95.9156", "56361": "46.153_-95.3289", "56515": "46.3142_-95.7144", "56518": "46.4918_-95.2236", "56524": "46.2757_-95.6308", "56527": "46.3911_-95.3214", "56528": "46.5554_-95.7644", "56533": "46.3803_-96.1326", "56534": "46.4948_-96.0593", "56537": "46.276_-96.0904", "56538": "46.283_-96.0776", "56551": "46.3256_-95.3852", "56567": "46.5559_-95.4047", "56571": "46.4177_-95.5436", "56572": "46.5994_-96.0662", "56573": "46.6031_-95.5818", "56576": "46.4434_-95.7924", "56586": "46.3265_-95.8415", "56587": "46.6706_-95.7948", "56588": "46.2195_-95.506", "56701": "48.1191_-96.1811", "56725": "48.0686_-95.7283", "56754": "48.0109_-96.2249", "55007": "45.9474_-93.0736", "55030": "45.8566_-93.0813", "55036": "45.8712_-93.1196", "55037": "46.0189_-92.8993", "55063": "45.8363_-92.9042", "55067": "45.7575_-92.9624", "55072": "46.1325_-92.589", "55704": "46.1964_-92.7528", "55712": "46.2845_-92.619", "55735": "46.2121_-92.9389", "55756": "46.3792_-92.578", "55783": "46.3837_-92.8182", "55795": "46.2949_-92.8309", "56128": "43.8824_-96.1463", "56139": "44.0759_-96.1903", "56140": "43.9072_-96.3673", "56144": "43.8568_-96.385", "56164": "43.9893_-96.2652", "56170": "44.1682_-96.0871", "56186": "43.9873_-96.1192", "56517": "47.5721_-96.4549", "56523": "47.6837_-96.8715", "56535": "47.6618_-96.0122", "56540": "47.5361_-96.2803", "56542": "47.5816_-95.7431", "56556": "47.6522_-95.8863", "56568": "47.5373_-96.7574", "56592": "47.5375_-95.9941", "56646": "47.7697_-95.641", "56651": "47.5158_-95.6359", "56684": "47.7478_-95.7607", "56716": "47.7797_-96.5931", "56721": "47.9318_-97.0213", "56722": "47.9845_-96.6428", "56723": "47.8003_-96.8015", "56736": "47.6576_-96.1778", "56323": "45.6414_-95.7096", "56327": "45.7244_-95.6656", "56334": "45.6429_-95.3868", "56349": "45.7105_-95.5322", "56381": "45.5926_-95.5421", "56385": "45.7118_-95.2414", "55101": "44.9512_-93.0902", "55102": "44.9372_-93.1209", "55103": "44.9608_-93.1216", "55104": "44.9532_-93.158", "55105": "44.9347_-93.1651", "55106": "44.9684_-93.0488", "55107": "44.9325_-93.088", "55108": "44.9806_-93.1771", "55109": "45.0132_-93.0297", "55110": "45.08_-93.0223", "55112": "45.0788_-93.1872", "55113": "45.0139_-93.1571", "55114": "44.968_-93.1981", "55116": "44.914_-93.1727", "55117": "44.9995_-93.0969", "55119": "44.9414_-93.0107", "55126": "45.0736_-93.138", "55127": "45.0803_-93.0875", "55130": "44.973_-93.0827", "55131": "44.973_-93.0827", "55133": "45.0059_-93.1059", "55144": "45.0059_-93.1059", "55145": "44.9444_-93.0933", "55146": "44.9427_-93.0828", "55155": "44.9522_-93.0955", "55164": "44.9909_-93.1066", "55165": "45.0059_-93.1059", "55170": "44.9444_-93.0933", "55172": "45.0059_-93.1059", "55175": "45.0059_-93.1059", "55187": "45.0059_-93.1059", "55188": "45.0059_-93.1059", "56715": "47.8129_-96.0117", "56742": "47.8286_-95.8617", "56748": "47.9113_-95.9646", "56750": "47.8823_-96.2681", "56083": "44.2183_-95.1328", "56152": "44.2378_-95.2739", "56166": "44.2391_-95.3557", "56180": "44.2294_-95.4965", "56214": "44.6055_-95.3178", "56224": "44.3943_-95.0474", "56255": "44.4132_-95.4119", "56263": "44.4365_-95.5545", "56266": "44.3926_-94.9218", "56283": "44.5394_-95.1169", "56287": "44.4772_-95.3264", "56292": "44.5051_-95.4118", "56293": "44.4059_-95.2632", "56294": "44.3149_-95.213", "55310": "44.7507_-94.8716", "55314": "44.7709_-94.5912", "55332": "44.5329_-94.7256", "55333": "44.5421_-94.8931", "55342": "44.7485_-94.7058", "56230": "44.7919_-95.0972", "56270": "44.5662_-95.0268", "56277": "44.7706_-94.9727", "56284": "44.7776_-95.1989", "56285": "44.7975_-95.3538", "55019": "44.3955_-93.2037", "55021": "44.2945_-93.2818", "55046": "44.4477_-93.4252", "55052": "44.2342_-93.4525", "55053": "44.3538_-93.0855", "55057": "44.4587_-93.1668", "55087": "44.2485_-93.3949", "55088": "44.5003_-93.3826", "56116": "43.6223_-96.3698", "56134": "43.7911_-96.2161", "56138": "43.5335_-96.3645", "56146": "43.5758_-96.0945", "56147": "43.7637_-96.1089", "56156": "43.6614_-96.2216", "56158": "43.644_-96.0769", "56173": "43.5317_-96.2439", "56673": "48.8279_-95.1119", "56682": "48.8533_-95.2213", "56714": "48.7913_-96.0965", "56726": "48.6957_-96.1871", "56751": "48.7048_-95.7504", "56756": "48.8522_-95.5356", "56759": "48.5459_-96.0879", "56761": "48.6452_-95.7072", "56763": "48.9111_-95.3538", "55602": "47.3142_-91.8625", "55702": "46.9782_-92.5579", "55703": "47.7577_-92.6413", "55705": "47.4951_-92.2415", "55706": "47.7091_-91.957", "55708": "47.5328_-92.3408", "55710": "47.655_-92.6321", "55711": "46.8384_-92.643", "55713": "47.4932_-92.7643", "55717": "47.0785_-92.4594", "55719": "47.5007_-92.8617", "55723": "47.8442_-92.721", "55724": "47.1521_-92.4352", "55725": "48.2594_-92.4896", "55731": "47.9034_-91.857", "55732": "47.6658_-92.2101", "55734": "47.451_-92.528", "55736": "46.9076_-92.9167", "55738": "47.2732_-92.6756", "55741": "47.4885_-92.4025", "55746": "47.4156_-92.9356", "55747": "47.4272_-92.9377", "55750": "47.515_-92.14", "55751": "47.4115_-92.6195", "55758": "47.5121_-92.7402", "55763": "47.3416_-92.3446", "55765": "47.1021_-92.7884", "55766": "47.2496_-92.4123", "55768": "47.5133_-92.6243", "55771": "48.1439_-92.8561", "55772": "48.111_-93.0941", "55777": "47.5233_-92.5366", "55779": "46.8795_-92.3917", "55781": "47.6671_-93.0424", "55782": "47.821_-92.2464", "55790": "47.8089_-92.2878", "55791": "46.8944_-92.3646", "55792": "47.5371_-92.5285", "55796": "47.9263_-91.8007", "55801": "46.7833_-92.1066", "55802": "46.7685_-92.0865", "55803": "46.8749_-92.0941", "55804": "46.8551_-92.0074", "55805": "46.7987_-92.0946", "55806": "46.7715_-92.1279", "55807": "46.7408_-92.1698", "55808": "46.681_-92.2226", "55810": "46.7606_-92.266", "55811": "46.8147_-92.1998", "55812": "46.8106_-92.0767", "55814": "46.7833_-92.1066", "55815": "46.7833_-92.1066", "55816": "46.7833_-92.1066", "55020": "44.5647_-93.3269", "55054": "44.5647_-93.3269", "55352": "44.6713_-93.6195", "55372": "44.7107_-93.4101", "55378": "44.7615_-93.3434", "55379": "44.7793_-93.5197", "56011": "44.6139_-93.7604", "55308": "45.4365_-93.841", "55309": "45.3506_-93.7399", "55319": "45.4795_-93.9684", "55330": "45.3136_-93.5814", "55377": "45.5402_-93.8154", "55398": "45.4553_-93.5879", "55307": "44.6153_-94.0762", "55334": "44.5463_-94.1955", "55335": "44.5606_-94.5467", "55338": "44.6791_-94.0083", "55366": "44.6735_-94.2293", "55396": "44.5436_-94.3698", "56044": "44.5344_-93.9345", "55353": "45.3436_-94.3028", "56301": "45.541_-94.1819", "56302": "45.5608_-94.1625", "56303": "45.5713_-94.2036", "56304": "45.5521_-94.1284", "56307": "45.6151_-94.574", "56310": "45.6122_-94.436", "56312": "45.4865_-94.9699", "56316": "45.5011_-95.1245", "56320": "45.45_-94.4378", "56321": "45.5783_-94.4199", "56325": "45.5636_-94.9464", "56331": "45.6731_-94.6785", "56335": "45.5971_-94.8515", "56340": "45.7249_-94.4581", "56352": "45.6582_-94.8198", "56356": "45.6297_-94.7519", "56362": "45.3988_-94.7157", "56368": "45.4605_-94.5361", "56369": "45.4719_-94.3408", "56371": "45.4332_-94.6366", "56372": "45.5608_-94.1625", "56374": "45.5651_-94.3367", "56375": "45.7118_-94.2817", "56376": "45.5019_-94.6689", "56377": "45.6318_-94.2136", "56378": "45.7281_-94.9682", "56387": "45.5497_-94.2245", "56393": "45.5608_-94.1625", "56395": "45.5608_-94.1625", "56396": "45.5608_-94.1625", "56397": "45.5608_-94.1625", "56398": "45.5608_-94.1625", "56399": "45.5608_-94.1625", "55049": "44.1741_-93.2437", "55060": "44.0805_-93.2191", "55917": "43.8977_-93.0608", "56026": "43.8826_-93.3195", "56046": "43.9619_-93.276", "56207": "45.5571_-96.0498", "56221": "45.5524_-96.1733", "56235": "45.7014_-96.0649", "56244": "45.4985_-95.8008", "56267": "45.5921_-95.9172", "56208": "45.2054_-95.9949", "56215": "45.3129_-95.5766", "56226": "45.3763_-95.6787", "56231": "45.2818_-95.7219", "56249": "45.2708_-95.9164", "56252": "45.2096_-95.3115", "56271": "45.2161_-95.4049", "56318": "45.888_-94.6962", "56336": "45.8252_-94.7467", "56347": "45.9747_-94.8656", "56389": "45.7995_-95.0821", "56437": "46.2515_-95.0357", "56438": "46.0905_-94.8346", "56440": "46.1373_-94.9572", "56446": "46.117_-95.0961", "56453": "46.325_-95.0504", "56479": "46.3536_-94.7633", "56219": "45.6069_-96.8063", "56236": "45.6717_-96.4061", "56296": "45.8111_-96.4866", "56583": "46.0074_-96.3593", "55041": "44.4305_-92.2838", "55932": "44.1358_-92.2535", "55945": "44.2739_-92.1095", "55956": "44.2646_-92.5207", "55957": "44.2359_-92.2672", "55964": "44.1637_-92.1621", "55968": "44.3977_-92.0893", "55981": "44.3703_-92.0361", "55991": "44.2427_-92.4256", "56434": "46.3797_-94.9364", "56464": "46.7572_-95.0714", "56477": "46.6306_-95.0681", "56481": "46.5065_-94.9676", "56482": "46.4401_-95.1283", "56048": "44.1168_-93.7095", "56072": "43.8937_-93.4995", "56091": "43.9399_-93.7043", "56093": "44.0834_-93.5108", "55001": "44.8697_-92.8234", "55003": "45.0214_-92.7844", "55016": "44.8308_-92.9393", "55025": "45.2685_-92.9749", "55038": "45.1824_-92.9452", "55042": "44.9946_-92.9056", "55043": "44.9394_-92.7716", "55047": "45.1988_-92.8258", "55055": "44.8725_-92.9986", "55071": "44.8344_-92.9873", "55073": "45.2697_-92.8292", "55082": "45.0614_-92.8474", "55083": "45.021_-92.9837", "55090": "45.0535_-92.957", "55115": "45.071_-92.9391", "55125": "44.9197_-92.9439", "55128": "44.9913_-92.9487", "55129": "44.8985_-92.923", "56022": "44.0513_-94.838", "56056": "44.0727_-94.5795", "56060": "43.9209_-94.4289", "56062": "44.0499_-94.411", "56081": "43.9875_-94.6229", "56120": "43.9654_-94.7956", "56160": "43.8824_-94.774", "56520": "46.2797_-96.5622", "56522": "46.1402_-96.4433", "56543": "46.2584_-96.3176", "56553": "46.4378_-96.6852", "56565": "46.0537_-96.316", "56579": "46.5094_-96.2887", "56594": "46.555_-96.6149", "55910": "44.1361_-91.9745", "55925": "43.9148_-91.394", "55942": "44.02_-91.6819", "55952": "43.9702_-91.8662", "55959": "44.0832_-91.7418", "55969": "44.1025_-91.8158", "55972": "43.9585_-92.0517", "55979": "43.9587_-91.9417", "55987": "44.03_-91.7009", "55988": "44.0252_-91.7708", "55301": "45.2534_-93.6469", "55302": "45.2483_-94.1061", "55313": "45.1814_-93.8635", "55320": "45.3877_-94.0452", "55321": "45.0748_-94.1911", "55328": "45.0342_-93.8016", "55341": "45.1602_-93.6734", "55349": "45.0616_-94.0695", "55358": "45.2202_-93.9638", "55362": "45.2956_-93.8023", "55363": "45.0442_-93.9139", "55373": "45.0882_-93.7237", "55376": "45.2064_-93.6593", "55380": "45.3158_-93.9798", "55382": "45.2925_-94.2119", "55390": "45.0666_-93.9664", "55592": "45.2009_-93.8881", "56220": "44.7202_-96.2784", "56223": "44.7743_-95.8304", "56237": "44.631_-95.4182", "56241": "44.8087_-95.5516", "56245": "44.6789_-95.6825", "56280": "44.6565_-96.1581", "56297": "44.6379_-95.5409", "63501": "40.1908_-92.5856", "63533": "40.1959_-92.4333", "63540": "40.104_-92.4066", "63546": "40.3446_-92.5567", "63559": "40.2685_-92.7172", "64421": "39.9092_-94.9113", "64427": "40.1007_-94.8847", "64436": "39.8555_-94.6977", "64449": "40.0142_-94.9555", "64459": "39.9295_-94.6465", "64480": "40.0593_-94.7002", "64483": "40.0399_-94.8328", "64485": "39.9168_-94.8267", "64506": "39.7893_-94.8043", "64446": "40.3302_-95.3751", "64482": "40.4306_-95.5274", "64491": "40.4418_-95.3786", "64496": "40.478_-95.6193", "64498": "40.5357_-95.3134", "63345": "39.2742_-91.5798", "63352": "39.2425_-91.6454", "63382": "39.2949_-91.4883", "65232": "39.1209_-91.7661", "65264": "39.0968_-91.6646", "65265": "39.1712_-91.8895", "65280": "39.21_-91.7216", "65285": "39.2128_-92.0046", "64874": "36.7651_-94.0492", "65623": "36.749_-93.9064", "65625": "36.6784_-93.8467", "65641": "36.548_-93.7336", "65647": "36.6815_-93.9702", "65658": "36.5625_-93.623", "65708": "36.9212_-93.9258", "65734": "36.8069_-93.9164", "65745": "36.5276_-93.9359", "65747": "36.6167_-93.6249", "65772": "36.5807_-93.992", "64748": "37.3995_-94.1027", "64759": "37.5191_-94.3364", "64762": "37.5725_-94.5204", "64766": "37.5848_-94.1572", "64769": "37.452_-94.5756", "64720": "38.4125_-94.3683", "64722": "38.2605_-94.5734", "64723": "38.3954_-94.5763", "64730": "38.2712_-94.3137", "64742": "38.4956_-94.5928", "64745": "38.1661_-94.5075", "64752": "38.09_-94.5838", "64779": "38.0944_-94.3635", "64780": "38.0766_-94.1299", "65325": "38.4531_-93.1915", "65326": "38.1906_-93.1471", "65335": "38.5019_-93.3224", "65338": "38.4073_-93.3668", "65355": "38.2431_-93.3819", "63662": "37.4733_-90.05", "63750": "37.147_-90.1795", "63751": "37.3231_-90.0515", "63760": "37.2609_-89.9227", "63764": "37.3061_-89.9823", "63781": "37.537_-89.9272", "63782": "37.071_-90.0092", "63787": "37.1365_-90.0757", "65010": "38.7878_-92.2537", "65039": "38.7159_-92.2864", "65201": "38.9382_-92.3049", "65202": "38.995_-92.3112", "65203": "38.9348_-92.3639", "65205": "39.0447_-92.3496", "65211": "38.9517_-92.3341", "65212": "38.9376_-92.3304", "65215": "38.9532_-92.3208", "65216": "38.9517_-92.3341", "65217": "38.9517_-92.3341", "65218": "38.9517_-92.3341", "65240": "39.1961_-92.1472", "65255": "39.1054_-92.2239", "65256": "39.1203_-92.441", "65279": "38.9756_-92.5079", "65284": "39.2057_-92.2953", "65299": "38.9033_-92.1022", "64401": "39.6662_-94.717", "64440": "39.5834_-94.927", "64443": "39.7517_-94.6582", "64448": "39.5891_-94.7913", "64484": "39.5653_-95.0413", "64501": "39.7688_-94.8385", "64502": "39.7686_-94.8466", "64503": "39.734_-94.8171", "64504": "39.7076_-94.8677", "64505": "39.7965_-94.8443", "64507": "39.7551_-94.8173", "64508": "39.6763_-94.8574", "63901": "36.7662_-90.4166", "63902": "36.7125_-90.407", "63932": "36.6899_-90.2508", "63938": "36.5114_-90.267", "63940": "36.7836_-90.2168", "63945": "36.6723_-90.5583", "63954": "36.571_-90.4995", "63961": "36.5818_-90.2617", "63962": "36.8431_-90.2801", "64624": "39.5915_-93.7887", "64625": "39.7582_-93.8068", "64637": "39.5643_-93.9295", "64644": "39.7364_-93.9909", "64649": "39.7803_-94.1024", "64650": "39.6508_-94.0827", "64671": "39.5647_-94.0743", "63388": "38.8874_-91.7689", "65043": "38.6328_-92.1163", "65059": "38.6998_-91.8868", "65063": "38.71_-92.083", "65067": "38.7109_-91.7177", "65077": "38.7566_-91.7888", "65080": "38.6402_-91.9673", "65231": "39.0122_-91.8858", "65251": "38.8518_-91.9605", "65262": "38.9551_-91.952", "65020": "38.0185_-92.7677", "65049": "38.2003_-92.6684", "65052": "38.0605_-92.6831", "65065": "38.138_-92.6664", "65079": "38.1558_-92.7854", "65324": "38.1396_-92.9537", "65567": "37.8693_-92.5114", "65591": "37.9851_-92.547", "65786": "37.9616_-92.9603", "65787": "38.1025_-92.9148", "63701": "37.3169_-89.5459", "63702": "37.3506_-89.5094", "63703": "37.3059_-89.5181", "63739": "37.3632_-89.8206", "63743": "37.5151_-89.8213", "63744": "37.1967_-89.7362", "63745": "37.2424_-89.6977", "63747": "37.5669_-89.8376", "63752": "37.3092_-89.6989", "63755": "37.3879_-89.6519", "63766": "37.4401_-89.795", "63769": "37.5258_-89.7508", "63770": "37.5975_-89.703", "63779": "37.5007_-89.6396", "63785": "37.2781_-89.8061", "64622": "39.4994_-93.5374", "64623": "39.4767_-93.3335", "64633": "39.3673_-93.4926", "64639": "39.384_-93.2238", "64643": "39.5953_-93.3445", "64668": "39.3299_-93.6761", "64680": "39.4231_-93.7588", "64682": "39.5518_-93.4647", "63937": "36.9453_-90.7485", "63941": "36.9172_-91.144", "63943": "36.828_-90.7942", "63965": "37.0015_-91.0007", "64012": "38.8161_-94.5328", "64078": "38.7165_-94.4405", "64080": "38.7859_-94.244", "64083": "38.8019_-94.4529", "64090": "38.7658_-94.1609", "64701": "38.6419_-94.3285", "64725": "38.4986_-94.363", "64734": "38.6898_-94.5695", "64739": "38.5078_-94.0926", "64743": "38.6682_-94.2333", "64746": "38.6245_-94.4956", "64747": "38.5681_-94.1825", "64744": "37.8652_-94.0124", "64756": "37.6613_-94.0129", "65607": "37.7942_-93.8044", "65785": "37.7241_-93.796", "64660": "39.5828_-93.0892", "64676": "39.6627_-93.0467", "64681": "39.655_-93.2241", "65236": "39.4374_-93.1187", "65246": "39.4035_-92.9944", "65261": "39.4794_-92.9302", "65281": "39.4319_-92.8014", "65286": "39.5011_-93.1928", "65610": "37.0628_-93.5476", "65620": "36.999_-92.9692", "65629": "36.922_-93.0451", "65630": "36.8359_-93.2291", "65631": "37.0447_-93.4383", "65657": "36.8389_-93.0196", "65669": "36.9408_-93.268", "65714": "37.0512_-93.2972", "65720": "36.9404_-92.9528", "65721": "37.0169_-93.2022", "65753": "36.9775_-93.1065", "65754": "36.8636_-93.2754", "72643": "36.9404_-92.9528", "63430": "40.3445_-91.5154", "63445": "40.4266_-91.725", "63453": "40.4931_-91.8912", "63465": "40.5172_-91.6753", "63466": "40.4312_-91.6851", "63472": "40.4001_-91.5842", "63474": "40.3721_-91.9071", "64024": "39.3392_-94.2261", "64048": "39.4289_-94.3689", "64060": "39.3652_-94.3621", "64068": "39.2461_-94.4191", "64069": "39.2461_-94.4191", "64072": "39.2458_-94.2924", "64073": "39.3149_-94.2939", "64089": "39.3917_-94.5592", "64116": "39.1479_-94.568", "64117": "39.1651_-94.5256", "64118": "39.2133_-94.5743", "64119": "39.1979_-94.5199", "64144": "39.2829_-94.409", "64155": "39.2758_-94.5704", "64156": "39.2901_-94.5336", "64157": "39.2767_-94.4595", "64158": "39.2284_-94.472", "64161": "39.1661_-94.464", "64162": "39.1562_-94.4797", "64165": "39.3113_-94.5431", "64166": "39.3294_-94.5199", "64167": "39.32_-94.4877", "64429": "39.7309_-94.2437", "64454": "39.602_-94.5965", "64465": "39.5177_-94.3093", "64477": "39.5705_-94.4338", "64492": "39.4871_-94.5512", "64493": "39.6318_-94.2972", "65023": "38.6297_-92.3995", "65032": "38.3424_-92.3823", "65040": "38.3445_-92.3224", "65053": "38.5484_-92.3842", "65074": "38.5005_-92.4291", "65076": "38.3912_-92.1894", "65101": "38.5462_-92.1525", "65102": "38.5767_-92.1735", "65103": "38.5767_-92.1735", "65104": "38.5767_-92.1735", "65105": "38.5767_-92.1735", "65106": "38.5767_-92.1735", "65107": "38.5767_-92.1735", "65108": "38.5767_-92.1735", "65109": "38.5773_-92.2443", "65110": "38.5767_-92.1735", "65111": "38.5309_-92.2493", "65068": "38.8253_-92.5974", "65233": "38.9536_-92.745", "65237": "38.7881_-92.7994", "65276": "38.8712_-92.9305", "65287": "38.8983_-92.5667", "65322": "38.9727_-92.9683", "65348": "38.7161_-93.0108", "65441": "38.172_-91.2225", "65446": "37.8066_-91.2348", "65449": "37.8242_-91.5623", "65453": "38.0926_-91.4081", "65456": "37.787_-91.2116", "65535": "38.092_-91.2965", "65565": "37.8904_-91.3032", "65586": "37.8585_-91.4267", "65603": "37.5512_-93.8619", "65635": "37.5105_-93.6956", "65646": "37.3425_-93.7024", "65661": "37.4197_-93.8407", "65682": "37.386_-93.9541", "65752": "37.3743_-93.8445", "65590": "37.5808_-92.9309", "65622": "37.6429_-93.0906", "65685": "37.7542_-93.1566", "65764": "37.8392_-92.9808", "65767": "37.8523_-93.151", "65783": "37.7182_-92.9379", "64620": "39.896_-94.0897", "64636": "40.0999_-94.0252", "64640": "39.9025_-93.9787", "64642": "40.145_-93.832", "64647": "40.0046_-93.9597", "64648": "39.9837_-93.78", "64654": "39.8489_-93.7774", "64670": "40.0428_-94.1343", "64689": "39.8499_-94.1487", "64422": "39.8837_-94.5136", "64430": "39.8137_-94.5421", "64469": "39.9112_-94.3548", "64474": "39.7912_-94.3974", "64490": "39.7984_-94.5175", "64494": "39.9846_-94.5787", "64497": "39.9277_-94.2429", "65440": "37.6373_-91.2109", "65501": "37.4867_-91.571", "65532": "37.7825_-91.6788", "65541": "37.6531_-91.7613", "65560": "37.617_-91.5258", "65608": "36.9407_-92.6765", "65638": "36.9319_-92.3664", "65755": "36.8504_-92.5844", "65768": "36.9698_-92.3029", "63821": "36.0501_-90.2284", "63829": "36.0434_-90.2907", "63837": "36.4478_-89.9729", "63847": "36.4412_-90.0309", "63852": "36.3885_-90.0208", "63855": "36.0627_-90.0816", "63857": "36.2407_-90.0491", "63863": "36.5672_-89.9737", "63875": "36.0937_-90.0134", "63876": "36.1324_-90.1632", "63880": "36.3133_-90.1658", "63933": "36.5197_-90.0829", "63013": "38.4294_-91.1709", "63014": "38.6444_-91.3374", "63015": "38.4047_-90.7806", "63037": "38.3507_-91.2931", "63039": "38.503_-90.8292", "63055": "38.52_-90.877", "63056": "38.4555_-91.2328", "63060": "38.2743_-90.8903", "63061": "38.2615_-90.8027", "63068": "38.574_-91.2291", "63069": "38.4922_-90.748", "63072": "38.3816_-90.8016", "63073": "38.5792_-90.7751", "63077": "38.3299_-90.9713", "63079": "38.2745_-91.1057", "63080": "38.2307_-91.1567", "63084": "38.4456_-91.0206", "63089": "38.4601_-90.8822", "63090": "38.5459_-91.0193", "63091": "38.3853_-91.3974", "65014": "38.3074_-91.6263", "65036": "38.6703_-91.5592", "65041": "38.5876_-91.4991", "65061": "38.606_-91.658", "65062": "38.4956_-91.6515", "65066": "38.3511_-91.4867", "64402": "40.2513_-94.327", "64438": "40.1955_-94.4049", "64453": "40.3411_-94.4142", "64463": "40.0652_-94.5234", "64489": "40.2293_-94.5387", "64657": "40.1051_-94.3003", "65604": "37.316_-93.5781", "65612": "37.2214_-93.5447", "65619": "37.1634_-93.4202", "65648": "37.3721_-93.1428", "65738": "37.123_-93.48", "65757": "37.2797_-93.1066", "65765": "37.1809_-93.1555", "65770": "37.3943_-93.5044", "65781": "37.2962_-93.4259", "65801": "37.2581_-93.3437", "65802": "37.2117_-93.299", "65803": "37.2593_-93.2912", "65804": "37.1654_-93.2522", "65805": "37.2581_-93.3437", "65806": "37.2031_-93.2971", "65807": "37.1668_-93.3085", "65808": "37.2581_-93.3437", "65809": "37.1852_-93.2057", "65810": "37.1136_-93.2896", "65814": "37.2581_-93.3437", "65817": "37.2581_-93.3437", "65890": "37.2581_-93.3437", "65897": "37.1987_-93.2784", "65898": "37.2153_-93.2982", "65899": "37.1815_-93.2596", "64641": "40.144_-93.3953", "64652": "40.0144_-93.4407", "64679": "40.2439_-93.5944", "64683": "40.0823_-93.6086", "64424": "40.2601_-94.0189", "64426": "40.5024_-93.8954", "64442": "40.4912_-93.9951", "64458": "40.5219_-94.1691", "64467": "40.3662_-94.1645", "64471": "40.2444_-94.1786", "64481": "40.3999_-93.9575", "64632": "40.4578_-93.759", "64726": "38.5319_-93.9221", "64735": "38.4018_-93.785", "64740": "38.2432_-93.7303", "64770": "38.2597_-93.9952", "64788": "38.4449_-93.9785", "65323": "38.4858_-93.6459", "65360": "38.5272_-93.5269", "65634": "38.0239_-93.1978", "65668": "37.8969_-93.2979", "65724": "37.8442_-93.3356", "65732": "37.939_-93.1713", "65735": "38.0084_-93.4724", "65774": "37.8906_-93.5419", "65779": "37.9103_-93.3981", "64437": "40.1267_-95.3291", "64451": "39.9897_-95.1916", "64466": "40.1991_-95.0927", "64470": "40.1362_-95.2138", "64473": "39.9809_-95.1234", "65230": "39.2566_-92.709", "65248": "39.143_-92.6583", "65250": "39.0668_-92.8316", "65254": "39.2257_-92.8318", "65274": "39.02_-92.7386", "65548": "36.9892_-91.7099", "65626": "36.6035_-92.0678", "65688": "36.6488_-91.6976", "65775": "36.7284_-91.8717", "65777": "36.533_-91.9898", "65788": "36.8091_-91.6938", "65789": "36.8441_-91.9137", "65790": "36.7068_-92.044", "65793": "36.9958_-91.9405", "63620": "37.3981_-90.6702", "63621": "37.4871_-90.6062", "63623": "37.682_-90.7991", "63636": "37.2955_-90.6279", "63650": "37.6168_-90.5985", "63656": "37.5055_-90.845", "63663": "37.625_-90.646", "63675": "37.306_-90.7106", "65439": "37.6603_-91.1151", "65566": "37.7151_-91.1289", "64002": "38.9285_-94.3983", "64013": "39.017_-94.2816", "64014": "39.0152_-94.2604", "64015": "39.015_-94.3118", "64016": "39.1303_-94.2062", "64029": "39.0274_-94.2087", "64030": "38.8819_-94.5205", "64034": "38.8644_-94.2815", "64050": "39.0983_-94.4111", "64051": "39.0911_-94.4155", "64052": "39.075_-94.4499", "64053": "39.105_-94.4625", "64054": "39.11_-94.4401", "64055": "39.0545_-94.4039", "64056": "39.1177_-94.3596", "64057": "39.0731_-94.3533", "64058": "39.1412_-94.3515", "64063": "38.912_-94.3517", "64064": "38.9953_-94.3652", "64065": "38.9529_-94.4058", "64066": "39.1356_-94.133", "64070": "38.8918_-94.1615", "64075": "38.9985_-94.1399", "64081": "38.9142_-94.4073", "64082": "38.8518_-94.3944", "64086": "38.944_-94.2881", "64088": "39.1584_-94.1844", "64101": "39.1024_-94.5986", "64102": "39.0861_-94.6066", "64105": "39.1025_-94.5901", "64106": "39.1052_-94.5699", "64108": "39.0837_-94.5868", "64109": "39.0663_-94.5674", "64110": "39.0361_-94.5722", "64111": "39.0565_-94.5929", "64112": "39.0382_-94.5929", "64113": "39.0123_-94.5938", "64114": "38.9621_-94.5959", "64120": "39.1222_-94.5487", "64121": "39.0997_-94.5786", "64123": "39.1136_-94.5235", "64124": "39.1068_-94.5394", "64125": "39.1042_-94.4923", "64126": "39.0923_-94.5047", "64127": "39.0883_-94.5366", "64128": "39.0659_-94.5386", "64129": "39.0401_-94.4951", "64130": "39.0351_-94.5467", "64131": "38.9713_-94.5774", "64132": "38.9911_-94.5522", "64133": "39.0323_-94.47", "64134": "38.9296_-94.5009", "64136": "39.0187_-94.4008", "64137": "38.9299_-94.5405", "64138": "38.9528_-94.4705", "64139": "38.9659_-94.4061", "64141": "39.0997_-94.5786", "64145": "38.8977_-94.5976", "64146": "38.8973_-94.5764", "64147": "38.8549_-94.5568", "64148": "39.0997_-94.5786", "64149": "38.8606_-94.4636", "64170": "39.0997_-94.5786", "64171": "39.0997_-94.5786", "64179": "39.0997_-94.5786", "64180": "39.0997_-94.5786", "64184": "39.0997_-94.5786", "64187": "39.0997_-94.5786", "64188": "39.0997_-94.5786", "64191": "39.0997_-94.5786", "64196": "39.0997_-94.5786", "64197": "39.0997_-94.5786", "64198": "39.0997_-94.5786", "64199": "39.0997_-94.5786", "64999": "39.0997_-94.5786", "64755": "37.3362_-94.3013", "64801": "37.0969_-94.5051", "64802": "37.0842_-94.5133", "64803": "37.0842_-94.5133", "64804": "37.0465_-94.5103", "64830": "37.2367_-94.418", "64832": "37.2942_-94.5655", "64833": "37.1953_-94.1297", "64834": "37.1795_-94.555", "64835": "37.1507_-94.4359", "64836": "37.1597_-94.3112", "64841": "37.076_-94.4071", "64848": "37.1739_-94.0329", "64849": "37.257_-94.4444", "64855": "37.2717_-94.4865", "64857": "37.2423_-94.4352", "64859": "37.1225_-94.1613", "64862": "37.0724_-94.1151", "64870": "37.144_-94.4727", "63010": "38.4305_-90.387", "63012": "38.3384_-90.4142", "63016": "38.3573_-90.6498", "63019": "38.23_-90.3825", "63020": "38.1204_-90.5546", "63023": "38.3155_-90.6911", "63028": "38.1879_-90.4286", "63030": "38.1659_-90.7335", "63041": "38.251_-90.7901", "63047": "38.202_-90.481", "63048": "38.2625_-90.3896", "63049": "38.4728_-90.5281", "63050": "38.2586_-90.5782", "63051": "38.4131_-90.5575", "63052": "38.4069_-90.4381", "63053": "38.3653_-90.3629", "63057": "38.3419_-90.4082", "63065": "38.2489_-90.4835", "63066": "38.2809_-90.6521", "63070": "38.2799_-90.4111", "64019": "38.7897_-93.8702", "64040": "38.7186_-93.9856", "64061": "38.8178_-94.0462", "64093": "38.7667_-93.7273", "64733": "38.6126_-93.8653", "64761": "38.5831_-93.6947", "65305": "38.7318_-93.5731", "65336": "38.7667_-93.5585", "63446": "40.1384_-92.0077", "63458": "39.9931_-91.973", "63460": "40.0125_-92.2082", "63464": "39.9765_-92.0852", "63531": "40.2509_-92.2311", "63537": "40.1795_-92.1455", "63547": "40.1609_-92.2791", "65463": "37.8346_-92.7382", "65470": "37.6061_-92.3466", "65536": "37.685_-92.655", "65543": "37.5054_-92.3202", "65632": "37.5085_-92.7891", "65722": "37.5832_-92.7416", "64001": "39.1048_-93.5429", "64011": "39.0219_-94.0798", "64020": "38.9776_-93.5812", "64021": "39.1024_-93.6391", "64022": "39.1926_-93.6684", "64037": "39.0705_-93.7133", "64067": "39.1742_-93.8714", "64071": "39.0459_-93.8353", "64074": "39.114_-94.0709", "64076": "38.9829_-93.9757", "64096": "39.2055_-93.5257", "64097": "39.1258_-93.9855", "65327": "38.9717_-93.4947", "65605": "36.9709_-93.718", "65654": "37.0211_-93.8974", "65664": "37.1944_-93.6275", "65705": "37.0009_-93.6413", "65707": "37.2225_-93.8422", "65712": "37.1045_-93.7976", "65723": "36.973_-94.0024", "65756": "37.1031_-93.9543", "65769": "36.937_-93.8005", "63435": "40.1437_-91.548", "63438": "39.9625_-91.6704", "63440": "39.9962_-91.7216", "63447": "40.1164_-91.9171", "63448": "40.0391_-91.5182", "63452": "40.0867_-91.8157", "63457": "40.1184_-91.7121", "63473": "40.2491_-91.7852", "63343": "39.159_-90.816", "63347": "39.053_-90.7775", "63349": "38.9766_-91.1211", "63362": "38.9482_-90.9138", "63369": "38.9346_-90.7782", "63370": "39.0839_-91.2432", "63377": "39.1166_-91.037", "63379": "39.0012_-90.9624", "63381": "38.967_-91.2126", "63387": "39.1853_-91.0168", "63389": "38.9897_-90.8213", "63557": "39.9332_-92.916", "64628": "39.7846_-93.0719", "64630": "40.029_-93.1607", "64631": "39.8006_-92.8928", "64651": "39.7837_-93.168", "64653": "39.9099_-93.1885", "64658": "39.7125_-92.9455", "64659": "39.7795_-93.3014", "64674": "39.9529_-93.17", "64601": "39.7966_-93.5509", "64635": "39.9226_-93.4841", "64638": "39.6665_-93.5964", "64656": "39.6551_-93.7046", "64664": "39.7425_-93.7169", "64686": "39.7417_-93.6289", "64688": "39.8011_-93.3868", "64831": "36.6506_-94.4436", "64843": "36.7323_-94.3986", "64847": "36.606_-94.4551", "64854": "36.5417_-94.4906", "64856": "36.574_-94.377", "64861": "36.7175_-94.1091", "64863": "36.5319_-94.5961", "64868": "36.6684_-94.6172", "65730": "36.6237_-94.1773", "63431": "39.7428_-92.328", "63530": "39.9146_-92.475", "63532": "39.7497_-92.5619", "63534": "39.7448_-92.6351", "63538": "39.9415_-92.6424", "63539": "39.9146_-92.7664", "63549": "40.0208_-92.5077", "63552": "39.7481_-92.4622", "63558": "39.7551_-92.7695", "65247": "39.6455_-92.4757", "63645": "37.4906_-90.3362", "63655": "37.4274_-90.1741", "65013": "38.2711_-91.7303", "65443": "38.1483_-92.1015", "65580": "38.098_-91.7788", "65582": "38.1919_-91.9422", "63401": "39.7064_-91.3839", "63454": "39.9333_-91.6148", "63461": "39.7913_-91.5368", "63463": "39.8359_-91.7538", "63471": "39.9145_-91.5278", "64661": "40.5169_-93.5242", "64673": "40.3855_-93.5774", "65017": "38.0709_-92.4747", "65026": "38.3401_-92.5736", "65047": "38.1637_-92.5799", "65064": "38.4109_-92.5294", "65075": "38.2712_-92.2635", "65082": "38.2181_-92.4461", "65083": "38.1505_-92.433", "65486": "38.1219_-92.2989", "63820": "36.8259_-89.3279", "63823": "36.8927_-89.4483", "63834": "36.9213_-89.3342", "63845": "36.7776_-89.3726", "63881": "36.7392_-89.2103", "63882": "36.9092_-89.2226", "65018": "38.6224_-92.5456", "65025": "38.6432_-92.6729", "65034": "38.5667_-92.798", "65042": "38.6749_-92.6109", "65046": "38.7793_-92.4807", "65050": "38.5466_-92.6817", "65055": "38.6749_-92.6109", "65081": "38.6548_-92.7814", "63456": "39.6546_-91.723", "65258": "39.4904_-92.1318", "65263": "39.4615_-92.2287", "65275": "39.4932_-92.0113", "65282": "39.3989_-91.8294", "65283": "39.5594_-91.8297", "63333": "39.0012_-91.3489", "63350": "38.8902_-91.3715", "63351": "38.8717_-91.3019", "63359": "39.1055_-91.3873", "63361": "38.9839_-91.5085", "63363": "38.9023_-91.4909", "63384": "39.0765_-91.5645", "65069": "38.7942_-91.5737", "65011": "38.3967_-92.6686", "65037": "38.2584_-92.823", "65038": "38.1992_-92.8335", "65072": "38.2911_-92.7059", "65078": "38.4414_-92.9947", "65084": "38.4365_-92.8258", "65329": "38.6101_-92.9986", "65354": "38.6547_-92.8929", "63828": "36.7504_-89.6918", "63833": "36.6876_-89.7706", "63848": "36.4538_-89.9135", "63860": "36.6726_-89.5639", "63862": "36.5853_-89.6112", "63866": "36.519_-89.6126", "63867": "36.7154_-89.6287", "63868": "36.8504_-89.6847", "63869": "36.6073_-89.5366", "63870": "36.5856_-89.819", "63873": "36.4279_-89.7002", "63874": "36.5534_-89.8179", "63878": "36.503_-89.8224", "64840": "37.006_-94.3204", "64842": "36.8254_-94.0912", "64844": "36.9066_-94.2643", "64850": "36.8706_-94.3862", "64853": "36.8767_-94.1855", "64858": "36.901_-94.5321", "64864": "37.024_-94.4683", "64865": "36.8408_-94.5781", "64866": "36.8785_-94.1548", "64867": "36.7516_-94.2086", "64873": "37.0177_-94.0514", "64423": "40.1862_-94.8056", "64428": "40.4475_-95.063", "64431": "40.5175_-95.0055", "64432": "40.2635_-94.6687", "64433": "40.2428_-94.6869", "64434": "40.2659_-94.6915", "64445": "40.5185_-95.1236", "64455": "40.2012_-95.0121", "64457": "40.1746_-94.6951", "64461": "40.5483_-94.8189", "64468": "40.3434_-94.8735", "64475": "40.44_-94.6233", "64476": "40.4591_-94.8411", "64479": "40.3579_-94.6805", "64487": "40.2896_-95.0792", "65606": "36.6929_-91.3971", "65690": "36.5853_-91.2724", "65692": "36.6056_-91.6304", "65778": "36.5217_-91.2706", "65791": "36.5327_-91.5418", "65001": "38.2986_-92.0155", "65016": "38.5533_-91.9293", "65024": "38.6527_-91.7697", "65035": "38.3551_-91.9276", "65048": "38.3615_-92.0468", "65051": "38.4739_-91.8195", "65054": "38.4717_-91.9591", "65058": "38.25_-92.1358", "65085": "38.427_-92.0392", "65609": "36.5332_-92.1507", "65618": "36.759_-92.4026", "65637": "36.756_-92.2378", "65655": "36.5901_-92.4162", "65666": "36.5892_-92.3713", "65676": "36.5749_-92.6053", "65715": "36.7441_-92.5769", "65729": "36.5156_-92.6038", "65741": "36.7895_-92.4091", "65760": "36.5875_-92.2598", "65761": "36.583_-92.6628", "65762": "36.6875_-92.6534", "65766": "36.544_-92.2588", "65773": "36.7573_-92.5093", "65784": "36.6862_-92.3318", "63826": "36.1753_-89.8295", "63827": "36.2732_-89.8736", "63830": "36.1802_-89.6683", "63839": "36.0476_-89.8091", "63840": "36.1909_-89.8829", "63849": "36.159_-89.9349", "63851": "36.2337_-89.7495", "63853": "36.0559_-89.8709", "63877": "36.0915_-89.8346", "63879": "36.3478_-89.8181", "63732": "37.6279_-89.5745", "63737": "37.6633_-89.6529", "63746": "37.7078_-89.6948", "63748": "37.6686_-89.6619", "63775": "37.7174_-89.8737", "63776": "37.7348_-89.8116", "63783": "37.6073_-89.6798", "65301": "38.6961_-93.2323", "65302": "38.7045_-93.2283", "65332": "38.619_-93.4374", "65333": "38.9106_-93.3325", "65334": "38.8494_-93.2159", "65337": "38.7753_-93.4313", "65345": "38.5207_-93.2272", "65350": "38.66_-93.1088", "65401": "37.9485_-91.7603", "65402": "37.9514_-91.7713", "65409": "37.9514_-91.7713", "65436": "37.6158_-91.9064", "65461": "37.6603_-92.0107", "65462": "37.7365_-91.8906", "65529": "37.9262_-91.9777", "65550": "37.9008_-91.8807", "65559": "38.0056_-91.6076", "63330": "39.2558_-90.8224", "63334": "39.3346_-91.1962", "63336": "39.3465_-90.9362", "63339": "39.3257_-91.3493", "63344": "39.2431_-91.0093", "63353": "39.4336_-91.0664", "63433": "39.561_-91.1844", "63441": "39.4892_-91.3031", "64018": "39.4515_-94.7444", "64028": "39.2839_-94.8302", "64079": "39.3602_-94.789", "64092": "39.2289_-94.8057", "64098": "39.4453_-94.9145", "64150": "39.1776_-94.6321", "64151": "39.2127_-94.6383", "64152": "39.2176_-94.7238", "64153": "39.2627_-94.697", "64154": "39.2547_-94.6354", "64163": "39.3402_-94.6908", "64164": "39.3426_-94.6446", "64168": "39.3432_-94.8516", "64190": "39.3432_-94.8516", "64195": "39.3432_-94.8516", "64439": "39.5172_-94.7664", "64444": "39.4742_-94.6352", "65601": "37.5057_-93.5576", "65613": "37.6085_-93.4126", "65617": "37.4728_-93.3603", "65640": "37.7031_-93.5216", "65645": "37.4767_-93.5397", "65649": "37.6335_-93.6064", "65650": "37.7803_-93.4471", "65663": "37.6018_-93.242", "65674": "37.7923_-93.5795", "65710": "37.4686_-93.4275", "65725": "37.4615_-93.2617", "65727": "37.7292_-93.2994", "65452": "37.9446_-92.27", "65457": "37.8512_-92.0569", "65459": "37.9848_-92.0897", "65473": "37.7677_-92.112", "65534": "37.6953_-92.2808", "65556": "37.8528_-92.3962", "65583": "37.7676_-92.2105", "65584": "37.8283_-92.131", "63551": "40.5112_-92.7241", "63565": "40.4815_-92.9951", "63567": "40.4084_-92.6888", "64655": "40.4382_-93.2867", "64672": "40.5492_-93.3002", "63436": "39.5154_-91.5398", "63459": "39.5917_-91.396", "63462": "39.4207_-91.6641", "63467": "39.65_-91.2705", "65239": "39.5114_-92.44", "65243": "39.2811_-92.3427", "65244": "39.426_-92.6677", "65257": "39.3055_-92.5163", "65259": "39.4354_-92.553", "65260": "39.5791_-92.4315", "65270": "39.4202_-92.4358", "65278": "39.3414_-92.411", "64017": "39.2048_-94.0259", "64035": "39.3504_-93.8409", "64036": "39.2367_-93.9369", "64062": "39.4401_-94.1966", "64077": "39.2116_-94.1239", "64084": "39.3853_-94.0284", "64085": "39.2793_-93.9792", "63625": "37.5473_-90.9917", "63629": "37.4772_-91.1927", "63633": "37.4285_-90.9757", "63638": "37.2398_-90.9589", "63654": "37.482_-90.8425", "63665": "37.32_-90.8985", "63666": "37.4009_-91.0735", "63931": "36.661_-90.8508", "63935": "36.6501_-90.8106", "63939": "36.6704_-90.6335", "63942": "36.5626_-91.0703", "63953": "36.5843_-90.6124", "63955": "36.5874_-90.692", "63301": "38.8014_-90.5065", "63302": "38.7839_-90.4812", "63303": "38.7622_-90.5471", "63304": "38.7378_-90.6234", "63332": "38.5728_-90.8815", "63338": "38.7462_-90.654", "63341": "38.6616_-90.8302", "63346": "38.7509_-90.5368", "63348": "38.7626_-90.9343", "63365": "38.7163_-90.8751", "63366": "38.8239_-90.7427", "63367": "38.7936_-90.7854", "63368": "38.7513_-90.7296", "63373": "38.9259_-90.3863", "63376": "38.7802_-90.6228", "63385": "38.802_-90.8534", "63386": "38.8758_-90.2384", "64724": "38.1848_-94.0229", "64738": "37.881_-93.6608", "64763": "38.1404_-93.7114", "64776": "38.0286_-93.7536", "64781": "37.9728_-93.8122", "63627": "38.0451_-90.2805", "63670": "37.8655_-90.1752", "63673": "37.8325_-89.977", "63036": "37.9961_-90.4005", "63087": "37.9998_-90.4407", "63601": "37.8498_-90.4885", "63624": "37.7539_-90.5984", "63626": "38.0544_-90.6279", "63628": "37.9231_-90.5554", "63637": "37.7348_-90.4968", "63640": "37.7773_-90.4094", "63651": "37.6754_-90.3677", "63653": "37.8577_-90.5879", "63005": "38.6318_-90.6142", "63006": "38.6631_-90.5771", "63011": "38.6091_-90.5598", "63017": "38.6491_-90.5358", "63021": "38.577_-90.5255", "63022": "38.5951_-90.5462", "63024": "38.5951_-90.5462", "63025": "38.5128_-90.6306", "63026": "38.5015_-90.4683", "63031": "38.8069_-90.3401", "63032": "38.6383_-90.4271", "63033": "38.7947_-90.2831", "63034": "38.8338_-90.2936", "63038": "38.5878_-90.6639", "63040": "38.5667_-90.631", "63042": "38.7809_-90.3669", "63043": "38.7229_-90.4474", "63044": "38.7506_-90.4161", "63045": "38.7689_-90.4662", "63074": "38.7259_-90.3864", "63088": "38.5576_-90.4924", "63099": "38.6383_-90.4271", "63105": "38.6459_-90.3264", "63114": "38.7023_-90.3644", "63117": "38.6295_-90.3342", "63119": "38.5893_-90.3481", "63121": "38.7071_-90.3055", "63122": "38.5781_-90.4256", "63123": "38.5476_-90.3241", "63124": "38.6372_-90.3776", "63125": "38.5222_-90.3021", "63126": "38.5495_-90.3811", "63127": "38.5355_-90.407", "63128": "38.4915_-90.3772", "63129": "38.4566_-90.3282", "63130": "38.6669_-90.3225", "63131": "38.6171_-90.4504", "63132": "38.6746_-90.3747", "63133": "38.6779_-90.3033", "63134": "38.7435_-90.341", "63135": "38.7497_-90.3012", "63136": "38.7196_-90.27", "63137": "38.7468_-90.2131", "63138": "38.8033_-90.2065", "63140": "38.7375_-90.3265", "63141": "38.6565_-90.4542", "63143": "38.6111_-90.3225", "63144": "38.6182_-90.3489", "63145": "38.6383_-90.4271", "63146": "38.7033_-90.4618", "63151": "38.6383_-90.4271", "63167": "38.6383_-90.4271", "65320": "39.0694_-92.9487", "65321": "39.0988_-93.4281", "65330": "39.2447_-92.9932", "65339": "39.1481_-93.3776", "65340": "39.1614_-93.2444", "65344": "39.2821_-93.1968", "65347": "39.0104_-93.0311", "65349": "39.2163_-93.0547", "65351": "38.966_-93.4247", "63535": "40.5665_-92.6388", "63536": "40.4875_-92.3694", "63541": "40.5149_-92.5886", "63548": "40.5253_-92.5264", "63561": "40.4152_-92.5663", "63432": "40.4863_-92.0047", "63442": "40.4533_-92.1474", "63543": "40.3622_-92.014", "63555": "40.4619_-92.1851", "63563": "40.329_-92.0976", "63736": "37.0697_-89.5664", "63740": "37.1726_-89.6457", "63742": "37.157_-89.4484", "63758": "37.1858_-89.5575", "63767": "37.0411_-89.6076", "63771": "37.087_-89.6734", "63774": "37.0948_-89.7754", "63780": "37.2077_-89.5181", "63784": "36.9912_-89.6885", "63801": "36.8911_-89.582", "63824": "37.0042_-89.5266", "65438": "36.9476_-91.5008", "65466": "37.1626_-91.4519", "65546": "36.987_-91.5754", "65588": "37.0169_-91.3121", "63434": "39.8922_-92.0316", "63437": "39.7366_-92.253", "63439": "39.8019_-91.8606", "63443": "39.7018_-91.8832", "63450": "39.7123_-92.1489", "63451": "39.9076_-92.1947", "63468": "39.6947_-92.0371", "63469": "39.8108_-92.0498", "63730": "37.0922_-89.9106", "63735": "37.0116_-89.7984", "63738": "37.0828_-89.9523", "63822": "36.6727_-89.9878", "63825": "36.8989_-89.9456", "63841": "36.7885_-89.9639", "63846": "36.8109_-89.8366", "63850": "36.8283_-89.7565", "63936": "36.811_-90.121", "63960": "36.9422_-90.1623", "65611": "36.5493_-93.3388", "65624": "36.7311_-93.5674", "65633": "36.9258_-93.5303", "65656": "36.8198_-93.4811", "65675": "36.9305_-93.4965", "65681": "36.5767_-93.4516", "65686": "36.6393_-93.4372", "65728": "36.8759_-93.3516", "65737": "36.6907_-93.3447", "63544": "40.2703_-92.878", "63545": "40.2601_-92.9532", "63556": "40.1844_-93.1361", "63560": "40.3385_-93.1115", "63566": "40.0371_-92.9301", "64645": "40.3075_-93.3501", "64646": "40.1144_-93.3015", "64667": "40.3612_-93.3073", "65614": "36.7659_-92.9151", "65615": "36.661_-93.2358", "65616": "36.669_-93.2481", "65627": "36.571_-93.0172", "65653": "36.6955_-93.115", "65672": "36.6107_-93.2286", "65673": "36.6179_-93.2162", "65679": "36.5792_-93.1263", "65680": "36.6704_-93.0377", "65726": "36.6165_-93.2418", "65731": "36.6578_-93.1243", "65733": "36.5286_-92.8465", "65739": "36.5247_-93.2778", "65740": "36.7137_-93.1715", "65744": "36.6314_-92.9188", "65759": "36.7405_-93.028", "65771": "36.7704_-93.2148", "65444": "37.3972_-92.0465", "65464": "37.1878_-91.9134", "65468": "37.248_-91.7834", "65479": "37.2843_-91.6834", "65483": "37.3218_-91.953", "65484": "37.3538_-92.2153", "65542": "37.5091_-91.8556", "65552": "37.5122_-92.1709", "65555": "37.3569_-91.8131", "65557": "37.5156_-92.139", "65564": "37.2428_-91.9624", "65570": "37.4626_-92.0909", "65571": "37.1484_-91.6828", "65589": "37.2311_-91.8244", "65689": "37.1314_-92.1144", "64728": "37.69_-94.486", "64741": "37.8197_-94.5608", "64750": "37.953_-94.1402", "64765": "37.9975_-94.4433", "64767": "37.7446_-94.3046", "64771": "37.7476_-94.4496", "64772": "37.8409_-94.3571", "64778": "37.9061_-94.5592", "64783": "38.0094_-94.1579", "64784": "37.684_-94.2548", "64790": "37.893_-94.2293", "63342": "38.606_-90.9962", "63357": "38.6512_-91.1516", "63378": "38.6445_-91.1879", "63380": "38.8117_-91.1304", "63383": "38.805_-91.174", "63390": "38.8097_-91.0329", "63071": "38.1496_-90.831", "63622": "37.7889_-90.8613", "63630": "38.0125_-90.7439", "63631": "37.7639_-90.7409", "63648": "37.8296_-90.6984", "63660": "37.9156_-90.7193", "63664": "37.9549_-90.8415", "63674": "38.0192_-90.6529", "63632": "37.2995_-90.2693", "63763": "37.1196_-90.445", "63934": "37.2145_-90.3457", "63944": "37.1108_-90.4514", "63950": "37.1196_-90.445", "63951": "37.1343_-90.2544", "63952": "37.0675_-90.6746", "63956": "37.1884_-90.5507", "63957": "37.1573_-90.699", "63964": "37.2119_-90.4375", "63966": "36.9356_-90.2709", "63967": "36.9638_-90.4879", "65636": "37.1726_-92.8543", "65644": "37.4336_-93.021", "65652": "37.1447_-92.9111", "65706": "37.3312_-92.925", "65713": "37.3985_-92.7763", "65742": "37.131_-93.0964", "65746": "37.1667_-92.7857", "64420": "40.4855_-94.2886", "64441": "40.4181_-94.3066", "64456": "40.4924_-94.3979", "64486": "40.4928_-94.5701", "64499": "40.3939_-94.4398", "65660": "37.3262_-92.2647", "65662": "37.4947_-92.6001", "65667": "37.2735_-92.5181", "65702": "37.1049_-92.4821", "65704": "37.1273_-92.5936", "65711": "37.1626_-92.2839", "65717": "37.0687_-92.4082", "63101": "38.6346_-90.1913", "63102": "38.6352_-90.1864", "63103": "38.6332_-90.2164", "63104": "38.6128_-90.2185", "63106": "38.6442_-90.2082", "63107": "38.6645_-90.2125", "63108": "38.6445_-90.2544", "63109": "38.5855_-90.2929", "63110": "38.6185_-90.2564", "63111": "38.5633_-90.2495", "63112": "38.6616_-90.2819", "63113": "38.659_-90.2496", "63115": "38.6756_-90.2385", "63116": "38.5814_-90.2625", "63118": "38.5943_-90.2309", "63120": "38.6909_-90.2595", "63139": "38.6108_-90.292", "63147": "38.7139_-90.2375", "63150": "38.6273_-90.1979", "63155": "38.6273_-90.1979", "63156": "38.6531_-90.2435", "63157": "38.6531_-90.2435", "63158": "38.6531_-90.2435", "63160": "38.6531_-90.2435", "63163": "38.6531_-90.2435", "63164": "38.6531_-90.2435", "63166": "38.6531_-90.2435", "63169": "38.6273_-90.1979", "63171": "38.6531_-90.2435", "63177": "38.6531_-90.2435", "63178": "38.6531_-90.2435", "63179": "38.6531_-90.2435", "63180": "38.6273_-90.1979", "63182": "38.6273_-90.1979", "63188": "38.6273_-90.1979", "63195": "38.6531_-90.2435", "63197": "38.6273_-90.1979", "63199": "38.6531_-90.2435", "39120": "31.5492_-91.3642", "39121": "31.4706_-91.4044", "39122": "31.5604_-91.4032", "39165": "31.4706_-91.4044", "39190": "31.5788_-91.2993", "38834": "34.8759_-88.5916", "38835": "34.9205_-88.5218", "38846": "34.878_-88.4359", "38865": "34.7968_-88.5795", "39633": "31.291_-91.1849", "39638": "31.1903_-90.924", "39645": "31.1384_-90.7133", "39664": "31.3672_-90.6752", "39067": "33.1204_-89.4659", "39090": "33.0446_-89.5724", "39107": "33.0828_-89.6412", "39108": "33.1632_-89.3268", "39160": "33.001_-89.7552", "38603": "34.8346_-89.1427", "38633": "34.6244_-89.1862", "38647": "34.9608_-89.2267", "38720": "34.1294_-90.7382", "38725": "33.6448_-91.0338", "38726": "33.788_-90.9795", "38730": "33.6891_-90.7838", "38732": "33.743_-90.7309", "38733": "33.624_-90.8195", "38740": "34.047_-90.7652", "38746": "33.9439_-90.9319", "38759": "33.8373_-90.7256", "38762": "33.886_-90.7302", "38764": "33.7915_-90.857", "38769": "33.8432_-90.9923", "38772": "33.5629_-91.0391", "38773": "33.6021_-90.7746", "38774": "33.9491_-90.7625", "38781": "33.9101_-90.7515", "38839": "33.8562_-89.3032", "38878": "33.919_-89.1921", "38913": "34.0949_-89.4154", "38914": "33.8514_-89.4378", "38915": "34.0066_-89.3484", "38916": "33.8408_-89.3178", "38951": "33.9443_-89.3376", "38955": "33.7439_-89.3753", "39751": "33.7052_-89.1051", "38917": "33.5208_-89.9506", "38923": "33.3731_-89.9915", "38943": "33.5864_-89.8513", "38947": "33.5324_-89.9001", "38954": "33.4095_-90.1779", "39176": "33.3343_-89.757", "38850": "34.0561_-89.0531", "38851": "33.9026_-88.967", "38860": "33.9694_-88.7638", "38875": "33.9068_-88.9554", "38877": "33.9871_-88.8988", "39776": "33.8066_-89.0256", "39735": "33.3517_-89.2014", "39745": "33.2898_-89.3999", "39772": "33.2645_-89.2804", "39086": "31.9564_-90.8446", "39144": "31.851_-90.8283", "39150": "31.961_-90.984", "39330": "32.1563_-88.8474", "39347": "32.0217_-88.8851", "39355": "32.0668_-88.6788", "39360": "31.9607_-88.7168", "39363": "32.1564_-88.7748", "39741": "33.6162_-88.8267", "39754": "33.7179_-88.9478", "39755": "33.5961_-88.9518", "39773": "33.6076_-88.6503", "38614": "34.256_-90.6348", "38617": "34.3668_-90.5232", "38630": "34.2643_-90.6723", "38631": "34.3668_-90.6376", "38639": "34.3037_-90.4294", "38644": "34.4618_-90.4981", "38645": "34.2474_-90.4981", "38669": "34.1953_-90.7335", "38739": "34.0604_-90.5011", "38767": "34.1412_-90.7865", "39059": "31.9933_-90.3744", "39077": "31.9288_-90.3926", "39078": "31.8552_-90.2127", "39083": "31.8562_-90.4051", "39191": "31.6901_-90.4131", "39119": "31.7613_-89.6551", "39428": "31.6707_-89.5438", "39479": "31.5285_-89.4816", "38632": "34.8096_-90.0095", "38637": "34.9519_-90.0507", "38641": "34.8937_-90.1608", "38651": "34.8992_-90.0122", "38654": "34.9441_-89.8544", "38671": "34.9771_-89.9992", "38672": "34.9474_-89.9258", "38680": "34.9641_-90.1208", "38686": "34.9582_-90.1526", "39401": "31.3146_-89.3065", "39402": "31.3098_-89.3775", "39403": "31.3566_-89.3824", "39404": "31.1721_-89.2948", "39406": "31.1721_-89.2948", "39407": "31.1721_-89.2948", "39425": "31.0591_-89.0796", "39465": "31.3472_-89.2222", "39630": "31.4593_-90.8457", "39647": "31.4908_-90.7836", "39653": "31.4285_-90.8578", "39661": "31.504_-91.0625", "39452": "30.8668_-88.649", "39362": "31.3916_-88.5171", "39451": "31.1238_-88.5595", "39456": "31.0867_-88.7977", "39461": "31.1793_-88.7198", "38901": "33.7751_-89.8087", "38902": "33.769_-89.8084", "38926": "33.6895_-89.7583", "38929": "33.7245_-89.5754", "38940": "33.7551_-90.0333", "38960": "33.7872_-89.8219", "39520": "30.2956_-89.4632", "39521": "30.4032_-89.4982", "39522": "30.4032_-89.4982", "39525": "30.3728_-89.3779", "39529": "30.4032_-89.4982", "39556": "30.4875_-89.4187", "39558": "30.2391_-89.4595", "39572": "30.2508_-89.6011", "39576": "30.2914_-89.3837", "39501": "30.3826_-89.0976", "39502": "30.4158_-89.0684", "39503": "30.4601_-89.0886", "39505": "30.4158_-89.0684", "39506": "30.4158_-89.0684", "39507": "30.3962_-89.0353", "39530": "30.4035_-88.8971", "39531": "30.4033_-88.9605", "39532": "30.511_-88.9681", "39533": "30.396_-88.8853", "39534": "30.4067_-88.9211", "39535": "30.4158_-89.0684", "39540": "30.4383_-88.8989", "39560": "30.3598_-89.1646", "39571": "30.3989_-89.2843", "39574": "30.5961_-89.1477", "39041": "32.3778_-90.4474", "39056": "32.3411_-90.3229", "39058": "32.3415_-90.3218", "39060": "32.3113_-90.3972", "39066": "32.316_-90.5984", "39154": "32.1961_-90.4753", "39170": "32.1147_-90.3241", "39174": "32.3953_-90.1544", "39175": "32.1229_-90.6047", "39201": "32.2935_-90.1867", "39202": "32.3149_-90.1782", "39203": "32.3081_-90.2021", "39204": "32.2832_-90.2306", "39205": "32.2988_-90.1848", "39206": "32.37_-90.1738", "39207": "32.2988_-90.1848", "39209": "32.3184_-90.2446", "39210": "32.3218_-90.1771", "39211": "32.3739_-90.1293", "39212": "32.2435_-90.2612", "39213": "32.3553_-90.2171", "39215": "32.2988_-90.1848", "39216": "32.3386_-90.1708", "39217": "32.2974_-90.2081", "39225": "32.2988_-90.1848", "39236": "32.2988_-90.1848", "39250": "32.2988_-90.1848", "39269": "32.3003_-90.1886", "39271": "32.2988_-90.1848", "39272": "32.1888_-90.2595", "39282": "32.2988_-90.1848", "39283": "32.2988_-90.1848", "39284": "32.2988_-90.1848", "39286": "32.2988_-90.1848", "39289": "32.2988_-90.1848", "39296": "32.2988_-90.1848", "38924": "33.311_-90.2316", "39063": "33.0828_-89.8612", "39079": "32.9892_-89.9433", "39095": "33.125_-90.0557", "39146": "32.8905_-89.9737", "39169": "33.1624_-90.25", "39192": "33.1883_-89.7695", "38754": "33.2471_-90.604", "39038": "33.1842_-90.4924", "39097": "32.9919_-90.5893", "39115": "33.0496_-90.5734", "39166": "33.0507_-90.4928", "38745": "32.9775_-90.983", "39113": "32.9013_-91.0286", "39177": "32.6323_-90.8542", "38843": "34.2745_-88.3793", "38847": "34.4812_-88.1842", "38855": "34.3243_-88.4912", "38858": "34.0821_-88.6052", "38876": "34.2335_-88.2392", "39552": "30.4411_-88.6345", "39553": "30.398_-88.6412", "39555": "30.7132_-88.5197", "39562": "30.5471_-88.4927", "39563": "30.425_-88.5233", "39564": "30.4404_-88.7801", "39565": "30.5405_-88.6875", "39566": "30.4113_-88.8278", "39567": "30.3658_-88.5561", "39568": "30.4411_-88.6345", "39569": "30.3658_-88.5561", "39581": "30.3664_-88.5289", "39595": "30.3658_-88.5561", "39338": "32.0997_-89.2199", "39348": "32.0167_-89.0584", "39356": "32.1489_-89.0011", "39366": "31.9506_-88.9707", "39422": "31.9449_-89.2338", "39439": "31.882_-88.9981", "39460": "31.8152_-89.1778", "39481": "31.8447_-89.2621", "39069": "31.7121_-91.0582", "39081": "31.74_-91.0509", "39096": "31.8383_-91.0957", "39668": "31.7105_-90.8259", "39421": "31.5037_-89.7027", "39427": "31.4814_-89.8279", "39474": "31.6057_-89.8735", "39436": "31.4555_-89.302", "39437": "31.5797_-89.2231", "39440": "31.7054_-89.1312", "39441": "31.7277_-89.0755", "39442": "31.6823_-89.0406", "39443": "31.7138_-89.0759", "39459": "31.4836_-89.3206", "39477": "31.7909_-89.0414", "39480": "31.7594_-89.3082", "39328": "32.7162_-88.7332", "39352": "32.6368_-88.4984", "39354": "32.8826_-88.8289", "39358": "32.8402_-88.4883", "38601": "34.4719_-89.4475", "38655": "34.3308_-89.4835", "38673": "34.2849_-89.6273", "38675": "34.3582_-89.4839", "38677": "34.3659_-89.5254", "38685": "34.5476_-89.6129", "38874": "34.2265_-89.2519", "38949": "34.1787_-89.4598", "39455": "31.0013_-89.4523", "39475": "31.1496_-89.4623", "39482": "31.36_-89.5777", "39301": "32.3574_-88.656", "39302": "32.3643_-88.7037", "39303": "32.4012_-88.6523", "39304": "32.4208_-88.646", "39305": "32.4401_-88.6783", "39307": "32.3736_-88.7436", "39309": "32.5505_-88.6132", "39320": "32.4676_-88.7228", "39325": "32.5643_-88.875", "39326": "32.5511_-88.6609", "39335": "32.5022_-88.4956", "39342": "32.4245_-88.6483", "39364": "32.4296_-88.4892", "39140": "31.73_-90.0153", "39641": "31.4036_-90.1864", "39654": "31.5238_-90.128", "39656": "31.442_-89.9827", "39663": "31.5755_-90.0173", "39665": "31.6524_-90.2043", "39051": "32.7852_-89.5241", "39094": "32.6446_-89.5494", "39109": "32.6909_-89.3554", "39171": "32.864_-89.6695", "39189": "32.6134_-89.4105", "38801": "34.2538_-88.7209", "38802": "34.2345_-88.7671", "38803": "34.1876_-88.7785", "38804": "34.2823_-88.6715", "38824": "34.528_-88.6375", "38826": "34.3057_-88.8462", "38849": "34.4563_-88.6975", "38857": "34.2808_-88.595", "38862": "34.2011_-88.6335", "38866": "34.3831_-88.6674", "38868": "34.121_-88.7342", "38879": "34.1943_-88.7198", "38930": "33.5159_-90.1726", "38935": "33.5162_-90.1795", "38941": "33.4798_-90.3394", "38944": "33.7515_-90.3133", "38945": "33.6507_-90.1969", "38946": "33.3807_-90.3504", "38952": "33.6244_-90.362", "38959": "33.3809_-90.3496", "39601": "31.5858_-90.452", "39602": "31.5334_-90.4907", "39603": "31.6123_-90.4467", "39629": "31.4563_-90.4732", "39662": "31.3795_-90.2867", "39701": "33.4109_-88.5047", "39702": "33.4812_-88.3554", "39703": "33.4841_-88.284", "39704": "33.5485_-88.3796", "39705": "33.5508_-88.4865", "39710": "33.5163_-88.4601", "39736": "33.4115_-88.6443", "39743": "33.3219_-88.5671", "39753": "33.4838_-88.6409", "39766": "33.5671_-88.3278", "39045": "32.7853_-89.8698", "39046": "32.6205_-90.0061", "39071": "32.5578_-90.3235", "39110": "32.4671_-90.1087", "39130": "32.4618_-90.1154", "39157": "32.4122_-90.1207", "39158": "32.4285_-90.1323", "39163": "32.6424_-90.0907", "39429": "31.2559_-89.7998", "39478": "31.0479_-89.8183", "39483": "31.2473_-89.9311", "39643": "31.244_-90.0194", "38611": "34.8854_-89.6763", "38634": "34.7676_-89.4487", "38635": "34.7471_-89.4897", "38642": "34.9271_-89.3163", "38649": "34.9536_-89.523", "38659": "34.6047_-89.3151", "38661": "34.8937_-89.5649", "38679": "34.8708_-89.6408", "38821": "33.9844_-88.4709", "38825": "33.8698_-88.4622", "38844": "33.8742_-88.2588", "38848": "33.8871_-88.3089", "38870": "34.0648_-88.39", "39730": "33.8284_-88.538", "39740": "33.6865_-88.3145", "39746": "33.7404_-88.4112", "39756": "33.7836_-88.6642", "38925": "33.5632_-89.6419", "38967": "33.4858_-89.7277", "39747": "33.4165_-89.5696", "39767": "33.5101_-89.479", "39350": "32.7572_-89.1154", "39365": "32.6439_-89.112", "39057": "32.467_-89.269", "39323": "32.3505_-88.9551", "39327": "32.4358_-89.1168", "39332": "32.32_-89.0093", "39336": "32.2876_-89.2724", "39337": "32.5049_-88.9955", "39345": "32.3244_-89.184", "39341": "33.1027_-88.5781", "39361": "32.9769_-88.5594", "39739": "33.2346_-88.5823", "39759": "33.4505_-88.8196", "39760": "33.4599_-88.8322", "39762": "33.4156_-88.7433", "39769": "33.357_-89.0473", "38606": "34.3115_-89.9443", "38619": "34.5137_-89.9155", "38620": "34.2596_-89.9396", "38621": "34.4491_-90.1701", "38658": "34.1906_-90.0027", "38665": "34.591_-90.162", "38666": "34.4276_-89.9221", "39426": "30.6178_-89.5779", "39457": "30.6669_-89.6734", "39463": "30.5637_-89.5578", "39466": "30.5418_-89.691", "39470": "30.8524_-89.5648", "39423": "31.1693_-88.92", "39462": "31.2026_-89.0367", "39464": "31.4738_-89.0396", "39476": "31.3434_-88.9101", "39632": "31.1145_-90.4875", "39635": "31.1855_-90.449", "39648": "31.1769_-90.4016", "39649": "31.2438_-90.4532", "39652": "31.1217_-90.4831", "39657": "31.0217_-90.479", "39666": "31.2975_-90.4654", "38820": "34.1715_-89.0328", "38841": "34.3366_-89.0109", "38863": "34.217_-88.9868", "38864": "34.1617_-89.1795", "38869": "34.3575_-88.8351", "38871": "34.3136_-89.1515", "38829": "34.6694_-88.5443", "38856": "34.5011_-88.4498", "38859": "34.5315_-88.3875", "38880": "34.6126_-88.5822", "38609": "34.2351_-90.2927", "38622": "34.1731_-90.1364", "38623": "34.359_-90.2743", "38628": "34.3932_-90.2565", "38643": "34.1837_-90.263", "38646": "34.2607_-90.2816", "38964": "34.0936_-90.3752", "39042": "32.3038_-89.964", "39043": "32.269_-89.9875", "39047": "32.3886_-89.9584", "39073": "32.1535_-90.1312", "39145": "32.318_-89.7913", "39148": "32.0627_-89.9929", "39151": "32.1062_-89.7836", "39161": "32.4983_-89.8686", "39167": "32.094_-90.0462", "39193": "32.2348_-90.0726", "39208": "32.2604_-90.0897", "39218": "32.2287_-90.1591", "39232": "32.3299_-90.0915", "39288": "32.2746_-90.132", "39298": "32.3199_-89.9923", "39074": "32.347_-89.4672", "39080": "32.4925_-89.4946", "39087": "32.4706_-89.5171", "39092": "32.3459_-89.3414", "39098": "32.566_-89.7135", "39117": "32.4029_-89.5949", "39152": "32.2745_-89.5627", "39359": "32.5729_-89.3351", "38721": "32.9739_-90.8316", "38765": "33.0662_-90.8684", "39054": "32.806_-90.9268", "39061": "33.074_-90.7951", "39159": "32.8733_-90.8833", "39044": "32.0016_-89.9672", "39062": "31.9857_-89.9012", "39082": "31.9676_-90.1054", "39111": "31.8495_-89.7503", "39114": "31.9494_-89.8095", "39149": "31.8277_-90.0088", "39116": "31.8473_-89.5741", "39153": "32.0508_-89.5088", "39168": "31.8394_-89.4049", "39561": "30.6975_-89.1536", "39573": "30.7669_-89.14", "39577": "30.8609_-89.1324", "38736": "33.63_-90.5264", "38737": "33.867_-90.5406", "38738": "33.9179_-90.4965", "38749": "33.451_-90.6551", "38751": "33.451_-90.6551", "38753": "33.349_-90.6051", "38761": "33.4783_-90.5143", "38768": "33.9632_-90.4784", "38771": "33.7241_-90.5527", "38778": "33.5567_-90.5451", "38920": "33.9079_-90.0362", "38921": "33.9726_-90.1116", "38927": "34.1263_-90.0044", "38928": "33.8573_-90.288", "38950": "33.7574_-90.2091", "38957": "33.9833_-90.3895", "38958": "33.9292_-90.1885", "38962": "33.9121_-90.1806", "38963": "34.0148_-90.4318", "38966": "33.9473_-90.3443", "38602": "34.6863_-90.1068", "38618": "34.6924_-89.9869", "38638": "34.6959_-89.8288", "38668": "34.6323_-89.8855", "38610": "34.671_-89.0088", "38625": "34.6491_-88.8072", "38629": "34.8417_-88.9525", "38663": "34.7509_-88.924", "38674": "34.9029_-88.9157", "38683": "34.9527_-88.9053", "38827": "34.5102_-88.2309", "38833": "34.8579_-88.307", "38838": "34.5497_-88.2117", "38852": "34.8089_-88.1983", "38873": "34.6478_-88.2194", "38626": "34.5357_-90.3693", "38664": "34.8093_-90.3052", "38670": "34.3823_-90.209", "38676": "34.6884_-90.3685", "38627": "34.4352_-89.1767", "38650": "34.5402_-89.1157", "38652": "34.4851_-89.0031", "38828": "34.4273_-88.859", "39667": "31.1466_-90.1169", "39156": "32.4867_-90.7859", "39180": "32.3258_-90.8507", "39181": "32.3486_-90.8642", "39182": "32.3486_-90.8642", "39183": "32.386_-90.84", "38701": "33.3787_-91.0468", "38702": "33.4258_-90.9946", "38703": "33.4085_-91.0228", "38704": "33.2534_-90.9185", "38722": "33.2698_-90.8798", "38723": "33.2301_-91.0473", "38731": "33.1007_-91.0979", "38744": "33.0254_-91.0092", "38748": "33.149_-90.9041", "38756": "33.3985_-90.8839", "38760": "33.4546_-90.9943", "38776": "33.4096_-90.9104", "38780": "33.269_-91.0337", "38782": "33.5018_-91.0584", "39322": "31.5391_-88.5289", "39324": "31.5937_-88.7048", "39367": "31.6754_-88.6782", "39737": "33.6487_-89.3101", "39744": "33.5494_-89.2904", "39750": "33.5686_-89.0605", "39752": "33.5415_-89.1275", "39771": "33.607_-89.2752", "39631": "31.0893_-91.096", "39669": "31.1459_-91.3076", "39339": "33.1058_-89.0287", "39346": "32.9789_-89.1221", "38922": "33.9215_-89.6782", "38948": "34.0756_-89.8877", "38953": "33.9253_-89.891", "38961": "33.9852_-89.8945", "38965": "34.1525_-89.638", "39039": "32.8158_-90.2815", "39040": "32.7_-90.3722", "39088": "32.8415_-90.7231", "39162": "32.6125_-90.5965", "39173": "32.7628_-90.3628", "39179": "32.8015_-90.0981", "39194": "32.8594_-90.4031", "59724": "44.723_-112.6972", "59725": "45.2339_-112.6405", "59732": "45.4766_-112.6906", "59736": "45.3687_-113.3598", "59739": "44.6441_-112.5625", "59746": "45.3696_-113.1195", "59761": "45.6519_-113.4729", "59762": "45.7424_-112.9963", "59016": "45.5541_-106.8723", "59022": "45.6296_-107.4973", "59025": "45.1797_-106.8721", "59031": "45.5187_-107.4817", "59034": "45.7498_-107.6075", "59035": "45.3127_-107.9371", "59050": "45.3166_-107.3675", "59066": "45.4297_-108.5332", "59075": "45.3985_-107.8893", "59089": "45.1089_-107.4303", "59523": "48.5799_-109.2225", "59526": "48.5398_-108.7693", "59527": "47.9892_-108.6943", "59529": "48.8571_-108.6677", "59535": "47.9647_-109.2671", "59542": "48.8328_-108.3961", "59547": "48.5844_-109.0304", "59641": "46.2069_-111.6344", "59643": "46.1709_-111.5899", "59644": "46.3346_-111.4919", "59647": "46.4545_-111.651", "59007": "45.1608_-109.1571", "59008": "45.0498_-109.0788", "59013": "45.4577_-109.0665", "59014": "45.2857_-108.9082", "59026": "45.4647_-108.8524", "59029": "45.4027_-108.9057", "59041": "45.4941_-108.9922", "59068": "45.1965_-109.2688", "59070": "45.3672_-109.1769", "59071": "45.268_-109.5658", "59311": "45.1562_-104.2617", "59316": "45.268_-105.0311", "59319": "45.4361_-104.0655", "59324": "45.8805_-104.504", "59332": "45.5671_-104.5391", "59401": "47.5098_-111.2734", "59402": "47.5002_-111.3008", "59403": "47.5002_-111.3008", "59404": "47.5098_-111.3405", "59405": "47.495_-111.2502", "59406": "47.62_-111.2393", "59412": "47.3821_-110.9081", "59414": "47.5262_-111.2764", "59421": "47.2912_-111.7223", "59443": "47.5055_-111.8103", "59463": "47.0722_-110.871", "59465": "46.9391_-110.7328", "59472": "47.4021_-111.1661", "59477": "47.4958_-111.8861", "59480": "47.3217_-111.1287", "59483": "47.481_-111.7242", "59485": "47.3539_-111.5954", "59487": "47.5624_-111.577", "59420": "47.781_-110.9786", "59440": "47.6584_-111.1214", "59442": "47.924_-110.6052", "59446": "47.6024_-110.2765", "59450": "47.5816_-110.7887", "59460": "47.9546_-110.4995", "59520": "48.1497_-110.0776", "59301": "46.4075_-105.8332", "59336": "46.4132_-105.2091", "59338": "46.5708_-105.6569", "59351": "45.8428_-105.6811", "59222": "48.7472_-105.1637", "59253": "48.7808_-105.8006", "59263": "48.7854_-105.417", "59276": "48.8956_-105.1617", "59259": "47.6229_-105.017", "59315": "47.41_-104.9596", "59330": "47.1008_-104.7287", "59339": "47.2024_-105.2089", "59711": "46.1299_-112.9739", "59756": "46.1813_-112.7848", "59313": "46.3552_-104.2667", "59344": "46.4112_-104.5713", "59354": "46.1939_-104.3699", "59032": "47.0259_-108.8271", "59418": "46.8211_-109.8285", "59424": "47.3467_-110.0908", "59430": "47.3191_-109.8789", "59441": "46.9914_-109.0802", "59451": "47.2539_-109.3599", "59457": "47.0563_-109.4203", "59464": "46.9755_-109.6969", "59471": "47.3678_-108.8634", "59489": "47.6408_-109.2364", "59901": "48.2028_-114.3039", "59903": "48.2237_-114.4296", "59904": "48.2404_-114.2561", "59911": "48.0633_-114.0726", "59912": "48.3534_-114.1784", "59913": "48.4342_-114.0584", "59916": "48.278_-113.6126", "59919": "48.3858_-114.061", "59920": "48.0744_-114.5104", "59921": "48.2989_-113.9497", "59922": "48.0215_-114.2266", "59925": "48.0836_-114.7446", "59926": "48.3916_-114.0382", "59927": "48.5455_-114.592", "59928": "48.8206_-114.3836", "59932": "48.0793_-114.2355", "59936": "48.5_-113.9787", "59937": "48.404_-114.3509", "59714": "45.7801_-111.1439", "59715": "45.6693_-111.0431", "59716": "45.2847_-111.3683", "59717": "45.628_-110.9013", "59718": "45.6681_-111.2404", "59719": "45.628_-110.9013", "59730": "45.339_-111.2485", "59741": "45.798_-111.3146", "59752": "45.8811_-111.5436", "59758": "44.6621_-111.1041", "59760": "45.7827_-111.6345", "59771": "45.7246_-111.1238", "59772": "45.6361_-111.0647", "59058": "46.9005_-107.7891", "59077": "47.1008_-107.4856", "59318": "47.4253_-107.2668", "59322": "47.1263_-106.4981", "59337": "47.3208_-106.9101", "59411": "48.8788_-113.3681", "59417": "48.5569_-113.0134", "59427": "48.6603_-112.3654", "59434": "48.4457_-113.219", "59046": "46.3291_-108.9959", "59074": "46.2724_-109.2761", "59832": "46.6647_-113.2426", "59837": "46.5825_-113.2087", "59858": "46.3189_-113.3126", "59501": "48.5561_-109.688", "59521": "48.2841_-109.8205", "59525": "48.5927_-110.2836", "59528": "48.587_-110.4275", "59530": "48.593_-110.688", "59532": "48.56_-110.0513", "59540": "48.586_-110.5552", "59631": "46.3296_-112.1967", "59632": "46.2306_-112.1138", "59634": "46.4652_-111.9864", "59638": "46.3679_-112.0232", "59721": "45.8941_-111.7809", "59759": "45.8771_-112.1245", "59447": "47.2598_-110.4839", "59452": "46.9968_-109.8756", "59462": "47.0916_-109.8901", "59469": "47.2604_-110.7047", "59479": "47.1489_-110.1961", "59821": "47.186_-114.076", "59824": "47.4385_-114.1723", "59855": "47.6002_-114.119", "59860": "47.6876_-114.1404", "59863": "47.2772_-114.1807", "59864": "47.5525_-114.1054", "59865": "47.33_-114.0758", "59910": "47.7952_-114.302", "59914": "47.8607_-114.2809", "59915": "47.8305_-114.3496", "59929": "47.9404_-114.3832", "59931": "47.9182_-114.225", "59410": "47.4537_-112.3883", "59601": "46.6131_-112.0213", "59602": "46.7074_-111.958", "59604": "46.6672_-111.9689", "59620": "46.5927_-112.0361", "59623": "46.5901_-112.0402", "59624": "46.5927_-112.0361", "59625": "46.6018_-112.0413", "59626": "46.5927_-112.0361", "59633": "46.7627_-112.2795", "59635": "46.5973_-111.9051", "59636": "46.6197_-112.1099", "59639": "46.9575_-112.6651", "59640": "46.7499_-112.2994", "59648": "47.0856_-112.1476", "59522": "48.4541_-110.9798", "59531": "48.6498_-110.7914", "59545": "48.911_-111.1075", "59917": "48.8428_-115.0049", "59918": "48.7586_-114.8809", "59923": "48.3773_-115.5391", "59930": "48.9179_-115.2129", "59933": "48.6741_-114.7702", "59934": "48.7052_-114.8693", "59935": "48.4791_-115.8817", "59214": "47.2485_-105.7776", "59215": "47.4264_-105.6148", "59274": "47.832_-105.493", "59710": "45.1939_-112.0568", "59720": "45.139_-111.6508", "59729": "45.3545_-111.687", "59735": "45.7423_-111.8461", "59740": "45.408_-111.7761", "59745": "45.5323_-111.6943", "59747": "45.6585_-111.8944", "59749": "45.423_-112.1735", "59751": "45.7_-112.2535", "59754": "45.5311_-112.3495", "59755": "45.2938_-111.9461", "59053": "46.4581_-110.4324", "59642": "46.2716_-110.8072", "59645": "46.6332_-111.0506", "59820": "46.9806_-114.4921", "59830": "47.3888_-115.3479", "59842": "47.3833_-115.3996", "59866": "47.3369_-115.1703", "59867": "47.4102_-115.5096", "59872": "47.1721_-114.8885", "59801": "46.8563_-114.0252", "59802": "46.9006_-114.0027", "59803": "46.8224_-114.0265", "59804": "46.8467_-114.1698", "59806": "46.8721_-113.994", "59807": "46.9103_-113.9587", "59808": "46.9776_-114.0619", "59812": "46.8721_-113.994", "59823": "46.8733_-113.8645", "59825": "46.7673_-113.7038", "59826": "47.5097_-113.7075", "59834": "47.0471_-114.2683", "59846": "47.066_-114.4219", "59847": "46.7585_-114.1097", "59851": "46.8737_-113.8783", "59868": "47.1789_-113.481", "59054": "46.5986_-107.8692", "59059": "46.5186_-108.0912", "59072": "46.4225_-108.5438", "59073": "46.4452_-108.5418", "59018": "45.8341_-110.6222", "59020": "45.0234_-109.907", "59027": "45.2708_-110.7921", "59030": "45.0849_-110.5715", "59047": "45.6546_-110.5609", "59065": "45.3331_-110.7137", "59081": "45.0046_-109.9854", "59082": "45.7383_-110.2271", "59086": "45.9484_-110.6061", "59084": "47.0366_-108.5968", "59087": "46.9438_-108.3184", "59261": "48.6389_-107.4293", "59524": "48.395_-108.2465", "59537": "48.7983_-107.8686", "59538": "48.3692_-107.8408", "59544": "48.7595_-107.6276", "59546": "47.7698_-108.592", "59416": "48.0312_-111.755", "59425": "48.1783_-111.9397", "59432": "48.1925_-112.4995", "59448": "48.2777_-112.8456", "59456": "48.2643_-111.3886", "59486": "48.2795_-112.3033", "59062": "45.0903_-106.1499", "59314": "45.0994_-105.3383", "59317": "45.2572_-105.2568", "59343": "45.5506_-105.528", "59345": "45.7589_-105.1153", "59713": "46.5972_-112.602", "59722": "46.3881_-112.7476", "59728": "46.5034_-112.4007", "59731": "46.5948_-112.7756", "59733": "46.59_-112.9706", "59843": "46.83_-112.9413", "59854": "47.0067_-113.0905", "59326": "46.7866_-105.1161", "59341": "46.6758_-104.96", "59349": "46.829_-105.3706", "59827": "45.919_-114.059", "59828": "46.3142_-114.096", "59829": "46.028_-114.1938", "59833": "46.631_-114.0945", "59835": "46.2035_-114.1418", "59840": "46.2395_-114.1679", "59841": "46.3329_-114.2235", "59870": "46.5267_-114.0478", "59871": "45.8433_-113.8748", "59875": "46.4005_-114.1665", "59217": "47.5758_-104.2624", "59221": "47.8916_-104.2302", "59243": "47.7459_-104.5987", "59262": "47.5194_-104.2845", "59270": "47.713_-104.1634", "59201": "48.1119_-105.6293", "59212": "48.158_-104.1995", "59213": "48.2101_-104.8548", "59218": "48.1495_-104.5132", "59226": "48.3345_-104.4961", "59242": "48.435_-104.4389", "59255": "48.1307_-105.187", "59003": "45.5827_-106.2797", "59004": "45.5944_-106.2708", "59012": "45.2862_-106.5095", "59039": "46.5767_-107.3723", "59043": "45.6032_-106.5654", "59083": "46.6183_-107.5512", "59312": "46.73_-106.2011", "59323": "45.9344_-106.6368", "59327": "46.2819_-106.6991", "59333": "46.2761_-106.1967", "59347": "46.4352_-106.352", "59831": "47.3131_-114.3056", "59844": "48.0537_-115.9407", "59845": "47.5914_-114.6597", "59848": "47.7251_-114.657", "59853": "48.0768_-115.8582", "59856": "47.3878_-114.799", "59859": "47.4734_-114.893", "59873": "47.6016_-115.3602", "59874": "47.8111_-115.5592", "59211": "48.6968_-104.4529", "59219": "48.6093_-104.2401", "59247": "48.4852_-104.4375", "59252": "48.8817_-104.7415", "59254": "48.7788_-104.56", "59256": "48.8764_-104.5802", "59257": "48.728_-104.9402", "59258": "48.5905_-104.6279", "59275": "48.8587_-104.1247", "59701": "45.9979_-112.5988", "59702": "45.9053_-112.6377", "59703": "45.9053_-112.6377", "59707": "46.0038_-112.5347", "59727": "45.803_-112.809", "59743": "45.6319_-112.6845", "59748": "46.0058_-112.6861", "59750": "46.0033_-112.7159", "59001": "45.5154_-109.4692", "59019": "45.6262_-109.2571", "59028": "45.4002_-109.5821", "59057": "45.8615_-108.9731", "59061": "45.441_-109.8271", "59063": "45.6329_-108.9293", "59067": "45.9795_-109.2761", "59069": "45.7439_-109.5224", "59011": "45.8283_-109.9631", "59033": "45.7633_-109.7846", "59052": "45.5963_-109.9357", "59055": "46.104_-109.7808", "59419": "47.99_-112.2762", "59422": "47.838_-112.2021", "59433": "47.8601_-111.69", "59436": "47.6143_-112.0015", "59467": "48.0879_-112.3261", "59468": "47.6798_-111.7169", "59435": "48.5578_-112.1206", "59444": "48.8111_-111.4704", "59454": "48.7508_-111.9708", "59461": "48.4717_-111.2322", "59466": "48.74_-111.8409", "59474": "48.5037_-111.8391", "59482": "48.8516_-111.7442", "59484": "48.9961_-111.9606", "59010": "45.997_-107.31", "59038": "46.2765_-107.3072", "59076": "46.2914_-107.0967", "59223": "48.0089_-106.4486", "59225": "48.2959_-106.0324", "59230": "48.2034_-106.6094", "59231": "48.4039_-106.5428", "59240": "48.8481_-106.2495", "59241": "48.4007_-107.0098", "59244": "48.5822_-106.2835", "59248": "48.1322_-106.3564", "59250": "48.8702_-106.3658", "59260": "48.6507_-106.1192", "59273": "48.3547_-106.9098", "59036": "46.4477_-109.8435", "59078": "46.3869_-109.5974", "59085": "46.4242_-110.0712", "59453": "46.6623_-109.6755", "59353": "46.9646_-104.1897", "59002": "45.9291_-108.6888", "59006": "45.9547_-108.1231", "59015": "46.0821_-108.8091", "59024": "46.1302_-107.5958", "59037": "45.8905_-108.285", "59044": "45.6745_-108.769", "59064": "45.9838_-107.9154", "59079": "45.9461_-108.3426", "59088": "45.9779_-108.1533", "59101": "45.7745_-108.5005", "59102": "45.7813_-108.5727", "59103": "45.7833_-108.5007", "59104": "45.7833_-108.5007", "59105": "45.9497_-108.599", "59106": "45.7753_-108.6519", "59107": "45.8252_-108.3934", "59108": "45.7833_-108.5007", "59111": "45.7833_-108.5007", "59112": "45.7833_-108.5007", "59114": "45.7833_-108.5007", "59115": "45.7833_-108.5007", "59116": "45.7833_-108.5007", "59117": "45.7833_-108.5007", "27201": "36.0318_-79.4856", "27202": "36.1855_-79.5055", "27215": "36.0318_-79.4889", "27216": "36.0475_-79.4797", "27217": "36.1288_-79.4114", "27244": "36.1029_-79.5067", "27253": "36.031_-79.3814", "27258": "36.0915_-79.3642", "27302": "36.0979_-79.2719", "27340": "35.9488_-79.3297", "27349": "35.9066_-79.4279", "27359": "36.0214_-79.3574", "28636": "35.9504_-81.0487", "28678": "35.8661_-81.0641", "28681": "35.901_-81.2124", "28623": "36.5253_-80.9771", "28627": "36.4429_-81.0168", "28663": "36.5276_-81.3019", "28668": "36.3836_-81.0188", "28675": "36.5089_-81.1384", "28007": "35.1046_-80.1092", "28091": "34.9689_-79.9721", "28102": "34.8136_-79.9776", "28119": "34.8511_-80.0025", "28133": "35.0054_-80.2829", "28135": "34.9823_-80.1538", "28170": "34.9809_-80.0696", "28615": "36.45_-81.6506", "28617": "36.4641_-81.4039", "28626": "36.2814_-81.514", "28629": "36.3405_-81.3653", "28631": "36.5415_-81.4468", "28640": "36.409_-81.4396", "28643": "36.5176_-81.5269", "28644": "36.4449_-81.2606", "28672": "36.4833_-81.3276", "28684": "36.3245_-81.5874", "28693": "36.4572_-81.5465", "28694": "36.3776_-81.4872", "28604": "36.1705_-81.8412", "28616": "36.0218_-81.9296", "28622": "36.1646_-81.9639", "28646": "36.0665_-81.8704", "28652": "36.0993_-81.9871", "28653": "36.0651_-81.9017", "28657": "36.059_-81.9303", "28662": "36.0285_-81.8915", "28664": "36.0441_-82.0037", "27806": "35.3023_-76.7994", "27808": "35.4702_-76.7715", "27810": "35.4458_-76.6391", "27814": "35.382_-76.925", "27817": "35.4814_-77.0868", "27821": "35.3236_-76.8794", "27860": "35.6201_-76.6988", "27865": "35.5758_-76.8076", "27889": "35.5884_-77.1404", "27805": "36.1475_-77.1141", "27847": "36.1871_-77.1898", "27849": "36.0933_-77.1439", "27872": "36.195_-77.2602", "27924": "36.1901_-76.8548", "27957": "36.0871_-76.7776", "27967": "36.2257_-76.933", "27983": "36.0159_-76.9336", "28320": "34.5658_-78.7793", "28332": "34.6568_-78.7264", "28337": "34.6471_-78.5747", "28392": "34.7465_-78.8134", "28399": "34.7662_-78.7301", "28433": "34.503_-78.6313", "28434": "34.429_-78.4115", "28448": "34.4591_-78.2942", "28404": "34.2257_-77.9447", "28420": "34.0659_-78.5056", "28422": "34.026_-78.1681", "28451": "34.268_-78.0578", "28452": "33.9973_-78.5541", "28459": "33.9334_-78.4129", "28461": "33.9654_-78.0359", "28462": "34.0231_-78.2884", "28465": "33.9161_-78.1255", "28467": "33.9047_-78.5744", "28468": "33.8836_-78.52", "28469": "33.8913_-78.4298", "28470": "33.9637_-78.4064", "28479": "34.1553_-78.0558", "28701": "35.7064_-82.6311", "28704": "35.4637_-82.5354", "28709": "35.7748_-82.4567", "28711": "35.5986_-82.2902", "28715": "35.5376_-82.7001", "28728": "35.4988_-82.708", "28730": "35.5258_-82.3985", "28748": "35.6498_-82.7106", "28757": "35.6415_-82.3156", "28759": "35.3906_-82.568", "28770": "35.6186_-82.3005", "28776": "35.4835_-82.5207", "28778": "35.6172_-82.407", "28787": "35.7126_-82.5491", "28801": "35.5971_-82.5565", "28802": "35.6237_-82.6671", "28803": "35.5393_-82.518", "28804": "35.6374_-82.5646", "28805": "35.6004_-82.4918", "28806": "35.5808_-82.6078", "28810": "35.6203_-82.5286", "28813": "35.5004_-82.5026", "28814": "35.6648_-82.4927", "28815": "35.6203_-82.5286", "28816": "35.6203_-82.5286", "28612": "35.7429_-81.5134", "28619": "35.7579_-81.6043", "28628": "35.729_-81.7793", "28637": "35.718_-81.4194", "28641": "35.9726_-81.8948", "28647": "35.9593_-81.9429", "28655": "35.7346_-81.7042", "28666": "35.7274_-81.4706", "28671": "35.7485_-81.5226", "28680": "35.7507_-81.6953", "28690": "35.7447_-81.567", "28025": "35.3716_-80.53", "28026": "35.3463_-80.5411", "28027": "35.4141_-80.6162", "28075": "35.3247_-80.6594", "28081": "35.502_-80.6359", "28082": "35.3463_-80.5411", "28083": "35.4848_-80.6015", "28107": "35.2477_-80.5319", "28124": "35.4146_-80.4171", "28611": "35.9946_-81.7266", "28630": "35.7965_-81.4306", "28633": "35.914_-81.539", "28638": "35.8403_-81.4897", "28645": "35.9149_-81.5398", "28661": "35.9973_-81.5626", "28667": "35.7772_-81.4302", "27921": "36.325_-76.15", "27974": "36.2584_-76.0432", "27976": "36.4536_-76.3033", "28511": "34.8888_-76.3521", "28512": "34.6991_-76.7402", "28516": "34.758_-76.6228", "28520": "35.0082_-76.316", "28524": "34.7974_-76.4602", "28528": "34.7344_-76.5394", "28531": "34.6966_-76.5583", "28553": "34.7265_-76.5173", "28557": "34.7253_-76.7531", "28570": "34.7551_-76.9069", "28575": "34.6885_-76.8861", "28577": "34.8769_-76.3898", "28579": "34.7593_-76.5274", "28581": "34.8412_-76.4289", "28582": "34.7777_-77.1308", "28589": "34.7893_-76.5052", "28594": "34.6662_-77.026", "27212": "36.4664_-79.2755", "27291": "36.4151_-79.1942", "27305": "36.5158_-79.2087", "27311": "36.4899_-79.4736", "27314": "36.2932_-79.2156", "27315": "36.4873_-79.4041", "27379": "36.3907_-79.3465", "28601": "35.7576_-81.3289", "28602": "35.6884_-81.3612", "28603": "35.6799_-81.2872", "28609": "35.6757_-81.0503", "28610": "35.7211_-81.1297", "28613": "35.7313_-81.2165", "28650": "35.5759_-81.1745", "28658": "35.6498_-81.2425", "28673": "35.5962_-81.0339", "28682": "35.5836_-80.9631", "27207": "35.6129_-79.3726", "27208": "35.5673_-79.5225", "27213": "35.6482_-79.4149", "27228": "35.7835_-79.1298", "27252": "35.5643_-79.3385", "27256": "35.5604_-79.2817", "27312": "35.7694_-79.1755", "27344": "35.7354_-79.4566", "27559": "35.6306_-79.0839", "28781": "35.2151_-83.6461", "28901": "35.1959_-83.8228", "28903": "34.9917_-84.1677", "28905": "35.1475_-83.9381", "28906": "35.1312_-84.0388", "27932": "36.0908_-76.6224", "27980": "36.2502_-76.6428", "28902": "35.0261_-83.9567", "28904": "35.0417_-83.7867", "28909": "35.0024_-83.9045", "28017": "35.2543_-81.667", "28020": "35.5145_-81.6357", "28038": "35.197_-81.5386", "28042": "35.429_-81.5015", "28073": "35.1836_-81.4552", "28086": "35.2516_-81.3806", "28089": "35.3182_-81.6607", "28090": "35.4449_-81.5336", "28114": "35.2295_-81.7492", "28136": "35.3961_-81.6303", "28150": "35.312_-81.5568", "28151": "35.2924_-81.5356", "28152": "35.2689_-81.5337", "28169": "35.3615_-81.4287", "28423": "34.3091_-78.3372", "28424": "34.2907_-78.6994", "28430": "34.3025_-78.9216", "28431": "34.3223_-78.8267", "28432": "34.1761_-78.7637", "28436": "34.2838_-78.2607", "28438": "34.4204_-78.8947", "28439": "34.3023_-79.0175", "28442": "34.3181_-78.6043", "28450": "34.3394_-78.5102", "28455": "34.1153_-78.657", "28456": "34.3471_-78.2575", "28463": "34.1233_-78.8232", "28472": "34.3241_-78.716", "28519": "35.1215_-77.0208", "28523": "35.2023_-77.2963", "28526": "35.2554_-77.3646", "28527": "35.2547_-77.0502", "28532": "34.8968_-76.89", "28533": "34.9038_-76.9", "28560": "35.1204_-76.9842", "28561": "35.1037_-77.0759", "28562": "35.1004_-77.1029", "28563": "35.1109_-77.0634", "28564": "35.1109_-77.0634", "28586": "35.3063_-77.1716", "28301": "35.0743_-78.8836", "28302": "35.0343_-78.9088", "28303": "35.0742_-78.965", "28304": "35.0257_-78.9705", "28305": "35.056_-78.9047", "28306": "35.0019_-78.9364", "28307": "35.1416_-79.0025", "28308": "35.0635_-78.8943", "28309": "35.0397_-78.8429", "28310": "35.0506_-78.8038", "28311": "35.1294_-78.8982", "28312": "34.9549_-78.7408", "28314": "35.0583_-79.008", "28331": "35.0049_-78.9673", "28342": "35.1899_-78.6483", "28344": "35.1969_-78.6625", "28348": "34.9536_-78.9354", "28356": "35.2276_-78.8004", "28390": "35.183_-78.9786", "28391": "35.0347_-78.6949", "28395": "35.1606_-78.7249", "27916": "36.3045_-75.9029", "27917": "36.3588_-75.9793", "27923": "36.3751_-75.934", "27927": "36.3206_-75.8132", "27929": "36.4398_-76.0055", "27939": "36.2339_-75.8768", "27941": "36.1025_-75.8169", "27947": "36.1714_-75.8621", "27950": "36.5232_-75.9702", "27956": "36.3987_-76.0039", "27958": "36.4871_-76.1146", "27964": "36.0781_-75.7983", "27965": "36.2737_-75.9097", "27966": "36.1207_-75.8273", "27973": "36.3779_-76.0945", "27915": "35.3521_-75.5104", "27920": "35.2677_-75.5424", "27936": "35.2338_-75.6145", "27943": "35.2193_-75.6902", "27948": "36.0088_-75.6757", "27949": "36.0646_-75.7057", "27953": "35.8238_-75.8467", "27954": "35.8948_-75.6714", "27959": "35.8865_-75.6038", "27968": "35.5935_-75.4679", "27972": "35.5546_-75.4693", "27978": "35.6985_-75.7728", "27981": "35.8622_-75.6437", "27982": "35.565_-75.4663", "27239": "35.6196_-80.0959", "27292": "35.8231_-80.262", "27293": "35.8829_-80.276", "27294": "35.824_-80.2534", "27295": "35.8684_-80.315", "27299": "35.7562_-80.3749", "27351": "35.6605_-80.2836", "27360": "35.8713_-80.0913", "27361": "35.8829_-80.276", "27373": "36.0101_-80.1392", "27374": "35.9029_-80.257", "27006": "36.0065_-80.4463", "27014": "35.8104_-80.5559", "27028": "35.922_-80.537", "28325": "35.1538_-78.1053", "28341": "35.1199_-78.118", "28349": "35.0152_-77.8969", "28398": "35.018_-78.031", "28453": "34.8957_-78.0432", "28458": "34.8235_-78.0166", "28464": "34.77_-78.0221", "28466": "34.7542_-77.9429", "28508": "35.1176_-77.8515", "28518": "34.934_-77.7697", "28521": "34.8276_-77.7636", "27503": "36.1566_-78.8903", "27572": "36.2393_-78.9019", "27701": "35.9967_-78.8966", "27702": "36.0512_-78.8577", "27703": "35.9781_-78.8439", "27704": "36.0383_-78.8764", "27705": "36.0218_-78.9478", "27706": "35.997_-78.9422", "27707": "35.9631_-78.9315", "27708": "36.0287_-78.924", "27709": "36.0512_-78.8577", "27710": "36.0512_-78.8577", "27711": "36.0512_-78.8577", "27712": "36.0918_-78.9299", "27713": "35.9112_-78.9178", "27715": "36.0512_-78.8577", "27717": "36.0512_-78.8577", "27722": "35.994_-78.8986", "27801": "35.9427_-77.7608", "27802": "35.9356_-77.7808", "27809": "36.0067_-77.7074", "27819": "35.8178_-77.4533", "27852": "35.751_-77.6706", "27864": "35.7885_-77.6378", "27881": "35.9679_-77.4452", "27886": "35.8983_-77.5421", "27009": "36.2269_-80.093", "27010": "36.183_-80.3387", "27012": "36.0341_-80.3962", "27023": "36.0967_-80.4206", "27040": "36.1669_-80.3798", "27045": "36.2293_-80.2936", "27050": "36.2336_-80.3915", "27051": "36.18_-80.1629", "27094": "36.2404_-80.2934", "27098": "36.2404_-80.2934", "27099": "36.2404_-80.2934", "27101": "36.1024_-80.2228", "27102": "36.0323_-80.3962", "27103": "36.0671_-80.3025", "27104": "36.092_-80.3224", "27105": "36.144_-80.2376", "27106": "36.1428_-80.3069", "27107": "36.0403_-80.1933", "27108": "36.0275_-80.2073", "27109": "36.0275_-80.2073", "27110": "36.0275_-80.2073", "27111": "36.0999_-80.2442", "27113": "36.0999_-80.2442", "27114": "36.0999_-80.2442", "27115": "36.0999_-80.2442", "27116": "36.0999_-80.2442", "27117": "36.0275_-80.2073", "27120": "36.0999_-80.2442", "27127": "36.0425_-80.2609", "27130": "36.0275_-80.2073", "27150": "36.0275_-80.2073", "27152": "36.0275_-80.2073", "27155": "36.0275_-80.2073", "27157": "36.0275_-80.2073", "27198": "36.0275_-80.2073", "27199": "36.0999_-80.2442", "27284": "36.1165_-80.0831", "27285": "36.1199_-80.0737", "27508": "35.9577_-78.2498", "27525": "36.0955_-78.4486", "27549": "36.0578_-78.2586", "27596": "36.0249_-78.4744", "28006": "35.4069_-81.0947", "28012": "35.244_-81.044", "28016": "35.2849_-81.2863", "28021": "35.3747_-81.3509", "28032": "35.2396_-81.0831", "28034": "35.3349_-81.1862", "28035": "35.4993_-80.8486", "28052": "35.2449_-81.2194", "28053": "35.2751_-81.2134", "28054": "35.2495_-81.133", "28055": "35.284_-81.1897", "28056": "35.2172_-81.1252", "28077": "35.4041_-81.2029", "28098": "35.2655_-81.096", "28101": "35.2578_-81.0788", "28120": "35.3119_-81.0306", "28164": "35.3516_-81.0959", "27926": "36.5179_-76.5979", "27935": "36.4341_-76.8463", "27937": "36.5036_-76.7646", "27938": "36.4072_-76.7325", "27946": "36.3543_-76.6178", "27969": "36.4618_-76.8125", "27979": "36.4316_-76.6096", "28733": "35.4231_-83.7795", "28771": "35.3259_-83.7888", "27507": "36.5076_-78.5646", "27509": "36.1359_-78.7636", "27522": "36.1224_-78.6861", "27527": "35.6577_-78.3837", "27528": "35.6555_-78.4611", "27565": "36.3313_-78.6134", "27574": "36.3942_-78.9863", "27581": "36.1999_-78.7222", "27582": "36.4482_-78.5703", "27888": "35.5882_-77.6983", "28538": "35.438_-77.5656", "28554": "35.4821_-77.5861", "28580": "35.4438_-77.6956", "27214": "36.2019_-79.7101", "27233": "35.9345_-79.7019", "27235": "36.1003_-80.0103", "27249": "36.1183_-79.5685", "27260": "35.954_-79.9884", "27261": "36.0807_-80.0244", "27262": "35.9734_-80.0107", "27263": "35.9359_-79.9395", "27264": "36.0807_-80.0244", "27265": "36.0036_-80.0036", "27268": "35.9698_-79.9936", "27282": "35.999_-79.9293", "27283": "35.9543_-79.6386", "27301": "36.1163_-79.6684", "27310": "36.1673_-79.9804", "27313": "35.9522_-79.7549", "27342": "36.0756_-79.6206", "27357": "36.2552_-79.9705", "27358": "36.2245_-79.8901", "27377": "36.033_-79.5972", "27401": "36.0697_-79.7682", "27402": "36.0726_-79.792", "27403": "36.0641_-79.8202", "27404": "36.0726_-79.792", "27405": "36.1214_-79.7733", "27406": "36.022_-79.7821", "27407": "36.0334_-79.8626", "27408": "36.1064_-79.8165", "27409": "36.0777_-79.9086", "27410": "36.1032_-79.8794", "27411": "36.0726_-79.792", "27412": "36.0661_-79.8067", "27413": "36.0726_-79.792", "27415": "36.0726_-79.792", "27416": "36.0726_-79.792", "27417": "36.0726_-79.792", "27419": "36.0726_-79.792", "27420": "36.113_-79.7759", "27425": "36.0726_-79.792", "27427": "36.0726_-79.792", "27429": "36.0726_-79.792", "27435": "36.0726_-79.792", "27438": "36.0726_-79.792", "27455": "36.1824_-79.806", "27495": "36.0726_-79.792", "27497": "36.0798_-79.8282", "27498": "36.0726_-79.792", "27499": "36.0726_-79.792", "27823": "36.1973_-77.7129", "27839": "36.3049_-77.5607", "27843": "36.0594_-77.4061", "27844": "36.259_-77.9319", "27850": "36.4169_-77.8528", "27870": "36.4461_-77.6731", "27874": "36.1301_-77.4273", "27887": "36.2352_-77.5026", "27890": "36.4206_-77.6035", "27501": "35.4897_-78.7249", "27506": "35.4132_-78.7356", "27521": "35.4082_-78.6627", "27543": "35.4799_-78.8211", "27546": "35.332_-78.9212", "27552": "35.4168_-78.9334", "28323": "35.3119_-78.8405", "28334": "35.3165_-78.6151", "28335": "35.3063_-78.6089", "28339": "35.3287_-78.6859", "28368": "35.3596_-79.1097", "28716": "35.5127_-82.8413", "28721": "35.5597_-82.9216", "28738": "35.4683_-83.0028", "28745": "35.5258_-82.9704", "28751": "35.5201_-83.0929", "28785": "35.533_-82.9719", "28786": "35.5018_-82.9913", "28710": "35.4515_-82.2871", "28724": "35.3293_-82.3754", "28726": "35.2799_-82.4204", "28727": "35.394_-82.3409", "28729": "35.3172_-82.5977", "28731": "35.289_-82.3916", "28732": "35.4499_-82.4966", "28735": "35.4759_-82.3505", "28739": "35.3192_-82.5", "28742": "35.3432_-82.5565", "28758": "35.3711_-82.4938", "28760": "35.3817_-82.4813", "28784": "35.2174_-82.4178", "28790": "35.2153_-82.4574", "28791": "35.3464_-82.525", "28792": "35.3613_-82.4264", "28793": "35.2927_-82.5036", "27818": "36.5015_-77.0094", "27855": "36.4319_-77.1027", "27910": "36.2957_-76.9966", "27922": "36.3333_-76.8746", "27942": "36.2866_-76.7767", "27986": "36.3826_-76.936", "28376": "34.989_-79.2228", "27824": "35.5149_-76.0303", "27826": "35.5659_-76.2318", "27875": "35.4717_-76.4951", "27885": "35.4222_-76.2875", "27960": "35.1397_-75.8931", "28010": "35.7192_-80.8991", "28115": "35.5774_-80.8226", "28117": "35.584_-80.8685", "28123": "35.5432_-80.8473", "28166": "35.6863_-80.8822", "28625": "35.8651_-80.8858", "28634": "35.958_-80.7585", "28660": "35.9593_-80.8511", "28677": "35.799_-80.894", "28687": "35.7826_-80.8873", "28688": "35.9085_-80.8073", "28689": "36.0369_-80.8967", "28699": "35.831_-81.0076", "28707": "35.4268_-83.0851", "28717": "35.0971_-83.0871", "28723": "35.2409_-83.1475", "28725": "35.3735_-83.2592", "28736": "35.1882_-83.09", "28779": "35.3481_-83.2031", "28783": "35.2599_-83.0749", "28788": "35.3462_-83.2193", "28789": "35.4469_-83.2872", "27504": "35.4037_-78.5421", "27520": "35.6348_-78.451", "27524": "35.404_-78.4153", "27542": "35.6077_-78.1382", "27555": "35.5638_-78.2044", "27557": "35.7665_-78.2062", "27568": "35.5132_-78.2444", "27569": "35.4558_-78.1674", "27576": "35.5565_-78.264", "27577": "35.5068_-78.3479", "27593": "35.5907_-78.3607", "28522": "35.0051_-77.5231", "28555": "34.8691_-77.2315", "28573": "35.0151_-77.2287", "28585": "35.0745_-77.4595", "27237": "35.4676_-79.1653", "27330": "35.4698_-79.1717", "27331": "35.4799_-79.1803", "27332": "35.4469_-79.138", "27505": "35.4181_-79.0435", "28355": "35.3896_-79.1945", "28501": "35.2783_-77.586", "28502": "35.2627_-77.5816", "28503": "35.3191_-77.595", "28504": "35.206_-77.6576", "28525": "35.163_-77.6928", "28551": "35.3054_-77.7686", "28572": "35.0573_-77.6943", "28033": "35.421_-81.3054", "28037": "35.4837_-80.9898", "28080": "35.4657_-81.107", "28092": "35.4851_-81.1818", "28093": "35.4848_-81.2395", "28168": "35.5188_-81.4589", "28737": "35.7387_-82.0595", "28749": "35.8493_-82.0904", "28752": "35.6819_-82.018", "28761": "35.6732_-81.9056", "28762": "35.6169_-82.1686", "28734": "35.181_-83.3885", "28741": "35.0705_-83.216", "28744": "35.1823_-83.3815", "28763": "35.0515_-83.3854", "28775": "35.0311_-83.3274", "28743": "35.8082_-82.9005", "28753": "35.8597_-82.7105", "28754": "35.8528_-82.5254", "27825": "35.8349_-77.1736", "27840": "35.9446_-77.2097", "27841": "35.9086_-77.2763", "27846": "35.7839_-76.8983", "27857": "35.9597_-77.3004", "27861": "35.8165_-77.3141", "27871": "35.8218_-77.26", "27892": "35.8212_-77.1022", "28031": "35.4733_-80.8726", "28036": "35.4858_-80.794", "28070": "35.4107_-80.8429", "28078": "35.4011_-80.8695", "28104": "35.0604_-80.6958", "28105": "35.1149_-80.705", "28106": "35.26_-80.8042", "28126": "35.2768_-80.7165", "28130": "35.26_-80.8042", "28134": "35.0709_-80.8859", "28201": "35.26_-80.8042", "28202": "35.229_-80.8419", "28203": "35.2081_-80.8583", "28204": "35.2132_-80.8231", "28205": "35.22_-80.7881", "28206": "35.2522_-80.8265", "28207": "35.1935_-80.8272", "28208": "35.2358_-80.8964", "28209": "35.1796_-80.8559", "28210": "35.1316_-80.8577", "28211": "35.1677_-80.7932", "28212": "35.1908_-80.7448", "28213": "35.2836_-80.7638", "28214": "35.2731_-80.9571", "28215": "35.244_-80.7387", "28216": "35.2834_-80.8702", "28217": "35.1714_-80.9084", "28218": "35.26_-80.8042", "28219": "35.26_-80.8042", "28220": "35.26_-80.8042", "28221": "35.26_-80.8042", "28222": "35.26_-80.8042", "28223": "35.3041_-80.7267", "28224": "35.26_-80.8042", "28226": "35.0869_-80.8167", "28227": "35.1936_-80.6846", "28228": "35.26_-80.8042", "28229": "35.26_-80.8042", "28230": "35.26_-80.8042", "28231": "35.26_-80.8042", "28232": "35.26_-80.8042", "28233": "35.2271_-80.8431", "28234": "35.26_-80.8042", "28235": "35.26_-80.8042", "28236": "35.2271_-80.8431", "28237": "35.26_-80.8042", "28241": "35.2271_-80.8431", "28242": "35.26_-80.8042", "28243": "35.2271_-80.8431", "28244": "35.2271_-80.8431", "28246": "35.2275_-80.8425", "28247": "35.0656_-80.8511", "28250": "35.2271_-80.8431", "28253": "35.26_-80.8042", "28254": "35.26_-80.8042", "28255": "35.26_-80.8042", "28256": "35.26_-80.8042", "28258": "35.26_-80.8042", "28260": "35.2271_-80.8431", "28262": "35.3183_-80.7476", "28263": "35.2268_-80.8432", "28265": "35.2271_-80.8431", "28266": "35.2271_-80.8431", "28269": "35.2886_-80.8209", "28270": "35.1355_-80.7669", "28272": "35.2271_-80.8431", "28273": "35.1287_-80.9338", "28274": "35.1879_-80.8317", "28275": "35.2271_-80.8431", "28277": "35.0552_-80.8195", "28278": "35.2072_-80.9568", "28280": "35.2271_-80.8431", "28281": "35.2271_-80.8431", "28282": "35.2242_-80.8447", "28284": "35.2271_-80.8431", "28285": "35.2271_-80.8431", "28287": "35.26_-80.8042", "28288": "35.2271_-80.8431", "28289": "35.2271_-80.8431", "28290": "35.26_-80.8042", "28296": "35.2252_-80.8458", "28297": "35.26_-80.8042", "28299": "35.26_-80.8042", "28705": "36.0286_-82.1711", "28765": "35.9219_-82.1107", "28777": "35.906_-82.0705", "27209": "35.3599_-79.7798", "27229": "35.2234_-79.7876", "27247": "35.4514_-79.7834", "27306": "35.2274_-79.9871", "27356": "35.4211_-79.7826", "27371": "35.3777_-79.9093", "27242": "35.336_-79.631", "27259": "35.4921_-79.479", "27281": "35.2259_-79.6685", "27325": "35.4528_-79.582", "27376": "35.2512_-79.536", "28315": "35.1216_-79.445", "28326": "35.3106_-79.3472", "28327": "35.3061_-79.3969", "28350": "35.2438_-79.3086", "28370": "35.2162_-79.4524", "28373": "35.1007_-79.4663", "28374": "35.1884_-79.4732", "28387": "35.1697_-79.3957", "28388": "35.2803_-79.4327", "28394": "35.2171_-79.2562", "27803": "35.9238_-77.835", "27804": "35.9904_-77.8468", "27807": "35.8072_-78.0892", "27815": "35.8979_-77.7935", "27816": "36.0901_-78.0705", "27856": "35.9843_-77.9595", "27868": "36.0548_-77.9116", "27878": "35.8654_-77.8389", "27882": "35.9302_-78.1085", "27891": "36.0758_-77.7167", "28401": "34.2257_-77.9447", "28402": "34.3405_-77.9014", "28403": "34.2237_-77.8862", "28405": "34.2651_-77.867", "28406": "34.0881_-77.8526", "28407": "34.0881_-77.8526", "28408": "34.2257_-77.9447", "28409": "34.1663_-77.8723", "28410": "34.0881_-77.8526", "28411": "34.3033_-77.8039", "28412": "34.1572_-77.9141", "28428": "34.0366_-77.8963", "28429": "34.3236_-77.9108", "28449": "33.9927_-77.9099", "28480": "34.2228_-77.7932", "27820": "36.4164_-77.2502", "27831": "36.4761_-77.5719", "27832": "36.5004_-77.645", "27842": "36.5274_-77.8546", "27845": "36.3896_-77.4214", "27853": "36.5245_-77.326", "27862": "36.4937_-77.1911", "27866": "36.5212_-77.5192", "27867": "36.3632_-77.2391", "27869": "36.2773_-77.2969", "27876": "36.4886_-77.4113", "27877": "36.5152_-77.1897", "27897": "36.325_-77.2107", "28445": "34.4954_-77.555", "28460": "34.5426_-77.4038", "28539": "34.6993_-77.2079", "28540": "34.7375_-77.4628", "28541": "34.6921_-77.3912", "28542": "34.664_-77.4637", "28543": "34.7354_-77.3831", "28544": "34.727_-77.32", "28545": "34.6921_-77.3912", "28546": "34.774_-77.3781", "28547": "34.6909_-77.3614", "28574": "34.8624_-77.5863", "28584": "34.6991_-77.135", "27231": "36.202_-79.1666", "27243": "36.0912_-79.1884", "27278": "36.0756_-79.0914", "27510": "35.9055_-79.0901", "27514": "35.9203_-79.0372", "27515": "35.9132_-79.0558", "27516": "35.9162_-79.0999", "27517": "35.9182_-79.0035", "27599": "36.0525_-79.1077", "28509": "35.1449_-76.8022", "28510": "35.0055_-76.8149", "28515": "35.1526_-76.7518", "28529": "35.0668_-76.871", "28537": "35.2518_-76.5696", "28552": "35.306_-76.5777", "28556": "35.1224_-76.6719", "28571": "35.0364_-76.7015", "28583": "35.1371_-76.7406", "28587": "35.1913_-76.6604", "27906": "36.2854_-76.2133", "27907": "36.285_-76.2553", "27909": "36.2951_-76.2445", "28421": "34.5304_-78.1671", "28425": "34.5487_-77.9403", "28435": "34.4497_-78.0925", "28443": "34.3879_-77.6628", "28454": "34.6594_-77.7117", "28457": "34.4344_-77.9234", "28478": "34.6845_-78.0234", "27919": "36.3096_-76.5436", "27930": "36.1902_-76.4661", "27944": "36.1685_-76.3731", "27985": "36.2193_-76.4667", "27343": "36.5114_-79.0942", "27541": "36.2518_-79.0827", "27573": "36.4059_-78.9737", "27583": "36.2918_-78.9353", "27811": "35.5847_-77.5134", "27812": "35.7909_-77.3748", "27827": "35.6966_-77.5132", "27828": "35.5806_-77.5793", "27829": "35.674_-77.64", "27833": "35.5804_-77.3926", "27834": "35.6192_-77.3975", "27835": "35.5885_-77.3531", "27836": "35.5804_-77.3926", "27837": "35.558_-77.2566", "27858": "35.5866_-77.3485", "27879": "35.5752_-77.2786", "27884": "35.7104_-77.2722", "28513": "35.4565_-77.4051", "28530": "35.3757_-77.4193", "28590": "35.5336_-77.391", "28722": "35.2532_-82.1971", "28750": "35.2362_-82.2362", "28756": "35.3338_-82.1557", "28773": "35.2383_-82.3306", "28782": "35.2157_-82.2394", "27203": "35.7323_-79.7893", "27204": "35.7883_-79.7206", "27205": "35.6396_-79.8509", "27230": "35.8028_-79.8797", "27248": "35.7917_-79.7132", "27298": "35.8729_-79.5821", "27316": "35.7143_-79.6469", "27317": "35.8488_-79.8018", "27341": "35.5283_-79.6979", "27350": "35.8298_-79.8986", "27355": "35.796_-79.5514", "27370": "35.8429_-79.9902", "28330": "34.9129_-79.822", "28338": "35.0914_-79.7524", "28345": "34.8894_-79.7022", "28347": "35.0326_-79.56", "28363": "34.9882_-79.5823", "28367": "35.1704_-79.7228", "28379": "34.9336_-79.7666", "28380": "34.9942_-79.7673", "28271": "35.216_-80.8358", "28319": "34.4088_-79.0467", "28340": "34.472_-79.1407", "28357": "34.8762_-79.0664", "28358": "34.6293_-79.0083", "28359": "34.6077_-79.0144", "28360": "34.6697_-79.1084", "28362": "34.3791_-79.1279", "28364": "34.7334_-79.3097", "28369": "34.4473_-79.031", "28371": "34.9006_-78.9969", "28372": "34.6902_-79.1834", "28375": "34.4713_-79.0414", "28377": "34.8083_-79.1636", "28378": "34.8543_-79.0642", "28383": "34.5887_-79.2618", "28384": "34.801_-78.9731", "28386": "34.8988_-79.1806", "27025": "36.3695_-79.9654", "27027": "36.4277_-79.9567", "27048": "36.4705_-79.9013", "27288": "36.5_-79.759", "27289": "36.3921_-79.7731", "27320": "36.3432_-79.6642", "27323": "36.3921_-79.7731", "27326": "36.4428_-79.5606", "27375": "36.3921_-79.7731", "27013": "35.7374_-80.7113", "27054": "35.7901_-80.6051", "28023": "35.5669_-80.59", "28039": "35.6805_-80.4354", "28041": "35.5817_-80.4581", "28071": "35.5498_-80.3346", "28072": "35.6109_-80.4361", "28088": "35.5435_-80.6129", "28125": "35.6389_-80.7239", "28138": "35.5494_-80.4226", "28144": "35.6515_-80.4889", "28145": "35.6827_-80.4771", "28146": "35.6187_-80.4022", "28147": "35.6817_-80.5615", "28159": "35.6917_-80.4327", "28018": "35.4533_-81.8118", "28019": "35.281_-81.7962", "28024": "35.2416_-81.7755", "28040": "35.3344_-81.7707", "28043": "35.325_-81.846", "28074": "35.2247_-81.8851", "28076": "35.2579_-81.7962", "28139": "35.3706_-81.9781", "28160": "35.3601_-81.9251", "28167": "35.4732_-81.9685", "28720": "35.4369_-82.2417", "28746": "35.4464_-82.1752", "28318": "35.0997_-78.6021", "28328": "35.0151_-78.326", "28329": "34.9979_-78.3233", "28366": "35.2301_-78.3594", "28382": "34.9639_-78.5133", "28385": "35.0515_-78.4714", "28393": "34.9857_-78.2121", "28441": "34.7897_-78.4309", "28444": "34.6769_-78.243", "28447": "34.6233_-78.2342", "28343": "34.7549_-79.5839", "28351": "34.8238_-79.5491", "28352": "34.7599_-79.4673", "28353": "34.7818_-79.4824", "28396": "34.9044_-79.3959", "28001": "35.3573_-80.2044", "28002": "35.3501_-80.2001", "28009": "35.406_-80.1167", "28097": "35.2704_-80.4211", "28109": "35.4849_-80.2884", "28127": "35.4285_-80.2057", "28128": "35.2275_-80.1433", "28129": "35.246_-80.3413", "28137": "35.4541_-80.2838", "28163": "35.2106_-80.4407", "27016": "36.4559_-80.2194", "27019": "36.2725_-80.2254", "27021": "36.295_-80.356", "27022": "36.5132_-80.2103", "27042": "36.3482_-80.0495", "27043": "36.3339_-80.4391", "27046": "36.49_-80.0859", "27052": "36.3189_-80.1484", "27007": "36.3859_-80.5895", "27017": "36.3698_-80.7101", "27024": "36.503_-80.7889", "27030": "36.5007_-80.6119", "27031": "36.3994_-80.7081", "27041": "36.4109_-80.4921", "27047": "36.3002_-80.5772", "27049": "36.5004_-80.6265", "27053": "36.4674_-80.3677", "28621": "36.2872_-80.8554", "28676": "36.3422_-80.8653", "28702": "35.3698_-83.5652", "28713": "35.4241_-83.4392", "28719": "35.5094_-83.3144", "28708": "35.2298_-82.8779", "28712": "35.2208_-82.7404", "28718": "35.1508_-82.6374", "28747": "35.1451_-82.9191", "28766": "35.2524_-82.6222", "28768": "35.2599_-82.6695", "28772": "35.1437_-82.8212", "28774": "35.0666_-83.0019", "27925": "35.9057_-76.2345", "28079": "35.0831_-80.6597", "28103": "35.0167_-80.3781", "28108": "34.9379_-80.6687", "28110": "35.0178_-80.5372", "28111": "35.0112_-80.5587", "28112": "34.8946_-80.554", "28173": "34.9251_-80.7278", "28174": "34.9847_-80.4476", "27536": "36.3301_-78.3981", "27537": "36.36_-78.3906", "27544": "36.2042_-78.4241", "27553": "36.4603_-78.2952", "27556": "36.3996_-78.3225", "27584": "36.4946_-78.4236", "27502": "35.7225_-78.8408", "27511": "35.7641_-78.7786", "27512": "35.8084_-78.8395", "27513": "35.7956_-78.7941", "27518": "35.7299_-78.7735", "27519": "35.8072_-78.887", "27523": "35.7225_-78.8408", "27526": "35.58_-78.7908", "27529": "35.6813_-78.5975", "27539": "35.7225_-78.8408", "27540": "35.6263_-78.8458", "27545": "35.7789_-78.4898", "27560": "35.8344_-78.8466", "27562": "35.6809_-78.9365", "27571": "35.9156_-78.4658", "27587": "35.9815_-78.5392", "27588": "35.9731_-78.4508", "27591": "35.798_-78.3926", "27592": "35.547_-78.6717", "27597": "35.8321_-78.3174", "27601": "35.7727_-78.6324", "27602": "35.7587_-78.6711", "27603": "35.7076_-78.6563", "27604": "35.8334_-78.5799", "27605": "35.7908_-78.653", "27606": "35.7645_-78.7112", "27607": "35.8014_-78.6877", "27608": "35.8077_-78.6463", "27609": "35.848_-78.6317", "27610": "35.7667_-78.6008", "27611": "35.7977_-78.6253", "27612": "35.852_-78.6841", "27613": "35.8949_-78.7051", "27614": "35.9457_-78.6433", "27615": "35.8887_-78.6393", "27616": "35.8673_-78.5381", "27617": "35.9034_-78.7447", "27619": "35.8515_-78.6314", "27620": "35.7977_-78.6253", "27621": "35.7977_-78.6253", "27622": "35.7977_-78.6253", "27623": "35.7977_-78.6253", "27624": "35.7977_-78.6253", "27625": "35.7977_-78.6253", "27626": "35.7977_-78.6253", "27627": "35.7977_-78.6253", "27628": "35.7977_-78.6253", "27629": "35.8175_-78.5524", "27634": "35.7977_-78.6253", "27635": "35.7977_-78.6253", "27636": "35.7977_-78.6253", "27640": "35.7977_-78.6253", "27650": "35.7977_-78.6253", "27656": "35.7977_-78.6253", "27658": "35.7977_-78.6253", "27661": "35.7977_-78.6253", "27668": "35.7977_-78.6253", "27675": "35.7977_-78.6253", "27676": "35.7977_-78.6253", "27690": "35.7977_-78.6253", "27695": "35.7977_-78.6253", "27697": "35.7721_-78.6386", "27698": "35.7977_-78.6253", "27699": "35.7977_-78.6253", "27551": "36.507_-77.9975", "27563": "36.4754_-78.1895", "27570": "36.4357_-78.2367", "27586": "36.4265_-78.0036", "27589": "36.3539_-78.1594", "27594": "36.4865_-78.1708", "27928": "35.8653_-76.4196", "27962": "35.8508_-76.7431", "27970": "35.8994_-76.5809", "28605": "36.1355_-81.6996", "28607": "36.2142_-81.666", "28608": "36.2168_-81.6746", "28618": "36.2136_-81.5163", "28679": "36.2627_-81.8441", "28691": "36.2092_-81.7789", "28692": "36.2574_-81.7652", "28698": "36.3194_-81.7476", "27530": "35.3683_-78.0929", "27531": "35.343_-77.9644", "27532": "35.372_-78.0524", "27533": "35.372_-78.0524", "27534": "35.3664_-77.9221", "27830": "35.5553_-77.958", "27863": "35.4929_-77.9578", "28333": "35.2926_-78.0273", "28365": "35.2109_-78.0983", "28578": "35.2105_-77.9146", "28606": "36.0552_-81.3137", "28624": "36.1283_-81.3864", "28635": "36.31_-81.1161", "28649": "36.3103_-81.1912", "28651": "36.2119_-81.2485", "28654": "36.0788_-81.1781", "28656": "36.2384_-81.046", "28659": "36.2017_-81.1286", "28665": "36.1964_-81.3528", "28669": "36.1916_-81.0004", "28670": "36.2059_-80.927", "28683": "36.3562_-80.9317", "28685": "36.3301_-81.0151", "28697": "36.1359_-81.1573", "27813": "35.6352_-77.933", "27822": "35.811_-77.856", "27851": "35.6415_-78.0197", "27873": "35.6538_-77.7755", "27880": "35.7435_-78.0859", "27883": "35.594_-77.8378", "27893": "35.727_-77.9227", "27894": "35.7158_-77.9043", "27895": "35.7199_-77.9267", "27896": "35.7715_-77.973", "27011": "36.234_-80.6357", "27018": "36.2032_-80.5284", "27020": "36.1242_-80.8137", "27055": "36.1277_-80.653", "28642": "36.2286_-80.787", "28714": "35.903_-82.2876", "28740": "35.9937_-82.259", "28755": "35.9096_-82.2132", "58639": "46.0578_-102.7851", "58649": "46.1116_-102.9405", "58031": "46.7728_-97.7812", "58049": "46.7177_-97.9763", "58062": "46.6748_-97.7911", "58063": "46.9433_-97.7853", "58065": "47.1862_-97.7605", "58072": "46.9268_-98.0033", "58429": "47.1828_-98.1616", "58461": "46.6536_-98.1943", "58479": "47.0741_-98.2136", "58480": "46.9271_-98.2336", "58492": "47.1438_-98.4329", "58332": "48.0419_-99.7617", "58335": "47.9811_-99.0264", "58343": "48.3388_-99.6713", "58346": "48.2889_-99.4376", "58348": "47.9625_-99.5301", "58351": "48.0698_-99.2743", "58357": "47.9487_-99.1401", "58370": "47.985_-98.8721", "58379": "47.9247_-98.8162", "58381": "47.8913_-98.681", "58386": "48.2565_-99.6025", "58627": "47.2329_-103.3056", "58645": "46.9387_-103.5632", "58318": "48.8451_-100.4329", "58384": "48.6062_-100.2968", "58711": "48.9585_-101.3338", "58748": "48.6867_-100.6716", "58750": "48.6254_-101.3858", "58760": "48.7722_-101.2563", "58762": "48.6982_-100.9681", "58783": "48.8738_-100.7359", "58793": "48.9051_-101.0338", "58623": "46.1733_-103.402", "58651": "46.1664_-103.7079", "58653": "46.0916_-103.1354", "58721": "48.8378_-102.2839", "58727": "48.8434_-102.798", "58737": "48.8772_-102.3823", "58752": "48.8481_-102.5542", "58772": "48.9758_-102.548", "58773": "48.6551_-102.6795", "58477": "47.1527_-100.5224", "58494": "47.1519_-100.3072", "58501": "46.8083_-100.7837", "58502": "46.8887_-100.6819", "58503": "46.8394_-100.7843", "58504": "46.7231_-100.678", "58505": "46.8165_-100.7805", "58506": "46.8083_-100.7837", "58507": "46.8083_-100.7837", "58521": "46.9543_-100.7615", "58532": "46.8511_-100.1441", "58558": "46.8205_-100.5312", "58560": "46.6757_-100.2975", "58572": "46.8436_-100.2744", "58002": "46.9763_-97.4069", "58004": "47.0194_-97.2048", "58005": "47.1066_-96.9058", "58006": "47.1048_-97.2097", "58007": "47.0139_-97.4629", "58011": "46.9264_-97.5352", "58012": "46.8992_-97.2138", "58021": "46.6968_-97.0871", "58029": "47.1128_-97.3849", "58036": "47.1252_-96.9901", "58038": "47.2158_-97.0207", "58042": "46.9565_-96.9654", "58047": "46.7101_-96.8851", "58048": "47.1905_-97.217", "58051": "46.6543_-97.0049", "58052": "46.6593_-97.2725", "58059": "46.8614_-97.1157", "58064": "47.1515_-97.5967", "58071": "46.9119_-97.6594", "58078": "46.8907_-96.9258", "58079": "46.8326_-97.3461", "58102": "46.9209_-96.8318", "58103": "46.8564_-96.8123", "58104": "46.7932_-96.8397", "58105": "46.8954_-96.8078", "58106": "46.8772_-96.7898", "58107": "46.8772_-96.7898", "58108": "46.8772_-96.7898", "58109": "46.8235_-96.8148", "58121": "46.8772_-96.7898", "58122": "46.8772_-96.7898", "58124": "46.8772_-96.7898", "58125": "46.8772_-96.7898", "58126": "46.8772_-96.7898", "58239": "48.9594_-98.7237", "58249": "48.7866_-98.3566", "58255": "48.9986_-98.3648", "58260": "48.617_-98.0183", "58269": "48.6689_-98.1512", "58281": "48.9216_-98.5596", "58311": "48.6525_-98.5795", "58323": "48.851_-98.8808", "58352": "48.6694_-98.8355", "58355": "48.5772_-98.3704", "58372": "48.9458_-98.996", "58436": "46.0073_-98.5138", "58439": "46.0109_-98.8124", "58441": "46.1951_-98.3882", "58474": "46.1095_-98.2257", "58730": "48.8836_-103.274", "58765": "48.8856_-103.0098", "58833": "48.8165_-103.4673", "58844": "48.8813_-103.7415", "58625": "47.3049_-102.1985", "58626": "47.3536_-102.6205", "58636": "47.3517_-102.3368", "58640": "47.4109_-102.7762", "58642": "47.1258_-102.6806", "58644": "47.1381_-102.333", "58356": "47.7174_-98.8987", "58374": "47.8184_-99.0583", "58524": "46.5603_-100.1075", "58542": "46.0589_-99.9745", "58544": "46.4875_-100.2733", "58549": "46.5736_-99.9705", "58552": "46.1855_-100.2331", "58573": "46.0979_-100.2119", "58421": "47.4573_-98.8933", "58443": "47.4569_-98.6916", "58445": "47.5536_-98.8095", "58464": "47.5604_-98.5726", "58621": "46.9324_-103.9843", "58632": "46.7075_-103.9575", "58654": "46.8305_-103.8001", "58201": "47.901_-97.0446", "58202": "47.9215_-97.0735", "58203": "47.9272_-97.0672", "58204": "47.9679_-97.3675", "58205": "47.9515_-97.379", "58206": "47.9253_-97.0329", "58207": "47.9253_-97.0329", "58208": "47.9253_-97.0329", "58214": "47.9093_-97.4871", "58228": "47.9214_-97.263", "58235": "48.0853_-97.4706", "58244": "48.1514_-97.6443", "58251": "47.9115_-97.6264", "58256": "48.0853_-97.1943", "58258": "48.0074_-97.4305", "58266": "47.9848_-97.8334", "58267": "47.7591_-97.6038", "58275": "47.7068_-97.2092", "58278": "47.7766_-97.0962", "58529": "46.4624_-101.5387", "58533": "46.3679_-101.7558", "58562": "46.3823_-101.9619", "58564": "46.3352_-101.2827", "58569": "46.1838_-101.2589", "58416": "47.5739_-98.3546", "58425": "47.4527_-98.1533", "58448": "47.3786_-98.3502", "58452": "47.5422_-98.2382", "58484": "47.3854_-98.432", "58646": "46.3696_-102.327", "58647": "46.5128_-102.8358", "58650": "46.4235_-102.5684", "58428": "46.8686_-99.7515", "58475": "47.12_-99.5279", "58478": "47.1749_-99.7457", "58482": "46.8524_-99.9336", "58487": "46.8336_-99.6019", "58488": "47.1626_-99.9873", "58415": "46.3786_-98.4898", "58431": "46.5426_-98.4682", "58433": "46.3591_-98.7157", "58454": "46.5511_-98.8667", "58456": "46.3073_-98.9427", "58458": "46.3844_-98.3587", "58466": "46.5514_-98.369", "58490": "46.3712_-98.0895", "58440": "46.3701_-99.1733", "58442": "46.5913_-99.2191", "58561": "46.4867_-99.7725", "58710": "47.8703_-100.2529", "58712": "47.9685_-100.5209", "58713": "48.5351_-100.5954", "58731": "48.4057_-101.0337", "58736": "47.9024_-100.379", "58741": "48.2566_-100.8082", "58744": "48.1009_-100.5742", "58768": "48.2491_-100.9712", "58788": "48.3636_-100.4854", "58789": "48.5816_-100.7323", "58790": "48.0675_-100.9346", "58792": "47.986_-100.7988", "58413": "46.0537_-99.3164", "58460": "46.2586_-99.3491", "58495": "46.1917_-99.6131", "58581": "46.0055_-99.7725", "58634": "47.4431_-103.2944", "58757": "47.7292_-102.676", "58831": "47.7947_-103.6546", "58835": "47.8088_-103.4538", "58838": "47.7992_-103.9487", "58847": "47.9405_-102.8906", "58854": "47.8043_-103.2582", "58531": "47.5442_-101.2238", "58540": "47.6675_-101.6142", "58559": "47.4858_-100.7171", "58565": "47.4975_-101.3713", "58575": "47.5414_-100.8814", "58576": "47.4602_-101.1898", "58577": "47.3114_-101.0116", "58579": "47.1709_-100.7944", "58716": "47.7865_-101.0579", "58723": "47.8119_-100.6604", "58759": "47.8156_-101.2932", "58775": "47.696_-101.822", "58778": "47.7622_-100.8754", "58523": "47.2707_-101.8075", "58541": "47.2938_-102.0612", "58545": "47.3271_-101.6107", "58571": "47.3128_-101.3899", "58580": "47.2897_-101.9256", "58520": "46.7046_-101.5221", "58535": "46.5998_-101.3166", "58554": "46.8306_-100.9092", "58563": "46.806_-101.4291", "58566": "46.5888_-100.8972", "58631": "46.8233_-101.8223", "58638": "46.8936_-102.0367", "58763": "47.9718_-102.4716", "58769": "48.3396_-102.24", "58770": "47.956_-102.1427", "58771": "48.0242_-101.9643", "58776": "48.3111_-102.5466", "58784": "48.3458_-102.4185", "58794": "48.2994_-102.7701", "58212": "47.6993_-97.9814", "58224": "48.1599_-97.9573", "58254": "47.7639_-98.1773", "58259": "48.0204_-98.1186", "58272": "47.998_-97.984", "58344": "47.972_-98.3246", "58361": "47.7696_-98.326", "58380": "47.8462_-98.4512", "58530": "47.1459_-101.1594", "58216": "48.8686_-97.4832", "58220": "48.7935_-97.7143", "58222": "48.5924_-97.6738", "58225": "48.6104_-97.2156", "58236": "48.7201_-97.4696", "58238": "48.7942_-97.4693", "58241": "48.7203_-97.6993", "58262": "48.6931_-97.8841", "58265": "48.9796_-97.5427", "58271": "48.859_-97.2886", "58276": "48.6252_-97.4545", "58282": "48.8808_-97.7974", "58313": "48.1667_-100.0371", "58368": "48.2545_-99.9899", "58385": "48.4809_-99.6628", "58301": "48.1132_-98.8616", "58321": "48.2255_-98.3559", "58325": "48.2862_-99.1412", "58327": "48.091_-98.5731", "58330": "48.4308_-98.4458", "58338": "48.5229_-98.6543", "58345": "48.3033_-98.4142", "58362": "48.2271_-99.0655", "58377": "48.4488_-98.8539", "58382": "48.3229_-98.8739", "58027": "46.6079_-97.6106", "58033": "46.4494_-97.9091", "58054": "46.456_-97.6369", "58057": "46.4103_-97.3139", "58068": "46.5548_-97.4543", "58740": "48.4718_-101.2297", "58761": "48.7269_-101.6058", "58782": "48.9576_-101.697", "58787": "48.7969_-101.8559", "58001": "46.4479_-96.7278", "58008": "46.2496_-96.9708", "58015": "46.5736_-96.8017", "58018": "46.4574_-96.8737", "58030": "46.0427_-96.6308", "58041": "46.0558_-96.8991", "58053": "46.0641_-97.1799", "58058": "46.1599_-96.957", "58061": "46.2686_-96.8762", "58074": "46.2652_-96.6059", "58075": "46.3366_-96.7921", "58076": "46.2718_-96.6081", "58077": "46.5835_-97.0014", "58081": "46.2891_-97.1289", "58310": "48.6228_-99.4932", "58316": "48.8379_-99.7688", "58329": "48.8561_-100.0241", "58353": "48.6329_-99.5957", "58366": "48.7009_-99.8785", "58367": "48.8594_-99.6134", "58369": "48.9366_-99.7648", "58013": "46.1326_-97.4059", "58017": "46.0659_-97.8207", "58032": "46.0721_-97.6986", "58040": "46.2258_-97.6626", "58043": "45.9644_-97.6094", "58060": "46.2007_-97.4772", "58067": "46.0738_-97.5483", "58069": "46.2519_-97.8326", "58430": "47.5709_-100.263", "58444": "47.471_-100.119", "58463": "47.4896_-100.452", "58758": "47.7781_-100.1225", "58528": "46.3874_-100.5975", "58538": "46.0905_-100.6516", "58568": "46.0351_-101.1502", "58570": "46.3656_-100.7831", "58620": "46.456_-103.2647", "58643": "46.3254_-103.88", "58601": "46.8057_-102.7565", "58602": "46.8792_-102.7896", "58622": "46.8198_-103.1261", "58630": "46.8152_-102.5274", "58641": "46.6684_-102.4986", "58652": "46.8426_-102.292", "58655": "46.8127_-103.0162", "58656": "46.9284_-102.3756", "58046": "47.3237_-97.7134", "58056": "47.2319_-97.9314", "58230": "47.5306_-97.7442", "58277": "47.6062_-97.9051", "58401": "46.921_-98.7455", "58402": "46.9788_-98.96", "58405": "46.9133_-98.6996", "58420": "47.0051_-98.9007", "58424": "46.8931_-99.1288", "58426": "47.2272_-98.5489", "58455": "47.2726_-98.7206", "58467": "46.892_-99.3106", "58472": "46.6816_-98.6604", "58476": "47.2038_-99.0144", "58481": "46.9865_-98.5219", "58483": "46.695_-99.2971", "58496": "47.1636_-99.3406", "58497": "46.7719_-98.4876", "58317": "48.6258_-99.3779", "58324": "48.4867_-99.2099", "58331": "48.6355_-99.1115", "58339": "48.9001_-99.4278", "58363": "48.7546_-99.4384", "58365": "48.8216_-99.1796", "58009": "47.3277_-97.2466", "58016": "47.3569_-97.41", "58035": "47.27_-97.4065", "58045": "47.3835_-97.0603", "58218": "47.6163_-97.0893", "58219": "47.4776_-96.879", "58223": "47.537_-96.9913", "58240": "47.638_-97.4325", "58257": "47.5014_-97.3176", "58274": "47.5015_-97.3843", "58210": "48.4223_-98.0867", "58227": "48.4997_-97.8932", "58229": "48.4819_-98.2066", "58231": "48.2212_-97.8022", "58233": "48.2251_-97.4605", "58237": "48.4122_-97.4106", "58243": "48.5198_-97.6183", "58250": "48.2952_-98.007", "58261": "48.26_-97.3144", "58270": "48.4039_-97.7439", "58273": "48.2971_-97.7029", "58701": "48.2291_-101.2985", "58702": "48.2325_-101.2963", "58703": "48.3306_-101.3156", "58704": "48.4232_-101.3168", "58705": "48.4223_-101.3339", "58707": "48.2453_-101.3012", "58718": "48.3064_-101.6866", "58722": "48.2735_-101.4282", "58725": "48.4323_-101.7119", "58733": "48.2557_-101.5672", "58734": "48.49_-101.896", "58735": "47.8659_-101.5112", "58746": "48.7182_-102.0852", "58756": "47.9611_-101.8046", "58779": "47.9788_-101.6683", "58781": "48.0858_-101.0674", "58785": "48.2365_-101.1216", "58341": "47.7035_-99.7478", "58418": "47.4343_-99.7015", "58422": "47.6289_-99.4049", "58423": "47.449_-99.8241", "58438": "47.6286_-99.6434", "58451": "47.4387_-99.9416", "58486": "47.4369_-99.3975", "58755": "48.595_-102.9288", "58795": "48.5678_-103.1536", "58801": "48.2257_-103.649", "58802": "48.1688_-103.6148", "58803": "48.1468_-103.6199", "58830": "48.5817_-103.4699", "58843": "48.2764_-103.3763", "58845": "48.5252_-103.9176", "58849": "48.3217_-103.1654", "58852": "48.3646_-102.9576", "58853": "48.0706_-103.8369", "58856": "48.5787_-103.6599", "68901": "40.5877_-98.3911", "68902": "40.5896_-98.3972", "68925": "40.4411_-98.439", "68950": "40.4542_-98.6538", "68955": "40.5867_-98.515", "68956": "40.6165_-98.6572", "68973": "40.4591_-98.5551", "68636": "41.9732_-98.0751", "68720": "42.3459_-98.0123", "68726": "42.1266_-98.1868", "68756": "42.1389_-98.0151", "68761": "42.0697_-97.9692", "68764": "42.3399_-98.2409", "68773": "42.3648_-98.1235", "69121": "41.574_-101.6931", "69345": "41.5531_-103.7111", "68821": "41.9467_-99.8292", "68833": "41.8131_-100.0873", "69157": "42.065_-100.2585", "68620": "41.7049_-97.9991", "68627": "41.5564_-98.1554", "68652": "41.859_-98.0848", "68655": "41.6405_-98.2355", "68660": "41.5708_-97.8801", "69301": "42.1149_-102.888", "69348": "42.3312_-103.0644", "68719": "42.9484_-98.5721", "68722": "42.9124_-98.8459", "68746": "42.8373_-98.4504", "68755": "42.9521_-99.071", "68777": "42.8849_-98.7059", "69210": "42.5403_-99.8615", "69214": "42.5717_-100.0582", "69217": "42.5364_-99.7007", "68812": "40.8495_-99.2609", "68836": "40.7301_-99.3728", "68840": "40.7444_-98.8543", "68845": "40.7514_-99.1291", "68847": "40.7136_-99.0779", "68848": "40.6861_-99.0693", "68849": "40.8497_-99.0741", "68858": "40.9422_-99.374", "68861": "40.7017_-99.2568", "68866": "40.9818_-99.1283", "68869": "41.0233_-98.9041", "68870": "40.8524_-99.1611", "68876": "40.7717_-98.7435", "68019": "41.7715_-96.3924", "68020": "41.9966_-96.2595", "68038": "41.9442_-96.4661", "68045": "41.8384_-96.4671", "68061": "41.7819_-96.2281", "68001": "41.3479_-96.9563", "68014": "41.2718_-96.9646", "68036": "41.4129_-96.9399", "68624": "41.3474_-97.2747", "68626": "41.1832_-96.9882", "68632": "41.2528_-97.13", "68635": "41.0894_-96.9931", "68658": "41.2082_-97.3032", "68667": "41.1086_-97.3112", "68669": "41.0791_-97.1984", "68016": "41.0425_-96.1044", "68037": "40.9967_-96.1948", "68048": "40.9992_-95.9139", "68058": "41.0067_-96.2462", "68304": "40.8992_-96.4036", "68307": "40.8159_-96.0957", "68347": "40.8169_-96.429", "68349": "40.8378_-96.2944", "68366": "40.9706_-96.4258", "68403": "40.9207_-96.168", "68407": "40.919_-96.2848", "68409": "40.92_-95.9227", "68413": "40.833_-95.993", "68455": "40.8245_-95.9037", "68463": "40.8731_-96.1528", "68717": "42.4022_-97.1956", "68727": "42.5061_-97.2037", "68736": "42.7309_-97.3567", "68739": "42.6235_-97.2837", "68745": "42.427_-97.0874", "68749": "42.455_-97.4701", "68771": "42.3798_-97.3464", "68774": "42.8046_-97.3047", "68792": "42.7393_-97.1678", "69023": "40.46_-101.7485", "69027": "40.4655_-101.5222", "69033": "40.5251_-101.6468", "69045": "40.4409_-101.3812", "69135": "42.2403_-100.2595", "69201": "42.8062_-100.6215", "69211": "42.825_-101.2913", "69212": "42.9255_-100.7735", "69216": "42.9146_-100.9884", "69218": "42.6419_-101.7583", "69219": "42.9278_-101.1029", "69220": "42.9411_-100.256", "69221": "42.6264_-100.2872", "69131": "41.4068_-102.9726", "69141": "41.315_-102.9835", "69149": "41.1697_-102.657", "69156": "41.2347_-103.3061", "69160": "41.2205_-102.9959", "69162": "41.138_-102.9856", "68452": "40.3968_-97.861", "68933": "40.5113_-98.0386", "68934": "40.354_-98.14", "68935": "40.3652_-97.9727", "68938": "40.4285_-98.1063", "68941": "40.4931_-98.2465", "68944": "40.6265_-98.0846", "68954": "40.5899_-98.2234", "68975": "40.6021_-97.9388", "68979": "40.6056_-97.8592", "68980": "40.6795_-98.2734", "68629": "41.6961_-97.1051", "68641": "41.725_-97.0028", "68643": "41.7053_-97.2381", "68659": "41.4653_-96.915", "68661": "41.4591_-97.0628", "68004": "42.0267_-96.6171", "68716": "41.9374_-96.815", "68788": "41.845_-96.7318", "68791": "41.998_-96.917", "68813": "41.6208_-99.8644", "68814": "41.3019_-99.3645", "68822": "41.4126_-99.6355", "68825": "41.2485_-99.9932", "68828": "41.5606_-99.2504", "68855": "41.1853_-99.3049", "68856": "41.4435_-99.8036", "68860": "41.1411_-99.7632", "68874": "41.6508_-99.3816", "68881": "41.4193_-99.3844", "69120": "41.4456_-100.1567", "68030": "42.3322_-96.4656", "68731": "42.3807_-96.4536", "68733": "42.2852_-96.7159", "68741": "42.3576_-96.6031", "68743": "42.4529_-96.5743", "68776": "42.4656_-96.4182", "69337": "42.8193_-102.9953", "69339": "42.6758_-103.4053", "69354": "42.4439_-103.2985", "69367": "42.7559_-103.2396", "68834": "41.0079_-99.681", "68850": "40.785_-99.7515", "68863": "40.7519_-99.5278", "68878": "40.9504_-99.52", "69029": "40.7129_-100.2069", "69130": "40.8619_-99.9921", "69138": "40.94_-100.1547", "69171": "40.8925_-100.0703", "69122": "41.0696_-102.0933", "69129": "41.0966_-102.4523", "68710": "42.4437_-96.8574", "68728": "42.382_-96.981", "68732": "42.4185_-96.9774", "68751": "42.6905_-96.9809", "68757": "42.6207_-96.8709", "68770": "42.5693_-96.7128", "68784": "42.2733_-96.8776", "68785": "42.4604_-96.7448", "68025": "41.4416_-96.4945", "68026": "41.4333_-96.4981", "68031": "41.6414_-96.5232", "68044": "41.5491_-96.4441", "68057": "41.663_-96.6441", "68063": "41.7369_-96.5037", "68072": "41.6102_-96.5033", "68621": "41.4613_-96.6463", "68633": "41.7052_-96.8969", "68649": "41.4689_-96.7813", "68664": "41.7039_-96.7886", "68007": "41.3623_-96.1575", "68010": "41.2587_-96.133", "68022": "41.2756_-96.2431", "68064": "41.3186_-96.3463", "68069": "41.2702_-96.3063", "68101": "41.2586_-95.9378", "68102": "41.259_-95.9409", "68103": "41.2586_-95.9378", "68104": "41.2919_-95.9999", "68105": "41.2435_-95.9629", "68106": "41.2403_-95.998", "68107": "41.2068_-95.9559", "68108": "41.2382_-95.9336", "68109": "41.2586_-95.9378", "68110": "41.2933_-95.9361", "68111": "41.2962_-95.965", "68112": "41.3296_-95.9597", "68114": "41.2656_-96.0493", "68116": "41.2879_-96.1495", "68117": "41.2064_-95.9953", "68118": "41.2606_-96.1661", "68119": "41.2586_-95.9378", "68120": "41.2586_-95.9378", "68122": "41.3333_-96.0458", "68124": "41.2338_-96.0495", "68127": "41.2074_-96.0612", "68130": "41.2355_-96.1688", "68131": "41.2647_-95.9639", "68132": "41.2657_-95.996", "68134": "41.2949_-96.0546", "68135": "41.2104_-96.1698", "68137": "41.2075_-96.1147", "68139": "41.2586_-95.9378", "68142": "41.3359_-96.0901", "68144": "41.2335_-96.1188", "68145": "41.2586_-95.9378", "68152": "41.3346_-96.0003", "68154": "41.2642_-96.1206", "68155": "41.2586_-95.9378", "68164": "41.2955_-96.1008", "68172": "41.2586_-95.9378", "68175": "41.2586_-95.9378", "68176": "41.2586_-95.9378", "68178": "41.2657_-95.9477", "68179": "41.2586_-95.9378", "68180": "41.2586_-95.9378", "68182": "41.2586_-95.9378", "68183": "41.2586_-95.9378", "68197": "41.2563_-95.9404", "68198": "41.2586_-95.9378", "69021": "40.098_-101.5344", "69030": "40.0642_-101.9371", "69037": "40.198_-101.4116", "69041": "40.1398_-101.7399", "68351": "40.6341_-97.4424", "68354": "40.6404_-97.5873", "68361": "40.5277_-97.6096", "68365": "40.6402_-97.7403", "68406": "40.4952_-97.3997", "68416": "40.4065_-97.4427", "68436": "40.4077_-97.7143", "68444": "40.4156_-97.587", "68929": "40.1383_-99.0094", "68932": "40.2967_-98.737", "68939": "40.1052_-98.9469", "68947": "40.3217_-99.0571", "68960": "40.1258_-99.1277", "68972": "40.1016_-98.7858", "68981": "40.3171_-98.8966", "69025": "40.6131_-100.5104", "69028": "40.6625_-100.0296", "69038": "40.6575_-100.6221", "69039": "40.5786_-100.3108", "69042": "40.4948_-100.3849", "68922": "40.3027_-99.8997", "68926": "40.129_-99.8065", "68936": "40.2802_-99.786", "68946": "40.1063_-99.9715", "68948": "40.3019_-100.0136", "68967": "40.256_-99.6302", "69022": "40.2808_-100.1676", "69046": "40.1089_-100.1211", "68301": "40.4576_-96.5396", "68309": "40.0483_-96.577", "68310": "40.2705_-96.7435", "68318": "40.1407_-96.659", "68328": "40.4724_-96.8555", "68331": "40.4976_-96.7166", "68357": "40.2946_-96.5301", "68381": "40.0801_-96.4804", "68415": "40.0451_-96.8019", "68422": "40.3821_-96.7344", "68458": "40.2309_-96.5121", "68466": "40.113_-96.6613", "69147": "41.3435_-102.1396", "69148": "41.5114_-102.5498", "69154": "41.405_-102.3444", "69190": "41.405_-102.3444", "68823": "41.808_-99.0995", "68937": "40.5747_-99.8258", "68976": "40.5832_-99.7285", "69333": "41.9776_-101.9636", "69350": "42.007_-101.7483", "69366": "41.9584_-101.5216", "68665": "41.6874_-98.3715", "68842": "41.5526_-98.53", "68875": "41.4837_-98.6893", "68882": "41.4244_-98.3995", "68801": "40.9219_-98.3411", "68802": "40.8725_-98.5021", "68803": "40.9286_-98.3873", "68810": "40.8711_-98.4681", "68824": "41.0002_-98.6165", "68832": "40.77_-98.379", "68883": "40.8106_-98.6065", "68818": "40.8528_-98.0201", "68841": "40.7654_-98.1434", "68843": "40.9236_-97.8841", "68846": "41.0813_-97.8881", "68854": "41.01_-98", "68865": "40.8982_-98.2129", "68920": "40.1189_-99.3601", "68966": "40.1484_-99.4572", "68969": "40.3103_-99.2898", "68971": "40.1034_-99.2322", "68977": "40.1163_-99.5814", "69032": "40.5173_-101.0252", "69024": "40.2237_-100.85", "69040": "40.3387_-101.1295", "69043": "40.1445_-101.2183", "69044": "40.1681_-101.0201", "68711": "42.1809_-99.008", "68713": "42.5483_-98.9761", "68725": "42.1916_-98.7378", "68734": "42.4747_-98.8238", "68735": "42.1851_-98.3981", "68742": "42.3761_-98.5384", "68763": "42.4857_-98.6456", "68766": "42.4119_-98.3964", "68780": "42.5713_-99.1396", "69152": "42.0163_-101.0542", "68820": "41.1003_-98.6976", "68831": "41.1192_-98.5546", "68835": "41.2864_-98.5756", "68838": "41.2204_-98.6481", "68872": "41.0867_-98.3589", "68873": "41.2242_-98.444", "68338": "40.3192_-97.3043", "68342": "40.1192_-96.9495", "68350": "40.0496_-97.0813", "68352": "40.1488_-97.1839", "68377": "40.2074_-97.0244", "68424": "40.3039_-97.0012", "68440": "40.0378_-97.0248", "68329": "40.4986_-96.1526", "68332": "40.3166_-96.4116", "68348": "40.2977_-96.1421", "68443": "40.4637_-96.3867", "68450": "40.3697_-96.205", "68924": "40.5269_-99.1169", "68945": "40.5716_-98.7851", "68959": "40.5091_-98.9383", "68982": "40.3735_-99.1539", "69127": "41.1002_-101.9099", "69144": "41.2621_-101.6282", "69146": "41.3236_-101.7673", "69153": "41.1275_-101.7107", "69155": "41.1268_-101.3585", "68753": "42.9225_-99.4466", "68759": "42.6001_-99.3359", "68778": "42.8488_-99.8061", "69128": "41.2139_-103.9075", "69133": "41.227_-103.4796", "69145": "41.2321_-103.6602", "68718": "42.5978_-97.6545", "68724": "42.5973_-97.867", "68729": "42.4681_-97.8932", "68730": "42.737_-97.5406", "68760": "42.7391_-97.9248", "68783": "42.6101_-98.0793", "68786": "42.4973_-97.5576", "68789": "42.5334_-98.005", "68317": "40.68_-96.5064", "68336": "40.9639_-96.688", "68339": "40.7378_-96.8445", "68358": "40.5586_-96.614", "68368": "40.5739_-96.7998", "68372": "40.6119_-96.6247", "68402": "40.9091_-96.86", "68404": "40.6514_-96.7442", "68419": "40.5998_-96.5129", "68428": "40.9342_-96.7866", "68430": "40.6702_-96.6391", "68438": "40.6267_-96.7456", "68461": "40.7975_-96.5359", "68462": "40.9222_-96.526", "68501": "40.8651_-96.8231", "68502": "40.7893_-96.6938", "68503": "40.8233_-96.6766", "68504": "40.8392_-96.6532", "68505": "40.8247_-96.6252", "68506": "40.7848_-96.6431", "68507": "40.8473_-96.6289", "68508": "40.8145_-96.7009", "68509": "40.7845_-96.6888", "68510": "40.8063_-96.6545", "68512": "40.7565_-96.6946", "68514": "40.9401_-96.6621", "68516": "40.7568_-96.6523", "68517": "40.9317_-96.6045", "68520": "40.7744_-96.5693", "68521": "40.851_-96.711", "68522": "40.7934_-96.7479", "68523": "40.7408_-96.7583", "68524": "40.8529_-96.7943", "68526": "40.7314_-96.5878", "68527": "40.8347_-96.5401", "68528": "40.8195_-96.7545", "68529": "40.8798_-96.7798", "68531": "40.9008_-96.7201", "68532": "40.7922_-96.8551", "68542": "40.7845_-96.6888", "68544": "40.7845_-96.6888", "68583": "40.7845_-96.6888", "68588": "40.8206_-96.6928", "69101": "41.1326_-100.7746", "69103": "41.0464_-100.7469", "69123": "41.0515_-100.3736", "69132": "40.8041_-101.0149", "69143": "41.2102_-101.0392", "69151": "41.0588_-100.527", "69165": "41.1557_-101.136", "69169": "40.8304_-101.1738", "69170": "40.7988_-100.7119", "69163": "41.4888_-100.4831", "68879": "41.9141_-99.4543", "69167": "41.5732_-101.0175", "68701": "42.0329_-97.4229", "68702": "42.0283_-97.417", "68715": "41.9943_-97.5982", "68748": "41.8308_-97.472", "68752": "42.0102_-97.7334", "68758": "41.7498_-97.774", "68781": "42.0496_-97.8223", "68628": "41.2328_-97.8461", "68663": "41.319_-97.6671", "68816": "41.1782_-98.1182", "68826": "41.1213_-98.0017", "68827": "40.9856_-98.2217", "68864": "41.1788_-98.2411", "69125": "41.5825_-102.8225", "69331": "41.8934_-103.085", "69334": "41.7579_-103.3019", "69336": "41.6766_-103.0701", "68623": "41.4611_-98.0866", "68638": "41.3633_-97.9692", "68640": "41.4468_-97.764", "68305": "40.3789_-95.8526", "68320": "40.4772_-95.9801", "68321": "40.3994_-95.6935", "68378": "40.4016_-95.9883", "68379": "40.5199_-95.8674", "68414": "40.3198_-95.6913", "68421": "40.4766_-95.7312", "68943": "40.0285_-97.9271", "68957": "40.2767_-98.2402", "68961": "40.2011_-98.0684", "68964": "40.2378_-97.903", "68974": "40.1383_-97.872", "68978": "40.0315_-98.0779", "68324": "40.5601_-96.2384", "68344": "40.5838_-96.397", "68346": "40.6592_-96.0136", "68382": "40.5973_-96.0241", "68410": "40.6747_-95.8619", "68417": "40.7355_-96.1329", "68418": "40.705_-96.3999", "68446": "40.6614_-96.1824", "68448": "40.5586_-96.0138", "68454": "40.6917_-96.2825", "68323": "40.1475_-96.3503", "68345": "40.0375_-96.0575", "68380": "40.2309_-96.4049", "68420": "40.1093_-96.1509", "68441": "40.2169_-96.2302", "68447": "40.1874_-96.0818", "69134": "40.8596_-101.37", "69140": "40.8511_-101.7196", "69150": "40.8544_-101.5371", "69168": "40.8073_-101.9839", "68923": "40.3667_-99.4732", "68927": "40.5608_-99.5759", "68940": "40.502_-99.245", "68949": "40.4475_-99.3672", "68958": "40.4792_-99.4979", "68738": "42.105_-97.4492", "68747": "42.3921_-97.4751", "68765": "42.3539_-97.582", "68767": "42.1943_-97.5256", "68769": "42.3467_-97.7786", "68601": "41.4297_-97.3684", "68602": "41.4297_-97.3684", "68631": "41.7067_-97.3625", "68634": "41.3895_-97.4948", "68642": "41.6702_-97.4986", "68644": "41.6926_-97.6711", "68647": "41.4783_-97.6061", "68653": "41.5375_-97.4884", "68651": "41.1966_-97.5571", "68654": "41.0767_-97.7839", "68662": "41.1922_-97.4253", "68666": "41.1118_-97.5742", "69001": "40.2049_-100.6279", "69020": "40.2581_-100.2908", "69026": "40.0377_-100.4242", "69034": "40.2357_-100.4298", "69036": "40.0506_-100.2763", "68337": "40.1377_-95.8341", "68355": "40.0742_-95.5931", "68376": "40.1566_-95.9311", "68431": "40.0536_-95.4292", "68433": "40.062_-95.7273", "68437": "40.2325_-95.6895", "68442": "40.2303_-95.768", "68457": "40.1425_-95.7162", "68714": "42.5763_-99.5387", "68333": "40.6193_-96.9567", "68341": "40.3944_-96.9338", "68343": "40.6499_-97.1056", "68359": "40.6368_-97.2739", "68445": "40.3844_-97.0806", "68453": "40.4262_-97.3184", "68464": "40.4152_-97.1976", "68465": "40.4821_-96.9757", "68005": "41.1497_-95.9099", "68028": "41.1345_-96.2458", "68046": "41.1523_-96.0371", "68056": "41.0927_-96.0905", "68059": "41.0765_-96.1438", "68113": "41.2563_-95.9404", "68123": "41.1156_-95.9393", "68128": "41.1814_-96.0658", "68133": "41.1416_-96.0131", "68136": "41.1683_-96.2096", "68138": "41.1549_-96.1376", "68147": "41.1758_-95.9553", "68157": "41.181_-95.9909", "68003": "41.0541_-96.3904", "68015": "41.3835_-96.5691", "68017": "41.0681_-96.6398", "68018": "41.2883_-96.6141", "68033": "41.1748_-96.5298", "68040": "41.2984_-96.7327", "68041": "41.2393_-96.4961", "68042": "41.0946_-96.4306", "68050": "41.3036_-96.8301", "68065": "41.0843_-96.8091", "68066": "41.2117_-96.6219", "68070": "41.1811_-96.7691", "68073": "41.234_-96.3932", "68648": "41.4178_-96.7862", "69341": "41.822_-103.6629", "69352": "41.8918_-104.0066", "69353": "41.7469_-103.4164", "69355": "41.7816_-103.5177", "69356": "41.8493_-103.489", "69357": "41.9459_-103.796", "69358": "41.9681_-103.9182", "69361": "41.872_-103.6619", "69363": "41.8666_-103.6672", "68313": "40.7887_-97.2914", "68314": "41.0007_-97.0745", "68330": "40.7185_-97.3407", "68360": "40.9412_-96.9702", "68364": "40.8322_-97.2212", "68405": "40.7632_-97.0576", "68423": "40.8133_-96.9513", "68434": "40.9066_-97.0966", "68439": "40.9845_-97.1859", "68456": "40.9168_-97.3344", "69335": "42.0211_-102.0885", "69340": "42.0586_-102.2807", "69343": "42.8068_-102.2049", "69347": "42.6401_-102.6756", "69351": "42.0496_-102.4437", "69360": "42.7379_-102.4657", "69365": "42.9969_-102.5546", "68817": "41.2672_-98.8034", "68844": "41.0934_-99.0719", "68852": "41.1686_-99.1415", "68853": "41.2845_-98.9751", "68871": "41.1108_-98.8578", "69346": "42.6872_-103.8827", "68768": "41.9761_-97.0779", "68779": "41.9076_-97.214", "68303": "40.2614_-97.4039", "68315": "40.251_-97.5554", "68322": "40.3302_-97.5573", "68325": "40.0269_-97.7612", "68326": "40.3005_-97.6719", "68327": "40.029_-97.6197", "68335": "40.3108_-97.805", "68340": "40.1387_-97.73", "68362": "40.147_-97.4271", "68370": "40.1728_-97.6052", "68375": "40.0456_-97.4735", "68429": "40.0598_-97.3806", "69142": "41.9291_-100.2955", "69161": "42.0433_-100.8329", "69166": "41.9794_-100.5574", "68039": "42.1177_-96.3589", "68047": "42.1177_-96.7189", "68055": "42.0574_-96.4929", "68062": "42.1882_-96.6904", "68067": "42.1485_-96.4803", "68071": "42.2339_-96.4685", "68815": "41.4293_-99.1205", "68837": "41.6808_-99.0062", "68859": "41.4972_-98.7858", "68862": "41.5962_-98.9418", "68002": "41.4417_-96.307", "68008": "41.5454_-96.1617", "68009": "41.5383_-96.1823", "68023": "41.4373_-96.0324", "68029": "41.6524_-96.2869", "68034": "41.4526_-96.1903", "68068": "41.3975_-96.2081", "68723": "42.277_-97.1926", "68740": "42.1408_-97.3084", "68787": "42.2304_-97.0186", "68790": "42.1678_-97.1825", "68928": "40.299_-98.6046", "68930": "40.311_-98.427", "68942": "40.0812_-98.3391", "68952": "40.0959_-98.6612", "68970": "40.0952_-98.5187", "68622": "41.8697_-98.5567", "68637": "41.7828_-98.6453", "68316": "41.0033_-97.6029", "68319": "40.9207_-97.7607", "68367": "41.021_-97.4079", "68371": "40.7814_-97.7979", "68401": "40.7442_-97.5937", "68460": "40.9198_-97.4534", "68467": "40.8667_-97.5825", "03218": "43.3349_-71.2887", "03220": "43.4512_-71.489", "03225": "43.3566_-71.2424", "03226": "43.7107_-71.4797", "03237": "43.4175_-71.4121", "03246": "43.5727_-71.4781", "03247": "43.589_-71.4455", "03249": "43.5475_-71.4072", "03252": "43.4686_-71.5371", "03253": "43.6311_-71.4997", "03256": "43.6184_-71.6435", "03269": "43.5496_-71.6003", "03276": "43.4603_-71.5774", "03289": "43.4964_-71.5197", "03298": "43.5249_-71.4458", "03299": "43.5249_-71.4458", "03809": "43.463_-71.2297", "03810": "43.4845_-71.2489", "03837": "43.4466_-71.2995", "03227": "43.8162_-71.4506", "03254": "43.7281_-71.3922", "03259": "43.8452_-71.385", "03812": "44.0802_-71.292", "03813": "43.9878_-71.0607", "03814": "43.7682_-71.1349", "03816": "43.6849_-71.2551", "03817": "43.8909_-71.2407", "03818": "43.9742_-71.1503", "03830": "43.6142_-71.0051", "03832": "43.9092_-71.0837", "03836": "43.8172_-71.0628", "03838": "44.1018_-71.1925", "03845": "44.0955_-71.1194", "03846": "44.167_-71.1878", "03847": "44.0753_-71.1176", "03849": "43.9152_-71.1254", "03850": "43.7077_-71.3017", "03853": "43.6366_-71.2729", "03860": "44.0336_-71.1238", "03861": "43.1192_-70.9969", "03864": "43.6945_-71.1129", "03872": "43.5513_-71.02", "03875": "43.879_-71.1905", "03882": "43.7012_-70.9834", "03883": "43.8077_-71.308", "03886": "43.862_-71.2645", "03890": "43.8118_-71.1946", "03894": "43.595_-71.1908", "03896": "43.5892_-71.2189", "03897": "43.9073_-71.3506", "03431": "42.9627_-72.2955", "03435": "42.9337_-72.2781", "03441": "42.7851_-72.4349", "03443": "42.8839_-72.4548", "03444": "42.8972_-72.0505", "03445": "42.9982_-72.2019", "03446": "42.8411_-72.3301", "03447": "42.7611_-72.145", "03448": "43.0399_-72.2719", "03450": "42.9399_-72.0972", "03451": "42.8027_-72.5015", "03452": "42.8178_-72.0275", "03455": "42.8988_-72.2013", "03456": "43.1326_-72.2109", "03457": "42.9906_-72.1309", "03461": "42.7544_-72.019", "03462": "42.912_-72.4103", "03464": "43.0739_-72.1088", "03465": "42.827_-72.1848", "03466": "42.8956_-72.5097", "03467": "42.969_-72.4358", "03469": "42.8734_-72.3151", "03470": "42.7788_-72.344", "03602": "43.1265_-72.3281", "03604": "43.1281_-72.392", "03608": "43.0765_-72.4155", "03609": "43.1428_-72.4483", "03570": "44.4811_-71.1892", "03575": "44.2581_-71.4412", "03576": "44.9078_-71.4793", "03579": "44.8003_-71.1436", "03581": "44.4048_-71.1548", "03582": "44.5984_-71.5064", "03583": "44.3999_-71.4518", "03584": "44.4921_-71.5591", "03588": "44.587_-71.181", "03589": "44.6956_-71.3874", "03590": "44.7149_-71.5644", "03592": "45.0866_-71.3636", "03593": "44.3753_-71.2798", "03595": "44.2689_-71.5471", "03597": "44.6956_-71.3874", "03598": "44.3681_-71.6035", "03215": "43.9501_-71.4995", "03217": "43.7034_-71.6121", "03222": "43.612_-71.7507", "03223": "43.8418_-71.6652", "03238": "43.9828_-71.8934", "03240": "43.5727_-71.9634", "03241": "43.7186_-71.827", "03245": "43.7378_-71.6044", "03251": "44.0582_-71.6727", "03258": "43.244_-71.4105", "03262": "44.0354_-71.6863", "03264": "43.757_-71.6881", "03266": "43.8044_-71.848", "03279": "43.9447_-71.8901", "03282": "43.8685_-71.9097", "03285": "43.905_-71.647", "03293": "43.9776_-71.6851", "03561": "44.3112_-71.7768", "03574": "44.2808_-71.6829", "03580": "44.2053_-71.7518", "03585": "44.2148_-71.8966", "03586": "44.2203_-71.7964", "03740": "44.1808_-71.9828", "03741": "43.6601_-72.0297", "03748": "43.6256_-72.127", "03749": "43.5796_-72.0854", "03750": "43.7113_-72.2125", "03755": "43.7045_-72.285", "03756": "43.6423_-72.2518", "03765": "44.0394_-72.0573", "03766": "43.6447_-72.2428", "03768": "43.7913_-72.162", "03769": "43.7863_-72.1205", "03771": "44.2734_-72.025", "03774": "44.0978_-72.0191", "03777": "43.8941_-72.0978", "03779": "43.9906_-72.0813", "03780": "44.0255_-72.0096", "03784": "43.644_-72.3007", "03785": "44.1523_-72.0373", "03031": "42.8569_-71.6075", "03033": "42.7384_-71.6663", "03043": "42.992_-71.8113", "03045": "43.0201_-71.5697", "03047": "42.9493_-71.8728", "03048": "42.7482_-71.7619", "03049": "42.7485_-71.5772", "03051": "42.769_-71.4121", "03052": "42.843_-71.455", "03054": "42.8667_-71.5128", "03055": "42.8285_-71.6606", "03057": "42.8976_-71.6762", "03060": "42.7564_-71.4667", "03061": "42.7654_-71.4676", "03062": "42.7235_-71.4893", "03063": "42.7717_-71.5132", "03064": "42.779_-71.4748", "03070": "42.9722_-71.6864", "03071": "42.7511_-71.8703", "03076": "42.7288_-71.3046", "03082": "42.8954_-71.7744", "03084": "42.82_-71.8523", "03086": "42.8368_-71.7541", "03101": "42.9929_-71.4633", "03102": "42.9944_-71.4884", "03103": "42.9656_-71.4493", "03104": "43.0073_-71.4482", "03105": "42.9956_-71.4548", "03108": "42.9956_-71.4548", "03109": "42.9713_-71.4135", "03110": "42.9403_-71.5213", "03111": "42.9956_-71.4548", "03244": "43.1141_-71.8992", "03281": "43.0714_-71.7038", "03440": "43.0595_-71.9387", "03442": "43.0103_-71.9153", "03449": "42.9768_-71.9819", "03458": "42.8856_-71.947", "03468": "42.8908_-71.9334", "03046": "43.1025_-71.6169", "03106": "43.0617_-71.4444", "03216": "43.4287_-71.783", "03221": "43.2517_-71.9617", "03224": "43.357_-71.557", "03229": "43.1978_-71.6968", "03230": "43.5115_-71.8691", "03231": "43.4595_-71.7476", "03233": "43.4209_-71.9373", "03234": "43.2174_-71.3546", "03235": "43.4426_-71.6491", "03242": "43.1791_-71.8159", "03243": "43.5274_-71.7292", "03255": "43.3217_-72.0118", "03257": "43.4145_-71.9857", "03260": "43.3653_-71.9341", "03263": "43.2874_-71.333", "03268": "43.4067_-71.7045", "03272": "43.2956_-71.9967", "03273": "43.3042_-71.9289", "03275": "43.1604_-71.4179", "03278": "43.3035_-71.8353", "03287": "43.4485_-71.9158", "03301": "43.2185_-71.5277", "03302": "43.3103_-71.6629", "03303": "43.2817_-71.6595", "03304": "43.1388_-71.5448", "03305": "43.2134_-71.5172", "03307": "43.3193_-71.467", "03032": "42.9925_-71.3449", "03034": "43.0585_-71.3049", "03036": "42.9678_-71.245", "03037": "43.1378_-71.2513", "03038": "42.8874_-71.302", "03040": "43.0481_-71.2487", "03041": "42.8945_-71.2912", "03042": "43.0411_-71.0764", "03044": "42.984_-71.1218", "03053": "42.8656_-71.3772", "03073": "42.837_-71.2206", "03077": "43.0325_-71.1912", "03079": "42.7846_-71.2176", "03087": "42.8051_-71.3067", "03261": "43.207_-71.2004", "03290": "43.1196_-71.111", "03291": "43.1823_-71.1396", "03801": "43.0729_-70.8052", "03802": "43.0718_-70.7626", "03803": "43.0718_-70.7626", "03804": "43.0718_-70.7626", "03811": "42.837_-71.1603", "03819": "42.9234_-71.121", "03826": "42.8877_-71.128", "03827": "42.907_-70.9876", "03833": "42.9815_-70.9478", "03840": "43.0353_-70.8475", "03841": "42.882_-71.1758", "03842": "42.9359_-70.8243", "03843": "43.0059_-71.0132", "03844": "42.9263_-70.8876", "03848": "42.9133_-71.0639", "03854": "43.0681_-70.7199", "03856": "43.0374_-70.9782", "03857": "43.0726_-70.9553", "03858": "42.8678_-71.042", "03859": "42.8619_-71.04", "03862": "42.9776_-70.8267", "03865": "42.8356_-71.0934", "03870": "43.0095_-70.7652", "03871": "42.9806_-70.7719", "03873": "42.9308_-71.1861", "03874": "42.8854_-70.8646", "03885": "43.0194_-70.8997", "03815": "43.2629_-71.1071", "03820": "43.1888_-70.8868", "03821": "43.1979_-70.8737", "03822": "43.1979_-70.8737", "03823": "43.1729_-70.9412", "03824": "43.1174_-70.9197", "03825": "43.2027_-71.0377", "03835": "43.3884_-71.0647", "03839": "43.262_-70.9837", "03851": "43.4229_-71.0114", "03852": "43.5025_-70.9697", "03855": "43.443_-71.1408", "03866": "43.3045_-70.9756", "03867": "43.3045_-70.9756", "03868": "43.32_-70.9413", "03869": "43.2269_-70.8332", "03878": "43.2525_-70.8756", "03884": "43.2506_-71.1625", "03887": "43.4861_-71.063", "03280": "43.1747_-72.0824", "03284": "43.4938_-72.047", "03601": "43.196_-72.3001", "03603": "43.2573_-72.4064", "03605": "43.2136_-72.1968", "03607": "43.1956_-72.2686", "03743": "43.3679_-72.3422", "03745": "43.4963_-72.3394", "03746": "43.4973_-72.2795", "03751": "43.4317_-72.0673", "03752": "43.3026_-72.1241", "03753": "43.5103_-72.1334", "03754": "43.3767_-72.1381", "03770": "43.5299_-72.2756", "03773": "43.3532_-72.1838", "03781": "43.5519_-72.2704", "03782": "43.3868_-72.095", "08037": "39.638_-74.7728", "08201": "39.4218_-74.4949", "08203": "39.4101_-74.3646", "08205": "39.4745_-74.4575", "08213": "39.5092_-74.6086", "08215": "39.5331_-74.6177", "08217": "39.5737_-74.72", "08220": "39.4921_-74.429", "08221": "39.3469_-74.5807", "08225": "39.3703_-74.5552", "08231": "39.4712_-74.4604", "08232": "39.3876_-74.5149", "08234": "39.3741_-74.6118", "08240": "39.4877_-74.5543", "08241": "39.5272_-74.4903", "08244": "39.3223_-74.6008", "08310": "39.537_-74.8895", "08317": "39.4031_-74.8316", "08319": "39.3783_-74.8165", "08326": "39.5239_-74.9377", "08330": "39.432_-74.6962", "08340": "39.4451_-74.8667", "08341": "39.5155_-74.9467", "08342": "39.5021_-74.8335", "08346": "39.5645_-74.859", "08350": "39.485_-74.8776", "08401": "39.3664_-74.4317", "08402": "39.3286_-74.509", "08403": "39.3194_-74.5356", "08404": "39.3643_-74.4229", "08405": "39.3643_-74.4229", "08406": "39.346_-74.4723", "07010": "40.8222_-73.988", "07020": "40.8317_-73.9738", "07022": "40.817_-74", "07024": "40.8503_-73.9745", "07026": "40.8789_-74.1081", "07031": "40.7898_-74.1343", "07057": "40.8536_-74.1079", "07070": "40.8292_-74.1121", "07071": "40.8094_-74.1245", "07072": "40.8403_-74.0925", "07073": "40.8385_-74.1041", "07074": "40.8394_-74.0566", "07075": "40.8493_-74.0878", "07401": "41.0327_-74.1342", "07407": "40.9069_-74.1209", "07410": "40.9343_-74.1166", "07417": "41.0081_-74.2113", "07423": "41.0004_-74.1025", "07430": "41.0817_-74.1861", "07432": "40.9957_-74.1409", "07436": "41.0294_-74.2338", "07446": "41.0577_-74.1445", "07450": "40.982_-74.1131", "07451": "40.9793_-74.1165", "07452": "40.9602_-74.1254", "07458": "41.0443_-74.0981", "07463": "41.013_-74.1243", "07481": "40.9978_-74.166", "07495": "41.1039_-74.1644", "07601": "40.8882_-74.0503", "07602": "40.8859_-74.0435", "07603": "40.8744_-74.0281", "07604": "40.8623_-74.0756", "07605": "40.8629_-73.9879", "07606": "40.8634_-74.0456", "07607": "40.9024_-74.0629", "07608": "40.864_-74.0556", "07620": "40.9511_-73.9308", "07621": "40.9238_-73.9989", "07624": "40.9721_-73.959", "07626": "40.9418_-73.9652", "07627": "40.9548_-73.9602", "07628": "40.9447_-73.9921", "07630": "40.9755_-74.0285", "07631": "40.8943_-73.9772", "07632": "40.882_-73.9544", "07640": "40.9918_-73.98", "07641": "40.9608_-73.9874", "07642": "41.0069_-74.0426", "07643": "40.8493_-74.0405", "07644": "40.8764_-74.0838", "07645": "41.0495_-74.0384", "07646": "40.9331_-74.0195", "07647": "41.0086_-73.9389", "07648": "40.9952_-73.9582", "07649": "40.9535_-74.0335", "07650": "40.8462_-73.9954", "07652": "40.9477_-74.0672", "07653": "40.9481_-74.0832", "07656": "41.0343_-74.0396", "07657": "40.8326_-74.0015", "07660": "40.8562_-74.023", "07661": "40.9265_-74.0392", "07662": "40.9057_-74.079", "07663": "40.9031_-74.0955", "07666": "40.8915_-74.0119", "07670": "40.9216_-73.9659", "07675": "41.0092_-74.0041", "07676": "40.9883_-74.0635", "07677": "41.0234_-74.0603", "07699": "40.8463_-74.0611", "08010": "40.0565_-74.9114", "08011": "39.976_-74.7114", "08015": "39.9597_-74.5655", "08016": "40.068_-74.8454", "08019": "39.8019_-74.5256", "08022": "40.0642_-74.6899", "08036": "39.9872_-74.8293", "08041": "40.0387_-74.6873", "08042": "40.0123_-74.6646", "08046": "40.029_-74.8835", "08048": "39.9651_-74.8067", "08052": "39.9511_-74.9946", "08053": "39.8845_-74.9067", "08054": "39.9478_-74.9036", "08055": "39.8637_-74.8223", "08057": "39.9683_-74.9533", "08060": "40.0086_-74.7896", "08064": "39.9582_-74.6279", "08065": "40.0037_-75.0257", "08068": "39.9712_-74.6676", "08073": "40.0095_-74.8668", "08075": "40.0293_-74.9497", "08076": "40.0115_-75.0149", "08077": "40.002_-74.9952", "08088": "39.8604_-74.6693", "08224": "39.5923_-74.451", "08505": "40.1431_-74.7032", "08511": "40.0481_-74.5595", "08515": "40.1151_-74.6393", "08518": "40.118_-74.8055", "08554": "40.1154_-74.7772", "08562": "40.072_-74.5731", "08640": "40.2171_-74.7429", "08641": "40.2171_-74.7429", "08002": "39.9308_-75.0175", "08003": "39.8805_-74.9706", "08004": "39.76_-74.8665", "08007": "39.8651_-75.0564", "08009": "39.7788_-74.9308", "08012": "39.7901_-75.0367", "08018": "39.7154_-74.9007", "08021": "39.8036_-75.0058", "08026": "39.8365_-74.971", "08029": "39.8404_-75.0697", "08030": "39.8911_-75.117", "08031": "39.8689_-75.0944", "08033": "39.8954_-75.0417", "08034": "39.9074_-75.0008", "08035": "39.8788_-75.0664", "08043": "39.8504_-74.9646", "08045": "39.8676_-75.0317", "08049": "39.8538_-75.0393", "08059": "39.8827_-75.0929", "08078": "39.8508_-75.0742", "08081": "39.7354_-74.9864", "08083": "39.84_-75.0309", "08084": "39.8288_-75.0147", "08089": "39.7215_-74.8609", "08091": "39.8051_-74.9255", "08095": "39.6549_-74.8685", "08099": "39.8676_-75.0946", "08101": "39.9259_-75.1196", "08102": "39.9512_-75.1186", "08103": "39.9351_-75.1117", "08104": "39.9186_-75.1078", "08105": "39.9484_-75.0864", "08106": "39.891_-75.0724", "08107": "39.908_-75.0849", "08108": "39.9157_-75.0634", "08109": "39.9519_-75.0482", "08110": "39.9723_-75.0607", "08202": "39.0951_-74.7262", "08204": "38.9711_-74.9214", "08210": "39.1378_-74.7806", "08212": "38.9372_-74.9654", "08214": "39.1932_-74.8252", "08218": "39.1415_-74.8529", "08219": "39.0462_-74.9013", "08223": "39.2586_-74.6593", "08226": "39.2709_-74.5875", "08230": "39.2154_-74.7075", "08242": "39.0196_-74.8756", "08243": "39.154_-74.7005", "08245": "39.1_-74.8487", "08246": "39.179_-74.7599", "08247": "39.0533_-74.762", "08248": "39.1992_-74.6554", "08250": "39.2901_-74.7538", "08251": "39.0219_-74.9354", "08252": "39.0421_-74.8618", "08260": "38.9949_-74.838", "08270": "39.2716_-74.7968", "08302": "39.3762_-75.1617", "08311": "39.337_-75.1994", "08313": "39.5293_-75.2249", "08314": "39.2023_-74.9705", "08315": "39.2732_-75.095", "08316": "39.2679_-74.9791", "08320": "39.3799_-75.2217", "08321": "39.2189_-75.1403", "08323": "39.4055_-75.3209", "08324": "39.224_-74.9942", "08327": "39.2568_-74.9874", "08329": "39.2853_-74.9983", "08332": "39.3673_-75.0293", "08345": "39.2832_-75.1716", "08348": "39.3131_-74.9807", "08349": "39.2563_-75.0506", "08352": "39.4782_-75.1313", "08353": "39.4594_-75.297", "08360": "39.4818_-75.0091", "08361": "39.4655_-74.9653", "08362": "39.4862_-75.0257", "07003": "40.8035_-74.1891", "07004": "40.8822_-74.296", "07006": "40.8545_-74.2789", "07007": "40.8398_-74.2765", "07009": "40.8534_-74.2297", "07017": "40.7696_-74.2077", "07018": "40.7558_-74.2198", "07019": "40.7673_-74.2049", "07021": "40.8279_-74.2797", "07028": "40.804_-74.2055", "07039": "40.7896_-74.3202", "07040": "40.7279_-74.2656", "07041": "40.7228_-74.3015", "07042": "40.8131_-74.2165", "07043": "40.843_-74.2011", "07044": "40.8319_-74.2428", "07050": "40.7692_-74.2355", "07051": "40.7918_-74.2452", "07052": "40.7859_-74.2568", "07068": "40.8203_-74.3047", "07078": "40.7368_-74.3271", "07079": "40.7465_-74.2575", "07101": "40.7361_-74.2251", "07102": "40.732_-74.1765", "07103": "40.737_-74.1964", "07104": "40.7664_-74.1695", "07105": "40.7271_-74.1563", "07106": "40.7415_-74.233", "07107": "40.7607_-74.1882", "07108": "40.7236_-74.2015", "07109": "40.7946_-74.1631", "07110": "40.8185_-74.1589", "07111": "40.7261_-74.2313", "07112": "40.7107_-74.2131", "07114": "40.7082_-74.1891", "07175": "40.7357_-74.1724", "07184": "40.7918_-74.2452", "07188": "40.7357_-74.1724", "07189": "40.7918_-74.2452", "07191": "40.7918_-74.2452", "07192": "40.7357_-74.1724", "07193": "40.7357_-74.1724", "07195": "40.7357_-74.1724", "07198": "40.7918_-74.2452", "07199": "40.7357_-74.1724", "08014": "39.8016_-75.3478", "08020": "39.7992_-75.2237", "08025": "39.7015_-75.1629", "08027": "39.8231_-75.2751", "08028": "39.7068_-75.1172", "08032": "39.7788_-75.0601", "08039": "39.6931_-75.2711", "08051": "39.787_-75.1785", "08056": "39.7857_-75.2498", "08061": "39.8097_-75.2082", "08062": "39.7252_-75.2065", "08063": "39.8664_-75.1794", "08066": "39.8312_-75.2242", "08071": "39.7312_-75.1297", "08074": "39.7206_-75.1681", "08080": "39.7473_-75.0899", "08085": "39.7529_-75.3362", "08086": "39.8457_-75.1943", "08090": "39.7993_-75.1536", "08093": "39.8605_-75.1323", "08094": "39.665_-74.971", "08096": "39.7539_-74.996", "08097": "39.8142_-75.153", "08312": "39.659_-75.0942", "08322": "39.6156_-75.0409", "08328": "39.5755_-75.0582", "08343": "39.6442_-75.1568", "08344": "39.5553_-75.0276", "07002": "40.6664_-74.1192", "07029": "40.7445_-74.1508", "07030": "40.7445_-74.0329", "07032": "40.7647_-74.1471", "07047": "40.7939_-74.0258", "07086": "40.7681_-74.0208", "07087": "40.7674_-74.0323", "07093": "40.7888_-74.0115", "07094": "40.791_-74.0634", "07096": "40.7328_-74.0755", "07097": "40.7328_-74.0755", "07099": "40.7328_-74.0755", "07302": "40.7221_-74.0469", "07303": "40.7328_-74.0755", "07304": "40.718_-74.0754", "07305": "40.702_-74.089", "07306": "40.7321_-74.066", "07307": "40.7482_-74.0498", "07308": "40.7328_-74.0755", "07310": "40.7324_-74.0431", "07311": "40.7323_-74.0754", "07395": "40.7279_-74.078", "07399": "40.7323_-74.0754", "07830": "40.7162_-74.8152", "07979": "40.7026_-74.7276", "08530": "40.3731_-74.9266", "08551": "40.4459_-74.8288", "08556": "40.42_-74.9886", "08557": "40.4459_-74.9435", "08559": "40.4397_-74.9554", "08801": "40.6287_-74.8855", "08803": "40.5218_-75.006", "08804": "40.6437_-75.0966", "08809": "40.6412_-74.9088", "08822": "40.518_-74.8453", "08825": "40.5208_-75.0325", "08826": "40.7134_-74.9162", "08827": "40.6774_-74.9622", "08829": "40.6684_-74.8937", "08833": "40.6466_-74.829", "08834": "40.5637_-74.9494", "08848": "40.5929_-75.1025", "08858": "40.6726_-74.7474", "08867": "40.5992_-74.9576", "08868": "40.5655_-74.9389", "08870": "40.5687_-74.7377", "08885": "40.5764_-74.8311", "08887": "40.5206_-74.7946", "08888": "40.6194_-74.7406", "08889": "40.6156_-74.7724", "08520": "40.2669_-74.525", "08525": "40.3902_-74.771", "08534": "40.3339_-74.7944", "08540": "40.3666_-74.6408", "08541": "40.3487_-74.659", "08542": "40.3535_-74.6594", "08543": "40.2805_-74.712", "08544": "40.3492_-74.6528", "08550": "40.2669_-74.6511", "08560": "40.3077_-74.8655", "08561": "40.2423_-74.5787", "08601": "40.2805_-74.712", "08602": "40.2805_-74.712", "08603": "40.2805_-74.712", "08604": "40.2805_-74.712", "08605": "40.2805_-74.712", "08606": "40.2805_-74.712", "08607": "40.2805_-74.712", "08608": "40.2204_-74.7622", "08609": "40.2248_-74.741", "08610": "40.2016_-74.705", "08611": "40.2171_-74.7429", "08618": "40.2377_-74.7821", "08619": "40.2418_-74.6962", "08620": "40.167_-74.6488", "08625": "40.2805_-74.712", "08628": "40.2655_-74.8168", "08629": "40.2196_-74.7334", "08638": "40.251_-74.7627", "08644": "40.2171_-74.7429", "08645": "40.2805_-74.712", "08646": "40.2805_-74.712", "08647": "40.2805_-74.712", "08648": "40.2171_-74.7429", "08650": "40.2805_-74.712", "08666": "40.2805_-74.712", "08690": "40.2336_-74.6576", "08691": "40.2197_-74.5939", "08695": "40.2805_-74.712", "07001": "40.5826_-74.2785", "07008": "40.5823_-74.2313", "07064": "40.5709_-74.2466", "07067": "40.5937_-74.3164", "07077": "40.5542_-74.2607", "07080": "40.5839_-74.4147", "07095": "40.556_-74.2845", "08512": "40.3039_-74.5065", "08536": "40.3324_-74.5688", "08810": "40.3825_-74.5111", "08812": "40.5897_-74.4639", "08816": "40.4284_-74.4064", "08817": "40.5171_-74.3973", "08818": "40.43_-74.4173", "08820": "40.578_-74.3589", "08824": "40.4208_-74.5529", "08828": "40.3777_-74.4204", "08830": "40.5716_-74.3167", "08831": "40.3192_-74.4285", "08832": "40.5192_-74.3021", "08837": "40.5325_-74.3375", "08840": "40.5449_-74.3517", "08846": "40.5759_-74.5008", "08850": "40.4493_-74.439", "08852": "40.3869_-74.5558", "08854": "40.5515_-74.459", "08855": "40.43_-74.4173", "08857": "40.398_-74.3236", "08859": "40.4587_-74.305", "08861": "40.5176_-74.2754", "08862": "40.43_-74.4173", "08863": "40.5393_-74.3117", "08871": "40.43_-74.4173", "08872": "40.46_-74.3478", "08879": "40.464_-74.2742", "08882": "40.4444_-74.3801", "08884": "40.3847_-74.3894", "08899": "40.5203_-74.4205", "08901": "40.4891_-74.4482", "08902": "40.4538_-74.4823", "08903": "40.5139_-74.4451", "08904": "40.4991_-74.4266", "08906": "40.4862_-74.4518", "08933": "40.4862_-74.4518", "08989": "40.43_-74.4173", "07701": "40.3584_-74.0681", "07702": "40.3282_-74.0589", "07703": "40.3177_-74.039", "07704": "40.3599_-74.0389", "07710": "40.2182_-74.2563", "07711": "40.2367_-74.0067", "07712": "40.2507_-74.0486", "07715": "40.1784_-74.0218", "07716": "40.4015_-74.0309", "07717": "40.1918_-74.0167", "07718": "40.4173_-74.0889", "07719": "40.1688_-74.072", "07720": "40.2023_-74.0132", "07721": "40.4353_-74.2358", "07722": "40.3012_-74.178", "07723": "40.2506_-74.002", "07724": "40.3028_-74.0698", "07726": "40.2825_-74.3424", "07727": "40.2043_-74.1779", "07728": "40.2458_-74.2768", "07730": "40.4226_-74.1799", "07731": "40.1481_-74.2137", "07732": "40.4037_-73.9915", "07733": "40.3859_-74.174", "07734": "40.4414_-74.1306", "07735": "40.4332_-74.1996", "07737": "40.4177_-74.0623", "07738": "40.3369_-74.1205", "07739": "40.3354_-74.0413", "07740": "40.2992_-73.9912", "07746": "40.3182_-74.2639", "07747": "40.4109_-74.238", "07748": "40.3944_-74.1157", "07750": "40.333_-73.9809", "07751": "40.3529_-74.2779", "07752": "40.4023_-74.0273", "07753": "40.2096_-74.0714", "07754": "40.2001_-74.0279", "07755": "40.2648_-74.0184", "07756": "40.2116_-74.0093", "07757": "40.3157_-74.0164", "07758": "40.4289_-74.1083", "07760": "40.3707_-74.0084", "07762": "40.1542_-74.0379", "07763": "40.2796_-74.3343", "07764": "40.2878_-74.0162", "07765": "40.3501_-74.2479", "07799": "40.3027_-74.2493", "08501": "40.1589_-74.5909", "08510": "40.147_-74.609", "08514": "40.1399_-74.465", "08526": "40.1623_-74.4759", "08535": "40.2739_-74.7162", "08555": "40.2214_-74.4747", "08720": "40.1389_-74.1122", "08730": "40.1077_-74.0635", "08736": "40.1217_-74.0611", "08750": "40.1345_-74.0436", "07005": "40.9115_-74.414", "07034": "40.8825_-74.383", "07035": "40.9208_-74.2995", "07045": "40.9049_-74.3646", "07046": "40.8904_-74.4415", "07054": "40.8621_-74.4117", "07058": "40.8742_-74.35", "07082": "40.9277_-74.3428", "07405": "40.9988_-74.4261", "07440": "40.9473_-74.296", "07444": "40.9655_-74.3016", "07457": "40.9931_-74.3088", "07801": "40.9176_-74.5467", "07802": "40.8673_-74.5783", "07803": "40.8771_-74.5845", "07806": "40.8673_-74.5783", "07828": "40.8731_-74.7426", "07834": "40.8897_-74.4844", "07836": "40.8453_-74.7019", "07842": "40.944_-74.4927", "07845": "40.8229_-74.6257", "07847": "40.8819_-74.621", "07849": "40.9506_-74.6129", "07850": "40.9087_-74.6554", "07852": "40.878_-74.6554", "07853": "40.7878_-74.787", "07856": "40.9283_-74.6363", "07857": "40.8985_-74.6985", "07866": "40.9229_-74.5094", "07869": "40.8456_-74.5725", "07870": "40.7993_-74.8138", "07876": "40.8539_-74.6536", "07878": "40.8711_-74.4777", "07885": "40.9139_-74.5863", "07926": "40.8004_-74.5718", "07927": "40.8223_-74.4569", "07928": "40.7305_-74.4017", "07930": "40.7892_-74.6776", "07932": "40.7757_-74.3928", "07933": "40.6877_-74.4681", "07935": "40.7416_-74.4517", "07936": "40.8192_-74.3636", "07940": "40.7599_-74.4179", "07945": "40.7789_-74.6", "07946": "40.6727_-74.5183", "07950": "40.8445_-74.4824", "07960": "40.7952_-74.4873", "07961": "40.7968_-74.4815", "07962": "40.8673_-74.5783", "07963": "40.7968_-74.4815", "07970": "40.8055_-74.5738", "07976": "40.7347_-74.4845", "07980": "40.6774_-74.4968", "07981": "40.8219_-74.42", "07999": "40.8673_-74.5783", "08005": "39.7552_-74.247", "08006": "39.7512_-74.1146", "08008": "39.6411_-74.1922", "08050": "39.705_-74.2604", "08087": "39.5881_-74.3646", "08092": "39.6627_-74.2885", "08527": "40.121_-74.3017", "08533": "40.0713_-74.5067", "08701": "40.085_-74.2042", "08721": "39.9093_-74.1549", "08722": "39.9302_-74.1961", "08723": "40.0389_-74.1109", "08724": "40.0874_-74.1152", "08731": "39.8444_-74.1973", "08732": "39.9432_-74.1468", "08733": "40.0263_-74.3254", "08734": "39.862_-74.1668", "08735": "39.9775_-74.0704", "08738": "40.0261_-74.0562", "08739": "40.0026_-74.0604", "08740": "39.926_-74.1351", "08741": "39.9347_-74.168", "08742": "40.0806_-74.0595", "08751": "39.9466_-74.0765", "08752": "39.9222_-74.0795", "08753": "39.9771_-74.1565", "08754": "40.0008_-74.2493", "08755": "39.9999_-74.2228", "08756": "39.788_-74.1911", "08757": "39.9715_-74.2512", "08758": "39.7896_-74.1954", "08759": "39.9515_-74.1521", "07011": "40.8789_-74.1425", "07012": "40.8488_-74.1612", "07013": "40.8693_-74.1711", "07014": "40.8344_-74.1377", "07015": "40.8584_-74.1638", "07055": "40.8601_-74.1283", "07403": "41.0128_-74.3338", "07420": "41.0301_-74.2965", "07421": "41.1709_-74.3686", "07424": "40.8835_-74.2144", "07435": "41.0647_-74.4359", "07438": "41.0302_-74.5198", "07442": "40.9993_-74.2876", "07456": "41.0928_-74.2659", "07465": "41.0544_-74.279", "07470": "40.9471_-74.2466", "07474": "40.9481_-74.245", "07480": "41.0915_-74.375", "07501": "40.9143_-74.1671", "07502": "40.9199_-74.1932", "07503": "40.897_-74.1573", "07504": "40.9122_-74.1452", "07505": "40.9166_-74.174", "07506": "40.9564_-74.1569", "07507": "40.9493_-74.1538", "07508": "40.9457_-74.1826", "07509": "40.9168_-74.1718", "07510": "40.9168_-74.1718", "07511": "41.0114_-74.3048", "07512": "40.9048_-74.2168", "07513": "40.907_-74.1529", "07514": "40.9248_-74.1467", "07522": "40.9252_-74.1781", "07524": "40.9309_-74.1555", "07533": "41.0114_-74.3048", "07538": "40.9357_-74.1863", "07543": "41.0114_-74.3048", "07544": "41.0114_-74.3048", "08001": "39.5591_-75.3506", "08023": "39.6815_-75.4934", "08038": "39.4716_-75.4902", "08067": "39.7435_-75.412", "08069": "39.6994_-75.4495", "08070": "39.6491_-75.5155", "08072": "39.5459_-75.4124", "08079": "39.5591_-75.4521", "08098": "39.6457_-75.3248", "08318": "39.5691_-75.163", "08347": "39.4998_-75.082", "07059": "40.6318_-74.5105", "07920": "40.6789_-74.5605", "07921": "40.6571_-74.6432", "07924": "40.7225_-74.5778", "07931": "40.6996_-74.6536", "07934": "40.7219_-74.6707", "07938": "40.6554_-74.5862", "07939": "40.6674_-74.5539", "07977": "40.7079_-74.6541", "07978": "40.6425_-74.6396", "08502": "40.4483_-74.6557", "08504": "40.4076_-74.7027", "08528": "40.3828_-74.6096", "08553": "40.401_-74.64", "08558": "40.4173_-74.6938", "08805": "40.5681_-74.5397", "08807": "40.5904_-74.6267", "08821": "40.517_-74.6843", "08823": "40.4421_-74.5369", "08835": "40.5399_-74.5934", "08836": "40.6_-74.5572", "08844": "40.4775_-74.6272", "08853": "40.5293_-74.7401", "08869": "40.5711_-74.6377", "08873": "40.5007_-74.5013", "08875": "40.4976_-74.4885", "08876": "40.588_-74.6874", "08880": "40.5523_-74.5311", "08890": "40.5361_-74.5789", "07416": "41.1164_-74.5865", "07418": "41.2356_-74.4885", "07419": "41.1467_-74.5874", "07422": "41.1826_-74.4564", "07428": "41.2065_-74.5381", "07439": "41.0767_-74.5982", "07460": "41.0992_-74.5283", "07461": "41.2292_-74.5992", "07462": "41.185_-74.5332", "07821": "40.9614_-74.7524", "07822": "41.1451_-74.6848", "07826": "41.1705_-74.75", "07827": "41.3023_-74.754", "07837": "41.1283_-74.679", "07839": "40.974_-74.821", "07843": "40.939_-74.6616", "07848": "41.0761_-74.6912", "07851": "41.2299_-74.8466", "07855": "41.0559_-74.8629", "07860": "41.0695_-74.8069", "07871": "41.0277_-74.6407", "07874": "40.9217_-74.7004", "07875": "41.0439_-74.872", "07877": "41.1029_-74.8508", "07879": "40.9559_-74.7881", "07881": "41.1256_-74.9177", "07890": "41.1465_-74.7524", "07016": "40.6554_-74.3057", "07023": "40.6419_-74.3868", "07027": "40.6512_-74.3239", "07033": "40.6759_-74.2944", "07036": "40.6354_-74.2556", "07060": "40.6152_-74.415", "07061": "40.6657_-74.2997", "07062": "40.6323_-74.3997", "07063": "40.6048_-74.4427", "07065": "40.6087_-74.2819", "07066": "40.6203_-74.3106", "07069": "40.6378_-74.4514", "07076": "40.6379_-74.3682", "07081": "40.7015_-74.3227", "07083": "40.6952_-74.2677", "07088": "40.7179_-74.2829", "07090": "40.6479_-74.3451", "07091": "40.6657_-74.2997", "07092": "40.6785_-74.3588", "07201": "40.6717_-74.2043", "07202": "40.6565_-74.2215", "07203": "40.653_-74.261", "07204": "40.6651_-74.267", "07205": "40.6968_-74.2281", "07206": "40.6501_-74.1871", "07207": "40.664_-74.2107", "07208": "40.6747_-74.2239", "07901": "40.7149_-74.3642", "07902": "40.7156_-74.3647", "07922": "40.6752_-74.4346", "07974": "40.7004_-74.4023", "07820": "40.9218_-74.8102", "07823": "40.8308_-75.0503", "07825": "40.9674_-74.9651", "07829": "40.8434_-74.9859", "07831": "40.7394_-74.9448", "07832": "40.9388_-75.055", "07833": "40.8929_-75.0646", "07838": "40.852_-74.9418", "07840": "40.8529_-74.8343", "07844": "40.9197_-74.9846", "07846": "40.9645_-74.8785", "07863": "40.8105_-75.0019", "07865": "40.7906_-74.9167", "07880": "40.8648_-74.897", "07882": "40.7582_-74.9914", "08802": "40.695_-75.0281", "08808": "40.732_-75.0516", "08865": "40.7079_-75.1507", "08886": "40.6937_-75.111", "87008": "35.1285_-106.3617", "87022": "34.9073_-106.6892", "87047": "35.1683_-106.3238", "87059": "35.0446_-106.3062", "87101": "35.1996_-106.6448", "87102": "35.0818_-106.6482", "87103": "35.0443_-106.6729", "87104": "35.1038_-106.6712", "87105": "35.0448_-106.6893", "87106": "35.079_-106.6169", "87107": "35.1347_-106.6427", "87108": "35.0726_-106.5749", "87109": "35.1506_-106.569", "87110": "35.1104_-106.5781", "87111": "35.1347_-106.5222", "87112": "35.101_-106.5183", "87113": "35.1759_-106.6015", "87114": "35.1868_-106.6652", "87115": "35.0549_-106.5461", "87116": "35.0561_-106.5506", "87117": "35.0203_-106.5503", "87119": "35.0443_-106.6729", "87120": "35.1421_-106.7041", "87121": "35.0512_-106.7269", "87122": "35.1787_-106.5102", "87123": "35.0717_-106.509", "87125": "35.0443_-106.6729", "87131": "35.0443_-106.6729", "87151": "35.023_-106.8556", "87153": "35.0443_-106.6729", "87154": "35.0443_-106.6729", "87158": "35.0845_-106.6511", "87174": "35.0443_-106.6729", "87176": "35.0443_-106.6729", "87181": "35.0443_-106.6729", "87184": "35.0443_-106.6729", "87185": "35.0443_-106.6729", "87187": "35.0443_-106.6729", "87190": "35.0443_-106.6729", "87191": "35.0443_-106.6729", "87192": "35.0443_-106.6729", "87193": "35.0443_-106.6729", "87194": "35.0443_-106.6729", "87195": "35.0443_-106.6729", "87196": "35.0443_-106.6729", "87197": "35.0845_-106.6511", "87198": "35.0845_-106.6511", "87199": "35.0443_-106.6729", "87820": "33.8859_-108.5466", "87821": "34.0427_-108.0183", "87824": "33.8189_-108.9545", "87827": "34.3243_-108.3682", "87829": "34.2652_-108.7578", "87830": "33.7131_-108.7578", "88039": "33.3048_-108.7743", "88201": "33.6397_-104.3748", "88202": "33.3038_-104.4318", "88203": "33.3718_-104.5284", "88230": "33.191_-104.3833", "88232": "33.1076_-104.3298", "88253": "32.9982_-104.3666", "87005": "35.255_-107.9856", "87007": "35.0456_-107.4714", "87014": "35.0859_-107.5181", "87020": "35.1476_-107.8526", "87021": "35.1698_-107.8909", "87026": "34.9625_-107.2325", "87038": "35.0409_-107.422", "87040": "35.1387_-107.3789", "87049": "35.0823_-107.5992", "87051": "35.1125_-107.8826", "87315": "34.7344_-108.6934", "87357": "34.9992_-108.4112", "87710": "36.3849_-105.2439", "87714": "36.4574_-105.0697", "87718": "36.5326_-105.2756", "87728": "36.5434_-104.564", "87729": "36.35_-104.7931", "87740": "36.8952_-104.4349", "87747": "36.3767_-104.5927", "87749": "36.5581_-105.115", "88101": "34.4126_-103.2214", "88102": "34.4048_-103.2052", "88103": "34.3841_-103.3154", "88112": "34.804_-103.1292", "88120": "34.8107_-103.298", "88124": "34.4479_-103.6325", "88133": "34.4756_-103.4669", "88135": "34.3958_-103.0615", "88119": "34.46_-104.2317", "88134": "34.3271_-104.0159", "88136": "34.455_-104.7452", "87936": "32.7557_-107.2704", "87937": "32.6583_-107.159", "87940": "32.6597_-107.0643", "87941": "32.7093_-107.2157", "88001": "32.2901_-106.7539", "88002": "32.3839_-106.4937", "88003": "32.2738_-106.7472", "88004": "32.4181_-106.8201", "88005": "32.3161_-106.7991", "88006": "32.3052_-106.7863", "88007": "32.3224_-106.8041", "88008": "31.8394_-106.6821", "88011": "32.3244_-106.6683", "88012": "32.5835_-106.7714", "88013": "32.5835_-106.7714", "88021": "32.004_-106.6058", "88024": "32.0682_-106.631", "88027": "32.0401_-106.6856", "88032": "32.3895_-106.8139", "88033": "32.2984_-106.8812", "88044": "32.1383_-106.7999", "88046": "32.268_-106.8059", "88047": "32.21_-106.7147", "88048": "32.146_-106.6676", "88052": "32.4259_-106.6136", "88054": "32.4888_-106.9146", "88058": "32.1554_-106.735", "88063": "31.8186_-106.5997", "88072": "32.1187_-106.649", "88210": "32.8384_-104.4074", "88211": "32.7536_-104.3281", "88220": "32.4119_-104.2395", "88221": "32.342_-104.2937", "88250": "32.8156_-104.7299", "88254": "32.6362_-104.365", "88255": "32.819_-103.9777", "88256": "32.274_-104.0914", "88263": "32.1813_-104.0668", "88268": "32.1757_-104.3766", "88022": "32.7839_-108.1854", "88023": "32.7617_-108.1306", "88025": "33.0633_-108.6956", "88026": "32.7795_-108.1503", "88028": "32.9623_-108.6112", "88034": "32.5642_-108.0242", "88036": "32.7574_-108.0075", "88038": "32.9659_-108.5767", "88040": "31.8904_-108.3316", "88041": "32.8045_-107.9545", "88043": "32.648_-108.1516", "88049": "32.909_-108.0332", "88051": "33.1071_-108.9032", "88053": "32.8614_-108.2192", "88055": "32.6862_-108.7381", "88061": "32.79_-108.2749", "88062": "32.7282_-108.1379", "88065": "32.7098_-108.302", "87711": "35.2001_-105.1422", "87724": "35.1734_-105.0775", "88353": "34.6241_-105.1926", "88417": "35.0312_-104.4086", "88431": "35.0847_-104.2433", "88435": "34.8526_-104.5899", "87730": "36.1281_-104.2277", "87733": "35.8041_-103.9021", "87743": "35.9522_-104.1497", "87746": "35.8484_-104.0675", "88009": "32.055_-108.6291", "88020": "32.053_-108.9069", "88045": "32.316_-108.723", "88056": "31.8358_-109.0322", "88114": "33.5272_-103.3564", "88213": "33.3939_-103.639", "88231": "32.4392_-103.1594", "88240": "32.7222_-103.1372", "88241": "32.7475_-103.2165", "88242": "32.8105_-103.1587", "88244": "32.7026_-103.136", "88252": "32.1128_-103.1997", "88260": "32.9512_-103.3488", "88262": "33.1407_-103.3174", "88264": "32.8562_-103.7627", "88265": "32.5874_-103.2703", "88267": "33.26_-103.314", "88301": "33.6496_-105.8696", "88312": "33.4314_-105.6776", "88316": "33.5602_-105.5269", "88318": "34.1693_-105.5339", "88323": "33.4959_-105.523", "88324": "33.3898_-105.4391", "88336": "33.3876_-105.2708", "88338": "33.4869_-105.382", "88341": "33.4996_-105.7036", "88343": "33.3518_-105.145", "88345": "33.3474_-105.651", "88346": "33.3577_-105.5383", "88348": "33.3877_-105.3498", "88351": "33.3706_-105.2264", "88355": "33.3305_-105.6933", "87544": "35.8663_-106.2676", "87545": "35.8639_-106.2953", "87547": "35.8275_-106.2039", "88029": "31.8276_-107.64", "88030": "32.2318_-107.7466", "88031": "32.2398_-107.7404", "87045": "35.3547_-108.1038", "87301": "35.5065_-108.7414", "87302": "35.5281_-108.7426", "87305": "35.4499_-108.7705", "87310": "35.8005_-108.5815", "87311": "35.5339_-108.5998", "87312": "35.4226_-108.323", "87313": "35.7206_-108.0271", "87316": "35.5191_-108.4864", "87317": "35.5763_-108.7626", "87319": "35.5042_-108.8317", "87320": "35.7837_-108.819", "87321": "35.1324_-108.492", "87322": "35.5289_-108.6548", "87323": "35.3976_-108.1604", "87325": "36.0021_-108.6229", "87326": "35.3509_-108.6985", "87327": "35.0684_-108.8336", "87328": "35.8942_-109.0226", "87347": "35.4809_-108.1767", "87365": "35.4809_-108.1767", "87375": "35.4809_-108.1767", "87712": "35.9136_-105.2492", "87713": "36.1388_-105.3854", "87715": "35.9898_-105.4326", "87722": "36.1375_-105.2386", "87723": "36.0384_-105.3836", "87732": "35.9742_-105.33", "87734": "36.1037_-105.066", "87735": "36.0578_-105.1183", "87736": "35.9786_-105.2092", "87750": "35.8164_-104.9231", "87752": "35.9814_-104.691", "87753": "35.7906_-104.9817", "88081": "32.2239_-106.2631", "88310": "32.8932_-105.9485", "88311": "32.8995_-105.9603", "88314": "33.148_-105.8635", "88317": "32.8897_-105.6744", "88325": "32.9396_-105.8189", "88330": "32.8366_-106.0774", "88337": "32.9774_-105.9534", "88339": "32.907_-105.5181", "88340": "33.2164_-105.7743", "88342": "32.3712_-106.0844", "88344": "32.6396_-105.4157", "88347": "32.8052_-105.6211", "88349": "32.8672_-105.7811", "88350": "32.6295_-105.6945", "88352": "33.065_-106.0108", "88354": "32.8052_-105.5063", "88121": "34.6952_-103.9203", "88401": "35.168_-103.7179", "88411": "35.1303_-103.1605", "88426": "35.3681_-103.4383", "88427": "34.6923_-103.7764", "88430": "35.618_-103.1317", "88433": "34.9167_-103.7782", "88434": "35.1198_-103.2846", "87012": "36.1018_-106.6692", "87017": "36.3202_-106.7687", "87029": "36.3249_-107.0495", "87064": "36.1875_-106.5564", "87510": "36.1769_-106.2449", "87511": "36.0889_-106.0536", "87515": "36.4795_-106.4378", "87516": "36.1814_-106.4376", "87518": "36.4654_-106.5785", "87520": "36.8962_-106.5829", "87522": "36.0039_-105.947", "87523": "36.0072_-105.8606", "87527": "36.179_-105.8615", "87528": "36.8598_-107.0602", "87530": "36.3647_-106.2192", "87531": "36.2153_-105.8901", "87532": "35.9872_-106.0717", "87533": "35.9866_-106.0654", "87537": "36.0738_-106.1396", "87539": "36.4654_-106.5785", "87548": "36.1756_-106.1834", "87551": "36.7292_-106.57", "87554": "36.5084_-106.0106", "87566": "36.0508_-106.069", "87575": "36.6805_-106.557", "87578": "36.0444_-105.8129", "87581": "36.5286_-106.1448", "87582": "36.1589_-105.9747", "88113": "33.7781_-103.0865", "88115": "33.9387_-103.3366", "88116": "33.9405_-103.6323", "88118": "34.252_-103.5827", "88122": "33.8423_-103.7719", "88123": "33.7176_-103.1451", "88125": "33.605_-103.2782", "88126": "33.8362_-103.3355", "88130": "34.1799_-103.3363", "88132": "33.9216_-103.1898", "87001": "35.389_-106.3517", "87004": "35.3285_-106.5309", "87013": "36.0482_-107.1885", "87018": "36.2092_-107.4578", "87024": "35.6243_-106.7219", "87025": "35.8927_-106.7714", "87027": "36.1194_-106.9923", "87041": "35.5709_-106.3381", "87043": "35.3092_-106.5293", "87044": "35.66_-106.6675", "87046": "36.1842_-106.9567", "87048": "35.2339_-106.62", "87052": "35.5269_-106.3445", "87053": "35.5634_-106.7706", "87072": "35.6089_-106.3518", "87083": "35.6485_-106.3428", "87124": "35.2493_-106.6818", "87144": "35.324_-106.7099", "87037": "36.1598_-107.7664", "87364": "36.142_-108.7064", "87401": "36.7412_-108.1797", "87402": "36.7685_-108.1478", "87410": "36.8205_-108.011", "87412": "36.7242_-107.8253", "87413": "36.6955_-107.9784", "87415": "36.8028_-108.0827", "87416": "36.6933_-108.4218", "87417": "36.741_-108.351", "87418": "36.9576_-108.1792", "87419": "36.8689_-107.6528", "87420": "36.656_-108.7355", "87421": "36.7637_-108.5186", "87455": "36.2847_-108.7059", "87461": "36.4247_-108.8743", "87499": "36.7745_-108.0692", "87538": "35.4212_-105.5589", "87552": "35.571_-105.6701", "87560": "35.3344_-105.4652", "87562": "35.4917_-105.6753", "87565": "35.4569_-105.4383", "87569": "35.3975_-105.3236", "87573": "35.7727_-105.6713", "87583": "35.2667_-105.3608", "87701": "35.5949_-105.2272", "87731": "35.6523_-105.2764", "87742": "35.8226_-105.3147", "87745": "35.762_-105.1077", "88416": "35.3786_-104.2052", "88421": "35.3502_-104.4419", "88439": "35.4563_-104.6796", "87010": "35.423_-106.1317", "87015": "35.0776_-106.1872", "87056": "35.1295_-106.0283", "87501": "35.6975_-105.9821", "87502": "35.687_-105.9378", "87503": "35.687_-105.9378", "87504": "35.687_-105.9378", "87505": "35.6219_-105.8688", "87506": "35.8195_-105.9886", "87507": "35.6567_-106.0152", "87508": "35.5335_-105.926", "87509": "35.5212_-105.9818", "87535": "35.5288_-105.7477", "87540": "35.4311_-105.9409", "87567": "35.986_-106.0318", "87574": "35.7874_-105.9157", "87592": "35.5212_-105.9818", "87594": "35.5212_-105.9818", "87654": "32.9903_-106.9697", "87901": "33.1606_-107.2669", "87930": "32.8487_-107.3192", "87931": "32.9641_-107.4102", "87933": "32.7881_-107.2822", "87935": "33.209_-107.2212", "87939": "33.397_-107.4509", "87942": "33.1171_-107.2915", "87943": "33.3061_-107.6675", "88042": "32.9239_-107.6276", "87011": "34.0646_-105.9496", "87028": "34.3813_-106.815", "87062": "34.485_-106.7591", "87801": "34.0479_-106.8907", "87823": "34.156_-106.9044", "87825": "34.1114_-107.2409", "87828": "34.2059_-106.9167", "87831": "34.2283_-106.9049", "87832": "33.819_-106.8285", "87512": "36.942_-105.4545", "87513": "36.5796_-105.6873", "87514": "36.52_-105.534", "87517": "36.3645_-105.7653", "87519": "36.7539_-105.6128", "87521": "36.1311_-105.7385", "87524": "36.9324_-105.6723", "87525": "36.596_-105.4545", "87529": "36.4317_-105.5747", "87543": "36.14_-105.6817", "87549": "36.3313_-106.0028", "87553": "36.1763_-105.7105", "87556": "36.7039_-105.595", "87557": "36.3357_-105.6086", "87558": "36.6659_-105.4694", "87564": "36.6116_-105.636", "87571": "36.3953_-105.5847", "87576": "36.1311_-105.7589", "87577": "36.647_-105.9672", "87579": "36.1338_-105.5712", "87580": "36.5701_-105.5658", "87009": "34.3706_-105.702", "87016": "34.77_-106.135", "87032": "34.8648_-106.0517", "87035": "34.9889_-106.0609", "87036": "34.5158_-106.2577", "87061": "34.6948_-106.3247", "87063": "34.5754_-106.0307", "87070": "35.0095_-105.6692", "88321": "34.615_-105.4839", "88410": "35.8983_-103.213", "88414": "36.7785_-103.9986", "88415": "36.4414_-103.1888", "88418": "36.7291_-103.8739", "88419": "36.869_-103.8399", "88422": "36.3048_-103.973", "88424": "36.3698_-103.5055", "88436": "36.226_-103.1449", "87002": "34.6511_-106.6952", "87006": "34.4996_-106.8038", "87023": "34.592_-106.7611", "87031": "34.7806_-106.7115", "87034": "34.8964_-107.5817", "87042": "34.8332_-106.6872", "87060": "34.7426_-106.7328", "87068": "34.8764_-106.6975", "89406": "39.4703_-118.7861", "89407": "39.4735_-118.7774", "89496": "39.4735_-118.7774", "88901": "36.3225_-114.8197", "88905": "35.9279_-114.9721", "89002": "36.0008_-114.9588", "89004": "36.0464_-115.4039", "89005": "35.9727_-114.8344", "89006": "35.9279_-114.9721", "89007": "36.7684_-114.1281", "89009": "35.9279_-114.9721", "89011": "36.1065_-114.9192", "89012": "36.0119_-115.0433", "89014": "36.0564_-115.078", "89015": "36.0357_-114.9718", "89016": "35.9279_-114.9721", "89018": "36.5697_-115.6706", "89019": "35.7368_-115.5405", "89021": "36.5935_-114.4683", "89024": "36.8101_-114.0722", "89025": "36.6916_-114.6514", "89026": "35.7789_-115.3239", "89027": "36.8113_-114.1235", "89028": "35.1604_-114.7464", "89029": "35.1321_-114.6368", "89030": "36.2115_-115.1241", "89031": "36.2589_-115.1718", "89032": "36.218_-115.1709", "89033": "36.2845_-115.1345", "89034": "36.809_-114.0591", "89036": "36.1989_-115.1175", "89037": "36.1579_-114.934", "89039": "35.2522_-114.8714", "89040": "36.5703_-114.4732", "89046": "35.5132_-114.8866", "89052": "35.9878_-115.1167", "89053": "35.9279_-114.9721", "89054": "35.935_-115.2058", "89067": "36.6591_-114.6656", "89070": "36.5697_-115.6706", "89074": "36.0384_-115.0857", "89077": "36.0397_-114.9819", "89081": "36.2583_-115.1068", "89084": "36.2815_-115.1482", "89085": "36.3097_-115.1981", "89086": "36.2809_-115.1349", "89087": "36.2204_-115.1458", "89101": "36.1721_-115.1224", "89102": "36.1433_-115.2004", "89103": "36.1149_-115.2161", "89104": "36.152_-115.1092", "89105": "36.086_-115.1471", "89106": "36.1847_-115.1617", "89107": "36.1705_-115.2176", "89108": "36.2044_-115.2233", "89109": "36.126_-115.1454", "89110": "36.173_-115.0669", "89111": "36.175_-115.1372", "89112": "36.1578_-115.0256", "89113": "36.0854_-115.2566", "89114": "36.0113_-115.1015", "89115": "36.2158_-115.0671", "89116": "36.175_-115.1372", "89117": "36.1302_-115.2755", "89118": "36.0811_-115.2169", "89119": "36.1008_-115.1365", "89120": "36.0914_-115.0885", "89121": "36.1232_-115.0902", "89122": "36.1205_-115.0523", "89123": "36.0383_-115.1462", "89124": "36.4257_-115.4809", "89125": "36.2235_-115.2655", "89126": "36.175_-115.1372", "89127": "36.175_-115.1372", "89128": "36.1968_-115.2644", "89129": "36.245_-115.2743", "89130": "36.2471_-115.221", "89131": "36.2956_-115.2419", "89132": "36.019_-115.1519", "89133": "36.175_-115.1372", "89134": "36.2092_-115.2941", "89135": "36.1378_-115.3261", "89136": "36.1753_-115.1364", "89137": "36.175_-115.1372", "89138": "36.1666_-115.3613", "89139": "36.0129_-115.2118", "89140": "36.086_-115.1471", "89141": "36.0104_-115.2073", "89142": "36.148_-115.0404", "89143": "36.3223_-115.2932", "89144": "36.1781_-115.3183", "89145": "36.1693_-115.2828", "89146": "36.1424_-115.2242", "89147": "36.1128_-115.2801", "89148": "36.0588_-115.3104", "89149": "36.2765_-115.2885", "89150": "36.175_-115.1372", "89151": "36.175_-115.1372", "89152": "36.175_-115.1372", "89153": "36.175_-115.1372", "89154": "36.175_-115.1372", "89155": "36.175_-115.1372", "89156": "36.2034_-115.0364", "89157": "36.175_-115.1372", "89158": "36.175_-115.1372", "89159": "36.175_-115.1372", "89160": "36.175_-115.1372", "89161": "36.0004_-115.3639", "89162": "36.1725_-115.1414", "89163": "36.175_-115.1372", "89164": "36.175_-115.1372", "89165": "36.3302_-115.3257", "89166": "36.3265_-115.3398", "89169": "36.1234_-115.1429", "89170": "36.175_-115.1372", "89173": "36.175_-115.1372", "89177": "36.175_-115.1372", "89178": "35.9977_-115.2861", "89179": "36.2542_-115.5269", "89180": "36.175_-115.1372", "89183": "35.9959_-115.1576", "89185": "36.175_-115.1372", "89191": "36.2395_-115.0257", "89193": "36.175_-115.1372", "89195": "36.175_-115.1372", "89199": "36.175_-115.1372", "89410": "38.8703_-119.6115", "89411": "39.0341_-119.8228", "89413": "39.0509_-119.9428", "89423": "39.0218_-119.7314", "89448": "39.0204_-119.9114", "89449": "38.9643_-119.9068", "89460": "38.9166_-119.7272", "89705": "39.0554_-119.8059", "89801": "40.9056_-115.5344", "89802": "40.8324_-115.7631", "89803": "40.8324_-115.7631", "89815": "40.7519_-115.5956", "89822": "40.7172_-116.1082", "89823": "41.0655_-115.2748", "89825": "41.8882_-114.7233", "89826": "41.8873_-115.3813", "89828": "40.7505_-115.3631", "89830": "41.2613_-114.1942", "89831": "41.8385_-115.9654", "89832": "41.9477_-116.0987", "89833": "40.3995_-115.2312", "89834": "41.3141_-116.2218", "89835": "41.1116_-114.9645", "89883": "40.7391_-114.0733", "89010": "37.7776_-118.084", "89013": "37.7085_-117.2356", "89047": "37.7225_-117.7965", "89316": "39.5897_-115.9943", "89821": "40.4138_-116.5813", "89404": "41.9899_-118.6343", "89414": "40.9532_-117.4893", "89421": "41.9708_-117.6737", "89425": "41.6654_-117.9083", "89426": "41.5057_-117.5728", "89438": "40.7927_-117.1268", "89445": "40.9664_-117.7467", "89446": "41.0764_-117.7602", "89310": "39.508_-117.0811", "89820": "40.622_-116.9554", "89001": "37.3259_-115.308", "89008": "37.6128_-114.5097", "89017": "37.5926_-115.2262", "89042": "37.7905_-114.3894", "89043": "37.8981_-114.3968", "89044": "35.9025_-115.1789", "89403": "39.2806_-119.5287", "89408": "39.6019_-119.235", "89428": "39.2652_-119.6388", "89429": "39.38_-119.2705", "89430": "38.7733_-119.3029", "89444": "38.8447_-119.3523", "89447": "38.9866_-119.1596", "89415": "38.5347_-118.6411", "89420": "38.5063_-118.1815", "89422": "38.387_-118.1096", "89427": "38.9575_-118.7756", "89003": "36.8199_-116.6094", "89020": "36.539_-116.5496", "89022": "38.5388_-117.0734", "89023": "36.6605_-115.9945", "89041": "36.2083_-115.9839", "89045": "38.711_-117.0676", "89048": "36.1661_-116.0038", "89049": "38.0672_-117.2301", "89060": "36.2645_-116.0393", "89061": "36.1184_-115.9407", "89409": "38.8688_-117.9221", "89418": "40.5484_-118.0344", "89419": "40.1819_-118.4689", "89440": "39.2965_-119.6587", "89402": "39.226_-120.0041", "89405": "40.6132_-119.3485", "89412": "40.6525_-119.3565", "89424": "39.8272_-119.3605", "89431": "39.5473_-119.7556", "89432": "39.5349_-119.7527", "89433": "39.5955_-119.7754", "89434": "39.5502_-119.7178", "89435": "39.5349_-119.7527", "89436": "39.6269_-119.7081", "89437": "39.6269_-119.7081", "89439": "39.5165_-119.9833", "89441": "39.6582_-119.6954", "89442": "39.6481_-119.2918", "89450": "39.2564_-119.9464", "89451": "39.2564_-119.9521", "89452": "39.2591_-119.9566", "89501": "39.5268_-119.8113", "89502": "39.4972_-119.7764", "89503": "39.5354_-119.8374", "89504": "39.5296_-119.8138", "89505": "39.5224_-119.8353", "89506": "39.6412_-119.8735", "89507": "39.5423_-119.8164", "89508": "39.6781_-119.9383", "89509": "39.498_-119.8239", "89510": "39.7699_-119.6027", "89511": "39.4151_-119.7668", "89512": "39.5483_-119.7957", "89513": "39.53_-119.81", "89515": "39.5296_-119.8138", "89519": "39.4814_-119.8591", "89520": "39.5296_-119.8138", "89521": "39.3809_-119.6859", "89523": "39.5249_-119.9031", "89533": "39.5439_-119.9061", "89555": "39.5246_-119.8125", "89557": "39.5296_-119.8138", "89570": "39.5296_-119.8138", "89595": "39.5296_-119.8138", "89599": "39.5296_-119.8138", "89704": "39.2669_-119.8174", "89301": "39.2474_-114.8886", "89311": "38.9559_-114.2438", "89314": "38.9324_-115.7145", "89315": "39.3326_-114.8245", "89317": "38.8641_-115.0069", "89318": "39.4034_-114.7791", "89319": "39.2783_-114.9892", "89701": "39.1507_-119.7459", "89702": "39.1355_-119.7588", "89703": "39.1704_-119.7782", "89706": "39.2025_-119.7526", "89711": "39.1678_-119.7764", "89712": "39.1678_-119.7764", "89713": "39.1678_-119.7764", "89714": "39.1678_-119.7764", "89721": "39.1678_-119.7764", "12007": "42.4561_-73.9277", "12009": "42.7063_-74.0193", "12023": "42.6108_-74.1466", "12041": "42.5759_-73.964", "12045": "42.4757_-73.7977", "12046": "42.4865_-73.9206", "12047": "42.7754_-73.7124", "12054": "42.6158_-73.8373", "12055": "42.6149_-73.9708", "12059": "42.6191_-74.0555", "12067": "42.555_-73.9237", "12077": "42.5971_-73.7959", "12084": "42.6973_-73.8975", "12085": "42.702_-73.9662", "12107": "42.66_-74.1168", "12110": "42.7462_-73.763", "12120": "42.4515_-74.1315", "12128": "42.725_-73.7643", "12143": "42.4754_-73.822", "12147": "42.5133_-74.1474", "12158": "42.5486_-73.8129", "12159": "42.6485_-73.8711", "12161": "42.5317_-73.8473", "12183": "42.746_-73.6943", "12186": "42.6431_-73.9448", "12189": "42.7298_-73.7123", "12193": "42.5156_-74.0394", "12201": "42.6526_-73.7562", "12202": "42.6413_-73.7641", "12203": "42.7003_-73.8575", "12204": "42.6847_-73.7354", "12205": "42.7198_-73.8207", "12206": "42.6683_-73.7744", "12207": "42.6526_-73.7562", "12208": "42.656_-73.7964", "12209": "42.6417_-73.7854", "12210": "42.6568_-73.7605", "12211": "42.713_-73.7739", "12212": "42.7168_-73.8104", "12214": "42.6526_-73.7562", "12220": "42.6526_-73.7562", "12222": "42.6853_-73.8253", "12223": "42.6526_-73.7562", "12224": "42.6526_-73.7562", "12225": "42.6526_-73.7562", "12226": "42.6526_-73.7562", "12227": "42.6526_-73.7562", "12228": "42.6526_-73.7562", "12229": "42.6526_-73.7562", "12230": "42.6526_-73.7562", "12231": "42.6526_-73.7562", "12232": "42.6526_-73.7562", "12233": "42.6526_-73.7562", "12234": "42.6526_-73.7562", "12235": "42.6526_-73.7562", "12236": "42.6526_-73.7562", "12237": "42.6526_-73.7562", "12238": "42.6526_-73.7562", "12239": "42.6526_-73.7562", "12240": "42.6526_-73.7562", "12241": "42.6526_-73.7562", "12242": "42.6526_-73.7562", "12243": "42.6526_-73.7562", "12244": "42.6526_-73.7562", "12245": "42.6526_-73.7562", "12246": "42.6471_-73.7503", "12247": "42.6526_-73.7562", "12248": "42.6526_-73.7562", "12249": "42.6526_-73.7562", "12250": "42.6526_-73.7562", "12252": "42.6526_-73.7562", "12255": "42.6526_-73.7562", "12256": "42.6526_-73.7562", "12257": "42.6526_-73.7562", "12260": "42.6526_-73.7562", "12261": "42.6526_-73.7562", "12288": "42.6526_-73.7562", "12469": "42.4563_-74.242", "14029": "42.4743_-78.2474", "14707": "42.0737_-78.0594", "14708": "42.0126_-78.0578", "14709": "42.3263_-77.9947", "14711": "42.32_-78.0943", "14714": "42.2855_-78.2312", "14715": "42.0704_-78.1448", "14717": "42.364_-78.184", "14721": "42.0137_-78.2648", "14727": "42.1882_-78.2751", "14735": "42.4508_-78.1043", "14739": "42.1907_-78.1359", "14744": "42.4228_-78.2063", "14745": "42.4777_-78.1403", "14754": "42.0319_-78.2097", "14774": "42.0884_-78.1533", "14777": "42.3923_-78.2536", "14786": "42.1227_-78.2213", "14802": "42.2534_-77.7893", "14803": "42.2558_-77.7781", "14804": "42.316_-77.778", "14806": "42.1575_-77.792", "14813": "42.2334_-78.011", "14822": "42.4585_-77.7954", "14880": "42.1697_-77.99", "14884": "42.4773_-77.889", "14895": "42.1108_-77.9419", "14897": "42.0456_-77.8106", "10451": "40.8222_-73.9217", "10452": "40.8376_-73.9216", "10453": "40.852_-73.9129", "10454": "40.8085_-73.9198", "10455": "40.8153_-73.9072", "10456": "40.8316_-73.9099", "10457": "40.8486_-73.8999", "10458": "40.8633_-73.8895", "10459": "40.8247_-73.894", "10460": "40.8409_-73.8794", "10461": "40.8465_-73.841", "10462": "40.8434_-73.8602", "10463": "40.8798_-73.9067", "10464": "40.8469_-73.7874", "10465": "40.8261_-73.8196", "10466": "40.8904_-73.8503", "10467": "40.8737_-73.8712", "10468": "40.8662_-73.9003", "10469": "40.8702_-73.8495", "10470": "40.9_-73.8622", "10471": "40.9011_-73.9053", "10472": "40.8295_-73.8716", "10473": "40.8194_-73.8606", "10474": "40.8139_-73.8841", "10475": "40.8729_-73.8278", "13737": "42.0805_-76.0973", "13744": "42.2568_-75.9087", "13745": "42.1738_-75.8728", "13746": "42.2778_-75.8462", "13748": "42.0454_-75.8076", "13749": "42.0156_-75.7905", "13754": "42.0666_-75.4287", "13760": "42.1506_-76.0551", "13761": "42.0984_-76.0494", "13762": "42.1129_-76.021", "13763": "42.0984_-76.0494", "13777": "42.2573_-75.9805", "13787": "42.1823_-75.6545", "13790": "42.1267_-75.9685", "13794": "42.4006_-76.0208", "13795": "42.0695_-75.7967", "13797": "42.3409_-76.0302", "13802": "42.2538_-76.0464", "13813": "42.1625_-75.5484", "13826": "42.1262_-75.6471", "13833": "42.1958_-75.7591", "13848": "42.2147_-75.7277", "13850": "42.0771_-76.0118", "13851": "42.0851_-76.0538", "13862": "42.3384_-75.9522", "13865": "42.0759_-75.6405", "13901": "42.1463_-75.8865", "13902": "42.1054_-75.8876", "13903": "42.0811_-75.8977", "13904": "42.1171_-75.8653", "13905": "42.1151_-75.9309", "14041": "42.4086_-78.9844", "14042": "42.4926_-78.4793", "14060": "42.4276_-78.3608", "14065": "42.4897_-78.3501", "14070": "42.4712_-78.9339", "14101": "42.4083_-78.5059", "14129": "42.4723_-78.9981", "14133": "42.4891_-78.367", "14138": "42.3718_-79.0501", "14168": "42.5189_-78.9959", "14171": "42.4315_-78.628", "14173": "42.5247_-78.4755", "14706": "42.0918_-78.4999", "14719": "42.3333_-78.8885", "14726": "42.2625_-79.022", "14729": "42.3971_-78.7432", "14730": "42.1747_-78.9473", "14731": "42.2959_-78.6606", "14737": "42.3388_-78.44", "14741": "42.2083_-78.6208", "14743": "42.1979_-78.4159", "14748": "42.145_-78.6466", "14751": "42.2983_-79.0062", "14753": "42.0639_-78.632", "14755": "42.2541_-78.8093", "14760": "42.0821_-78.426", "14766": "42.3575_-78.8073", "14770": "42.0273_-78.3314", "14772": "42.1631_-78.96", "14778": "42.0803_-78.475", "14779": "42.1604_-78.7304", "14783": "42.082_-78.9177", "14788": "42.0621_-78.378", "13021": "42.93_-76.5626", "13022": "42.9317_-76.5661", "13024": "42.9317_-76.5661", "13026": "42.7472_-76.6775", "13033": "43.1794_-76.5648", "13034": "42.9142_-76.7024", "13071": "42.6746_-76.5418", "13081": "42.6635_-76.6216", "13092": "42.6558_-76.4154", "13111": "43.2661_-76.6289", "13113": "43.1656_-76.5369", "13117": "43.0101_-76.7033", "13118": "42.7355_-76.399", "13139": "42.7421_-76.6285", "13140": "43.0427_-76.6449", "13147": "42.7708_-76.5862", "13156": "43.3296_-76.6747", "13160": "42.8335_-76.674", "13166": "43.0489_-76.5425", "14048": "42.4877_-79.3283", "14062": "42.4482_-79.1607", "14063": "42.4333_-79.3339", "14081": "42.5739_-79.0596", "14135": "42.489_-79.239", "14136": "42.5357_-79.1628", "14166": "42.4511_-79.4154", "14701": "42.0928_-79.244", "14702": "42.097_-79.2353", "14710": "42.1084_-79.4056", "14712": "42.1513_-79.3581", "14716": "42.394_-79.4344", "14718": "42.3504_-79.2993", "14720": "42.1095_-79.2831", "14722": "42.2098_-79.4667", "14723": "42.3127_-79.1203", "14724": "42.0557_-79.6685", "14728": "42.2394_-79.4193", "14732": "42.2291_-79.1135", "14733": "42.1239_-79.1895", "14736": "42.1204_-79.7349", "14738": "42.0528_-79.1318", "14740": "42.2147_-79.1649", "14742": "42.1205_-79.3096", "14747": "42.1508_-79.0964", "14750": "42.0973_-79.3291", "14752": "42.3524_-79.3235", "14756": "42.1967_-79.4239", "14757": "42.2409_-79.4963", "14758": "42.0126_-79.4495", "14767": "42.057_-79.4815", "14769": "42.3858_-79.4589", "14775": "42.2482_-79.7121", "14781": "42.1631_-79.5857", "14782": "42.2455_-79.2673", "14784": "42.3182_-79.3758", "14785": "42.1557_-79.4122", "14787": "42.322_-79.5726", "14814": "42.1455_-76.9527", "14816": "42.1939_-76.7361", "14825": "42.0392_-76.6202", "14838": "42.1859_-76.6819", "14845": "42.1805_-76.8345", "14861": "42.0694_-76.693", "14864": "42.2581_-76.8392", "14871": "42.0419_-76.8815", "14872": "42.2348_-76.8652", "14889": "42.2085_-76.5717", "14894": "42.0273_-76.7723", "14901": "42.1008_-76.812", "14902": "42.1473_-76.7509", "14903": "42.1198_-76.8877", "14904": "42.0729_-76.8037", "14905": "42.0869_-76.8397", "13124": "42.6372_-75.8164", "13136": "42.5969_-75.8465", "13155": "42.6626_-75.7669", "13332": "42.7197_-75.5589", "13411": "42.6224_-75.3474", "13460": "42.6859_-75.483", "13464": "42.6896_-75.6121", "13730": "42.2417_-75.5366", "13733": "42.312_-75.4894", "13758": "42.5835_-75.7219", "13778": "42.3401_-75.7342", "13780": "42.4269_-75.4823", "13801": "42.5068_-75.7623", "13809": "42.4081_-75.4003", "13814": "42.6036_-75.5282", "13815": "42.5414_-75.5274", "13830": "42.4379_-75.5673", "13832": "42.6336_-75.6172", "13841": "42.3989_-75.8237", "13843": "42.5295_-75.3852", "13844": "42.6053_-75.633", "12901": "44.6927_-73.466", "12903": "44.6854_-73.4474", "12910": "44.8816_-73.6408", "12911": "44.505_-73.4801", "12912": "44.4499_-73.6857", "12918": "44.6862_-73.6702", "12919": "44.9773_-73.4466", "12921": "44.8884_-73.4501", "12923": "44.9432_-73.9355", "12924": "44.4777_-73.5843", "12929": "44.72_-73.7192", "12933": "44.8939_-73.8365", "12934": "44.8444_-73.8685", "12935": "44.9163_-73.7876", "12952": "44.7255_-73.9195", "12955": "44.8043_-73.973", "12958": "44.9592_-73.5834", "12959": "44.9602_-73.673", "12962": "44.6894_-73.5772", "12972": "44.5851_-73.5293", "12978": "44.6164_-73.8087", "12979": "44.9884_-73.3691", "12981": "44.7032_-73.7481", "12985": "44.6287_-73.5579", "12992": "44.797_-73.5112", "12017": "42.3223_-73.455", "12029": "42.4132_-73.4159", "12037": "42.3496_-73.5873", "12050": "42.3172_-73.7486", "12060": "42.433_-73.4903", "12075": "42.3036_-73.6486", "12106": "42.3767_-73.7183", "12115": "42.4725_-73.5807", "12125": "42.4759_-73.3773", "12130": "42.44_-73.6663", "12132": "42.4705_-73.63", "12136": "42.4357_-73.5545", "12165": "42.3091_-73.5008", "12172": "42.2857_-73.7335", "12173": "42.3596_-73.7613", "12174": "42.344_-73.7348", "12184": "42.4321_-73.6683", "12195": "42.4862_-73.4662", "12502": "42.0851_-73.6424", "12503": "42.0381_-73.5819", "12513": "42.2251_-73.7346", "12516": "42.1113_-73.5526", "12517": "42.1367_-73.5108", "12521": "42.176_-73.6571", "12523": "42.0902_-73.7818", "12526": "42.1219_-73.8625", "12529": "42.1868_-73.5483", "12530": "42.2054_-73.6912", "12534": "42.247_-73.7552", "12541": "42.1421_-73.7574", "12544": "42.2596_-73.668", "12565": "42.2485_-73.6463", "13040": "42.5385_-75.903", "13045": "42.5952_-76.1857", "13056": "42.6772_-76.1052", "13077": "42.6726_-76.1878", "13087": "42.707_-76.1561", "13101": "42.5948_-76.082", "13141": "42.795_-76.2141", "13158": "42.7085_-76.0189", "13738": "42.5673_-76.1238", "13784": "42.4262_-76.2266", "13803": "42.4527_-76.0395", "13863": "42.452_-75.9014", "12167": "42.4174_-74.6098", "12406": "42.1417_-74.5721", "12421": "42.2522_-74.5407", "12430": "42.1772_-74.5473", "12434": "42.362_-74.494", "12438": "42.2079_-74.6012", "12455": "42.1852_-74.6178", "12459": "42.2094_-74.6837", "12474": "42.2957_-74.5631", "13731": "42.1569_-74.7887", "13739": "42.3522_-74.8071", "13740": "42.2709_-74.7661", "13750": "42.4711_-74.8357", "13751": "42.4508_-74.9013", "13752": "42.2884_-75.1051", "13753": "42.2937_-74.9207", "13755": "42.0716_-75.0152", "13756": "42.0039_-75.1226", "13757": "42.4101_-74.8987", "13774": "41.9654_-75.1594", "13775": "42.3421_-75.1485", "13782": "42.1787_-74.9984", "13783": "41.9914_-75.2647", "13786": "42.4499_-74.6871", "13788": "42.3594_-74.6759", "13804": "42.2102_-75.3739", "13806": "42.3734_-74.965", "13838": "42.3074_-75.3908", "13839": "42.2441_-75.2871", "13842": "42.377_-74.7259", "13846": "42.363_-75.0588", "13847": "42.2037_-75.2793", "13856": "42.1756_-75.1532", "13860": "42.4459_-74.9632", "12501": "41.8447_-73.5542", "12504": "42.0129_-73.9082", "12506": "41.8756_-73.6912", "12507": "42.0005_-73.9199", "12508": "41.5097_-73.9634", "12510": "41.6712_-73.7632", "12511": "41.5462_-73.9596", "12512": "41.5528_-73.9682", "12514": "41.8693_-73.7659", "12522": "41.7351_-73.587", "12524": "41.5404_-73.8979", "12527": "41.5202_-73.9333", "12531": "41.5325_-73.6628", "12533": "41.5603_-73.7939", "12537": "41.5824_-73.9363", "12538": "41.7887_-73.9063", "12540": "41.6615_-73.745", "12545": "41.7803_-73.6885", "12546": "41.9536_-73.5287", "12564": "41.5749_-73.5948", "12567": "41.9896_-73.6602", "12569": "41.747_-73.8143", "12570": "41.6194_-73.6783", "12571": "42.0064_-73.8546", "12572": "41.9272_-73.8888", "12574": "41.9151_-73.9517", "12578": "41.805_-73.8013", "12580": "41.8502_-73.8988", "12581": "41.8877_-73.6945", "12582": "41.5512_-73.7255", "12583": "42.0579_-73.9025", "12585": "41.7227_-73.7184", "12590": "41.595_-73.8876", "12592": "41.7759_-73.5544", "12594": "41.6538_-73.5556", "12601": "41.7035_-73.9117", "12602": "41.7599_-73.7437", "12603": "41.6907_-73.8621", "12604": "41.7599_-73.7437", "14001": "43.0249_-78.5084", "14004": "42.8984_-78.5257", "14006": "42.6366_-79.0497", "14010": "42.7684_-78.8871", "14025": "42.6314_-78.7391", "14026": "42.941_-78.688", "14027": "42.5707_-79.0308", "14030": "42.5605_-78.5025", "14031": "42.981_-78.6162", "14032": "43.0362_-78.639", "14033": "42.6551_-78.6921", "14034": "42.5001_-78.893", "14035": "42.4906_-78.8499", "14038": "42.9473_-78.4744", "14043": "42.905_-78.7041", "14047": "42.6974_-78.9834", "14051": "43.0429_-78.6988", "14052": "42.7701_-78.602", "14055": "42.5466_-78.611", "14057": "42.6506_-78.8781", "14059": "42.834_-78.6343", "14061": "42.5946_-79.084", "14068": "43.024_-78.7532", "14069": "42.6001_-78.6386", "14072": "43.0183_-78.9591", "14075": "42.7334_-78.8389", "14080": "42.6396_-78.5439", "14085": "42.7215_-78.9327", "14086": "42.9017_-78.6631", "14091": "42.5404_-78.9212", "14102": "42.8332_-78.5587", "14110": "42.6856_-78.7767", "14111": "42.5896_-78.9107", "14112": "42.697_-78.9414", "14127": "42.7639_-78.7518", "14134": "42.5323_-78.5172", "14139": "42.7063_-78.5452", "14140": "42.8072_-78.6676", "14141": "42.52_-78.6847", "14150": "43.0028_-78.8547", "14151": "43.0203_-78.8803", "14169": "42.7684_-78.53", "14170": "42.7053_-78.6779", "14201": "42.8967_-78.8846", "14202": "42.887_-78.8779", "14203": "42.8939_-78.8681", "14204": "42.884_-78.8597", "14205": "42.8864_-78.8784", "14206": "42.8811_-78.8104", "14207": "42.9491_-78.8978", "14208": "42.9154_-78.8505", "14209": "42.913_-78.8656", "14210": "42.8614_-78.8205", "14211": "42.9082_-78.8225", "14212": "42.8946_-78.8245", "14213": "42.9167_-78.8895", "14214": "42.9414_-78.8374", "14215": "42.9335_-78.8115", "14216": "42.9499_-78.8599", "14217": "42.9719_-78.8769", "14218": "42.8146_-78.8078", "14219": "42.7863_-78.8264", "14220": "42.8441_-78.8182", "14221": "42.9685_-78.7492", "14222": "42.9164_-78.8763", "14223": "42.9731_-78.845", "14224": "42.8371_-78.7484", "14225": "42.9255_-78.7481", "14226": "42.9744_-78.7949", "14227": "42.8853_-78.7462", "14228": "43.0408_-78.7812", "14231": "42.7684_-78.8871", "14233": "42.7684_-78.8871", "14240": "42.7684_-78.8871", "14241": "42.9383_-78.7441", "14260": "42.7684_-78.8871", "14261": "42.7684_-78.8871", "14263": "42.7684_-78.8871", "14264": "42.8856_-78.8735", "14265": "42.7684_-78.8871", "14267": "42.7684_-78.8871", "14269": "42.7684_-78.8871", "14270": "42.7684_-78.8871", "14272": "42.7684_-78.8871", "14273": "42.755_-78.7849", "14276": "42.8864_-78.8784", "14280": "42.8864_-78.8784", "12851": "43.7811_-73.9835", "12852": "43.946_-74.1299", "12855": "43.9869_-73.7121", "12857": "43.7799_-73.9335", "12858": "43.8914_-73.645", "12870": "43.8412_-73.7674", "12872": "43.8759_-73.7304", "12879": "43.9697_-74.1662", "12883": "43.8463_-73.4426", "12913": "44.3985_-74.0829", "12928": "43.9526_-73.4665", "12932": "44.2245_-73.6011", "12936": "44.2807_-73.3731", "12941": "44.3734_-73.7247", "12942": "44.2555_-73.7915", "12943": "44.2024_-73.7731", "12944": "44.4999_-73.4745", "12946": "44.2796_-73.982", "12950": "44.3075_-73.5491", "12956": "44.0876_-73.5236", "12960": "44.0438_-73.5079", "12961": "44.0612_-73.5098", "12964": "44.1595_-73.6059", "12974": "44.0465_-73.4705", "12975": "44.5264_-73.4092", "12977": "44.2802_-74.0795", "12987": "44.3364_-73.7757", "12993": "44.205_-73.4702", "12996": "44.3604_-73.3963", "12997": "44.3755_-73.8431", "12998": "44.0827_-73.5306", "12914": "44.9479_-74.5947", "12915": "44.8578_-74.0335", "12916": "44.8282_-74.5223", "12917": "44.9177_-74.1731", "12920": "44.9088_-74.0741", "12926": "44.9417_-74.3297", "12930": "44.7233_-74.5523", "12937": "44.9731_-74.4929", "12939": "44.432_-74.181", "12945": "44.3375_-74.2381", "12953": "44.8482_-74.2928", "12957": "44.8504_-74.5603", "12966": "44.8532_-74.4191", "12969": "44.7308_-74.1342", "12970": "44.445_-74.2664", "12976": "44.467_-74.1729", "12980": "44.6578_-74.5155", "12983": "44.3243_-74.133", "12986": "44.232_-74.4905", "12989": "44.4601_-74.0573", "12995": "44.8057_-74.2523", "13655": "44.9825_-74.6626", "12025": "43.0727_-74.1684", "12032": "43.1922_-74.5169", "12078": "43.0616_-74.3375", "12095": "43.0069_-74.3715", "12117": "43.1411_-74.2444", "12134": "43.2662_-74.2288", "13470": "43.1791_-74.6768", "14005": "42.9159_-78.2589", "14013": "43.0807_-78.3951", "14020": "43.0003_-78.1929", "14021": "42.9981_-78.1848", "14036": "42.9777_-78.3929", "14040": "42.8948_-78.3878", "14054": "42.9166_-78.1342", "14056": "42.9912_-78.3122", "14058": "43.0897_-78.1704", "14125": "43.0717_-78.2702", "14143": "42.9829_-78.0898", "14416": "43.0869_-77.9603", "14422": "43.0738_-78.0629", "14482": "42.9774_-77.9851", "14486": "42.8943_-77.9216", "14525": "42.9102_-78.0269", "14557": "43.0416_-78.0573", "12015": "42.2736_-73.8152", "12042": "42.3659_-73.851", "12051": "42.3501_-73.8199", "12058": "42.3527_-73.9062", "12083": "42.4113_-74.0222", "12087": "42.429_-73.8093", "12124": "42.4442_-73.7882", "12176": "42.3851_-73.9587", "12192": "42.4029_-73.8283", "12405": "42.3304_-74.0857", "12407": "42.3037_-74.3335", "12413": "42.3096_-74.0115", "12414": "42.2276_-73.8985", "12418": "42.3629_-74.1631", "12422": "42.402_-74.1849", "12423": "42.386_-74.1117", "12424": "42.2469_-74.1353", "12427": "42.1643_-74.1245", "12431": "42.3815_-74.0623", "12436": "42.1955_-74.1023", "12439": "42.2898_-74.2165", "12442": "42.2333_-74.2416", "12444": "42.2694_-74.2793", "12450": "42.1332_-74.2443", "12451": "42.3045_-73.9457", "12452": "42.2404_-74.3654", "12454": "42.2995_-74.1655", "12460": "42.4098_-74.1524", "12463": "42.1729_-74.0167", "12468": "42.2979_-74.3895", "12470": "42.2959_-74.0773", "12473": "42.2678_-74.0523", "12482": "42.2681_-73.9554", "12485": "42.1956_-74.1338", "12492": "42.2046_-74.362", "12496": "42.3175_-74.262", "12108": "43.6676_-74.4569", "12139": "43.4481_-74.5263", "12164": "43.5042_-74.3667", "12190": "43.4012_-74.2886", "12812": "43.8553_-74.4435", "12842": "43.7606_-74.2766", "12847": "43.9477_-74.4662", "12864": "43.7284_-74.3057", "13353": "43.3915_-74.74", "13360": "43.748_-74.7846", "13436": "43.8131_-74.6574", "13324": "43.3024_-74.9977", "13329": "43.1042_-74.7643", "13331": "43.8167_-74.8862", "13340": "43.044_-75.1072", "13350": "43.0307_-74.9876", "13357": "43.0064_-75.0484", "13361": "42.9148_-74.9515", "13365": "43.0474_-74.8606", "13406": "43.1369_-74.924", "13407": "42.99_-74.9853", "13416": "43.18_-74.9861", "13420": "43.7435_-74.8935", "13431": "43.2115_-75.0731", "13454": "43.1625_-74.7809", "13472": "43.7001_-75.0018", "13475": "42.8951_-74.8276", "13491": "42.8826_-75.1835", "13601": "43.9743_-75.9122", "13602": "44.0354_-75.754", "13603": "43.9087_-75.8967", "13605": "43.8062_-76.049", "13606": "43.8631_-76.0041", "13607": "44.3359_-75.9177", "13608": "44.2358_-75.6005", "13611": "43.778_-76.1259", "13612": "44.0042_-75.7958", "13615": "44.007_-75.9841", "13616": "44.0265_-75.8499", "13618": "44.1244_-76.3164", "13619": "43.9791_-75.6013", "13622": "44.0848_-76.1232", "13624": "44.1442_-76.062", "13628": "44.0356_-75.6838", "13632": "44.1395_-76.0616", "13634": "44.0069_-76.065", "13636": "43.7434_-76.1165", "13637": "44.0817_-75.8305", "13638": "44.0204_-75.7524", "13640": "44.3213_-76.0172", "13641": "44.2752_-76.0049", "13643": "44.0342_-75.7188", "13650": "43.8467_-76.2352", "13651": "43.8708_-76.1809", "13656": "44.1987_-75.9569", "13657": "44.0292_-76.043", "13659": "43.7568_-75.9053", "13661": "43.7179_-76.082", "13665": "44.063_-75.5039", "13671": "44.2873_-75.623", "13673": "44.1589_-75.7099", "13674": "43.7334_-76.0543", "13675": "44.2774_-75.8496", "13679": "44.3211_-75.815", "13682": "43.8622_-75.8719", "13685": "43.9398_-76.105", "13691": "44.2113_-75.8014", "13692": "44.2898_-76.0262", "13693": "44.0551_-76.2689", "11201": "40.694_-73.9903", "11202": "40.6451_-73.945", "11203": "40.6505_-73.9349", "11204": "40.6179_-73.9856", "11205": "40.6924_-73.9666", "11206": "40.7012_-73.9436", "11207": "40.6705_-73.894", "11208": "40.6762_-73.8736", "11209": "40.6251_-74.0303", "11210": "40.6281_-73.9467", "11211": "40.7095_-73.9563", "11212": "40.6625_-73.9145", "11213": "40.67_-73.9367", "11214": "40.6016_-73.9968", "11215": "40.6669_-73.9828", "11216": "40.6794_-73.9496", "11217": "40.6816_-73.9798", "11218": "40.6424_-73.9758", "11219": "40.6336_-73.996", "11220": "40.6412_-74.0133", "11221": "40.6907_-73.9274", "11222": "40.7272_-73.9498", "11223": "40.5979_-73.9743", "11224": "40.5767_-73.9884", "11225": "40.6628_-73.9546", "11226": "40.6467_-73.957", "11228": "40.6174_-74.0121", "11229": "40.6011_-73.9475", "11230": "40.6225_-73.965", "11231": "40.6794_-74.0014", "11232": "40.6521_-74.0018", "11233": "40.6784_-73.9211", "11234": "40.6205_-73.9239", "11235": "40.5839_-73.9536", "11236": "40.6407_-73.9028", "11237": "40.7006_-73.918", "11238": "40.679_-73.9644", "11239": "40.6497_-73.8824", "11241": "40.6451_-73.945", "11242": "40.6451_-73.945", "11243": "40.6451_-73.945", "11245": "40.6451_-73.945", "11247": "40.6451_-73.945", "11249": "40.6451_-73.945", "11251": "40.6451_-73.945", "11252": "40.6451_-73.945", "11256": "40.6451_-73.945", "13305": "43.887_-75.4274", "13312": "43.6887_-75.2921", "13325": "43.563_-75.4584", "13327": "43.9095_-75.3542", "13343": "43.7323_-75.3669", "13345": "43.6886_-75.3302", "13367": "43.7893_-75.4156", "13368": "43.6262_-75.3553", "13404": "43.7376_-75.4696", "13433": "43.5802_-75.3263", "13473": "43.6441_-75.4132", "13489": "43.4597_-75.5127", "13620": "43.8843_-75.4604", "13626": "43.8801_-75.6839", "13627": "43.9298_-75.5891", "13631": "43.8998_-75.5824", "13648": "44.1613_-75.3252", "14414": "42.903_-77.7274", "14423": "42.9567_-77.8493", "14435": "42.7216_-77.6747", "14437": "42.57_-77.7109", "14454": "42.7938_-77.7996", "14462": "42.676_-77.7573", "14466": "42.78_-77.582", "14480": "42.8296_-77.7149", "14481": "42.7739_-77.899", "14485": "42.9012_-77.6083", "14487": "42.8135_-77.6635", "14488": "42.8215_-77.6386", "14510": "42.6835_-77.8664", "14517": "42.5867_-77.918", "14533": "42.8435_-77.8962", "14539": "42.8343_-77.8779", "14545": "42.6649_-77.701", "14556": "42.679_-77.8272", "14558": "42.8554_-77.6876", "14560": "42.6776_-77.5775", "14592": "42.8757_-77.8835", "14836": "42.5449_-77.9289", "14846": "42.5388_-77.9818", "13032": "43.0878_-75.7602", "13035": "42.938_-75.8392", "13037": "43.0552_-75.8768", "13043": "43.042_-75.7408", "13052": "42.7494_-75.8582", "13061": "42.8562_-75.7543", "13072": "42.7631_-75.7443", "13122": "42.8441_-75.8635", "13134": "42.9686_-75.6794", "13163": "43.0753_-75.7069", "13310": "42.894_-75.5678", "13314": "42.8128_-75.3177", "13334": "42.8484_-75.6314", "13346": "42.8231_-75.5434", "13355": "42.8237_-75.4367", "13364": "42.8087_-75.2527", "13402": "42.8969_-75.5076", "13408": "42.9108_-75.6487", "13409": "42.9863_-75.594", "13418": "42.8501_-75.3815", "13421": "43.0862_-75.6508", "13465": "42.9106_-75.5177", "13484": "42.8545_-75.656", "14410": "43.1953_-77.8559", "14420": "43.2128_-77.9368", "14428": "43.0749_-77.835", "14430": "43.2331_-77.9275", "14445": "43.1128_-77.4906", "14450": "43.0892_-77.436", "14464": "43.3076_-77.927", "14467": "43.0483_-77.6122", "14468": "43.2923_-77.7905", "14472": "42.9695_-77.5781", "14506": "42.9953_-77.5001", "14511": "42.9928_-77.8603", "14514": "43.1186_-77.8005", "14515": "43.2578_-77.7351", "14526": "43.1396_-77.456", "14534": "43.0695_-77.5141", "14543": "42.9966_-77.6665", "14546": "43.0246_-77.7743", "14559": "43.1895_-77.8043", "14580": "43.2196_-77.4616", "14586": "43.0397_-77.6871", "14602": "43.286_-77.6843", "14603": "43.1616_-77.6068", "14604": "43.1577_-77.608", "14605": "43.1698_-77.6007", "14606": "43.1685_-77.6845", "14607": "43.1501_-77.589", "14608": "43.1521_-77.6258", "14609": "43.174_-77.5637", "14610": "43.1452_-77.5495", "14611": "43.1484_-77.6394", "14612": "43.2566_-77.6652", "14613": "43.1831_-77.6393", "14614": "43.1558_-77.6142", "14615": "43.2058_-77.6521", "14616": "43.2346_-77.6577", "14617": "43.2203_-77.5994", "14618": "43.1122_-77.5618", "14619": "43.1367_-77.6481", "14620": "43.1317_-77.6062", "14621": "43.1834_-77.6043", "14622": "43.214_-77.5555", "14623": "43.0834_-77.6344", "14624": "43.1216_-77.7311", "14625": "43.1522_-77.5057", "14626": "43.2126_-77.704", "14627": "43.1275_-77.6277", "14638": "43.286_-77.6843", "14639": "43.286_-77.6843", "14642": "43.286_-77.6843", "14643": "43.1548_-77.6156", "14644": "43.286_-77.6843", "14646": "43.286_-77.6843", "14647": "43.1548_-77.6156", "14649": "43.286_-77.6843", "14650": "43.1548_-77.6156", "14651": "43.1548_-77.6156", "14652": "43.286_-77.6843", "14653": "43.286_-77.6843", "14692": "43.286_-77.6843", "14694": "43.286_-77.6843", "12010": "42.9387_-74.1882", "12016": "42.9295_-74.3165", "12066": "42.7717_-74.2882", "12068": "42.9571_-74.4021", "12069": "42.9423_-74.2851", "12070": "42.9765_-74.2484", "12072": "42.9036_-74.3598", "12086": "42.9695_-74.1556", "12166": "42.8484_-74.4536", "12177": "42.9554_-74.2851", "13317": "42.8671_-74.5956", "13339": "42.9372_-74.6433", "13410": "42.9379_-74.6117", "13428": "42.9221_-74.5708", "13452": "43.017_-74.646", "11001": "40.7236_-73.7058", "11002": "40.7237_-73.7049", "11003": "40.6976_-73.7049", "11010": "40.701_-73.6758", "11020": "40.7742_-73.7189", "11021": "40.7867_-73.727", "11022": "40.7548_-73.6018", "11023": "40.7993_-73.7343", "11024": "40.8171_-73.7416", "11026": "40.7548_-73.6018", "11027": "40.8007_-73.7285", "11030": "40.7934_-73.6888", "11040": "40.7294_-73.6828", "11042": "40.7602_-73.695", "11050": "40.835_-73.6964", "11051": "40.7548_-73.6018", "11052": "40.7548_-73.6018", "11053": "40.7548_-73.6018", "11054": "40.7548_-73.6018", "11055": "40.7548_-73.6018", "11096": "40.6205_-73.7474", "11501": "40.7469_-73.6398", "11507": "40.7703_-73.6514", "11509": "40.5887_-73.7255", "11510": "40.6548_-73.6097", "11514": "40.7512_-73.6119", "11516": "40.6236_-73.7264", "11518": "40.6404_-73.6674", "11520": "40.6536_-73.5866", "11530": "40.7245_-73.6487", "11531": "40.7268_-73.6343", "11542": "40.865_-73.6277", "11545": "40.8281_-73.6076", "11547": "40.8307_-73.6387", "11548": "40.8125_-73.6261", "11549": "40.7172_-73.6027", "11550": "40.7049_-73.6176", "11551": "40.7062_-73.6187", "11552": "40.6929_-73.6539", "11553": "40.702_-73.592", "11554": "40.7149_-73.5561", "11555": "40.7004_-73.5929", "11556": "40.7548_-73.6018", "11557": "40.6404_-73.6957", "11558": "40.604_-73.6554", "11559": "40.614_-73.733", "11560": "40.8817_-73.5927", "11561": "40.5877_-73.6595", "11563": "40.6571_-73.6741", "11565": "40.675_-73.6731", "11566": "40.6685_-73.5536", "11568": "40.7882_-73.5875", "11569": "40.5905_-73.5808", "11570": "40.6637_-73.638", "11571": "40.6587_-73.6412", "11572": "40.6362_-73.6375", "11575": "40.6802_-73.5867", "11576": "40.7984_-73.6477", "11577": "40.7845_-73.6403", "11579": "40.846_-73.6436", "11580": "40.6742_-73.7057", "11581": "40.6523_-73.7118", "11582": "40.6643_-73.7085", "11590": "40.7557_-73.5723", "11596": "40.7592_-73.6449", "11598": "40.6326_-73.7141", "11599": "40.7268_-73.6343", "11709": "40.9074_-73.5601", "11710": "40.6729_-73.5365", "11714": "40.74_-73.4857", "11732": "40.8472_-73.5349", "11735": "40.7315_-73.4327", "11737": "40.7326_-73.4454", "11753": "40.7881_-73.5331", "11756": "40.7254_-73.5166", "11758": "40.6682_-73.4588", "11762": "40.6807_-73.4444", "11765": "40.8857_-73.5526", "11771": "40.866_-73.5272", "11773": "40.8262_-73.5021", "11783": "40.6795_-73.491", "11791": "40.8146_-73.5024", "11793": "40.685_-73.5103", "11797": "40.8154_-73.4716", "11801": "40.7623_-73.523", "11802": "40.7684_-73.5251", "11803": "40.7781_-73.4816", "11804": "40.765_-73.4575", "11815": "40.7548_-73.6018", "11819": "40.7684_-73.5251", "11853": "40.792_-73.5398", "10001": "40.7484_-73.9967", "10002": "40.7152_-73.9877", "10003": "40.7313_-73.9892", "10004": "40.7143_-74.006", "10005": "40.7056_-74.0083", "10006": "40.7085_-74.0135", "10007": "40.7139_-74.007", "10008": "40.7143_-74.006", "10009": "40.7262_-73.9796", "10010": "40.7375_-73.9813", "10011": "40.7402_-73.9996", "10012": "40.7255_-73.9983", "10013": "40.7185_-74.0025", "10014": "40.7339_-74.0054", "10016": "40.7443_-73.9781", "10017": "40.7517_-73.9707", "10018": "40.7547_-73.9925", "10019": "40.7651_-73.9858", "10020": "40.7354_-73.9968", "10021": "40.7685_-73.9588", "10022": "40.7571_-73.9657", "10023": "40.7764_-73.9827", "10024": "40.7864_-73.9764", "10025": "40.7975_-73.9683", "10026": "40.8019_-73.9531", "10027": "40.8116_-73.955", "10028": "40.7763_-73.9529", "10029": "40.7918_-73.9447", "10030": "40.8183_-73.9426", "10031": "40.8246_-73.9507", "10032": "40.8382_-73.942", "10033": "40.8496_-73.9356", "10034": "40.8662_-73.9221", "10035": "40.8011_-73.9371", "10036": "40.7597_-73.9918", "10037": "40.8135_-73.9381", "10038": "40.7101_-74.0013", "10039": "40.8265_-73.9383", "10040": "40.8583_-73.9296", "10041": "40.7038_-74.0098", "10043": "40.7143_-74.006", "10044": "40.7618_-73.9505", "10045": "40.7086_-74.0087", "10055": "40.7808_-73.9772", "10060": "40.7808_-73.9772", "10065": "40.7651_-73.9638", "10069": "40.778_-73.9884", "10075": "40.7143_-74.006", "10080": "40.7143_-74.006", "10081": "40.7143_-74.006", "10087": "40.7808_-73.9772", "10090": "40.7808_-73.9772", "10101": "40.7808_-73.9772", "10102": "40.7808_-73.9772", "10103": "40.7603_-73.9762", "10104": "40.7609_-73.9799", "10105": "40.7628_-73.9785", "10106": "40.7652_-73.9804", "10107": "40.7664_-73.9827", "10108": "40.7808_-73.9772", "10109": "40.7808_-73.9772", "10110": "40.754_-73.9808", "10111": "40.7592_-73.9778", "10112": "40.7593_-73.9798", "10113": "40.7808_-73.9772", "10114": "40.7808_-73.9772", "10115": "40.8111_-73.9642", "10116": "40.7808_-73.9772", "10117": "40.7808_-73.9772", "10118": "40.749_-73.9865", "10119": "40.7808_-73.9772", "10120": "40.7506_-73.9894", "10121": "40.7496_-73.9919", "10122": "40.7518_-73.9922", "10123": "40.7515_-73.9905", "10124": "40.7808_-73.9772", "10125": "40.7808_-73.9772", "10126": "40.7808_-73.9772", "10128": "40.7816_-73.9511", "10129": "40.7808_-73.9772", "10130": "40.7808_-73.9772", "10131": "40.7808_-73.9772", "10132": "40.7808_-73.9772", "10133": "40.7808_-73.9772", "10138": "40.7808_-73.9772", "10150": "40.7808_-73.9772", "10151": "40.7634_-73.974", "10152": "40.7589_-73.973", "10153": "40.7641_-73.9735", "10154": "40.7583_-73.9735", "10155": "40.7611_-73.968", "10156": "40.7808_-73.9772", "10157": "40.7808_-73.9772", "10158": "40.7494_-73.9758", "10159": "40.7808_-73.9772", "10160": "40.7808_-73.9772", "10161": "40.7808_-73.9772", "10162": "40.7699_-73.9511", "10163": "40.7808_-73.9772", "10164": "40.7808_-73.9772", "10165": "40.7524_-73.9791", "10166": "40.7546_-73.9762", "10167": "40.7549_-73.975", "10168": "40.7519_-73.9768", "10169": "40.7547_-73.9766", "10170": "40.7526_-73.9755", "10171": "40.7564_-73.9748", "10172": "40.7558_-73.9753", "10173": "40.7543_-73.9796", "10174": "40.7517_-73.9752", "10175": "40.7543_-73.9798", "10176": "40.7556_-73.9789", "10177": "40.7553_-73.9761", "10178": "40.7514_-73.9785", "10179": "40.7808_-73.9772", "10185": "40.7808_-73.9772", "10199": "40.7503_-74.0006", "10203": "40.7143_-74.006", "10211": "40.7808_-73.9772", "10212": "40.7143_-74.006", "10213": "40.7143_-74.006", "10242": "40.7143_-74.006", "10249": "40.7143_-74.006", "10256": "40.7143_-74.006", "10258": "40.7143_-74.006", "10259": "40.7143_-74.006", "10260": "40.7143_-74.006", "10261": "40.7808_-73.9772", "10265": "40.7143_-74.006", "10268": "40.7808_-73.9772", "10269": "40.7808_-73.9772", "10270": "40.7069_-74.0082", "10271": "40.7089_-74.0111", "10272": "40.7808_-73.9772", "10273": "40.7143_-74.006", "10274": "40.7808_-73.9772", "10275": "40.7808_-73.9772", "10276": "40.7808_-73.9772", "10277": "40.7808_-73.9772", "10278": "40.7152_-74.0038", "10279": "40.7127_-74.0078", "10280": "40.7105_-74.0163", "10281": "40.7146_-74.015", "10282": "40.7166_-74.0146", "10285": "40.7143_-74.006", "10286": "40.7142_-74.0119", "14008": "43.3105_-78.6372", "14012": "43.3368_-78.542", "14028": "43.3221_-78.7141", "14067": "43.2106_-78.5745", "14092": "43.1722_-79.0215", "14094": "43.16_-78.6923", "14095": "43.1706_-78.6903", "14105": "43.2183_-78.4841", "14107": "43.1851_-78.9837", "14108": "43.2724_-78.707", "14109": "43.138_-79.0342", "14120": "43.0498_-78.851", "14126": "43.3378_-78.7148", "14131": "43.2286_-78.8982", "14132": "43.1419_-78.8785", "14144": "43.1995_-79.0425", "14172": "43.2968_-78.8244", "14174": "43.2461_-79.0245", "14301": "43.0955_-79.0414", "14302": "43.0945_-79.0567", "14303": "43.0878_-79.037", "14304": "43.0908_-78.9644", "14305": "43.1146_-79.0378", "13054": "43.1579_-75.6714", "13123": "43.2364_-75.7769", "13157": "43.1965_-75.7305", "13162": "43.1885_-75.7126", "13301": "43.4157_-75.2137", "13303": "43.3445_-75.4509", "13304": "43.2237_-75.1612", "13308": "43.2303_-75.6873", "13309": "43.4786_-75.344", "13313": "42.8792_-75.2672", "13316": "43.3392_-75.7543", "13318": "42.9069_-75.2607", "13319": "43.0226_-75.2656", "13321": "43.0923_-75.3796", "13322": "42.9801_-75.251", "13323": "43.0586_-75.3808", "13328": "42.9818_-75.4383", "13338": "43.4737_-75.1787", "13341": "43.0361_-75.3962", "13352": "43.3126_-75.1169", "13354": "43.2484_-75.2535", "13362": "42.9803_-75.5186", "13363": "43.3148_-75.5055", "13401": "43.2672_-75.6882", "13403": "43.1639_-75.2783", "13413": "43.0654_-75.2906", "13417": "43.1_-75.2937", "13424": "43.1524_-75.3434", "13425": "42.9576_-75.4838", "13435": "43.3052_-75.1502", "13438": "43.3385_-75.1616", "13440": "43.2193_-75.4498", "13441": "43.2264_-75.4083", "13442": "43.2128_-75.4557", "13449": "43.2393_-75.478", "13455": "42.9162_-75.3545", "13456": "43.0073_-75.2626", "13461": "43.0704_-75.599", "13469": "43.2229_-75.2899", "13471": "43.3366_-75.6027", "13476": "43.0945_-75.5627", "13477": "43.0443_-75.521", "13478": "43.1473_-75.5724", "13479": "43.0538_-75.2716", "13480": "42.9332_-75.3815", "13483": "43.4117_-75.8226", "13486": "43.3294_-75.3151", "13490": "43.1017_-75.4533", "13492": "43.1158_-75.3095", "13494": "43.5249_-75.1428", "13495": "43.1116_-75.2756", "13501": "43.0871_-75.2315", "13502": "43.1067_-75.2314", "13503": "43.1019_-75.2312", "13504": "43.1009_-75.2327", "13505": "43.1009_-75.2327", "13599": "43.1009_-75.2327", "13020": "42.8187_-76.0724", "13027": "43.162_-76.3237", "13029": "43.2252_-76.1351", "13030": "43.159_-75.97", "13031": "43.0417_-76.2807", "13039": "43.1707_-76.0962", "13041": "43.1737_-76.1707", "13051": "42.8765_-75.9135", "13057": "43.0734_-76.0558", "13060": "43.0252_-76.4352", "13063": "42.8531_-75.9836", "13066": "43.0268_-76.0145", "13078": "42.983_-76.0766", "13080": "43.0651_-76.4598", "13082": "43.0981_-75.955", "13084": "42.891_-76.1061", "13088": "43.1099_-76.187", "13089": "43.0214_-76.1977", "13090": "43.1528_-76.2235", "13104": "42.9904_-75.9703", "13108": "42.9821_-76.3323", "13110": "42.8974_-76.2806", "13112": "43.0934_-76.403", "13116": "43.0772_-76.0098", "13119": "42.9745_-76.4408", "13120": "42.9559_-76.1529", "13137": "43.1577_-76.447", "13138": "42.899_-76.016", "13152": "42.9258_-76.4052", "13153": "42.9931_-76.456", "13159": "42.807_-76.1394", "13164": "43.0932_-76.2904", "13201": "43.0481_-76.1474", "13202": "43.041_-76.1489", "13203": "43.0607_-76.1369", "13204": "43.0444_-76.1758", "13205": "43.0123_-76.1452", "13206": "43.0677_-76.1102", "13207": "43.0195_-76.165", "13208": "43.073_-76.1486", "13209": "43.0847_-76.2405", "13210": "43.0354_-76.1282", "13211": "43.1036_-76.1195", "13212": "43.1226_-76.1284", "13214": "43.0397_-76.0722", "13215": "42.9722_-76.2276", "13217": "43.0214_-76.1977", "13218": "43.0214_-76.1977", "13219": "43.0409_-76.2262", "13220": "43.1234_-76.1282", "13221": "43.0481_-76.1474", "13224": "43.0421_-76.1046", "13225": "43.0214_-76.1977", "13235": "43.0559_-76.1526", "13244": "43.0377_-76.1396", "13250": "43.0214_-76.1977", "13251": "43.0214_-76.1977", "13252": "43.051_-76.1567", "13261": "43.0481_-76.1474", "13290": "43.0676_-76.1714", "14424": "42.8689_-77.2846", "14425": "42.958_-77.3083", "14432": "42.9632_-77.144", "14443": "42.901_-77.4233", "14453": "43.0109_-77.4705", "14456": "42.8637_-76.9913", "14461": "42.799_-77.1316", "14463": "42.7966_-77.0639", "14469": "42.8851_-77.46", "14471": "42.7901_-77.5169", "14475": "42.938_-77.5009", "14504": "42.9689_-77.2332", "14512": "42.6404_-77.3901", "14518": "42.9319_-77.0118", "14532": "42.9582_-77.0473", "14537": "43.0345_-77.1575", "14547": "42.887_-77.0961", "14548": "42.9761_-77.2439", "14561": "42.8303_-77.1207", "14564": "42.9866_-77.418", "14585": "42.9063_-77.5531", "10910": "41.2745_-74.1529", "10912": "41.2504_-74.3107", "10914": "41.4093_-74.1951", "10915": "41.5443_-74.3615", "10916": "41.443_-74.2505", "10917": "41.3268_-74.122", "10918": "41.3554_-74.2651", "10919": "41.5244_-74.385", "10921": "41.3295_-74.3528", "10922": "41.3346_-73.9917", "10924": "41.3946_-74.3302", "10925": "41.2101_-74.3033", "10926": "41.3005_-74.1249", "10928": "41.3582_-73.9746", "10930": "41.3536_-74.1197", "10932": "41.4795_-74.4652", "10933": "41.3653_-74.5109", "10940": "41.4512_-74.4701", "10941": "41.4886_-74.345", "10949": "41.3274_-74.1911", "10950": "41.3286_-74.1885", "10953": "41.4009_-74.0785", "10958": "41.3627_-74.4435", "10959": "41.2345_-74.4138", "10963": "41.4818_-74.5294", "10969": "41.2926_-74.4888", "10973": "41.376_-74.4847", "10975": "41.248_-74.1762", "10979": "41.1823_-74.3184", "10981": "41.3232_-74.2886", "10985": "41.575_-74.3225", "10987": "41.1925_-74.2159", "10988": "41.302_-74.5615", "10990": "41.2656_-74.3604", "10992": "41.4237_-74.1601", "10996": "41.3945_-73.9737", "10997": "41.3915_-73.956", "10998": "41.3214_-74.5529", "12518": "41.4162_-74.0395", "12520": "41.433_-74.0061", "12543": "41.4886_-74.2163", "12549": "41.5333_-74.2534", "12550": "41.5372_-74.0526", "12551": "41.5034_-74.0104", "12552": "41.5034_-74.0104", "12553": "41.4724_-74.0566", "12555": "41.5034_-74.0104", "12566": "41.6178_-74.3263", "12575": "41.4575_-74.1659", "12577": "41.4497_-74.1214", "12584": "41.4641_-74.0591", "12586": "41.5596_-74.1764", "12729": "41.4776_-74.5976", "12746": "41.4179_-74.631", "12771": "41.3786_-74.6691", "12780": "41.4443_-74.7213", "14098": "43.3233_-78.3811", "14103": "43.2184_-78.3874", "14411": "43.2398_-78.2068", "14429": "43.1934_-78.0647", "14452": "43.2448_-78.0911", "14470": "43.2159_-78.0731", "14476": "43.3284_-78.0304", "14477": "43.3341_-78.1355", "14479": "43.2363_-78.3138", "14508": "43.3281_-77.9953", "14571": "43.3326_-78.243", "13028": "43.2717_-75.9373", "13036": "43.309_-76.1849", "13042": "43.2432_-75.8537", "13044": "43.2728_-76.0042", "13064": "43.4313_-76.2004", "13069": "43.3211_-76.4034", "13074": "43.3111_-76.546", "13076": "43.3527_-76.1477", "13083": "43.6429_-76.0503", "13093": "43.4987_-76.3858", "13103": "43.3237_-76.1166", "13107": "43.4578_-76.1534", "13114": "43.4605_-76.2446", "13115": "43.3977_-76.4824", "13121": "43.4834_-76.315", "13126": "43.4394_-76.4613", "13131": "43.4153_-76.1", "13132": "43.2609_-76.2395", "13135": "43.2468_-76.3064", "13142": "43.5562_-76.1252", "13144": "43.5776_-76.0029", "13145": "43.6517_-76.1264", "13167": "43.2882_-76.0797", "13302": "43.497_-75.9719", "13426": "43.5628_-75.9968", "13437": "43.5658_-75.8242", "13493": "43.4106_-75.9044", "12064": "42.6321_-74.6674", "12116": "42.5371_-74.903", "12155": "42.59_-74.8149", "12197": "42.6049_-74.7299", "13315": "42.7516_-75.169", "13320": "42.7823_-74.7444", "13326": "42.7005_-74.9243", "13333": "42.8336_-74.8233", "13335": "42.6979_-75.2438", "13337": "42.7252_-74.9869", "13342": "42.6315_-75.1866", "13348": "42.695_-75.055", "13415": "42.5904_-75.1957", "13439": "42.8402_-74.9716", "13450": "42.708_-74.8025", "13457": "42.7758_-75.0485", "13468": "42.8388_-74.859", "13482": "42.7043_-75.1849", "13485": "42.7868_-75.3149", "13488": "42.6809_-74.7653", "13747": "42.5051_-74.9821", "13776": "42.4715_-75.3257", "13796": "42.5383_-75.1279", "13807": "42.6148_-74.9685", "13808": "42.5478_-75.2448", "13810": "42.6068_-75.1264", "13820": "42.4625_-75.0491", "13825": "42.4133_-75.2079", "13834": "42.5304_-74.9671", "13849": "42.3252_-75.3366", "13859": "42.3709_-75.2486", "13861": "42.5011_-75.1409", "10509": "41.4097_-73.5992", "10512": "41.4432_-73.6815", "10516": "41.4414_-73.9335", "10524": "41.3621_-73.92", "10537": "41.3374_-73.8838", "10541": "41.3717_-73.7508", "10542": "41.3726_-73.7601", "10579": "41.3728_-73.8502", "12563": "41.4888_-73.5815", "11004": "40.7481_-73.7114", "11005": "40.7571_-73.7182", "11101": "40.7446_-73.9345", "11102": "40.7706_-73.9265", "11103": "40.7627_-73.9149", "11104": "40.7436_-73.9216", "11105": "40.7763_-73.911", "11106": "40.7608_-73.9295", "11109": "40.7454_-73.9575", "11120": "40.7448_-73.9487", "11351": "40.7817_-73.8317", "11352": "40.6514_-73.8708", "11354": "40.7667_-73.8241", "11355": "40.7536_-73.8226", "11356": "40.7855_-73.845", "11357": "40.7851_-73.8096", "11358": "40.7606_-73.7968", "11359": "40.7928_-73.7767", "11360": "40.7807_-73.7812", "11361": "40.7627_-73.7745", "11362": "40.7591_-73.7326", "11363": "40.7722_-73.7454", "11364": "40.7428_-73.7588", "11365": "40.7374_-73.7951", "11366": "40.7272_-73.7949", "11367": "40.728_-73.8195", "11368": "40.7453_-73.8611", "11369": "40.7613_-73.8739", "11370": "40.7611_-73.8916", "11371": "40.7721_-73.8735", "11372": "40.7513_-73.883", "11373": "40.7351_-73.8776", "11374": "40.7278_-73.8602", "11375": "40.7229_-73.8473", "11377": "40.745_-73.9069", "11378": "40.7239_-73.8997", "11379": "40.7173_-73.8792", "11380": "40.7365_-73.8779", "11381": "40.6514_-73.8708", "11385": "40.7036_-73.8961", "11386": "40.7001_-73.9057", "11405": "40.6514_-73.8708", "11411": "40.6947_-73.7374", "11412": "40.6958_-73.7617", "11413": "40.6645_-73.7559", "11414": "40.6588_-73.8438", "11415": "40.7069_-73.8297", "11416": "40.6838_-73.8514", "11417": "40.6769_-73.8448", "11418": "40.6982_-73.8345", "11419": "40.6868_-73.823", "11420": "40.6744_-73.819", "11421": "40.6913_-73.8585", "11422": "40.6621_-73.7353", "11423": "40.7142_-73.7677", "11424": "40.6514_-73.8708", "11425": "40.6514_-73.8708", "11426": "40.7347_-73.723", "11427": "40.7277_-73.7489", "11428": "40.7208_-73.7433", "11429": "40.709_-73.7401", "11430": "40.6472_-73.7827", "11431": "40.6869_-73.8501", "11432": "40.7119_-73.7944", "11433": "40.6969_-73.7877", "11434": "40.6775_-73.7758", "11435": "40.7029_-73.8111", "11436": "40.6763_-73.7966", "11437": "40.6763_-73.7966", "11439": "40.722_-73.7908", "11451": "40.6514_-73.8708", "11499": "40.6514_-73.8708", "11690": "40.6054_-73.7551", "11691": "40.6006_-73.758", "11692": "40.5923_-73.7933", "11693": "40.6076_-73.8198", "11694": "40.5766_-73.8428", "11695": "40.6514_-73.8708", "11697": "40.5594_-73.9067", "12018": "42.6365_-73.5504", "12022": "42.6919_-73.3702", "12024": "42.495_-73.5107", "12028": "42.9601_-73.4497", "12033": "42.5376_-73.7071", "12040": "42.6467_-73.3716", "12052": "42.7667_-73.4719", "12061": "42.5951_-73.6826", "12062": "42.5352_-73.4984", "12063": "42.5637_-73.6274", "12082": "42.7726_-73.4468", "12089": "42.8667_-73.3181", "12090": "42.8937_-73.3581", "12094": "42.8769_-73.4989", "12121": "42.8412_-73.6077", "12123": "42.5271_-73.6118", "12133": "42.9261_-73.3464", "12138": "42.7495_-73.3401", "12140": "42.6918_-73.5627", "12144": "42.6359_-73.7219", "12153": "42.6379_-73.4989", "12154": "42.9144_-73.6154", "12156": "42.4816_-73.748", "12168": "42.5487_-73.374", "12169": "42.5855_-73.4154", "12180": "42.7287_-73.6683", "12181": "42.7387_-73.6739", "12182": "42.7829_-73.6648", "12185": "42.8855_-73.5437", "12196": "42.638_-73.6109", "12198": "42.6878_-73.6383", "10301": "40.6316_-74.0927", "10302": "40.6306_-74.1379", "10303": "40.6301_-74.1607", "10304": "40.6102_-74.0878", "10305": "40.5973_-74.0768", "10306": "40.5682_-74.1184", "10307": "40.5085_-74.2445", "10308": "40.5518_-74.1526", "10309": "40.5352_-74.2116", "10310": "40.6324_-74.1171", "10311": "40.6052_-74.1795", "10312": "40.5457_-74.1792", "10313": "40.5644_-74.1468", "10314": "40.6039_-74.1472", "10901": "41.1177_-74.1241", "10911": "41.1609_-74.0608", "10913": "41.0626_-73.9629", "10920": "41.1487_-73.9413", "10923": "41.2021_-74.0005", "10927": "41.1971_-73.969", "10931": "41.124_-74.1702", "10952": "41.1163_-74.0736", "10954": "41.0977_-74.0109", "10956": "41.1472_-73.9962", "10960": "41.0914_-73.9252", "10962": "41.0442_-73.9609", "10964": "41.0103_-73.925", "10965": "41.0629_-74.0159", "10968": "41.0395_-73.9192", "10970": "41.1901_-74.0436", "10974": "41.1575_-74.2008", "10976": "41.0256_-73.9229", "10977": "41.1158_-74.0474", "10980": "41.2292_-73.9962", "10982": "41.1112_-74.0999", "10983": "41.0278_-73.9491", "10984": "41.2078_-74.0154", "10986": "41.2598_-73.9892", "10989": "41.1183_-73.943", "10993": "41.209_-73.9821", "10994": "41.0973_-73.9768", "12922": "44.2867_-74.6759", "12927": "44.229_-74.8581", "12949": "44.7469_-74.6604", "12965": "44.703_-74.6805", "12967": "44.775_-74.6653", "12973": "44.2343_-74.556", "13613": "44.8467_-74.7473", "13614": "44.5525_-75.6722", "13617": "44.5924_-75.1628", "13621": "44.8672_-75.073", "13623": "44.442_-75.7569", "13625": "44.5016_-74.9327", "13630": "44.4896_-75.2871", "13633": "44.4989_-75.4772", "13635": "44.311_-75.2522", "13639": "44.2541_-75.1379", "13642": "44.3283_-75.4651", "13645": "44.3101_-75.4463", "13646": "44.4502_-75.6727", "13647": "44.6087_-74.9732", "13649": "44.9217_-74.7068", "13652": "44.4448_-75.1987", "13654": "44.593_-75.4203", "13658": "44.7184_-75.2694", "13660": "44.769_-75.1413", "13662": "44.9322_-74.8845", "13664": "44.5843_-75.6453", "13666": "44.2177_-74.9423", "13667": "44.8424_-74.9577", "13668": "44.7472_-74.9992", "13669": "44.6902_-75.4774", "13670": "44.1933_-75.0659", "13672": "44.5927_-74.7941", "13676": "44.6592_-74.9681", "13677": "44.5148_-75.1858", "13678": "44.8287_-74.9798", "13680": "44.5943_-75.3237", "13681": "44.44_-75.3777", "13683": "44.9728_-74.731", "13684": "44.3824_-75.1043", "13687": "44.5041_-74.8607", "13690": "44.1578_-75.033", "13694": "44.8564_-75.2049", "13695": "44.1408_-74.9125", "13696": "44.7137_-74.9008", "13697": "44.7583_-74.8066", "13699": "44.6698_-74.9813", "12019": "42.9192_-73.8552", "12020": "43.005_-73.8486", "12027": "42.9329_-73.896", "12065": "42.8499_-73.7851", "12074": "43.0217_-74.029", "12118": "42.9168_-73.7214", "12148": "42.8524_-73.8701", "12151": "42.9247_-73.7859", "12170": "43.0019_-73.6609", "12188": "42.81_-73.6995", "12803": "43.2836_-73.6294", "12822": "43.2426_-73.8369", "12831": "43.1803_-73.7053", "12833": "43.1401_-73.8398", "12835": "43.3173_-73.8482", "12850": "43.0975_-74.0167", "12859": "43.1724_-73.8839", "12863": "43.0662_-73.9215", "12866": "43.0708_-73.7408", "12871": "43.0878_-73.6007", "12884": "43.0884_-73.5917", "12008": "42.8573_-73.9002", "12053": "42.748_-74.1868", "12056": "42.7708_-74.0839", "12137": "42.8499_-74.1231", "12141": "42.7318_-74.1854", "12150": "42.8745_-74.0465", "12301": "42.8142_-73.9396", "12302": "42.88_-73.9913", "12303": "42.7823_-73.9448", "12304": "42.7841_-73.9094", "12305": "42.8161_-73.9398", "12306": "42.7904_-73.9809", "12307": "42.8047_-73.9363", "12308": "42.8179_-73.9206", "12309": "42.8091_-73.8693", "12325": "42.8333_-74.058", "12345": "42.8142_-73.9396", "12031": "42.7648_-74.4569", "12035": "42.737_-74.3451", "12036": "42.533_-74.6819", "12043": "42.684_-74.4939", "12071": "42.5923_-74.4381", "12073": "42.6626_-74.2326", "12076": "42.4108_-74.4003", "12092": "42.7045_-74.3648", "12093": "42.4999_-74.6117", "12122": "42.5637_-74.3292", "12131": "42.4899_-74.4282", "12149": "42.6424_-74.571", "12157": "42.6615_-74.3047", "12160": "42.7599_-74.3642", "12175": "42.535_-74.5452", "12187": "42.6604_-74.5074", "12194": "42.5506_-74.4631", "13459": "42.7634_-74.5919", "14805": "42.351_-76.7348", "14812": "42.2798_-76.972", "14818": "42.4394_-76.8292", "14824": "42.2774_-76.6974", "14841": "42.4966_-76.8786", "14863": "42.4516_-76.7067", "14865": "42.3437_-76.8396", "14869": "42.3609_-76.7717", "14876": "42.4297_-76.9258", "14887": "42.3994_-77.0268", "14891": "42.3771_-76.9022", "14893": "42.4741_-77.0977", "13065": "42.8227_-76.802", "13148": "42.9094_-76.7925", "13165": "42.9045_-76.8755", "14521": "42.6898_-76.7941", "14541": "42.7497_-76.8449", "14588": "42.6835_-76.8724", "14847": "42.6165_-76.7268", "14860": "42.5966_-76.8339", "14529": "42.5398_-77.6283", "14572": "42.5593_-77.5906", "14801": "42.0983_-77.266", "14807": "42.4225_-77.6918", "14808": "42.5596_-77.4669", "14809": "42.3679_-77.4641", "14810": "42.3575_-77.3028", "14815": "42.3825_-77.0913", "14819": "42.2128_-77.4403", "14820": "42.1925_-77.365", "14821": "42.2386_-77.2066", "14823": "42.2635_-77.5897", "14826": "42.5003_-77.4998", "14827": "42.1785_-77.1414", "14830": "42.1383_-77.0475", "14831": "42.1429_-77.0547", "14839": "42.1398_-77.636", "14840": "42.4312_-77.1977", "14843": "42.3274_-77.6569", "14855": "42.129_-77.4999", "14856": "42.3742_-77.3648", "14858": "42.0284_-77.1397", "14870": "42.171_-77.1194", "14873": "42.5224_-77.2983", "14874": "42.5233_-77.1691", "14877": "42.0726_-77.6767", "14879": "42.3041_-77.2083", "14885": "42.0501_-77.5502", "14898": "42.0736_-77.4203", "00501": "40.8154_-73.0451", "00544": "40.8154_-73.0451", "06390": "41.2639_-72.0178", "11701": "40.6842_-73.4171", "11702": "40.6957_-73.3257", "11703": "40.7321_-73.3236", "11704": "40.7135_-73.3546", "11705": "40.7444_-73.0542", "11706": "40.7051_-73.243", "11707": "40.7182_-73.3543", "11713": "40.7733_-72.9469", "11715": "40.7501_-73.0352", "11716": "40.7678_-73.1163", "11717": "40.7809_-73.2503", "11718": "40.728_-73.2646", "11719": "40.7843_-72.8921", "11720": "40.8705_-73.0822", "11721": "40.8929_-73.3754", "11722": "40.7866_-73.1961", "11724": "40.8601_-73.4423", "11725": "40.843_-73.2799", "11726": "40.6778_-73.3963", "11727": "40.885_-73.0069", "11729": "40.7591_-73.3257", "11730": "40.7282_-73.1805", "11731": "40.857_-73.3146", "11733": "40.9426_-73.1116", "11738": "40.8366_-73.0413", "11739": "40.7297_-73.1607", "11740": "40.8621_-73.3646", "11741": "40.7964_-73.0718", "11742": "40.8105_-73.0416", "11743": "40.8676_-73.4102", "11746": "40.8143_-73.3634", "11747": "40.7946_-73.403", "11749": "40.8067_-73.1709", "11751": "40.7348_-73.2221", "11752": "40.7548_-73.1827", "11754": "40.8861_-73.2438", "11755": "40.8567_-73.1168", "11757": "40.6884_-73.3745", "11760": "40.7934_-73.4151", "11763": "40.8174_-72.9852", "11764": "40.9436_-72.9913", "11766": "40.9271_-73.0127", "11767": "40.8462_-73.1482", "11768": "40.9051_-73.3309", "11769": "40.7382_-73.1297", "11770": "40.6443_-73.1613", "11772": "40.7609_-72.9871", "11775": "40.7934_-73.4151", "11776": "40.9136_-73.0464", "11777": "40.9457_-73.0611", "11778": "40.9492_-72.9357", "11779": "40.8083_-73.1305", "11780": "40.8813_-73.1591", "11782": "40.7459_-73.0859", "11784": "40.8699_-73.0448", "11786": "40.9485_-72.8927", "11787": "40.8542_-73.2138", "11788": "40.8231_-73.1958", "11789": "40.9567_-72.9742", "11790": "40.9068_-73.1277", "11792": "40.952_-72.8348", "11794": "40.9257_-73.1409", "11795": "40.7117_-73.3007", "11796": "40.732_-73.1", "11798": "40.7523_-73.3761", "11901": "40.9262_-72.652", "11930": "40.9895_-72.0959", "11931": "40.9445_-72.627", "11932": "40.9339_-72.3077", "11933": "40.9297_-72.7423", "11934": "40.7997_-72.797", "11935": "41.0139_-72.4803", "11937": "40.993_-72.179", "11939": "41.1264_-72.3419", "11940": "40.809_-72.7538", "11941": "40.8297_-72.7283", "11942": "40.8428_-72.5813", "11944": "41.1039_-72.3674", "11946": "40.8726_-72.5202", "11947": "40.9495_-72.5815", "11948": "40.9674_-72.554", "11949": "40.8421_-72.8002", "11950": "40.8064_-72.8566", "11951": "40.7657_-72.8537", "11952": "40.9943_-72.5363", "11953": "40.8782_-72.9525", "11954": "41.0459_-71.944", "11955": "40.8095_-72.8229", "11956": "40.9915_-72.4759", "11957": "41.1437_-72.2879", "11958": "41.0392_-72.4666", "11959": "40.8226_-72.6012", "11960": "40.8086_-72.7064", "11961": "40.9018_-72.8881", "11962": "40.9305_-72.2707", "11963": "40.982_-72.3067", "11964": "41.064_-72.3366", "11965": "41.084_-72.3559", "11967": "40.8015_-72.8676", "11968": "40.9043_-72.4103", "11969": "40.8843_-72.3895", "11970": "40.9365_-72.5773", "11971": "41.0555_-72.429", "11972": "40.8195_-72.7054", "11973": "40.8678_-72.8822", "11975": "40.9396_-72.2425", "11976": "40.9209_-72.3491", "11977": "40.818_-72.6699", "11978": "40.8295_-72.6473", "11980": "40.837_-72.9174", "12701": "41.6516_-74.7007", "12719": "41.4912_-74.9152", "12720": "41.6693_-74.894", "12721": "41.5644_-74.4304", "12722": "41.5901_-74.3821", "12723": "41.7673_-75.0563", "12724": "41.8368_-74.9466", "12725": "41.9657_-74.5293", "12726": "41.692_-74.9741", "12727": "41.6548_-74.9827", "12732": "41.5328_-74.8968", "12733": "41.7273_-74.6154", "12734": "41.7349_-74.7345", "12736": "41.8782_-75.0343", "12737": "41.4858_-74.7995", "12738": "41.6545_-74.5833", "12740": "41.8807_-74.5127", "12741": "41.8391_-75.0534", "12742": "41.7143_-74.7263", "12743": "41.5309_-74.8516", "12745": "41.7629_-75.0306", "12747": "41.7356_-74.6743", "12748": "41.7784_-74.9196", "12749": "41.6874_-74.8358", "12750": "41.7296_-74.9611", "12751": "41.6838_-74.6724", "12752": "41.6782_-74.9949", "12754": "41.7962_-74.7484", "12758": "41.8778_-74.827", "12759": "41.7789_-74.6614", "12760": "41.8644_-75.0942", "12762": "41.681_-74.8028", "12763": "41.6918_-74.5358", "12764": "41.5921_-75.0107", "12765": "41.8492_-74.6127", "12766": "41.8142_-74.9824", "12767": "41.8448_-75.0071", "12768": "41.8517_-74.7359", "12769": "41.6515_-74.4362", "12770": "41.4511_-74.841", "12775": "41.6134_-74.5872", "12776": "41.9609_-74.9346", "12777": "41.5691_-74.7241", "12778": "41.6615_-74.8178", "12779": "41.7042_-74.6444", "12781": "41.6215_-74.4507", "12783": "41.7285_-74.8341", "12784": "41.6681_-74.6252", "12785": "41.4987_-74.5585", "12786": "41.6485_-74.8654", "12787": "41.8002_-74.8286", "12788": "41.7708_-74.5928", "12789": "41.717_-74.5815", "12790": "41.5877_-74.5039", "12791": "41.8032_-74.8888", "12792": "41.5226_-74.9329", "13732": "42.0556_-76.1519", "13734": "42.0695_-76.3983", "13736": "42.3074_-76.192", "13743": "42.2063_-76.3322", "13811": "42.2281_-76.1625", "13812": "42.0301_-76.354", "13827": "42.1138_-76.2528", "13835": "42.3945_-76.1865", "13840": "42.0395_-76.4004", "13845": "42.0562_-76.348", "13864": "42.3029_-76.3897", "14859": "42.1149_-76.5366", "14883": "42.2467_-76.4899", "14892": "42.0172_-76.5333", "13053": "42.4861_-76.2872", "13062": "42.4851_-76.3835", "13068": "42.4998_-76.3636", "13073": "42.5855_-76.3633", "13102": "42.5542_-76.2927", "14817": "42.3765_-76.3668", "14850": "42.4406_-76.4966", "14851": "42.4607_-76.5054", "14852": "42.4451_-76.4672", "14853": "42.4474_-76.4837", "14854": "42.5084_-76.6149", "14867": "42.3621_-76.592", "14881": "42.4025_-76.3608", "14882": "42.5645_-76.5375", "14886": "42.521_-76.6681", "12401": "41.9697_-74.0668", "12402": "41.927_-73.9974", "12404": "41.8083_-74.2353", "12409": "42.0406_-74.1551", "12410": "42.074_-74.453", "12411": "41.8752_-74.0436", "12412": "42.0048_-74.2658", "12416": "42.095_-74.2717", "12417": "41.9076_-73.9893", "12419": "41.8467_-74.1038", "12420": "41.6698_-74.3801", "12428": "41.7218_-74.4141", "12429": "41.8279_-73.9651", "12432": "42.0437_-73.9474", "12433": "42.0053_-74.1532", "12435": "41.7281_-74.5201", "12440": "41.8167_-74.1311", "12441": "42.1443_-74.4899", "12443": "41.9327_-74.0687", "12446": "41.7939_-74.3035", "12448": "42.0733_-74.2123", "12449": "41.9918_-73.9924", "12453": "42.0987_-73.9354", "12456": "42.0357_-74.0002", "12457": "42.0435_-74.2485", "12458": "41.759_-74.3804", "12461": "41.875_-74.2734", "12464": "42.0848_-74.3154", "12465": "42.1331_-74.4802", "12466": "41.8948_-73.9767", "12471": "41.8403_-74.0306", "12472": "41.8402_-74.073", "12475": "42.0176_-74.0079", "12477": "42.0738_-73.9797", "12480": "42.1363_-74.3774", "12481": "41.9767_-74.2119", "12483": "41.6639_-74.4245", "12484": "41.8616_-74.1697", "12486": "41.8338_-74.0626", "12487": "41.8651_-73.9948", "12489": "41.7606_-74.3535", "12490": "42.1231_-73.9349", "12491": "41.9973_-74.1049", "12493": "41.7953_-73.9809", "12494": "41.9673_-74.2871", "12495": "42.0849_-74.2407", "12498": "42.0348_-74.112", "12515": "41.6749_-74.0557", "12525": "41.6576_-74.1672", "12528": "41.7167_-73.9928", "12542": "41.6056_-73.988", "12547": "41.6535_-73.9772", "12548": "41.6503_-74.1036", "12561": "41.7464_-74.1092", "12568": "41.6412_-74.0781", "12588": "41.6337_-74.3779", "12589": "41.616_-74.1439", "12801": "43.3115_-73.6448", "12804": "43.329_-73.6818", "12808": "43.7165_-73.7825", "12810": "43.4839_-73.8817", "12811": "43.6148_-74.0249", "12814": "43.5766_-73.6714", "12815": "43.6989_-73.7205", "12817": "43.6451_-73.8066", "12820": "43.4718_-73.6393", "12824": "43.5156_-73.7001", "12836": "43.7463_-73.5282", "12843": "43.586_-73.9165", "12844": "43.4754_-73.6272", "12845": "43.4167_-73.6975", "12846": "43.3165_-73.8228", "12853": "43.6978_-73.986", "12856": "43.7237_-74.0873", "12860": "43.7312_-73.8193", "12862": "43.6617_-73.8971", "12874": "43.6978_-73.5071", "12878": "43.4214_-73.9495", "12885": "43.5003_-73.792", "12886": "43.6313_-73.9364", "12057": "42.9808_-73.3522", "12809": "43.2381_-73.4641", "12816": "43.0466_-73.3814", "12819": "43.6435_-73.4326", "12821": "43.4614_-73.4033", "12823": "43.1837_-73.4268", "12827": "43.4285_-73.4784", "12828": "43.2653_-73.5822", "12832": "43.3776_-73.2978", "12834": "43.0947_-73.503", "12837": "43.5248_-73.2518", "12838": "43.3493_-73.4049", "12839": "43.3149_-73.5746", "12841": "43.6392_-73.5071", "12848": "43.1001_-73.5246", "12849": "43.4508_-73.3031", "12854": "43.4525_-73.341", "12861": "43.756_-73.4123", "12865": "43.1828_-73.3327", "12873": "43.1106_-73.3231", "12887": "43.5531_-73.3864", "13143": "43.2291_-76.7146", "13146": "43.0934_-76.7565", "13154": "43.1344_-76.7656", "14413": "43.2227_-76.9821", "14433": "43.0855_-76.8725", "14449": "43.2354_-77.1376", "14489": "43.0777_-76.9896", "14502": "43.0784_-77.3372", "14505": "43.1546_-77.1863", "14513": "43.0519_-77.0946", "14516": "43.1964_-76.9152", "14519": "43.2291_-77.3088", "14520": "43.2259_-77.3058", "14522": "43.0622_-77.2218", "14538": "43.2836_-77.142", "14542": "43.1448_-76.8608", "14551": "43.2217_-77.0514", "14555": "43.2546_-76.9835", "14563": "43.2228_-77.3717", "14568": "43.1402_-77.2858", "14589": "43.2421_-77.17", "14590": "43.2341_-76.8217", "10501": "41.2946_-73.7611", "10502": "41.0113_-73.8413", "10503": "41.0259_-73.8718", "10504": "41.136_-73.7009", "10505": "41.3421_-73.7454", "10506": "41.1909_-73.6355", "10507": "41.2344_-73.6915", "10510": "41.1444_-73.835", "10511": "41.2583_-73.9412", "10514": "41.1705_-73.7715", "10517": "41.3006_-73.8612", "10518": "41.2722_-73.602", "10519": "41.3477_-73.661", "10520": "41.218_-73.8924", "10521": "41.2343_-73.9262", "10522": "41.0118_-73.8665", "10523": "41.0572_-73.8136", "10526": "41.3004_-73.6479", "10527": "41.3098_-73.753", "10528": "40.9719_-73.7181", "10530": "41.0197_-73.8074", "10532": "41.1073_-73.796", "10533": "41.0381_-73.8597", "10535": "41.3385_-73.7947", "10536": "41.2709_-73.6841", "10538": "40.9351_-73.7571", "10540": "41.3334_-73.7243", "10543": "40.9525_-73.735", "10545": "41.119_-73.733", "10546": "41.2015_-73.7926", "10547": "41.3143_-73.8508", "10548": "41.2496_-73.9446", "10549": "41.205_-73.7299", "10550": "40.9079_-73.838", "10551": "40.9126_-73.8371", "10552": "40.9231_-73.8299", "10553": "40.9086_-73.8221", "10560": "41.3414_-73.5929", "10562": "41.1673_-73.8538", "10566": "41.2892_-73.9184", "10567": "41.284_-73.8931", "10570": "41.135_-73.7845", "10573": "41.0222_-73.6798", "10576": "41.2042_-73.5732", "10577": "41.0384_-73.7156", "10578": "41.3259_-73.6551", "10580": "40.9734_-73.6907", "10583": "40.9927_-73.7995", "10587": "41.3287_-73.7423", "10588": "41.3286_-73.8273", "10589": "41.3346_-73.6951", "10590": "41.2553_-73.5402", "10591": "41.0897_-73.844", "10594": "41.1182_-73.7733", "10595": "41.0856_-73.7776", "10596": "41.2548_-73.9587", "10597": "41.3032_-73.6032", "10598": "41.2999_-73.7924", "10601": "41.033_-73.7652", "10602": "41.034_-73.7629", "10603": "41.0499_-73.7776", "10604": "41.0592_-73.7395", "10605": "41.0141_-73.7552", "10606": "41.0247_-73.7781", "10607": "41.0398_-73.8117", "10610": "41.119_-73.733", "10701": "40.9461_-73.8669", "10702": "40.9312_-73.8987", "10703": "40.9518_-73.8852", "10704": "40.9176_-73.8593", "10705": "40.9177_-73.895", "10706": "40.9878_-73.863", "10707": "40.9569_-73.8198", "10708": "40.9391_-73.8353", "10709": "40.955_-73.8086", "10710": "40.9656_-73.8434", "10801": "40.9166_-73.7877", "10802": "40.9115_-73.7824", "10803": "40.9045_-73.8073", "10804": "40.9491_-73.7863", "10805": "40.9002_-73.781", "14009": "42.563_-78.4134", "14011": "42.8499_-78.2798", "14024": "42.5799_-78.2581", "14037": "42.8112_-78.4481", "14039": "42.8263_-78.1749", "14066": "42.619_-78.1795", "14082": "42.6634_-78.3925", "14083": "42.6769_-78.441", "14113": "42.6776_-78.338", "14130": "42.5565_-78.1528", "14145": "42.7249_-78.4347", "14167": "42.7459_-78.3167", "14427": "42.6359_-78.0547", "14530": "42.7229_-78.0059", "14536": "42.557_-78.0856", "14549": "42.6929_-78.0224", "14550": "42.6742_-78.0845", "14569": "42.741_-78.1429", "14591": "42.8317_-78.0833", "14415": "42.7554_-77.0217", "14418": "42.6065_-77.2052", "14441": "42.6846_-76.9564", "14478": "42.5708_-77.1226", "14507": "42.6976_-77.2805", "14527": "42.6645_-77.0569", "14544": "42.7597_-77.2395", "14837": "42.5053_-77.0028", "14842": "42.5945_-76.9508", "14857": "42.5126_-76.927", "14878": "42.4485_-76.9364", "45105": "38.7498_-83.6126", "45144": "38.6982_-83.6181", "45616": "38.7776_-83.3302", "45618": "38.8922_-83.6218", "45650": "38.7391_-83.4262", "45660": "38.9869_-83.3687", "45679": "38.9621_-83.5936", "45693": "38.8017_-83.5333", "45697": "38.9353_-83.6661", "45801": "40.7641_-84.0973", "45802": "40.7818_-84.1386", "45804": "40.7275_-84.089", "45805": "40.7399_-84.1459", "45807": "40.7955_-84.1383", "45808": "40.8314_-83.9758", "45809": "40.8451_-84.1872", "45817": "40.879_-83.8914", "45820": "40.8304_-84.0852", "45833": "40.8336_-84.3247", "45850": "40.7177_-83.9436", "45854": "40.7582_-83.9499", "45887": "40.7038_-84.3413", "44805": "40.8559_-82.3189", "44838": "40.7731_-82.2624", "44840": "40.8134_-82.1861", "44842": "40.6361_-82.2356", "44848": "40.9206_-82.2817", "44859": "41.0282_-82.3384", "44864": "40.6606_-82.3213", "44866": "40.9343_-82.2126", "44874": "40.9653_-82.3652", "44880": "41.0368_-82.2172", "44003": "41.6225_-80.5754", "44004": "41.8679_-80.7947", "44005": "41.8651_-80.7898", "44010": "41.7554_-80.8584", "44030": "41.9345_-80.5803", "44032": "41.659_-80.6683", "44041": "41.8029_-80.9474", "44047": "41.7335_-80.7562", "44048": "41.8723_-80.6601", "44068": "41.9046_-80.685", "44076": "41.5293_-80.8208", "44082": "41.7677_-80.5741", "44084": "41.6603_-80.8606", "44085": "41.6053_-80.8709", "44088": "41.7833_-81.0034", "44093": "41.5383_-80.5964", "44099": "41.5623_-80.9667", "45701": "39.3178_-82.102", "45710": "39.2097_-82.2177", "45711": "39.4086_-81.965", "45716": "39.462_-82.1818", "45717": "39.3778_-82.271", "45719": "39.4002_-82.1302", "45723": "39.2141_-81.8329", "45732": "39.4978_-82.0871", "45735": "39.2493_-81.922", "45739": "39.1979_-81.7446", "45740": "39.477_-82.0794", "45761": "39.4077_-82.1113", "45764": "39.4556_-82.2309", "45766": "39.3228_-82.2594", "45776": "39.2129_-82.0218", "45777": "39.4359_-81.9115", "45778": "39.3213_-81.8929", "45780": "39.3662_-82.1341", "45782": "39.4845_-82.0805", "45806": "40.6752_-84.1244", "45819": "40.6241_-84.2603", "45865": "40.391_-84.3729", "45869": "40.4389_-84.3821", "45870": "40.5563_-83.9514", "45871": "40.5039_-84.3118", "45884": "40.5559_-84.0836", "45885": "40.544_-84.3944", "45888": "40.6023_-84.086", "45895": "40.569_-84.1774", "45896": "40.6072_-83.9585", "43713": "39.9853_-81.1375", "43718": "40.032_-81.0066", "43719": "40.0192_-81.0767", "43759": "40.0631_-81.0743", "43902": "39.9053_-80.9578", "43905": "40.1073_-80.8412", "43906": "40.0204_-80.7638", "43909": "40.0701_-80.8176", "43912": "40.0752_-80.7747", "43916": "40.1224_-80.8149", "43927": "40.1225_-80.938", "43928": "40.0109_-80.8993", "43933": "39.9372_-80.888", "43934": "40.0756_-80.7901", "43935": "40.1036_-80.7361", "43937": "40.1302_-80.8773", "43940": "40.0284_-80.8245", "43942": "39.8679_-80.8168", "43947": "39.9675_-80.7643", "43950": "40.0778_-80.9788", "43951": "40.111_-81.0102", "43967": "40.0226_-80.9373", "43972": "40.1032_-80.9756", "43977": "40.1451_-81.0757", "43983": "40.1507_-81.2145", "43985": "40.1623_-81.1326", "45101": "38.6709_-83.7637", "45115": "38.8237_-83.6995", "45118": "39.1862_-83.9501", "45119": "38.8806_-84.0087", "45121": "38.8717_-83.9092", "45130": "38.92_-83.9931", "45131": "38.7903_-83.9666", "45154": "39.0454_-83.948", "45167": "38.7551_-83.8227", "45168": "38.8511_-83.7625", "45171": "38.9832_-83.7966", "45275": "39.162_-84.4569", "45003": "39.5755_-84.805", "45004": "39.5153_-84.6094", "45011": "39.4059_-84.5221", "45012": "39.441_-84.5757", "45013": "39.4361_-84.6185", "45014": "39.3266_-84.5479", "45015": "39.3494_-84.5376", "45018": "39.441_-84.5757", "45042": "39.5321_-84.3896", "45044": "39.5151_-84.3983", "45050": "39.4413_-84.3652", "45053": "39.3537_-84.7761", "45055": "39.4518_-84.5152", "45056": "39.507_-84.7452", "45061": "39.3124_-84.6483", "45062": "39.479_-84.5512", "45063": "39.3258_-84.7121", "45064": "39.5554_-84.6219", "45067": "39.4799_-84.4598", "45069": "39.3402_-84.3998", "45071": "39.3317_-84.4072", "44607": "40.686_-81.0219", "44615": "40.5787_-81.0818", "44620": "40.5861_-81.1986", "44639": "40.4517_-81.212", "44644": "40.6845_-81.1838", "44651": "40.6263_-80.956", "44675": "40.5184_-81.2339", "43009": "40.1784_-83.647", "43044": "40.0647_-83.5724", "43047": "40.2049_-83.6466", "43060": "40.2229_-83.5615", "43070": "40.2158_-83.9579", "43072": "40.1058_-83.9631", "43078": "40.1066_-83.7671", "43083": "40.1022_-83.8379", "43084": "40.1816_-83.5461", "45389": "40.0564_-84.0254", "43010": "39.9991_-83.6222", "45319": "39.9189_-83.9449", "45323": "39.8663_-83.9385", "45341": "39.8789_-84.0218", "45344": "39.93_-84.0217", "45349": "39.9893_-83.9389", "45368": "39.8543_-83.6653", "45369": "39.9473_-83.6157", "45372": "40.0139_-83.8333", "45501": "39.9271_-83.8132", "45502": "39.9242_-83.8088", "45503": "39.9528_-83.7804", "45504": "39.9408_-83.8343", "45505": "39.9106_-83.7856", "45506": "39.9104_-83.8275", "45102": "39.0211_-84.2112", "45103": "39.0957_-84.1451", "45106": "38.9424_-84.0919", "45112": "38.7926_-84.1382", "45120": "38.8262_-84.0986", "45122": "39.2209_-84.1188", "45140": "39.2445_-84.2588", "45147": "39.2137_-84.3002", "45150": "39.1657_-84.233", "45153": "38.8583_-84.1958", "45156": "38.8101_-84.2122", "45157": "38.9537_-84.2379", "45158": "39.182_-84.0863", "45160": "39.1232_-84.135", "45176": "39.0753_-84.0432", "45245": "39.0688_-84.2802", "45107": "39.3034_-83.974", "45113": "39.4042_-83.9594", "45114": "39.3568_-83.8572", "45146": "39.3127_-83.8005", "45148": "39.2917_-83.8931", "45159": "39.3321_-83.6882", "45164": "39.5514_-83.7881", "45166": "39.4805_-83.6772", "45169": "39.49_-83.6503", "45177": "39.4488_-83.8417", "43920": "40.6774_-80.6006", "43945": "40.6195_-80.835", "43962": "40.6781_-80.8862", "43968": "40.6171_-80.6621", "44408": "40.8853_-80.6975", "44413": "40.8406_-80.5465", "44415": "40.763_-80.7042", "44423": "40.7731_-80.9144", "44427": "40.7142_-80.9381", "44431": "40.8631_-80.7585", "44432": "40.7592_-80.7587", "44441": "40.7579_-80.553", "44445": "40.8489_-80.6209", "44455": "40.7789_-80.6202", "44460": "40.9_-80.8619", "44490": "40.8973_-80.7631", "44492": "40.7093_-80.7014", "44493": "40.8286_-80.8967", "44625": "40.7563_-81.0175", "44634": "40.8301_-81.0333", "44665": "40.8436_-80.9794", "43803": "40.3572_-81.6436", "43805": "40.3983_-81.9688", "43811": "40.1804_-81.8951", "43812": "40.2754_-81.866", "43824": "40.3711_-81.7623", "43828": "40.3513_-81.8736", "43836": "40.2087_-81.7197", "43843": "40.3407_-82.1559", "43844": "40.3172_-82.056", "43845": "40.2718_-81.7361", "44820": "40.8103_-82.9698", "44825": "40.9542_-82.9432", "44827": "40.7927_-82.7367", "44833": "40.7303_-82.7939", "44854": "40.9571_-82.8504", "44856": "40.7934_-82.8566", "44860": "40.8357_-83.1029", "44881": "40.8709_-82.8771", "44887": "40.881_-82.797", "44017": "41.3676_-81.8618", "44022": "41.4494_-81.4314", "44040": "41.5324_-81.415", "44070": "41.4201_-81.9131", "44101": "41.5234_-81.5996", "44102": "41.4735_-81.7398", "44103": "41.5157_-81.6405", "44104": "41.4809_-81.6245", "44105": "41.4509_-81.619", "44106": "41.5084_-81.6076", "44107": "41.4847_-81.8018", "44108": "41.5349_-81.609", "44109": "41.4458_-81.7033", "44110": "41.5636_-81.5733", "44111": "41.4571_-81.7844", "44112": "41.5356_-81.5737", "44113": "41.4816_-81.7018", "44114": "41.5064_-81.6743", "44115": "41.4946_-81.667", "44116": "41.4694_-81.8512", "44117": "41.5696_-81.5257", "44118": "41.5008_-81.5516", "44119": "41.5882_-81.5468", "44120": "41.4714_-81.5839", "44121": "41.5277_-81.5323", "44122": "41.4701_-81.5232", "44123": "41.6025_-81.5258", "44124": "41.501_-81.4694", "44125": "41.4335_-81.6323", "44126": "41.4429_-81.853", "44127": "41.4701_-81.649", "44128": "41.4416_-81.5486", "44129": "41.3897_-81.7351", "44130": "41.3826_-81.7964", "44131": "41.3809_-81.6642", "44132": "41.6069_-81.4993", "44133": "41.3232_-81.7457", "44134": "41.3853_-81.7044", "44135": "41.4342_-81.8044", "44136": "41.3132_-81.8285", "44137": "41.4105_-81.5603", "44138": "41.3734_-81.9158", "44139": "41.3866_-81.4421", "44140": "41.4841_-81.9289", "44141": "41.3166_-81.6261", "44142": "41.3979_-81.8118", "44143": "41.5592_-81.4828", "44144": "41.4385_-81.7398", "44145": "41.4535_-81.9218", "44146": "41.3921_-81.5232", "44147": "41.3141_-81.6731", "44181": "41.6857_-81.6728", "44188": "41.6857_-81.6728", "44190": "41.6857_-81.6728", "44191": "41.6857_-81.6728", "44192": "41.4995_-81.6954", "44193": "41.4995_-81.6954", "44194": "41.6857_-81.6728", "44195": "41.6857_-81.6728", "44197": "41.6857_-81.6728", "44198": "41.6857_-81.6728", "44199": "41.4995_-81.6954", "45303": "40.2151_-84.6406", "45304": "39.9888_-84.5312", "45328": "40.1147_-84.4934", "45331": "40.0987_-84.6342", "45332": "39.9899_-84.7901", "45346": "39.9687_-84.7222", "45348": "40.3349_-84.6308", "45350": "40.3243_-84.5737", "45351": "40.3406_-84.4963", "45352": "40.0503_-84.7457", "45358": "39.987_-84.4866", "45362": "40.2946_-84.6264", "45380": "40.2273_-84.4957", "45388": "40.3283_-84.4836", "45390": "40.2018_-84.7832", "43512": "41.2799_-84.3626", "43519": "41.4222_-84.3966", "43520": "41.3907_-84.6313", "43526": "41.3034_-84.7589", "43530": "41.3258_-84.2793", "43536": "41.2917_-84.6278", "43549": "41.3781_-84.5269", "43556": "41.2946_-84.5417", "43003": "40.4163_-82.9542", "43015": "40.2932_-83.0723", "43021": "40.2011_-82.8749", "43032": "40.3286_-82.9588", "43035": "40.1879_-82.9878", "43061": "40.274_-83.1978", "43065": "40.1834_-83.0912", "43066": "40.3918_-83.1781", "43074": "40.2655_-82.8511", "43082": "40.1524_-82.882", "43438": "41.6008_-82.7068", "44089": "41.41_-82.3554", "44814": "41.3205_-82.4777", "44816": "41.3349_-82.355", "44824": "41.3872_-82.7994", "44839": "41.3757_-82.5386", "44846": "41.3111_-82.6126", "44870": "41.4349_-82.7063", "44871": "41.4489_-82.708", "43046": "39.8993_-82.5283", "43102": "39.6251_-82.7552", "43105": "39.8645_-82.624", "43107": "39.6909_-82.4096", "43110": "39.8349_-82.8044", "43112": "39.7957_-82.7084", "43130": "39.7187_-82.6031", "43136": "39.8013_-82.8125", "43147": "39.9061_-82.7563", "43148": "39.8227_-82.5043", "43150": "39.7674_-82.428", "43154": "39.6067_-82.8193", "43155": "39.6277_-82.5321", "43157": "39.8427_-82.5462", "43106": "39.6286_-83.4095", "43128": "39.659_-83.5687", "43142": "39.5937_-83.5873", "43160": "39.537_-83.455", "43002": "40.072_-83.1792", "43004": "40.021_-82.8079", "43016": "40.0985_-83.1537", "43017": "40.1093_-83.1146", "43026": "40.0322_-83.1383", "43054": "40.0847_-82.7988", "43068": "39.9551_-82.8035", "43069": "39.9555_-82.7992", "43081": "40.1146_-82.9105", "43085": "40.0999_-83.0157", "43086": "39.969_-83.0114", "43109": "39.9181_-82.8321", "43119": "39.9366_-83.1838", "43123": "39.8814_-83.0839", "43125": "39.8581_-82.8872", "43126": "39.8139_-83.1664", "43194": "39.8092_-82.9725", "43195": "39.8614_-82.8916", "43199": "39.969_-83.0114", "43201": "39.9952_-83.0047", "43202": "40.0201_-83.0118", "43203": "39.9719_-82.9691", "43204": "39.9523_-83.078", "43205": "39.9569_-82.9644", "43206": "39.9426_-82.9748", "43207": "39.9046_-82.9703", "43209": "39.9539_-82.9301", "43210": "40.0028_-83.0164", "43211": "40.0118_-82.9732", "43212": "39.9874_-83.0456", "43213": "39.9727_-82.8329", "43214": "40.0535_-83.0187", "43215": "39.9671_-83.0044", "43216": "39.969_-83.0114", "43217": "39.8277_-82.9342", "43218": "39.969_-83.0114", "43219": "40.0326_-82.9103", "43220": "40.0495_-83.0669", "43221": "40.0226_-83.0776", "43222": "39.9576_-83.0311", "43223": "39.9388_-83.0463", "43224": "40.0425_-82.9689", "43226": "39.969_-83.0114", "43227": "39.9444_-82.8903", "43228": "39.9648_-83.126", "43229": "40.0839_-82.9726", "43230": "40.0347_-82.8726", "43231": "40.081_-82.9383", "43232": "39.923_-82.8664", "43234": "39.969_-83.0114", "43235": "40.1088_-82.9742", "43236": "40.1357_-83.0076", "43240": "40.1454_-82.9817", "43251": "39.969_-83.0114", "43260": "39.969_-83.0114", "43266": "39.969_-83.0114", "43268": "39.969_-83.0114", "43270": "39.969_-83.0114", "43271": "39.969_-83.0114", "43272": "39.969_-83.0114", "43279": "39.969_-83.0114", "43287": "39.969_-83.0114", "43291": "39.969_-83.0114", "43502": "41.5333_-84.3048", "43515": "41.5577_-83.9866", "43521": "41.6717_-84.325", "43533": "41.6905_-84.0624", "43540": "41.6952_-83.926", "43553": "41.5306_-84.2297", "43558": "41.5945_-83.8718", "43567": "41.5668_-84.1537", "45614": "38.9276_-82.2701", "45620": "38.9587_-82.1235", "45623": "38.6135_-82.2657", "45631": "38.8148_-82.229", "45643": "38.8683_-82.2562", "45658": "38.777_-82.4275", "45674": "38.8814_-82.3782", "45685": "38.8705_-82.4063", "45686": "38.9783_-82.357", "44021": "41.4527_-81.1526", "44023": "41.3872_-81.3042", "44024": "41.5719_-81.2056", "44026": "41.5344_-81.3421", "44033": "41.5333_-81.1112", "44046": "41.5384_-81.0734", "44062": "41.4455_-81.0373", "44064": "41.6034_-81.057", "44065": "41.475_-81.2345", "44072": "41.4763_-81.3342", "44073": "41.4948_-81.3407", "44080": "41.3706_-81.0651", "44086": "41.6762_-81.0573", "45301": "39.7117_-84.0233", "45305": "39.6402_-84.0824", "45307": "39.5806_-83.7249", "45314": "39.7484_-83.8013", "45316": "39.797_-83.8256", "45324": "39.8053_-84.0198", "45335": "39.6428_-83.7504", "45370": "39.6083_-84.026", "45384": "39.7128_-83.8781", "45385": "39.6842_-83.9369", "45387": "39.7996_-83.8891", "45431": "39.7574_-84.0569", "45433": "39.8138_-84.059", "43722": "39.9159_-81.5201", "43723": "39.9623_-81.5485", "43725": "40.027_-81.582", "43732": "39.852_-81.6576", "43733": "39.9236_-81.543", "43736": "40.065_-81.2558", "43749": "40.1589_-81.549", "43750": "39.9945_-81.5006", "43755": "40.0459_-81.4479", "43768": "40.0392_-81.4522", "43772": "39.9095_-81.558", "43773": "39.9866_-81.2899", "43778": "40.0081_-81.3728", "43780": "39.9337_-81.458", "45001": "39.1374_-84.7096", "45002": "39.1937_-84.734", "45030": "39.2592_-84.7837", "45033": "39.1773_-84.7627", "45041": "39.2159_-84.7041", "45051": "39.0965_-84.6431", "45052": "39.1536_-84.7273", "45111": "39.1962_-84.2897", "45174": "39.1602_-84.3098", "45201": "39.1668_-84.5382", "45202": "39.1072_-84.502", "45203": "39.1075_-84.5257", "45204": "39.0963_-84.5719", "45205": "39.1104_-84.5757", "45206": "39.1269_-84.4853", "45207": "39.1397_-84.4706", "45208": "39.1361_-84.4355", "45209": "39.1516_-84.4278", "45211": "39.1524_-84.5967", "45212": "39.1642_-84.4522", "45213": "39.1802_-84.4204", "45214": "39.1219_-84.5506", "45215": "39.2353_-84.4619", "45216": "39.2003_-84.4859", "45217": "39.1661_-84.4959", "45218": "39.2663_-84.5221", "45219": "39.127_-84.5131", "45220": "39.1432_-84.5217", "45221": "39.1668_-84.5382", "45222": "39.1668_-84.5382", "45223": "39.1696_-84.5478", "45224": "39.1991_-84.5251", "45225": "39.1447_-84.5533", "45226": "39.1174_-84.4312", "45227": "39.1539_-84.3854", "45229": "39.149_-84.4892", "45230": "39.0713_-84.3758", "45231": "39.2418_-84.5437", "45232": "39.1859_-84.5141", "45233": "39.111_-84.6594", "45234": "39.1668_-84.5382", "45235": "39.1668_-84.5382", "45236": "39.21_-84.395", "45237": "39.188_-84.458", "45238": "39.1092_-84.6108", "45239": "39.2045_-84.5799", "45240": "39.2851_-84.5288", "45241": "39.2638_-84.4092", "45242": "39.2447_-84.3455", "45243": "39.1848_-84.3448", "45244": "39.1191_-84.351", "45246": "39.2839_-84.4744", "45247": "39.2208_-84.6418", "45248": "39.1652_-84.6625", "45249": "39.2692_-84.3307", "45250": "39.1668_-84.5382", "45251": "39.2672_-84.5993", "45252": "39.2668_-84.6283", "45253": "39.1668_-84.5382", "45254": "39.1668_-84.5382", "45255": "39.0584_-84.3396", "45258": "39.1668_-84.5382", "45262": "39.1668_-84.5382", "45263": "39.1668_-84.5382", "45264": "39.1668_-84.5382", "45267": "39.1668_-84.5382", "45268": "39.1668_-84.5382", "45269": "39.1668_-84.5382", "45270": "39.1668_-84.5382", "45271": "39.1668_-84.5382", "45273": "39.1668_-84.5382", "45274": "39.1668_-84.5382", "45277": "39.1668_-84.5382", "45280": "39.162_-84.4569", "45296": "39.1668_-84.5382", "45298": "39.1668_-84.5382", "45299": "39.2622_-84.5093", "45999": "39.1668_-84.5382", "44804": "41.1116_-83.5019", "45814": "40.8761_-83.6685", "45816": "41.0031_-83.7931", "45839": "41.0442_-83.6499", "45840": "41.0449_-83.6457", "45841": "40.9004_-83.7256", "45858": "41.1125_-83.8014", "45867": "40.8929_-83.5553", "45868": "40.9437_-83.8093", "45881": "40.9589_-83.7841", "45889": "41.1327_-83.6473", "45890": "40.9583_-83.4971", "45897": "40.834_-83.6518", "43326": "40.6404_-83.6111", "43340": "40.5232_-83.4942", "43345": "40.5209_-83.5702", "43346": "40.5732_-83.8462", "45810": "40.7709_-83.8154", "45812": "40.706_-83.825", "45835": "40.7598_-83.7001", "45836": "40.7824_-83.6339", "45843": "40.7816_-83.5351", "45859": "40.6899_-83.8111", "43907": "40.2632_-81.0307", "43973": "40.1925_-81.277", "43974": "40.1815_-80.8882", "43976": "40.3496_-80.9021", "43981": "40.1839_-80.9959", "43984": "40.4017_-81.0309", "43986": "40.3745_-81.0004", "43988": "40.4012_-81.1016", "44693": "40.2947_-81.1839", "44695": "40.4371_-81.1862", "44699": "40.2797_-81.2919", "43510": "41.4199_-84.0137", "43516": "41.2239_-83.8964", "43523": "41.3411_-84.0005", "43524": "41.2292_-84.0341", "43527": "41.2549_-84.1447", "43532": "41.4514_-83.9859", "43534": "41.3773_-83.9425", "43535": "41.3084_-84.0457", "43545": "41.391_-84.1433", "43548": "41.2037_-84.1683", "43550": "41.3267_-84.1117", "43555": "41.4351_-84.2544", "45123": "39.3478_-83.3898", "45132": "39.3445_-83.5974", "45133": "39.1679_-83.6064", "45135": "39.3458_-83.5481", "45142": "39.2119_-83.8021", "45155": "39.0388_-83.7505", "45172": "39.0738_-83.3853", "43111": "39.5045_-82.2429", "43127": "39.4766_-82.3281", "43135": "39.4757_-82.7212", "43138": "39.5372_-82.4126", "43144": "39.5055_-82.1711", "43149": "39.5509_-82.5626", "43152": "39.4174_-82.5923", "43158": "39.4617_-82.3563", "44610": "40.5612_-81.7943", "44611": "40.6188_-82.072", "44617": "40.5071_-81.7829", "44628": "40.5217_-82.1505", "44633": "40.633_-81.9275", "44637": "40.4933_-81.9837", "44638": "40.652_-82.1455", "44654": "40.5567_-81.8324", "44660": "40.6223_-81.7825", "44661": "40.5956_-82.113", "44687": "40.5415_-81.7218", "44690": "40.6164_-81.6951", "44811": "41.2684_-82.8577", "44826": "41.245_-82.4904", "44837": "41.0407_-82.5133", "44847": "41.2181_-82.7023", "44850": "41.035_-82.677", "44851": "41.0906_-82.3966", "44855": "41.103_-82.5998", "44857": "41.2403_-82.6078", "44888": "41.0531_-82.7263", "44889": "41.2637_-82.3782", "44890": "41.0628_-82.7288", "45621": "39.1108_-82.6077", "45640": "39.0428_-82.6472", "45656": "38.8916_-82.5883", "45692": "39.1189_-82.5485", "43901": "40.2126_-80.8815", "43903": "40.4731_-80.9596", "43908": "40.5195_-80.884", "43910": "40.3742_-80.8072", "43913": "40.2683_-80.6319", "43917": "40.2251_-80.8031", "43925": "40.4506_-80.8604", "43926": "40.5092_-80.6241", "43930": "40.5676_-80.7659", "43932": "40.5111_-80.7915", "43938": "40.3203_-80.625", "43939": "40.1753_-80.7979", "43941": "40.2639_-80.8358", "43943": "40.2083_-80.7125", "43944": "40.4261_-80.7613", "43948": "40.2709_-80.7815", "43952": "40.3698_-80.634", "43953": "40.3524_-80.6781", "43961": "40.5185_-80.6285", "43963": "40.1681_-80.6996", "43964": "40.4733_-80.6325", "43970": "40.4673_-80.8893", "43971": "40.1581_-80.7077", "43005": "40.2845_-82.284", "43006": "40.4583_-82.1553", "43011": "40.2865_-82.68", "43014": "40.4557_-82.2639", "43019": "40.4976_-82.5857", "43022": "40.3782_-82.3828", "43028": "40.4158_-82.3334", "43037": "40.268_-82.3567", "43048": "40.3467_-82.6302", "43050": "40.3849_-82.4873", "44045": "41.7427_-81.2821", "44057": "41.8054_-81.0588", "44060": "41.6895_-81.3421", "44061": "41.6662_-81.3396", "44077": "41.7079_-81.199", "44081": "41.7679_-81.1433", "44092": "41.6046_-81.4692", "44094": "41.6302_-81.4076", "44095": "41.6587_-81.4445", "44096": "41.6398_-81.4065", "44097": "41.6539_-81.4504", "45619": "38.4551_-82.4504", "45638": "38.5294_-82.6654", "45645": "38.5649_-82.5489", "45659": "38.6503_-82.6477", "45669": "38.4635_-82.3523", "45675": "38.5367_-82.5327", "45678": "38.594_-82.3967", "45680": "38.4339_-82.5529", "45688": "38.7182_-82.5174", "45696": "38.594_-82.453", "43001": "40.106_-82.6077", "43008": "39.9337_-82.4724", "43013": "40.2376_-82.6989", "43018": "39.9572_-82.6837", "43023": "40.0788_-82.5194", "43025": "39.9535_-82.4919", "43027": "40.2528_-82.5177", "43030": "39.9595_-82.4129", "43031": "40.1445_-82.6973", "43033": "39.961_-82.5998", "43055": "40.0724_-82.4046", "43056": "40.0197_-82.3875", "43058": "40.0581_-82.4013", "43062": "40.0009_-82.6687", "43071": "40.1818_-82.356", "43073": "39.9965_-82.754", "43080": "40.2441_-82.4135", "43093": "40.0951_-82.4827", "43721": "39.947_-82.2565", "43740": "39.9522_-82.2128", "43310": "40.5024_-83.7688", "43311": "40.3605_-83.7571", "43318": "40.3058_-83.9153", "43319": "40.3077_-83.5862", "43324": "40.4413_-83.7927", "43331": "40.5019_-83.9202", "43333": "40.4277_-83.9209", "43336": "40.2926_-83.5824", "43343": "40.2876_-83.9744", "43347": "40.4658_-83.6598", "43348": "40.4675_-83.887", "43357": "40.2625_-83.7528", "43358": "40.4043_-83.5243", "43360": "40.3211_-83.6405", "44001": "41.3617_-82.2538", "44011": "41.4467_-82.0204", "44012": "41.5019_-82.0111", "44028": "41.3187_-81.9344", "44035": "41.3724_-82.1051", "44036": "41.4015_-82.0771", "44039": "41.3964_-82.0033", "44044": "41.2854_-82.0431", "44049": "41.2664_-82.3064", "44050": "41.2423_-82.1279", "44052": "41.4578_-82.171", "44053": "41.432_-82.2038", "44054": "41.4823_-82.0965", "44055": "41.4361_-82.135", "44074": "41.2899_-82.2229", "44090": "41.1712_-82.2269", "43434": "41.6934_-83.4444", "43504": "41.6989_-83.831", "43528": "41.6226_-83.7257", "43537": "41.5817_-83.6628", "43542": "41.5684_-83.7757", "43547": "41.492_-83.8706", "43560": "41.708_-83.7068", "43566": "41.5022_-83.7331", "43571": "41.5194_-83.8115", "43601": "41.7207_-83.5694", "43603": "41.6868_-83.4394", "43604": "41.6614_-83.5249", "43605": "41.6525_-83.5085", "43606": "41.6712_-83.606", "43607": "41.6504_-83.5974", "43608": "41.6779_-83.5344", "43609": "41.6298_-83.5773", "43610": "41.6767_-83.5573", "43611": "41.7045_-83.4892", "43612": "41.7046_-83.5656", "43613": "41.7039_-83.6034", "43614": "41.6028_-83.6292", "43615": "41.6492_-83.6706", "43616": "41.6418_-83.4714", "43617": "41.6668_-83.717", "43620": "41.6654_-83.5536", "43623": "41.708_-83.6434", "43635": "41.6868_-83.4394", "43652": "41.6868_-83.4394", "43654": "41.6868_-83.4394", "43656": "41.6782_-83.4972", "43657": "41.6868_-83.4394", "43659": "41.6868_-83.4394", "43660": "41.6546_-83.5329", "43661": "41.6782_-83.4972", "43666": "41.6782_-83.4972", "43667": "41.6868_-83.4394", "43681": "41.6868_-83.4394", "43682": "41.6868_-83.4394", "43697": "41.6868_-83.4394", "43699": "41.6538_-83.6589", "43064": "40.0974_-83.269", "43140": "39.9001_-83.4439", "43143": "39.7175_-83.2806", "43151": "39.733_-83.4764", "43153": "39.7423_-83.597", "43162": "39.9424_-83.2853", "44401": "41.0243_-80.9341", "44405": "41.0778_-80.5897", "44406": "41.0293_-80.7564", "44416": "41.0242_-80.8573", "44422": "40.9439_-80.7915", "44429": "41.1014_-80.9724", "44436": "41.0503_-80.5416", "44442": "40.9646_-80.5534", "44443": "40.9265_-80.5856", "44449": "40.9876_-81.0162", "44451": "41.088_-80.8623", "44452": "40.9649_-80.6549", "44454": "40.9049_-80.54", "44471": "41.0508_-80.5985", "44501": "41.0171_-80.8029", "44502": "41.0774_-80.6409", "44503": "41.102_-80.65", "44504": "41.1237_-80.6539", "44505": "41.1257_-80.6277", "44506": "41.096_-80.6259", "44507": "41.0732_-80.6553", "44509": "41.105_-80.6945", "44510": "41.1197_-80.6672", "44511": "41.0704_-80.6931", "44512": "41.0252_-80.6687", "44513": "41.0171_-80.8029", "44514": "41.0093_-80.6183", "44515": "41.0979_-80.7598", "44555": "41.1039_-80.6436", "44609": "40.8957_-80.9897", "44619": "40.9021_-80.9628", "44672": "40.9227_-81.0232", "43301": "40.6166_-83.0693", "43302": "40.5876_-83.1271", "43314": "40.6272_-82.9925", "43322": "40.5322_-83.2078", "43332": "40.5789_-83.3734", "43335": "40.6685_-82.91", "43337": "40.6954_-83.2046", "43341": "40.6073_-83.3224", "43342": "40.4727_-83.1763", "43356": "40.4605_-83.0706", "44149": "41.3134_-81.8562", "44212": "41.2471_-81.828", "44215": "41.0653_-81.9017", "44233": "41.2419_-81.7453", "44235": "41.0267_-82.125", "44251": "41.0288_-81.9283", "44253": "41.1668_-82.0157", "44254": "41.0327_-82.0147", "44256": "41.1404_-81.8584", "44258": "41.1276_-81.8411", "44273": "41.0227_-81.8562", "44274": "41.0992_-81.7343", "44275": "41.0983_-82.0999", "44280": "41.2368_-81.9245", "44281": "41.0384_-81.7374", "44282": "41.0256_-81.7299", "45720": "39.0856_-81.9214", "45741": "39.0697_-82.2499", "45743": "39.0802_-81.8887", "45760": "38.9993_-82.06", "45769": "39.0607_-82.0331", "45770": "38.9999_-81.8135", "45771": "38.9786_-81.9258", "45772": "39.149_-81.7924", "45775": "39.0909_-82.1486", "45779": "38.9976_-81.974", "45783": "39.1683_-81.8423", "45310": "40.3541_-84.6435", "45822": "40.5566_-84.6287", "45826": "40.437_-84.4933", "45828": "40.4846_-84.6517", "45846": "40.4018_-84.7613", "45860": "40.4062_-84.5076", "45862": "40.6777_-84.5152", "45866": "40.489_-84.5494", "45882": "40.6771_-84.6642", "45883": "40.4091_-84.6333", "45308": "40.1286_-84.4293", "45312": "40.0716_-84.1088", "45317": "40.1457_-84.0283", "45318": "40.1176_-84.3496", "45326": "40.1445_-84.101", "45337": "39.9785_-84.3994", "45339": "39.9871_-84.3334", "45356": "40.1486_-84.2531", "45359": "40.0531_-84.3436", "45361": "39.9635_-84.4145", "45371": "39.942_-84.1663", "45373": "40.0374_-84.2032", "45374": "40.04_-84.2298", "45383": "39.9531_-84.3242", "43716": "39.8484_-81.0368", "43747": "39.8488_-81.0921", "43752": "39.7171_-81.01", "43754": "39.7684_-81.2316", "43757": "39.8594_-81.1516", "43786": "39.7112_-81.2758", "43793": "39.7515_-81.0759", "43914": "39.7687_-80.9454", "43915": "39.7819_-80.9113", "43931": "39.6673_-80.872", "43946": "39.6526_-80.9243", "45734": "39.663_-81.1822", "45309": "39.8414_-84.4165", "45315": "39.8551_-84.3399", "45322": "39.877_-84.3319", "45325": "39.6867_-84.4205", "45327": "39.6244_-84.3764", "45342": "39.6321_-84.2675", "45343": "39.7505_-84.2686", "45345": "39.7398_-84.3956", "45354": "39.9054_-84.4028", "45377": "39.8883_-84.2023", "45401": "39.7505_-84.2686", "45402": "39.7563_-84.1895", "45403": "39.7617_-84.1498", "45404": "39.7862_-84.1622", "45405": "39.7899_-84.2135", "45406": "39.7821_-84.2373", "45409": "39.7238_-84.1854", "45410": "39.7474_-84.16", "45412": "39.7589_-84.1916", "45413": "39.7505_-84.2686", "45414": "39.8285_-84.2024", "45415": "39.8355_-84.2613", "45416": "39.8011_-84.2578", "45417": "39.7528_-84.247", "45419": "39.7155_-84.1637", "45420": "39.7171_-84.1342", "45422": "39.7581_-84.2001", "45423": "39.7589_-84.1916", "45424": "39.8353_-84.1123", "45426": "39.7982_-84.3211", "45428": "39.7467_-84.2593", "45429": "39.6841_-84.1633", "45430": "39.7092_-84.1048", "45432": "39.739_-84.0856", "45434": "39.7216_-84.029", "45435": "39.7505_-84.2686", "45437": "39.7505_-84.2686", "45439": "39.701_-84.2187", "45440": "39.6749_-84.1136", "45441": "39.7505_-84.2686", "45448": "39.7505_-84.2686", "45449": "39.6651_-84.2401", "45458": "39.6062_-84.1695", "45459": "39.6464_-84.1717", "45469": "39.7405_-84.1789", "45470": "39.7505_-84.2686", "45475": "39.7505_-84.2686", "45479": "39.7344_-84.1944", "45481": "39.7505_-84.2686", "45482": "39.7505_-84.2686", "45490": "39.7505_-84.2686", "43728": "39.4953_-81.8773", "43756": "39.6487_-81.8532", "43758": "39.6482_-81.9127", "43787": "39.549_-81.8262", "43315": "40.5066_-82.9337", "43317": "40.4789_-82.6828", "43320": "40.5905_-82.9023", "43321": "40.4626_-82.8288", "43325": "40.6703_-82.8435", "43334": "40.3895_-82.8121", "43338": "40.5384_-82.8062", "43349": "40.6142_-82.6619", "43350": "40.5289_-82.8229", "43701": "39.9274_-82.0041", "43702": "39.9403_-82.0132", "43720": "39.8_-81.891", "43727": "39.8897_-81.8301", "43734": "39.8778_-81.9117", "43735": "39.8501_-82.1221", "43738": "39.8555_-82.1378", "43746": "39.9601_-82.1756", "43762": "40.0088_-81.7387", "43767": "39.9934_-81.8024", "43771": "39.8458_-81.9175", "43777": "39.8187_-82.0792", "43791": "39.8713_-82.0987", "43802": "40.0793_-81.8718", "43821": "40.1069_-81.9998", "43822": "40.1316_-82.1293", "43830": "40.0386_-82.0998", "43842": "40.1412_-82.0099", "43711": "39.8317_-81.5748", "43717": "39.7906_-81.5562", "43724": "39.7467_-81.5153", "43779": "39.8162_-81.4243", "43788": "39.8036_-81.332", "45727": "39.6526_-81.4672", "43408": "41.5686_-83.3632", "43412": "41.6477_-83.2858", "43416": "41.4681_-83.2767", "43430": "41.53_-83.359", "43432": "41.5647_-83.2613", "43433": "41.5038_-82.8708", "43436": "41.7153_-82.8227", "43439": "41.5181_-83.0413", "43440": "41.5247_-82.7766", "43445": "41.5694_-83.3116", "43446": "41.6835_-82.8047", "43449": "41.5236_-83.1278", "43452": "41.512_-82.9377", "43456": "41.6514_-82.8226", "43458": "41.5302_-83.2128", "43468": "41.6037_-83.3399", "45813": "41.1887_-84.7448", "45821": "41.2174_-84.6296", "45849": "41.0245_-84.4956", "45851": "41.0329_-84.6139", "45855": "41.0879_-84.5841", "45861": "41.0812_-84.4287", "45873": "41.0908_-84.3969", "45879": "41.141_-84.5722", "45880": "41.0807_-84.7341", "43076": "39.8974_-82.4071", "43730": "39.6361_-82.1102", "43731": "39.7623_-82.084", "43739": "39.8699_-82.3026", "43748": "39.6965_-82.3155", "43760": "39.8788_-82.188", "43761": "39.6626_-82.1363", "43764": "39.7174_-82.2019", "43766": "39.5869_-82.2488", "43782": "39.611_-82.2085", "43783": "39.7936_-82.2991", "43103": "39.7316_-82.9446", "43113": "39.5988_-82.93", "43116": "39.7699_-83.0602", "43117": "39.7687_-83.2057", "43137": "39.8142_-82.9764", "43145": "39.5589_-83.2504", "43146": "39.7954_-83.1543", "43156": "39.5535_-82.7763", "43164": "39.6117_-83.1251", "45613": "39.0332_-82.8514", "45624": "39.1737_-83.3485", "45642": "39.0523_-83.05", "45646": "39.0804_-83.3283", "45661": "39.0437_-83.121", "45683": "38.9555_-82.8584", "45687": "38.9703_-83.0199", "45690": "39.1264_-83.0049", "44201": "41.0335_-81.1985", "44202": "41.3176_-81.3454", "44211": "41.1698_-81.3124", "44231": "41.2988_-81.0704", "44234": "41.3323_-81.1464", "44240": "41.1449_-81.3498", "44241": "41.2491_-81.3383", "44242": "41.1537_-81.3579", "44243": "41.1475_-81.3415", "44255": "41.2941_-81.2283", "44265": "41.0328_-81.2484", "44266": "41.1649_-81.2337", "44272": "41.0995_-81.2026", "44285": "41.1597_-81.07", "44288": "41.2392_-81.0535", "44411": "41.0359_-81.0528", "44412": "41.0935_-81.0425", "45070": "39.5897_-84.5581", "45311": "39.6134_-84.61", "45320": "39.7426_-84.6508", "45321": "39.8882_-84.6786", "45330": "39.6483_-84.5282", "45338": "39.8534_-84.5369", "45347": "39.8617_-84.7793", "45378": "39.9029_-84.4887", "45381": "39.7259_-84.5352", "45382": "39.9026_-84.6194", "45815": "41.1539_-83.9413", "45827": "41.0379_-84.2938", "45830": "40.9137_-84.0705", "45831": "41.1148_-84.2358", "45837": "41.0463_-84.3195", "45844": "40.9484_-84.2374", "45848": "41.0289_-84.0791", "45853": "40.9828_-84.1994", "45856": "41.1092_-83.9957", "45864": "41.1038_-84.1315", "45875": "41.0192_-84.0472", "45876": "40.9323_-84.3388", "45877": "40.9509_-83.9521", "45893": "40.8821_-84.148", "44813": "40.6136_-82.5175", "44822": "40.5438_-82.399", "44843": "40.7039_-82.4087", "44862": "40.7729_-82.5321", "44865": "41.0003_-82.6635", "44875": "40.8784_-82.6549", "44878": "40.934_-82.5222", "44901": "40.8508_-82.5114", "44902": "40.7559_-82.5123", "44903": "40.7623_-82.5254", "44904": "40.6824_-82.5286", "44905": "40.7779_-82.4613", "44906": "40.7627_-82.5593", "44907": "40.7345_-82.5198", "43101": "39.4667_-82.7471", "43115": "39.4904_-83.1563", "45601": "39.338_-82.9895", "45612": "39.2131_-83.2763", "45617": "39.2804_-83.159", "45628": "39.391_-83.2034", "45633": "39.4656_-82.7479", "45644": "39.4414_-82.8488", "45647": "39.2723_-82.7833", "45673": "39.2039_-82.812", "45681": "39.3021_-83.272", "43407": "41.268_-83.2475", "43410": "41.3024_-82.9918", "43420": "41.3498_-83.1181", "43431": "41.3805_-83.3358", "43435": "41.326_-83.3186", "43442": "41.4147_-83.2135", "43464": "41.391_-82.899", "43469": "41.4512_-83.3646", "45629": "38.6282_-82.8145", "45630": "38.6991_-83.0916", "45636": "38.5848_-82.8321", "45648": "38.8938_-82.994", "45652": "38.8362_-83.0689", "45653": "38.8751_-82.8555", "45657": "38.852_-83.2222", "45662": "38.7932_-82.9306", "45663": "38.7495_-83.1335", "45671": "38.9577_-83.2365", "45677": "38.7941_-82.7555", "45682": "38.82_-82.7202", "45684": "38.6546_-83.209", "45694": "38.7418_-82.8204", "45699": "38.8795_-82.9968", "44802": "41.0463_-83.377", "44807": "41.0773_-82.9032", "44809": "41.1328_-83.2854", "44815": "41.2469_-83.2398", "44818": "41.0182_-82.9899", "44828": "41.2371_-82.8597", "44830": "41.1623_-83.4139", "44836": "41.2281_-83.0885", "44841": "41.2512_-83.306", "44845": "41.0242_-83.1098", "44853": "41.0514_-83.3185", "44861": "41.2395_-83.1479", "44867": "41.1259_-83.0194", "44883": "41.1238_-83.1844", "45302": "40.4051_-84.2103", "45306": "40.4659_-84.178", "45333": "40.2535_-84.3521", "45334": "40.4358_-84.0457", "45336": "40.4413_-84.2626", "45340": "40.3643_-84.0565", "45353": "40.2952_-84.0323", "45360": "40.3307_-84.0926", "45363": "40.2341_-84.4123", "45365": "40.2874_-84.1622", "45367": "40.2842_-84.1555", "45845": "40.3306_-84.3741", "44601": "40.9158_-81.1182", "44608": "40.6562_-81.5851", "44613": "40.7142_-81.5957", "44614": "40.8887_-81.5773", "44626": "40.6971_-81.3687", "44630": "40.9295_-81.4001", "44632": "40.9618_-81.3239", "44640": "40.9836_-81.1497", "44641": "40.8477_-81.2595", "44643": "40.6514_-81.3076", "44646": "40.8116_-81.4973", "44647": "40.7959_-81.5533", "44648": "40.8118_-81.3683", "44650": "40.8746_-81.1739", "44652": "40.8951_-81.3262", "44657": "40.742_-81.1031", "44662": "40.7204_-81.5338", "44666": "40.8387_-81.6299", "44669": "40.8014_-81.154", "44670": "40.7647_-81.1879", "44688": "40.6829_-81.2659", "44689": "40.6567_-81.6352", "44701": "40.7824_-81.3712", "44702": "40.8027_-81.3739", "44703": "40.8098_-81.3814", "44704": "40.7991_-81.3537", "44705": "40.8259_-81.3399", "44706": "40.768_-81.4119", "44707": "40.7598_-81.35", "44708": "40.812_-81.4241", "44709": "40.8423_-81.3862", "44710": "40.7911_-81.4169", "44711": "40.8118_-81.3683", "44714": "40.8272_-81.361", "44718": "40.8465_-81.4408", "44720": "40.7989_-81.3784", "44721": "40.8834_-81.3328", "44730": "40.7873_-81.2826", "44735": "40.8118_-81.3683", "44750": "40.7846_-81.4189", "44767": "40.8957_-81.4246", "44799": "40.8118_-81.3683", "44056": "41.3222_-81.4996", "44067": "41.3208_-81.5429", "44087": "41.3289_-81.4559", "44203": "41.0197_-81.6212", "44210": "41.1889_-81.6362", "44216": "40.9391_-81.5871", "44221": "41.1401_-81.479", "44222": "41.1339_-81.4846", "44223": "41.1464_-81.5107", "44224": "41.1748_-81.438", "44232": "40.9325_-81.462", "44236": "41.2458_-81.4367", "44237": "41.1287_-81.54", "44250": "41.0222_-81.4279", "44260": "41.0382_-81.359", "44262": "41.142_-81.4376", "44264": "41.2256_-81.54", "44278": "41.0975_-81.426", "44286": "41.2371_-81.6467", "44301": "41.0449_-81.52", "44302": "41.092_-81.542", "44303": "41.1025_-81.5386", "44304": "41.0814_-81.519", "44305": "41.076_-81.4644", "44306": "41.0479_-81.4916", "44307": "41.0695_-81.5488", "44308": "41.0796_-81.5194", "44309": "41.0962_-81.5123", "44310": "41.1075_-81.5006", "44311": "41.0638_-81.52", "44312": "41.0334_-81.4385", "44313": "41.122_-81.5685", "44314": "41.0408_-81.5598", "44315": "41.028_-81.4632", "44316": "41.0675_-81.4847", "44317": "41.0525_-81.5291", "44319": "40.9791_-81.5347", "44320": "41.0835_-81.5674", "44321": "41.1002_-81.6443", "44325": "41.0764_-81.5103", "44326": "41.0814_-81.519", "44328": "41.076_-81.5206", "44333": "41.1552_-81.6314", "44334": "41.1278_-81.6098", "44372": "41.1287_-81.54", "44396": "41.1287_-81.54", "44398": "41.1287_-81.54", "44685": "40.9637_-81.4211", "44402": "41.3797_-80.8568", "44403": "41.248_-80.5788", "44404": "41.3347_-80.5441", "44410": "41.3251_-80.7327", "44417": "41.3923_-80.6628", "44418": "41.3349_-80.6059", "44420": "41.1611_-80.6933", "44424": "41.3091_-80.5847", "44425": "41.1624_-80.5762", "44428": "41.4354_-80.5765", "44430": "41.2445_-80.8869", "44437": "41.158_-80.7312", "44438": "41.2255_-80.5326", "44439": "41.4584_-80.9551", "44440": "41.1318_-80.7553", "44444": "41.191_-80.9701", "44446": "41.1824_-80.7558", "44450": "41.4569_-80.8068", "44453": "41.3252_-80.5336", "44470": "41.2983_-80.9485", "44473": "41.2175_-80.655", "44481": "41.1724_-80.8718", "44482": "41.3174_-80.7613", "44483": "41.2639_-80.8164", "44484": "41.2318_-80.7642", "44485": "41.2405_-80.8441", "44486": "41.3174_-80.7613", "44491": "41.3508_-80.9672", "43804": "40.4476_-81.6792", "43832": "40.2739_-81.594", "43837": "40.3404_-81.5215", "43840": "40.4052_-81.589", "44612": "40.6347_-81.4464", "44621": "40.4089_-81.3203", "44622": "40.5343_-81.4763", "44624": "40.589_-81.6058", "44629": "40.3584_-81.4343", "44653": "40.438_-81.3729", "44656": "40.5705_-81.3436", "44663": "40.4845_-81.4358", "44671": "40.6442_-81.3653", "44678": "40.5649_-81.3524", "44679": "40.3234_-81.3084", "44680": "40.6003_-81.5366", "44681": "40.5148_-81.6604", "44682": "40.3959_-81.4069", "44683": "40.3905_-81.3374", "44697": "40.6142_-81.4223", "43007": "40.3406_-83.4163", "43029": "40.1284_-83.4587", "43036": "40.3528_-83.2634", "43040": "40.2477_-83.3622", "43041": "40.2364_-83.3671", "43045": "40.1817_-83.4373", "43067": "40.338_-83.4655", "43077": "40.1367_-83.3408", "43344": "40.437_-83.3136", "45832": "40.927_-84.7238", "45838": "40.7425_-84.4758", "45863": "40.8993_-84.4541", "45874": "40.7854_-84.6731", "45886": "40.9892_-84.5845", "45891": "40.8689_-84.5904", "45894": "40.7685_-84.462", "45898": "40.7346_-84.7777", "45899": "40.8009_-84.7752", "45622": "39.3543_-82.503", "45634": "39.1685_-82.51", "45651": "39.28_-82.4753", "45654": "39.3884_-82.3892", "45672": "39.2077_-82.6908", "45695": "39.1416_-82.3682", "45698": "39.283_-82.3977", "45005": "39.5357_-84.303", "45032": "39.5013_-84.0067", "45034": "39.358_-84.2473", "45036": "39.4293_-84.1735", "45039": "39.317_-84.2438", "45040": "39.3357_-84.3149", "45054": "39.4145_-84.0511", "45065": "39.3715_-84.2108", "45066": "39.563_-84.2288", "45068": "39.5285_-84.0815", "45152": "39.3476_-84.1181", "45162": "39.2884_-84.0967", "45712": "39.3987_-81.6649", "45713": "39.4195_-81.8157", "45714": "39.2868_-81.5968", "45715": "39.5714_-81.6346", "45721": "39.5676_-81.5812", "45724": "39.4042_-81.7657", "45729": "39.4136_-81.6078", "45742": "39.28_-81.7071", "45744": "39.5385_-81.5197", "45745": "39.5611_-81.3968", "45746": "39.6204_-81.4471", "45750": "39.4281_-81.4644", "45767": "39.5288_-81.094", "45768": "39.3971_-81.2402", "45773": "39.4585_-81.2673", "45784": "39.3374_-81.6743", "45786": "39.5159_-81.6559", "45787": "39.4659_-81.6332", "45788": "39.5136_-81.3668", "45789": "39.5428_-81.284", "44214": "40.9637_-81.9958", "44217": "40.9788_-81.9211", "44230": "40.965_-81.6848", "44270": "40.9684_-81.7826", "44276": "40.9369_-81.8305", "44287": "40.9485_-82.1066", "44606": "40.7551_-81.8093", "44618": "40.7793_-81.7008", "44627": "40.686_-81.8518", "44636": "40.7384_-81.7428", "44645": "40.9067_-81.7225", "44659": "40.6949_-81.7026", "44667": "40.8458_-81.7741", "44676": "40.6926_-82.0325", "44677": "40.8592_-81.8633", "44691": "40.8094_-81.9483", "43501": "41.6625_-84.4355", "43505": "41.5239_-84.7303", "43506": "41.4748_-84.5629", "43517": "41.4425_-84.7349", "43518": "41.5842_-84.757", "43531": "41.6367_-84.4952", "43543": "41.5982_-84.6147", "43554": "41.6656_-84.5363", "43557": "41.4861_-84.4089", "43570": "41.5756_-84.4421", "43402": "41.3815_-83.6507", "43403": "41.377_-83.6371", "43406": "41.3298_-83.4456", "43413": "41.2401_-83.6433", "43414": "41.4581_-83.6102", "43437": "41.2559_-83.6022", "43441": "41.4959_-83.4741", "43443": "41.4517_-83.4674", "43447": "41.5611_-83.4381", "43450": "41.4023_-83.4736", "43451": "41.3127_-83.6143", "43457": "41.2706_-83.4326", "43460": "41.6049_-83.5638", "43462": "41.2967_-83.6832", "43463": "41.5091_-83.5085", "43465": "41.5861_-83.493", "43466": "41.2993_-83.4701", "43467": "41.2426_-83.4896", "43511": "41.2953_-83.8349", "43522": "41.4379_-83.8552", "43525": "41.4667_-83.7055", "43529": "41.1872_-83.7847", "43541": "41.3009_-83.8296", "43551": "41.5429_-83.5927", "43552": "41.557_-83.6272", "43565": "41.4192_-83.7408", "43569": "41.3516_-83.7973", "43619": "41.608_-83.4806", "44817": "41.1815_-83.5724", "45872": "41.1867_-83.6806", "43316": "40.9486_-83.3836", "43323": "40.7475_-83.2343", "43330": "40.813_-83.4196", "43351": "40.8249_-83.2977", "43359": "40.8612_-83.463", "44844": "40.9752_-83.2637", "44849": "40.8259_-83.1266", "44882": "40.9413_-83.1492", "74457": "36.0308_-94.7613", "74931": "35.6826_-94.7611", "74960": "35.8107_-94.6313", "74964": "36.1152_-94.6345", "74965": "35.9912_-94.5926", "73716": "36.5056_-98.4574", "73719": "36.9412_-98.2458", "73722": "36.9036_-98.4215", "73726": "36.5842_-98.4578", "73728": "36.7564_-98.3594", "73739": "36.5314_-98.154", "73741": "36.5438_-98.2778", "73749": "36.6929_-98.1721", "74525": "34.3445_-96.1418", "74533": "34.2221_-96.2584", "74540": "34.5384_-95.7088", "74555": "34.2691_-95.9685", "74569": "34.4676_-96.0002", "73844": "36.8757_-100.0734", "73931": "36.5996_-100.7103", "73932": "36.8341_-100.5177", "73938": "36.9086_-100.5409", "73950": "36.8664_-100.8779", "73627": "35.2208_-99.4822", "73644": "35.4104_-99.4211", "73645": "35.2286_-99.8635", "73648": "35.412_-99.4043", "73662": "35.3047_-99.6429", "73668": "35.2161_-99.9915", "73040": "35.6217_-98.3905", "73043": "35.7333_-98.3841", "73724": "36.0372_-98.5778", "73744": "35.9712_-98.3315", "73755": "36.1212_-98.55", "73763": "36.1165_-98.3254", "73770": "36.0581_-98.5884", "73772": "35.8538_-98.4175", "73449": "33.9944_-96.5299", "74701": "34.0061_-96.3847", "74702": "33.922_-96.1918", "74720": "33.8396_-96.3648", "74721": "33.8815_-96.1628", "74723": "33.9771_-96.0188", "74726": "33.9859_-96.1621", "74729": "34.1157_-96.26", "74730": "33.9322_-96.4308", "74731": "33.8668_-96.5672", "74733": "33.8575_-96.4953", "74741": "33.8016_-96.3581", "74747": "33.773_-96.3555", "74748": "34.1481_-96.3622", "74753": "33.907_-96.535", "73001": "35.2032_-98.3574", "73005": "35.0728_-98.2429", "73006": "34.9034_-98.3695", "73009": "35.3106_-98.3148", "73015": "35.1235_-98.5755", "73017": "34.9321_-98.1466", "73029": "34.8959_-98.2083", "73033": "35.3053_-98.5578", "73038": "35.1161_-98.4303", "73042": "35.1875_-98.2835", "73047": "35.4675_-98.3313", "73048": "35.452_-98.5604", "73053": "35.3679_-98.3898", "73014": "35.5476_-98.1512", "73022": "35.6193_-97.9796", "73036": "35.5335_-97.9591", "73064": "35.3885_-97.7309", "73078": "35.6695_-97.7431", "73085": "35.4895_-97.75", "73090": "35.3913_-97.9398", "73099": "35.4977_-97.7323", "73401": "34.1566_-97.1792", "73402": "34.2889_-97.2481", "73403": "34.1743_-97.1436", "73435": "34.3488_-97.4924", "73436": "34.2939_-97.0339", "73437": "34.3762_-97.4255", "73438": "34.229_-97.4889", "73443": "34.1774_-97.2685", "73458": "34.3038_-97.1223", "73463": "34.1364_-97.4273", "73481": "34.449_-97.5095", "73487": "34.4777_-97.457", "73488": "34.4852_-97.5423", "74427": "35.7116_-94.9132", "74441": "35.9254_-95.1651", "74444": "36.0458_-94.9669", "74451": "35.7977_-94.9822", "74452": "36.1154_-95.1199", "74464": "35.9094_-94.9787", "74465": "35.9001_-95.04", "74471": "35.8819_-94.8653", "74727": "34.0245_-95.8403", "74735": "34.052_-95.253", "74738": "33.9302_-95.4893", "74743": "34.0113_-95.5139", "74756": "34.0277_-95.3558", "74759": "34.0366_-95.6916", "74760": "34.1508_-95.3771", "74761": "34.0179_-95.2022", "73933": "36.7283_-102.5355", "73937": "36.5666_-102.7974", "73946": "36.9031_-102.9653", "73947": "36.8003_-102.2361", "73019": "35.2086_-97.4445", "73026": "35.2343_-97.2914", "73051": "35.0377_-97.2609", "73068": "35.1417_-97.3409", "73069": "35.2204_-97.4577", "73070": "35.1876_-97.3975", "73071": "35.233_-97.4067", "73072": "35.199_-97.4841", "73139": "35.3792_-97.5362", "73160": "35.334_-97.4768", "73165": "35.3267_-97.3534", "73170": "35.327_-97.5556", "73173": "35.3425_-97.6317", "74534": "34.6066_-96.3386", "74535": "34.4829_-96.4333", "74538": "34.5344_-96.2167", "74556": "34.4756_-96.1889", "74572": "34.5598_-96.4274", "73501": "34.5915_-98.3698", "73502": "34.6087_-98.3903", "73503": "34.6595_-98.4004", "73505": "34.6179_-98.4552", "73506": "34.6309_-98.4576", "73507": "34.6246_-98.3895", "73527": "34.6131_-98.6154", "73528": "34.4262_-98.6514", "73538": "34.772_-98.4073", "73540": "34.4645_-98.5577", "73541": "34.7847_-98.2002", "73543": "34.4805_-98.3875", "73552": "34.6242_-98.7349", "73557": "34.7292_-98.5026", "73558": "34.7828_-98.579", "73567": "34.7496_-98.1679", "73531": "34.1956_-98.577", "73562": "34.174_-98.46", "73568": "34.2607_-98.2371", "73572": "34.3605_-98.314", "74301": "36.6334_-95.1382", "74332": "36.534_-95.2246", "74333": "36.7975_-95.1018", "74369": "36.902_-95.1295", "74010": "35.8209_-96.3758", "74028": "35.7561_-96.4897", "74030": "35.9931_-96.5198", "74039": "35.9171_-96.218", "74041": "35.9528_-96.061", "74044": "36.0927_-96.3576", "74046": "35.7551_-96.5658", "74047": "35.8896_-96.0887", "74052": "36.0685_-96.5958", "74066": "36.003_-96.1106", "74067": "36.0196_-96.0937", "74068": "35.9124_-96.578", "74071": "35.7861_-96.2806", "74131": "36.0557_-96.0602", "73096": "35.535_-98.6996", "73601": "35.5115_-98.9795", "73620": "35.5789_-98.9595", "73625": "35.6336_-99.2427", "73639": "35.6894_-98.912", "73669": "35.7382_-98.7388", "74338": "36.2333_-94.6547", "74342": "36.4063_-94.9157", "74344": "36.5929_-94.7565", "74345": "36.6036_-94.7297", "74346": "36.4363_-94.7763", "74347": "36.2161_-94.8114", "74359": "36.1662_-94.8547", "74368": "36.2054_-94.8513", "73646": "35.8204_-98.6587", "73654": "35.8698_-99.3491", "73658": "35.9328_-98.7065", "73659": "35.8539_-98.9638", "73663": "36.1278_-98.8875", "73667": "35.9972_-98.9825", "73835": "36.0212_-99.2781", "73859": "36.1372_-99.267", "73832": "36.0522_-99.6514", "73840": "36.3761_-99.6237", "73843": "36.318_-99.76", "73858": "36.2889_-99.8793", "73701": "36.4028_-97.8623", "73702": "36.3956_-97.8784", "73703": "36.3975_-97.9157", "73705": "36.3382_-97.9026", "73706": "36.3791_-97.7826", "73720": "36.1962_-97.8805", "73727": "36.4922_-98.0422", "73730": "36.3099_-97.5752", "73733": "36.2481_-97.6896", "73735": "36.2841_-98.0358", "73736": "36.34_-97.6848", "73738": "36.4392_-97.5789", "73743": "36.5631_-97.9915", "73753": "36.5207_-97.8542", "73754": "36.385_-98.0727", "73773": "36.2781_-97.8996", "74640": "36.5603_-97.6425", "73052": "34.8211_-97.5998", "73057": "34.8113_-97.4131", "73074": "34.8285_-97.2608", "73075": "34.7385_-97.2195", "73098": "34.6385_-97.177", "73433": "34.6265_-97.4142", "73444": "34.4719_-97.3879", "74872": "34.7714_-96.9763", "73002": "34.9612_-97.7571", "73004": "35.1526_-97.8532", "73011": "34.8741_-97.7118", "73018": "35.0268_-97.9518", "73023": "35.0526_-97.9364", "73059": "35.3067_-97.9664", "73067": "34.9143_-97.9333", "73079": "35.1544_-97.979", "73082": "34.7708_-97.9431", "73089": "35.2674_-97.7446", "73092": "35.0836_-98.0792", "73758": "36.9744_-98.0383", "73759": "36.8142_-97.7202", "73761": "36.6961_-98.0258", "73766": "36.6643_-97.8019", "73771": "36.8753_-97.9427", "74636": "36.8048_-97.5136", "74643": "36.6939_-97.5601", "73547": "34.9712_-99.3881", "73554": "34.9126_-99.4606", "73673": "35.0702_-99.5421", "73544": "34.665_-99.7843", "73550": "34.6953_-99.9177", "73571": "34.9006_-99.8598", "73834": "36.8523_-99.5538", "73848": "36.7062_-99.8918", "73851": "36.6226_-99.7858", "73855": "36.8789_-99.9003", "74440": "35.2685_-95.2994", "74462": "35.2686_-95.1071", "74472": "35.2646_-95.2645", "74552": "35.1193_-95.2377", "74941": "35.2645_-94.9028", "74943": "35.0867_-95.0974", "74944": "35.1404_-95.0127", "74531": "34.878_-96.271", "74570": "34.8826_-96.1381", "74827": "34.9562_-96.3386", "74839": "35.2519_-96.0573", "74848": "35.0839_-96.377", "74850": "35.0836_-96.1142", "74883": "35.2396_-96.2421", "73521": "34.6484_-99.3205", "73522": "34.6381_-99.334", "73523": "34.5982_-99.4408", "73526": "34.7788_-99.3334", "73532": "34.6668_-99.5482", "73537": "34.4727_-99.646", "73539": "34.5137_-99.3167", "73549": "34.6265_-99.139", "73556": "34.7253_-99.387", "73560": "34.5496_-99.4287", "73456": "34.1679_-97.6029", "73520": "34.2445_-97.967", "73548": "34.2251_-98.1075", "73561": "34.0313_-97.6481", "73565": "34.0238_-97.9461", "73569": "33.9379_-97.8053", "73573": "34.1745_-97.9973", "73432": "34.2625_-96.4588", "73447": "34.1899_-96.8778", "73450": "34.1952_-96.5429", "73455": "34.244_-96.7529", "73460": "34.2643_-96.6675", "73461": "34.3866_-96.4532", "74530": "34.4233_-96.4867", "74836": "34.4194_-96.6291", "74856": "34.3098_-96.7884", "74601": "36.7031_-97.0784", "74602": "36.6954_-97.1377", "74604": "36.7299_-97.0454", "74631": "36.8006_-97.2867", "74632": "36.9331_-97.3082", "74641": "36.8382_-96.8833", "74646": "36.8155_-97.4325", "74647": "36.84_-97.0561", "74653": "36.6806_-97.3063", "73016": "35.8_-97.6795", "73734": "35.9848_-97.9067", "73742": "36.0868_-97.8926", "73750": "35.8636_-97.9473", "73756": "35.9705_-98.1155", "73762": "35.7502_-97.93", "73764": "35.8507_-98.1863", "73041": "35.0759_-98.876", "73062": "35.0654_-98.7307", "73559": "34.7032_-98.9591", "73564": "34.847_-98.9836", "73566": "34.6548_-98.9508", "73651": "35.0255_-99.0944", "73655": "34.9806_-99.2502", "74545": "34.8724_-95.469", "74559": "34.9287_-95.2133", "74563": "34.9422_-95.0904", "74578": "34.9128_-95.3389", "74549": "34.5519_-94.9428", "74571": "34.7381_-94.9978", "74577": "34.6926_-94.8852", "74901": "35.3434_-94.4403", "74902": "35.2436_-94.476", "74930": "35.1865_-94.7858", "74932": "35.1494_-94.506", "74935": "34.9537_-94.8998", "74937": "34.8353_-94.6185", "74939": "34.7538_-94.6391", "74940": "34.9512_-94.6372", "74942": "34.8979_-94.9758", "74947": "34.9906_-94.515", "74949": "34.6641_-94.719", "74951": "35.1535_-94.6709", "74953": "35.0606_-94.6096", "74956": "35.1293_-94.6665", "74959": "35.2492_-94.6265", "74966": "34.9556_-94.7832", "74026": "35.7089_-96.767", "74079": "35.7398_-96.6719", "74824": "35.909_-96.8738", "74832": "35.8054_-97.0159", "74834": "35.7017_-96.8809", "74855": "35.5211_-96.9981", "74864": "35.5105_-96.7009", "74869": "35.6138_-96.8163", "74875": "35.8759_-96.9623", "74881": "35.6757_-97.0597", "73027": "35.8985_-97.2607", "73028": "35.942_-97.5969", "73044": "35.833_-97.436", "73050": "35.9419_-97.2557", "73056": "36.1485_-97.6171", "73058": "35.8451_-97.2462", "73063": "36.0537_-97.4098", "73073": "36.142_-97.396", "73430": "33.9515_-97.3249", "73441": "33.8793_-97.4292", "73448": "33.9431_-97.1148", "73453": "34.0539_-97.1324", "73459": "33.7882_-97.1363", "73010": "35.1192_-97.6401", "73031": "35.009_-97.6318", "73065": "35.2453_-97.6216", "73080": "35.0103_-97.4255", "73093": "35.1324_-97.487", "73095": "34.9154_-97.329", "74831": "34.8904_-97.0997", "74722": "34.3934_-94.9249", "74724": "34.3598_-94.8374", "74728": "34.027_-94.7623", "74734": "34.0364_-94.5596", "74736": "33.9192_-94.986", "74737": "34.0303_-94.8986", "74740": "33.785_-94.633", "74745": "33.8851_-94.802", "74750": "33.9801_-95.0025", "74752": "34.3965_-95.0119", "74754": "34.1799_-95.0704", "74755": "34.1272_-95.1174", "74764": "34.0091_-95.0686", "74766": "34.0799_-94.9929", "74957": "34.4954_-94.6981", "74963": "34.4193_-94.5562", "74426": "35.4358_-95.535", "74432": "35.2911_-95.6472", "74438": "35.5297_-95.7596", "74459": "35.5214_-95.495", "74461": "35.3814_-95.7056", "74845": "35.2604_-95.8675", "73718": "36.2423_-98.182", "73729": "36.409_-98.4423", "73737": "36.2871_-98.604", "73747": "36.2341_-98.3374", "73760": "36.3815_-98.1635", "73768": "36.3753_-98.2706", "73838": "36.2621_-98.8838", "73439": "33.9517_-96.712", "73440": "33.9687_-96.9064", "73446": "34.0784_-96.7597", "74330": "36.4115_-95.2732", "74337": "36.1669_-95.3416", "74340": "36.4759_-95.024", "74349": "36.5245_-95.0239", "74350": "36.4645_-95.0478", "74352": "36.1819_-95.1689", "74361": "36.2921_-95.3129", "74362": "36.2925_-95.2228", "74364": "36.1951_-94.9643", "74365": "36.3116_-95.1158", "74366": "36.3912_-95.0466", "74367": "36.4141_-95.0773", "73030": "34.4953_-97.1084", "73032": "34.402_-97.051", "73086": "34.5116_-96.9797", "74401": "35.7058_-95.5002", "74402": "35.7642_-95.3069", "74403": "35.7411_-95.3449", "74422": "35.6577_-95.66", "74423": "35.6574_-95.2033", "74428": "35.5556_-95.6514", "74434": "35.7943_-95.2297", "74436": "35.8108_-95.684", "74439": "35.6767_-95.1775", "74450": "35.625_-95.4856", "74455": "35.3631_-95.2607", "74463": "35.7581_-95.5494", "74468": "35.6126_-95.5644", "74469": "35.4945_-95.3064", "74470": "35.5138_-95.1659", "73061": "36.2902_-97.0228", "73077": "36.2875_-97.2842", "73757": "36.2753_-97.4526", "74630": "36.5246_-97.4189", "74644": "36.5609_-97.1512", "74651": "36.4748_-97.164", "74027": "36.7804_-95.6181", "74042": "36.8801_-95.6233", "74048": "36.6946_-95.6404", "74072": "36.9837_-95.6065", "74083": "36.9402_-95.7768", "74829": "35.4913_-96.4704", "74833": "35.4732_-96.3791", "74859": "35.4647_-96.3287", "74860": "35.5182_-96.5719", "74880": "35.3416_-96.1136", "73003": "35.6748_-97.4997", "73007": "35.6543_-97.3243", "73008": "35.5043_-97.6399", "73012": "35.6215_-97.4733", "73013": "35.6215_-97.4733", "73020": "35.4718_-97.2726", "73025": "35.722_-97.5133", "73034": "35.6665_-97.4798", "73039": "34.506_-97.1131", "73045": "35.4833_-97.1734", "73049": "35.5753_-97.2891", "73054": "35.6617_-97.1956", "73066": "35.4928_-97.3276", "73083": "35.6665_-97.4654", "73084": "35.5183_-97.3488", "73097": "35.397_-97.6519", "73101": "35.4916_-97.5628", "73102": "35.4726_-97.5199", "73103": "35.491_-97.5196", "73104": "35.4794_-97.5017", "73105": "35.5108_-97.5003", "73106": "35.4853_-97.5372", "73107": "35.4874_-97.574", "73108": "35.4445_-97.5619", "73109": "35.4259_-97.5261", "73110": "35.4605_-97.3974", "73111": "35.5042_-97.4806", "73112": "35.5184_-97.5746", "73113": "35.5514_-97.4075", "73114": "35.5704_-97.5257", "73115": "35.4449_-97.446", "73116": "35.5463_-97.5642", "73117": "35.4797_-97.4722", "73118": "35.5136_-97.5319", "73119": "35.421_-97.5616", "73120": "35.5835_-97.5638", "73121": "35.5062_-97.4452", "73122": "35.5184_-97.6167", "73123": "35.4676_-97.5164", "73124": "35.5514_-97.4075", "73125": "35.4654_-97.5218", "73126": "35.5514_-97.4075", "73127": "35.4834_-97.6299", "73128": "35.4444_-97.6164", "73129": "35.4312_-97.4913", "73130": "35.4604_-97.3419", "73131": "35.5797_-97.4691", "73132": "35.5583_-97.6375", "73134": "35.6174_-97.5583", "73135": "35.411_-97.4388", "73136": "35.4676_-97.5164", "73137": "35.5514_-97.4075", "73140": "35.5185_-97.4275", "73141": "35.4918_-97.3666", "73142": "35.599_-97.6251", "73143": "35.5514_-97.4075", "73144": "35.5514_-97.4075", "73145": "35.4304_-97.3962", "73146": "35.5514_-97.4075", "73147": "35.5514_-97.4075", "73148": "35.5514_-97.4075", "73149": "35.395_-97.4972", "73150": "35.4123_-97.3331", "73151": "35.5676_-97.4111", "73152": "35.5514_-97.4075", "73153": "35.5514_-97.4075", "73154": "35.5238_-97.5255", "73155": "35.5514_-97.4075", "73156": "35.5514_-97.4075", "73157": "35.5514_-97.4075", "73159": "35.3922_-97.5567", "73162": "35.5806_-97.6419", "73163": "35.5514_-97.4075", "73164": "35.5514_-97.4075", "73167": "35.4676_-97.5164", "73169": "35.3882_-97.6587", "73172": "35.5175_-97.6218", "73178": "35.5514_-97.4075", "73179": "35.4242_-97.6547", "73184": "35.5514_-97.4075", "73185": "35.4676_-97.5164", "73189": "35.5514_-97.4075", "73190": "35.4676_-97.5164", "73194": "35.5514_-97.4075", "73195": "35.474_-97.5227", "73196": "35.5514_-97.4075", "74857": "35.3734_-97.1971", "74421": "35.7896_-96.0264", "74431": "35.4551_-95.9498", "74437": "35.4622_-96.0122", "74445": "35.6619_-95.8319", "74447": "35.6288_-95.9697", "74456": "35.7115_-95.9917", "74460": "35.5145_-95.9567", "74001": "36.4901_-96.0616", "74002": "36.5429_-96.1318", "74035": "36.4111_-96.3878", "74054": "36.2832_-96.3774", "74056": "36.6904_-96.3121", "74060": "36.2501_-96.2701", "74070": "36.3725_-96.0123", "74084": "36.5462_-96.3272", "74127": "36.1576_-96.0311", "74633": "36.6966_-96.7869", "74637": "36.5577_-96.6997", "74652": "36.7819_-96.6607", "74331": "36.6296_-94.9432", "74335": "36.9795_-94.8557", "74339": "36.9331_-94.873", "74343": "36.7418_-94.8279", "74354": "36.8764_-94.8719", "74355": "36.8341_-94.877", "74358": "36.9173_-94.8797", "74360": "36.98_-94.8173", "74363": "36.9282_-94.743", "74370": "36.7796_-94.7002", "74020": "36.2553_-96.423", "74034": "36.2319_-96.562", "74038": "36.1863_-96.5732", "74045": "36.242_-96.6803", "74058": "36.3362_-96.7923", "74081": "36.1889_-96.4876", "74650": "36.4992_-96.7755", "74023": "35.9822_-96.7526", "74032": "36.2158_-96.9138", "74059": "35.9768_-97.0441", "74062": "35.9985_-96.8967", "74074": "36.1043_-97.0609", "74075": "36.1396_-97.063", "74076": "36.0724_-97.0551", "74077": "36.1156_-97.0584", "74078": "36.1241_-97.0705", "74085": "36.1101_-96.7022", "74425": "35.1571_-95.6215", "74430": "35.1334_-95.6602", "74442": "35.1314_-95.8158", "74501": "34.9262_-95.7592", "74502": "34.9334_-95.7697", "74522": "34.9001_-95.6919", "74528": "34.7276_-95.7283", "74529": "35.0615_-95.5683", "74546": "34.85_-95.5777", "74547": "34.8452_-95.574", "74553": "34.7278_-95.9328", "74554": "34.9255_-95.7216", "74560": "34.6975_-95.8439", "74561": "35.1547_-95.4671", "74565": "34.8354_-95.838", "74576": "34.6695_-96.0258", "74820": "34.78_-96.6924", "74821": "34.7745_-96.6783", "74825": "34.8691_-96.4151", "74842": "34.6148_-96.6345", "74843": "34.6615_-96.7745", "74844": "34.8737_-96.5956", "74865": "34.6153_-96.8423", "74871": "34.6511_-96.5273", "74801": "35.2958_-96.9601", "74802": "35.3273_-96.9253", "74804": "35.3868_-96.9331", "74826": "34.9849_-96.8763", "74840": "35.2628_-96.8041", "74851": "35.4262_-97.079", "74852": "35.1205_-97.034", "74854": "35.1292_-96.7627", "74866": "35.0588_-96.8444", "74873": "35.2502_-96.9667", "74878": "34.9983_-97.0419", "74521": "34.6516_-95.0924", "74523": "34.2349_-95.6254", "74536": "34.5906_-95.38", "74543": "34.3407_-95.5385", "74557": "34.3386_-95.6639", "74558": "34.5072_-95.2075", "74562": "34.2454_-95.3442", "74567": "34.4419_-95.4622", "74574": "34.6622_-95.2362", "73628": "35.6081_-99.6725", "73638": "35.8368_-99.8064", "73642": "35.8364_-99.9088", "73650": "35.6461_-99.4027", "73660": "35.6576_-99.9166", "73666": "35.4488_-99.9006", "74015": "36.1721_-95.7273", "74016": "36.5356_-95.4489", "74017": "36.3242_-95.5985", "74018": "36.3436_-95.606", "74031": "36.4348_-95.5194", "74036": "36.1503_-95.5205", "74053": "36.4482_-95.7047", "74080": "36.5429_-95.7142", "74818": "35.2245_-96.6706", "74830": "35.1462_-96.67", "74837": "35.3405_-96.4546", "74849": "34.9708_-96.7343", "74867": "34.951_-96.5387", "74868": "35.2521_-96.6683", "74884": "35.1463_-96.628", "74435": "35.5418_-95.1095", "74936": "35.3946_-94.6901", "74945": "35.5972_-94.8094", "74946": "35.3898_-94.4462", "74948": "35.402_-94.6332", "74954": "35.4538_-94.5291", "74955": "35.4852_-94.779", "74962": "35.5404_-94.9888", "73055": "34.6387_-97.941", "73425": "34.4487_-97.5628", "73434": "34.6379_-97.5455", "73442": "34.3214_-97.6658", "73491": "34.4565_-97.6689", "73529": "34.3765_-97.9793", "73533": "34.5073_-97.9403", "73534": "34.5189_-97.9733", "73536": "34.4853_-97.8522", "73901": "36.755_-101.078", "73939": "36.6744_-101.7137", "73942": "36.6961_-101.4778", "73944": "36.6018_-101.1539", "73945": "36.8109_-101.2163", "73949": "36.5253_-101.8394", "73951": "36.9558_-101.0594", "73530": "34.2514_-99.064", "73542": "34.4012_-99.0119", "73546": "34.2282_-98.6867", "73551": "34.3525_-98.8814", "73553": "34.391_-98.7235", "73555": "34.5075_-98.9792", "73570": "34.5098_-99.1315", "74008": "35.942_-95.8833", "74011": "35.9908_-95.8143", "74012": "36.0447_-95.8079", "74013": "36.0526_-95.7908", "74021": "36.3701_-95.8469", "74033": "35.9591_-95.9997", "74037": "36.0148_-95.9797", "74043": "35.9183_-95.7988", "74050": "36.0731_-96.0621", "74055": "36.2863_-95.8222", "74063": "36.1341_-96.1426", "74073": "36.2955_-95.9804", "74101": "36.0391_-95.8687", "74102": "36.154_-95.9928", "74103": "36.1539_-95.9954", "74104": "36.1464_-95.9526", "74105": "36.0948_-95.9655", "74106": "36.1883_-95.986", "74107": "36.1042_-96.0244", "74108": "36.1499_-95.7923", "74110": "36.1803_-95.9525", "74112": "36.147_-95.907", "74114": "36.1262_-95.9408", "74115": "36.1754_-95.9112", "74116": "36.175_-95.8477", "74117": "36.2393_-95.8979", "74119": "36.1407_-95.9902", "74120": "36.1442_-95.9734", "74121": "36.1398_-96.0297", "74126": "36.2383_-95.9931", "74128": "36.1459_-95.8514", "74129": "36.1259_-95.8654", "74130": "36.2395_-95.9596", "74132": "36.064_-96.0251", "74133": "36.0467_-95.8841", "74134": "36.1162_-95.8225", "74135": "36.0976_-95.9228", "74136": "36.0605_-95.9452", "74137": "36.0284_-95.9306", "74141": "36.1398_-96.0297", "74145": "36.0934_-95.8856", "74146": "36.1093_-95.8506", "74147": "36.1398_-96.0297", "74148": "36.1398_-96.0297", "74149": "36.1398_-96.0297", "74150": "36.1398_-96.0297", "74152": "36.1398_-96.0297", "74153": "36.1398_-96.0297", "74155": "36.1398_-96.0297", "74156": "36.3024_-95.9605", "74157": "36.1398_-96.0297", "74158": "36.1398_-96.0297", "74159": "36.0772_-96.0835", "74169": "36.1398_-96.0297", "74170": "36.1398_-96.0297", "74171": "36.154_-95.9928", "74172": "36.1543_-95.9923", "74182": "36.154_-95.9928", "74186": "36.154_-95.9928", "74187": "36.154_-95.9928", "74192": "36.154_-95.9928", "74193": "36.1398_-96.0297", "74014": "36.0544_-95.7223", "74019": "36.2806_-95.6039", "74429": "35.9578_-95.6526", "74446": "35.8507_-95.3183", "74454": "35.8567_-95.5082", "74458": "35.8836_-95.5917", "74467": "35.9549_-95.354", "74477": "35.9636_-95.5139", "74003": "36.744_-95.9921", "74004": "36.7114_-95.894", "74005": "36.7473_-95.9808", "74006": "36.7366_-95.9251", "74022": "36.9062_-95.913", "74029": "36.8013_-95.9345", "74051": "36.5947_-95.9691", "74061": "36.5752_-95.8962", "74082": "36.4501_-95.8814", "73021": "35.3448_-98.6707", "73024": "35.3784_-98.7818", "73622": "35.3854_-98.9896", "73624": "35.3492_-99.188", "73626": "35.4037_-99.2816", "73632": "35.2788_-98.9511", "73641": "35.2787_-99.1537", "73647": "35.4545_-99.1698", "73661": "35.1526_-99.048", "73664": "35.1617_-99.1706", "73717": "36.8016_-98.6722", "73731": "36.6606_-98.5942", "73746": "36.6881_-98.6659", "73842": "36.809_-99.1319", "73860": "36.5858_-98.8487", "73801": "36.4268_-99.402", "73802": "36.544_-99.3003", "73841": "36.5722_-99.5738", "73852": "36.4428_-99.1832", "73853": "36.214_-99.1145", "73857": "36.2699_-99.3587", "97814": "44.7749_-117.8344", "97819": "44.4931_-117.7655", "97833": "44.8776_-117.9756", "97834": "44.8953_-117.1132", "97837": "44.5304_-118.0293", "97840": "44.9749_-116.8629", "97870": "44.797_-117.3018", "97877": "44.7457_-118.2022", "97884": "44.4374_-118.1927", "97905": "44.4988_-117.4129", "97907": "44.3811_-117.3097", "97324": "44.3691_-123.6089", "97326": "44.6281_-123.6067", "97330": "44.5904_-123.2722", "97331": "44.5638_-123.2779", "97333": "44.5393_-123.2799", "97339": "44.5646_-123.262", "97370": "44.5488_-123.3923", "97456": "44.3245_-123.3203", "97004": "45.2597_-122.4751", "97009": "45.4297_-122.3807", "97011": "45.3652_-122.0036", "97013": "45.2514_-122.6832", "97015": "45.415_-122.52", "97017": "45.1573_-122.4248", "97022": "45.3582_-122.3381", "97023": "45.2872_-122.3259", "97027": "45.3899_-122.5902", "97028": "45.2972_-121.739", "97034": "45.4093_-122.6847", "97035": "45.4147_-122.7227", "97036": "45.4012_-122.6512", "97038": "45.1223_-122.5756", "97042": "45.213_-122.5351", "97045": "45.3377_-122.57", "97049": "45.3465_-121.9151", "97055": "45.379_-122.223", "97067": "45.3399_-121.9598", "97068": "45.3669_-122.648", "97070": "45.2986_-122.7699", "97089": "45.4176_-122.459", "97222": "45.4373_-122.6147", "97267": "45.4021_-122.6144", "97268": "45.5235_-122.6762", "97269": "45.5235_-122.6762", "97102": "45.8109_-123.963", "97103": "46.1558_-123.798", "97110": "45.8918_-123.9615", "97121": "46.198_-123.9527", "97138": "45.9932_-123.9226", "97145": "45.8663_-123.9595", "97146": "46.145_-123.9254", "97016": "46.0665_-123.2059", "97018": "45.8925_-122.8122", "97048": "46.0646_-122.9671", "97051": "45.8608_-122.8282", "97053": "45.826_-122.8634", "97054": "45.9356_-122.8985", "97056": "45.7655_-122.8928", "97064": "45.8573_-123.1967", "97407": "43.4259_-124.0323", "97411": "43.0968_-124.4037", "97414": "42.985_-124.1189", "97420": "43.2151_-124.1984", "97423": "43.1884_-124.2014", "97449": "43.5833_-124.1624", "97458": "43.0667_-124.1213", "97459": "43.4327_-124.2131", "97466": "42.88_-124.0709", "97751": "44.2102_-119.7828", "97752": "44.0793_-120.2998", "97753": "44.2415_-121.0113", "97754": "44.3045_-120.8336", "97406": "42.5748_-124.0648", "97415": "42.0526_-124.284", "97444": "42.4073_-124.4218", "97450": "42.9154_-124.4413", "97464": "42.5632_-124.3829", "97465": "42.7572_-124.4913", "97476": "42.825_-124.4409", "97491": "42.6093_-124.3886", "97701": "44.0928_-121.2936", "97702": "44.0223_-121.2985", "97703": "44.0915_-121.4073", "97707": "43.8431_-121.5764", "97708": "44.0582_-121.3153", "97709": "44.0582_-121.3153", "97712": "43.7789_-120.477", "97739": "43.7091_-121.5194", "97756": "44.2767_-121.1896", "97759": "44.3165_-121.5091", "97760": "44.3909_-121.2379", "97410": "42.845_-123.155", "97416": "43.0557_-123.6655", "97417": "42.9307_-123.278", "97429": "42.9819_-123.1439", "97432": "43.1135_-123.4181", "97435": "43.6877_-123.2929", "97436": "43.6378_-123.59", "97441": "43.7301_-124.1104", "97442": "42.7518_-123.3943", "97443": "43.3015_-123.1012", "97447": "43.3237_-123.024", "97457": "43.0162_-123.2851", "97462": "43.453_-123.3558", "97467": "43.7023_-124.0968", "97469": "42.9389_-123.3612", "97470": "43.2297_-123.2343", "97471": "43.227_-123.5158", "97473": "43.6765_-123.8041", "97479": "43.3904_-123.2974", "97481": "43.114_-123.5294", "97484": "42.9177_-122.9079", "97486": "43.3745_-123.5358", "97494": "43.3284_-123.3332", "97495": "43.2878_-123.3055", "97496": "43.1049_-123.4325", "97499": "43.6043_-123.2926", "97812": "45.6664_-120.1971", "97823": "45.2306_-120.1898", "97861": "45.4388_-120.2067", "97817": "44.7138_-118.6469", "97820": "44.3911_-118.9465", "97825": "44.4663_-119.5312", "97845": "44.416_-118.953", "97848": "44.7226_-119.5965", "97856": "44.7554_-119.097", "97864": "44.8189_-119.4192", "97865": "44.4171_-119.1121", "97869": "44.457_-118.6952", "97873": "44.1346_-118.9716", "97710": "42.1862_-118.4758", "97720": "43.5145_-119.0504", "97721": "43.0198_-119.0696", "97722": "42.9508_-118.695", "97732": "43.4262_-118.4642", "97736": "42.7147_-119.0058", "97738": "43.5558_-119.0816", "97758": "43.3886_-119.8798", "97904": "43.8643_-118.4707", "97014": "45.671_-121.8686", "97031": "45.6711_-121.5391", "97041": "45.4929_-121.5983", "97044": "45.6437_-121.5367", "97501": "42.2818_-122.9054", "97502": "42.3899_-122.9222", "97503": "42.4319_-122.8296", "97504": "42.3363_-122.8398", "97520": "42.1885_-122.693", "97522": "42.5492_-122.5638", "97524": "42.4935_-122.8088", "97525": "42.4244_-123.0854", "97530": "42.1813_-123.0241", "97535": "42.2766_-122.8227", "97536": "42.7544_-122.509", "97537": "42.4889_-123.1587", "97539": "42.6107_-122.8125", "97540": "42.2363_-122.7861", "97541": "42.6864_-122.816", "97711": "44.7195_-120.7192", "97730": "44.4604_-121.6412", "97734": "44.4818_-121.2344", "97741": "44.6376_-121.1349", "97761": "44.7468_-121.2909", "97497": "42.6522_-123.425", "97523": "42.1348_-123.6272", "97526": "42.4638_-123.3457", "97527": "42.3989_-123.3538", "97528": "42.4393_-123.3307", "97531": "42.2093_-123.6573", "97532": "42.5297_-123.4393", "97533": "42.308_-123.3273", "97534": "42.0879_-123.689", "97538": "42.2654_-123.5515", "97543": "42.3751_-123.5621", "97544": "42.223_-123.2829", "97601": "42.2933_-121.8169", "97602": "42.2249_-121.7817", "97603": "42.1919_-121.7241", "97604": "42.9465_-122.1769", "97621": "42.4369_-121.22", "97622": "42.3995_-121.0806", "97623": "42.2463_-121.3336", "97624": "42.5463_-121.745", "97625": "42.2351_-121.5211", "97626": "42.6415_-122.038", "97627": "42.1265_-121.93", "97632": "42.0195_-121.4221", "97633": "42.0295_-121.5985", "97634": "42.1307_-121.8203", "97639": "42.4514_-121.4365", "97731": "43.146_-121.7974", "97733": "43.4442_-121.7109", "97737": "43.4771_-121.6853", "97620": "42.1487_-119.8833", "97630": "42.1854_-120.3775", "97635": "41.9941_-120.2972", "97636": "42.7031_-120.5532", "97637": "42.5035_-119.8947", "97638": "43.1395_-120.9984", "97640": "42.9447_-120.7946", "97641": "43.2363_-120.6369", "97735": "43.3565_-121.0539", "97401": "44.0682_-123.0819", "97402": "44.0612_-123.1555", "97403": "44.0385_-123.0614", "97404": "44.1005_-123.1334", "97405": "44.0185_-123.0998", "97408": "44.1445_-123.0545", "97409": "44.1276_-123.2666", "97412": "44.1966_-123.5348", "97413": "44.1755_-122.1217", "97419": "44.1782_-123.3715", "97424": "43.7839_-123.0529", "97426": "43.9058_-123.0284", "97430": "44.1462_-123.6816", "97431": "43.9217_-122.8424", "97434": "43.7361_-122.8946", "97437": "44.0873_-123.3671", "97438": "43.9509_-122.6884", "97439": "43.9881_-124.0993", "97440": "44.0521_-123.0868", "97448": "44.1988_-123.23", "97451": "43.8376_-123.239", "97452": "43.921_-122.7806", "97453": "44.0312_-123.8657", "97454": "44.2064_-122.8246", "97455": "43.9458_-122.9285", "97461": "44.0992_-123.4684", "97463": "43.7376_-122.4377", "97475": "44.0462_-123.022", "97477": "44.0611_-123.0153", "97478": "44.0561_-122.9171", "97480": "44.0899_-123.8279", "97487": "44.0382_-123.3516", "97488": "44.13_-122.5044", "97489": "44.1288_-122.6376", "97490": "44.0282_-123.5893", "97492": "43.7575_-122.481", "97493": "43.914_-124.0334", "97341": "44.8322_-124.0503", "97343": "44.6371_-123.7531", "97357": "44.7432_-123.7943", "97364": "44.9988_-123.9843", "97365": "44.6487_-124.0509", "97366": "44.5712_-124.06", "97367": "44.9089_-123.9888", "97368": "45.0138_-123.9332", "97369": "44.7588_-124.0633", "97376": "44.4874_-123.9567", "97380": "44.7313_-123.9062", "97388": "44.8812_-124.0343", "97390": "44.4055_-123.9149", "97391": "44.6271_-123.9301", "97394": "44.4085_-124.0351", "97498": "44.3256_-124.0863", "97321": "44.652_-123.1333", "97322": "44.626_-123.057", "97327": "44.377_-122.9485", "97329": "44.3973_-122.4817", "97335": "44.6344_-122.8933", "97336": "44.3593_-122.8508", "97345": "44.3836_-122.5449", "97348": "44.3862_-123.1251", "97355": "44.5316_-122.8821", "97358": "44.7499_-122.595", "97360": "44.7516_-122.4768", "97374": "44.7168_-122.7684", "97377": "44.453_-123.1065", "97386": "44.3981_-122.7286", "97389": "44.5497_-123.1108", "97446": "44.2717_-123.1432", "97901": "43.6537_-117.0602", "97902": "42.9156_-117.498", "97903": "44.1994_-117.5904", "97906": "43.8734_-117.5284", "97908": "44.3009_-117.9444", "97909": "44.2161_-117.4813", "97910": "42.8801_-117.281", "97911": "43.8253_-118.0921", "97913": "43.8604_-117.0251", "97914": "44.0416_-116.9783", "97917": "43.5099_-118.0986", "97918": "44.0039_-117.2674", "97920": "43.9922_-117.6877", "97002": "45.2284_-122.8039", "97020": "45.2199_-122.8405", "97026": "45.1086_-122.8962", "97032": "45.1823_-122.8079", "97071": "45.1446_-122.8583", "97137": "45.196_-122.9674", "97301": "44.949_-123.004", "97302": "44.9039_-123.0445", "97303": "44.9927_-123.0167", "97305": "44.9961_-122.9124", "97306": "44.8685_-123.0438", "97307": "44.9901_-123.0262", "97308": "44.9429_-123.0351", "97309": "44.9429_-123.0351", "97310": "44.9271_-122.9861", "97311": "44.9438_-123.0286", "97312": "44.9364_-123.0381", "97313": "44.9849_-122.9988", "97314": "44.9655_-123.0066", "97317": "44.9026_-122.9074", "97325": "44.8313_-122.8517", "97342": "44.734_-122.1498", "97346": "44.7527_-122.3995", "97350": "44.7001_-122.074", "97352": "44.7495_-123.006", "97362": "45.0737_-122.7856", "97373": "44.9845_-122.457", "97375": "44.9897_-122.6187", "97381": "44.991_-122.7627", "97383": "44.8021_-122.7624", "97384": "44.7903_-122.6187", "97385": "44.8425_-122.8007", "97392": "44.8476_-122.9501", "97818": "45.8272_-119.7206", "97836": "45.3486_-119.5369", "97839": "45.4264_-119.7464", "97843": "45.5403_-119.769", "97844": "45.8877_-119.507", "97010": "45.583_-122.1011", "97019": "45.5221_-122.2417", "97024": "45.5473_-122.4414", "97030": "45.5154_-122.4203", "97060": "45.5254_-122.3739", "97080": "45.4817_-122.4156", "97086": "45.4446_-122.5372", "97201": "45.5078_-122.6897", "97202": "45.484_-122.6365", "97203": "45.5889_-122.7347", "97204": "45.5181_-122.6745", "97205": "45.5207_-122.6888", "97206": "45.484_-122.5973", "97207": "45.5235_-122.6762", "97208": "45.5235_-122.6762", "97209": "45.527_-122.6854", "97210": "45.5303_-122.7033", "97211": "45.5653_-122.6448", "97212": "45.5441_-122.6423", "97213": "45.5373_-122.5987", "97214": "45.5142_-122.6364", "97215": "45.5143_-122.599", "97216": "45.5137_-122.5569", "97217": "45.5742_-122.6842", "97218": "45.56_-122.6001", "97219": "45.458_-122.7074", "97220": "45.5411_-122.5566", "97221": "45.4918_-122.7267", "97227": "45.5496_-122.6743", "97228": "45.5235_-122.6762", "97230": "45.5472_-122.5001", "97231": "45.6401_-122.838", "97232": "45.5287_-122.6363", "97233": "45.5142_-122.4985", "97236": "45.4887_-122.5091", "97238": "45.5235_-122.6762", "97239": "45.4983_-122.6913", "97240": "45.5235_-122.6762", "97242": "45.5235_-122.6762", "97250": "45.5235_-122.6762", "97251": "45.5235_-122.6762", "97252": "45.5235_-122.6762", "97253": "45.5235_-122.6762", "97254": "45.5967_-122.5942", "97256": "45.5235_-122.6762", "97258": "45.5235_-122.6762", "97266": "45.4762_-122.5596", "97280": "45.5235_-122.6762", "97282": "45.5235_-122.6762", "97283": "45.5235_-122.6762", "97286": "45.5235_-122.6762", "97290": "45.5235_-122.6762", "97292": "45.5235_-122.6762", "97293": "45.5235_-122.6762", "97294": "45.5235_-122.6762", "97296": "45.5235_-122.6762", "97304": "44.9588_-123.0753", "97338": "44.9225_-123.32", "97344": "44.8706_-123.4461", "97347": "45.075_-123.6335", "97351": "44.8481_-123.1879", "97361": "44.8377_-123.2512", "97371": "45.02_-123.2064", "97029": "45.3013_-120.7478", "97033": "45.0838_-120.6649", "97039": "45.4853_-120.6957", "97050": "45.6948_-120.7359", "97065": "45.5974_-120.7304", "97107": "45.5197_-123.8761", "97108": "45.2767_-123.8234", "97112": "45.2858_-123.8356", "97118": "45.5626_-123.9001", "97122": "45.1768_-123.846", "97130": "45.7184_-123.9351", "97131": "45.7216_-123.9049", "97134": "45.4549_-123.965", "97135": "45.205_-123.959", "97136": "45.6134_-123.9429", "97141": "45.4492_-123.8189", "97143": "45.434_-123.9458", "97147": "45.6888_-123.8816", "97149": "45.097_-123.9434", "97801": "45.6605_-118.7831", "97810": "45.7674_-118.5625", "97813": "45.8289_-118.4971", "97826": "45.7411_-119.1949", "97835": "45.8665_-118.7222", "97838": "45.845_-119.2849", "97859": "45.5215_-118.4335", "97862": "45.9486_-118.3912", "97868": "45.4227_-118.8483", "97875": "45.786_-119.2116", "97880": "45.0836_-118.894", "97882": "45.8998_-119.3553", "97886": "45.8074_-118.3733", "97824": "45.3199_-117.8147", "97827": "45.5941_-117.9112", "97841": "45.4599_-117.9544", "97850": "45.3304_-118.0852", "97867": "45.0317_-117.9337", "97876": "45.5077_-118.027", "97883": "45.2019_-117.8536", "97828": "45.437_-117.2888", "97842": "45.5137_-116.8257", "97846": "45.3494_-117.2128", "97857": "45.4939_-117.4359", "97885": "45.5717_-117.5357", "97001": "44.8892_-120.7914", "97021": "45.3913_-121.1432", "97037": "45.0742_-121.2282", "97040": "45.6508_-121.379", "97057": "45.0027_-120.75", "97058": "45.5995_-121.1905", "97063": "45.2229_-121.2927", "97003": "45.5201_-122.8604", "97005": "45.4963_-122.8001", "97006": "45.5201_-122.8604", "97007": "45.4505_-122.8652", "97008": "45.456_-122.7996", "97062": "45.3727_-122.7631", "97075": "45.4871_-122.8037", "97076": "45.4871_-122.8037", "97077": "45.4871_-122.8037", "97078": "45.452_-122.7893", "97079": "45.452_-122.7893", "97106": "45.6535_-123.121", "97109": "45.737_-123.2146", "97113": "45.529_-123.0415", "97116": "45.5981_-123.1818", "97117": "45.5957_-123.234", "97119": "45.4427_-123.1666", "97123": "45.4984_-122.957", "97124": "45.5387_-122.9636", "97125": "45.6648_-123.1637", "97129": "45.5387_-122.9636", "97133": "45.6686_-123.0281", "97140": "45.3514_-122.8567", "97144": "45.727_-123.3119", "97223": "45.4403_-122.7793", "97224": "45.4094_-122.8014", "97225": "45.4985_-122.7787", "97229": "45.5483_-122.8276", "97281": "45.5235_-122.6762", "97291": "45.5235_-122.6762", "97298": "45.5235_-122.6762", "97750": "44.5657_-120.1456", "97830": "44.9286_-120.1309", "97874": "44.8242_-119.8303", "97101": "45.1157_-123.1744", "97111": "45.2859_-123.1523", "97114": "45.1977_-123.0753", "97115": "45.2776_-123.0152", "97127": "45.2466_-123.1114", "97128": "45.2097_-123.2043", "97132": "45.3099_-122.9685", "97148": "45.335_-123.2036", "97378": "45.0897_-123.4003", "97396": "45.0826_-123.5047", "17301": "39.8881_-76.9931", "17303": "39.9236_-77.3001", "17304": "39.9765_-77.2287", "17306": "39.9792_-77.2496", "17307": "39.9281_-77.2885", "17310": "39.8906_-77.3566", "17316": "39.9645_-77.0073", "17320": "39.7808_-77.3619", "17324": "40.0428_-77.1877", "17325": "39.832_-77.2223", "17337": "40.0157_-77.2001", "17340": "39.7495_-77.1003", "17343": "39.8692_-77.3292", "17344": "39.801_-77.0229", "17350": "39.8775_-77.0643", "17353": "39.881_-77.3806", "17372": "40.0084_-77.1061", "17375": "39.8948_-77.2135", "15006": "40.6312_-79.8814", "15007": "40.6478_-79.931", "15014": "40.6082_-79.7414", "15015": "40.6372_-80.0811", "15017": "40.3472_-80.1153", "15018": "40.2773_-79.7992", "15020": "40.2373_-79.9506", "15024": "40.5681_-79.841", "15025": "40.3243_-79.9317", "15026": "40.5131_-80.3423", "15028": "40.4344_-80.0248", "15030": "40.5821_-79.7818", "15031": "40.3547_-80.1669", "15032": "40.6423_-79.8509", "15034": "40.3527_-79.8895", "15035": "40.3839_-79.8079", "15037": "40.2656_-79.8568", "15044": "40.6252_-79.9443", "15045": "40.326_-79.8883", "15046": "40.5563_-80.2286", "15047": "40.3123_-79.8067", "15049": "40.5574_-79.8051", "15051": "40.5695_-79.8637", "15056": "40.5662_-80.2099", "15064": "40.3542_-80.1398", "15065": "40.6421_-79.7273", "15071": "40.4033_-80.1842", "15075": "40.5856_-79.8287", "15076": "40.6073_-79.8347", "15082": "40.3863_-80.2083", "15084": "40.6187_-79.7852", "15086": "40.6534_-80.0795", "15088": "40.2716_-79.8966", "15090": "40.612_-80.0649", "15091": "40.5942_-79.9701", "15095": "40.6534_-80.0795", "15096": "40.6534_-80.0795", "15101": "40.57_-79.9665", "15102": "40.321_-80.0398", "15104": "40.4038_-79.8625", "15106": "40.4029_-80.0915", "15108": "40.5_-80.1996", "15110": "40.3704_-79.8522", "15112": "40.4036_-79.8389", "15116": "40.5375_-79.9644", "15120": "40.3926_-79.9052", "15122": "40.3634_-79.8664", "15123": "40.4344_-80.0248", "15126": "40.4584_-80.2649", "15127": "40.5809_-80.0609", "15129": "40.2932_-79.996", "15131": "40.3478_-79.8642", "15132": "40.3478_-79.8642", "15133": "40.3478_-79.8642", "15134": "40.3478_-79.8642", "15135": "40.3478_-79.8642", "15136": "40.4717_-80.0876", "15137": "40.3762_-79.8124", "15139": "40.5196_-79.8369", "15140": "40.4048_-79.777", "15142": "40.3847_-80.1209", "15143": "40.557_-80.1578", "15144": "40.544_-79.7844", "15145": "40.4113_-79.822", "15146": "40.429_-79.7623", "15147": "40.4927_-79.8345", "15148": "40.3934_-79.7951", "15201": "40.4752_-79.9528", "15202": "40.5053_-80.0685", "15203": "40.4254_-79.9799", "15204": "40.4554_-80.0644", "15205": "40.4322_-80.1021", "15206": "40.4723_-79.9132", "15207": "40.4003_-79.9338", "15208": "40.4532_-79.8995", "15209": "40.4999_-79.9739", "15210": "40.4072_-79.9839", "15211": "40.4295_-80.0144", "15212": "40.4406_-79.9959", "15213": "40.444_-79.9552", "15214": "40.4865_-80.014", "15215": "40.5048_-79.9138", "15216": "40.4001_-80.0462", "15217": "40.4308_-79.9205", "15218": "40.4237_-79.89", "15219": "40.4423_-79.983", "15220": "40.4181_-80.0526", "15221": "40.4346_-79.8655", "15222": "40.4477_-79.9933", "15223": "40.5051_-79.9528", "15224": "40.4642_-79.9448", "15225": "40.5051_-80.1155", "15226": "40.4001_-80.0161", "15227": "40.3805_-79.9667", "15228": "40.3696_-80.0439", "15229": "40.5203_-80.037", "15230": "40.4344_-80.0248", "15231": "40.4961_-80.2466", "15232": "40.4525_-79.9319", "15233": "40.4608_-80.0348", "15234": "40.3688_-80.0224", "15235": "40.4598_-79.8224", "15236": "40.3351_-79.9832", "15237": "40.5488_-80.0474", "15238": "40.5346_-79.8805", "15239": "40.4837_-79.7381", "15240": "40.4344_-80.0248", "15241": "40.3323_-80.081", "15242": "40.4344_-80.0248", "15243": "40.3748_-80.0731", "15244": "40.4344_-80.0248", "15250": "40.4344_-80.0248", "15251": "40.4344_-80.0248", "15252": "40.4344_-80.0248", "15253": "40.4344_-80.0248", "15254": "40.4344_-80.0248", "15255": "40.4344_-80.0248", "15257": "40.4344_-80.0248", "15258": "40.4344_-80.0248", "15259": "40.4344_-80.0248", "15260": "40.4432_-79.9531", "15261": "40.4344_-80.0248", "15262": "40.4344_-80.0248", "15264": "40.4344_-80.0248", "15265": "40.4344_-80.0248", "15267": "40.4344_-80.0248", "15268": "40.4344_-80.0248", "15270": "40.4344_-80.0248", "15272": "40.4344_-80.0248", "15274": "40.4344_-80.0248", "15275": "40.4495_-80.1795", "15276": "40.4344_-80.0248", "15277": "40.4344_-80.0248", "15278": "40.4344_-80.0248", "15279": "40.4344_-80.0248", "15281": "40.4344_-80.0248", "15282": "40.4406_-79.9959", "15283": "40.4344_-80.0248", "15286": "40.4344_-80.0248", "15289": "40.4446_-79.9451", "15290": "40.4344_-80.0248", "15295": "40.463_-80.0108", "15656": "40.6344_-79.6201", "15673": "40.593_-79.5581", "15682": "40.6845_-79.6617", "15686": "40.6153_-79.4545", "15736": "40.6922_-79.3422", "15774": "40.6388_-79.3191", "16049": "41.1009_-79.6889", "16201": "40.8155_-79.5107", "16210": "40.9049_-79.5074", "16212": "40.7539_-79.5798", "16218": "40.923_-79.5946", "16222": "40.8741_-79.2686", "16223": "40.9695_-79.3567", "16226": "40.7384_-79.5122", "16228": "40.7608_-79.5358", "16229": "40.7033_-79.663", "16236": "40.7818_-79.5218", "16238": "40.7863_-79.5213", "16244": "40.8478_-79.4516", "16245": "41.0076_-79.2959", "16249": "40.7885_-79.2991", "16250": "40.7774_-79.2336", "16253": "40.9548_-79.3428", "16259": "40.9419_-79.4499", "16261": "40.9612_-79.4673", "16262": "40.8378_-79.6298", "16263": "40.8001_-79.3342", "15001": "40.5921_-80.3197", "15003": "40.6005_-80.2105", "15005": "40.6416_-80.1985", "15009": "40.6972_-80.3365", "15010": "40.7687_-80.3592", "15027": "40.6649_-80.2349", "15042": "40.683_-80.2147", "15043": "40.5743_-80.49", "15050": "40.5622_-80.4388", "15052": "40.6671_-80.4151", "15059": "40.6793_-80.4908", "15061": "40.6718_-80.2917", "15066": "40.7393_-80.2972", "15074": "40.7157_-80.2603", "15077": "40.632_-80.414", "15081": "40.5763_-80.2383", "16115": "40.7968_-80.4556", "16123": "40.8125_-80.2073", "16136": "40.8348_-80.328", "16141": "40.8569_-80.3939", "15521": "40.1858_-78.6206", "15522": "39.9908_-78.5261", "15533": "39.9905_-78.2453", "15534": "39.922_-78.6996", "15535": "39.8533_-78.4392", "15537": "40.0098_-78.3713", "15539": "40.1217_-78.5856", "15545": "39.8049_-78.7335", "15550": "39.9808_-78.6423", "15554": "40.1254_-78.6184", "15559": "40.0487_-78.6482", "16633": "40.1601_-78.2346", "16650": "40.1192_-78.3129", "16655": "40.2067_-78.5228", "16659": "40.1609_-78.375", "16664": "40.2_-78.4259", "16667": "40.1695_-78.5203", "16670": "40.2592_-78.5075", "16672": "40.162_-78.2545", "16678": "40.2233_-78.2471", "16679": "40.1576_-78.2108", "16694": "40.166_-78.1381", "16695": "40.2185_-78.3666", "17211": "39.7575_-78.4031", "18056": "40.4491_-75.5491", "19503": "40.405_-75.5769", "19504": "40.3815_-75.5749", "19505": "40.3795_-75.6257", "19506": "40.4551_-76.1247", "19507": "40.4808_-76.2742", "19508": "40.2563_-75.8344", "19510": "40.4435_-75.8837", "19511": "40.4821_-75.7435", "19512": "40.3339_-75.6604", "19516": "40.4858_-76.006", "19518": "40.2709_-75.7397", "19519": "40.319_-75.7334", "19522": "40.4473_-75.8185", "19523": "40.2026_-75.8363", "19526": "40.5488_-75.9874", "19529": "40.6328_-75.8513", "19530": "40.5214_-75.7774", "19533": "40.4152_-75.9944", "19534": "40.5736_-75.865", "19535": "40.3356_-75.801", "19536": "40.5218_-75.7419", "19538": "40.5426_-75.6888", "19539": "40.4992_-75.6872", "19540": "40.2584_-75.9833", "19541": "40.4783_-76.0125", "19543": "40.1552_-75.8998", "19544": "40.4187_-76.2944", "19545": "40.3397_-75.6302", "19547": "40.3833_-75.7706", "19548": "40.2829_-75.6907", "19550": "40.4553_-76.2453", "19551": "40.3553_-76.1366", "19554": "40.5129_-76.1044", "19555": "40.4955_-75.9603", "19559": "40.4945_-76.1825", "19560": "40.4025_-75.9046", "19562": "40.5029_-75.7015", "19564": "40.524_-75.873", "19565": "40.3293_-76.0901", "19567": "40.3743_-76.1985", "19601": "40.3466_-75.9351", "19602": "40.3306_-75.9192", "19603": "40.3884_-75.9631", "19604": "40.3507_-75.9143", "19605": "40.3886_-75.9328", "19606": "40.3351_-75.875", "19607": "40.2995_-75.9876", "19608": "40.3113_-76.0345", "19609": "40.328_-75.9908", "19610": "40.338_-75.978", "19611": "40.325_-75.9442", "19612": "40.4389_-75.8853", "16601": "40.5209_-78.4089", "16602": "40.5052_-78.3905", "16603": "40.5018_-78.41", "16617": "40.6039_-78.3372", "16625": "40.2821_-78.5083", "16631": "40.2759_-78.3383", "16635": "40.4262_-78.4383", "16637": "40.3282_-78.4475", "16648": "40.4387_-78.3686", "16662": "40.2951_-78.3244", "16665": "40.3937_-78.4356", "16673": "40.3277_-78.3928", "16682": "40.2711_-78.4588", "16684": "40.6367_-78.3036", "16686": "40.6619_-78.2419", "16693": "40.4025_-78.2558", "16910": "41.7051_-76.8283", "16914": "41.8638_-76.7825", "16925": "41.9568_-76.7713", "16926": "41.6973_-76.7218", "16945": "41.8051_-76.8569", "16947": "41.7781_-76.7711", "17724": "41.6538_-76.8582", "17735": "41.6145_-76.8672", "18810": "41.949_-76.4889", "18814": "41.7817_-76.6056", "18815": "41.7312_-76.2347", "18817": "41.8645_-76.6255", "18829": "41.8434_-76.1796", "18831": "41.8966_-76.5328", "18832": "41.7135_-76.4872", "18833": "41.5987_-76.4398", "18837": "41.8634_-76.3015", "18840": "41.9842_-76.5218", "18845": "41.7718_-76.1717", "18846": "41.6041_-76.2598", "18848": "41.7638_-76.4645", "18850": "41.8408_-76.4876", "18851": "41.9394_-76.1964", "18853": "41.7015_-76.2754", "18854": "41.7826_-76.3834", "18039": "40.5757_-75.2232", "18077": "40.5782_-75.2191", "18081": "40.5565_-75.2893", "18901": "40.3054_-75.1489", "18902": "40.3477_-75.0968", "18910": "40.4259_-75.1791", "18911": "40.3695_-75.2482", "18912": "40.3237_-75.0599", "18913": "40.3865_-75.0627", "18914": "40.2892_-75.2149", "18916": "40.3545_-75.1327", "18917": "40.375_-75.2045", "18920": "40.5087_-75.0804", "18921": "40.5337_-75.1788", "18922": "40.2923_-75.0591", "18923": "40.3578_-75.1711", "18925": "40.2945_-75.0649", "18927": "40.3235_-75.2548", "18928": "40.336_-75.0429", "18929": "40.2566_-75.0961", "18930": "40.531_-75.2117", "18931": "40.3286_-75.1028", "18932": "40.2888_-75.2555", "18933": "40.3286_-75.1028", "18934": "40.3494_-75.0676", "18935": "40.437_-75.3988", "18938": "40.3556_-74.9839", "18940": "40.263_-74.9555", "18942": "40.4592_-75.157", "18943": "40.269_-75.0094", "18944": "40.3765_-75.2648", "18946": "40.2962_-75.0057", "18947": "40.4262_-75.1074", "18949": "40.388_-75.1425", "18950": "40.4226_-75.0663", "18951": "40.4411_-75.3507", "18953": "40.5154_-75.161", "18954": "40.2167_-75.0029", "18955": "40.4796_-75.3146", "18956": "40.2628_-75.0157", "18960": "40.362_-75.319", "18962": "40.3445_-75.2687", "18963": "40.3807_-75.0082", "18966": "40.1868_-75.0071", "18968": "40.439_-75.4371", "18970": "40.4107_-75.3782", "18972": "40.5411_-75.1259", "18974": "40.2067_-75.0905", "18976": "40.2464_-75.1354", "18977": "40.2849_-74.8778", "18980": "40.2742_-75.0205", "18981": "40.4843_-75.3938", "18991": "40.3286_-75.1028", "19007": "40.1159_-74.8536", "19020": "40.1109_-74.9378", "19021": "40.0933_-74.8991", "19030": "40.1748_-74.8519", "19047": "40.1813_-74.9104", "19048": "40.1735_-74.9246", "19049": "40.1746_-74.9227", "19053": "40.1547_-74.9904", "19054": "40.1681_-74.8231", "19055": "40.1483_-74.8371", "19056": "40.1519_-74.8826", "19057": "40.1434_-74.8614", "19058": "40.1551_-74.8288", "19067": "40.2084_-74.8291", "16001": "40.8859_-79.934", "16002": "40.8409_-79.8592", "16003": "40.8612_-79.8953", "16016": "41.1084_-79.8989", "16017": "40.9211_-79.9276", "16018": "40.9211_-79.9276", "16020": "41.1092_-79.9047", "16021": "41.0726_-79.9856", "16022": "41.0571_-79.7291", "16023": "40.7924_-79.76", "16024": "40.7406_-80.0364", "16025": "40.9458_-79.7462", "16027": "40.8178_-80.0142", "16029": "40.8778_-79.8464", "16030": "41.1348_-79.7981", "16033": "40.7808_-80.0592", "16034": "40.8555_-79.7372", "16035": "41.1068_-80.007", "16037": "40.8496_-80.1381", "16038": "41.1631_-79.9796", "16039": "40.8301_-79.8112", "16040": "41.1009_-79.8215", "16041": "41.0022_-79.716", "16045": "40.8528_-79.9167", "16046": "40.7005_-80.0358", "16048": "41.0472_-79.8089", "16050": "41.0442_-79.7711", "16051": "40.9468_-80.139", "16052": "40.9049_-80.0679", "16053": "40.81_-79.977", "16055": "40.7143_-79.7424", "16056": "40.7361_-79.8352", "16057": "41.0454_-80.0468", "16059": "40.7018_-79.9235", "16061": "41.0026_-79.8751", "16063": "40.7609_-80.1094", "16066": "40.685_-80.1071", "15714": "40.6661_-78.792", "15722": "40.5891_-78.7037", "15737": "40.6076_-78.7524", "15738": "40.6948_-78.787", "15760": "40.6522_-78.8054", "15762": "40.6016_-78.8114", "15773": "40.6298_-78.7329", "15775": "40.6351_-78.7692", "15901": "40.326_-78.9141", "15902": "40.3078_-78.8969", "15904": "40.285_-78.8654", "15905": "40.3072_-78.943", "15906": "40.3522_-78.9383", "15907": "40.3254_-78.9151", "15909": "40.4096_-78.8712", "15915": "40.3267_-78.922", "15921": "40.3173_-78.7009", "15922": "40.5176_-78.8767", "15925": "40.4085_-78.6407", "15927": "40.5383_-78.7865", "15930": "40.2939_-78.7192", "15931": "40.4801_-78.7263", "15934": "40.2799_-78.8032", "15938": "40.4238_-78.6231", "15940": "40.5105_-78.6294", "15942": "40.3793_-78.8352", "15943": "40.4704_-78.8375", "15945": "40.3612_-78.8709", "15946": "40.3724_-78.6328", "15948": "40.49_-78.7646", "15951": "40.337_-78.7709", "15952": "40.2986_-78.7816", "15955": "40.3299_-78.746", "15956": "40.3629_-78.7887", "15958": "40.389_-78.756", "15960": "40.4967_-78.8659", "15961": "40.4939_-78.9427", "15962": "40.3887_-78.7186", "16613": "40.5513_-78.5346", "16619": "40.6847_-78.4137", "16624": "40.5702_-78.5991", "16629": "40.5218_-78.5263", "16630": "40.4608_-78.5861", "16636": "40.6088_-78.5271", "16639": "40.6867_-78.4992", "16640": "40.6876_-78.5523", "16641": "40.4823_-78.5517", "16644": "40.7178_-78.4637", "16646": "40.6659_-78.7029", "16668": "40.623_-78.635", "16675": "40.6712_-78.6755", "16699": "40.4845_-78.7022", "15832": "41.3764_-78.1632", "15834": "41.5177_-78.2536", "15861": "41.3762_-78.0661", "18012": "40.8133_-75.592", "18030": "40.8011_-75.6614", "18071": "40.817_-75.6011", "18210": "40.9748_-75.5842", "18212": "40.7841_-75.7083", "18216": "40.9281_-75.9146", "18229": "40.87_-75.7397", "18230": "40.9234_-75.9416", "18232": "40.8314_-75.8828", "18235": "40.8299_-75.6974", "18240": "40.8626_-75.8239", "18244": "40.8181_-75.6727", "18250": "40.8255_-75.8693", "18254": "40.9159_-75.9657", "18255": "40.9411_-75.8306", "18624": "41.0542_-75.6331", "16677": "40.8136_-78.239", "16801": "40.7925_-77.8523", "16802": "40.7997_-77.8623", "16803": "40.8082_-77.8926", "16804": "40.7934_-77.86", "16805": "40.7934_-77.86", "16820": "40.8987_-77.4562", "16823": "40.8978_-77.7732", "16826": "41.0642_-77.5978", "16827": "40.7793_-77.7822", "16828": "40.8254_-77.6742", "16829": "41.0585_-77.9312", "16832": "40.8383_-77.4509", "16835": "40.9046_-77.8752", "16841": "41.0203_-77.6702", "16844": "40.8917_-77.9332", "16851": "40.8082_-77.8125", "16852": "40.9334_-77.495", "16853": "40.9417_-77.785", "16854": "40.8935_-77.4733", "16856": "40.9299_-77.6389", "16859": "41.0342_-78.0095", "16864": "40.9722_-77.7602", "16865": "40.71_-77.996", "16866": "40.8863_-78.219", "16868": "40.7337_-77.8856", "16870": "40.8018_-78.0788", "16872": "40.9549_-77.4053", "16874": "41.0376_-77.9523", "16875": "40.8578_-77.574", "16882": "40.9116_-77.3483", "19301": "40.0426_-75.4827", "19310": "39.9458_-75.9703", "19311": "39.8219_-75.7687", "19312": "40.0412_-75.4475", "19316": "40.055_-75.8378", "19318": "39.8524_-75.8118", "19320": "39.9843_-75.8253", "19330": "39.8757_-75.9214", "19333": "40.0452_-75.4227", "19335": "40.0161_-75.7183", "19341": "40.0468_-75.6432", "19343": "40.0846_-75.7711", "19344": "40.0832_-75.8843", "19345": "39.8478_-75.7193", "19346": "39.8087_-75.878", "19347": "39.749_-75.8241", "19348": "39.855_-75.7", "19350": "39.7696_-75.7807", "19351": "39.7226_-75.8749", "19352": "39.7787_-75.8876", "19353": "40.0132_-75.499", "19354": "40.0582_-75.7433", "19355": "40.0468_-75.531", "19357": "39.854_-75.6413", "19358": "39.9621_-75.8025", "19360": "39.7261_-75.7857", "19362": "39.7441_-76.0356", "19363": "39.7827_-75.9815", "19365": "39.9654_-75.926", "19366": "39.9004_-75.6258", "19367": "39.9643_-75.8866", "19369": "39.9903_-75.8936", "19371": "40.0995_-75.8791", "19372": "39.9984_-75.759", "19374": "39.8315_-75.7574", "19375": "39.8954_-75.7344", "19376": "39.9832_-75.7481", "19380": "39.9845_-75.5962", "19381": "39.961_-75.608", "19382": "39.9441_-75.5882", "19383": "39.961_-75.608", "19390": "39.8253_-75.8374", "19395": "39.9328_-75.5448", "19397": "39.9832_-75.7481", "19398": "39.9832_-75.7481", "19399": "39.9832_-75.7481", "19421": "39.9832_-75.7481", "19425": "40.0978_-75.6398", "19432": "40.0796_-75.56", "19442": "40.1307_-75.5721", "19457": "40.1995_-75.5838", "19460": "40.1267_-75.5272", "19465": "40.1919_-75.6653", "19470": "40.1867_-75.7288", "19475": "40.1765_-75.5697", "19480": "40.098_-75.688", "19481": "40.0923_-75.4537", "19482": "40.0803_-75.4554", "19493": "40.0971_-75.4696", "19494": "40.0971_-75.4696", "19495": "40.0971_-75.4696", "19496": "40.0971_-75.4696", "19520": "40.1568_-75.7866", "16028": "40.9744_-79.6302", "16036": "41.1431_-79.6798", "16054": "41.1617_-79.6528", "16058": "41.1853_-79.6134", "16213": "41.1259_-79.5584", "16214": "41.2123_-79.3773", "16220": "41.3898_-79.2709", "16221": "41.2023_-79.4538", "16224": "41.0429_-79.2784", "16225": "41.2665_-79.2425", "16230": "41.0178_-79.2799", "16232": "41.2245_-79.5194", "16233": "41.3671_-79.3022", "16234": "41.2023_-79.4538", "16235": "41.3124_-79.3754", "16240": "40.9906_-79.2617", "16242": "40.9999_-79.3527", "16248": "41.0411_-79.5017", "16254": "41.2475_-79.4332", "16255": "41.1139_-79.4805", "16257": "41.3328_-79.3556", "16258": "41.1955_-79.3082", "16260": "41.3957_-79.2266", "16326": "41.3717_-79.4134", "16331": "41.2926_-79.5655", "16332": "41.3789_-79.3715", "16334": "41.3261_-79.4459", "16361": "41.3848_-79.3223", "16375": "41.2226_-79.6339", "15721": "40.8134_-78.7865", "15753": "40.7876_-78.6514", "15757": "40.8875_-78.7353", "15801": "41.126_-78.7527", "15848": "41.0532_-78.7428", "15849": "41.2085_-78.5791", "15856": "41.0806_-78.6577", "15866": "41.0256_-78.7853", "16616": "40.7683_-78.4455", "16620": "40.8387_-78.3526", "16627": "40.7503_-78.5352", "16645": "40.7984_-78.4999", "16651": "40.8305_-78.3618", "16656": "40.8017_-78.5602", "16661": "40.8271_-78.4275", "16663": "40.7864_-78.367", "16666": "40.8722_-78.2757", "16671": "40.8015_-78.3998", "16680": "40.7507_-78.4012", "16681": "40.9891_-78.4224", "16692": "40.7615_-78.7355", "16698": "40.8251_-78.3511", "16821": "40.967_-78.2014", "16825": "40.9848_-78.3064", "16830": "41.021_-78.4435", "16833": "40.966_-78.5272", "16834": "41.0242_-78.1083", "16836": "41.1038_-78.2345", "16837": "40.9458_-78.475", "16838": "40.9818_-78.5949", "16839": "41.0036_-78.1104", "16840": "40.923_-78.2037", "16843": "41.003_-78.4642", "16845": "41.1136_-78.0875", "16847": "40.9934_-78.1672", "16849": "40.9605_-78.1144", "16850": "41.0831_-78.2833", "16855": "40.9981_-78.3636", "16858": "41.0001_-78.2357", "16860": "40.9468_-78.1718", "16861": "40.8652_-78.5237", "16863": "40.9056_-78.5001", "16871": "41.1868_-78.0341", "16873": "41.0692_-78.3581", "16876": "40.9616_-78.2926", "16878": "40.9493_-78.3129", "16879": "40.9696_-78.1508", "16881": "41.0098_-78.3214", "16822": "41.0845_-77.5851", "16848": "41.0162_-77.5311", "17721": "41.186_-77.3162", "17726": "41.1227_-77.4317", "17745": "41.1425_-77.4436", "17747": "41.0283_-77.3204", "17748": "41.1355_-77.37", "17750": "41.0545_-77.4614", "17751": "41.0867_-77.4836", "17760": "41.4083_-77.6641", "17764": "41.3334_-77.7448", "17778": "41.2745_-77.9315", "17779": "41.1948_-77.3764", "17814": "41.2231_-76.3406", "17815": "41.0115_-76.4384", "17820": "40.918_-76.4416", "17846": "41.1261_-76.5208", "17858": "40.8806_-76.4022", "17859": "41.1016_-76.381", "17878": "41.1515_-76.3696", "17888": "40.8121_-76.3929", "17920": "40.8167_-76.3503", "18603": "41.0665_-76.2443", "18631": "41.0323_-76.308", "16110": "41.5067_-80.3765", "16111": "41.5333_-80.2863", "16131": "41.5509_-80.3813", "16314": "41.5205_-80.0573", "16316": "41.6189_-80.3086", "16327": "41.6333_-79.9714", "16328": "41.6526_-79.727", "16335": "41.6338_-80.1488", "16354": "41.6382_-79.6855", "16360": "41.6856_-79.8767", "16388": "41.6596_-80.1576", "16403": "41.8034_-80.0594", "16404": "41.7243_-79.79", "16406": "41.7455_-80.3445", "16422": "41.6609_-80.3178", "16424": "41.6244_-80.4523", "16432": "41.7776_-79.8028", "16433": "41.7268_-80.1479", "16434": "41.7936_-79.6849", "16435": "41.8113_-80.3753", "16440": "41.764_-80.0982", "17001": "40.216_-76.925", "17007": "40.1449_-77.1195", "17011": "40.2352_-76.9291", "17012": "40.2398_-76.92", "17013": "40.2417_-77.1983", "17015": "40.1772_-77.2312", "17025": "40.2922_-76.9432", "17027": "40.158_-76.9964", "17043": "40.2469_-76.9001", "17050": "40.2122_-77.0265", "17055": "40.179_-77.0036", "17065": "40.1115_-77.1902", "17070": "40.2151_-76.8689", "17072": "40.2306_-77.0794", "17081": "40.203_-77.2848", "17089": "40.2697_-76.936", "17093": "40.3078_-76.9312", "17240": "40.1333_-77.5669", "17241": "40.1855_-77.4114", "17257": "40.0514_-77.5195", "17266": "40.086_-77.409", "17005": "40.601_-76.8117", "17018": "40.3846_-76.9283", "17023": "40.555_-76.8355", "17028": "40.3606_-76.6713", "17030": "40.6082_-76.7375", "17032": "40.476_-76.894", "17033": "40.2638_-76.6545", "17034": "40.2083_-76.7853", "17036": "40.2782_-76.7094", "17048": "40.5909_-76.7074", "17057": "40.2041_-76.7331", "17061": "40.5587_-76.9305", "17080": "40.6392_-76.8029", "17097": "40.5734_-76.6914", "17098": "40.5808_-76.6223", "17101": "40.2618_-76.8831", "17102": "40.2728_-76.891", "17103": "40.2724_-76.861", "17104": "40.2597_-76.8594", "17105": "40.2785_-76.8752", "17106": "40.2927_-76.8501", "17107": "40.297_-76.8764", "17108": "40.3086_-76.8017", "17109": "40.291_-76.8203", "17110": "40.303_-76.8862", "17111": "40.2721_-76.8017", "17112": "40.3352_-76.7914", "17113": "40.239_-76.8416", "17120": "40.2657_-76.8827", "17121": "40.2944_-76.8938", "17122": "40.2498_-76.8712", "17123": "40.2675_-76.8837", "17124": "40.2675_-76.886", "17125": "40.2662_-76.8829", "17126": "40.2618_-76.88", "17127": "40.2615_-76.8809", "17128": "40.2737_-76.8844", "17129": "40.2615_-76.8809", "17130": "40.2702_-76.8829", "17140": "40.3086_-76.8464", "17177": "40.299_-76.8472", "19003": "40.002_-75.2966", "19008": "39.9747_-75.3602", "19010": "40.0236_-75.3295", "19013": "39.8498_-75.3747", "19014": "39.8643_-75.4332", "19015": "39.8654_-75.3885", "19016": "39.934_-75.406", "19017": "39.8901_-75.4755", "19018": "39.9218_-75.2876", "19022": "39.8685_-75.3374", "19023": "39.9176_-75.2696", "19026": "39.9503_-75.304", "19028": "39.9748_-75.4505", "19029": "39.8621_-75.2971", "19032": "39.8905_-75.2821", "19033": "39.8901_-75.3296", "19036": "39.9048_-75.2946", "19037": "39.934_-75.406", "19039": "39.9432_-75.4694", "19041": "40.0097_-75.3121", "19043": "39.9003_-75.3087", "19050": "39.9375_-75.2637", "19052": "39.8942_-75.4456", "19060": "39.852_-75.5007", "19061": "39.8295_-75.4354", "19063": "39.9188_-75.3991", "19064": "39.9296_-75.3338", "19065": "39.9211_-75.3861", "19070": "39.9063_-75.3238", "19073": "39.9863_-75.407", "19074": "39.887_-75.2972", "19076": "39.8857_-75.3082", "19078": "39.8784_-75.3215", "19079": "39.9035_-75.2695", "19080": "40.044_-75.3877", "19081": "39.8967_-75.3474", "19082": "39.9579_-75.2681", "19083": "39.9774_-75.3106", "19085": "40.0399_-75.3459", "19086": "39.8871_-75.3721", "19087": "40.0612_-75.3999", "19088": "39.934_-75.406", "19089": "40.044_-75.3877", "19091": "39.934_-75.406", "19094": "39.876_-75.3463", "19098": "39.8954_-75.3107", "19113": "39.865_-75.2752", "19317": "39.8648_-75.5885", "19319": "39.9209_-75.5222", "19331": "39.8823_-75.5165", "19339": "39.934_-75.406", "19340": "39.8851_-75.5202", "19342": "39.9015_-75.5049", "19373": "39.9041_-75.5313", "15821": "41.3253_-78.3576", "15822": "41.3209_-78.6875", "15823": "41.2822_-78.7128", "15827": "41.2865_-78.5051", "15831": "41.3539_-78.6056", "15841": "41.2629_-78.5298", "15845": "41.4928_-78.6783", "15846": "41.3563_-78.6015", "15853": "41.3621_-78.7262", "15857": "41.4289_-78.5505", "15868": "41.2685_-78.4952", "15870": "41.5735_-78.6823", "16728": "41.4159_-78.6651", "16734": "41.6192_-78.8394", "16401": "41.8947_-80.3111", "16407": "41.9226_-79.6567", "16410": "41.9162_-80.3085", "16411": "41.9794_-80.4303", "16412": "41.8756_-80.1356", "16413": "41.9031_-79.7437", "16415": "42.0407_-80.2395", "16417": "41.9896_-80.3178", "16421": "42.1767_-79.9416", "16423": "42.0204_-80.3388", "16426": "41.999_-80.1473", "16427": "41.8773_-79.9692", "16428": "42.2008_-79.8332", "16430": "41.9999_-80.4258", "16438": "41.8939_-79.8455", "16441": "41.9603_-79.9996", "16442": "42.0391_-79.8363", "16443": "41.9465_-80.465", "16444": "41.8707_-80.1218", "16475": "41.8906_-80.3665", "16501": "42.126_-80.086", "16502": "42.1133_-80.0976", "16503": "42.1265_-80.064", "16504": "42.1108_-80.0521", "16505": "42.1109_-80.1534", "16506": "42.0738_-80.1484", "16507": "42.1316_-80.0864", "16508": "42.0976_-80.0935", "16509": "42.0763_-80.0668", "16510": "42.1087_-79.9535", "16511": "42.1553_-80.0177", "16512": "42.1292_-80.0851", "16514": "42.1827_-80.0649", "16515": "42.1827_-80.0649", "16522": "42.1292_-80.0851", "16530": "42.1292_-80.0851", "16531": "42.1827_-80.0649", "16534": "42.1292_-80.0851", "16538": "42.1292_-80.0851", "16541": "42.1292_-80.0851", "16544": "42.1827_-80.0649", "16546": "42.1827_-80.0649", "16550": "42.1292_-80.0851", "16553": "42.1292_-80.0851", "16563": "42.1192_-79.9865", "16565": "42.1827_-80.0649", "15012": "40.1588_-79.8122", "15401": "39.8897_-79.7282", "15410": "39.8965_-79.922", "15413": "39.9868_-79.8637", "15415": "39.9808_-79.8504", "15416": "39.857_-79.712", "15417": "40.0237_-79.8839", "15420": "39.9567_-79.8662", "15421": "39.8451_-79.5991", "15422": "39.9812_-79.8116", "15425": "40.0265_-79.5566", "15428": "40.0638_-79.6602", "15430": "40.0418_-79.66", "15431": "39.9722_-79.6431", "15433": "39.9822_-79.9664", "15435": "39.9434_-79.8495", "15436": "39.8229_-79.7551", "15437": "39.807_-79.5832", "15438": "40.0988_-79.8366", "15439": "39.7429_-79.8242", "15440": "39.7364_-79.5736", "15442": "40.0084_-79.8404", "15443": "39.9317_-79.8825", "15444": "40.012_-79.9088", "15445": "39.8728_-79.6568", "15446": "40.0248_-79.395", "15447": "39.946_-79.9393", "15449": "39.9636_-79.7853", "15450": "39.9983_-79.9754", "15451": "39.7501_-79.8618", "15454": "39.8615_-79.8701", "15455": "39.9985_-79.6435", "15456": "39.9311_-79.6477", "15458": "39.8882_-79.8694", "15459": "39.7597_-79.46", "15460": "39.8065_-79.9098", "15461": "39.8424_-79.9003", "15462": "40.052_-79.3892", "15463": "39.8825_-79.8336", "15464": "39.968_-79.4622", "15465": "39.9321_-79.6522", "15466": "40.0751_-79.8943", "15467": "39.7884_-79.9092", "15468": "39.9242_-79.8356", "15469": "40.0418_-79.4151", "15470": "39.8507_-79.523", "15472": "39.9183_-79.7158", "15473": "40.0646_-79.7756", "15474": "39.7351_-79.899", "15475": "39.9626_-79.8767", "15476": "39.8697_-79.9206", "15478": "39.7923_-79.8127", "15480": "39.9961_-79.7678", "15482": "40.0651_-79.769", "15484": "39.8936_-79.7856", "15486": "40.0246_-79.6955", "15488": "39.9763_-79.7689", "15489": "39.9561_-79.7007", "15490": "40.0726_-79.4251", "15492": "40.1194_-79.7623", "15631": "40.0911_-79.5873", "15828": "41.3233_-79.1466", "16217": "41.3384_-79.1971", "16239": "41.4622_-79.1306", "16321": "41.584_-79.4017", "16322": "41.5895_-79.385", "16353": "41.5116_-79.3663", "16370": "41.5687_-79.4081", "17201": "39.9313_-77.6579", "17202": "39.9072_-77.636", "17210": "40.1704_-77.6772", "17214": "39.7399_-77.4707", "17217": "40.2252_-77.725", "17219": "40.2184_-77.6797", "17220": "40.1781_-77.7353", "17221": "40.0717_-77.821", "17222": "39.9065_-77.531", "17224": "39.9547_-77.8984", "17225": "39.7818_-77.747", "17231": "39.8594_-77.8579", "17232": "40.1055_-77.6405", "17235": "39.8587_-77.6981", "17236": "39.8195_-77.9073", "17237": "39.8417_-77.5537", "17244": "40.0731_-77.6398", "17246": "40.0531_-77.6539", "17247": "39.7995_-77.5811", "17250": "39.7364_-77.5247", "17251": "40.1104_-77.6619", "17252": "39.9241_-77.7908", "17254": "39.9696_-77.5848", "17256": "39.7834_-77.6749", "17261": "39.8465_-77.4878", "17262": "40.1734_-77.7092", "17263": "39.7248_-77.7186", "17265": "40.058_-77.7368", "17268": "39.7635_-77.5674", "17271": "40.1137_-77.7969", "17272": "39.7714_-77.627", "15536": "39.92_-78.2258", "16689": "40.1276_-78.0628", "16691": "40.101_-78.1403", "17212": "39.8127_-78.0645", "17215": "40.0753_-77.9017", "17223": "40.078_-77.9532", "17228": "39.9761_-78.0841", "17229": "40.0441_-78.0148", "17233": "39.9443_-77.9901", "17238": "39.8713_-78.1439", "17267": "39.7698_-78.1986", "15310": "39.8246_-80.4579", "15315": "39.7612_-79.9814", "15316": "39.7245_-80.2537", "15320": "39.8825_-79.971", "15322": "39.9667_-80.0452", "15325": "39.9502_-79.9676", "15327": "39.7555_-79.9771", "15334": "39.8083_-79.9679", "15337": "39.9092_-80.3952", "15338": "39.8045_-79.9399", "15341": "39.8489_-80.3385", "15344": "39.9334_-80.0503", "15346": "39.9354_-80.0753", "15349": "39.774_-80.0246", "15351": "39.8779_-79.9258", "15352": "39.7507_-80.4542", "15353": "39.9615_-80.3078", "15357": "39.944_-79.9857", "15359": "39.8765_-80.2758", "15362": "39.7447_-80.2145", "15364": "39.9415_-80.2906", "15370": "39.8917_-80.1795", "15380": "39.8971_-80.4647", "16611": "40.5485_-78.0951", "16621": "40.2019_-78.1406", "16622": "40.3367_-78.0272", "16623": "40.294_-78.0272", "16634": "40.2054_-78.1814", "16638": "40.334_-78.1989", "16647": "40.4121_-78.1281", "16652": "40.5023_-78.005", "16654": "40.4848_-78.0103", "16657": "40.3567_-78.1887", "16660": "40.4025_-77.967", "16669": "40.603_-77.9984", "16674": "40.1787_-78.1117", "16683": "40.6218_-78.1361", "16685": "40.271_-78.0772", "16877": "40.7414_-78.0775", "17052": "40.3864_-77.9604", "17060": "40.4679_-77.8967", "17066": "40.3901_-77.8637", "17213": "40.2548_-77.7695", "17239": "40.1371_-77.858", "17243": "40.2389_-77.9069", "17249": "40.2414_-77.8995", "17253": "40.2133_-78.0069", "17255": "40.173_-77.868", "17260": "40.2979_-77.8742", "17264": "40.1834_-77.9941", "15681": "40.5429_-79.3978", "15701": "40.6196_-79.1596", "15705": "40.6215_-79.1525", "15710": "40.6303_-78.857", "15712": "40.7817_-78.8536", "15713": "40.5698_-79.2617", "15716": "40.4725_-79.1869", "15717": "40.4413_-79.2533", "15720": "40.5292_-79.0846", "15723": "40.7056_-79.1615", "15724": "40.7554_-78.8474", "15725": "40.5039_-79.3677", "15727": "40.5503_-79.3237", "15728": "40.6688_-79.0119", "15729": "40.7016_-78.9134", "15731": "40.4992_-79.1739", "15732": "40.7199_-79.2014", "15734": "40.7165_-79.007", "15739": "40.678_-79.1657", "15741": "40.8073_-78.8764", "15742": "40.8508_-78.8555", "15745": "40.6207_-78.9186", "15746": "40.7517_-78.885", "15747": "40.7834_-79.1641", "15748": "40.5245_-79.0843", "15750": "40.4828_-79.185", "15752": "40.5412_-79.282", "15754": "40.5567_-79.1515", "15756": "40.5684_-79.2999", "15758": "40.8576_-79.0228", "15759": "40.7814_-79.0252", "15761": "40.6373_-78.8823", "15763": "40.9037_-79.1257", "15765": "40.6213_-78.9943", "15771": "40.8308_-78.9892", "15772": "40.8846_-78.9414", "15777": "40.7027_-78.9588", "15783": "40.6026_-79.3537", "15920": "40.4603_-79.0097", "15929": "40.4665_-79.0025", "15949": "40.4042_-79.1395", "15957": "40.5727_-78.9", "16211": "40.7865_-79.2011", "16246": "40.7931_-79.1806", "16256": "40.8372_-79.1614", "15711": "41.0018_-78.9666", "15715": "40.9704_-78.8758", "15730": "41.0431_-79.0836", "15733": "41.1411_-78.9629", "15744": "40.9233_-79.0831", "15764": "40.9926_-79.0291", "15767": "40.9479_-78.9681", "15770": "40.9997_-79.1766", "15776": "41.0133_-79.114", "15778": "40.9684_-79.2014", "15780": "40.9159_-79.0448", "15781": "40.9651_-78.9948", "15784": "41.0238_-79.1387", "15824": "41.2406_-78.8116", "15825": "41.1627_-79.0816", "15829": "41.1762_-79.1976", "15840": "41.1455_-78.8128", "15847": "41.0862_-79.0264", "15851": "41.097_-78.8886", "15860": "41.3099_-79.054", "15863": "41.0126_-78.8373", "15864": "41.1058_-79.1726", "15865": "41.0514_-78.8195", "17014": "40.6479_-77.2125", "17021": "40.3542_-77.6528", "17035": "40.4309_-77.5761", "17049": "40.6469_-77.2602", "17056": "40.5373_-77.3543", "17058": "40.5695_-77.4028", "17059": "40.5727_-77.3761", "17076": "40.6147_-77.3192", "17082": "40.5107_-77.431", "17086": "40.6884_-77.1223", "17094": "40.5908_-77.2076", "18403": "41.4876_-75.5334", "18407": "41.5831_-75.5056", "18410": "41.4865_-75.6933", "18411": "41.4878_-75.7057", "18414": "41.5395_-75.7037", "18416": "41.3756_-75.548", "18420": "41.5981_-75.7146", "18433": "41.5744_-75.5881", "18434": "41.4724_-75.5689", "18440": "41.5516_-75.7676", "18444": "41.3432_-75.5301", "18447": "41.4677_-75.6015", "18448": "41.4649_-75.5962", "18452": "41.4821_-75.5899", "18471": "41.5238_-75.6906", "18501": "41.4019_-75.6376", "18502": "41.4092_-75.6649", "18503": "41.4095_-75.6642", "18504": "41.4128_-75.6861", "18505": "41.3914_-75.6657", "18507": "41.3554_-75.6805", "18508": "41.4389_-75.6625", "18509": "41.4274_-75.6465", "18510": "41.408_-75.6484", "18512": "41.435_-75.6103", "18515": "41.4035_-75.7065", "18517": "41.3904_-75.7158", "18518": "41.3701_-75.7391", "18519": "41.4092_-75.6649", "18540": "41.4019_-75.6376", "18577": "41.4019_-75.6376", "18653": "41.3945_-75.8242", "17022": "40.1553_-76.6025", "17501": "40.1573_-76.2042", "17502": "40.1086_-76.6726", "17503": "40.0185_-76.2976", "17504": "40.024_-76.3281", "17505": "40.0561_-76.183", "17506": "40.1173_-76.0524", "17507": "40.1966_-76.016", "17508": "40.124_-76.2176", "17509": "39.904_-76.0401", "17512": "40.0391_-76.4862", "17516": "39.9403_-76.3575", "17517": "40.2297_-76.1157", "17518": "39.8183_-76.2499", "17519": "40.1395_-76.0276", "17520": "40.1008_-76.3512", "17521": "40.2044_-76.3464", "17522": "40.1756_-76.1821", "17527": "40.002_-75.9978", "17528": "40.1257_-76.0033", "17529": "40.0353_-76.1106", "17532": "39.8631_-76.3008", "17533": "40.2339_-76.2607", "17534": "40.0367_-76.1069", "17535": "40.0053_-76.0493", "17536": "39.8257_-76.0933", "17537": "39.9885_-76.2387", "17538": "40.0892_-76.4156", "17540": "40.0964_-76.1921", "17543": "40.1846_-76.3015", "17545": "40.1702_-76.4168", "17547": "40.0664_-76.5645", "17549": "40.1545_-76.0876", "17550": "40.0754_-76.5822", "17551": "39.9982_-76.3566", "17552": "40.1083_-76.5103", "17554": "40.0427_-76.4277", "17555": "40.1252_-75.9756", "17557": "40.1005_-76.0801", "17560": "39.9098_-76.2243", "17562": "39.9852_-76.1081", "17563": "39.7705_-76.1791", "17564": "40.0185_-76.2976", "17565": "39.9058_-76.3209", "17566": "39.8949_-76.1465", "17567": "40.2099_-76.1164", "17568": "39.9469_-76.2322", "17569": "40.2688_-76.1013", "17570": "40.1301_-76.5705", "17572": "40.0208_-76.1661", "17573": "40.0262_-76.1686", "17575": "40.0647_-76.4343", "17576": "40.0376_-76.1969", "17578": "40.2194_-76.1626", "17579": "39.9701_-76.1848", "17580": "40.1168_-76.2131", "17581": "40.1585_-76.0511", "17582": "39.9881_-76.4402", "17583": "39.9723_-76.2873", "17584": "39.967_-76.2752", "17585": "40.0484_-76.2114", "17601": "40.0766_-76.3107", "17602": "40.0335_-76.2844", "17603": "40.0091_-76.3671", "17604": "40.0651_-76.3356", "17605": "40.0185_-76.2976", "17606": "40.1102_-76.3054", "17607": "40.0185_-76.2976", "17608": "40.0185_-76.2976", "17611": "40.0379_-76.3055", "17622": "40.0418_-76.3012", "17699": "40.0185_-76.2976", "19501": "40.2423_-76.0577", "16101": "40.9922_-80.3284", "16102": "40.9677_-80.3907", "16103": "40.9897_-80.3084", "16105": "41.0241_-80.3454", "16107": "40.9897_-80.3084", "16108": "40.9897_-80.3084", "16112": "40.9755_-80.4937", "16116": "41.0276_-80.4632", "16117": "40.8729_-80.2559", "16120": "40.8721_-80.4612", "16132": "41.0113_-80.4975", "16140": "41.0973_-80.5048", "16142": "41.1382_-80.3245", "16143": "41.0942_-80.4685", "16155": "41.0737_-80.5073", "16156": "41.0938_-80.2441", "16157": "40.8819_-80.3392", "16160": "40.9301_-80.3611", "16172": "41.12_-80.3332", "17003": "40.3456_-76.5447", "17010": "40.2776_-76.5852", "17016": "40.2755_-76.4053", "17026": "40.4524_-76.4267", "17038": "40.4361_-76.5038", "17039": "40.3005_-76.2584", "17041": "40.2236_-76.538", "17042": "40.3316_-76.3976", "17046": "40.3812_-76.4368", "17064": "40.2476_-76.4711", "17067": "40.3789_-76.3143", "17073": "40.3495_-76.2133", "17077": "40.4029_-76.5347", "17078": "40.3011_-76.5886", "17083": "40.2796_-76.4397", "17085": "40.2771_-76.3857", "17087": "40.3806_-76.2654", "17088": "40.2984_-76.2944", "18011": "40.5145_-75.6029", "18025": "40.6259_-75.3705", "18031": "40.5526_-75.6553", "18032": "40.6557_-75.4693", "18034": "40.5396_-75.4242", "18036": "40.5076_-75.3888", "18037": "40.6701_-75.4955", "18046": "40.5476_-75.5613", "18049": "40.5293_-75.501", "18051": "40.593_-75.6568", "18052": "40.6567_-75.5041", "18053": "40.7118_-75.7147", "18059": "40.7177_-75.5335", "18060": "40.509_-75.4471", "18062": "40.5285_-75.5666", "18065": "40.6967_-75.6116", "18066": "40.6545_-75.7417", "18068": "40.4865_-75.5202", "18069": "40.6248_-75.5974", "18078": "40.6819_-75.6239", "18079": "40.7455_-75.6592", "18080": "40.7345_-75.6186", "18087": "40.5482_-75.5961", "18092": "40.4734_-75.5261", "18098": "40.5395_-75.4969", "18099": "40.5395_-75.4969", "18101": "40.6026_-75.4691", "18102": "40.6068_-75.4781", "18103": "40.5891_-75.4645", "18104": "40.6018_-75.5225", "18105": "40.6084_-75.4902", "18106": "40.5824_-75.5911", "18109": "40.6366_-75.4405", "18195": "40.5843_-75.6248", "18201": "40.9488_-75.9563", "18202": "40.9506_-76.0487", "18219": "40.9907_-76.0564", "18221": "41.0016_-75.9057", "18222": "41.0255_-75.9768", "18223": "40.9862_-75.9413", "18224": "41.0196_-75.888", "18225": "40.9806_-75.9713", "18234": "40.9925_-75.9626", "18239": "40.9961_-75.9815", "18246": "40.9654_-76.1844", "18247": "41.0281_-76.006", "18249": "40.9971_-76.0717", "18251": "41.0015_-76.0763", "18256": "40.9448_-76.1452", "18601": "41.0684_-76.1758", "18602": "41.1922_-75.7161", "18611": "41.1981_-76.3058", "18612": "41.3494_-75.9834", "18617": "41.1746_-76.0746", "18618": "41.3592_-76.0451", "18621": "41.2459_-76.0879", "18622": "41.1906_-76.2335", "18627": "41.3166_-76.021", "18634": "41.1963_-76.0044", "18635": "41.0469_-76.1981", "18640": "41.3175_-75.7885", "18641": "41.3361_-75.7304", "18642": "41.3486_-75.7611", "18643": "41.3665_-75.8362", "18644": "41.3197_-75.8541", "18651": "41.2458_-75.9481", "18654": "41.3501_-76.0319", "18655": "41.1513_-76.1081", "18656": "41.3066_-76.1339", "18660": "41.068_-76.0857", "18661": "41.079_-75.7715", "18690": "41.3362_-75.9633", "18701": "41.2436_-75.885", "18702": "41.2208_-75.7736", "18703": "41.2421_-75.8857", "18704": "41.2742_-75.8903", "18705": "41.2689_-75.8453", "18706": "41.2044_-75.9113", "18707": "41.135_-75.9376", "18708": "41.2998_-75.9711", "18709": "41.2843_-75.8935", "18710": "41.2722_-75.8801", "18711": "41.2722_-75.8801", "18762": "41.2722_-75.8801", "18764": "41.2722_-75.8801", "18765": "41.2722_-75.8801", "18766": "41.2448_-75.8896", "18767": "41.2722_-75.8801", "18769": "41.2722_-75.8801", "18773": "41.2722_-75.8801", "17701": "41.2412_-77.0011", "17702": "41.1943_-77.0547", "17703": "41.2412_-77.0011", "17705": "41.3327_-77.0236", "17720": "41.1865_-77.2184", "17723": "41.432_-77.4562", "17727": "41.5299_-77.4917", "17728": "41.3152_-77.069", "17737": "41.256_-76.7141", "17739": "41.3573_-77.4066", "17740": "41.247_-77.2706", "17742": "41.2359_-76.605", "17744": "41.2472_-77.1527", "17752": "41.1788_-76.8839", "17754": "41.2663_-76.903", "17756": "41.2137_-76.7633", "17762": "41.2798_-76.713", "17763": "41.5038_-76.9583", "17769": "41.4728_-77.5016", "17771": "41.4125_-77.0098", "17774": "41.2436_-76.5183", "17776": "41.3114_-77.3604", "16333": "41.7284_-78.9434", "16701": "41.9547_-78.654", "16724": "41.7451_-78.3903", "16725": "41.9059_-78.6517", "16726": "41.8186_-78.5957", "16727": "41.9726_-78.5626", "16729": "41.954_-78.4923", "16730": "41.8087_-78.4195", "16731": "41.9489_-78.3884", "16732": "41.8581_-78.5964", "16733": "41.7059_-78.5825", "16735": "41.6619_-78.7978", "16738": "41.8211_-78.6805", "16740": "41.7247_-78.6446", "16743": "41.8169_-78.2799", "16744": "41.9015_-78.5392", "16745": "41.9262_-78.4942", "16749": "41.8021_-78.4702", "16750": "41.8847_-78.3308", "16113": "41.2866_-80.4237", "16114": "41.3931_-80.1837", "16121": "41.211_-80.4944", "16124": "41.3241_-80.2699", "16125": "41.4057_-80.3739", "16127": "41.1607_-80.0841", "16130": "41.4432_-80.2153", "16133": "41.2801_-80.1037", "16134": "41.4566_-80.4492", "16137": "41.2325_-80.234", "16145": "41.3383_-80.0497", "16146": "41.2316_-80.4993", "16148": "41.2326_-80.453", "16150": "41.2676_-80.4656", "16151": "41.4435_-80.2055", "16153": "41.3439_-80.0976", "16154": "41.3244_-80.4197", "16159": "41.1741_-80.4528", "16161": "41.2009_-80.4978", "16311": "41.4815_-80.0203", "17002": "40.5075_-77.8392", "17004": "40.6016_-77.7358", "17009": "40.6361_-77.5625", "17029": "40.5537_-77.6255", "17044": "40.5994_-77.5756", "17051": "40.5046_-77.7186", "17054": "40.496_-77.7237", "17063": "40.7203_-77.5567", "17075": "40.3931_-77.8316", "17084": "40.6722_-77.6116", "17099": "40.6431_-77.5805", "18058": "40.8999_-75.476", "18301": "41.0367_-75.1735", "18320": "41.0712_-75.2364", "18321": "41.008_-75.2967", "18322": "40.9309_-75.4104", "18323": "41.1879_-75.2657", "18325": "41.2338_-75.2573", "18326": "41.154_-75.2805", "18327": "40.9793_-75.143", "18330": "40.9669_-75.4523", "18331": "40.9089_-75.4314", "18332": "41.0889_-75.2798", "18333": "40.8982_-75.5074", "18334": "41.0677_-75.4482", "18335": "41.0508_-75.2083", "18341": "41.0004_-75.1371", "18342": "41.1737_-75.271", "18344": "41.1216_-75.3529", "18346": "41.1353_-75.4079", "18347": "41.1187_-75.5559", "18348": "41.0338_-75.308", "18349": "41.1001_-75.3588", "18350": "41.1054_-75.476", "18352": "41.019_-75.336", "18353": "40.8965_-75.367", "18354": "40.9257_-75.325", "18355": "41.0751_-75.3265", "18356": "41.0123_-75.1107", "18357": "41.2336_-75.2389", "18360": "40.9877_-75.2485", "18370": "41.0879_-75.3483", "18372": "41.0472_-75.3244", "18466": "41.1836_-75.3918", "18610": "41.0485_-75.5343", "18041": "40.4119_-75.5056", "18054": "40.3534_-75.4351", "18070": "40.4317_-75.5331", "18073": "40.3911_-75.4866", "18074": "40.3157_-75.5022", "18076": "40.3758_-75.4846", "18084": "40.3278_-75.454", "18915": "40.2728_-75.2563", "18918": "40.32_-75.3742", "18924": "40.3081_-75.3586", "18936": "40.2241_-75.231", "18957": "40.3029_-75.4486", "18958": "40.2904_-75.4355", "18964": "40.2884_-75.341", "18969": "40.3205_-75.352", "18971": "40.347_-75.377", "18979": "40.3107_-75.4488", "19001": "40.1238_-75.1148", "19002": "40.1809_-75.2156", "19004": "40.0118_-75.2342", "19006": "40.1284_-75.0607", "19009": "40.135_-75.0623", "19012": "40.0603_-75.1048", "19025": "40.1431_-75.1624", "19027": "40.075_-75.1315", "19031": "40.1068_-75.2115", "19034": "40.1386_-75.2022", "19035": "40.0451_-75.2821", "19038": "40.1096_-75.155", "19040": "40.1785_-75.1072", "19044": "40.1821_-75.1479", "19046": "40.098_-75.1078", "19066": "40.003_-75.2503", "19072": "40.0177_-75.2594", "19075": "40.1132_-75.1869", "19090": "40.1567_-75.1269", "19095": "40.0867_-75.1524", "19096": "40_-75.276", "19126": "40.0568_-75.1379", "19401": "40.1245_-75.3304", "19403": "40.1496_-75.3796", "19404": "40.2119_-75.3559", "19405": "40.103_-75.3402", "19406": "40.0956_-75.3737", "19407": "40.2119_-75.3559", "19408": "40.1566_-75.4131", "19409": "40.1579_-75.3871", "19415": "40.1572_-75.406", "19422": "40.1576_-75.2799", "19423": "40.2174_-75.365", "19424": "40.1523_-75.2663", "19426": "40.1913_-75.4373", "19428": "40.0825_-75.3044", "19429": "40.0793_-75.3016", "19430": "40.1851_-75.42", "19435": "40.3275_-75.5692", "19436": "40.2021_-75.2507", "19437": "40.1811_-75.2579", "19438": "40.2659_-75.3883", "19440": "40.2778_-75.2975", "19441": "40.2795_-75.3871", "19443": "40.241_-75.3439", "19444": "40.0896_-75.2601", "19446": "40.2378_-75.2955", "19450": "40.2119_-75.3559", "19451": "40.2119_-75.3559", "19453": "40.1364_-75.4999", "19454": "40.2166_-75.2565", "19455": "40.2109_-75.2782", "19456": "40.1318_-75.4596", "19462": "40.1077_-75.2796", "19464": "40.2635_-75.6172", "19468": "40.2075_-75.5329", "19472": "40.3448_-75.5775", "19473": "40.2471_-75.4602", "19474": "40.2251_-75.4031", "19477": "40.1839_-75.2327", "19478": "40.2759_-75.4618", "19484": "40.2119_-75.3559", "19486": "40.2033_-75.3019", "19490": "40.1929_-75.3576", "19492": "40.2901_-75.503", "19525": "40.3059_-75.5953", "17821": "40.9799_-76.6229", "17822": "40.9674_-76.6049", "17884": "41.0518_-76.6747", "18001": "40.6934_-75.4712", "18002": "40.6656_-75.4262", "18003": "40.6934_-75.4712", "18013": "40.853_-75.1718", "18014": "40.7551_-75.4086", "18015": "40.6002_-75.3805", "18016": "40.6934_-75.4712", "18017": "40.6622_-75.3903", "18018": "40.6278_-75.3928", "18020": "40.6693_-75.3349", "18035": "40.751_-75.5394", "18038": "40.7866_-75.5186", "18040": "40.7449_-75.2217", "18042": "40.6516_-75.224", "18043": "40.6884_-75.2207", "18044": "40.6884_-75.2207", "18045": "40.6957_-75.2865", "18055": "40.5817_-75.3255", "18063": "40.7825_-75.1735", "18064": "40.745_-75.3199", "18067": "40.6998_-75.4874", "18072": "40.8518_-75.2701", "18083": "40.754_-75.2621", "18085": "40.7406_-75.2549", "18086": "40.7361_-75.5449", "18088": "40.7615_-75.5657", "18091": "40.8169_-75.3264", "18343": "40.9008_-75.1115", "18351": "40.9214_-75.097", "17017": "40.6483_-76.8797", "17730": "41.1092_-76.8766", "17749": "41.072_-76.8184", "17772": "41.1119_-76.7425", "17777": "41.102_-76.8532", "17801": "40.8551_-76.7776", "17823": "40.7571_-76.7626", "17824": "40.8639_-76.5569", "17830": "40.6918_-76.8008", "17832": "40.8046_-76.4651", "17834": "40.7933_-76.4744", "17836": "40.7101_-76.6271", "17840": "40.7727_-76.4383", "17847": "41.0168_-76.8398", "17850": "40.9661_-76.8575", "17851": "40.7955_-76.4195", "17857": "40.9044_-76.7908", "17860": "40.8448_-76.635", "17865": "40.9937_-76.7891", "17866": "40.7917_-76.5519", "17867": "40.7141_-76.6886", "17868": "40.9529_-76.6311", "17872": "40.789_-76.5588", "17877": "40.879_-76.6673", "17881": "40.7819_-76.6702", "17006": "40.3293_-77.5117", "17020": "40.4087_-77.0473", "17024": "40.4096_-77.3121", "17037": "40.4363_-77.397", "17040": "40.3326_-77.3191", "17045": "40.5753_-77.0083", "17047": "40.3658_-77.4138", "17053": "40.3351_-76.9722", "17062": "40.5505_-77.1298", "17068": "40.4193_-77.1938", "17069": "40.4543_-76.9697", "17071": "40.309_-77.5697", "17074": "40.4827_-77.1659", "17090": "40.3299_-77.1809", "19019": "40.0018_-75.1179", "19092": "40.0018_-75.1179", "19093": "40.0018_-75.1179", "19099": "39.9523_-75.1638", "19101": "40.0018_-75.1179", "19102": "39.9489_-75.1661", "19103": "39.9513_-75.1741", "19104": "39.9597_-75.2024", "19105": "39.9523_-75.1638", "19106": "39.9474_-75.1473", "19107": "39.9487_-75.1593", "19108": "39.9598_-75.1616", "19109": "39.9496_-75.1637", "19110": "39.9502_-75.1636", "19111": "40.0596_-75.0818", "19112": "39.8893_-75.1782", "19114": "40.0634_-74.999", "19115": "40.0903_-75.041", "19116": "40.1166_-75.0198", "19118": "40.0723_-75.2034", "19119": "40.0547_-75.1866", "19120": "40.0343_-75.1213", "19121": "39.9811_-75.174", "19122": "39.978_-75.1459", "19123": "39.966_-75.151", "19124": "40.0178_-75.0895", "19125": "39.9788_-75.1262", "19127": "40.0275_-75.2242", "19128": "40.0402_-75.2231", "19129": "40.0118_-75.1861", "19130": "39.9677_-75.1735", "19131": "39.9845_-75.2282", "19132": "39.9954_-75.1698", "19133": "39.9925_-75.1415", "19134": "39.9925_-75.1133", "19135": "40.0247_-75.0518", "19136": "40.0422_-75.0244", "19137": "40.0008_-75.0727", "19138": "40.0568_-75.1569", "19139": "39.9612_-75.2303", "19140": "40.0118_-75.1456", "19141": "40.0365_-75.1451", "19142": "39.9223_-75.2338", "19143": "39.9448_-75.2288", "19144": "40.0338_-75.1731", "19145": "39.9227_-75.1812", "19146": "39.9379_-75.1794", "19147": "39.9362_-75.1563", "19148": "39.9207_-75.1595", "19149": "40.0369_-75.0664", "19150": "40.0726_-75.1706", "19151": "39.9772_-75.2545", "19152": "40.0606_-75.0471", "19153": "39.9055_-75.2444", "19154": "40.0897_-74.9781", "19155": "40.0018_-75.1179", "19160": "40.0018_-75.1179", "19161": "40.0018_-75.1179", "19162": "40.0018_-75.1179", "19170": "40.0018_-75.1179", "19171": "39.9523_-75.1638", "19172": "39.9473_-75.15", "19173": "39.9523_-75.1638", "19175": "39.9906_-75.1296", "19176": "39.9522_-75.1642", "19177": "40.0018_-75.1179", "19178": "40.0018_-75.1179", "19179": "40.0018_-75.1179", "19181": "40.0018_-75.1179", "19182": "40.0018_-75.1179", "19183": "39.9523_-75.1638", "19184": "40.0018_-75.1179", "19185": "40.0018_-75.1179", "19187": "39.9523_-75.1638", "19188": "40.0018_-75.1179", "19190": "39.9484_-75.1442", "19191": "39.9523_-75.1638", "19192": "39.9511_-75.1676", "19193": "40.0018_-75.1179", "19194": "40.0018_-75.1179", "19195": "39.9525_-75.1645", "19196": "40.0018_-75.1179", "19197": "40.0018_-75.1179", "19244": "40.0018_-75.1179", "19255": "40.0018_-75.1179", "18302": "41.0936_-75.1187", "18324": "41.1285_-75.0132", "18328": "41.24_-74.938", "18336": "41.3674_-74.7154", "18337": "41.3228_-74.8824", "18340": "41.4093_-74.7432", "18371": "41.1423_-75.0271", "18425": "41.4372_-75.0125", "18426": "41.3321_-75.2819", "18435": "41.482_-74.986", "18451": "41.3962_-75.1963", "18457": "41.4719_-75.0485", "18458": "41.4182_-74.918", "18464": "41.4045_-75.183", "16720": "41.6296_-78.0908", "16746": "41.7738_-78.1538", "16748": "41.9572_-78.1906", "16915": "41.7762_-77.9567", "16922": "41.723_-77.6548", "16923": "41.9401_-77.8725", "16927": "41.9587_-77.6587", "16937": "41.9656_-77.7111", "16941": "41.9883_-77.758", "16948": "41.8459_-77.7126", "17729": "41.4737_-77.8095", "17901": "40.684_-76.2123", "17921": "40.7732_-76.343", "17922": "40.5962_-76.1344", "17923": "40.6643_-76.3328", "17925": "40.7508_-76.0629", "17929": "40.6284_-76.195", "17930": "40.7114_-76.1392", "17931": "40.7825_-76.2311", "17932": "40.784_-76.2302", "17933": "40.6026_-76.2408", "17934": "40.7986_-76.2155", "17935": "40.7922_-76.2858", "17936": "40.7489_-76.3355", "17938": "40.6669_-76.4732", "17941": "40.6676_-76.6507", "17943": "40.7634_-76.3827", "17944": "40.6729_-76.2791", "17945": "40.7773_-76.3761", "17946": "40.8081_-76.2407", "17948": "40.8123_-76.1396", "17949": "40.794_-76.2433", "17951": "40.683_-76.2387", "17952": "40.7473_-76.0628", "17953": "40.7331_-76.0858", "17954": "40.6904_-76.2597", "17957": "40.5926_-76.5161", "17959": "40.7195_-76.1158", "17960": "40.7149_-75.9484", "17961": "40.6431_-76.084", "17963": "40.5671_-76.3269", "17964": "40.7049_-76.5233", "17965": "40.6977_-76.166", "17966": "40.5745_-76.4038", "17967": "40.8559_-76.2349", "17968": "40.6352_-76.6128", "17970": "40.7193_-76.1924", "17972": "40.6306_-76.17", "17974": "40.6954_-76.2338", "17976": "40.8167_-76.2035", "17978": "40.6258_-76.6218", "17979": "40.5545_-76.2038", "17980": "40.5845_-76.55", "17981": "40.6343_-76.3905", "17982": "40.7815_-76.0134", "17983": "40.6445_-76.5448", "17985": "40.9141_-76.1931", "18211": "40.7465_-75.8342", "18214": "40.8138_-76.0611", "18218": "40.8219_-75.9104", "18220": "40.8389_-76.0694", "18231": "40.9002_-76.0054", "18237": "40.8979_-75.9971", "18241": "40.9395_-76.1716", "18242": "40.911_-76.1223", "18245": "40.8518_-76.036", "18248": "40.902_-76.1188", "18252": "40.7983_-75.9735", "19549": "40.5818_-76.0267", "17812": "40.7528_-77.2318", "17813": "40.7774_-77.1691", "17827": "40.765_-76.9395", "17831": "40.8344_-76.8354", "17833": "40.8031_-76.9639", "17841": "40.6991_-77.3758", "17842": "40.7977_-77.0468", "17843": "40.7462_-77.2094", "17853": "40.7237_-77.0135", "17861": "40.7725_-77.0833", "17862": "40.8598_-77.0553", "17864": "40.6996_-76.9082", "17870": "40.8224_-76.8683", "17876": "40.8459_-76.8224", "17882": "40.8031_-77.2053", "15411": "39.7476_-79.3454", "15424": "39.8129_-79.3567", "15485": "39.8173_-79.3306", "15501": "40.0248_-79.0808", "15502": "40.046_-79.2585", "15510": "39.9633_-79.0409", "15520": "40.1104_-79.0689", "15530": "39.9188_-78.9637", "15531": "40.1918_-79.0362", "15532": "39.7673_-79.062", "15538": "39.868_-78.8362", "15540": "39.7961_-79.2472", "15541": "40.011_-78.9033", "15542": "39.8646_-79.0616", "15544": "40.1377_-79.0926", "15546": "40.1431_-79.0428", "15547": "40.1595_-79.0616", "15548": "40.1011_-78.9387", "15549": "40.0208_-79.0123", "15551": "39.8691_-79.2879", "15552": "39.7905_-79.0261", "15553": "39.9828_-78.7719", "15555": "40.0914_-79.0872", "15557": "39.9373_-79.1865", "15558": "39.7531_-79.0835", "15560": "40.0171_-78.9077", "15561": "40.0964_-79.0902", "15562": "39.748_-79.1237", "15563": "40.0948_-78.9658", "15564": "39.7299_-78.8441", "15565": "39.7542_-79.095", "15924": "40.1149_-78.7851", "15926": "40.0913_-78.8448", "15928": "40.2245_-78.9363", "15935": "40.2343_-78.9515", "15936": "40.1488_-78.9141", "15937": "40.2084_-78.9873", "15953": "40.212_-78.8984", "15959": "40.268_-78.9156", "15963": "40.2287_-78.8303", "17731": "41.4109_-76.5819", "17758": "41.3426_-76.5852", "17768": "41.5536_-76.7455", "18614": "41.5232_-76.4021", "18616": "41.5269_-76.6008", "18619": "41.4482_-76.6979", "18626": "41.4329_-76.5169", "18628": "41.418_-76.3002", "18632": "41.4792_-76.3831", "18413": "41.649_-75.5988", "18421": "41.6515_-75.4666", "18430": "41.742_-75.4894", "18441": "41.6595_-75.6282", "18465": "41.834_-75.5342", "18470": "41.7079_-75.5465", "18801": "41.8396_-75.8821", "18812": "41.9666_-75.9375", "18813": "41.7512_-75.8069", "18816": "41.7465_-75.8983", "18818": "41.9164_-76.0257", "18820": "41.8034_-75.6441", "18821": "41.9717_-75.7432", "18822": "41.9598_-75.7826", "18823": "41.7761_-75.6935", "18824": "41.6932_-75.7897", "18825": "41.8203_-75.8046", "18826": "41.7659_-75.7831", "18827": "41.957_-75.5849", "18828": "41.7573_-76.0912", "18830": "41.9766_-76.1185", "18834": "41.8664_-75.7171", "18842": "41.7342_-75.6302", "18843": "41.7973_-75.8913", "18844": "41.7147_-75.9025", "18847": "41.9487_-75.5862", "16901": "41.7373_-77.308", "16911": "41.6626_-77.123", "16912": "41.6698_-77.0797", "16917": "41.7448_-77.0772", "16920": "41.9882_-77.3134", "16921": "41.7471_-77.568", "16928": "41.9596_-77.4357", "16929": "41.9783_-77.1136", "16930": "41.5656_-77.1195", "16932": "41.784_-76.9983", "16933": "41.8123_-77.0716", "16935": "41.8664_-77.3128", "16936": "41.9625_-76.9748", "16938": "41.5475_-77.292", "16939": "41.6775_-77.0152", "16940": "41.9787_-77.2419", "16942": "41.9848_-77.354", "16943": "41.8408_-77.6155", "16946": "41.9125_-77.1393", "16950": "41.9193_-77.523", "17765": "41.5692_-76.9421", "17810": "41.1264_-76.9724", "17829": "40.9005_-77.1558", "17835": "40.8831_-77.1986", "17837": "40.9702_-76.9099", "17844": "40.9218_-77.0505", "17845": "40.8803_-77.1941", "17855": "40.8802_-76.9861", "17856": "41.0541_-76.9019", "17880": "40.8923_-77.1266", "17883": "40.9387_-76.988", "17885": "40.8584_-77.2953", "17886": "41.0179_-76.8708", "17887": "41.0759_-76.8747", "17889": "40.8908_-76.8718", "16301": "41.4319_-79.6916", "16317": "41.498_-79.8757", "16319": "41.3197_-79.6317", "16323": "41.4048_-79.8309", "16341": "41.5867_-79.5685", "16342": "41.3583_-79.9346", "16343": "41.411_-79.7493", "16344": "41.4717_-79.6881", "16346": "41.3744_-79.6759", "16362": "41.4798_-79.9403", "16364": "41.3761_-79.5048", "16372": "41.2002_-79.8734", "16373": "41.2028_-79.747", "16374": "41.2848_-79.7393", "16312": "41.9358_-79.3097", "16313": "41.7302_-79.1719", "16329": "41.8117_-79.2643", "16340": "41.8366_-79.4196", "16345": "41.9461_-79.1271", "16347": "41.7005_-79.0348", "16350": "41.9475_-79.3186", "16351": "41.703_-79.3752", "16352": "41.7434_-79.0528", "16365": "41.8436_-79.1726", "16366": "41.8439_-79.145", "16367": "41.8439_-79.145", "16368": "41.8117_-79.2643", "16369": "41.8117_-79.2643", "16371": "41.8537_-79.3187", "16402": "41.9701_-79.4614", "16405": "41.9382_-79.5731", "16416": "41.8188_-79.4463", "16420": "41.6963_-79.5473", "16436": "41.92_-79.4482", "15004": "40.3413_-80.3822", "15019": "40.4051_-80.3622", "15021": "40.3821_-80.4044", "15022": "40.1404_-79.92", "15033": "40.1768_-79.8619", "15038": "40.2521_-79.9252", "15053": "40.38_-80.3605", "15054": "40.3625_-80.4086", "15055": "40.3058_-80.1219", "15057": "40.3697_-80.2562", "15060": "40.368_-80.2921", "15063": "40.1937_-79.9241", "15067": "40.2066_-79.9534", "15078": "40.3584_-80.3879", "15301": "40.1717_-80.256", "15311": "40.0498_-80.1681", "15312": "40.2734_-80.4565", "15313": "40.0655_-80.0221", "15314": "40.1187_-80.007", "15317": "40.2706_-80.1668", "15321": "40.3234_-80.1879", "15323": "40.1179_-80.4103", "15324": "40.1008_-80.0652", "15329": "40.0224_-80.2613", "15330": "40.1868_-80.0627", "15331": "40.1073_-80.0204", "15332": "40.2593_-79.9753", "15333": "40.0026_-79.9981", "15336": "40.2601_-79.9927", "15339": "40.3018_-80.1543", "15340": "40.2925_-80.3025", "15342": "40.2425_-80.2209", "15345": "40.0331_-80.1145", "15347": "40.2174_-80.2269", "15348": "39.9867_-79.9937", "15350": "40.2928_-80.2003", "15358": "40.0563_-79.9926", "15360": "40.0859_-80.0703", "15361": "40.3282_-80.2563", "15363": "40.2505_-80.1984", "15365": "40.1611_-80.3781", "15366": "40.1562_-79.9742", "15367": "40.2755_-80.0598", "15368": "40.0144_-79.9889", "15376": "40.1065_-80.4978", "15377": "39.9914_-80.4408", "15378": "40.2775_-80.2731", "15379": "40.2417_-80.4242", "15412": "40.0959_-79.8499", "15419": "40.0625_-79.8953", "15423": "40.0973_-79.8839", "15427": "40.0743_-79.967", "15429": "40.0081_-79.9392", "15432": "40.1151_-79.8627", "15434": "40.0797_-79.8758", "15477": "40.0787_-79.8656", "15483": "40.0826_-79.8501", "18405": "41.6034_-75.1165", "18415": "41.7366_-75.1312", "18417": "41.8117_-75.1891", "18424": "41.2448_-75.5037", "18427": "41.4047_-75.4069", "18428": "41.4787_-75.1978", "18431": "41.5792_-75.2528", "18436": "41.4395_-75.4313", "18437": "41.8666_-75.3231", "18438": "41.4223_-75.2607", "18439": "41.8171_-75.3838", "18443": "41.667_-75.1185", "18445": "41.3041_-75.3384", "18449": "41.8137_-75.448", "18453": "41.7322_-75.3989", "18454": "41.8206_-75.4199", "18455": "41.8867_-75.356", "18456": "41.582_-75.3207", "18459": "41.616_-75.2747", "18460": "41.2643_-75.348", "18461": "41.9251_-75.3212", "18462": "41.8907_-75.449", "18463": "41.3412_-75.3899", "18469": "41.7011_-75.1422", "18472": "41.5703_-75.4065", "18473": "41.5262_-75.2035", "15062": "40.1524_-79.8835", "15068": "40.5616_-79.7129", "15069": "40.5698_-79.7648", "15072": "40.1393_-79.8562", "15083": "40.2382_-79.7922", "15085": "40.3857_-79.7223", "15087": "40.1851_-79.8487", "15089": "40.2075_-79.758", "15448": "40.1331_-79.7417", "15479": "40.1553_-79.7381", "15601": "40.3074_-79.5424", "15605": "40.3602_-79.4398", "15606": "40.3015_-79.5389", "15610": "40.1201_-79.4051", "15611": "40.3126_-79.6565", "15612": "40.1373_-79.5997", "15613": "40.5565_-79.5772", "15615": "40.3578_-79.735", "15616": "40.2237_-79.5512", "15617": "40.268_-79.6591", "15618": "40.5221_-79.4853", "15619": "40.3198_-79.5034", "15620": "40.3238_-79.3434", "15621": "40.2109_-79.4853", "15622": "40.044_-79.3247", "15623": "40.3692_-79.619", "15624": "40.3623_-79.4706", "15625": "40.2665_-79.6787", "15626": "40.4139_-79.5764", "15627": "40.3349_-79.3326", "15628": "40.0996_-79.381", "15629": "40.598_-79.5624", "15632": "40.4252_-79.611", "15633": "40.354_-79.5217", "15634": "40.3239_-79.6049", "15635": "40.352_-79.4979", "15636": "40.366_-79.6565", "15637": "40.2455_-79.7172", "15638": "40.2662_-79.3984", "15639": "40.2149_-79.5824", "15640": "40.2251_-79.7328", "15641": "40.6311_-79.5899", "15642": "40.3191_-79.7205", "15644": "40.3295_-79.6144", "15646": "40.0889_-79.3427", "15647": "40.3453_-79.7264", "15650": "40.2926_-79.4103", "15655": "40.212_-79.1978", "15658": "40.2431_-79.2375", "15660": "40.2459_-79.7709", "15661": "40.3222_-79.3601", "15662": "40.3342_-79.4781", "15663": "40.2467_-79.676", "15664": "40.3108_-79.6172", "15665": "40.334_-79.67", "15666": "40.1742_-79.5134", "15668": "40.4467_-79.6842", "15670": "40.3987_-79.422", "15671": "40.3494_-79.3225", "15672": "40.2192_-79.6095", "15674": "40.216_-79.4872", "15675": "40.3301_-79.6413", "15676": "40.2424_-79.4542", "15677": "40.1864_-79.2473", "15678": "40.2872_-79.7262", "15679": "40.1585_-79.6277", "15680": "40.5189_-79.4959", "15683": "40.1029_-79.593", "15684": "40.4653_-79.5067", "15685": "40.3602_-79.4398", "15687": "40.1386_-79.3445", "15688": "40.1686_-79.5848", "15689": "40.2184_-79.4878", "15690": "40.6418_-79.5399", "15691": "40.294_-79.6866", "15692": "40.3294_-79.6806", "15693": "40.2534_-79.4103", "15695": "40.1962_-79.6942", "15696": "40.2793_-79.3661", "15697": "40.2395_-79.5823", "15698": "40.2155_-79.6849", "15779": "40.3992_-79.2177", "15923": "40.3673_-79.1605", "15944": "40.3823_-79.0968", "15954": "40.4099_-79.0232", "18419": "41.5762_-75.7652", "18446": "41.6412_-75.7641", "18615": "41.4667_-75.856", "18623": "41.6662_-76.1426", "18625": "41.5096_-75.8508", "18629": "41.5587_-76.1035", "18630": "41.6392_-76.0155", "18636": "41.4181_-76.046", "18657": "41.5387_-75.9466", "17019": "40.0964_-77.0339", "17302": "39.821_-76.4012", "17309": "39.8608_-76.4673", "17311": "39.8718_-76.7599", "17312": "39.9467_-76.5066", "17313": "39.9124_-76.6535", "17314": "39.7518_-76.3441", "17315": "40.0062_-76.8555", "17317": "39.9701_-76.5217", "17318": "40.0215_-76.7266", "17319": "40.1545_-76.8019", "17321": "39.751_-76.4392", "17322": "39.836_-76.5937", "17323": "40.075_-77.0279", "17327": "39.7813_-76.7477", "17329": "39.757_-76.8153", "17331": "39.7943_-76.9812", "17332": "39.8007_-76.983", "17333": "39.8007_-76.983", "17334": "39.805_-76.9736", "17335": "39.8144_-76.9837", "17339": "40.1463_-76.87", "17342": "39.8536_-76.708", "17345": "40.0695_-76.7332", "17347": "40.0711_-76.6966", "17349": "39.7423_-76.6841", "17352": "39.76_-76.5042", "17354": "39.8246_-76.8993", "17355": "39.7573_-76.6994", "17356": "39.9026_-76.6081", "17358": "39.973_-76.6878", "17360": "39.8556_-76.7383", "17361": "39.7601_-76.6748", "17362": "39.8572_-76.8774", "17363": "39.772_-76.597", "17364": "39.9346_-76.8822", "17365": "40.0557_-76.9443", "17366": "39.9233_-76.5591", "17368": "39.9966_-76.527", "17370": "40.1222_-76.7737", "17371": "39.9006_-76.7896", "17401": "39.9635_-76.7269", "17402": "39.959_-76.6592", "17403": "39.9494_-76.713", "17404": "40.0023_-76.7712", "17405": "40.0086_-76.5972", "17406": "40.0046_-76.5947", "17407": "39.8833_-76.712", "17408": "39.9492_-76.8018", "02806": "41.7443_-71.3175", "02809": "41.6825_-71.2676", "02872": "41.7071_-71.2868", "02885": "41.7256_-71.2702", "02816": "41.6914_-71.5768", "02817": "41.64_-71.6435", "02818": "41.6498_-71.474", "02827": "41.7062_-71.7356", "02886": "41.7026_-71.4476", "02887": "41.7001_-71.4162", "02888": "41.7494_-71.4084", "02889": "41.7141_-71.3901", "02893": "41.7004_-71.5183", "02801": "41.5301_-71.2841", "02835": "41.5164_-71.3761", "02837": "41.522_-71.1612", "02840": "41.4876_-71.3271", "02841": "41.499_-71.299", "02842": "41.5198_-71.2731", "02871": "41.5944_-71.252", "02878": "41.6338_-71.1808", "02802": "41.9512_-71.4545", "02814": "41.9155_-71.6795", "02815": "41.7778_-71.6706", "02823": "41.7312_-71.5468", "02824": "42.0002_-71.5631", "02825": "41.7815_-71.7187", "02826": "41.9762_-71.6326", "02828": "41.8734_-71.5569", "02829": "41.8793_-71.5894", "02830": "41.9764_-71.6534", "02831": "41.7516_-71.5612", "02838": "41.9689_-71.4741", "02839": "41.9417_-71.6376", "02857": "41.8439_-71.6242", "02858": "41.9573_-71.6478", "02859": "41.9627_-71.7099", "02860": "41.8729_-71.3907", "02861": "41.8814_-71.356", "02862": "41.8612_-71.3691", "02863": "41.8883_-71.3945", "02864": "41.9484_-71.4154", "02865": "41.9089_-71.4348", "02876": "41.9984_-71.5763", "02895": "41.9846_-71.5194", "02896": "41.9724_-71.5508", "02901": "41.8227_-71.4145", "02902": "41.8184_-71.4249", "02903": "41.82_-71.4158", "02904": "41.8541_-71.4378", "02905": "41.7845_-71.3959", "02906": "41.8351_-71.3971", "02907": "41.7971_-71.4255", "02908": "41.8383_-71.4377", "02909": "41.8206_-71.4443", "02910": "41.7766_-71.4383", "02911": "41.8547_-71.4735", "02912": "41.824_-71.4128", "02914": "41.8138_-71.3688", "02915": "41.7723_-71.3542", "02916": "41.8425_-71.3559", "02917": "41.8964_-71.5207", "02918": "41.8415_-71.4404", "02919": "41.8274_-71.52", "02920": "41.7716_-71.4659", "02921": "41.7614_-71.5061", "02940": "41.824_-71.4128", "02804": "41.4231_-71.7837", "02807": "41.1715_-71.5748", "02808": "41.4114_-71.7465", "02812": "41.4691_-71.6751", "02813": "41.4007_-71.6615", "02822": "41.574_-71.6076", "02832": "41.5096_-71.7339", "02833": "41.4751_-71.7726", "02836": "41.4474_-71.6204", "02852": "41.5894_-71.4625", "02873": "41.5199_-71.774", "02874": "41.5105_-71.4427", "02875": "41.456_-71.6355", "02877": "41.5289_-71.5299", "02879": "41.4437_-71.5342", "02880": "41.3753_-71.6439", "02881": "41.4803_-71.5292", "02882": "41.4353_-71.4616", "02883": "41.4512_-71.4987", "02891": "41.3691_-71.8126", "02892": "41.5058_-71.6211", "02894": "41.45_-71.7074", "02898": "41.5041_-71.663", "29620": "34.1819_-82.3785", "29628": "34.0999_-82.5805", "29638": "34.3304_-82.3367", "29639": "34.3344_-82.4002", "29659": "34.2126_-82.6496", "29137": "33.5972_-81.3184", "29164": "33.6494_-81.3995", "29801": "33.553_-81.7194", "29802": "33.5604_-81.7196", "29803": "33.5059_-81.6951", "29804": "33.5377_-81.5999", "29805": "33.6993_-81.6465", "29808": "33.5377_-81.5999", "29809": "33.413_-81.69", "29816": "33.5046_-81.869", "29822": "33.4997_-81.8649", "29828": "33.5182_-81.8277", "29829": "33.563_-81.8147", "29831": "33.3389_-81.7976", "29834": "33.5179_-81.844", "29839": "33.5073_-81.5992", "29841": "33.5251_-81.9394", "29842": "33.4707_-81.8639", "29850": "33.6126_-81.8098", "29851": "33.526_-81.7956", "29856": "33.4674_-81.5136", "29860": "33.6028_-81.9748", "29861": "33.5018_-81.9651", "29810": "33.0077_-81.3203", "29827": "32.9515_-81.2586", "29836": "33.1093_-81.5003", "29846": "33.0241_-81.2258", "29849": "33.0988_-81.2068", "29621": "34.5261_-82.6304", "29622": "34.5034_-82.6501", "29623": "34.4381_-82.8354", "29624": "34.4373_-82.6251", "29625": "34.5271_-82.7087", "29626": "34.4596_-82.7614", "29627": "34.5087_-82.5101", "29654": "34.4417_-82.4255", "29655": "34.3198_-82.6574", "29656": "34.6252_-82.7654", "29669": "34.6461_-82.4673", "29670": "34.6369_-82.7406", "29677": "34.5975_-82.7568", "29684": "34.3962_-82.6897", "29689": "34.5226_-82.8963", "29697": "34.6206_-82.511", "29003": "33.2779_-81.0177", "29042": "33.3209_-81.1407", "29081": "33.1044_-81.0221", "29843": "33.1836_-81.164", "29812": "33.2335_-81.3523", "29813": "33.2735_-81.247", "29817": "33.3645_-81.2718", "29826": "33.3804_-81.3796", "29853": "33.3926_-81.4161", "29901": "32.4244_-80.5653", "29902": "32.4316_-80.6698", "29903": "32.444_-80.7352", "29904": "32.3906_-80.661", "29905": "32.3281_-80.6915", "29906": "32.3823_-80.7603", "29907": "32.4316_-80.6698", "29910": "32.2513_-80.8721", "29914": "32.5527_-80.677", "29915": "32.1145_-80.8686", "29920": "32.3716_-80.5383", "29925": "32.2132_-80.7997", "29926": "32.2077_-80.7476", "29928": "32.1665_-80.7569", "29931": "32.5527_-80.7434", "29935": "32.3874_-80.6844", "29938": "32.3906_-80.661", "29940": "32.5693_-80.7192", "29941": "32.5431_-80.8126", "29410": "32.9185_-80.022", "29431": "33.2703_-79.8736", "29434": "33.1362_-79.8826", "29436": "33.3364_-80.1859", "29445": "33.058_-80.0101", "29450": "33.0439_-79.7841", "29453": "33.2221_-79.6282", "29456": "32.993_-80.1257", "29461": "33.1971_-80.0233", "29468": "33.4199_-80.0932", "29469": "33.2241_-80.0398", "29476": "33.3971_-79.9717", "29479": "33.3362_-79.9236", "29486": "33.0185_-80.1756", "29492": "32.9668_-79.8528", "29030": "33.5703_-80.7081", "29135": "33.6967_-80.8678", "29401": "32.7795_-79.9371", "29402": "32.7766_-79.9309", "29403": "32.7976_-79.9493", "29404": "32.8982_-80.0686", "29405": "32.853_-79.9913", "29406": "32.9352_-80.0325", "29407": "32.7993_-80.006", "29409": "32.7961_-79.9605", "29412": "32.718_-79.9537", "29413": "32.8488_-79.8577", "29414": "32.8215_-80.0568", "29415": "32.8546_-79.9748", "29416": "32.8488_-79.8577", "29417": "32.8488_-79.8577", "29418": "32.8929_-80.0458", "29419": "32.8546_-79.9748", "29422": "32.8488_-79.8577", "29423": "32.8488_-79.8577", "29424": "32.7831_-79.937", "29425": "32.7862_-79.9471", "29426": "32.779_-80.3288", "29429": "33.0063_-79.6561", "29439": "32.663_-79.927", "29449": "32.7105_-80.2744", "29451": "32.7943_-79.7729", "29455": "32.7924_-80.1081", "29457": "32.7924_-80.1081", "29458": "33.1194_-79.5074", "29464": "32.8473_-79.8206", "29465": "32.7941_-79.8626", "29466": "32.8674_-79.8049", "29470": "32.7881_-80.2223", "29482": "32.7637_-79.8399", "29487": "32.6529_-80.1829", "29340": "35.0615_-81.6491", "29341": "35.0999_-81.7056", "29342": "34.9963_-81.6524", "29702": "35.1095_-81.4942", "29014": "34.5779_-81.1249", "29055": "34.5705_-80.9133", "29706": "34.7149_-81.2186", "29712": "34.797_-80.9891", "29714": "34.7006_-80.9092", "29724": "34.7763_-81.0101", "29729": "34.6822_-80.9891", "29101": "34.4606_-80.2544", "29520": "34.6863_-79.9174", "29584": "34.5598_-80.065", "29709": "34.7278_-80.0958", "29718": "34.6546_-80.3639", "29727": "34.7439_-80.2428", "29728": "34.7722_-80.3966", "29741": "34.7379_-80.191", "29001": "33.7684_-80.1788", "29041": "33.6027_-80.2645", "29051": "33.8644_-80.1276", "29102": "33.6184_-80.2116", "29111": "33.7957_-80.0148", "29143": "33.8343_-80.0829", "29148": "33.5946_-80.3606", "29162": "33.8907_-80.0184", "29082": "33.0377_-80.9417", "29433": "33.0614_-80.6312", "29435": "32.9612_-80.4794", "29438": "32.5486_-80.307", "29446": "32.6628_-80.528", "29452": "32.7305_-80.4609", "29474": "32.9405_-80.5739", "29475": "33.0103_-80.8137", "29481": "33.0963_-80.813", "29488": "32.9052_-80.6668", "29493": "33.0327_-80.8445", "29929": "32.9503_-80.8916", "29069": "34.1862_-80.0963", "29079": "34.289_-80.1123", "29532": "34.3003_-79.8732", "29540": "34.3843_-79.8422", "29550": "34.3756_-80.0842", "29551": "34.3659_-80.1324", "29593": "34.4512_-79.8865", "29536": "34.4146_-79.377", "29543": "34.2873_-79.2501", "29547": "34.4849_-79.3502", "29563": "34.3445_-79.1929", "29565": "34.3398_-79.4417", "29567": "34.5613_-79.4335", "29420": "32.9336_-80.1026", "29437": "33.1247_-80.4034", "29447": "33.1052_-80.5948", "29448": "33.2205_-80.4501", "29471": "33.1872_-80.6672", "29472": "33.108_-80.3086", "29477": "33.1845_-80.5732", "29483": "33.028_-80.1739", "29484": "33.0023_-80.2267", "29485": "32.9756_-80.1831", "29824": "33.8056_-81.966", "29832": "33.8231_-81.7972", "29847": "33.6938_-81.8534", "29015": "34.4967_-81.3459", "29065": "34.2717_-81.2712", "29130": "34.3167_-80.9288", "29132": "34.3074_-81.1252", "29180": "34.381_-81.109", "29114": "33.9285_-79.9153", "29161": "34.1012_-79.9378", "29501": "34.1838_-79.7728", "29502": "34.201_-79.7847", "29503": "34.063_-79.6506", "29504": "34.0416_-79.6933", "29505": "34.1231_-79.6893", "29506": "34.2153_-79.6468", "29530": "33.9905_-79.7515", "29541": "34.0946_-79.7918", "29555": "33.8299_-79.4783", "29560": "33.8655_-79.7418", "29583": "33.9922_-79.5929", "29591": "33.9281_-79.7731", "29440": "33.4308_-79.3235", "29442": "33.4037_-79.2264", "29510": "33.4525_-79.5604", "29576": "33.5507_-79.0528", "29585": "33.4508_-79.1341", "29601": "34.8472_-82.406", "29602": "34.8007_-82.3956", "29603": "34.8377_-82.3715", "29604": "34.8497_-82.4538", "29605": "34.8001_-82.3932", "29606": "34.8497_-82.4538", "29607": "34.8285_-82.3516", "29608": "34.8497_-82.4538", "29609": "34.8921_-82.4002", "29610": "34.8497_-82.4538", "29611": "34.8533_-82.4493", "29612": "34.8497_-82.4538", "29613": "34.9249_-82.4331", "29614": "34.8724_-82.3626", "29615": "34.8661_-82.3198", "29616": "34.8526_-82.394", "29617": "34.912_-82.4666", "29635": "35.0654_-82.6093", "29636": "34.7682_-82.3498", "29644": "34.6578_-82.2441", "29650": "34.8968_-82.2674", "29651": "34.9453_-82.2209", "29652": "34.9387_-82.2271", "29661": "35.0296_-82.5136", "29662": "34.7807_-82.3035", "29673": "34.7244_-82.4702", "29680": "34.6962_-82.2893", "29681": "34.7512_-82.255", "29683": "35.0289_-82.4941", "29687": "34.9245_-82.3197", "29688": "35.0477_-82.353", "29690": "35.0039_-82.4272", "29646": "34.1758_-82.1562", "29647": "34.1788_-82.1631", "29648": "34.2124_-82.1681", "29649": "34.223_-82.1582", "29653": "34.2882_-82.2142", "29666": "34.1652_-82.0292", "29692": "34.4025_-82.2678", "29695": "34.2876_-82.2443", "29819": "34.0326_-82.2027", "29848": "33.9876_-82.2979", "29911": "32.9413_-81.1807", "29913": "32.9166_-81.0773", "29916": "32.723_-80.9634", "29918": "32.7375_-81.2178", "29921": "32.6816_-81.1882", "29922": "32.6007_-81.2396", "29923": "32.8596_-81.239", "29924": "32.8729_-81.0973", "29932": "32.8138_-81.2398", "29933": "32.9479_-81.0318", "29939": "32.6786_-81.2455", "29944": "32.8349_-81.0288", "29945": "32.643_-80.8129", "29511": "33.9823_-79.1777", "29526": "33.8731_-79.0557", "29527": "33.7827_-79.1473", "29528": "33.9358_-78.9192", "29544": "34.0563_-79.2464", "29545": "34.1668_-78.9589", "29566": "33.8768_-78.6508", "29568": "33.9064_-78.7934", "29569": "34.0558_-78.9161", "29572": "33.7587_-78.8044", "29575": "33.6286_-78.9736", "29577": "33.6994_-78.9137", "29578": "33.7389_-78.9996", "29579": "33.7377_-78.9787", "29581": "34.2426_-79.1625", "29582": "33.8343_-78.6606", "29587": "33.6211_-78.9632", "29588": "33.7226_-78.9782", "29597": "33.816_-78.68", "29598": "33.816_-78.68", "29909": "32.3301_-80.8435", "29912": "32.5888_-80.9273", "29927": "32.2635_-81.0669", "29934": "32.5931_-81.1078", "29936": "32.4807_-80.9804", "29943": "32.468_-81.1667", "29009": "34.4201_-80.3662", "29020": "34.2696_-80.591", "29021": "34.2974_-80.6089", "29032": "34.3424_-80.5", "29045": "34.162_-80.8113", "29074": "34.457_-80.7892", "29078": "34.2296_-80.7147", "29175": "34.4418_-80.6033", "29058": "34.6024_-80.7103", "29067": "34.5578_-80.5546", "29707": "34.9773_-80.8584", "29720": "34.749_-80.7616", "29721": "34.6994_-80.7817", "29722": "34.7673_-80.6589", "29744": "34.8585_-80.8459", "29325": "34.4707_-81.8772", "29332": "34.2693_-81.9843", "29351": "34.4068_-81.8191", "29360": "34.499_-82.0143", "29370": "34.3408_-81.9584", "29384": "34.3367_-82.088", "29645": "34.5953_-82.1147", "29010": "34.2241_-80.275", "29046": "34.1071_-80.1637", "29080": "34.0526_-80.0988", "29006": "33.8702_-81.5505", "29033": "33.9626_-81.0671", "29036": "34.1312_-81.3318", "29053": "33.8337_-81.1174", "29054": "33.9581_-81.3914", "29070": "33.9132_-81.4598", "29071": "33.9815_-81.2362", "29072": "33.9724_-81.2359", "29073": "33.8632_-81.2351", "29123": "33.7766_-81.2502", "29160": "33.7339_-81.0933", "29169": "33.995_-81.0888", "29170": "33.9568_-81.1405", "29171": "33.9252_-81.2483", "29172": "33.9_-81.091", "29212": "34.0726_-81.1796", "29228": "33.9252_-81.2483", "29821": "33.6505_-82.1488", "29835": "33.9146_-82.2719", "29838": "33.7052_-82.2187", "29840": "34.0065_-82.5324", "29844": "33.7854_-82.2111", "29845": "33.8329_-82.248", "29899": "33.8356_-82.32", "29519": "34.027_-79.3537", "29546": "33.9069_-79.3564", "29571": "34.1562_-79.3898", "29574": "34.2044_-79.2542", "29589": "34.1053_-79.3221", "29592": "34.258_-79.4783", "29512": "34.6255_-79.6898", "29516": "34.5171_-79.6442", "29525": "34.5805_-79.5453", "29570": "34.6704_-79.5597", "29594": "34.6405_-79.5869", "29596": "34.7307_-79.8011", "29037": "34.1856_-81.8644", "29075": "34.1676_-81.4184", "29108": "34.2847_-81.6157", "29122": "34.2386_-81.3271", "29126": "34.3063_-81.45", "29127": "34.1832_-81.5324", "29145": "34.2207_-81.7741", "29178": "34.4955_-81.606", "29355": "34.3804_-81.7773", "29643": "34.5112_-82.9854", "29658": "34.7634_-83.2776", "29664": "34.8541_-83.1134", "29665": "34.7247_-82.9106", "29672": "34.774_-82.9457", "29675": "34.7641_-83.0883", "29676": "34.8728_-82.9607", "29678": "34.6828_-82.9362", "29679": "34.6857_-82.9532", "29686": "34.897_-83.0375", "29691": "34.7648_-83.064", "29693": "34.6965_-83.1535", "29696": "34.7516_-83.0399", "29018": "33.3475_-80.6709", "29038": "33.3726_-80.9631", "29039": "33.4275_-80.8857", "29047": "33.531_-80.572", "29048": "33.3922_-80.32", "29059": "33.3276_-80.4024", "29107": "33.5318_-81.1232", "29112": "33.6211_-81.0601", "29113": "33.4534_-81.1097", "29115": "33.5025_-80.8593", "29116": "33.4959_-80.8246", "29117": "33.4918_-80.8556", "29118": "33.5675_-80.9248", "29133": "33.3703_-80.8331", "29142": "33.4835_-80.4805", "29146": "33.5343_-81.2499", "29163": "33.4139_-80.4617", "29432": "33.2628_-80.8059", "29630": "34.7401_-82.7947", "29631": "34.6831_-82.825", "29632": "34.6834_-82.8374", "29633": "34.6834_-82.8374", "29634": "34.6834_-82.8374", "29640": "34.829_-82.5796", "29641": "34.8135_-82.6531", "29642": "34.7901_-82.5937", "29657": "34.7872_-82.6974", "29667": "34.7648_-82.7567", "29671": "34.9024_-82.7058", "29682": "34.8283_-82.8278", "29685": "34.9706_-82.8076", "29002": "34.1265_-81.2348", "29016": "34.1911_-80.9758", "29044": "33.9153_-80.6996", "29052": "33.8455_-80.7532", "29061": "33.9349_-80.8449", "29063": "34.1103_-81.1966", "29147": "34.0907_-80.9662", "29177": "34.1504_-81.2601", "29201": "34.0004_-81.0334", "29202": "34.0007_-81.0348", "29203": "34.0635_-81.0265", "29204": "34.026_-81.0046", "29205": "33.9903_-80.9997", "29206": "34.0247_-80.9532", "29207": "34.0197_-80.9391", "29208": "34.0007_-81.0348", "29209": "33.9659_-80.9355", "29210": "34.0479_-81.1101", "29211": "34.0007_-81.0348", "29214": "34.0007_-81.0348", "29215": "34.006_-80.9708", "29216": "34.0007_-81.0348", "29217": "34.0007_-81.0348", "29218": "34.0007_-81.0348", "29219": "34.006_-80.9708", "29220": "34.0007_-81.0348", "29221": "34.006_-80.9708", "29222": "34.006_-80.9708", "29223": "34.0853_-80.9167", "29224": "34.006_-80.9708", "29225": "34.0007_-81.0348", "29226": "34.006_-80.9708", "29227": "34.006_-80.9708", "29229": "34.1388_-80.8892", "29230": "34.1075_-81.0626", "29240": "34.006_-80.9708", "29250": "34.006_-80.9708", "29260": "34.006_-80.9708", "29290": "34.006_-80.9708", "29292": "34.006_-80.9708", "29105": "33.8084_-81.5956", "29129": "33.8714_-81.6559", "29138": "34.0175_-81.7754", "29166": "33.8849_-81.7283", "29301": "34.9352_-81.9654", "29302": "34.8939_-81.834", "29303": "34.9803_-81.9168", "29304": "34.9166_-81.8639", "29305": "34.9496_-81.932", "29306": "34.8937_-81.9228", "29307": "34.9839_-81.8313", "29316": "35.0465_-81.9818", "29319": "34.9496_-81.932", "29320": "34.9572_-81.9916", "29322": "35.108_-82.1403", "29323": "35.1154_-81.8678", "29324": "34.9796_-81.8179", "29329": "34.9921_-81.8348", "29330": "35.039_-81.822", "29331": "34.6383_-81.8567", "29333": "34.9685_-81.9064", "29334": "34.9176_-82.1258", "29335": "34.671_-81.9237", "29336": "34.9565_-82.0101", "29338": "35.134_-82.0065", "29346": "34.9448_-81.8376", "29348": "35.0768_-82.1326", "29349": "35.0528_-82.054", "29356": "35.1565_-82.2115", "29365": "34.9684_-82.1435", "29368": "35.084_-81.8598", "29369": "34.8646_-82.0215", "29372": "34.9017_-81.7587", "29373": "34.9226_-81.7426", "29374": "34.7855_-81.8492", "29375": "34.8636_-82.1101", "29376": "34.8688_-81.9526", "29377": "34.9285_-82.099", "29378": "34.969_-81.9704", "29385": "34.9514_-82.0927", "29386": "34.8882_-81.969", "29388": "34.7579_-82.0447", "29040": "34.0144_-80.4665", "29062": "34.0213_-80.5659", "29104": "33.9502_-80.2173", "29125": "33.7642_-80.4978", "29128": "34.1085_-80.4945", "29150": "33.9137_-80.3542", "29151": "33.8999_-80.3743", "29152": "33.9204_-80.3415", "29153": "33.9446_-80.3206", "29154": "33.8821_-80.4028", "29168": "33.8953_-80.498", "29031": "34.567_-81.4814", "29321": "34.7247_-81.6826", "29353": "34.8125_-81.6431", "29364": "34.7865_-81.462", "29379": "34.7269_-81.6202", "29395": "34.8466_-81.7227", "29056": "33.5966_-79.9802", "29518": "33.7886_-79.848", "29554": "33.7419_-79.4489", "29556": "33.6878_-79.7832", "29564": "33.5083_-79.8715", "29580": "33.6625_-79.5589", "29590": "33.5611_-79.83", "29703": "35.1499_-81.2123", "29704": "34.8507_-80.9342", "29708": "35.0502_-80.9908", "29710": "35.1065_-81.2201", "29715": "35.0108_-80.9266", "29716": "35.0074_-80.9451", "29717": "34.9708_-81.4306", "29726": "34.8677_-81.2368", "29730": "34.9151_-81.0129", "29731": "34.9926_-81.1787", "29732": "34.9681_-81.0489", "29733": "34.9926_-81.1787", "29734": "34.9926_-81.1787", "29742": "34.9084_-81.3729", "29743": "35.0308_-81.3896", "29745": "34.9947_-81.2245", "57368": "43.7373_-98.4694", "57375": "43.5842_-98.5088", "57383": "43.7564_-98.7076", "57324": "44.365_-98.0208", "57348": "44.5834_-98.4509", "57350": "44.359_-98.2163", "57379": "44.2908_-98.4243", "57381": "44.4128_-98.692", "57384": "44.3991_-98.4743", "57386": "44.5225_-98.0401", "57399": "44.3633_-98.2143", "57551": "43.1722_-101.7341", "57574": "43.1196_-101.4701", "57714": "43.2908_-101.9329", "57059": "43.1212_-97.7296", "57062": "42.8687_-97.9288", "57063": "42.9383_-97.6923", "57066": "42.99_-97.8633", "57315": "43.0397_-98.0283", "57002": "44.2838_-96.7043", "57006": "44.3056_-96.7914", "57007": "44.3697_-96.7907", "57026": "44.235_-96.5011", "57061": "44.2444_-97.0409", "57071": "44.3224_-96.9251", "57220": "44.4675_-96.911", "57276": "44.4132_-96.615", "57401": "45.4661_-98.4856", "57402": "45.5896_-98.352", "57426": "45.7325_-98.4965", "57427": "45.4564_-98.3552", "57432": "45.6661_-98.0404", "57433": "45.6512_-98.3158", "57439": "45.329_-98.0837", "57441": "45.8493_-98.5176", "57445": "45.4503_-98.1058", "57446": "45.8725_-98.1918", "57449": "45.7967_-98.0952", "57474": "45.2866_-98.2792", "57479": "45.3486_-98.4757", "57481": "45.6705_-98.5802", "57325": "43.7953_-99.3118", "57326": "43.8108_-99.3307", "57355": "43.7467_-98.9584", "57370": "43.7783_-99.1779", "57339": "44.0517_-99.3973", "57341": "44.0693_-99.0543", "57717": "44.6723_-103.8396", "57760": "44.741_-103.3914", "57762": "44.6665_-103.5402", "57788": "44.6222_-103.3795", "57632": "45.8452_-100.049", "57646": "45.6786_-100.0479", "57648": "45.889_-100.2875", "57329": "42.9967_-98.1746", "57342": "43.2597_-98.6926", "57356": "43.1303_-98.4964", "57361": "42.9925_-98.4251", "57367": "43.0673_-98.523", "57369": "43.4251_-98.9479", "57380": "43.0819_-98.2819", "57217": "45.0751_-97.6387", "57225": "44.878_-97.7265", "57236": "44.9841_-97.5814", "57258": "44.8637_-97.9168", "57271": "44.7362_-97.5307", "57278": "44.6272_-97.6747", "57322": "44.6648_-97.9168", "57010": "42.7638_-96.8466", "57037": "43.1027_-97.2558", "57069": "42.7951_-96.9258", "57073": "42.996_-97.0694", "57201": "44.9043_-97.124", "57235": "45.0554_-97.2866", "57243": "44.8858_-97.4442", "57245": "44.8923_-96.9174", "57263": "45.1049_-96.9859", "57272": "45.0815_-97.4458", "57621": "45.7656_-101.0807", "57634": "45.7528_-101.8843", "57639": "45.6758_-100.8043", "57641": "45.7084_-101.1546", "57642": "45.8763_-100.8915", "57645": "45.9386_-101.7232", "57657": "45.4725_-100.7254", "57658": "45.7006_-100.5332", "57659": "45.9103_-101.0904", "57660": "45.9276_-101.5129", "57722": "43.4958_-103.3157", "57730": "43.6573_-103.4258", "57738": "43.6623_-103.2133", "57744": "43.8188_-103.206", "57773": "43.6086_-103.5938", "57301": "43.7094_-98.0298", "57334": "43.5478_-97.9881", "57363": "43.7204_-98.2633", "57219": "45.288_-97.8086", "57239": "45.5097_-97.3092", "57261": "45.5006_-97.5401", "57273": "45.3784_-97.295", "57274": "45.3151_-97.5254", "57422": "45.4222_-97.9175", "57468": "45.496_-97.8128", "57213": "44.5735_-96.5416", "57218": "44.6738_-96.6435", "57226": "44.7612_-96.6907", "57237": "44.827_-96.5044", "57238": "44.8754_-96.8608", "57268": "44.5786_-96.7077", "57625": "45.0016_-101.2329", "57630": "45.4483_-100.9213", "57633": "45.3962_-101.4385", "57636": "45.0144_-101.4315", "57652": "45.2024_-100.605", "57656": "45.3927_-101.0351", "57661": "45.2705_-100.8865", "57313": "43.316_-98.3414", "57328": "43.4213_-98.3564", "57330": "43.2573_-98.1596", "57344": "43.4297_-98.5273", "57364": "43.4291_-98.6069", "57428": "45.453_-99.654", "57448": "45.569_-99.4857", "57451": "45.4489_-99.0148", "57471": "45.4271_-99.3326", "57735": "43.2874_-103.811", "57747": "43.4223_-103.4766", "57763": "43.1551_-103.2162", "57766": "43.3876_-103.1832", "57782": "43.3014_-103.2183", "57435": "45.1691_-98.9411", "57438": "45.0855_-99.1954", "57466": "45.1965_-99.4551", "57467": "44.8343_-99.1058", "57470": "44.8767_-98.8669", "57473": "45.0262_-99.461", "57216": "45.285_-96.5614", "57246": "45.0415_-96.6892", "57251": "45.2727_-96.91", "57252": "45.2061_-96.6255", "57259": "45.0805_-96.5557", "57264": "45.1031_-96.8106", "57265": "45.0389_-96.7901", "57269": "45.2309_-96.8237", "57317": "43.0695_-98.988", "57335": "43.0351_-98.8308", "57523": "43.1825_-99.2937", "57529": "43.2351_-99.514", "57533": "43.2136_-99.3622", "57538": "43.1012_-99.2173", "57571": "43.0852_-99.0925", "57552": "44.0717_-101.1554", "57553": "44.4283_-101.7523", "57567": "44.055_-101.6876", "57221": "44.5987_-97.4537", "57223": "44.7313_-97.0204", "57234": "44.6029_-96.8928", "57241": "44.6647_-97.2305", "57242": "44.7572_-97.3083", "57248": "44.5844_-97.2009", "57362": "44.4966_-98.9894", "57371": "44.5603_-99.2286", "57373": "44.5215_-98.8754", "57311": "43.6684_-97.7563", "57332": "43.5656_-97.6475", "57340": "43.7588_-97.8712", "57650": "45.8554_-103.0356", "57651": "45.5277_-103.0692", "57720": "45.574_-103.5826", "57724": "45.6402_-104.0278", "57755": "45.8366_-103.3491", "57776": "45.2711_-103.5482", "57501": "44.3695_-100.3211", "57522": "44.5026_-99.9463", "57536": "44.5215_-99.7382", "57029": "43.3605_-97.4601", "57045": "43.234_-97.565", "57052": "43.2928_-97.7184", "57331": "43.4705_-97.9988", "57354": "43.3341_-97.7569", "57366": "43.3978_-97.9678", "57376": "43.2404_-97.9713", "57345": "44.5326_-99.4543", "57346": "44.248_-99.4532", "57540": "44.5173_-99.5943", "57521": "43.886_-101.2387", "57543": "43.8446_-101.5523", "57547": "43.4754_-101.4294", "57577": "43.5589_-101.7219", "57750": "43.7319_-101.9642", "57312": "44.1709_-98.3962", "57358": "44.0696_-98.4252", "57382": "44.0664_-98.6751", "57531": "43.926_-100.5085", "57559": "43.8961_-100.7121", "57562": "43.8861_-100.8918", "57051": "44.2457_-97.2696", "57212": "44.3668_-97.0687", "57214": "44.4918_-97.2184", "57231": "44.3852_-97.5634", "57233": "44.4915_-97.4103", "57249": "44.3692_-97.3828", "57353": "44.3455_-97.8542", "57016": "43.8981_-96.9759", "57042": "44.0054_-97.1149", "57050": "44.1525_-96.9942", "57054": "44.1229_-97.2349", "57057": "44.0683_-96.9519", "57075": "43.9852_-96.9615", "57076": "43.9972_-97.3623", "57732": "44.3767_-103.7296", "57754": "44.263_-103.8712", "57759": "44.2097_-103.5449", "57779": "44.5473_-103.7232", "57783": "44.4946_-103.865", "57793": "44.4589_-103.637", "57799": "44.4958_-103.8703", "57013": "43.3038_-96.5938", "57027": "43.197_-96.5135", "57032": "43.446_-96.6864", "57034": "43.1284_-96.5306", "57039": "43.3451_-96.8821", "57064": "43.4711_-96.8177", "57077": "43.3291_-96.7628", "57365": "43.7975_-99.3947", "57544": "43.8921_-99.8502", "57548": "44.0937_-99.6139", "57568": "43.8995_-100.0746", "57569": "43.8789_-99.6032", "57576": "43.9535_-100.286", "57012": "43.5856_-97.2889", "57048": "43.7063_-97.1885", "57058": "43.7356_-97.3797", "57319": "43.5503_-97.4691", "57374": "43.7557_-97.5936", "57437": "45.7707_-99.3308", "57456": "45.7228_-98.9409", "57457": "45.8566_-99.2051", "57232": "45.6211_-97.3741", "57247": "45.6899_-97.3481", "57270": "45.8535_-97.3122", "57421": "45.7585_-97.9274", "57430": "45.8023_-97.7418", "57454": "45.6174_-97.7925", "57626": "44.9926_-102.0541", "57706": "44.1447_-103.0759", "57718": "44.1512_-103.3486", "57737": "44.5755_-102.5632", "57741": "44.4093_-103.4554", "57748": "44.5838_-102.0229", "57758": "45.031_-102.8031", "57769": "44.2287_-103.3688", "57785": "44.3692_-103.3617", "57787": "44.6539_-102.7252", "57792": "44.6182_-102.4452", "57560": "43.4662_-101.1517", "57579": "43.5666_-100.7449", "57585": "43.5366_-100.4379", "57321": "43.8855_-97.5342", "57323": "44.1496_-97.7116", "57337": "43.9841_-97.789", "57349": "44.0371_-97.5603", "57003": "43.7309_-96.7563", "57005": "43.5926_-96.586", "57018": "43.7951_-96.9572", "57020": "43.6669_-96.8221", "57022": "43.8228_-96.7223", "57030": "43.7162_-96.5196", "57033": "43.6155_-96.9501", "57035": "43.612_-97.0697", "57041": "43.7285_-96.8709", "57055": "43.6366_-96.7119", "57068": "43.5773_-96.4956", "57101": "43.5464_-96.6906", "57103": "43.5374_-96.6864", "57104": "43.5514_-96.7375", "57105": "43.524_-96.7341", "57106": "43.5179_-96.7924", "57107": "43.5566_-96.8028", "57108": "43.4775_-96.7041", "57109": "43.6746_-96.7913", "57110": "43.5486_-96.6332", "57117": "43.6746_-96.7913", "57118": "43.6746_-96.7913", "57186": "43.5424_-96.7312", "57193": "43.6746_-96.7913", "57197": "43.6746_-96.7913", "57198": "43.6746_-96.7913", "57017": "43.9558_-96.8189", "57024": "43.9866_-96.6493", "57028": "44.0658_-96.6222", "57065": "43.8942_-96.6326", "57701": "44.1415_-103.2052", "57702": "44.0036_-103.3589", "57703": "44.048_-103.1763", "57709": "44.0761_-103.3171", "57719": "44.1199_-103.0682", "57725": "43.9481_-102.7935", "57745": "43.9377_-103.5782", "57751": "43.8848_-103.3995", "57761": "44.0874_-102.8136", "57767": "44.0631_-102.5628", "57775": "44.1035_-102.0159", "57780": "43.7994_-102.5353", "57790": "43.9812_-102.2245", "57791": "44.225_-102.4311", "57620": "45.5161_-102.4827", "57638": "45.9159_-102.1928", "57640": "45.8232_-102.7599", "57644": "45.3538_-102.2844", "57649": "45.5813_-102.8085", "57442": "45.0259_-99.9766", "57450": "45.2278_-99.7763", "57455": "45.0123_-99.7366", "57475": "45.1702_-99.6176", "57224": "45.8755_-97.1073", "57227": "45.3595_-96.6649", "57255": "45.8659_-96.915", "57256": "45.2657_-97.1925", "57257": "45.5206_-97.0012", "57260": "45.8753_-96.7174", "57262": "45.6732_-97.0715", "57266": "45.3521_-97.0427", "57279": "45.4125_-96.856", "57314": "44.021_-98.0114", "57359": "43.8923_-98.1743", "57385": "44.0572_-98.243", "57716": "43.1085_-102.2006", "57752": "43.425_-102.1765", "57756": "43.2353_-102.4707", "57764": "43.1886_-102.7396", "57770": "43.1124_-102.5984", "57772": "43.2397_-102.331", "57794": "43.1405_-102.3657", "57424": "45.0465_-98.3973", "57429": "45.1635_-98.3193", "57434": "45.1393_-98.1534", "57436": "44.8159_-98.0947", "57440": "44.8084_-98.2935", "57460": "45.243_-98.5629", "57461": "45.1631_-98.4824", "57465": "45.1611_-98.6589", "57469": "44.8719_-98.5112", "57476": "44.7305_-98.5539", "57477": "45.0379_-98.0996", "57532": "44.3426_-100.4043", "57537": "44.3703_-101.0215", "57520": "44.8393_-100.0712", "57564": "44.7125_-100.0957", "57555": "43.285_-100.5954", "57563": "43.3633_-100.3809", "57566": "43.3117_-101.0081", "57570": "43.2328_-100.8535", "57572": "43.1444_-100.9051", "57528": "43.2273_-99.6933", "57534": "43.6439_-99.6918", "57541": "43.5596_-99.9279", "57580": "43.3318_-99.8033", "57584": "43.4498_-100.0783", "57014": "43.1176_-96.9636", "57015": "43.408_-96.9827", "57021": "43.2864_-96.9792", "57036": "43.2893_-97.1904", "57043": "43.4188_-97.2771", "57047": "43.5207_-97.212", "57053": "43.402_-97.1333", "57070": "43.1815_-97.114", "57001": "43.0047_-96.6332", "57004": "43.0874_-96.7813", "57025": "42.7382_-96.687", "57038": "42.6013_-96.5784", "57049": "42.5249_-96.5074", "57420": "45.3324_-100.1186", "57452": "45.4492_-99.822", "57472": "45.4786_-100.0541", "57601": "45.5407_-100.4315", "57631": "45.5335_-100.2716", "57031": "42.8835_-97.183", "57040": "43.0394_-97.5956", "57046": "42.9836_-97.3349", "57067": "43.0164_-97.3694", "57072": "42.9572_-97.1803", "57078": "42.8821_-97.3986", "57622": "44.6055_-101.4999", "57623": "45.0079_-101.6337", "37705": "36.1915_-84.0544", "37710": "36.1626_-84.2992", "37716": "36.0869_-84.1897", "37717": "36.11_-84.1672", "37769": "36.2032_-84.1386", "37828": "36.2005_-84.0858", "37830": "36.0159_-84.2623", "37831": "36.106_-84.1958", "37020": "35.6381_-86.3949", "37160": "35.4863_-86.4624", "37161": "35.4834_-86.4603", "37162": "35.5108_-86.45", "37180": "35.6224_-86.5639", "37183": "35.5123_-86.3277", "37360": "35.4296_-86.2557", "38221": "36.2285_-88.0627", "38320": "36.0556_-88.1119", "38333": "36.1142_-87.982", "38341": "35.8951_-88.0912", "37367": "35.6408_-85.2077", "37701": "35.7852_-83.9809", "37737": "35.7523_-84.1061", "37777": "35.8375_-84.0089", "37801": "35.6884_-84.0769", "37802": "35.7565_-83.9705", "37803": "35.6539_-83.9956", "37804": "35.7991_-83.8852", "37853": "35.8305_-83.9412", "37878": "35.5844_-83.9923", "37882": "35.6784_-83.7572", "37886": "35.7533_-83.8243", "37310": "35.2556_-84.7666", "37311": "35.1313_-84.875", "37312": "35.2023_-84.8476", "37320": "35.1727_-84.8619", "37323": "35.1361_-84.8457", "37353": "35.0869_-84.9892", "37364": "35.1727_-84.8619", "37714": "36.3028_-84.203", "37729": "36.5086_-84.0454", "37757": "36.3266_-84.1928", "37762": "36.577_-84.126", "37766": "36.4248_-84.0907", "37819": "36.5428_-84.1798", "37847": "36.4695_-84.2907", "37016": "35.9338_-86.1126", "37026": "35.7053_-86.0912", "37149": "35.7989_-86.2415", "37190": "35.8143_-86.05", "38201": "36.1272_-88.5134", "38220": "35.9663_-88.6247", "38235": "35.9778_-88.5744", "38258": "36.0172_-88.61", "38317": "36.0268_-88.2518", "38318": "35.9431_-88.2926", "38321": "35.8613_-88.5517", "38324": "35.8675_-88.3934", "38342": "36.0381_-88.2737", "38344": "36.0062_-88.4202", "38348": "35.8583_-88.6324", "38387": "35.8845_-88.2892", "38390": "35.868_-88.3819", "37643": "36.3445_-82.2015", "37644": "36.3487_-82.2107", "37658": "36.2577_-82.1891", "37682": "36.296_-82.3054", "37687": "36.1773_-82.081", "37694": "36.3702_-82.2683", "37015": "36.2731_-87.0447", "37035": "36.3768_-87.1127", "37082": "36.0953_-87.1156", "37143": "36.1129_-87.0316", "37146": "36.3783_-87.0395", "38332": "35.4393_-88.4206", "38340": "35.4269_-88.6398", "38347": "35.4782_-88.5019", "38352": "35.5355_-88.5379", "37707": "36.5481_-83.6707", "37715": "36.565_-83.9397", "37724": "36.5504_-83.681", "37730": "36.552_-83.9769", "37752": "36.5767_-83.6073", "37773": "36.3906_-83.5849", "37824": "36.45_-83.5911", "37825": "36.4245_-83.6469", "37851": "36.5862_-83.901", "37867": "36.5803_-83.6473", "37870": "36.4797_-83.8135", "37879": "36.471_-83.5552", "38551": "36.5475_-85.4966", "38575": "36.5966_-85.6772", "37713": "36.0482_-83.1793", "37722": "35.8347_-83.2187", "37727": "35.883_-83.015", "37753": "35.8256_-83.0996", "37821": "35.9544_-83.2027", "37822": "35.967_-83.1877", "37843": "35.9983_-83.0736", "37018": "35.6447_-86.2046", "37342": "35.3699_-85.9724", "37349": "35.4976_-86.0748", "37355": "35.4958_-86.0816", "37382": "35.5595_-85.9925", "37388": "35.3468_-86.22", "37389": "35.4976_-86.0748", "38001": "35.8017_-89.1765", "38006": "35.7198_-89.0729", "38021": "35.8676_-89.1692", "38034": "35.909_-89.2453", "38050": "35.8379_-89.2273", "38336": "35.7484_-89.0327", "38337": "35.7799_-88.9929", "37723": "35.9537_-84.8205", "38555": "35.9623_-85.0514", "38557": "35.9885_-85.0124", "38558": "36.0077_-84.8719", "38571": "36.0527_-85.0138", "38572": "35.8487_-85.1308", "38578": "35.9813_-85.1984", "37011": "36.0601_-86.6722", "37013": "36.0595_-86.6592", "37070": "36.3231_-86.7133", "37072": "36.3417_-86.7212", "37076": "36.1848_-86.6002", "37080": "36.329_-86.9163", "37115": "36.2604_-86.7046", "37116": "36.1866_-86.7852", "37138": "36.2416_-86.6117", "37189": "36.2744_-86.8292", "37201": "36.1657_-86.7781", "37202": "36.3403_-86.8273", "37203": "36.1504_-86.7916", "37204": "36.1067_-86.7743", "37205": "36.1114_-86.869", "37206": "36.1798_-86.7411", "37207": "36.2195_-86.774", "37208": "36.1762_-86.8076", "37209": "36.1546_-86.8602", "37210": "36.1379_-86.741", "37211": "36.0725_-86.724", "37212": "36.1337_-86.8006", "37213": "36.1663_-86.7669", "37214": "36.1633_-86.6609", "37215": "36.0986_-86.8219", "37216": "36.2125_-86.7257", "37217": "36.1052_-86.6591", "37218": "36.2071_-86.8456", "37219": "36.1678_-86.7837", "37220": "36.0641_-86.7697", "37221": "36.0662_-86.9639", "37222": "36.1659_-86.7844", "37224": "36.1866_-86.7852", "37227": "36.1866_-86.7852", "37228": "36.1901_-86.8053", "37229": "36.1866_-86.7852", "37230": "36.1866_-86.7852", "37232": "36.1866_-86.7852", "37234": "36.1866_-86.7852", "37235": "36.1866_-86.7852", "37236": "36.1866_-86.7852", "37238": "36.1866_-86.7852", "37240": "36.1866_-86.7852", "37241": "36.1866_-86.7852", "37242": "36.1866_-86.7852", "37243": "36.165_-86.7821", "37244": "36.1866_-86.7852", "37246": "36.1586_-86.79", "37250": "36.1866_-86.7852", "38311": "35.4521_-88.1286", "38329": "35.5585_-88.1334", "38363": "35.6664_-88.1195", "38374": "35.505_-88.2405", "38380": "35.792_-88.0322", "37012": "36.0711_-86.0372", "37059": "35.9725_-85.9055", "37095": "36.0067_-85.9678", "37166": "35.9299_-85.8046", "37029": "36.0471_-87.3061", "37036": "36.2326_-87.2816", "37051": "36.2721_-87.3914", "37055": "36.076_-87.3995", "37056": "36.1469_-87.353", "37165": "36.2948_-87.4703", "37181": "36.2237_-87.4565", "37187": "36.1253_-87.219", "38007": "36.164_-89.4384", "38024": "36.0444_-89.3836", "38025": "36.0345_-89.3856", "38030": "36.0169_-89.5134", "38047": "36.0892_-89.4984", "38059": "36.1009_-89.2514", "38070": "35.9515_-89.2401", "38259": "36.2011_-89.1863", "38010": "35.2886_-89.488", "38036": "35.3274_-89.6198", "38045": "35.2904_-89.2322", "38046": "35.0454_-89.2437", "38048": "35.1507_-89.4814", "38057": "35.0588_-89.3595", "38060": "35.229_-89.5151", "38066": "35.0768_-89.5678", "38068": "35.2772_-89.3918", "38076": "35.1576_-89.3684", "38504": "36.3818_-84.7756", "38553": "36.2112_-84.9777", "38556": "36.4245_-84.9357", "38565": "36.2598_-85.0015", "38577": "36.5781_-85.0384", "38589": "36.2822_-85.0913", "37306": "35.1415_-86.1728", "37318": "35.1783_-86.0167", "37324": "35.2326_-86.0589", "37330": "35.2705_-86.1396", "37345": "35.0512_-86.2694", "37375": "35.2011_-85.9126", "37376": "35.0452_-85.9302", "37383": "35.1805_-85.9035", "37398": "35.1864_-86.113", "38233": "36.1906_-89.0229", "38316": "36.0645_-88.8046", "38330": "36.0716_-89.0192", "38331": "35.9693_-89.1319", "38338": "35.8708_-88.8464", "38343": "35.837_-88.9057", "38346": "36.0306_-88.8056", "38355": "35.8081_-88.7627", "38358": "35.9251_-88.7688", "38369": "36.13_-88.9849", "38382": "35.9712_-88.9507", "38389": "36.1354_-89.1117", "38449": "35.0574_-86.8796", "38455": "35.0523_-86.8886", "38459": "35.1834_-86.85", "38460": "35.1167_-87.1278", "38472": "35.3792_-87.0629", "38473": "35.05_-87.1522", "38477": "35.0666_-87.0174", "38478": "35.2093_-87.0393", "37708": "36.3249_-83.3142", "37709": "36.1583_-83.6783", "37848": "36.2357_-83.6801", "37861": "36.2501_-83.5125", "37881": "36.3917_-83.366", "37888": "36.3106_-83.5937", "37616": "36.2265_-82.7476", "37641": "36.2569_-82.6905", "37743": "36.1316_-82.8692", "37744": "36.1683_-82.8548", "37745": "36.2455_-82.8238", "37809": "36.151_-83.0281", "37810": "36.1869_-83.0902", "37818": "36.1839_-82.9674", "37301": "35.4258_-85.7635", "37305": "35.4652_-85.6942", "37313": "35.3516_-85.7003", "37339": "35.3723_-85.618", "37356": "35.2402_-85.8228", "37365": "35.3741_-85.5643", "37366": "35.314_-85.8441", "37387": "35.2721_-85.7362", "37778": "36.2133_-83.2752", "37813": "36.1957_-83.2755", "37814": "36.2248_-83.3119", "37815": "36.2133_-83.2752", "37816": "36.2133_-83.2752", "37860": "36.2567_-83.1914", "37877": "36.16_-83.4129", "37891": "36.2621_-83.1458", "37302": "35.0149_-85.0164", "37304": "35.3452_-85.138", "37308": "35.352_-84.9618", "37315": "35.0479_-85.0574", "37341": "35.1679_-85.0945", "37343": "35.1591_-85.2182", "37350": "34.9948_-85.3506", "37351": "35.1045_-85.2631", "37363": "35.0781_-85.0635", "37373": "35.3858_-85.1023", "37377": "35.1494_-85.3362", "37379": "35.2527_-85.163", "37384": "35.2211_-85.2091", "37401": "35.0456_-85.3097", "37402": "35.0463_-85.3161", "37403": "35.045_-85.2965", "37404": "35.0306_-85.2722", "37405": "35.0768_-85.3082", "37406": "35.0614_-85.2478", "37407": "35.0024_-85.2849", "37408": "35.0292_-85.3068", "37409": "34.9981_-85.331", "37410": "35.0018_-85.3138", "37411": "35.0271_-85.2356", "37412": "35.0015_-85.2384", "37414": "35.0456_-85.3097", "37415": "35.1273_-85.2802", "37416": "35.0942_-85.1757", "37419": "35.0331_-85.3687", "37421": "35.025_-85.1459", "37422": "35.0456_-85.3097", "37424": "35.0456_-85.3097", "37450": "35.0456_-85.3097", "37765": "36.5721_-83.0507", "37869": "36.5275_-83.2529", "38008": "35.2461_-89.0007", "38039": "35.049_-89.187", "38042": "35.158_-89.1309", "38044": "35.2197_-88.8263", "38052": "35.0818_-88.9046", "38061": "35.0315_-88.8116", "38067": "35.0498_-89.0769", "38075": "35.3191_-89.1337", "38377": "35.356_-88.8269", "38381": "35.3574_-88.9353", "38326": "35.0394_-88.2936", "38327": "35.2191_-88.3192", "38361": "35.3026_-88.3176", "38365": "35.0383_-88.2256", "38370": "35.3815_-88.2472", "38372": "35.2023_-88.2005", "38376": "35.1154_-88.3617", "38475": "35.2667_-88.039", "37642": "36.5399_-82.7252", "37645": "36.5629_-82.6532", "37711": "36.2832_-83.0374", "37731": "36.4995_-83.0827", "37811": "36.3621_-83.2095", "37857": "36.4162_-83.0108", "37873": "36.4741_-82.8306", "38012": "35.61_-89.2624", "38069": "35.4482_-89.3326", "38328": "35.663_-88.2177", "38345": "35.6144_-88.5195", "38351": "35.6512_-88.3927", "38368": "35.5096_-88.3508", "38371": "35.4386_-88.3058", "38388": "35.7698_-88.4388", "38222": "36.4146_-88.1515", "38223": "36.2931_-88.5123", "38224": "36.3479_-88.4614", "38231": "36.2039_-88.4198", "38236": "36.1847_-88.2859", "38242": "36.3005_-88.3093", "38251": "36.4456_-88.3472", "38256": "36.265_-88.1459", "37025": "35.9471_-87.2996", "37033": "35.7797_-87.4775", "37098": "35.8502_-87.3127", "37137": "35.8763_-87.5067", "37140": "35.8679_-87.6655", "38454": "35.748_-87.3577", "38476": "35.8104_-87.253", "37061": "36.3067_-87.679", "37175": "36.3241_-87.8725", "37178": "36.3297_-87.7808", "37078": "35.924_-87.8105", "37101": "36.1185_-87.6422", "37134": "36.0088_-87.9547", "37185": "36.0997_-87.7991", "38562": "36.3438_-85.6355", "38564": "36.2768_-85.7475", "38588": "36.5158_-85.6899", "37725": "36.0008_-83.4233", "37760": "36.1163_-83.481", "37820": "36.081_-83.5673", "37871": "36.0687_-83.6568", "37890": "36.0776_-83.2998", "37640": "36.3282_-81.9856", "37680": "36.5793_-81.7254", "37683": "36.4657_-81.814", "37688": "36.5272_-81.9068", "37691": "36.3683_-81.7572", "37721": "36.12_-83.813", "37754": "36.115_-84.0438", "37806": "36.0844_-83.7411", "37849": "36.0435_-84.04", "37901": "36.0323_-83.8848", "37902": "35.9625_-83.9209", "37909": "35.946_-84.0235", "37912": "36.0055_-83.9773", "37914": "35.9918_-83.8496", "37915": "35.9721_-83.901", "37916": "35.9556_-83.9336", "37917": "35.998_-83.9152", "37918": "36.0501_-83.9226", "37919": "35.9244_-84.0015", "37920": "35.8929_-83.9387", "37921": "35.9793_-84.003", "37922": "35.858_-84.1194", "37923": "35.9331_-84.0761", "37924": "36.032_-83.8021", "37927": "35.9901_-83.9622", "37928": "35.9901_-83.9622", "37929": "35.9606_-83.9207", "37930": "35.9029_-83.9536", "37931": "35.9924_-84.1201", "37932": "35.9335_-84.1481", "37933": "35.9901_-83.9622", "37934": "35.8762_-84.1746", "37938": "36.1055_-83.946", "37939": "35.9901_-83.9622", "37940": "35.9901_-83.9622", "37950": "35.9901_-83.9622", "37995": "35.9606_-83.9207", "37996": "35.9901_-83.9622", "37997": "35.9901_-83.9622", "37998": "35.9351_-83.7503", "38077": "36.3281_-89.4744", "38079": "36.3846_-89.4649", "38080": "36.2638_-89.4858", "38037": "35.796_-89.3938", "38040": "35.8862_-89.4147", "38041": "35.6593_-89.6962", "38063": "35.7527_-89.535", "38456": "35.3326_-87.3039", "38457": "35.031_-87.2961", "38463": "35.0563_-87.6473", "38464": "35.2507_-87.3526", "38468": "35.1382_-87.3168", "38469": "35.0728_-87.427", "38481": "35.0376_-87.5018", "38483": "35.4307_-87.3198", "38486": "35.1393_-87.538", "38462": "35.5266_-87.4891", "37144": "35.2924_-86.6447", "37328": "35.0295_-86.3481", "37334": "35.1527_-86.5664", "37335": "35.0581_-86.413", "37348": "35.1024_-86.4683", "37359": "35.1941_-86.4217", "38453": "35.1214_-86.8121", "38488": "35.0517_-86.6447", "37742": "35.6567_-84.171", "37771": "35.8104_-84.2665", "37772": "35.7883_-84.2188", "37774": "35.7292_-84.3436", "37846": "35.6781_-84.4312", "37303": "35.4574_-84.6043", "37309": "35.3228_-84.7364", "37329": "35.4272_-84.4833", "37331": "35.3314_-84.5283", "37370": "35.3731_-84.6951", "37371": "35.4429_-84.593", "37826": "35.5819_-84.5721", "38310": "35.2556_-88.4134", "38315": "35.2289_-88.644", "38334": "35.3544_-88.5876", "38339": "35.0142_-88.5208", "38357": "35.0603_-88.4405", "38359": "35.3729_-88.3675", "38367": "35.0642_-88.6017", "38375": "35.1691_-88.5958", "38379": "35.1809_-88.4364", "38393": "34.9969_-88.6456", "37083": "36.539_-86.0242", "37150": "36.5177_-85.8662", "38301": "35.6102_-88.814", "38302": "35.6124_-88.8412", "38303": "35.6124_-88.8412", "38305": "35.6829_-88.8281", "38308": "35.6124_-88.8412", "38313": "35.5922_-88.6396", "38314": "35.6124_-88.8412", "38356": "35.4345_-88.8953", "38362": "35.7242_-88.7801", "38366": "35.4781_-88.7304", "38378": "35.7668_-88.6839", "38391": "35.5571_-88.9759", "38392": "35.4816_-89.0271", "37340": "35.0178_-85.5116", "37347": "35.097_-85.5897", "37374": "35.1634_-85.6371", "37380": "35.028_-85.7225", "37396": "34.9873_-85.4977", "37397": "35.1972_-85.5011", "37019": "35.4069_-86.7095", "37034": "35.6354_-86.6836", "37047": "35.3409_-86.8286", "37091": "35.4596_-86.7812", "37174": "35.7173_-86.9048", "38401": "35.6156_-87.038", "38402": "35.6151_-87.0353", "38451": "35.4749_-87.0005", "38461": "35.5915_-87.3251", "38474": "35.5301_-87.2037", "38482": "35.7588_-87.1515", "38487": "35.6494_-87.2257", "37322": "35.5072_-84.8081", "37336": "35.2932_-84.9127", "37880": "35.6862_-84.6548", "37314": "35.2467_-84.3031", "37354": "35.4916_-84.3395", "37385": "35.3562_-84.3068", "37874": "35.6015_-84.461", "37885": "35.5354_-84.1778", "37040": "36.522_-87.349", "37041": "36.4774_-87.3772", "37042": "36.5853_-87.4186", "37043": "36.5107_-87.2757", "37044": "36.5314_-87.353", "37052": "36.3789_-87.4245", "37142": "36.4176_-87.4914", "37171": "36.3626_-87.3061", "37191": "36.5147_-87.5393", "37352": "35.2706_-86.372", "37719": "36.029_-84.4208", "37726": "36.2176_-84.8191", "37733": "36.3519_-84.7137", "37770": "36.1456_-84.7135", "37829": "36.01_-84.5753", "37840": "36.0366_-84.3486", "37845": "36.0959_-84.4424", "37872": "36.2622_-84.6984", "37887": "36.1016_-84.5652", "38232": "36.3596_-89.3056", "38240": "36.2657_-89.2805", "38253": "36.3108_-89.0731", "38254": "36.3791_-89.3538", "38257": "36.4814_-88.8808", "38260": "36.3416_-89.1611", "38261": "36.4263_-89.0667", "38271": "36.4583_-89.2332", "38281": "36.4242_-89.057", "38541": "36.497_-85.3197", "38542": "36.324_-85.2031", "38543": "36.3803_-85.1522", "38554": "36.2361_-85.1688", "38568": "36.4227_-85.4464", "38570": "36.389_-85.3205", "38573": "36.4642_-85.2164", "38580": "36.2812_-85.3048", "37096": "35.5944_-87.8567", "37097": "35.7467_-87.8251", "38549": "36.5709_-85.1456", "37307": "35.173_-84.6544", "37316": "34.9971_-84.7327", "37317": "35.0207_-84.3748", "37325": "35.2612_-84.6024", "37326": "35.0339_-84.3792", "37333": "35.1449_-84.3209", "37361": "35.1025_-84.7136", "37362": "35.2829_-85.2568", "37369": "35.1807_-84.541", "37391": "35.1081_-84.3544", "38501": "36.2178_-85.5423", "38502": "36.1628_-85.5016", "38503": "36.1628_-85.5016", "38505": "36.1628_-85.5016", "38506": "36.1819_-85.4408", "38544": "36.1249_-85.6378", "38545": "36.2321_-85.6628", "38548": "36.1833_-85.7589", "38574": "36.1509_-85.2542", "38582": "36.1006_-85.7338", "37321": "35.5002_-85.0135", "37332": "35.6153_-85.0228", "37337": "35.7608_-84.8615", "37338": "35.4484_-85.179", "37381": "35.6935_-84.8198", "37748": "35.9348_-84.5155", "37763": "35.8528_-84.4971", "37854": "35.8587_-84.6842", "37010": "36.5582_-87.1226", "37032": "36.5514_-86.9992", "37049": "36.5531_-86.6761", "37073": "36.4229_-86.7914", "37141": "36.611_-86.699", "37152": "36.4025_-86.7722", "37172": "36.5018_-86.8769", "37188": "36.46_-86.6705", "37037": "35.696_-86.368", "37060": "35.7492_-86.6327", "37063": "35.6551_-86.403", "37085": "35.9495_-86.3112", "37086": "36.0127_-86.56", "37089": "35.8596_-86.421", "37118": "35.9221_-86.1824", "37127": "35.763_-86.3722", "37128": "35.8454_-86.4867", "37129": "35.871_-86.4181", "37130": "35.8456_-86.3903", "37131": "35.8596_-86.421", "37132": "35.8596_-86.421", "37133": "35.8456_-86.3903", "37153": "35.745_-86.5352", "37167": "35.9656_-86.5048", "37732": "36.3323_-84.6063", "37755": "36.4329_-84.5381", "37756": "36.3983_-84.4288", "37841": "36.5053_-84.5293", "37852": "36.3527_-84.5904", "37892": "36.5598_-84.434", "37327": "35.3842_-85.3925", "37738": "35.729_-83.4874", "37764": "35.9722_-83.6171", "37862": "35.8452_-83.5386", "37863": "35.7922_-83.5638", "37864": "35.8542_-83.6138", "37865": "35.87_-83.7495", "37868": "35.8809_-83.5561", "37876": "35.866_-83.4793", "37501": "35.1693_-89.9904", "37544": "35.1496_-90.0487", "38002": "35.2752_-89.7295", "38014": "35.2673_-89.7687", "38016": "35.1602_-89.7816", "38017": "35.0551_-89.6767", "38018": "35.1556_-89.7762", "38027": "35.042_-89.6645", "38028": "35.1551_-89.676", "38029": "35.2306_-89.8259", "38053": "35.3185_-89.9054", "38054": "35.3341_-89.8706", "38055": "35.3415_-89.8973", "38083": "35.2017_-89.9715", "38088": "35.1556_-89.7762", "38101": "35.1495_-90.049", "38103": "35.144_-90.048", "38104": "35.1334_-90.0046", "38105": "35.1497_-90.033", "38106": "35.1021_-90.033", "38107": "35.1831_-90.0201", "38108": "35.1787_-89.9682", "38109": "35.0425_-90.0732", "38111": "35.1076_-89.9457", "38112": "35.1483_-89.9729", "38113": "35.1274_-89.9845", "38114": "35.0981_-89.9825", "38115": "35.0579_-89.864", "38116": "35.0303_-90.0123", "38117": "35.1124_-89.9034", "38118": "35.0514_-89.9265", "38119": "35.0821_-89.8501", "38120": "35.1207_-89.8651", "38122": "35.1572_-89.9268", "38124": "35.2017_-89.9715", "38125": "35.0312_-89.8124", "38126": "35.1255_-90.0424", "38127": "35.251_-90.0296", "38128": "35.2213_-89.9413", "38130": "35.2017_-89.9715", "38131": "35.0664_-89.9921", "38132": "35.072_-89.9886", "38133": "35.2054_-89.8036", "38134": "35.1845_-89.8574", "38135": "35.2323_-89.8509", "38136": "35.2017_-89.9715", "38137": "35.2017_-89.9715", "38138": "35.0883_-89.8053", "38139": "35.0874_-89.7703", "38141": "35.0231_-89.8492", "38145": "35.2017_-89.9715", "38148": "35.1495_-90.049", "38150": "35.1495_-90.049", "38151": "35.2017_-89.9715", "38152": "35.2017_-89.9715", "38157": "35.2017_-89.9715", "38159": "35.1495_-90.049", "38161": "35.2017_-89.9715", "38163": "35.2017_-89.9715", "38166": "35.2017_-89.9715", "38167": "35.2017_-89.9715", "38168": "35.2017_-89.9715", "38173": "35.1495_-90.049", "38174": "35.2017_-89.9715", "38175": "35.2017_-89.9715", "38177": "35.2017_-89.9715", "38181": "35.2017_-89.9715", "38182": "35.2017_-89.9715", "38183": "35.2017_-89.9715", "38184": "35.2017_-89.9715", "38186": "35.2017_-89.9715", "38187": "35.2017_-89.9715", "38188": "35.2017_-89.9715", "38190": "35.2017_-89.9715", "38193": "35.2017_-89.9715", "38194": "35.2017_-89.9715", "38197": "35.2017_-89.9715", "37030": "36.2763_-85.9517", "37057": "36.4455_-86.0533", "37145": "36.3462_-85.9189", "37151": "36.3506_-86.0335", "38547": "36.1107_-86.0203", "38552": "36.2028_-85.8264", "38560": "36.2355_-85.8808", "38563": "36.1843_-86.0008", "38567": "36.1197_-85.9023", "38569": "36.0954_-85.8551", "37023": "36.5716_-87.7378", "37028": "36.6226_-87.8614", "37050": "36.3729_-87.6306", "37058": "36.4942_-87.8787", "37079": "36.4946_-87.6804", "37617": "36.5356_-82.3656", "37618": "36.4774_-82.2362", "37620": "36.5686_-82.1819", "37621": "36.5042_-82.2645", "37625": "36.5951_-82.1887", "37660": "36.5484_-82.5618", "37662": "36.5484_-82.5618", "37663": "36.4715_-82.4834", "37664": "36.5208_-82.5168", "37665": "36.5799_-82.5733", "37669": "36.5484_-82.5618", "37686": "36.4461_-82.334", "37699": "36.4195_-82.304", "37022": "36.5186_-86.3146", "37031": "36.3806_-86.3107", "37048": "36.4912_-86.6033", "37066": "36.3834_-86.4512", "37075": "36.3054_-86.6072", "37077": "36.3047_-86.6211", "37119": "36.632_-86.539", "37148": "36.5673_-86.5059", "37186": "36.5756_-86.2353", "38004": "35.4412_-89.7781", "38011": "35.484_-89.7251", "38015": "35.5399_-89.8177", "38019": "35.5598_-89.6501", "38023": "35.4452_-89.9236", "38049": "35.438_-89.5518", "38058": "35.459_-89.8197", "38071": "35.4143_-89.8188", "37074": "36.3947_-86.1704", "37650": "36.1342_-82.4163", "37657": "36.0085_-82.5623", "37692": "36.2066_-82.322", "37779": "36.2001_-83.76", "37807": "36.2343_-83.8403", "37866": "36.3685_-83.8127", "38585": "35.7279_-85.4287", "37110": "35.6834_-85.77", "37111": "35.6834_-85.77", "37357": "35.6029_-85.9197", "37378": "35.6403_-85.8366", "37394": "35.5384_-85.8591", "38550": "35.7734_-85.6192", "38581": "35.7668_-85.6788", "37601": "36.3339_-82.3408", "37602": "36.2717_-82.5012", "37604": "36.3107_-82.381", "37605": "36.3158_-82.3838", "37614": "36.1571_-82.5626", "37615": "36.3996_-82.4523", "37656": "36.4158_-82.6256", "37659": "36.2954_-82.4902", "37681": "36.254_-82.625", "37684": "36.3107_-82.3732", "37690": "36.2451_-82.5369", "38425": "35.3819_-87.95", "38450": "35.1635_-87.7185", "38452": "35.0579_-87.7883", "38471": "35.1138_-87.8923", "38485": "35.322_-87.7395", "38225": "36.295_-88.6963", "38226": "36.4796_-88.6926", "38229": "36.2117_-88.6184", "38230": "36.1485_-88.7453", "38237": "36.3425_-88.8554", "38238": "36.3434_-88.8503", "38241": "36.3948_-88.6142", "38255": "36.2395_-88.8477", "38559": "35.8356_-85.5191", "38579": "35.8303_-85.552", "38583": "35.9439_-85.4392", "38587": "35.8695_-85.6185", "37014": "35.8566_-86.6633", "37024": "36.0331_-86.7828", "37027": "36.0063_-86.7909", "37046": "35.7832_-86.7495", "37062": "35.9755_-87.1321", "37064": "35.9328_-86.8788", "37065": "35.9251_-86.8689", "37067": "35.9121_-86.7655", "37068": "35.8746_-86.9076", "37069": "35.9796_-86.9106", "37135": "35.9307_-86.6829", "37179": "35.809_-86.8913", "37071": "36.1562_-86.3049", "37087": "36.2098_-86.3024", "37088": "36.2081_-86.2911", "37090": "36.1185_-86.263", "37121": "36.2001_-86.5186", "37122": "36.1897_-86.5023", "37136": "36.1562_-86.3049", "37184": "36.0953_-86.1434", "75763": "32.0535_-95.5163", "75779": "31.8668_-95.4958", "75801": "31.7588_-95.6342", "75802": "31.7621_-95.6308", "75803": "31.7571_-95.6545", "75832": "31.9571_-95.9747", "75839": "31.648_-95.5551", "75853": "31.8766_-95.7327", "75861": "31.7929_-95.8998", "75880": "31.8354_-95.8389", "75882": "31.7942_-95.662", "75884": "31.8354_-95.8389", "75886": "31.8354_-95.8389", "79714": "32.3201_-102.5409", "75901": "31.27_-94.6469", "75902": "31.3623_-94.7611", "75903": "31.2766_-94.5676", "75904": "31.3489_-94.8327", "75915": "31.3382_-94.7291", "75941": "31.195_-94.7729", "75949": "31.2837_-94.5662", "75969": "31.4291_-94.8254", "75980": "31.1569_-94.3871", "78358": "28.0614_-97.0411", "78381": "28.0131_-97.0936", "78382": "28.0308_-97.0688", "76351": "33.5562_-98.6249", "76366": "33.8162_-98.6951", "76370": "33.4533_-98.9297", "76379": "33.6535_-98.465", "76389": "33.5796_-98.4376", "79019": "35.0967_-101.3813", "79094": "34.7928_-101.5471", "78008": "28.767_-98.2566", "78011": "28.8649_-98.707", "78012": "28.7858_-98.4886", "78026": "28.903_-98.544", "78050": "29.073_-98.4842", "78052": "29.2366_-98.7945", "78062": "28.7397_-98.1786", "78064": "28.9924_-98.4831", "78065": "29.0994_-98.6241", "77418": "29.9658_-96.2531", "77452": "30.0477_-96.3269", "77473": "29.8019_-96.1014", "77474": "29.7826_-96.1592", "77485": "29.6397_-96.0456", "78931": "30.0292_-96.4448", "78933": "29.7512_-96.39", "78944": "29.9904_-96.4843", "78950": "29.9134_-96.4961", "79324": "33.8731_-102.7599", "79344": "33.8487_-102.8985", "79347": "34.2193_-102.7496", "78003": "29.7276_-99.0453", "78055": "29.8475_-99.3215", "78063": "29.6796_-98.9484", "78883": "29.6455_-99.2469", "78885": "29.7452_-99.5551", "78602": "30.1388_-97.2921", "78612": "30.0966_-97.4976", "78621": "30.3231_-97.3737", "78650": "30.2968_-97.2386", "78659": "30.1858_-97.1198", "78662": "29.9906_-97.4081", "78953": "29.9241_-97.3119", "78957": "30.0178_-97.1494", "76380": "33.5914_-99.2587", "78102": "28.4222_-97.7616", "78104": "28.3931_-97.776", "78125": "28.5552_-97.9407", "78142": "28.5278_-97.7831", "78145": "28.6526_-97.9921", "78146": "28.6164_-97.8082", "78162": "28.5708_-97.7972", "78389": "28.2121_-97.7127", "78391": "28.1693_-97.7549", "76501": "31.0895_-97.3343", "76502": "31.071_-97.3898", "76503": "31.054_-97.3203", "76504": "31.0917_-97.3648", "76508": "31.0363_-97.492", "76511": "30.7991_-97.4263", "76513": "31.0723_-97.472", "76533": "31.0496_-97.4936", "76534": "30.88_-97.3857", "76540": "31.1171_-97.7278", "76541": "31.1164_-97.7278", "76542": "31.0376_-97.6809", "76543": "31.1172_-97.6651", "76544": "31.1349_-97.7756", "76547": "31.1171_-97.7278", "76548": "31.0286_-97.6115", "76549": "31.0065_-97.841", "76554": "30.9863_-97.3586", "76559": "31.0833_-97.5941", "76564": "31.1952_-97.3486", "76569": "30.955_-97.2228", "76571": "30.9494_-97.533", "76579": "31.1759_-97.2852", "78002": "29.2705_-98.7421", "78015": "29.7327_-98.6646", "78023": "29.6321_-98.7542", "78054": "29.3258_-98.6911", "78069": "29.2205_-98.6678", "78073": "29.275_-98.6677", "78101": "29.3805_-98.265", "78109": "29.5173_-98.3217", "78112": "29.2308_-98.372", "78148": "29.5465_-98.2954", "78150": "29.3759_-97.958", "78152": "29.4353_-98.1952", "78201": "29.4711_-98.5356", "78202": "29.4275_-98.4601", "78203": "29.4148_-98.4601", "78204": "29.4059_-98.5078", "78205": "29.4237_-98.4925", "78206": "29.4375_-98.4616", "78207": "29.4229_-98.526", "78208": "29.44_-98.459", "78209": "29.4821_-98.4554", "78210": "29.3977_-98.4658", "78211": "29.3499_-98.5638", "78212": "29.4388_-98.4935", "78213": "29.5234_-98.5273", "78214": "29.3641_-98.4924", "78215": "29.4413_-98.4793", "78216": "29.5334_-98.4975", "78217": "29.5395_-98.4194", "78218": "29.4969_-98.4032", "78219": "29.4492_-98.3446", "78220": "29.4106_-98.4128", "78221": "29.3309_-98.5054", "78222": "29.3831_-98.396", "78223": "29.3579_-98.4356", "78224": "29.3374_-98.5393", "78225": "29.3875_-98.5245", "78226": "29.393_-98.5511", "78227": "29.4027_-98.6433", "78228": "29.4589_-98.5699", "78229": "29.5042_-98.5697", "78230": "29.5407_-98.5521", "78231": "29.5714_-98.5414", "78232": "29.5863_-98.4769", "78233": "29.5563_-98.3643", "78234": "29.4241_-98.4936", "78235": "29.3494_-98.4422", "78236": "29.4241_-98.4936", "78237": "29.4208_-98.5645", "78238": "29.451_-98.6169", "78239": "29.5182_-98.3627", "78240": "29.5189_-98.6006", "78241": "29.4375_-98.4616", "78242": "29.3509_-98.6109", "78243": "29.4375_-98.4616", "78244": "29.4793_-98.3476", "78245": "29.4189_-98.6895", "78246": "29.4375_-98.4616", "78247": "29.5855_-98.4071", "78248": "29.5894_-98.5201", "78249": "29.5612_-98.6117", "78250": "29.5054_-98.6688", "78251": "29.4597_-98.6555", "78252": "29.346_-98.6464", "78253": "29.4599_-98.7479", "78254": "29.5551_-98.7442", "78255": "29.6701_-98.6873", "78256": "29.6169_-98.6252", "78257": "29.6495_-98.6137", "78258": "29.6562_-98.4967", "78259": "29.6283_-98.4445", "78260": "29.7026_-98.4759", "78261": "29.7055_-98.4191", "78263": "29.3614_-98.3174", "78264": "29.1733_-98.4723", "78265": "29.4375_-98.4616", "78268": "29.4375_-98.4616", "78269": "29.4375_-98.4616", "78270": "29.4375_-98.4616", "78278": "29.4375_-98.4616", "78279": "29.4375_-98.4616", "78280": "29.4375_-98.4616", "78283": "29.4375_-98.4616", "78284": "29.4426_-98.4913", "78285": "29.4375_-98.4616", "78288": "29.4241_-98.4936", "78289": "29.4375_-98.4616", "78291": "29.4375_-98.4616", "78292": "29.4375_-98.4616", "78293": "29.4375_-98.4616", "78294": "29.4375_-98.4616", "78295": "29.4375_-98.4616", "78296": "29.4375_-98.4616", "78297": "29.4375_-98.4616", "78298": "29.4375_-98.4616", "78299": "29.4375_-98.4616", "78606": "30.0874_-98.4107", "78635": "30.2269_-98.5396", "78636": "30.2948_-98.3691", "78663": "30.4429_-98.4365", "79738": "32.7523_-101.45", "76634": "31.7918_-97.5203", "76637": "31.7486_-97.8113", "76644": "31.8593_-97.3797", "76649": "31.9722_-97.8793", "76652": "32.1035_-97.5421", "76665": "31.929_-97.6443", "76671": "32.0195_-97.5608", "76689": "31.6599_-97.4935", "76690": "32.0593_-97.7514", "75501": "33.4113_-94.1774", "75503": "33.4669_-94.0774", "75504": "33.4251_-94.0477", "75505": "33.4624_-94.0715", "75507": "33.4251_-94.0477", "75559": "33.5087_-94.6163", "75561": "33.5253_-94.2657", "75567": "33.3409_-94.3175", "75569": "33.4344_-94.1219", "75570": "33.4619_-94.4375", "75573": "33.358_-94.2571", "75574": "33.3359_-94.552", "75599": "33.4251_-94.0477", "77422": "29.0236_-95.5867", "77430": "29.3014_-95.7036", "77431": "29.1737_-95.8207", "77463": "29.08_-95.7497", "77480": "29.0415_-95.7004", "77486": "29.1408_-95.6694", "77511": "29.412_-95.2515", "77512": "29.4238_-95.2441", "77515": "29.181_-95.4467", "77516": "29.1694_-95.4319", "77531": "29.0325_-95.4026", "77534": "29.2291_-95.3435", "77541": "29.0357_-95.3379", "77542": "28.9541_-95.3597", "77566": "29.0393_-95.4401", "77577": "29.2667_-95.2889", "77578": "29.4694_-95.3503", "77581": "29.5617_-95.2721", "77583": "29.4203_-95.4537", "77584": "29.5405_-95.3208", "77588": "29.5127_-95.2542", "77801": "30.6327_-96.3662", "77802": "30.6582_-96.3351", "77803": "30.6913_-96.3714", "77805": "30.6521_-96.341", "77806": "30.6744_-96.37", "77807": "30.6711_-96.4799", "77808": "30.8202_-96.3059", "77840": "30.6045_-96.3123", "77841": "30.5726_-96.327", "77842": "30.6521_-96.341", "77843": "30.6521_-96.341", "77844": "30.6521_-96.341", "77845": "30.5118_-96.3171", "77862": "30.7871_-96.2641", "77866": "30.4491_-96.217", "77881": "30.5334_-96.3032", "79830": "30.2631_-103.6541", "79831": "30.3068_-103.6704", "79832": "30.3631_-103.6539", "79834": "29.2924_-103.2963", "79842": "30.1886_-103.2214", "79852": "29.3165_-103.5597", "79255": "34.3796_-101.0465", "79257": "34.4641_-101.3169", "78353": "26.9249_-98.1922", "78355": "27.2242_-98.1408", "76432": "31.7882_-98.8311", "76801": "31.7754_-98.9915", "76802": "31.7874_-98.9229", "76803": "31.7421_-98.9456", "76804": "31.7742_-99.0921", "76823": "31.7503_-99.1568", "76827": "31.5176_-99.1277", "76857": "31.9571_-98.9656", "76890": "31.6694_-98.8182", "77836": "30.5298_-96.7143", "77838": "30.5994_-96.7708", "77852": "30.4322_-96.7561", "77863": "30.3863_-96.5633", "77878": "30.4702_-96.4804", "77879": "30.4076_-96.5358", "78605": "30.7411_-98.0529", "78608": "30.9325_-97.9702", "78611": "30.7766_-98.2642", "78654": "30.5784_-98.2751", "78616": "29.9528_-97.581", "78622": "29.7561_-97.7764", "78644": "29.8868_-97.6769", "78648": "29.6826_-97.6499", "78655": "29.8394_-97.8508", "78656": "29.8953_-97.8144", "78661": "29.7239_-97.7449", "77978": "28.6651_-96.5506", "77979": "28.6011_-96.6259", "77982": "28.4483_-96.4058", "77983": "28.4101_-96.7023", "76443": "32.1482_-99.1872", "76469": "32.374_-99.1957", "79504": "32.3916_-99.3777", "79510": "32.3803_-99.5184", "78520": "25.9337_-97.5174", "78521": "25.9221_-97.4612", "78522": "25.9017_-97.4975", "78523": "25.981_-97.5209", "78526": "25.9717_-97.4699", "78535": "26.2451_-97.7416", "78550": "26.1951_-97.689", "78551": "26.2447_-97.7206", "78552": "26.1831_-97.7468", "78553": "26.1906_-97.6961", "78559": "26.1666_-97.8261", "78566": "26.1158_-97.4107", "78567": "26.0492_-97.745", "78568": "26.1904_-97.5423", "78575": "26.0353_-97.5496", "78578": "26.0539_-97.3125", "78583": "26.2339_-97.5513", "78586": "26.1337_-97.6447", "78592": "26.0787_-97.8494", "78593": "26.2555_-97.8257", "78597": "26.2393_-97.1936", "75451": "32.9763_-95.1079", "75686": "32.9623_-94.9603", "79039": "35.2168_-101.1285", "79068": "35.3808_-101.4304", "79080": "35.5685_-101.1721", "79097": "35.4278_-101.174", "75551": "33.109_-94.1646", "75555": "32.966_-94.1404", "75556": "33.1339_-94.0647", "75560": "33.1758_-94.3467", "75562": "32.9468_-94.2539", "75563": "33.0048_-94.3605", "75565": "32.9511_-94.0808", "75566": "33.1735_-94.5424", "75572": "33.1557_-94.1537", "75630": "32.8485_-94.5795", "75656": "33.0168_-94.6228", "79027": "34.5341_-102.3046", "79043": "34.3878_-102.1155", "79063": "34.5444_-102.1069", "79085": "34.7437_-102.5064", "77514": "29.662_-94.593", "77523": "29.77_-94.8608", "77560": "29.8752_-94.5938", "77580": "29.8477_-94.8908", "77597": "29.8591_-94.6759", "77661": "29.7809_-94.39", "77665": "29.8157_-94.3395", "75759": "32.0415_-95.42", "75764": "31.891_-95.1455", "75766": "31.9618_-95.2703", "75772": "31.8008_-95.3001", "75780": "31.9807_-95.0938", "75784": "31.8859_-95.0118", "75785": "31.8136_-95.0965", "75925": "31.6103_-95.0762", "75976": "31.4885_-94.9399", "79201": "34.4104_-100.2364", "79259": "34.3759_-100.3948", "76228": "33.5879_-98.1574", "76352": "33.674_-98.23", "76357": "34.0728_-98.1839", "76365": "33.8196_-98.26", "76377": "34.0132_-98.2323", "79314": "33.5997_-103.0168", "79346": "33.7251_-102.7594", "79379": "33.5988_-102.6199", "76933": "31.8789_-100.2988", "76945": "31.8951_-100.5104", "76949": "32.0484_-100.6922", "76953": "31.7397_-100.2884", "76828": "31.9986_-99.2553", "76834": "31.8287_-99.427", "76845": "31.5549_-99.4767", "76873": "31.5037_-99.3746", "76878": "31.7215_-99.3212", "76882": "31.8034_-99.6747", "76884": "31.7529_-99.5473", "76888": "31.5892_-99.6326", "79519": "32.0482_-99.6775", "79538": "31.9781_-99.6809", "75002": "33.0934_-96.6454", "75009": "33.3103_-96.7673", "75013": "33.1186_-96.6773", "75023": "33.055_-96.7365", "75024": "33.0752_-96.7843", "75025": "33.0784_-96.7291", "75026": "33.0198_-96.6989", "75033": "33.2559_-96.8853", "75034": "33.1499_-96.8241", "75035": "33.1377_-96.7524", "75036": "33.1499_-96.8241", "75069": "33.1976_-96.6153", "75070": "33.1976_-96.6153", "75071": "33.1976_-96.6153", "75072": "33.1976_-96.6153", "75074": "33.0277_-96.6777", "75075": "33.025_-96.7397", "75078": "33.2362_-96.7954", "75086": "33.0198_-96.6989", "75093": "33.0299_-96.7889", "75094": "33.0148_-96.6189", "75097": "33.3512_-96.6646", "75121": "33.0875_-96.4186", "75164": "33.0612_-96.3072", "75166": "33.0139_-96.4377", "75173": "33.0593_-96.3877", "75407": "33.1555_-96.4981", "75409": "33.3445_-96.5639", "75424": "33.3061_-96.3901", "75442": "33.1659_-96.3686", "75454": "33.2841_-96.574", "75485": "33.3627_-96.4635", "79077": "35.0523_-100.2807", "79095": "34.8717_-100.2207", "79230": "34.7644_-100.0286", "79251": "34.918_-100.4252", "77412": "29.5714_-96.4541", "77434": "29.5842_-96.3354", "77442": "29.476_-96.4919", "77460": "29.405_-96.3864", "77470": "29.5311_-96.5752", "77475": "29.4936_-96.6711", "78934": "29.7032_-96.5527", "78935": "29.7092_-96.4865", "78943": "29.6994_-96.5942", "78951": "29.6016_-96.83", "78962": "29.6787_-96.755", "78070": "29.9238_-98.3788", "78130": "29.7229_-98.0742", "78131": "29.703_-98.1245", "78132": "29.7565_-98.1983", "78133": "29.9112_-98.2374", "78135": "29.703_-98.1245", "78163": "29.7767_-98.4626", "78266": "29.6643_-98.3118", "78623": "29.9627_-98.2088", "76442": "31.9116_-98.6082", "76444": "32.1087_-98.5489", "76452": "31.7629_-98.3695", "76455": "31.8468_-98.4017", "76468": "31.9874_-98.4298", "76474": "31.932_-98.768", "76837": "31.2192_-99.8407", "76855": "31.5663_-100.0759", "76862": "31.4167_-99.7171", "76866": "31.5048_-99.9139", "76937": "31.3617_-100.0922", "76238": "33.4965_-97.3859", "76240": "33.6547_-97.1583", "76241": "33.6104_-97.0369", "76250": "33.636_-97.2214", "76252": "33.6595_-97.3624", "76253": "33.6178_-97.309", "76263": "33.4674_-97.4534", "76272": "33.5022_-97.2311", "76522": "31.2029_-97.9301", "76525": "31.4388_-98.0535", "76526": "31.2956_-97.5822", "76528": "31.4177_-97.833", "76538": "31.5599_-97.8456", "76558": "31.3514_-97.6444", "76561": "31.4438_-97.5501", "76566": "31.4841_-97.9903", "76596": "31.3902_-97.7993", "76597": "31.3902_-97.7993", "76598": "31.3902_-97.7993", "76599": "31.4706_-97.7347", "79223": "34.2295_-100.4573", "79248": "34.0217_-100.2986", "79731": "31.3969_-102.3544", "76943": "30.7164_-101.2388", "79322": "33.6562_-101.2287", "79343": "33.6666_-101.5277", "79357": "33.6851_-101.3836", "79855": "31.0391_-104.8245", "79022": "36.0732_-102.5177", "79051": "36.4956_-102.2427", "79087": "36.374_-102.9845", "75001": "32.96_-96.8385", "75006": "32.9657_-96.8825", "75011": "32.9537_-96.8903", "75014": "32.7673_-96.7776", "75015": "32.8987_-96.9722", "75016": "32.8987_-96.9722", "75017": "32.7673_-96.7776", "75019": "32.9673_-96.9805", "75030": "32.9029_-96.5639", "75038": "32.8653_-96.9905", "75039": "32.8697_-96.9389", "75040": "32.9227_-96.6248", "75041": "32.8794_-96.6411", "75042": "32.9185_-96.6775", "75043": "32.8565_-96.5999", "75044": "32.9522_-96.6654", "75045": "32.9137_-96.6271", "75046": "32.9126_-96.6389", "75047": "32.9126_-96.6389", "75048": "32.9643_-96.6012", "75049": "32.9126_-96.6389", "75050": "32.7649_-97.0112", "75051": "32.7115_-97.0069", "75052": "32.6605_-97.0311", "75053": "32.746_-96.9978", "75054": "32.5907_-97.0405", "75059": "32.8023_-96.9597", "75060": "32.8023_-96.9597", "75061": "32.8267_-96.9633", "75062": "32.8479_-96.974", "75063": "32.9247_-96.9598", "75064": "32.9247_-96.9598", "75080": "32.966_-96.7452", "75081": "32.9462_-96.7058", "75082": "32.9865_-96.686", "75083": "32.7673_-96.7776", "75085": "32.7673_-96.7776", "75088": "32.9031_-96.5472", "75089": "32.9346_-96.5544", "75098": "33.0041_-96.5394", "75099": "32.9546_-97.015", "75104": "32.5885_-96.9438", "75106": "32.5885_-96.9561", "75115": "32.6041_-96.8653", "75116": "32.6587_-96.9114", "75123": "32.5899_-96.8569", "75134": "32.6161_-96.783", "75137": "32.6347_-96.9113", "75138": "32.7673_-96.7776", "75141": "32.6396_-96.707", "75146": "32.5914_-96.7728", "75149": "32.7678_-96.6082", "75150": "32.8154_-96.6307", "75159": "32.6525_-96.558", "75172": "32.5981_-96.6838", "75180": "32.7287_-96.6228", "75181": "32.7272_-96.5669", "75182": "32.797_-96.5616", "75185": "32.7403_-96.5618", "75187": "32.7673_-96.7776", "75201": "32.7904_-96.8044", "75202": "32.7781_-96.8054", "75203": "32.746_-96.807", "75204": "32.8038_-96.7851", "75205": "32.826_-96.7843", "75206": "32.831_-96.7692", "75207": "32.7939_-96.8319", "75208": "32.7492_-96.8389", "75209": "32.8456_-96.826", "75210": "32.7699_-96.743", "75211": "32.7319_-96.9057", "75212": "32.7829_-96.8714", "75214": "32.8248_-96.7498", "75215": "32.7582_-96.7623", "75216": "32.7086_-96.7955", "75217": "32.7244_-96.6755", "75218": "32.8463_-96.6972", "75219": "32.8132_-96.8142", "75220": "32.8681_-96.8622", "75221": "32.8147_-96.7877", "75222": "32.7673_-96.7776", "75223": "32.7942_-96.7475", "75224": "32.7114_-96.8387", "75225": "32.8628_-96.7918", "75226": "32.7887_-96.7676", "75227": "32.7672_-96.6836", "75228": "32.825_-96.6784", "75229": "32.8958_-96.8588", "75230": "32.8999_-96.7897", "75231": "32.8756_-96.7495", "75232": "32.6647_-96.8384", "75233": "32.7046_-96.8725", "75234": "32.9245_-96.8938", "75235": "32.8252_-96.8388", "75236": "32.69_-96.9177", "75237": "32.659_-96.8765", "75238": "32.877_-96.708", "75240": "32.9374_-96.7872", "75241": "32.6722_-96.7774", "75242": "32.7673_-96.7776", "75243": "32.9103_-96.7285", "75244": "32.9322_-96.8353", "75246": "32.7948_-96.7697", "75247": "32.8152_-96.8703", "75248": "32.9682_-96.7942", "75249": "32.636_-96.9493", "75250": "32.7673_-96.7776", "75251": "32.9189_-96.7751", "75252": "32.9968_-96.7921", "75253": "32.6833_-96.5964", "75254": "32.9503_-96.819", "75260": "32.7673_-96.7776", "75261": "32.7673_-96.7776", "75262": "32.7673_-96.7776", "75263": "32.7673_-96.7776", "75264": "32.7673_-96.7776", "75265": "32.7673_-96.7776", "75266": "32.7673_-96.7776", "75267": "32.7673_-96.7776", "75270": "32.7813_-96.8019", "75275": "32.7673_-96.7776", "75277": "32.7673_-96.7776", "75283": "32.7673_-96.7776", "75284": "32.7673_-96.7776", "75285": "32.7673_-96.7776", "75287": "33.0005_-96.8314", "75301": "32.7673_-96.7776", "75303": "32.7673_-96.7776", "75312": "32.7673_-96.7776", "75313": "32.7673_-96.7776", "75315": "32.7673_-96.7776", "75320": "32.7673_-96.7776", "75326": "32.7673_-96.7776", "75336": "32.7673_-96.7776", "75339": "32.7673_-96.7776", "75342": "32.7673_-96.7776", "75354": "32.7673_-96.7776", "75355": "32.7673_-96.7776", "75356": "32.7673_-96.7776", "75357": "32.7673_-96.7776", "75358": "32.7942_-96.7652", "75