# Copyright 2015 OpenStack Foundation
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#

"""Add Service related dbs

Revision ID: 12a57080b277
Revises: 5958429bcb3c
Create Date: 2015-11-26 15:18:19.623170

"""

# revision identifiers, used by Alembic.
revision = '12a57080b277'
down_revision = '5958429bcb3c'

from alembic import op
import sqlalchemy as sa


def upgrade(active_plugins=None, options=None):
    # commands auto generated by Alembic - please adjust! #
    op.create_table(
        'servicetypes',
        sa.Column('tenant_id', sa.String(length=255), nullable=True),
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('template_id', sa.String(length=36), nullable=False),
        sa.Column('service_type', sa.String(length=255), nullable=False),
        sa.ForeignKeyConstraint(['template_id'], ['devicetemplates.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_table(
        'deviceservicecontexts',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('device_id', sa.String(length=36), nullable=True),
        sa.Column('network_id', sa.String(length=36), nullable=True),
        sa.Column('subnet_id', sa.String(length=36), nullable=True),
        sa.Column('port_id', sa.String(length=36), nullable=True),
        sa.Column('router_id', sa.String(length=36), nullable=True),
        sa.Column('role', sa.String(length=255), nullable=True),
        sa.Column('index', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['device_id'], ['devices.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_table(
        'serviceinstances',
        sa.Column('tenant_id', sa.String(length=255), nullable=True),
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=True),
        sa.Column('service_type_id', sa.String(length=36), nullable=True),
        sa.Column('service_table_id', sa.String(length=36), nullable=True),
        sa.Column('managed_by_user', sa.Boolean(), nullable=True),
        sa.Column('mgmt_driver', sa.String(length=255), nullable=True),
        sa.Column('mgmt_url', sa.String(length=255), nullable=True),
        sa.Column('status', sa.String(length=255), nullable=False),
        sa.ForeignKeyConstraint(['service_type_id'], ['servicetypes.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_table(
        'servicecontexts',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('service_instance_id', sa.String(length=36), nullable=True),
        sa.Column('network_id', sa.String(length=36), nullable=True),
        sa.Column('subnet_id', sa.String(length=36), nullable=True),
        sa.Column('port_id', sa.String(length=36), nullable=True),
        sa.Column('router_id', sa.String(length=36), nullable=True),
        sa.Column('role', sa.String(length=255), nullable=True),
        sa.Column('index', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['service_instance_id'],
                                ['serviceinstances.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_table(
        'servicedevicebindings',
        sa.Column('service_instance_id', sa.String(length=36), nullable=False),
        sa.Column('device_id', sa.String(length=36), nullable=False),
        sa.ForeignKeyConstraint(['device_id'], ['devices.id'], ),
        sa.ForeignKeyConstraint(['service_instance_id'],
                                ['serviceinstances.id'], ),
        sa.PrimaryKeyConstraint('service_instance_id', 'device_id'),
        mysql_engine='InnoDB'
    )
    # end Alembic commands #


def downgrade(active_plugins=None, options=None):
    # commands auto generated by Alembic - please adjust! #
    op.drop_table('servicedevicebindings')
    op.drop_table('servicecontexts')
    op.drop_table('serviceinstances')
    op.drop_table('deviceservicecontexts')
    op.drop_table('servicetypes')
    # end Alembic commands #
