# Generated by Django 4.1.2 on 2022-10-27 20:37

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('tom_nonlocalizedevents', '0014_credibleregion_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='EventSequence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sequence_id', models.PositiveIntegerField(default=1, help_text='The version / update number of this event. I.E. the SEQUENCE_NUM for a GW event.')),
                ('event_subtype', models.CharField(default='', help_text='The subtype of the event. Options are type specific, i.e. GW events have initial, preliminary, update types.', max_length=256)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='nonlocalizedevent',
            unique_together=set(),
        ),
        migrations.RemoveField(
            model_name='eventlocalization',
            name='sequence_id',
        ),
        migrations.AddField(
            model_name='eventcandidate',
            name='created',
            field=models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='eventcandidate',
            name='modified',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name='eventlocalization',
            name='date',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text='The datestamp of this localizations creation.'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='eventlocalization',
            name='distance_mean',
            field=models.FloatField(default=0, help_text='The posterior mean distance in Mpc.'),
        ),
        migrations.AddField(
            model_name='eventlocalization',
            name='distance_std',
            field=models.FloatField(default=0, help_text='The posterior standard deviation of the distance in Mpc.'),
        ),
        migrations.AddField(
            model_name='eventlocalization',
            name='skymap_moc_file_url',
            field=models.URLField(default='', help_text='The URL to a file containing skymap MOC file for the event sequence. Used to generate localization.'),
        ),
        migrations.AddField(
            model_name='skymaptile',
            name='distance_mean',
            field=models.FloatField(default=0),
        ),
        migrations.AddField(
            model_name='skymaptile',
            name='distance_std',
            field=models.FloatField(default=0),
        ),
        migrations.AddConstraint(
            model_name='eventlocalization',
            constraint=models.UniqueConstraint(fields=('nonlocalizedevent', 'date'), name='unique_date_per_nonlocalizedevent'),
        ),
        migrations.AddConstraint(
            model_name='nonlocalizedevent',
            constraint=models.UniqueConstraint(fields=('event_id',), name='unique_event_id'),
        ),
        migrations.AddField(
            model_name='eventsequence',
            name='localization',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='sequences', to='tom_nonlocalizedevents.eventlocalization'),
        ),
        migrations.AddField(
            model_name='eventsequence',
            name='nonlocalizedevent',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sequences', to='tom_nonlocalizedevents.nonlocalizedevent'),
        ),
        migrations.RemoveField(
            model_name='nonlocalizedevent',
            name='event_subtype',
        ),
        migrations.RemoveField(
            model_name='nonlocalizedevent',
            name='sequence_id',
        ),
        migrations.RemoveField(
            model_name='nonlocalizedevent',
            name='skymap_file_url',
        ),
        migrations.AddConstraint(
            model_name='eventsequence',
            constraint=models.UniqueConstraint(fields=('nonlocalizedevent', 'sequence_id'), name='unique_sequence_per_nonlocalizedevent'),
        ),
    ]
