# Generated by Django 4.1.1 on 2022-10-13 00:38

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('tom_nonlocalizedevents', '0010_rename_more_superevent_fields'),
    ]

    operations = [
        migrations.AddField(
            model_name='eventcandidate',
            name='viability_reason',
            field=models.TextField(default='', help_text='Reason why this candidates viability is set the way it is.'),
        ),
        migrations.AlterField(
            model_name='eventcandidate',
            name='viable',
            field=models.BooleanField(default=True, help_text='Whether this event candidate is actively being considered or not'),
        ),
        migrations.AlterField(
            model_name='nonlocalizedevent',
            name='event_id',
            field=models.CharField(help_text='Unique identifer for the event. I.E. the TRIGGER_NUM for a GW event.', max_length=64),
        ),
        migrations.AlterField(
            model_name='nonlocalizedevent',
            name='event_type',
            field=models.CharField(choices=[('GW', 'Gravitational Wave'), ('GRB', 'Gamma-ray Burst'), ('NU', 'Neutrino'), ('UNK', 'Unknown')], default='GW', help_text='The type of NonLocalizedEvent, used for determining how to ingest and display it', max_length=3),
        ),
        migrations.AlterField(
            model_name='nonlocalizedevent',
            name='sequence_id',
            field=models.PositiveIntegerField(default=1, help_text='The version / update number of this event. I.E. the SEQUENCE_NUM for a GW event.'),
        ),
        migrations.AlterField(
            model_name='nonlocalizedevent',
            name='skymap_file_url',
            field=models.URLField(default='', help_text='The URL to a file containing skymap details for the event.'),
        ),
        migrations.AlterUniqueTogether(
            name='nonlocalizedevent',
            unique_together={('event_id', 'sequence_id')},
        ),
    ]
