"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("../lib");
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
const sqs = require("@aws-cdk/aws-sqs");
const kms = require("@aws-cdk/aws-kms");
const core_2 = require("@aws-solutions-constructs/core");
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
const existingQueueObj = new sqs.Queue(stack, 'MyQueue', {
    encryption: sqs.QueueEncryption.KMS,
    encryptionMasterKey: new kms.Key(stack, 'MyKey', {
        enableKeyRotation: true
    }),
});
const existingEventBus = new events.EventBus(stack, 'existing-event-bus', { eventBusName: 'test' });
const props = {
    eventRuleProps: {
        eventPattern: {
            source: ['solutionsconstructs']
        }
    },
    existingQueueObj,
    existingEventBusInterface: existingEventBus
};
new lib_1.EventsRuleToSqs(stack, 'construct', props);
app.synth();
//# sourceMappingURL=data:application/json;base64,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