"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const iam = require("@aws-cdk/aws-iam");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-apigateway-sagemakerendpoint';
const existingRole = new iam.Role(stack, 'api-gateway-role', {
    assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com'),
    description: 'existing role for SageMaker integration',
    inlinePolicies: {
        InvokePolicy: new iam.PolicyDocument({
            statements: [new iam.PolicyStatement({
                    resources: [`arn:${core_1.Aws.PARTITION}:sagemaker:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:endpoint/my-endpoint`],
                    actions: ['sagemaker:InvokeEndpoint']
                })]
        })
    }
});
// Definitions
const requestTemplate = `{
    "instances": [
#set( $user_id = $input.params("user_id") )
#set( $items = $input.params("items") )
#foreach( $item in $items.split(",") )
    {"in0": [$user_id], "in1": [$item]}#if( $foreach.hasNext ),#end
    $esc.newline
#end
    ]
}`;
const responseTemplate = `{
    "ratings": [
#set( $predictions = $input.path("$.predictions") )
#foreach( $item in $predictions )
    $item.scores[0]#if( $foreach.hasNext ),#end
    $esc.newline
#end
    ]
}`;
const props = {
    endpointName: 'my-endpoint',
    resourcePath: '{user_id}',
    resourceName: 'predicted-ratings',
    requestMappingTemplate: requestTemplate,
    responseMappingTemplate: responseTemplate,
    apiGatewayExecutionRole: existingRole
};
new lib_1.ApiGatewayToSageMakerEndpoint(stack, 'test-apigateway-sagemakerendpoint-overwrite', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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