# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Mapping, Optional, TYPE_CHECKING, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AcknowledgeOptions(_model_base.Model):
    """Array of lock token strings for the corresponding received Cloud Events to be acknowledged.

    All required parameters must be populated in order to send to Azure.

    :ivar lock_tokens: String array of lock tokens. Required.
    :vartype lock_tokens: list[str]
    """

    lock_tokens: List[str] = rest_field(name="lockTokens")
    """String array of lock tokens. Required."""

    @overload
    def __init__(
        self,
        *,
        lock_tokens: List[str],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:# pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AcknowledgeResult(_model_base.Model):
    """The result of the Acknowledge operation.

    All required parameters must be populated in order to send to Azure.

    :ivar failed_lock_tokens: Array of LockToken values for failed cloud events. Each LockToken
     includes the lock token value along with the related error information (namely, the error code
     and description). Required.
    :vartype failed_lock_tokens: list[~azure.eventgrid.models.FailedLockToken]
    :ivar succeeded_lock_tokens: Array of lock tokens values for the successfully acknowledged
     cloud events. Required.
    :vartype succeeded_lock_tokens: list[str]
    """

    failed_lock_tokens: List["_models.FailedLockToken"] = rest_field(name="failedLockTokens")
    """Array of LockToken values for failed cloud events. Each LockToken includes the lock token value
     along with the related error information (namely, the error code and description). Required."""
    succeeded_lock_tokens: List[str] = rest_field(name="succeededLockTokens")
    """Array of lock tokens values for the successfully acknowledged cloud events. Required."""

    @overload
    def __init__(
        self,
        *,
        failed_lock_tokens: List["_models.FailedLockToken"],
        succeeded_lock_tokens: List[str],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:# pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class BrokerProperties(_model_base.Model):
    """Properties of the Event Broker operation.

    All required parameters must be populated in order to send to Azure.

    :ivar lock_token: The token used to lock the event. Required.
    :vartype lock_token: str
    :ivar delivery_count: The attempt count for delivering the event. Required.
    :vartype delivery_count: int
    """

    lock_token: str = rest_field(name="lockToken")
    """The token used to lock the event. Required."""
    delivery_count: int = rest_field(name="deliveryCount")
    """The attempt count for delivering the event. Required."""



class CloudEvent(_model_base.Model):
    """Properties of an event published to an Azure Messaging EventGrid Namespace topic using the
    CloudEvent 1.0 Schema.

    All required parameters must be populated in order to send to Azure.

    :ivar id: An identifier for the event. The combination of id and source must be unique for each
     distinct event. Required.
    :vartype id: str
    :ivar source: Identifies the context in which an event happened. The combination of id and
     source must be unique for each distinct event. Required.
    :vartype source: str
    :ivar data: Event data specific to the event type.
    :vartype data: any
    :ivar data_base64: Event data specific to the event type, encoded as a base64 string.
    :vartype data_base64: bytes
    :ivar type: Type of event related to the originating occurrence. Required.
    :vartype type: str
    :ivar time: The time (in UTC) the event was generated, in RFC3339 format.
    :vartype time: ~datetime.datetime
    :ivar specversion: The version of the CloudEvents specification which the event uses. Required.
    :vartype specversion: str
    :ivar dataschema: Identifies the schema that data adheres to.
    :vartype dataschema: str
    :ivar datacontenttype: Content type of data value.
    :vartype datacontenttype: str
    :ivar subject: This describes the subject of the event in the context of the event producer
     (identified by source).
    :vartype subject: str
    """

    id: str = rest_field()
    """An identifier for the event. The combination of id and source must be unique for each distinct
     event. Required."""
    source: str = rest_field()
    """Identifies the context in which an event happened. The combination of id and source must be
     unique for each distinct event. Required."""
    data: Optional[Any] = rest_field()
    """Event data specific to the event type."""
    data_base64: Optional[bytes] = rest_field()
    """Event data specific to the event type, encoded as a base64 string."""
    type: str = rest_field()
    """Type of event related to the originating occurrence. Required."""
    time: Optional[datetime.datetime] = rest_field()
    """The time (in UTC) the event was generated, in RFC3339 format."""
    specversion: str = rest_field()
    """The version of the CloudEvents specification which the event uses. Required."""
    dataschema: Optional[str] = rest_field()
    """Identifies the schema that data adheres to."""
    datacontenttype: Optional[str] = rest_field()
    """Content type of data value."""
    subject: Optional[str] = rest_field()
    """This describes the subject of the event in the context of the event producer (identified by
     source)."""



class FailedLockToken(_model_base.Model):
    """Failed LockToken information.

    All required parameters must be populated in order to send to Azure.

    :ivar lock_token: LockToken value. Required.
    :vartype lock_token: str
    :ivar error_code: Error code related to the token. Example of such error codes are BadToken:
     which indicates the Token is not formatted correctly, TokenLost: which indicates that token is
     not found, and InternalServerError: For any internal server errors. Required.
    :vartype error_code: str
    :ivar error_description: Description of the token error. Required.
    :vartype error_description: str
    """

    lock_token: str = rest_field(name="lockToken")
    """LockToken value. Required."""
    error_code: str = rest_field(name="errorCode")
    """Error code related to the token. Example of such error codes are BadToken: which indicates the
     Token is not formatted correctly, TokenLost: which indicates that token is not found, and
     InternalServerError: For any internal server errors. Required."""
    error_description: str = rest_field(name="errorDescription")
    """Description of the token error. Required."""

    @overload
    def __init__(
        self,
        *,
        lock_token: str,
        error_code: str,
        error_description: str,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:# pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ReceiveDetails(_model_base.Model):
    """Receive operation details per Cloud Event.

    All required parameters must be populated in order to send to Azure.

    :ivar broker_properties: The Event Broker details. Required.
    :vartype broker_properties: ~azure.eventgrid.models.BrokerProperties
    :ivar event: Cloud Event details. Required.
    :vartype event: ~azure.eventgrid.models.CloudEvent
    """

    broker_properties: "_models._models.BrokerProperties" = rest_field(name="brokerProperties")
    """The Event Broker details. Required."""
    event: "_models._models.CloudEvent" = rest_field()
    """Cloud Event details. Required."""



class ReceiveResult(_model_base.Model):
    """Details of the Receive operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Array of receive responses, one per cloud event. Required.
    :vartype value: list[~azure.eventgrid.models.ReceiveDetails]
    """

    value: List["_models._models.ReceiveDetails"] = rest_field()
    """Array of receive responses, one per cloud event. Required."""



class RejectOptions(_model_base.Model):
    """Array of lock token strings for the corresponding received Cloud Events to be rejected.

    All required parameters must be populated in order to send to Azure.

    :ivar lock_tokens: String array of lock tokens. Required.
    :vartype lock_tokens: list[str]
    """

    lock_tokens: List[str] = rest_field(name="lockTokens")
    """String array of lock tokens. Required."""

    @overload
    def __init__(
        self,
        *,
        lock_tokens: List[str],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:# pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RejectResult(_model_base.Model):
    """The result of the Reject operation.

    All required parameters must be populated in order to send to Azure.

    :ivar failed_lock_tokens: Array of LockToken values for failed cloud events. Each LockToken
     includes the lock token value along with the related error information (namely, the error code
     and description). Required.
    :vartype failed_lock_tokens: list[~azure.eventgrid.models.FailedLockToken]
    :ivar succeeded_lock_tokens: Array of lock tokens values for the successfully rejected cloud
     events. Required.
    :vartype succeeded_lock_tokens: list[str]
    """

    failed_lock_tokens: List["_models.FailedLockToken"] = rest_field(name="failedLockTokens")
    """Array of LockToken values for failed cloud events. Each LockToken includes the lock token value
     along with the related error information (namely, the error code and description). Required."""
    succeeded_lock_tokens: List[str] = rest_field(name="succeededLockTokens")
    """Array of lock tokens values for the successfully rejected cloud events. Required."""

    @overload
    def __init__(
        self,
        *,
        failed_lock_tokens: List["_models.FailedLockToken"],
        succeeded_lock_tokens: List[str],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:# pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ReleaseOptions(_model_base.Model):
    """Array of lock token strings for the corresponding received Cloud Events to be released.

    All required parameters must be populated in order to send to Azure.

    :ivar lock_tokens: String array of lock tokens. Required.
    :vartype lock_tokens: list[str]
    """

    lock_tokens: List[str] = rest_field(name="lockTokens")
    """String array of lock tokens. Required."""

    @overload
    def __init__(
        self,
        *,
        lock_tokens: List[str],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:# pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ReleaseResult(_model_base.Model):
    """The result of the Release operation.

    All required parameters must be populated in order to send to Azure.

    :ivar failed_lock_tokens: Array of LockToken values for failed cloud events. Each LockToken
     includes the lock token value along with the related error information (namely, the error code
     and description). Required.
    :vartype failed_lock_tokens: list[~azure.eventgrid.models.FailedLockToken]
    :ivar succeeded_lock_tokens: Array of lock tokens values for the successfully released cloud
     events. Required.
    :vartype succeeded_lock_tokens: list[str]
    """

    failed_lock_tokens: List["_models.FailedLockToken"] = rest_field(name="failedLockTokens")
    """Array of LockToken values for failed cloud events. Each LockToken includes the lock token value
     along with the related error information (namely, the error code and description). Required."""
    succeeded_lock_tokens: List[str] = rest_field(name="succeededLockTokens")
    """Array of lock tokens values for the successfully released cloud events. Required."""

    @overload
    def __init__(
        self,
        *,
        failed_lock_tokens: List["_models.FailedLockToken"],
        succeeded_lock_tokens: List[str],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:# pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
