# Generated by Django 5.1.7 on 2025-04-13 14:56

import django.db.models.deletion
import taggit.managers
import utilities.json
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0012_job_object_type_optional'),
        ('extras', '0122_charfield_null_choices'),
        ('netbox_inventory', '0011_alter_supplier_options'),
    ]

    operations = [
        migrations.CreateModel(
            name='AuditFlowPage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('comments', models.TextField(blank=True)),
                ('object_filter', models.JSONField(blank=True, null=True)),
                ('object_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='core.objecttype')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AuditFlow',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('comments', models.TextField(blank=True)),
                ('object_filter', models.JSONField(blank=True, null=True)),
                ('enabled', models.BooleanField(default=True)),
                ('object_type', models.ForeignKey(limit_choices_to=models.Q(('app_label', 'dcim'), ('model__in', ('site', 'location', 'rack'))), on_delete=django.db.models.deletion.PROTECT, related_name='+', to='core.objecttype')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AuditFlowPageAssignment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('weight', models.PositiveSmallIntegerField(default=100)),
                ('flow', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='netbox_inventory.auditflow')),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='netbox_inventory.auditflowpage')),
            ],
            options={
                'ordering': ('weight',),
            },
        ),
        migrations.AddField(
            model_name='auditflow',
            name='pages',
            field=models.ManyToManyField(related_name='assigned_flows', through='netbox_inventory.AuditFlowPageAssignment', to='netbox_inventory.auditflowpage'),
        ),
        migrations.AddConstraint(
            model_name='auditflowpageassignment',
            constraint=models.UniqueConstraint(fields=('flow', 'page'), name='netbox_inventory_auditflowpageassignment_unique_flow_page'),
        ),
        migrations.AlterField(
            model_name='auditflowpageassignment',
            name='flow',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='assigned_pages', to='netbox_inventory.auditflow'),
        ),
    ]
