# Generated by Django 4.1.9 on 2023-07-25 14:34

import django.db.models.deletion
import taggit.managers
from django.db import migrations, models

import utilities.json


class Migration(migrations.Migration):
    dependencies = [
        ('tenancy', '0010_tenant_relax_uniqueness'),
        ('extras', '0092_delete_jobresult'),
        ('netbox_inventory', '0004_inventoryitemgroup_tree'),
    ]

    operations = [
        migrations.CreateModel(
            name='Delivery',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ('name', models.CharField(max_length=100)),
                ('date', models.DateField(blank=True, null=True)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('comments', models.TextField(blank=True)),
                (
                    'purchase',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='orders',
                        to='netbox_inventory.purchase',
                    ),
                ),
                (
                    'receiving_contact',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='deliveries',
                        to='tenancy.contact',
                    ),
                ),
                (
                    'tags',
                    taggit.managers.TaggableManager(
                        through='extras.TaggedItem', to='extras.Tag'
                    ),
                ),
            ],
            options={
                'verbose_name': 'delivery',
                'verbose_name_plural': 'deliveries',
                'ordering': ['purchase', 'name'],
                'unique_together': {('purchase', 'name')},
            },
        ),
        migrations.AddField(
            model_name='asset',
            name='delivery',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name='assets',
                to='netbox_inventory.delivery',
            ),
        ),
    ]
