# Generated by Django 4.0.8 on 2022-12-11 12:44

import django.db.models.deletion
import taggit.managers
from django.db import migrations, models

from utilities.json import CustomFieldJSONEncoder


class Migration(migrations.Migration):
    dependencies = [
        ('extras', '0077_customlink_extend_text_and_url'),
        ('netbox_inventory', '0002_alter_asset_serial'),
    ]

    operations = [
        migrations.CreateModel(
            name='InventoryItemGroup',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(
                        blank=True, default=dict, encoder=CustomFieldJSONEncoder
                    ),
                ),
                ('name', models.CharField(max_length=100, unique=True)),
                ('comments', models.TextField(blank=True)),
                (
                    'tags',
                    taggit.managers.TaggableManager(
                        through='extras.TaggedItem', to='extras.Tag'
                    ),
                ),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='inventoryitemtype',
            name='inventoryitem_group',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='inventoryitem_types',
                to='netbox_inventory.inventoryitemgroup',
            ),
        ),
    ]
