"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.  # noqa: E501

    The version of the OpenAPI document: 2023-02-22
    Contact: developers@klaviyo.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from openapi_client.exceptions import ApiAttributeError



class CatalogVariantCreateQueryAsSubResourceAttributes(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('integration_type',): {
            '$CUSTOM': "$custom",
        },
        ('inventory_policy',): {
            '0': 0,
            '1': 1,
            '2': 2,
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'external_id': (str,),  # noqa: E501
            'title': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'sku': (str,),  # noqa: E501
            'inventory_quantity': (float,),  # noqa: E501
            'price': (float,),  # noqa: E501
            'url': (str,),  # noqa: E501
            'catalog_type': (str,),  # noqa: E501
            'integration_type': (str,),  # noqa: E501
            'inventory_policy': (int,),  # noqa: E501
            'image_full_url': (str,),  # noqa: E501
            'image_thumbnail_url': (str,),  # noqa: E501
            'images': ([str],),  # noqa: E501
            'custom_metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'published': (bool,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'external_id': 'external_id',  # noqa: E501
        'title': 'title',  # noqa: E501
        'description': 'description',  # noqa: E501
        'sku': 'sku',  # noqa: E501
        'inventory_quantity': 'inventory_quantity',  # noqa: E501
        'price': 'price',  # noqa: E501
        'url': 'url',  # noqa: E501
        'catalog_type': 'catalog_type',  # noqa: E501
        'integration_type': 'integration_type',  # noqa: E501
        'inventory_policy': 'inventory_policy',  # noqa: E501
        'image_full_url': 'image_full_url',  # noqa: E501
        'image_thumbnail_url': 'image_thumbnail_url',  # noqa: E501
        'images': 'images',  # noqa: E501
        'custom_metadata': 'custom_metadata',  # noqa: E501
        'published': 'published',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, external_id, title, description, sku, inventory_quantity, price, url, *args, **kwargs):  # noqa: E501
        """CatalogVariantCreateQueryAsSubResourceAttributes - a model defined in OpenAPI

        Args:
            external_id (str): The ID of the catalog item variant in an external system.
            title (str): The title of the catalog item variant.
            description (str): A description of the catalog item variant.
            sku (str): The SKU of the catalog item variant.
            inventory_quantity (float): The quantity of the catalog item variant currently in stock.
            price (float): This field can be used to set the price on the catalog item variant, which is what gets displayed for the item variant when included in emails. For most price-update use cases, you will also want to update the `price` on any parent items using the [Update Catalog Item Endpoint](https://developers.klaviyo.com/en/reference/update_catalog_item).
            url (str): URL pointing to the location of the catalog item variant on your website.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            catalog_type (str): The type of catalog. Currently only \"$default\" is supported.. [optional] if omitted the server will use the default value of "$default"  # noqa: E501
            integration_type (str): The integration type. Currently only \"$custom\" is supported.. [optional] if omitted the server will use the default value of "$custom"  # noqa: E501
            inventory_policy (int): This field controls the visibility of this catalog item variant in product feeds/blocks. This field supports the following values: `1`: a product will not appear in dynamic product recommendation feeds and blocks if it is out of stock. `0` or `2`: a product can appear in dynamic product recommendation feeds and blocks regardless of inventory quantity. . [optional]  # noqa: E501
            image_full_url (str): URL pointing to the location of a full image of the catalog item variant.. [optional]  # noqa: E501
            image_thumbnail_url (str): URL pointing to the location of an image thumbnail of the catalog item variant.. [optional]  # noqa: E501
            images ([str]): List of URLs pointing to the locations of images of the catalog item variant.. [optional]  # noqa: E501
            custom_metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Flat JSON blob to provide custom metadata about the catalog item variant. May not exceed 100kb.. [optional]  # noqa: E501
            published (bool): Boolean value indicating whether the catalog item variant is published.. [optional] if omitted the server will use the default value of True  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.external_id = external_id
        self.title = title
        self.description = description
        self.sku = sku
        self.inventory_quantity = inventory_quantity
        self.price = price
        self.url = url
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, external_id, title, description, sku, inventory_quantity, price, url, *args, **kwargs):  # noqa: E501
        """CatalogVariantCreateQueryAsSubResourceAttributes - a model defined in OpenAPI

        Args:
            external_id (str): The ID of the catalog item variant in an external system.
            title (str): The title of the catalog item variant.
            description (str): A description of the catalog item variant.
            sku (str): The SKU of the catalog item variant.
            inventory_quantity (float): The quantity of the catalog item variant currently in stock.
            price (float): This field can be used to set the price on the catalog item variant, which is what gets displayed for the item variant when included in emails. For most price-update use cases, you will also want to update the `price` on any parent items using the [Update Catalog Item Endpoint](https://developers.klaviyo.com/en/reference/update_catalog_item).
            url (str): URL pointing to the location of the catalog item variant on your website.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            catalog_type (str): The type of catalog. Currently only \"$default\" is supported.. [optional] if omitted the server will use the default value of "$default"  # noqa: E501
            integration_type (str): The integration type. Currently only \"$custom\" is supported.. [optional] if omitted the server will use the default value of "$custom"  # noqa: E501
            inventory_policy (int): This field controls the visibility of this catalog item variant in product feeds/blocks. This field supports the following values: `1`: a product will not appear in dynamic product recommendation feeds and blocks if it is out of stock. `0` or `2`: a product can appear in dynamic product recommendation feeds and blocks regardless of inventory quantity. . [optional]  # noqa: E501
            image_full_url (str): URL pointing to the location of a full image of the catalog item variant.. [optional]  # noqa: E501
            image_thumbnail_url (str): URL pointing to the location of an image thumbnail of the catalog item variant.. [optional]  # noqa: E501
            images ([str]): List of URLs pointing to the locations of images of the catalog item variant.. [optional]  # noqa: E501
            custom_metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Flat JSON blob to provide custom metadata about the catalog item variant. May not exceed 100kb.. [optional]  # noqa: E501
            published (bool): Boolean value indicating whether the catalog item variant is published.. [optional] if omitted the server will use the default value of True  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.external_id = external_id
        self.title = title
        self.description = description
        self.sku = sku
        self.inventory_quantity = inventory_quantity
        self.price = price
        self.url = url
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
