"""
system specific functions. See: https://docs.micropython.org/en/v1.20.0/library/sys.html

|see_cpython_module| :mod:`python:sys` https://docs.python.org/3/library/sys.html .
"""
from typing import Dict, List, Tuple, Any

platform: str
version_info: tuple
path: list
version: str
ps1: str
ps2: str
byteorder: str
modules: dict
argv: list
implementation: tuple
maxsize: int

def print_exception(exc, file=stdout, /) -> None:
    """
    Print exception with a traceback to a file-like object *file* (or
    `sys.stdout` by default).
    """
    ...

def exit(retval=0, /) -> Any:
    """
    Terminate current program with a given exit code. Underlyingly, this
    function raise as `SystemExit` exception. If an argument is given, its
    value given as an argument to `SystemExit`.
    """
    ...

stderr: Any
stdout: Any
stdin: Any
