"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventbridgeToStepfunctions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const defaults = require("@aws-solutions-constructs/core");
const iam = require("@aws-cdk/aws-iam");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const core_2 = require("@aws-solutions-constructs/core");
class EventbridgeToStepfunctions extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the EventbridgeToStepfunctions class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventbridgeToStepfunctionsProps} props - user provided props for the construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        [this.stateMachine, this.stateMachineLogGroup] = defaults.buildStateMachine(this, props.stateMachineProps, props.logGroupProps);
        // Create an IAM role for Events to start the State Machine
        const eventsRole = new iam.Role(this, 'EventsRuleRole', {
            assumedBy: new iam.ServicePrincipal('events.amazonaws.com')
        });
        // Grant the start execution permission to the Events service
        this.stateMachine.grantStartExecution(eventsRole);
        // Setup the Events target
        const stateMachine = {
            bind: () => ({
                id: '',
                arn: this.stateMachine.stateMachineArn,
                role: eventsRole
            })
        };
        // build an event bus if existingEventBus is provided or eventBusProps are provided
        this.eventBus = defaults.buildEventBus(this, {
            existingEventBusInterface: props.existingEventBusInterface,
            eventBusProps: props.eventBusProps
        });
        // Defaults props for the Events
        const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([stateMachine], this.eventBus);
        // Override the defaults with the user provided props
        const eventsRuleProps = core_2.overrideProps(defaultEventsRuleProps, props.eventRuleProps, true);
        // Create the Events Rule for the State Machine
        this.eventsRule = new events.Rule(this, 'EventsRule', eventsRuleProps);
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            // Deploy best practices CW Alarms for State Machine
            this.cloudwatchAlarms = defaults.buildStepFunctionCWAlarms(this, this.stateMachine);
        }
    }
}
exports.EventbridgeToStepfunctions = EventbridgeToStepfunctions;
_a = JSII_RTTI_SYMBOL_1;
EventbridgeToStepfunctions[_a] = { fqn: "@aws-solutions-constructs/aws-eventbridge-stepfunctions.EventbridgeToStepfunctions", version: "1.170.1" };
//# sourceMappingURL=data:application/json;base64,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